/*
 * Copyright 2020-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package l2oam

import (
	"github.com/google/gopacket"
)

// GenerateSetQosPolicerRate generates QosPolicerRate message
func GenerateSetQosPolicerRate(pkgType string, idx int) gopacket.SerializableLayer {
	if pkgType == OnuPkgTypeB {
		return &TibitFrame{
			Data: []byte{
				0x03, 0x00, 0x50, 0xfe, 0x90, 0x82, 0x60, 0x03,
				0xca, 0xfe, 0x00, 0xb7, 0x00, 0x0F, 0x20, 0x00,
				0x01, 0x86, 0xa0, 0x00, 0x01, 0x86, 0xa0, 0x00,
				0x01, 0x86, 0xa0, 0x00, 0x01, 0x86, 0xa0, 0x00,
				0x01, 0x86, 0xa0, 0x00, 0x01, 0x86, 0xa0, 0x00,
				0x01, 0x86, 0xa0, 0x00, 0x01, 0x86, 0xa0,
			},
		}
	}
	switch idx {
	case 1:
		return &TibitFrame{
			Data: []byte{
				0x03, 0x00, 0x50, 0xfe, 0x00, 0x10, 0x00, 0x03,
				0xd6, 0x00, 0x03, 0x01, 0x00, 0xd7, 0x06, 0x02,
				0x0a, 0xff, 0x00, 0x01, 0x00, 0x00, 0x04,
			},
		}
	case 2:
		return &TibitFrame{
			Data: []byte{
				0x03, 0x00, 0x50, 0xFE, 0x00, 0x10, 0x00, 0x03,
				0xD6, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0xD7,
				0x00, 0x24,
			},
		}
	case 3:
		return &TibitFrame{
			Data: []byte{
				0x03, 0x00, 0x50, 0xFE, 0x00, 0x10, 0x00, 0x03,
				0xD6, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0xD7,
				0x00, 0x25,
			},
		}
	case 4:
		return &TibitFrame{
			Data: []byte{
				0x03, 0x00, 0x50, 0xFE, 0x00, 0x10, 0x00, 0x03,
				0xD6, 0x00, 0x03, 0x00, 0xD7, 0x06, 0x02, 0x0A,
				0xFF, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00,
			},
		}
	case 5:
		return &TibitFrame{
			Data: []byte{
				0x03, 0x00, 0x50, 0xFE, 0x00, 0x10, 0x00, 0x03,
				0xD6, 0x00, 0x03, 0x00, 0xD7, 0x06, 0x03, 0x07,
				0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			},
		}
	default:
		return &TibitFrame{
			Data: []byte{},
		}
	}
}
