/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#include "bcmolt_string.h"
#include "bcmolt_math.h"

struct bcmolt_string
{
    char *str;
    uint32_t max_len;
    char *curr;
    int32_t remaining;
};

int bcmolt_string_copy(bcmolt_string *str, const char *buf, uint32_t size)
{
    int to_copy = MIN(size, str->remaining);
    memcpy(str->curr, buf, to_copy);
    str->remaining -= to_copy;
    str->curr += to_copy;
    str->curr[0] = '\0';
    return to_copy;
}

int bcmolt_string_append(bcmolt_string *str, const char *fmt, ...)
{
    int n;
    va_list args;

    va_start(args, fmt);
    n = vsnprintf(str->curr, str->remaining, fmt, args);
    va_end(args);
    if (n > 0)
    {
        if (n > str->remaining)
        {
            n = str->remaining;
        }
        str->remaining -= n;
        str->curr += n;
    }

    return n;
}

const char *bcmolt_string_get(bcmolt_string *str)
{
    return str->str;
}

void bcmolt_string_reset(bcmolt_string *str)
{
    str->str[0] = '\0';
    str->curr = str->str;
    str->remaining = str->max_len;
}

bcmos_errno bcmolt_string_create(bcmolt_string **str, uint32_t max_len)
{
    *str = bcmos_calloc(sizeof(bcmolt_string) + max_len + 1);
    if (*str != NULL)
    {
        (*str)->str = (char*)((*str) + 1);
        (*str)->max_len = max_len;
        bcmolt_string_reset(*str);
        return BCM_ERR_OK;
    }

    return BCM_ERR_NOMEM;
}

void bcmolt_string_destroy(bcmolt_string *str)
{
    bcmos_free(str);
}

