/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#ifndef _BCMOLT_MATH_H_
#define _BCMOLT_MATH_H_

#include <math.h>

#define ROUND_U32(size_in_bytes) ((uint32_t)((size_in_bytes) + 0.5))
#define CEIL_U32(size_in_bytes) (((size_in_bytes)-(uint32_t)(size_in_bytes)) > 0 ? ((uint32_t)(size_in_bytes)+1) : (uint32_t)(size_in_bytes))
#define SQUARE(x) ((x) * (x))
#define PERCENT(percent, x) (((float)(percent) * (x)) / 100)

/*
 * Unit Conversion
 */
#define BITS_TO_BYTES(bits) ((bits) >> 3)
#define BYTES_TO_BITS(bytes) ((bytes) << 3)

/* Quantization */

/*
 * VAL_TO_BIN classifies the value of val to the proper bin
 * val - a value in the range [0, maxval]
 * bin - a value in the range [0, bins-1] (result of macro)
 */
#define VAL_TO_BIN(val, maxval, bins) ((val) < (maxval) ? ((val) * (bins)) / (maxval) : (bins) - 1)

/* If a value is in a certain bin, it is in the range [min_bin_val, max_bin_val]
 * min_bin_val - minimum value that belongs to bin
 * max_bin_val - maximum value that belongs to bin
 */
#define BIN_TO_MIN_BIN_VAL(bin, maxval, bins) ((bin) * ((double)(maxval) / (bins)))
#define BIN_TO_MAX_BIN_VAL(bin, maxval, bins) (((bin) + 1) * ((double)(maxval) / (bins)))

#define GET_MASK(width)             ((1 << (width)) - 1)

#define MAX(a, b) ((a) > (b) ? (a) : (b))
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#define MAX3(a, b, c) MAX(MAX(a, b), c)
#define MIN3(a, b, c) MIN(MIN(a, b), c)

#define CEILING(a, b)   (((a) + ((b) - 1)) / (b))

#endif /* _BCMOLT_MATH_H_ */
