/*
<:copyright-BRCM:2016:proprietary:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

This program is the proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modified or distributed pursuant
to the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License").  Except as set forth in
an Authorized License, Broadcom grants no license (express or implied), right
to use, or waiver of any kind with respect to the Software, and Broadcom
expressly reserves all rights in and to the Software and all intellectual
property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization,
    constitutes the valuable trade secrets of Broadcom, and you shall use
    all reasonable efforts to protect the confidentiality thereof, and to
    use this information only in connection with your use of Broadcom
    integrated circuit products.

2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
    PERFORMANCE OF THE SOFTWARE.

3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
    LIMITED REMEDY.
:>
*/
#ifndef _BCMOLT_FIRMWARE_ENVELOPE_H_
#define _BCMOLT_FIRMWARE_ENVELOPE_H_

#include <bcmos_system.h>

#define BCMOLT_FIRMWARE_ENVELOPE_DESC_MAX_SIZE 128
#define BCMOLT_FIRMWARE_ENVELOPE_TIME_ZONE_SIZE 7
#define BCMOLT_FIRMWARE_ENVELOPE_MD5_CHECKSUM_SIZE 16

/* Normalized form of a firmware revision for comparison purposes. */
#define DEVICE_MGMT_REVISION_RELEASE_MAJOR_ID_SHIFT 24
#define DEVICE_MGMT_REVISION_RELEASE_MINOR_ID_SHIFT 16
#define DEVICE_MGMT_REVISION_RELEASE_REVISION_ID_SHIFT 8
#define DEVICE_MGMT_REVISION_MODEL_ID_SHIFT 0

#define BCMOLT_FIRMWARE_ENVELOPE_NORMALIZE(rev_a) \
    (((rev_a)->release_major_id << DEVICE_MGMT_REVISION_RELEASE_MAJOR_ID_SHIFT) | \
    ((rev_a)->release_minor_id << DEVICE_MGMT_REVISION_RELEASE_MINOR_ID_SHIFT) | \
    ((rev_a)->release_revision_id << DEVICE_MGMT_REVISION_RELEASE_REVISION_ID_SHIFT) | \
    ((rev_a)->model_id << DEVICE_MGMT_REVISION_MODEL_ID_SHIFT))

typedef struct __PACKED_ATTR_START__
{
    uint8_t release_major_id;
    uint8_t release_minor_id;
    uint8_t release_revision_id;
    uint32_t model_id;
} __PACKED_ATTR_END__ bcmolt_firmware_envelope_revision;

typedef struct __PACKED_ATTR_START__
{
    uint8_t envelope_revision; /* The envelope itself can be changed over time, so this explains why we need an envelope revision field. */
    bcmolt_firmware_envelope_revision revision; /* Revision information */
    uint32_t block_issu_enforce; /* Every time a change in the code cannot be supported in ISSU and requires a regular upgrade (e.g.: SGB/SERDES firmware upgrade), this integer number will 
                                  * be incremented. If revision validation function detects a change in this integer between two revisions, then it will block ISSU. */
    uint32_t p4_change_set; /* This is purely informative field that should have no impact on validation. */
    uint32_t build_time; /* This is purely informative field that should have no impact on validation. It contains the date/time of the image itself, expressed as seconds since the EPOCH. */
    char build_time_zone[BCMOLT_FIRMWARE_ENVELOPE_TIME_ZONE_SIZE]; /* This is purely informative field that should have no impact on validation. It goes along with build time option and
                                                                    * provides time zone information, as the embedded side does not know anything about time zone (without that, the build
                                                                    * time converted to a string will always yield GMT time, not local time). */
    uint8_t desc[BCMOLT_FIRMWARE_ENVELOPE_DESC_MAX_SIZE]; /* This is purely informative field that should have no impact on validation. */
    uint8_t md5_checksum[BCMOLT_FIRMWARE_ENVELOPE_MD5_CHECKSUM_SIZE]; /* The MD5 checksum should be applied on the image itself, not on the envelope. This may be redundant because we
                                                                       * automatically do CRC inherently as part of image transfer mechanism. However, this may have some future use. */
    uint32_t image_len; /* The size in bytes of the image itself, not with the envelope. 4 bytes should be big enough to accommodate image length up to 4GB, which is far beyond what we
                         * really need. */
} __PACKED_ATTR_END__ bcmolt_firmware_envelope;

#endif

