/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#ifndef _BCMOLT_CONV_H_
#define _BCMOLT_CONV_H_

#ifndef CFE_BUILD
#include <bcmolt_utils.h>
#endif

/* Macro for generating a generic conversion from type A to type B.
 * Example:
 *
 *      BCMOLT_TYPE2TYPE(bws_dba_control_id, bws_dba_control_cb, static)
 *
 * will expand to:
 *
 *     typedef struct
 *     {
 *         bws_dba_control_id from;
 *         bws_dba_control_cb to;
 *     }
 *     bws_dba_control_id2bws_dba_control_cb_t;
 *     
 *     static bws_dba_control_id2bws_dba_control_cb_t bws_dba_control_id2bws_dba_control_cb[];
 *     
 *     static inline bws_dba_control_cb bws_dba_control_id2bws_dba_control_cb_conv(bws_dba_control_id from)
 *     {
 *         const bws_dba_control_id2bws_dba_control_cb_t *arr = bws_dba_control_id2bws_dba_control_cb;
 *         for (; arr->from != (bws_dba_control_id)-1 && arr->from != from; arr++);
 *         return arr->to;
 *     }
 */
#define BCMOLT_TYPE2TYPE(from_type, to_type, scope) \
    typedef struct \
    { \
        from_type from; \
        to_type to; \
    } \
    from_type##2##to_type##_t; \
    scope from_type##2##to_type##_t from_type##2##to_type[]; \
    static inline to_type from_type##2##to_type##_conv(from_type from) \
    { \
        const from_type##2##to_type##_t *arr = from_type##2##to_type; \
        for (; arr->from != (from_type)-1 && arr->from != from; arr++); \
        return arr->to; \
    }

/* Macro for generating a generic conversion from type A to a constant string.
 * Example:
 *
 *      BCMOLT_TYPE2STR(pon_mode, extern)
 *
 * will expand to:
 *
 *     typedef struct
 *     {
 *         pon_mode from;
 *         const char *to;
 *     }
 *     pon_mode2str_t;
 *
 *     extern pon_mode2str_t pon_mode2str[];
 *
 *     static inline const char *pon_mode2str_conv(pon_mode from)
 *     {
 *         const pon_mode2str_t *arr = pon_mode2str;
 *         for (; arr->from != (pon_mode)-1 && arr->from != from; arr++);
 *         return arr->to;
 *     }
 */
#define BCMOLT_TYPE2STR(from_type, scope) \
    typedef struct \
    { \
        from_type from; \
        const char *to; \
    } \
    from_type##2str_t; \
    scope from_type##2str_t from_type##2str[]; \
    static inline const char *from_type##2str_conv(from_type from) \
    { \
        const from_type##2str_t *arr = from_type##2str; \
        for (; arr->from != (from_type)-1 && arr->from != from; arr++); \
        return arr->to; \
    }

/* Macro for generating a generic conversion from type A to an integer.
 * Example:
 *
 *      BCMOLT_TYPE2INT(ploam_ds_gpon_message_id, repetitions, extern)
 *
 * will expand to:
 * 
 *     typedef struct
 *     {
 *         ploam_ds_gpon_message_id from;
 *         int to;
 *     }
 *     ploam_ds_gpon_message_id2repetitions_t;
 *
 *     extern ploam_ds_gpon_message_id2repetitions_t ploam_ds_gpon_message_id2repetitions[];
 *
 *     static inline int ploam_ds_gpon_message_id2repetitions_conv(ploam_ds_gpon_message_id from)
 *     {
 *         const ploam_ds_gpon_message_id2repetitions_t *arr = ploam_ds_gpon_message_id2repetitions;
 *         for (; arr->from != (ploam_ds_gpon_message_id)-1 && arr->from != from; arr++);
 *         return arr->to;
 *     }
 */
#define BCMOLT_TYPE2INT(from_type, to_name, scope) \
    typedef struct \
    { \
        from_type from; \
        int to; \
    } \
    from_type##2##to_name##_t; \
    scope from_type##2##to_name##_t from_type##2##to_name[]; \
    static inline int from_type##2##to_name##_conv(from_type from) \
    { \
        const from_type##2##to_name##_t *arr = from_type##2##to_name; \
        for (; arr->from != (from_type)-1 && arr->from != from; arr++); \
        return arr->to; \
    }

/* Although we have BCMOLT_TYPE2STR, int2str_t is still required when the same generic pointer needs to point to 2 different types (e.g: one specific for GPON and
 * the other specific for XGPON). */
typedef struct
{
    int from;
    const char *to;
}
int2str_t;

static inline const char *int2str(const int2str_t *arr, int from)
{
    for (; arr->from != -1 && arr->from != from; arr++);
    return arr->to;
}

/* Although we have BCMOLT_TYPE2INT, int2int_t is still required when the same generic pointer needs to point to 2 different types (e.g: one specific for GPON and
 * the other specific for XGPON). */
typedef struct
{
    int from;
    int to;
}
int2int_t;

static inline int int2int(const int2int_t *arr, int from)
{
    for (; arr->from != -1 && arr->from != from; arr++);
    return arr->to;
}

#ifndef CFE_BUILD
char *bcmolt_strftime(char *time_str, time_t t, const char *timezone_str);
#endif

#endif

