/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#include <bcmos_system.h>
#include <bcmolt_utils.h>
#include "bcmolt_conv.h"

char *bcmolt_strftime(char *time_str, time_t t, const char *timezone_str)
{
    struct tm ts;
    int32_t tz_hour;
    uint32_t tz_min;
    
    ts = *localtime(&t);
    if (timezone_str && *timezone_str)
    {
        if (sscanf(timezone_str, "%03d:%02u", &tz_hour, &tz_min) < 2)
        {
            tz_hour = 0;
            tz_min = 0;
        }
        else
        {
            ts.tm_hour += tz_hour;
            ts.tm_min += tz_min;
        }
    }

    strftime(time_str, BCMOLT_TIME_STR_MAX_LEN, "%a %Y-%m-%d %H:%M:%S", &ts);

    return time_str;
}

