/*
<:copyright-BRCM:2016:proprietary:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

This program is the proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modified or distributed pursuant
to the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License").  Except as set forth in
an Authorized License, Broadcom grants no license (express or implied), right
to use, or waiver of any kind with respect to the Software, and Broadcom
expressly reserves all rights in and to the Software and all intellectual
property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization,
    constitutes the valuable trade secrets of Broadcom, and you shall use
    all reasonable efforts to protect the confidentiality thereof, and to
    use this information only in connection with your use of Broadcom
    integrated circuit products.

2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
    PERFORMANCE OF THE SOFTWARE.

3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
    LIMITED REMEDY.
:>
*/

#ifndef BCMOLT_MSG_PACK_H_
#define BCMOLT_MSG_PACK_H_

#include "bcmos_system.h"
#include "bcmos_common.h"
#include "bcmos_errno.h"
#include "bcmolt_buf.h"
#include "bcmolt_msg.h"
#include "bcmolt_model_types.h"

/** Gets the number of bytes a message would occupy when packed.
 *
 * \param this The message to scan.
 * \return The size in bytes if > 0, or an error as defined in bcmos_errno.
 */
int32_t bcmolt_msg_get_packed_length(bcmolt_msg *this);

/** Packs a message to a byte stream.
 *
 * \param this The message to pack.
 * \param buf The stream to pack into.
 * \return An error code or BCM_ERR_OK for success.
 */
bcmos_errno bcmolt_msg_pack(bcmolt_msg *this, bcmolt_buf *buf);

/** Unpacks a message from a byte stream.
 *
 * This unpacks the message from the packed form into the struct following the "unpacked" pointer.  There are several
 * special cases:
 *
 * if *unpacked == NULL:
 *   *unpacked will be allocated dynamically via bcmos_calloc, in a contiguous block of memory with the struct
 *   itself followed by the memory required for all variable-sized lists.
 *
 * if (*unpacked)->list_buf != NULL:
 *   When a variable-length list is encountered in the input stream, and the array field we're unpacking into is NULL,
 *   memory will be allocated starting from (*unpacked)->list_buf.  If multiple such lists exist, they will share this
 *   buffer.  If the (*unpacked)->list_buf_size is not large enough, this will return BCM_ERR_INSUFFICIENT_LIST_MEM.
 *
 * \param buf           The stream to unpack from.
 * \param unpacked      A pointer to the message to unpack.
 * \return An error as defined in bcmos_errno.
 */
bcmos_errno bcmolt_msg_unpack(bcmolt_buf *buf, bcmolt_msg **unpacked);

/** Converts a generic group ID into a specific object type, group and subgroup.
 *
 * \param group_id The generic group ID.
 * \param obj The object type that corresponds to the group ID.
 * \param group The group type that corresponds to the group ID.
 * \param subgroup The subgroup index that corresponds to the group ID.
 * \return An error code or BCM_ERR_OK for success.
 */
bcmos_errno bcmolt_group_id_split(bcmolt_group_id group_id,
                                  bcmolt_obj_id *obj,
                                  bcmolt_mgt_group *group,
                                  uint16_t *subgroup);

/** Converts a specific object type, group and subgroup into a generic group ID.
 *
 * \param obj The object type that corresponds to the group ID.
 * \param group The group type that corresponds to the group ID.
 * \param subgroup The subgroup index that corresponds to the group ID.
 * \param group_id The generic group ID.
 * \return An error code or BCM_ERR_OK for success.
 */
bcmos_errno bcmolt_group_id_combine(bcmolt_obj_id obj,
                                    bcmolt_mgt_group group,
                                    uint16_t subgroup,
                                    bcmolt_group_id *group_id);

/** Returns the instance number of a given message, as determined by the object key.
 *
 * \param msg The message to check.
 * \return The instance number of the message.
 */
uint8_t bcmolt_msg_instance(const bcmolt_msg *msg);

/** Gets a mask of all readonly properties for an object's cfg group.
 *
 * \param obj The objecct to check.
 * \param mask A mask of bits set to 1 per read-only property.
 * \return An error code or BCM_ERR_OK for success.
 */
bcmos_errno bcmolt_get_prop_readonly_mask(bcmolt_obj_id obj, bcmolt_presence_mask *mask);

/** Clones a message by packing it to a buffer then unpacking it into the destination message.
 * This uses bcmolt_msg_unpack, so if *dest is NULL, memory will by allocated dynamically using bcmos_calloc.
 *
 * \param dest A pointer to the location in memory that will hold the cloned message.
 * \param src The message that should be copied.
 * \return An error code or BCM_ERR_OK for success.
 */
bcmos_errno bcmolt_msg_clone(bcmolt_msg **dest, bcmolt_msg *src);

#endif /* BCMOLT_MSG_PACK_H_ */
