/*
<:copyright-BRCM:2016:proprietary:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

This program is the proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modified or distributed pursuant
to the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License").  Except as set forth in
an Authorized License, Broadcom grants no license (express or implied), right
to use, or waiver of any kind with respect to the Software, and Broadcom
expressly reserves all rights in and to the Software and all intellectual
property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization,
    constitutes the valuable trade secrets of Broadcom, and you shall use
    all reasonable efforts to protect the confidentiality thereof, and to
    use this information only in connection with your use of Broadcom
    integrated circuit products.

2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
    PERFORMANCE OF THE SOFTWARE.

3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
    LIMITED REMEDY.
:>
*/
#include <bcmolt_buf.h>
#include <bcmolt_msg.h>
#include "bcmolt_msg_pack.h"

typedef uint32_t (*bcmolt_func_packed_len) (void *this, bcmolt_presence_mask fields_present);
typedef bcmos_bool (*bcmolt_func_pack) (void *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present);
typedef bcmos_bool (*bcmolt_func_unpack) (void *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present);
typedef bcmos_bool (*bcmolt_func_mem_scan) (bcmolt_buf * buf, uint32_t * extra_mem, bcmolt_presence_mask fields_present);

/******************************************************************************/
typedef struct bcmolt_group_info
{
    bcmolt_obj_id obj_type;
    bcmolt_mgt_group group;
    uint16_t subgroup;
    uint32_t size;
    uint32_t container_size;    /* sizeof() the key/data container struct (0 for key groups) */
    uint32_t data_offset;       /* offsetof() data field within container struct (0 for key groups) */
    bcmolt_func_packed_len get_packed_length;
    bcmolt_func_pack pack;
    bcmolt_func_unpack unpack;
    bcmolt_func_mem_scan mem_scan;
} bcmolt_group_info;

/******************************************************************************/
typedef struct bcmolt_group_ids
{
    uint32_t subgroup_count;
    bcmolt_group_id *subgroup_ids;
} bcmolt_group_ids;

/******************************************************************************/
typedef struct bcmolt_instance_info
{
    int8_t offset;
    int8_t size;
} bcmolt_instance_info;

/******************************************************************************/
static bcmolt_group_info group_info_ae_ni_key = { BCMOLT_OBJ_ID_AE_NI, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_ae_ni_key), 0, 0, (bcmolt_func_packed_len) bcmolt_ae_ni_key_get_packed_length, (bcmolt_func_pack) bcmolt_ae_ni_key_pack, (bcmolt_func_unpack) bcmolt_ae_ni_key_unpack, bcmolt_ae_ni_key_scan };
static bcmolt_group_info group_info_ae_ni_cfg = { BCMOLT_OBJ_ID_AE_NI, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_ae_ni_cfg_data), sizeof(bcmolt_ae_ni_cfg), offsetof(bcmolt_ae_ni_cfg, data), (bcmolt_func_packed_len) bcmolt_ae_ni_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_ni_cfg_data_pack, (bcmolt_func_unpack) bcmolt_ae_ni_cfg_data_unpack, bcmolt_ae_ni_cfg_data_scan };
static bcmolt_group_info group_info_ae_ni_set_ae_ni_en_state = { BCMOLT_OBJ_ID_AE_NI, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_ae_ni_set_ae_ni_en_state_data), sizeof(bcmolt_ae_ni_set_ae_ni_en_state), offsetof(bcmolt_ae_ni_set_ae_ni_en_state, data), (bcmolt_func_packed_len) bcmolt_ae_ni_set_ae_ni_en_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_ni_set_ae_ni_en_state_data_pack, (bcmolt_func_unpack) bcmolt_ae_ni_set_ae_ni_en_state_data_unpack, bcmolt_ae_ni_set_ae_ni_en_state_data_scan };
static bcmolt_group_info group_info_ae_path_ds_key = { BCMOLT_OBJ_ID_AE_PATH_DS, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_ae_path_ds_key), 0, 0, (bcmolt_func_packed_len) bcmolt_ae_path_ds_key_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_ds_key_pack, (bcmolt_func_unpack) bcmolt_ae_path_ds_key_unpack, bcmolt_ae_path_ds_key_scan };
static bcmolt_group_info group_info_ae_path_ds_stat = { BCMOLT_OBJ_ID_AE_PATH_DS, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_ae_path_ds_stat_data), sizeof(bcmolt_ae_path_ds_stat), offsetof(bcmolt_ae_path_ds_stat, data), (bcmolt_func_packed_len) bcmolt_ae_path_ds_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_ds_stat_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_ds_stat_data_unpack, bcmolt_ae_path_ds_stat_data_scan };
static bcmolt_group_info group_info_ae_path_ds_stat_cfg = { BCMOLT_OBJ_ID_AE_PATH_DS, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_ae_path_ds_stat_cfg_data), sizeof(bcmolt_ae_path_ds_stat_cfg), offsetof(bcmolt_ae_path_ds_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_ae_path_ds_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_ds_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_ds_stat_cfg_data_unpack, bcmolt_ae_path_ds_stat_cfg_data_scan };
static bcmolt_group_info group_info_ae_path_ds_stat_alarm_cleared = { BCMOLT_OBJ_ID_AE_PATH_DS, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_ae_path_ds_stat_alarm_cleared_data), sizeof(bcmolt_ae_path_ds_stat_alarm_cleared), offsetof(bcmolt_ae_path_ds_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_ae_path_ds_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_ds_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_ds_stat_alarm_cleared_data_unpack, bcmolt_ae_path_ds_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_ae_path_ds_stat_alarm_raised = { BCMOLT_OBJ_ID_AE_PATH_DS, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_ae_path_ds_stat_alarm_raised_data), sizeof(bcmolt_ae_path_ds_stat_alarm_raised), offsetof(bcmolt_ae_path_ds_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_ae_path_ds_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_ds_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_ds_stat_alarm_raised_data_unpack, bcmolt_ae_path_ds_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_ae_path_ds_auto_cfg = { BCMOLT_OBJ_ID_AE_PATH_DS, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_ae_path_ds_auto_cfg_data), sizeof(bcmolt_ae_path_ds_auto_cfg), offsetof(bcmolt_ae_path_ds_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_ae_path_ds_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_ds_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_ds_auto_cfg_data_unpack, bcmolt_ae_path_ds_auto_cfg_data_scan };
static bcmolt_group_info group_info_ae_path_us_key = { BCMOLT_OBJ_ID_AE_PATH_US, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_ae_path_us_key), 0, 0, (bcmolt_func_packed_len) bcmolt_ae_path_us_key_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_us_key_pack, (bcmolt_func_unpack) bcmolt_ae_path_us_key_unpack, bcmolt_ae_path_us_key_scan };
static bcmolt_group_info group_info_ae_path_us_stat = { BCMOLT_OBJ_ID_AE_PATH_US, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_ae_path_us_stat_data), sizeof(bcmolt_ae_path_us_stat), offsetof(bcmolt_ae_path_us_stat, data), (bcmolt_func_packed_len) bcmolt_ae_path_us_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_us_stat_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_us_stat_data_unpack, bcmolt_ae_path_us_stat_data_scan };
static bcmolt_group_info group_info_ae_path_us_stat_cfg = { BCMOLT_OBJ_ID_AE_PATH_US, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_ae_path_us_stat_cfg_data), sizeof(bcmolt_ae_path_us_stat_cfg), offsetof(bcmolt_ae_path_us_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_ae_path_us_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_us_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_us_stat_cfg_data_unpack, bcmolt_ae_path_us_stat_cfg_data_scan };
static bcmolt_group_info group_info_ae_path_us_stat_alarm_cleared = { BCMOLT_OBJ_ID_AE_PATH_US, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_ae_path_us_stat_alarm_cleared_data), sizeof(bcmolt_ae_path_us_stat_alarm_cleared), offsetof(bcmolt_ae_path_us_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_ae_path_us_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_us_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_us_stat_alarm_cleared_data_unpack, bcmolt_ae_path_us_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_ae_path_us_stat_alarm_raised = { BCMOLT_OBJ_ID_AE_PATH_US, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_ae_path_us_stat_alarm_raised_data), sizeof(bcmolt_ae_path_us_stat_alarm_raised), offsetof(bcmolt_ae_path_us_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_ae_path_us_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_us_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_us_stat_alarm_raised_data_unpack, bcmolt_ae_path_us_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_ae_path_us_auto_cfg = { BCMOLT_OBJ_ID_AE_PATH_US, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_ae_path_us_auto_cfg_data), sizeof(bcmolt_ae_path_us_auto_cfg), offsetof(bcmolt_ae_path_us_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_ae_path_us_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_ae_path_us_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_ae_path_us_auto_cfg_data_unpack, bcmolt_ae_path_us_auto_cfg_data_scan };
static bcmolt_group_info group_info_channel_key = { BCMOLT_OBJ_ID_CHANNEL, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_channel_key), 0, 0, (bcmolt_func_packed_len) bcmolt_channel_key_get_packed_length, (bcmolt_func_pack) bcmolt_channel_key_pack, (bcmolt_func_unpack) bcmolt_channel_key_unpack, bcmolt_channel_key_scan };
static bcmolt_group_info group_info_channel_cfg = { BCMOLT_OBJ_ID_CHANNEL, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_channel_cfg_data), sizeof(bcmolt_channel_cfg), offsetof(bcmolt_channel_cfg, data), (bcmolt_func_packed_len) bcmolt_channel_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_channel_cfg_data_pack, (bcmolt_func_unpack) bcmolt_channel_cfg_data_unpack, bcmolt_channel_cfg_data_scan };
static bcmolt_group_info group_info_debug_key = { BCMOLT_OBJ_ID_DEBUG, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_debug_key), 0, 0, (bcmolt_func_packed_len) bcmolt_debug_key_get_packed_length, (bcmolt_func_pack) bcmolt_debug_key_pack, (bcmolt_func_unpack) bcmolt_debug_key_unpack, bcmolt_debug_key_scan };
static bcmolt_group_info group_info_debug_cfg = { BCMOLT_OBJ_ID_DEBUG, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_debug_cfg_data), sizeof(bcmolt_debug_cfg), offsetof(bcmolt_debug_cfg, data), (bcmolt_func_packed_len) bcmolt_debug_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_debug_cfg_data_pack, (bcmolt_func_unpack) bcmolt_debug_cfg_data_unpack, bcmolt_debug_cfg_data_scan };
static bcmolt_group_info group_info_debug_cli_output = { BCMOLT_OBJ_ID_DEBUG, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_debug_cli_output_data), sizeof(bcmolt_debug_cli_output), offsetof(bcmolt_debug_cli_output, data), (bcmolt_func_packed_len) bcmolt_debug_cli_output_data_get_packed_length, (bcmolt_func_pack) bcmolt_debug_cli_output_data_pack, (bcmolt_func_unpack) bcmolt_debug_cli_output_data_unpack, bcmolt_debug_cli_output_data_scan };
static bcmolt_group_info group_info_debug_file_almost_full = { BCMOLT_OBJ_ID_DEBUG, BCMOLT_MGT_GROUP_AUTO, 1, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_debug_auto_cfg = { BCMOLT_OBJ_ID_DEBUG, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_debug_auto_cfg_data), sizeof(bcmolt_debug_auto_cfg), offsetof(bcmolt_debug_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_debug_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_debug_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_debug_auto_cfg_data_unpack, bcmolt_debug_auto_cfg_data_scan };
static bcmolt_group_info group_info_debug_cli_input = { BCMOLT_OBJ_ID_DEBUG, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_debug_cli_input_data), sizeof(bcmolt_debug_cli_input), offsetof(bcmolt_debug_cli_input, data), (bcmolt_func_packed_len) bcmolt_debug_cli_input_data_get_packed_length, (bcmolt_func_pack) bcmolt_debug_cli_input_data_pack, (bcmolt_func_unpack) bcmolt_debug_cli_input_data_unpack, bcmolt_debug_cli_input_data_scan };
static bcmolt_group_info group_info_debug_reset_api_capture = { BCMOLT_OBJ_ID_DEBUG, BCMOLT_MGT_GROUP_OPER, 1, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_debug_start_api_capture = { BCMOLT_OBJ_ID_DEBUG, BCMOLT_MGT_GROUP_OPER, 2, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_debug_stop_api_capture = { BCMOLT_OBJ_ID_DEBUG, BCMOLT_MGT_GROUP_OPER, 3, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_device_key = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_device_key), 0, 0, (bcmolt_func_packed_len) bcmolt_device_key_get_packed_length, (bcmolt_func_pack) bcmolt_device_key_pack, (bcmolt_func_unpack) bcmolt_device_key_unpack, bcmolt_device_key_scan };
static bcmolt_group_info group_info_device_cfg = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_device_cfg_data), sizeof(bcmolt_device_cfg), offsetof(bcmolt_device_cfg, data), (bcmolt_func_packed_len) bcmolt_device_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_cfg_data_pack, (bcmolt_func_unpack) bcmolt_device_cfg_data_unpack, bcmolt_device_cfg_data_scan };
static bcmolt_group_info group_info_device_connection_complete = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_device_connection_complete_data), sizeof(bcmolt_device_connection_complete), offsetof(bcmolt_device_connection_complete, data), (bcmolt_func_packed_len) bcmolt_device_connection_complete_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_connection_complete_data_pack, (bcmolt_func_unpack) bcmolt_device_connection_complete_data_unpack, bcmolt_device_connection_complete_data_scan };
static bcmolt_group_info group_info_device_connection_established = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 1, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_device_connection_failure = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_device_connection_failure_data), sizeof(bcmolt_device_connection_failure), offsetof(bcmolt_device_connection_failure, data), (bcmolt_func_packed_len) bcmolt_device_connection_failure_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_connection_failure_data_pack, (bcmolt_func_unpack) bcmolt_device_connection_failure_data_unpack, bcmolt_device_connection_failure_data_scan };
static bcmolt_group_info group_info_device_ddr_test_complete = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 3, sizeof(bcmolt_device_ddr_test_complete_data), sizeof(bcmolt_device_ddr_test_complete), offsetof(bcmolt_device_ddr_test_complete, data), (bcmolt_func_packed_len) bcmolt_device_ddr_test_complete_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_ddr_test_complete_data_pack, (bcmolt_func_unpack) bcmolt_device_ddr_test_complete_data_unpack, bcmolt_device_ddr_test_complete_data_scan };
static bcmolt_group_info group_info_device_device_keep_alive = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 4, sizeof(bcmolt_device_device_keep_alive_data), sizeof(bcmolt_device_device_keep_alive), offsetof(bcmolt_device_device_keep_alive, data), (bcmolt_func_packed_len) bcmolt_device_device_keep_alive_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_device_keep_alive_data_pack, (bcmolt_func_unpack) bcmolt_device_device_keep_alive_data_unpack, bcmolt_device_device_keep_alive_data_scan };
static bcmolt_group_info group_info_device_device_ready = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 5, sizeof(bcmolt_device_device_ready_data), sizeof(bcmolt_device_device_ready), offsetof(bcmolt_device_device_ready, data), (bcmolt_func_packed_len) bcmolt_device_device_ready_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_device_ready_data_pack, (bcmolt_func_unpack) bcmolt_device_device_ready_data_unpack, bcmolt_device_device_ready_data_scan };
static bcmolt_group_info group_info_device_disconnection_complete = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 6, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_device_image_transfer_complete = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 7, sizeof(bcmolt_device_image_transfer_complete_data), sizeof(bcmolt_device_image_transfer_complete), offsetof(bcmolt_device_image_transfer_complete, data), (bcmolt_func_packed_len) bcmolt_device_image_transfer_complete_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_image_transfer_complete_data_pack, (bcmolt_func_unpack) bcmolt_device_image_transfer_complete_data_unpack, bcmolt_device_image_transfer_complete_data_scan };
static bcmolt_group_info group_info_device_indications_dropped = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 8, sizeof(bcmolt_device_indications_dropped_data), sizeof(bcmolt_device_indications_dropped), offsetof(bcmolt_device_indications_dropped, data), (bcmolt_func_packed_len) bcmolt_device_indications_dropped_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_indications_dropped_data_pack, (bcmolt_func_unpack) bcmolt_device_indications_dropped_data_unpack, bcmolt_device_indications_dropped_data_scan };
static bcmolt_group_info group_info_device_sw_error = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 9, sizeof(bcmolt_device_sw_error_data), sizeof(bcmolt_device_sw_error), offsetof(bcmolt_device_sw_error, data), (bcmolt_func_packed_len) bcmolt_device_sw_error_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_sw_error_data_pack, (bcmolt_func_unpack) bcmolt_device_sw_error_data_unpack, bcmolt_device_sw_error_data_scan };
static bcmolt_group_info group_info_device_sw_exception = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO, 10, sizeof(bcmolt_device_sw_exception_data), sizeof(bcmolt_device_sw_exception), offsetof(bcmolt_device_sw_exception, data), (bcmolt_func_packed_len) bcmolt_device_sw_exception_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_sw_exception_data_pack, (bcmolt_func_unpack) bcmolt_device_sw_exception_data_unpack, bcmolt_device_sw_exception_data_scan };
static bcmolt_group_info group_info_device_auto_cfg = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_device_auto_cfg_data), sizeof(bcmolt_device_auto_cfg), offsetof(bcmolt_device_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_device_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_device_auto_cfg_data_unpack, bcmolt_device_auto_cfg_data_scan };
static bcmolt_group_info group_info_device_connect = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_OPER, 0, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_device_disconnect = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_OPER, 1, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_device_host_keep_alive = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_OPER, 2, sizeof(bcmolt_device_host_keep_alive_data), sizeof(bcmolt_device_host_keep_alive), offsetof(bcmolt_device_host_keep_alive, data), (bcmolt_func_packed_len) bcmolt_device_host_keep_alive_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_host_keep_alive_data_pack, (bcmolt_func_unpack) bcmolt_device_host_keep_alive_data_unpack, bcmolt_device_host_keep_alive_data_scan };
static bcmolt_group_info group_info_device_image_transfer_data = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_OPER, 3, sizeof(bcmolt_device_image_transfer_data_data), sizeof(bcmolt_device_image_transfer_data), offsetof(bcmolt_device_image_transfer_data, data), (bcmolt_func_packed_len) bcmolt_device_image_transfer_data_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_image_transfer_data_data_pack, (bcmolt_func_unpack) bcmolt_device_image_transfer_data_data_unpack, bcmolt_device_image_transfer_data_data_scan };
static bcmolt_group_info group_info_device_image_transfer_start = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_OPER, 4, sizeof(bcmolt_device_image_transfer_start_data), sizeof(bcmolt_device_image_transfer_start), offsetof(bcmolt_device_image_transfer_start, data), (bcmolt_func_packed_len) bcmolt_device_image_transfer_start_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_image_transfer_start_data_pack, (bcmolt_func_unpack) bcmolt_device_image_transfer_start_data_unpack, bcmolt_device_image_transfer_start_data_scan };
static bcmolt_group_info group_info_device_reset = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_OPER, 5, sizeof(bcmolt_device_reset_data), sizeof(bcmolt_device_reset), offsetof(bcmolt_device_reset, data), (bcmolt_func_packed_len) bcmolt_device_reset_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_reset_data_pack, (bcmolt_func_unpack) bcmolt_device_reset_data_unpack, bcmolt_device_reset_data_scan };
static bcmolt_group_info group_info_device_run_ddr_test = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_OPER, 6, sizeof(bcmolt_device_run_ddr_test_data), sizeof(bcmolt_device_run_ddr_test), offsetof(bcmolt_device_run_ddr_test, data), (bcmolt_func_packed_len) bcmolt_device_run_ddr_test_data_get_packed_length, (bcmolt_func_pack) bcmolt_device_run_ddr_test_data_pack, (bcmolt_func_unpack) bcmolt_device_run_ddr_test_data_unpack, bcmolt_device_run_ddr_test_data_scan };
static bcmolt_group_info group_info_device_sw_upgrade_activate = { BCMOLT_OBJ_ID_DEVICE, BCMOLT_MGT_GROUP_OPER, 7, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_denied_link_key = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_denied_link_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_denied_link_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_key_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_key_unpack, bcmolt_epon_denied_link_key_scan };
static bcmolt_group_info group_info_epon_denied_link_cfg = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_denied_link_cfg_data), sizeof(bcmolt_epon_denied_link_cfg), offsetof(bcmolt_epon_denied_link_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_cfg_data_unpack, bcmolt_epon_denied_link_cfg_data_scan };
static bcmolt_group_info group_info_epon_denied_link_laser_on_off_violation = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_epon_denied_link_laser_on_off_violation_data), sizeof(bcmolt_epon_denied_link_laser_on_off_violation), offsetof(bcmolt_epon_denied_link_laser_on_off_violation, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_laser_on_off_violation_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_laser_on_off_violation_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_laser_on_off_violation_data_unpack, bcmolt_epon_denied_link_laser_on_off_violation_data_scan };
static bcmolt_group_info group_info_epon_denied_link_llid_pool_empty_violation = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_epon_denied_link_llid_pool_empty_violation_data), sizeof(bcmolt_epon_denied_link_llid_pool_empty_violation), offsetof(bcmolt_epon_denied_link_llid_pool_empty_violation, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_llid_pool_empty_violation_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_llid_pool_empty_violation_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_llid_pool_empty_violation_data_unpack, bcmolt_epon_denied_link_llid_pool_empty_violation_data_scan };
static bcmolt_group_info group_info_epon_denied_link_max_link_violation = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_epon_denied_link_max_link_violation_data), sizeof(bcmolt_epon_denied_link_max_link_violation), offsetof(bcmolt_epon_denied_link_max_link_violation, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_max_link_violation_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_max_link_violation_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_max_link_violation_data_unpack, bcmolt_epon_denied_link_max_link_violation_data_scan };
static bcmolt_group_info group_info_epon_denied_link_overhead_profile_violation = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 3, sizeof(bcmolt_epon_denied_link_overhead_profile_violation_data), sizeof(bcmolt_epon_denied_link_overhead_profile_violation), offsetof(bcmolt_epon_denied_link_overhead_profile_violation, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_overhead_profile_violation_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_overhead_profile_violation_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_overhead_profile_violation_data_unpack, bcmolt_epon_denied_link_overhead_profile_violation_data_scan };
static bcmolt_group_info group_info_epon_denied_link_range_violation = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 4, sizeof(bcmolt_epon_denied_link_range_violation_data), sizeof(bcmolt_epon_denied_link_range_violation), offsetof(bcmolt_epon_denied_link_range_violation, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_range_violation_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_range_violation_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_range_violation_data_unpack, bcmolt_epon_denied_link_range_violation_data_scan };
static bcmolt_group_info group_info_epon_denied_link_rogue_violation = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 5, sizeof(bcmolt_epon_denied_link_rogue_violation_data), sizeof(bcmolt_epon_denied_link_rogue_violation), offsetof(bcmolt_epon_denied_link_rogue_violation, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_rogue_violation_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_rogue_violation_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_rogue_violation_data_unpack, bcmolt_epon_denied_link_rogue_violation_data_scan };
static bcmolt_group_info group_info_epon_denied_link_system_resource_violation = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 6, sizeof(bcmolt_epon_denied_link_system_resource_violation_data), sizeof(bcmolt_epon_denied_link_system_resource_violation), offsetof(bcmolt_epon_denied_link_system_resource_violation, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_system_resource_violation_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_system_resource_violation_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_system_resource_violation_data_unpack, bcmolt_epon_denied_link_system_resource_violation_data_scan };
static bcmolt_group_info group_info_epon_denied_link_tdm_channels_exhausted = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 7, sizeof(bcmolt_epon_denied_link_tdm_channels_exhausted_data), sizeof(bcmolt_epon_denied_link_tdm_channels_exhausted), offsetof(bcmolt_epon_denied_link_tdm_channels_exhausted, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_tdm_channels_exhausted_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_tdm_channels_exhausted_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_tdm_channels_exhausted_data_unpack, bcmolt_epon_denied_link_tdm_channels_exhausted_data_scan };
static bcmolt_group_info group_info_epon_denied_link_unknown_link_violation = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 8, sizeof(bcmolt_epon_denied_link_unknown_link_violation_data), sizeof(bcmolt_epon_denied_link_unknown_link_violation), offsetof(bcmolt_epon_denied_link_unknown_link_violation, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_unknown_link_violation_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_unknown_link_violation_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_unknown_link_violation_data_unpack, bcmolt_epon_denied_link_unknown_link_violation_data_scan };
static bcmolt_group_info group_info_epon_denied_link_upstream_bandwidth_violation = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO, 9, sizeof(bcmolt_epon_denied_link_upstream_bandwidth_violation_data), sizeof(bcmolt_epon_denied_link_upstream_bandwidth_violation), offsetof(bcmolt_epon_denied_link_upstream_bandwidth_violation, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_upstream_bandwidth_violation_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_upstream_bandwidth_violation_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_upstream_bandwidth_violation_data_unpack, bcmolt_epon_denied_link_upstream_bandwidth_violation_data_scan };
static bcmolt_group_info group_info_epon_denied_link_auto_cfg = { BCMOLT_OBJ_ID_EPON_DENIED_LINK, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_epon_denied_link_auto_cfg_data), sizeof(bcmolt_epon_denied_link_auto_cfg), offsetof(bcmolt_epon_denied_link_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_denied_link_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_denied_link_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_denied_link_auto_cfg_data_unpack, bcmolt_epon_denied_link_auto_cfg_data_scan };
static bcmolt_group_info group_info_epon_link_key = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_link_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_link_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_key_pack, (bcmolt_func_unpack) bcmolt_epon_link_key_unpack, bcmolt_epon_link_key_scan };
static bcmolt_group_info group_info_epon_link_cfg = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_link_cfg_data), sizeof(bcmolt_epon_link_cfg), offsetof(bcmolt_epon_link_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_link_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_cfg_data_unpack, bcmolt_epon_link_cfg_data_scan };
static bcmolt_group_info group_info_epon_link_stat = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_epon_link_stat_data), sizeof(bcmolt_epon_link_stat), offsetof(bcmolt_epon_link_stat, data), (bcmolt_func_packed_len) bcmolt_epon_link_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_stat_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_stat_data_unpack, bcmolt_epon_link_stat_data_scan };
static bcmolt_group_info group_info_epon_link_stat_cfg = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_epon_link_stat_cfg_data), sizeof(bcmolt_epon_link_stat_cfg), offsetof(bcmolt_epon_link_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_link_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_stat_cfg_data_unpack, bcmolt_epon_link_stat_cfg_data_scan };
static bcmolt_group_info group_info_epon_link_duplicate_mpcp_registration_request = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_epon_link_duplicate_mpcp_registration_request_data), sizeof(bcmolt_epon_link_duplicate_mpcp_registration_request), offsetof(bcmolt_epon_link_duplicate_mpcp_registration_request, data), (bcmolt_func_packed_len) bcmolt_epon_link_duplicate_mpcp_registration_request_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_duplicate_mpcp_registration_request_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_duplicate_mpcp_registration_request_data_unpack, bcmolt_epon_link_duplicate_mpcp_registration_request_data_scan };
static bcmolt_group_info group_info_epon_link_encryption_enabled = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 1, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_key_exchange_failure = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_epon_link_key_exchange_failure_data), sizeof(bcmolt_epon_link_key_exchange_failure), offsetof(bcmolt_epon_link_key_exchange_failure, data), (bcmolt_func_packed_len) bcmolt_epon_link_key_exchange_failure_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_key_exchange_failure_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_key_exchange_failure_data_unpack, bcmolt_epon_link_key_exchange_failure_data_scan };
static bcmolt_group_info group_info_epon_link_key_exchange_started = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 3, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_key_exchange_stopped = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 4, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_link_deleted = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 5, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_link_speed_mismatch = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 6, sizeof(bcmolt_epon_link_link_speed_mismatch_data), sizeof(bcmolt_epon_link_link_speed_mismatch), offsetof(bcmolt_epon_link_link_speed_mismatch, data), (bcmolt_func_packed_len) bcmolt_epon_link_link_speed_mismatch_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_link_speed_mismatch_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_link_speed_mismatch_data_unpack, bcmolt_epon_link_link_speed_mismatch_data_scan };
static bcmolt_group_info group_info_epon_link_mpcp_deregistered = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 7, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_mpcp_discovered = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 8, sizeof(bcmolt_epon_link_mpcp_discovered_data), sizeof(bcmolt_epon_link_mpcp_discovered), offsetof(bcmolt_epon_link_mpcp_discovered, data), (bcmolt_func_packed_len) bcmolt_epon_link_mpcp_discovered_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_mpcp_discovered_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_mpcp_discovered_data_unpack, bcmolt_epon_link_mpcp_discovered_data_scan };
static bcmolt_group_info group_info_epon_link_mpcp_reg_ack_timeout = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 9, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_mpcp_report_timeout = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 10, sizeof(bcmolt_epon_link_mpcp_report_timeout_data), sizeof(bcmolt_epon_link_mpcp_report_timeout), offsetof(bcmolt_epon_link_mpcp_report_timeout, data), (bcmolt_func_packed_len) bcmolt_epon_link_mpcp_report_timeout_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_mpcp_report_timeout_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_mpcp_report_timeout_data_unpack, bcmolt_epon_link_mpcp_report_timeout_data_scan };
static bcmolt_group_info group_info_epon_link_oam_keepalive_timeout = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 11, sizeof(bcmolt_epon_link_oam_keepalive_timeout_data), sizeof(bcmolt_epon_link_oam_keepalive_timeout), offsetof(bcmolt_epon_link_oam_keepalive_timeout, data), (bcmolt_func_packed_len) bcmolt_epon_link_oam_keepalive_timeout_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_oam_keepalive_timeout_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_oam_keepalive_timeout_data_unpack, bcmolt_epon_link_oam_keepalive_timeout_data_scan };
static bcmolt_group_info group_info_epon_link_oam_keepalive_timer_started = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 12, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_oam_keepalive_timer_stopped = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 13, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_preprovisioned_link_created = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 14, sizeof(bcmolt_epon_link_preprovisioned_link_created_data), sizeof(bcmolt_epon_link_preprovisioned_link_created), offsetof(bcmolt_epon_link_preprovisioned_link_created, data), (bcmolt_func_packed_len) bcmolt_epon_link_preprovisioned_link_created_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_preprovisioned_link_created_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_preprovisioned_link_created_data_unpack, bcmolt_epon_link_preprovisioned_link_created_data_scan };
static bcmolt_group_info group_info_epon_link_protection_switch_occurred = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 15, sizeof(bcmolt_epon_link_protection_switch_occurred_data), sizeof(bcmolt_epon_link_protection_switch_occurred), offsetof(bcmolt_epon_link_protection_switch_occurred, data), (bcmolt_func_packed_len) bcmolt_epon_link_protection_switch_occurred_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_protection_switch_occurred_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_protection_switch_occurred_data_unpack, bcmolt_epon_link_protection_switch_occurred_data_scan };
static bcmolt_group_info group_info_epon_link_range_value_changed = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 16, sizeof(bcmolt_epon_link_range_value_changed_data), sizeof(bcmolt_epon_link_range_value_changed), offsetof(bcmolt_epon_link_range_value_changed, data), (bcmolt_func_packed_len) bcmolt_epon_link_range_value_changed_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_range_value_changed_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_range_value_changed_data_unpack, bcmolt_epon_link_range_value_changed_data_scan };
static bcmolt_group_info group_info_epon_link_rerange_failure = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 17, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_stat_alarm_cleared = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 18, sizeof(bcmolt_epon_link_stat_alarm_cleared_data), sizeof(bcmolt_epon_link_stat_alarm_cleared), offsetof(bcmolt_epon_link_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_epon_link_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_stat_alarm_cleared_data_unpack, bcmolt_epon_link_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_epon_link_stat_alarm_raised = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 19, sizeof(bcmolt_epon_link_stat_alarm_raised_data), sizeof(bcmolt_epon_link_stat_alarm_raised), offsetof(bcmolt_epon_link_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_epon_link_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_stat_alarm_raised_data_unpack, bcmolt_epon_link_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_epon_link_static_registration_done = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO, 20, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_auto_cfg = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_epon_link_auto_cfg_data), sizeof(bcmolt_epon_link_auto_cfg), offsetof(bcmolt_epon_link_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_link_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_auto_cfg_data_unpack, bcmolt_epon_link_auto_cfg_data_scan };
static bcmolt_group_info group_info_epon_link_delete_link = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_OPER, 0, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_force_rediscovery = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_OPER, 1, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_key_exchange_start = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_OPER, 2, sizeof(bcmolt_epon_link_key_exchange_start_data), sizeof(bcmolt_epon_link_key_exchange_start), offsetof(bcmolt_epon_link_key_exchange_start, data), (bcmolt_func_packed_len) bcmolt_epon_link_key_exchange_start_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_key_exchange_start_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_key_exchange_start_data_unpack, bcmolt_epon_link_key_exchange_start_data_scan };
static bcmolt_group_info group_info_epon_link_key_exchange_stop = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_OPER, 3, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_oam_keepalive_timer_start = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_OPER, 4, sizeof(bcmolt_epon_link_oam_keepalive_timer_start_data), sizeof(bcmolt_epon_link_oam_keepalive_timer_start), offsetof(bcmolt_epon_link_oam_keepalive_timer_start, data), (bcmolt_func_packed_len) bcmolt_epon_link_oam_keepalive_timer_start_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_oam_keepalive_timer_start_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_oam_keepalive_timer_start_data_unpack, bcmolt_epon_link_oam_keepalive_timer_start_data_scan };
static bcmolt_group_info group_info_epon_link_oam_keepalive_timer_stop = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_OPER, 5, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_link_static_registration = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_OPER, 6, sizeof(bcmolt_epon_link_static_registration_data), sizeof(bcmolt_epon_link_static_registration), offsetof(bcmolt_epon_link_static_registration, data), (bcmolt_func_packed_len) bcmolt_epon_link_static_registration_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_static_registration_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_static_registration_data_unpack, bcmolt_epon_link_static_registration_data_scan };
static bcmolt_group_info group_info_epon_link_inject_frame = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_PROXY, 0, sizeof(bcmolt_epon_link_inject_frame_data), sizeof(bcmolt_epon_link_inject_frame), offsetof(bcmolt_epon_link_inject_frame, data), (bcmolt_func_packed_len) bcmolt_epon_link_inject_frame_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_inject_frame_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_inject_frame_data_unpack, bcmolt_epon_link_inject_frame_data_scan };
static bcmolt_group_info group_info_epon_link_frame_captured = { BCMOLT_OBJ_ID_EPON_LINK, BCMOLT_MGT_GROUP_PROXY_RX, 0, sizeof(bcmolt_epon_link_frame_captured_data), sizeof(bcmolt_epon_link_frame_captured), offsetof(bcmolt_epon_link_frame_captured, data), (bcmolt_func_packed_len) bcmolt_epon_link_frame_captured_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_link_frame_captured_data_pack, (bcmolt_func_unpack) bcmolt_epon_link_frame_captured_data_unpack, bcmolt_epon_link_frame_captured_data_scan };
static bcmolt_group_info group_info_epon_ni_key = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_ni_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_ni_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_key_pack, (bcmolt_func_unpack) bcmolt_epon_ni_key_unpack, bcmolt_epon_ni_key_scan };
static bcmolt_group_info group_info_epon_ni_cfg = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_ni_cfg_data), sizeof(bcmolt_epon_ni_cfg), offsetof(bcmolt_epon_ni_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_ni_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_cfg_data_unpack, bcmolt_epon_ni_cfg_data_scan };
static bcmolt_group_info group_info_epon_ni_auto_rogue_scan_10g_failure = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 0, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_ni_auto_rogue_scan_1g_failure = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 1, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_ni_llid_quarantined = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_epon_ni_llid_quarantined_data), sizeof(bcmolt_epon_ni_llid_quarantined), offsetof(bcmolt_epon_ni_llid_quarantined, data), (bcmolt_func_packed_len) bcmolt_epon_ni_llid_quarantined_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_llid_quarantined_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_llid_quarantined_data_unpack, bcmolt_epon_ni_llid_quarantined_data_scan };
static bcmolt_group_info group_info_epon_ni_mpcp_timestamp_changed = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 3, sizeof(bcmolt_epon_ni_mpcp_timestamp_changed_data), sizeof(bcmolt_epon_ni_mpcp_timestamp_changed), offsetof(bcmolt_epon_ni_mpcp_timestamp_changed, data), (bcmolt_func_packed_len) bcmolt_epon_ni_mpcp_timestamp_changed_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_mpcp_timestamp_changed_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_mpcp_timestamp_changed_data_unpack, bcmolt_epon_ni_mpcp_timestamp_changed_data_scan };
static bcmolt_group_info group_info_epon_ni_no_reports = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 4, sizeof(bcmolt_epon_ni_no_reports_data), sizeof(bcmolt_epon_ni_no_reports), offsetof(bcmolt_epon_ni_no_reports, data), (bcmolt_func_packed_len) bcmolt_epon_ni_no_reports_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_no_reports_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_no_reports_data_unpack, bcmolt_epon_ni_no_reports_data_scan };
static bcmolt_group_info group_info_epon_ni_onu_upgrade_complete = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 5, sizeof(bcmolt_epon_ni_onu_upgrade_complete_data), sizeof(bcmolt_epon_ni_onu_upgrade_complete), offsetof(bcmolt_epon_ni_onu_upgrade_complete, data), (bcmolt_func_packed_len) bcmolt_epon_ni_onu_upgrade_complete_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_onu_upgrade_complete_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_onu_upgrade_complete_data_unpack, bcmolt_epon_ni_onu_upgrade_complete_data_scan };
static bcmolt_group_info group_info_epon_ni_rerange_failure = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 6, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_epon_ni_rogue_scan_complete = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 7, sizeof(bcmolt_epon_ni_rogue_scan_complete_data), sizeof(bcmolt_epon_ni_rogue_scan_complete), offsetof(bcmolt_epon_ni_rogue_scan_complete, data), (bcmolt_func_packed_len) bcmolt_epon_ni_rogue_scan_complete_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_rogue_scan_complete_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_rogue_scan_complete_data_unpack, bcmolt_epon_ni_rogue_scan_complete_data_scan };
static bcmolt_group_info group_info_epon_ni_rssi_measurement_completed = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 8, sizeof(bcmolt_epon_ni_rssi_measurement_completed_data), sizeof(bcmolt_epon_ni_rssi_measurement_completed), offsetof(bcmolt_epon_ni_rssi_measurement_completed, data), (bcmolt_func_packed_len) bcmolt_epon_ni_rssi_measurement_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_rssi_measurement_completed_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_rssi_measurement_completed_data_unpack, bcmolt_epon_ni_rssi_measurement_completed_data_scan };
static bcmolt_group_info group_info_epon_ni_state_change_completed = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO, 9, sizeof(bcmolt_epon_ni_state_change_completed_data), sizeof(bcmolt_epon_ni_state_change_completed), offsetof(bcmolt_epon_ni_state_change_completed, data), (bcmolt_func_packed_len) bcmolt_epon_ni_state_change_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_state_change_completed_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_state_change_completed_data_unpack, bcmolt_epon_ni_state_change_completed_data_scan };
static bcmolt_group_info group_info_epon_ni_auto_cfg = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_epon_ni_auto_cfg_data), sizeof(bcmolt_epon_ni_auto_cfg), offsetof(bcmolt_epon_ni_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_ni_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_auto_cfg_data_unpack, bcmolt_epon_ni_auto_cfg_data_scan };
static bcmolt_group_info group_info_epon_ni_add_link = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_epon_ni_add_link_data), sizeof(bcmolt_epon_ni_add_link), offsetof(bcmolt_epon_ni_add_link, data), (bcmolt_func_packed_len) bcmolt_epon_ni_add_link_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_add_link_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_add_link_data_unpack, bcmolt_epon_ni_add_link_data_scan };
static bcmolt_group_info group_info_epon_ni_add_multicast_link = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_OPER, 1, sizeof(bcmolt_epon_ni_add_multicast_link_data), sizeof(bcmolt_epon_ni_add_multicast_link), offsetof(bcmolt_epon_ni_add_multicast_link, data), (bcmolt_func_packed_len) bcmolt_epon_ni_add_multicast_link_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_add_multicast_link_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_add_multicast_link_data_unpack, bcmolt_epon_ni_add_multicast_link_data_scan };
static bcmolt_group_info group_info_epon_ni_add_protected_standby_link = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_OPER, 2, sizeof(bcmolt_epon_ni_add_protected_standby_link_data), sizeof(bcmolt_epon_ni_add_protected_standby_link), offsetof(bcmolt_epon_ni_add_protected_standby_link, data), (bcmolt_func_packed_len) bcmolt_epon_ni_add_protected_standby_link_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_add_protected_standby_link_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_add_protected_standby_link_data_unpack, bcmolt_epon_ni_add_protected_standby_link_data_scan };
static bcmolt_group_info group_info_epon_ni_issue_rssi_grant = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_OPER, 3, sizeof(bcmolt_epon_ni_issue_rssi_grant_data), sizeof(bcmolt_epon_ni_issue_rssi_grant), offsetof(bcmolt_epon_ni_issue_rssi_grant, data), (bcmolt_func_packed_len) bcmolt_epon_ni_issue_rssi_grant_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_issue_rssi_grant_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_issue_rssi_grant_data_unpack, bcmolt_epon_ni_issue_rssi_grant_data_scan };
static bcmolt_group_info group_info_epon_ni_protection_switching_apply_rerange_delta = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_OPER, 4, sizeof(bcmolt_epon_ni_protection_switching_apply_rerange_delta_data), sizeof(bcmolt_epon_ni_protection_switching_apply_rerange_delta), offsetof(bcmolt_epon_ni_protection_switching_apply_rerange_delta, data), (bcmolt_func_packed_len) bcmolt_epon_ni_protection_switching_apply_rerange_delta_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_protection_switching_apply_rerange_delta_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_protection_switching_apply_rerange_delta_data_unpack, bcmolt_epon_ni_protection_switching_apply_rerange_delta_data_scan };
static bcmolt_group_info group_info_epon_ni_rogue_llid_scan = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_OPER, 5, sizeof(bcmolt_epon_ni_rogue_llid_scan_data), sizeof(bcmolt_epon_ni_rogue_llid_scan), offsetof(bcmolt_epon_ni_rogue_llid_scan, data), (bcmolt_func_packed_len) bcmolt_epon_ni_rogue_llid_scan_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_rogue_llid_scan_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_rogue_llid_scan_data_unpack, bcmolt_epon_ni_rogue_llid_scan_data_scan };
static bcmolt_group_info group_info_epon_ni_set_epon_ni_en_state = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_OPER, 6, sizeof(bcmolt_epon_ni_set_epon_ni_en_state_data), sizeof(bcmolt_epon_ni_set_epon_ni_en_state), offsetof(bcmolt_epon_ni_set_epon_ni_en_state, data), (bcmolt_func_packed_len) bcmolt_epon_ni_set_epon_ni_en_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_set_epon_ni_en_state_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_set_epon_ni_en_state_data_unpack, bcmolt_epon_ni_set_epon_ni_en_state_data_scan };
static bcmolt_group_info group_info_epon_ni_start_onu_upgrade = { BCMOLT_OBJ_ID_EPON_NI, BCMOLT_MGT_GROUP_OPER, 7, sizeof(bcmolt_epon_ni_start_onu_upgrade_data), sizeof(bcmolt_epon_ni_start_onu_upgrade), offsetof(bcmolt_epon_ni_start_onu_upgrade, data), (bcmolt_func_packed_len) bcmolt_epon_ni_start_onu_upgrade_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_ni_start_onu_upgrade_data_pack, (bcmolt_func_unpack) bcmolt_epon_ni_start_onu_upgrade_data_unpack, bcmolt_epon_ni_start_onu_upgrade_data_scan };
static bcmolt_group_info group_info_epon_onu_10g_us_key = { BCMOLT_OBJ_ID_EPON_ONU_10G_US, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_onu_10g_us_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_onu_10g_us_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_10g_us_key_pack, (bcmolt_func_unpack) bcmolt_epon_onu_10g_us_key_unpack, bcmolt_epon_onu_10g_us_key_scan };
static bcmolt_group_info group_info_epon_onu_10g_us_cfg = { BCMOLT_OBJ_ID_EPON_ONU_10G_US, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_onu_10g_us_cfg_data), sizeof(bcmolt_epon_onu_10g_us_cfg), offsetof(bcmolt_epon_onu_10g_us_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_onu_10g_us_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_10g_us_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_10g_us_cfg_data_unpack, bcmolt_epon_onu_10g_us_cfg_data_scan };
static bcmolt_group_info group_info_epon_onu_10g_us_stat = { BCMOLT_OBJ_ID_EPON_ONU_10G_US, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_epon_onu_10g_us_stat_data), sizeof(bcmolt_epon_onu_10g_us_stat), offsetof(bcmolt_epon_onu_10g_us_stat, data), (bcmolt_func_packed_len) bcmolt_epon_onu_10g_us_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_10g_us_stat_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_10g_us_stat_data_unpack, bcmolt_epon_onu_10g_us_stat_data_scan };
static bcmolt_group_info group_info_epon_onu_10g_us_stat_cfg = { BCMOLT_OBJ_ID_EPON_ONU_10G_US, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_epon_onu_10g_us_stat_cfg_data), sizeof(bcmolt_epon_onu_10g_us_stat_cfg), offsetof(bcmolt_epon_onu_10g_us_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_onu_10g_us_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_10g_us_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_10g_us_stat_cfg_data_unpack, bcmolt_epon_onu_10g_us_stat_cfg_data_scan };
static bcmolt_group_info group_info_epon_onu_10g_us_stat_alarm_cleared = { BCMOLT_OBJ_ID_EPON_ONU_10G_US, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_epon_onu_10g_us_stat_alarm_cleared_data), sizeof(bcmolt_epon_onu_10g_us_stat_alarm_cleared), offsetof(bcmolt_epon_onu_10g_us_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_epon_onu_10g_us_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_10g_us_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_10g_us_stat_alarm_cleared_data_unpack, bcmolt_epon_onu_10g_us_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_epon_onu_10g_us_stat_alarm_raised = { BCMOLT_OBJ_ID_EPON_ONU_10G_US, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_epon_onu_10g_us_stat_alarm_raised_data), sizeof(bcmolt_epon_onu_10g_us_stat_alarm_raised), offsetof(bcmolt_epon_onu_10g_us_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_epon_onu_10g_us_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_10g_us_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_10g_us_stat_alarm_raised_data_unpack, bcmolt_epon_onu_10g_us_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_epon_onu_10g_us_auto_cfg = { BCMOLT_OBJ_ID_EPON_ONU_10G_US, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_epon_onu_10g_us_auto_cfg_data), sizeof(bcmolt_epon_onu_10g_us_auto_cfg), offsetof(bcmolt_epon_onu_10g_us_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_onu_10g_us_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_10g_us_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_10g_us_auto_cfg_data_unpack, bcmolt_epon_onu_10g_us_auto_cfg_data_scan };
static bcmolt_group_info group_info_epon_onu_1g_us_key = { BCMOLT_OBJ_ID_EPON_ONU_1G_US, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_onu_1g_us_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_onu_1g_us_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_1g_us_key_pack, (bcmolt_func_unpack) bcmolt_epon_onu_1g_us_key_unpack, bcmolt_epon_onu_1g_us_key_scan };
static bcmolt_group_info group_info_epon_onu_1g_us_cfg = { BCMOLT_OBJ_ID_EPON_ONU_1G_US, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_onu_1g_us_cfg_data), sizeof(bcmolt_epon_onu_1g_us_cfg), offsetof(bcmolt_epon_onu_1g_us_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_onu_1g_us_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_1g_us_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_1g_us_cfg_data_unpack, bcmolt_epon_onu_1g_us_cfg_data_scan };
static bcmolt_group_info group_info_epon_onu_1g_us_stat = { BCMOLT_OBJ_ID_EPON_ONU_1G_US, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_epon_onu_1g_us_stat_data), sizeof(bcmolt_epon_onu_1g_us_stat), offsetof(bcmolt_epon_onu_1g_us_stat, data), (bcmolt_func_packed_len) bcmolt_epon_onu_1g_us_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_1g_us_stat_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_1g_us_stat_data_unpack, bcmolt_epon_onu_1g_us_stat_data_scan };
static bcmolt_group_info group_info_epon_onu_1g_us_stat_cfg = { BCMOLT_OBJ_ID_EPON_ONU_1G_US, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_epon_onu_1g_us_stat_cfg_data), sizeof(bcmolt_epon_onu_1g_us_stat_cfg), offsetof(bcmolt_epon_onu_1g_us_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_onu_1g_us_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_1g_us_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_1g_us_stat_cfg_data_unpack, bcmolt_epon_onu_1g_us_stat_cfg_data_scan };
static bcmolt_group_info group_info_epon_onu_1g_us_stat_alarm_cleared = { BCMOLT_OBJ_ID_EPON_ONU_1G_US, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_epon_onu_1g_us_stat_alarm_cleared_data), sizeof(bcmolt_epon_onu_1g_us_stat_alarm_cleared), offsetof(bcmolt_epon_onu_1g_us_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_epon_onu_1g_us_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_1g_us_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_1g_us_stat_alarm_cleared_data_unpack, bcmolt_epon_onu_1g_us_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_epon_onu_1g_us_stat_alarm_raised = { BCMOLT_OBJ_ID_EPON_ONU_1G_US, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_epon_onu_1g_us_stat_alarm_raised_data), sizeof(bcmolt_epon_onu_1g_us_stat_alarm_raised), offsetof(bcmolt_epon_onu_1g_us_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_epon_onu_1g_us_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_1g_us_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_1g_us_stat_alarm_raised_data_unpack, bcmolt_epon_onu_1g_us_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_epon_onu_1g_us_auto_cfg = { BCMOLT_OBJ_ID_EPON_ONU_1G_US, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_epon_onu_1g_us_auto_cfg_data), sizeof(bcmolt_epon_onu_1g_us_auto_cfg), offsetof(bcmolt_epon_onu_1g_us_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_onu_1g_us_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_onu_1g_us_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_onu_1g_us_auto_cfg_data_unpack, bcmolt_epon_onu_1g_us_auto_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_10g_ds_key = { BCMOLT_OBJ_ID_EPON_PATH_10G_DS, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_path_10g_ds_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_path_10g_ds_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_ds_key_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_ds_key_unpack, bcmolt_epon_path_10g_ds_key_scan };
static bcmolt_group_info group_info_epon_path_10g_ds_cfg = { BCMOLT_OBJ_ID_EPON_PATH_10G_DS, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_path_10g_ds_cfg_data), sizeof(bcmolt_epon_path_10g_ds_cfg), offsetof(bcmolt_epon_path_10g_ds_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_ds_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_ds_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_ds_cfg_data_unpack, bcmolt_epon_path_10g_ds_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_10g_ds_stat = { BCMOLT_OBJ_ID_EPON_PATH_10G_DS, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_epon_path_10g_ds_stat_data), sizeof(bcmolt_epon_path_10g_ds_stat), offsetof(bcmolt_epon_path_10g_ds_stat, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_ds_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_ds_stat_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_ds_stat_data_unpack, bcmolt_epon_path_10g_ds_stat_data_scan };
static bcmolt_group_info group_info_epon_path_10g_ds_stat_cfg = { BCMOLT_OBJ_ID_EPON_PATH_10G_DS, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_epon_path_10g_ds_stat_cfg_data), sizeof(bcmolt_epon_path_10g_ds_stat_cfg), offsetof(bcmolt_epon_path_10g_ds_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_ds_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_ds_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_ds_stat_cfg_data_unpack, bcmolt_epon_path_10g_ds_stat_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_10g_ds_stat_alarm_cleared = { BCMOLT_OBJ_ID_EPON_PATH_10G_DS, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_epon_path_10g_ds_stat_alarm_cleared_data), sizeof(bcmolt_epon_path_10g_ds_stat_alarm_cleared), offsetof(bcmolt_epon_path_10g_ds_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_ds_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_ds_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_ds_stat_alarm_cleared_data_unpack, bcmolt_epon_path_10g_ds_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_epon_path_10g_ds_stat_alarm_raised = { BCMOLT_OBJ_ID_EPON_PATH_10G_DS, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_epon_path_10g_ds_stat_alarm_raised_data), sizeof(bcmolt_epon_path_10g_ds_stat_alarm_raised), offsetof(bcmolt_epon_path_10g_ds_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_ds_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_ds_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_ds_stat_alarm_raised_data_unpack, bcmolt_epon_path_10g_ds_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_epon_path_10g_ds_auto_cfg = { BCMOLT_OBJ_ID_EPON_PATH_10G_DS, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_epon_path_10g_ds_auto_cfg_data), sizeof(bcmolt_epon_path_10g_ds_auto_cfg), offsetof(bcmolt_epon_path_10g_ds_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_ds_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_ds_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_ds_auto_cfg_data_unpack, bcmolt_epon_path_10g_ds_auto_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_10g_us_key = { BCMOLT_OBJ_ID_EPON_PATH_10G_US, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_path_10g_us_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_path_10g_us_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_us_key_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_us_key_unpack, bcmolt_epon_path_10g_us_key_scan };
static bcmolt_group_info group_info_epon_path_10g_us_cfg = { BCMOLT_OBJ_ID_EPON_PATH_10G_US, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_path_10g_us_cfg_data), sizeof(bcmolt_epon_path_10g_us_cfg), offsetof(bcmolt_epon_path_10g_us_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_us_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_us_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_us_cfg_data_unpack, bcmolt_epon_path_10g_us_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_10g_us_stat = { BCMOLT_OBJ_ID_EPON_PATH_10G_US, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_epon_path_10g_us_stat_data), sizeof(bcmolt_epon_path_10g_us_stat), offsetof(bcmolt_epon_path_10g_us_stat, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_us_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_us_stat_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_us_stat_data_unpack, bcmolt_epon_path_10g_us_stat_data_scan };
static bcmolt_group_info group_info_epon_path_10g_us_stat_cfg = { BCMOLT_OBJ_ID_EPON_PATH_10G_US, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_epon_path_10g_us_stat_cfg_data), sizeof(bcmolt_epon_path_10g_us_stat_cfg), offsetof(bcmolt_epon_path_10g_us_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_us_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_us_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_us_stat_cfg_data_unpack, bcmolt_epon_path_10g_us_stat_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_10g_us_stat_alarm_cleared = { BCMOLT_OBJ_ID_EPON_PATH_10G_US, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_epon_path_10g_us_stat_alarm_cleared_data), sizeof(bcmolt_epon_path_10g_us_stat_alarm_cleared), offsetof(bcmolt_epon_path_10g_us_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_us_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_us_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_us_stat_alarm_cleared_data_unpack, bcmolt_epon_path_10g_us_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_epon_path_10g_us_stat_alarm_raised = { BCMOLT_OBJ_ID_EPON_PATH_10G_US, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_epon_path_10g_us_stat_alarm_raised_data), sizeof(bcmolt_epon_path_10g_us_stat_alarm_raised), offsetof(bcmolt_epon_path_10g_us_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_us_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_us_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_us_stat_alarm_raised_data_unpack, bcmolt_epon_path_10g_us_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_epon_path_10g_us_auto_cfg = { BCMOLT_OBJ_ID_EPON_PATH_10G_US, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_epon_path_10g_us_auto_cfg_data), sizeof(bcmolt_epon_path_10g_us_auto_cfg), offsetof(bcmolt_epon_path_10g_us_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_10g_us_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_10g_us_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_10g_us_auto_cfg_data_unpack, bcmolt_epon_path_10g_us_auto_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_1g_ds_key = { BCMOLT_OBJ_ID_EPON_PATH_1G_DS, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_path_1g_ds_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_path_1g_ds_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_ds_key_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_ds_key_unpack, bcmolt_epon_path_1g_ds_key_scan };
static bcmolt_group_info group_info_epon_path_1g_ds_cfg = { BCMOLT_OBJ_ID_EPON_PATH_1G_DS, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_path_1g_ds_cfg_data), sizeof(bcmolt_epon_path_1g_ds_cfg), offsetof(bcmolt_epon_path_1g_ds_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_ds_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_ds_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_ds_cfg_data_unpack, bcmolt_epon_path_1g_ds_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_1g_ds_stat = { BCMOLT_OBJ_ID_EPON_PATH_1G_DS, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_epon_path_1g_ds_stat_data), sizeof(bcmolt_epon_path_1g_ds_stat), offsetof(bcmolt_epon_path_1g_ds_stat, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_ds_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_ds_stat_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_ds_stat_data_unpack, bcmolt_epon_path_1g_ds_stat_data_scan };
static bcmolt_group_info group_info_epon_path_1g_ds_stat_cfg = { BCMOLT_OBJ_ID_EPON_PATH_1G_DS, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_epon_path_1g_ds_stat_cfg_data), sizeof(bcmolt_epon_path_1g_ds_stat_cfg), offsetof(bcmolt_epon_path_1g_ds_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_ds_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_ds_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_ds_stat_cfg_data_unpack, bcmolt_epon_path_1g_ds_stat_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_1g_ds_stat_alarm_cleared = { BCMOLT_OBJ_ID_EPON_PATH_1G_DS, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_epon_path_1g_ds_stat_alarm_cleared_data), sizeof(bcmolt_epon_path_1g_ds_stat_alarm_cleared), offsetof(bcmolt_epon_path_1g_ds_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_ds_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_ds_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_ds_stat_alarm_cleared_data_unpack, bcmolt_epon_path_1g_ds_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_epon_path_1g_ds_stat_alarm_raised = { BCMOLT_OBJ_ID_EPON_PATH_1G_DS, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_epon_path_1g_ds_stat_alarm_raised_data), sizeof(bcmolt_epon_path_1g_ds_stat_alarm_raised), offsetof(bcmolt_epon_path_1g_ds_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_ds_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_ds_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_ds_stat_alarm_raised_data_unpack, bcmolt_epon_path_1g_ds_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_epon_path_1g_ds_auto_cfg = { BCMOLT_OBJ_ID_EPON_PATH_1G_DS, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_epon_path_1g_ds_auto_cfg_data), sizeof(bcmolt_epon_path_1g_ds_auto_cfg), offsetof(bcmolt_epon_path_1g_ds_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_ds_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_ds_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_ds_auto_cfg_data_unpack, bcmolt_epon_path_1g_ds_auto_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_1g_us_key = { BCMOLT_OBJ_ID_EPON_PATH_1G_US, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_path_1g_us_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_path_1g_us_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_us_key_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_us_key_unpack, bcmolt_epon_path_1g_us_key_scan };
static bcmolt_group_info group_info_epon_path_1g_us_cfg = { BCMOLT_OBJ_ID_EPON_PATH_1G_US, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_path_1g_us_cfg_data), sizeof(bcmolt_epon_path_1g_us_cfg), offsetof(bcmolt_epon_path_1g_us_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_us_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_us_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_us_cfg_data_unpack, bcmolt_epon_path_1g_us_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_1g_us_stat = { BCMOLT_OBJ_ID_EPON_PATH_1G_US, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_epon_path_1g_us_stat_data), sizeof(bcmolt_epon_path_1g_us_stat), offsetof(bcmolt_epon_path_1g_us_stat, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_us_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_us_stat_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_us_stat_data_unpack, bcmolt_epon_path_1g_us_stat_data_scan };
static bcmolt_group_info group_info_epon_path_1g_us_stat_cfg = { BCMOLT_OBJ_ID_EPON_PATH_1G_US, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_epon_path_1g_us_stat_cfg_data), sizeof(bcmolt_epon_path_1g_us_stat_cfg), offsetof(bcmolt_epon_path_1g_us_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_us_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_us_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_us_stat_cfg_data_unpack, bcmolt_epon_path_1g_us_stat_cfg_data_scan };
static bcmolt_group_info group_info_epon_path_1g_us_stat_alarm_cleared = { BCMOLT_OBJ_ID_EPON_PATH_1G_US, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_epon_path_1g_us_stat_alarm_cleared_data), sizeof(bcmolt_epon_path_1g_us_stat_alarm_cleared), offsetof(bcmolt_epon_path_1g_us_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_us_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_us_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_us_stat_alarm_cleared_data_unpack, bcmolt_epon_path_1g_us_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_epon_path_1g_us_stat_alarm_raised = { BCMOLT_OBJ_ID_EPON_PATH_1G_US, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_epon_path_1g_us_stat_alarm_raised_data), sizeof(bcmolt_epon_path_1g_us_stat_alarm_raised), offsetof(bcmolt_epon_path_1g_us_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_us_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_us_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_us_stat_alarm_raised_data_unpack, bcmolt_epon_path_1g_us_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_epon_path_1g_us_auto_cfg = { BCMOLT_OBJ_ID_EPON_PATH_1G_US, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_epon_path_1g_us_auto_cfg_data), sizeof(bcmolt_epon_path_1g_us_auto_cfg), offsetof(bcmolt_epon_path_1g_us_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_path_1g_us_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_path_1g_us_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_path_1g_us_auto_cfg_data_unpack, bcmolt_epon_path_1g_us_auto_cfg_data_scan };
static bcmolt_group_info group_info_epon_rp_key = { BCMOLT_OBJ_ID_EPON_RP, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_epon_rp_key), 0, 0, (bcmolt_func_packed_len) bcmolt_epon_rp_key_get_packed_length, (bcmolt_func_pack) bcmolt_epon_rp_key_pack, (bcmolt_func_unpack) bcmolt_epon_rp_key_unpack, bcmolt_epon_rp_key_scan };
static bcmolt_group_info group_info_epon_rp_cfg = { BCMOLT_OBJ_ID_EPON_RP, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_epon_rp_cfg_data), sizeof(bcmolt_epon_rp_cfg), offsetof(bcmolt_epon_rp_cfg, data), (bcmolt_func_packed_len) bcmolt_epon_rp_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_epon_rp_cfg_data_pack, (bcmolt_func_unpack) bcmolt_epon_rp_cfg_data_unpack, bcmolt_epon_rp_cfg_data_scan };
static bcmolt_group_info group_info_gpio_key = { BCMOLT_OBJ_ID_GPIO, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpio_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpio_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpio_key_pack, (bcmolt_func_unpack) bcmolt_gpio_key_unpack, bcmolt_gpio_key_scan };
static bcmolt_group_info group_info_gpio_cfg = { BCMOLT_OBJ_ID_GPIO, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpio_cfg_data), sizeof(bcmolt_gpio_cfg), offsetof(bcmolt_gpio_cfg, data), (bcmolt_func_packed_len) bcmolt_gpio_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpio_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpio_cfg_data_unpack, bcmolt_gpio_cfg_data_scan };
static bcmolt_group_info group_info_gpon_alloc_key = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_alloc_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_alloc_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_key_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_key_unpack, bcmolt_gpon_alloc_key_scan };
static bcmolt_group_info group_info_gpon_alloc_cfg = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_alloc_cfg_data), sizeof(bcmolt_gpon_alloc_cfg), offsetof(bcmolt_gpon_alloc_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_cfg_data_unpack, bcmolt_gpon_alloc_cfg_data_scan };
static bcmolt_group_info group_info_gpon_alloc_stat = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_gpon_alloc_stat_data), sizeof(bcmolt_gpon_alloc_stat), offsetof(bcmolt_gpon_alloc_stat, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_stat_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_stat_data_unpack, bcmolt_gpon_alloc_stat_data_scan };
static bcmolt_group_info group_info_gpon_alloc_stat_cfg = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_gpon_alloc_stat_cfg_data), sizeof(bcmolt_gpon_alloc_stat_cfg), offsetof(bcmolt_gpon_alloc_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_stat_cfg_data_unpack, bcmolt_gpon_alloc_stat_cfg_data_scan };
static bcmolt_group_info group_info_gpon_alloc_configuration_completed = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_gpon_alloc_configuration_completed_data), sizeof(bcmolt_gpon_alloc_configuration_completed), offsetof(bcmolt_gpon_alloc_configuration_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_configuration_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_configuration_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_configuration_completed_data_unpack, bcmolt_gpon_alloc_configuration_completed_data_scan };
static bcmolt_group_info group_info_gpon_alloc_get_alloc_stats_completed = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_gpon_alloc_get_alloc_stats_completed_data), sizeof(bcmolt_gpon_alloc_get_alloc_stats_completed), offsetof(bcmolt_gpon_alloc_get_alloc_stats_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_get_alloc_stats_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_get_alloc_stats_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_get_alloc_stats_completed_data_unpack, bcmolt_gpon_alloc_get_alloc_stats_completed_data_scan };
static bcmolt_group_info group_info_gpon_alloc_stat_alarm_cleared = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_gpon_alloc_stat_alarm_cleared_data), sizeof(bcmolt_gpon_alloc_stat_alarm_cleared), offsetof(bcmolt_gpon_alloc_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_stat_alarm_cleared_data_unpack, bcmolt_gpon_alloc_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_gpon_alloc_stat_alarm_raised = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_AUTO, 3, sizeof(bcmolt_gpon_alloc_stat_alarm_raised_data), sizeof(bcmolt_gpon_alloc_stat_alarm_raised), offsetof(bcmolt_gpon_alloc_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_stat_alarm_raised_data_unpack, bcmolt_gpon_alloc_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_gpon_alloc_auto_cfg = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_gpon_alloc_auto_cfg_data), sizeof(bcmolt_gpon_alloc_auto_cfg), offsetof(bcmolt_gpon_alloc_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_auto_cfg_data_unpack, bcmolt_gpon_alloc_auto_cfg_data_scan };
static bcmolt_group_info group_info_gpon_alloc_get_stats = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_gpon_alloc_get_stats_data), sizeof(bcmolt_gpon_alloc_get_stats), offsetof(bcmolt_gpon_alloc_get_stats, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_get_stats_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_get_stats_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_get_stats_data_unpack, bcmolt_gpon_alloc_get_stats_data_scan };
static bcmolt_group_info group_info_gpon_alloc_set_state = { BCMOLT_OBJ_ID_GPON_ALLOC, BCMOLT_MGT_GROUP_OPER, 1, sizeof(bcmolt_gpon_alloc_set_state_data), sizeof(bcmolt_gpon_alloc_set_state), offsetof(bcmolt_gpon_alloc_set_state, data), (bcmolt_func_packed_len) bcmolt_gpon_alloc_set_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_alloc_set_state_data_pack, (bcmolt_func_unpack) bcmolt_gpon_alloc_set_state_data_unpack, bcmolt_gpon_alloc_set_state_data_scan };
static bcmolt_group_info group_info_gpon_gem_port_key = { BCMOLT_OBJ_ID_GPON_GEM_PORT, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_gem_port_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_gem_port_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_gem_port_key_pack, (bcmolt_func_unpack) bcmolt_gpon_gem_port_key_unpack, bcmolt_gpon_gem_port_key_scan };
static bcmolt_group_info group_info_gpon_gem_port_cfg = { BCMOLT_OBJ_ID_GPON_GEM_PORT, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_gem_port_cfg_data), sizeof(bcmolt_gpon_gem_port_cfg), offsetof(bcmolt_gpon_gem_port_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_gem_port_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_gem_port_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_gem_port_cfg_data_unpack, bcmolt_gpon_gem_port_cfg_data_scan };
static bcmolt_group_info group_info_gpon_gem_port_stat = { BCMOLT_OBJ_ID_GPON_GEM_PORT, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_gpon_gem_port_stat_data), sizeof(bcmolt_gpon_gem_port_stat), offsetof(bcmolt_gpon_gem_port_stat, data), (bcmolt_func_packed_len) bcmolt_gpon_gem_port_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_gem_port_stat_data_pack, (bcmolt_func_unpack) bcmolt_gpon_gem_port_stat_data_unpack, bcmolt_gpon_gem_port_stat_data_scan };
static bcmolt_group_info group_info_gpon_gem_port_stat_cfg = { BCMOLT_OBJ_ID_GPON_GEM_PORT, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_gpon_gem_port_stat_cfg_data), sizeof(bcmolt_gpon_gem_port_stat_cfg), offsetof(bcmolt_gpon_gem_port_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_gem_port_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_gem_port_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_gem_port_stat_cfg_data_unpack, bcmolt_gpon_gem_port_stat_cfg_data_scan };
static bcmolt_group_info group_info_gpon_gem_port_configuration_completed = { BCMOLT_OBJ_ID_GPON_GEM_PORT, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_gpon_gem_port_configuration_completed_data), sizeof(bcmolt_gpon_gem_port_configuration_completed), offsetof(bcmolt_gpon_gem_port_configuration_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_gem_port_configuration_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_gem_port_configuration_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_gem_port_configuration_completed_data_unpack, bcmolt_gpon_gem_port_configuration_completed_data_scan };
static bcmolt_group_info group_info_gpon_gem_port_stat_alarm_cleared = { BCMOLT_OBJ_ID_GPON_GEM_PORT, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_gpon_gem_port_stat_alarm_cleared_data), sizeof(bcmolt_gpon_gem_port_stat_alarm_cleared), offsetof(bcmolt_gpon_gem_port_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_gpon_gem_port_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_gem_port_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_gpon_gem_port_stat_alarm_cleared_data_unpack, bcmolt_gpon_gem_port_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_gpon_gem_port_stat_alarm_raised = { BCMOLT_OBJ_ID_GPON_GEM_PORT, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_gpon_gem_port_stat_alarm_raised_data), sizeof(bcmolt_gpon_gem_port_stat_alarm_raised), offsetof(bcmolt_gpon_gem_port_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_gpon_gem_port_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_gem_port_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_gpon_gem_port_stat_alarm_raised_data_unpack, bcmolt_gpon_gem_port_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_gpon_gem_port_auto_cfg = { BCMOLT_OBJ_ID_GPON_GEM_PORT, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_gpon_gem_port_auto_cfg_data), sizeof(bcmolt_gpon_gem_port_auto_cfg), offsetof(bcmolt_gpon_gem_port_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_gem_port_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_gem_port_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_gem_port_auto_cfg_data_unpack, bcmolt_gpon_gem_port_auto_cfg_data_scan };
static bcmolt_group_info group_info_gpon_gem_port_set_state = { BCMOLT_OBJ_ID_GPON_GEM_PORT, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_gpon_gem_port_set_state_data), sizeof(bcmolt_gpon_gem_port_set_state), offsetof(bcmolt_gpon_gem_port_set_state, data), (bcmolt_func_packed_len) bcmolt_gpon_gem_port_set_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_gem_port_set_state_data_pack, (bcmolt_func_unpack) bcmolt_gpon_gem_port_set_state_data_unpack, bcmolt_gpon_gem_port_set_state_data_scan };
static bcmolt_group_info group_info_gpon_iwf_key = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_iwf_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_iwf_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_key_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_key_unpack, bcmolt_gpon_iwf_key_scan };
static bcmolt_group_info group_info_gpon_iwf_cfg = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_iwf_cfg_data), sizeof(bcmolt_gpon_iwf_cfg), offsetof(bcmolt_gpon_iwf_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_cfg_data_unpack, bcmolt_gpon_iwf_cfg_data_scan };
static bcmolt_group_info group_info_gpon_iwf_stat = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_gpon_iwf_stat_data), sizeof(bcmolt_gpon_iwf_stat), offsetof(bcmolt_gpon_iwf_stat, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_stat_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_stat_data_unpack, bcmolt_gpon_iwf_stat_data_scan };
static bcmolt_group_info group_info_gpon_iwf_stat_cfg = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_gpon_iwf_stat_cfg_data), sizeof(bcmolt_gpon_iwf_stat_cfg), offsetof(bcmolt_gpon_iwf_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_stat_cfg_data_unpack, bcmolt_gpon_iwf_stat_cfg_data_scan };
static bcmolt_group_info group_info_gpon_iwf_flush_mac_table_completed = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_AUTO, 0, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_iwf_scan_mac_table_completed = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_gpon_iwf_scan_mac_table_completed_data), sizeof(bcmolt_gpon_iwf_scan_mac_table_completed), offsetof(bcmolt_gpon_iwf_scan_mac_table_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_scan_mac_table_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_scan_mac_table_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_scan_mac_table_completed_data_unpack, bcmolt_gpon_iwf_scan_mac_table_completed_data_scan };
static bcmolt_group_info group_info_gpon_iwf_stat_alarm_cleared = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_gpon_iwf_stat_alarm_cleared_data), sizeof(bcmolt_gpon_iwf_stat_alarm_cleared), offsetof(bcmolt_gpon_iwf_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_stat_alarm_cleared_data_unpack, bcmolt_gpon_iwf_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_gpon_iwf_stat_alarm_raised = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_AUTO, 3, sizeof(bcmolt_gpon_iwf_stat_alarm_raised_data), sizeof(bcmolt_gpon_iwf_stat_alarm_raised), offsetof(bcmolt_gpon_iwf_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_stat_alarm_raised_data_unpack, bcmolt_gpon_iwf_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_gpon_iwf_auto_cfg = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_gpon_iwf_auto_cfg_data), sizeof(bcmolt_gpon_iwf_auto_cfg), offsetof(bcmolt_gpon_iwf_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_auto_cfg_data_unpack, bcmolt_gpon_iwf_auto_cfg_data_scan };
static bcmolt_group_info group_info_gpon_iwf_flush_mac_table = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_gpon_iwf_flush_mac_table_data), sizeof(bcmolt_gpon_iwf_flush_mac_table), offsetof(bcmolt_gpon_iwf_flush_mac_table, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_flush_mac_table_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_flush_mac_table_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_flush_mac_table_data_unpack, bcmolt_gpon_iwf_flush_mac_table_data_scan };
static bcmolt_group_info group_info_gpon_iwf_scan_mac_table = { BCMOLT_OBJ_ID_GPON_IWF, BCMOLT_MGT_GROUP_OPER, 1, sizeof(bcmolt_gpon_iwf_scan_mac_table_data), sizeof(bcmolt_gpon_iwf_scan_mac_table), offsetof(bcmolt_gpon_iwf_scan_mac_table, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_scan_mac_table_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_scan_mac_table_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_scan_mac_table_data_unpack, bcmolt_gpon_iwf_scan_mac_table_data_scan };
static bcmolt_group_info group_info_gpon_iwf_ds_egress_flow_key = { BCMOLT_OBJ_ID_GPON_IWF_DS_EGRESS_FLOW, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_iwf_ds_egress_flow_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_iwf_ds_egress_flow_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_ds_egress_flow_key_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_ds_egress_flow_key_unpack, bcmolt_gpon_iwf_ds_egress_flow_key_scan };
static bcmolt_group_info group_info_gpon_iwf_ds_egress_flow_cfg = { BCMOLT_OBJ_ID_GPON_IWF_DS_EGRESS_FLOW, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_iwf_ds_egress_flow_cfg_data), sizeof(bcmolt_gpon_iwf_ds_egress_flow_cfg), offsetof(bcmolt_gpon_iwf_ds_egress_flow_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_ds_egress_flow_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_ds_egress_flow_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_ds_egress_flow_cfg_data_unpack, bcmolt_gpon_iwf_ds_egress_flow_cfg_data_scan };
static bcmolt_group_info group_info_gpon_iwf_ds_ingress_flow_key = { BCMOLT_OBJ_ID_GPON_IWF_DS_INGRESS_FLOW, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_iwf_ds_ingress_flow_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_iwf_ds_ingress_flow_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_ds_ingress_flow_key_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_ds_ingress_flow_key_unpack, bcmolt_gpon_iwf_ds_ingress_flow_key_scan };
static bcmolt_group_info group_info_gpon_iwf_ds_ingress_flow_cfg = { BCMOLT_OBJ_ID_GPON_IWF_DS_INGRESS_FLOW, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_iwf_ds_ingress_flow_cfg_data), sizeof(bcmolt_gpon_iwf_ds_ingress_flow_cfg), offsetof(bcmolt_gpon_iwf_ds_ingress_flow_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_ds_ingress_flow_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_ds_ingress_flow_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_ds_ingress_flow_cfg_data_unpack, bcmolt_gpon_iwf_ds_ingress_flow_cfg_data_scan };
static bcmolt_group_info group_info_gpon_iwf_mac_table_key = { BCMOLT_OBJ_ID_GPON_IWF_MAC_TABLE, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_iwf_mac_table_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_iwf_mac_table_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_mac_table_key_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_mac_table_key_unpack, bcmolt_gpon_iwf_mac_table_key_scan };
static bcmolt_group_info group_info_gpon_iwf_mac_table_cfg = { BCMOLT_OBJ_ID_GPON_IWF_MAC_TABLE, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_iwf_mac_table_cfg_data), sizeof(bcmolt_gpon_iwf_mac_table_cfg), offsetof(bcmolt_gpon_iwf_mac_table_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_mac_table_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_mac_table_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_mac_table_cfg_data_unpack, bcmolt_gpon_iwf_mac_table_cfg_data_scan };
static bcmolt_group_info group_info_gpon_iwf_mac_table_mac_aged = { BCMOLT_OBJ_ID_GPON_IWF_MAC_TABLE, BCMOLT_MGT_GROUP_AUTO, 0, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_iwf_mac_table_mac_dropped = { BCMOLT_OBJ_ID_GPON_IWF_MAC_TABLE, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_gpon_iwf_mac_table_mac_dropped_data), sizeof(bcmolt_gpon_iwf_mac_table_mac_dropped), offsetof(bcmolt_gpon_iwf_mac_table_mac_dropped, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_mac_table_mac_dropped_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_mac_table_mac_dropped_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_mac_table_mac_dropped_data_unpack, bcmolt_gpon_iwf_mac_table_mac_dropped_data_scan };
static bcmolt_group_info group_info_gpon_iwf_mac_table_mac_move = { BCMOLT_OBJ_ID_GPON_IWF_MAC_TABLE, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_gpon_iwf_mac_table_mac_move_data), sizeof(bcmolt_gpon_iwf_mac_table_mac_move), offsetof(bcmolt_gpon_iwf_mac_table_mac_move, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_mac_table_mac_move_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_mac_table_mac_move_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_mac_table_mac_move_data_unpack, bcmolt_gpon_iwf_mac_table_mac_move_data_scan };
static bcmolt_group_info group_info_gpon_iwf_mac_table_new_mac = { BCMOLT_OBJ_ID_GPON_IWF_MAC_TABLE, BCMOLT_MGT_GROUP_AUTO, 3, sizeof(bcmolt_gpon_iwf_mac_table_new_mac_data), sizeof(bcmolt_gpon_iwf_mac_table_new_mac), offsetof(bcmolt_gpon_iwf_mac_table_new_mac, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_mac_table_new_mac_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_mac_table_new_mac_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_mac_table_new_mac_data_unpack, bcmolt_gpon_iwf_mac_table_new_mac_data_scan };
static bcmolt_group_info group_info_gpon_iwf_mac_table_auto_cfg = { BCMOLT_OBJ_ID_GPON_IWF_MAC_TABLE, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_gpon_iwf_mac_table_auto_cfg_data), sizeof(bcmolt_gpon_iwf_mac_table_auto_cfg), offsetof(bcmolt_gpon_iwf_mac_table_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_mac_table_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_mac_table_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_mac_table_auto_cfg_data_unpack, bcmolt_gpon_iwf_mac_table_auto_cfg_data_scan };
static bcmolt_group_info group_info_gpon_iwf_us_flow_key = { BCMOLT_OBJ_ID_GPON_IWF_US_FLOW, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_iwf_us_flow_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_iwf_us_flow_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_us_flow_key_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_us_flow_key_unpack, bcmolt_gpon_iwf_us_flow_key_scan };
static bcmolt_group_info group_info_gpon_iwf_us_flow_cfg = { BCMOLT_OBJ_ID_GPON_IWF_US_FLOW, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_iwf_us_flow_cfg_data), sizeof(bcmolt_gpon_iwf_us_flow_cfg), offsetof(bcmolt_gpon_iwf_us_flow_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_iwf_us_flow_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_iwf_us_flow_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_iwf_us_flow_cfg_data_unpack, bcmolt_gpon_iwf_us_flow_cfg_data_scan };
static bcmolt_group_info group_info_gpon_ni_key = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_ni_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_ni_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_key_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_key_unpack, bcmolt_gpon_ni_key_scan };
static bcmolt_group_info group_info_gpon_ni_cfg = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_ni_cfg_data), sizeof(bcmolt_gpon_ni_cfg), offsetof(bcmolt_gpon_ni_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_cfg_data_unpack, bcmolt_gpon_ni_cfg_data_scan };
static bcmolt_group_info group_info_gpon_ni_stat = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_gpon_ni_stat_data), sizeof(bcmolt_gpon_ni_stat), offsetof(bcmolt_gpon_ni_stat, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_stat_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_stat_data_unpack, bcmolt_gpon_ni_stat_data_scan };
static bcmolt_group_info group_info_gpon_ni_stat_cfg = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_gpon_ni_stat_cfg_data), sizeof(bcmolt_gpon_ni_stat_cfg), offsetof(bcmolt_gpon_ni_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_stat_cfg_data_unpack, bcmolt_gpon_ni_stat_cfg_data_scan };
static bcmolt_group_info group_info_gpon_ni_activate_all_onus_completed = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 0, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_ni_cpu_packets_failure = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_gpon_ni_cpu_packets_failure_data), sizeof(bcmolt_gpon_ni_cpu_packets_failure), offsetof(bcmolt_gpon_ni_cpu_packets_failure, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_cpu_packets_failure_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_cpu_packets_failure_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_cpu_packets_failure_data_unpack, bcmolt_gpon_ni_cpu_packets_failure_data_scan };
static bcmolt_group_info group_info_gpon_ni_deactivate_all_onus_completed = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 2, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_ni_disable_all_onus_completed = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 3, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_ni_enable_all_onus_completed = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 4, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_ni_los = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 5, sizeof(bcmolt_gpon_ni_los_data), sizeof(bcmolt_gpon_ni_los), offsetof(bcmolt_gpon_ni_los, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_los_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_los_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_los_data_unpack, bcmolt_gpon_ni_los_data_scan };
static bcmolt_group_info group_info_gpon_ni_onu_discovered = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 6, sizeof(bcmolt_gpon_ni_onu_discovered_data), sizeof(bcmolt_gpon_ni_onu_discovered), offsetof(bcmolt_gpon_ni_onu_discovered, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_onu_discovered_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_onu_discovered_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_onu_discovered_data_unpack, bcmolt_gpon_ni_onu_discovered_data_scan };
static bcmolt_group_info group_info_gpon_ni_onu_upgrade_complete = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 7, sizeof(bcmolt_gpon_ni_onu_upgrade_complete_data), sizeof(bcmolt_gpon_ni_onu_upgrade_complete), offsetof(bcmolt_gpon_ni_onu_upgrade_complete, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_onu_upgrade_complete_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_onu_upgrade_complete_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_onu_upgrade_complete_data_unpack, bcmolt_gpon_ni_onu_upgrade_complete_data_scan };
static bcmolt_group_info group_info_gpon_ni_protection_switching_onus_ranged = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 8, sizeof(bcmolt_gpon_ni_protection_switching_onus_ranged_data), sizeof(bcmolt_gpon_ni_protection_switching_onus_ranged), offsetof(bcmolt_gpon_ni_protection_switching_onus_ranged, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_protection_switching_onus_ranged_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_protection_switching_onus_ranged_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_protection_switching_onus_ranged_data_unpack, bcmolt_gpon_ni_protection_switching_onus_ranged_data_scan };
static bcmolt_group_info group_info_gpon_ni_protection_switching_switchover_completed = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 9, sizeof(bcmolt_gpon_ni_protection_switching_switchover_completed_data), sizeof(bcmolt_gpon_ni_protection_switching_switchover_completed), offsetof(bcmolt_gpon_ni_protection_switching_switchover_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_protection_switching_switchover_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_protection_switching_switchover_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_protection_switching_switchover_completed_data_unpack, bcmolt_gpon_ni_protection_switching_switchover_completed_data_scan };
static bcmolt_group_info group_info_gpon_ni_protection_switching_traffic_resume = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 10, sizeof(bcmolt_gpon_ni_protection_switching_traffic_resume_data), sizeof(bcmolt_gpon_ni_protection_switching_traffic_resume), offsetof(bcmolt_gpon_ni_protection_switching_traffic_resume, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_protection_switching_traffic_resume_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_protection_switching_traffic_resume_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_protection_switching_traffic_resume_data_unpack, bcmolt_gpon_ni_protection_switching_traffic_resume_data_scan };
static bcmolt_group_info group_info_gpon_ni_rogue_detection_completed = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 11, sizeof(bcmolt_gpon_ni_rogue_detection_completed_data), sizeof(bcmolt_gpon_ni_rogue_detection_completed), offsetof(bcmolt_gpon_ni_rogue_detection_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_rogue_detection_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_rogue_detection_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_rogue_detection_completed_data_unpack, bcmolt_gpon_ni_rogue_detection_completed_data_scan };
static bcmolt_group_info group_info_gpon_ni_rogue_onu_special_map_cycle_start = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 12, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_ni_serial_number_acquisition_cycle_start = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 13, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_ni_standby_pon_monitoring_cycle_completed = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 14, sizeof(bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_data), sizeof(bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed), offsetof(bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_data_unpack, bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_data_scan };
static bcmolt_group_info group_info_gpon_ni_stat_alarm_cleared = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 15, sizeof(bcmolt_gpon_ni_stat_alarm_cleared_data), sizeof(bcmolt_gpon_ni_stat_alarm_cleared), offsetof(bcmolt_gpon_ni_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_stat_alarm_cleared_data_unpack, bcmolt_gpon_ni_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_gpon_ni_stat_alarm_raised = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 16, sizeof(bcmolt_gpon_ni_stat_alarm_raised_data), sizeof(bcmolt_gpon_ni_stat_alarm_raised), offsetof(bcmolt_gpon_ni_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_stat_alarm_raised_data_unpack, bcmolt_gpon_ni_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_gpon_ni_state_change_completed = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 17, sizeof(bcmolt_gpon_ni_state_change_completed_data), sizeof(bcmolt_gpon_ni_state_change_completed), offsetof(bcmolt_gpon_ni_state_change_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_state_change_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_state_change_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_state_change_completed_data_unpack, bcmolt_gpon_ni_state_change_completed_data_scan };
static bcmolt_group_info group_info_gpon_ni_tod_request_completed = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO, 18, sizeof(bcmolt_gpon_ni_tod_request_completed_data), sizeof(bcmolt_gpon_ni_tod_request_completed), offsetof(bcmolt_gpon_ni_tod_request_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_tod_request_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_tod_request_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_tod_request_completed_data_unpack, bcmolt_gpon_ni_tod_request_completed_data_scan };
static bcmolt_group_info group_info_gpon_ni_auto_cfg = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_gpon_ni_auto_cfg_data), sizeof(bcmolt_gpon_ni_auto_cfg), offsetof(bcmolt_gpon_ni_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_auto_cfg_data_unpack, bcmolt_gpon_ni_auto_cfg_data_scan };
static bcmolt_group_info group_info_gpon_ni_disable_serial_number = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_gpon_ni_disable_serial_number_data), sizeof(bcmolt_gpon_ni_disable_serial_number), offsetof(bcmolt_gpon_ni_disable_serial_number, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_disable_serial_number_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_disable_serial_number_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_disable_serial_number_data_unpack, bcmolt_gpon_ni_disable_serial_number_data_scan };
static bcmolt_group_info group_info_gpon_ni_protection_switching_type_c_set_multiple_onu_state = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_OPER, 1, sizeof(bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_data), sizeof(bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state), offsetof(bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_data_unpack, bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_data_scan };
static bcmolt_group_info group_info_gpon_ni_reset = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_OPER, 2, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_ni_rogue_detection_window = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_OPER, 3, sizeof(bcmolt_gpon_ni_rogue_detection_window_data), sizeof(bcmolt_gpon_ni_rogue_detection_window), offsetof(bcmolt_gpon_ni_rogue_detection_window, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_rogue_detection_window_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_rogue_detection_window_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_rogue_detection_window_data_unpack, bcmolt_gpon_ni_rogue_detection_window_data_scan };
static bcmolt_group_info group_info_gpon_ni_set_onu_state = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_OPER, 4, sizeof(bcmolt_gpon_ni_set_onu_state_data), sizeof(bcmolt_gpon_ni_set_onu_state), offsetof(bcmolt_gpon_ni_set_onu_state, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_set_onu_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_set_onu_state_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_set_onu_state_data_unpack, bcmolt_gpon_ni_set_onu_state_data_scan };
static bcmolt_group_info group_info_gpon_ni_set_pon_state = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_OPER, 5, sizeof(bcmolt_gpon_ni_set_pon_state_data), sizeof(bcmolt_gpon_ni_set_pon_state), offsetof(bcmolt_gpon_ni_set_pon_state, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_set_pon_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_set_pon_state_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_set_pon_state_data_unpack, bcmolt_gpon_ni_set_pon_state_data_scan };
static bcmolt_group_info group_info_gpon_ni_single_request_standby_pon_monitoring = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_OPER, 6, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_ni_start_onu_upgrade = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_OPER, 7, sizeof(bcmolt_gpon_ni_start_onu_upgrade_data), sizeof(bcmolt_gpon_ni_start_onu_upgrade), offsetof(bcmolt_gpon_ni_start_onu_upgrade, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_start_onu_upgrade_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_start_onu_upgrade_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_start_onu_upgrade_data_unpack, bcmolt_gpon_ni_start_onu_upgrade_data_scan };
static bcmolt_group_info group_info_gpon_ni_tod_request = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_OPER, 8, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_ni_broadcast_ploam_packet = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_PROXY, 0, sizeof(bcmolt_gpon_ni_broadcast_ploam_packet_data), sizeof(bcmolt_gpon_ni_broadcast_ploam_packet), offsetof(bcmolt_gpon_ni_broadcast_ploam_packet, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_broadcast_ploam_packet_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_broadcast_ploam_packet_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_broadcast_ploam_packet_data_unpack, bcmolt_gpon_ni_broadcast_ploam_packet_data_scan };
static bcmolt_group_info group_info_gpon_ni_cpu_packets = { BCMOLT_OBJ_ID_GPON_NI, BCMOLT_MGT_GROUP_PROXY, 1, sizeof(bcmolt_gpon_ni_cpu_packets_data), sizeof(bcmolt_gpon_ni_cpu_packets), offsetof(bcmolt_gpon_ni_cpu_packets, data), (bcmolt_func_packed_len) bcmolt_gpon_ni_cpu_packets_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_ni_cpu_packets_data_pack, (bcmolt_func_unpack) bcmolt_gpon_ni_cpu_packets_data_unpack, bcmolt_gpon_ni_cpu_packets_data_scan };
static bcmolt_group_info group_info_gpon_onu_key = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_onu_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_onu_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_key_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_key_unpack, bcmolt_gpon_onu_key_scan };
static bcmolt_group_info group_info_gpon_onu_cfg = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_onu_cfg_data), sizeof(bcmolt_gpon_onu_cfg), offsetof(bcmolt_gpon_onu_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_cfg_data_unpack, bcmolt_gpon_onu_cfg_data_scan };
static bcmolt_group_info group_info_gpon_onu_stat = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_gpon_onu_stat_data), sizeof(bcmolt_gpon_onu_stat), offsetof(bcmolt_gpon_onu_stat, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_stat_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_stat_data_unpack, bcmolt_gpon_onu_stat_data_scan };
static bcmolt_group_info group_info_gpon_onu_stat_cfg = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_gpon_onu_stat_cfg_data), sizeof(bcmolt_gpon_onu_stat_cfg), offsetof(bcmolt_gpon_onu_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_stat_cfg_data_unpack, bcmolt_gpon_onu_stat_cfg_data_scan };
static bcmolt_group_info group_info_gpon_onu_ber_interval_configuration_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_gpon_onu_ber_interval_configuration_completed_data), sizeof(bcmolt_gpon_onu_ber_interval_configuration_completed), offsetof(bcmolt_gpon_onu_ber_interval_configuration_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_ber_interval_configuration_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_ber_interval_configuration_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_ber_interval_configuration_completed_data_unpack, bcmolt_gpon_onu_ber_interval_configuration_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_dfi = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_gpon_onu_dfi_data), sizeof(bcmolt_gpon_onu_dfi), offsetof(bcmolt_gpon_onu_dfi, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_dfi_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_dfi_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_dfi_data_unpack, bcmolt_gpon_onu_dfi_data_scan };
static bcmolt_group_info group_info_gpon_onu_dgi = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_gpon_onu_dgi_data), sizeof(bcmolt_gpon_onu_dgi), offsetof(bcmolt_gpon_onu_dgi, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_dgi_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_dgi_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_dgi_data_unpack, bcmolt_gpon_onu_dgi_data_scan };
static bcmolt_group_info group_info_gpon_onu_dowi = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 3, sizeof(bcmolt_gpon_onu_dowi_data), sizeof(bcmolt_gpon_onu_dowi), offsetof(bcmolt_gpon_onu_dowi, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_dowi_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_dowi_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_dowi_data_unpack, bcmolt_gpon_onu_dowi_data_scan };
static bcmolt_group_info group_info_gpon_onu_err = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 4, sizeof(bcmolt_gpon_onu_err_data), sizeof(bcmolt_gpon_onu_err), offsetof(bcmolt_gpon_onu_err, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_err_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_err_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_err_data_unpack, bcmolt_gpon_onu_err_data_scan };
static bcmolt_group_info group_info_gpon_onu_invalid_dbru_report = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 5, sizeof(bcmolt_gpon_onu_invalid_dbru_report_data), sizeof(bcmolt_gpon_onu_invalid_dbru_report), offsetof(bcmolt_gpon_onu_invalid_dbru_report, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_invalid_dbru_report_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_invalid_dbru_report_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_invalid_dbru_report_data_unpack, bcmolt_gpon_onu_invalid_dbru_report_data_scan };
static bcmolt_group_info group_info_gpon_onu_key_exchange_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 6, sizeof(bcmolt_gpon_onu_key_exchange_completed_data), sizeof(bcmolt_gpon_onu_key_exchange_completed), offsetof(bcmolt_gpon_onu_key_exchange_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_key_exchange_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_key_exchange_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_key_exchange_completed_data_unpack, bcmolt_gpon_onu_key_exchange_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_key_exchange_cycle_skipped = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 7, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_onu_key_exchange_decrypt_required = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 8, sizeof(bcmolt_gpon_onu_key_exchange_decrypt_required_data), sizeof(bcmolt_gpon_onu_key_exchange_decrypt_required), offsetof(bcmolt_gpon_onu_key_exchange_decrypt_required, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_key_exchange_decrypt_required_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_key_exchange_decrypt_required_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_key_exchange_decrypt_required_data_unpack, bcmolt_gpon_onu_key_exchange_decrypt_required_data_scan };
static bcmolt_group_info group_info_gpon_onu_key_exchange_key_mismatch = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 9, sizeof(bcmolt_gpon_onu_key_exchange_key_mismatch_data), sizeof(bcmolt_gpon_onu_key_exchange_key_mismatch), offsetof(bcmolt_gpon_onu_key_exchange_key_mismatch, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_key_exchange_key_mismatch_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_key_exchange_key_mismatch_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_key_exchange_key_mismatch_data_unpack, bcmolt_gpon_onu_key_exchange_key_mismatch_data_scan };
static bcmolt_group_info group_info_gpon_onu_key_exchange_key_request_timeout = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 10, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_onu_key_exchange_unconsecutive_index = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 11, sizeof(bcmolt_gpon_onu_key_exchange_unconsecutive_index_data), sizeof(bcmolt_gpon_onu_key_exchange_unconsecutive_index), offsetof(bcmolt_gpon_onu_key_exchange_unconsecutive_index, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_key_exchange_unconsecutive_index_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_key_exchange_unconsecutive_index_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_key_exchange_unconsecutive_index_data_unpack, bcmolt_gpon_onu_key_exchange_unconsecutive_index_data_scan };
static bcmolt_group_info group_info_gpon_onu_loai = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 12, sizeof(bcmolt_gpon_onu_loai_data), sizeof(bcmolt_gpon_onu_loai), offsetof(bcmolt_gpon_onu_loai, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_loai_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_loai_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_loai_data_unpack, bcmolt_gpon_onu_loai_data_scan };
static bcmolt_group_info group_info_gpon_onu_loki = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 13, sizeof(bcmolt_gpon_onu_loki_data), sizeof(bcmolt_gpon_onu_loki), offsetof(bcmolt_gpon_onu_loki, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_loki_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_loki_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_loki_data_unpack, bcmolt_gpon_onu_loki_data_scan };
static bcmolt_group_info group_info_gpon_onu_memi = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 14, sizeof(bcmolt_gpon_onu_memi_data), sizeof(bcmolt_gpon_onu_memi), offsetof(bcmolt_gpon_onu_memi, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_memi_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_memi_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_memi_data_unpack, bcmolt_gpon_onu_memi_data_scan };
static bcmolt_group_info group_info_gpon_onu_omci_port_id_configuration_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 15, sizeof(bcmolt_gpon_onu_omci_port_id_configuration_completed_data), sizeof(bcmolt_gpon_onu_omci_port_id_configuration_completed), offsetof(bcmolt_gpon_onu_omci_port_id_configuration_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_omci_port_id_configuration_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_omci_port_id_configuration_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_omci_port_id_configuration_completed_data_unpack, bcmolt_gpon_onu_omci_port_id_configuration_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_onu_activation_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 16, sizeof(bcmolt_gpon_onu_onu_activation_completed_data), sizeof(bcmolt_gpon_onu_onu_activation_completed), offsetof(bcmolt_gpon_onu_onu_activation_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_onu_activation_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_onu_activation_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_onu_activation_completed_data_unpack, bcmolt_gpon_onu_onu_activation_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_onu_activation_standby_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 17, sizeof(bcmolt_gpon_onu_onu_activation_standby_completed_data), sizeof(bcmolt_gpon_onu_onu_activation_standby_completed), offsetof(bcmolt_gpon_onu_onu_activation_standby_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_onu_activation_standby_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_onu_activation_standby_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_onu_activation_standby_completed_data_unpack, bcmolt_gpon_onu_onu_activation_standby_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_onu_alarm = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 18, sizeof(bcmolt_gpon_onu_onu_alarm_data), sizeof(bcmolt_gpon_onu_onu_alarm), offsetof(bcmolt_gpon_onu_onu_alarm, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_onu_alarm_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_onu_alarm_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_onu_alarm_data_unpack, bcmolt_gpon_onu_onu_alarm_data_scan };
static bcmolt_group_info group_info_gpon_onu_onu_deactivation_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 19, sizeof(bcmolt_gpon_onu_onu_deactivation_completed_data), sizeof(bcmolt_gpon_onu_onu_deactivation_completed), offsetof(bcmolt_gpon_onu_onu_deactivation_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_onu_deactivation_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_onu_deactivation_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_onu_deactivation_completed_data_unpack, bcmolt_gpon_onu_onu_deactivation_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_onu_disable_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 20, sizeof(bcmolt_gpon_onu_onu_disable_completed_data), sizeof(bcmolt_gpon_onu_onu_disable_completed), offsetof(bcmolt_gpon_onu_onu_disable_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_onu_disable_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_onu_disable_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_onu_disable_completed_data_unpack, bcmolt_gpon_onu_onu_disable_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_onu_enable_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 21, sizeof(bcmolt_gpon_onu_onu_enable_completed_data), sizeof(bcmolt_gpon_onu_onu_enable_completed), offsetof(bcmolt_gpon_onu_onu_enable_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_onu_enable_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_onu_enable_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_onu_enable_completed_data_unpack, bcmolt_gpon_onu_onu_enable_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_optical_reflection = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 22, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_onu_password_authentication_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 23, sizeof(bcmolt_gpon_onu_password_authentication_completed_data), sizeof(bcmolt_gpon_onu_password_authentication_completed), offsetof(bcmolt_gpon_onu_password_authentication_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_password_authentication_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_password_authentication_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_password_authentication_completed_data_unpack, bcmolt_gpon_onu_password_authentication_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_pee = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 24, sizeof(bcmolt_gpon_onu_pee_data), sizeof(bcmolt_gpon_onu_pee), offsetof(bcmolt_gpon_onu_pee, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_pee_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_pee_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_pee_data_unpack, bcmolt_gpon_onu_pee_data_scan };
static bcmolt_group_info group_info_gpon_onu_possible_drift = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 25, sizeof(bcmolt_gpon_onu_possible_drift_data), sizeof(bcmolt_gpon_onu_possible_drift), offsetof(bcmolt_gpon_onu_possible_drift, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_possible_drift_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_possible_drift_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_possible_drift_data_unpack, bcmolt_gpon_onu_possible_drift_data_scan };
static bcmolt_group_info group_info_gpon_onu_power_management_state_change = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 26, sizeof(bcmolt_gpon_onu_power_management_state_change_data), sizeof(bcmolt_gpon_onu_power_management_state_change), offsetof(bcmolt_gpon_onu_power_management_state_change, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_power_management_state_change_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_power_management_state_change_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_power_management_state_change_data_unpack, bcmolt_gpon_onu_power_management_state_change_data_scan };
static bcmolt_group_info group_info_gpon_onu_pst = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 27, sizeof(bcmolt_gpon_onu_pst_data), sizeof(bcmolt_gpon_onu_pst), offsetof(bcmolt_gpon_onu_pst, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_pst_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_pst_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_pst_data_unpack, bcmolt_gpon_onu_pst_data_scan };
static bcmolt_group_info group_info_gpon_onu_ranging_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 28, sizeof(bcmolt_gpon_onu_ranging_completed_data), sizeof(bcmolt_gpon_onu_ranging_completed), offsetof(bcmolt_gpon_onu_ranging_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_ranging_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_ranging_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_ranging_completed_data_unpack, bcmolt_gpon_onu_ranging_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_rei = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 29, sizeof(bcmolt_gpon_onu_rei_data), sizeof(bcmolt_gpon_onu_rei), offsetof(bcmolt_gpon_onu_rei, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_rei_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_rei_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_rei_data_unpack, bcmolt_gpon_onu_rei_data_scan };
static bcmolt_group_info group_info_gpon_onu_rssi_measurement_completed = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 30, sizeof(bcmolt_gpon_onu_rssi_measurement_completed_data), sizeof(bcmolt_gpon_onu_rssi_measurement_completed), offsetof(bcmolt_gpon_onu_rssi_measurement_completed, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_rssi_measurement_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_rssi_measurement_completed_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_rssi_measurement_completed_data_unpack, bcmolt_gpon_onu_rssi_measurement_completed_data_scan };
static bcmolt_group_info group_info_gpon_onu_sdi = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 31, sizeof(bcmolt_gpon_onu_sdi_data), sizeof(bcmolt_gpon_onu_sdi), offsetof(bcmolt_gpon_onu_sdi, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_sdi_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_sdi_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_sdi_data_unpack, bcmolt_gpon_onu_sdi_data_scan };
static bcmolt_group_info group_info_gpon_onu_sfi = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 32, sizeof(bcmolt_gpon_onu_sfi_data), sizeof(bcmolt_gpon_onu_sfi), offsetof(bcmolt_gpon_onu_sfi, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_sfi_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_sfi_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_sfi_data_unpack, bcmolt_gpon_onu_sfi_data_scan };
static bcmolt_group_info group_info_gpon_onu_stat_alarm_cleared = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 33, sizeof(bcmolt_gpon_onu_stat_alarm_cleared_data), sizeof(bcmolt_gpon_onu_stat_alarm_cleared), offsetof(bcmolt_gpon_onu_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_stat_alarm_cleared_data_unpack, bcmolt_gpon_onu_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_gpon_onu_stat_alarm_raised = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 34, sizeof(bcmolt_gpon_onu_stat_alarm_raised_data), sizeof(bcmolt_gpon_onu_stat_alarm_raised), offsetof(bcmolt_gpon_onu_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_stat_alarm_raised_data_unpack, bcmolt_gpon_onu_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_gpon_onu_sufi = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 35, sizeof(bcmolt_gpon_onu_sufi_data), sizeof(bcmolt_gpon_onu_sufi), offsetof(bcmolt_gpon_onu_sufi, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_sufi_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_sufi_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_sufi_data_unpack, bcmolt_gpon_onu_sufi_data_scan };
static bcmolt_group_info group_info_gpon_onu_tiwi = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO, 36, sizeof(bcmolt_gpon_onu_tiwi_data), sizeof(bcmolt_gpon_onu_tiwi), offsetof(bcmolt_gpon_onu_tiwi, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_tiwi_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_tiwi_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_tiwi_data_unpack, bcmolt_gpon_onu_tiwi_data_scan };
static bcmolt_group_info group_info_gpon_onu_auto_cfg = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_gpon_onu_auto_cfg_data), sizeof(bcmolt_gpon_onu_auto_cfg), offsetof(bcmolt_gpon_onu_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_auto_cfg_data_unpack, bcmolt_gpon_onu_auto_cfg_data_scan };
static bcmolt_group_info group_info_gpon_onu_change_power_level = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_gpon_onu_change_power_level_data), sizeof(bcmolt_gpon_onu_change_power_level), offsetof(bcmolt_gpon_onu_change_power_level, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_change_power_level_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_change_power_level_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_change_power_level_data_unpack, bcmolt_gpon_onu_change_power_level_data_scan };
static bcmolt_group_info group_info_gpon_onu_rssi_measurement = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_OPER, 1, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_gpon_onu_set_onu_state = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_OPER, 2, sizeof(bcmolt_gpon_onu_set_onu_state_data), sizeof(bcmolt_gpon_onu_set_onu_state), offsetof(bcmolt_gpon_onu_set_onu_state, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_set_onu_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_set_onu_state_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_set_onu_state_data_unpack, bcmolt_gpon_onu_set_onu_state_data_scan };
static bcmolt_group_info group_info_gpon_onu_cpu_packets = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_PROXY, 0, sizeof(bcmolt_gpon_onu_cpu_packets_data), sizeof(bcmolt_gpon_onu_cpu_packets), offsetof(bcmolt_gpon_onu_cpu_packets, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_cpu_packets_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_cpu_packets_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_cpu_packets_data_unpack, bcmolt_gpon_onu_cpu_packets_data_scan };
static bcmolt_group_info group_info_gpon_onu_ploam_packet = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_PROXY, 1, sizeof(bcmolt_gpon_onu_ploam_packet_data), sizeof(bcmolt_gpon_onu_ploam_packet), offsetof(bcmolt_gpon_onu_ploam_packet, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_ploam_packet_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_ploam_packet_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_ploam_packet_data_unpack, bcmolt_gpon_onu_ploam_packet_data_scan };
static bcmolt_group_info group_info_gpon_onu_cpu_packet = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_PROXY_RX, 0, sizeof(bcmolt_gpon_onu_cpu_packet_data), sizeof(bcmolt_gpon_onu_cpu_packet), offsetof(bcmolt_gpon_onu_cpu_packet, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_cpu_packet_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_cpu_packet_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_cpu_packet_data_unpack, bcmolt_gpon_onu_cpu_packet_data_scan };
static bcmolt_group_info group_info_gpon_onu_omci_packet = { BCMOLT_OBJ_ID_GPON_ONU, BCMOLT_MGT_GROUP_PROXY_RX, 1, sizeof(bcmolt_gpon_onu_omci_packet_data), sizeof(bcmolt_gpon_onu_omci_packet), offsetof(bcmolt_gpon_onu_omci_packet, data), (bcmolt_func_packed_len) bcmolt_gpon_onu_omci_packet_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_onu_omci_packet_data_pack, (bcmolt_func_unpack) bcmolt_gpon_onu_omci_packet_data_unpack, bcmolt_gpon_onu_omci_packet_data_scan };
static bcmolt_group_info group_info_gpon_trx_key = { BCMOLT_OBJ_ID_GPON_TRX, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_gpon_trx_key), 0, 0, (bcmolt_func_packed_len) bcmolt_gpon_trx_key_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_trx_key_pack, (bcmolt_func_unpack) bcmolt_gpon_trx_key_unpack, bcmolt_gpon_trx_key_scan };
static bcmolt_group_info group_info_gpon_trx_cfg = { BCMOLT_OBJ_ID_GPON_TRX, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_gpon_trx_cfg_data), sizeof(bcmolt_gpon_trx_cfg), offsetof(bcmolt_gpon_trx_cfg, data), (bcmolt_func_packed_len) bcmolt_gpon_trx_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_gpon_trx_cfg_data_pack, (bcmolt_func_unpack) bcmolt_gpon_trx_cfg_data_unpack, bcmolt_gpon_trx_cfg_data_scan };
static bcmolt_group_info group_info_log_entry_key = { BCMOLT_OBJ_ID_LOG_ENTRY, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_log_entry_key), 0, 0, (bcmolt_func_packed_len) bcmolt_log_entry_key_get_packed_length, (bcmolt_func_pack) bcmolt_log_entry_key_pack, (bcmolt_func_unpack) bcmolt_log_entry_key_unpack, bcmolt_log_entry_key_scan };
static bcmolt_group_info group_info_log_entry_cfg = { BCMOLT_OBJ_ID_LOG_ENTRY, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_log_entry_cfg_data), sizeof(bcmolt_log_entry_cfg), offsetof(bcmolt_log_entry_cfg, data), (bcmolt_func_packed_len) bcmolt_log_entry_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_log_entry_cfg_data_pack, (bcmolt_func_unpack) bcmolt_log_entry_cfg_data_unpack, bcmolt_log_entry_cfg_data_scan };
static bcmolt_group_info group_info_log_entry_stat = { BCMOLT_OBJ_ID_LOG_ENTRY, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_log_entry_stat_data), sizeof(bcmolt_log_entry_stat), offsetof(bcmolt_log_entry_stat, data), (bcmolt_func_packed_len) bcmolt_log_entry_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_log_entry_stat_data_pack, (bcmolt_func_unpack) bcmolt_log_entry_stat_data_unpack, bcmolt_log_entry_stat_data_scan };
static bcmolt_group_info group_info_log_entry_stat_cfg = { BCMOLT_OBJ_ID_LOG_ENTRY, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_log_entry_stat_cfg_data), sizeof(bcmolt_log_entry_stat_cfg), offsetof(bcmolt_log_entry_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_log_entry_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_log_entry_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_log_entry_stat_cfg_data_unpack, bcmolt_log_entry_stat_cfg_data_scan };
static bcmolt_group_info group_info_log_entry_stat_alarm_cleared = { BCMOLT_OBJ_ID_LOG_ENTRY, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_log_entry_stat_alarm_cleared_data), sizeof(bcmolt_log_entry_stat_alarm_cleared), offsetof(bcmolt_log_entry_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_log_entry_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_log_entry_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_log_entry_stat_alarm_cleared_data_unpack, bcmolt_log_entry_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_log_entry_stat_alarm_raised = { BCMOLT_OBJ_ID_LOG_ENTRY, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_log_entry_stat_alarm_raised_data), sizeof(bcmolt_log_entry_stat_alarm_raised), offsetof(bcmolt_log_entry_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_log_entry_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_log_entry_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_log_entry_stat_alarm_raised_data_unpack, bcmolt_log_entry_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_log_entry_auto_cfg = { BCMOLT_OBJ_ID_LOG_ENTRY, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_log_entry_auto_cfg_data), sizeof(bcmolt_log_entry_auto_cfg), offsetof(bcmolt_log_entry_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_log_entry_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_log_entry_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_log_entry_auto_cfg_data_unpack, bcmolt_log_entry_auto_cfg_data_scan };
static bcmolt_group_info group_info_logger_key = { BCMOLT_OBJ_ID_LOGGER, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_logger_key), 0, 0, (bcmolt_func_packed_len) bcmolt_logger_key_get_packed_length, (bcmolt_func_pack) bcmolt_logger_key_pack, (bcmolt_func_unpack) bcmolt_logger_key_unpack, bcmolt_logger_key_scan };
static bcmolt_group_info group_info_logger_cfg = { BCMOLT_OBJ_ID_LOGGER, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_logger_cfg_data), sizeof(bcmolt_logger_cfg), offsetof(bcmolt_logger_cfg, data), (bcmolt_func_packed_len) bcmolt_logger_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_logger_cfg_data_pack, (bcmolt_func_unpack) bcmolt_logger_cfg_data_unpack, bcmolt_logger_cfg_data_scan };
static bcmolt_group_info group_info_logger_stat = { BCMOLT_OBJ_ID_LOGGER, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_logger_stat_data), sizeof(bcmolt_logger_stat), offsetof(bcmolt_logger_stat, data), (bcmolt_func_packed_len) bcmolt_logger_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_logger_stat_data_pack, (bcmolt_func_unpack) bcmolt_logger_stat_data_unpack, bcmolt_logger_stat_data_scan };
static bcmolt_group_info group_info_logger_stat_cfg = { BCMOLT_OBJ_ID_LOGGER, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_logger_stat_cfg_data), sizeof(bcmolt_logger_stat_cfg), offsetof(bcmolt_logger_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_logger_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_logger_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_logger_stat_cfg_data_unpack, bcmolt_logger_stat_cfg_data_scan };
static bcmolt_group_info group_info_logger_stat_alarm_cleared = { BCMOLT_OBJ_ID_LOGGER, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_logger_stat_alarm_cleared_data), sizeof(bcmolt_logger_stat_alarm_cleared), offsetof(bcmolt_logger_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_logger_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_logger_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_logger_stat_alarm_cleared_data_unpack, bcmolt_logger_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_logger_stat_alarm_raised = { BCMOLT_OBJ_ID_LOGGER, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_logger_stat_alarm_raised_data), sizeof(bcmolt_logger_stat_alarm_raised), offsetof(bcmolt_logger_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_logger_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_logger_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_logger_stat_alarm_raised_data_unpack, bcmolt_logger_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_logger_auto_cfg = { BCMOLT_OBJ_ID_LOGGER, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_logger_auto_cfg_data), sizeof(bcmolt_logger_auto_cfg), offsetof(bcmolt_logger_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_logger_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_logger_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_logger_auto_cfg_data_unpack, bcmolt_logger_auto_cfg_data_scan };
static bcmolt_group_info group_info_logger_clear_log = { BCMOLT_OBJ_ID_LOGGER, BCMOLT_MGT_GROUP_OPER, 0, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_nni_key = { BCMOLT_OBJ_ID_NNI, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_nni_key), 0, 0, (bcmolt_func_packed_len) bcmolt_nni_key_get_packed_length, (bcmolt_func_pack) bcmolt_nni_key_pack, (bcmolt_func_unpack) bcmolt_nni_key_unpack, bcmolt_nni_key_scan };
static bcmolt_group_info group_info_nni_cfg = { BCMOLT_OBJ_ID_NNI, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_nni_cfg_data), sizeof(bcmolt_nni_cfg), offsetof(bcmolt_nni_cfg, data), (bcmolt_func_packed_len) bcmolt_nni_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_nni_cfg_data_pack, (bcmolt_func_unpack) bcmolt_nni_cfg_data_unpack, bcmolt_nni_cfg_data_scan };
static bcmolt_group_info group_info_nni_stat = { BCMOLT_OBJ_ID_NNI, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_nni_stat_data), sizeof(bcmolt_nni_stat), offsetof(bcmolt_nni_stat, data), (bcmolt_func_packed_len) bcmolt_nni_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_nni_stat_data_pack, (bcmolt_func_unpack) bcmolt_nni_stat_data_unpack, bcmolt_nni_stat_data_scan };
static bcmolt_group_info group_info_nni_stat_cfg = { BCMOLT_OBJ_ID_NNI, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_nni_stat_cfg_data), sizeof(bcmolt_nni_stat_cfg), offsetof(bcmolt_nni_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_nni_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_nni_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_nni_stat_cfg_data_unpack, bcmolt_nni_stat_cfg_data_scan };
static bcmolt_group_info group_info_nni_stat_alarm_cleared = { BCMOLT_OBJ_ID_NNI, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_nni_stat_alarm_cleared_data), sizeof(bcmolt_nni_stat_alarm_cleared), offsetof(bcmolt_nni_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_nni_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_nni_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_nni_stat_alarm_cleared_data_unpack, bcmolt_nni_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_nni_stat_alarm_raised = { BCMOLT_OBJ_ID_NNI, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_nni_stat_alarm_raised_data), sizeof(bcmolt_nni_stat_alarm_raised), offsetof(bcmolt_nni_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_nni_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_nni_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_nni_stat_alarm_raised_data_unpack, bcmolt_nni_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_nni_status_changed = { BCMOLT_OBJ_ID_NNI, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_nni_status_changed_data), sizeof(bcmolt_nni_status_changed), offsetof(bcmolt_nni_status_changed, data), (bcmolt_func_packed_len) bcmolt_nni_status_changed_data_get_packed_length, (bcmolt_func_pack) bcmolt_nni_status_changed_data_pack, (bcmolt_func_unpack) bcmolt_nni_status_changed_data_unpack, bcmolt_nni_status_changed_data_scan };
static bcmolt_group_info group_info_nni_auto_cfg = { BCMOLT_OBJ_ID_NNI, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_nni_auto_cfg_data), sizeof(bcmolt_nni_auto_cfg), offsetof(bcmolt_nni_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_nni_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_nni_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_nni_auto_cfg_data_unpack, bcmolt_nni_auto_cfg_data_scan };
static bcmolt_group_info group_info_nni_serdes_key = { BCMOLT_OBJ_ID_NNI_SERDES, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_nni_serdes_key), 0, 0, (bcmolt_func_packed_len) bcmolt_nni_serdes_key_get_packed_length, (bcmolt_func_pack) bcmolt_nni_serdes_key_pack, (bcmolt_func_unpack) bcmolt_nni_serdes_key_unpack, bcmolt_nni_serdes_key_scan };
static bcmolt_group_info group_info_nni_serdes_cfg = { BCMOLT_OBJ_ID_NNI_SERDES, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_nni_serdes_cfg_data), sizeof(bcmolt_nni_serdes_cfg), offsetof(bcmolt_nni_serdes_cfg, data), (bcmolt_func_packed_len) bcmolt_nni_serdes_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_nni_serdes_cfg_data_pack, (bcmolt_func_unpack) bcmolt_nni_serdes_cfg_data_unpack, bcmolt_nni_serdes_cfg_data_scan };
static bcmolt_group_info group_info_software_error_key = { BCMOLT_OBJ_ID_SOFTWARE_ERROR, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_software_error_key), 0, 0, (bcmolt_func_packed_len) bcmolt_software_error_key_get_packed_length, (bcmolt_func_pack) bcmolt_software_error_key_pack, (bcmolt_func_unpack) bcmolt_software_error_key_unpack, bcmolt_software_error_key_scan };
static bcmolt_group_info group_info_software_error_cfg = { BCMOLT_OBJ_ID_SOFTWARE_ERROR, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_software_error_cfg_data), sizeof(bcmolt_software_error_cfg), offsetof(bcmolt_software_error_cfg, data), (bcmolt_func_packed_len) bcmolt_software_error_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_software_error_cfg_data_pack, (bcmolt_func_unpack) bcmolt_software_error_cfg_data_unpack, bcmolt_software_error_cfg_data_scan };
static bcmolt_group_info group_info_trx_calibration_key = { BCMOLT_OBJ_ID_TRX_CALIBRATION, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_trx_calibration_key), 0, 0, (bcmolt_func_packed_len) bcmolt_trx_calibration_key_get_packed_length, (bcmolt_func_pack) bcmolt_trx_calibration_key_pack, (bcmolt_func_unpack) bcmolt_trx_calibration_key_unpack, bcmolt_trx_calibration_key_scan };
static bcmolt_group_info group_info_trx_calibration_capture_window_and_statistic_completed = { BCMOLT_OBJ_ID_TRX_CALIBRATION, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_trx_calibration_capture_window_and_statistic_completed_data), sizeof(bcmolt_trx_calibration_capture_window_and_statistic_completed), offsetof(bcmolt_trx_calibration_capture_window_and_statistic_completed, data), (bcmolt_func_packed_len) bcmolt_trx_calibration_capture_window_and_statistic_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_trx_calibration_capture_window_and_statistic_completed_data_pack, (bcmolt_func_unpack) bcmolt_trx_calibration_capture_window_and_statistic_completed_data_unpack, bcmolt_trx_calibration_capture_window_and_statistic_completed_data_scan };
static bcmolt_group_info group_info_trx_calibration_auto_cfg = { BCMOLT_OBJ_ID_TRX_CALIBRATION, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_trx_calibration_auto_cfg_data), sizeof(bcmolt_trx_calibration_auto_cfg), offsetof(bcmolt_trx_calibration_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_trx_calibration_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_trx_calibration_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_trx_calibration_auto_cfg_data_unpack, bcmolt_trx_calibration_auto_cfg_data_scan };
static bcmolt_group_info group_info_trx_calibration_start_capture_window = { BCMOLT_OBJ_ID_TRX_CALIBRATION, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_trx_calibration_start_capture_window_data), sizeof(bcmolt_trx_calibration_start_capture_window), offsetof(bcmolt_trx_calibration_start_capture_window, data), (bcmolt_func_packed_len) bcmolt_trx_calibration_start_capture_window_data_get_packed_length, (bcmolt_func_pack) bcmolt_trx_calibration_start_capture_window_data_pack, (bcmolt_func_unpack) bcmolt_trx_calibration_start_capture_window_data_unpack, bcmolt_trx_calibration_start_capture_window_data_scan };
static bcmolt_group_info group_info_trx_calibration_stop_capture_window = { BCMOLT_OBJ_ID_TRX_CALIBRATION, BCMOLT_MGT_GROUP_OPER, 1, sizeof(bcmolt_trx_calibration_stop_capture_window_data), sizeof(bcmolt_trx_calibration_stop_capture_window), offsetof(bcmolt_trx_calibration_stop_capture_window, data), (bcmolt_func_packed_len) bcmolt_trx_calibration_stop_capture_window_data_get_packed_length, (bcmolt_func_pack) bcmolt_trx_calibration_stop_capture_window_data_pack, (bcmolt_func_unpack) bcmolt_trx_calibration_stop_capture_window_data_unpack, bcmolt_trx_calibration_stop_capture_window_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_key = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_xgpon_alloc_key), 0, 0, (bcmolt_func_packed_len) bcmolt_xgpon_alloc_key_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_key_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_key_unpack, bcmolt_xgpon_alloc_key_scan };
static bcmolt_group_info group_info_xgpon_alloc_cfg = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_xgpon_alloc_cfg_data), sizeof(bcmolt_xgpon_alloc_cfg), offsetof(bcmolt_xgpon_alloc_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_cfg_data_unpack, bcmolt_xgpon_alloc_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_stat = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_xgpon_alloc_stat_data), sizeof(bcmolt_xgpon_alloc_stat), offsetof(bcmolt_xgpon_alloc_stat, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_stat_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_stat_data_unpack, bcmolt_xgpon_alloc_stat_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_stat_cfg = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_xgpon_alloc_stat_cfg_data), sizeof(bcmolt_xgpon_alloc_stat_cfg), offsetof(bcmolt_xgpon_alloc_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_stat_cfg_data_unpack, bcmolt_xgpon_alloc_stat_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_configuration_completed = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_xgpon_alloc_configuration_completed_data), sizeof(bcmolt_xgpon_alloc_configuration_completed), offsetof(bcmolt_xgpon_alloc_configuration_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_configuration_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_configuration_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_configuration_completed_data_unpack, bcmolt_xgpon_alloc_configuration_completed_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_get_alloc_stats_completed = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_xgpon_alloc_get_alloc_stats_completed_data), sizeof(bcmolt_xgpon_alloc_get_alloc_stats_completed), offsetof(bcmolt_xgpon_alloc_get_alloc_stats_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_get_alloc_stats_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_get_alloc_stats_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_get_alloc_stats_completed_data_unpack, bcmolt_xgpon_alloc_get_alloc_stats_completed_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_stat_alarm_cleared = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_xgpon_alloc_stat_alarm_cleared_data), sizeof(bcmolt_xgpon_alloc_stat_alarm_cleared), offsetof(bcmolt_xgpon_alloc_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_stat_alarm_cleared_data_unpack, bcmolt_xgpon_alloc_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_stat_alarm_raised = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_AUTO, 3, sizeof(bcmolt_xgpon_alloc_stat_alarm_raised_data), sizeof(bcmolt_xgpon_alloc_stat_alarm_raised), offsetof(bcmolt_xgpon_alloc_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_stat_alarm_raised_data_unpack, bcmolt_xgpon_alloc_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_auto_cfg = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_xgpon_alloc_auto_cfg_data), sizeof(bcmolt_xgpon_alloc_auto_cfg), offsetof(bcmolt_xgpon_alloc_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_auto_cfg_data_unpack, bcmolt_xgpon_alloc_auto_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_get_stats = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_xgpon_alloc_get_stats_data), sizeof(bcmolt_xgpon_alloc_get_stats), offsetof(bcmolt_xgpon_alloc_get_stats, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_get_stats_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_get_stats_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_get_stats_data_unpack, bcmolt_xgpon_alloc_get_stats_data_scan };
static bcmolt_group_info group_info_xgpon_alloc_set_state = { BCMOLT_OBJ_ID_XGPON_ALLOC, BCMOLT_MGT_GROUP_OPER, 1, sizeof(bcmolt_xgpon_alloc_set_state_data), sizeof(bcmolt_xgpon_alloc_set_state), offsetof(bcmolt_xgpon_alloc_set_state, data), (bcmolt_func_packed_len) bcmolt_xgpon_alloc_set_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_alloc_set_state_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_alloc_set_state_data_unpack, bcmolt_xgpon_alloc_set_state_data_scan };
static bcmolt_group_info group_info_xgpon_gem_port_key = { BCMOLT_OBJ_ID_XGPON_GEM_PORT, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_xgpon_gem_port_key), 0, 0, (bcmolt_func_packed_len) bcmolt_xgpon_gem_port_key_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_gem_port_key_pack, (bcmolt_func_unpack) bcmolt_xgpon_gem_port_key_unpack, bcmolt_xgpon_gem_port_key_scan };
static bcmolt_group_info group_info_xgpon_gem_port_cfg = { BCMOLT_OBJ_ID_XGPON_GEM_PORT, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_xgpon_gem_port_cfg_data), sizeof(bcmolt_xgpon_gem_port_cfg), offsetof(bcmolt_xgpon_gem_port_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_gem_port_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_gem_port_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_gem_port_cfg_data_unpack, bcmolt_xgpon_gem_port_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_gem_port_stat = { BCMOLT_OBJ_ID_XGPON_GEM_PORT, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_xgpon_gem_port_stat_data), sizeof(bcmolt_xgpon_gem_port_stat), offsetof(bcmolt_xgpon_gem_port_stat, data), (bcmolt_func_packed_len) bcmolt_xgpon_gem_port_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_gem_port_stat_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_gem_port_stat_data_unpack, bcmolt_xgpon_gem_port_stat_data_scan };
static bcmolt_group_info group_info_xgpon_gem_port_stat_cfg = { BCMOLT_OBJ_ID_XGPON_GEM_PORT, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_xgpon_gem_port_stat_cfg_data), sizeof(bcmolt_xgpon_gem_port_stat_cfg), offsetof(bcmolt_xgpon_gem_port_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_gem_port_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_gem_port_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_gem_port_stat_cfg_data_unpack, bcmolt_xgpon_gem_port_stat_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_gem_port_stat_alarm_cleared = { BCMOLT_OBJ_ID_XGPON_GEM_PORT, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_xgpon_gem_port_stat_alarm_cleared_data), sizeof(bcmolt_xgpon_gem_port_stat_alarm_cleared), offsetof(bcmolt_xgpon_gem_port_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_xgpon_gem_port_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_gem_port_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_gem_port_stat_alarm_cleared_data_unpack, bcmolt_xgpon_gem_port_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_xgpon_gem_port_stat_alarm_raised = { BCMOLT_OBJ_ID_XGPON_GEM_PORT, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_xgpon_gem_port_stat_alarm_raised_data), sizeof(bcmolt_xgpon_gem_port_stat_alarm_raised), offsetof(bcmolt_xgpon_gem_port_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_xgpon_gem_port_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_gem_port_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_gem_port_stat_alarm_raised_data_unpack, bcmolt_xgpon_gem_port_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_xgpon_gem_port_auto_cfg = { BCMOLT_OBJ_ID_XGPON_GEM_PORT, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_xgpon_gem_port_auto_cfg_data), sizeof(bcmolt_xgpon_gem_port_auto_cfg), offsetof(bcmolt_xgpon_gem_port_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_gem_port_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_gem_port_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_gem_port_auto_cfg_data_unpack, bcmolt_xgpon_gem_port_auto_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_iwf_key = { BCMOLT_OBJ_ID_XGPON_IWF, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_xgpon_iwf_key), 0, 0, (bcmolt_func_packed_len) bcmolt_xgpon_iwf_key_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_iwf_key_pack, (bcmolt_func_unpack) bcmolt_xgpon_iwf_key_unpack, bcmolt_xgpon_iwf_key_scan };
static bcmolt_group_info group_info_xgpon_iwf_cfg = { BCMOLT_OBJ_ID_XGPON_IWF, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_xgpon_iwf_cfg_data), sizeof(bcmolt_xgpon_iwf_cfg), offsetof(bcmolt_xgpon_iwf_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_iwf_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_iwf_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_iwf_cfg_data_unpack, bcmolt_xgpon_iwf_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_ni_key = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_xgpon_ni_key), 0, 0, (bcmolt_func_packed_len) bcmolt_xgpon_ni_key_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_key_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_key_unpack, bcmolt_xgpon_ni_key_scan };
static bcmolt_group_info group_info_xgpon_ni_cfg = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_xgpon_ni_cfg_data), sizeof(bcmolt_xgpon_ni_cfg), offsetof(bcmolt_xgpon_ni_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_cfg_data_unpack, bcmolt_xgpon_ni_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_ni_stat = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_xgpon_ni_stat_data), sizeof(bcmolt_xgpon_ni_stat), offsetof(bcmolt_xgpon_ni_stat, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_stat_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_stat_data_unpack, bcmolt_xgpon_ni_stat_data_scan };
static bcmolt_group_info group_info_xgpon_ni_stat_cfg = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_xgpon_ni_stat_cfg_data), sizeof(bcmolt_xgpon_ni_stat_cfg), offsetof(bcmolt_xgpon_ni_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_stat_cfg_data_unpack, bcmolt_xgpon_ni_stat_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_ni_activate_all_onus_completed = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 0, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_ni_cpu_packets_failure = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_xgpon_ni_cpu_packets_failure_data), sizeof(bcmolt_xgpon_ni_cpu_packets_failure), offsetof(bcmolt_xgpon_ni_cpu_packets_failure, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_cpu_packets_failure_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_cpu_packets_failure_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_cpu_packets_failure_data_unpack, bcmolt_xgpon_ni_cpu_packets_failure_data_scan };
static bcmolt_group_info group_info_xgpon_ni_deactivate_all_onus_completed = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 2, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_ni_disable_all_onus_completed = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 3, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_ni_enable_all_onus_completed = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 4, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_ni_los = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 5, sizeof(bcmolt_xgpon_ni_los_data), sizeof(bcmolt_xgpon_ni_los), offsetof(bcmolt_xgpon_ni_los, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_los_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_los_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_los_data_unpack, bcmolt_xgpon_ni_los_data_scan };
static bcmolt_group_info group_info_xgpon_ni_onu_discovered = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 6, sizeof(bcmolt_xgpon_ni_onu_discovered_data), sizeof(bcmolt_xgpon_ni_onu_discovered), offsetof(bcmolt_xgpon_ni_onu_discovered, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_onu_discovered_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_onu_discovered_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_onu_discovered_data_unpack, bcmolt_xgpon_ni_onu_discovered_data_scan };
static bcmolt_group_info group_info_xgpon_ni_onu_upgrade_complete = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 7, sizeof(bcmolt_xgpon_ni_onu_upgrade_complete_data), sizeof(bcmolt_xgpon_ni_onu_upgrade_complete), offsetof(bcmolt_xgpon_ni_onu_upgrade_complete, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_onu_upgrade_complete_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_onu_upgrade_complete_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_onu_upgrade_complete_data_unpack, bcmolt_xgpon_ni_onu_upgrade_complete_data_scan };
static bcmolt_group_info group_info_xgpon_ni_protection_switching_onus_ranged = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 8, sizeof(bcmolt_xgpon_ni_protection_switching_onus_ranged_data), sizeof(bcmolt_xgpon_ni_protection_switching_onus_ranged), offsetof(bcmolt_xgpon_ni_protection_switching_onus_ranged, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_protection_switching_onus_ranged_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_protection_switching_onus_ranged_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_protection_switching_onus_ranged_data_unpack, bcmolt_xgpon_ni_protection_switching_onus_ranged_data_scan };
static bcmolt_group_info group_info_xgpon_ni_protection_switching_switchover_completed = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 9, sizeof(bcmolt_xgpon_ni_protection_switching_switchover_completed_data), sizeof(bcmolt_xgpon_ni_protection_switching_switchover_completed), offsetof(bcmolt_xgpon_ni_protection_switching_switchover_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_protection_switching_switchover_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_protection_switching_switchover_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_protection_switching_switchover_completed_data_unpack, bcmolt_xgpon_ni_protection_switching_switchover_completed_data_scan };
static bcmolt_group_info group_info_xgpon_ni_protection_switching_traffic_resume = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 10, sizeof(bcmolt_xgpon_ni_protection_switching_traffic_resume_data), sizeof(bcmolt_xgpon_ni_protection_switching_traffic_resume), offsetof(bcmolt_xgpon_ni_protection_switching_traffic_resume, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_protection_switching_traffic_resume_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_protection_switching_traffic_resume_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_protection_switching_traffic_resume_data_unpack, bcmolt_xgpon_ni_protection_switching_traffic_resume_data_scan };
static bcmolt_group_info group_info_xgpon_ni_rogue_detection_completed = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 11, sizeof(bcmolt_xgpon_ni_rogue_detection_completed_data), sizeof(bcmolt_xgpon_ni_rogue_detection_completed), offsetof(bcmolt_xgpon_ni_rogue_detection_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_rogue_detection_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_rogue_detection_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_rogue_detection_completed_data_unpack, bcmolt_xgpon_ni_rogue_detection_completed_data_scan };
static bcmolt_group_info group_info_xgpon_ni_rogue_onu_special_map_cycle_start = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 12, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_ni_serial_number_acquisition_cycle_start = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 13, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_ni_standby_pon_monitoring_cycle_completed = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 14, sizeof(bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_data), sizeof(bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed), offsetof(bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_data_unpack, bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_data_scan };
static bcmolt_group_info group_info_xgpon_ni_stat_alarm_cleared = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 15, sizeof(bcmolt_xgpon_ni_stat_alarm_cleared_data), sizeof(bcmolt_xgpon_ni_stat_alarm_cleared), offsetof(bcmolt_xgpon_ni_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_stat_alarm_cleared_data_unpack, bcmolt_xgpon_ni_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_xgpon_ni_stat_alarm_raised = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 16, sizeof(bcmolt_xgpon_ni_stat_alarm_raised_data), sizeof(bcmolt_xgpon_ni_stat_alarm_raised), offsetof(bcmolt_xgpon_ni_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_stat_alarm_raised_data_unpack, bcmolt_xgpon_ni_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_xgpon_ni_state_change_completed = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 17, sizeof(bcmolt_xgpon_ni_state_change_completed_data), sizeof(bcmolt_xgpon_ni_state_change_completed), offsetof(bcmolt_xgpon_ni_state_change_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_state_change_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_state_change_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_state_change_completed_data_unpack, bcmolt_xgpon_ni_state_change_completed_data_scan };
static bcmolt_group_info group_info_xgpon_ni_tod_request_completed = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO, 18, sizeof(bcmolt_xgpon_ni_tod_request_completed_data), sizeof(bcmolt_xgpon_ni_tod_request_completed), offsetof(bcmolt_xgpon_ni_tod_request_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_tod_request_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_tod_request_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_tod_request_completed_data_unpack, bcmolt_xgpon_ni_tod_request_completed_data_scan };
static bcmolt_group_info group_info_xgpon_ni_auto_cfg = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_xgpon_ni_auto_cfg_data), sizeof(bcmolt_xgpon_ni_auto_cfg), offsetof(bcmolt_xgpon_ni_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_auto_cfg_data_unpack, bcmolt_xgpon_ni_auto_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_ni_adjust_tx_wavelength = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_xgpon_ni_adjust_tx_wavelength_data), sizeof(bcmolt_xgpon_ni_adjust_tx_wavelength), offsetof(bcmolt_xgpon_ni_adjust_tx_wavelength, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_adjust_tx_wavelength_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_adjust_tx_wavelength_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_adjust_tx_wavelength_data_unpack, bcmolt_xgpon_ni_adjust_tx_wavelength_data_scan };
static bcmolt_group_info group_info_xgpon_ni_disable_serial_number = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 1, sizeof(bcmolt_xgpon_ni_disable_serial_number_data), sizeof(bcmolt_xgpon_ni_disable_serial_number), offsetof(bcmolt_xgpon_ni_disable_serial_number, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_disable_serial_number_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_disable_serial_number_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_disable_serial_number_data_unpack, bcmolt_xgpon_ni_disable_serial_number_data_scan };
static bcmolt_group_info group_info_xgpon_ni_reset = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 2, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_ni_rogue_detection_window = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 3, sizeof(bcmolt_xgpon_ni_rogue_detection_window_data), sizeof(bcmolt_xgpon_ni_rogue_detection_window), offsetof(bcmolt_xgpon_ni_rogue_detection_window, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_rogue_detection_window_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_rogue_detection_window_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_rogue_detection_window_data_unpack, bcmolt_xgpon_ni_rogue_detection_window_data_scan };
static bcmolt_group_info group_info_xgpon_ni_run_special_bw_map = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 4, sizeof(bcmolt_xgpon_ni_run_special_bw_map_data), sizeof(bcmolt_xgpon_ni_run_special_bw_map), offsetof(bcmolt_xgpon_ni_run_special_bw_map, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_run_special_bw_map_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_run_special_bw_map_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_run_special_bw_map_data_unpack, bcmolt_xgpon_ni_run_special_bw_map_data_scan };
static bcmolt_group_info group_info_xgpon_ni_set_onu_state = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 5, sizeof(bcmolt_xgpon_ni_set_onu_state_data), sizeof(bcmolt_xgpon_ni_set_onu_state), offsetof(bcmolt_xgpon_ni_set_onu_state, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_set_onu_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_set_onu_state_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_set_onu_state_data_unpack, bcmolt_xgpon_ni_set_onu_state_data_scan };
static bcmolt_group_info group_info_xgpon_ni_set_pon_state = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 6, sizeof(bcmolt_xgpon_ni_set_pon_state_data), sizeof(bcmolt_xgpon_ni_set_pon_state), offsetof(bcmolt_xgpon_ni_set_pon_state, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_set_pon_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_set_pon_state_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_set_pon_state_data_unpack, bcmolt_xgpon_ni_set_pon_state_data_scan };
static bcmolt_group_info group_info_xgpon_ni_single_request_standby_pon_monitoring = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 7, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_ni_start_onu_upgrade = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 8, sizeof(bcmolt_xgpon_ni_start_onu_upgrade_data), sizeof(bcmolt_xgpon_ni_start_onu_upgrade), offsetof(bcmolt_xgpon_ni_start_onu_upgrade, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_start_onu_upgrade_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_start_onu_upgrade_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_start_onu_upgrade_data_unpack, bcmolt_xgpon_ni_start_onu_upgrade_data_scan };
static bcmolt_group_info group_info_xgpon_ni_tod_request = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_OPER, 9, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_ni_broadcast_ploam_packet = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_PROXY, 0, sizeof(bcmolt_xgpon_ni_broadcast_ploam_packet_data), sizeof(bcmolt_xgpon_ni_broadcast_ploam_packet), offsetof(bcmolt_xgpon_ni_broadcast_ploam_packet, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_broadcast_ploam_packet_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_broadcast_ploam_packet_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_broadcast_ploam_packet_data_unpack, bcmolt_xgpon_ni_broadcast_ploam_packet_data_scan };
static bcmolt_group_info group_info_xgpon_ni_cpu_packets = { BCMOLT_OBJ_ID_XGPON_NI, BCMOLT_MGT_GROUP_PROXY, 1, sizeof(bcmolt_xgpon_ni_cpu_packets_data), sizeof(bcmolt_xgpon_ni_cpu_packets), offsetof(bcmolt_xgpon_ni_cpu_packets, data), (bcmolt_func_packed_len) bcmolt_xgpon_ni_cpu_packets_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_ni_cpu_packets_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_ni_cpu_packets_data_unpack, bcmolt_xgpon_ni_cpu_packets_data_scan };
static bcmolt_group_info group_info_xgpon_onu_key = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_xgpon_onu_key), 0, 0, (bcmolt_func_packed_len) bcmolt_xgpon_onu_key_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_key_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_key_unpack, bcmolt_xgpon_onu_key_scan };
static bcmolt_group_info group_info_xgpon_onu_cfg = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_xgpon_onu_cfg_data), sizeof(bcmolt_xgpon_onu_cfg), offsetof(bcmolt_xgpon_onu_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_cfg_data_unpack, bcmolt_xgpon_onu_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_onu_stat = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_STAT, 0, sizeof(bcmolt_xgpon_onu_stat_data), sizeof(bcmolt_xgpon_onu_stat), offsetof(bcmolt_xgpon_onu_stat, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_stat_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_stat_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_stat_data_unpack, bcmolt_xgpon_onu_stat_data_scan };
static bcmolt_group_info group_info_xgpon_onu_stat_cfg = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_STAT_CFG, 0, sizeof(bcmolt_xgpon_onu_stat_cfg_data), sizeof(bcmolt_xgpon_onu_stat_cfg), offsetof(bcmolt_xgpon_onu_stat_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_stat_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_stat_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_stat_cfg_data_unpack, bcmolt_xgpon_onu_stat_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_onu_dfi = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 0, sizeof(bcmolt_xgpon_onu_dfi_data), sizeof(bcmolt_xgpon_onu_dfi), offsetof(bcmolt_xgpon_onu_dfi, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_dfi_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_dfi_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_dfi_data_unpack, bcmolt_xgpon_onu_dfi_data_scan };
static bcmolt_group_info group_info_xgpon_onu_dgi = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 1, sizeof(bcmolt_xgpon_onu_dgi_data), sizeof(bcmolt_xgpon_onu_dgi), offsetof(bcmolt_xgpon_onu_dgi, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_dgi_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_dgi_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_dgi_data_unpack, bcmolt_xgpon_onu_dgi_data_scan };
static bcmolt_group_info group_info_xgpon_onu_dowi = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 2, sizeof(bcmolt_xgpon_onu_dowi_data), sizeof(bcmolt_xgpon_onu_dowi), offsetof(bcmolt_xgpon_onu_dowi, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_dowi_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_dowi_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_dowi_data_unpack, bcmolt_xgpon_onu_dowi_data_scan };
static bcmolt_group_info group_info_xgpon_onu_invalid_dbru_report = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 3, sizeof(bcmolt_xgpon_onu_invalid_dbru_report_data), sizeof(bcmolt_xgpon_onu_invalid_dbru_report), offsetof(bcmolt_xgpon_onu_invalid_dbru_report, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_invalid_dbru_report_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_invalid_dbru_report_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_invalid_dbru_report_data_unpack, bcmolt_xgpon_onu_invalid_dbru_report_data_scan };
static bcmolt_group_info group_info_xgpon_onu_key_exchange_completed = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 4, sizeof(bcmolt_xgpon_onu_key_exchange_completed_data), sizeof(bcmolt_xgpon_onu_key_exchange_completed), offsetof(bcmolt_xgpon_onu_key_exchange_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_key_exchange_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_key_exchange_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_key_exchange_completed_data_unpack, bcmolt_xgpon_onu_key_exchange_completed_data_scan };
static bcmolt_group_info group_info_xgpon_onu_key_exchange_cycle_skipped = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 5, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_onu_key_exchange_key_mismatch = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 6, sizeof(bcmolt_xgpon_onu_key_exchange_key_mismatch_data), sizeof(bcmolt_xgpon_onu_key_exchange_key_mismatch), offsetof(bcmolt_xgpon_onu_key_exchange_key_mismatch, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_key_exchange_key_mismatch_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_key_exchange_key_mismatch_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_key_exchange_key_mismatch_data_unpack, bcmolt_xgpon_onu_key_exchange_key_mismatch_data_scan };
static bcmolt_group_info group_info_xgpon_onu_key_exchange_key_request_timeout = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 7, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_onu_looci = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 8, sizeof(bcmolt_xgpon_onu_looci_data), sizeof(bcmolt_xgpon_onu_looci), offsetof(bcmolt_xgpon_onu_looci, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_looci_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_looci_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_looci_data_unpack, bcmolt_xgpon_onu_looci_data_scan };
static bcmolt_group_info group_info_xgpon_onu_onu_activation_completed = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 9, sizeof(bcmolt_xgpon_onu_onu_activation_completed_data), sizeof(bcmolt_xgpon_onu_onu_activation_completed), offsetof(bcmolt_xgpon_onu_onu_activation_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_onu_activation_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_onu_activation_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_onu_activation_completed_data_unpack, bcmolt_xgpon_onu_onu_activation_completed_data_scan };
static bcmolt_group_info group_info_xgpon_onu_onu_alarm = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 10, sizeof(bcmolt_xgpon_onu_onu_alarm_data), sizeof(bcmolt_xgpon_onu_onu_alarm), offsetof(bcmolt_xgpon_onu_onu_alarm, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_onu_alarm_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_onu_alarm_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_onu_alarm_data_unpack, bcmolt_xgpon_onu_onu_alarm_data_scan };
static bcmolt_group_info group_info_xgpon_onu_onu_deactivation_completed = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 11, sizeof(bcmolt_xgpon_onu_onu_deactivation_completed_data), sizeof(bcmolt_xgpon_onu_onu_deactivation_completed), offsetof(bcmolt_xgpon_onu_onu_deactivation_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_onu_deactivation_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_onu_deactivation_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_onu_deactivation_completed_data_unpack, bcmolt_xgpon_onu_onu_deactivation_completed_data_scan };
static bcmolt_group_info group_info_xgpon_onu_onu_disable_completed = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 12, sizeof(bcmolt_xgpon_onu_onu_disable_completed_data), sizeof(bcmolt_xgpon_onu_onu_disable_completed), offsetof(bcmolt_xgpon_onu_onu_disable_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_onu_disable_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_onu_disable_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_onu_disable_completed_data_unpack, bcmolt_xgpon_onu_onu_disable_completed_data_scan };
static bcmolt_group_info group_info_xgpon_onu_onu_enable_completed = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 13, sizeof(bcmolt_xgpon_onu_onu_enable_completed_data), sizeof(bcmolt_xgpon_onu_onu_enable_completed), offsetof(bcmolt_xgpon_onu_onu_enable_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_onu_enable_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_onu_enable_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_onu_enable_completed_data_unpack, bcmolt_xgpon_onu_onu_enable_completed_data_scan };
static bcmolt_group_info group_info_xgpon_onu_onu_tuning_in_completed = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 14, sizeof(bcmolt_xgpon_onu_onu_tuning_in_completed_data), sizeof(bcmolt_xgpon_onu_onu_tuning_in_completed), offsetof(bcmolt_xgpon_onu_onu_tuning_in_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_onu_tuning_in_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_onu_tuning_in_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_onu_tuning_in_completed_data_unpack, bcmolt_xgpon_onu_onu_tuning_in_completed_data_scan };
static bcmolt_group_info group_info_xgpon_onu_onu_tuning_out_completed = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 15, sizeof(bcmolt_xgpon_onu_onu_tuning_out_completed_data), sizeof(bcmolt_xgpon_onu_onu_tuning_out_completed), offsetof(bcmolt_xgpon_onu_onu_tuning_out_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_onu_tuning_out_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_onu_tuning_out_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_onu_tuning_out_completed_data_unpack, bcmolt_xgpon_onu_onu_tuning_out_completed_data_scan };
static bcmolt_group_info group_info_xgpon_onu_optical_reflection = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 16, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_onu_possible_drift = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 17, sizeof(bcmolt_xgpon_onu_possible_drift_data), sizeof(bcmolt_xgpon_onu_possible_drift), offsetof(bcmolt_xgpon_onu_possible_drift, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_possible_drift_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_possible_drift_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_possible_drift_data_unpack, bcmolt_xgpon_onu_possible_drift_data_scan };
static bcmolt_group_info group_info_xgpon_onu_power_consumption_report = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 18, sizeof(bcmolt_xgpon_onu_power_consumption_report_data), sizeof(bcmolt_xgpon_onu_power_consumption_report), offsetof(bcmolt_xgpon_onu_power_consumption_report, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_power_consumption_report_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_power_consumption_report_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_power_consumption_report_data_unpack, bcmolt_xgpon_onu_power_consumption_report_data_scan };
static bcmolt_group_info group_info_xgpon_onu_power_level_report = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 19, sizeof(bcmolt_xgpon_onu_power_level_report_data), sizeof(bcmolt_xgpon_onu_power_level_report), offsetof(bcmolt_xgpon_onu_power_level_report, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_power_level_report_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_power_level_report_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_power_level_report_data_unpack, bcmolt_xgpon_onu_power_level_report_data_scan };
static bcmolt_group_info group_info_xgpon_onu_power_management_state_change = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 20, sizeof(bcmolt_xgpon_onu_power_management_state_change_data), sizeof(bcmolt_xgpon_onu_power_management_state_change), offsetof(bcmolt_xgpon_onu_power_management_state_change, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_power_management_state_change_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_power_management_state_change_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_power_management_state_change_data_unpack, bcmolt_xgpon_onu_power_management_state_change_data_scan };
static bcmolt_group_info group_info_xgpon_onu_pqsi = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 21, sizeof(bcmolt_xgpon_onu_pqsi_data), sizeof(bcmolt_xgpon_onu_pqsi), offsetof(bcmolt_xgpon_onu_pqsi, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_pqsi_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_pqsi_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_pqsi_data_unpack, bcmolt_xgpon_onu_pqsi_data_scan };
static bcmolt_group_info group_info_xgpon_onu_ranging_completed = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 22, sizeof(bcmolt_xgpon_onu_ranging_completed_data), sizeof(bcmolt_xgpon_onu_ranging_completed), offsetof(bcmolt_xgpon_onu_ranging_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_ranging_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_ranging_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_ranging_completed_data_unpack, bcmolt_xgpon_onu_ranging_completed_data_scan };
static bcmolt_group_info group_info_xgpon_onu_registration_id = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 23, sizeof(bcmolt_xgpon_onu_registration_id_data), sizeof(bcmolt_xgpon_onu_registration_id), offsetof(bcmolt_xgpon_onu_registration_id, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_registration_id_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_registration_id_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_registration_id_data_unpack, bcmolt_xgpon_onu_registration_id_data_scan };
static bcmolt_group_info group_info_xgpon_onu_rssi_measurement_completed = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 24, sizeof(bcmolt_xgpon_onu_rssi_measurement_completed_data), sizeof(bcmolt_xgpon_onu_rssi_measurement_completed), offsetof(bcmolt_xgpon_onu_rssi_measurement_completed, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_rssi_measurement_completed_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_rssi_measurement_completed_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_rssi_measurement_completed_data_unpack, bcmolt_xgpon_onu_rssi_measurement_completed_data_scan };
static bcmolt_group_info group_info_xgpon_onu_sdi = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 25, sizeof(bcmolt_xgpon_onu_sdi_data), sizeof(bcmolt_xgpon_onu_sdi), offsetof(bcmolt_xgpon_onu_sdi, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_sdi_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_sdi_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_sdi_data_unpack, bcmolt_xgpon_onu_sdi_data_scan };
static bcmolt_group_info group_info_xgpon_onu_secure_mutual_authentication_failure = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 26, sizeof(bcmolt_xgpon_onu_secure_mutual_authentication_failure_data), sizeof(bcmolt_xgpon_onu_secure_mutual_authentication_failure), offsetof(bcmolt_xgpon_onu_secure_mutual_authentication_failure, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_secure_mutual_authentication_failure_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_secure_mutual_authentication_failure_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_secure_mutual_authentication_failure_data_unpack, bcmolt_xgpon_onu_secure_mutual_authentication_failure_data_scan };
static bcmolt_group_info group_info_xgpon_onu_sfi = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 27, sizeof(bcmolt_xgpon_onu_sfi_data), sizeof(bcmolt_xgpon_onu_sfi), offsetof(bcmolt_xgpon_onu_sfi, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_sfi_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_sfi_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_sfi_data_unpack, bcmolt_xgpon_onu_sfi_data_scan };
static bcmolt_group_info group_info_xgpon_onu_stat_alarm_cleared = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 28, sizeof(bcmolt_xgpon_onu_stat_alarm_cleared_data), sizeof(bcmolt_xgpon_onu_stat_alarm_cleared), offsetof(bcmolt_xgpon_onu_stat_alarm_cleared, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_stat_alarm_cleared_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_stat_alarm_cleared_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_stat_alarm_cleared_data_unpack, bcmolt_xgpon_onu_stat_alarm_cleared_data_scan };
static bcmolt_group_info group_info_xgpon_onu_stat_alarm_raised = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 29, sizeof(bcmolt_xgpon_onu_stat_alarm_raised_data), sizeof(bcmolt_xgpon_onu_stat_alarm_raised), offsetof(bcmolt_xgpon_onu_stat_alarm_raised, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_stat_alarm_raised_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_stat_alarm_raised_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_stat_alarm_raised_data_unpack, bcmolt_xgpon_onu_stat_alarm_raised_data_scan };
static bcmolt_group_info group_info_xgpon_onu_sufi = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 30, sizeof(bcmolt_xgpon_onu_sufi_data), sizeof(bcmolt_xgpon_onu_sufi), offsetof(bcmolt_xgpon_onu_sufi, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_sufi_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_sufi_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_sufi_data_unpack, bcmolt_xgpon_onu_sufi_data_scan };
static bcmolt_group_info group_info_xgpon_onu_tiwi = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 31, sizeof(bcmolt_xgpon_onu_tiwi_data), sizeof(bcmolt_xgpon_onu_tiwi), offsetof(bcmolt_xgpon_onu_tiwi, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_tiwi_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_tiwi_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_tiwi_data_unpack, bcmolt_xgpon_onu_tiwi_data_scan };
static bcmolt_group_info group_info_xgpon_onu_tuning_response = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO, 32, sizeof(bcmolt_xgpon_onu_tuning_response_data), sizeof(bcmolt_xgpon_onu_tuning_response), offsetof(bcmolt_xgpon_onu_tuning_response, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_tuning_response_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_tuning_response_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_tuning_response_data_unpack, bcmolt_xgpon_onu_tuning_response_data_scan };
static bcmolt_group_info group_info_xgpon_onu_auto_cfg = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_AUTO_CFG, 0, sizeof(bcmolt_xgpon_onu_auto_cfg_data), sizeof(bcmolt_xgpon_onu_auto_cfg), offsetof(bcmolt_xgpon_onu_auto_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_auto_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_auto_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_auto_cfg_data_unpack, bcmolt_xgpon_onu_auto_cfg_data_scan };
static bcmolt_group_info group_info_xgpon_onu_adjust_tx_wavelength = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 0, sizeof(bcmolt_xgpon_onu_adjust_tx_wavelength_data), sizeof(bcmolt_xgpon_onu_adjust_tx_wavelength), offsetof(bcmolt_xgpon_onu_adjust_tx_wavelength, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_adjust_tx_wavelength_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_adjust_tx_wavelength_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_adjust_tx_wavelength_data_unpack, bcmolt_xgpon_onu_adjust_tx_wavelength_data_scan };
static bcmolt_group_info group_info_xgpon_onu_change_power_levelling = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 1, sizeof(bcmolt_xgpon_onu_change_power_levelling_data), sizeof(bcmolt_xgpon_onu_change_power_levelling), offsetof(bcmolt_xgpon_onu_change_power_levelling, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_change_power_levelling_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_change_power_levelling_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_change_power_levelling_data_unpack, bcmolt_xgpon_onu_change_power_levelling_data_scan };
static bcmolt_group_info group_info_xgpon_onu_get_power_consumption = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 2, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_onu_get_power_level = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 3, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_onu_onu_tuning_in = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 4, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_onu_onu_tuning_out = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 5, sizeof(bcmolt_xgpon_onu_onu_tuning_out_data), sizeof(bcmolt_xgpon_onu_onu_tuning_out), offsetof(bcmolt_xgpon_onu_onu_tuning_out, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_onu_tuning_out_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_onu_tuning_out_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_onu_tuning_out_data_unpack, bcmolt_xgpon_onu_onu_tuning_out_data_scan };
static bcmolt_group_info group_info_xgpon_onu_request_registration = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 6, sizeof(bcmolt_xgpon_onu_request_registration_data), sizeof(bcmolt_xgpon_onu_request_registration), offsetof(bcmolt_xgpon_onu_request_registration, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_request_registration_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_request_registration_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_request_registration_data_unpack, bcmolt_xgpon_onu_request_registration_data_scan };
static bcmolt_group_info group_info_xgpon_onu_rssi_measurement = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 7, 0, 0, 0, NULL, NULL, NULL };
static bcmolt_group_info group_info_xgpon_onu_secure_mutual_authentication = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 8, sizeof(bcmolt_xgpon_onu_secure_mutual_authentication_data), sizeof(bcmolt_xgpon_onu_secure_mutual_authentication), offsetof(bcmolt_xgpon_onu_secure_mutual_authentication, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_secure_mutual_authentication_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_secure_mutual_authentication_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_secure_mutual_authentication_data_unpack, bcmolt_xgpon_onu_secure_mutual_authentication_data_scan };
static bcmolt_group_info group_info_xgpon_onu_set_onu_state = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_OPER, 9, sizeof(bcmolt_xgpon_onu_set_onu_state_data), sizeof(bcmolt_xgpon_onu_set_onu_state), offsetof(bcmolt_xgpon_onu_set_onu_state, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_set_onu_state_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_set_onu_state_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_set_onu_state_data_unpack, bcmolt_xgpon_onu_set_onu_state_data_scan };
static bcmolt_group_info group_info_xgpon_onu_cpu_packets = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_PROXY, 0, sizeof(bcmolt_xgpon_onu_cpu_packets_data), sizeof(bcmolt_xgpon_onu_cpu_packets), offsetof(bcmolt_xgpon_onu_cpu_packets, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_cpu_packets_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_cpu_packets_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_cpu_packets_data_unpack, bcmolt_xgpon_onu_cpu_packets_data_scan };
static bcmolt_group_info group_info_xgpon_onu_ploam_packet = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_PROXY, 1, sizeof(bcmolt_xgpon_onu_ploam_packet_data), sizeof(bcmolt_xgpon_onu_ploam_packet), offsetof(bcmolt_xgpon_onu_ploam_packet, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_ploam_packet_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_ploam_packet_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_ploam_packet_data_unpack, bcmolt_xgpon_onu_ploam_packet_data_scan };
static bcmolt_group_info group_info_xgpon_onu_cpu_packet = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_PROXY_RX, 0, sizeof(bcmolt_xgpon_onu_cpu_packet_data), sizeof(bcmolt_xgpon_onu_cpu_packet), offsetof(bcmolt_xgpon_onu_cpu_packet, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_cpu_packet_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_cpu_packet_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_cpu_packet_data_unpack, bcmolt_xgpon_onu_cpu_packet_data_scan };
static bcmolt_group_info group_info_xgpon_onu_omci_packet = { BCMOLT_OBJ_ID_XGPON_ONU, BCMOLT_MGT_GROUP_PROXY_RX, 1, sizeof(bcmolt_xgpon_onu_omci_packet_data), sizeof(bcmolt_xgpon_onu_omci_packet), offsetof(bcmolt_xgpon_onu_omci_packet, data), (bcmolt_func_packed_len) bcmolt_xgpon_onu_omci_packet_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_onu_omci_packet_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_onu_omci_packet_data_unpack, bcmolt_xgpon_onu_omci_packet_data_scan };
static bcmolt_group_info group_info_xgpon_trx_key = { BCMOLT_OBJ_ID_XGPON_TRX, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_xgpon_trx_key), 0, 0, (bcmolt_func_packed_len) bcmolt_xgpon_trx_key_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_trx_key_pack, (bcmolt_func_unpack) bcmolt_xgpon_trx_key_unpack, bcmolt_xgpon_trx_key_scan };
static bcmolt_group_info group_info_xgpon_trx_cfg = { BCMOLT_OBJ_ID_XGPON_TRX, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_xgpon_trx_cfg_data), sizeof(bcmolt_xgpon_trx_cfg), offsetof(bcmolt_xgpon_trx_cfg, data), (bcmolt_func_packed_len) bcmolt_xgpon_trx_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xgpon_trx_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xgpon_trx_cfg_data_unpack, bcmolt_xgpon_trx_cfg_data_scan };
static bcmolt_group_info group_info_xpon_serdes_key = { BCMOLT_OBJ_ID_XPON_SERDES, BCMOLT_MGT_GROUP_KEY, 0, sizeof(bcmolt_xpon_serdes_key), 0, 0, (bcmolt_func_packed_len) bcmolt_xpon_serdes_key_get_packed_length, (bcmolt_func_pack) bcmolt_xpon_serdes_key_pack, (bcmolt_func_unpack) bcmolt_xpon_serdes_key_unpack, bcmolt_xpon_serdes_key_scan };
static bcmolt_group_info group_info_xpon_serdes_cfg = { BCMOLT_OBJ_ID_XPON_SERDES, BCMOLT_MGT_GROUP_CFG, 0, sizeof(bcmolt_xpon_serdes_cfg_data), sizeof(bcmolt_xpon_serdes_cfg), offsetof(bcmolt_xpon_serdes_cfg, data), (bcmolt_func_packed_len) bcmolt_xpon_serdes_cfg_data_get_packed_length, (bcmolt_func_pack) bcmolt_xpon_serdes_cfg_data_pack, (bcmolt_func_unpack) bcmolt_xpon_serdes_cfg_data_unpack, bcmolt_xpon_serdes_cfg_data_scan };
static bcmolt_group_info *group_info[] =
{
    &group_info_ae_ni_key,
    &group_info_ae_ni_cfg,
    &group_info_ae_ni_set_ae_ni_en_state,
    &group_info_ae_path_ds_key,
    &group_info_ae_path_ds_stat,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_cfg,
    &group_info_ae_path_ds_stat_alarm_cleared,
    &group_info_ae_path_ds_stat_alarm_raised,
    &group_info_ae_path_ds_auto_cfg,
    &group_info_ae_path_us_key,
    &group_info_ae_path_us_stat,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_cfg,
    &group_info_ae_path_us_stat_alarm_cleared,
    &group_info_ae_path_us_stat_alarm_raised,
    &group_info_ae_path_us_auto_cfg,
    &group_info_channel_key,
    &group_info_channel_cfg,
    &group_info_debug_key,
    &group_info_debug_cfg,
    &group_info_debug_cli_output,
    &group_info_debug_file_almost_full,
    &group_info_debug_auto_cfg,
    &group_info_debug_cli_input,
    &group_info_debug_reset_api_capture,
    &group_info_debug_start_api_capture,
    &group_info_debug_stop_api_capture,
    &group_info_device_key,
    &group_info_device_cfg,
    &group_info_device_connection_complete,
    &group_info_device_connection_established,
    &group_info_device_connection_failure,
    &group_info_device_ddr_test_complete,
    &group_info_device_device_keep_alive,
    &group_info_device_device_ready,
    &group_info_device_disconnection_complete,
    &group_info_device_image_transfer_complete,
    &group_info_device_indications_dropped,
    &group_info_device_sw_error,
    &group_info_device_sw_exception,
    &group_info_device_auto_cfg,
    &group_info_device_connect,
    &group_info_device_disconnect,
    &group_info_device_host_keep_alive,
    &group_info_device_image_transfer_data,
    &group_info_device_image_transfer_start,
    &group_info_device_reset,
    &group_info_device_run_ddr_test,
    &group_info_device_sw_upgrade_activate,
    &group_info_epon_denied_link_key,
    &group_info_epon_denied_link_cfg,
    &group_info_epon_denied_link_laser_on_off_violation,
    &group_info_epon_denied_link_llid_pool_empty_violation,
    &group_info_epon_denied_link_max_link_violation,
    &group_info_epon_denied_link_overhead_profile_violation,
    &group_info_epon_denied_link_range_violation,
    &group_info_epon_denied_link_rogue_violation,
    &group_info_epon_denied_link_system_resource_violation,
    &group_info_epon_denied_link_tdm_channels_exhausted,
    &group_info_epon_denied_link_unknown_link_violation,
    &group_info_epon_denied_link_upstream_bandwidth_violation,
    &group_info_epon_denied_link_auto_cfg,
    &group_info_epon_link_key,
    &group_info_epon_link_cfg,
    &group_info_epon_link_stat,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_stat_cfg,
    &group_info_epon_link_duplicate_mpcp_registration_request,
    &group_info_epon_link_encryption_enabled,
    &group_info_epon_link_key_exchange_failure,
    &group_info_epon_link_key_exchange_started,
    &group_info_epon_link_key_exchange_stopped,
    &group_info_epon_link_link_deleted,
    &group_info_epon_link_link_speed_mismatch,
    &group_info_epon_link_mpcp_deregistered,
    &group_info_epon_link_mpcp_discovered,
    &group_info_epon_link_mpcp_reg_ack_timeout,
    &group_info_epon_link_mpcp_report_timeout,
    &group_info_epon_link_oam_keepalive_timeout,
    &group_info_epon_link_oam_keepalive_timer_started,
    &group_info_epon_link_oam_keepalive_timer_stopped,
    &group_info_epon_link_preprovisioned_link_created,
    &group_info_epon_link_protection_switch_occurred,
    &group_info_epon_link_range_value_changed,
    &group_info_epon_link_rerange_failure,
    &group_info_epon_link_stat_alarm_cleared,
    &group_info_epon_link_stat_alarm_raised,
    &group_info_epon_link_static_registration_done,
    &group_info_epon_link_auto_cfg,
    &group_info_epon_link_delete_link,
    &group_info_epon_link_force_rediscovery,
    &group_info_epon_link_key_exchange_start,
    &group_info_epon_link_key_exchange_stop,
    &group_info_epon_link_oam_keepalive_timer_start,
    &group_info_epon_link_oam_keepalive_timer_stop,
    &group_info_epon_link_static_registration,
    &group_info_epon_link_inject_frame,
    &group_info_epon_link_frame_captured,
    &group_info_epon_ni_key,
    &group_info_epon_ni_cfg,
    &group_info_epon_ni_auto_rogue_scan_10g_failure,
    &group_info_epon_ni_auto_rogue_scan_1g_failure,
    &group_info_epon_ni_llid_quarantined,
    &group_info_epon_ni_mpcp_timestamp_changed,
    &group_info_epon_ni_no_reports,
    &group_info_epon_ni_onu_upgrade_complete,
    &group_info_epon_ni_rerange_failure,
    &group_info_epon_ni_rogue_scan_complete,
    &group_info_epon_ni_rssi_measurement_completed,
    &group_info_epon_ni_state_change_completed,
    &group_info_epon_ni_auto_cfg,
    &group_info_epon_ni_add_link,
    &group_info_epon_ni_add_multicast_link,
    &group_info_epon_ni_add_protected_standby_link,
    &group_info_epon_ni_issue_rssi_grant,
    &group_info_epon_ni_protection_switching_apply_rerange_delta,
    &group_info_epon_ni_rogue_llid_scan,
    &group_info_epon_ni_set_epon_ni_en_state,
    &group_info_epon_ni_start_onu_upgrade,
    &group_info_epon_onu_10g_us_key,
    &group_info_epon_onu_10g_us_cfg,
    &group_info_epon_onu_10g_us_stat,
    &group_info_epon_onu_10g_us_stat_cfg,
    &group_info_epon_onu_10g_us_stat_cfg,
    &group_info_epon_onu_10g_us_stat_cfg,
    &group_info_epon_onu_10g_us_stat_cfg,
    &group_info_epon_onu_10g_us_stat_alarm_cleared,
    &group_info_epon_onu_10g_us_stat_alarm_raised,
    &group_info_epon_onu_10g_us_auto_cfg,
    &group_info_epon_onu_1g_us_key,
    &group_info_epon_onu_1g_us_cfg,
    &group_info_epon_onu_1g_us_stat,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_cfg,
    &group_info_epon_onu_1g_us_stat_alarm_cleared,
    &group_info_epon_onu_1g_us_stat_alarm_raised,
    &group_info_epon_onu_1g_us_auto_cfg,
    &group_info_epon_path_10g_ds_key,
    &group_info_epon_path_10g_ds_cfg,
    &group_info_epon_path_10g_ds_stat,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_cfg,
    &group_info_epon_path_10g_ds_stat_alarm_cleared,
    &group_info_epon_path_10g_ds_stat_alarm_raised,
    &group_info_epon_path_10g_ds_auto_cfg,
    &group_info_epon_path_10g_us_key,
    &group_info_epon_path_10g_us_cfg,
    &group_info_epon_path_10g_us_stat,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_cfg,
    &group_info_epon_path_10g_us_stat_alarm_cleared,
    &group_info_epon_path_10g_us_stat_alarm_raised,
    &group_info_epon_path_10g_us_auto_cfg,
    &group_info_epon_path_1g_ds_key,
    &group_info_epon_path_1g_ds_cfg,
    &group_info_epon_path_1g_ds_stat,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_cfg,
    &group_info_epon_path_1g_ds_stat_alarm_cleared,
    &group_info_epon_path_1g_ds_stat_alarm_raised,
    &group_info_epon_path_1g_ds_auto_cfg,
    &group_info_epon_path_1g_us_key,
    &group_info_epon_path_1g_us_cfg,
    &group_info_epon_path_1g_us_stat,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_cfg,
    &group_info_epon_path_1g_us_stat_alarm_cleared,
    &group_info_epon_path_1g_us_stat_alarm_raised,
    &group_info_epon_path_1g_us_auto_cfg,
    &group_info_epon_rp_key,
    &group_info_epon_rp_cfg,
    &group_info_gpio_key,
    &group_info_gpio_cfg,
    &group_info_gpon_alloc_key,
    &group_info_gpon_alloc_cfg,
    &group_info_gpon_alloc_stat,
    &group_info_gpon_alloc_stat_cfg,
    &group_info_gpon_alloc_configuration_completed,
    &group_info_gpon_alloc_get_alloc_stats_completed,
    &group_info_gpon_alloc_stat_alarm_cleared,
    &group_info_gpon_alloc_stat_alarm_raised,
    &group_info_gpon_alloc_auto_cfg,
    &group_info_gpon_alloc_get_stats,
    &group_info_gpon_alloc_set_state,
    &group_info_gpon_gem_port_key,
    &group_info_gpon_gem_port_cfg,
    &group_info_gpon_gem_port_stat,
    &group_info_gpon_gem_port_stat_cfg,
    &group_info_gpon_gem_port_stat_cfg,
    &group_info_gpon_gem_port_stat_cfg,
    &group_info_gpon_gem_port_stat_cfg,
    &group_info_gpon_gem_port_configuration_completed,
    &group_info_gpon_gem_port_stat_alarm_cleared,
    &group_info_gpon_gem_port_stat_alarm_raised,
    &group_info_gpon_gem_port_auto_cfg,
    &group_info_gpon_gem_port_set_state,
    &group_info_gpon_iwf_key,
    &group_info_gpon_iwf_cfg,
    &group_info_gpon_iwf_stat,
    &group_info_gpon_iwf_stat_cfg,
    &group_info_gpon_iwf_stat_cfg,
    &group_info_gpon_iwf_stat_cfg,
    &group_info_gpon_iwf_stat_cfg,
    &group_info_gpon_iwf_stat_cfg,
    &group_info_gpon_iwf_stat_cfg,
    &group_info_gpon_iwf_stat_cfg,
    &group_info_gpon_iwf_stat_cfg,
    &group_info_gpon_iwf_flush_mac_table_completed,
    &group_info_gpon_iwf_scan_mac_table_completed,
    &group_info_gpon_iwf_stat_alarm_cleared,
    &group_info_gpon_iwf_stat_alarm_raised,
    &group_info_gpon_iwf_auto_cfg,
    &group_info_gpon_iwf_flush_mac_table,
    &group_info_gpon_iwf_scan_mac_table,
    &group_info_gpon_iwf_ds_egress_flow_key,
    &group_info_gpon_iwf_ds_egress_flow_cfg,
    &group_info_gpon_iwf_ds_ingress_flow_key,
    &group_info_gpon_iwf_ds_ingress_flow_cfg,
    &group_info_gpon_iwf_mac_table_key,
    &group_info_gpon_iwf_mac_table_cfg,
    &group_info_gpon_iwf_mac_table_mac_aged,
    &group_info_gpon_iwf_mac_table_mac_dropped,
    &group_info_gpon_iwf_mac_table_mac_move,
    &group_info_gpon_iwf_mac_table_new_mac,
    &group_info_gpon_iwf_mac_table_auto_cfg,
    &group_info_gpon_iwf_us_flow_key,
    &group_info_gpon_iwf_us_flow_cfg,
    &group_info_gpon_ni_key,
    &group_info_gpon_ni_cfg,
    &group_info_gpon_ni_stat,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_stat_cfg,
    &group_info_gpon_ni_activate_all_onus_completed,
    &group_info_gpon_ni_cpu_packets_failure,
    &group_info_gpon_ni_deactivate_all_onus_completed,
    &group_info_gpon_ni_disable_all_onus_completed,
    &group_info_gpon_ni_enable_all_onus_completed,
    &group_info_gpon_ni_los,
    &group_info_gpon_ni_onu_discovered,
    &group_info_gpon_ni_onu_upgrade_complete,
    &group_info_gpon_ni_protection_switching_onus_ranged,
    &group_info_gpon_ni_protection_switching_switchover_completed,
    &group_info_gpon_ni_protection_switching_traffic_resume,
    &group_info_gpon_ni_rogue_detection_completed,
    &group_info_gpon_ni_rogue_onu_special_map_cycle_start,
    &group_info_gpon_ni_serial_number_acquisition_cycle_start,
    &group_info_gpon_ni_standby_pon_monitoring_cycle_completed,
    &group_info_gpon_ni_stat_alarm_cleared,
    &group_info_gpon_ni_stat_alarm_raised,
    &group_info_gpon_ni_state_change_completed,
    &group_info_gpon_ni_tod_request_completed,
    &group_info_gpon_ni_auto_cfg,
    &group_info_gpon_ni_disable_serial_number,
    &group_info_gpon_ni_protection_switching_type_c_set_multiple_onu_state,
    &group_info_gpon_ni_reset,
    &group_info_gpon_ni_rogue_detection_window,
    &group_info_gpon_ni_set_onu_state,
    &group_info_gpon_ni_set_pon_state,
    &group_info_gpon_ni_single_request_standby_pon_monitoring,
    &group_info_gpon_ni_start_onu_upgrade,
    &group_info_gpon_ni_tod_request,
    &group_info_gpon_ni_broadcast_ploam_packet,
    &group_info_gpon_ni_cpu_packets,
    &group_info_gpon_onu_key,
    &group_info_gpon_onu_cfg,
    &group_info_gpon_onu_stat,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_stat_cfg,
    &group_info_gpon_onu_ber_interval_configuration_completed,
    &group_info_gpon_onu_dfi,
    &group_info_gpon_onu_dgi,
    &group_info_gpon_onu_dowi,
    &group_info_gpon_onu_err,
    &group_info_gpon_onu_invalid_dbru_report,
    &group_info_gpon_onu_key_exchange_completed,
    &group_info_gpon_onu_key_exchange_cycle_skipped,
    &group_info_gpon_onu_key_exchange_decrypt_required,
    &group_info_gpon_onu_key_exchange_key_mismatch,
    &group_info_gpon_onu_key_exchange_key_request_timeout,
    &group_info_gpon_onu_key_exchange_unconsecutive_index,
    &group_info_gpon_onu_loai,
    &group_info_gpon_onu_loki,
    &group_info_gpon_onu_memi,
    &group_info_gpon_onu_omci_port_id_configuration_completed,
    &group_info_gpon_onu_onu_activation_completed,
    &group_info_gpon_onu_onu_activation_standby_completed,
    &group_info_gpon_onu_onu_alarm,
    &group_info_gpon_onu_onu_deactivation_completed,
    &group_info_gpon_onu_onu_disable_completed,
    &group_info_gpon_onu_onu_enable_completed,
    &group_info_gpon_onu_optical_reflection,
    &group_info_gpon_onu_password_authentication_completed,
    &group_info_gpon_onu_pee,
    &group_info_gpon_onu_possible_drift,
    &group_info_gpon_onu_power_management_state_change,
    &group_info_gpon_onu_pst,
    &group_info_gpon_onu_ranging_completed,
    &group_info_gpon_onu_rei,
    &group_info_gpon_onu_rssi_measurement_completed,
    &group_info_gpon_onu_sdi,
    &group_info_gpon_onu_sfi,
    &group_info_gpon_onu_stat_alarm_cleared,
    &group_info_gpon_onu_stat_alarm_raised,
    &group_info_gpon_onu_sufi,
    &group_info_gpon_onu_tiwi,
    &group_info_gpon_onu_auto_cfg,
    &group_info_gpon_onu_change_power_level,
    &group_info_gpon_onu_rssi_measurement,
    &group_info_gpon_onu_set_onu_state,
    &group_info_gpon_onu_cpu_packets,
    &group_info_gpon_onu_ploam_packet,
    &group_info_gpon_onu_cpu_packet,
    &group_info_gpon_onu_omci_packet,
    &group_info_gpon_trx_key,
    &group_info_gpon_trx_cfg,
    &group_info_log_entry_key,
    &group_info_log_entry_cfg,
    &group_info_log_entry_stat,
    &group_info_log_entry_stat_cfg,
    &group_info_log_entry_stat_cfg,
    &group_info_log_entry_stat_alarm_cleared,
    &group_info_log_entry_stat_alarm_raised,
    &group_info_log_entry_auto_cfg,
    &group_info_logger_key,
    &group_info_logger_cfg,
    &group_info_logger_stat,
    &group_info_logger_stat_cfg,
    &group_info_logger_stat_alarm_cleared,
    &group_info_logger_stat_alarm_raised,
    &group_info_logger_auto_cfg,
    &group_info_logger_clear_log,
    &group_info_nni_key,
    &group_info_nni_cfg,
    &group_info_nni_stat,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_cfg,
    &group_info_nni_stat_alarm_cleared,
    &group_info_nni_stat_alarm_raised,
    &group_info_nni_status_changed,
    &group_info_nni_auto_cfg,
    &group_info_nni_serdes_key,
    &group_info_nni_serdes_cfg,
    &group_info_software_error_key,
    &group_info_software_error_cfg,
    &group_info_trx_calibration_key,
    &group_info_trx_calibration_capture_window_and_statistic_completed,
    &group_info_trx_calibration_auto_cfg,
    &group_info_trx_calibration_start_capture_window,
    &group_info_trx_calibration_stop_capture_window,
    &group_info_xgpon_alloc_key,
    &group_info_xgpon_alloc_cfg,
    &group_info_xgpon_alloc_stat,
    &group_info_xgpon_alloc_stat_cfg,
    &group_info_xgpon_alloc_configuration_completed,
    &group_info_xgpon_alloc_get_alloc_stats_completed,
    &group_info_xgpon_alloc_stat_alarm_cleared,
    &group_info_xgpon_alloc_stat_alarm_raised,
    &group_info_xgpon_alloc_auto_cfg,
    &group_info_xgpon_alloc_get_stats,
    &group_info_xgpon_alloc_set_state,
    &group_info_xgpon_gem_port_key,
    &group_info_xgpon_gem_port_cfg,
    &group_info_xgpon_gem_port_stat,
    &group_info_xgpon_gem_port_stat_cfg,
    &group_info_xgpon_gem_port_stat_cfg,
    &group_info_xgpon_gem_port_stat_cfg,
    &group_info_xgpon_gem_port_stat_cfg,
    &group_info_xgpon_gem_port_stat_alarm_cleared,
    &group_info_xgpon_gem_port_stat_alarm_raised,
    &group_info_xgpon_gem_port_auto_cfg,
    &group_info_xgpon_iwf_key,
    &group_info_xgpon_iwf_cfg,
    &group_info_xgpon_ni_key,
    &group_info_xgpon_ni_cfg,
    &group_info_xgpon_ni_stat,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_stat_cfg,
    &group_info_xgpon_ni_activate_all_onus_completed,
    &group_info_xgpon_ni_cpu_packets_failure,
    &group_info_xgpon_ni_deactivate_all_onus_completed,
    &group_info_xgpon_ni_disable_all_onus_completed,
    &group_info_xgpon_ni_enable_all_onus_completed,
    &group_info_xgpon_ni_los,
    &group_info_xgpon_ni_onu_discovered,
    &group_info_xgpon_ni_onu_upgrade_complete,
    &group_info_xgpon_ni_protection_switching_onus_ranged,
    &group_info_xgpon_ni_protection_switching_switchover_completed,
    &group_info_xgpon_ni_protection_switching_traffic_resume,
    &group_info_xgpon_ni_rogue_detection_completed,
    &group_info_xgpon_ni_rogue_onu_special_map_cycle_start,
    &group_info_xgpon_ni_serial_number_acquisition_cycle_start,
    &group_info_xgpon_ni_standby_pon_monitoring_cycle_completed,
    &group_info_xgpon_ni_stat_alarm_cleared,
    &group_info_xgpon_ni_stat_alarm_raised,
    &group_info_xgpon_ni_state_change_completed,
    &group_info_xgpon_ni_tod_request_completed,
    &group_info_xgpon_ni_auto_cfg,
    &group_info_xgpon_ni_adjust_tx_wavelength,
    &group_info_xgpon_ni_disable_serial_number,
    &group_info_xgpon_ni_reset,
    &group_info_xgpon_ni_rogue_detection_window,
    &group_info_xgpon_ni_run_special_bw_map,
    &group_info_xgpon_ni_set_onu_state,
    &group_info_xgpon_ni_set_pon_state,
    &group_info_xgpon_ni_single_request_standby_pon_monitoring,
    &group_info_xgpon_ni_start_onu_upgrade,
    &group_info_xgpon_ni_tod_request,
    &group_info_xgpon_ni_broadcast_ploam_packet,
    &group_info_xgpon_ni_cpu_packets,
    &group_info_xgpon_onu_key,
    &group_info_xgpon_onu_cfg,
    &group_info_xgpon_onu_stat,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_stat_cfg,
    &group_info_xgpon_onu_dfi,
    &group_info_xgpon_onu_dgi,
    &group_info_xgpon_onu_dowi,
    &group_info_xgpon_onu_invalid_dbru_report,
    &group_info_xgpon_onu_key_exchange_completed,
    &group_info_xgpon_onu_key_exchange_cycle_skipped,
    &group_info_xgpon_onu_key_exchange_key_mismatch,
    &group_info_xgpon_onu_key_exchange_key_request_timeout,
    &group_info_xgpon_onu_looci,
    &group_info_xgpon_onu_onu_activation_completed,
    &group_info_xgpon_onu_onu_alarm,
    &group_info_xgpon_onu_onu_deactivation_completed,
    &group_info_xgpon_onu_onu_disable_completed,
    &group_info_xgpon_onu_onu_enable_completed,
    &group_info_xgpon_onu_onu_tuning_in_completed,
    &group_info_xgpon_onu_onu_tuning_out_completed,
    &group_info_xgpon_onu_optical_reflection,
    &group_info_xgpon_onu_possible_drift,
    &group_info_xgpon_onu_power_consumption_report,
    &group_info_xgpon_onu_power_level_report,
    &group_info_xgpon_onu_power_management_state_change,
    &group_info_xgpon_onu_pqsi,
    &group_info_xgpon_onu_ranging_completed,
    &group_info_xgpon_onu_registration_id,
    &group_info_xgpon_onu_rssi_measurement_completed,
    &group_info_xgpon_onu_sdi,
    &group_info_xgpon_onu_secure_mutual_authentication_failure,
    &group_info_xgpon_onu_sfi,
    &group_info_xgpon_onu_stat_alarm_cleared,
    &group_info_xgpon_onu_stat_alarm_raised,
    &group_info_xgpon_onu_sufi,
    &group_info_xgpon_onu_tiwi,
    &group_info_xgpon_onu_tuning_response,
    &group_info_xgpon_onu_auto_cfg,
    &group_info_xgpon_onu_adjust_tx_wavelength,
    &group_info_xgpon_onu_change_power_levelling,
    &group_info_xgpon_onu_get_power_consumption,
    &group_info_xgpon_onu_get_power_level,
    &group_info_xgpon_onu_onu_tuning_in,
    &group_info_xgpon_onu_onu_tuning_out,
    &group_info_xgpon_onu_request_registration,
    &group_info_xgpon_onu_rssi_measurement,
    &group_info_xgpon_onu_secure_mutual_authentication,
    &group_info_xgpon_onu_set_onu_state,
    &group_info_xgpon_onu_cpu_packets,
    &group_info_xgpon_onu_ploam_packet,
    &group_info_xgpon_onu_cpu_packet,
    &group_info_xgpon_onu_omci_packet,
    &group_info_xgpon_trx_key,
    &group_info_xgpon_trx_cfg,
    &group_info_xpon_serdes_key,
    &group_info_xpon_serdes_cfg
};
static bcmolt_group_id group_ids_ae_ni_key[] = { BCMOLT_GROUP_ID_AE_NI_KEY };
static bcmolt_group_id group_ids_ae_ni_cfg[] = { BCMOLT_GROUP_ID_AE_NI_CFG };
static bcmolt_group_id group_ids_ae_ni_oper[] = { BCMOLT_GROUP_ID_AE_NI_SET_AE_NI_EN_STATE };
static bcmolt_group_id group_ids_ae_path_ds_key[] = { BCMOLT_GROUP_ID_AE_PATH_DS_KEY };
static bcmolt_group_id group_ids_ae_path_ds_stat[] = { BCMOLT_GROUP_ID_AE_PATH_DS_STAT };
static bcmolt_group_id group_ids_ae_path_ds_stat_cfg[] = { BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_BYTES, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_64, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_65_127, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_128_255, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_256_511, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_512_1023, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_1024_1518, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_1519_2047, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_2048_4095, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_4096_9216, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_9217_16383, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_BROADCAST_FRAMES, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_DATA_BYTES, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_MULTICAST_FRAMES, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_UNICAST_FRAMES, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_ABORT_FRAMES };
static bcmolt_group_id group_ids_ae_path_ds_auto[] = { BCMOLT_GROUP_ID_AE_PATH_DS_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_AE_PATH_DS_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_ae_path_ds_auto_cfg[] = { BCMOLT_GROUP_ID_AE_PATH_DS_AUTO_CFG };
static bcmolt_group_id group_ids_ae_path_us_key[] = { BCMOLT_GROUP_ID_AE_PATH_US_KEY };
static bcmolt_group_id group_ids_ae_path_us_stat[] = { BCMOLT_GROUP_ID_AE_PATH_US_STAT };
static bcmolt_group_id group_ids_ae_path_us_stat_cfg[] = { BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_BYTES, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_64, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_65_127, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_128_255, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_256_511, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_512_1023, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_1024_1518, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_1519_2047, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_2048_4095, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_4096_9216, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_9217_16383, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_BROADCAST_FRAMES, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_DATA_BYTES, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_MULTICAST_FRAMES, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_UNICAST_FRAMES, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_ABORT_FRAMES, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FCS_ERROR, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_OVERSIZE_ERROR, BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_RUNT_ERROR };
static bcmolt_group_id group_ids_ae_path_us_auto[] = { BCMOLT_GROUP_ID_AE_PATH_US_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_AE_PATH_US_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_ae_path_us_auto_cfg[] = { BCMOLT_GROUP_ID_AE_PATH_US_AUTO_CFG };
static bcmolt_group_id group_ids_channel_key[] = { BCMOLT_GROUP_ID_CHANNEL_KEY };
static bcmolt_group_id group_ids_channel_cfg[] = { BCMOLT_GROUP_ID_CHANNEL_CFG };
static bcmolt_group_id group_ids_debug_key[] = { BCMOLT_GROUP_ID_DEBUG_KEY };
static bcmolt_group_id group_ids_debug_cfg[] = { BCMOLT_GROUP_ID_DEBUG_CFG };
static bcmolt_group_id group_ids_debug_auto[] = { BCMOLT_GROUP_ID_DEBUG_CLI_OUTPUT, BCMOLT_GROUP_ID_DEBUG_FILE_ALMOST_FULL };
static bcmolt_group_id group_ids_debug_auto_cfg[] = { BCMOLT_GROUP_ID_DEBUG_AUTO_CFG };
static bcmolt_group_id group_ids_debug_oper[] = { BCMOLT_GROUP_ID_DEBUG_CLI_INPUT, BCMOLT_GROUP_ID_DEBUG_RESET_API_CAPTURE, BCMOLT_GROUP_ID_DEBUG_START_API_CAPTURE, BCMOLT_GROUP_ID_DEBUG_STOP_API_CAPTURE };
static bcmolt_group_id group_ids_device_key[] = { BCMOLT_GROUP_ID_DEVICE_KEY };
static bcmolt_group_id group_ids_device_cfg[] = { BCMOLT_GROUP_ID_DEVICE_CFG };
static bcmolt_group_id group_ids_device_auto[] = { BCMOLT_GROUP_ID_DEVICE_CONNECTION_COMPLETE, BCMOLT_GROUP_ID_DEVICE_CONNECTION_ESTABLISHED, BCMOLT_GROUP_ID_DEVICE_CONNECTION_FAILURE, BCMOLT_GROUP_ID_DEVICE_DDR_TEST_COMPLETE, BCMOLT_GROUP_ID_DEVICE_DEVICE_KEEP_ALIVE, BCMOLT_GROUP_ID_DEVICE_DEVICE_READY, BCMOLT_GROUP_ID_DEVICE_DISCONNECTION_COMPLETE, BCMOLT_GROUP_ID_DEVICE_IMAGE_TRANSFER_COMPLETE, BCMOLT_GROUP_ID_DEVICE_INDICATIONS_DROPPED, BCMOLT_GROUP_ID_DEVICE_SW_ERROR, BCMOLT_GROUP_ID_DEVICE_SW_EXCEPTION };
static bcmolt_group_id group_ids_device_auto_cfg[] = { BCMOLT_GROUP_ID_DEVICE_AUTO_CFG };
static bcmolt_group_id group_ids_device_oper[] = { BCMOLT_GROUP_ID_DEVICE_CONNECT, BCMOLT_GROUP_ID_DEVICE_DISCONNECT, BCMOLT_GROUP_ID_DEVICE_HOST_KEEP_ALIVE, BCMOLT_GROUP_ID_DEVICE_IMAGE_TRANSFER_DATA, BCMOLT_GROUP_ID_DEVICE_IMAGE_TRANSFER_START, BCMOLT_GROUP_ID_DEVICE_RESET, BCMOLT_GROUP_ID_DEVICE_RUN_DDR_TEST, BCMOLT_GROUP_ID_DEVICE_SW_UPGRADE_ACTIVATE };
static bcmolt_group_id group_ids_epon_denied_link_key[] = { BCMOLT_GROUP_ID_EPON_DENIED_LINK_KEY };
static bcmolt_group_id group_ids_epon_denied_link_cfg[] = { BCMOLT_GROUP_ID_EPON_DENIED_LINK_CFG };
static bcmolt_group_id group_ids_epon_denied_link_auto[] = { BCMOLT_GROUP_ID_EPON_DENIED_LINK_LASER_ON_OFF_VIOLATION, BCMOLT_GROUP_ID_EPON_DENIED_LINK_LLID_POOL_EMPTY_VIOLATION, BCMOLT_GROUP_ID_EPON_DENIED_LINK_MAX_LINK_VIOLATION, BCMOLT_GROUP_ID_EPON_DENIED_LINK_OVERHEAD_PROFILE_VIOLATION, BCMOLT_GROUP_ID_EPON_DENIED_LINK_RANGE_VIOLATION, BCMOLT_GROUP_ID_EPON_DENIED_LINK_ROGUE_VIOLATION, BCMOLT_GROUP_ID_EPON_DENIED_LINK_SYSTEM_RESOURCE_VIOLATION, BCMOLT_GROUP_ID_EPON_DENIED_LINK_TDM_CHANNELS_EXHAUSTED, BCMOLT_GROUP_ID_EPON_DENIED_LINK_UNKNOWN_LINK_VIOLATION, BCMOLT_GROUP_ID_EPON_DENIED_LINK_UPSTREAM_BANDWIDTH_VIOLATION };
static bcmolt_group_id group_ids_epon_denied_link_auto_cfg[] = { BCMOLT_GROUP_ID_EPON_DENIED_LINK_AUTO_CFG };
static bcmolt_group_id group_ids_epon_link_key[] = { BCMOLT_GROUP_ID_EPON_LINK_KEY };
static bcmolt_group_id group_ids_epon_link_cfg[] = { BCMOLT_GROUP_ID_EPON_LINK_CFG };
static bcmolt_group_id group_ids_epon_link_stat[] = { BCMOLT_GROUP_ID_EPON_LINK_STAT };
static bcmolt_group_id group_ids_epon_link_stat_cfg[] = { BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_DATA_BYTES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_DATA_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_64, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_65_127, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_128_255, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_256_511, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_512_1023, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_1024_1518, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_1519_2047, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_2048_4095, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_4096_9216, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_9217_16383, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_OAM_BYTES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_OAM_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_MPCP_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_BROADCAST_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_UNICAST_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_MULTICAST_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_REPORT_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FCS_ERROR, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_OVERSIZE_ERROR, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_RUNT_ERROR, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_LINE_CODE_ERROR, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_LINE_CODE_ERROR_MAX, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_DATA_BYTES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_DATA_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_64, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_65_127, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_128_255, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_256_511, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_512_1023, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_1024_1518, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_1519_2047, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_2048_4095, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_4096_9216, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_9217_16383, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_OAM_BYTES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_OAM_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_MPCP_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_BROADCAST_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_UNICAST_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_MULTICAST_FRAMES, BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_GATES };
static bcmolt_group_id group_ids_epon_link_auto[] = { BCMOLT_GROUP_ID_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST, BCMOLT_GROUP_ID_EPON_LINK_ENCRYPTION_ENABLED, BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_FAILURE, BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_STARTED, BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_STOPPED, BCMOLT_GROUP_ID_EPON_LINK_LINK_DELETED, BCMOLT_GROUP_ID_EPON_LINK_LINK_SPEED_MISMATCH, BCMOLT_GROUP_ID_EPON_LINK_MPCP_DEREGISTERED, BCMOLT_GROUP_ID_EPON_LINK_MPCP_DISCOVERED, BCMOLT_GROUP_ID_EPON_LINK_MPCP_REG_ACK_TIMEOUT, BCMOLT_GROUP_ID_EPON_LINK_MPCP_REPORT_TIMEOUT, BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMEOUT, BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMER_STARTED, BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMER_STOPPED, BCMOLT_GROUP_ID_EPON_LINK_PREPROVISIONED_LINK_CREATED, BCMOLT_GROUP_ID_EPON_LINK_PROTECTION_SWITCH_OCCURRED, BCMOLT_GROUP_ID_EPON_LINK_RANGE_VALUE_CHANGED, BCMOLT_GROUP_ID_EPON_LINK_RERANGE_FAILURE, BCMOLT_GROUP_ID_EPON_LINK_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_EPON_LINK_STAT_ALARM_RAISED, BCMOLT_GROUP_ID_EPON_LINK_STATIC_REGISTRATION_DONE };
static bcmolt_group_id group_ids_epon_link_auto_cfg[] = { BCMOLT_GROUP_ID_EPON_LINK_AUTO_CFG };
static bcmolt_group_id group_ids_epon_link_oper[] = { BCMOLT_GROUP_ID_EPON_LINK_DELETE_LINK, BCMOLT_GROUP_ID_EPON_LINK_FORCE_REDISCOVERY, BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_START, BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_STOP, BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMER_START, BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMER_STOP, BCMOLT_GROUP_ID_EPON_LINK_STATIC_REGISTRATION };
static bcmolt_group_id group_ids_epon_link_proxy[] = { BCMOLT_GROUP_ID_EPON_LINK_INJECT_FRAME };
static bcmolt_group_id group_ids_epon_link_proxy_rx[] = { BCMOLT_GROUP_ID_EPON_LINK_FRAME_CAPTURED };
static bcmolt_group_id group_ids_epon_ni_key[] = { BCMOLT_GROUP_ID_EPON_NI_KEY };
static bcmolt_group_id group_ids_epon_ni_cfg[] = { BCMOLT_GROUP_ID_EPON_NI_CFG };
static bcmolt_group_id group_ids_epon_ni_auto[] = { BCMOLT_GROUP_ID_EPON_NI_AUTO_ROGUE_SCAN_10G_FAILURE, BCMOLT_GROUP_ID_EPON_NI_AUTO_ROGUE_SCAN_1G_FAILURE, BCMOLT_GROUP_ID_EPON_NI_LLID_QUARANTINED, BCMOLT_GROUP_ID_EPON_NI_MPCP_TIMESTAMP_CHANGED, BCMOLT_GROUP_ID_EPON_NI_NO_REPORTS, BCMOLT_GROUP_ID_EPON_NI_ONU_UPGRADE_COMPLETE, BCMOLT_GROUP_ID_EPON_NI_RERANGE_FAILURE, BCMOLT_GROUP_ID_EPON_NI_ROGUE_SCAN_COMPLETE, BCMOLT_GROUP_ID_EPON_NI_RSSI_MEASUREMENT_COMPLETED, BCMOLT_GROUP_ID_EPON_NI_STATE_CHANGE_COMPLETED };
static bcmolt_group_id group_ids_epon_ni_auto_cfg[] = { BCMOLT_GROUP_ID_EPON_NI_AUTO_CFG };
static bcmolt_group_id group_ids_epon_ni_oper[] = { BCMOLT_GROUP_ID_EPON_NI_ADD_LINK, BCMOLT_GROUP_ID_EPON_NI_ADD_MULTICAST_LINK, BCMOLT_GROUP_ID_EPON_NI_ADD_PROTECTED_STANDBY_LINK, BCMOLT_GROUP_ID_EPON_NI_ISSUE_RSSI_GRANT, BCMOLT_GROUP_ID_EPON_NI_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA, BCMOLT_GROUP_ID_EPON_NI_ROGUE_LLID_SCAN, BCMOLT_GROUP_ID_EPON_NI_SET_EPON_NI_EN_STATE, BCMOLT_GROUP_ID_EPON_NI_START_ONU_UPGRADE };
static bcmolt_group_id group_ids_epon_onu_10g_us_key[] = { BCMOLT_GROUP_ID_EPON_ONU_10G_US_KEY };
static bcmolt_group_id group_ids_epon_onu_10g_us_cfg[] = { BCMOLT_GROUP_ID_EPON_ONU_10G_US_CFG };
static bcmolt_group_id group_ids_epon_onu_10g_us_stat[] = { BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT };
static bcmolt_group_id group_ids_epon_onu_10g_us_stat_cfg[] = { BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_CFG_FEC_CODE_WORDS_TOTAL, BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_CFG_FEC_CODE_WORDS_DECODE_FAILS, BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_CFG_FEC_ZEROES_CORRECTED, BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_CFG_FEC_ONES_CORRECTED };
static bcmolt_group_id group_ids_epon_onu_10g_us_auto[] = { BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_epon_onu_10g_us_auto_cfg[] = { BCMOLT_GROUP_ID_EPON_ONU_10G_US_AUTO_CFG };
static bcmolt_group_id group_ids_epon_onu_1g_us_key[] = { BCMOLT_GROUP_ID_EPON_ONU_1G_US_KEY };
static bcmolt_group_id group_ids_epon_onu_1g_us_cfg[] = { BCMOLT_GROUP_ID_EPON_ONU_1G_US_CFG };
static bcmolt_group_id group_ids_epon_onu_1g_us_stat[] = { BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT };
static bcmolt_group_id group_ids_epon_onu_1g_us_stat_cfg[] = { BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_GOOD_FRAMES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_GOOD_BYTES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_OVERSZ_FRAMES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_NON_FEC_GOOD_FRAMES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_NON_FEC_GOOD_BYTES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_GOOD_FRAMES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_GOOD_BYTES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_FRAMES_EXC_ERRS, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_BLKS_NO_ERRS, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_BLKS_CORR_ERRS, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_BLKS_UNCORR_ERRS, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_CORR_BYTES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_CORR_ZEROES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_CORR_ONES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_UNDERSZ_FRAMES, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_ERRORSZ_FRAMES };
static bcmolt_group_id group_ids_epon_onu_1g_us_auto[] = { BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_epon_onu_1g_us_auto_cfg[] = { BCMOLT_GROUP_ID_EPON_ONU_1G_US_AUTO_CFG };
static bcmolt_group_id group_ids_epon_path_10g_ds_key[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_DS_KEY };
static bcmolt_group_id group_ids_epon_path_10g_ds_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_DS_CFG };
static bcmolt_group_id group_ids_epon_path_10g_ds_stat[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT };
static bcmolt_group_id group_ids_epon_path_10g_ds_stat_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_BYTES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_64, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_65_127, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_128_255, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_256_511, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_512_1023, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_1024_1518, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_1519_2047, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_2048_4095, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_4096_9216, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_9217_16383, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_BROADCAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_DATA_BYTES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_MULTICAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_UNICAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_OAM_BYTES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_OAM_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_GATE_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_MPCP_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_ABORT_FRAMES };
static bcmolt_group_id group_ids_epon_path_10g_ds_auto[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_epon_path_10g_ds_auto_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_DS_AUTO_CFG };
static bcmolt_group_id group_ids_epon_path_10g_us_key[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_US_KEY };
static bcmolt_group_id group_ids_epon_path_10g_us_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_US_CFG };
static bcmolt_group_id group_ids_epon_path_10g_us_stat[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT };
static bcmolt_group_id group_ids_epon_path_10g_us_stat_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_BYTES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_64, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_65_127, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_128_255, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_256_511, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_512_1023, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_1024_1518, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_1519_2047, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_2048_4095, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_4096_9216, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_9217_16383, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_BROADCAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_DATA_BYTES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_MULTICAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_UNICAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_MPCP_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_OAM_BYTES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_OAM_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_REPORT_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_ABORT_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FCS_ERROR, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_CRC_8_ERROR, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_OUT_OF_SLOT, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_OVERSIZE_ERROR, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_RUNT_ERROR };
static bcmolt_group_id group_ids_epon_path_10g_us_auto[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_epon_path_10g_us_auto_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_10G_US_AUTO_CFG };
static bcmolt_group_id group_ids_epon_path_1g_ds_key[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_DS_KEY };
static bcmolt_group_id group_ids_epon_path_1g_ds_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_DS_CFG };
static bcmolt_group_id group_ids_epon_path_1g_ds_stat[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT };
static bcmolt_group_id group_ids_epon_path_1g_ds_stat_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_BYTES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_64, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_65_127, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_128_255, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_256_511, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_512_1023, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_1024_1518, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_1519_2047, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_2048_4095, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_4096_9216, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_9217_16383, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_BROADCAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_DATA_BYTES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_MULTICAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_UNICAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_OAM_BYTES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_OAM_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_GATE_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_MPCP_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_ABORT_FRAMES };
static bcmolt_group_id group_ids_epon_path_1g_ds_auto[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_epon_path_1g_ds_auto_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_DS_AUTO_CFG };
static bcmolt_group_id group_ids_epon_path_1g_us_key[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_US_KEY };
static bcmolt_group_id group_ids_epon_path_1g_us_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_US_CFG };
static bcmolt_group_id group_ids_epon_path_1g_us_stat[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT };
static bcmolt_group_id group_ids_epon_path_1g_us_stat_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_BYTES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_64, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_65_127, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_128_255, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_256_511, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_512_1023, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_1024_1518, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_1519_2047, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_2048_4095, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_4096_9216, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_9217_16383, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_BROADCAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_DATA_BYTES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_MULTICAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_UNICAST_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_MPCP_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_OAM_BYTES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_OAM_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_REPORT_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_ABORT_FRAMES, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FCS_ERROR, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_CRC_8_ERROR, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_OUT_OF_SLOT, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_OVERSIZE_ERROR, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_RUNT_ERROR };
static bcmolt_group_id group_ids_epon_path_1g_us_auto[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_epon_path_1g_us_auto_cfg[] = { BCMOLT_GROUP_ID_EPON_PATH_1G_US_AUTO_CFG };
static bcmolt_group_id group_ids_epon_rp_key[] = { BCMOLT_GROUP_ID_EPON_RP_KEY };
static bcmolt_group_id group_ids_epon_rp_cfg[] = { BCMOLT_GROUP_ID_EPON_RP_CFG };
static bcmolt_group_id group_ids_gpio_key[] = { BCMOLT_GROUP_ID_GPIO_KEY };
static bcmolt_group_id group_ids_gpio_cfg[] = { BCMOLT_GROUP_ID_GPIO_CFG };
static bcmolt_group_id group_ids_gpon_alloc_key[] = { BCMOLT_GROUP_ID_GPON_ALLOC_KEY };
static bcmolt_group_id group_ids_gpon_alloc_cfg[] = { BCMOLT_GROUP_ID_GPON_ALLOC_CFG };
static bcmolt_group_id group_ids_gpon_alloc_stat[] = { BCMOLT_GROUP_ID_GPON_ALLOC_STAT };
static bcmolt_group_id group_ids_gpon_alloc_stat_cfg[] = { BCMOLT_GROUP_ID_GPON_ALLOC_STAT_CFG_RX_BYTES };
static bcmolt_group_id group_ids_gpon_alloc_auto[] = { BCMOLT_GROUP_ID_GPON_ALLOC_CONFIGURATION_COMPLETED, BCMOLT_GROUP_ID_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED, BCMOLT_GROUP_ID_GPON_ALLOC_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_GPON_ALLOC_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_gpon_alloc_auto_cfg[] = { BCMOLT_GROUP_ID_GPON_ALLOC_AUTO_CFG };
static bcmolt_group_id group_ids_gpon_alloc_oper[] = { BCMOLT_GROUP_ID_GPON_ALLOC_GET_STATS, BCMOLT_GROUP_ID_GPON_ALLOC_SET_STATE };
static bcmolt_group_id group_ids_gpon_gem_port_key[] = { BCMOLT_GROUP_ID_GPON_GEM_PORT_KEY };
static bcmolt_group_id group_ids_gpon_gem_port_cfg[] = { BCMOLT_GROUP_ID_GPON_GEM_PORT_CFG };
static bcmolt_group_id group_ids_gpon_gem_port_stat[] = { BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT };
static bcmolt_group_id group_ids_gpon_gem_port_stat_cfg[] = { BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_CFG_RX_PACKETS, BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_CFG_RX_BYTES, BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_CFG_TX_PACKETS, BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_CFG_TX_BYTES };
static bcmolt_group_id group_ids_gpon_gem_port_auto[] = { BCMOLT_GROUP_ID_GPON_GEM_PORT_CONFIGURATION_COMPLETED, BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_gpon_gem_port_auto_cfg[] = { BCMOLT_GROUP_ID_GPON_GEM_PORT_AUTO_CFG };
static bcmolt_group_id group_ids_gpon_gem_port_oper[] = { BCMOLT_GROUP_ID_GPON_GEM_PORT_SET_STATE };
static bcmolt_group_id group_ids_gpon_iwf_key[] = { BCMOLT_GROUP_ID_GPON_IWF_KEY };
static bcmolt_group_id group_ids_gpon_iwf_cfg[] = { BCMOLT_GROUP_ID_GPON_IWF_CFG };
static bcmolt_group_id group_ids_gpon_iwf_stat[] = { BCMOLT_GROUP_ID_GPON_IWF_STAT };
static bcmolt_group_id group_ids_gpon_iwf_stat_cfg[] = { BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_HIT_EVENT, BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_MISS_EVENT, BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_DROP_DUE_TO_MISS_EVENT, BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_DROP_DUE_TO_HIT_EVENT, BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_DROP_TO_DISABLED_GEM, BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_NEW_MAC_DISCOVERED, BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_MOVE_EVENT, BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_NEW_MAC_DROP_DUE_TO_FIFO_FULL };
static bcmolt_group_id group_ids_gpon_iwf_auto[] = { BCMOLT_GROUP_ID_GPON_IWF_FLUSH_MAC_TABLE_COMPLETED, BCMOLT_GROUP_ID_GPON_IWF_SCAN_MAC_TABLE_COMPLETED, BCMOLT_GROUP_ID_GPON_IWF_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_GPON_IWF_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_gpon_iwf_auto_cfg[] = { BCMOLT_GROUP_ID_GPON_IWF_AUTO_CFG };
static bcmolt_group_id group_ids_gpon_iwf_oper[] = { BCMOLT_GROUP_ID_GPON_IWF_FLUSH_MAC_TABLE, BCMOLT_GROUP_ID_GPON_IWF_SCAN_MAC_TABLE };
static bcmolt_group_id group_ids_gpon_iwf_ds_egress_flow_key[] = { BCMOLT_GROUP_ID_GPON_IWF_DS_EGRESS_FLOW_KEY };
static bcmolt_group_id group_ids_gpon_iwf_ds_egress_flow_cfg[] = { BCMOLT_GROUP_ID_GPON_IWF_DS_EGRESS_FLOW_CFG };
static bcmolt_group_id group_ids_gpon_iwf_ds_ingress_flow_key[] = { BCMOLT_GROUP_ID_GPON_IWF_DS_INGRESS_FLOW_KEY };
static bcmolt_group_id group_ids_gpon_iwf_ds_ingress_flow_cfg[] = { BCMOLT_GROUP_ID_GPON_IWF_DS_INGRESS_FLOW_CFG };
static bcmolt_group_id group_ids_gpon_iwf_mac_table_key[] = { BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_KEY };
static bcmolt_group_id group_ids_gpon_iwf_mac_table_cfg[] = { BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_CFG };
static bcmolt_group_id group_ids_gpon_iwf_mac_table_auto[] = { BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_MAC_AGED, BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_MAC_DROPPED, BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_MAC_MOVE, BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_NEW_MAC };
static bcmolt_group_id group_ids_gpon_iwf_mac_table_auto_cfg[] = { BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_AUTO_CFG };
static bcmolt_group_id group_ids_gpon_iwf_us_flow_key[] = { BCMOLT_GROUP_ID_GPON_IWF_US_FLOW_KEY };
static bcmolt_group_id group_ids_gpon_iwf_us_flow_cfg[] = { BCMOLT_GROUP_ID_GPON_IWF_US_FLOW_CFG };
static bcmolt_group_id group_ids_gpon_ni_key[] = { BCMOLT_GROUP_ID_GPON_NI_KEY };
static bcmolt_group_id group_ids_gpon_ni_cfg[] = { BCMOLT_GROUP_ID_GPON_NI_CFG };
static bcmolt_group_id group_ids_gpon_ni_stat[] = { BCMOLT_GROUP_ID_GPON_NI_STAT };
static bcmolt_group_id group_ids_gpon_ni_stat_cfg[] = { BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_FEC_CODEWORDS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_FEC_CODEWORDS_UNCORRECTED, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_BIP8_BYTES, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_BIP8_ERRORS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_PACKETS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_DROPPED, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_IDLE, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_CORRECTED, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_ILLEGAL, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_ALLOCATIONS_VALID, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_ALLOCATIONS_INVALID, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_ALLOCATIONS_DISABLED, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PLOAMS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PLOAMS_NON_IDLE, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PLOAMS_ERROR, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PLOAMS_DROPPED, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_CPU, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_OMCI, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_OMCI_PACKETS_CRC_ERROR, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_DROPPED_TOO_SHORT, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_DROPPED_TOO_LONG, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_CRC_ERRORS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_KEY_ERRORS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_FRAGMENTS_ERRORS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PACKETS_DROPPED, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_GEM, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_PLOAMS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_GEM_FRAGMENTS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_CPU, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_OMCI, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_CPU_OMCI_PACKETS_DROPPED, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_DROPPED_ILLEGAL_LENGTH, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_DROPPED_TPID_MISS, BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_DROPPED_VID_MISS };
static bcmolt_group_id group_ids_gpon_ni_auto[] = { BCMOLT_GROUP_ID_GPON_NI_ACTIVATE_ALL_ONUS_COMPLETED, BCMOLT_GROUP_ID_GPON_NI_CPU_PACKETS_FAILURE, BCMOLT_GROUP_ID_GPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED, BCMOLT_GROUP_ID_GPON_NI_DISABLE_ALL_ONUS_COMPLETED, BCMOLT_GROUP_ID_GPON_NI_ENABLE_ALL_ONUS_COMPLETED, BCMOLT_GROUP_ID_GPON_NI_LOS, BCMOLT_GROUP_ID_GPON_NI_ONU_DISCOVERED, BCMOLT_GROUP_ID_GPON_NI_ONU_UPGRADE_COMPLETE, BCMOLT_GROUP_ID_GPON_NI_PROTECTION_SWITCHING_ONUS_RANGED, BCMOLT_GROUP_ID_GPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED, BCMOLT_GROUP_ID_GPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME, BCMOLT_GROUP_ID_GPON_NI_ROGUE_DETECTION_COMPLETED, BCMOLT_GROUP_ID_GPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START, BCMOLT_GROUP_ID_GPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START, BCMOLT_GROUP_ID_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED, BCMOLT_GROUP_ID_GPON_NI_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_GPON_NI_STAT_ALARM_RAISED, BCMOLT_GROUP_ID_GPON_NI_STATE_CHANGE_COMPLETED, BCMOLT_GROUP_ID_GPON_NI_TOD_REQUEST_COMPLETED };
static bcmolt_group_id group_ids_gpon_ni_auto_cfg[] = { BCMOLT_GROUP_ID_GPON_NI_AUTO_CFG };
static bcmolt_group_id group_ids_gpon_ni_oper[] = { BCMOLT_GROUP_ID_GPON_NI_DISABLE_SERIAL_NUMBER, BCMOLT_GROUP_ID_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE, BCMOLT_GROUP_ID_GPON_NI_RESET, BCMOLT_GROUP_ID_GPON_NI_ROGUE_DETECTION_WINDOW, BCMOLT_GROUP_ID_GPON_NI_SET_ONU_STATE, BCMOLT_GROUP_ID_GPON_NI_SET_PON_STATE, BCMOLT_GROUP_ID_GPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING, BCMOLT_GROUP_ID_GPON_NI_START_ONU_UPGRADE, BCMOLT_GROUP_ID_GPON_NI_TOD_REQUEST };
static bcmolt_group_id group_ids_gpon_ni_proxy[] = { BCMOLT_GROUP_ID_GPON_NI_BROADCAST_PLOAM_PACKET, BCMOLT_GROUP_ID_GPON_NI_CPU_PACKETS };
static bcmolt_group_id group_ids_gpon_onu_key[] = { BCMOLT_GROUP_ID_GPON_ONU_KEY };
static bcmolt_group_id group_ids_gpon_onu_cfg[] = { BCMOLT_GROUP_ID_GPON_ONU_CFG };
static bcmolt_group_id group_ids_gpon_onu_stat[] = { BCMOLT_GROUP_ID_GPON_ONU_STAT };
static bcmolt_group_id group_ids_gpon_onu_stat_cfg[] = { BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_FEC_CODEWORDS, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_FEC_BYTES_CORRECTED, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_FEC_CODEWORDS_CORRECTED, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_FEC_CODEWORDS_UNCORRECTED, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_BIP8_BYTES, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_BIP8_ERRORS, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_PLOAMS_CRC_ERROR, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_PLOAMS_NON_IDLE, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_POSITIVE_DRIFT, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_NEGATIVE_DRIFT, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_OMCI, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_OMCI_PACKETS_CRC_ERROR, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_BER_REPORTED, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_UNRECEIVED_BURST, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_LCDG_ERRORS, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RDI_ERRORS, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_BYTES, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_PACKETS, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_TX_BYTES, BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_TX_PACKETS };
static bcmolt_group_id group_ids_gpon_onu_auto[] = { BCMOLT_GROUP_ID_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_DFI, BCMOLT_GROUP_ID_GPON_ONU_DGI, BCMOLT_GROUP_ID_GPON_ONU_DOWI, BCMOLT_GROUP_ID_GPON_ONU_ERR, BCMOLT_GROUP_ID_GPON_ONU_INVALID_DBRU_REPORT, BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED, BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_DECRYPT_REQUIRED, BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH, BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT, BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX, BCMOLT_GROUP_ID_GPON_ONU_LOAI, BCMOLT_GROUP_ID_GPON_ONU_LOKI, BCMOLT_GROUP_ID_GPON_ONU_MEMI, BCMOLT_GROUP_ID_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_ONU_ACTIVATION_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_ONU_ACTIVATION_STANDBY_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_ONU_ALARM, BCMOLT_GROUP_ID_GPON_ONU_ONU_DEACTIVATION_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_ONU_DISABLE_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_ONU_ENABLE_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_OPTICAL_REFLECTION, BCMOLT_GROUP_ID_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_PEE, BCMOLT_GROUP_ID_GPON_ONU_POSSIBLE_DRIFT, BCMOLT_GROUP_ID_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE, BCMOLT_GROUP_ID_GPON_ONU_PST, BCMOLT_GROUP_ID_GPON_ONU_RANGING_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_REI, BCMOLT_GROUP_ID_GPON_ONU_RSSI_MEASUREMENT_COMPLETED, BCMOLT_GROUP_ID_GPON_ONU_SDI, BCMOLT_GROUP_ID_GPON_ONU_SFI, BCMOLT_GROUP_ID_GPON_ONU_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_GPON_ONU_STAT_ALARM_RAISED, BCMOLT_GROUP_ID_GPON_ONU_SUFI, BCMOLT_GROUP_ID_GPON_ONU_TIWI };
static bcmolt_group_id group_ids_gpon_onu_auto_cfg[] = { BCMOLT_GROUP_ID_GPON_ONU_AUTO_CFG };
static bcmolt_group_id group_ids_gpon_onu_oper[] = { BCMOLT_GROUP_ID_GPON_ONU_CHANGE_POWER_LEVEL, BCMOLT_GROUP_ID_GPON_ONU_RSSI_MEASUREMENT, BCMOLT_GROUP_ID_GPON_ONU_SET_ONU_STATE };
static bcmolt_group_id group_ids_gpon_onu_proxy[] = { BCMOLT_GROUP_ID_GPON_ONU_CPU_PACKETS, BCMOLT_GROUP_ID_GPON_ONU_PLOAM_PACKET };
static bcmolt_group_id group_ids_gpon_onu_proxy_rx[] = { BCMOLT_GROUP_ID_GPON_ONU_CPU_PACKET, BCMOLT_GROUP_ID_GPON_ONU_OMCI_PACKET };
static bcmolt_group_id group_ids_gpon_trx_key[] = { BCMOLT_GROUP_ID_GPON_TRX_KEY };
static bcmolt_group_id group_ids_gpon_trx_cfg[] = { BCMOLT_GROUP_ID_GPON_TRX_CFG };
static bcmolt_group_id group_ids_log_entry_key[] = { BCMOLT_GROUP_ID_LOG_ENTRY_KEY };
static bcmolt_group_id group_ids_log_entry_cfg[] = { BCMOLT_GROUP_ID_LOG_ENTRY_CFG };
static bcmolt_group_id group_ids_log_entry_stat[] = { BCMOLT_GROUP_ID_LOG_ENTRY_STAT };
static bcmolt_group_id group_ids_log_entry_stat_cfg[] = { BCMOLT_GROUP_ID_LOG_ENTRY_STAT_CFG_MSG_COUNT, BCMOLT_GROUP_ID_LOG_ENTRY_STAT_CFG_LOST_MSG_COUNT };
static bcmolt_group_id group_ids_log_entry_auto[] = { BCMOLT_GROUP_ID_LOG_ENTRY_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_LOG_ENTRY_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_log_entry_auto_cfg[] = { BCMOLT_GROUP_ID_LOG_ENTRY_AUTO_CFG };
static bcmolt_group_id group_ids_logger_key[] = { BCMOLT_GROUP_ID_LOGGER_KEY };
static bcmolt_group_id group_ids_logger_cfg[] = { BCMOLT_GROUP_ID_LOGGER_CFG };
static bcmolt_group_id group_ids_logger_stat[] = { BCMOLT_GROUP_ID_LOGGER_STAT };
static bcmolt_group_id group_ids_logger_stat_cfg[] = { BCMOLT_GROUP_ID_LOGGER_STAT_CFG_LINES_IN_LOG };
static bcmolt_group_id group_ids_logger_auto[] = { BCMOLT_GROUP_ID_LOGGER_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_LOGGER_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_logger_auto_cfg[] = { BCMOLT_GROUP_ID_LOGGER_AUTO_CFG };
static bcmolt_group_id group_ids_logger_oper[] = { BCMOLT_GROUP_ID_LOGGER_CLEAR_LOG };
static bcmolt_group_id group_ids_nni_key[] = { BCMOLT_GROUP_ID_NNI_KEY };
static bcmolt_group_id group_ids_nni_cfg[] = { BCMOLT_GROUP_ID_NNI_CFG };
static bcmolt_group_id group_ids_nni_stat[] = { BCMOLT_GROUP_ID_NNI_STAT };
static bcmolt_group_id group_ids_nni_stat_cfg[] = { BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_64, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_65_127, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_128_255, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_256_511, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_512_1023, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_1024_1518, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_1519_2047, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_2048_4095, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_4096_9216, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_9217_16383, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_BYTES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_GOOD_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_UNICAST_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_MULTICAST_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_BROADCAST_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FCS_ERRORS, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_CONTROL_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_PAUSE_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_PFC_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_UNSUPPORTED_OPCODE, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_UNSUPPORTED_DA, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_ALIGNMENT_ERRORS, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_LENGTH_OUT_OF_RANGE, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_CODE_ERRORS, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_OVERSIZED_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_JABBER_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_MTU_CHECK_ERRORS, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_PROMISCUOUS_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_VLAN_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_DOUBLE_VLAN_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_TRUNCATED_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_UNDERSIZE_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAGMENTED_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_RUNT_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_64, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_65_127, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_128_255, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_256_511, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_512_1023, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_1024_1518, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_1519_2047, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_2048_4095, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_4096_9216, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_9217_16383, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_BYTES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_GOOD_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_UNICAST_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_MULTICAST_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_BROADCAST_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_PAUSE_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_PFC_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_JABBER_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FCS_ERRORS, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_CONTROL_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_OVERSIZE_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAGMENTED_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_ERROR_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_VLAN_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_DOUBLE_VLAN_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_RUNT_FRAMES, BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_UNDERRUN_FRAMES };
static bcmolt_group_id group_ids_nni_auto[] = { BCMOLT_GROUP_ID_NNI_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_NNI_STAT_ALARM_RAISED, BCMOLT_GROUP_ID_NNI_STATUS_CHANGED };
static bcmolt_group_id group_ids_nni_auto_cfg[] = { BCMOLT_GROUP_ID_NNI_AUTO_CFG };
static bcmolt_group_id group_ids_nni_serdes_key[] = { BCMOLT_GROUP_ID_NNI_SERDES_KEY };
static bcmolt_group_id group_ids_nni_serdes_cfg[] = { BCMOLT_GROUP_ID_NNI_SERDES_CFG };
static bcmolt_group_id group_ids_software_error_key[] = { BCMOLT_GROUP_ID_SOFTWARE_ERROR_KEY };
static bcmolt_group_id group_ids_software_error_cfg[] = { BCMOLT_GROUP_ID_SOFTWARE_ERROR_CFG };
static bcmolt_group_id group_ids_trx_calibration_key[] = { BCMOLT_GROUP_ID_TRX_CALIBRATION_KEY };
static bcmolt_group_id group_ids_trx_calibration_auto[] = { BCMOLT_GROUP_ID_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED };
static bcmolt_group_id group_ids_trx_calibration_auto_cfg[] = { BCMOLT_GROUP_ID_TRX_CALIBRATION_AUTO_CFG };
static bcmolt_group_id group_ids_trx_calibration_oper[] = { BCMOLT_GROUP_ID_TRX_CALIBRATION_START_CAPTURE_WINDOW, BCMOLT_GROUP_ID_TRX_CALIBRATION_STOP_CAPTURE_WINDOW };
static bcmolt_group_id group_ids_xgpon_alloc_key[] = { BCMOLT_GROUP_ID_XGPON_ALLOC_KEY };
static bcmolt_group_id group_ids_xgpon_alloc_cfg[] = { BCMOLT_GROUP_ID_XGPON_ALLOC_CFG };
static bcmolt_group_id group_ids_xgpon_alloc_stat[] = { BCMOLT_GROUP_ID_XGPON_ALLOC_STAT };
static bcmolt_group_id group_ids_xgpon_alloc_stat_cfg[] = { BCMOLT_GROUP_ID_XGPON_ALLOC_STAT_CFG_RX_BYTES };
static bcmolt_group_id group_ids_xgpon_alloc_auto[] = { BCMOLT_GROUP_ID_XGPON_ALLOC_CONFIGURATION_COMPLETED, BCMOLT_GROUP_ID_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED, BCMOLT_GROUP_ID_XGPON_ALLOC_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_XGPON_ALLOC_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_xgpon_alloc_auto_cfg[] = { BCMOLT_GROUP_ID_XGPON_ALLOC_AUTO_CFG };
static bcmolt_group_id group_ids_xgpon_alloc_oper[] = { BCMOLT_GROUP_ID_XGPON_ALLOC_GET_STATS, BCMOLT_GROUP_ID_XGPON_ALLOC_SET_STATE };
static bcmolt_group_id group_ids_xgpon_gem_port_key[] = { BCMOLT_GROUP_ID_XGPON_GEM_PORT_KEY };
static bcmolt_group_id group_ids_xgpon_gem_port_cfg[] = { BCMOLT_GROUP_ID_XGPON_GEM_PORT_CFG };
static bcmolt_group_id group_ids_xgpon_gem_port_stat[] = { BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT };
static bcmolt_group_id group_ids_xgpon_gem_port_stat_cfg[] = { BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_CFG_TX_BYTES, BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_CFG_TX_PACKETS, BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_CFG_RX_PACKETS, BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_CFG_RX_BYTES };
static bcmolt_group_id group_ids_xgpon_gem_port_auto[] = { BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_ALARM_RAISED };
static bcmolt_group_id group_ids_xgpon_gem_port_auto_cfg[] = { BCMOLT_GROUP_ID_XGPON_GEM_PORT_AUTO_CFG };
static bcmolt_group_id group_ids_xgpon_iwf_key[] = { BCMOLT_GROUP_ID_XGPON_IWF_KEY };
static bcmolt_group_id group_ids_xgpon_iwf_cfg[] = { BCMOLT_GROUP_ID_XGPON_IWF_CFG };
static bcmolt_group_id group_ids_xgpon_ni_key[] = { BCMOLT_GROUP_ID_XGPON_NI_KEY };
static bcmolt_group_id group_ids_xgpon_ni_cfg[] = { BCMOLT_GROUP_ID_XGPON_NI_CFG };
static bcmolt_group_id group_ids_xgpon_ni_stat[] = { BCMOLT_GROUP_ID_XGPON_NI_STAT };
static bcmolt_group_id group_ids_xgpon_ni_stat_cfg[] = { BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_FEC_CODEWORDS, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_BIP32_BYTES, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_BIP32_ERRORS, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGTC_HEADERS, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGTC_CORRECTED, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGTC_UNCORRECTED, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGEM, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGEM_DROPPED, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGEM_IDLE, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGEM_CORRECTED, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_CRC_ERROR, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_FRAGMENT_ERROR, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PACKETS_DROPPED, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_DROPPED_TOO_SHORT, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_DROPPED_TOO_LONG, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_KEY_ERROR, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_PLOAMS, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PLOAMS_DROPPED, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_ALLOCATIONS_VALID, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_ALLOCATIONS_INVALID, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_ALLOCATIONS_DISABLED, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PLOAMS, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PLOAMS_NON_IDLE, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PLOAMS_ERROR, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_CPU, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_OMCI, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_OMCI_PACKETS_CRC_ERROR, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_PACKETS, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_XGEM, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_CPU, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_OMCI, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_CPU_OMCI_PACKETS_DROPPED, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_DROPPED_ILLEGAL_LENGTH, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_DROPPED_TPID_MISS, BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_DROPPED_VID_MISS };
static bcmolt_group_id group_ids_xgpon_ni_auto[] = { BCMOLT_GROUP_ID_XGPON_NI_ACTIVATE_ALL_ONUS_COMPLETED, BCMOLT_GROUP_ID_XGPON_NI_CPU_PACKETS_FAILURE, BCMOLT_GROUP_ID_XGPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED, BCMOLT_GROUP_ID_XGPON_NI_DISABLE_ALL_ONUS_COMPLETED, BCMOLT_GROUP_ID_XGPON_NI_ENABLE_ALL_ONUS_COMPLETED, BCMOLT_GROUP_ID_XGPON_NI_LOS, BCMOLT_GROUP_ID_XGPON_NI_ONU_DISCOVERED, BCMOLT_GROUP_ID_XGPON_NI_ONU_UPGRADE_COMPLETE, BCMOLT_GROUP_ID_XGPON_NI_PROTECTION_SWITCHING_ONUS_RANGED, BCMOLT_GROUP_ID_XGPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED, BCMOLT_GROUP_ID_XGPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME, BCMOLT_GROUP_ID_XGPON_NI_ROGUE_DETECTION_COMPLETED, BCMOLT_GROUP_ID_XGPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START, BCMOLT_GROUP_ID_XGPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START, BCMOLT_GROUP_ID_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED, BCMOLT_GROUP_ID_XGPON_NI_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_XGPON_NI_STAT_ALARM_RAISED, BCMOLT_GROUP_ID_XGPON_NI_STATE_CHANGE_COMPLETED, BCMOLT_GROUP_ID_XGPON_NI_TOD_REQUEST_COMPLETED };
static bcmolt_group_id group_ids_xgpon_ni_auto_cfg[] = { BCMOLT_GROUP_ID_XGPON_NI_AUTO_CFG };
static bcmolt_group_id group_ids_xgpon_ni_oper[] = { BCMOLT_GROUP_ID_XGPON_NI_ADJUST_TX_WAVELENGTH, BCMOLT_GROUP_ID_XGPON_NI_DISABLE_SERIAL_NUMBER, BCMOLT_GROUP_ID_XGPON_NI_RESET, BCMOLT_GROUP_ID_XGPON_NI_ROGUE_DETECTION_WINDOW, BCMOLT_GROUP_ID_XGPON_NI_RUN_SPECIAL_BW_MAP, BCMOLT_GROUP_ID_XGPON_NI_SET_ONU_STATE, BCMOLT_GROUP_ID_XGPON_NI_SET_PON_STATE, BCMOLT_GROUP_ID_XGPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING, BCMOLT_GROUP_ID_XGPON_NI_START_ONU_UPGRADE, BCMOLT_GROUP_ID_XGPON_NI_TOD_REQUEST };
static bcmolt_group_id group_ids_xgpon_ni_proxy[] = { BCMOLT_GROUP_ID_XGPON_NI_BROADCAST_PLOAM_PACKET, BCMOLT_GROUP_ID_XGPON_NI_CPU_PACKETS };
static bcmolt_group_id group_ids_xgpon_onu_key[] = { BCMOLT_GROUP_ID_XGPON_ONU_KEY };
static bcmolt_group_id group_ids_xgpon_onu_cfg[] = { BCMOLT_GROUP_ID_XGPON_ONU_CFG };
static bcmolt_group_id group_ids_xgpon_onu_stat[] = { BCMOLT_GROUP_ID_XGPON_ONU_STAT };
static bcmolt_group_id group_ids_xgpon_onu_stat_cfg[] = { BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_POSITIVE_DRIFT, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_NEGATIVE_DRIFT, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_DELIMITER_MISS_DETECTION, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_BIP32_ERRORS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_WORDS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_CORRECTED_SYMBOLS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_CORRECTED_CODEWORDS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_UNCORRECTABLE_CODEWORDS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_CODEWORDS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_CORRECTED_BITS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_XGEM_KEY_ERRORS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_XGEM_LOSS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_PLOAMS_MIC_ERROR, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_PLOAMS_NON_IDLE, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_OMCI, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_OMCI_PACKETS_CRC_ERROR, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_BYTES, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_PACKETS, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_TX_BYTES, BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_TX_PACKETS };
static bcmolt_group_id group_ids_xgpon_onu_auto[] = { BCMOLT_GROUP_ID_XGPON_ONU_DFI, BCMOLT_GROUP_ID_XGPON_ONU_DGI, BCMOLT_GROUP_ID_XGPON_ONU_DOWI, BCMOLT_GROUP_ID_XGPON_ONU_INVALID_DBRU_REPORT, BCMOLT_GROUP_ID_XGPON_ONU_KEY_EXCHANGE_COMPLETED, BCMOLT_GROUP_ID_XGPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED, BCMOLT_GROUP_ID_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH, BCMOLT_GROUP_ID_XGPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT, BCMOLT_GROUP_ID_XGPON_ONU_LOOCI, BCMOLT_GROUP_ID_XGPON_ONU_ONU_ACTIVATION_COMPLETED, BCMOLT_GROUP_ID_XGPON_ONU_ONU_ALARM, BCMOLT_GROUP_ID_XGPON_ONU_ONU_DEACTIVATION_COMPLETED, BCMOLT_GROUP_ID_XGPON_ONU_ONU_DISABLE_COMPLETED, BCMOLT_GROUP_ID_XGPON_ONU_ONU_ENABLE_COMPLETED, BCMOLT_GROUP_ID_XGPON_ONU_ONU_TUNING_IN_COMPLETED, BCMOLT_GROUP_ID_XGPON_ONU_ONU_TUNING_OUT_COMPLETED, BCMOLT_GROUP_ID_XGPON_ONU_OPTICAL_REFLECTION, BCMOLT_GROUP_ID_XGPON_ONU_POSSIBLE_DRIFT, BCMOLT_GROUP_ID_XGPON_ONU_POWER_CONSUMPTION_REPORT, BCMOLT_GROUP_ID_XGPON_ONU_POWER_LEVEL_REPORT, BCMOLT_GROUP_ID_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE, BCMOLT_GROUP_ID_XGPON_ONU_PQSI, BCMOLT_GROUP_ID_XGPON_ONU_RANGING_COMPLETED, BCMOLT_GROUP_ID_XGPON_ONU_REGISTRATION_ID, BCMOLT_GROUP_ID_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED, BCMOLT_GROUP_ID_XGPON_ONU_SDI, BCMOLT_GROUP_ID_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE, BCMOLT_GROUP_ID_XGPON_ONU_SFI, BCMOLT_GROUP_ID_XGPON_ONU_STAT_ALARM_CLEARED, BCMOLT_GROUP_ID_XGPON_ONU_STAT_ALARM_RAISED, BCMOLT_GROUP_ID_XGPON_ONU_SUFI, BCMOLT_GROUP_ID_XGPON_ONU_TIWI, BCMOLT_GROUP_ID_XGPON_ONU_TUNING_RESPONSE };
static bcmolt_group_id group_ids_xgpon_onu_auto_cfg[] = { BCMOLT_GROUP_ID_XGPON_ONU_AUTO_CFG };
static bcmolt_group_id group_ids_xgpon_onu_oper[] = { BCMOLT_GROUP_ID_XGPON_ONU_ADJUST_TX_WAVELENGTH, BCMOLT_GROUP_ID_XGPON_ONU_CHANGE_POWER_LEVELLING, BCMOLT_GROUP_ID_XGPON_ONU_GET_POWER_CONSUMPTION, BCMOLT_GROUP_ID_XGPON_ONU_GET_POWER_LEVEL, BCMOLT_GROUP_ID_XGPON_ONU_ONU_TUNING_IN, BCMOLT_GROUP_ID_XGPON_ONU_ONU_TUNING_OUT, BCMOLT_GROUP_ID_XGPON_ONU_REQUEST_REGISTRATION, BCMOLT_GROUP_ID_XGPON_ONU_RSSI_MEASUREMENT, BCMOLT_GROUP_ID_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION, BCMOLT_GROUP_ID_XGPON_ONU_SET_ONU_STATE };
static bcmolt_group_id group_ids_xgpon_onu_proxy[] = { BCMOLT_GROUP_ID_XGPON_ONU_CPU_PACKETS, BCMOLT_GROUP_ID_XGPON_ONU_PLOAM_PACKET };
static bcmolt_group_id group_ids_xgpon_onu_proxy_rx[] = { BCMOLT_GROUP_ID_XGPON_ONU_CPU_PACKET, BCMOLT_GROUP_ID_XGPON_ONU_OMCI_PACKET };
static bcmolt_group_id group_ids_xgpon_trx_key[] = { BCMOLT_GROUP_ID_XGPON_TRX_KEY };
static bcmolt_group_id group_ids_xgpon_trx_cfg[] = { BCMOLT_GROUP_ID_XGPON_TRX_CFG };
static bcmolt_group_id group_ids_xpon_serdes_key[] = { BCMOLT_GROUP_ID_XPON_SERDES_KEY };
static bcmolt_group_id group_ids_xpon_serdes_cfg[] = { BCMOLT_GROUP_ID_XPON_SERDES_CFG };
static bcmolt_group_ids group_ids_obj_ae_ni[] = { { 1, group_ids_ae_ni_key }, { 1, group_ids_ae_ni_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 1, group_ids_ae_ni_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_ae_path_ds[] = { { 1, group_ids_ae_path_ds_key }, { 0, NULL }, { 1, group_ids_ae_path_ds_stat }, { 17, group_ids_ae_path_ds_stat_cfg }, { 2, group_ids_ae_path_ds_auto }, { 1, group_ids_ae_path_ds_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_ae_path_us[] = { { 1, group_ids_ae_path_us_key }, { 0, NULL }, { 1, group_ids_ae_path_us_stat }, { 20, group_ids_ae_path_us_stat_cfg }, { 2, group_ids_ae_path_us_auto }, { 1, group_ids_ae_path_us_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_channel[] = { { 1, group_ids_channel_key }, { 1, group_ids_channel_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_debug[] = { { 1, group_ids_debug_key }, { 1, group_ids_debug_cfg }, { 0, NULL }, { 0, NULL }, { 2, group_ids_debug_auto }, { 1, group_ids_debug_auto_cfg }, { 4, group_ids_debug_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_device[] = { { 1, group_ids_device_key }, { 1, group_ids_device_cfg }, { 0, NULL }, { 0, NULL }, { 11, group_ids_device_auto }, { 1, group_ids_device_auto_cfg }, { 8, group_ids_device_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_epon_denied_link[] = { { 1, group_ids_epon_denied_link_key }, { 1, group_ids_epon_denied_link_cfg }, { 0, NULL }, { 0, NULL }, { 10, group_ids_epon_denied_link_auto }, { 1, group_ids_epon_denied_link_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_epon_link[] = { { 1, group_ids_epon_link_key }, { 1, group_ids_epon_link_cfg }, { 1, group_ids_epon_link_stat }, { 43, group_ids_epon_link_stat_cfg }, { 21, group_ids_epon_link_auto }, { 1, group_ids_epon_link_auto_cfg }, { 7, group_ids_epon_link_oper }, { 1, group_ids_epon_link_proxy }, { 1, group_ids_epon_link_proxy_rx } };
static bcmolt_group_ids group_ids_obj_epon_ni[] = { { 1, group_ids_epon_ni_key }, { 1, group_ids_epon_ni_cfg }, { 0, NULL }, { 0, NULL }, { 10, group_ids_epon_ni_auto }, { 1, group_ids_epon_ni_auto_cfg }, { 8, group_ids_epon_ni_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_epon_onu_10g_us[] = { { 1, group_ids_epon_onu_10g_us_key }, { 1, group_ids_epon_onu_10g_us_cfg }, { 1, group_ids_epon_onu_10g_us_stat }, { 4, group_ids_epon_onu_10g_us_stat_cfg }, { 2, group_ids_epon_onu_10g_us_auto }, { 1, group_ids_epon_onu_10g_us_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_epon_onu_1g_us[] = { { 1, group_ids_epon_onu_1g_us_key }, { 1, group_ids_epon_onu_1g_us_cfg }, { 1, group_ids_epon_onu_1g_us_stat }, { 16, group_ids_epon_onu_1g_us_stat_cfg }, { 2, group_ids_epon_onu_1g_us_auto }, { 1, group_ids_epon_onu_1g_us_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_epon_path_10g_ds[] = { { 1, group_ids_epon_path_10g_ds_key }, { 1, group_ids_epon_path_10g_ds_cfg }, { 1, group_ids_epon_path_10g_ds_stat }, { 21, group_ids_epon_path_10g_ds_stat_cfg }, { 2, group_ids_epon_path_10g_ds_auto }, { 1, group_ids_epon_path_10g_ds_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_epon_path_10g_us[] = { { 1, group_ids_epon_path_10g_us_key }, { 1, group_ids_epon_path_10g_us_cfg }, { 1, group_ids_epon_path_10g_us_stat }, { 26, group_ids_epon_path_10g_us_stat_cfg }, { 2, group_ids_epon_path_10g_us_auto }, { 1, group_ids_epon_path_10g_us_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_epon_path_1g_ds[] = { { 1, group_ids_epon_path_1g_ds_key }, { 1, group_ids_epon_path_1g_ds_cfg }, { 1, group_ids_epon_path_1g_ds_stat }, { 21, group_ids_epon_path_1g_ds_stat_cfg }, { 2, group_ids_epon_path_1g_ds_auto }, { 1, group_ids_epon_path_1g_ds_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_epon_path_1g_us[] = { { 1, group_ids_epon_path_1g_us_key }, { 1, group_ids_epon_path_1g_us_cfg }, { 1, group_ids_epon_path_1g_us_stat }, { 26, group_ids_epon_path_1g_us_stat_cfg }, { 2, group_ids_epon_path_1g_us_auto }, { 1, group_ids_epon_path_1g_us_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_epon_rp[] = { { 1, group_ids_epon_rp_key }, { 1, group_ids_epon_rp_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpio[] = { { 1, group_ids_gpio_key }, { 1, group_ids_gpio_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpon_alloc[] = { { 1, group_ids_gpon_alloc_key }, { 1, group_ids_gpon_alloc_cfg }, { 1, group_ids_gpon_alloc_stat }, { 1, group_ids_gpon_alloc_stat_cfg }, { 4, group_ids_gpon_alloc_auto }, { 1, group_ids_gpon_alloc_auto_cfg }, { 2, group_ids_gpon_alloc_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpon_gem_port[] = { { 1, group_ids_gpon_gem_port_key }, { 1, group_ids_gpon_gem_port_cfg }, { 1, group_ids_gpon_gem_port_stat }, { 4, group_ids_gpon_gem_port_stat_cfg }, { 3, group_ids_gpon_gem_port_auto }, { 1, group_ids_gpon_gem_port_auto_cfg }, { 1, group_ids_gpon_gem_port_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpon_iwf[] = { { 1, group_ids_gpon_iwf_key }, { 1, group_ids_gpon_iwf_cfg }, { 1, group_ids_gpon_iwf_stat }, { 8, group_ids_gpon_iwf_stat_cfg }, { 4, group_ids_gpon_iwf_auto }, { 1, group_ids_gpon_iwf_auto_cfg }, { 2, group_ids_gpon_iwf_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpon_iwf_ds_egress_flow[] = { { 1, group_ids_gpon_iwf_ds_egress_flow_key }, { 1, group_ids_gpon_iwf_ds_egress_flow_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpon_iwf_ds_ingress_flow[] = { { 1, group_ids_gpon_iwf_ds_ingress_flow_key }, { 1, group_ids_gpon_iwf_ds_ingress_flow_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpon_iwf_mac_table[] = { { 1, group_ids_gpon_iwf_mac_table_key }, { 1, group_ids_gpon_iwf_mac_table_cfg }, { 0, NULL }, { 0, NULL }, { 4, group_ids_gpon_iwf_mac_table_auto }, { 1, group_ids_gpon_iwf_mac_table_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpon_iwf_us_flow[] = { { 1, group_ids_gpon_iwf_us_flow_key }, { 1, group_ids_gpon_iwf_us_flow_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpon_ni[] = { { 1, group_ids_gpon_ni_key }, { 1, group_ids_gpon_ni_cfg }, { 1, group_ids_gpon_ni_stat }, { 34, group_ids_gpon_ni_stat_cfg }, { 19, group_ids_gpon_ni_auto }, { 1, group_ids_gpon_ni_auto_cfg }, { 9, group_ids_gpon_ni_oper }, { 2, group_ids_gpon_ni_proxy }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_gpon_onu[] = { { 1, group_ids_gpon_onu_key }, { 1, group_ids_gpon_onu_cfg }, { 1, group_ids_gpon_onu_stat }, { 20, group_ids_gpon_onu_stat_cfg }, { 37, group_ids_gpon_onu_auto }, { 1, group_ids_gpon_onu_auto_cfg }, { 3, group_ids_gpon_onu_oper }, { 2, group_ids_gpon_onu_proxy }, { 2, group_ids_gpon_onu_proxy_rx } };
static bcmolt_group_ids group_ids_obj_gpon_trx[] = { { 1, group_ids_gpon_trx_key }, { 1, group_ids_gpon_trx_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_log_entry[] = { { 1, group_ids_log_entry_key }, { 1, group_ids_log_entry_cfg }, { 1, group_ids_log_entry_stat }, { 2, group_ids_log_entry_stat_cfg }, { 2, group_ids_log_entry_auto }, { 1, group_ids_log_entry_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_logger[] = { { 1, group_ids_logger_key }, { 1, group_ids_logger_cfg }, { 1, group_ids_logger_stat }, { 1, group_ids_logger_stat_cfg }, { 2, group_ids_logger_auto }, { 1, group_ids_logger_auto_cfg }, { 1, group_ids_logger_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_nni[] = { { 1, group_ids_nni_key }, { 1, group_ids_nni_cfg }, { 1, group_ids_nni_stat }, { 63, group_ids_nni_stat_cfg }, { 3, group_ids_nni_auto }, { 1, group_ids_nni_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_nni_serdes[] = { { 1, group_ids_nni_serdes_key }, { 1, group_ids_nni_serdes_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_software_error[] = { { 1, group_ids_software_error_key }, { 1, group_ids_software_error_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_trx_calibration[] = { { 1, group_ids_trx_calibration_key }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 1, group_ids_trx_calibration_auto }, { 1, group_ids_trx_calibration_auto_cfg }, { 2, group_ids_trx_calibration_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_xgpon_alloc[] = { { 1, group_ids_xgpon_alloc_key }, { 1, group_ids_xgpon_alloc_cfg }, { 1, group_ids_xgpon_alloc_stat }, { 1, group_ids_xgpon_alloc_stat_cfg }, { 4, group_ids_xgpon_alloc_auto }, { 1, group_ids_xgpon_alloc_auto_cfg }, { 2, group_ids_xgpon_alloc_oper }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_xgpon_gem_port[] = { { 1, group_ids_xgpon_gem_port_key }, { 1, group_ids_xgpon_gem_port_cfg }, { 1, group_ids_xgpon_gem_port_stat }, { 4, group_ids_xgpon_gem_port_stat_cfg }, { 2, group_ids_xgpon_gem_port_auto }, { 1, group_ids_xgpon_gem_port_auto_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_xgpon_iwf[] = { { 1, group_ids_xgpon_iwf_key }, { 1, group_ids_xgpon_iwf_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_xgpon_ni[] = { { 1, group_ids_xgpon_ni_key }, { 1, group_ids_xgpon_ni_cfg }, { 1, group_ids_xgpon_ni_stat }, { 35, group_ids_xgpon_ni_stat_cfg }, { 19, group_ids_xgpon_ni_auto }, { 1, group_ids_xgpon_ni_auto_cfg }, { 10, group_ids_xgpon_ni_oper }, { 2, group_ids_xgpon_ni_proxy }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_xgpon_onu[] = { { 1, group_ids_xgpon_onu_key }, { 1, group_ids_xgpon_onu_cfg }, { 1, group_ids_xgpon_onu_stat }, { 20, group_ids_xgpon_onu_stat_cfg }, { 33, group_ids_xgpon_onu_auto }, { 1, group_ids_xgpon_onu_auto_cfg }, { 10, group_ids_xgpon_onu_oper }, { 2, group_ids_xgpon_onu_proxy }, { 2, group_ids_xgpon_onu_proxy_rx } };
static bcmolt_group_ids group_ids_obj_xgpon_trx[] = { { 1, group_ids_xgpon_trx_key }, { 1, group_ids_xgpon_trx_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids group_ids_obj_xpon_serdes[] = { { 1, group_ids_xpon_serdes_key }, { 1, group_ids_xpon_serdes_cfg }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL }, { 0, NULL } };
static bcmolt_group_ids *group_ids[] = { group_ids_obj_ae_ni, group_ids_obj_ae_path_ds, group_ids_obj_ae_path_us, group_ids_obj_channel, group_ids_obj_debug, group_ids_obj_device, group_ids_obj_epon_denied_link, group_ids_obj_epon_link, group_ids_obj_epon_ni, group_ids_obj_epon_onu_10g_us, group_ids_obj_epon_onu_1g_us, group_ids_obj_epon_path_10g_ds, group_ids_obj_epon_path_10g_us, group_ids_obj_epon_path_1g_ds, group_ids_obj_epon_path_1g_us, group_ids_obj_epon_rp, group_ids_obj_gpio, group_ids_obj_gpon_alloc, group_ids_obj_gpon_gem_port, group_ids_obj_gpon_iwf, group_ids_obj_gpon_iwf_ds_egress_flow, group_ids_obj_gpon_iwf_ds_ingress_flow, group_ids_obj_gpon_iwf_mac_table, group_ids_obj_gpon_iwf_us_flow, group_ids_obj_gpon_ni, group_ids_obj_gpon_onu, group_ids_obj_gpon_trx, group_ids_obj_log_entry, group_ids_obj_logger, group_ids_obj_nni, group_ids_obj_nni_serdes, group_ids_obj_software_error, group_ids_obj_trx_calibration, group_ids_obj_xgpon_alloc, group_ids_obj_xgpon_gem_port, group_ids_obj_xgpon_iwf, group_ids_obj_xgpon_ni, group_ids_obj_xgpon_onu, group_ids_obj_xgpon_trx, group_ids_obj_xpon_serdes };
static bcmolt_presence_mask readonly_prop_mask[] = { (1ULL << BCMOLT_AE_NI_CFG_ID_AE_NI_EN) | (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_STATUS), 0, 0, 0, (((1ULL << BCMOLT_DEBUG_CFG_ID_INDICATIONS_DROPPED) | (1ULL << BCMOLT_DEBUG_CFG_ID_FILE_USED_PERCENT)) | (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS)) | (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER), ((((((1ULL << BCMOLT_DEVICE_CFG_ID_FIRMWARE_SW_VERSION) | (1ULL << BCMOLT_DEVICE_CFG_ID_HOST_SW_VERSION)) | (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_REVISION)) | (1ULL << BCMOLT_DEVICE_CFG_ID_STATE)) | (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_TEMPERATURE)) | (1ULL << BCMOLT_DEVICE_CFG_ID_EMBEDDED_IMAGE_LIST)) | (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_VOLTAGE), 1ULL << BCMOLT_EPON_DENIED_LINK_CFG_ID_ALARM_STATE, ((((((((((1ULL << BCMOLT_EPON_LINK_CFG_ID_LINK_RATE) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_STATE_FLAGS)) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_LLID)) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_LASER_ON_TIME_TQ)) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_LASER_OFF_TIME_TQ)) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_RANGE_VALUE_TQ)) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_DISTANCE)) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_ALARM_STATE)) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_UBD_INFO)) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_PENDING_GRANTS)) | (1ULL << BCMOLT_EPON_LINK_CFG_ID_LINK_TYPE), (((((1ULL << BCMOLT_EPON_NI_CFG_ID_EPON_NI_EN) | (1ULL << BCMOLT_EPON_NI_CFG_ID_ALARM_STATE)) | (1ULL << BCMOLT_EPON_NI_CFG_ID_ALL_LINKS)) | (1ULL << BCMOLT_EPON_NI_CFG_ID_APPROXIMATE_SOLICITED_USAGE)) | (1ULL << BCMOLT_EPON_NI_CFG_ID_APPROXIMATE_TDM_USAGE)) | (1ULL << BCMOLT_EPON_NI_CFG_ID_ESTIMATED_PON_LATENCY_TQ), 1ULL << BCMOLT_EPON_ONU_10G_US_CFG_ID_ALL_LINKS, 1ULL << BCMOLT_EPON_ONU_1G_US_CFG_ID_ALL_LINKS, 0, 1ULL << BCMOLT_EPON_PATH_10G_US_CFG_ID_PRBS_STATUS, 0, 1ULL << BCMOLT_EPON_PATH_1G_US_CFG_ID_PRBS_STATUS, 0, 0, 1ULL << BCMOLT_GPON_ALLOC_CFG_ID_STATE, 1ULL << BCMOLT_GPON_GEM_PORT_CFG_ID_GEM_PORT_STATE, 1ULL << BCMOLT_GPON_IWF_CFG_ID_MAC_TABLE_COUNT, 0, 0, (1ULL << BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_GEM_PORT_ID) | (1ULL << BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_ONU_ID), 0, (((((((1ULL << BCMOLT_GPON_NI_CFG_ID_PON_STATUS) | (1ULL << BCMOLT_GPON_NI_CFG_ID_AVAILABLE_BANDWIDTH)) | (1ULL << BCMOLT_GPON_NI_CFG_ID_NUMBER_OF_ACTIVE_ONUS)) | (1ULL << BCMOLT_GPON_NI_CFG_ID_NUMBER_OF_ACTIVE_STANDBY_ONUS)) | (1ULL << BCMOLT_GPON_NI_CFG_ID_PRBS_STATUS)) | (1ULL << BCMOLT_GPON_NI_CFG_ID_RANGING_WINDOW_SIZE)) | (1ULL << BCMOLT_GPON_NI_CFG_ID_ALL_ONUS)) | (1ULL << BCMOLT_GPON_NI_CFG_ID_ALL_MCAST_GEM_PORTS), ((((1ULL << BCMOLT_GPON_ONU_CFG_ID_ONU_STATE) | (1ULL << BCMOLT_GPON_ONU_CFG_ID_DISABLED_AFTER_DISCOVERY)) | (1ULL << BCMOLT_GPON_ONU_CFG_ID_DEACTIVATION_REASON)) | (1ULL << BCMOLT_GPON_ONU_CFG_ID_ALL_GEM_PORTS)) | (1ULL << BCMOLT_GPON_ONU_CFG_ID_ALL_ALLOCS), (1ULL << BCMOLT_GPON_TRX_CFG_ID_PLO_RANGING) | (1ULL << BCMOLT_GPON_TRX_CFG_ID_PLO_DATA), ((1ULL << BCMOLT_LOG_ENTRY_CFG_ID_DEFAULT_LOG_LEVEL) | (1ULL << BCMOLT_LOG_ENTRY_CFG_ID_DEFAULT_LOG_TYPE)) | (1ULL << BCMOLT_LOG_ENTRY_CFG_ID_LOG_NAME), (1ULL << BCMOLT_LOGGER_CFG_ID_BUFFER) | (1ULL << BCMOLT_LOGGER_CFG_ID_LOG_NAMES), (1ULL << BCMOLT_NNI_CFG_ID_NNI_STATUS) | (1ULL << BCMOLT_NNI_CFG_ID_NNI_BACKUP_STATUS), 0, 1ULL << BCMOLT_SOFTWARE_ERROR_CFG_ID_ENTRY, 0, 1ULL << BCMOLT_XGPON_ALLOC_CFG_ID_STATE, 1ULL << BCMOLT_XGPON_GEM_PORT_CFG_ID_GEM_PORT_STATE, 0, ((((((1ULL << BCMOLT_XGPON_NI_CFG_ID_AVAILABLE_BANDWIDTH) | (1ULL << BCMOLT_XGPON_NI_CFG_ID_NUMBER_OF_ACTIVE_ONUS)) | (1ULL << BCMOLT_XGPON_NI_CFG_ID_PON_STATUS)) | (1ULL << BCMOLT_XGPON_NI_CFG_ID_RANGING_WINDOW_SIZE)) | (1ULL << BCMOLT_XGPON_NI_CFG_ID_PRBS_STATUS)) | (1ULL << BCMOLT_XGPON_NI_CFG_ID_ALL_ONUS)) | (1ULL << BCMOLT_XGPON_NI_CFG_ID_ALL_MCAST_GEM_PORTS), (((((1ULL << BCMOLT_XGPON_ONU_CFG_ID_ONU_OLD_STATE) | (1ULL << BCMOLT_XGPON_ONU_CFG_ID_DISABLED_AFTER_DISCOVERY)) | (1ULL << BCMOLT_XGPON_ONU_CFG_ID_DEACTIVATION_REASON)) | (1ULL << BCMOLT_XGPON_ONU_CFG_ID_ALL_GEM_PORTS)) | (1ULL << BCMOLT_XGPON_ONU_CFG_ID_ALL_ALLOCS)) | (1ULL << BCMOLT_XGPON_ONU_CFG_ID_REQUEST_REGISTRATION_STATUS), 0, 0 };
static bcmolt_instance_info instance_info[] = { { offsetof(bcmolt_ae_ni_key, ae_ni), sizeof(bcmolt_ae_ni) }, { offsetof(bcmolt_ae_path_ds_key, ae_ni), sizeof(bcmolt_ae_ni) }, { offsetof(bcmolt_ae_path_us_key, ae_ni), sizeof(bcmolt_ae_ni) }, { offsetof(bcmolt_channel_key, pon_ni), sizeof(bcmolt_pon_ni) }, { offsetof(bcmolt_debug_key, reserved), sizeof(uint32_t) }, { offsetof(bcmolt_device_key, reserved), sizeof(uint32_t) }, { offsetof(bcmolt_epon_denied_link_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_epon_link_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_epon_ni_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_epon_onu_10g_us_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_epon_onu_1g_us_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_epon_path_10g_ds_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_epon_path_10g_us_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_epon_path_1g_ds_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_epon_path_1g_us_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_epon_rp_key, epon_ni), sizeof(bcmolt_epon_ni) }, { offsetof(bcmolt_gpio_key, reserved), sizeof(uint32_t) }, { offsetof(bcmolt_gpon_alloc_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_gpon_gem_port_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_gpon_iwf_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_gpon_iwf_ds_egress_flow_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_gpon_iwf_ds_ingress_flow_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_gpon_iwf_mac_table_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_gpon_iwf_us_flow_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_gpon_ni_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_gpon_onu_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_gpon_trx_key, pon_ni), sizeof(bcmolt_gpon_ni) }, { offsetof(bcmolt_log_entry_key, reserved), sizeof(uint8_t) }, { offsetof(bcmolt_logger_key, reserved), sizeof(uint32_t) }, { offsetof(bcmolt_nni_key, pon_ni), sizeof(bcmolt_pon_ni) }, { offsetof(bcmolt_nni_serdes_key, pon_ni), sizeof(bcmolt_pon_ni) }, { offsetof(bcmolt_software_error_key, reserved), sizeof(uint32_t) }, { offsetof(bcmolt_trx_calibration_key, reserved), sizeof(uint32_t) }, { offsetof(bcmolt_xgpon_alloc_key, pon_ni), sizeof(bcmolt_xgpon_ni) }, { offsetof(bcmolt_xgpon_gem_port_key, pon_ni), sizeof(bcmolt_xgpon_ni) }, { offsetof(bcmolt_xgpon_iwf_key, pon_ni), sizeof(bcmolt_xgpon_ni) }, { offsetof(bcmolt_xgpon_ni_key, pon_ni), sizeof(bcmolt_xgpon_ni) }, { offsetof(bcmolt_xgpon_onu_key, pon_ni), sizeof(bcmolt_xgpon_ni) }, { offsetof(bcmolt_xgpon_trx_key, pon_ni), sizeof(bcmolt_xgpon_ni) }, { offsetof(bcmolt_xpon_serdes_key, pon_ni), sizeof(bcmolt_pon_ni) } };

/******************************************************************************/
static bcmos_bool bcmolt_get_group_info(const bcmolt_msg *msg, bcmolt_group_info **group, bcmolt_group_info **key)
{
    bcmolt_group_id group_id;
    bcmolt_group_id key_id;
    bcmos_errno err;

    err = bcmolt_group_id_combine(msg->obj_type, msg->group, msg->subgroup, &group_id);
    if (err != BCM_ERR_OK)
    {
        return BCMOS_FALSE;
    }

    err = bcmolt_group_id_combine(msg->obj_type, BCMOLT_MGT_GROUP_KEY, 0, &key_id);
    if (err != BCM_ERR_OK)
    {
        return BCMOS_FALSE;
    }

    *group = group_info[group_id];
    *key = group_info[key_id];
    return BCMOS_TRUE;
}

/******************************************************************************/
int32_t bcmolt_msg_get_packed_length(bcmolt_msg *msg)
{
    uint8_t *key_ptr;
    bcmolt_group_info *group;
    bcmolt_group_info *key;

    int32_t ret = bcmolt_msg_hdr_get_packed_length(msg);
    if (ret < 0)
    {
        return ret;
    }

    if (!bcmolt_get_group_info(msg, &group, &key))
    {
        return (int32_t) BCM_ERR_MSG_ERROR;
    }

    key_ptr = (uint8_t *) (msg + 1);
    ret += key->get_packed_length(key_ptr, BCMOLT_PRESENCE_MASK_ALL);

    if (bcmolt_msg_should_pack_data(msg) && (group->get_packed_length != NULL))
    {
        uint8_t *data_ptr = (uint8_t *) ((long)msg + group->data_offset);
        ret += group->get_packed_length(data_ptr, msg->presence_mask);
    }

    if (msg->type & BCMOLT_MSG_TYPE_MULTI)
    {
        if (msg->msg_set == NULL)
        {
            return (int32_t) BCM_ERR_NULL;
        }

        if (msg->dir == BCMOLT_MSG_DIR_REQUEST)
        {
            ret += 19;  /* group: 1, max_instances: 2, presence_mask: 8, filter_flags: 8 */
        }
        else
        {
            int i;
            int32_t sub_msg_ret;

            ret += 3;   /* group: num_instances: 2, more: 1 */
            ret += key->get_packed_length(key_ptr, BCMOLT_PRESENCE_MASK_ALL);   /* next key */
            for (i = 0; i < msg->msg_set->num_instances; i++)
            {
                if (msg->msg_set->msg[i] == NULL)
                {
                    return (int32_t) BCM_ERR_INTERNAL;
                }

                sub_msg_ret = bcmolt_msg_get_packed_length(msg->msg_set->msg[i]);
                if (sub_msg_ret < 0)
                {
                    return sub_msg_ret;
                }

                ret += sub_msg_ret;
            }
        }
    }

    return ret;
}

/* Create message set */
bcmos_errno bcmolt_msg_set_alloc(bcmolt_obj_id obj, bcmolt_mgt_group group, uint32_t max_instances, bcmolt_msg_set **msg_set)
{
    bcmolt_msg hdr = { };
    uint32_t size;
    bcmolt_group_info *grp;
    bcmolt_group_info *key;

    if (msg_set == NULL)
    {
        BCMOS_TRACE_RETURN(BCM_ERR_PARM, "msg_set parameter must be set\n");
    }

    if (group != BCMOLT_MGT_GROUP_CFG && group != BCMOLT_MGT_GROUP_STAT)
    {
        BCMOS_TRACE_RETURN(BCM_ERR_NOT_SUPPORTED, "group must be BCMOLT_MGT_GROUP_CFG or BCMOLT_MGT_GROUP_STAT\n");
    }

    /* Calculate message set size */
    hdr.obj_type = obj;
    hdr.group = group;
    hdr.dir = BCMOLT_MSG_DIR_REQUEST;
    if (!bcmolt_get_group_info(&hdr, &grp, &key))
    {
        BCMOS_TRACE_RETURN(BCM_ERR_NOT_SUPPORTED, "Not supported for the object\n");
    }

    size = sizeof(bcmolt_msg_set) + key->size + max_instances * sizeof(bcmolt_msg *);
    *msg_set = bcmos_calloc(size);
    if (*msg_set == NULL)
    {
        BCMOS_TRACE_RETURN(BCM_ERR_NOMEM, "Can't allocate message set\n");
    }
    (*msg_set)->group = group;
    (*msg_set)->max_instances = max_instances;
    (*msg_set)->next_key = (void *)(&((*msg_set)->msg[max_instances]));

    return BCM_ERR_OK;
}

/* Release message set
 * \param[in]   msg_set
 */
void bcmolt_msg_set_free(bcmolt_msg_set *msg_set)
{
    uint32_t i;

    for (i = 0; i < msg_set->max_instances && msg_set->msg[i] != NULL; i++)
    {
        bcmolt_msg_free(msg_set->msg[i]);
    }

    bcmos_free(msg_set);
}

/* Pack message set, excluding the filter-header which is already packed */
static bcmos_errno bcmolt_msg_set_pack(const bcmolt_msg *msg, bcmolt_buf *buf, const bcmolt_group_info *key_info)
{
    bcmolt_msg_set *msg_set = msg->msg_set;
    int i;
    bcmos_bool ret;
    bcmos_errno err = BCM_ERR_OK;

    if (!msg_set)
    {
        BCMOS_TRACE_RETURN(BCM_ERR_INTERNAL, "msh->msg_set == NULL\n");
    }

    /* REQUEST:
     * - filter (already packed at this point, contains first key to check)
     * - group (FFU)
     * - max_instances
     * - presence_mask
     * - filter_flags
     *
     * RESPONSE:
     * - filter (already packed at this point)
     * - num_instances
     * - more
     * - next_key
     * - num_instances * msg
     */
    if (msg->dir == BCMOLT_MSG_DIR_REQUEST)
    {
        ret = bcmolt_buf_write_u8(buf, (uint8_t) msg_set->group);
        ret = ret && bcmolt_buf_write_u16(buf, msg_set->max_instances);
        ret = ret && bcmolt_buf_write_u64(buf, msg_set->presence_mask);
        ret = ret && bcmolt_buf_write_u64(buf, msg_set->filter_flags);
        if (!ret) err = BCM_ERR_OVERFLOW;
    }
    else
    {
        ret = bcmolt_buf_write_u16(buf, msg_set->num_instances);
        ret = ret && bcmolt_buf_write_u8(buf, (uint8_t) msg_set->more);
        ret = ret && key_info->pack(msg_set->next_key, buf, BCMOLT_PRESENCE_MASK_ALL);
        if (!ret) return BCM_ERR_OVERFLOW;

        for (i = 0; i < msg_set->num_instances && err == BCM_ERR_OK; i++)
        {
            if (msg_set->msg[i] == NULL)
            {
                err = BCM_ERR_INTERNAL;
                break;
            }

            err = bcmolt_msg_pack(msg_set->msg[i], buf);
        }
    }

    return err;
}

/******************************************************************************/
bcmos_errno bcmolt_msg_pack(bcmolt_msg *msg, bcmolt_buf *buf)
{
    uint8_t *key_ptr;
    bcmos_errno err;
    bcmolt_group_info *group;
    bcmolt_group_info *key;

    if (!bcmolt_get_group_info(msg, &group, &key))
    {
        return BCM_ERR_MSG_ERROR;
    }

    err = bcmolt_msg_hdr_pack(msg, buf);
    if (err != BCM_ERR_OK)
    {
        return err;
    }

    key_ptr = (uint8_t *) (msg + 1);
    if (!key->pack(key_ptr, buf, BCMOLT_PRESENCE_MASK_ALL))
    {
        return BCM_ERR_OVERFLOW;
    }

    if (bcmolt_msg_should_pack_data(msg) && (group->pack != NULL))
    {
        uint8_t *data_ptr = (uint8_t *) ((long)msg + group->data_offset);
        if (!group->pack(data_ptr, buf, msg->presence_mask))
        {
            return BCM_ERR_OVERFLOW;
        }
    }

    /* If it is a multi-message pack what follows the rest of the set */
    if (msg->type & BCMOLT_MSG_TYPE_MULTI)
    {
        err = bcmolt_msg_set_pack(msg, buf, key);
    }

    return err;
}

/* scan the input buffer to determine how much memory will be required to unpack variable-sized lists */
static bcmos_errno bcmolt_msg_list_mem_scan(bcmolt_buf *buf, const bcmolt_msg *hdr, const bcmolt_group_info *group, const bcmolt_group_info *key, uint32_t *size)
{
    uint32_t pos_before_scan = bcmolt_buf_get_used(buf);

    if (!key->mem_scan(buf, size, BCMOLT_PRESENCE_MASK_ALL))
    {
        return BCM_ERR_OVERFLOW;
    }

    if (bcmolt_msg_should_pack_data(hdr) && (group->mem_scan != NULL) && !group->mem_scan(buf, size, hdr->presence_mask))
    {
        return BCM_ERR_OVERFLOW;
    }

    if (!bcmolt_buf_rewind(buf, bcmolt_buf_get_used(buf) - pos_before_scan))
    {
        return BCM_ERR_OVERFLOW;
    }

    return BCM_ERR_OK;
}

/* Pack message set, excluding the filter-header which is already packed */
static bcmos_errno bcmolt_msg_set_unpack(bcmolt_msg *msg, bcmolt_buf *buf, const bcmolt_group_info *key_info)
{
    bcmolt_msg_set *msg_set;
    int i;
    bcmos_bool ret;
    bcmos_errno err = BCM_ERR_OK;

    /*
     * See encoding in bcmolt_msg_set_pack()
     */
    if (msg->dir == BCMOLT_MSG_DIR_REQUEST)
    {
        uint8_t group;
        uint16_t max_instances;
        uint64_t filter_flags;

        ret = bcmolt_buf_read_u8(buf, &group);
        ret = ret && bcmolt_buf_read_u16(buf, &max_instances);
        if (!ret)
        {
            return BCM_ERR_OVERFLOW;
        }

        err = bcmolt_msg_set_alloc(msg->obj_type, group, max_instances, &msg_set);
        if (err) return err;

        ret = ret && bcmolt_buf_read_u64(buf, &msg_set->presence_mask);
        ret = ret && bcmolt_buf_read_u64(buf, &filter_flags);
        if (!ret)
        {
            bcmolt_msg_set_free(msg_set);
            return BCM_ERR_OVERFLOW;
        }

        msg_set->filter_flags = filter_flags;
        msg->msg_set = msg_set;
    }
    else
    {
        uint8_t is_more;
        uint16_t num_instances;

        ret = bcmolt_buf_read_u16(buf, &num_instances);
        if (!ret)
        {
            return BCM_ERR_OVERFLOW;
        }

        if (msg->msg_set == NULL)
        {
            err = bcmolt_msg_set_alloc(msg->obj_type, msg->group, num_instances, &msg->msg_set);
            if (BCM_ERR_OK != err)
            {
                return err;
            }
        }

        msg_set = msg->msg_set;
        msg_set->num_instances = num_instances;
        ret = ret && bcmolt_buf_read_u8(buf, &is_more);
        ret = ret && key_info->unpack(msg_set->next_key, buf, NULL, BCMOLT_PRESENCE_MASK_ALL);
        if (!ret)
        {
            return BCM_ERR_OVERFLOW;
        }

        msg_set->more = (bcmos_bool) is_more;
        if (msg_set->num_instances > msg_set->max_instances)
        {
            BCMOS_TRACE_RETURN(BCM_ERR_INTERNAL, "msg_set unpack: num_instances %u > max_instances %u\n", msg_set->num_instances, msg_set->max_instances);
        }

        for (i = 0; i < msg_set->num_instances && err == BCM_ERR_OK; i++)
        {
            err = bcmolt_msg_unpack(buf, &msg_set->msg[i]);
        }
    }

    return err;
}

/******************************************************************************/
bcmos_errno bcmolt_msg_unpack(bcmolt_buf *buf, bcmolt_msg **unpacked)
{
    bcmolt_msg hdr = { };
    bcmos_errno err;
    bcmolt_group_info *group;
    bcmolt_group_info *key;
    bcmos_bool did_malloc = BCMOS_FALSE;
    uint8_t *key_ptr;
    void *list_mem = NULL;
    void **list_mem_ptr = NULL;

    err = bcmolt_msg_hdr_unpack(&hdr, buf);
    if (err != BCM_ERR_OK)
    {
        return err;
    }

    if (!bcmolt_get_group_info(&hdr, &group, &key))
    {
        return BCM_ERR_MSG_ERROR;
    }

    if (*unpacked == NULL)
    {
        uint32_t size = group->container_size == 0 ? sizeof(bcmolt_msg) + key->size : group->container_size;
        err = bcmolt_msg_list_mem_scan(buf, &hdr, group, key, &size);
        if (err != BCM_ERR_OK)
        {
            return err;
        }

        *unpacked = bcmos_calloc(size);
        if (*unpacked == NULL)
        {
            return BCM_ERR_NOMEM;
        }

        list_mem = (uint8_t *) (*unpacked) + group->container_size;
        list_mem_ptr = &list_mem;
        did_malloc = BCMOS_TRUE;
    }
    else
    {
        if ((*unpacked)->list_buf != NULL)
        {
            uint32_t size = 0;
            err = bcmolt_msg_list_mem_scan(buf, &hdr, group, key, &size);
            if (err != BCM_ERR_OK)
            {
                return err;
            }

            if (size > (*unpacked)->list_buf_size)
            {
                return BCM_ERR_INSUFFICIENT_LIST_MEM;
            }

            list_mem = (*unpacked)->list_buf;
            list_mem_ptr = &list_mem;
        }
    }

    hdr.msg_set = (*unpacked)->msg_set;
    **unpacked = hdr;

    key_ptr = (uint8_t *) (*unpacked + 1);
    if (!key->unpack(key_ptr, buf, list_mem_ptr, BCMOLT_PRESENCE_MASK_ALL))
    {
        if (did_malloc)
        {
            bcmos_free(*unpacked);
        }

        return BCM_ERR_OVERFLOW;
    }

    if (bcmolt_msg_should_pack_data(&hdr))
    {
        uint8_t *data_ptr = (uint8_t *) (*unpacked) + group->data_offset;
        if ((group->unpack != NULL) && !group->unpack(data_ptr, buf, list_mem_ptr, hdr.presence_mask))
        {
            if (did_malloc)
            {
                bcmos_free(*unpacked);
            }

            return BCM_ERR_OVERFLOW;
        }
    }

    /* If it is a multi-message pack what follows the rest of the set */
    if (hdr.type & BCMOLT_MSG_TYPE_MULTI)
    {
        err = bcmolt_msg_set_unpack(*unpacked, buf, key);
        if (err != BCM_ERR_OK)
        {
            if (did_malloc)
            {
                bcmos_free(*unpacked);
            }

            return err;
        }
    }

    return BCM_ERR_OK;
}

/******************************************************************************/
bcmos_errno bcmolt_group_id_split(bcmolt_group_id group_id, bcmolt_obj_id *obj, bcmolt_mgt_group *group, uint16_t *subgroup)
{
    if ((group_id >= BCMOLT_GROUP_ID__NUM_OF) || (group_info[group_id] == NULL))
    {
        return BCM_ERR_RANGE;
    }

    *obj = group_info[group_id]->obj_type;
    *group = group_info[group_id]->group;
    *subgroup = group_info[group_id]->subgroup;
    return BCM_ERR_OK;
}

/******************************************************************************/
bcmos_errno bcmolt_group_id_combine(bcmolt_obj_id obj, bcmolt_mgt_group group, uint16_t subgroup, bcmolt_group_id *group_id)
{
    if ((obj >= BCMOLT_OBJ_ID__NUM_OF) || (group >= BCMOLT_MGT_GROUP__NUM_OF) || (group_ids[obj] == NULL) || (subgroup >= group_ids[obj][group].subgroup_count))
    {
        return BCM_ERR_RANGE;
    }

    *group_id = group_ids[obj][group].subgroup_ids[subgroup];
    return BCM_ERR_OK;
}

/******************************************************************************/
uint8_t bcmolt_msg_instance(const bcmolt_msg *msg)
{
    const void *val_ptr;

    if (msg->obj_type >= BCMOLT_OBJ_ID__NUM_OF)
    {
        return 0;
    }

    if (instance_info[msg->obj_type].offset < 0)
    {
        return 0;
    }

    val_ptr = ((const uint8_t *)(msg + 1)) + instance_info[msg->obj_type].offset;

    /** This is probably not the smartest way to do this... TODO: revisit */
    switch (instance_info[msg->obj_type].size)
    {
        case 1:
            return *((const uint8_t *)val_ptr);
        case 2:
            return (uint8_t) (*((const uint16_t *)val_ptr));
        case 4:
            return (uint8_t) (*((const uint32_t *)val_ptr));
        case 8:
            return (uint8_t) (*((const uint64_t *)val_ptr));
        default:
            return 0;
    }
}

/******************************************************************************/
bcmos_errno bcmolt_msg_clone(bcmolt_msg **dest, bcmolt_msg *src)
{
    bcmos_errno err;
    int32_t packed_len;
    uint8_t *mem;
    bcmolt_buf buf;

    packed_len = bcmolt_msg_get_packed_length(src);
    if (packed_len < 0)
    {
        return (bcmos_errno) packed_len;
    }

    mem = bcmos_calloc((uint32_t) packed_len);
    if (mem == NULL)
    {
        return BCM_ERR_NOMEM;
    }

    bcmolt_buf_init(&buf, (uint32_t) packed_len, mem, BCMOLT_BUF_ENDIAN_FIXED);
    err = bcmolt_msg_pack(src, &buf);
    if (err != BCM_ERR_OK)
    {
        bcmos_free(mem);
        return err;
    }

    buf.curr = buf.start;
    err = bcmolt_msg_unpack(&buf, dest);
    bcmos_free(mem);
    return err;
}

/******************************************************************************/
bcmos_errno bcmolt_get_prop_readonly_mask(bcmolt_obj_id obj, bcmolt_presence_mask *mask)
{
    if (obj >= BCMOLT_OBJ_ID__NUM_OF)
    {
        return BCM_ERR_RANGE;
    }

    *mask = readonly_prop_mask[obj];
    return BCM_ERR_OK;
}

#ifdef __KERNEL__
EXPORT_SYMBOL(bcmolt_msg_get_packed_length);
EXPORT_SYMBOL(bcmolt_msg_pack);
EXPORT_SYMBOL(bcmolt_msg_unpack);
EXPORT_SYMBOL(bcmolt_group_id_split);
EXPORT_SYMBOL(bcmolt_group_id_combine);
EXPORT_SYMBOL(bcmolt_msg_instance);
EXPORT_SYMBOL(bcmolt_get_prop_readonly_mask);
EXPORT_SYMBOL(bcmolt_msg_set_alloc);
EXPORT_SYMBOL(bcmolt_msg_set_free);

MODULE_LICENSE("Dual BSD/GPL");
#endif
