/*
<:copyright-BRCM:2016:proprietary:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

This program is the proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modified or distributed pursuant
to the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License").  Except as set forth in
an Authorized License, Broadcom grants no license (express or implied), right
to use, or waiver of any kind with respect to the Software, and Broadcom
expressly reserves all rights in and to the Software and all intellectual
property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization,
    constitutes the valuable trade secrets of Broadcom, and you shall use
    all reasonable efforts to protect the confidentiality thereof, and to
    use this information only in connection with your use of Broadcom
    integrated circuit products.

2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
    PERFORMANCE OF THE SOFTWARE.

3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
    LIMITED REMEDY.
:>
*/
#ifndef BCMOLT_MODEL_TYPES_H_
#define BCMOLT_MODEL_TYPES_H_

#include "bcmos_system.h"
#include "bcmos_errno.h"
#include "bcmolt_buf.h"
#include "bcmolt_msg.h"
#include "bcmolt_model_data.h"

/** \addtogroup object_model
 * @{
 */

/** Structure definition for the "key" group of the "ae_ni" object. 
 */
typedef struct bcmolt_ae_ni_key
{
    bcmolt_ae_ni ae_ni; /**< The index of a specific AE NI instance as seen by the host. */
} bcmolt_ae_ni_key;

/** Structure definition for the "cfg" group of the "ae_ni" object. 
 */
typedef struct bcmolt_ae_ni_cfg_data
{
    bcmos_mac_address mac_address;  /**< The MAC address used for all frames generated by the OLT on the network.  This value must be set before AE_NI is first enabled, and cannot be changed while the AE_NI is enabled. */
    bcmolt_ae_ni_en_state ae_ni_en; /**< Indicates the enable state of the AE NI. */
    uint16_t mtu_10g;               /**< Maximum frame size (including FCS) on the 10G path. This attribute cannot be changed on an enabled AE_NI. */
    bcmolt_prbs_generator_config prbs_generator;    /**< DS PRBS generator configuration */
    bcmolt_prbs_checker_config prbs_checker;        /**< US PRBS checker configuration */
    bcmolt_prbs_status prbs_status;                 /**< Result of US PRBS checker */
} bcmolt_ae_ni_cfg_data;

/** Transport message definition for "cfg" group of "ae_ni" object. 
 */
typedef struct bcmolt_ae_ni_cfg
{
    bcmolt_cfg hdr;             /**< Transport header. */
    bcmolt_ae_ni_key key;       /**< Object key. */
    bcmolt_ae_ni_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_ae_ni_cfg;

/** Structure definition for the "set_ae_ni_en_state" group of the "ae_ni" 
 * object. 
 *
 * Set the AE NI enable state. 
 */
typedef struct bcmolt_ae_ni_set_ae_ni_en_state_data
{
    bcmolt_ae_ni_en_state new_state;    /**< New EPON NI enable state. */
} bcmolt_ae_ni_set_ae_ni_en_state_data;

/** Transport message definition for "set_ae_ni_en_state" group of "ae_ni" 
 * object. 
 */
typedef struct bcmolt_ae_ni_set_ae_ni_en_state
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_ae_ni_key key;   /**< Object key. */
    bcmolt_ae_ni_set_ae_ni_en_state_data data;  /**< All properties that must be set by the user. */
} bcmolt_ae_ni_set_ae_ni_en_state;

/** Structure definition for the "key" group of the "ae_path_ds" object. 
 */
typedef struct bcmolt_ae_path_ds_key
{
    bcmolt_ae_ni ae_ni; /**< AE NI associated with this 10G downstream path. */
} bcmolt_ae_path_ds_key;

/** Structure definition for the "stat" group of the "ae_path_ds" object. 
 */
typedef struct bcmolt_ae_path_ds_stat_data
{
    uint64_t bytes;             /**< The number of bytes transmitted on this 10g downstream path. */
    uint64_t frames;            /**< The number of frames transmitted on this 10g downstream path. */
    uint64_t frames_64;         /**< The number of 64 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_65_127;     /**< The number of 65 to 127 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_128_255;    /**< The number of 128 to 255 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_256_511;    /**< The number of 256 to 511 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_512_1023;   /**< The number of 512 to 1023 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_1024_1518;  /**< The number of 1024 to 1518 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_1519_2047;  /**< The number of 1519 to 2047 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_2048_4095;  /**< The number of 2048 to 4095 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_4096_9216;  /**< The number of 4096 to 9216 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_9217_16383; /**< The number of 9217 to 16383 byte frames transmitted on this 10g downstream path. */
    uint64_t broadcast_frames;  /**< The number of broadcast frames transmitted on this 10g downstream path. */
    uint64_t data_bytes;        /**< The number of data bytes transmitted on this 10g downstream path. */
    uint64_t multicast_frames;  /**< The number of multicast frames transmitted on this 10g downstream path. */
    uint64_t unicast_frames;    /**< The number of unicast frames transmitted on this 10g downstream path. */
    uint64_t abort_frames;      /**< Number of abort frames transmitted on this 10g downstream path. */
} bcmolt_ae_path_ds_stat_data;

/** Transport message definition for "stat" group of "ae_path_ds" object. 
 */
typedef struct bcmolt_ae_path_ds_stat
{
    bcmolt_stat hdr;                    /**< Transport header. */
    bcmolt_ae_path_ds_key key;          /**< Object key. */
    bcmolt_ae_path_ds_stat_data data;   /**< All properties that must be set by the user. */
} bcmolt_ae_path_ds_stat;

/** Structure definition for the "stat_cfg" group of the "ae_path_ds" object. 
 */
typedef struct bcmolt_ae_path_ds_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_ae_path_ds_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "ae_path_ds" object. 
 */
typedef struct bcmolt_ae_path_ds_stat_cfg
{
    bcmolt_stat_cfg hdr;        /**< Transport header. */
    bcmolt_ae_path_ds_key key;  /**< Object key. */
    bcmolt_ae_path_ds_stat_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_ae_path_ds_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the "ae_path_ds" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_ae_path_ds_stat_alarm_cleared_data
{
    bcmolt_ae_path_ds_stat_id stat; /**< Statistic identifier. */
} bcmolt_ae_path_ds_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "ae_path_ds" 
 * object. 
 */
typedef struct bcmolt_ae_path_ds_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_ae_path_ds_key key;  /**< Object key. */
    bcmolt_ae_path_ds_stat_alarm_cleared_data data; /**< All properties that must be set by the user. */
} bcmolt_ae_path_ds_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "ae_path_ds" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_ae_path_ds_stat_alarm_raised_data
{
    bcmolt_ae_path_ds_stat_id stat; /**< Statistic identifier. */
} bcmolt_ae_path_ds_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "ae_path_ds" 
 * object. 
 */
typedef struct bcmolt_ae_path_ds_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_ae_path_ds_key key;  /**< Object key. */
    bcmolt_ae_path_ds_stat_alarm_raised_data data;  /**< All properties that must be set by the user. */
} bcmolt_ae_path_ds_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "ae_path_ds" object. 
 */
typedef struct bcmolt_ae_path_ds_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_ae_path_ds_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "ae_path_ds" object. 
 */
typedef struct bcmolt_ae_path_ds_auto_cfg
{
    bcmolt_auto_cfg hdr;                    /**< Transport header. */
    bcmolt_ae_path_ds_key key;              /**< Object key. */
    bcmolt_ae_path_ds_auto_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_ae_path_ds_auto_cfg;

/** Structure definition for the "key" group of the "ae_path_us" object. 
 */
typedef struct bcmolt_ae_path_us_key
{
    bcmolt_ae_ni ae_ni; /**< AE NI associated with this 10G upstream path. */
} bcmolt_ae_path_us_key;

/** Structure definition for the "stat" group of the "ae_path_us" object. 
 */
typedef struct bcmolt_ae_path_us_stat_data
{
    uint64_t bytes;             /**< The number of bytes received on this 10g upstream path. */
    uint64_t frames;            /**< The number of frames received on this 10g upstream path. */
    uint64_t frames_64;         /**< The number of 64 byte frames received on this 10g upstream path. */
    uint64_t frames_65_127;     /**< The number of 65 to 127 byte frames received on this 10g upstream path. */
    uint64_t frames_128_255;    /**< The number of 128 to 255 byte frames received on this 10g upstream path. */
    uint64_t frames_256_511;    /**< The number of 256 to 511 byte frames received on this 10g upstream path. */
    uint64_t frames_512_1023;   /**< The number of 512 to 1023 byte frames received on this 10g upstream path. */
    uint64_t frames_1024_1518;  /**< The number of 1024 to 1518 byte frames received on this 10g upstream path. */
    uint64_t frames_1519_2047;  /**< The number of 1519 to 2047 byte frames received on this 10g upstream path. */
    uint64_t frames_2048_4095;  /**< The number of 2048 to 4095 byte frames received on this 10g upstream path. */
    uint64_t frames_4096_9216;  /**< The number of 4096 to 9216 byte frames received on this 10g upstream path. */
    uint64_t frames_9217_16383; /**< The number of 9217 to 16383 byte frames received on this 10g upstream path. */
    uint64_t broadcast_frames;  /**< The number of broadcast frames received on this 10g upstream path. */
    uint64_t data_bytes;        /**< The number of data bytes received on this 10g upstream path. */
    uint64_t multicast_frames;  /**< The number of multicast frames received on this 10g upstream path. */
    uint64_t unicast_frames;    /**< The number of unicast frames received on this 10g upstream path. */
    uint64_t abort_frames;      /**< The number of abort frames received on this 10g upstream path. */
    uint64_t fcs_error;         /**< The number of bad FCS errors received on this 10g upstream path. */
    uint64_t oversize_error;    /**< The number of oversize errors received on this 10g upstream path. */
    uint64_t runt_error;        /**< The number of runt errors received on this 10g upstream path. */
} bcmolt_ae_path_us_stat_data;

/** Transport message definition for "stat" group of "ae_path_us" object. 
 */
typedef struct bcmolt_ae_path_us_stat
{
    bcmolt_stat hdr;                    /**< Transport header. */
    bcmolt_ae_path_us_key key;          /**< Object key. */
    bcmolt_ae_path_us_stat_data data;   /**< All properties that must be set by the user. */
} bcmolt_ae_path_us_stat;

/** Structure definition for the "stat_cfg" group of the "ae_path_us" object. 
 */
typedef struct bcmolt_ae_path_us_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_ae_path_us_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "ae_path_us" object. 
 */
typedef struct bcmolt_ae_path_us_stat_cfg
{
    bcmolt_stat_cfg hdr;        /**< Transport header. */
    bcmolt_ae_path_us_key key;  /**< Object key. */
    bcmolt_ae_path_us_stat_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_ae_path_us_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the "ae_path_us" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_ae_path_us_stat_alarm_cleared_data
{
    bcmolt_ae_path_us_stat_id stat; /**< Statistic identifier. */
} bcmolt_ae_path_us_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "ae_path_us" 
 * object. 
 */
typedef struct bcmolt_ae_path_us_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_ae_path_us_key key;  /**< Object key. */
    bcmolt_ae_path_us_stat_alarm_cleared_data data; /**< All properties that must be set by the user. */
} bcmolt_ae_path_us_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "ae_path_us" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_ae_path_us_stat_alarm_raised_data
{
    bcmolt_ae_path_us_stat_id stat; /**< Statistic identifier. */
} bcmolt_ae_path_us_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "ae_path_us" 
 * object. 
 */
typedef struct bcmolt_ae_path_us_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_ae_path_us_key key;  /**< Object key. */
    bcmolt_ae_path_us_stat_alarm_raised_data data;  /**< All properties that must be set by the user. */
} bcmolt_ae_path_us_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "ae_path_us" object. 
 */
typedef struct bcmolt_ae_path_us_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_ae_path_us_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "ae_path_us" object. 
 */
typedef struct bcmolt_ae_path_us_auto_cfg
{
    bcmolt_auto_cfg hdr;                    /**< Transport header. */
    bcmolt_ae_path_us_key key;              /**< Object key. */
    bcmolt_ae_path_us_auto_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_ae_path_us_auto_cfg;

/** Structure definition for the "key" group of the "channel" object. 
 */
typedef struct bcmolt_channel_key
{
    bcmolt_pon_ni pon_ni;   /**< PON network interface. */
} bcmolt_channel_key;

/** Structure definition for the "cfg" group of the "channel" object. 
 */
typedef struct bcmolt_channel_cfg_data
{
    bcmolt_operation_control operation_control; /**< Operation control. */
    uint16_t tol;   /**< Transmit Optical Level. An indication of the current OLT CT transceiver channel launch power into the ODN */
    bcmolt_system_profile system_profile;           /**< System profile. */
#define BCMOLT_CHANNEL_CFG_DATA_CHANNEL_PROFILE_LEN 8
    bcmolt_arr_channel_profile_8 channel_profile;   /**< Channel profile. */
} bcmolt_channel_cfg_data;

/** Transport message definition for "cfg" group of "channel" object. 
 */
typedef struct bcmolt_channel_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_channel_key key;         /**< Object key. */
    bcmolt_channel_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_channel_cfg;

/** Structure definition for the "key" group of the "debug" object. 
 */
typedef struct bcmolt_debug_key
{
    uint32_t reserved;  /**< Reserved (set to 0) */
} bcmolt_debug_key;

/** Structure definition for the "cfg" group of the "debug" object. 
 */
typedef struct bcmolt_debug_cfg_data
{
    bcmolt_console_redirection console_redirection;             /**< Log output redirection */
    uint32_t indications_dropped;                               /**< Number of indications dropped due to congestion / shaping. */
    uint8_t file_used_percent;                                  /**< DDR log file used percent */
    bcmolt_api_capture_config api_capture_cfg;                  /**< Configuration for API capture. */
    bcmolt_api_capture_stats api_capture_stats;                 /**< Statistics on the most recent API capture. */
    bcmolt_api_capture_buffer_reader api_capture_buffer_read;   /**< Controls what portion of the capture buffer is returned when performing a cfg_get. */
    bcmolt_u8_list_u32 api_capture_buffer;                      /**< The portion of the capture buffer currently specified by api_capture_buffer_read. */
} bcmolt_debug_cfg_data;

/** Transport message definition for "cfg" group of "debug" object. 
 */
typedef struct bcmolt_debug_cfg
{
    bcmolt_cfg hdr;             /**< Transport header. */
    bcmolt_debug_key key;       /**< Object key. */
    bcmolt_debug_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_debug_cfg;

/** Structure definition for the "cli_output" group of the "debug" object. 
 *
 * CLI Output String 
 */
typedef struct bcmolt_debug_cli_output_data
{
    bcmolt_u8_list_u32 data;    /**< output data */
} bcmolt_debug_cli_output_data;

/** Transport message definition for "cli_output" group of "debug" object. 
 */
typedef struct bcmolt_debug_cli_output
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_debug_key key;               /**< Object key. */
    bcmolt_debug_cli_output_data data;  /**< All properties that must be set by the user. */
} bcmolt_debug_cli_output;

/** Transport message definition for "file_almost_full" group of "debug" object. 
 */
typedef struct bcmolt_debug_file_almost_full
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_debug_key key;   /**< Object key. */
} bcmolt_debug_file_almost_full;

/** Structure definition for the "auto_cfg" group of the "debug" object. 
 */
typedef struct bcmolt_debug_auto_cfg_data
{
    bcmos_bool cli_output;          /**< If true, indications of type "cli_output" will be generated. */
    bcmos_bool file_almost_full;    /**< If true, indications of type "file_almost_full" will be generated. */
} bcmolt_debug_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "debug" object. 
 */
typedef struct bcmolt_debug_auto_cfg
{
    bcmolt_auto_cfg hdr;                /**< Transport header. */
    bcmolt_debug_key key;               /**< Object key. */
    bcmolt_debug_auto_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_debug_auto_cfg;

/** Structure definition for the "cli_input" group of the "debug" object. 
 *
 * CLI Input String 
 */
typedef struct bcmolt_debug_cli_input_data
{
    bcmolt_u8_list_u32 data;    /**< Input String */
} bcmolt_debug_cli_input_data;

/** Transport message definition for "cli_input" group of "debug" object. 
 */
typedef struct bcmolt_debug_cli_input
{
    bcmolt_oper hdr;                    /**< Transport header. */
    bcmolt_debug_key key;               /**< Object key. */
    bcmolt_debug_cli_input_data data;   /**< All properties that must be set by the user. */
} bcmolt_debug_cli_input;

/** Transport message definition for "reset_api_capture" group of "debug" 
 * object. 
 */
typedef struct bcmolt_debug_reset_api_capture
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_debug_key key;   /**< Object key. */
} bcmolt_debug_reset_api_capture;

/** Transport message definition for "start_api_capture" group of "debug" 
 * object. 
 */
typedef struct bcmolt_debug_start_api_capture
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_debug_key key;   /**< Object key. */
} bcmolt_debug_start_api_capture;

/** Transport message definition for "stop_api_capture" group of "debug" object. 
 */
typedef struct bcmolt_debug_stop_api_capture
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_debug_key key;   /**< Object key. */
} bcmolt_debug_stop_api_capture;

/** Structure definition for the "key" group of the "device" object. 
 */
typedef struct bcmolt_device_key
{
    uint32_t reserved;  /**< Reserved (set to 0). */
} bcmolt_device_key;

/** Structure definition for the "cfg" group of the "device" object. 
 */
typedef struct bcmolt_device_cfg_data
{
    bcmolt_system_mode system_mode; /**< System mode - this must be set by the host when initially provisioning the system.  Setting this also sets the "nni_speed" property, unless it is overridden. */
    uint32_t keepalive_interval;    /**< Keepalive Interval in Seconds  (0 = Disable) */
    uint32_t keepalive_tolerance;   /**< How many keepalive messages can be lost before triggering a disconnect sequence  */
    bcmolt_firmware_sw_version firmware_sw_version;             /**< Firmware SW Version */
    bcmolt_host_sw_version host_sw_version;                     /**< Host SW Version */
    bcmolt_device_chip_revision chip_revision;                  /**< Revision of the BCM68620 device. */
    bcmolt_device_state state;                                  /**< Device state */
    bcmolt_debug_device_cfg debug;                              /**< Device configuration debug parameters */
    bcmolt_device_nni_speed nni_speed;                          /**< Speed of the NNI interface.  This is calculated automatically when the "system_mode" property is set, but can be overridden by the host. */
    bcmolt_ext_irq protection_switching_ext_irq;                /**< The selected external IRQ for protection switching */
    uint32_t epon_clock_transport_sample_delay;                 /**< The time (in TQ) that it takes from when a pulse is generated at the external source to when we sample it. */
    bcmolt_indication_shaping indication_shaping;               /**< Shaping / rate limiting for the indication channel. */
    uint32_t chip_temperature;                                  /**< Current die temperature. */
    bcmolt_control_state gpon_xgpon_tod_enable;                 /**< GPON/XGPON ToD control state */
    bcmolt_gpio_pin gpon_xgpon_tod_gpio_pin;                    /**< GPON/XGPON ToD GIO pin */
    bcmos_bool gpon_xgpon_tod_connected_internally;             /**< GPON/XGPON is ToD internally */
    bcmolt_str_256 epon_8021_as_tod_format;                     /**< The format of the 802.1AS ToD string. */
    bcmolt_shaper_mode epon_shaper_mode;                        /**< Controls EPON shaper behavior. */
    bcmolt_embedded_image_entry_list_u8 embedded_image_list;    /**< List of all file images stored in the OLT. */
    uint32_t chip_voltage;                      /**< Chip voltage in mV */
    bcmolt_str_256 epon_tod_string;             /**< The current ToD string to be used for clock transport (EPON only). */
    bcmolt_xgpon_num_of_onus xgpon_num_of_onus; /**< xgpon num of onus. */
    bcmos_ipv4_address device_ip_address;       /**< The IP Address of the device */
    uint16_t device_udp_port;                   /**< The UDP port of the Device */
    bcmolt_uart_baudrate tod_uart_baudrate;     /**< UART baud rate */
    uint8_t gpon_xgpon_tod_string_length;       /**< GPON/XGPON ToD string length */
} bcmolt_device_cfg_data;

/** Transport message definition for "cfg" group of "device" object. 
 */
typedef struct bcmolt_device_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_device_key key;          /**< Object key. */
    bcmolt_device_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_device_cfg;

/** Structure definition for the "connection_complete" group of the "device" 
 * object. 
 *
 * The host successfully connected to the device.  The device has either been 
 * reprogrammed with new firmware, or a connection was established with an 
 * existing device (see the "standalone" field). 
 */
typedef struct bcmolt_device_connection_complete_data
{
    bcmos_bool standalone;  /**< If true, the device was previously running in standalone mode before this connection was established.  If false, the device was booted from reset with new firmware, etc. */
} bcmolt_device_connection_complete_data;

/** Transport message definition for "connection_complete" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_connection_complete
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_connection_complete_data data;    /**< All properties that must be set by the user. */
} bcmolt_device_connection_complete;

/** Transport message definition for "connection_established" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_connection_established
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
} bcmolt_device_connection_established;

/** Structure definition for the "connection_failure" group of the "device" 
 * object. 
 *
 * The host failed to connect to the device. 
 */
typedef struct bcmolt_device_connection_failure_data
{
    bcmolt_host_connection_fail_reason reason;  /**< Connection fail reason. */
} bcmolt_device_connection_failure_data;

/** Transport message definition for "connection_failure" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_connection_failure
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_connection_failure_data data; /**< All properties that must be set by the user. */
} bcmolt_device_connection_failure;

/** Structure definition for the "ddr_test_complete" group of the "device" 
 * object. 
 *
 * The DDR Test has completed 
 */
typedef struct bcmolt_device_ddr_test_complete_data
{
    bcmolt_ddr_test_completed ddr_test; /**< Results of the DDR Test */
} bcmolt_device_ddr_test_complete_data;

/** Transport message definition for "ddr_test_complete" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_ddr_test_complete
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_ddr_test_complete_data data;  /**< All properties that must be set by the user. */
} bcmolt_device_ddr_test_complete;

/** Structure definition for the "device_keep_alive" group of the "device" 
 * object. 
 *
 * Keep alive message from the device to the host - used by the device control 
 * library (not sent to the host application). 
 */
typedef struct bcmolt_device_device_keep_alive_data
{
    uint32_t sequence_number;   /**< sequence number */
    uint32_t time_stamp;        /**< time stamp */
} bcmolt_device_device_keep_alive_data;

/** Transport message definition for "device_keep_alive" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_device_keep_alive
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_device_keep_alive_data data;  /**< All properties that must be set by the user. */
} bcmolt_device_device_keep_alive;

/** Structure definition for the "device_ready" group of the "device" object. 
 *
 * Device ready indication used by the device control library (not sent to the 
 * host application). 
 */
typedef struct bcmolt_device_device_ready_data
{
    bcmolt_firmware_sw_version firmware_sw_version; /**< Software Version. */
    bcmolt_system_mode system_mode;                 /**< System Mode. */
    bcmolt_device_nni_speed nni_speed;              /**< NNI Speed. */
    bcmolt_device_chip_revision chip_revision;      /**< Chip Revision. */
    bcmolt_control_state tod_enable;                /**< ToD control. */
    bcmolt_gpio_pin tod_gpio_pin;                   /**< GPIO pin is used when ToD UART is not connected to the embedded, and TOD value is obtained by the host. */
} bcmolt_device_device_ready_data;

/** Transport message definition for "device_ready" group of "device" object. 
 */
typedef struct bcmolt_device_device_ready
{
    bcmolt_auto hdr;                        /**< Transport header. */
    bcmolt_device_key key;                  /**< Object key. */
    bcmolt_device_device_ready_data data;   /**< All properties that must be set by the user. */
} bcmolt_device_device_ready;

/** Transport message definition for "disconnection_complete" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_disconnection_complete
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
} bcmolt_device_disconnection_complete;

/** Structure definition for the "image_transfer_complete" group of the "device" 
 * object. 
 */
typedef struct bcmolt_device_image_transfer_complete_data
{
    bcmolt_device_image_type image_type;    /**< Image type. */
    uint32_t block_number;                  /**< Block number. */
    bcmolt_image_transfer_status status;    /**< Image transfer status. */
} bcmolt_device_image_transfer_complete_data;

/** Transport message definition for "image_transfer_complete" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_image_transfer_complete
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_image_transfer_complete_data data;    /**< All properties that must be set by the user. */
} bcmolt_device_image_transfer_complete;

/** Structure definition for the "indications_dropped" group of the "device" 
 * object. 
 *
 * Sent when indications are dropped due to congestion / shaping. 
 */
typedef struct bcmolt_device_indications_dropped_data
{
    uint32_t total_count;   /**< Total number of indications dropped since the system was started. */
} bcmolt_device_indications_dropped_data;

/** Transport message definition for "indications_dropped" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_indications_dropped
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_indications_dropped_data data;    /**< All properties that must be set by the user. */
} bcmolt_device_indications_dropped;

/** Structure definition for the "sw_error" group of the "device" object. 
 */
typedef struct bcmolt_device_sw_error_data
{
    bcmolt_str_100 task_name;   /**< task name. */
    bcmolt_str_100 file_name;   /**< file name. */
    uint32_t line_number;       /**< line number. */
    uint8_t pon_ni;             /**< pon_ni. */
} bcmolt_device_sw_error_data;

/** Transport message definition for "sw_error" group of "device" object. 
 */
typedef struct bcmolt_device_sw_error
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_device_key key;              /**< Object key. */
    bcmolt_device_sw_error_data data;   /**< All properties that must be set by the user. */
} bcmolt_device_sw_error;

/** Structure definition for the "sw_exception" group of the "device" object. 
 */
typedef struct bcmolt_device_sw_exception_data
{
    uint8_t cpu_id;         /**< CPU ID. */
    bcmolt_str_2000 text;   /**< text. */
} bcmolt_device_sw_exception_data;

/** Transport message definition for "sw_exception" group of "device" object. 
 */
typedef struct bcmolt_device_sw_exception
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_sw_exception_data data;   /**< All properties that must be set by the user. */
} bcmolt_device_sw_exception;

/** Structure definition for the "auto_cfg" group of the "device" object. 
 */
typedef struct bcmolt_device_auto_cfg_data
{
    bcmos_bool connection_complete;     /**< If true, indications of type "connection_complete" will be generated. */
    bcmos_bool connection_established;  /**< If true, indications of type "connection_established" will be generated. */
    bcmos_bool connection_failure;      /**< If true, indications of type "connection_failure" will be generated. */
    bcmos_bool ddr_test_complete;       /**< If true, indications of type "ddr_test_complete" will be generated. */
    bcmos_bool device_keep_alive;       /**< If true, indications of type "device_keep_alive" will be generated. */
    bcmos_bool device_ready;            /**< If true, indications of type "device_ready" will be generated. */
    bcmos_bool disconnection_complete;  /**< If true, indications of type "disconnection_complete" will be generated. */
    bcmos_bool image_transfer_complete; /**< If true, indications of type "image_transfer_complete" will be generated. */
    bcmos_bool indications_dropped;     /**< If true, indications of type "indications_dropped" will be generated. */
    bcmos_bool sw_error;                /**< If true, indications of type "sw_error" will be generated. */
    bcmos_bool sw_exception;            /**< If true, indications of type "sw_exception" will be generated. */
} bcmolt_device_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "device" object. 
 */
typedef struct bcmolt_device_auto_cfg
{
    bcmolt_auto_cfg hdr;                /**< Transport header. */
    bcmolt_device_key key;              /**< Object key. */
    bcmolt_device_auto_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_device_auto_cfg;

/** Transport message definition for "connect" group of "device" object. 
 */
typedef struct bcmolt_device_connect
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
} bcmolt_device_connect;

/** Transport message definition for "disconnect" group of "device" object. 
 */
typedef struct bcmolt_device_disconnect
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
} bcmolt_device_disconnect;

/** Structure definition for the "host_keep_alive" group of the "device" object. 
 *
 * Keep alive message from the host to the device - used by the device control 
 * library (should not be sent by the host application). 
 */
typedef struct bcmolt_device_host_keep_alive_data
{
    uint32_t sequence_number;   /**< sequence number */
    uint32_t time_stamp;        /**< time stamp */
} bcmolt_device_host_keep_alive_data;

/** Transport message definition for "host_keep_alive" group of "device" object. 
 */
typedef struct bcmolt_device_host_keep_alive
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_host_keep_alive_data data;    /**< All properties that must be set by the user. */
} bcmolt_device_host_keep_alive;

/** Structure definition for the "image_transfer_data" group of the "device" 
 * object. 
 *
 * used for transferring the actual data from/to the OLT.   not to be directly 
 * called by the user. 
 */
typedef struct bcmolt_device_image_transfer_data_data
{
    uint32_t block_number;          /**< Block number. */
    bcmos_bool more_data;           /**< Specifies that there are more data to come. */
    bcmolt_u8_list_u16_hex data;    /**< Data. */
} bcmolt_device_image_transfer_data_data;

/** Transport message definition for "image_transfer_data" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_image_transfer_data
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_image_transfer_data_data data;    /**< All properties that must be set by the user. */
} bcmolt_device_image_transfer_data;

/** Structure definition for the "image_transfer_start" group of the "device" 
 * object. 
 *
 * This API message informs the OLT of the start of image transfer, and 
 * provides the information of the file image. 
 */
typedef struct bcmolt_device_image_transfer_start_data
{
    bcmolt_device_image_type image_type;    /**< File type. */
    uint32_t image_size;                    /**< Size of the file image.  Ignored for RRQ operation. */
    uint32_t crc32;             /**< CRC32 checksum of the entire file image. */
    bcmolt_str_64 image_name;   /**< Name of the file image.  Null-terminated string.  This is required for the DPoE ONU only.  DPoE requires the write request OAM contains the name of the file. */
} bcmolt_device_image_transfer_start_data;

/** Transport message definition for "image_transfer_start" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_image_transfer_start
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_image_transfer_start_data data;   /**< All properties that must be set by the user. */
} bcmolt_device_image_transfer_start;

/** Structure definition for the "reset" group of the "device" object. 
 *
 * Resets the host/device. 
 */
typedef struct bcmolt_device_reset_data
{
    bcmolt_device_reset_mode mode;  /**< Options to control what should be reset. */
} bcmolt_device_reset_data;

/** Transport message definition for "reset" group of "device" object. 
 */
typedef struct bcmolt_device_reset
{
    bcmolt_oper hdr;                /**< Transport header. */
    bcmolt_device_key key;          /**< Object key. */
    bcmolt_device_reset_data data;  /**< All properties that must be set by the user. */
} bcmolt_device_reset;

/** Structure definition for the "run_ddr_test" group of the "device" object. 
 *
 * Run a test on one or more of the DDR components. 
 */
typedef struct bcmolt_device_run_ddr_test_data
{
    bcmos_bool cpu;     /**< Whether or not to test the CPU DDR */
    bcmos_bool ras_0;   /**< Whether or not to test RAS 0 DDR */
    bcmos_bool ras_1;   /**< Whether or not to test RAS 1 DDR */
} bcmolt_device_run_ddr_test_data;

/** Transport message definition for "run_ddr_test" group of "device" object. 
 */
typedef struct bcmolt_device_run_ddr_test
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
    bcmolt_device_run_ddr_test_data data;   /**< All properties that must be set by the user. */
} bcmolt_device_run_ddr_test;

/** Transport message definition for "sw_upgrade_activate" group of "device" 
 * object. 
 */
typedef struct bcmolt_device_sw_upgrade_activate
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_device_key key;  /**< Object key. */
} bcmolt_device_sw_upgrade_activate;

/** Structure definition for the "key" group of the "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_key
{
    bcmolt_epon_ni epon_ni;         /**< Uniquely identifies the EPON NI containing the link. */
    bcmos_mac_address mac_address;  /**< The MAC address associated with the EPON link. */
} bcmolt_epon_denied_link_key;

/** Structure definition for the "cfg" group of the "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_cfg_data
{
    bcmolt_epon_denied_link_alarm_state alarm_state;    /**< The state of the alarms on this link. */
} bcmolt_epon_denied_link_cfg_data;

/** Transport message definition for "cfg" group of "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_cfg;

/** Structure definition for the "laser_on_off_violation" group of the 
 * "epon_denied_link" object. 
 *
 * This is when a link tries to reigster with an impossible laser on or off 
 * time. 
 */
typedef struct bcmolt_epon_denied_link_laser_on_off_violation_data
{
    bcmolt_laser_on_off_status alarm_status;    /**< Alarm Status. */
} bcmolt_epon_denied_link_laser_on_off_violation_data;

/** Transport message definition for "laser_on_off_violation" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_laser_on_off_violation
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_laser_on_off_violation_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_laser_on_off_violation;

/** Structure definition for the "llid_pool_empty_violation" group of the 
 * "epon_denied_link" object. 
 *
 * A link tried to register and it there are no LLIDs available. If this 
 * occurs, it is possible there is an issue with your 'max links' and/or 'Base 
 * LLID' fields on your RP. 
 */
typedef struct bcmolt_epon_denied_link_llid_pool_empty_violation_data
{
    bcmolt_status alarm_status; /**< Alarm Status. */
} bcmolt_epon_denied_link_llid_pool_empty_violation_data;

/** Transport message definition for "llid_pool_empty_violation" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_llid_pool_empty_violation
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_llid_pool_empty_violation_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_llid_pool_empty_violation;

/** Structure definition for the "max_link_violation" group of the 
 * "epon_denied_link" object. 
 *
 * A link tried to register and it would have put us over the provisioned max 
 * links for the corresponding EPON NI. 
 */
typedef struct bcmolt_epon_denied_link_max_link_violation_data
{
    bcmolt_status alarm_status; /**< Alarm Status. */
} bcmolt_epon_denied_link_max_link_violation_data;

/** Transport message definition for "max_link_violation" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_max_link_violation
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_max_link_violation_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_max_link_violation;

/** Structure definition for the "overhead_profile_violation" group of the 
 * "epon_denied_link" object. 
 *
 * This is when link tries to register and there are already too many existing 
 * laser on/off combinations. 
 */
typedef struct bcmolt_epon_denied_link_overhead_profile_violation_data
{
    bcmolt_status alarm_status; /**< Alarm status. */
} bcmolt_epon_denied_link_overhead_profile_violation_data;

/** Transport message definition for "overhead_profile_violation" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_overhead_profile_violation
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_overhead_profile_violation_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_overhead_profile_violation;

/** Structure definition for the "range_violation" group of the 
 * "epon_denied_link" object. 
 *
 * A link tried to register with a range value that was outside of the min/max 
 * fiber length. 
 */
typedef struct bcmolt_epon_denied_link_range_violation_data
{
    bcmolt_range_status alarm_status;   /**< Alarm Status. */
} bcmolt_epon_denied_link_range_violation_data;

/** Transport message definition for "range_violation" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_range_violation
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_range_violation_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_range_violation;

/** Structure definition for the "rogue_violation" group of the 
 * "epon_denied_link" object. 
 *
 * A Rogue ONU was detected on this link/LLID.  
 */
typedef struct bcmolt_epon_denied_link_rogue_violation_data
{
    bcmolt_rogue_status alarm_status;   /**< Alarm Status. */
} bcmolt_epon_denied_link_rogue_violation_data;

/** Transport message definition for "rogue_violation" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_rogue_violation
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_rogue_violation_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_rogue_violation;

/** Structure definition for the "system_resource_violation" group of the 
 * "epon_denied_link" object. 
 *
 * A link tried to register and we were unable to allocate system resources for 
 * it. 
 */
typedef struct bcmolt_epon_denied_link_system_resource_violation_data
{
    bcmolt_status alarm_status; /**< Alarm Status. */
} bcmolt_epon_denied_link_system_resource_violation_data;

/** Transport message definition for "system_resource_violation" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_system_resource_violation
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_system_resource_violation_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_system_resource_violation;

/** Structure definition for the "tdm_channels_exhausted" group of the 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_tdm_channels_exhausted_data
{
    bcmolt_status alarm_status; /**< Alarm Status. */
} bcmolt_epon_denied_link_tdm_channels_exhausted_data;

/** Transport message definition for "tdm_channels_exhausted" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_tdm_channels_exhausted
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_tdm_channels_exhausted_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_tdm_channels_exhausted;

/** Structure definition for the "unknown_link_violation" group of the 
 * "epon_denied_link" object. 
 *
 * A link tried to register while the PON was set to "notify unknown" 
 * registration behavior and this link was not pre-provisioned. 
 */
typedef struct bcmolt_epon_denied_link_unknown_link_violation_data
{
    bcmolt_unknown_link_status alarm_status;    /**< Alarm Status. */
} bcmolt_epon_denied_link_unknown_link_violation_data;

/** Transport message definition for "unknown_link_violation" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_unknown_link_violation
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_unknown_link_violation_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_unknown_link_violation;

/** Structure definition for the "upstream_bandwidth_violation" group of the 
 * "epon_denied_link" object. 
 *
 * This link failed to register because there was insufficient upstream 
 * bandwidth available to provide the default UBD. 
 */
typedef struct bcmolt_epon_denied_link_upstream_bandwidth_violation_data
{
    bcmolt_status alarm_status; /**< Alarm Status. */
} bcmolt_epon_denied_link_upstream_bandwidth_violation_data;

/** Transport message definition for "upstream_bandwidth_violation" group of 
 * "epon_denied_link" object. 
 */
typedef struct bcmolt_epon_denied_link_upstream_bandwidth_violation
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_denied_link_key key;    /**< Object key. */
    bcmolt_epon_denied_link_upstream_bandwidth_violation_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_upstream_bandwidth_violation;

/** Structure definition for the "auto_cfg" group of the "epon_denied_link" 
 * object. 
 */
typedef struct bcmolt_epon_denied_link_auto_cfg_data
{
    bcmos_bool laser_on_off_violation;          /**< If true, indications of type "laser_on_off_violation" will be generated. */
    bcmos_bool llid_pool_empty_violation;       /**< If true, indications of type "llid_pool_empty_violation" will be generated. */
    bcmos_bool max_link_violation;              /**< If true, indications of type "max_link_violation" will be generated. */
    bcmos_bool overhead_profile_violation;      /**< If true, indications of type "overhead_profile_violation" will be generated. */
    bcmos_bool range_violation;                 /**< If true, indications of type "range_violation" will be generated. */
    bcmos_bool rogue_violation;                 /**< If true, indications of type "rogue_violation" will be generated. */
    bcmos_bool system_resource_violation;       /**< If true, indications of type "system_resource_violation" will be generated. */
    bcmos_bool tdm_channels_exhausted;          /**< If true, indications of type "tdm_channels_exhausted" will be generated. */
    bcmos_bool unknown_link_violation;          /**< If true, indications of type "unknown_link_violation" will be generated. */
    bcmos_bool upstream_bandwidth_violation;    /**< If true, indications of type "upstream_bandwidth_violation" will be generated. */
} bcmolt_epon_denied_link_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "epon_denied_link" 
 * object. 
 */
typedef struct bcmolt_epon_denied_link_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_denied_link_key key;            /**< Object key. */
    bcmolt_epon_denied_link_auto_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_denied_link_auto_cfg;

/** Structure definition for the "key" group of the "epon_link" object. 
 */
typedef struct bcmolt_epon_link_key
{
    bcmolt_epon_ni epon_ni;         /**< Uniquely identifies the EPON NI containing the link. */
    bcmos_mac_address mac_address;  /**< The MAC address associated with the EPON link. */
} bcmolt_epon_link_key;

/** Structure definition for the "cfg" group of the "epon_link" object. 
 */
typedef struct bcmolt_epon_link_cfg_data
{
    bcmolt_epon_link_rate link_rate;            /**< This link's downstream and upstream rate. */
    bcmolt_epon_link_state_flags state_flags;   /**< EPON link state flags reflect the current status of the link.   Registered state flag is controled by the static registration operation for links on a protected-standby PON. */
    bcmolt_epon_llid llid;                      /**< LLID associated with this link. */
    bcmolt_time_quanta laser_on_time_tq;        /**< Laser-on time in time quanta. */
    bcmolt_time_quanta laser_off_time_tq;       /**< Laser-off time in time quanta. */
    bcmolt_time_quanta range_value_tq;          /**< Range value used for this link - in time quanta. */
    bcmolt_meters distance;                     /**< Distance to the ONU (Differs from range value in that this ignores internal delays) */
    bcmolt_epon_link_alarm_state alarm_state;   /**< The state of the alarms on this link. */
    bcmolt_epon_tunnel_id tunnel_id;            /**< Upstream and downstream tunnel ID for this link. */
    bcmolt_epon_onu_id onu_id;                  /**< ONU associated with this EPON link.  A value of 0xFF indicates that the link has not been associated with an ONU. */
    bcmolt_epon_laser_overhead_parameters min_laser_overhead;   /**< For 1G ONUs ,these values will override the standard values of 32. */
    bcmolt_epon_key_exchange_config key_exchange_config;        /**< Encryption key exchange configuration for this link. */
    bcmolt_epon_encryption_config epon_encryption;              /**< Encryption configuration for this link. */
    bcmolt_epon_link_fec_en fec_enable;                 /**< FEC enable state for this link. */
    bcmolt_oam_heartbeat_config oam_heartbeat_config;   /**< OAM heartbeat configuration.  This includes the frame to transmit to the link, and the expected frame/mask from the ONU.   */
    bcmolt_upstream_bandwidth_distribution upstream_bandwidth;  /**< Upstream Bandwidth. */
    bcmolt_ubd_info ubd_info;           /**< Returns the actual values from the UBD. Useful if you want to see what value the firmware chose for a field set to 'automatic'. */
    bcmos_bool clock_transport_enable;  /**< Whether or not to enable clock transport on this link. */
    uint8_t pending_grants;             /**< The number of pending grants. */
    bcmolt_epon_link_type link_type;    /**< Link Type. */
} bcmolt_epon_link_cfg_data;

/** Transport message definition for "cfg" group of "epon_link" object. 
 */
typedef struct bcmolt_epon_link_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_epon_link_key key;       /**< Object key. */
    bcmolt_epon_link_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_link_cfg;

/** Structure definition for the "stat" group of the "epon_link" object. 
 */
typedef struct bcmolt_epon_link_stat_data
{
    uint64_t rx_data_bytes;             /**< The number of data bytes received on this EPON link. */
    uint64_t rx_data_frames;            /**< The number of data frames received on this EPON link. */
    uint64_t rx_frames_64;              /**< The number of 64 byte frames received on this EPON Link */
    uint64_t rx_frames_65_127;          /**< The number of 65 to 127 byte frames received on this EPON Link */
    uint64_t rx_frames_128_255;         /**< The number of 128 to 255 byte frames received on this EPON Link */
    uint64_t rx_frames_256_511;         /**< The number of 256 to 511 byte frames received on this EPON Link */
    uint64_t rx_frames_512_1023;        /**< The number of 512 to 1023 byte frames received on this EPON Link */
    uint64_t rx_frames_1024_1518;       /**< The number of 1024 to 1518 byte frames received on this EPON Link */
    uint64_t rx_frames_1519_2047;       /**< The number of 1519 to 2047 byte frames received on this EPON Link */
    uint64_t rx_frames_2048_4095;       /**< The number of 2048 to 4095 byte frames received on this EPON Link */
    uint64_t rx_frames_4096_9216;       /**< The number of 4096 to 9216 byte frames received on this EPON Link */
    uint64_t rx_frames_9217_16383;      /**< The number of 9217 to 16383 byte frames received on this EPON Link */
    uint64_t rx_oam_bytes;              /**< The number of OAM bytes received on this EPON link. */
    uint64_t rx_oam_frames;             /**< The number of OAM frames received on this EPON link. */
    uint64_t rx_mpcp_frames;            /**< The number of MPCP frames received on this EPON link. */
    uint64_t rx_broadcast_frames;       /**< The number of broadcast frames received on this EPON link. */
    uint64_t rx_unicast_frames;         /**< The number of unicast frames received on this EPON link. */
    uint64_t rx_multicast_frames;       /**< The number of multicast frames received on this EPON link. */
    uint64_t rx_report_frames;          /**< The number of report frames received on this EPON link. */
    uint64_t rx_fcs_error;              /**< The number of bad FCS errors received on this EPON Link */
    uint64_t rx_oversize_error;         /**< The number of oversize errors received on this EPON Link */
    uint64_t rx_runt_error;             /**< The number of runt errors received on this EPON Link */
    uint64_t rx_line_code_error;        /**< The number of line code errors received on this EPON Link */
    uint64_t rx_line_code_error_max;    /**< The number of line code errors max received on this EPON Link */
    uint64_t tx_data_bytes;             /**< The number of data bytes transmitted on this EPON link. */
    uint64_t tx_data_frames;            /**< The number of data frames transmitted on this EPON link. */
    uint64_t tx_frames_64;              /**< The number of 64 byte frames transmitted on this EPON Link */
    uint64_t tx_frames_65_127;          /**< The number of 65 to 127 byte frames transmitted on this EPON Link */
    uint64_t tx_frames_128_255;         /**< The number of 128 to 255 byte frames transmitted on this EPON Link */
    uint64_t tx_frames_256_511;         /**< The number of 256 to 511 byte frames transmitted on this EPON Link */
    uint64_t tx_frames_512_1023;        /**< The number of 512 to 1023 byte frames transmitted on this EPON Link */
    uint64_t tx_frames_1024_1518;       /**< The number of 1024 to 1518 byte frames transmitted on this EPON Link */
    uint64_t tx_frames_1519_2047;       /**< The number of 1519 to 2047 byte frames transmitted on this EPON Link */
    uint64_t tx_frames_2048_4095;       /**< The number of 2048 to 4095 byte frames transmitted on this EPON Link */
    uint64_t tx_frames_4096_9216;       /**< The number of 4096 to 9216 byte frames transmitted on this EPON Link */
    uint64_t tx_frames_9217_16383;      /**< The number of 9217 to 16383 byte frames transmitted on this EPON Link */
    uint64_t tx_oam_bytes;              /**< The number of OAM bytes transmitted on this EPON link. */
    uint64_t tx_oam_frames;             /**< The number of OAM frames transmitted on this EPON link. */
    uint64_t tx_mpcp_frames;            /**< The number of MPCP frames transmitted on this EPON link. */
    uint64_t tx_broadcast_frames;       /**< The number of broadcast frames transmitted on this EPON link. */
    uint64_t tx_unicast_frames;         /**< The number of unicast frames transmitted on this EPON link. */
    uint64_t tx_multicast_frames;       /**< The number of multicast frames transmitted on this EPON link. */
    uint64_t tx_gates;                  /**< The number of gates transmitted on this EPON link. */
} bcmolt_epon_link_stat_data;

/** Transport message definition for "stat" group of "epon_link" object. 
 */
typedef struct bcmolt_epon_link_stat
{
    bcmolt_stat hdr;                    /**< Transport header. */
    bcmolt_epon_link_key key;           /**< Object key. */
    bcmolt_epon_link_stat_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_link_stat;

/** Structure definition for the "stat_cfg" group of the "epon_link" object. 
 */
typedef struct bcmolt_epon_link_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_epon_link_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "epon_link" object. 
 */
typedef struct bcmolt_epon_link_stat_cfg
{
    bcmolt_stat_cfg hdr;        /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_stat_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_link_stat_cfg;

/** Structure definition for the "duplicate_mpcp_registration_request" group of 
 * the "epon_link" object. 
 *
 * A register requested was received for a link with the same MAC address as a 
 * link that has already registered. 
 */
typedef struct bcmolt_epon_link_duplicate_mpcp_registration_request_data
{
    bcmolt_time_quanta initial_range_tq;    /**< Range as calculated from the first frame received. */
    bcmolt_time_quanta current_range_tq;    /**< Range as calculated from the current frame. */
} bcmolt_epon_link_duplicate_mpcp_registration_request_data;

/** Transport message definition for "duplicate_mpcp_registration_request" group 
 * of "epon_link" object. 
 */
typedef struct bcmolt_epon_link_duplicate_mpcp_registration_request
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_duplicate_mpcp_registration_request_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_link_duplicate_mpcp_registration_request;

/** Transport message definition for "encryption_enabled" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_encryption_enabled
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_encryption_enabled;

/** Structure definition for the "key_exchange_failure" group of the "epon_link" 
 * object. 
 *
 * The OLT failed to receive an updated encryption key within the expected time 
 * period after encryption key exchange has been initiated. 
 */
typedef struct bcmolt_epon_link_key_exchange_failure_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_epon_link_key_exchange_failure_data;

/** Transport message definition for "key_exchange_failure" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_key_exchange_failure
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_key_exchange_failure_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_link_key_exchange_failure;

/** Transport message definition for "key_exchange_started" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_key_exchange_started
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_key_exchange_started;

/** Transport message definition for "key_exchange_stopped" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_key_exchange_stopped
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_key_exchange_stopped;

/** Transport message definition for "link_deleted" group of "epon_link" object. 
 */
typedef struct bcmolt_epon_link_link_deleted
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_link_deleted;

/** Structure definition for the "link_speed_mismatch" group of the "epon_link" 
 * object. 
 *
 * Host will receive this indication if a link registers then attempts to 
 * register later at a different speed, or if the link registers at a different 
 * speed than the speed with which it was pre-provisioned. 
 */
typedef struct bcmolt_epon_link_link_speed_mismatch_data
{
    bcmolt_epon_link_rate previous_rate;    /**< PON rate link initially registered */
    bcmolt_epon_link_rate current_rate;     /**< PON rate link is currently attempting to register at */
} bcmolt_epon_link_link_speed_mismatch_data;

/** Transport message definition for "link_speed_mismatch" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_link_speed_mismatch
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_link_speed_mismatch_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_link_link_speed_mismatch;

/** Transport message definition for "mpcp_deregistered" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_mpcp_deregistered
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_mpcp_deregistered;

/** Structure definition for the "mpcp_discovered" group of the "epon_link" 
 * object. 
 *
 * A link has completed MPCP link registration. 
 */
typedef struct bcmolt_epon_link_mpcp_discovered_data
{
    bcmolt_epon_link_info link_info;    /**< Information associated with the discovered link. */
} bcmolt_epon_link_mpcp_discovered_data;

/** Transport message definition for "mpcp_discovered" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_mpcp_discovered
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_mpcp_discovered_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_link_mpcp_discovered;

/** Transport message definition for "mpcp_reg_ack_timeout" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_mpcp_reg_ack_timeout
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_mpcp_reg_ack_timeout;

/** Structure definition for the "mpcp_report_timeout" group of the "epon_link" 
 * object. 
 *
 * The provisioned limit between reports for the specified link has been 
 * exceeded.  This link will be de-registered, and the alarm_status set when 
 * this occurs.  The alarm_status will be cleared when the link attempts to 
 * register again. 
 */
typedef struct bcmolt_epon_link_mpcp_report_timeout_data
{
    bcmolt_status alarm_status; /**< Alarm Status. */
} bcmolt_epon_link_mpcp_report_timeout_data;

/** Transport message definition for "mpcp_report_timeout" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_mpcp_report_timeout
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_mpcp_report_timeout_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_link_mpcp_report_timeout;

/** Structure definition for the "oam_keepalive_timeout" group of the 
 * "epon_link" object. 
 *
 * The provisioned time limit between receiving upstream info frames has been 
 * exceeded.  Normally an ONU will reset its OAM state machine when this 
 * occurrs and the host must re-negotiate OAM and reprovision the link. 
 */
typedef struct bcmolt_epon_link_oam_keepalive_timeout_data
{
    bcmolt_status alarm_status; /**< Alarm Status. */
} bcmolt_epon_link_oam_keepalive_timeout_data;

/** Transport message definition for "oam_keepalive_timeout" group of 
 * "epon_link" object. 
 */
typedef struct bcmolt_epon_link_oam_keepalive_timeout
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_oam_keepalive_timeout_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_link_oam_keepalive_timeout;

/** Transport message definition for "oam_keepalive_timer_started" group of 
 * "epon_link" object. 
 */
typedef struct bcmolt_epon_link_oam_keepalive_timer_started
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_oam_keepalive_timer_started;

/** Transport message definition for "oam_keepalive_timer_stopped" group of 
 * "epon_link" object. 
 */
typedef struct bcmolt_epon_link_oam_keepalive_timer_stopped
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_oam_keepalive_timer_stopped;

/** Structure definition for the "preprovisioned_link_created" group of the 
 * "epon_link" object. 
 *
 * Raised after an 'add_link' operation on an EPON NI completes successfully 
 */
typedef struct bcmolt_epon_link_preprovisioned_link_created_data
{
    bcmolt_epon_link_info link_info;    /**< Information associated with the link. */
} bcmolt_epon_link_preprovisioned_link_created_data;

/** Transport message definition for "preprovisioned_link_created" group of 
 * "epon_link" object. 
 */
typedef struct bcmolt_epon_link_preprovisioned_link_created
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_preprovisioned_link_created_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_link_preprovisioned_link_created;

/** Structure definition for the "protection_switch_occurred" group of the 
 * "epon_link" object. 
 *
 * The link has undergone a protection switch event. 
 */
typedef struct bcmolt_epon_link_protection_switch_occurred_data
{
    bcmolt_epon_protection_state protection_status; /**< The link's post-switch role (working or standby). */
    bcmolt_time_quanta range_value_tq;              /**< Current range value in time quanta. */
} bcmolt_epon_link_protection_switch_occurred_data;

/** Transport message definition for "protection_switch_occurred" group of 
 * "epon_link" object. 
 */
typedef struct bcmolt_epon_link_protection_switch_occurred
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_protection_switch_occurred_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_link_protection_switch_occurred;

/** Structure definition for the "range_value_changed" group of the "epon_link" 
 * object. 
 *
 * Indication sent when a range value has been changed. 
 */
typedef struct bcmolt_epon_link_range_value_changed_data
{
    bcmolt_time_quanta range_value_tq;  /**< New range value. */
} bcmolt_epon_link_range_value_changed_data;

/** Transport message definition for "range_value_changed" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_range_value_changed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_range_value_changed_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_link_range_value_changed;

/** Transport message definition for "rerange_failure" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_rerange_failure
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_rerange_failure;

/** Structure definition for the "stat_alarm_cleared" group of the "epon_link" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_epon_link_stat_alarm_cleared_data
{
    bcmolt_epon_link_stat_id stat;  /**< Statistic identifier. */
} bcmolt_epon_link_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_stat_alarm_cleared_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_link_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "epon_link" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_epon_link_stat_alarm_raised_data
{
    bcmolt_epon_link_stat_id stat;  /**< Statistic identifier. */
} bcmolt_epon_link_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_stat_alarm_raised_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_link_stat_alarm_raised;

/** Transport message definition for "static_registration_done" group of 
 * "epon_link" object. 
 */
typedef struct bcmolt_epon_link_static_registration_done
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_static_registration_done;

/** Structure definition for the "auto_cfg" group of the "epon_link" object. 
 */
typedef struct bcmolt_epon_link_auto_cfg_data
{
    bcmos_bool duplicate_mpcp_registration_request; /**< If true, indications of type "duplicate_mpcp_registration_request" will be generated. */
    bcmos_bool encryption_enabled;                  /**< If true, indications of type "encryption_enabled" will be generated. */
    bcmos_bool key_exchange_failure;                /**< If true, indications of type "key_exchange_failure" will be generated. */
    bcmos_bool key_exchange_started;                /**< If true, indications of type "key_exchange_started" will be generated. */
    bcmos_bool key_exchange_stopped;                /**< If true, indications of type "key_exchange_stopped" will be generated. */
    bcmos_bool link_deleted;                        /**< If true, indications of type "link_deleted" will be generated. */
    bcmos_bool link_speed_mismatch;                 /**< If true, indications of type "link_speed_mismatch" will be generated. */
    bcmos_bool mpcp_deregistered;                   /**< If true, indications of type "mpcp_deregistered" will be generated. */
    bcmos_bool mpcp_discovered;                     /**< If true, indications of type "mpcp_discovered" will be generated. */
    bcmos_bool mpcp_reg_ack_timeout;                /**< If true, indications of type "mpcp_reg_ack_timeout" will be generated. */
    bcmos_bool mpcp_report_timeout;                 /**< If true, indications of type "mpcp_report_timeout" will be generated. */
    bcmos_bool oam_keepalive_timeout;               /**< If true, indications of type "oam_keepalive_timeout" will be generated. */
    bcmos_bool oam_keepalive_timer_started;         /**< If true, indications of type "oam_keepalive_timer_started" will be generated. */
    bcmos_bool oam_keepalive_timer_stopped;         /**< If true, indications of type "oam_keepalive_timer_stopped" will be generated. */
    bcmos_bool preprovisioned_link_created;         /**< If true, indications of type "preprovisioned_link_created" will be generated. */
    bcmos_bool protection_switch_occurred;          /**< If true, indications of type "protection_switch_occurred" will be generated. */
    bcmos_bool range_value_changed;                 /**< If true, indications of type "range_value_changed" will be generated. */
    bcmos_bool rerange_failure;                     /**< If true, indications of type "rerange_failure" will be generated. */
    bcmos_bool stat_alarm_cleared;                  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;                   /**< If true, indications of type "stat_alarm_raised" will be generated. */
    bcmos_bool static_registration_done;            /**< If true, indications of type "static_registration_done" will be generated. */
} bcmolt_epon_link_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "epon_link" object. 
 */
typedef struct bcmolt_epon_link_auto_cfg
{
    bcmolt_auto_cfg hdr;                    /**< Transport header. */
    bcmolt_epon_link_key key;               /**< Object key. */
    bcmolt_epon_link_auto_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_link_auto_cfg;

/** Transport message definition for "delete_link" group of "epon_link" object. 
 */
typedef struct bcmolt_epon_link_delete_link
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_delete_link;

/** Transport message definition for "force_rediscovery" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_force_rediscovery
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_force_rediscovery;

/** Structure definition for the "key_exchange_start" group of the "epon_link" 
 * object. 
 *
 * Apply the corresponding provisioning for 'epon_link.key_exchange_config' 
 * against this link and then start key exchange timer with the given period. 
 */
typedef struct bcmolt_epon_link_key_exchange_start_data
{
    uint16_t period;    /**< Key exchange period in seconds. */
} bcmolt_epon_link_key_exchange_start_data;

/** Transport message definition for "key_exchange_start" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_key_exchange_start
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_key_exchange_start_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_link_key_exchange_start;

/** Transport message definition for "key_exchange_stop" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_key_exchange_stop
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_key_exchange_stop;

/** Structure definition for the "oam_keepalive_timer_start" group of the 
 * "epon_link" object. 
 *
 * Start the OAM keepalive timer against this link. 
 */
typedef struct bcmolt_epon_link_oam_keepalive_timer_start_data
{
    uint16_t send_period;   /**< The period at which to send OAM info frames (in seconds). */
} bcmolt_epon_link_oam_keepalive_timer_start_data;

/** Transport message definition for "oam_keepalive_timer_start" group of 
 * "epon_link" object. 
 */
typedef struct bcmolt_epon_link_oam_keepalive_timer_start
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_oam_keepalive_timer_start_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_link_oam_keepalive_timer_start;

/** Transport message definition for "oam_keepalive_timer_stop" group of 
 * "epon_link" object. 
 */
typedef struct bcmolt_epon_link_oam_keepalive_timer_stop
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
} bcmolt_epon_link_oam_keepalive_timer_stop;

/** Structure definition for the "static_registration" group of the "epon_link" 
 * object. 
 *
 * Statically registers the logical link 
 */
typedef struct bcmolt_epon_link_static_registration_data
{
    bcmolt_time_quanta laseron_time_tq;     /**< Laser-on time in time quanta.\ */
    bcmolt_time_quanta laseroff_time_tq;    /**< Laser-off time in time quanta. */
    bcmolt_time_quanta range_value_tq;      /**< Range value used for this link - in time quanta. */
    uint8_t pending_grants;                 /**< The number of pending grants. */
} bcmolt_epon_link_static_registration_data;

/** Transport message definition for "static_registration" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_static_registration
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_static_registration_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_link_static_registration;

/** Structure definition for the "inject_frame" group of the "epon_link" object. 
 *
 * Send an arbitrary frame across the specified link. 
 */
typedef struct bcmolt_epon_link_inject_frame_data
{
    bcmolt_ethernet_frame_unmasked frame;   /**< Complete contents of the frame beginning with the DA up through but not including the CRC. */
} bcmolt_epon_link_inject_frame_data;

/** Transport message definition for "inject_frame" group of "epon_link" object. 
 */
typedef struct bcmolt_epon_link_inject_frame
{
    bcmolt_proxy hdr;           /**< Transport header. */
    bcmolt_epon_link_key key;   /**< Object key. */
    bcmolt_epon_link_inject_frame_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_link_inject_frame;

/** Structure definition for the "frame_captured" group of the "epon_link" 
 * object. 
 *
 * A frame matching host-specified criteria was received. 
 */
typedef struct bcmolt_epon_link_frame_captured_data
{
    bcmolt_u8_list_u32 frame;   /**< Contents of the frame. */
} bcmolt_epon_link_frame_captured_data;

/** Transport message definition for "frame_captured" group of "epon_link" 
 * object. 
 */
typedef struct bcmolt_epon_link_frame_captured
{
    bcmolt_proxy_rx hdr;                        /**< Transport header. */
    bcmolt_epon_link_key key;                   /**< Object key. */
    bcmolt_epon_link_frame_captured_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_link_frame_captured;

/** Structure definition for the "key" group of the "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_key
{
    bcmolt_epon_ni epon_ni; /**< The index of a specific EPON NI instance as seen by the host. */
} bcmolt_epon_ni_key;

/** Structure definition for the "cfg" group of the "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_cfg_data
{
    bcmos_mac_address mac_address;      /**< The MAC address used for all frames generated by the OLT on the PON.  This value must be set before EPON_NI is first enabled, and cannot be changed while the EPON_NI is enabled. */
    bcmolt_epon_ni_en_state epon_ni_en; /**< Indicates the enable state of the EPON NI. */
    bcmolt_registration_behavior registration_behavior; /**< Determines how registration requests from unknown links are handled.  Set to 'Notify Unknown' to force all links to be pre-provisioned.  If in 'Notify Unknown' mode, MPCP Registration of an unknown link will be denied, and a 'White List Violation" will be sent to the host. If set to 'Automatic', the link registers fully without host interaction.  */
    uint16_t mtu_1g;                        /**< Maximum frame size (including FCS) on the 1G path. This attribute cannot be changed on an enabled EPON_NI. This attribute cannot be an odd value. */
    uint16_t mtu_10g;                       /**< Maximum frame size (including FCS) on the 10G path. This attribute cannot be changed on an enabled EPON_NI. This attribute cannot be an odd value. */
    bcmolt_meters minimum_fiber_length;     /**< The minimum fiber length, in meters, at which we expect to find an ONU. Notes: The difference between the minimum and maximum fiber length cannot exceed 100 km. This attribute cannot be changed on an enabled EPON_NI. Some ONUs can register at distances that are less than the provisioned minimum. */
    bcmolt_meters maximum_fiber_length;     /**< The maximum fiber length, in meters, at which we expect to find an ONU. Notes: The difference between the minimum and maximum fiber length cannot exceed 100 km. This attribute cannot be changed on an enabled EPON_NI. Some ONUs can register at distances that are greater than the provisioned maximum. */
    bcmolt_time_quanta grant_spacing_tq;    /**< The dead time on the PON between upstream bursts.  This attribute cannot be changed on an enabled EPON_NI. */
    bcmolt_epon_logical_link_options epon_logical_link_options; /**< Configuration related to EPON links registration and reporting. This value cannot be changed on an enabled EPON_NI. */
    uint32_t mpcp_discovery_period_ms;              /**< Period of MPCP discovery windows.  In this time period, one discovery gate will be sent for every enabled RP.  The discovery gates will be spaced equally across the time period. */
    bcmolt_epon_ni_alarm_state alarm_state;         /**< The state of the alarms on this EPON NI. */
    bcmolt_macaddress_list_u32_max_2048 all_links;  /**< List of all links on the EPON NI. */
    bcmolt_epon_ni_encryption_cfg encryption_cfg;   /**< Encryption configuration that applies to the EPON NI as a whole. */
    bcmolt_epon_protection_switching_configuration protection_switching_cfg;    /**< Protection switching configuration. */
    bcmolt_epon_clock_transport_configuration clock_transport_cfg;              /**< Clock transport configuration. */
#define BCMOLT_EPON_NI_CFG_DATA_DROPDOWN_WEIGHTS_LEN    7
    bcmolt_arr_u16_7 dropdown_weights;                  /**< The solicited scheduling drop down weights for priorities 0-6 (percentages relative to that priority). Priority 7 has no drop-down, as it is the lowest priority. The drop-down weights are how much bandwidth to allocate to solicited schedulers at the next lower priority level (even when elements at this level are still active).  This is NOT the percentage allocated to the drop down, it is the ratio between a priority and its dropdown */
#define BCMOLT_EPON_NI_CFG_DATA_APPROXIMATE_SOLICITED_USAGE_LEN 8
    bcmolt_arr_bounds_8 approximate_solicited_usage;    /**< The approximate percentage of the PON time necessary to schedule all elements at or above each priority. */
    uint32_t approximate_tdm_usage;                     /**< The approximate percentage of the PON time necessary to accomodate all TDM grants. */
    uint16_t no_reports_soak_time;                      /**< Period of time after last report received to send no reports alarm (in ms). */
    bcmolt_pon_aggregate_shaper pon_aggregate_shaper;   /**< PON Aggregate Shaper. */
#define BCMOLT_EPON_NI_CFG_DATA_ESTIMATED_PON_LATENCY_TQ_LEN    8
    bcmolt_arr_bounds_8 estimated_pon_latency_tq;       /**< The estimated time between when the OLT receives a non-zero report from an ONU and when the OLT will generate a grant to that ONU for each priority level. */
    bcmolt_epon_onu_upgrade_params onu_upgrade_params;  /**< ONU upgrade params. */
    bcmos_bool auto_rogue_detect_10g_en;                /**< Enable 10G Autonomous Rogue Dection during discovery window */
    bcmos_bool auto_rogue_detect_1g_en;                 /**< Enable 1G Autonomous Rogue Dection during discovery window */
    uint8_t auto_rogue_detect_10g_threshold;            /**< Set threshold for number of SyncPatterns received without a Burst Delimiter to trigger the fault. */
} bcmolt_epon_ni_cfg_data;

/** Transport message definition for "cfg" group of "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_epon_ni_key key;         /**< Object key. */
    bcmolt_epon_ni_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_ni_cfg;

/** Transport message definition for "auto_rogue_scan_10g_failure" group of 
 * "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_auto_rogue_scan_10g_failure
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
} bcmolt_epon_ni_auto_rogue_scan_10g_failure;

/** Transport message definition for "auto_rogue_scan_1g_failure" group of 
 * "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_auto_rogue_scan_1g_failure
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
} bcmolt_epon_ni_auto_rogue_scan_1g_failure;

/** Structure definition for the "llid_quarantined" group of the "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_llid_quarantined_data
{
    bcmolt_epon_llid llid;              /**< LLID. */
    bcmolt_epon_link_rate link_rate;    /**< Link Rate. */
    bcmos_mac_address link_mac;         /**< Link MAC. */
    bcmolt_time_quanta range_value_tq;  /**< Range value in time quanta. */
} bcmolt_epon_ni_llid_quarantined_data;

/** Transport message definition for "llid_quarantined" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_llid_quarantined
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_llid_quarantined_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_ni_llid_quarantined;

/** Structure definition for the "mpcp_timestamp_changed" group of the "epon_ni" 
 * object. 
 *
 * A clock transport pulse was received at the given MPCP timestamp. 
 */
typedef struct bcmolt_epon_ni_mpcp_timestamp_changed_data
{
    uint32_t mpcp_timestamp;    /**< The MPCP time at which the pulse was received. */
} bcmolt_epon_ni_mpcp_timestamp_changed_data;

/** Transport message definition for "mpcp_timestamp_changed" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_mpcp_timestamp_changed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_mpcp_timestamp_changed_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_ni_mpcp_timestamp_changed;

/** Structure definition for the "no_reports" group of the "epon_ni" object. 
 *
 * Loss of all reports on all links on the EPON NI 
 */
typedef struct bcmolt_epon_ni_no_reports_data
{
    bcmolt_status alarm_status; /**< Alarm Status. */
} bcmolt_epon_ni_no_reports_data;

/** Transport message definition for "no_reports" group of "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_no_reports
{
    bcmolt_auto hdr;                        /**< Transport header. */
    bcmolt_epon_ni_key key;                 /**< Object key. */
    bcmolt_epon_ni_no_reports_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_ni_no_reports;

/** Structure definition for the "onu_upgrade_complete" group of the "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_onu_upgrade_complete_data
{
    bcmos_bool status;  /**< Success or failure.  Against entire upgrade process. */
    bcmolt_epon_onu_upgrade_status_list_u32 list_of_failed_entities;    /**< List of ONU-IDs the upgrade failed for. */
} bcmolt_epon_ni_onu_upgrade_complete_data;

/** Transport message definition for "onu_upgrade_complete" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_onu_upgrade_complete
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_onu_upgrade_complete_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_ni_onu_upgrade_complete;

/** Transport message definition for "rerange_failure" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_rerange_failure
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
} bcmolt_epon_ni_rerange_failure;

/** Structure definition for the "rogue_scan_complete" group of the "epon_ni" 
 * object. 
 *
 * Indciation that a scan is complete, any error is also returned.  
 */
typedef struct bcmolt_epon_ni_rogue_scan_complete_data
{
    bcmolt_rogue_scan_status return_ind_status; /**< Status of completed scan. */
} bcmolt_epon_ni_rogue_scan_complete_data;

/** Transport message definition for "rogue_scan_complete" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_rogue_scan_complete
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_rogue_scan_complete_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_ni_rogue_scan_complete;

/** Structure definition for the "rssi_measurement_completed" group of the 
 * "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_rssi_measurement_completed_data
{
    bcmolt_result status;       /**< status. */
    bcmolt_epon_llid llid;      /**< LLID. */
    bcmos_mac_address link_mac; /**< Link MAC . */
} bcmolt_epon_ni_rssi_measurement_completed_data;

/** Transport message definition for "rssi_measurement_completed" group of 
 * "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_rssi_measurement_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_rssi_measurement_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_ni_rssi_measurement_completed;

/** Structure definition for the "state_change_completed" group of the "epon_ni" 
 * object. 
 *
 * Sent after a 'set_epon_ni_en_state' operation has completed. 
 */
typedef struct bcmolt_epon_ni_state_change_completed_data
{
    bcmolt_epon_ni_en_state new_state;  /**< New EPON NI enable state. */
} bcmolt_epon_ni_state_change_completed_data;

/** Transport message definition for "state_change_completed" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_state_change_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_state_change_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_ni_state_change_completed;

/** Structure definition for the "auto_cfg" group of the "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_auto_cfg_data
{
    bcmos_bool auto_rogue_scan_10g_failure; /**< If true, indications of type "auto_rogue_scan_10g_failure" will be generated. */
    bcmos_bool auto_rogue_scan_1g_failure;  /**< If true, indications of type "auto_rogue_scan_1g_failure" will be generated. */
    bcmos_bool llid_quarantined;            /**< If true, indications of type "llid_quarantined" will be generated. */
    bcmos_bool mpcp_timestamp_changed;      /**< If true, indications of type "mpcp_timestamp_changed" will be generated. */
    bcmos_bool no_reports;                  /**< If true, indications of type "no_reports" will be generated. */
    bcmos_bool onu_upgrade_complete;        /**< If true, indications of type "onu_upgrade_complete" will be generated. */
    bcmos_bool rerange_failure;             /**< If true, indications of type "rerange_failure" will be generated. */
    bcmos_bool rogue_scan_complete;         /**< If true, indications of type "rogue_scan_complete" will be generated. */
    bcmos_bool rssi_measurement_completed;  /**< If true, indications of type "rssi_measurement_completed" will be generated. */
    bcmos_bool state_change_completed;      /**< If true, indications of type "state_change_completed" will be generated. */
} bcmolt_epon_ni_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_auto_cfg
{
    bcmolt_auto_cfg hdr;                /**< Transport header. */
    bcmolt_epon_ni_key key;             /**< Object key. */
    bcmolt_epon_ni_auto_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_ni_auto_cfg;

/** Structure definition for the "add_link" group of the "epon_ni" object. 
 *
 * Pre-provision an EPON link. 
 */
typedef struct bcmolt_epon_ni_add_link_data
{
    bcmos_mac_address mac_address;  /**< The MAC address of the EPON link. */
    bcmolt_epon_link_rate rate;     /**< Rate of link to pre-provision. */
} bcmolt_epon_ni_add_link_data;

/** Transport message definition for "add_link" group of "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_add_link
{
    bcmolt_oper hdr;                    /**< Transport header. */
    bcmolt_epon_ni_key key;             /**< Object key. */
    bcmolt_epon_ni_add_link_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_ni_add_link;

/** Structure definition for the "add_multicast_link" group of the "epon_ni" 
 * object. 
 *
 * Pre-provision an EPON multicast link. 
 */
typedef struct bcmolt_epon_ni_add_multicast_link_data
{
    bcmos_mac_address mac_address;  /**< The MAC address of the EPON link. */
    bcmolt_epon_link_rate rate;     /**< Rate of link to pre-provision. */
} bcmolt_epon_ni_add_multicast_link_data;

/** Transport message definition for "add_multicast_link" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_add_multicast_link
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_add_multicast_link_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_ni_add_multicast_link;

/** Structure definition for the "add_protected_standby_link" group of the 
 * "epon_ni" object. 
 *
 * Adds a protected standby link.  Once it has been created, the link is 
 * considered "standby" for the puposes of protection switching. 
 */
typedef struct bcmolt_epon_ni_add_protected_standby_link_data
{
    bcmos_mac_address mac_address;              /**< The MAC address of the EPON link. */
    bcmolt_epon_link_info working_link_info;    /**< Link info for the associated working link. */
} bcmolt_epon_ni_add_protected_standby_link_data;

/** Transport message definition for "add_protected_standby_link" group of 
 * "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_add_protected_standby_link
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_add_protected_standby_link_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_ni_add_protected_standby_link;

/** Structure definition for the "issue_rssi_grant" group of the "epon_ni" 
 * object. 
 *
 * Issues an RSSI grant to read RX Power 
 */
typedef struct bcmolt_epon_ni_issue_rssi_grant_data
{
    bcmos_mac_address granted_link; /**< Logical link to grant, which should either be associated with a particular unicast link of interest on the PON or, 0 for idle power measurement. 0 will use a link that will not result in upstream transmission by any device on the PON. */
    uint16_t trigger_width;         /**< RSSI Trigger Width (Tw) in ns, Desired width of RSSI Trigger based on the Optical Module Specifications. */
    uint16_t trigger_delay;         /**< RSSI Trigger Delay(Td), in ns, for this link to meet the (Td) delay timing requirement of the Optical Module Specifications. */
    uint16_t sample_period;         /**< Sample period in us, internal I2C hold/prohibit time where access to device is not allowed. */
} bcmolt_epon_ni_issue_rssi_grant_data;

/** Transport message definition for "issue_rssi_grant" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_issue_rssi_grant
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_issue_rssi_grant_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_ni_issue_rssi_grant;

/** Structure definition for the "protection_switching_apply_rerange_delta" 
 * group of the "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_protection_switching_apply_rerange_delta_data
{
    uint32_t rerange_delta; /**< Re-range delta. */
} bcmolt_epon_ni_protection_switching_apply_rerange_delta_data;

/** Transport message definition for "protection_switching_apply_rerange_delta" 
 * group of "epon_ni" object. 
 */
typedef struct bcmolt_epon_ni_protection_switching_apply_rerange_delta
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_protection_switching_apply_rerange_delta_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_ni_protection_switching_apply_rerange_delta;

/** Structure definition for the "rogue_llid_scan" group of the "epon_ni" 
 * object. 
 *
 * Issue a request to scan all LLIDs or a specific LLID on a PON 
 */
typedef struct bcmolt_epon_ni_rogue_llid_scan_data
{
    bcmos_bool mode;        /**< True = Scan all LLIDS on the PON */
    bcmolt_epon_llid llid;  /**< Specific LLID to scan or 0 to scan all when mode is ALL */
} bcmolt_epon_ni_rogue_llid_scan_data;

/** Transport message definition for "rogue_llid_scan" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_rogue_llid_scan
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_rogue_llid_scan_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_ni_rogue_llid_scan;

/** Structure definition for the "set_epon_ni_en_state" group of the "epon_ni" 
 * object. 
 *
 * Set the EPON NI enable state. 
 */
typedef struct bcmolt_epon_ni_set_epon_ni_en_state_data
{
    bcmolt_epon_ni_en_state new_state;  /**< New EPON NI enable state. */
} bcmolt_epon_ni_set_epon_ni_en_state_data;

/** Transport message definition for "set_epon_ni_en_state" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_set_epon_ni_en_state
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_set_epon_ni_en_state_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_ni_set_epon_ni_en_state;

/** Structure definition for the "start_onu_upgrade" group of the "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_start_onu_upgrade_data
{
    bcmolt_macaddress_list_u32 list_of_onu_ids; /**< List of ONUs to upgrade the firmware. */
} bcmolt_epon_ni_start_onu_upgrade_data;

/** Transport message definition for "start_onu_upgrade" group of "epon_ni" 
 * object. 
 */
typedef struct bcmolt_epon_ni_start_onu_upgrade
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_epon_ni_key key; /**< Object key. */
    bcmolt_epon_ni_start_onu_upgrade_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_ni_start_onu_upgrade;

/** Structure definition for the "key" group of the "epon_onu_10g_us" object. 
 */
typedef struct bcmolt_epon_onu_10g_us_key
{
    bcmolt_epon_ni epon_ni;     /**< EPON NI with which this ONU interface is associated. */
    bcmolt_epon_onu_id onu_id;  /**< Unique identifier of the ONU interface within its EPON NI. */
} bcmolt_epon_onu_10g_us_key;

/** Structure definition for the "cfg" group of the "epon_onu_10g_us" object. 
 */
typedef struct bcmolt_epon_onu_10g_us_cfg_data
{
    bcmolt_macaddress_list_u32_max_2048 all_links;  /**< List of MAC Addresses for all links on the ONU Id. */
} bcmolt_epon_onu_10g_us_cfg_data;

/** Transport message definition for "cfg" group of "epon_onu_10g_us" object. 
 */
typedef struct bcmolt_epon_onu_10g_us_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_epon_onu_10g_us_key key; /**< Object key. */
    bcmolt_epon_onu_10g_us_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_onu_10g_us_cfg;

/** Structure definition for the "stat" group of the "epon_onu_10g_us" object. 
 */
typedef struct bcmolt_epon_onu_10g_us_stat_data
{
    uint64_t fec_code_words_total;          /**< FEC stats code words total */
    uint64_t fec_code_words_decode_fails;   /**< FEC stats code words decode fails */
    uint64_t fec_zeroes_corrected;          /**< FEC stats zeros corrected */
    uint64_t fec_ones_corrected;            /**< FEC stats ones corected */
} bcmolt_epon_onu_10g_us_stat_data;

/** Transport message definition for "stat" group of "epon_onu_10g_us" object. 
 */
typedef struct bcmolt_epon_onu_10g_us_stat
{
    bcmolt_stat hdr;                        /**< Transport header. */
    bcmolt_epon_onu_10g_us_key key;         /**< Object key. */
    bcmolt_epon_onu_10g_us_stat_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_onu_10g_us_stat;

/** Structure definition for the "stat_cfg" group of the "epon_onu_10g_us" 
 * object. 
 */
typedef struct bcmolt_epon_onu_10g_us_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_epon_onu_10g_us_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "epon_onu_10g_us" 
 * object. 
 */
typedef struct bcmolt_epon_onu_10g_us_stat_cfg
{
    bcmolt_stat_cfg hdr;            /**< Transport header. */
    bcmolt_epon_onu_10g_us_key key; /**< Object key. */
    bcmolt_epon_onu_10g_us_stat_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_onu_10g_us_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the 
 * "epon_onu_10g_us" object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_epon_onu_10g_us_stat_alarm_cleared_data
{
    bcmolt_epon_onu_10g_us_stat_id stat;    /**< Statistic identifier. */
} bcmolt_epon_onu_10g_us_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of 
 * "epon_onu_10g_us" object. 
 */
typedef struct bcmolt_epon_onu_10g_us_stat_alarm_cleared
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_epon_onu_10g_us_key key; /**< Object key. */
    bcmolt_epon_onu_10g_us_stat_alarm_cleared_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_onu_10g_us_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the 
 * "epon_onu_10g_us" object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_epon_onu_10g_us_stat_alarm_raised_data
{
    bcmolt_epon_onu_10g_us_stat_id stat;    /**< Statistic identifier. */
} bcmolt_epon_onu_10g_us_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of 
 * "epon_onu_10g_us" object. 
 */
typedef struct bcmolt_epon_onu_10g_us_stat_alarm_raised
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_epon_onu_10g_us_key key; /**< Object key. */
    bcmolt_epon_onu_10g_us_stat_alarm_raised_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_onu_10g_us_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "epon_onu_10g_us" 
 * object. 
 */
typedef struct bcmolt_epon_onu_10g_us_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_epon_onu_10g_us_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "epon_onu_10g_us" 
 * object. 
 */
typedef struct bcmolt_epon_onu_10g_us_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_onu_10g_us_key key;             /**< Object key. */
    bcmolt_epon_onu_10g_us_auto_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_onu_10g_us_auto_cfg;

/** Structure definition for the "key" group of the "epon_onu_1g_us" object. 
 */
typedef struct bcmolt_epon_onu_1g_us_key
{
    bcmolt_epon_ni epon_ni;     /**< EPON NI with which this ONU interface is associated. */
    bcmolt_epon_onu_id onu_id;  /**< Unique identifier of the ONU interface within its EPON NI. */
} bcmolt_epon_onu_1g_us_key;

/** Structure definition for the "cfg" group of the "epon_onu_1g_us" object. 
 */
typedef struct bcmolt_epon_onu_1g_us_cfg_data
{
    bcmolt_macaddress_list_u32 all_links;   /**< List of MAC Addresses for all links on the ONU Id. */
} bcmolt_epon_onu_1g_us_cfg_data;

/** Transport message definition for "cfg" group of "epon_onu_1g_us" object. 
 */
typedef struct bcmolt_epon_onu_1g_us_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_epon_onu_1g_us_key key;  /**< Object key. */
    bcmolt_epon_onu_1g_us_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_onu_1g_us_cfg;

/** Structure definition for the "stat" group of the "epon_onu_1g_us" object. 
 */
typedef struct bcmolt_epon_onu_1g_us_stat_data
{
    uint64_t good_frames;           /**< Good Frame Count, including nonFEC and FEC */
    uint64_t good_bytes;            /**< Good Byte Count, including nonFEC and FEC */
    uint64_t oversz_frames;         /**< Oversized frame count (frames larger than 2000 bytes) */
    uint64_t non_fec_good_frames;   /**< Non FEC Good Frame Count */
    uint64_t non_fec_good_bytes;    /**< Non FEC Good Byte Count */
    uint64_t fec_good_frames;       /**< FEC Good Frame Count */
    uint64_t fec_good_bytes;        /**< FEC Good Byte Count */
    uint64_t fec_frames_exc_errs;   /**< FEC Frames which exceeded 8 symbol errors */
    uint64_t fec_blks_no_errs;      /**< FEC Blocks with no errors */
    uint64_t fec_blks_corr_errs;    /**< FEC Blocks with correctable errors */
    uint64_t fec_blks_uncorr_errs;  /**< FEC Blocks with uncorrectable errors */
    uint64_t fec_corr_bytes;        /**< FEC Corrected Bytes/Symbols */
    uint64_t fec_corr_zeroes;       /**< FEC Corrected Zeroes, 8b domain */
    uint64_t fec_corr_ones;         /**< FEC Corrected Ones, 8b domain */
    uint64_t undersz_frames;        /**< Undersize frame count (frames less than 64 bytes) */
    uint64_t errorsz_frames;        /**< Errored frame  */
} bcmolt_epon_onu_1g_us_stat_data;

/** Transport message definition for "stat" group of "epon_onu_1g_us" object. 
 */
typedef struct bcmolt_epon_onu_1g_us_stat
{
    bcmolt_stat hdr;                        /**< Transport header. */
    bcmolt_epon_onu_1g_us_key key;          /**< Object key. */
    bcmolt_epon_onu_1g_us_stat_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_onu_1g_us_stat;

/** Structure definition for the "stat_cfg" group of the "epon_onu_1g_us" 
 * object. 
 */
typedef struct bcmolt_epon_onu_1g_us_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_epon_onu_1g_us_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "epon_onu_1g_us" 
 * object. 
 */
typedef struct bcmolt_epon_onu_1g_us_stat_cfg
{
    bcmolt_stat_cfg hdr;            /**< Transport header. */
    bcmolt_epon_onu_1g_us_key key;  /**< Object key. */
    bcmolt_epon_onu_1g_us_stat_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_onu_1g_us_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the 
 * "epon_onu_1g_us" object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_epon_onu_1g_us_stat_alarm_cleared_data
{
    bcmolt_epon_onu_1g_us_stat_id stat; /**< Statistic identifier. */
} bcmolt_epon_onu_1g_us_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of 
 * "epon_onu_1g_us" object. 
 */
typedef struct bcmolt_epon_onu_1g_us_stat_alarm_cleared
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_epon_onu_1g_us_key key;  /**< Object key. */
    bcmolt_epon_onu_1g_us_stat_alarm_cleared_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_onu_1g_us_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the 
 * "epon_onu_1g_us" object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_epon_onu_1g_us_stat_alarm_raised_data
{
    bcmolt_epon_onu_1g_us_stat_id stat; /**< Statistic identifier. */
} bcmolt_epon_onu_1g_us_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of 
 * "epon_onu_1g_us" object. 
 */
typedef struct bcmolt_epon_onu_1g_us_stat_alarm_raised
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_epon_onu_1g_us_key key;  /**< Object key. */
    bcmolt_epon_onu_1g_us_stat_alarm_raised_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_onu_1g_us_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "epon_onu_1g_us" 
 * object. 
 */
typedef struct bcmolt_epon_onu_1g_us_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_epon_onu_1g_us_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "epon_onu_1g_us" 
 * object. 
 */
typedef struct bcmolt_epon_onu_1g_us_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_onu_1g_us_key key;              /**< Object key. */
    bcmolt_epon_onu_1g_us_auto_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_onu_1g_us_auto_cfg;

/** Structure definition for the "key" group of the "epon_path_10g_ds" object. 
 */
typedef struct bcmolt_epon_path_10g_ds_key
{
    bcmolt_epon_ni epon_ni; /**< EPON NI associated with this 10G downstream path. */
} bcmolt_epon_path_10g_ds_key;

/** Structure definition for the "cfg" group of the "epon_path_10g_ds" object. 
 */
typedef struct bcmolt_epon_path_10g_ds_cfg_data
{
    bcmolt_epon_fec_en_state fec_state; /**< FEC enable state for the 10G downstream path on this EPON NI.  This attribute cannot be changed while the EPON_NI is enabled. */
    bcmolt_prbs_generator_config prbs_generator;    /**< DS PRBS generator configuration */
} bcmolt_epon_path_10g_ds_cfg_data;

/** Transport message definition for "cfg" group of "epon_path_10g_ds" object. 
 */
typedef struct bcmolt_epon_path_10g_ds_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_epon_path_10g_ds_key key;    /**< Object key. */
    bcmolt_epon_path_10g_ds_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_ds_cfg;

/** Structure definition for the "stat" group of the "epon_path_10g_ds" object. 
 */
typedef struct bcmolt_epon_path_10g_ds_stat_data
{
    uint64_t bytes;             /**< The number of bytes transmitted on this 10g downstream path. */
    uint64_t frames;            /**< The number of frames transmitted on this 10g downstream path. */
    uint64_t frames_64;         /**< The number of 64 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_65_127;     /**< The number of 65 to 127 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_128_255;    /**< The number of 128 to 255 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_256_511;    /**< The number of 256 to 511 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_512_1023;   /**< The number of 512 to 1023 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_1024_1518;  /**< The number of 1024 to 1518 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_1519_2047;  /**< The number of 1519 to 2047 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_2048_4095;  /**< The number of 2048 to 4095 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_4096_9216;  /**< The number of 4096 to 9216 byte frames transmitted on this 10g downstream path. */
    uint64_t frames_9217_16383; /**< The number of 9217 to 16383 byte frames transmitted on this 10g downstream path. */
    uint64_t broadcast_frames;  /**< The number of broadcast frames transmitted on this 10g downstream path. */
    uint64_t data_bytes;        /**< The number of data bytes transmitted on this 10g downstream path. */
    uint64_t multicast_frames;  /**< The number of multicast frames transmitted on this 10g downstream path. */
    uint64_t unicast_frames;    /**< The number of unicast frames transmitted on this 10g downstream path. */
    uint64_t oam_bytes;         /**< Number of OAM bytes transmitted on this 10g downstream path. */
    uint64_t oam_frames;        /**< Number of OAM frames transmitted on this 10g downstream path. */
    uint64_t gate_frames;       /**< Number of gate frames transmitted on this 10g downstream path. */
    uint64_t mpcp_frames;       /**< Number of MPCP frames transmitted on this 10g downstream path. */
    uint64_t abort_frames;      /**< Number of abort frames transmitted on this 10g downstream path. */
} bcmolt_epon_path_10g_ds_stat_data;

/** Transport message definition for "stat" group of "epon_path_10g_ds" object. 
 */
typedef struct bcmolt_epon_path_10g_ds_stat
{
    bcmolt_stat hdr;                    /**< Transport header. */
    bcmolt_epon_path_10g_ds_key key;    /**< Object key. */
    bcmolt_epon_path_10g_ds_stat_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_ds_stat;

/** Structure definition for the "stat_cfg" group of the "epon_path_10g_ds" 
 * object. 
 */
typedef struct bcmolt_epon_path_10g_ds_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_epon_path_10g_ds_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "epon_path_10g_ds" 
 * object. 
 */
typedef struct bcmolt_epon_path_10g_ds_stat_cfg
{
    bcmolt_stat_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_path_10g_ds_key key;            /**< Object key. */
    bcmolt_epon_path_10g_ds_stat_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_ds_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the 
 * "epon_path_10g_ds" object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_epon_path_10g_ds_stat_alarm_cleared_data
{
    bcmolt_epon_path_10g_ds_stat_id stat;   /**< Statistic identifier. */
} bcmolt_epon_path_10g_ds_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of 
 * "epon_path_10g_ds" object. 
 */
typedef struct bcmolt_epon_path_10g_ds_stat_alarm_cleared
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_path_10g_ds_key key;    /**< Object key. */
    bcmolt_epon_path_10g_ds_stat_alarm_cleared_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_ds_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the 
 * "epon_path_10g_ds" object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_epon_path_10g_ds_stat_alarm_raised_data
{
    bcmolt_epon_path_10g_ds_stat_id stat;   /**< Statistic identifier. */
} bcmolt_epon_path_10g_ds_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of 
 * "epon_path_10g_ds" object. 
 */
typedef struct bcmolt_epon_path_10g_ds_stat_alarm_raised
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_path_10g_ds_key key;    /**< Object key. */
    bcmolt_epon_path_10g_ds_stat_alarm_raised_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_ds_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "epon_path_10g_ds" 
 * object. 
 */
typedef struct bcmolt_epon_path_10g_ds_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_epon_path_10g_ds_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "epon_path_10g_ds" 
 * object. 
 */
typedef struct bcmolt_epon_path_10g_ds_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_path_10g_ds_key key;            /**< Object key. */
    bcmolt_epon_path_10g_ds_auto_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_ds_auto_cfg;

/** Structure definition for the "key" group of the "epon_path_10g_us" object. 
 */
typedef struct bcmolt_epon_path_10g_us_key
{
    bcmolt_epon_ni epon_ni; /**< EPON NI associated with this 10G upstream path. */
} bcmolt_epon_path_10g_us_key;

/** Structure definition for the "cfg" group of the "epon_path_10g_us" object. 
 */
typedef struct bcmolt_epon_path_10g_us_cfg_data
{
    bcmolt_epon_fec_en_state fec_state;         /**< FEC enable state for the 10G upstream path on this EPON NI.  This attribute cannot be changed while the EPON_NI is enabled. */
    bcmolt_time_quanta sync_time_tq;            /**< Time quanta of sync at start of US burst.  This attribute cannot be changed while the EPON_NI is enabled. */
    bcmolt_prbs_checker_config prbs_checker;    /**< US PRBS checker configuration */
    bcmolt_prbs_status prbs_status;             /**< Result of US PRBS checker */
} bcmolt_epon_path_10g_us_cfg_data;

/** Transport message definition for "cfg" group of "epon_path_10g_us" object. 
 */
typedef struct bcmolt_epon_path_10g_us_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_epon_path_10g_us_key key;    /**< Object key. */
    bcmolt_epon_path_10g_us_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_us_cfg;

/** Structure definition for the "stat" group of the "epon_path_10g_us" object. 
 */
typedef struct bcmolt_epon_path_10g_us_stat_data
{
    uint64_t bytes;             /**< The number of bytes received on this 10g upstream path. */
    uint64_t frames;            /**< The number of frames received on this 10g upstream path. */
    uint64_t frames_64;         /**< The number of 64 byte frames received on this 10g upstream path. */
    uint64_t frames_65_127;     /**< The number of 65 to 127 byte frames received on this 10g upstream path. */
    uint64_t frames_128_255;    /**< The number of 128 to 255 byte frames received on this 10g upstream path. */
    uint64_t frames_256_511;    /**< The number of 256 to 511 byte frames received on this 10g upstream path. */
    uint64_t frames_512_1023;   /**< The number of 512 to 1023 byte frames received on this 10g upstream path. */
    uint64_t frames_1024_1518;  /**< The number of 1024 to 1518 byte frames received on this 10g upstream path. */
    uint64_t frames_1519_2047;  /**< The number of 1519 to 2047 byte frames received on this 10g upstream path. */
    uint64_t frames_2048_4095;  /**< The number of 2048 to 4095 byte frames received on this 10g upstream path. */
    uint64_t frames_4096_9216;  /**< The number of 4096 to 9216 byte frames received on this 10g upstream path. */
    uint64_t frames_9217_16383; /**< The number of 9217 to 16383 byte frames received on this 10g upstream path. */
    uint64_t broadcast_frames;  /**< The number of broadcast frames received on this 10g upstream path. */
    uint64_t data_bytes;        /**< The number of data bytes received on this 10g upstream path. */
    uint64_t multicast_frames;  /**< The number of multicast frames received on this 10g upstream path. */
    uint64_t unicast_frames;    /**< The number of unicast frames received on this 10g upstream path. */
    uint64_t mpcp_frames;       /**< The number of MPCP frames received on this 10g upstream path. */
    uint64_t oam_bytes;         /**< The number of OAM bytes received on this 10g upstream path. */
    uint64_t oam_frames;        /**< The number of OAM frames received on this 10g upstream path. */
    uint64_t report_frames;     /**< The number of report frames received on this 10g upstream path. */
    uint64_t abort_frames;      /**< The number of abort frames received on this 10g upstream path. */
    uint64_t fcs_error;         /**< The number of bad FCS errors received on this 10g upstream path. */
    uint64_t crc_8_error;       /**< The number of CRC8 errors received on this 10g upstream path. */
    uint64_t out_of_slot;       /**< The number of out of slot errors received on this 10g upstream path. */
    uint64_t oversize_error;    /**< The number of oversize errors received on this 10g upstream path. */
    uint64_t runt_error;        /**< The number of runt errors received on this 10g upstream path. */
} bcmolt_epon_path_10g_us_stat_data;

/** Transport message definition for "stat" group of "epon_path_10g_us" object. 
 */
typedef struct bcmolt_epon_path_10g_us_stat
{
    bcmolt_stat hdr;                    /**< Transport header. */
    bcmolt_epon_path_10g_us_key key;    /**< Object key. */
    bcmolt_epon_path_10g_us_stat_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_us_stat;

/** Structure definition for the "stat_cfg" group of the "epon_path_10g_us" 
 * object. 
 */
typedef struct bcmolt_epon_path_10g_us_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_epon_path_10g_us_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "epon_path_10g_us" 
 * object. 
 */
typedef struct bcmolt_epon_path_10g_us_stat_cfg
{
    bcmolt_stat_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_path_10g_us_key key;            /**< Object key. */
    bcmolt_epon_path_10g_us_stat_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_us_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the 
 * "epon_path_10g_us" object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_epon_path_10g_us_stat_alarm_cleared_data
{
    bcmolt_epon_path_10g_us_stat_id stat;   /**< Statistic identifier. */
} bcmolt_epon_path_10g_us_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of 
 * "epon_path_10g_us" object. 
 */
typedef struct bcmolt_epon_path_10g_us_stat_alarm_cleared
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_path_10g_us_key key;    /**< Object key. */
    bcmolt_epon_path_10g_us_stat_alarm_cleared_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_us_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the 
 * "epon_path_10g_us" object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_epon_path_10g_us_stat_alarm_raised_data
{
    bcmolt_epon_path_10g_us_stat_id stat;   /**< Statistic identifier. */
} bcmolt_epon_path_10g_us_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of 
 * "epon_path_10g_us" object. 
 */
typedef struct bcmolt_epon_path_10g_us_stat_alarm_raised
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_epon_path_10g_us_key key;    /**< Object key. */
    bcmolt_epon_path_10g_us_stat_alarm_raised_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_us_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "epon_path_10g_us" 
 * object. 
 */
typedef struct bcmolt_epon_path_10g_us_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_epon_path_10g_us_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "epon_path_10g_us" 
 * object. 
 */
typedef struct bcmolt_epon_path_10g_us_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_path_10g_us_key key;            /**< Object key. */
    bcmolt_epon_path_10g_us_auto_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_path_10g_us_auto_cfg;

/** Structure definition for the "key" group of the "epon_path_1g_ds" object. 
 */
typedef struct bcmolt_epon_path_1g_ds_key
{
    bcmolt_epon_ni epon_ni; /**< EPON NI associated with this 1G downstream path. */
} bcmolt_epon_path_1g_ds_key;

/** Structure definition for the "cfg" group of the "epon_path_1g_ds" object. 
 */
typedef struct bcmolt_epon_path_1g_ds_cfg_data
{
    bcmolt_epon_fec_en_state default_fec_state; /**< Default FEC enable state for the 1G downstream path on this EPON NI.  This attribute cannot be changed while the EPON_NI is enabled. */
    bcmolt_raman_mitigation_mode raman_mode;    /**< Raman mitigation mode for the 1G downstream path on this EPON NI.  Raman mitigation cannot coexist with turbo mode.  This attribute cannot be changed while the EPON_NI is enabled. */
    bcmolt_epon_1g_turbo_mode turbo_2g_mode;    /**< Operate the 1G downstream path at the turbo 2G data rate on this EPON NI.  Raman mitigation cannot coexist with turbo mode.  This attribute cannot be changed while the EPON_NI is enabled. */
    bcmolt_prbs_generator_config prbs_generator;    /**< DS PRBS generator configuration */
} bcmolt_epon_path_1g_ds_cfg_data;

/** Transport message definition for "cfg" group of "epon_path_1g_ds" object. 
 */
typedef struct bcmolt_epon_path_1g_ds_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_epon_path_1g_ds_key key; /**< Object key. */
    bcmolt_epon_path_1g_ds_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_ds_cfg;

/** Structure definition for the "stat" group of the "epon_path_1g_ds" object. 
 */
typedef struct bcmolt_epon_path_1g_ds_stat_data
{
    uint64_t bytes;             /**< The number of bytes transmitted on this 1g downstream path. */
    uint64_t frames;            /**< The number of frames transmitted on this 1g downstream path. */
    uint64_t frames_64;         /**< The number of 64 byte frames transmitted on this 1g downstream path. */
    uint64_t frames_65_127;     /**< The number of 65 to 127 byte frames transmitted on this 1g downstream path. */
    uint64_t frames_128_255;    /**< The number of 128 to 255 byte frames transmitted on this 1g downstream path. */
    uint64_t frames_256_511;    /**< The number of 256 to 511 byte frames transmitted on this 1g downstream path. */
    uint64_t frames_512_1023;   /**< The number of 512 to 1023 byte frames transmitted on this 1g downstream path. */
    uint64_t frames_1024_1518;  /**< The number of 1024 to 1518 byte frames transmitted on this 1g downstream path. */
    uint64_t frames_1519_2047;  /**< The number of 1519 to 2047 byte frames transmitted on this 1g downstream path. */
    uint64_t frames_2048_4095;  /**< The number of 2048 to 4095 byte frames transmitted on this 1g downstream path. */
    uint64_t frames_4096_9216;  /**< The number of 4096 to 9216 byte frames transmitted on this 1g downstream path. */
    uint64_t frames_9217_16383; /**< The number of 9217 to 16383 byte frames transmitted on this 1g downstream path. */
    uint64_t broadcast_frames;  /**< The number of broadcast frames transmitted on this 1g downstream path. */
    uint64_t data_bytes;        /**< The number of data bytes transmitted on this 1g downstream path. */
    uint64_t multicast_frames;  /**< The number of multicast frames transmitted on this 1g downstream path. */
    uint64_t unicast_frames;    /**< The number of unicast frames transmitted on this 1g downstream path. */
    uint64_t oam_bytes;         /**< Number of OAM bytes transmitted on this 1g downstream path. */
    uint64_t oam_frames;        /**< Number of OAM frames transmitted on this 1g downstream path. */
    uint64_t gate_frames;       /**< Number of gate frames transmitted on this 1g downstream path. */
    uint64_t mpcp_frames;       /**< Number of MPCP frames transmitted on this 1g downstream path. */
    uint64_t abort_frames;      /**< Number of abort frames transmitted on this 1g downstream path. */
} bcmolt_epon_path_1g_ds_stat_data;

/** Transport message definition for "stat" group of "epon_path_1g_ds" object. 
 */
typedef struct bcmolt_epon_path_1g_ds_stat
{
    bcmolt_stat hdr;                /**< Transport header. */
    bcmolt_epon_path_1g_ds_key key; /**< Object key. */
    bcmolt_epon_path_1g_ds_stat_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_ds_stat;

/** Structure definition for the "stat_cfg" group of the "epon_path_1g_ds" 
 * object. 
 */
typedef struct bcmolt_epon_path_1g_ds_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_epon_path_1g_ds_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "epon_path_1g_ds" 
 * object. 
 */
typedef struct bcmolt_epon_path_1g_ds_stat_cfg
{
    bcmolt_stat_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_path_1g_ds_key key;             /**< Object key. */
    bcmolt_epon_path_1g_ds_stat_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_ds_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the 
 * "epon_path_1g_ds" object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_epon_path_1g_ds_stat_alarm_cleared_data
{
    bcmolt_epon_path_1g_ds_stat_id stat;    /**< Statistic identifier. */
} bcmolt_epon_path_1g_ds_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of 
 * "epon_path_1g_ds" object. 
 */
typedef struct bcmolt_epon_path_1g_ds_stat_alarm_cleared
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_epon_path_1g_ds_key key; /**< Object key. */
    bcmolt_epon_path_1g_ds_stat_alarm_cleared_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_ds_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the 
 * "epon_path_1g_ds" object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_epon_path_1g_ds_stat_alarm_raised_data
{
    bcmolt_epon_path_1g_ds_stat_id stat;    /**< Statistic identifier. */
} bcmolt_epon_path_1g_ds_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of 
 * "epon_path_1g_ds" object. 
 */
typedef struct bcmolt_epon_path_1g_ds_stat_alarm_raised
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_epon_path_1g_ds_key key; /**< Object key. */
    bcmolt_epon_path_1g_ds_stat_alarm_raised_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_ds_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "epon_path_1g_ds" 
 * object. 
 */
typedef struct bcmolt_epon_path_1g_ds_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_epon_path_1g_ds_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "epon_path_1g_ds" 
 * object. 
 */
typedef struct bcmolt_epon_path_1g_ds_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_path_1g_ds_key key;             /**< Object key. */
    bcmolt_epon_path_1g_ds_auto_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_ds_auto_cfg;

/** Structure definition for the "key" group of the "epon_path_1g_us" object. 
 */
typedef struct bcmolt_epon_path_1g_us_key
{
    bcmolt_epon_ni epon_ni; /**< EPON NI associated with this 1G upstream path. */
} bcmolt_epon_path_1g_us_key;

/** Structure definition for the "cfg" group of the "epon_path_1g_us" object. 
 */
typedef struct bcmolt_epon_path_1g_us_cfg_data
{
    bcmolt_epon_fec_en_state default_fec_state; /**< Default FEC enable state for the 1G upstream path on this EPON NI.  This attribute cannot be changed while the EPON_NI is enabled. */
    bcmolt_time_quanta sync_time_tq;            /**< Time quanta of sync at start of US burst.  This attribute cannot be changed while the EPON_NI is enabled. */
    bcmolt_prbs_checker_config prbs_checker;    /**< US PRBS checker configuration */
    bcmolt_prbs_status prbs_status;             /**< Result of US PRBS checker */
} bcmolt_epon_path_1g_us_cfg_data;

/** Transport message definition for "cfg" group of "epon_path_1g_us" object. 
 */
typedef struct bcmolt_epon_path_1g_us_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_epon_path_1g_us_key key; /**< Object key. */
    bcmolt_epon_path_1g_us_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_us_cfg;

/** Structure definition for the "stat" group of the "epon_path_1g_us" object. 
 */
typedef struct bcmolt_epon_path_1g_us_stat_data
{
    uint64_t bytes;             /**< The number of bytes received on this 1g upstream path. */
    uint64_t frames;            /**< The number of frames received on this 1g upstream path. */
    uint64_t frames_64;         /**< The number of 64 byte frames received on this 1g upstream path. */
    uint64_t frames_65_127;     /**< The number of 65 to 127 byte frames received on this 1g upstream path. */
    uint64_t frames_128_255;    /**< The number of 128 to 255 byte frames received on this 1g upstream path. */
    uint64_t frames_256_511;    /**< The number of 256 to 511 byte frames received on this 1g upstream path. */
    uint64_t frames_512_1023;   /**< The number of 512 to 1023 byte frames received on this 1g upstream path. */
    uint64_t frames_1024_1518;  /**< The number of 1024 to 1518 byte frames received on this 1g upstream path. */
    uint64_t frames_1519_2047;  /**< The number of 1519 to 2047 byte frames received on this 1g upstream path. */
    uint64_t frames_2048_4095;  /**< The number of 2048 to 4095 byte frames received on this 1g upstream path. */
    uint64_t frames_4096_9216;  /**< The number of 4096 to 9216 byte frames received on this 1g upstream path. */
    uint64_t frames_9217_16383; /**< The number of 9217 to 16383 byte frames received on this 1g upstream path. */
    uint64_t broadcast_frames;  /**< The number of broadcast frames received on this 1g upstream path. */
    uint64_t data_bytes;        /**< The number of data bytes received on this 1g upstream path. */
    uint64_t multicast_frames;  /**< The number of multicast frames received on this 1g upstream path. */
    uint64_t unicast_frames;    /**< The number of unicast frames received on this 1g upstream path. */
    uint64_t mpcp_frames;       /**< The number of MPCP frames received on this 1g upstream path. */
    uint64_t oam_bytes;         /**< The number of OAM bytes received on this 1g upstream path. */
    uint64_t oam_frames;        /**< The number of OAM frames received on this 1g upstream path. */
    uint64_t report_frames;     /**< The number of report frames received on this 1g upstream path. */
    uint64_t abort_frames;      /**< The number of abort frames received on this 1g upstream path. */
    uint64_t fcs_error;         /**< The number of bad FCS errors received on this 1g upstream path. */
    uint64_t crc_8_error;       /**< The number of CRC8 errors received on this 1g upstream path. */
    uint64_t out_of_slot;       /**< The number of out of slot errors received on this 1g upstream path. */
    uint64_t oversize_error;    /**< The number of oversize errors received on this 1g upstream path. */
    uint64_t runt_error;        /**< The number of runt errors received on this 1g upstream path. */
} bcmolt_epon_path_1g_us_stat_data;

/** Transport message definition for "stat" group of "epon_path_1g_us" object. 
 */
typedef struct bcmolt_epon_path_1g_us_stat
{
    bcmolt_stat hdr;                /**< Transport header. */
    bcmolt_epon_path_1g_us_key key; /**< Object key. */
    bcmolt_epon_path_1g_us_stat_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_us_stat;

/** Structure definition for the "stat_cfg" group of the "epon_path_1g_us" 
 * object. 
 */
typedef struct bcmolt_epon_path_1g_us_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_epon_path_1g_us_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "epon_path_1g_us" 
 * object. 
 */
typedef struct bcmolt_epon_path_1g_us_stat_cfg
{
    bcmolt_stat_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_path_1g_us_key key;             /**< Object key. */
    bcmolt_epon_path_1g_us_stat_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_us_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the 
 * "epon_path_1g_us" object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_epon_path_1g_us_stat_alarm_cleared_data
{
    bcmolt_epon_path_1g_us_stat_id stat;    /**< Statistic identifier. */
} bcmolt_epon_path_1g_us_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of 
 * "epon_path_1g_us" object. 
 */
typedef struct bcmolt_epon_path_1g_us_stat_alarm_cleared
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_epon_path_1g_us_key key; /**< Object key. */
    bcmolt_epon_path_1g_us_stat_alarm_cleared_data data;    /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_us_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the 
 * "epon_path_1g_us" object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_epon_path_1g_us_stat_alarm_raised_data
{
    bcmolt_epon_path_1g_us_stat_id stat;    /**< Statistic identifier. */
} bcmolt_epon_path_1g_us_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of 
 * "epon_path_1g_us" object. 
 */
typedef struct bcmolt_epon_path_1g_us_stat_alarm_raised
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_epon_path_1g_us_key key; /**< Object key. */
    bcmolt_epon_path_1g_us_stat_alarm_raised_data data; /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_us_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "epon_path_1g_us" 
 * object. 
 */
typedef struct bcmolt_epon_path_1g_us_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_epon_path_1g_us_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "epon_path_1g_us" 
 * object. 
 */
typedef struct bcmolt_epon_path_1g_us_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_epon_path_1g_us_key key;             /**< Object key. */
    bcmolt_epon_path_1g_us_auto_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_epon_path_1g_us_auto_cfg;

/** Structure definition for the "key" group of the "epon_rp" object. 
 */
typedef struct bcmolt_epon_rp_key
{
    bcmolt_epon_ni epon_ni;             /**< EPON NI containing this RP. */
    bcmolt_epon_link_rate link_rate;    /**< Link rate associated with this RP.  Must be one of 10/10, 10/1, or 1/1. */
} bcmolt_epon_rp_key;

/** Structure definition for the "cfg" group of the "epon_rp" object. 
 */
typedef struct bcmolt_epon_rp_cfg_data
{
    bcmolt_epon_llid base_llid;                 /**< Base (lowest) logical link identifier for this RP.  This attribute cannot be changed while the EPON_NI is enabled, nor while any non-system links exist.  The sum of this value and max_links for this RP must be 0x7eff or smaller. */
    bcmos_bool mpcp_disc_en;                    /**< Governs whether discovery gates for this RP are issued  */
    bcmolt_time_quanta mpcp_disc_gnt_len_tq;    /**< Length of discovery grants in time quanta for this RP. */
    uint16_t mpcp_report_timeout;               /**< Number of ms before links are deregistered due to no report received. */
    uint16_t max_mpcp_reg_per_disc_window;      /**< Maximum number of MPCP registrations per discovery window on this RP (0 indicates unlimited). */
    uint16_t max_links; /**< Maximum number of links to register on this EPON_RP.  This attribute cannot be changed while the EPON_NI is enabled, nor while any non-system links exist.  The actual limit is dependent on the system mode. */
    bcmolt_upstream_bandwidth_distribution default_upstream_bandwidth;  /**< Default upstream bandwidth for newly created links. */
    double rate_of_refraction;  /**< These are magic numbers derived using the process defined in ITU-T G.984.3 Appendix VII (http://www.itu.int/rec/T-REC-G.984.3-200911-S!Amd2/en) and ITU-T G.987.3 Appendix II (http://www.itu.int/rec/T-REC-G.987.3-201010-S/en) */
} bcmolt_epon_rp_cfg_data;

/** Transport message definition for "cfg" group of "epon_rp" object. 
 */
typedef struct bcmolt_epon_rp_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_epon_rp_key key;         /**< Object key. */
    bcmolt_epon_rp_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_epon_rp_cfg;

/** Structure definition for the "key" group of the "gpio" object. 
 */
typedef struct bcmolt_gpio_key
{
    uint32_t reserved;          /**< Reserved (set to 0). */
    bcmolt_gpio_pin gpio_id;    /**< GPIO ID. */
} bcmolt_gpio_key;

/** Structure definition for the "cfg" group of the "gpio" object. 
 */
typedef struct bcmolt_gpio_cfg_data
{
    bcmolt_gpio_pin_dir direction;  /**< GPIO PIN direction (input or output) */
    bcmolt_gpio_value value;        /**< Value to write. */
} bcmolt_gpio_cfg_data;

/** Transport message definition for "cfg" group of "gpio" object. 
 */
typedef struct bcmolt_gpio_cfg
{
    bcmolt_cfg hdr;             /**< Transport header. */
    bcmolt_gpio_key key;        /**< Object key. */
    bcmolt_gpio_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpio_cfg;

/** Structure definition for the "key" group of the "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_key
{
    bcmolt_gpon_ni pon_ni;          /**< PON network interface. */
    bcmolt_gpon_alloc_id alloc_id;  /**< Alloc ID. */
} bcmolt_gpon_alloc_key;

/** Structure definition for the "cfg" group of the "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_cfg_data
{
    bcmolt_alloc_state state;   /**< Current Alloc ID state */
    bcmolt_pon_alloc_sla sla;   /**< Alloc ID SLA */
    bcmolt_gpon_onu_id onu_id;  /**< ONU ID the alloc ID is assigned to */
    bcmos_bool collect_stats;   /**< Enable statistics collection for this alloc ID */
} bcmolt_gpon_alloc_cfg_data;

/** Transport message definition for "cfg" group of "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_gpon_alloc_key key;          /**< Object key. */
    bcmolt_gpon_alloc_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_cfg;

/** Structure definition for the "stat" group of the "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_stat_data
{
    uint64_t rx_bytes;  /**< Number of alloc ID received bytes. */
} bcmolt_gpon_alloc_stat_data;

/** Transport message definition for "stat" group of "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_stat
{
    bcmolt_stat hdr;                    /**< Transport header. */
    bcmolt_gpon_alloc_key key;          /**< Object key. */
    bcmolt_gpon_alloc_stat_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_stat;

/** Structure definition for the "stat_cfg" group of the "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_gpon_alloc_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_stat_cfg
{
    bcmolt_stat_cfg hdr;        /**< Transport header. */
    bcmolt_gpon_alloc_key key;  /**< Object key. */
    bcmolt_gpon_alloc_stat_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_stat_cfg;

/** Structure definition for the "configuration_completed" group of the 
 * "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_configuration_completed_data
{
    bcmolt_result status;           /**< Status. */
    bcmolt_alloc_state new_state;   /**< new state. */
} bcmolt_gpon_alloc_configuration_completed_data;

/** Transport message definition for "configuration_completed" group of 
 * "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_configuration_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_alloc_key key;  /**< Object key. */
    bcmolt_gpon_alloc_configuration_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_configuration_completed;

/** Structure definition for the "get_alloc_stats_completed" group of the 
 * "gpon_alloc" object. 
 *
 * Collected alloc ID statistics from get_stats operation 
 */
typedef struct bcmolt_gpon_alloc_get_alloc_stats_completed_data
{
    bcmolt_result status;           /**< status. */
    uint32_t average_nsr_used;      /**< Average NSR used bytes. */
    uint32_t average_nsr_allocated; /**< Average NSR allocated bytes. */
    uint32_t average_sr_report;     /**< Average SR report. */
} bcmolt_gpon_alloc_get_alloc_stats_completed_data;

/** Transport message definition for "get_alloc_stats_completed" group of 
 * "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_get_alloc_stats_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_alloc_key key;  /**< Object key. */
    bcmolt_gpon_alloc_get_alloc_stats_completed_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_get_alloc_stats_completed;

/** Structure definition for the "stat_alarm_cleared" group of the "gpon_alloc" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_gpon_alloc_stat_alarm_cleared_data
{
    bcmolt_gpon_alloc_stat_id stat; /**< Statistic identifier. */
} bcmolt_gpon_alloc_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "gpon_alloc" 
 * object. 
 */
typedef struct bcmolt_gpon_alloc_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_alloc_key key;  /**< Object key. */
    bcmolt_gpon_alloc_stat_alarm_cleared_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "gpon_alloc" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_gpon_alloc_stat_alarm_raised_data
{
    bcmolt_gpon_alloc_stat_id stat; /**< Statistic identifier. */
} bcmolt_gpon_alloc_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "gpon_alloc" 
 * object. 
 */
typedef struct bcmolt_gpon_alloc_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_alloc_key key;  /**< Object key. */
    bcmolt_gpon_alloc_stat_alarm_raised_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_auto_cfg_data
{
    bcmos_bool configuration_completed;     /**< If true, indications of type "configuration_completed" will be generated. */
    bcmos_bool get_alloc_stats_completed;   /**< If true, indications of type "get_alloc_stats_completed" will be generated. */
    bcmos_bool stat_alarm_cleared;          /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;           /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_gpon_alloc_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_auto_cfg
{
    bcmolt_auto_cfg hdr;                    /**< Transport header. */
    bcmolt_gpon_alloc_key key;              /**< Object key. */
    bcmolt_gpon_alloc_auto_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_auto_cfg;

/** Structure definition for the "get_stats" group of the "gpon_alloc" object. 
 *
 * Run statistics collection for a given period of time 
 */
typedef struct bcmolt_gpon_alloc_get_stats_data
{
    uint32_t num_of_cycles; /**< The number of cycles to run statistics collection */
} bcmolt_gpon_alloc_get_stats_data;

/** Transport message definition for "get_stats" group of "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_get_stats
{
    bcmolt_oper hdr;                        /**< Transport header. */
    bcmolt_gpon_alloc_key key;              /**< Object key. */
    bcmolt_gpon_alloc_get_stats_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_get_stats;

/** Structure definition for the "set_state" group of the "gpon_alloc" object. 
 *
 * Sets the alloc's activation state.  This is only used for protection 
 * switching on an active-standby PON.  In normal operation, this isn't 
 * necessary since allocs are activated/deactivated automatically along with 
 * the ONU. 
 */
typedef struct bcmolt_gpon_alloc_set_state_data
{
    bcmolt_alloc_operation state;   /**< State. */
} bcmolt_gpon_alloc_set_state_data;

/** Transport message definition for "set_state" group of "gpon_alloc" object. 
 */
typedef struct bcmolt_gpon_alloc_set_state
{
    bcmolt_oper hdr;                        /**< Transport header. */
    bcmolt_gpon_alloc_key key;              /**< Object key. */
    bcmolt_gpon_alloc_set_state_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_alloc_set_state;

/** Structure definition for the "key" group of the "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_key
{
    bcmolt_gpon_ni pon_ni;          /**< PON network interface. */
    bcmolt_gpon_gem_id gem_port_id; /**< GEM Port ID. */
} bcmolt_gpon_gem_port_key;

/** Structure definition for the "cfg" group of the "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_cfg_data
{
    bcmolt_gem_port_configuration configuration;                /**< GEM port configuration parameters */
    bcmolt_gpon_onu_id onu_id;                                  /**< ONU ID this GEM port is assigned to */
    bcmolt_gpon_gem_port_state gem_port_state;                  /**< Current GEM port state */
    bcmolt_control_state downstream_encryption_mode;            /**< Enable/Disable the downstream encryption mode of the GEM Port */
    bcmolt_us_gem_port_destination upstream_destination_queue;  /**< The destination queue of the packets arriving on this GEM Port on the upstream direction */
    bcmolt_control_state control;                       /**< Enable/Disable the GEM Port ID in the OLT */
    bcmolt_gpon_debug_flow_config debug_flow_config;    /**< Traffic flow debug options */
    uint16_t mac_table_entry_limit;                     /**< The maximum number of MAC table entries allowed for this GEM port (0 = no limit). */
} bcmolt_gpon_gem_port_cfg_data;

/** Transport message definition for "cfg" group of "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_gpon_gem_port_key key;       /**< Object key. */
    bcmolt_gpon_gem_port_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_gem_port_cfg;

/** Structure definition for the "stat" group of the "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_stat_data
{
    uint64_t rx_packets;    /**< Received GEM frames. */
    uint64_t rx_bytes;      /**< Received bytes. */
    uint64_t tx_packets;    /**< Transmitted GEM frames. */
    uint64_t tx_bytes;      /**< Transmitted bytes. */
} bcmolt_gpon_gem_port_stat_data;

/** Transport message definition for "stat" group of "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_stat
{
    bcmolt_stat hdr;                /**< Transport header. */
    bcmolt_gpon_gem_port_key key;   /**< Object key. */
    bcmolt_gpon_gem_port_stat_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_gem_port_stat;

/** Structure definition for the "stat_cfg" group of the "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_gpon_gem_port_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_stat_cfg
{
    bcmolt_stat_cfg hdr;                        /**< Transport header. */
    bcmolt_gpon_gem_port_key key;               /**< Object key. */
    bcmolt_gpon_gem_port_stat_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_gem_port_stat_cfg;

/** Structure definition for the "configuration_completed" group of the 
 * "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_configuration_completed_data
{
    bcmolt_result status;                   /**< status. */
    bcmolt_gpon_gem_port_state new_state;   /**< new state. */
} bcmolt_gpon_gem_port_configuration_completed_data;

/** Transport message definition for "configuration_completed" group of 
 * "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_configuration_completed
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_gem_port_key key;   /**< Object key. */
    bcmolt_gpon_gem_port_configuration_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_gem_port_configuration_completed;

/** Structure definition for the "stat_alarm_cleared" group of the 
 * "gpon_gem_port" object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_gpon_gem_port_stat_alarm_cleared_data
{
    bcmolt_gpon_gem_port_stat_id stat;  /**< Statistic identifier. */
} bcmolt_gpon_gem_port_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of 
 * "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_stat_alarm_cleared
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_gem_port_key key;   /**< Object key. */
    bcmolt_gpon_gem_port_stat_alarm_cleared_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_gem_port_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the 
 * "gpon_gem_port" object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_gpon_gem_port_stat_alarm_raised_data
{
    bcmolt_gpon_gem_port_stat_id stat;  /**< Statistic identifier. */
} bcmolt_gpon_gem_port_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of 
 * "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_stat_alarm_raised
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_gem_port_key key;   /**< Object key. */
    bcmolt_gpon_gem_port_stat_alarm_raised_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_gem_port_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_auto_cfg_data
{
    bcmos_bool configuration_completed; /**< If true, indications of type "configuration_completed" will be generated. */
    bcmos_bool stat_alarm_cleared;      /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;       /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_gpon_gem_port_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "gpon_gem_port" object. 
 */
typedef struct bcmolt_gpon_gem_port_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_gpon_gem_port_key key;               /**< Object key. */
    bcmolt_gpon_gem_port_auto_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_gem_port_auto_cfg;

/** Structure definition for the "set_state" group of the "gpon_gem_port" 
 * object. 
 *
 * Sets the GEM port's activation state.  This is only used for protection 
 * switching on an active-standby PON.  In normal operation, this isn't 
 * necessary since GEM ports are activated/deactivated automatically along with 
 * the ONU. 
 */
typedef struct bcmolt_gpon_gem_port_set_state_data
{
    bcmolt_gem_port_operation state;    /**< State. */
} bcmolt_gpon_gem_port_set_state_data;

/** Transport message definition for "set_state" group of "gpon_gem_port" 
 * object. 
 */
typedef struct bcmolt_gpon_gem_port_set_state
{
    bcmolt_oper hdr;                /**< Transport header. */
    bcmolt_gpon_gem_port_key key;   /**< Object key. */
    bcmolt_gpon_gem_port_set_state_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_gem_port_set_state;

/** Structure definition for the "key" group of the "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_key
{
    bcmolt_gpon_ni pon_ni;  /**< PON network interface. */
} bcmolt_gpon_iwf_key;

/** Structure definition for the "cfg" group of the "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_cfg_data
{
    bcmolt_iwf_mode iwf_mode;               /**< IWF mapping mode */
#define BCMOLT_GPON_IWF_CFG_DATA_US_TPID_PER_FLOW_LEN   2
    bcmolt_arr_u16_2_hex us_tpid_per_flow;  /**< TPID value of the VLAN tag added to upstream packet when IWF mode is set to per flow */
    uint16_t us_otag_direct_tpid;           /**< TPID value of the VLAN tag added to upstream packet when IWF mode is set to direct mode */
    uint8_t us_otag_direct_pbit;            /**< P-bit value of the VLAN tag added to upstream packet when IWF mode is set to direct mode */
#define BCMOLT_GPON_IWF_CFG_DATA_DS_TPID_LEN    5
    bcmolt_arr_u16_5_hex ds_tpid;           /**< Packets marked with one of the five configured DS TPID options will be forwarded, all the rest will be dropped */
    bcmolt_mac_table_configuration mac_table_configuration;     /**< MAC table configuration */
    bcmolt_gpon_iwf_debug_flow_config debug_flow_configuration; /**< MAC table configuration */
    uint16_t mac_table_count;                       /**< Number of MAC table entries configured in the MAC table */
    uint16_t forbidden_vlan_flow_gem_range_start;   /**< Forbidden range for Vlans, Flows and Gems start value */
} bcmolt_gpon_iwf_cfg_data;

/** Transport message definition for "cfg" group of "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_gpon_iwf_key key;        /**< Object key. */
    bcmolt_gpon_iwf_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_cfg;

/** Structure definition for the "stat" group of the "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_stat_data
{
    uint64_t ds_hit_event;              /**< DS hit event. */
    uint64_t ds_miss_event;             /**< DS miss event. */
    uint64_t ds_drop_due_to_miss_event; /**< DS drop due to miss event. */
    uint64_t ds_drop_due_to_hit_event;  /**< DS drop due to hit event. */
    uint64_t ds_drop_to_disabled_gem;   /**< DS drop to disabled GEM. */
    uint64_t new_mac_discovered;        /**< New MAC discovered. */
    uint64_t move_event;                /**< Move event. */
    uint64_t new_mac_drop_due_to_fifo_full; /**< New MAC drop due to fifo full. */
} bcmolt_gpon_iwf_stat_data;

/** Transport message definition for "stat" group of "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_stat
{
    bcmolt_stat hdr;                /**< Transport header. */
    bcmolt_gpon_iwf_key key;        /**< Object key. */
    bcmolt_gpon_iwf_stat_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_stat;

/** Structure definition for the "stat_cfg" group of the "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_gpon_iwf_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_stat_cfg
{
    bcmolt_stat_cfg hdr;                /**< Transport header. */
    bcmolt_gpon_iwf_key key;            /**< Object key. */
    bcmolt_gpon_iwf_stat_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_stat_cfg;

/** Transport message definition for "flush_mac_table_completed" group of 
 * "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_flush_mac_table_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_iwf_key key;    /**< Object key. */
} bcmolt_gpon_iwf_flush_mac_table_completed;

/** Structure definition for the "scan_mac_table_completed" group of the 
 * "gpon_iwf" object. 
 *
 * A MAC table scan initiated using the "scan_mac_table" operation is complete. 
 */
typedef struct bcmolt_gpon_iwf_scan_mac_table_completed_data
{
    bcmos_mac_address mac_address;  /**< Entry MAC address. */
    bcmolt_gpon_mac_table_scan_result_list_u16 entries; /**< Scan results for this entry.  If this list is empty, the MAC address was not found in the table. */
} bcmolt_gpon_iwf_scan_mac_table_completed_data;

/** Transport message definition for "scan_mac_table_completed" group of 
 * "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_scan_mac_table_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_iwf_key key;    /**< Object key. */
    bcmolt_gpon_iwf_scan_mac_table_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_scan_mac_table_completed;

/** Structure definition for the "stat_alarm_cleared" group of the "gpon_iwf" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_gpon_iwf_stat_alarm_cleared_data
{
    bcmolt_gpon_iwf_stat_id stat;   /**< Statistic identifier. */
} bcmolt_gpon_iwf_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "gpon_iwf" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_iwf_key key;    /**< Object key. */
    bcmolt_gpon_iwf_stat_alarm_cleared_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "gpon_iwf" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_gpon_iwf_stat_alarm_raised_data
{
    bcmolt_gpon_iwf_stat_id stat;   /**< Statistic identifier. */
} bcmolt_gpon_iwf_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "gpon_iwf" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_iwf_key key;    /**< Object key. */
    bcmolt_gpon_iwf_stat_alarm_raised_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_auto_cfg_data
{
    bcmos_bool flush_mac_table_completed;   /**< If true, indications of type "flush_mac_table_completed" will be generated. */
    bcmos_bool scan_mac_table_completed;    /**< If true, indications of type "scan_mac_table_completed" will be generated. */
    bcmos_bool stat_alarm_cleared;          /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;           /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_gpon_iwf_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "gpon_iwf" object. 
 */
typedef struct bcmolt_gpon_iwf_auto_cfg
{
    bcmolt_auto_cfg hdr;                /**< Transport header. */
    bcmolt_gpon_iwf_key key;            /**< Object key. */
    bcmolt_gpon_iwf_auto_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_auto_cfg;

/** Structure definition for the "flush_mac_table" group of the "gpon_iwf" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_flush_mac_table_data
{
    bcmolt_flush_mac_table_option control;  /**< control. */
    bcmolt_vlan_id vid;                     /**< VID. */
    bcmolt_flow_id flow_id;                 /**< FLOW ID. */
} bcmolt_gpon_iwf_flush_mac_table_data;

/** Transport message definition for "flush_mac_table" group of "gpon_iwf" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_flush_mac_table
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_gpon_iwf_key key;    /**< Object key. */
    bcmolt_gpon_iwf_flush_mac_table_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_flush_mac_table;

/** Structure definition for the "scan_mac_table" group of the "gpon_iwf" 
 * object. 
 *
 * Scans MAC table for a given MAC address then returns the associated 
 * information 
 */
typedef struct bcmolt_gpon_iwf_scan_mac_table_data
{
    bcmos_mac_address mac_address;  /**< Entry MAC address. */
} bcmolt_gpon_iwf_scan_mac_table_data;

/** Transport message definition for "scan_mac_table" group of "gpon_iwf" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_scan_mac_table
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_gpon_iwf_key key;    /**< Object key. */
    bcmolt_gpon_iwf_scan_mac_table_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_scan_mac_table;

/** Structure definition for the "key" group of the "gpon_iwf_ds_egress_flow" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_ds_egress_flow_key
{
    bcmolt_gpon_ni pon_ni;  /**< PON network interface. */
    bcmolt_flow_id flow_id; /**< Flow ID. */
} bcmolt_gpon_iwf_ds_egress_flow_key;

/** Structure definition for the "cfg" group of the "gpon_iwf_ds_egress_flow" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_ds_egress_flow_cfg_data
{
    bcmolt_gpon_gem_id gem_port;    /**< GEM port ID */
    bcmos_bool pbit_control;        /**< If enabled, the Pbits value is taken from the mapping VLAN tag (Inner/Outer) VLAN Pbits location and added to the configured GEM port ID value to create the Final GEM ID */
} bcmolt_gpon_iwf_ds_egress_flow_cfg_data;

/** Transport message definition for "cfg" group of "gpon_iwf_ds_egress_flow" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_ds_egress_flow_cfg
{
    bcmolt_cfg hdr; /**< Transport header. */
    bcmolt_gpon_iwf_ds_egress_flow_key key;         /**< Object key. */
    bcmolt_gpon_iwf_ds_egress_flow_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_ds_egress_flow_cfg;

/** Structure definition for the "key" group of the "gpon_iwf_ds_ingress_flow" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_ds_ingress_flow_key
{
    bcmolt_gpon_ni pon_ni;  /**< PON network interface. */
    bcmolt_vlan_id vlan_id; /**< vlan ID. */
} bcmolt_gpon_iwf_ds_ingress_flow_key;

/** Structure definition for the "cfg" group of the "gpon_iwf_ds_ingress_flow" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_ds_ingress_flow_cfg_data
{
    bcmolt_vlan_to_flow_mapping_method mapping_method;  /**< The Mapping method defines how the flow ID will be determined */
    bcmolt_mapping_tag_method mapping_tag;              /**< Define if the outer or the inner VLAN tag of the packet will determine the flow ID */
    bcmolt_ds_vlan_action vlan_action;                  /**< Define the outer VLAN tag manipulation on the packet: transparent or remove */
} bcmolt_gpon_iwf_ds_ingress_flow_cfg_data;

/** Transport message definition for "cfg" group of "gpon_iwf_ds_ingress_flow" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_ds_ingress_flow_cfg
{
    bcmolt_cfg hdr; /**< Transport header. */
    bcmolt_gpon_iwf_ds_ingress_flow_key key;        /**< Object key. */
    bcmolt_gpon_iwf_ds_ingress_flow_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_ds_ingress_flow_cfg;

/** Structure definition for the "key" group of the "gpon_iwf_mac_table" object. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_key
{
    bcmolt_gpon_ni pon_ni;          /**< PON network interface. */
    bcmos_mac_address mac_address;  /**< MAC address. */
    bcmolt_vlan_id vlan;            /**< VLAN. */
} bcmolt_gpon_iwf_mac_table_key;

/** Structure definition for the "cfg" group of the "gpon_iwf_mac_table" object. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_cfg_data
{
    bcmolt_flow_id flow_id;         /**< The flow ID assigned to traffic that matches this MAC table entry. */
    bcmos_bool stat;                /**< Whether or not the MAC entry is static.  Static entries don't age. */
    bcmolt_gpon_gem_id gem_port_id; /**< The GEM port ID of the traffic that created this table entry.  This only applies to automatically-learned entries.  Manually-added entries will have the value BCMOLT_PON_GEM_PORT_ID_INVALID. */
    bcmolt_gpon_onu_id onu_id;      /**< The ONU ID for the traffic that created this table entry.  This only valid if gem_port_id is valid.  Otherwise this will be set to BCMOLT_GPON_ONU_ID_INVALID. */
} bcmolt_gpon_iwf_mac_table_cfg_data;

/** Transport message definition for "cfg" group of "gpon_iwf_mac_table" object. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_gpon_iwf_mac_table_key key;  /**< Object key. */
    bcmolt_gpon_iwf_mac_table_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_mac_table_cfg;

/** Transport message definition for "mac_aged" group of "gpon_iwf_mac_table" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_mac_aged
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_gpon_iwf_mac_table_key key;  /**< Object key. */
} bcmolt_gpon_iwf_mac_table_mac_aged;

/** Structure definition for the "mac_dropped" group of the "gpon_iwf_mac_table" 
 * object. 
 *
 * Sent when an entry cannot be learned since the MAC table is full. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_mac_dropped_data
{
    bcmolt_flow_id flow_id; /**< The flow ID of the entry that was dropped. */
} bcmolt_gpon_iwf_mac_table_mac_dropped_data;

/** Transport message definition for "mac_dropped" group of "gpon_iwf_mac_table" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_mac_dropped
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_gpon_iwf_mac_table_key key;  /**< Object key. */
    bcmolt_gpon_iwf_mac_table_mac_dropped_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_mac_table_mac_dropped;

/** Structure definition for the "mac_move" group of the "gpon_iwf_mac_table" 
 * object. 
 *
 * Sent when the MAC table is in move mode and a packet is seen that matches on 
 * MAC address / VID but doesn't match on flow ID. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_mac_move_data
{
    bcmolt_flow_id old_flow_id; /**< The flow ID in the current MAC table entry. */
    bcmolt_flow_id new_flow_id; /**< The flow ID seen in the traffic stream. */
} bcmolt_gpon_iwf_mac_table_mac_move_data;

/** Transport message definition for "mac_move" group of "gpon_iwf_mac_table" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_mac_move
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_gpon_iwf_mac_table_key key;  /**< Object key. */
    bcmolt_gpon_iwf_mac_table_mac_move_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_mac_table_mac_move;

/** Structure definition for the "new_mac" group of the "gpon_iwf_mac_table" 
 * object. 
 *
 * Sent when a new MAC address / VID combination is seen in the upstream 
 * traffic stream. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_new_mac_data
{
    bcmolt_flow_id flow_id; /**< The flow ID associated with the new entry. */
} bcmolt_gpon_iwf_mac_table_new_mac_data;

/** Transport message definition for "new_mac" group of "gpon_iwf_mac_table" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_new_mac
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_gpon_iwf_mac_table_key key;  /**< Object key. */
    bcmolt_gpon_iwf_mac_table_new_mac_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_mac_table_new_mac;

/** Structure definition for the "auto_cfg" group of the "gpon_iwf_mac_table" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_auto_cfg_data
{
    bcmos_bool mac_aged;    /**< If true, indications of type "mac_aged" will be generated. */
    bcmos_bool mac_dropped; /**< If true, indications of type "mac_dropped" will be generated. */
    bcmos_bool mac_move;    /**< If true, indications of type "mac_move" will be generated. */
    bcmos_bool new_mac;     /**< If true, indications of type "new_mac" will be generated. */
} bcmolt_gpon_iwf_mac_table_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "gpon_iwf_mac_table" 
 * object. 
 */
typedef struct bcmolt_gpon_iwf_mac_table_auto_cfg
{
    bcmolt_auto_cfg hdr;                /**< Transport header. */
    bcmolt_gpon_iwf_mac_table_key key;  /**< Object key. */
    bcmolt_gpon_iwf_mac_table_auto_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_mac_table_auto_cfg;

/** Structure definition for the "key" group of the "gpon_iwf_us_flow" object. 
 */
typedef struct bcmolt_gpon_iwf_us_flow_key
{
    bcmolt_gpon_ni pon_ni;          /**< PON network interface. */
    bcmolt_gpon_gem_id gem_port_id; /**< GEM Port  ID. */
} bcmolt_gpon_iwf_us_flow_key;

/** Structure definition for the "cfg" group of the "gpon_iwf_us_flow" object. 
 */
typedef struct bcmolt_gpon_iwf_us_flow_cfg_data
{
    bcmolt_flow_id flow_id;             /**< Flow ID. */
    bcmos_bool mac_learning;            /**< MAC learning. */
    bcmolt_us_vlan_action vlan_action;  /**< VLAN action. */
    bcmolt_vlan_tag vlan_tag;           /**< Vlan tag. */
    uint8_t tpid_index;                 /**< TPID index. */
} bcmolt_gpon_iwf_us_flow_cfg_data;

/** Transport message definition for "cfg" group of "gpon_iwf_us_flow" object. 
 */
typedef struct bcmolt_gpon_iwf_us_flow_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_gpon_iwf_us_flow_key key;    /**< Object key. */
    bcmolt_gpon_iwf_us_flow_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_iwf_us_flow_cfg;

/** Structure definition for the "key" group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_key
{
    bcmolt_gpon_ni pon_ni;  /**< PON network interface. */
} bcmolt_gpon_ni_key;

/** Structure definition for the "cfg" group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_cfg_data
{
    bcmolt_pon_status pon_status;   /**< PON status parameters */
    bcmolt_pon_available_bandwidth available_bandwidth; /**< PON available bandwidth parameters */
    uint16_t number_of_active_onus;                     /**< Number of active ONUs on the PON */
    uint16_t number_of_active_standby_onus;             /**< number of active standby onus. */
    bcmolt_prbs_status prbs_status;                     /**< Result of US PRBS checker */
    bcmolt_pon_distance pon_distance;                   /**< PON distance */
    uint32_t ranging_window_size;                       /**< Ranging window size */
    uint32_t preassigned_equalization_delay;            /**< ONU pre-assigned equalization delay */
    uint32_t eqd_cycles_number;                     /**< How many ranging windows are opened during a single ONU activation process */
    bcmolt_pon_power_level power_level;             /**< ONU power level configuration */
    bcmolt_control_state ds_fec_mode;               /**< DS FEC mode */
    bcmolt_pon_drift_control drift_control;         /**< Drift control process configuration */
    bcmolt_ber_interval ds_ber_reporting_interval;  /**< DS BER reporting interval */
    uint8_t los_alarm_threshold;                    /**< LOS alarm threshold */
    bcmolt_status los_initial_value;                /**< LOS initial value following PON activation */
    bcmolt_gpon_onu_alarms_thresholds onu_alarms_thresholds;    /**< ONU alarms thresholds configuration */
    bcmolt_ber_monitor_params ber_monitor;                      /**< BER monitor process configuration */
    uint16_t ploam_ack_timeout;                 /**< Timeout for receiving ACK ploam */
    bcmolt_gpon_onu_activation onu_activation;  /**< ONU activation control parameters */
    bcmolt_gpon_sn_acquisition sn_acquisition;  /**< Serial Number process configuration */
    bcmolt_gpon_key_exchange key_exchange;      /**< Key Exchange process configuration */
    bcmolt_pon_protection_switching protection_switching;       /**< Protection switching control */
    bcmolt_cbr_rt_allocation_profile cbr_rt_allocation_profile; /**< CBR Real Time allocation profile */
#define BCMOLT_GPON_NI_CFG_DATA_CBR_NRT_ALLOCATION_PROFILE_LEN  2
    bcmolt_arr_u16_2 cbr_nrt_allocation_profile;                /**< CBR non Real Time allocation profile */
    bcmolt_pon_dba dba; /**< DBA configuration */
    bcmolt_onu_power_management_configuration power_management;             /**< ONU power management control */
    bcmolt_rogue_onu_detection_process rogue_onu_detection_process;         /**< Rogue ONU detection process configuration */
    bcmolt_periodic_standby_pon_monitoring periodic_standby_pon_monitoring; /**< Periodic Standby PON monitoring */
    bcmolt_prbs_checker_config prbs_checker;                        /**< US PRBS checker configuration */
    bcmolt_prbs_generator_config prbs_generator;                    /**< DS PRBS generator configuration */
    bcmolt_gpon_alloc_id min_data_alloc_id;                         /**< Min data Alloc ID value */
    bcmolt_automatic_onu_deactivation automatic_onu_deactivation;   /**< Option to disable the automatic deactivation of ONUs due to alarms */
    uint32_t us_bandwidth_limit;    /**< Total PON upstream bandwidth limit in bytes per second. */
    bcmolt_gpon_onu_with_state_list_u16_max_128 all_onus;                   /**< All ONUs currently provisioned on this PON. */
    bcmolt_gpon_gem_port_with_state_list_u16_max_128 all_mcast_gem_ports;   /**< All multicast GEM ports currently provisioned on this PON. */
    bcmolt_gpon_ni_debug debug; /**< PON NI debug parameters */
    bcmolt_gpon_onu_upgrade_params onu_upgrade_params;  /**< ONU upgrade params. */
    uint16_t ps_c_wait_before_deactivation_timeout;     /**< PS type C timeout in milliseconds */
    bcmolt_control_state bip32_indication_control;      /**< Option to disable the bip32 indication when the value is zero */
} bcmolt_gpon_ni_cfg_data;

/** Transport message definition for "cfg" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_gpon_ni_key key;         /**< Object key. */
    bcmolt_gpon_ni_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_cfg;

/** Structure definition for the "stat" group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_stat_data
{
    uint64_t fec_codewords;             /**< Received FEC codewords. */
    uint64_t fec_codewords_uncorrected; /**< Received uncorrected FEC codewords. */
    uint64_t bip8_bytes;                /**< Received bytes protected by bip8. */
    uint64_t bip8_errors;               /**< Received bip8 errors. */
    uint64_t rx_gem_packets;            /**< Received GEM frames. */
    uint64_t rx_gem_dropped;            /**< Received dropped GEM ID packets. */
    uint64_t rx_gem_idle;               /**< Received idle GEM frames. */
    uint64_t rx_gem_corrected;          /**< Received corrected GEM frames. */
    uint64_t rx_gem_illegal;            /**< Received illegal GEM frames. */
    uint64_t rx_allocations_valid;      /**< Received valid allocations. */
    uint64_t rx_allocations_invalid;    /**< Received invalid allocations. */
    uint64_t rx_allocations_disabled;   /**< Received disabled allocations. */
    uint64_t rx_ploams;                 /**< Received Ploams. */
    uint64_t rx_ploams_non_idle;        /**< Received non idle Ploams. */
    uint64_t rx_ploams_error;           /**< Received error Ploams. */
    uint64_t rx_ploams_dropped;         /**< Received dropped Ploams. */
    uint64_t rx_cpu;                    /**< Received CPU packets. */
    uint64_t rx_omci;                   /**< Received OMCI packets. */
    uint64_t rx_omci_packets_crc_error; /**< Received OMCI packets with CRC errors. */
    uint64_t rx_dropped_too_short;      /**< Received packets dropped due to length too short. */
    uint64_t rx_dropped_too_long;       /**< Received packet dropped due to length too long. */
    uint64_t rx_crc_errors;             /**< Received packet dropped due to crc error. */
    uint64_t rx_key_errors;             /**< Received packet dropped due to key error. */
    uint64_t rx_fragments_errors;       /**< Received packet dropped due to fragmentation error. */
    uint64_t rx_packets_dropped;        /**< Global dropped packets. */
    uint64_t tx_gem;                    /**< Transmitted GEM frames. */
    uint64_t tx_ploams;                 /**< Transmitted Ploams. */
    uint64_t tx_gem_fragments;          /**< Transmitted GEM fragments. */
    uint64_t tx_cpu;                    /**< Transmitted CPU packets. */
    uint64_t tx_omci;                   /**< Transmitted OMCI packets. */
    uint8_t tx_cpu_omci_packets_dropped;    /**< Transmit packets dropped due to illegal length. */
    uint64_t tx_dropped_illegal_length;     /**< Transmitted packet dropped due to illegal length. */
    uint64_t tx_dropped_tpid_miss;          /**< Dropped because of TPID miss. */
    uint64_t tx_dropped_vid_miss;           /**< Dropped because of VID miss. */
} bcmolt_gpon_ni_stat_data;

/** Transport message definition for "stat" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_stat
{
    bcmolt_stat hdr;                /**< Transport header. */
    bcmolt_gpon_ni_key key;         /**< Object key. */
    bcmolt_gpon_ni_stat_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_stat;

/** Structure definition for the "stat_cfg" group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_gpon_ni_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_stat_cfg
{
    bcmolt_stat_cfg hdr;                /**< Transport header. */
    bcmolt_gpon_ni_key key;             /**< Object key. */
    bcmolt_gpon_ni_stat_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_stat_cfg;

/** Transport message definition for "activate_all_onus_completed" group of 
 * "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_activate_all_onus_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
} bcmolt_gpon_ni_activate_all_onus_completed;

/** Structure definition for the "cpu_packets_failure" group of the "gpon_ni" 
 * object. 
 *
 * A failure was encountered during the "cpu_packets" proxy operation. 
 */
typedef struct bcmolt_gpon_ni_cpu_packets_failure_data
{
    bcmolt_packet_injection_error error;    /**< The error that was encountered. */
    bcmolt_gpon_gem_id gem_port_id;         /**< The GEM port that caused the error. */
} bcmolt_gpon_ni_cpu_packets_failure_data;

/** Transport message definition for "cpu_packets_failure" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_cpu_packets_failure
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_cpu_packets_failure_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_cpu_packets_failure;

/** Transport message definition for "deactivate_all_onus_completed" group of 
 * "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_deactivate_all_onus_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
} bcmolt_gpon_ni_deactivate_all_onus_completed;

/** Transport message definition for "disable_all_onus_completed" group of 
 * "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_disable_all_onus_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
} bcmolt_gpon_ni_disable_all_onus_completed;

/** Transport message definition for "enable_all_onus_completed" group of 
 * "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_enable_all_onus_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
} bcmolt_gpon_ni_enable_all_onus_completed;

/** Structure definition for the "los" group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_los_data
{
    bcmolt_status status;   /**< status. */
} bcmolt_gpon_ni_los_data;

/** Transport message definition for "los" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_los
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_ni_key key;         /**< Object key. */
    bcmolt_gpon_ni_los_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_los;

/** Structure definition for the "onu_discovered" group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_onu_discovered_data
{
    bcmolt_serial_number serial_number; /**< serial number. */
    uint32_t ranging_time;              /**< ranging time. */
    bcmolt_gpon_onu_id onu_id;          /**< onu_id. */
} bcmolt_gpon_ni_onu_discovered_data;

/** Transport message definition for "onu_discovered" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_onu_discovered
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_onu_discovered_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_onu_discovered;

/** Structure definition for the "onu_upgrade_complete" group of the "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_onu_upgrade_complete_data
{
    bcmos_bool status;  /**< Success or failure.  Against entire upgrade process. */
    bcmolt_gpon_onu_upgrade_status_list_u32 list_of_failed_entities;    /**< List of ONU-IDs the upgrade failed for. */
} bcmolt_gpon_ni_onu_upgrade_complete_data;

/** Transport message definition for "onu_upgrade_complete" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_onu_upgrade_complete
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_onu_upgrade_complete_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_onu_upgrade_complete;

/** Structure definition for the "protection_switching_onus_ranged" group of the 
 * "gpon_ni" object. 
 *
 * After a switchover is complete and all ONU ranging times have stabilized, 
 * this indication is sent to inform the host of all new ONU EQDs. 
 */
typedef struct bcmolt_gpon_ni_protection_switching_onus_ranged_data
{
    bcmolt_gpon_onu_eqd_list_u32 onus;  /**< ONUs. */
} bcmolt_gpon_ni_protection_switching_onus_ranged_data;

/** Transport message definition for "protection_switching_onus_ranged" group of 
 * "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_protection_switching_onus_ranged
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_protection_switching_onus_ranged_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_protection_switching_onus_ranged;

/** Structure definition for the "protection_switching_switchover_completed" 
 * group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_protection_switching_switchover_completed_data
{
    bcmolt_result result;   /**< Result. */
} bcmolt_gpon_ni_protection_switching_switchover_completed_data;

/** Transport message definition for "protection_switching_switchover_completed" 
 * group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_protection_switching_switchover_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_protection_switching_switchover_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_protection_switching_switchover_completed;

/** Structure definition for the "protection_switching_traffic_resume" group of 
 * the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_protection_switching_traffic_resume_data
{
    bcmolt_traffic_resume_result result;    /**< Result. */
} bcmolt_gpon_ni_protection_switching_traffic_resume_data;

/** Transport message definition for "protection_switching_traffic_resume" group 
 * of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_protection_switching_traffic_resume
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_protection_switching_traffic_resume_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_protection_switching_traffic_resume;

/** Structure definition for the "rogue_detection_completed" group of the 
 * "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_rogue_detection_completed_data
{
    bcmolt_rogue_detection_window window_type;          /**< Silent Window or Cut off Window */
    bcmolt_rogue_measurement_result measurement_status; /**< Status of the rogue ONU detection result. */
    bcmolt_gpon_alloc_id alloc_id;                      /**< Alloc-ID */
    bcmolt_gpon_onu_id onu_id;                  /**< ONU-ID */
    bcmos_bool is_delineation;                  /**< Burst Delineation detected during the rogue ONU detection. */
    bcmos_bool is_ed;                           /**< Is ED. */
    bcmolt_u8_list_u32 rx_data;                 /**< Captured PLOAMu message if the burst delinieation was detected. */
    bcmolt_gpon_onu_id ploam_received_onu_id;   /**< ONU ID received in the ploam */
    bcmos_bool ploam_received_crc_error;        /**< Crc error in the received ploam */
} bcmolt_gpon_ni_rogue_detection_completed_data;

/** Transport message definition for "rogue_detection_completed" group of 
 * "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_rogue_detection_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_rogue_detection_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_rogue_detection_completed;

/** Transport message definition for "rogue_onu_special_map_cycle_start" group 
 * of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_rogue_onu_special_map_cycle_start
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
} bcmolt_gpon_ni_rogue_onu_special_map_cycle_start;

/** Transport message definition for "serial_number_acquisition_cycle_start" 
 * group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_serial_number_acquisition_cycle_start
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
} bcmolt_gpon_ni_serial_number_acquisition_cycle_start;

/** Structure definition for the "standby_pon_monitoring_cycle_completed" group 
 * of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_data
{
    uint32_t number_of_detected_delimiter;  /**< number of detected delimiter. */
    bcmolt_status energy_detect_signal;     /**< energy detect signal. */
} bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_data;

/** Transport message definition for "standby_pon_monitoring_cycle_completed" 
 * group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed;

/** Structure definition for the "stat_alarm_cleared" group of the "gpon_ni" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_gpon_ni_stat_alarm_cleared_data
{
    bcmolt_gpon_ni_stat_id stat;    /**< Statistic identifier. */
} bcmolt_gpon_ni_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_stat_alarm_cleared
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_stat_alarm_cleared_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "gpon_ni" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_gpon_ni_stat_alarm_raised_data
{
    bcmolt_gpon_ni_stat_id stat;    /**< Statistic identifier. */
} bcmolt_gpon_ni_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_stat_alarm_raised
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_stat_alarm_raised_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_stat_alarm_raised;

/** Structure definition for the "state_change_completed" group of the "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_state_change_completed_data
{
    bcmolt_result result;               /**< Result. */
    bcmolt_pon_state previous_state;    /**< Previous state. */
    bcmolt_pon_state new_state;         /**< New state. */
} bcmolt_gpon_ni_state_change_completed_data;

/** Transport message definition for "state_change_completed" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_state_change_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_state_change_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_state_change_completed;

/** Structure definition for the "tod_request_completed" group of the "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_tod_request_completed_data
{
    bcmolt_str_64 tod_string;   /**< tod_string. */
    uint32_t sfc;               /**< sfc. */
    uint64_t rtc_offset_sec;    /**< rtc_offset_sec. */
    uint32_t rtc_offset_nsec;   /**< rtc_offset_nsec. */
    bcmolt_result status;       /**< status. */
} bcmolt_gpon_ni_tod_request_completed_data;

/** Transport message definition for "tod_request_completed" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_tod_request_completed
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_tod_request_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_tod_request_completed;

/** Structure definition for the "auto_cfg" group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_auto_cfg_data
{
    bcmos_bool activate_all_onus_completed;     /**< If true, indications of type "activate_all_onus_completed" will be generated. */
    bcmos_bool cpu_packets_failure;             /**< If true, indications of type "cpu_packets_failure" will be generated. */
    bcmos_bool deactivate_all_onus_completed;   /**< If true, indications of type "deactivate_all_onus_completed" will be generated. */
    bcmos_bool disable_all_onus_completed;      /**< If true, indications of type "disable_all_onus_completed" will be generated. */
    bcmos_bool enable_all_onus_completed;       /**< If true, indications of type "enable_all_onus_completed" will be generated. */
    bcmos_bool los;                     /**< If true, indications of type "los" will be generated. */
    bcmos_bool onu_discovered;          /**< If true, indications of type "onu_discovered" will be generated. */
    bcmos_bool onu_upgrade_complete;    /**< If true, indications of type "onu_upgrade_complete" will be generated. */
    bcmos_bool protection_switching_onus_ranged;            /**< If true, indications of type "protection_switching_onus_ranged" will be generated. */
    bcmos_bool protection_switching_switchover_completed;   /**< If true, indications of type "protection_switching_switchover_completed" will be generated. */
    bcmos_bool protection_switching_traffic_resume;         /**< If true, indications of type "protection_switching_traffic_resume" will be generated. */
    bcmos_bool rogue_detection_completed;                   /**< If true, indications of type "rogue_detection_completed" will be generated. */
    bcmos_bool rogue_onu_special_map_cycle_start;           /**< If true, indications of type "rogue_onu_special_map_cycle_start" will be generated. */
    bcmos_bool serial_number_acquisition_cycle_start;       /**< If true, indications of type "serial_number_acquisition_cycle_start" will be generated. */
    bcmos_bool standby_pon_monitoring_cycle_completed;      /**< If true, indications of type "standby_pon_monitoring_cycle_completed" will be generated. */
    bcmos_bool stat_alarm_cleared;      /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;       /**< If true, indications of type "stat_alarm_raised" will be generated. */
    bcmos_bool state_change_completed;  /**< If true, indications of type "state_change_completed" will be generated. */
    bcmos_bool tod_request_completed;   /**< If true, indications of type "tod_request_completed" will be generated. */
} bcmolt_gpon_ni_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_auto_cfg
{
    bcmolt_auto_cfg hdr;                /**< Transport header. */
    bcmolt_gpon_ni_key key;             /**< Object key. */
    bcmolt_gpon_ni_auto_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_auto_cfg;

/** Structure definition for the "disable_serial_number" group of the "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_disable_serial_number_data
{
    bcmolt_disable_serial_number_control control;   /**< control. */
    bcmolt_serial_number serial_number;             /**< serial number. */
} bcmolt_gpon_ni_disable_serial_number_data;

/** Transport message definition for "disable_serial_number" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_disable_serial_number
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_disable_serial_number_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_disable_serial_number;

/** Structure definition for the 
 * "protection_switching_type_c_set_multiple_onu_state" group of the "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_data
{
    bcmolt_switch_over_type_c_onu_state onu_state;  /**< onu state. */
    bcmolt_gpon_onu_id_list_u32_max_256 onu_list;   /**< onu list. */
} bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_data;

/** Transport message definition for 
 * "protection_switching_type_c_set_multiple_onu_state" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state;

/** Transport message definition for "reset" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_reset
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
} bcmolt_gpon_ni_reset;

/** Structure definition for the "rogue_detection_window" group of the "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_rogue_detection_window_data
{
    bcmolt_rogue_detection_window window_type;  /**< Type of silent measurement to execute */
    bcmolt_gpon_alloc_id alloc_id;              /**< ALLOC ID to scan */
    bcmolt_gpon_onu_id onu_id;                  /**< ONU ID to scan */
    bcmos_bool second_ranging_window;           /**< Not currently supported */
} bcmolt_gpon_ni_rogue_detection_window_data;

/** Transport message definition for "rogue_detection_window" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_rogue_detection_window
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_rogue_detection_window_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_rogue_detection_window;

/** Structure definition for the "set_onu_state" group of the "gpon_ni" object. 
 *
 * Set the operation state of all ONUs. 
 */
typedef struct bcmolt_gpon_ni_set_onu_state_data
{
    bcmolt_onu_operation onu_state; /**< New operation state of all ONUs.  The default operation may be configured by the GPON NI configuration object : gpon_ni.cfg.sn_acquisition. */
} bcmolt_gpon_ni_set_onu_state_data;

/** Transport message definition for "set_onu_state" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_set_onu_state
{
    bcmolt_oper hdr;                        /**< Transport header. */
    bcmolt_gpon_ni_key key;                 /**< Object key. */
    bcmolt_gpon_ni_set_onu_state_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_set_onu_state;

/** Structure definition for the "set_pon_state" group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_set_pon_state_data
{
    bcmolt_pon_operation pon_state; /**< PON state. */
} bcmolt_gpon_ni_set_pon_state_data;

/** Transport message definition for "set_pon_state" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_set_pon_state
{
    bcmolt_oper hdr;                        /**< Transport header. */
    bcmolt_gpon_ni_key key;                 /**< Object key. */
    bcmolt_gpon_ni_set_pon_state_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_set_pon_state;

/** Transport message definition for "single_request_standby_pon_monitoring" 
 * group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_single_request_standby_pon_monitoring
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
} bcmolt_gpon_ni_single_request_standby_pon_monitoring;

/** Structure definition for the "start_onu_upgrade" group of the "gpon_ni" 
 * object. 
 *
 * OLT to ONU firmware transfer 
 */
typedef struct bcmolt_gpon_ni_start_onu_upgrade_data
{
    bcmolt_pon_onu_id_list_u32 list_of_onu_ids; /**< List of ONU IDs to upgrade the firmware. */
} bcmolt_gpon_ni_start_onu_upgrade_data;

/** Transport message definition for "start_onu_upgrade" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_start_onu_upgrade
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_start_onu_upgrade_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_start_onu_upgrade;

/** Transport message definition for "tod_request" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_tod_request
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
} bcmolt_gpon_ni_tod_request;

/** Structure definition for the "broadcast_ploam_packet" group of the "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_broadcast_ploam_packet_data
{
#define BCMOLT_GPON_NI_BROADCAST_PLOAM_PACKET_DATA_PLOAM_LEN    12
    bcmolt_arr_u8_12 ploam; /**< ploam. */
} bcmolt_gpon_ni_broadcast_ploam_packet_data;

/** Transport message definition for "broadcast_ploam_packet" group of "gpon_ni" 
 * object. 
 */
typedef struct bcmolt_gpon_ni_broadcast_ploam_packet
{
    bcmolt_proxy hdr;       /**< Transport header. */
    bcmolt_gpon_ni_key key; /**< Object key. */
    bcmolt_gpon_ni_broadcast_ploam_packet_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_broadcast_ploam_packet;

/** Structure definition for the "cpu_packets" group of the "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_cpu_packets_data
{
    bcmolt_packet_type packet_type;                     /**< packet type. */
    bcmos_bool calc_crc;                                /**< calc crc. */
    bcmolt_gpon_gem_id_list_u8_max_16 gem_port_list;    /**< gem port list. */
    bcmolt_u8_list_u32_max_2048 buffer;                 /**< buffer. */
} bcmolt_gpon_ni_cpu_packets_data;

/** Transport message definition for "cpu_packets" group of "gpon_ni" object. 
 */
typedef struct bcmolt_gpon_ni_cpu_packets
{
    bcmolt_proxy hdr;                       /**< Transport header. */
    bcmolt_gpon_ni_key key;                 /**< Object key. */
    bcmolt_gpon_ni_cpu_packets_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_ni_cpu_packets;

/** Structure definition for the "key" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key
{
    bcmolt_gpon_ni pon_ni;      /**< PON network interface. */
    bcmolt_gpon_onu_id onu_id;  /**< ONU ID. */
} bcmolt_gpon_onu_key;

/** Structure definition for the "cfg" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_cfg_data
{
    bcmolt_onu_state onu_state;         /**< Current ONU state */
    bcmolt_serial_number serial_number; /**< ONU serial number */
#define BCMOLT_GPON_ONU_CFG_DATA_PASSWORD_LEN   10
    bcmolt_arr_u8_10 password;          /**< ONU password */
    bcmos_bool auto_password_learning;  /**< Enable\Disable automatic password learning */
    bcmos_bool us_fec;                  /**< Enable\Disable US FEC for ONU */
    bcmolt_gpon_gem_id omci_port_id;    /**< OMCI port ID  */
    bcmolt_ber_interval ds_ber_reporting_interval;  /**< DS BER reporting interval */
    bcmolt_aes_key aes_encryption_key;              /**< AES encryption key.  */
    bcmolt_gpon_onu_alarm_state alarm_state;        /**< State of all ONU alarms.  This is normally read-only and can only be written when the PON is in active-standby mode to keep the ONU in sync. */
    uint32_t ranging_time;                  /**< ONU ranging time.  This is normally read-only and can only be written when the PON is in active-standby mode to keep the ONU in sync. */
    bcmolt_status disabled_after_discovery; /**< This ONU was disabled after SN discovery */
    bcmolt_deactivation_reason deactivation_reason;                 /**< Reason for the last ONU deactivation */
    bcmolt_gpon_gem_port_with_state_list_u16_max_256 all_gem_ports; /**< All unicast GEM ports currently provisioned on this ONU. */
    bcmolt_gpon_alloc_with_state_list_u16_max_32 all_allocs;        /**< All alloc IDs currently provisioned on this ONU. */
    bcmos_bool onu_ps_type_c;                       /**< onu protection switching type c. */
    bcmolt_extended_guard_time extended_guard_time; /**< Additional guard time (in bytes) for this ONU. */
} bcmolt_gpon_onu_cfg_data;

/** Transport message definition for "cfg" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_cfg;

/** Structure definition for the "stat" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_stat_data
{
    uint64_t fec_codewords;             /**< Total received FEC codewords. */
    uint64_t fec_bytes_corrected;       /**< FEC codewords corrected bytes. */
    uint64_t fec_codewords_corrected;   /**< FEC corrected codewords error . */
    uint64_t fec_codewords_uncorrected; /**< FEC not corrected codewords error. */
    uint64_t bip8_bytes;                /**< Received bytes for BIP8. */
    uint64_t bip8_errors;               /**< Bit error according to BIP8. */
    uint64_t rx_ploams_crc_error;       /**< Received PLOAMs with CRC error. */
    uint64_t rx_ploams_non_idle;        /**< Received non idle PLOAMs. */
    uint64_t positive_drift;            /**< Positive drift. */
    uint64_t negative_drift;            /**< Negative drift. */
    uint64_t rx_omci;                   /**< Received OMCI packets. */
    uint64_t rx_omci_packets_crc_error; /**< Received OMCI packets with CRC errors. */
    uint64_t ber_reported;              /**< BER reported. */
    uint64_t unreceived_burst;          /**< Unreceived burst. */
    uint64_t lcdg_errors;               /**< LCDG errors. */
    uint64_t rdi_errors;                /**< RDI errors. */
    uint64_t rx_bytes;                  /**< rx bytes. */
    uint64_t rx_packets;                /**< rx packets. */
    uint64_t tx_bytes;                  /**< tx bytes. */
    uint64_t tx_packets;                /**< tx packets. */
} bcmolt_gpon_onu_stat_data;

/** Transport message definition for "stat" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_stat
{
    bcmolt_stat hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_stat_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_stat;

/** Structure definition for the "stat_cfg" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_gpon_onu_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_stat_cfg
{
    bcmolt_stat_cfg hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;            /**< Object key. */
    bcmolt_gpon_onu_stat_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_stat_cfg;

/** Structure definition for the "ber_interval_configuration_completed" group of 
 * the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_ber_interval_configuration_completed_data
{
    bcmolt_ber_interval ber_interval;   /**< BER interval in ms. */
    bcmolt_result result;               /**< Result. */
} bcmolt_gpon_onu_ber_interval_configuration_completed_data;

/** Transport message definition for "ber_interval_configuration_completed" 
 * group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_ber_interval_configuration_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_ber_interval_configuration_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_ber_interval_configuration_completed;

/** Structure definition for the "dfi" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_dfi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_gpon_onu_dfi_data;

/** Transport message definition for "dfi" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_dfi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_dfi_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_dfi;

/** Structure definition for the "dgi" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_dgi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_gpon_onu_dgi_data;

/** Transport message definition for "dgi" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_dgi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_dgi_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_dgi;

/** Structure definition for the "dowi" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_dowi_data
{
    bcmolt_status alarm_status; /**< Alarm status. */
    int32_t drift_value;        /**< Calculated amount of drift (positive + negative as a signed value). */
    uint32_t new_eqd;           /**< New EQD after drift is corrected (only valid if status is 'on'). */
} bcmolt_gpon_onu_dowi_data;

/** Transport message definition for "dowi" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_dowi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_dowi_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_dowi;

/** Structure definition for the "err" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_err_data
{
    uint8_t bip8_errors;    /**< BIP8 errors. */
} bcmolt_gpon_onu_err_data;

/** Transport message definition for "err" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_err
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_err_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_err;

/** Structure definition for the "invalid_dbru_report" group of the "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_invalid_dbru_report_data
{
    bcmolt_gpon_alloc_id alloc_id;  /**< Alloc-ID. */
} bcmolt_gpon_onu_invalid_dbru_report_data;

/** Transport message definition for "invalid_dbru_report" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_invalid_dbru_report
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_invalid_dbru_report_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_invalid_dbru_report;

/** Structure definition for the "key_exchange_completed" group of the 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_completed_data
{
    bcmolt_aes_key new_key; /**< new key. */
} bcmolt_gpon_onu_key_exchange_completed_data;

/** Transport message definition for "key_exchange_completed" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_key_exchange_completed_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_key_exchange_completed;

/** Transport message definition for "key_exchange_cycle_skipped" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_cycle_skipped
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
} bcmolt_gpon_onu_key_exchange_cycle_skipped;

/** Structure definition for the "key_exchange_decrypt_required" group of the 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_decrypt_required_data
{
    bcmolt_aes_key new_key; /**< new key. */
} bcmolt_gpon_onu_key_exchange_decrypt_required_data;

/** Transport message definition for "key_exchange_decrypt_required" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_decrypt_required
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_key_exchange_decrypt_required_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_key_exchange_decrypt_required;

/** Structure definition for the "key_exchange_key_mismatch" group of the 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_key_mismatch_data
{
    bcmolt_aes_key expected_key;    /**< expected key. */
    bcmolt_aes_key received_key;    /**< received key. */
} bcmolt_gpon_onu_key_exchange_key_mismatch_data;

/** Transport message definition for "key_exchange_key_mismatch" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_key_mismatch
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_key_exchange_key_mismatch_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_key_exchange_key_mismatch;

/** Transport message definition for "key_exchange_key_request_timeout" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_key_request_timeout
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
} bcmolt_gpon_onu_key_exchange_key_request_timeout;

/** Structure definition for the "key_exchange_unconsecutive_index" group of the 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_unconsecutive_index_data
{
    uint32_t expected_index;    /**< expected index. */
    uint32_t actual_index;      /**< actual index. */
} bcmolt_gpon_onu_key_exchange_unconsecutive_index_data;

/** Transport message definition for "key_exchange_unconsecutive_index" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_key_exchange_unconsecutive_index
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_key_exchange_unconsecutive_index_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_key_exchange_unconsecutive_index;

/** Structure definition for the "loai" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_loai_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_gpon_onu_loai_data;

/** Transport message definition for "loai" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_loai
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_loai_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_loai;

/** Structure definition for the "loki" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_loki_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_gpon_onu_loki_data;

/** Transport message definition for "loki" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_loki
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_loki_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_loki;

/** Structure definition for the "memi" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_memi_data
{
#define BCMOLT_GPON_ONU_MEMI_DATA_PLOAM_BUFFER_LEN  13
    bcmolt_arr_u8_13 ploam_buffer;  /**< PLOAM buffer. */
} bcmolt_gpon_onu_memi_data;

/** Transport message definition for "memi" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_memi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_memi_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_memi;

/** Structure definition for the "omci_port_id_configuration_completed" group of 
 * the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_omci_port_id_configuration_completed_data
{
    bcmolt_gpon_gem_id gem_port;    /**< GEM Port ID. */
    bcmolt_result status;           /**< status. */
    bcmolt_omci_port_id_operation operation;    /**< Operation. */
} bcmolt_gpon_onu_omci_port_id_configuration_completed_data;

/** Transport message definition for "omci_port_id_configuration_completed" 
 * group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_omci_port_id_configuration_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_omci_port_id_configuration_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_omci_port_id_configuration_completed;

/** Structure definition for the "onu_activation_completed" group of the 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_onu_activation_completed_data
{
    bcmolt_result status;                       /**< status. */
    bcmolt_activation_fail_reason fail_reason;  /**< fail reason. */
} bcmolt_gpon_onu_onu_activation_completed_data;

/** Transport message definition for "onu_activation_completed" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_onu_activation_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_onu_activation_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_onu_activation_completed;

/** Structure definition for the "onu_activation_standby_completed" group of the 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_onu_activation_standby_completed_data
{
    bcmolt_result result;   /**< result. */
} bcmolt_gpon_onu_onu_activation_standby_completed_data;

/** Transport message definition for "onu_activation_standby_completed" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_onu_activation_standby_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_onu_activation_standby_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_onu_activation_standby_completed;

/** Structure definition for the "onu_alarm" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_onu_alarm_data
{
    bcmolt_gpon_onu_alarms onu_alarm;   /**< onu alarm. */
} bcmolt_gpon_onu_onu_alarm_data;

/** Transport message definition for "onu_alarm" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_onu_alarm
{
    bcmolt_auto hdr;                        /**< Transport header. */
    bcmolt_gpon_onu_key key;                /**< Object key. */
    bcmolt_gpon_onu_onu_alarm_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_onu_alarm;

/** Structure definition for the "onu_deactivation_completed" group of the 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_onu_deactivation_completed_data
{
    bcmolt_result status;   /**< status. */
} bcmolt_gpon_onu_onu_deactivation_completed_data;

/** Transport message definition for "onu_deactivation_completed" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_onu_deactivation_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_onu_deactivation_completed_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_onu_deactivation_completed;

/** Structure definition for the "onu_disable_completed" group of the "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_onu_disable_completed_data
{
    bcmolt_serial_number serial_number; /**< serial number. */
} bcmolt_gpon_onu_onu_disable_completed_data;

/** Transport message definition for "onu_disable_completed" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_onu_disable_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_onu_disable_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_onu_disable_completed;

/** Structure definition for the "onu_enable_completed" group of the "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_onu_enable_completed_data
{
    bcmolt_serial_number serial_number; /**< serial number. */
} bcmolt_gpon_onu_onu_enable_completed_data;

/** Transport message definition for "onu_enable_completed" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_onu_enable_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_onu_enable_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_onu_enable_completed;

/** Transport message definition for "optical_reflection" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_optical_reflection
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
} bcmolt_gpon_onu_optical_reflection;

/** Structure definition for the "password_authentication_completed" group of 
 * the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_password_authentication_completed_data
{
    bcmolt_result status;   /**< status. */
    bcmolt_password_authentication_fail_reason fail_reason; /**< fail reason. */
#define BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_DATA_PASSWORD_LEN 10
    bcmolt_arr_u8_10 password;  /**< password. */
} bcmolt_gpon_onu_password_authentication_completed_data;

/** Transport message definition for "password_authentication_completed" group 
 * of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_password_authentication_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_password_authentication_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_password_authentication_completed;

/** Structure definition for the "pee" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_pee_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_gpon_onu_pee_data;

/** Transport message definition for "pee" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_pee
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_pee_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_pee;

/** Structure definition for the "possible_drift" group of the "gpon_onu" 
 * object. 
 *
 * An ONU in a low power state may be experiencing drift beyond the configured 
 * threshold. The estimate may be inaccurate depending on ONU behavior. Actual 
 * drift may be less than estimated. 
 */
typedef struct bcmolt_gpon_onu_possible_drift_data
{
    bcmolt_status alarm_status; /**< On: estimated drift has exceeded the configured threshold. */
    int32_t estimated_drift;    /**< If status is on, the estimated drift value, otherwise zero (0). */
} bcmolt_gpon_onu_possible_drift_data;

/** Transport message definition for "possible_drift" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_possible_drift
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_possible_drift_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_possible_drift;

/** Structure definition for the "power_management_state_change" group of the 
 * "gpon_onu" object. 
 *
 * Notification that an ONUs power management state has changed. 
 */
typedef struct bcmolt_gpon_onu_power_management_state_change_data
{
    bcmolt_onu_state old_state; /**< The state the ONU was previously in. */
    bcmolt_onu_state new_state; /**< The state the ONU is currently in. */
    bcmolt_power_management_transition_reason reason;   /**< The reason for the state change. */
} bcmolt_gpon_onu_power_management_state_change_data;

/** Transport message definition for "power_management_state_change" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_power_management_state_change
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_power_management_state_change_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_power_management_state_change;

/** Structure definition for the "pst" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_pst_data
{
    uint32_t link_number;   /**< link number. */
    uint8_t k1;             /**< K1. */
    uint8_t k2;             /**< K2. */
} bcmolt_gpon_onu_pst_data;

/** Transport message definition for "pst" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_pst
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_pst_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_pst;

/** Structure definition for the "ranging_completed" group of the "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_ranging_completed_data
{
    bcmolt_result status;                   /**< status. */
    bcmolt_ranging_fail_reason fail_reason; /**< fail reason. */
    uint8_t number_of_ploams;               /**< number of PLOAMs. */
    uint32_t eqd;           /**< EQD. */
    uint8_t power_level;    /**< Power Level. */
} bcmolt_gpon_onu_ranging_completed_data;

/** Transport message definition for "ranging_completed" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_ranging_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_ranging_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_ranging_completed;

/** Structure definition for the "rei" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_rei_data
{
    uint32_t bip8_errors;   /**< BIP8 errors. */
} bcmolt_gpon_onu_rei_data;

/** Transport message definition for "rei" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_rei
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_rei_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_rei;

/** Structure definition for the "rssi_measurement_completed" group of the 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_rssi_measurement_completed_data
{
    bcmolt_result status;   /**< status. */
    bcmolt_rssi_measurement_fail_reason fail_reason;    /**< fail reason. */
} bcmolt_gpon_onu_rssi_measurement_completed_data;

/** Transport message definition for "rssi_measurement_completed" group of 
 * "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_rssi_measurement_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_rssi_measurement_completed_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_rssi_measurement_completed;

/** Structure definition for the "sdi" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_sdi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
    uint32_t ber;               /**< Inverse bit error rate (e.g. if this number is 1000, the BER is 1/1000). */
} bcmolt_gpon_onu_sdi_data;

/** Transport message definition for "sdi" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_sdi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_sdi_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_sdi;

/** Structure definition for the "sfi" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_sfi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
    uint32_t ber;               /**< Inverse bit error rate (e.g. if this number is 1000, the BER is 1/1000). */
} bcmolt_gpon_onu_sfi_data;

/** Transport message definition for "sfi" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_sfi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_sfi_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_sfi;

/** Structure definition for the "stat_alarm_cleared" group of the "gpon_onu" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_gpon_onu_stat_alarm_cleared_data
{
    bcmolt_gpon_onu_stat_id stat;   /**< Statistic identifier. */
} bcmolt_gpon_onu_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_stat_alarm_cleared_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "gpon_onu" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_gpon_onu_stat_alarm_raised_data
{
    bcmolt_gpon_onu_stat_id stat;   /**< Statistic identifier. */
} bcmolt_gpon_onu_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_stat_alarm_raised_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_stat_alarm_raised;

/** Structure definition for the "sufi" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_sufi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_gpon_onu_sufi_data;

/** Transport message definition for "sufi" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_sufi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_sufi_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_sufi;

/** Structure definition for the "tiwi" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_tiwi_data
{
    bcmolt_status alarm_status; /**< Alarm status. */
    int32_t drift_value;        /**< Calculated amount of drift (positive + negative as a signed value). */
} bcmolt_gpon_onu_tiwi_data;

/** Transport message definition for "tiwi" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_tiwi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;        /**< Object key. */
    bcmolt_gpon_onu_tiwi_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_tiwi;

/** Structure definition for the "auto_cfg" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_auto_cfg_data
{
    bcmos_bool ber_interval_configuration_completed;    /**< If true, indications of type "ber_interval_configuration_completed" will be generated. */
    bcmos_bool dfi;                     /**< If true, indications of type "dfi" will be generated. */
    bcmos_bool dgi;                     /**< If true, indications of type "dgi" will be generated. */
    bcmos_bool dowi;                    /**< If true, indications of type "dowi" will be generated. */
    bcmos_bool err;                     /**< If true, indications of type "err" will be generated. */
    bcmos_bool invalid_dbru_report;     /**< If true, indications of type "invalid_dbru_report" will be generated. */
    bcmos_bool key_exchange_completed;  /**< If true, indications of type "key_exchange_completed" will be generated. */
    bcmos_bool key_exchange_cycle_skipped;          /**< If true, indications of type "key_exchange_cycle_skipped" will be generated. */
    bcmos_bool key_exchange_decrypt_required;       /**< If true, indications of type "key_exchange_decrypt_required" will be generated. */
    bcmos_bool key_exchange_key_mismatch;           /**< If true, indications of type "key_exchange_key_mismatch" will be generated. */
    bcmos_bool key_exchange_key_request_timeout;    /**< If true, indications of type "key_exchange_key_request_timeout" will be generated. */
    bcmos_bool key_exchange_unconsecutive_index;    /**< If true, indications of type "key_exchange_unconsecutive_index" will be generated. */
    bcmos_bool loai;    /**< If true, indications of type "loai" will be generated. */
    bcmos_bool loki;    /**< If true, indications of type "loki" will be generated. */
    bcmos_bool memi;    /**< If true, indications of type "memi" will be generated. */
    bcmos_bool omci_port_id_configuration_completed;    /**< If true, indications of type "omci_port_id_configuration_completed" will be generated. */
    bcmos_bool onu_activation_completed;                /**< If true, indications of type "onu_activation_completed" will be generated. */
    bcmos_bool onu_activation_standby_completed;        /**< If true, indications of type "onu_activation_standby_completed" will be generated. */
    bcmos_bool onu_alarm;                   /**< If true, indications of type "onu_alarm" will be generated. */
    bcmos_bool onu_deactivation_completed;  /**< If true, indications of type "onu_deactivation_completed" will be generated. */
    bcmos_bool onu_disable_completed;       /**< If true, indications of type "onu_disable_completed" will be generated. */
    bcmos_bool onu_enable_completed;        /**< If true, indications of type "onu_enable_completed" will be generated. */
    bcmos_bool optical_reflection;          /**< If true, indications of type "optical_reflection" will be generated. */
    bcmos_bool password_authentication_completed;   /**< If true, indications of type "password_authentication_completed" will be generated. */
    bcmos_bool pee;             /**< If true, indications of type "pee" will be generated. */
    bcmos_bool possible_drift;  /**< If true, indications of type "possible_drift" will be generated. */
    bcmos_bool power_management_state_change;   /**< If true, indications of type "power_management_state_change" will be generated. */
    bcmos_bool pst;                 /**< If true, indications of type "pst" will be generated. */
    bcmos_bool ranging_completed;   /**< If true, indications of type "ranging_completed" will be generated. */
    bcmos_bool rei;                 /**< If true, indications of type "rei" will be generated. */
    bcmos_bool rssi_measurement_completed;  /**< If true, indications of type "rssi_measurement_completed" will be generated. */
    bcmos_bool sdi;                 /**< If true, indications of type "sdi" will be generated. */
    bcmos_bool sfi;                 /**< If true, indications of type "sfi" will be generated. */
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
    bcmos_bool sufi;                /**< If true, indications of type "sufi" will be generated. */
    bcmos_bool tiwi;                /**< If true, indications of type "tiwi" will be generated. */
} bcmolt_gpon_onu_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_auto_cfg
{
    bcmolt_auto_cfg hdr;                /**< Transport header. */
    bcmolt_gpon_onu_key key;            /**< Object key. */
    bcmolt_gpon_onu_auto_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_auto_cfg;

/** Structure definition for the "change_power_level" group of the "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_change_power_level_data
{
    bcmolt_onu_power_level power_level_action;  /**< power level action. */
} bcmolt_gpon_onu_change_power_level_data;

/** Transport message definition for "change_power_level" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_change_power_level
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_change_power_level_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_change_power_level;

/** Transport message definition for "rssi_measurement" group of "gpon_onu" 
 * object. 
 */
typedef struct bcmolt_gpon_onu_rssi_measurement
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
} bcmolt_gpon_onu_rssi_measurement;

/** Structure definition for the "set_onu_state" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_set_onu_state_data
{
    bcmolt_onu_operation onu_state; /**< ONU state. */
} bcmolt_gpon_onu_set_onu_state_data;

/** Transport message definition for "set_onu_state" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_set_onu_state
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_gpon_onu_key key;    /**< Object key. */
    bcmolt_gpon_onu_set_onu_state_data data;    /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_set_onu_state;

/** Structure definition for the "cpu_packets" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_cpu_packets_data
{
    bcmolt_packet_type packet_type;     /**< packet type. */
    bcmos_bool calc_crc;                /**< calc crc. */
    uint8_t number_of_packets;          /**< number of packets. */
    uint16_t packet_size;               /**< Single packet size. */
    bcmolt_u8_list_u32_max_2048 buffer; /**< buffer. */
} bcmolt_gpon_onu_cpu_packets_data;

/** Transport message definition for "cpu_packets" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_cpu_packets
{
    bcmolt_proxy hdr;                       /**< Transport header. */
    bcmolt_gpon_onu_key key;                /**< Object key. */
    bcmolt_gpon_onu_cpu_packets_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_cpu_packets;

/** Structure definition for the "ploam_packet" group of the "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_ploam_packet_data
{
#define BCMOLT_GPON_ONU_PLOAM_PACKET_DATA_PLOAM_LEN 12
    bcmolt_arr_u8_12 ploam; /**< ploam. */
} bcmolt_gpon_onu_ploam_packet_data;

/** Transport message definition for "ploam_packet" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_ploam_packet
{
    bcmolt_proxy hdr;                       /**< Transport header. */
    bcmolt_gpon_onu_key key;                /**< Object key. */
    bcmolt_gpon_onu_ploam_packet_data data; /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_ploam_packet;

/** Structure definition for the "cpu_packet" group of the "gpon_onu" object. 
 *
 * Indicates CPU packet was received on the US from this ONU id 
 */
typedef struct bcmolt_gpon_onu_cpu_packet_data
{
    uint16_t port_id;           /**< port_id. */
    bcmos_bool crc_ok;          /**< crc_ok. */
    uint32_t packet_size;       /**< packet_size. */
    bcmolt_u8_list_u32 buffer;  /**< buffer. */
} bcmolt_gpon_onu_cpu_packet_data;

/** Transport message definition for "cpu_packet" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_cpu_packet
{
    bcmolt_proxy_rx hdr;                    /**< Transport header. */
    bcmolt_gpon_onu_key key;                /**< Object key. */
    bcmolt_gpon_onu_cpu_packet_data data;   /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_cpu_packet;

/** Structure definition for the "omci_packet" group of the "gpon_onu" object. 
 *
 * Indicates OMCI packet was received on the US from this ONU id 
 */
typedef struct bcmolt_gpon_onu_omci_packet_data
{
    uint16_t port_id;           /**< port_id. */
    bcmos_bool crc_ok;          /**< crc_ok. */
    uint32_t packet_size;       /**< packet_size. */
    bcmolt_u8_list_u32 buffer;  /**< buffer. */
} bcmolt_gpon_onu_omci_packet_data;

/** Transport message definition for "omci_packet" group of "gpon_onu" object. 
 */
typedef struct bcmolt_gpon_onu_omci_packet
{
    bcmolt_proxy_rx hdr;                    /**< Transport header. */
    bcmolt_gpon_onu_key key;                /**< Object key. */
    bcmolt_gpon_onu_omci_packet_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_onu_omci_packet;

/** Structure definition for the "key" group of the "gpon_trx" object. 
 */
typedef struct bcmolt_gpon_trx_key
{
    bcmolt_gpon_ni pon_ni;  /**< PON network interface. */
} bcmolt_gpon_trx_key;

/** Structure definition for the "cfg" group of the "gpon_trx" object. 
 */
typedef struct bcmolt_gpon_trx_cfg_data
{
    bcmolt_trx_type transceiver_type;   /**< transceiver type. */
    bcmolt_la_resync_pattern_configuration la_configuration;    /**< LA configuration. */
    bcmolt_bcdr_resync_pattern_configuration bcdr;              /**< BCDR. */
    bcmolt_resync_control la_ranging_after_no_ed_resync;        /**< LA ranging after no ed resync . */
    bcmolt_resync_control bcdr_ranging_after_no_ed_resync;      /**< used in ranging mode after no ed found */
    bcmolt_resync_control la_ranging_after_ed_resync;           /**< LA ranging after ed resync . */
    bcmolt_resync_control bcdr_ranging_after_ed_resync;         /**< BCDR ranging after ed resync. */
    bcmolt_polarity la_resync_polarity;     /**< la resync polarity. */
    bcmolt_polarity bcdr_resync_polarity;   /**< BCDR resync polarity. */
    bcmolt_ranging_resync_conditions bcdr_ranging_resync_conditions;            /**< bcdr ranging resync conditions. */
    bcmolt_ranging_resync_conditions la_ranging_resync_conditions;              /**< la ranging resync conditions. */
    bcmolt_trx_rx_configuration rx_configuration;                               /**< RX configuration. */
    bcmolt_ranging_control_configuration ranging_control_stages_configuration;  /**< ranging control stages configuration. */
    bcmolt_trx_energy_detect energy_detect;             /**< Energy Detect. */
    bcmolt_resync_control end_of_burst_data_pattern;    /**< end of burst data pattern . */
    bcmolt_resync_control end_of_burst_ranging_pattern; /**< end of burst ranging pattern. */
    bcmolt_trx_preamble preamble;                       /**< Preamble. */
    bcmolt_trx_delimiter delimiter;                     /**< Delimiter. */
    uint32_t guard_bits;    /**< Guard bits. */
    bcmolt_serdes_configuration serdes_configuration;   /**< serdes configuration. */
    uint32_t plo_ranging;   /**< PLO for ranging. */
    uint32_t plo_data;      /**< PLO for data. */
    bcmolt_gpon_rssi_general_configuration rssi_normal_config;  /**< rssi normal config. */
    bcmolt_ranging_rssi_control ranging_rssi_resync_control;    /**< ranging rssi resync control. */
} bcmolt_gpon_trx_cfg_data;

/** Transport message definition for "cfg" group of "gpon_trx" object. 
 */
typedef struct bcmolt_gpon_trx_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_gpon_trx_key key;        /**< Object key. */
    bcmolt_gpon_trx_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_gpon_trx_cfg;

/** Structure definition for the "key" group of the "log_entry" object. 
 */
typedef struct bcmolt_log_entry_key
{
    uint32_t log_id;        /**< log id. */
    uint8_t reserved;       /**< reserved. */
    bcmolt_str_100 name;    /**< name. */
} bcmolt_log_entry_key;

/** Structure definition for the "cfg" group of the "log_entry" object. 
 */
typedef struct bcmolt_log_entry_cfg_data
{
    bcmolt_log_level default_log_level; /**< default log level. */
    bcmolt_log_type default_log_type;   /**< default log type. */
    bcmolt_log_level log_level_print;   /**< log level print. */
    bcmolt_log_level log_level_save;    /**< log level save. */
    bcmolt_log_type log_type;           /**< log type. */
    bcmolt_log_style log_style;         /**< log_style. */
    bcmolt_str_100 log_name;            /**< log name. */
} bcmolt_log_entry_cfg_data;

/** Transport message definition for "cfg" group of "log_entry" object. 
 */
typedef struct bcmolt_log_entry_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_log_entry_key key;       /**< Object key. */
    bcmolt_log_entry_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_log_entry_cfg;

/** Structure definition for the "stat" group of the "log_entry" object. 
 */
typedef struct bcmolt_log_entry_stat_data
{
#define BCMOLT_LOG_ENTRY_STAT_DATA_MSG_COUNT_LEN    6
    bcmolt_arr_u32_6 msg_count; /**< msg count. */
    uint32_t lost_msg_count;    /**< lost msg count. */
} bcmolt_log_entry_stat_data;

/** Transport message definition for "stat" group of "log_entry" object. 
 */
typedef struct bcmolt_log_entry_stat
{
    bcmolt_stat hdr;                    /**< Transport header. */
    bcmolt_log_entry_key key;           /**< Object key. */
    bcmolt_log_entry_stat_data data;    /**< All properties that must be set by the user. */
} bcmolt_log_entry_stat;

/** Structure definition for the "stat_cfg" group of the "log_entry" object. 
 */
typedef struct bcmolt_log_entry_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_log_entry_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "log_entry" object. 
 */
typedef struct bcmolt_log_entry_stat_cfg
{
    bcmolt_stat_cfg hdr;        /**< Transport header. */
    bcmolt_log_entry_key key;   /**< Object key. */
    bcmolt_log_entry_stat_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_log_entry_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the "log_entry" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_log_entry_stat_alarm_cleared_data
{
    bcmolt_log_entry_stat_id stat;  /**< Statistic identifier. */
} bcmolt_log_entry_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "log_entry" 
 * object. 
 */
typedef struct bcmolt_log_entry_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_log_entry_key key;   /**< Object key. */
    bcmolt_log_entry_stat_alarm_cleared_data data;  /**< All properties that must be set by the user. */
} bcmolt_log_entry_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "log_entry" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_log_entry_stat_alarm_raised_data
{
    bcmolt_log_entry_stat_id stat;  /**< Statistic identifier. */
} bcmolt_log_entry_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "log_entry" 
 * object. 
 */
typedef struct bcmolt_log_entry_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_log_entry_key key;   /**< Object key. */
    bcmolt_log_entry_stat_alarm_raised_data data;   /**< All properties that must be set by the user. */
} bcmolt_log_entry_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "log_entry" object. 
 */
typedef struct bcmolt_log_entry_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_log_entry_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "log_entry" object. 
 */
typedef struct bcmolt_log_entry_auto_cfg
{
    bcmolt_auto_cfg hdr;                    /**< Transport header. */
    bcmolt_log_entry_key key;               /**< Object key. */
    bcmolt_log_entry_auto_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_log_entry_auto_cfg;

/** Structure definition for the "key" group of the "logger" object. 
 */
typedef struct bcmolt_logger_key
{
    uint32_t reserved;          /**< reserved. */
    bcmolt_log_file_id file_id; /**< should be 0 */
} bcmolt_logger_key;

/** Structure definition for the "cfg" group of the "logger" object. 
 */
typedef struct bcmolt_logger_cfg_data
{
    bcmolt_log_buffer buffer;       /**< Contains "next" log records read by "bcmolt_cfg_get() API */
    bcmos_bool wrap_around;         /**< Log file wrap-around option. TRUE=wrap around when full. FALSE=stop when full */
    bcmos_bool clear_after_read;    /**< Clear log after last record has been read */
    bcmos_bool enable_log;          /**< Enable logger */
    bcmolt_str_1000 log_names;      /**< log_names. */
} bcmolt_logger_cfg_data;

/** Transport message definition for "cfg" group of "logger" object. 
 */
typedef struct bcmolt_logger_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_logger_key key;          /**< Object key. */
    bcmolt_logger_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_logger_cfg;

/** Structure definition for the "stat" group of the "logger" object. 
 */
typedef struct bcmolt_logger_stat_data
{
    uint32_t lines_in_log;  /**< lines in log. */
} bcmolt_logger_stat_data;

/** Transport message definition for "stat" group of "logger" object. 
 */
typedef struct bcmolt_logger_stat
{
    bcmolt_stat hdr;                /**< Transport header. */
    bcmolt_logger_key key;          /**< Object key. */
    bcmolt_logger_stat_data data;   /**< All properties that must be set by the user. */
} bcmolt_logger_stat;

/** Structure definition for the "stat_cfg" group of the "logger" object. 
 */
typedef struct bcmolt_logger_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_logger_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "logger" object. 
 */
typedef struct bcmolt_logger_stat_cfg
{
    bcmolt_stat_cfg hdr;                /**< Transport header. */
    bcmolt_logger_key key;              /**< Object key. */
    bcmolt_logger_stat_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_logger_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the "logger" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_logger_stat_alarm_cleared_data
{
    bcmolt_logger_stat_id stat; /**< Statistic identifier. */
} bcmolt_logger_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "logger" 
 * object. 
 */
typedef struct bcmolt_logger_stat_alarm_cleared
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_logger_key key;  /**< Object key. */
    bcmolt_logger_stat_alarm_cleared_data data; /**< All properties that must be set by the user. */
} bcmolt_logger_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "logger" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_logger_stat_alarm_raised_data
{
    bcmolt_logger_stat_id stat; /**< Statistic identifier. */
} bcmolt_logger_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "logger" 
 * object. 
 */
typedef struct bcmolt_logger_stat_alarm_raised
{
    bcmolt_auto hdr;        /**< Transport header. */
    bcmolt_logger_key key;  /**< Object key. */
    bcmolt_logger_stat_alarm_raised_data data;  /**< All properties that must be set by the user. */
} bcmolt_logger_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "logger" object. 
 */
typedef struct bcmolt_logger_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_logger_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "logger" object. 
 */
typedef struct bcmolt_logger_auto_cfg
{
    bcmolt_auto_cfg hdr;                /**< Transport header. */
    bcmolt_logger_key key;              /**< Object key. */
    bcmolt_logger_auto_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_logger_auto_cfg;

/** Transport message definition for "clear_log" group of "logger" object. 
 */
typedef struct bcmolt_logger_clear_log
{
    bcmolt_oper hdr;        /**< Transport header. */
    bcmolt_logger_key key;  /**< Object key. */
} bcmolt_logger_clear_log;

/** Structure definition for the "key" group of the "nni" object. 
 */
typedef struct bcmolt_nni_key
{
    bcmolt_pon_ni pon_ni;   /**< PON NI. */
} bcmolt_nni_key;

/** Structure definition for the "cfg" group of the "nni" object. 
 */
typedef struct bcmolt_nni_cfg_data
{
    bcmolt_control_state remote_loopback;   /**< Incoming packets coming from the PON (upstream) and going back to the PON (Downstream)  */
    bcmolt_control_state line_loopback;     /**< Incoming packets coming from the NNI interface to the PM and going back towards the NNI interface */
    bcmos_mac_address mac_address;          /**< Mac address to be used for this NNI. */
    bcmolt_nni_link_status nni_status;      /**< NNI status */
    bcmolt_nni_link_status nni_backup_status;   /**< Status of the backup NNI. */
    bcmolt_nni_connection active_nni;           /**< Which NNI is currently active. */
    uint32_t nni_status_polling_interval_ms;    /**< How often to check the status of the primary and backup NNIs (units: ms). Zero (0) disables status polling. */
    bcmos_bool autoswitch;                      /**< Should firmware automatically switch between primary/backup NNIs when Loss of Link is detected? */
    bcmolt_control_state flow_control;          /**< NNI Flow control. */
} bcmolt_nni_cfg_data;

/** Transport message definition for "cfg" group of "nni" object. 
 */
typedef struct bcmolt_nni_cfg
{
    bcmolt_cfg hdr;             /**< Transport header. */
    bcmolt_nni_key key;         /**< Object key. */
    bcmolt_nni_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_nni_cfg;

/** Structure definition for the "stat" group of the "nni" object. 
 */
typedef struct bcmolt_nni_stat_data
{
    uint64_t rx_frames_64;              /**< The count of RX 64 byte frames on this NNI. */
    uint64_t rx_frames_65_127;          /**< The count of RX 65 to 127 byte frames on this NNI. */
    uint64_t rx_frames_128_255;         /**< The count of RX 128 to 255 byte frames on this NNI. */
    uint64_t rx_frames_256_511;         /**< The count of RX 256 to 511 byte frames on this NNI. */
    uint64_t rx_frames_512_1023;        /**< The count of RX 512 to 1023 byte frames on this NNI. */
    uint64_t rx_frames_1024_1518;       /**< The count of RX 1024 to 1518 byte frames on this NNI. */
    uint64_t rx_frames_1519_2047;       /**< The count of RX 1519 to 2047 byte frames on this NNI. */
    uint64_t rx_frames_2048_4095;       /**< The count of RX 2048 to 4095 byte frames on this NNI. */
    uint64_t rx_frames_4096_9216;       /**< The count of RX 4096 to 9216 byte frames on this NNI. */
    uint64_t rx_frames_9217_16383;      /**< The count of RX 9217 to 16383 byte frames on this NNI. */
    uint64_t rx_frames;                 /**< The number of received frames on this NNI. This includes all errored frames as well. */
    uint64_t rx_bytes;                  /**< The number of received bytes on this NNI. This includes all errored frames as well. */
    uint64_t rx_good_frames;            /**< The number of received good frames on this NNI. */
    uint64_t rx_unicast_frames;         /**< The number of received unicast frames on this NNI. */
    uint64_t rx_multicast_frames;       /**< The number of received multicast frames on this NNI. */
    uint64_t rx_broadcast_frames;       /**< The number of received broadcast frames on this NNI. */
    uint64_t rx_fcs_errors;             /**< The number of received FCS errors on this NNI. */
    uint64_t rx_control_frames;         /**< The number of received control frames on this NNI. */
    uint64_t rx_pause_frames;           /**< The number of received pause frames on this NNI. */
    uint64_t rx_pfc_frames;             /**< The number of received PFC frames on this NNI. */
    uint64_t rx_unsupported_opcode;     /**< The number of received Unsupported Opcode frames on this NNI. */
    uint64_t rx_unsupported_da;         /**< The number of received unsupported DA frames on this NNI. */
    uint64_t rx_alignment_errors;       /**< The number of received alignment errors on this NNI. */
    uint64_t rx_length_out_of_range;    /**< The number of received length out of range errors on this NNI. */
    uint64_t rx_code_errors;            /**< The number of received code errors on this NNI. */
    uint64_t rx_oversized_frames;       /**< The number of received oversized frames on this NNI. */
    uint64_t rx_jabber_frames;          /**< The number of received jabber frames on this NNI. these are oversized frames that also contain an invalid CRC, code error, or IEEE length check error. */
    uint64_t rx_mtu_check_errors;       /**< The number of received MTU Check Errors on this NNI. */
    uint64_t rx_promiscuous_frames;     /**< The number of received frames on this NNI that are not control packets and have a DA that is not matching with the RX SA. */
    uint64_t rx_vlan_frames;            /**< The number of received VLAN tagged frames on this NNI (with TPID 8100). This counts both single and double tagged frames. */
    uint64_t rx_double_vlan_frames;     /**< The number of received double VLAN tagged frames on this NNI (with TPID 8100).  */
    uint64_t rx_truncated_frames;       /**< The number of received truncated frames on this NNI. This is likely due to RX FIFO Full.  */
    uint64_t rx_undersize_frames;       /**< The number of received undersized frames on this NNI. */
    uint64_t rx_fragmented_frames;      /**< The number of received fragmented frames on this NNI. */
    uint64_t rx_runt_frames;            /**< The number of received runt frames on this NNI. */
    uint64_t tx_frames_64;              /**< The count of TX 64 byte frames on this NNI. */
    uint64_t tx_frames_65_127;          /**< The count of TX 65 to 127 byte frames on this NNI. */
    uint64_t tx_frames_128_255;         /**< The count of TX 128 to 255 byte frames on this NNI. */
    uint64_t tx_frames_256_511;         /**< The count of TX 256 to 511 byte frames on this NNI. */
    uint64_t tx_frames_512_1023;        /**< The count of TX 512 to 1023 byte frames on this NNI. */
    uint64_t tx_frames_1024_1518;       /**< The count of TX 1024 to 1518 byte frames on this NNI. */
    uint64_t tx_frames_1519_2047;       /**< The count of TX 1519 to 2047 byte frames on this NNI. */
    uint64_t tx_frames_2048_4095;       /**< The count of TX 2048 to 4095 byte frames on this NNI. */
    uint64_t tx_frames_4096_9216;       /**< The count of TX 4096 to 9216 byte frames on this NNI. */
    uint64_t tx_frames_9217_16383;      /**< The count of TX 9217 to 16383 byte frames on this NNI. */
    uint64_t tx_frames;                 /**< The number of transmitted frames on this NNI. This includes all errored frames as well. */
    uint64_t tx_bytes;                  /**< The number of transmitted bytes on this NNI. This includes all errored frames as well. */
    uint64_t tx_good_frames;            /**< The number of transmitted good frames on this NNI. */
    uint64_t tx_unicast_frames;         /**< The number of transmitted unicast frames on this NNI. */
    uint64_t tx_multicast_frames;       /**< The number of transmitted multicast frames on this NNI. */
    uint64_t tx_broadcast_frames;       /**< The number of transmitted broadcast frames on this NNI. */
    uint64_t tx_pause_frames;           /**< The number of transmitted pause frames on this NNI. */
    uint64_t tx_pfc_frames;             /**< The number of transmitted PFC frames on this NNI. */
    uint64_t tx_jabber_frames;          /**< The number of transmitted jabber frames on this NNI. These are oversized frames that also contain an invalid FCS. */
    uint64_t tx_fcs_errors;             /**< The number of transmitted FCS errors on this NNI.  */
    uint64_t tx_control_frames;         /**< The number of transmitted control frames on this NNI.  */
    uint64_t tx_oversize_frames;        /**< The number of transmitted oversized frames on this NNI.  */
    uint64_t tx_fragmented_frames;      /**< The number of transmitted fragmented frames on this NNI.  */
    uint64_t tx_error_frames;           /**< The number of transmitted errored frames on this NNI.  */
    uint64_t tx_vlan_frames;            /**< The number of transmitted VLAN tagged frames on this NNI (with TPID 8100). This counts both single and double tagged frames. */
    uint64_t tx_double_vlan_frames;     /**< The number of transmitted double VLAN tagged frames on this NNI (with TPID 8100).  */
    uint64_t tx_runt_frames;            /**< The number of transmitted runt frames on this NNI.  */
    uint64_t tx_underrun_frames;        /**< The number of transmitted underrun frames on this NNI. Thus happens when a frame encounters a MAC underrun (Tx Sync FIFO runs out of data before the end of packet). */
} bcmolt_nni_stat_data;

/** Transport message definition for "stat" group of "nni" object. 
 */
typedef struct bcmolt_nni_stat
{
    bcmolt_stat hdr;            /**< Transport header. */
    bcmolt_nni_key key;         /**< Object key. */
    bcmolt_nni_stat_data data;  /**< All properties that must be set by the user. */
} bcmolt_nni_stat;

/** Structure definition for the "stat_cfg" group of the "nni" object. 
 */
typedef struct bcmolt_nni_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_nni_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "nni" object. 
 */
typedef struct bcmolt_nni_stat_cfg
{
    bcmolt_stat_cfg hdr;            /**< Transport header. */
    bcmolt_nni_key key;             /**< Object key. */
    bcmolt_nni_stat_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_nni_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the "nni" object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_nni_stat_alarm_cleared_data
{
    bcmolt_nni_stat_id stat;    /**< Statistic identifier. */
} bcmolt_nni_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "nni" object. 
 */
typedef struct bcmolt_nni_stat_alarm_cleared
{
    bcmolt_auto hdr;    /**< Transport header. */
    bcmolt_nni_key key; /**< Object key. */
    bcmolt_nni_stat_alarm_cleared_data data;    /**< All properties that must be set by the user. */
} bcmolt_nni_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "nni" object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_nni_stat_alarm_raised_data
{
    bcmolt_nni_stat_id stat;    /**< Statistic identifier. */
} bcmolt_nni_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "nni" object. 
 */
typedef struct bcmolt_nni_stat_alarm_raised
{
    bcmolt_auto hdr;                        /**< Transport header. */
    bcmolt_nni_key key;                     /**< Object key. */
    bcmolt_nni_stat_alarm_raised_data data; /**< All properties that must be set by the user. */
} bcmolt_nni_stat_alarm_raised;

/** Structure definition for the "status_changed" group of the "nni" object. 
 *
 * NNI Link status changed 
 */
typedef struct bcmolt_nni_status_changed_data
{
    bcmolt_status new_status;               /**< New NNI Link Status */
    bcmolt_nni_connection link;             /**< Which NNI this indication pertains to. */
    bcmolt_nni_connection previous_active;  /**< Which NNI was active before this status change. */
    bcmolt_nni_connection new_active;       /**< Which NNI is now active after this status change. */
} bcmolt_nni_status_changed_data;

/** Transport message definition for "status_changed" group of "nni" object. 
 */
typedef struct bcmolt_nni_status_changed
{
    bcmolt_auto hdr;                        /**< Transport header. */
    bcmolt_nni_key key;                     /**< Object key. */
    bcmolt_nni_status_changed_data data;    /**< All properties that must be set by the user. */
} bcmolt_nni_status_changed;

/** Structure definition for the "auto_cfg" group of the "nni" object. 
 */
typedef struct bcmolt_nni_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
    bcmos_bool status_changed;      /**< If true, indications of type "status_changed" will be generated. */
} bcmolt_nni_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "nni" object. 
 */
typedef struct bcmolt_nni_auto_cfg
{
    bcmolt_auto_cfg hdr;            /**< Transport header. */
    bcmolt_nni_key key;             /**< Object key. */
    bcmolt_nni_auto_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_nni_auto_cfg;

/** Structure definition for the "key" group of the "nni_serdes" object. 
 */
typedef struct bcmolt_nni_serdes_key
{
    bcmolt_pon_ni pon_ni;               /**< PON NI. */
    bcmolt_serdes_instance instance;    /**< SerDes instance.: 0 = Primary, 1 = Secondary. */
} bcmolt_nni_serdes_key;

/** Structure definition for the "cfg" group of the "nni_serdes" object. 
 */
typedef struct bcmolt_nni_serdes_cfg_data
{
    uint8_t rx_vga;     /**< Rx Vga. */
    uint8_t rx_pf;      /**< Peaking Filter */
    uint8_t rx_lfpf;    /**< Low Frequency Peaking Filter */
    uint8_t rx_dfe1;    /**< Rx DFE1. */
    int8_t rx_dfe2;     /**< Rx DFE2. */
    int8_t rx_dfe3;     /**< Rx DFE3. */
    int8_t rx_dfe4;     /**< Rx DFE4. */
    int8_t rx_dfe5;     /**< Rx DFE5. */
    uint8_t tx_pre;     /**< Tx Pre. */
    uint8_t tx_main;    /**< Tx Main. */
    uint8_t tx_post1;   /**< Tx Post1. */
    int8_t tx_post2;    /**< Tx Post2. */
    int8_t tx_post3;    /**< Tx Post3. */
    uint8_t tx_amp;     /**< Tx Amp. */
} bcmolt_nni_serdes_cfg_data;

/** Transport message definition for "cfg" group of "nni_serdes" object. 
 */
typedef struct bcmolt_nni_serdes_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_nni_serdes_key key;          /**< Object key. */
    bcmolt_nni_serdes_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_nni_serdes_cfg;

/** Structure definition for the "key" group of the "software_error" object. 
 */
typedef struct bcmolt_software_error_key
{
    uint32_t reserved;  /**< Reserved (set to 0). */
    uint32_t idx;       /**< Index. */
} bcmolt_software_error_key;

/** Structure definition for the "cfg" group of the "software_error" object. 
 */
typedef struct bcmolt_software_error_cfg_data
{
    bcmolt_sw_error entry;  /**< Entry. */
} bcmolt_software_error_cfg_data;

/** Transport message definition for "cfg" group of "software_error" object. 
 */
typedef struct bcmolt_software_error_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_software_error_key key;  /**< Object key. */
    bcmolt_software_error_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_software_error_cfg;

/** Structure definition for the "key" group of the "trx_calibration" object. 
 */
typedef struct bcmolt_trx_calibration_key
{
    uint32_t reserved;  /**< Reserved (set to 0) */
} bcmolt_trx_calibration_key;

/** Structure definition for the "capture_window_and_statistic_completed" group 
 * of the "trx_calibration" object. 
 */
typedef struct bcmolt_trx_calibration_capture_window_and_statistic_completed_data
{
    bcmolt_u32_list_u32_max_500_hex data_window;    /**< data window. */
    bcmolt_u32_list_u32_max_500_hex strobe_window;  /**< strobe window. */
    uint64_t edge_rise_min_min;                     /**< edge rise min min. */
    uint64_t edge_rise_min_max;                     /**< edge rise min max. */
    uint64_t edge_rise_max_min;                     /**< edge rise max min. */
    uint64_t edge_rise_max_max;                     /**< edge rise max max. */
    uint64_t edge_fall_min_min;                     /**< edge fall min min . */
    uint64_t edge_fall_min_max;                     /**< edge fall min max. */
    uint64_t edge_fall_max_min;                     /**< edge fall max min. */
    uint64_t edge_fall_max_max;                     /**< edge fall max max. */
    bcmolt_result result;   /**< result. */
} bcmolt_trx_calibration_capture_window_and_statistic_completed_data;

/** Transport message definition for "capture_window_and_statistic_completed" 
 * group of "trx_calibration" object. 
 */
typedef struct bcmolt_trx_calibration_capture_window_and_statistic_completed
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_trx_calibration_key key; /**< Object key. */
    bcmolt_trx_calibration_capture_window_and_statistic_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_trx_calibration_capture_window_and_statistic_completed;

/** Structure definition for the "auto_cfg" group of the "trx_calibration" 
 * object. 
 */
typedef struct bcmolt_trx_calibration_auto_cfg_data
{
    bcmos_bool capture_window_and_statistic_completed;  /**< If true, indications of type "capture_window_and_statistic_completed" will be generated. */
} bcmolt_trx_calibration_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "trx_calibration" 
 * object. 
 */
typedef struct bcmolt_trx_calibration_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_trx_calibration_key key;             /**< Object key. */
    bcmolt_trx_calibration_auto_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_trx_calibration_auto_cfg;

/** Structure definition for the "start_capture_window" group of the 
 * "trx_calibration" object. 
 */
typedef struct bcmolt_trx_calibration_start_capture_window_data
{
    uint8_t pon_ni; /**< pon_ni. */
    bcmolt_trx_calibration_trigger trigger;         /**< trigger. */
    bcmolt_capture_strobe_signal strobe;            /**< strobe. */
    bcmolt_trx_calibration_window_mode window_mode; /**< window mode. */
    uint16_t onu_id;    /**< onu id. */
    bcmolt_trx_calibration_trigger_position trigger_position;   /**< trigger position. */
    bcmos_bool stop_due_to_corrupt_strobe;                      /**< enable/disable corrupt strobe from MAC to terminate stat window */
    uint16_t start_offset;      /**< start offset. */
    uint16_t end_offset;        /**< end offset. */
    uint8_t number_of_cycles;   /**< number of cycles. */
} bcmolt_trx_calibration_start_capture_window_data;

/** Transport message definition for "start_capture_window" group of 
 * "trx_calibration" object. 
 */
typedef struct bcmolt_trx_calibration_start_capture_window
{
    bcmolt_oper hdr;                /**< Transport header. */
    bcmolt_trx_calibration_key key; /**< Object key. */
    bcmolt_trx_calibration_start_capture_window_data data;  /**< All properties that must be set by the user. */
} bcmolt_trx_calibration_start_capture_window;

/** Structure definition for the "stop_capture_window" group of the 
 * "trx_calibration" object. 
 */
typedef struct bcmolt_trx_calibration_stop_capture_window_data
{
    uint8_t pon_ni; /**< pon_ni. */
} bcmolt_trx_calibration_stop_capture_window_data;

/** Transport message definition for "stop_capture_window" group of 
 * "trx_calibration" object. 
 */
typedef struct bcmolt_trx_calibration_stop_capture_window
{
    bcmolt_oper hdr;                /**< Transport header. */
    bcmolt_trx_calibration_key key; /**< Object key. */
    bcmolt_trx_calibration_stop_capture_window_data data;   /**< All properties that must be set by the user. */
} bcmolt_trx_calibration_stop_capture_window;

/** Structure definition for the "key" group of the "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_key
{
    bcmolt_xgpon_ni pon_ni;         /**< PON network interface. */
    bcmolt_xgpon_alloc_id alloc_id; /**< Alloc ID. */
} bcmolt_xgpon_alloc_key;

/** Structure definition for the "cfg" group of the "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_cfg_data
{
    bcmolt_alloc_state state;   /**< Current Alloc ID state */
    bcmolt_pon_alloc_sla sla;   /**< Alloc ID SLA */
    bcmolt_xgpon_onu_id onu_id; /**< ONU ID the alloc ID is assigned to */
    bcmos_bool collect_stats;   /**< Enable statistics collection for this alloc ID */
} bcmolt_xgpon_alloc_cfg_data;

/** Transport message definition for "cfg" group of "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_xgpon_alloc_key key;         /**< Object key. */
    bcmolt_xgpon_alloc_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_cfg;

/** Structure definition for the "stat" group of the "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_stat_data
{
    uint64_t rx_bytes;  /**< Number of alloc ID received bytes. */
} bcmolt_xgpon_alloc_stat_data;

/** Transport message definition for "stat" group of "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_stat
{
    bcmolt_stat hdr;                    /**< Transport header. */
    bcmolt_xgpon_alloc_key key;         /**< Object key. */
    bcmolt_xgpon_alloc_stat_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_stat;

/** Structure definition for the "stat_cfg" group of the "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_xgpon_alloc_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_stat_cfg
{
    bcmolt_stat_cfg hdr;        /**< Transport header. */
    bcmolt_xgpon_alloc_key key; /**< Object key. */
    bcmolt_xgpon_alloc_stat_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_stat_cfg;

/** Structure definition for the "configuration_completed" group of the 
 * "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_configuration_completed_data
{
    bcmolt_result status;           /**< status. */
    bcmolt_alloc_state new_state;   /**< new state. */
} bcmolt_xgpon_alloc_configuration_completed_data;

/** Transport message definition for "configuration_completed" group of 
 * "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_configuration_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_alloc_key key; /**< Object key. */
    bcmolt_xgpon_alloc_configuration_completed_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_configuration_completed;

/** Structure definition for the "get_alloc_stats_completed" group of the 
 * "xgpon_alloc" object. 
 *
 * Collected alloc ID statistics from get_stats operation 
 */
typedef struct bcmolt_xgpon_alloc_get_alloc_stats_completed_data
{
    bcmolt_result status;           /**< status. */
    uint32_t average_nsr_used;      /**< Average NSR used words. */
    uint32_t average_nsr_allocated; /**< Average NSR allocated words. */
    uint32_t average_sr_report;     /**< Average SR report. */
} bcmolt_xgpon_alloc_get_alloc_stats_completed_data;

/** Transport message definition for "get_alloc_stats_completed" group of 
 * "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_get_alloc_stats_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_alloc_key key; /**< Object key. */
    bcmolt_xgpon_alloc_get_alloc_stats_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_get_alloc_stats_completed;

/** Structure definition for the "stat_alarm_cleared" group of the "xgpon_alloc" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_xgpon_alloc_stat_alarm_cleared_data
{
    bcmolt_xgpon_alloc_stat_id stat;    /**< Statistic identifier. */
} bcmolt_xgpon_alloc_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "xgpon_alloc" 
 * object. 
 */
typedef struct bcmolt_xgpon_alloc_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_alloc_key key; /**< Object key. */
    bcmolt_xgpon_alloc_stat_alarm_cleared_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "xgpon_alloc" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_xgpon_alloc_stat_alarm_raised_data
{
    bcmolt_xgpon_alloc_stat_id stat;    /**< Statistic identifier. */
} bcmolt_xgpon_alloc_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "xgpon_alloc" 
 * object. 
 */
typedef struct bcmolt_xgpon_alloc_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_alloc_key key; /**< Object key. */
    bcmolt_xgpon_alloc_stat_alarm_raised_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_auto_cfg_data
{
    bcmos_bool configuration_completed;     /**< If true, indications of type "configuration_completed" will be generated. */
    bcmos_bool get_alloc_stats_completed;   /**< If true, indications of type "get_alloc_stats_completed" will be generated. */
    bcmos_bool stat_alarm_cleared;          /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;           /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_xgpon_alloc_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_auto_cfg
{
    bcmolt_auto_cfg hdr;                    /**< Transport header. */
    bcmolt_xgpon_alloc_key key;             /**< Object key. */
    bcmolt_xgpon_alloc_auto_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_auto_cfg;

/** Structure definition for the "get_stats" group of the "xgpon_alloc" object. 
 *
 * Run statistics collection for a given period of time 
 */
typedef struct bcmolt_xgpon_alloc_get_stats_data
{
    uint32_t num_of_cycles; /**< The number of cycles to run statistics collection */
} bcmolt_xgpon_alloc_get_stats_data;

/** Transport message definition for "get_stats" group of "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_get_stats
{
    bcmolt_oper hdr;                        /**< Transport header. */
    bcmolt_xgpon_alloc_key key;             /**< Object key. */
    bcmolt_xgpon_alloc_get_stats_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_get_stats;

/** Structure definition for the "set_state" group of the "xgpon_alloc" object. 
 *
 * Sets the alloc's activation state.  This is only used for protection 
 * switching on an active-standby PON.  In normal operation, this isn't 
 * necessary since allocs are activated/deactivated automatically along with 
 * the ONU. 
 */
typedef struct bcmolt_xgpon_alloc_set_state_data
{
    bcmolt_alloc_operation state;   /**< State. */
} bcmolt_xgpon_alloc_set_state_data;

/** Transport message definition for "set_state" group of "xgpon_alloc" object. 
 */
typedef struct bcmolt_xgpon_alloc_set_state
{
    bcmolt_oper hdr;                        /**< Transport header. */
    bcmolt_xgpon_alloc_key key;             /**< Object key. */
    bcmolt_xgpon_alloc_set_state_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_alloc_set_state;

/** Structure definition for the "key" group of the "xgpon_gem_port" object. 
 */
typedef struct bcmolt_xgpon_gem_port_key
{
    bcmolt_xgpon_ni pon_ni;             /**< PON network interface. */
    bcmolt_xgpon_gem_id gem_port_id;    /**< GEM PORT ID. */
} bcmolt_xgpon_gem_port_key;

/** Structure definition for the "cfg" group of the "xgpon_gem_port" object. 
 */
typedef struct bcmolt_xgpon_gem_port_cfg_data
{
    bcmolt_gem_port_configuration configuration;                /**< GEM port configuration parameters */
    bcmolt_xgpon_onu_id onu_id;                                 /**< ONU ID this GEM port is assigned to */
    bcmolt_xgpon_gem_port_state gem_port_state;                 /**< Current GEM port state */
    bcmolt_control_state encryption_mode;                       /**< Enable/Disable the downstream encryption mode of the GEM Port */
    bcmolt_us_gem_port_destination upstream_destination_queue;  /**< The destination queue of the packets arriving on this GEM Port on the upstream direction */
    bcmolt_control_state control;   /**< Enable/Disable the GEM Port ID in the OLT */
} bcmolt_xgpon_gem_port_cfg_data;

/** Transport message definition for "cfg" group of "xgpon_gem_port" object. 
 */
typedef struct bcmolt_xgpon_gem_port_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_xgpon_gem_port_key key;  /**< Object key. */
    bcmolt_xgpon_gem_port_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_gem_port_cfg;

/** Structure definition for the "stat" group of the "xgpon_gem_port" object. 
 */
typedef struct bcmolt_xgpon_gem_port_stat_data
{
    uint64_t tx_bytes;      /**< TX bytes. */
    uint64_t tx_packets;    /**< TX packets. */
    uint64_t rx_packets;    /**< RX packets. */
    uint64_t rx_bytes;      /**< RX bytes. */
} bcmolt_xgpon_gem_port_stat_data;

/** Transport message definition for "stat" group of "xgpon_gem_port" object. 
 */
typedef struct bcmolt_xgpon_gem_port_stat
{
    bcmolt_stat hdr;                        /**< Transport header. */
    bcmolt_xgpon_gem_port_key key;          /**< Object key. */
    bcmolt_xgpon_gem_port_stat_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_gem_port_stat;

/** Structure definition for the "stat_cfg" group of the "xgpon_gem_port" 
 * object. 
 */
typedef struct bcmolt_xgpon_gem_port_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_xgpon_gem_port_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "xgpon_gem_port" 
 * object. 
 */
typedef struct bcmolt_xgpon_gem_port_stat_cfg
{
    bcmolt_stat_cfg hdr;            /**< Transport header. */
    bcmolt_xgpon_gem_port_key key;  /**< Object key. */
    bcmolt_xgpon_gem_port_stat_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_gem_port_stat_cfg;

/** Structure definition for the "stat_alarm_cleared" group of the 
 * "xgpon_gem_port" object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_xgpon_gem_port_stat_alarm_cleared_data
{
    bcmolt_xgpon_gem_port_stat_id stat; /**< Statistic identifier. */
} bcmolt_xgpon_gem_port_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of 
 * "xgpon_gem_port" object. 
 */
typedef struct bcmolt_xgpon_gem_port_stat_alarm_cleared
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_xgpon_gem_port_key key;  /**< Object key. */
    bcmolt_xgpon_gem_port_stat_alarm_cleared_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_gem_port_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the 
 * "xgpon_gem_port" object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_xgpon_gem_port_stat_alarm_raised_data
{
    bcmolt_xgpon_gem_port_stat_id stat; /**< Statistic identifier. */
} bcmolt_xgpon_gem_port_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of 
 * "xgpon_gem_port" object. 
 */
typedef struct bcmolt_xgpon_gem_port_stat_alarm_raised
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_xgpon_gem_port_key key;  /**< Object key. */
    bcmolt_xgpon_gem_port_stat_alarm_raised_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_gem_port_stat_alarm_raised;

/** Structure definition for the "auto_cfg" group of the "xgpon_gem_port" 
 * object. 
 */
typedef struct bcmolt_xgpon_gem_port_auto_cfg_data
{
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
} bcmolt_xgpon_gem_port_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "xgpon_gem_port" 
 * object. 
 */
typedef struct bcmolt_xgpon_gem_port_auto_cfg
{
    bcmolt_auto_cfg hdr;                        /**< Transport header. */
    bcmolt_xgpon_gem_port_key key;              /**< Object key. */
    bcmolt_xgpon_gem_port_auto_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_gem_port_auto_cfg;

/** Structure definition for the "key" group of the "xgpon_iwf" object. 
 */
typedef struct bcmolt_xgpon_iwf_key
{
    bcmolt_xgpon_ni pon_ni; /**< PON network interface. */
} bcmolt_xgpon_iwf_key;

/** Structure definition for the "cfg" group of the "xgpon_iwf" object. 
 */
typedef struct bcmolt_xgpon_iwf_cfg_data
{
    uint16_t us_otag_direct_tpid;   /**< TPID value of the VLAN tag added to upstream packet */
#define BCMOLT_XGPON_IWF_CFG_DATA_DS_TPID_LEN   5
    bcmolt_arr_u16_5_hex ds_tpid;   /**< Packets marked with one of the five configured DS TPID options will be forwarded, all the rest will be dropped */
} bcmolt_xgpon_iwf_cfg_data;

/** Transport message definition for "cfg" group of "xgpon_iwf" object. 
 */
typedef struct bcmolt_xgpon_iwf_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_xgpon_iwf_key key;       /**< Object key. */
    bcmolt_xgpon_iwf_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_iwf_cfg;

/** Structure definition for the "key" group of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_key
{
    bcmolt_xgpon_ni pon_ni; /**< PON network interface. */
} bcmolt_xgpon_ni_key;

/** Structure definition for the "cfg" group of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_cfg_data
{
    bcmolt_hw_pon_id hw_pon_id; /**< 51 bit PON identifier. This attribute is part of the downstream physical synchronization block (PSBd) */
    bcmolt_pon_available_bandwidth available_bandwidth; /**< PON available bandwidth parameters */
    uint16_t number_of_active_onus;                     /**< Number of active ONUs on the PON */
    bcmolt_pon_status pon_status;                       /**< PON status parameters */
    bcmolt_pon_distance pon_distance;                   /**< PON distance */
    uint32_t ranging_window_size;                       /**< Ranging window size in BW units (4-byte words for 2.5G upstream, 16-byte blocks for 10G upstream) */
    uint32_t eqd_cycles_number;             /**< How many ranging windows are opened during a single ONU activation process */
    bcmolt_pon_drift_control drift_control; /**< Drift control process configuration */
    uint8_t los_alarm_threshold;            /**< LOS alarm threshold */
    bcmolt_status los_initial_value;        /**< LOS initial value following PON activation */
    bcmolt_xgpon_onu_alarms_thresholds onu_alarms_thresholds;               /**< ONU alarms thresholds configuration */
    bcmolt_ber_monitor_params ber_monitor;                                  /**< BER monitor process configuration */
    bcmolt_xgpon_onu_activation onu_activation;                             /**< ONU activation control parameters */
    bcmolt_xgpon_sn_acquisition sn_acquisition;                             /**< Serial Number process configuration */
    bcmolt_xgpon_key_exchange key_exchange;                                 /**< Key Exchange process configuration */
    bcmolt_xgpon_protection_switching protection_switching;                 /**< Protection switching control */
    bcmolt_xgpon_protection_switching_debug protection_switching_debug;     /**< protection switching debug . */
    bcmolt_cbr_rt_allocation_profile cbr_rt_allocation_profile;             /**< CBR Real Time allocation profile */
#define BCMOLT_XGPON_NI_CFG_DATA_CBR_NRT_ALLOCATION_PROFILE_LEN 2
    bcmolt_arr_u16_2 cbr_nrt_allocation_profile;                            /**< CBR non Real Time allocation profile */
    bcmolt_onu_power_management_configuration power_management;             /**< ONU power management control */
    bcmolt_rogue_onu_detection_process rogue_onu_detection_process;         /**< TBD */
    bcmolt_periodic_standby_pon_monitoring periodic_standby_pon_monitoring; /**< Periodic Standby PON monitoring */
    bcmolt_dba_mode dba_mode;                       /**< DBA mode */
    bcmolt_xgpon_ploam_handling ploam_handling;     /**< Ploam handling configuration */
    bcmolt_xgpon_alloc_id min_data_alloc_id;        /**< Min data Alloc ID value */
    bcmolt_xgpon_gem_id min_data_gem_port_id;       /**< Min data XGEM port ID value */
    bcmolt_xgpon_multicast_key multicast_key;       /**< Multicast XGEM ports encryption control */
    bcmolt_prbs_checker_config prbs_checker;        /**< US PRBS checker configuration */
    bcmolt_prbs_generator_config prbs_generator;    /**< DS PRBS generator configuration */
    bcmolt_prbs_status prbs_status;                 /**< Result of US PRBS checker */
    bcmolt_automatic_onu_deactivation automatic_onu_deactivation;   /**< Option to disable the automatic deactivation of ONUs due to alarms */
    uint32_t us_bandwidth_limit;    /**< Total PON upstream bandwidth limit in bytes per second. */
    bcmolt_xgpon_onu_with_state_list_u16_max_510 all_onus;                  /**< All ONUs currently provisioned on this PON. */
    bcmolt_xgpon_gem_port_with_state_list_u16_max_128 all_mcast_gem_ports;  /**< All multicast GEM ports currently provisioned on this PON. */
    bcmolt_xgpon_ni_debug debug;                        /**< PON NI debug parameters */
    bcmolt_gpon_onu_upgrade_params onu_upgrade_params;  /**< ONU upgrade params. */
    bcmolt_control_state ds_fec_mode;                   /**< DS FEC mode. */
    bcmolt_dba_type dba_type;                   /**< DBA implementation type */
    bcmolt_onu_tuning_configuration onu_tuning; /**< onu tuning. */
} bcmolt_xgpon_ni_cfg_data;

/** Transport message definition for "cfg" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_xgpon_ni_key key;        /**< Object key. */
    bcmolt_xgpon_ni_cfg_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_cfg;

/** Structure definition for the "stat" group of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_stat_data
{
    uint64_t fec_codewords;             /**< Receive FEC codewords. */
    uint64_t bip32_bytes;               /**< Received bytes protected by bip32. */
    uint64_t bip32_errors;              /**< Received bip32 errors. */
    uint64_t rx_xgtc_headers;           /**< Received valid XGTC headers. */
    uint64_t rx_xgtc_corrected;         /**< Received corrected XGTC headers. */
    uint64_t rx_xgtc_uncorrected;       /**< Received uncorrected XGTC headers. */
    uint64_t rx_xgem;                   /**< Received valid XGEM frames. */
    uint64_t rx_xgem_dropped;           /**< Received dropped XGEM ID frames. */
    uint64_t rx_xgem_idle;              /**< Received idle XGEM frames. */
    uint64_t rx_xgem_corrected;         /**< Received corrected XGEM frames. */
    uint64_t rx_crc_error;              /**< Received packets with CRC error. */
    uint64_t rx_fragment_error;         /**< Received fragment errors. */
    uint64_t rx_packets_dropped;        /**< Global dropped packets. */
    uint64_t rx_dropped_too_short;      /**< Received packets dropped due to length too short. */
    uint64_t rx_dropped_too_long;       /**< Received packet dropped due to length too long. */
    uint64_t rx_key_error;              /**< Received key errors. */
    uint64_t tx_ploams;                 /**< Transmitted Ploams. */
    uint64_t rx_ploams_dropped;         /**< Received dropped Ploams. */
    uint64_t rx_allocations_valid;      /**< Received valid allocations. */
    uint64_t rx_allocations_invalid;    /**< Received invalid allocations. */
    uint64_t rx_allocations_disabled;   /**< Received disabled allocations. */
    uint64_t rx_ploams;                 /**< Received Ploams. */
    uint64_t rx_ploams_non_idle;        /**< Received non idle Ploams. */
    uint64_t rx_ploams_error;           /**< Received error Ploams. */
    uint64_t rx_cpu;                    /**< Received CPU packets. */
    uint64_t rx_omci;                   /**< Received OMCI packets. */
    uint64_t rx_omci_packets_crc_error; /**< Received OMCI packets with CRC errors. */
    uint64_t tx_packets;                /**< Transmitted packets. */
    uint64_t tx_xgem;                   /**< Transmitted XGEM fragments. */
    uint64_t tx_cpu;                    /**< Transmitted CPU packets. */
    uint64_t tx_omci;                   /**< Transmitted OMCI packets. */
    uint8_t tx_cpu_omci_packets_dropped;    /**< Transmit packets dropped due to illegal length. */
    uint64_t tx_dropped_illegal_length;     /**< Transmit packets dropped due to illegal length. */
    uint64_t tx_dropped_tpid_miss;          /**< Transmit packets dropped due to TPID miss. */
    uint64_t tx_dropped_vid_miss;           /**< Transmit packets droped due to VID miss. */
} bcmolt_xgpon_ni_stat_data;

/** Transport message definition for "stat" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_stat
{
    bcmolt_stat hdr;                /**< Transport header. */
    bcmolt_xgpon_ni_key key;        /**< Object key. */
    bcmolt_xgpon_ni_stat_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_stat;

/** Structure definition for the "stat_cfg" group of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_xgpon_ni_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_stat_cfg
{
    bcmolt_stat_cfg hdr;                /**< Transport header. */
    bcmolt_xgpon_ni_key key;            /**< Object key. */
    bcmolt_xgpon_ni_stat_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_stat_cfg;

/** Transport message definition for "activate_all_onus_completed" group of 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_activate_all_onus_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
} bcmolt_xgpon_ni_activate_all_onus_completed;

/** Structure definition for the "cpu_packets_failure" group of the "xgpon_ni" 
 * object. 
 *
 * A failure was encountered during the "cpu_packets" proxy operation. 
 */
typedef struct bcmolt_xgpon_ni_cpu_packets_failure_data
{
    bcmolt_packet_injection_error error;    /**< The error that was encountered. */
    bcmolt_xgpon_gem_id gem_port_id;        /**< The GEM port that caused the error. */
} bcmolt_xgpon_ni_cpu_packets_failure_data;

/** Transport message definition for "cpu_packets_failure" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_cpu_packets_failure
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_cpu_packets_failure_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_cpu_packets_failure;

/** Transport message definition for "deactivate_all_onus_completed" group of 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_deactivate_all_onus_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
} bcmolt_xgpon_ni_deactivate_all_onus_completed;

/** Transport message definition for "disable_all_onus_completed" group of 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_disable_all_onus_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
} bcmolt_xgpon_ni_disable_all_onus_completed;

/** Transport message definition for "enable_all_onus_completed" group of 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_enable_all_onus_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
} bcmolt_xgpon_ni_enable_all_onus_completed;

/** Structure definition for the "los" group of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_los_data
{
    bcmolt_status status;   /**< status. */
} bcmolt_xgpon_ni_los_data;

/** Transport message definition for "los" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_los
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_xgpon_ni_key key;        /**< Object key. */
    bcmolt_xgpon_ni_los_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_los;

/** Structure definition for the "onu_discovered" group of the "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_onu_discovered_data
{
    bcmolt_serial_number serial_number; /**< serial number. */
    uint32_t ranging_time;              /**< ranging time. */
    bcmolt_xgpon_onu_id onu_id;         /**< onu_id. */
    bcmolt_upstream_line_rate_capabilities upstream_line_rate_capabilities; /**< Upstream line rate capabilities */
    uint8_t current_downstream_pon_id;                  /**< The PON-ID received by the ONU in its current downstream wavelength channel */
    uint8_t current_upstream_pon_id;                    /**< The PON-ID of the Channel Profile containing the descriptor of the upstream wavelength channel in which the ONU is transmitting */
#define BCMOLT_XGPON_NI_ONU_DISCOVERED_DATA_CALIBRATION_RECORD_LEN  8
    bcmolt_arr_calibration_record_8 calibration_record; /**< Calibration record */
    uint8_t tuning_granularity;             /**< The tuning granularity of the ONU transmitted expressed in units of 1Ghz. Value of 0 indicates that the ONU does not support fine tuning / dithering */
    uint8_t step_tuning_time;               /**< The value of the tuning time for a single granularity step, expressed in unit of PHY frames. The value 0 indicates that the ONU does not support fine tuning / dithering */
    uint8_t attenuation;                    /**< The ONU attenuation in steps of 3dB at the time of the message transmission as part of the power levelling report. Value of 0 represents un-attenuated transmission */
    uint8_t power_levelling_capabilities;   /**< The ONU supports attenuation level in step of 3dB */
} bcmolt_xgpon_ni_onu_discovered_data;

/** Transport message definition for "onu_discovered" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_onu_discovered
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_onu_discovered_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_onu_discovered;

/** Structure definition for the "onu_upgrade_complete" group of the "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_onu_upgrade_complete_data
{
    bcmos_bool status;  /**< Success or failure.  Against entire upgrade process.  This is added per Anat's request. */
    bcmolt_gpon_onu_upgrade_status_list_u32 list_of_failed_entities;    /**< List of ONU-IDs the upgrade failed for. */
} bcmolt_xgpon_ni_onu_upgrade_complete_data;

/** Transport message definition for "onu_upgrade_complete" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_onu_upgrade_complete
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_onu_upgrade_complete_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_onu_upgrade_complete;

/** Structure definition for the "protection_switching_onus_ranged" group of the 
 * "xgpon_ni" object. 
 *
 * After a switchover is complete and all ONU ranging times have stabilized, 
 * this indication is sent to inform the host of all new ONU EQDs. 
 */
typedef struct bcmolt_xgpon_ni_protection_switching_onus_ranged_data
{
    bcmolt_xgpon_onu_eqd_list_u32 onus; /**< ONUs. */
} bcmolt_xgpon_ni_protection_switching_onus_ranged_data;

/** Transport message definition for "protection_switching_onus_ranged" group of 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_protection_switching_onus_ranged
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_protection_switching_onus_ranged_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_protection_switching_onus_ranged;

/** Structure definition for the "protection_switching_switchover_completed" 
 * group of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_protection_switching_switchover_completed_data
{
    bcmolt_result result;   /**< Result. */
} bcmolt_xgpon_ni_protection_switching_switchover_completed_data;

/** Transport message definition for "protection_switching_switchover_completed" 
 * group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_protection_switching_switchover_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_protection_switching_switchover_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_protection_switching_switchover_completed;

/** Structure definition for the "protection_switching_traffic_resume" group of 
 * the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_protection_switching_traffic_resume_data
{
    bcmolt_traffic_resume_result result;    /**< Result. */
} bcmolt_xgpon_ni_protection_switching_traffic_resume_data;

/** Transport message definition for "protection_switching_traffic_resume" group 
 * of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_protection_switching_traffic_resume
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_protection_switching_traffic_resume_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_protection_switching_traffic_resume;

/** Structure definition for the "rogue_detection_completed" group of the 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_rogue_detection_completed_data
{
    bcmolt_rogue_detection_window window_type;          /**< Silent Window or Cut off Window */
    bcmolt_rogue_measurement_result measurement_status; /**< Status of the rogue ONU detection result. */
    bcmolt_xgpon_alloc_id alloc_id;                     /**< Alloc-ID */
    bcmolt_xgpon_onu_id onu_id;                 /**< ONU-ID */
    bcmos_bool is_delineation;                  /**< Burst Delineation detected during the rogue ONU detection. */
    bcmos_bool is_ed;                           /**< Is ED. */
    bcmolt_u8_list_u32 rx_data;                 /**< Captured PLOAMu message if the burst delinieation was detected. */
    bcmolt_xgpon_onu_id ploam_received_onu_id;  /**< ONU ID received in the ploam */
    bcmos_bool ploam_received_mic_error;        /**< Mic error in the received ploam */
} bcmolt_xgpon_ni_rogue_detection_completed_data;

/** Transport message definition for "rogue_detection_completed" group of 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_rogue_detection_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_rogue_detection_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_rogue_detection_completed;

/** Transport message definition for "rogue_onu_special_map_cycle_start" group 
 * of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
} bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start;

/** Transport message definition for "serial_number_acquisition_cycle_start" 
 * group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_serial_number_acquisition_cycle_start
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
} bcmolt_xgpon_ni_serial_number_acquisition_cycle_start;

/** Structure definition for the "standby_pon_monitoring_cycle_completed" group 
 * of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_data
{
    uint32_t number_of_detected_delimiter;  /**< number of detected delimiter. */
    bcmolt_status energy_detect_signal;     /**< energy detect signal. */
} bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_data;

/** Transport message definition for "standby_pon_monitoring_cycle_completed" 
 * group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed;

/** Structure definition for the "stat_alarm_cleared" group of the "xgpon_ni" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_xgpon_ni_stat_alarm_cleared_data
{
    bcmolt_xgpon_ni_stat_id stat;   /**< Statistic identifier. */
} bcmolt_xgpon_ni_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_stat_alarm_cleared_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "xgpon_ni" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_xgpon_ni_stat_alarm_raised_data
{
    bcmolt_xgpon_ni_stat_id stat;   /**< Statistic identifier. */
} bcmolt_xgpon_ni_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_stat_alarm_raised_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_stat_alarm_raised;

/** Structure definition for the "state_change_completed" group of the 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_state_change_completed_data
{
    bcmolt_result result;               /**< Result. */
    bcmolt_pon_state previous_state;    /**< Previous state. */
    bcmolt_pon_state new_state;         /**< new state. */
} bcmolt_xgpon_ni_state_change_completed_data;

/** Transport message definition for "state_change_completed" group of 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_state_change_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_state_change_completed_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_state_change_completed;

/** Structure definition for the "tod_request_completed" group of the "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_tod_request_completed_data
{
    bcmolt_str_64 tod_string;   /**< tod_string. */
    uint64_t sfc;               /**< sfc. */
    uint64_t rtc_offset_sec;    /**< rtc_offset_sec. */
    uint32_t rtc_offset_nsec;   /**< rtc_offset_nsec. */
    bcmolt_result status;       /**< status. */
} bcmolt_xgpon_ni_tod_request_completed_data;

/** Transport message definition for "tod_request_completed" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_tod_request_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_tod_request_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_tod_request_completed;

/** Structure definition for the "auto_cfg" group of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_auto_cfg_data
{
    bcmos_bool activate_all_onus_completed;     /**< If true, indications of type "activate_all_onus_completed" will be generated. */
    bcmos_bool cpu_packets_failure;             /**< If true, indications of type "cpu_packets_failure" will be generated. */
    bcmos_bool deactivate_all_onus_completed;   /**< If true, indications of type "deactivate_all_onus_completed" will be generated. */
    bcmos_bool disable_all_onus_completed;      /**< If true, indications of type "disable_all_onus_completed" will be generated. */
    bcmos_bool enable_all_onus_completed;       /**< If true, indications of type "enable_all_onus_completed" will be generated. */
    bcmos_bool los;                     /**< If true, indications of type "los" will be generated. */
    bcmos_bool onu_discovered;          /**< If true, indications of type "onu_discovered" will be generated. */
    bcmos_bool onu_upgrade_complete;    /**< If true, indications of type "onu_upgrade_complete" will be generated. */
    bcmos_bool protection_switching_onus_ranged;            /**< If true, indications of type "protection_switching_onus_ranged" will be generated. */
    bcmos_bool protection_switching_switchover_completed;   /**< If true, indications of type "protection_switching_switchover_completed" will be generated. */
    bcmos_bool protection_switching_traffic_resume;         /**< If true, indications of type "protection_switching_traffic_resume" will be generated. */
    bcmos_bool rogue_detection_completed;                   /**< If true, indications of type "rogue_detection_completed" will be generated. */
    bcmos_bool rogue_onu_special_map_cycle_start;           /**< If true, indications of type "rogue_onu_special_map_cycle_start" will be generated. */
    bcmos_bool serial_number_acquisition_cycle_start;       /**< If true, indications of type "serial_number_acquisition_cycle_start" will be generated. */
    bcmos_bool standby_pon_monitoring_cycle_completed;      /**< If true, indications of type "standby_pon_monitoring_cycle_completed" will be generated. */
    bcmos_bool stat_alarm_cleared;      /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;       /**< If true, indications of type "stat_alarm_raised" will be generated. */
    bcmos_bool state_change_completed;  /**< If true, indications of type "state_change_completed" will be generated. */
    bcmos_bool tod_request_completed;   /**< If true, indications of type "tod_request_completed" will be generated. */
} bcmolt_xgpon_ni_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_auto_cfg
{
    bcmolt_auto_cfg hdr;                /**< Transport header. */
    bcmolt_xgpon_ni_key key;            /**< Object key. */
    bcmolt_xgpon_ni_auto_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_auto_cfg;

/** Structure definition for the "adjust_tx_wavelength" group of the "xgpon_ni" 
 * object. 
 *
 * Instruct an unassigned ONU to adjust its upstream transmitter wavelength 
 */
typedef struct bcmolt_xgpon_ni_adjust_tx_wavelength_data
{
    bcmolt_serial_number serial_number; /**< Serial number */
    bcmolt_frequency_adjustment_direction freqency_adjustment_direction;    /**< Frequency adjustment direction */
    uint8_t frequency_adjustment_size;  /**< The size of the frequncy adjustment in units of 0.1 Ghz */
} bcmolt_xgpon_ni_adjust_tx_wavelength_data;

/** Transport message definition for "adjust_tx_wavelength" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_adjust_tx_wavelength
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_adjust_tx_wavelength_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_adjust_tx_wavelength;

/** Structure definition for the "disable_serial_number" group of the "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_disable_serial_number_data
{
    bcmolt_disable_serial_number_control control;   /**< control. */
    bcmolt_serial_number serial_number;             /**< serial number. */
} bcmolt_xgpon_ni_disable_serial_number_data;

/** Transport message definition for "disable_serial_number" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_disable_serial_number
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_disable_serial_number_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_disable_serial_number;

/** Transport message definition for "reset" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_reset
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
} bcmolt_xgpon_ni_reset;

/** Structure definition for the "rogue_detection_window" group of the 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_rogue_detection_window_data
{
    bcmolt_rogue_detection_window window_type;  /**< Type of silent measurement to execute */
    bcmolt_xgpon_alloc_id alloc_id;             /**< ALLOC ID to scan */
    bcmolt_xgpon_onu_id onu_id;                 /**< ONU ID to scan */
    bcmos_bool second_ranging_window;           /**< Not currently supported */
} bcmolt_xgpon_ni_rogue_detection_window_data;

/** Transport message definition for "rogue_detection_window" group of 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_rogue_detection_window
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_rogue_detection_window_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_rogue_detection_window;

/** Structure definition for the "run_special_bw_map" group of the "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_run_special_bw_map_data
{
    uint8_t number_of_cycle;    /**< number of cycle. */
    uint8_t allocation_number;  /**< allocation number. */
    uint8_t bw_map_array;       /**< bw map array. */
} bcmolt_xgpon_ni_run_special_bw_map_data;

/** Transport message definition for "run_special_bw_map" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_run_special_bw_map
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_run_special_bw_map_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_run_special_bw_map;

/** Structure definition for the "set_onu_state" group of the "xgpon_ni" object. 
 *
 * Set the operation state of all ONUs. 
 */
typedef struct bcmolt_xgpon_ni_set_onu_state_data
{
    bcmolt_onu_operation onu_state; /**< New operation state of all ONUs.  The default operation may be configured by the XGPON NI configuration object : xgpon_ni.cfg.sn_acquisition. */
} bcmolt_xgpon_ni_set_onu_state_data;

/** Transport message definition for "set_onu_state" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_set_onu_state
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_set_onu_state_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_set_onu_state;

/** Structure definition for the "set_pon_state" group of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_set_pon_state_data
{
    bcmolt_pon_operation pon_state; /**< PON state. */
} bcmolt_xgpon_ni_set_pon_state_data;

/** Transport message definition for "set_pon_state" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_set_pon_state
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_set_pon_state_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_set_pon_state;

/** Transport message definition for "single_request_standby_pon_monitoring" 
 * group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_single_request_standby_pon_monitoring
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
} bcmolt_xgpon_ni_single_request_standby_pon_monitoring;

/** Structure definition for the "start_onu_upgrade" group of the "xgpon_ni" 
 * object. 
 *
 * OLT to ONU firmware transfer 
 */
typedef struct bcmolt_xgpon_ni_start_onu_upgrade_data
{
    bcmolt_pon_onu_id_list_u32 list_of_onu_ids; /**< List of ONU IDs to upgrade the firmware. */
} bcmolt_xgpon_ni_start_onu_upgrade_data;

/** Transport message definition for "start_onu_upgrade" group of "xgpon_ni" 
 * object. 
 */
typedef struct bcmolt_xgpon_ni_start_onu_upgrade
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_start_onu_upgrade_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_start_onu_upgrade;

/** Transport message definition for "tod_request" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_tod_request
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
} bcmolt_xgpon_ni_tod_request;

/** Structure definition for the "broadcast_ploam_packet" group of the 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_broadcast_ploam_packet_data
{
#define BCMOLT_XGPON_NI_BROADCAST_PLOAM_PACKET_DATA_PLOAM_LEN   40
    bcmolt_arr_u8_40 ploam; /**< ploam. */
} bcmolt_xgpon_ni_broadcast_ploam_packet_data;

/** Transport message definition for "broadcast_ploam_packet" group of 
 * "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_broadcast_ploam_packet
{
    bcmolt_proxy hdr;           /**< Transport header. */
    bcmolt_xgpon_ni_key key;    /**< Object key. */
    bcmolt_xgpon_ni_broadcast_ploam_packet_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_broadcast_ploam_packet;

/** Structure definition for the "cpu_packets" group of the "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_cpu_packets_data
{
    bcmolt_packet_type packet_type;                     /**< packet type. */
    bcmos_bool calc_crc;                                /**< calc crc. */
    bcmolt_xgpon_gem_id_list_u8_max_16 gem_port_list;   /**< gem port list. */
    bcmolt_u8_list_u32_max_2048 buffer;                 /**< buffer. */
} bcmolt_xgpon_ni_cpu_packets_data;

/** Transport message definition for "cpu_packets" group of "xgpon_ni" object. 
 */
typedef struct bcmolt_xgpon_ni_cpu_packets
{
    bcmolt_proxy hdr;                       /**< Transport header. */
    bcmolt_xgpon_ni_key key;                /**< Object key. */
    bcmolt_xgpon_ni_cpu_packets_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_ni_cpu_packets;

/** Structure definition for the "key" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_key
{
    bcmolt_xgpon_ni pon_ni;     /**< PON network interface. */
    bcmolt_xgpon_onu_id onu_id; /**< onu id. */
} bcmolt_xgpon_onu_key;

/** Structure definition for the "cfg" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_cfg_data
{
    bcmolt_onu_state onu_state;     /**< Current ONU state */
    bcmolt_onu_state onu_old_state; /**< onu old state. */
    bcmolt_xgpon_onu_alarm_state alarm_state;   /**< State of all ONU alarms.  This is normally read-only and can only be written when the PON is in active-standby mode to keep the ONU in sync. */
    bcmolt_xgpon_onu_registration_keys registration_encryption_keys;    /**< AES encryption keys learned during ONU registration.  This is normally read-only and can only be written when the PON is in active-standby mode to keep the ONU in sync. */
    bcmolt_xgpon_onu_aes_key current_encryption_key;                    /**< Current AES encryption key.  This is normally read-only and can only be written when the PON is in active-standby mode to keep the ONU in sync. */
    bcmolt_serial_number serial_number;                 /**< ONU serial number */
#define BCMOLT_XGPON_ONU_CFG_DATA_REGISTRATION_ID_LEN   36
    bcmolt_arr_u8_36 registration_id;                   /**< ONU registration ID */
    bcmos_bool registration_id_auto_learning;           /**< Enable\Disable automatic registration learning */
    bcmolt_burst_profile_index ranging_burst_profile;   /**< Burst profile index for ranging allocations */
    bcmolt_burst_profile_index data_burst_profile;      /**< Burst profile index for data allocations */
    uint32_t ranging_time;                  /**< ONU ranging time.  This is normally read-only and can only be written when the PON is in active-standby mode to keep the ONU in sync. */
    bcmolt_status disabled_after_discovery; /**< This ONU was disabled after SN discovery */
    bcmolt_deactivation_reason deactivation_reason;                     /**< deactivation reason. */
    bcmolt_xgpon_gem_port_with_state_list_u16_max_256 all_gem_ports;    /**< All unicast GEM ports currently provisioned on this ONU. */
    bcmolt_xgpon_alloc_with_state_list_u16_max_32 all_allocs;           /**< All alloc IDs currently provisioned on this ONU. */
    bcmolt_extended_guard_time extended_guard_time;                     /**< Additional guard time (in bytes) for this ONU. */
    bcmolt_upstream_line_rate_capabilities us_line_rate;                /**< US line rate. */
#define BCMOLT_XGPON_ONU_CFG_DATA_CALIBRATION_RECORD_LEN    8
    bcmolt_arr_calibration_record_8 calibration_record;                 /**< Calibration record. */
    uint8_t tuning_granularity;             /**< The tuning granularity of the ONU transmitted expressed in units of 1GHz. Value of 0 indicates that the ONU does not support fine tuning/dithering */
    uint8_t step_tuning_time;               /**< The value of the tuning time for a single granularity step, expressed in units of PHY frames. */
    uint8_t power_levelling_capabilities;   /**< Power levelling capabilities. */
    bcmolt_request_registration_status request_registration_status; /**< This value indicate that the onu is in the middle of request registration process */
} bcmolt_xgpon_onu_cfg_data;

/** Transport message definition for "cfg" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_xgpon_onu_key key;       /**< Object key. */
    bcmolt_xgpon_onu_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_cfg;

/** Structure definition for the "stat" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_stat_data
{
    uint64_t positive_drift;            /**< positive drift. */
    uint64_t negative_drift;            /**< negative drift. */
    uint64_t delimiter_miss_detection;  /**< delimiter miss detection. */
    uint64_t bip32_errors;              /**< bip32 errors. */
    uint64_t rx_words;                  /**< Number of 4-byte words received (word size is 4 bytes regardless of upstream data rate). */
    uint64_t fec_corrected_symbols;     /**< fec corrected symbols. */
    uint64_t fec_corrected_codewords;   /**< fec corrected codewords. */
    uint64_t fec_uncorrectable_codewords;   /**< fec uncorrectable codewords. */
    uint64_t fec_codewords;                 /**< fec total codewords. */
    uint64_t fec_corrected_bits;            /**< fec corrected bits. */
    uint64_t xgem_key_errors;               /**< xgem key error. */
    uint64_t xgem_loss;                     /**< xgem loss . */
    uint64_t rx_ploams_mic_error;           /**< mic error ploam. */
    uint64_t rx_ploams_non_idle;            /**< non idle ploam. */
    uint64_t rx_omci;                       /**< Received OMCI packets. */
    uint64_t rx_omci_packets_crc_error;     /**< Received OMCI packets with CRC errors. */
    uint64_t rx_bytes;                      /**< rx bytes. */
    uint64_t rx_packets;                    /**< rx packets. */
    uint64_t tx_bytes;                      /**< tx bytes. */
    uint64_t tx_packets;                    /**< tx packets. */
} bcmolt_xgpon_onu_stat_data;

/** Transport message definition for "stat" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_stat
{
    bcmolt_stat hdr;                    /**< Transport header. */
    bcmolt_xgpon_onu_key key;           /**< Object key. */
    bcmolt_xgpon_onu_stat_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_stat;

/** Structure definition for the "stat_cfg" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_stat_cfg_data
{
    bcmolt_stat_alarm_config cfg;   /**< Statistic alarm configuration. */
} bcmolt_xgpon_onu_stat_cfg_data;

/** Transport message definition for "stat_cfg" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_stat_cfg
{
    bcmolt_stat_cfg hdr;                    /**< Transport header. */
    bcmolt_xgpon_onu_key key;               /**< Object key. */
    bcmolt_xgpon_onu_stat_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_stat_cfg;

/** Structure definition for the "dfi" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_dfi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_xgpon_onu_dfi_data;

/** Transport message definition for "dfi" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_dfi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_xgpon_onu_key key;       /**< Object key. */
    bcmolt_xgpon_onu_dfi_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_dfi;

/** Structure definition for the "dgi" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_dgi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_xgpon_onu_dgi_data;

/** Transport message definition for "dgi" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_dgi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_xgpon_onu_key key;       /**< Object key. */
    bcmolt_xgpon_onu_dgi_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_dgi;

/** Structure definition for the "dowi" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_dowi_data
{
    bcmolt_status alarm_status; /**< Alarm status. */
    int32_t drift_value;        /**< Calculated amount of drift (positive + negative as a signed value). */
    uint32_t new_eqd;           /**< New EQD after drift is corrected (only valid if status is 'on'). */
} bcmolt_xgpon_onu_dowi_data;

/** Transport message definition for "dowi" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_dowi
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_xgpon_onu_key key;           /**< Object key. */
    bcmolt_xgpon_onu_dowi_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_dowi;

/** Structure definition for the "invalid_dbru_report" group of the "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_invalid_dbru_report_data
{
    bcmolt_xgpon_alloc_id alloc_id; /**< Alloc-ID. */
} bcmolt_xgpon_onu_invalid_dbru_report_data;

/** Transport message definition for "invalid_dbru_report" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_invalid_dbru_report
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_invalid_dbru_report_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_invalid_dbru_report;

/** Structure definition for the "key_exchange_completed" group of the 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_key_exchange_completed_data
{
    bcmolt_xgpon_onu_aes_key new_key;   /**< new key. */
} bcmolt_xgpon_onu_key_exchange_completed_data;

/** Transport message definition for "key_exchange_completed" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_key_exchange_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_key_exchange_completed_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_key_exchange_completed;

/** Transport message definition for "key_exchange_cycle_skipped" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_key_exchange_cycle_skipped
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
} bcmolt_xgpon_onu_key_exchange_cycle_skipped;

/** Structure definition for the "key_exchange_key_mismatch" group of the 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_key_exchange_key_mismatch_data
{
    bcmolt_aes_key expected_key;    /**< expected key. */
    bcmolt_aes_key received_key;    /**< received key. */
} bcmolt_xgpon_onu_key_exchange_key_mismatch_data;

/** Transport message definition for "key_exchange_key_mismatch" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_key_exchange_key_mismatch
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_key_exchange_key_mismatch_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_key_exchange_key_mismatch;

/** Transport message definition for "key_exchange_key_request_timeout" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_key_exchange_key_request_timeout
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
} bcmolt_xgpon_onu_key_exchange_key_request_timeout;

/** Structure definition for the "looci" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_looci_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_xgpon_onu_looci_data;

/** Transport message definition for "looci" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_looci
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_xgpon_onu_key key;           /**< Object key. */
    bcmolt_xgpon_onu_looci_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_looci;

/** Structure definition for the "onu_activation_completed" group of the 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_activation_completed_data
{
    bcmolt_result status;   /**< status. */
    bcmolt_activation_fail_reason fail_reason;  /**< fail reason. */
#define BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_DATA_REGISTRATION_ID_LEN  36
    bcmolt_arr_u8_36 registration_id;           /**< registration id. */
    bcmolt_xgpon_onu_registration_keys registration_encryption_keys;    /**< registration encryption keys. */
} bcmolt_xgpon_onu_onu_activation_completed_data;

/** Transport message definition for "onu_activation_completed" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_activation_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_onu_activation_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_onu_activation_completed;

/** Structure definition for the "onu_alarm" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_alarm_data
{
    bcmolt_xgpon_onu_alarms onu_alarm;  /**< onu alarm. */
} bcmolt_xgpon_onu_onu_alarm_data;

/** Transport message definition for "onu_alarm" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_alarm
{
    bcmolt_auto hdr;                        /**< Transport header. */
    bcmolt_xgpon_onu_key key;               /**< Object key. */
    bcmolt_xgpon_onu_onu_alarm_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_onu_alarm;

/** Structure definition for the "onu_deactivation_completed" group of the 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_deactivation_completed_data
{
    bcmolt_result status;   /**< Status. */
} bcmolt_xgpon_onu_onu_deactivation_completed_data;

/** Transport message definition for "onu_deactivation_completed" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_deactivation_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_onu_deactivation_completed_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_onu_deactivation_completed;

/** Structure definition for the "onu_disable_completed" group of the 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_disable_completed_data
{
    bcmolt_serial_number serial_number; /**< serial number. */
} bcmolt_xgpon_onu_onu_disable_completed_data;

/** Transport message definition for "onu_disable_completed" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_disable_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_onu_disable_completed_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_onu_disable_completed;

/** Structure definition for the "onu_enable_completed" group of the "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_onu_enable_completed_data
{
    bcmolt_serial_number serial_number; /**< serial number. */
} bcmolt_xgpon_onu_onu_enable_completed_data;

/** Transport message definition for "onu_enable_completed" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_onu_enable_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_onu_enable_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_onu_enable_completed;

/** Structure definition for the "onu_tuning_in_completed" group of the 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_tuning_in_completed_data
{
    bcmolt_result result;                   /**< result. */
    bcmolt_tune_in_fail_reason fail_reason; /**< fail reason. */
} bcmolt_xgpon_onu_onu_tuning_in_completed_data;

/** Transport message definition for "onu_tuning_in_completed" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_tuning_in_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_onu_tuning_in_completed_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_onu_tuning_in_completed;

/** Structure definition for the "onu_tuning_out_completed" group of the 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_tuning_out_completed_data
{
    bcmolt_result result;                       /**< result. */
    bcmolt_tune_out_fail_reason fail_reason;    /**< fail reason. */
} bcmolt_xgpon_onu_onu_tuning_out_completed_data;

/** Transport message definition for "onu_tuning_out_completed" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_onu_tuning_out_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_onu_tuning_out_completed_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_onu_tuning_out_completed;

/** Transport message definition for "optical_reflection" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_optical_reflection
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
} bcmolt_xgpon_onu_optical_reflection;

/** Structure definition for the "possible_drift" group of the "xgpon_onu" 
 * object. 
 *
 * An ONU in a low power state may be experiencing drift beyond the configured 
 * threshold. The estimate may be inaccurate depending on ONU behavior. Actual 
 * drift may be less than estimated. 
 */
typedef struct bcmolt_xgpon_onu_possible_drift_data
{
    bcmolt_status alarm_status; /**< On: estimated drift has exceeded the configured threshold. */
    int32_t estimated_drift;    /**< If status is on, the estimated drift value, otherwise zero (0). */
} bcmolt_xgpon_onu_possible_drift_data;

/** Transport message definition for "possible_drift" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_possible_drift
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_possible_drift_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_possible_drift;

/** Structure definition for the "power_consumption_report" group of the 
 * "xgpon_onu" object. 
 *
 * Power consumption report 
 */
typedef struct bcmolt_xgpon_onu_power_consumption_report_data
{
#define BCMOLT_XGPON_ONU_POWER_CONSUMPTION_REPORT_DATA_POWER_CONSUMPTION_REPORT_LEN 8
    bcmolt_arr_power_consumption_channel_report_8 power_consumption_report; /**< power consumption report. */
} bcmolt_xgpon_onu_power_consumption_report_data;

/** Transport message definition for "power_consumption_report" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_power_consumption_report
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_power_consumption_report_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_power_consumption_report;

/** Structure definition for the "power_level_report" group of the "xgpon_onu" 
 * object. 
 *
 * Power level report 
 */
typedef struct bcmolt_xgpon_onu_power_level_report_data
{
    uint8_t attenuation;                /**< Attenuation. */
    uint8_t power_levelling_capability; /**< Power levelling capability. */
} bcmolt_xgpon_onu_power_level_report_data;

/** Transport message definition for "power_level_report" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_power_level_report
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_power_level_report_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_power_level_report;

/** Structure definition for the "power_management_state_change" group of the 
 * "xgpon_onu" object. 
 *
 * Notification that an ONUs power management state has changed. 
 */
typedef struct bcmolt_xgpon_onu_power_management_state_change_data
{
    bcmolt_onu_state old_state; /**< The state the ONU was previously in. */
    bcmolt_onu_state new_state; /**< The state the ONU is currently in. */
    bcmolt_power_management_transition_reason reason;   /**< The reason for the state change. */
} bcmolt_xgpon_onu_power_management_state_change_data;

/** Transport message definition for "power_management_state_change" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_power_management_state_change
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_power_management_state_change_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_power_management_state_change;

/** Structure definition for the "pqsi" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_pqsi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_xgpon_onu_pqsi_data;

/** Transport message definition for "pqsi" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_pqsi
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_xgpon_onu_key key;           /**< Object key. */
    bcmolt_xgpon_onu_pqsi_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_pqsi;

/** Structure definition for the "ranging_completed" group of the "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_ranging_completed_data
{
    bcmolt_result status;                   /**< status. */
    bcmolt_ranging_fail_reason fail_reason; /**< fail reason. */
    uint32_t eqd;               /**< EQD. */
    uint8_t number_of_ploams;   /**< number of ploams. */
    uint8_t power_level;        /**< power level. */
} bcmolt_xgpon_onu_ranging_completed_data;

/** Transport message definition for "ranging_completed" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_ranging_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_ranging_completed_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_ranging_completed;

/** Structure definition for the "registration_id" group of the "xgpon_onu" 
 * object. 
 *
 * Registration ID 
 */
typedef struct bcmolt_xgpon_onu_registration_id_data
{
#define BCMOLT_XGPON_ONU_REGISTRATION_ID_DATA_REGISTRATION_ID_LEN   36
    bcmolt_arr_u8_36 registration_id;           /**< Registration ID. */
    bcmolt_result request_registration_status;  /**< request registration status. */
    bcmolt_request_registration_fail_reason request_registration_fail_reason;   /**< request registration fail reason. */
} bcmolt_xgpon_onu_registration_id_data;

/** Transport message definition for "registration_id" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_registration_id
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_registration_id_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_registration_id;

/** Structure definition for the "rssi_measurement_completed" group of the 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_rssi_measurement_completed_data
{
    bcmolt_result status;   /**< status. */
    bcmolt_rssi_measurement_fail_reason fail_reason;    /**< fail reason. */
} bcmolt_xgpon_onu_rssi_measurement_completed_data;

/** Transport message definition for "rssi_measurement_completed" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_rssi_measurement_completed
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_rssi_measurement_completed_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_rssi_measurement_completed;

/** Structure definition for the "sdi" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_sdi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
    uint32_t ber;               /**< Inverse bit error rate (e.g. if this number is 1000, the BER is 1/1000). */
} bcmolt_xgpon_onu_sdi_data;

/** Transport message definition for "sdi" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_sdi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_xgpon_onu_key key;       /**< Object key. */
    bcmolt_xgpon_onu_sdi_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_sdi;

/** Structure definition for the "secure_mutual_authentication_failure" group of 
 * the "xgpon_onu" object. 
 *
 * Failure of secure mutual authentication due to MIC error 
 */
typedef struct bcmolt_xgpon_onu_secure_mutual_authentication_failure_data
{
    bcmolt_result status;   /**< status. */
    bcmolt_secure_mutual_authentication_fail_reason fail_reason;    /**< secure mutual authentication fail reason. */
} bcmolt_xgpon_onu_secure_mutual_authentication_failure_data;

/** Transport message definition for "secure_mutual_authentication_failure" 
 * group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_secure_mutual_authentication_failure
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_secure_mutual_authentication_failure_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_secure_mutual_authentication_failure;

/** Structure definition for the "sfi" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_sfi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
    uint32_t ber;               /**< Inverse bit error rate (e.g. if this number is 1000, the BER is 1/1000). */
} bcmolt_xgpon_onu_sfi_data;

/** Transport message definition for "sfi" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_sfi
{
    bcmolt_auto hdr;                /**< Transport header. */
    bcmolt_xgpon_onu_key key;       /**< Object key. */
    bcmolt_xgpon_onu_sfi_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_sfi;

/** Structure definition for the "stat_alarm_cleared" group of the "xgpon_onu" 
 * object. 
 *
 * Sent when a configured statistic alarm condition is no longer met. 
 */
typedef struct bcmolt_xgpon_onu_stat_alarm_cleared_data
{
    bcmolt_xgpon_onu_stat_id stat;  /**< Statistic identifier. */
} bcmolt_xgpon_onu_stat_alarm_cleared_data;

/** Transport message definition for "stat_alarm_cleared" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_stat_alarm_cleared
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_stat_alarm_cleared_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_stat_alarm_cleared;

/** Structure definition for the "stat_alarm_raised" group of the "xgpon_onu" 
 * object. 
 *
 * Sent when a configured statistic alarm condition has been met. 
 */
typedef struct bcmolt_xgpon_onu_stat_alarm_raised_data
{
    bcmolt_xgpon_onu_stat_id stat;  /**< Statistic identifier. */
} bcmolt_xgpon_onu_stat_alarm_raised_data;

/** Transport message definition for "stat_alarm_raised" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_stat_alarm_raised
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_stat_alarm_raised_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_stat_alarm_raised;

/** Structure definition for the "sufi" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_sufi_data
{
    bcmolt_status alarm_status; /**< alarm status. */
} bcmolt_xgpon_onu_sufi_data;

/** Transport message definition for "sufi" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_sufi
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_xgpon_onu_key key;           /**< Object key. */
    bcmolt_xgpon_onu_sufi_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_sufi;

/** Structure definition for the "tiwi" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_tiwi_data
{
    bcmolt_status alarm_status; /**< Alarm status. */
    int32_t drift_value;        /**< Calculated amount of drift (positive + negative as a signed value). */
} bcmolt_xgpon_onu_tiwi_data;

/** Transport message definition for "tiwi" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_tiwi
{
    bcmolt_auto hdr;                    /**< Transport header. */
    bcmolt_xgpon_onu_key key;           /**< Object key. */
    bcmolt_xgpon_onu_tiwi_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_tiwi;

/** Structure definition for the "tuning_response" group of the "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_tuning_response_data
{
    bcmos_bool ack;         /**< is tuning response received with ack or nack */
    bcmolt_result result;   /**< result. */
} bcmolt_xgpon_onu_tuning_response_data;

/** Transport message definition for "tuning_response" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_tuning_response
{
    bcmolt_auto hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_tuning_response_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_tuning_response;

/** Structure definition for the "auto_cfg" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_auto_cfg_data
{
    bcmos_bool dfi;                     /**< If true, indications of type "dfi" will be generated. */
    bcmos_bool dgi;                     /**< If true, indications of type "dgi" will be generated. */
    bcmos_bool dowi;                    /**< If true, indications of type "dowi" will be generated. */
    bcmos_bool invalid_dbru_report;     /**< If true, indications of type "invalid_dbru_report" will be generated. */
    bcmos_bool key_exchange_completed;  /**< If true, indications of type "key_exchange_completed" will be generated. */
    bcmos_bool key_exchange_cycle_skipped;          /**< If true, indications of type "key_exchange_cycle_skipped" will be generated. */
    bcmos_bool key_exchange_key_mismatch;           /**< If true, indications of type "key_exchange_key_mismatch" will be generated. */
    bcmos_bool key_exchange_key_request_timeout;    /**< If true, indications of type "key_exchange_key_request_timeout" will be generated. */
    bcmos_bool looci;                       /**< If true, indications of type "looci" will be generated. */
    bcmos_bool onu_activation_completed;    /**< If true, indications of type "onu_activation_completed" will be generated. */
    bcmos_bool onu_alarm;                   /**< If true, indications of type "onu_alarm" will be generated. */
    bcmos_bool onu_deactivation_completed;  /**< If true, indications of type "onu_deactivation_completed" will be generated. */
    bcmos_bool onu_disable_completed;       /**< If true, indications of type "onu_disable_completed" will be generated. */
    bcmos_bool onu_enable_completed;        /**< If true, indications of type "onu_enable_completed" will be generated. */
    bcmos_bool onu_tuning_in_completed;     /**< If true, indications of type "onu_tuning_in_completed" will be generated. */
    bcmos_bool onu_tuning_out_completed;    /**< If true, indications of type "onu_tuning_out_completed" will be generated. */
    bcmos_bool optical_reflection;          /**< If true, indications of type "optical_reflection" will be generated. */
    bcmos_bool possible_drift;              /**< If true, indications of type "possible_drift" will be generated. */
    bcmos_bool power_consumption_report;    /**< If true, indications of type "power_consumption_report" will be generated. */
    bcmos_bool power_level_report;          /**< If true, indications of type "power_level_report" will be generated. */
    bcmos_bool power_management_state_change;   /**< If true, indications of type "power_management_state_change" will be generated. */
    bcmos_bool pqsi;                        /**< If true, indications of type "pqsi" will be generated. */
    bcmos_bool ranging_completed;           /**< If true, indications of type "ranging_completed" will be generated. */
    bcmos_bool registration_id;             /**< If true, indications of type "registration_id" will be generated. */
    bcmos_bool rssi_measurement_completed;  /**< If true, indications of type "rssi_measurement_completed" will be generated. */
    bcmos_bool sdi; /**< If true, indications of type "sdi" will be generated. */
    bcmos_bool secure_mutual_authentication_failure;    /**< If true, indications of type "secure_mutual_authentication_failure" will be generated. */
    bcmos_bool sfi;                 /**< If true, indications of type "sfi" will be generated. */
    bcmos_bool stat_alarm_cleared;  /**< If true, indications of type "stat_alarm_cleared" will be generated. */
    bcmos_bool stat_alarm_raised;   /**< If true, indications of type "stat_alarm_raised" will be generated. */
    bcmos_bool sufi;                /**< If true, indications of type "sufi" will be generated. */
    bcmos_bool tiwi;                /**< If true, indications of type "tiwi" will be generated. */
    bcmos_bool tuning_response;     /**< If true, indications of type "tuning_response" will be generated. */
} bcmolt_xgpon_onu_auto_cfg_data;

/** Transport message definition for "auto_cfg" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_auto_cfg
{
    bcmolt_auto_cfg hdr;        /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_auto_cfg_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_auto_cfg;

/** Structure definition for the "adjust_tx_wavelength" group of the "xgpon_onu" 
 * object. 
 *
 * Instruct the ONU to adjust its upstream transmitter wavelength 
 */
typedef struct bcmolt_xgpon_onu_adjust_tx_wavelength_data
{
    bcmolt_frequency_adjustment_direction frequency_adjustment_direction;   /**< Frequency adjustment direction. */
    uint8_t frequency_adjustment_size;  /**< The size of the frequency adjustment in units of 0.1GHz */
} bcmolt_xgpon_onu_adjust_tx_wavelength_data;

/** Transport message definition for "adjust_tx_wavelength" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_adjust_tx_wavelength
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_adjust_tx_wavelength_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_adjust_tx_wavelength;

/** Structure definition for the "change_power_levelling" group of the 
 * "xgpon_onu" object. 
 *
 * Change power levelling 
 */
typedef struct bcmolt_xgpon_onu_change_power_levelling_data
{
    bcmolt_power_levelling_control control; /**< control. */
    uint8_t attenuation;                    /**< The requested attenuation in steps of 3dB as part of power levelling instruction */
} bcmolt_xgpon_onu_change_power_levelling_data;

/** Transport message definition for "change_power_levelling" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_change_power_levelling
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_change_power_levelling_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_change_power_levelling;

/** Transport message definition for "get_power_consumption" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_get_power_consumption
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
} bcmolt_xgpon_onu_get_power_consumption;

/** Transport message definition for "get_power_level" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_get_power_level
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
} bcmolt_xgpon_onu_get_power_level;

/** Transport message definition for "onu_tuning_in" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_onu_tuning_in
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
} bcmolt_xgpon_onu_onu_tuning_in;

/** Structure definition for the "onu_tuning_out" group of the "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_onu_tuning_out_data
{
    bcmolt_pon_id target_ds_pon_id; /**< target ds pon id. */
    bcmolt_pon_id target_us_pon_id; /**< target us pon id. */
    uint32_t time_to_switch;        /**< Time to switch in ms */
    bcmos_bool rollback;            /**< rollback. */
    bcmolt_status status;           /**< on- to start tuning out off- to stop tuning out */
} bcmolt_xgpon_onu_onu_tuning_out_data;

/** Transport message definition for "onu_tuning_out" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_onu_tuning_out
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_onu_tuning_out_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_onu_tuning_out;

/** Structure definition for the "request_registration" group of the "xgpon_onu" 
 * object. 
 *
 * Request the ONU to send its Registration ID 
 */
typedef struct bcmolt_xgpon_onu_request_registration_data
{
    bcmos_bool sma_flag;    /**< Is the request registration process is part of the SMA process */
} bcmolt_xgpon_onu_request_registration_data;

/** Transport message definition for "request_registration" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_request_registration
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_request_registration_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_request_registration;

/** Transport message definition for "rssi_measurement" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_rssi_measurement
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
} bcmolt_xgpon_onu_rssi_measurement;

/** Structure definition for the "secure_mutual_authentication" group of the 
 * "xgpon_onu" object. 
 *
 * OMCI base secure mutual authentication 
 */
typedef struct bcmolt_xgpon_onu_secure_mutual_authentication_data
{
    bcmolt_aes_key master_key;          /**< master key. */
    bcmolt_u8_list_u32_max_2048 buffer; /**< OMCI data buffer. */
    uint32_t mic;                       /**< mic. */
} bcmolt_xgpon_onu_secure_mutual_authentication_data;

/** Transport message definition for "secure_mutual_authentication" group of 
 * "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_secure_mutual_authentication
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_secure_mutual_authentication_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_secure_mutual_authentication;

/** Structure definition for the "set_onu_state" group of the "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_set_onu_state_data
{
    bcmolt_onu_operation onu_state; /**< ONU state. */
} bcmolt_xgpon_onu_set_onu_state_data;

/** Transport message definition for "set_onu_state" group of "xgpon_onu" 
 * object. 
 */
typedef struct bcmolt_xgpon_onu_set_onu_state
{
    bcmolt_oper hdr;            /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_set_onu_state_data data;   /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_set_onu_state;

/** Structure definition for the "cpu_packets" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_cpu_packets_data
{
    bcmolt_packet_type packet_type;     /**< packet type. */
    bcmos_bool calc_crc;                /**< calc crc. */
    uint8_t number_of_packets;          /**< number of packets. */
    uint16_t packet_size;               /**< Single packet size. */
    bcmolt_u8_list_u32_max_2048 buffer; /**< buffer. */
} bcmolt_xgpon_onu_cpu_packets_data;

/** Transport message definition for "cpu_packets" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_cpu_packets
{
    bcmolt_proxy hdr;                       /**< Transport header. */
    bcmolt_xgpon_onu_key key;               /**< Object key. */
    bcmolt_xgpon_onu_cpu_packets_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_cpu_packets;

/** Structure definition for the "ploam_packet" group of the "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_ploam_packet_data
{
    bcmos_bool default_key; /**< default key. */
#define BCMOLT_XGPON_ONU_PLOAM_PACKET_DATA_PLOAM_LEN    40
    bcmolt_arr_u8_40 ploam; /**< ploam. */
} bcmolt_xgpon_onu_ploam_packet_data;

/** Transport message definition for "ploam_packet" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_ploam_packet
{
    bcmolt_proxy hdr;           /**< Transport header. */
    bcmolt_xgpon_onu_key key;   /**< Object key. */
    bcmolt_xgpon_onu_ploam_packet_data data;    /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_ploam_packet;

/** Structure definition for the "cpu_packet" group of the "xgpon_onu" object. 
 *
 * Indicates CPU packet was received on the US from this ONU id 
 */
typedef struct bcmolt_xgpon_onu_cpu_packet_data
{
    uint16_t port_id;           /**< port id. */
    bcmos_bool crc_ok;          /**< crc ok. */
    uint32_t packet_size;       /**< packet size. */
    bcmolt_u8_list_u32 buffer;  /**< buffer. */
} bcmolt_xgpon_onu_cpu_packet_data;

/** Transport message definition for "cpu_packet" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_cpu_packet
{
    bcmolt_proxy_rx hdr;                    /**< Transport header. */
    bcmolt_xgpon_onu_key key;               /**< Object key. */
    bcmolt_xgpon_onu_cpu_packet_data data;  /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_cpu_packet;

/** Structure definition for the "omci_packet" group of the "xgpon_onu" object. 
 *
 * Indicates OMCI packet was received on the US from this ONU id 
 */
typedef struct bcmolt_xgpon_onu_omci_packet_data
{
    uint16_t port_id;           /**< port id. */
    bcmos_bool crc_ok;          /**< crc ok. */
    uint32_t packet_size;       /**< packet size. */
    bcmolt_u8_list_u32 buffer;  /**< buffer. */
} bcmolt_xgpon_onu_omci_packet_data;

/** Transport message definition for "omci_packet" group of "xgpon_onu" object. 
 */
typedef struct bcmolt_xgpon_onu_omci_packet
{
    bcmolt_proxy_rx hdr;                    /**< Transport header. */
    bcmolt_xgpon_onu_key key;               /**< Object key. */
    bcmolt_xgpon_onu_omci_packet_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_onu_omci_packet;

/** Structure definition for the "key" group of the "xgpon_trx" object. 
 */
typedef struct bcmolt_xgpon_trx_key
{
    bcmolt_xgpon_ni pon_ni; /**< PON network interface. */
} bcmolt_xgpon_trx_key;

/** Structure definition for the "cfg" group of the "xgpon_trx" object. 
 */
typedef struct bcmolt_xgpon_trx_cfg_data
{
#define BCMOLT_XGPON_TRX_CFG_DATA_BURST_PROFILE_LEN 4
    bcmolt_arr_xgpon_burst_profile_4 burst_profile;             /**< burst profile. */
#define BCMOLT_XGPON_TRX_CFG_DATA_TRANSCEIVER_CONFIG_LEN    4
    bcmolt_arr_xgpon_trx_configuration_4 transceiver_config;    /**< transceiver config. */
    bcmolt_xgpon_trx_type transceiver_type;                     /**< trx type. */
    bcmolt_xgpon_trx_debug debug;                       /**< debug. */
    bcmolt_xgpon_rssi_normal_config rssi_normal_config; /**< rssi normal config. */
    bcmolt_xgpon_rssi_ranging_config rssi_ranging_config;               /**< rssi ranging config. */
    bcmolt_xgpon_serdes_configuration serdes_configuration;             /**< serdes configuration. */
#define BCMOLT_XGPON_TRX_CFG_DATA_BURST_PROFILE_DELIMITER_MAX_ERRORS_LEN    4
    bcmolt_arr_u8_4 burst_profile_delimiter_max_errors;                 /**< burst profile delimiter max errors. */
    bcmolt_xgpon_rx_ranging_sm_pattern ranging_sm_patterns_at_init;     /**< Reset patterns used at Init of Ranging-Window and after Access */
    bcmolt_xgpon_rx_ranging_sm_pattern ranging_sm_patterns_ed_failure;  /**< ranging sm patterns ED failure. */
    bcmos_bool reset_on_del_miss;   /**< reset on del miss. */
    bcmolt_xgpon_ed_state ed_state; /**< ed state. */
    bcmos_bool invert_ed;           /**< invert ED. */
    bcmos_bool end_of_burst_reset;  /**< end of burst reset. */
    bcmos_bool trx_rst_polarity;    /**< TRX reset polarity. */
} bcmolt_xgpon_trx_cfg_data;

/** Transport message definition for "cfg" group of "xgpon_trx" object. 
 */
typedef struct bcmolt_xgpon_trx_cfg
{
    bcmolt_cfg hdr;                 /**< Transport header. */
    bcmolt_xgpon_trx_key key;       /**< Object key. */
    bcmolt_xgpon_trx_cfg_data data; /**< All properties that must be set by the user. */
} bcmolt_xgpon_trx_cfg;

/** Structure definition for the "key" group of the "xpon_serdes" object. 
 */
typedef struct bcmolt_xpon_serdes_key
{
    bcmolt_pon_ni pon_ni;               /**< PON NI. */
    bcmolt_serdes_instance instance;    /**< SerDes instance: */
} bcmolt_xpon_serdes_key;

/** Structure definition for the "cfg" group of the "xpon_serdes" object. 
 */
typedef struct bcmolt_xpon_serdes_cfg_data
{
    uint8_t rx_vga;     /**< Rx Vga. */
    uint8_t rx_pf;      /**< Peaking Filter */
    uint8_t rx_lfpf;    /**< Low Frequency Peaking Filter */
    uint8_t rx_dfe1;    /**< Rx DFE1. */
    int8_t rx_dfe2;     /**< Rx DFE2. */
    int8_t rx_dfe3;     /**< Rx DFE3. */
    int8_t rx_dfe4;     /**< Rx DFE4. */
    int8_t rx_dfe5;     /**< Rx DFE5. */
    uint8_t tx_pre;     /**< Tx Pre. */
    uint8_t tx_main;    /**< Tx Main. */
    uint8_t tx_post1;   /**< Tx Post1. */
    int8_t tx_post2;    /**< Tx Post2. */
    int8_t tx_post3;    /**< Tx Post3. */
    uint8_t tx_amp;     /**< Tx Amp. */
} bcmolt_xpon_serdes_cfg_data;

/** Transport message definition for "cfg" group of "xpon_serdes" object. 
 */
typedef struct bcmolt_xpon_serdes_cfg
{
    bcmolt_cfg hdr;                     /**< Transport header. */
    bcmolt_xpon_serdes_key key;         /**< Object key. */
    bcmolt_xpon_serdes_cfg_data data;   /**< All properties that must be set by the user. */
} bcmolt_xpon_serdes_cfg;

/** @} */

/** Packs a bcmolt_activation_fail_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_activation_fail_reason_pack(bcmolt_activation_fail_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_activation_fail_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_activation_fail_reason_unpack(bcmolt_activation_fail_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_additional_bw_eligibility to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_additional_bw_eligibility_pack(bcmolt_additional_bw_eligibility this, bcmolt_buf *buf);

/** Unpacks a bcmolt_additional_bw_eligibility from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_additional_bw_eligibility_unpack(bcmolt_additional_bw_eligibility *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_ni_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_ni_cfg_id_pack(bcmolt_ae_ni_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_ni_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_ni_cfg_id_unpack(bcmolt_ae_ni_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_ni_en_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_ni_en_state_pack(bcmolt_ae_ni_en_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_ni_en_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_ni_en_state_unpack(bcmolt_ae_ni_en_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_ni_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_ni_key_id_pack(bcmolt_ae_ni_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_ni_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_ni_key_id_unpack(bcmolt_ae_ni_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_ni_set_ae_ni_en_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_ni_set_ae_ni_en_state_id_pack(bcmolt_ae_ni_set_ae_ni_en_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_ni_set_ae_ni_en_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_ni_set_ae_ni_en_state_id_unpack(bcmolt_ae_ni_set_ae_ni_en_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_ds_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_auto_cfg_id_pack(bcmolt_ae_path_ds_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_ds_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_auto_cfg_id_unpack(bcmolt_ae_path_ds_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_ds_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_key_id_pack(bcmolt_ae_path_ds_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_ds_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_key_id_unpack(bcmolt_ae_path_ds_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_ds_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_stat_alarm_cleared_id_pack(bcmolt_ae_path_ds_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_ds_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_stat_alarm_cleared_id_unpack(bcmolt_ae_path_ds_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_ds_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_stat_alarm_raised_id_pack(bcmolt_ae_path_ds_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_ds_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_stat_alarm_raised_id_unpack(bcmolt_ae_path_ds_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_ds_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_stat_cfg_id_pack(bcmolt_ae_path_ds_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_ds_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_stat_cfg_id_unpack(bcmolt_ae_path_ds_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_ds_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_stat_id_pack(bcmolt_ae_path_ds_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_ds_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_ds_stat_id_unpack(bcmolt_ae_path_ds_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_us_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_us_auto_cfg_id_pack(bcmolt_ae_path_us_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_us_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_us_auto_cfg_id_unpack(bcmolt_ae_path_us_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_us_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_us_key_id_pack(bcmolt_ae_path_us_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_us_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_us_key_id_unpack(bcmolt_ae_path_us_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_us_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_us_stat_alarm_cleared_id_pack(bcmolt_ae_path_us_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_us_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_us_stat_alarm_cleared_id_unpack(bcmolt_ae_path_us_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_us_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_us_stat_alarm_raised_id_pack(bcmolt_ae_path_us_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_us_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_us_stat_alarm_raised_id_unpack(bcmolt_ae_path_us_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_us_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_us_stat_cfg_id_pack(bcmolt_ae_path_us_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_us_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_us_stat_cfg_id_unpack(bcmolt_ae_path_us_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ae_path_us_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ae_path_us_stat_id_pack(bcmolt_ae_path_us_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ae_path_us_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ae_path_us_stat_id_unpack(bcmolt_ae_path_us_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_alloc_operation to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_alloc_operation_pack(bcmolt_alloc_operation this, bcmolt_buf *buf);

/** Unpacks a bcmolt_alloc_operation from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_alloc_operation_unpack(bcmolt_alloc_operation *this, bcmolt_buf *buf);

/** Packs a bcmolt_alloc_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_alloc_state_pack(bcmolt_alloc_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_alloc_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_alloc_state_unpack(bcmolt_alloc_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_alloc_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_alloc_type_pack(bcmolt_alloc_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_alloc_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_alloc_type_unpack(bcmolt_alloc_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_alloc_type_to_scan to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_alloc_type_to_scan_pack(bcmolt_alloc_type_to_scan this, bcmolt_buf *buf);

/** Unpacks a bcmolt_alloc_type_to_scan from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_alloc_type_to_scan_unpack(bcmolt_alloc_type_to_scan *this, bcmolt_buf *buf);

/** Packs a bcmolt_api_capture_buffer_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_api_capture_buffer_mode_pack(bcmolt_api_capture_buffer_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_api_capture_buffer_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_api_capture_buffer_mode_unpack(bcmolt_api_capture_buffer_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_api_capture_location to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_api_capture_location_pack(bcmolt_api_capture_location this, bcmolt_buf *buf);

/** Unpacks a bcmolt_api_capture_location from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_api_capture_location_unpack(bcmolt_api_capture_location *this, bcmolt_buf *buf);

/** Packs a bcmolt_calibration_record to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_calibration_record_pack(bcmolt_calibration_record this, bcmolt_buf *buf);

/** Unpacks a bcmolt_calibration_record from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_calibration_record_unpack(bcmolt_calibration_record *this, bcmolt_buf *buf);

/** Packs a bcmolt_sign to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_sign_pack(bcmolt_sign this, bcmolt_buf *buf);

/** Unpacks a bcmolt_sign from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_sign_unpack(bcmolt_sign *this, bcmolt_buf *buf);

/** Packs a bcmolt_upstream_line_rate_capabilities to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_upstream_line_rate_capabilities_pack(bcmolt_upstream_line_rate_capabilities this, bcmolt_buf *buf);

/** Unpacks a bcmolt_upstream_line_rate_capabilities from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_upstream_line_rate_capabilities_unpack(bcmolt_upstream_line_rate_capabilities *this, bcmolt_buf *buf);

/** Packs a bcmolt_link_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_link_type_pack(bcmolt_link_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_link_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_link_type_unpack(bcmolt_link_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_capture_strobe_signal to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_capture_strobe_signal_pack(bcmolt_capture_strobe_signal this, bcmolt_buf *buf);

/** Unpacks a bcmolt_capture_strobe_signal from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_capture_strobe_signal_unpack(bcmolt_capture_strobe_signal *this, bcmolt_buf *buf);

/** Packs a bcmolt_channel_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_channel_cfg_id_pack(bcmolt_channel_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_channel_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_channel_cfg_id_unpack(bcmolt_channel_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_channel_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_channel_key_id_pack(bcmolt_channel_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_channel_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_channel_key_id_unpack(bcmolt_channel_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_console_redirection to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_console_redirection_pack(bcmolt_console_redirection this, bcmolt_buf *buf);

/** Unpacks a bcmolt_console_redirection from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_console_redirection_unpack(bcmolt_console_redirection *this, bcmolt_buf *buf);

/** Packs a bcmolt_control_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_control_state_pack(bcmolt_control_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_control_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_control_state_unpack(bcmolt_control_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_dba_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_dba_mode_pack(bcmolt_dba_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_dba_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_dba_mode_unpack(bcmolt_dba_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_dba_ram to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_dba_ram_pack(bcmolt_dba_ram this, bcmolt_buf *buf);

/** Unpacks a bcmolt_dba_ram from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_dba_ram_unpack(bcmolt_dba_ram *this, bcmolt_buf *buf);

/** Packs a bcmolt_dba_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_dba_type_pack(bcmolt_dba_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_dba_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_dba_type_unpack(bcmolt_dba_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_ddr_test_status to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ddr_test_status_pack(bcmolt_ddr_test_status this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ddr_test_status from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ddr_test_status_unpack(bcmolt_ddr_test_status *this, bcmolt_buf *buf);

/** Packs a bcmolt_ddr_test_result to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ddr_test_result_pack(bcmolt_ddr_test_result this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ddr_test_result from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ddr_test_result_unpack(bcmolt_ddr_test_result *this, bcmolt_buf *buf);

/** Packs a bcmolt_host_connection_fail_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_host_connection_fail_reason_pack(bcmolt_host_connection_fail_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_host_connection_fail_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_host_connection_fail_reason_unpack(bcmolt_host_connection_fail_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_deactivation_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_deactivation_reason_pack(bcmolt_deactivation_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_deactivation_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_deactivation_reason_unpack(bcmolt_deactivation_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_debug_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_debug_auto_cfg_id_pack(bcmolt_debug_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_debug_auto_cfg_id_unpack(bcmolt_debug_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_debug_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_debug_cfg_id_pack(bcmolt_debug_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_debug_cfg_id_unpack(bcmolt_debug_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_debug_cli_input_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_debug_cli_input_id_pack(bcmolt_debug_cli_input_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_cli_input_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_debug_cli_input_id_unpack(bcmolt_debug_cli_input_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_debug_cli_output_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_debug_cli_output_id_pack(bcmolt_debug_cli_output_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_cli_output_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_debug_cli_output_id_unpack(bcmolt_debug_cli_output_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_debug_file_almost_full_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_debug_file_almost_full_id_pack(bcmolt_debug_file_almost_full_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_file_almost_full_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_debug_file_almost_full_id_unpack(bcmolt_debug_file_almost_full_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_debug_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_debug_key_id_pack(bcmolt_debug_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_debug_key_id_unpack(bcmolt_debug_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_debug_reset_api_capture_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_debug_reset_api_capture_id_pack(bcmolt_debug_reset_api_capture_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_reset_api_capture_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_debug_reset_api_capture_id_unpack(bcmolt_debug_reset_api_capture_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_debug_start_api_capture_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_debug_start_api_capture_id_pack(bcmolt_debug_start_api_capture_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_start_api_capture_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_debug_start_api_capture_id_unpack(bcmolt_debug_start_api_capture_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_debug_stop_api_capture_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_debug_stop_api_capture_id_pack(bcmolt_debug_stop_api_capture_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_stop_api_capture_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_debug_stop_api_capture_id_unpack(bcmolt_debug_stop_api_capture_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_auto_cfg_id_pack(bcmolt_device_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_auto_cfg_id_unpack(bcmolt_device_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_cfg_id_pack(bcmolt_device_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_cfg_id_unpack(bcmolt_device_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_chip_revision to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_chip_revision_pack(bcmolt_device_chip_revision this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_chip_revision from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_chip_revision_unpack(bcmolt_device_chip_revision *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_connect_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_connect_id_pack(bcmolt_device_connect_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_connect_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_connect_id_unpack(bcmolt_device_connect_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_connection_complete_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_connection_complete_id_pack(bcmolt_device_connection_complete_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_connection_complete_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_connection_complete_id_unpack(bcmolt_device_connection_complete_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_connection_established_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_connection_established_id_pack(bcmolt_device_connection_established_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_connection_established_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_connection_established_id_unpack(bcmolt_device_connection_established_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_connection_failure_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_connection_failure_id_pack(bcmolt_device_connection_failure_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_connection_failure_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_connection_failure_id_unpack(bcmolt_device_connection_failure_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_ddr_test_complete_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_ddr_test_complete_id_pack(bcmolt_device_ddr_test_complete_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_ddr_test_complete_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_ddr_test_complete_id_unpack(bcmolt_device_ddr_test_complete_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_device_keep_alive_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_device_keep_alive_id_pack(bcmolt_device_device_keep_alive_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_device_keep_alive_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_device_keep_alive_id_unpack(bcmolt_device_device_keep_alive_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_device_ready_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_device_ready_id_pack(bcmolt_device_device_ready_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_device_ready_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_device_ready_id_unpack(bcmolt_device_device_ready_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_disconnect_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_disconnect_id_pack(bcmolt_device_disconnect_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_disconnect_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_disconnect_id_unpack(bcmolt_device_disconnect_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_disconnection_complete_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_disconnection_complete_id_pack(bcmolt_device_disconnection_complete_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_disconnection_complete_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_disconnection_complete_id_unpack(bcmolt_device_disconnection_complete_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_host_keep_alive_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_host_keep_alive_id_pack(bcmolt_device_host_keep_alive_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_host_keep_alive_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_host_keep_alive_id_unpack(bcmolt_device_host_keep_alive_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_image_transfer_complete_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_image_transfer_complete_id_pack(bcmolt_device_image_transfer_complete_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_image_transfer_complete_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_image_transfer_complete_id_unpack(bcmolt_device_image_transfer_complete_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_image_transfer_data_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_image_transfer_data_id_pack(bcmolt_device_image_transfer_data_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_image_transfer_data_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_image_transfer_data_id_unpack(bcmolt_device_image_transfer_data_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_image_transfer_start_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_image_transfer_start_id_pack(bcmolt_device_image_transfer_start_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_image_transfer_start_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_image_transfer_start_id_unpack(bcmolt_device_image_transfer_start_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_image_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_image_type_pack(bcmolt_device_image_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_image_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_image_type_unpack(bcmolt_device_image_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_indications_dropped_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_indications_dropped_id_pack(bcmolt_device_indications_dropped_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_indications_dropped_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_indications_dropped_id_unpack(bcmolt_device_indications_dropped_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_key_id_pack(bcmolt_device_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_key_id_unpack(bcmolt_device_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_speed to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_speed_pack(bcmolt_nni_speed this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_speed from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_speed_unpack(bcmolt_nni_speed *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_reset_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_reset_id_pack(bcmolt_device_reset_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_reset_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_reset_id_unpack(bcmolt_device_reset_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_reset_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_reset_mode_pack(bcmolt_device_reset_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_reset_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_reset_mode_unpack(bcmolt_device_reset_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_run_ddr_test_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_run_ddr_test_id_pack(bcmolt_device_run_ddr_test_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_run_ddr_test_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_run_ddr_test_id_unpack(bcmolt_device_run_ddr_test_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_state_pack(bcmolt_device_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_state_unpack(bcmolt_device_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_sw_error_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_sw_error_id_pack(bcmolt_device_sw_error_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_sw_error_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_sw_error_id_unpack(bcmolt_device_sw_error_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_sw_exception_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_sw_exception_id_pack(bcmolt_device_sw_exception_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_sw_exception_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_sw_exception_id_unpack(bcmolt_device_sw_exception_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_device_sw_upgrade_activate_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_device_sw_upgrade_activate_id_pack(bcmolt_device_sw_upgrade_activate_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_sw_upgrade_activate_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_device_sw_upgrade_activate_id_unpack(bcmolt_device_sw_upgrade_activate_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_disable_serial_number_control to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_disable_serial_number_control_pack(bcmolt_disable_serial_number_control this, bcmolt_buf *buf);

/** Unpacks a bcmolt_disable_serial_number_control from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_disable_serial_number_control_unpack(bcmolt_disable_serial_number_control *this, bcmolt_buf *buf);

/** Packs a bcmolt_drv_icf_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_drv_icf_id_pack(bcmolt_drv_icf_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_drv_icf_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_drv_icf_id_unpack(bcmolt_drv_icf_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_drv_sgb_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_drv_sgb_id_pack(bcmolt_drv_sgb_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_drv_sgb_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_drv_sgb_id_unpack(bcmolt_drv_sgb_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ds_vlan_action to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ds_vlan_action_pack(bcmolt_ds_vlan_action this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ds_vlan_action from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ds_vlan_action_unpack(bcmolt_ds_vlan_action *this, bcmolt_buf *buf);

/** Packs a bcmolt_tfb_trap_behavior to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_tfb_trap_behavior_pack(bcmolt_tfb_trap_behavior this, bcmolt_buf *buf);

/** Unpacks a bcmolt_tfb_trap_behavior from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_tfb_trap_behavior_unpack(bcmolt_tfb_trap_behavior *this, bcmolt_buf *buf);

/** Packs a bcmolt_tfb_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_tfb_mode_pack(bcmolt_tfb_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_tfb_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_tfb_mode_unpack(bcmolt_tfb_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_lim_sec_mode_up to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_lim_sec_mode_up_pack(bcmolt_lim_sec_mode_up this, bcmolt_buf *buf);

/** Unpacks a bcmolt_lim_sec_mode_up from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_lim_sec_mode_up_unpack(bcmolt_lim_sec_mode_up *this, bcmolt_buf *buf);

/** Packs a bcmolt_lim_sec_mode_dn to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_lim_sec_mode_dn_pack(bcmolt_lim_sec_mode_dn this, bcmolt_buf *buf);

/** Unpacks a bcmolt_lim_sec_mode_dn from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_lim_sec_mode_dn_unpack(bcmolt_lim_sec_mode_dn *this, bcmolt_buf *buf);

/** Packs a bcmolt_xim_sec_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xim_sec_mode_pack(bcmolt_xim_sec_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xim_sec_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xim_sec_mode_unpack(bcmolt_xim_sec_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_hsc_ram to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_hsc_ram_pack(bcmolt_hsc_ram this, bcmolt_buf *buf);

/** Unpacks a bcmolt_hsc_ram from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_hsc_ram_unpack(bcmolt_hsc_ram *this, bcmolt_buf *buf);

/** Packs a bcmolt_lim_ram to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_lim_ram_pack(bcmolt_lim_ram this, bcmolt_buf *buf);

/** Unpacks a bcmolt_lim_ram from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_lim_ram_unpack(bcmolt_lim_ram *this, bcmolt_buf *buf);

/** Packs a bcmolt_lky_ram to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_lky_ram_pack(bcmolt_lky_ram this, bcmolt_buf *buf);

/** Unpacks a bcmolt_lky_ram from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_lky_ram_unpack(bcmolt_lky_ram *this, bcmolt_buf *buf);

/** Packs a bcmolt_mic_ram to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_mic_ram_pack(bcmolt_mic_ram this, bcmolt_buf *buf);

/** Unpacks a bcmolt_mic_ram from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_mic_ram_unpack(bcmolt_mic_ram *this, bcmolt_buf *buf);

/** Packs a bcmolt_xpcsrm_ram to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xpcsrm_ram_pack(bcmolt_xpcsrm_ram this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xpcsrm_ram from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xpcsrm_ram_unpack(bcmolt_xpcsrm_ram *this, bcmolt_buf *buf);

/** Packs a bcmolt_embedded_image_transfer_status to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_embedded_image_transfer_status_pack(bcmolt_embedded_image_transfer_status this, bcmolt_buf *buf);

/** Unpacks a bcmolt_embedded_image_transfer_status from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_embedded_image_transfer_status_unpack(bcmolt_embedded_image_transfer_status *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_encryption_information_format to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_encryption_information_format_pack(bcmolt_epon_encryption_information_format this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_encryption_information_format from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_encryption_information_format_unpack(bcmolt_epon_encryption_information_format *this, bcmolt_buf *buf);

/** Packs a bcmolt_energy_detect_source to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_energy_detect_source_pack(bcmolt_energy_detect_source this, bcmolt_buf *buf);

/** Unpacks a bcmolt_energy_detect_source from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_energy_detect_source_unpack(bcmolt_energy_detect_source *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_1g_turbo_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_1g_turbo_mode_pack(bcmolt_epon_1g_turbo_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_1g_turbo_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_1g_turbo_mode_unpack(bcmolt_epon_1g_turbo_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_clock_transport_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_clock_transport_mode_pack(bcmolt_epon_clock_transport_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_clock_transport_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_clock_transport_mode_unpack(bcmolt_epon_clock_transport_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_dba_reporting_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_dba_reporting_mode_pack(bcmolt_epon_dba_reporting_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_dba_reporting_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_dba_reporting_mode_unpack(bcmolt_epon_dba_reporting_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_rate to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_rate_pack(bcmolt_epon_link_rate this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_rate from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_rate_unpack(bcmolt_epon_link_rate *this, bcmolt_buf *buf);

/** Packs a bcmolt_status to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_status_pack(bcmolt_status this, bcmolt_buf *buf);

/** Unpacks a bcmolt_status from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_status_unpack(bcmolt_status *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_auto_cfg_id_pack(bcmolt_epon_denied_link_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_auto_cfg_id_unpack(bcmolt_epon_denied_link_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_cfg_id_pack(bcmolt_epon_denied_link_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_cfg_id_unpack(bcmolt_epon_denied_link_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_key_id_pack(bcmolt_epon_denied_link_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_key_id_unpack(bcmolt_epon_denied_link_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_laser_on_off_violation_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_laser_on_off_violation_id_pack(bcmolt_epon_denied_link_laser_on_off_violation_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_laser_on_off_violation_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_laser_on_off_violation_id_unpack(bcmolt_epon_denied_link_laser_on_off_violation_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_llid_pool_empty_violation_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_llid_pool_empty_violation_id_pack(bcmolt_epon_denied_link_llid_pool_empty_violation_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_llid_pool_empty_violation_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_llid_pool_empty_violation_id_unpack(bcmolt_epon_denied_link_llid_pool_empty_violation_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_max_link_violation_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_max_link_violation_id_pack(bcmolt_epon_denied_link_max_link_violation_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_max_link_violation_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_max_link_violation_id_unpack(bcmolt_epon_denied_link_max_link_violation_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_overhead_profile_violation_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_overhead_profile_violation_id_pack(bcmolt_epon_denied_link_overhead_profile_violation_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_overhead_profile_violation_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_overhead_profile_violation_id_unpack(bcmolt_epon_denied_link_overhead_profile_violation_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_range_violation_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_range_violation_id_pack(bcmolt_epon_denied_link_range_violation_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_range_violation_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_range_violation_id_unpack(bcmolt_epon_denied_link_range_violation_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_rogue_violation_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_rogue_violation_id_pack(bcmolt_epon_denied_link_rogue_violation_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_rogue_violation_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_rogue_violation_id_unpack(bcmolt_epon_denied_link_rogue_violation_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_system_resource_violation_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_system_resource_violation_id_pack(bcmolt_epon_denied_link_system_resource_violation_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_system_resource_violation_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_system_resource_violation_id_unpack(bcmolt_epon_denied_link_system_resource_violation_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_tdm_channels_exhausted_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_tdm_channels_exhausted_id_pack(bcmolt_epon_denied_link_tdm_channels_exhausted_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_tdm_channels_exhausted_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_tdm_channels_exhausted_id_unpack(bcmolt_epon_denied_link_tdm_channels_exhausted_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_unknown_link_violation_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_unknown_link_violation_id_pack(bcmolt_epon_denied_link_unknown_link_violation_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_unknown_link_violation_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_unknown_link_violation_id_unpack(bcmolt_epon_denied_link_unknown_link_violation_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_denied_link_upstream_bandwidth_violation_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_upstream_bandwidth_violation_id_pack(bcmolt_epon_denied_link_upstream_bandwidth_violation_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_upstream_bandwidth_violation_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_denied_link_upstream_bandwidth_violation_id_unpack(bcmolt_epon_denied_link_upstream_bandwidth_violation_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_encryption_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_encryption_mode_pack(bcmolt_epon_encryption_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_encryption_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_encryption_mode_unpack(bcmolt_epon_encryption_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_key_choice to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_key_choice_pack(bcmolt_epon_key_choice this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_key_choice from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_key_choice_unpack(bcmolt_epon_key_choice *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_encryption_direction to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_encryption_direction_pack(bcmolt_epon_encryption_direction this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_encryption_direction from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_encryption_direction_unpack(bcmolt_epon_encryption_direction *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_fec_en_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_fec_en_state_pack(bcmolt_epon_fec_en_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_fec_en_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_fec_en_state_unpack(bcmolt_epon_fec_en_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_oam_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_oam_type_pack(bcmolt_epon_oam_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_oam_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_oam_type_unpack(bcmolt_epon_oam_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_auto_cfg_id_pack(bcmolt_epon_link_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_auto_cfg_id_unpack(bcmolt_epon_link_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_cfg_id_pack(bcmolt_epon_link_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_cfg_id_unpack(bcmolt_epon_link_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_delete_link_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_delete_link_id_pack(bcmolt_epon_link_delete_link_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_delete_link_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_delete_link_id_unpack(bcmolt_epon_link_delete_link_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_duplicate_mpcp_registration_request_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_duplicate_mpcp_registration_request_id_pack(bcmolt_epon_link_duplicate_mpcp_registration_request_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_duplicate_mpcp_registration_request_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_duplicate_mpcp_registration_request_id_unpack(bcmolt_epon_link_duplicate_mpcp_registration_request_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_encryption_enabled_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_encryption_enabled_id_pack(bcmolt_epon_link_encryption_enabled_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_encryption_enabled_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_encryption_enabled_id_unpack(bcmolt_epon_link_encryption_enabled_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_fec_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_fec_state_pack(bcmolt_epon_link_fec_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_fec_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_fec_state_unpack(bcmolt_epon_link_fec_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_force_rediscovery_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_force_rediscovery_id_pack(bcmolt_epon_link_force_rediscovery_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_force_rediscovery_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_force_rediscovery_id_unpack(bcmolt_epon_link_force_rediscovery_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_frame_captured_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_frame_captured_id_pack(bcmolt_epon_link_frame_captured_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_frame_captured_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_frame_captured_id_unpack(bcmolt_epon_link_frame_captured_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_status to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_status_pack(bcmolt_epon_link_status this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_status from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_status_unpack(bcmolt_epon_link_status *this, bcmolt_buf *buf);

/** Packs a bcmolt_mpcp_discovery_info to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_mpcp_discovery_info_pack(bcmolt_mpcp_discovery_info this, bcmolt_buf *buf);

/** Unpacks a bcmolt_mpcp_discovery_info from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_mpcp_discovery_info_unpack(bcmolt_mpcp_discovery_info *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_inject_frame_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_inject_frame_id_pack(bcmolt_epon_link_inject_frame_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_inject_frame_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_inject_frame_id_unpack(bcmolt_epon_link_inject_frame_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_key_exchange_failure_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_failure_id_pack(bcmolt_epon_link_key_exchange_failure_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_key_exchange_failure_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_failure_id_unpack(bcmolt_epon_link_key_exchange_failure_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_key_exchange_start_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_start_id_pack(bcmolt_epon_link_key_exchange_start_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_key_exchange_start_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_start_id_unpack(bcmolt_epon_link_key_exchange_start_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_key_exchange_started_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_started_id_pack(bcmolt_epon_link_key_exchange_started_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_key_exchange_started_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_started_id_unpack(bcmolt_epon_link_key_exchange_started_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_key_exchange_stop_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_stop_id_pack(bcmolt_epon_link_key_exchange_stop_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_key_exchange_stop_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_stop_id_unpack(bcmolt_epon_link_key_exchange_stop_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_key_exchange_stopped_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_stopped_id_pack(bcmolt_epon_link_key_exchange_stopped_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_key_exchange_stopped_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_key_exchange_stopped_id_unpack(bcmolt_epon_link_key_exchange_stopped_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_key_id_pack(bcmolt_epon_link_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_key_id_unpack(bcmolt_epon_link_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_link_deleted_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_link_deleted_id_pack(bcmolt_epon_link_link_deleted_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_link_deleted_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_link_deleted_id_unpack(bcmolt_epon_link_link_deleted_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_link_speed_mismatch_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_link_speed_mismatch_id_pack(bcmolt_epon_link_link_speed_mismatch_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_link_speed_mismatch_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_link_speed_mismatch_id_unpack(bcmolt_epon_link_link_speed_mismatch_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_mpcp_deregistered_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_mpcp_deregistered_id_pack(bcmolt_epon_link_mpcp_deregistered_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_mpcp_deregistered_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_mpcp_deregistered_id_unpack(bcmolt_epon_link_mpcp_deregistered_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_mpcp_discovered_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_mpcp_discovered_id_pack(bcmolt_epon_link_mpcp_discovered_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_mpcp_discovered_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_mpcp_discovered_id_unpack(bcmolt_epon_link_mpcp_discovered_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_mpcp_reg_ack_timeout_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_mpcp_reg_ack_timeout_id_pack(bcmolt_epon_link_mpcp_reg_ack_timeout_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_mpcp_reg_ack_timeout_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_mpcp_reg_ack_timeout_id_unpack(bcmolt_epon_link_mpcp_reg_ack_timeout_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_mpcp_report_timeout_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_mpcp_report_timeout_id_pack(bcmolt_epon_link_mpcp_report_timeout_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_mpcp_report_timeout_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_mpcp_report_timeout_id_unpack(bcmolt_epon_link_mpcp_report_timeout_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_oam_keepalive_timeout_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timeout_id_pack(bcmolt_epon_link_oam_keepalive_timeout_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_oam_keepalive_timeout_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timeout_id_unpack(bcmolt_epon_link_oam_keepalive_timeout_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_oam_keepalive_timer_start_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_start_id_pack(bcmolt_epon_link_oam_keepalive_timer_start_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_oam_keepalive_timer_start_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_start_id_unpack(bcmolt_epon_link_oam_keepalive_timer_start_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_oam_keepalive_timer_started_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_started_id_pack(bcmolt_epon_link_oam_keepalive_timer_started_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_oam_keepalive_timer_started_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_started_id_unpack(bcmolt_epon_link_oam_keepalive_timer_started_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_oam_keepalive_timer_stop_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_stop_id_pack(bcmolt_epon_link_oam_keepalive_timer_stop_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_oam_keepalive_timer_stop_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_stop_id_unpack(bcmolt_epon_link_oam_keepalive_timer_stop_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_oam_keepalive_timer_stopped_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_stopped_id_pack(bcmolt_epon_link_oam_keepalive_timer_stopped_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_oam_keepalive_timer_stopped_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_stopped_id_unpack(bcmolt_epon_link_oam_keepalive_timer_stopped_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_preprovisioned_link_created_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_preprovisioned_link_created_id_pack(bcmolt_epon_link_preprovisioned_link_created_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_preprovisioned_link_created_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_preprovisioned_link_created_id_unpack(bcmolt_epon_link_preprovisioned_link_created_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_protection_switch_occurred_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_protection_switch_occurred_id_pack(bcmolt_epon_link_protection_switch_occurred_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_protection_switch_occurred_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_protection_switch_occurred_id_unpack(bcmolt_epon_link_protection_switch_occurred_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_range_value_changed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_range_value_changed_id_pack(bcmolt_epon_link_range_value_changed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_range_value_changed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_range_value_changed_id_unpack(bcmolt_epon_link_range_value_changed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_rerange_failure_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_rerange_failure_id_pack(bcmolt_epon_link_rerange_failure_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_rerange_failure_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_rerange_failure_id_unpack(bcmolt_epon_link_rerange_failure_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_stat_alarm_cleared_id_pack(bcmolt_epon_link_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_stat_alarm_cleared_id_unpack(bcmolt_epon_link_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_stat_alarm_raised_id_pack(bcmolt_epon_link_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_stat_alarm_raised_id_unpack(bcmolt_epon_link_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_stat_cfg_id_pack(bcmolt_epon_link_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_stat_cfg_id_unpack(bcmolt_epon_link_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_stat_id_pack(bcmolt_epon_link_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_stat_id_unpack(bcmolt_epon_link_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_state_flags to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_state_flags_pack(bcmolt_epon_link_state_flags this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_state_flags from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_state_flags_unpack(bcmolt_epon_link_state_flags *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_static_registration_done_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_static_registration_done_id_pack(bcmolt_epon_link_static_registration_done_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_static_registration_done_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_static_registration_done_id_unpack(bcmolt_epon_link_static_registration_done_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_static_registration_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_static_registration_id_pack(bcmolt_epon_link_static_registration_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_static_registration_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_static_registration_id_unpack(bcmolt_epon_link_static_registration_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_link_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_link_type_pack(bcmolt_epon_link_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_link_type_unpack(bcmolt_epon_link_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_mpcp_gate_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_mpcp_gate_mode_pack(bcmolt_mpcp_gate_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_mpcp_gate_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_mpcp_gate_mode_unpack(bcmolt_mpcp_gate_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_mpcp_registration_gate_flags to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_mpcp_registration_gate_flags_pack(bcmolt_mpcp_registration_gate_flags this, bcmolt_buf *buf);

/** Unpacks a bcmolt_mpcp_registration_gate_flags from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_mpcp_registration_gate_flags_unpack(bcmolt_mpcp_registration_gate_flags *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_add_link_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_add_link_id_pack(bcmolt_epon_ni_add_link_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_add_link_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_add_link_id_unpack(bcmolt_epon_ni_add_link_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_add_multicast_link_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_add_multicast_link_id_pack(bcmolt_epon_ni_add_multicast_link_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_add_multicast_link_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_add_multicast_link_id_unpack(bcmolt_epon_ni_add_multicast_link_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_add_protected_standby_link_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_add_protected_standby_link_id_pack(bcmolt_epon_ni_add_protected_standby_link_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_add_protected_standby_link_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_add_protected_standby_link_id_unpack(bcmolt_epon_ni_add_protected_standby_link_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_auto_cfg_id_pack(bcmolt_epon_ni_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_auto_cfg_id_unpack(bcmolt_epon_ni_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_auto_rogue_scan_10g_failure_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_auto_rogue_scan_10g_failure_id_pack(bcmolt_epon_ni_auto_rogue_scan_10g_failure_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_auto_rogue_scan_10g_failure_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_auto_rogue_scan_10g_failure_id_unpack(bcmolt_epon_ni_auto_rogue_scan_10g_failure_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_auto_rogue_scan_1g_failure_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_auto_rogue_scan_1g_failure_id_pack(bcmolt_epon_ni_auto_rogue_scan_1g_failure_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_auto_rogue_scan_1g_failure_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_auto_rogue_scan_1g_failure_id_unpack(bcmolt_epon_ni_auto_rogue_scan_1g_failure_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_cfg_id_pack(bcmolt_epon_ni_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_cfg_id_unpack(bcmolt_epon_ni_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_en_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_en_state_pack(bcmolt_epon_ni_en_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_en_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_en_state_unpack(bcmolt_epon_ni_en_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_issue_rssi_grant_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_issue_rssi_grant_id_pack(bcmolt_epon_ni_issue_rssi_grant_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_issue_rssi_grant_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_issue_rssi_grant_id_unpack(bcmolt_epon_ni_issue_rssi_grant_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_key_id_pack(bcmolt_epon_ni_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_key_id_unpack(bcmolt_epon_ni_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_llid_quarantined_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_llid_quarantined_id_pack(bcmolt_epon_ni_llid_quarantined_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_llid_quarantined_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_llid_quarantined_id_unpack(bcmolt_epon_ni_llid_quarantined_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_mpcp_timestamp_changed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_mpcp_timestamp_changed_id_pack(bcmolt_epon_ni_mpcp_timestamp_changed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_mpcp_timestamp_changed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_mpcp_timestamp_changed_id_unpack(bcmolt_epon_ni_mpcp_timestamp_changed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_no_reports_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_no_reports_id_pack(bcmolt_epon_ni_no_reports_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_no_reports_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_no_reports_id_unpack(bcmolt_epon_ni_no_reports_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_onu_upgrade_complete_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_onu_upgrade_complete_id_pack(bcmolt_epon_ni_onu_upgrade_complete_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_onu_upgrade_complete_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_onu_upgrade_complete_id_unpack(bcmolt_epon_ni_onu_upgrade_complete_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_protection_switching_apply_rerange_delta_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_protection_switching_apply_rerange_delta_id_pack(bcmolt_epon_ni_protection_switching_apply_rerange_delta_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_protection_switching_apply_rerange_delta_id from 
 * bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_protection_switching_apply_rerange_delta_id_unpack(bcmolt_epon_ni_protection_switching_apply_rerange_delta_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_rerange_failure_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_rerange_failure_id_pack(bcmolt_epon_ni_rerange_failure_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_rerange_failure_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_rerange_failure_id_unpack(bcmolt_epon_ni_rerange_failure_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_rogue_llid_scan_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_rogue_llid_scan_id_pack(bcmolt_epon_ni_rogue_llid_scan_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_rogue_llid_scan_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_rogue_llid_scan_id_unpack(bcmolt_epon_ni_rogue_llid_scan_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_rogue_scan_complete_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_rogue_scan_complete_id_pack(bcmolt_epon_ni_rogue_scan_complete_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_rogue_scan_complete_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_rogue_scan_complete_id_unpack(bcmolt_epon_ni_rogue_scan_complete_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_rssi_measurement_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_rssi_measurement_completed_id_pack(bcmolt_epon_ni_rssi_measurement_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_rssi_measurement_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_rssi_measurement_completed_id_unpack(bcmolt_epon_ni_rssi_measurement_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_set_epon_ni_en_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_set_epon_ni_en_state_id_pack(bcmolt_epon_ni_set_epon_ni_en_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_set_epon_ni_en_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_set_epon_ni_en_state_id_unpack(bcmolt_epon_ni_set_epon_ni_en_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_start_onu_upgrade_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_start_onu_upgrade_id_pack(bcmolt_epon_ni_start_onu_upgrade_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_start_onu_upgrade_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_start_onu_upgrade_id_unpack(bcmolt_epon_ni_start_onu_upgrade_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_ni_state_change_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_ni_state_change_completed_id_pack(bcmolt_epon_ni_state_change_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_state_change_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_ni_state_change_completed_id_unpack(bcmolt_epon_ni_state_change_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_oam_extension_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_oam_extension_type_pack(bcmolt_epon_oam_extension_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_oam_extension_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_oam_extension_type_unpack(bcmolt_epon_oam_extension_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_10g_us_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_auto_cfg_id_pack(bcmolt_epon_onu_10g_us_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_10g_us_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_auto_cfg_id_unpack(bcmolt_epon_onu_10g_us_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_10g_us_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_cfg_id_pack(bcmolt_epon_onu_10g_us_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_10g_us_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_cfg_id_unpack(bcmolt_epon_onu_10g_us_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_10g_us_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_key_id_pack(bcmolt_epon_onu_10g_us_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_10g_us_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_key_id_unpack(bcmolt_epon_onu_10g_us_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_10g_us_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_stat_alarm_cleared_id_pack(bcmolt_epon_onu_10g_us_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_10g_us_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_stat_alarm_cleared_id_unpack(bcmolt_epon_onu_10g_us_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_10g_us_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_stat_alarm_raised_id_pack(bcmolt_epon_onu_10g_us_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_10g_us_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_stat_alarm_raised_id_unpack(bcmolt_epon_onu_10g_us_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_10g_us_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_stat_cfg_id_pack(bcmolt_epon_onu_10g_us_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_10g_us_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_stat_cfg_id_unpack(bcmolt_epon_onu_10g_us_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_10g_us_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_stat_id_pack(bcmolt_epon_onu_10g_us_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_10g_us_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_10g_us_stat_id_unpack(bcmolt_epon_onu_10g_us_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_1g_us_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_auto_cfg_id_pack(bcmolt_epon_onu_1g_us_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_1g_us_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_auto_cfg_id_unpack(bcmolt_epon_onu_1g_us_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_1g_us_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_cfg_id_pack(bcmolt_epon_onu_1g_us_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_1g_us_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_cfg_id_unpack(bcmolt_epon_onu_1g_us_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_1g_us_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_key_id_pack(bcmolt_epon_onu_1g_us_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_1g_us_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_key_id_unpack(bcmolt_epon_onu_1g_us_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_1g_us_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_stat_alarm_cleared_id_pack(bcmolt_epon_onu_1g_us_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_1g_us_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_stat_alarm_cleared_id_unpack(bcmolt_epon_onu_1g_us_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_1g_us_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_stat_alarm_raised_id_pack(bcmolt_epon_onu_1g_us_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_1g_us_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_stat_alarm_raised_id_unpack(bcmolt_epon_onu_1g_us_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_1g_us_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_stat_cfg_id_pack(bcmolt_epon_onu_1g_us_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_1g_us_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_stat_cfg_id_unpack(bcmolt_epon_onu_1g_us_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_1g_us_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_stat_id_pack(bcmolt_epon_onu_1g_us_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_1g_us_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_1g_us_stat_id_unpack(bcmolt_epon_onu_1g_us_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_upgrade_onu_response_code to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_upgrade_onu_response_code_pack(bcmolt_epon_onu_upgrade_onu_response_code this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_upgrade_onu_response_code from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_upgrade_onu_response_code_unpack(bcmolt_epon_onu_upgrade_onu_response_code *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_onu_upgrade_return_code to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_onu_upgrade_return_code_pack(bcmolt_epon_onu_upgrade_return_code this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_upgrade_return_code from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_onu_upgrade_return_code_unpack(bcmolt_epon_onu_upgrade_return_code *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_ds_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_auto_cfg_id_pack(bcmolt_epon_path_10g_ds_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_ds_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_auto_cfg_id_unpack(bcmolt_epon_path_10g_ds_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_ds_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_cfg_id_pack(bcmolt_epon_path_10g_ds_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_ds_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_cfg_id_unpack(bcmolt_epon_path_10g_ds_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_ds_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_key_id_pack(bcmolt_epon_path_10g_ds_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_ds_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_key_id_unpack(bcmolt_epon_path_10g_ds_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_ds_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_stat_alarm_cleared_id_pack(bcmolt_epon_path_10g_ds_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_ds_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_stat_alarm_cleared_id_unpack(bcmolt_epon_path_10g_ds_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_ds_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_stat_alarm_raised_id_pack(bcmolt_epon_path_10g_ds_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_ds_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_stat_alarm_raised_id_unpack(bcmolt_epon_path_10g_ds_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_ds_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_stat_cfg_id_pack(bcmolt_epon_path_10g_ds_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_ds_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_stat_cfg_id_unpack(bcmolt_epon_path_10g_ds_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_ds_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_stat_id_pack(bcmolt_epon_path_10g_ds_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_ds_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_ds_stat_id_unpack(bcmolt_epon_path_10g_ds_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_us_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_auto_cfg_id_pack(bcmolt_epon_path_10g_us_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_us_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_auto_cfg_id_unpack(bcmolt_epon_path_10g_us_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_us_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_cfg_id_pack(bcmolt_epon_path_10g_us_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_us_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_cfg_id_unpack(bcmolt_epon_path_10g_us_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_us_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_key_id_pack(bcmolt_epon_path_10g_us_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_us_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_key_id_unpack(bcmolt_epon_path_10g_us_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_us_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_stat_alarm_cleared_id_pack(bcmolt_epon_path_10g_us_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_us_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_stat_alarm_cleared_id_unpack(bcmolt_epon_path_10g_us_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_us_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_stat_alarm_raised_id_pack(bcmolt_epon_path_10g_us_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_us_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_stat_alarm_raised_id_unpack(bcmolt_epon_path_10g_us_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_us_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_stat_cfg_id_pack(bcmolt_epon_path_10g_us_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_us_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_stat_cfg_id_unpack(bcmolt_epon_path_10g_us_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_10g_us_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_stat_id_pack(bcmolt_epon_path_10g_us_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_10g_us_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_10g_us_stat_id_unpack(bcmolt_epon_path_10g_us_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_ds_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_auto_cfg_id_pack(bcmolt_epon_path_1g_ds_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_ds_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_auto_cfg_id_unpack(bcmolt_epon_path_1g_ds_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_ds_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_cfg_id_pack(bcmolt_epon_path_1g_ds_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_ds_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_cfg_id_unpack(bcmolt_epon_path_1g_ds_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_ds_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_key_id_pack(bcmolt_epon_path_1g_ds_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_ds_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_key_id_unpack(bcmolt_epon_path_1g_ds_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_ds_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_stat_alarm_cleared_id_pack(bcmolt_epon_path_1g_ds_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_ds_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_stat_alarm_cleared_id_unpack(bcmolt_epon_path_1g_ds_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_ds_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_stat_alarm_raised_id_pack(bcmolt_epon_path_1g_ds_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_ds_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_stat_alarm_raised_id_unpack(bcmolt_epon_path_1g_ds_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_ds_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_stat_cfg_id_pack(bcmolt_epon_path_1g_ds_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_ds_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_stat_cfg_id_unpack(bcmolt_epon_path_1g_ds_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_ds_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_stat_id_pack(bcmolt_epon_path_1g_ds_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_ds_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_ds_stat_id_unpack(bcmolt_epon_path_1g_ds_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_us_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_auto_cfg_id_pack(bcmolt_epon_path_1g_us_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_us_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_auto_cfg_id_unpack(bcmolt_epon_path_1g_us_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_us_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_cfg_id_pack(bcmolt_epon_path_1g_us_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_us_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_cfg_id_unpack(bcmolt_epon_path_1g_us_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_us_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_key_id_pack(bcmolt_epon_path_1g_us_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_us_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_key_id_unpack(bcmolt_epon_path_1g_us_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_us_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_stat_alarm_cleared_id_pack(bcmolt_epon_path_1g_us_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_us_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_stat_alarm_cleared_id_unpack(bcmolt_epon_path_1g_us_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_us_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_stat_alarm_raised_id_pack(bcmolt_epon_path_1g_us_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_us_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_stat_alarm_raised_id_unpack(bcmolt_epon_path_1g_us_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_us_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_stat_cfg_id_pack(bcmolt_epon_path_1g_us_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_us_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_stat_cfg_id_unpack(bcmolt_epon_path_1g_us_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_path_1g_us_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_stat_id_pack(bcmolt_epon_path_1g_us_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_path_1g_us_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_path_1g_us_stat_id_unpack(bcmolt_epon_path_1g_us_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_protection_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_protection_state_pack(bcmolt_epon_protection_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_protection_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_protection_state_unpack(bcmolt_epon_protection_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_protection_switching_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_protection_switching_type_pack(bcmolt_epon_protection_switching_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_protection_switching_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_protection_switching_type_unpack(bcmolt_epon_protection_switching_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_protection_switching_detection_options to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_protection_switching_detection_options_pack(bcmolt_protection_switching_detection_options this, bcmolt_buf *buf);

/** Unpacks a bcmolt_protection_switching_detection_options from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_protection_switching_detection_options_unpack(bcmolt_protection_switching_detection_options *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_protection_switching_reranging_options to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_protection_switching_reranging_options_pack(bcmolt_epon_protection_switching_reranging_options this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_protection_switching_reranging_options from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_protection_switching_reranging_options_unpack(bcmolt_epon_protection_switching_reranging_options *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpio_pin to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpio_pin_pack(bcmolt_gpio_pin this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpio_pin from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpio_pin_unpack(bcmolt_gpio_pin *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpio_polarity to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpio_polarity_pack(bcmolt_gpio_polarity this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpio_polarity from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpio_polarity_unpack(bcmolt_gpio_polarity *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_rp_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_rp_cfg_id_pack(bcmolt_epon_rp_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_rp_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_rp_cfg_id_unpack(bcmolt_epon_rp_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_epon_rp_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_epon_rp_key_id_pack(bcmolt_epon_rp_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_rp_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_epon_rp_key_id_unpack(bcmolt_epon_rp_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_ext_irq to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ext_irq_pack(bcmolt_ext_irq this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ext_irq from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ext_irq_unpack(bcmolt_ext_irq *this, bcmolt_buf *buf);

/** Packs a bcmolt_flush_mac_table_option to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_flush_mac_table_option_pack(bcmolt_flush_mac_table_option this, bcmolt_buf *buf);

/** Unpacks a bcmolt_flush_mac_table_option from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_flush_mac_table_option_unpack(bcmolt_flush_mac_table_option *this, bcmolt_buf *buf);

/** Packs a bcmolt_frequency_adjustment_direction to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_frequency_adjustment_direction_pack(bcmolt_frequency_adjustment_direction this, bcmolt_buf *buf);

/** Unpacks a bcmolt_frequency_adjustment_direction from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_frequency_adjustment_direction_unpack(bcmolt_frequency_adjustment_direction *this, bcmolt_buf *buf);

/** Packs a bcmolt_gem_port_direction to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gem_port_direction_pack(bcmolt_gem_port_direction this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gem_port_direction from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gem_port_direction_unpack(bcmolt_gem_port_direction *this, bcmolt_buf *buf);

/** Packs a bcmolt_gem_port_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gem_port_type_pack(bcmolt_gem_port_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gem_port_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gem_port_type_unpack(bcmolt_gem_port_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_gem_port_operation to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gem_port_operation_pack(bcmolt_gem_port_operation this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gem_port_operation from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gem_port_operation_unpack(bcmolt_gem_port_operation *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpio_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpio_cfg_id_pack(bcmolt_gpio_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpio_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpio_cfg_id_unpack(bcmolt_gpio_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpio_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpio_key_id_pack(bcmolt_gpio_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpio_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpio_key_id_unpack(bcmolt_gpio_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpio_pin_dir to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpio_pin_dir_pack(bcmolt_gpio_pin_dir this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpio_pin_dir from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpio_pin_dir_unpack(bcmolt_gpio_pin_dir *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpio_value to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpio_value_pack(bcmolt_gpio_value this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpio_value from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpio_value_unpack(bcmolt_gpio_value *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_auto_cfg_id_pack(bcmolt_gpon_alloc_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_auto_cfg_id_unpack(bcmolt_gpon_alloc_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_cfg_id_pack(bcmolt_gpon_alloc_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_cfg_id_unpack(bcmolt_gpon_alloc_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_configuration_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_configuration_completed_id_pack(bcmolt_gpon_alloc_configuration_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_configuration_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_configuration_completed_id_unpack(bcmolt_gpon_alloc_configuration_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_get_alloc_stats_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_get_alloc_stats_completed_id_pack(bcmolt_gpon_alloc_get_alloc_stats_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_get_alloc_stats_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_get_alloc_stats_completed_id_unpack(bcmolt_gpon_alloc_get_alloc_stats_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_get_stats_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_get_stats_id_pack(bcmolt_gpon_alloc_get_stats_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_get_stats_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_get_stats_id_unpack(bcmolt_gpon_alloc_get_stats_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_key_id_pack(bcmolt_gpon_alloc_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_key_id_unpack(bcmolt_gpon_alloc_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_set_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_set_state_id_pack(bcmolt_gpon_alloc_set_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_set_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_set_state_id_unpack(bcmolt_gpon_alloc_set_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_stat_alarm_cleared_id_pack(bcmolt_gpon_alloc_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_stat_alarm_cleared_id_unpack(bcmolt_gpon_alloc_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_stat_alarm_raised_id_pack(bcmolt_gpon_alloc_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_stat_alarm_raised_id_unpack(bcmolt_gpon_alloc_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_stat_cfg_id_pack(bcmolt_gpon_alloc_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_stat_cfg_id_unpack(bcmolt_gpon_alloc_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_alloc_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_stat_id_pack(bcmolt_gpon_alloc_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_alloc_stat_id_unpack(bcmolt_gpon_alloc_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_auto_cfg_id_pack(bcmolt_gpon_gem_port_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_auto_cfg_id_unpack(bcmolt_gpon_gem_port_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_cfg_id_pack(bcmolt_gpon_gem_port_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_cfg_id_unpack(bcmolt_gpon_gem_port_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_configuration_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_configuration_completed_id_pack(bcmolt_gpon_gem_port_configuration_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_configuration_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_configuration_completed_id_unpack(bcmolt_gpon_gem_port_configuration_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_key_id_pack(bcmolt_gpon_gem_port_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_key_id_unpack(bcmolt_gpon_gem_port_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_set_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_set_state_id_pack(bcmolt_gpon_gem_port_set_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_set_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_set_state_id_unpack(bcmolt_gpon_gem_port_set_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_stat_alarm_cleared_id_pack(bcmolt_gpon_gem_port_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_stat_alarm_cleared_id_unpack(bcmolt_gpon_gem_port_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_stat_alarm_raised_id_pack(bcmolt_gpon_gem_port_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_stat_alarm_raised_id_unpack(bcmolt_gpon_gem_port_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_stat_cfg_id_pack(bcmolt_gpon_gem_port_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_stat_cfg_id_unpack(bcmolt_gpon_gem_port_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_stat_id_pack(bcmolt_gpon_gem_port_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_stat_id_unpack(bcmolt_gpon_gem_port_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_gem_port_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_state_pack(bcmolt_gpon_gem_port_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_gem_port_state_unpack(bcmolt_gpon_gem_port_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_auto_cfg_id_pack(bcmolt_gpon_iwf_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_auto_cfg_id_unpack(bcmolt_gpon_iwf_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_cfg_id_pack(bcmolt_gpon_iwf_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_cfg_id_unpack(bcmolt_gpon_iwf_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_ds_egress_flow_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_ds_egress_flow_cfg_id_pack(bcmolt_gpon_iwf_ds_egress_flow_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_ds_egress_flow_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_ds_egress_flow_cfg_id_unpack(bcmolt_gpon_iwf_ds_egress_flow_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_ds_egress_flow_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_ds_egress_flow_key_id_pack(bcmolt_gpon_iwf_ds_egress_flow_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_ds_egress_flow_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_ds_egress_flow_key_id_unpack(bcmolt_gpon_iwf_ds_egress_flow_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_ds_ingress_flow_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_ds_ingress_flow_cfg_id_pack(bcmolt_gpon_iwf_ds_ingress_flow_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_ds_ingress_flow_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_ds_ingress_flow_cfg_id_unpack(bcmolt_gpon_iwf_ds_ingress_flow_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_ds_ingress_flow_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_ds_ingress_flow_key_id_pack(bcmolt_gpon_iwf_ds_ingress_flow_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_ds_ingress_flow_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_ds_ingress_flow_key_id_unpack(bcmolt_gpon_iwf_ds_ingress_flow_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_flush_mac_table_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_flush_mac_table_completed_id_pack(bcmolt_gpon_iwf_flush_mac_table_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_flush_mac_table_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_flush_mac_table_completed_id_unpack(bcmolt_gpon_iwf_flush_mac_table_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_flush_mac_table_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_flush_mac_table_id_pack(bcmolt_gpon_iwf_flush_mac_table_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_flush_mac_table_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_flush_mac_table_id_unpack(bcmolt_gpon_iwf_flush_mac_table_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_key_id_pack(bcmolt_gpon_iwf_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_key_id_unpack(bcmolt_gpon_iwf_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_mac_table_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_auto_cfg_id_pack(bcmolt_gpon_iwf_mac_table_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_mac_table_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_auto_cfg_id_unpack(bcmolt_gpon_iwf_mac_table_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_mac_table_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_cfg_id_pack(bcmolt_gpon_iwf_mac_table_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_mac_table_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_cfg_id_unpack(bcmolt_gpon_iwf_mac_table_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_mac_table_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_key_id_pack(bcmolt_gpon_iwf_mac_table_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_mac_table_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_key_id_unpack(bcmolt_gpon_iwf_mac_table_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_mac_table_mac_aged_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_aged_id_pack(bcmolt_gpon_iwf_mac_table_mac_aged_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_mac_table_mac_aged_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_aged_id_unpack(bcmolt_gpon_iwf_mac_table_mac_aged_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_mac_table_mac_dropped_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_dropped_id_pack(bcmolt_gpon_iwf_mac_table_mac_dropped_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_mac_table_mac_dropped_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_dropped_id_unpack(bcmolt_gpon_iwf_mac_table_mac_dropped_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_mac_table_mac_move_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_move_id_pack(bcmolt_gpon_iwf_mac_table_mac_move_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_mac_table_mac_move_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_move_id_unpack(bcmolt_gpon_iwf_mac_table_mac_move_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_mac_table_new_mac_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_new_mac_id_pack(bcmolt_gpon_iwf_mac_table_new_mac_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_mac_table_new_mac_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_mac_table_new_mac_id_unpack(bcmolt_gpon_iwf_mac_table_new_mac_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_scan_mac_table_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_scan_mac_table_completed_id_pack(bcmolt_gpon_iwf_scan_mac_table_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_scan_mac_table_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_scan_mac_table_completed_id_unpack(bcmolt_gpon_iwf_scan_mac_table_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_scan_mac_table_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_scan_mac_table_id_pack(bcmolt_gpon_iwf_scan_mac_table_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_scan_mac_table_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_scan_mac_table_id_unpack(bcmolt_gpon_iwf_scan_mac_table_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_stat_alarm_cleared_id_pack(bcmolt_gpon_iwf_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_stat_alarm_cleared_id_unpack(bcmolt_gpon_iwf_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_stat_alarm_raised_id_pack(bcmolt_gpon_iwf_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_stat_alarm_raised_id_unpack(bcmolt_gpon_iwf_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_stat_cfg_id_pack(bcmolt_gpon_iwf_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_stat_cfg_id_unpack(bcmolt_gpon_iwf_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_stat_id_pack(bcmolt_gpon_iwf_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_stat_id_unpack(bcmolt_gpon_iwf_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_us_flow_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_us_flow_cfg_id_pack(bcmolt_gpon_iwf_us_flow_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_us_flow_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_us_flow_cfg_id_unpack(bcmolt_gpon_iwf_us_flow_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_iwf_us_flow_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_us_flow_key_id_pack(bcmolt_gpon_iwf_us_flow_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_us_flow_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_iwf_us_flow_key_id_unpack(bcmolt_gpon_iwf_us_flow_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_key_exchange_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_key_exchange_mode_pack(bcmolt_key_exchange_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_key_exchange_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_key_exchange_mode_unpack(bcmolt_key_exchange_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_activate_all_onus_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_activate_all_onus_completed_id_pack(bcmolt_gpon_ni_activate_all_onus_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_activate_all_onus_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_activate_all_onus_completed_id_unpack(bcmolt_gpon_ni_activate_all_onus_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_auto_cfg_id_pack(bcmolt_gpon_ni_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_auto_cfg_id_unpack(bcmolt_gpon_ni_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_broadcast_ploam_packet_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_broadcast_ploam_packet_id_pack(bcmolt_gpon_ni_broadcast_ploam_packet_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_broadcast_ploam_packet_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_broadcast_ploam_packet_id_unpack(bcmolt_gpon_ni_broadcast_ploam_packet_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_cfg_id_pack(bcmolt_gpon_ni_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_cfg_id_unpack(bcmolt_gpon_ni_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_cpu_packets_failure_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_cpu_packets_failure_id_pack(bcmolt_gpon_ni_cpu_packets_failure_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_cpu_packets_failure_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_cpu_packets_failure_id_unpack(bcmolt_gpon_ni_cpu_packets_failure_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_cpu_packets_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_cpu_packets_id_pack(bcmolt_gpon_ni_cpu_packets_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_cpu_packets_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_cpu_packets_id_unpack(bcmolt_gpon_ni_cpu_packets_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_deactivate_all_onus_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_deactivate_all_onus_completed_id_pack(bcmolt_gpon_ni_deactivate_all_onus_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_deactivate_all_onus_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_deactivate_all_onus_completed_id_unpack(bcmolt_gpon_ni_deactivate_all_onus_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_disable_all_onus_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_disable_all_onus_completed_id_pack(bcmolt_gpon_ni_disable_all_onus_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_disable_all_onus_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_disable_all_onus_completed_id_unpack(bcmolt_gpon_ni_disable_all_onus_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_disable_serial_number_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_disable_serial_number_id_pack(bcmolt_gpon_ni_disable_serial_number_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_disable_serial_number_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_disable_serial_number_id_unpack(bcmolt_gpon_ni_disable_serial_number_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_enable_all_onus_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_enable_all_onus_completed_id_pack(bcmolt_gpon_ni_enable_all_onus_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_enable_all_onus_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_enable_all_onus_completed_id_unpack(bcmolt_gpon_ni_enable_all_onus_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_key_id_pack(bcmolt_gpon_ni_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_key_id_unpack(bcmolt_gpon_ni_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_los_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_los_id_pack(bcmolt_gpon_ni_los_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_los_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_los_id_unpack(bcmolt_gpon_ni_los_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_onu_discovered_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_onu_discovered_id_pack(bcmolt_gpon_ni_onu_discovered_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_onu_discovered_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_onu_discovered_id_unpack(bcmolt_gpon_ni_onu_discovered_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_onu_upgrade_complete_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_onu_upgrade_complete_id_pack(bcmolt_gpon_ni_onu_upgrade_complete_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_onu_upgrade_complete_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_onu_upgrade_complete_id_unpack(bcmolt_gpon_ni_onu_upgrade_complete_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_protection_switching_onus_ranged_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_protection_switching_onus_ranged_id_pack(bcmolt_gpon_ni_protection_switching_onus_ranged_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_protection_switching_onus_ranged_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_protection_switching_onus_ranged_id_unpack(bcmolt_gpon_ni_protection_switching_onus_ranged_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_protection_switching_switchover_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_protection_switching_switchover_completed_id_pack(bcmolt_gpon_ni_protection_switching_switchover_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_protection_switching_switchover_completed_id from 
 * bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_protection_switching_switchover_completed_id_unpack(bcmolt_gpon_ni_protection_switching_switchover_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_protection_switching_traffic_resume_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_protection_switching_traffic_resume_id_pack(bcmolt_gpon_ni_protection_switching_traffic_resume_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_protection_switching_traffic_resume_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_protection_switching_traffic_resume_id_unpack(bcmolt_gpon_ni_protection_switching_traffic_resume_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id 
 * to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id_pack(bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id this, bcmolt_buf *buf);

/** Unpacks a 
 * bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id from 
 * bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id_unpack(bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_reset_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_reset_id_pack(bcmolt_gpon_ni_reset_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_reset_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_reset_id_unpack(bcmolt_gpon_ni_reset_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_rogue_detection_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_rogue_detection_completed_id_pack(bcmolt_gpon_ni_rogue_detection_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_rogue_detection_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_rogue_detection_completed_id_unpack(bcmolt_gpon_ni_rogue_detection_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_rogue_detection_window_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_rogue_detection_window_id_pack(bcmolt_gpon_ni_rogue_detection_window_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_rogue_detection_window_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_rogue_detection_window_id_unpack(bcmolt_gpon_ni_rogue_detection_window_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id_pack(bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id_unpack(bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id_pack(bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id_unpack(bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_set_onu_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_set_onu_state_id_pack(bcmolt_gpon_ni_set_onu_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_set_onu_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_set_onu_state_id_unpack(bcmolt_gpon_ni_set_onu_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_set_pon_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_set_pon_state_id_pack(bcmolt_gpon_ni_set_pon_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_set_pon_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_set_pon_state_id_unpack(bcmolt_gpon_ni_set_pon_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_single_request_standby_pon_monitoring_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_single_request_standby_pon_monitoring_id_pack(bcmolt_gpon_ni_single_request_standby_pon_monitoring_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_single_request_standby_pon_monitoring_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_single_request_standby_pon_monitoring_id_unpack(bcmolt_gpon_ni_single_request_standby_pon_monitoring_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id_pack(bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id from 
 * bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id_unpack(bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_start_onu_upgrade_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_start_onu_upgrade_id_pack(bcmolt_gpon_ni_start_onu_upgrade_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_start_onu_upgrade_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_start_onu_upgrade_id_unpack(bcmolt_gpon_ni_start_onu_upgrade_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_stat_alarm_cleared_id_pack(bcmolt_gpon_ni_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_stat_alarm_cleared_id_unpack(bcmolt_gpon_ni_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_stat_alarm_raised_id_pack(bcmolt_gpon_ni_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_stat_alarm_raised_id_unpack(bcmolt_gpon_ni_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_stat_cfg_id_pack(bcmolt_gpon_ni_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_stat_cfg_id_unpack(bcmolt_gpon_ni_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_stat_id_pack(bcmolt_gpon_ni_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_stat_id_unpack(bcmolt_gpon_ni_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_state_change_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_state_change_completed_id_pack(bcmolt_gpon_ni_state_change_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_state_change_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_state_change_completed_id_unpack(bcmolt_gpon_ni_state_change_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_tod_request_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_tod_request_completed_id_pack(bcmolt_gpon_ni_tod_request_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_tod_request_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_tod_request_completed_id_unpack(bcmolt_gpon_ni_tod_request_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_ni_tod_request_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_ni_tod_request_id_pack(bcmolt_gpon_ni_tod_request_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_tod_request_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_ni_tod_request_id_unpack(bcmolt_gpon_ni_tod_request_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_auto_cfg_id_pack(bcmolt_gpon_onu_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_auto_cfg_id_unpack(bcmolt_gpon_onu_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_ber_interval_configuration_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_ber_interval_configuration_completed_id_pack(bcmolt_gpon_onu_ber_interval_configuration_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_ber_interval_configuration_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_ber_interval_configuration_completed_id_unpack(bcmolt_gpon_onu_ber_interval_configuration_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_cfg_id_pack(bcmolt_gpon_onu_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_cfg_id_unpack(bcmolt_gpon_onu_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_change_power_level_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_change_power_level_id_pack(bcmolt_gpon_onu_change_power_level_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_change_power_level_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_change_power_level_id_unpack(bcmolt_gpon_onu_change_power_level_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_cpu_packet_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_cpu_packet_id_pack(bcmolt_gpon_onu_cpu_packet_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_cpu_packet_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_cpu_packet_id_unpack(bcmolt_gpon_onu_cpu_packet_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_cpu_packets_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_cpu_packets_id_pack(bcmolt_gpon_onu_cpu_packets_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_cpu_packets_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_cpu_packets_id_unpack(bcmolt_gpon_onu_cpu_packets_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_dfi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_dfi_id_pack(bcmolt_gpon_onu_dfi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_dfi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_dfi_id_unpack(bcmolt_gpon_onu_dfi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_dgi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_dgi_id_pack(bcmolt_gpon_onu_dgi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_dgi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_dgi_id_unpack(bcmolt_gpon_onu_dgi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_dowi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_dowi_id_pack(bcmolt_gpon_onu_dowi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_dowi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_dowi_id_unpack(bcmolt_gpon_onu_dowi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_err_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_err_id_pack(bcmolt_gpon_onu_err_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_err_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_err_id_unpack(bcmolt_gpon_onu_err_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_invalid_dbru_report_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_invalid_dbru_report_id_pack(bcmolt_gpon_onu_invalid_dbru_report_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_invalid_dbru_report_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_invalid_dbru_report_id_unpack(bcmolt_gpon_onu_invalid_dbru_report_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_key_exchange_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_completed_id_pack(bcmolt_gpon_onu_key_exchange_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_key_exchange_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_completed_id_unpack(bcmolt_gpon_onu_key_exchange_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_key_exchange_cycle_skipped_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_cycle_skipped_id_pack(bcmolt_gpon_onu_key_exchange_cycle_skipped_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_key_exchange_cycle_skipped_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_cycle_skipped_id_unpack(bcmolt_gpon_onu_key_exchange_cycle_skipped_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_key_exchange_decrypt_required_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_decrypt_required_id_pack(bcmolt_gpon_onu_key_exchange_decrypt_required_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_key_exchange_decrypt_required_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_decrypt_required_id_unpack(bcmolt_gpon_onu_key_exchange_decrypt_required_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_key_exchange_key_mismatch_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_key_mismatch_id_pack(bcmolt_gpon_onu_key_exchange_key_mismatch_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_key_exchange_key_mismatch_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_key_mismatch_id_unpack(bcmolt_gpon_onu_key_exchange_key_mismatch_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_key_exchange_key_request_timeout_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_key_request_timeout_id_pack(bcmolt_gpon_onu_key_exchange_key_request_timeout_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_key_exchange_key_request_timeout_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_key_request_timeout_id_unpack(bcmolt_gpon_onu_key_exchange_key_request_timeout_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_key_exchange_unconsecutive_index_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_unconsecutive_index_id_pack(bcmolt_gpon_onu_key_exchange_unconsecutive_index_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_key_exchange_unconsecutive_index_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_exchange_unconsecutive_index_id_unpack(bcmolt_gpon_onu_key_exchange_unconsecutive_index_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_id_pack(bcmolt_gpon_onu_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_key_id_unpack(bcmolt_gpon_onu_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_loai_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_loai_id_pack(bcmolt_gpon_onu_loai_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_loai_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_loai_id_unpack(bcmolt_gpon_onu_loai_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_loki_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_loki_id_pack(bcmolt_gpon_onu_loki_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_loki_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_loki_id_unpack(bcmolt_gpon_onu_loki_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_memi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_memi_id_pack(bcmolt_gpon_onu_memi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_memi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_memi_id_unpack(bcmolt_gpon_onu_memi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_omci_packet_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_omci_packet_id_pack(bcmolt_gpon_onu_omci_packet_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_omci_packet_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_omci_packet_id_unpack(bcmolt_gpon_onu_omci_packet_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_omci_port_id_configuration_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_omci_port_id_configuration_completed_id_pack(bcmolt_gpon_onu_omci_port_id_configuration_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_omci_port_id_configuration_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_omci_port_id_configuration_completed_id_unpack(bcmolt_gpon_onu_omci_port_id_configuration_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_onu_activation_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_activation_completed_id_pack(bcmolt_gpon_onu_onu_activation_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_onu_activation_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_activation_completed_id_unpack(bcmolt_gpon_onu_onu_activation_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_onu_activation_standby_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_activation_standby_completed_id_pack(bcmolt_gpon_onu_onu_activation_standby_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_onu_activation_standby_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_activation_standby_completed_id_unpack(bcmolt_gpon_onu_onu_activation_standby_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_onu_alarm_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_alarm_id_pack(bcmolt_gpon_onu_onu_alarm_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_onu_alarm_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_alarm_id_unpack(bcmolt_gpon_onu_onu_alarm_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_onu_deactivation_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_deactivation_completed_id_pack(bcmolt_gpon_onu_onu_deactivation_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_onu_deactivation_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_deactivation_completed_id_unpack(bcmolt_gpon_onu_onu_deactivation_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_onu_disable_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_disable_completed_id_pack(bcmolt_gpon_onu_onu_disable_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_onu_disable_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_disable_completed_id_unpack(bcmolt_gpon_onu_onu_disable_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_onu_enable_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_enable_completed_id_pack(bcmolt_gpon_onu_onu_enable_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_onu_enable_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_onu_enable_completed_id_unpack(bcmolt_gpon_onu_onu_enable_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_optical_reflection_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_optical_reflection_id_pack(bcmolt_gpon_onu_optical_reflection_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_optical_reflection_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_optical_reflection_id_unpack(bcmolt_gpon_onu_optical_reflection_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_password_authentication_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_password_authentication_completed_id_pack(bcmolt_gpon_onu_password_authentication_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_password_authentication_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_password_authentication_completed_id_unpack(bcmolt_gpon_onu_password_authentication_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_pee_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_pee_id_pack(bcmolt_gpon_onu_pee_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_pee_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_pee_id_unpack(bcmolt_gpon_onu_pee_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_ploam_packet_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_ploam_packet_id_pack(bcmolt_gpon_onu_ploam_packet_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_ploam_packet_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_ploam_packet_id_unpack(bcmolt_gpon_onu_ploam_packet_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_possible_drift_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_possible_drift_id_pack(bcmolt_gpon_onu_possible_drift_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_possible_drift_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_possible_drift_id_unpack(bcmolt_gpon_onu_possible_drift_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_power_management_state_change_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_power_management_state_change_id_pack(bcmolt_gpon_onu_power_management_state_change_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_power_management_state_change_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_power_management_state_change_id_unpack(bcmolt_gpon_onu_power_management_state_change_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_pst_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_pst_id_pack(bcmolt_gpon_onu_pst_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_pst_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_pst_id_unpack(bcmolt_gpon_onu_pst_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_ranging_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_ranging_completed_id_pack(bcmolt_gpon_onu_ranging_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_ranging_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_ranging_completed_id_unpack(bcmolt_gpon_onu_ranging_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_rei_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_rei_id_pack(bcmolt_gpon_onu_rei_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_rei_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_rei_id_unpack(bcmolt_gpon_onu_rei_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_rssi_measurement_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_rssi_measurement_completed_id_pack(bcmolt_gpon_onu_rssi_measurement_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_rssi_measurement_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_rssi_measurement_completed_id_unpack(bcmolt_gpon_onu_rssi_measurement_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_rssi_measurement_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_rssi_measurement_id_pack(bcmolt_gpon_onu_rssi_measurement_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_rssi_measurement_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_rssi_measurement_id_unpack(bcmolt_gpon_onu_rssi_measurement_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_sdi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_sdi_id_pack(bcmolt_gpon_onu_sdi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_sdi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_sdi_id_unpack(bcmolt_gpon_onu_sdi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_set_onu_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_set_onu_state_id_pack(bcmolt_gpon_onu_set_onu_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_set_onu_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_set_onu_state_id_unpack(bcmolt_gpon_onu_set_onu_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_sfi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_sfi_id_pack(bcmolt_gpon_onu_sfi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_sfi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_sfi_id_unpack(bcmolt_gpon_onu_sfi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_stat_alarm_cleared_id_pack(bcmolt_gpon_onu_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_stat_alarm_cleared_id_unpack(bcmolt_gpon_onu_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_stat_alarm_raised_id_pack(bcmolt_gpon_onu_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_stat_alarm_raised_id_unpack(bcmolt_gpon_onu_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_stat_cfg_id_pack(bcmolt_gpon_onu_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_stat_cfg_id_unpack(bcmolt_gpon_onu_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_stat_id_pack(bcmolt_gpon_onu_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_stat_id_unpack(bcmolt_gpon_onu_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_sufi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_sufi_id_pack(bcmolt_gpon_onu_sufi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_sufi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_sufi_id_unpack(bcmolt_gpon_onu_sufi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_tiwi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_tiwi_id_pack(bcmolt_gpon_onu_tiwi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_tiwi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_tiwi_id_unpack(bcmolt_gpon_onu_tiwi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_omci_device_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_omci_device_id_pack(bcmolt_omci_device_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_omci_device_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_omci_device_id_unpack(bcmolt_omci_device_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_onu_upgrade_return_code to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_return_code_pack(bcmolt_gpon_onu_upgrade_return_code this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_upgrade_return_code from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_return_code_unpack(bcmolt_gpon_onu_upgrade_return_code *this, bcmolt_buf *buf);

/** Packs a bcmolt_omci_result_code to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_omci_result_code_pack(bcmolt_omci_result_code this, bcmolt_buf *buf);

/** Unpacks a bcmolt_omci_result_code from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_omci_result_code_unpack(bcmolt_omci_result_code *this, bcmolt_buf *buf);

/** Packs a bcmolt_onu_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_onu_state_pack(bcmolt_onu_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_onu_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_onu_state_unpack(bcmolt_onu_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_rssi_location_sign to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_rssi_location_sign_pack(bcmolt_rssi_location_sign this, bcmolt_buf *buf);

/** Unpacks a bcmolt_rssi_location_sign from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_rssi_location_sign_unpack(bcmolt_rssi_location_sign *this, bcmolt_buf *buf);

/** Packs a bcmolt_onu_post_discovery_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_onu_post_discovery_mode_pack(bcmolt_onu_post_discovery_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_onu_post_discovery_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_onu_post_discovery_mode_unpack(bcmolt_onu_post_discovery_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_trx_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_trx_cfg_id_pack(bcmolt_gpon_trx_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_trx_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_trx_cfg_id_unpack(bcmolt_gpon_trx_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_gpon_trx_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_gpon_trx_key_id_pack(bcmolt_gpon_trx_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_trx_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_gpon_trx_key_id_unpack(bcmolt_gpon_trx_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_image_transfer_status to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_image_transfer_status_pack(bcmolt_image_transfer_status this, bcmolt_buf *buf);

/** Unpacks a bcmolt_image_transfer_status from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_image_transfer_status_unpack(bcmolt_image_transfer_status *this, bcmolt_buf *buf);

/** Packs a bcmolt_iwf_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_iwf_mode_pack(bcmolt_iwf_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_iwf_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_iwf_mode_unpack(bcmolt_iwf_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_entry_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_entry_auto_cfg_id_pack(bcmolt_log_entry_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_entry_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_entry_auto_cfg_id_unpack(bcmolt_log_entry_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_entry_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_entry_cfg_id_pack(bcmolt_log_entry_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_entry_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_entry_cfg_id_unpack(bcmolt_log_entry_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_entry_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_entry_key_id_pack(bcmolt_log_entry_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_entry_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_entry_key_id_unpack(bcmolt_log_entry_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_entry_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_entry_stat_alarm_cleared_id_pack(bcmolt_log_entry_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_entry_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_entry_stat_alarm_cleared_id_unpack(bcmolt_log_entry_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_entry_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_entry_stat_alarm_raised_id_pack(bcmolt_log_entry_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_entry_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_entry_stat_alarm_raised_id_unpack(bcmolt_log_entry_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_entry_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_entry_stat_cfg_id_pack(bcmolt_log_entry_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_entry_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_entry_stat_cfg_id_unpack(bcmolt_log_entry_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_entry_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_entry_stat_id_pack(bcmolt_log_entry_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_entry_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_entry_stat_id_unpack(bcmolt_log_entry_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_file_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_file_id_pack(bcmolt_log_file_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_file_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_file_id_unpack(bcmolt_log_file_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_level to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_level_pack(bcmolt_log_level this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_level from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_level_unpack(bcmolt_log_level *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_style to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_style_pack(bcmolt_log_style this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_style from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_style_unpack(bcmolt_log_style *this, bcmolt_buf *buf);

/** Packs a bcmolt_log_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_log_type_pack(bcmolt_log_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_log_type_unpack(bcmolt_log_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_logger_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_logger_auto_cfg_id_pack(bcmolt_logger_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_logger_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_logger_auto_cfg_id_unpack(bcmolt_logger_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_logger_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_logger_cfg_id_pack(bcmolt_logger_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_logger_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_logger_cfg_id_unpack(bcmolt_logger_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_logger_clear_log_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_logger_clear_log_id_pack(bcmolt_logger_clear_log_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_logger_clear_log_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_logger_clear_log_id_unpack(bcmolt_logger_clear_log_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_logger_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_logger_key_id_pack(bcmolt_logger_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_logger_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_logger_key_id_unpack(bcmolt_logger_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_logger_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_logger_stat_alarm_cleared_id_pack(bcmolt_logger_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_logger_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_logger_stat_alarm_cleared_id_unpack(bcmolt_logger_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_logger_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_logger_stat_alarm_raised_id_pack(bcmolt_logger_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_logger_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_logger_stat_alarm_raised_id_unpack(bcmolt_logger_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_logger_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_logger_stat_cfg_id_pack(bcmolt_logger_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_logger_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_logger_stat_cfg_id_unpack(bcmolt_logger_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_logger_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_logger_stat_id_pack(bcmolt_logger_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_logger_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_logger_stat_id_unpack(bcmolt_logger_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_mac_table_miss_fallback to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_mac_table_miss_fallback_pack(bcmolt_mac_table_miss_fallback this, bcmolt_buf *buf);

/** Unpacks a bcmolt_mac_table_miss_fallback from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_mac_table_miss_fallback_unpack(bcmolt_mac_table_miss_fallback *this, bcmolt_buf *buf);

/** Packs a bcmolt_mac_table_learning_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_mac_table_learning_mode_pack(bcmolt_mac_table_learning_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_mac_table_learning_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_mac_table_learning_mode_unpack(bcmolt_mac_table_learning_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_mapping_tag_method to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_mapping_tag_method_pack(bcmolt_mapping_tag_method this, bcmolt_buf *buf);

/** Unpacks a bcmolt_mapping_tag_method from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_mapping_tag_method_unpack(bcmolt_mapping_tag_method *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_auto_cfg_id_pack(bcmolt_nni_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_auto_cfg_id_unpack(bcmolt_nni_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_cfg_id_pack(bcmolt_nni_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_cfg_id_unpack(bcmolt_nni_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_connection to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_connection_pack(bcmolt_nni_connection this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_connection from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_connection_unpack(bcmolt_nni_connection *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_key_id_pack(bcmolt_nni_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_key_id_unpack(bcmolt_nni_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_trivalent to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trivalent_pack(bcmolt_trivalent this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trivalent from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trivalent_unpack(bcmolt_trivalent *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_serdes_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_serdes_cfg_id_pack(bcmolt_nni_serdes_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_serdes_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_serdes_cfg_id_unpack(bcmolt_nni_serdes_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_serdes_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_serdes_key_id_pack(bcmolt_nni_serdes_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_serdes_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_serdes_key_id_unpack(bcmolt_nni_serdes_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_stat_alarm_cleared_id_pack(bcmolt_nni_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_stat_alarm_cleared_id_unpack(bcmolt_nni_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_stat_alarm_raised_id_pack(bcmolt_nni_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_stat_alarm_raised_id_unpack(bcmolt_nni_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_stat_cfg_id_pack(bcmolt_nni_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_stat_cfg_id_unpack(bcmolt_nni_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_stat_id_pack(bcmolt_nni_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_stat_id_unpack(bcmolt_nni_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_nni_status_changed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_nni_status_changed_id_pack(bcmolt_nni_status_changed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_status_changed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_nni_status_changed_id_unpack(bcmolt_nni_status_changed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_odn_class to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_odn_class_pack(bcmolt_odn_class this, bcmolt_buf *buf);

/** Unpacks a bcmolt_odn_class from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_odn_class_unpack(bcmolt_odn_class *this, bcmolt_buf *buf);

/** Packs a bcmolt_omci_port_id_operation to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_omci_port_id_operation_pack(bcmolt_omci_port_id_operation this, bcmolt_buf *buf);

/** Unpacks a bcmolt_omci_port_id_operation from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_omci_port_id_operation_unpack(bcmolt_omci_port_id_operation *this, bcmolt_buf *buf);

/** Packs a bcmolt_onu_operation to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_onu_operation_pack(bcmolt_onu_operation this, bcmolt_buf *buf);

/** Unpacks a bcmolt_onu_operation from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_onu_operation_unpack(bcmolt_onu_operation *this, bcmolt_buf *buf);

/** Packs a bcmolt_onu_power_level to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_onu_power_level_pack(bcmolt_onu_power_level this, bcmolt_buf *buf);

/** Unpacks a bcmolt_onu_power_level from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_onu_power_level_unpack(bcmolt_onu_power_level *this, bcmolt_buf *buf);

/** Packs a bcmolt_tc_protocol to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_tc_protocol_pack(bcmolt_tc_protocol this, bcmolt_buf *buf);

/** Unpacks a bcmolt_tc_protocol from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_tc_protocol_unpack(bcmolt_tc_protocol *this, bcmolt_buf *buf);

/** Packs a bcmolt_packet_injection_error to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_packet_injection_error_pack(bcmolt_packet_injection_error this, bcmolt_buf *buf);

/** Unpacks a bcmolt_packet_injection_error from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_packet_injection_error_unpack(bcmolt_packet_injection_error *this, bcmolt_buf *buf);

/** Packs a bcmolt_packet_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_packet_type_pack(bcmolt_packet_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_packet_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_packet_type_unpack(bcmolt_packet_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_password_authentication_fail_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_password_authentication_fail_reason_pack(bcmolt_password_authentication_fail_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_password_authentication_fail_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_password_authentication_fail_reason_unpack(bcmolt_password_authentication_fail_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_polarity to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_polarity_pack(bcmolt_polarity this, bcmolt_buf *buf);

/** Unpacks a bcmolt_polarity from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_polarity_unpack(bcmolt_polarity *this, bcmolt_buf *buf);

/** Packs a bcmolt_polling_interval to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_polling_interval_pack(bcmolt_polling_interval this, bcmolt_buf *buf);

/** Unpacks a bcmolt_polling_interval from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_polling_interval_unpack(bcmolt_polling_interval *this, bcmolt_buf *buf);

/** Packs a bcmolt_pon_operation to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_pon_operation_pack(bcmolt_pon_operation this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_operation from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_pon_operation_unpack(bcmolt_pon_operation *this, bcmolt_buf *buf);

/** Packs a bcmolt_pon_protection_switching_options to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_pon_protection_switching_options_pack(bcmolt_pon_protection_switching_options this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_protection_switching_options from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_pon_protection_switching_options_unpack(bcmolt_pon_protection_switching_options *this, bcmolt_buf *buf);

/** Packs a bcmolt_pon_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_pon_state_pack(bcmolt_pon_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_pon_state_unpack(bcmolt_pon_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_power_levelling_control to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_power_levelling_control_pack(bcmolt_power_levelling_control this, bcmolt_buf *buf);

/** Unpacks a bcmolt_power_levelling_control from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_power_levelling_control_unpack(bcmolt_power_levelling_control *this, bcmolt_buf *buf);

/** Packs a bcmolt_power_management_transition_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_power_management_transition_reason_pack(bcmolt_power_management_transition_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_power_management_transition_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_power_management_transition_reason_unpack(bcmolt_power_management_transition_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_prbs_polynomial to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_prbs_polynomial_pack(bcmolt_prbs_polynomial this, bcmolt_buf *buf);

/** Unpacks a bcmolt_prbs_polynomial from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_prbs_polynomial_unpack(bcmolt_prbs_polynomial *this, bcmolt_buf *buf);

/** Packs a bcmolt_prbs_checker_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_prbs_checker_mode_pack(bcmolt_prbs_checker_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_prbs_checker_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_prbs_checker_mode_unpack(bcmolt_prbs_checker_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_prbs_lock_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_prbs_lock_state_pack(bcmolt_prbs_lock_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_prbs_lock_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_prbs_lock_state_unpack(bcmolt_prbs_lock_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_raman_mitigation_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_raman_mitigation_mode_pack(bcmolt_raman_mitigation_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_raman_mitigation_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_raman_mitigation_mode_unpack(bcmolt_raman_mitigation_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_ranging_fail_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_ranging_fail_reason_pack(bcmolt_ranging_fail_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ranging_fail_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_ranging_fail_reason_unpack(bcmolt_ranging_fail_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_registration_behavior to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_registration_behavior_pack(bcmolt_registration_behavior this, bcmolt_buf *buf);

/** Unpacks a bcmolt_registration_behavior from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_registration_behavior_unpack(bcmolt_registration_behavior *this, bcmolt_buf *buf);

/** Packs a bcmolt_request_registration_fail_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_request_registration_fail_reason_pack(bcmolt_request_registration_fail_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_request_registration_fail_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_request_registration_fail_reason_unpack(bcmolt_request_registration_fail_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_result to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_result_pack(bcmolt_result this, bcmolt_buf *buf);

/** Unpacks a bcmolt_result from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_result_unpack(bcmolt_result *this, bcmolt_buf *buf);

/** Packs a bcmolt_rogue_detection_algorithm_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_rogue_detection_algorithm_type_pack(bcmolt_rogue_detection_algorithm_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_rogue_detection_algorithm_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_rogue_detection_algorithm_type_unpack(bcmolt_rogue_detection_algorithm_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_rogue_detection_window to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_rogue_detection_window_pack(bcmolt_rogue_detection_window this, bcmolt_buf *buf);

/** Unpacks a bcmolt_rogue_detection_window from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_rogue_detection_window_unpack(bcmolt_rogue_detection_window *this, bcmolt_buf *buf);

/** Packs a bcmolt_rogue_measurement_result to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_rogue_measurement_result_pack(bcmolt_rogue_measurement_result this, bcmolt_buf *buf);

/** Unpacks a bcmolt_rogue_measurement_result from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_rogue_measurement_result_unpack(bcmolt_rogue_measurement_result *this, bcmolt_buf *buf);

/** Packs a bcmolt_rogue_scan_status to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_rogue_scan_status_pack(bcmolt_rogue_scan_status this, bcmolt_buf *buf);

/** Unpacks a bcmolt_rogue_scan_status from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_rogue_scan_status_unpack(bcmolt_rogue_scan_status *this, bcmolt_buf *buf);

/** Packs a bcmolt_rssi_measurement_fail_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_rssi_measurement_fail_reason_pack(bcmolt_rssi_measurement_fail_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_rssi_measurement_fail_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_rssi_measurement_fail_reason_unpack(bcmolt_rssi_measurement_fail_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_secure_mutual_authentication_fail_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_secure_mutual_authentication_fail_reason_pack(bcmolt_secure_mutual_authentication_fail_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_secure_mutual_authentication_fail_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_secure_mutual_authentication_fail_reason_unpack(bcmolt_secure_mutual_authentication_fail_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_serdes_ranging_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_serdes_ranging_mode_pack(bcmolt_serdes_ranging_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_serdes_ranging_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_serdes_ranging_mode_unpack(bcmolt_serdes_ranging_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_serdes_instance to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_serdes_instance_pack(bcmolt_serdes_instance this, bcmolt_buf *buf);

/** Unpacks a bcmolt_serdes_instance from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_serdes_instance_unpack(bcmolt_serdes_instance *this, bcmolt_buf *buf);

/** Packs a bcmolt_shaper_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_shaper_mode_pack(bcmolt_shaper_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_shaper_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_shaper_mode_unpack(bcmolt_shaper_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_software_error_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_software_error_cfg_id_pack(bcmolt_software_error_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_software_error_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_software_error_cfg_id_unpack(bcmolt_software_error_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_software_error_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_software_error_key_id_pack(bcmolt_software_error_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_software_error_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_software_error_key_id_unpack(bcmolt_software_error_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_stat_condition_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_stat_condition_type_pack(bcmolt_stat_condition_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_stat_condition_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_stat_condition_type_unpack(bcmolt_stat_condition_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_switch_over_type_c_onu_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_switch_over_type_c_onu_state_pack(bcmolt_switch_over_type_c_onu_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_switch_over_type_c_onu_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_switch_over_type_c_onu_state_unpack(bcmolt_switch_over_type_c_onu_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_system_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_system_mode_pack(bcmolt_system_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_system_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_system_mode_unpack(bcmolt_system_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_us_operating_wavelength_bands to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_us_operating_wavelength_bands_pack(bcmolt_us_operating_wavelength_bands this, bcmolt_buf *buf);

/** Unpacks a bcmolt_us_operating_wavelength_bands from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_us_operating_wavelength_bands_unpack(bcmolt_us_operating_wavelength_bands *this, bcmolt_buf *buf);

/** Packs a bcmolt_traffic_resume_result to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_traffic_resume_result_pack(bcmolt_traffic_resume_result this, bcmolt_buf *buf);

/** Unpacks a bcmolt_traffic_resume_result from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_traffic_resume_result_unpack(bcmolt_traffic_resume_result *this, bcmolt_buf *buf);

/** Packs a bcmolt_trx_calibration_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trx_calibration_auto_cfg_id_pack(bcmolt_trx_calibration_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trx_calibration_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trx_calibration_auto_cfg_id_unpack(bcmolt_trx_calibration_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_trx_calibration_capture_window_and_statistic_completed_id to 
 * bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trx_calibration_capture_window_and_statistic_completed_id_pack(bcmolt_trx_calibration_capture_window_and_statistic_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trx_calibration_capture_window_and_statistic_completed_id 
 * from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trx_calibration_capture_window_and_statistic_completed_id_unpack(bcmolt_trx_calibration_capture_window_and_statistic_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_trx_calibration_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trx_calibration_key_id_pack(bcmolt_trx_calibration_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trx_calibration_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trx_calibration_key_id_unpack(bcmolt_trx_calibration_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_trx_calibration_start_capture_window_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trx_calibration_start_capture_window_id_pack(bcmolt_trx_calibration_start_capture_window_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trx_calibration_start_capture_window_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trx_calibration_start_capture_window_id_unpack(bcmolt_trx_calibration_start_capture_window_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_trx_calibration_stop_capture_window_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trx_calibration_stop_capture_window_id_pack(bcmolt_trx_calibration_stop_capture_window_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trx_calibration_stop_capture_window_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trx_calibration_stop_capture_window_id_unpack(bcmolt_trx_calibration_stop_capture_window_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_trx_calibration_trigger to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trx_calibration_trigger_pack(bcmolt_trx_calibration_trigger this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trx_calibration_trigger from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trx_calibration_trigger_unpack(bcmolt_trx_calibration_trigger *this, bcmolt_buf *buf);

/** Packs a bcmolt_trx_calibration_trigger_position to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trx_calibration_trigger_position_pack(bcmolt_trx_calibration_trigger_position this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trx_calibration_trigger_position from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trx_calibration_trigger_position_unpack(bcmolt_trx_calibration_trigger_position *this, bcmolt_buf *buf);

/** Packs a bcmolt_trx_calibration_window_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trx_calibration_window_mode_pack(bcmolt_trx_calibration_window_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trx_calibration_window_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trx_calibration_window_mode_unpack(bcmolt_trx_calibration_window_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_trx_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_trx_type_pack(bcmolt_trx_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_trx_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_trx_type_unpack(bcmolt_trx_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_tune_in_fail_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_tune_in_fail_reason_pack(bcmolt_tune_in_fail_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_tune_in_fail_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_tune_in_fail_reason_unpack(bcmolt_tune_in_fail_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_tune_out_fail_reason to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_tune_out_fail_reason_pack(bcmolt_tune_out_fail_reason this, bcmolt_buf *buf);

/** Unpacks a bcmolt_tune_out_fail_reason from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_tune_out_fail_reason_unpack(bcmolt_tune_out_fail_reason *this, bcmolt_buf *buf);

/** Packs a bcmolt_uart_baudrate to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_uart_baudrate_pack(bcmolt_uart_baudrate this, bcmolt_buf *buf);

/** Unpacks a bcmolt_uart_baudrate from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_uart_baudrate_unpack(bcmolt_uart_baudrate *this, bcmolt_buf *buf);

/** Packs a bcmolt_us_gem_port_destination to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_us_gem_port_destination_pack(bcmolt_us_gem_port_destination this, bcmolt_buf *buf);

/** Unpacks a bcmolt_us_gem_port_destination from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_us_gem_port_destination_unpack(bcmolt_us_gem_port_destination *this, bcmolt_buf *buf);

/** Packs a bcmolt_us_vlan_action to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_us_vlan_action_pack(bcmolt_us_vlan_action this, bcmolt_buf *buf);

/** Unpacks a bcmolt_us_vlan_action from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_us_vlan_action_unpack(bcmolt_us_vlan_action *this, bcmolt_buf *buf);

/** Packs a bcmolt_vlan_to_flow_mapping_method to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_vlan_to_flow_mapping_method_pack(bcmolt_vlan_to_flow_mapping_method this, bcmolt_buf *buf);

/** Unpacks a bcmolt_vlan_to_flow_mapping_method from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_vlan_to_flow_mapping_method_unpack(bcmolt_vlan_to_flow_mapping_method *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_auto_cfg_id_pack(bcmolt_xgpon_alloc_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_auto_cfg_id_unpack(bcmolt_xgpon_alloc_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_cfg_id_pack(bcmolt_xgpon_alloc_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_cfg_id_unpack(bcmolt_xgpon_alloc_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_configuration_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_configuration_completed_id_pack(bcmolt_xgpon_alloc_configuration_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_configuration_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_configuration_completed_id_unpack(bcmolt_xgpon_alloc_configuration_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_get_alloc_stats_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_get_alloc_stats_completed_id_pack(bcmolt_xgpon_alloc_get_alloc_stats_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_get_alloc_stats_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_get_alloc_stats_completed_id_unpack(bcmolt_xgpon_alloc_get_alloc_stats_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_get_stats_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_get_stats_id_pack(bcmolt_xgpon_alloc_get_stats_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_get_stats_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_get_stats_id_unpack(bcmolt_xgpon_alloc_get_stats_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_key_id_pack(bcmolt_xgpon_alloc_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_key_id_unpack(bcmolt_xgpon_alloc_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_set_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_set_state_id_pack(bcmolt_xgpon_alloc_set_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_set_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_set_state_id_unpack(bcmolt_xgpon_alloc_set_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_stat_alarm_cleared_id_pack(bcmolt_xgpon_alloc_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_stat_alarm_cleared_id_unpack(bcmolt_xgpon_alloc_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_stat_alarm_raised_id_pack(bcmolt_xgpon_alloc_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_stat_alarm_raised_id_unpack(bcmolt_xgpon_alloc_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_stat_cfg_id_pack(bcmolt_xgpon_alloc_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_stat_cfg_id_unpack(bcmolt_xgpon_alloc_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_alloc_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_stat_id_pack(bcmolt_xgpon_alloc_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_alloc_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_alloc_stat_id_unpack(bcmolt_xgpon_alloc_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_gem_port_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_auto_cfg_id_pack(bcmolt_xgpon_gem_port_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_gem_port_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_auto_cfg_id_unpack(bcmolt_xgpon_gem_port_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_gem_port_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_cfg_id_pack(bcmolt_xgpon_gem_port_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_gem_port_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_cfg_id_unpack(bcmolt_xgpon_gem_port_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_gem_port_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_key_id_pack(bcmolt_xgpon_gem_port_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_gem_port_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_key_id_unpack(bcmolt_xgpon_gem_port_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_gem_port_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_stat_alarm_cleared_id_pack(bcmolt_xgpon_gem_port_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_gem_port_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_stat_alarm_cleared_id_unpack(bcmolt_xgpon_gem_port_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_gem_port_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_stat_alarm_raised_id_pack(bcmolt_xgpon_gem_port_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_gem_port_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_stat_alarm_raised_id_unpack(bcmolt_xgpon_gem_port_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_gem_port_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_stat_cfg_id_pack(bcmolt_xgpon_gem_port_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_gem_port_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_stat_cfg_id_unpack(bcmolt_xgpon_gem_port_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_gem_port_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_stat_id_pack(bcmolt_xgpon_gem_port_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_gem_port_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_stat_id_unpack(bcmolt_xgpon_gem_port_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_gem_port_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_state_pack(bcmolt_xgpon_gem_port_state this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_gem_port_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_gem_port_state_unpack(bcmolt_xgpon_gem_port_state *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_iwf_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_iwf_cfg_id_pack(bcmolt_xgpon_iwf_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_iwf_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_iwf_cfg_id_unpack(bcmolt_xgpon_iwf_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_iwf_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_iwf_key_id_pack(bcmolt_xgpon_iwf_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_iwf_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_iwf_key_id_unpack(bcmolt_xgpon_iwf_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_activate_all_onus_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_activate_all_onus_completed_id_pack(bcmolt_xgpon_ni_activate_all_onus_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_activate_all_onus_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_activate_all_onus_completed_id_unpack(bcmolt_xgpon_ni_activate_all_onus_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_adjust_tx_wavelength_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_adjust_tx_wavelength_id_pack(bcmolt_xgpon_ni_adjust_tx_wavelength_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_adjust_tx_wavelength_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_adjust_tx_wavelength_id_unpack(bcmolt_xgpon_ni_adjust_tx_wavelength_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_auto_cfg_id_pack(bcmolt_xgpon_ni_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_auto_cfg_id_unpack(bcmolt_xgpon_ni_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_broadcast_ploam_packet_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_broadcast_ploam_packet_id_pack(bcmolt_xgpon_ni_broadcast_ploam_packet_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_broadcast_ploam_packet_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_broadcast_ploam_packet_id_unpack(bcmolt_xgpon_ni_broadcast_ploam_packet_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_cfg_id_pack(bcmolt_xgpon_ni_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_cfg_id_unpack(bcmolt_xgpon_ni_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_cpu_packets_failure_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_cpu_packets_failure_id_pack(bcmolt_xgpon_ni_cpu_packets_failure_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_cpu_packets_failure_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_cpu_packets_failure_id_unpack(bcmolt_xgpon_ni_cpu_packets_failure_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_cpu_packets_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_cpu_packets_id_pack(bcmolt_xgpon_ni_cpu_packets_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_cpu_packets_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_cpu_packets_id_unpack(bcmolt_xgpon_ni_cpu_packets_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_deactivate_all_onus_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_deactivate_all_onus_completed_id_pack(bcmolt_xgpon_ni_deactivate_all_onus_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_deactivate_all_onus_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_deactivate_all_onus_completed_id_unpack(bcmolt_xgpon_ni_deactivate_all_onus_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_disable_all_onus_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_disable_all_onus_completed_id_pack(bcmolt_xgpon_ni_disable_all_onus_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_disable_all_onus_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_disable_all_onus_completed_id_unpack(bcmolt_xgpon_ni_disable_all_onus_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_disable_serial_number_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_disable_serial_number_id_pack(bcmolt_xgpon_ni_disable_serial_number_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_disable_serial_number_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_disable_serial_number_id_unpack(bcmolt_xgpon_ni_disable_serial_number_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_enable_all_onus_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_enable_all_onus_completed_id_pack(bcmolt_xgpon_ni_enable_all_onus_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_enable_all_onus_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_enable_all_onus_completed_id_unpack(bcmolt_xgpon_ni_enable_all_onus_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_key_id_pack(bcmolt_xgpon_ni_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_key_id_unpack(bcmolt_xgpon_ni_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_los_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_los_id_pack(bcmolt_xgpon_ni_los_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_los_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_los_id_unpack(bcmolt_xgpon_ni_los_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_onu_discovered_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_onu_discovered_id_pack(bcmolt_xgpon_ni_onu_discovered_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_onu_discovered_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_onu_discovered_id_unpack(bcmolt_xgpon_ni_onu_discovered_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_onu_upgrade_complete_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_onu_upgrade_complete_id_pack(bcmolt_xgpon_ni_onu_upgrade_complete_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_onu_upgrade_complete_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_onu_upgrade_complete_id_unpack(bcmolt_xgpon_ni_onu_upgrade_complete_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_protection_switching_onus_ranged_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_protection_switching_onus_ranged_id_pack(bcmolt_xgpon_ni_protection_switching_onus_ranged_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_protection_switching_onus_ranged_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_protection_switching_onus_ranged_id_unpack(bcmolt_xgpon_ni_protection_switching_onus_ranged_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_protection_switching_switchover_completed_id to 
 * bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_protection_switching_switchover_completed_id_pack(bcmolt_xgpon_ni_protection_switching_switchover_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_protection_switching_switchover_completed_id from 
 * bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_protection_switching_switchover_completed_id_unpack(bcmolt_xgpon_ni_protection_switching_switchover_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_protection_switching_traffic_resume_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_protection_switching_traffic_resume_id_pack(bcmolt_xgpon_ni_protection_switching_traffic_resume_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_protection_switching_traffic_resume_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_protection_switching_traffic_resume_id_unpack(bcmolt_xgpon_ni_protection_switching_traffic_resume_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_reset_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_reset_id_pack(bcmolt_xgpon_ni_reset_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_reset_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_reset_id_unpack(bcmolt_xgpon_ni_reset_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_rogue_detection_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_rogue_detection_completed_id_pack(bcmolt_xgpon_ni_rogue_detection_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_rogue_detection_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_rogue_detection_completed_id_unpack(bcmolt_xgpon_ni_rogue_detection_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_rogue_detection_window_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_rogue_detection_window_id_pack(bcmolt_xgpon_ni_rogue_detection_window_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_rogue_detection_window_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_rogue_detection_window_id_unpack(bcmolt_xgpon_ni_rogue_detection_window_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id_pack(bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id_unpack(bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_run_special_bw_map_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_run_special_bw_map_id_pack(bcmolt_xgpon_ni_run_special_bw_map_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_run_special_bw_map_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_run_special_bw_map_id_unpack(bcmolt_xgpon_ni_run_special_bw_map_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id_pack(bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id from 
 * bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id_unpack(bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_set_onu_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_set_onu_state_id_pack(bcmolt_xgpon_ni_set_onu_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_set_onu_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_set_onu_state_id_unpack(bcmolt_xgpon_ni_set_onu_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_set_pon_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_set_pon_state_id_pack(bcmolt_xgpon_ni_set_pon_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_set_pon_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_set_pon_state_id_unpack(bcmolt_xgpon_ni_set_pon_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id_pack(bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id from 
 * bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id_unpack(bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id_pack(bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id from 
 * bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id_unpack(bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_start_onu_upgrade_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_start_onu_upgrade_id_pack(bcmolt_xgpon_ni_start_onu_upgrade_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_start_onu_upgrade_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_start_onu_upgrade_id_unpack(bcmolt_xgpon_ni_start_onu_upgrade_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_stat_alarm_cleared_id_pack(bcmolt_xgpon_ni_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_stat_alarm_cleared_id_unpack(bcmolt_xgpon_ni_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_stat_alarm_raised_id_pack(bcmolt_xgpon_ni_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_stat_alarm_raised_id_unpack(bcmolt_xgpon_ni_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_stat_cfg_id_pack(bcmolt_xgpon_ni_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_stat_cfg_id_unpack(bcmolt_xgpon_ni_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_stat_id_pack(bcmolt_xgpon_ni_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_stat_id_unpack(bcmolt_xgpon_ni_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_state_change_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_state_change_completed_id_pack(bcmolt_xgpon_ni_state_change_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_state_change_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_state_change_completed_id_unpack(bcmolt_xgpon_ni_state_change_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_tod_request_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_tod_request_completed_id_pack(bcmolt_xgpon_ni_tod_request_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_tod_request_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_tod_request_completed_id_unpack(bcmolt_xgpon_ni_tod_request_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_ni_tod_request_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_tod_request_id_pack(bcmolt_xgpon_ni_tod_request_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_ni_tod_request_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_ni_tod_request_id_unpack(bcmolt_xgpon_ni_tod_request_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_num_of_onus to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_num_of_onus_pack(bcmolt_xgpon_num_of_onus this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_num_of_onus from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_num_of_onus_unpack(bcmolt_xgpon_num_of_onus *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_adjust_tx_wavelength_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_adjust_tx_wavelength_id_pack(bcmolt_xgpon_onu_adjust_tx_wavelength_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_adjust_tx_wavelength_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_adjust_tx_wavelength_id_unpack(bcmolt_xgpon_onu_adjust_tx_wavelength_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_auto_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_auto_cfg_id_pack(bcmolt_xgpon_onu_auto_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_auto_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_auto_cfg_id_unpack(bcmolt_xgpon_onu_auto_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_cfg_id_pack(bcmolt_xgpon_onu_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_cfg_id_unpack(bcmolt_xgpon_onu_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_change_power_levelling_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_change_power_levelling_id_pack(bcmolt_xgpon_onu_change_power_levelling_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_change_power_levelling_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_change_power_levelling_id_unpack(bcmolt_xgpon_onu_change_power_levelling_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_cpu_packet_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_cpu_packet_id_pack(bcmolt_xgpon_onu_cpu_packet_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_cpu_packet_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_cpu_packet_id_unpack(bcmolt_xgpon_onu_cpu_packet_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_cpu_packets_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_cpu_packets_id_pack(bcmolt_xgpon_onu_cpu_packets_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_cpu_packets_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_cpu_packets_id_unpack(bcmolt_xgpon_onu_cpu_packets_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_dfi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_dfi_id_pack(bcmolt_xgpon_onu_dfi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_dfi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_dfi_id_unpack(bcmolt_xgpon_onu_dfi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_dgi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_dgi_id_pack(bcmolt_xgpon_onu_dgi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_dgi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_dgi_id_unpack(bcmolt_xgpon_onu_dgi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_dowi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_dowi_id_pack(bcmolt_xgpon_onu_dowi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_dowi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_dowi_id_unpack(bcmolt_xgpon_onu_dowi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_get_power_consumption_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_get_power_consumption_id_pack(bcmolt_xgpon_onu_get_power_consumption_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_get_power_consumption_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_get_power_consumption_id_unpack(bcmolt_xgpon_onu_get_power_consumption_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_get_power_level_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_get_power_level_id_pack(bcmolt_xgpon_onu_get_power_level_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_get_power_level_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_get_power_level_id_unpack(bcmolt_xgpon_onu_get_power_level_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_invalid_dbru_report_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_invalid_dbru_report_id_pack(bcmolt_xgpon_onu_invalid_dbru_report_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_invalid_dbru_report_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_invalid_dbru_report_id_unpack(bcmolt_xgpon_onu_invalid_dbru_report_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_key_exchange_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_exchange_completed_id_pack(bcmolt_xgpon_onu_key_exchange_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_key_exchange_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_exchange_completed_id_unpack(bcmolt_xgpon_onu_key_exchange_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_key_exchange_cycle_skipped_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_exchange_cycle_skipped_id_pack(bcmolt_xgpon_onu_key_exchange_cycle_skipped_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_key_exchange_cycle_skipped_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_exchange_cycle_skipped_id_unpack(bcmolt_xgpon_onu_key_exchange_cycle_skipped_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_key_exchange_key_mismatch_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_exchange_key_mismatch_id_pack(bcmolt_xgpon_onu_key_exchange_key_mismatch_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_key_exchange_key_mismatch_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_exchange_key_mismatch_id_unpack(bcmolt_xgpon_onu_key_exchange_key_mismatch_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_key_exchange_key_request_timeout_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_exchange_key_request_timeout_id_pack(bcmolt_xgpon_onu_key_exchange_key_request_timeout_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_key_exchange_key_request_timeout_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_exchange_key_request_timeout_id_unpack(bcmolt_xgpon_onu_key_exchange_key_request_timeout_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_id_pack(bcmolt_xgpon_onu_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_key_id_unpack(bcmolt_xgpon_onu_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_looci_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_looci_id_pack(bcmolt_xgpon_onu_looci_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_looci_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_looci_id_unpack(bcmolt_xgpon_onu_looci_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_omci_packet_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_omci_packet_id_pack(bcmolt_xgpon_onu_omci_packet_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_omci_packet_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_omci_packet_id_unpack(bcmolt_xgpon_onu_omci_packet_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_onu_activation_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_activation_completed_id_pack(bcmolt_xgpon_onu_onu_activation_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_onu_activation_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_activation_completed_id_unpack(bcmolt_xgpon_onu_onu_activation_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_onu_alarm_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_alarm_id_pack(bcmolt_xgpon_onu_onu_alarm_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_onu_alarm_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_alarm_id_unpack(bcmolt_xgpon_onu_onu_alarm_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_onu_deactivation_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_deactivation_completed_id_pack(bcmolt_xgpon_onu_onu_deactivation_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_onu_deactivation_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_deactivation_completed_id_unpack(bcmolt_xgpon_onu_onu_deactivation_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_onu_disable_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_disable_completed_id_pack(bcmolt_xgpon_onu_onu_disable_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_onu_disable_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_disable_completed_id_unpack(bcmolt_xgpon_onu_onu_disable_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_onu_enable_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_enable_completed_id_pack(bcmolt_xgpon_onu_onu_enable_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_onu_enable_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_enable_completed_id_unpack(bcmolt_xgpon_onu_onu_enable_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_onu_tuning_in_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_tuning_in_completed_id_pack(bcmolt_xgpon_onu_onu_tuning_in_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_onu_tuning_in_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_tuning_in_completed_id_unpack(bcmolt_xgpon_onu_onu_tuning_in_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_onu_tuning_in_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_tuning_in_id_pack(bcmolt_xgpon_onu_onu_tuning_in_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_onu_tuning_in_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_tuning_in_id_unpack(bcmolt_xgpon_onu_onu_tuning_in_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_onu_tuning_out_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_tuning_out_completed_id_pack(bcmolt_xgpon_onu_onu_tuning_out_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_onu_tuning_out_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_tuning_out_completed_id_unpack(bcmolt_xgpon_onu_onu_tuning_out_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_onu_tuning_out_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_tuning_out_id_pack(bcmolt_xgpon_onu_onu_tuning_out_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_onu_tuning_out_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_onu_tuning_out_id_unpack(bcmolt_xgpon_onu_onu_tuning_out_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_optical_reflection_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_optical_reflection_id_pack(bcmolt_xgpon_onu_optical_reflection_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_optical_reflection_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_optical_reflection_id_unpack(bcmolt_xgpon_onu_optical_reflection_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_ploam_packet_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_ploam_packet_id_pack(bcmolt_xgpon_onu_ploam_packet_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_ploam_packet_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_ploam_packet_id_unpack(bcmolt_xgpon_onu_ploam_packet_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_possible_drift_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_possible_drift_id_pack(bcmolt_xgpon_onu_possible_drift_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_possible_drift_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_possible_drift_id_unpack(bcmolt_xgpon_onu_possible_drift_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_power_consumption_report_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_power_consumption_report_id_pack(bcmolt_xgpon_onu_power_consumption_report_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_power_consumption_report_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_power_consumption_report_id_unpack(bcmolt_xgpon_onu_power_consumption_report_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_power_level_report_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_power_level_report_id_pack(bcmolt_xgpon_onu_power_level_report_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_power_level_report_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_power_level_report_id_unpack(bcmolt_xgpon_onu_power_level_report_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_power_management_state_change_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_power_management_state_change_id_pack(bcmolt_xgpon_onu_power_management_state_change_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_power_management_state_change_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_power_management_state_change_id_unpack(bcmolt_xgpon_onu_power_management_state_change_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_pqsi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_pqsi_id_pack(bcmolt_xgpon_onu_pqsi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_pqsi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_pqsi_id_unpack(bcmolt_xgpon_onu_pqsi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_ranging_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_ranging_completed_id_pack(bcmolt_xgpon_onu_ranging_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_ranging_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_ranging_completed_id_unpack(bcmolt_xgpon_onu_ranging_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_registration_id_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_registration_id_id_pack(bcmolt_xgpon_onu_registration_id_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_registration_id_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_registration_id_id_unpack(bcmolt_xgpon_onu_registration_id_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_request_registration_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_request_registration_id_pack(bcmolt_xgpon_onu_request_registration_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_request_registration_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_request_registration_id_unpack(bcmolt_xgpon_onu_request_registration_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_rssi_measurement_completed_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_rssi_measurement_completed_id_pack(bcmolt_xgpon_onu_rssi_measurement_completed_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_rssi_measurement_completed_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_rssi_measurement_completed_id_unpack(bcmolt_xgpon_onu_rssi_measurement_completed_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_rssi_measurement_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_rssi_measurement_id_pack(bcmolt_xgpon_onu_rssi_measurement_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_rssi_measurement_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_rssi_measurement_id_unpack(bcmolt_xgpon_onu_rssi_measurement_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_sdi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_sdi_id_pack(bcmolt_xgpon_onu_sdi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_sdi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_sdi_id_unpack(bcmolt_xgpon_onu_sdi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_secure_mutual_authentication_failure_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_secure_mutual_authentication_failure_id_pack(bcmolt_xgpon_onu_secure_mutual_authentication_failure_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_secure_mutual_authentication_failure_id from 
 * bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_secure_mutual_authentication_failure_id_unpack(bcmolt_xgpon_onu_secure_mutual_authentication_failure_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_secure_mutual_authentication_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_secure_mutual_authentication_id_pack(bcmolt_xgpon_onu_secure_mutual_authentication_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_secure_mutual_authentication_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_secure_mutual_authentication_id_unpack(bcmolt_xgpon_onu_secure_mutual_authentication_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_set_onu_state_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_set_onu_state_id_pack(bcmolt_xgpon_onu_set_onu_state_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_set_onu_state_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_set_onu_state_id_unpack(bcmolt_xgpon_onu_set_onu_state_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_sfi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_sfi_id_pack(bcmolt_xgpon_onu_sfi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_sfi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_sfi_id_unpack(bcmolt_xgpon_onu_sfi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_stat_alarm_cleared_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_stat_alarm_cleared_id_pack(bcmolt_xgpon_onu_stat_alarm_cleared_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_stat_alarm_cleared_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_stat_alarm_cleared_id_unpack(bcmolt_xgpon_onu_stat_alarm_cleared_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_stat_alarm_raised_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_stat_alarm_raised_id_pack(bcmolt_xgpon_onu_stat_alarm_raised_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_stat_alarm_raised_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_stat_alarm_raised_id_unpack(bcmolt_xgpon_onu_stat_alarm_raised_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_stat_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_stat_cfg_id_pack(bcmolt_xgpon_onu_stat_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_stat_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_stat_cfg_id_unpack(bcmolt_xgpon_onu_stat_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_stat_id_pack(bcmolt_xgpon_onu_stat_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_stat_id_unpack(bcmolt_xgpon_onu_stat_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_sufi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_sufi_id_pack(bcmolt_xgpon_onu_sufi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_sufi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_sufi_id_unpack(bcmolt_xgpon_onu_sufi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_tiwi_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_tiwi_id_pack(bcmolt_xgpon_onu_tiwi_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_tiwi_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_tiwi_id_unpack(bcmolt_xgpon_onu_tiwi_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_onu_tuning_response_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_tuning_response_id_pack(bcmolt_xgpon_onu_tuning_response_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_onu_tuning_response_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_onu_tuning_response_id_unpack(bcmolt_xgpon_onu_tuning_response_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_serdes_ranging_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_serdes_ranging_mode_pack(bcmolt_xgpon_serdes_ranging_mode this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_serdes_ranging_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_serdes_ranging_mode_unpack(bcmolt_xgpon_serdes_ranging_mode *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_trx_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_trx_cfg_id_pack(bcmolt_xgpon_trx_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_trx_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_trx_cfg_id_unpack(bcmolt_xgpon_trx_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_trx_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_trx_key_id_pack(bcmolt_xgpon_trx_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_trx_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_trx_key_id_unpack(bcmolt_xgpon_trx_key_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xgpon_trx_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xgpon_trx_type_pack(bcmolt_xgpon_trx_type this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_trx_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xgpon_trx_type_unpack(bcmolt_xgpon_trx_type *this, bcmolt_buf *buf);

/** Packs a bcmolt_xpon_serdes_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xpon_serdes_cfg_id_pack(bcmolt_xpon_serdes_cfg_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xpon_serdes_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xpon_serdes_cfg_id_unpack(bcmolt_xpon_serdes_cfg_id *this, bcmolt_buf *buf);

/** Packs a bcmolt_xpon_serdes_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmolt_xpon_serdes_key_id_pack(bcmolt_xpon_serdes_key_id this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xpon_serdes_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmolt_xpon_serdes_key_id_unpack(bcmolt_xpon_serdes_key_id *this, bcmolt_buf *buf);

/** Initializes a bcmolt_actual_schedulershaper struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_actual_schedulershaper_set_default(bcmolt_actual_schedulershaper *this);

/** Packs a bcmolt_actual_schedulershaper to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_actual_schedulershaper_pack(const bcmolt_actual_schedulershaper *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_actual_schedulershaper from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_actual_schedulershaper_unpack(bcmolt_actual_schedulershaper *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_actual_schedulershaper struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_actual_schedulershaper_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_actual_schedulershaper is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_actual_schedulershaper_bounds_check(const bcmolt_actual_schedulershaper *this);

/** Initializes a bcmolt_aes_key struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_aes_key_set_default(bcmolt_aes_key *this);

/** Packs a bcmolt_aes_key to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_aes_key_pack(const bcmolt_aes_key *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_aes_key from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_aes_key_unpack(bcmolt_aes_key *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_aes_key struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_aes_key_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_aes_key is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_aes_key_bounds_check(const bcmolt_aes_key *this);

/** Initializes a bcmolt_api_capture_buffer_reader struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_api_capture_buffer_reader_set_default(bcmolt_api_capture_buffer_reader *this);

/** Packs a bcmolt_api_capture_buffer_reader to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_api_capture_buffer_reader_pack(const bcmolt_api_capture_buffer_reader *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_api_capture_buffer_reader from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_api_capture_buffer_reader_unpack(bcmolt_api_capture_buffer_reader *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_api_capture_buffer_reader struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_api_capture_buffer_reader_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_api_capture_buffer_reader is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_api_capture_buffer_reader_bounds_check(const bcmolt_api_capture_buffer_reader *this);

/** Initializes a bcmolt_api_capture_config struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_api_capture_config_set_default(bcmolt_api_capture_config *this);

/** Packs a bcmolt_api_capture_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_api_capture_config_pack(const bcmolt_api_capture_config *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_api_capture_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_api_capture_config_unpack(bcmolt_api_capture_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_api_capture_config struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_api_capture_config_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_api_capture_config is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_api_capture_config_bounds_check(const bcmolt_api_capture_config *this);

/** Initializes a bcmolt_api_capture_stats struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_api_capture_stats_set_default(bcmolt_api_capture_stats *this);

/** Packs a bcmolt_api_capture_stats to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_api_capture_stats_pack(const bcmolt_api_capture_stats *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_api_capture_stats from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_api_capture_stats_unpack(bcmolt_api_capture_stats *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_api_capture_stats struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_api_capture_stats_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_api_capture_stats is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_api_capture_stats_bounds_check(const bcmolt_api_capture_stats *this);

/** Initializes a bcmolt_bounds struct.  This sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_bounds_set_default(bcmolt_bounds *this);

/** Packs a bcmolt_bounds to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_bounds_pack(const bcmolt_bounds *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_bounds from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_bounds_unpack(bcmolt_bounds *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_bounds struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_bounds_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_bounds is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_bounds_bounds_check(const bcmolt_bounds *this);

/** Initializes a bcmolt_arr_bounds_8 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_bounds_8_set_default(bcmolt_arr_bounds_8 *this);

/** Packs a bcmolt_arr_bounds_8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_bounds_8_pack(const bcmolt_arr_bounds_8 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_bounds_8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_bounds_8_unpack(bcmolt_arr_bounds_8 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_bounds_8 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_bounds_8_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_bounds_8 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_bounds_8_bounds_check(const bcmolt_arr_bounds_8 *this);

/** Initializes a bcmolt_arr_calibration_record_8 struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_calibration_record_8_set_default(bcmolt_arr_calibration_record_8 *this);

/** Packs a bcmolt_arr_calibration_record_8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_calibration_record_8_pack(const bcmolt_arr_calibration_record_8 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_calibration_record_8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_calibration_record_8_unpack(bcmolt_arr_calibration_record_8 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_calibration_record_8 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_calibration_record_8_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_calibration_record_8 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_calibration_record_8_bounds_check(const bcmolt_arr_calibration_record_8 *this);

/** Initializes a bcmolt_ds_frequency_offset struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ds_frequency_offset_set_default(bcmolt_ds_frequency_offset *this);

/** Packs a bcmolt_ds_frequency_offset to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ds_frequency_offset_pack(const bcmolt_ds_frequency_offset *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ds_frequency_offset from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ds_frequency_offset_unpack(bcmolt_ds_frequency_offset *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ds_frequency_offset struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ds_frequency_offset_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ds_frequency_offset is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ds_frequency_offset_bounds_check(const bcmolt_ds_frequency_offset *this);

/** Initializes a bcmolt_channel_profile struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_channel_profile_set_default(bcmolt_channel_profile *this);

/** Packs a bcmolt_channel_profile to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_channel_profile_pack(const bcmolt_channel_profile *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_channel_profile from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_channel_profile_unpack(bcmolt_channel_profile *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_channel_profile struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_channel_profile_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_channel_profile is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_channel_profile_bounds_check(const bcmolt_channel_profile *this);

/** Initializes a bcmolt_arr_channel_profile_8 struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_channel_profile_8_set_default(bcmolt_arr_channel_profile_8 *this);

/** Packs a bcmolt_arr_channel_profile_8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_channel_profile_8_pack(const bcmolt_arr_channel_profile_8 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_channel_profile_8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_channel_profile_8_unpack(bcmolt_arr_channel_profile_8 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_channel_profile_8 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_channel_profile_8_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_channel_profile_8 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_channel_profile_8_bounds_check(const bcmolt_arr_channel_profile_8 *this);

/** Initializes a bcmolt_power_consumption_channel_report struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_power_consumption_channel_report_set_default(bcmolt_power_consumption_channel_report *this);

/** Packs a bcmolt_power_consumption_channel_report to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_power_consumption_channel_report_pack(const bcmolt_power_consumption_channel_report *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_power_consumption_channel_report from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_power_consumption_channel_report_unpack(bcmolt_power_consumption_channel_report *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_power_consumption_channel_report struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_power_consumption_channel_report_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_power_consumption_channel_report is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_power_consumption_channel_report_bounds_check(const bcmolt_power_consumption_channel_report *this);

/** Initializes a bcmolt_arr_power_consumption_channel_report_8 struct.  This 
 * sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_power_consumption_channel_report_8_set_default(bcmolt_arr_power_consumption_channel_report_8 *this);

/** Packs a bcmolt_arr_power_consumption_channel_report_8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_power_consumption_channel_report_8_pack(const bcmolt_arr_power_consumption_channel_report_8 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_power_consumption_channel_report_8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_power_consumption_channel_report_8_unpack(bcmolt_arr_power_consumption_channel_report_8 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_power_consumption_channel_report_8 struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_power_consumption_channel_report_8_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_power_consumption_channel_report_8 is 
 * out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_power_consumption_channel_report_8_bounds_check(const bcmolt_arr_power_consumption_channel_report_8 *this);

/** Initializes a bcmolt_arr_u16_2 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u16_2_set_default(bcmolt_arr_u16_2 *this);

/** Packs a bcmolt_arr_u16_2 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_2_pack(const bcmolt_arr_u16_2 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u16_2 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_2_unpack(bcmolt_arr_u16_2 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u16_2 struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u16_2_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u16_2 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_2_bounds_check(const bcmolt_arr_u16_2 *this);

/** Initializes a bcmolt_arr_u16_2_hex struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u16_2_hex_set_default(bcmolt_arr_u16_2_hex *this);

/** Packs a bcmolt_arr_u16_2_hex to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_2_hex_pack(const bcmolt_arr_u16_2_hex *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u16_2_hex from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_2_hex_unpack(bcmolt_arr_u16_2_hex *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u16_2_hex struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u16_2_hex_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u16_2_hex is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_2_hex_bounds_check(const bcmolt_arr_u16_2_hex *this);

/** Initializes a bcmolt_arr_u16_5_hex struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u16_5_hex_set_default(bcmolt_arr_u16_5_hex *this);

/** Packs a bcmolt_arr_u16_5_hex to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_5_hex_pack(const bcmolt_arr_u16_5_hex *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u16_5_hex from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_5_hex_unpack(bcmolt_arr_u16_5_hex *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u16_5_hex struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u16_5_hex_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u16_5_hex is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_5_hex_bounds_check(const bcmolt_arr_u16_5_hex *this);

/** Initializes a bcmolt_arr_u16_7 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u16_7_set_default(bcmolt_arr_u16_7 *this);

/** Packs a bcmolt_arr_u16_7 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_7_pack(const bcmolt_arr_u16_7 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u16_7 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_7_unpack(bcmolt_arr_u16_7 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u16_7 struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u16_7_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u16_7 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u16_7_bounds_check(const bcmolt_arr_u16_7 *this);

/** Initializes a bcmolt_arr_u32_6 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u32_6_set_default(bcmolt_arr_u32_6 *this);

/** Packs a bcmolt_arr_u32_6 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u32_6_pack(const bcmolt_arr_u32_6 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u32_6 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u32_6_unpack(bcmolt_arr_u32_6 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u32_6 struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u32_6_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u32_6 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u32_6_bounds_check(const bcmolt_arr_u32_6 *this);

/** Initializes a bcmolt_arr_u8_10 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u8_10_set_default(bcmolt_arr_u8_10 *this);

/** Packs a bcmolt_arr_u8_10 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_10_pack(const bcmolt_arr_u8_10 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u8_10 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_10_unpack(bcmolt_arr_u8_10 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u8_10 struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u8_10_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u8_10 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_10_bounds_check(const bcmolt_arr_u8_10 *this);

/** Initializes a bcmolt_arr_u8_12 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u8_12_set_default(bcmolt_arr_u8_12 *this);

/** Packs a bcmolt_arr_u8_12 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_12_pack(const bcmolt_arr_u8_12 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u8_12 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_12_unpack(bcmolt_arr_u8_12 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u8_12 struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u8_12_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u8_12 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_12_bounds_check(const bcmolt_arr_u8_12 *this);

/** Initializes a bcmolt_arr_u8_13 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u8_13_set_default(bcmolt_arr_u8_13 *this);

/** Packs a bcmolt_arr_u8_13 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_13_pack(const bcmolt_arr_u8_13 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u8_13 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_13_unpack(bcmolt_arr_u8_13 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u8_13 struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u8_13_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u8_13 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_13_bounds_check(const bcmolt_arr_u8_13 *this);

/** Initializes a bcmolt_arr_u8_36 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u8_36_set_default(bcmolt_arr_u8_36 *this);

/** Packs a bcmolt_arr_u8_36 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_36_pack(const bcmolt_arr_u8_36 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u8_36 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_36_unpack(bcmolt_arr_u8_36 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u8_36 struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u8_36_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u8_36 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_36_bounds_check(const bcmolt_arr_u8_36 *this);

/** Initializes a bcmolt_arr_u8_4 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u8_4_set_default(bcmolt_arr_u8_4 *this);

/** Packs a bcmolt_arr_u8_4 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_4_pack(const bcmolt_arr_u8_4 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u8_4 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_4_unpack(bcmolt_arr_u8_4 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u8_4 struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u8_4_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u8_4 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_4_bounds_check(const bcmolt_arr_u8_4 *this);

/** Initializes a bcmolt_arr_u8_40 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_u8_40_set_default(bcmolt_arr_u8_40 *this);

/** Packs a bcmolt_arr_u8_40 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_40_pack(const bcmolt_arr_u8_40 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_u8_40 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_40_unpack(bcmolt_arr_u8_40 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_u8_40 struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_u8_40_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_u8_40 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_u8_40_bounds_check(const bcmolt_arr_u8_40 *this);

/** Initializes a bcmolt_xgpon_burst_profile struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_xgpon_burst_profile_set_default(bcmolt_xgpon_burst_profile *this);

/** Packs a bcmolt_xgpon_burst_profile to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_xgpon_burst_profile_pack(const bcmolt_xgpon_burst_profile *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_burst_profile from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_xgpon_burst_profile_unpack(bcmolt_xgpon_burst_profile *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_xgpon_burst_profile struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_xgpon_burst_profile_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_xgpon_burst_profile is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_xgpon_burst_profile_bounds_check(const bcmolt_xgpon_burst_profile *this);

/** Initializes a bcmolt_arr_xgpon_burst_profile_4 struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_xgpon_burst_profile_4_set_default(bcmolt_arr_xgpon_burst_profile_4 *this);

/** Packs a bcmolt_arr_xgpon_burst_profile_4 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_xgpon_burst_profile_4_pack(const bcmolt_arr_xgpon_burst_profile_4 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_xgpon_burst_profile_4 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_xgpon_burst_profile_4_unpack(bcmolt_arr_xgpon_burst_profile_4 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_xgpon_burst_profile_4 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_xgpon_burst_profile_4_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_xgpon_burst_profile_4 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_xgpon_burst_profile_4_bounds_check(const bcmolt_arr_xgpon_burst_profile_4 *this);

/** Initializes a bcmolt_xgpon_trx_configuration struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_xgpon_trx_configuration_set_default(bcmolt_xgpon_trx_configuration *this);

/** Packs a bcmolt_xgpon_trx_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_xgpon_trx_configuration_pack(const bcmolt_xgpon_trx_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_xgpon_trx_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_xgpon_trx_configuration_unpack(bcmolt_xgpon_trx_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_xgpon_trx_configuration struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_xgpon_trx_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_xgpon_trx_configuration is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_xgpon_trx_configuration_bounds_check(const bcmolt_xgpon_trx_configuration *this);

/** Initializes a bcmolt_arr_xgpon_trx_configuration_4 struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_arr_xgpon_trx_configuration_4_set_default(bcmolt_arr_xgpon_trx_configuration_4 *this);

/** Packs a bcmolt_arr_xgpon_trx_configuration_4 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_xgpon_trx_configuration_4_pack(const bcmolt_arr_xgpon_trx_configuration_4 *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_arr_xgpon_trx_configuration_4 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_xgpon_trx_configuration_4_unpack(bcmolt_arr_xgpon_trx_configuration_4 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_arr_xgpon_trx_configuration_4 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_arr_xgpon_trx_configuration_4_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_arr_xgpon_trx_configuration_4 is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_arr_xgpon_trx_configuration_4_bounds_check(const bcmolt_arr_xgpon_trx_configuration_4 *this);

/** Initializes a bcmolt_automatic_onu_deactivation struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_automatic_onu_deactivation_set_default(bcmolt_automatic_onu_deactivation *this);

/** Packs a bcmolt_automatic_onu_deactivation to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_automatic_onu_deactivation_pack(const bcmolt_automatic_onu_deactivation *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_automatic_onu_deactivation from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_automatic_onu_deactivation_unpack(bcmolt_automatic_onu_deactivation *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_automatic_onu_deactivation struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_automatic_onu_deactivation_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_automatic_onu_deactivation is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_automatic_onu_deactivation_bounds_check(const bcmolt_automatic_onu_deactivation *this);

/** Initializes a bcmolt_resync_control struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_resync_control_set_default(bcmolt_resync_control *this);

/** Packs a bcmolt_resync_control to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_resync_control_pack(const bcmolt_resync_control *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_resync_control from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_resync_control_unpack(bcmolt_resync_control *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_resync_control struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_resync_control_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_resync_control is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_resync_control_bounds_check(const bcmolt_resync_control *this);

/** Initializes a bcmolt_bcdr_resync_pattern_configuration struct.  This sets 
 * all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_bcdr_resync_pattern_configuration_set_default(bcmolt_bcdr_resync_pattern_configuration *this);

/** Packs a bcmolt_bcdr_resync_pattern_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_bcdr_resync_pattern_configuration_pack(const bcmolt_bcdr_resync_pattern_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_bcdr_resync_pattern_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_bcdr_resync_pattern_configuration_unpack(bcmolt_bcdr_resync_pattern_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_bcdr_resync_pattern_configuration struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_bcdr_resync_pattern_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_bcdr_resync_pattern_configuration is out 
 * of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_bcdr_resync_pattern_configuration_bounds_check(const bcmolt_bcdr_resync_pattern_configuration *this);

/** Initializes a bcmolt_ber_monitor_params struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ber_monitor_params_set_default(bcmolt_ber_monitor_params *this);

/** Packs a bcmolt_ber_monitor_params to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ber_monitor_params_pack(const bcmolt_ber_monitor_params *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ber_monitor_params from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ber_monitor_params_unpack(bcmolt_ber_monitor_params *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ber_monitor_params struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ber_monitor_params_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ber_monitor_params is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ber_monitor_params_bounds_check(const bcmolt_ber_monitor_params *this);

/** Initializes a bcmolt_cbr_rt_allocation_profile struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_cbr_rt_allocation_profile_set_default(bcmolt_cbr_rt_allocation_profile *this);

/** Packs a bcmolt_cbr_rt_allocation_profile to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_cbr_rt_allocation_profile_pack(const bcmolt_cbr_rt_allocation_profile *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_cbr_rt_allocation_profile from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_cbr_rt_allocation_profile_unpack(bcmolt_cbr_rt_allocation_profile *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_cbr_rt_allocation_profile struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_cbr_rt_allocation_profile_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_cbr_rt_allocation_profile is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_cbr_rt_allocation_profile_bounds_check(const bcmolt_cbr_rt_allocation_profile *this);

/** Initializes a bcmolt_ddr_test_completed struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ddr_test_completed_set_default(bcmolt_ddr_test_completed *this);

/** Packs a bcmolt_ddr_test_completed to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ddr_test_completed_pack(const bcmolt_ddr_test_completed *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_ddr_test_completed would occupy on 
 * the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_ddr_test_completed_get_packed_length(const bcmolt_ddr_test_completed *this);

/** Unpacks a bcmolt_ddr_test_completed from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ddr_test_completed_unpack(bcmolt_ddr_test_completed *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ddr_test_completed struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ddr_test_completed_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ddr_test_completed is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ddr_test_completed_bounds_check(const bcmolt_ddr_test_completed *this);

/** Initializes a bcmolt_debug_device_cfg struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_debug_device_cfg_set_default(bcmolt_debug_device_cfg *this);

/** Packs a bcmolt_debug_device_cfg to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_debug_device_cfg_pack(const bcmolt_debug_device_cfg *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_debug_device_cfg from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_debug_device_cfg_unpack(bcmolt_debug_device_cfg *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_debug_device_cfg struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_debug_device_cfg_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_debug_device_cfg is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_debug_device_cfg_bounds_check(const bcmolt_debug_device_cfg *this);

/** Initializes a bcmolt_device_nni_speed struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_device_nni_speed_set_default(bcmolt_device_nni_speed *this);

/** Packs a bcmolt_device_nni_speed to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_device_nni_speed_pack(const bcmolt_device_nni_speed *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_device_nni_speed from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_device_nni_speed_unpack(bcmolt_device_nni_speed *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_device_nni_speed struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_device_nni_speed_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_device_nni_speed is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_device_nni_speed_bounds_check(const bcmolt_device_nni_speed *this);

/* \cond UNDOCUMENTED_SYMBOLS */

/** Initializes a bcmolt_dummy_struct_for_embedded_types struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_dummy_struct_for_embedded_types_set_default(bcmolt_dummy_struct_for_embedded_types *this);

/** Packs a bcmolt_dummy_struct_for_embedded_types to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_dummy_struct_for_embedded_types_pack(const bcmolt_dummy_struct_for_embedded_types *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_dummy_struct_for_embedded_types from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_dummy_struct_for_embedded_types_unpack(bcmolt_dummy_struct_for_embedded_types *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_dummy_struct_for_embedded_types struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_dummy_struct_for_embedded_types_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_dummy_struct_for_embedded_types is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_dummy_struct_for_embedded_types_bounds_check(const bcmolt_dummy_struct_for_embedded_types *this);

/* \endcond */

/** Initializes a bcmolt_embedded_image_entry struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_embedded_image_entry_set_default(bcmolt_embedded_image_entry *this);

/** Packs a bcmolt_embedded_image_entry to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_embedded_image_entry_pack(const bcmolt_embedded_image_entry *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_embedded_image_entry from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_embedded_image_entry_unpack(bcmolt_embedded_image_entry *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_embedded_image_entry struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_embedded_image_entry_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_embedded_image_entry is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_embedded_image_entry_bounds_check(const bcmolt_embedded_image_entry *this);

/** Initializes a bcmolt_embedded_image_entry_list_u8 struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_embedded_image_entry_list_u8_set_default(bcmolt_embedded_image_entry_list_u8 *this);

/** Packs a bcmolt_embedded_image_entry_list_u8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_embedded_image_entry_list_u8_pack(const bcmolt_embedded_image_entry_list_u8 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_embedded_image_entry_list_u8 would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_embedded_image_entry_list_u8_get_packed_length(const bcmolt_embedded_image_entry_list_u8 *this);

/** Unpacks a bcmolt_embedded_image_entry_list_u8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_embedded_image_entry_list_u8_unpack(bcmolt_embedded_image_entry_list_u8 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_embedded_image_entry_list_u8 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_embedded_image_entry_list_u8_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_embedded_image_entry_list_u8 is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_embedded_image_entry_list_u8_bounds_check(const bcmolt_embedded_image_entry_list_u8 *this);

/** Initializes a bcmolt_encryption_information_container struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_encryption_information_container_set_default(bcmolt_encryption_information_container *this);

/** Packs a bcmolt_encryption_information_container to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_encryption_information_container_pack(const bcmolt_encryption_information_container *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_encryption_information_container 
 * would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_encryption_information_container_get_packed_length(const bcmolt_encryption_information_container *this);

/** Unpacks a bcmolt_encryption_information_container from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_encryption_information_container_unpack(bcmolt_encryption_information_container *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_encryption_information_container struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_encryption_information_container_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_encryption_information_container is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_encryption_information_container_bounds_check(const bcmolt_encryption_information_container *this);

/** Initializes a bcmolt_epon_clock_transport_configuration struct.  This sets 
 * all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_clock_transport_configuration_set_default(bcmolt_epon_clock_transport_configuration *this);

/** Packs a bcmolt_epon_clock_transport_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_clock_transport_configuration_pack(const bcmolt_epon_clock_transport_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_clock_transport_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_clock_transport_configuration_unpack(bcmolt_epon_clock_transport_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_clock_transport_configuration struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_clock_transport_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_clock_transport_configuration is out 
 * of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_clock_transport_configuration_bounds_check(const bcmolt_epon_clock_transport_configuration *this);

/** Initializes a bcmolt_unknown_link_status struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_unknown_link_status_set_default(bcmolt_unknown_link_status *this);

/** Packs a bcmolt_unknown_link_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_unknown_link_status_pack(const bcmolt_unknown_link_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_unknown_link_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_unknown_link_status_unpack(bcmolt_unknown_link_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_unknown_link_status struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_unknown_link_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_unknown_link_status is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_unknown_link_status_bounds_check(const bcmolt_unknown_link_status *this);

/** Initializes a bcmolt_laser_on_off_status struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_laser_on_off_status_set_default(bcmolt_laser_on_off_status *this);

/** Packs a bcmolt_laser_on_off_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_laser_on_off_status_pack(const bcmolt_laser_on_off_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_laser_on_off_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_laser_on_off_status_unpack(bcmolt_laser_on_off_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_laser_on_off_status struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_laser_on_off_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_laser_on_off_status is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_laser_on_off_status_bounds_check(const bcmolt_laser_on_off_status *this);

/** Initializes a bcmolt_range_status struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_range_status_set_default(bcmolt_range_status *this);

/** Packs a bcmolt_range_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_range_status_pack(const bcmolt_range_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_range_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_range_status_unpack(bcmolt_range_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_range_status struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_range_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_range_status is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_range_status_bounds_check(const bcmolt_range_status *this);

/** Initializes a bcmolt_rogue_status struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_rogue_status_set_default(bcmolt_rogue_status *this);

/** Packs a bcmolt_rogue_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_status_pack(const bcmolt_rogue_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_rogue_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_status_unpack(bcmolt_rogue_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_rogue_status struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_rogue_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_rogue_status is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_status_bounds_check(const bcmolt_rogue_status *this);

/** Initializes a bcmolt_epon_denied_link_alarm_state struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_denied_link_alarm_state_set_default(bcmolt_epon_denied_link_alarm_state *this);

/** Packs a bcmolt_epon_denied_link_alarm_state to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_denied_link_alarm_state_pack(const bcmolt_epon_denied_link_alarm_state *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_denied_link_alarm_state from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_denied_link_alarm_state_unpack(bcmolt_epon_denied_link_alarm_state *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_denied_link_alarm_state struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_denied_link_alarm_state_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_denied_link_alarm_state is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_denied_link_alarm_state_bounds_check(const bcmolt_epon_denied_link_alarm_state *this);

/** Initializes a bcmolt_epon_encryption_config struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_encryption_config_set_default(bcmolt_epon_encryption_config *this);

/** Packs a bcmolt_epon_encryption_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_encryption_config_pack(const bcmolt_epon_encryption_config *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_epon_encryption_config would occupy 
 * on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_epon_encryption_config_get_packed_length(const bcmolt_epon_encryption_config *this);

/** Unpacks a bcmolt_epon_encryption_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_encryption_config_unpack(bcmolt_epon_encryption_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_encryption_config struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_encryption_config_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_encryption_config is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_encryption_config_bounds_check(const bcmolt_epon_encryption_config *this);

/** Initializes a bcmolt_epon_key_exchange_config struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_key_exchange_config_set_default(bcmolt_epon_key_exchange_config *this);

/** Packs a bcmolt_epon_key_exchange_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_key_exchange_config_pack(const bcmolt_epon_key_exchange_config *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_key_exchange_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_key_exchange_config_unpack(bcmolt_epon_key_exchange_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_key_exchange_config struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_key_exchange_config_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_key_exchange_config is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_key_exchange_config_bounds_check(const bcmolt_epon_key_exchange_config *this);

/** Initializes a bcmolt_epon_laser_overhead_parameters struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_laser_overhead_parameters_set_default(bcmolt_epon_laser_overhead_parameters *this);

/** Packs a bcmolt_epon_laser_overhead_parameters to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_laser_overhead_parameters_pack(const bcmolt_epon_laser_overhead_parameters *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_laser_overhead_parameters from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_laser_overhead_parameters_unpack(bcmolt_epon_laser_overhead_parameters *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_laser_overhead_parameters struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_laser_overhead_parameters_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_laser_overhead_parameters is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_laser_overhead_parameters_bounds_check(const bcmolt_epon_laser_overhead_parameters *this);

/** Initializes a bcmolt_epon_link_alarm_state struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_link_alarm_state_set_default(bcmolt_epon_link_alarm_state *this);

/** Packs a bcmolt_epon_link_alarm_state to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_link_alarm_state_pack(const bcmolt_epon_link_alarm_state *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_alarm_state from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_link_alarm_state_unpack(bcmolt_epon_link_alarm_state *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_link_alarm_state struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_link_alarm_state_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_link_alarm_state is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_link_alarm_state_bounds_check(const bcmolt_epon_link_alarm_state *this);

/** Initializes a bcmolt_epon_link_fec_en struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_link_fec_en_set_default(bcmolt_epon_link_fec_en *this);

/** Packs a bcmolt_epon_link_fec_en to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_link_fec_en_pack(const bcmolt_epon_link_fec_en *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_fec_en from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_link_fec_en_unpack(bcmolt_epon_link_fec_en *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_link_fec_en struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_link_fec_en_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_link_fec_en is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_link_fec_en_bounds_check(const bcmolt_epon_link_fec_en *this);

/** Initializes a bcmolt_epon_link_info struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_link_info_set_default(bcmolt_epon_link_info *this);

/** Packs a bcmolt_epon_link_info to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_link_info_pack(const bcmolt_epon_link_info *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_link_info from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_link_info_unpack(bcmolt_epon_link_info *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_link_info struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_link_info_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_link_info is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_link_info_bounds_check(const bcmolt_epon_link_info *this);

/** Initializes a bcmolt_gate_parameters struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gate_parameters_set_default(bcmolt_gate_parameters *this);

/** Packs a bcmolt_gate_parameters to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gate_parameters_pack(const bcmolt_gate_parameters *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gate_parameters from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gate_parameters_unpack(bcmolt_gate_parameters *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gate_parameters struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gate_parameters_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gate_parameters is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gate_parameters_bounds_check(const bcmolt_gate_parameters *this);

/** Initializes a bcmolt_gate_parameters_list_u32 struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gate_parameters_list_u32_set_default(bcmolt_gate_parameters_list_u32 *this);

/** Packs a bcmolt_gate_parameters_list_u32 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gate_parameters_list_u32_pack(const bcmolt_gate_parameters_list_u32 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_gate_parameters_list_u32 would occupy 
 * on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gate_parameters_list_u32_get_packed_length(const bcmolt_gate_parameters_list_u32 *this);

/** Unpacks a bcmolt_gate_parameters_list_u32 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gate_parameters_list_u32_unpack(bcmolt_gate_parameters_list_u32 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gate_parameters_list_u32 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gate_parameters_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gate_parameters_list_u32 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gate_parameters_list_u32_bounds_check(const bcmolt_gate_parameters_list_u32 *this);

/** Initializes a bcmolt_epon_registration_gate_mode struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_registration_gate_mode_set_default(bcmolt_epon_registration_gate_mode *this);

/** Packs a bcmolt_epon_registration_gate_mode to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_registration_gate_mode_pack(const bcmolt_epon_registration_gate_mode *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_epon_registration_gate_mode would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_epon_registration_gate_mode_get_packed_length(const bcmolt_epon_registration_gate_mode *this);

/** Unpacks a bcmolt_epon_registration_gate_mode from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_registration_gate_mode_unpack(bcmolt_epon_registration_gate_mode *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_registration_gate_mode struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_registration_gate_mode_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_registration_gate_mode is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_registration_gate_mode_bounds_check(const bcmolt_epon_registration_gate_mode *this);

/** Initializes a bcmolt_epon_logical_link_options struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_logical_link_options_set_default(bcmolt_epon_logical_link_options *this);

/** Packs a bcmolt_epon_logical_link_options to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_logical_link_options_pack(const bcmolt_epon_logical_link_options *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_epon_logical_link_options would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_epon_logical_link_options_get_packed_length(const bcmolt_epon_logical_link_options *this);

/** Unpacks a bcmolt_epon_logical_link_options from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_logical_link_options_unpack(bcmolt_epon_logical_link_options *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_logical_link_options struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_logical_link_options_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_logical_link_options is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_logical_link_options_bounds_check(const bcmolt_epon_logical_link_options *this);

/** Initializes a bcmolt_epon_ni_alarm_state struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_ni_alarm_state_set_default(bcmolt_epon_ni_alarm_state *this);

/** Packs a bcmolt_epon_ni_alarm_state to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_ni_alarm_state_pack(const bcmolt_epon_ni_alarm_state *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_alarm_state from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_ni_alarm_state_unpack(bcmolt_epon_ni_alarm_state *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_ni_alarm_state struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_ni_alarm_state_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_ni_alarm_state is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_ni_alarm_state_bounds_check(const bcmolt_epon_ni_alarm_state *this);

/** Initializes a bcmolt_epon_ni_encryption_cfg struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_ni_encryption_cfg_set_default(bcmolt_epon_ni_encryption_cfg *this);

/** Packs a bcmolt_epon_ni_encryption_cfg to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_ni_encryption_cfg_pack(const bcmolt_epon_ni_encryption_cfg *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_ni_encryption_cfg from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_ni_encryption_cfg_unpack(bcmolt_epon_ni_encryption_cfg *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_ni_encryption_cfg struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_ni_encryption_cfg_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_ni_encryption_cfg is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_ni_encryption_cfg_bounds_check(const bcmolt_epon_ni_encryption_cfg *this);

/** Initializes a bcmolt_epon_onu_upgrade_params struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_onu_upgrade_params_set_default(bcmolt_epon_onu_upgrade_params *this);

/** Packs a bcmolt_epon_onu_upgrade_params to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_onu_upgrade_params_pack(const bcmolt_epon_onu_upgrade_params *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_epon_onu_upgrade_params would occupy 
 * on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_epon_onu_upgrade_params_get_packed_length(const bcmolt_epon_onu_upgrade_params *this);

/** Unpacks a bcmolt_epon_onu_upgrade_params from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_onu_upgrade_params_unpack(bcmolt_epon_onu_upgrade_params *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_onu_upgrade_params struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_onu_upgrade_params_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_onu_upgrade_params is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_onu_upgrade_params_bounds_check(const bcmolt_epon_onu_upgrade_params *this);

/** Initializes a bcmolt_epon_onu_upgrade_status struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_onu_upgrade_status_set_default(bcmolt_epon_onu_upgrade_status *this);

/** Packs a bcmolt_epon_onu_upgrade_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_onu_upgrade_status_pack(const bcmolt_epon_onu_upgrade_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_onu_upgrade_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_onu_upgrade_status_unpack(bcmolt_epon_onu_upgrade_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_onu_upgrade_status struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_onu_upgrade_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_onu_upgrade_status is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_onu_upgrade_status_bounds_check(const bcmolt_epon_onu_upgrade_status *this);

/** Initializes a bcmolt_epon_onu_upgrade_status_list_u32 struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_onu_upgrade_status_list_u32_set_default(bcmolt_epon_onu_upgrade_status_list_u32 *this);

/** Packs a bcmolt_epon_onu_upgrade_status_list_u32 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_onu_upgrade_status_list_u32_pack(const bcmolt_epon_onu_upgrade_status_list_u32 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_epon_onu_upgrade_status_list_u32 
 * would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_epon_onu_upgrade_status_list_u32_get_packed_length(const bcmolt_epon_onu_upgrade_status_list_u32 *this);

/** Unpacks a bcmolt_epon_onu_upgrade_status_list_u32 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_onu_upgrade_status_list_u32_unpack(bcmolt_epon_onu_upgrade_status_list_u32 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_onu_upgrade_status_list_u32 struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_onu_upgrade_status_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_onu_upgrade_status_list_u32 is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_onu_upgrade_status_list_u32_bounds_check(const bcmolt_epon_onu_upgrade_status_list_u32 *this);

/** Initializes a bcmolt_epon_protection_switching_configuration struct.  This 
 * sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_epon_protection_switching_configuration_set_default(bcmolt_epon_protection_switching_configuration *this);

/** Packs a bcmolt_epon_protection_switching_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_protection_switching_configuration_pack(const bcmolt_epon_protection_switching_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_epon_protection_switching_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_protection_switching_configuration_unpack(bcmolt_epon_protection_switching_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_epon_protection_switching_configuration struct 
 * and collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_epon_protection_switching_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_epon_protection_switching_configuration is 
 * out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_epon_protection_switching_configuration_bounds_check(const bcmolt_epon_protection_switching_configuration *this);

/** Initializes a bcmolt_u8_list_u16 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_u8_list_u16_set_default(bcmolt_u8_list_u16 *this);

/** Packs a bcmolt_u8_list_u16 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_u8_list_u16_pack(const bcmolt_u8_list_u16 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_u8_list_u16 would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_u8_list_u16_get_packed_length(const bcmolt_u8_list_u16 *this);

/** Unpacks a bcmolt_u8_list_u16 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_u8_list_u16_unpack(bcmolt_u8_list_u16 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_u8_list_u16 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_u8_list_u16_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_u8_list_u16 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_u8_list_u16_bounds_check(const bcmolt_u8_list_u16 *this);

/** Initializes a bcmolt_ethernet_frame_masked struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ethernet_frame_masked_set_default(bcmolt_ethernet_frame_masked *this);

/** Packs a bcmolt_ethernet_frame_masked to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ethernet_frame_masked_pack(const bcmolt_ethernet_frame_masked *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_ethernet_frame_masked would occupy on 
 * the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_ethernet_frame_masked_get_packed_length(const bcmolt_ethernet_frame_masked *this);

/** Unpacks a bcmolt_ethernet_frame_masked from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ethernet_frame_masked_unpack(bcmolt_ethernet_frame_masked *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ethernet_frame_masked struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ethernet_frame_masked_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ethernet_frame_masked is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ethernet_frame_masked_bounds_check(const bcmolt_ethernet_frame_masked *this);

/** Initializes a bcmolt_ethernet_frame_unmasked struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ethernet_frame_unmasked_set_default(bcmolt_ethernet_frame_unmasked *this);

/** Packs a bcmolt_ethernet_frame_unmasked to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ethernet_frame_unmasked_pack(const bcmolt_ethernet_frame_unmasked *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_ethernet_frame_unmasked would occupy 
 * on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_ethernet_frame_unmasked_get_packed_length(const bcmolt_ethernet_frame_unmasked *this);

/** Unpacks a bcmolt_ethernet_frame_unmasked from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ethernet_frame_unmasked_unpack(bcmolt_ethernet_frame_unmasked *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ethernet_frame_unmasked struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ethernet_frame_unmasked_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ethernet_frame_unmasked is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ethernet_frame_unmasked_bounds_check(const bcmolt_ethernet_frame_unmasked *this);

/** Initializes a bcmolt_extended_guard_time struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_extended_guard_time_set_default(bcmolt_extended_guard_time *this);

/** Packs a bcmolt_extended_guard_time to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_extended_guard_time_pack(const bcmolt_extended_guard_time *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_extended_guard_time from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_extended_guard_time_unpack(bcmolt_extended_guard_time *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_extended_guard_time struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_extended_guard_time_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_extended_guard_time is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_extended_guard_time_bounds_check(const bcmolt_extended_guard_time *this);

/** Initializes a bcmolt_firmware_sw_version struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_firmware_sw_version_set_default(bcmolt_firmware_sw_version *this);

/** Packs a bcmolt_firmware_sw_version to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_firmware_sw_version_pack(const bcmolt_firmware_sw_version *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_firmware_sw_version from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_firmware_sw_version_unpack(bcmolt_firmware_sw_version *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_firmware_sw_version struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_firmware_sw_version_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_firmware_sw_version is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_firmware_sw_version_bounds_check(const bcmolt_firmware_sw_version *this);

/** Initializes a bcmolt_gem_port_configuration struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gem_port_configuration_set_default(bcmolt_gem_port_configuration *this);

/** Packs a bcmolt_gem_port_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gem_port_configuration_pack(const bcmolt_gem_port_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gem_port_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gem_port_configuration_unpack(bcmolt_gem_port_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gem_port_configuration struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gem_port_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gem_port_configuration is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gem_port_configuration_bounds_check(const bcmolt_gem_port_configuration *this);

/** Initializes a bcmolt_gpon_alloc_with_state struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_alloc_with_state_set_default(bcmolt_gpon_alloc_with_state *this);

/** Packs a bcmolt_gpon_alloc_with_state to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_alloc_with_state_pack(const bcmolt_gpon_alloc_with_state *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_alloc_with_state from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_alloc_with_state_unpack(bcmolt_gpon_alloc_with_state *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_alloc_with_state struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_alloc_with_state_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_alloc_with_state is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_alloc_with_state_bounds_check(const bcmolt_gpon_alloc_with_state *this);

/** Initializes a bcmolt_gpon_alloc_with_state_list_u16_max_32 struct.  This 
 * sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_alloc_with_state_list_u16_max_32_set_default(bcmolt_gpon_alloc_with_state_list_u16_max_32 *this);

/** Packs a bcmolt_gpon_alloc_with_state_list_u16_max_32 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_alloc_with_state_list_u16_max_32_pack(const bcmolt_gpon_alloc_with_state_list_u16_max_32 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_gpon_alloc_with_state_list_u16_max_32 
 * would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gpon_alloc_with_state_list_u16_max_32_get_packed_length(const bcmolt_gpon_alloc_with_state_list_u16_max_32 *this);

/** Unpacks a bcmolt_gpon_alloc_with_state_list_u16_max_32 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_alloc_with_state_list_u16_max_32_unpack(bcmolt_gpon_alloc_with_state_list_u16_max_32 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_alloc_with_state_list_u16_max_32 struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_alloc_with_state_list_u16_max_32_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_alloc_with_state_list_u16_max_32 is 
 * out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_alloc_with_state_list_u16_max_32_bounds_check(const bcmolt_gpon_alloc_with_state_list_u16_max_32 *this);

/** Initializes a bcmolt_gpon_debug_flow_config struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_debug_flow_config_set_default(bcmolt_gpon_debug_flow_config *this);

/** Packs a bcmolt_gpon_debug_flow_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_debug_flow_config_pack(const bcmolt_gpon_debug_flow_config *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_debug_flow_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_debug_flow_config_unpack(bcmolt_gpon_debug_flow_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_debug_flow_config struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_debug_flow_config_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_debug_flow_config is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_debug_flow_config_bounds_check(const bcmolt_gpon_debug_flow_config *this);

/** Initializes a bcmolt_gpon_gem_id_list_u8_max_16 struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_gem_id_list_u8_max_16_set_default(bcmolt_gpon_gem_id_list_u8_max_16 *this);

/** Packs a bcmolt_gpon_gem_id_list_u8_max_16 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_id_list_u8_max_16_pack(const bcmolt_gpon_gem_id_list_u8_max_16 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_gpon_gem_id_list_u8_max_16 would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gpon_gem_id_list_u8_max_16_get_packed_length(const bcmolt_gpon_gem_id_list_u8_max_16 *this);

/** Unpacks a bcmolt_gpon_gem_id_list_u8_max_16 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_id_list_u8_max_16_unpack(bcmolt_gpon_gem_id_list_u8_max_16 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_gem_id_list_u8_max_16 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_gem_id_list_u8_max_16_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_gem_id_list_u8_max_16 is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_id_list_u8_max_16_bounds_check(const bcmolt_gpon_gem_id_list_u8_max_16 *this);

/** Initializes a bcmolt_gpon_gem_port_with_state struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_gem_port_with_state_set_default(bcmolt_gpon_gem_port_with_state *this);

/** Packs a bcmolt_gpon_gem_port_with_state to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_pack(const bcmolt_gpon_gem_port_with_state *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_gem_port_with_state from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_unpack(bcmolt_gpon_gem_port_with_state *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_gem_port_with_state struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_gem_port_with_state is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_bounds_check(const bcmolt_gpon_gem_port_with_state *this);

/** Initializes a bcmolt_gpon_gem_port_with_state_list_u16_max_128 struct.  This 
 * sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_gem_port_with_state_list_u16_max_128_set_default(bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this);

/** Packs a bcmolt_gpon_gem_port_with_state_list_u16_max_128 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_128_pack(const bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a 
 * bcmolt_gpon_gem_port_with_state_list_u16_max_128 would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gpon_gem_port_with_state_list_u16_max_128_get_packed_length(const bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this);

/** Unpacks a bcmolt_gpon_gem_port_with_state_list_u16_max_128 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_128_unpack(bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_gem_port_with_state_list_u16_max_128 struct 
 * and collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_128_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_gem_port_with_state_list_u16_max_128 
 * is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_128_bounds_check(const bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this);

/** Initializes a bcmolt_gpon_gem_port_with_state_list_u16_max_256 struct.  This 
 * sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_gem_port_with_state_list_u16_max_256_set_default(bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this);

/** Packs a bcmolt_gpon_gem_port_with_state_list_u16_max_256 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_256_pack(const bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a 
 * bcmolt_gpon_gem_port_with_state_list_u16_max_256 would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gpon_gem_port_with_state_list_u16_max_256_get_packed_length(const bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this);

/** Unpacks a bcmolt_gpon_gem_port_with_state_list_u16_max_256 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_256_unpack(bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_gem_port_with_state_list_u16_max_256 struct 
 * and collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_256_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_gem_port_with_state_list_u16_max_256 
 * is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_256_bounds_check(const bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this);

/** Initializes a bcmolt_gpon_iwf_debug_flow_config struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_iwf_debug_flow_config_set_default(bcmolt_gpon_iwf_debug_flow_config *this);

/** Packs a bcmolt_gpon_iwf_debug_flow_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_iwf_debug_flow_config_pack(const bcmolt_gpon_iwf_debug_flow_config *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_iwf_debug_flow_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_iwf_debug_flow_config_unpack(bcmolt_gpon_iwf_debug_flow_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_iwf_debug_flow_config struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_iwf_debug_flow_config_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_iwf_debug_flow_config is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_iwf_debug_flow_config_bounds_check(const bcmolt_gpon_iwf_debug_flow_config *this);

/** Initializes a bcmolt_gpon_key_exchange struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_key_exchange_set_default(bcmolt_gpon_key_exchange *this);

/** Packs a bcmolt_gpon_key_exchange to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_key_exchange_pack(const bcmolt_gpon_key_exchange *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_key_exchange from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_key_exchange_unpack(bcmolt_gpon_key_exchange *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_key_exchange struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_key_exchange_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_key_exchange is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_key_exchange_bounds_check(const bcmolt_gpon_key_exchange *this);

/** Initializes a bcmolt_gpon_mac_table_scan_result struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_mac_table_scan_result_set_default(bcmolt_gpon_mac_table_scan_result *this);

/** Packs a bcmolt_gpon_mac_table_scan_result to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_mac_table_scan_result_pack(const bcmolt_gpon_mac_table_scan_result *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_mac_table_scan_result from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_mac_table_scan_result_unpack(bcmolt_gpon_mac_table_scan_result *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_mac_table_scan_result struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_mac_table_scan_result_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_mac_table_scan_result is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_mac_table_scan_result_bounds_check(const bcmolt_gpon_mac_table_scan_result *this);

/** Initializes a bcmolt_gpon_mac_table_scan_result_list_u16 struct.  This sets 
 * all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_mac_table_scan_result_list_u16_set_default(bcmolt_gpon_mac_table_scan_result_list_u16 *this);

/** Packs a bcmolt_gpon_mac_table_scan_result_list_u16 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_mac_table_scan_result_list_u16_pack(const bcmolt_gpon_mac_table_scan_result_list_u16 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_gpon_mac_table_scan_result_list_u16 
 * would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gpon_mac_table_scan_result_list_u16_get_packed_length(const bcmolt_gpon_mac_table_scan_result_list_u16 *this);

/** Unpacks a bcmolt_gpon_mac_table_scan_result_list_u16 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_mac_table_scan_result_list_u16_unpack(bcmolt_gpon_mac_table_scan_result_list_u16 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_mac_table_scan_result_list_u16 struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_mac_table_scan_result_list_u16_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_mac_table_scan_result_list_u16 is out 
 * of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_mac_table_scan_result_list_u16_bounds_check(const bcmolt_gpon_mac_table_scan_result_list_u16 *this);

/** Initializes a bcmolt_gpon_ni_debug struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_ni_debug_set_default(bcmolt_gpon_ni_debug *this);

/** Packs a bcmolt_gpon_ni_debug to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_ni_debug_pack(const bcmolt_gpon_ni_debug *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_ni_debug from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_ni_debug_unpack(bcmolt_gpon_ni_debug *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_ni_debug struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_ni_debug_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_ni_debug is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_ni_debug_bounds_check(const bcmolt_gpon_ni_debug *this);

/** Initializes a bcmolt_gpon_onu_activation struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_activation_set_default(bcmolt_gpon_onu_activation *this);

/** Packs a bcmolt_gpon_onu_activation to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_activation_pack(const bcmolt_gpon_onu_activation *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_activation from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_activation_unpack(bcmolt_gpon_onu_activation *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_activation struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_activation_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_activation is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_activation_bounds_check(const bcmolt_gpon_onu_activation *this);

/** Initializes a bcmolt_gpon_onu_alarm_state struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_alarm_state_set_default(bcmolt_gpon_onu_alarm_state *this);

/** Packs a bcmolt_gpon_onu_alarm_state to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_alarm_state_pack(const bcmolt_gpon_onu_alarm_state *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_alarm_state from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_alarm_state_unpack(bcmolt_gpon_onu_alarm_state *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_alarm_state struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_alarm_state_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_alarm_state is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_alarm_state_bounds_check(const bcmolt_gpon_onu_alarm_state *this);

/** Initializes a bcmolt_gpon_onu_alarms struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_alarms_set_default(bcmolt_gpon_onu_alarms *this);

/** Packs a bcmolt_gpon_onu_alarms to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_alarms_pack(const bcmolt_gpon_onu_alarms *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_alarms from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_alarms_unpack(bcmolt_gpon_onu_alarms *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_alarms struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_alarms_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_alarms is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_alarms_bounds_check(const bcmolt_gpon_onu_alarms *this);

/** Initializes a bcmolt_gpon_onu_alarms_thresholds struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_alarms_thresholds_set_default(bcmolt_gpon_onu_alarms_thresholds *this);

/** Packs a bcmolt_gpon_onu_alarms_thresholds to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_alarms_thresholds_pack(const bcmolt_gpon_onu_alarms_thresholds *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_alarms_thresholds from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_alarms_thresholds_unpack(bcmolt_gpon_onu_alarms_thresholds *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_alarms_thresholds struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_alarms_thresholds_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_alarms_thresholds is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_alarms_thresholds_bounds_check(const bcmolt_gpon_onu_alarms_thresholds *this);

/** Initializes a bcmolt_gpon_onu_eqd struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_eqd_set_default(bcmolt_gpon_onu_eqd *this);

/** Packs a bcmolt_gpon_onu_eqd to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_eqd_pack(const bcmolt_gpon_onu_eqd *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_eqd from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_eqd_unpack(bcmolt_gpon_onu_eqd *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_eqd struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_eqd_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_eqd is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_eqd_bounds_check(const bcmolt_gpon_onu_eqd *this);

/** Initializes a bcmolt_gpon_onu_eqd_list_u32 struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_eqd_list_u32_set_default(bcmolt_gpon_onu_eqd_list_u32 *this);

/** Packs a bcmolt_gpon_onu_eqd_list_u32 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_eqd_list_u32_pack(const bcmolt_gpon_onu_eqd_list_u32 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_gpon_onu_eqd_list_u32 would occupy on 
 * the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gpon_onu_eqd_list_u32_get_packed_length(const bcmolt_gpon_onu_eqd_list_u32 *this);

/** Unpacks a bcmolt_gpon_onu_eqd_list_u32 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_eqd_list_u32_unpack(bcmolt_gpon_onu_eqd_list_u32 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_eqd_list_u32 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_eqd_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_eqd_list_u32 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_eqd_list_u32_bounds_check(const bcmolt_gpon_onu_eqd_list_u32 *this);

/** Initializes a bcmolt_gpon_onu_id_list_u32_max_256 struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_id_list_u32_max_256_set_default(bcmolt_gpon_onu_id_list_u32_max_256 *this);

/** Packs a bcmolt_gpon_onu_id_list_u32_max_256 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_id_list_u32_max_256_pack(const bcmolt_gpon_onu_id_list_u32_max_256 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_gpon_onu_id_list_u32_max_256 would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gpon_onu_id_list_u32_max_256_get_packed_length(const bcmolt_gpon_onu_id_list_u32_max_256 *this);

/** Unpacks a bcmolt_gpon_onu_id_list_u32_max_256 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_id_list_u32_max_256_unpack(bcmolt_gpon_onu_id_list_u32_max_256 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_id_list_u32_max_256 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_id_list_u32_max_256_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_id_list_u32_max_256 is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_id_list_u32_max_256_bounds_check(const bcmolt_gpon_onu_id_list_u32_max_256 *this);

/** Initializes a bcmolt_gpon_onu_upgrade_params struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_upgrade_params_set_default(bcmolt_gpon_onu_upgrade_params *this);

/** Packs a bcmolt_gpon_onu_upgrade_params to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_params_pack(const bcmolt_gpon_onu_upgrade_params *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_upgrade_params from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_params_unpack(bcmolt_gpon_onu_upgrade_params *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_upgrade_params struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_params_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_upgrade_params is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_params_bounds_check(const bcmolt_gpon_onu_upgrade_params *this);

/** Initializes a bcmolt_gpon_onu_upgrade_status struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_upgrade_status_set_default(bcmolt_gpon_onu_upgrade_status *this);

/** Packs a bcmolt_gpon_onu_upgrade_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_status_pack(const bcmolt_gpon_onu_upgrade_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_upgrade_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_status_unpack(bcmolt_gpon_onu_upgrade_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_upgrade_status struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_upgrade_status is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_status_bounds_check(const bcmolt_gpon_onu_upgrade_status *this);

/** Initializes a bcmolt_gpon_onu_upgrade_status_list_u32 struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_upgrade_status_list_u32_set_default(bcmolt_gpon_onu_upgrade_status_list_u32 *this);

/** Packs a bcmolt_gpon_onu_upgrade_status_list_u32 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_status_list_u32_pack(const bcmolt_gpon_onu_upgrade_status_list_u32 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_gpon_onu_upgrade_status_list_u32 
 * would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gpon_onu_upgrade_status_list_u32_get_packed_length(const bcmolt_gpon_onu_upgrade_status_list_u32 *this);

/** Unpacks a bcmolt_gpon_onu_upgrade_status_list_u32 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_status_list_u32_unpack(bcmolt_gpon_onu_upgrade_status_list_u32 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_upgrade_status_list_u32 struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_status_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_upgrade_status_list_u32 is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_upgrade_status_list_u32_bounds_check(const bcmolt_gpon_onu_upgrade_status_list_u32 *this);

/** Initializes a bcmolt_gpon_onu_with_state struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_with_state_set_default(bcmolt_gpon_onu_with_state *this);

/** Packs a bcmolt_gpon_onu_with_state to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_with_state_pack(const bcmolt_gpon_onu_with_state *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_onu_with_state from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_with_state_unpack(bcmolt_gpon_onu_with_state *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_with_state struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_with_state_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_with_state is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_with_state_bounds_check(const bcmolt_gpon_onu_with_state *this);

/** Initializes a bcmolt_gpon_onu_with_state_list_u16_max_128 struct.  This sets 
 * all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_onu_with_state_list_u16_max_128_set_default(bcmolt_gpon_onu_with_state_list_u16_max_128 *this);

/** Packs a bcmolt_gpon_onu_with_state_list_u16_max_128 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_with_state_list_u16_max_128_pack(const bcmolt_gpon_onu_with_state_list_u16_max_128 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_gpon_onu_with_state_list_u16_max_128 
 * would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_gpon_onu_with_state_list_u16_max_128_get_packed_length(const bcmolt_gpon_onu_with_state_list_u16_max_128 *this);

/** Unpacks a bcmolt_gpon_onu_with_state_list_u16_max_128 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_with_state_list_u16_max_128_unpack(bcmolt_gpon_onu_with_state_list_u16_max_128 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_onu_with_state_list_u16_max_128 struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_onu_with_state_list_u16_max_128_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_onu_with_state_list_u16_max_128 is 
 * out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_onu_with_state_list_u16_max_128_bounds_check(const bcmolt_gpon_onu_with_state_list_u16_max_128 *this);

/** Initializes a bcmolt_gpon_rssi_general_configuration struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_rssi_general_configuration_set_default(bcmolt_gpon_rssi_general_configuration *this);

/** Packs a bcmolt_gpon_rssi_general_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_rssi_general_configuration_pack(const bcmolt_gpon_rssi_general_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_rssi_general_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_rssi_general_configuration_unpack(bcmolt_gpon_rssi_general_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_rssi_general_configuration struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_rssi_general_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_rssi_general_configuration is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_rssi_general_configuration_bounds_check(const bcmolt_gpon_rssi_general_configuration *this);

/** Initializes a bcmolt_gpon_sn_acquisition struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_gpon_sn_acquisition_set_default(bcmolt_gpon_sn_acquisition *this);

/** Packs a bcmolt_gpon_sn_acquisition to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_sn_acquisition_pack(const bcmolt_gpon_sn_acquisition *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_gpon_sn_acquisition from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_sn_acquisition_unpack(bcmolt_gpon_sn_acquisition *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_gpon_sn_acquisition struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_gpon_sn_acquisition_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_gpon_sn_acquisition is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_gpon_sn_acquisition_bounds_check(const bcmolt_gpon_sn_acquisition *this);

/** Initializes a bcmolt_host_sw_version struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_host_sw_version_set_default(bcmolt_host_sw_version *this);

/** Packs a bcmolt_host_sw_version to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_host_sw_version_pack(const bcmolt_host_sw_version *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_host_sw_version from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_host_sw_version_unpack(bcmolt_host_sw_version *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_host_sw_version struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_host_sw_version_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_host_sw_version is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_host_sw_version_bounds_check(const bcmolt_host_sw_version *this);

/** Initializes a bcmolt_hw_pon_id struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_hw_pon_id_set_default(bcmolt_hw_pon_id *this);

/** Packs a bcmolt_hw_pon_id to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_hw_pon_id_pack(const bcmolt_hw_pon_id *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_hw_pon_id from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_hw_pon_id_unpack(bcmolt_hw_pon_id *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_hw_pon_id struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_hw_pon_id_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_hw_pon_id is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_hw_pon_id_bounds_check(const bcmolt_hw_pon_id *this);

/** Initializes a bcmolt_ieee_8021as_port_identity struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ieee_8021as_port_identity_set_default(bcmolt_ieee_8021as_port_identity *this);

/** Packs a bcmolt_ieee_8021as_port_identity to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ieee_8021as_port_identity_pack(const bcmolt_ieee_8021as_port_identity *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ieee_8021as_port_identity from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ieee_8021as_port_identity_unpack(bcmolt_ieee_8021as_port_identity *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ieee_8021as_port_identity struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ieee_8021as_port_identity_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ieee_8021as_port_identity is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ieee_8021as_port_identity_bounds_check(const bcmolt_ieee_8021as_port_identity *this);

/** Initializes a bcmolt_ieee_8021as_timestamp struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ieee_8021as_timestamp_set_default(bcmolt_ieee_8021as_timestamp *this);

/** Packs a bcmolt_ieee_8021as_timestamp to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ieee_8021as_timestamp_pack(const bcmolt_ieee_8021as_timestamp *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ieee_8021as_timestamp from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ieee_8021as_timestamp_unpack(bcmolt_ieee_8021as_timestamp *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ieee_8021as_timestamp struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ieee_8021as_timestamp_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ieee_8021as_timestamp is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ieee_8021as_timestamp_bounds_check(const bcmolt_ieee_8021as_timestamp *this);

/** Initializes a bcmolt_ieee_8021as_time_sync struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ieee_8021as_time_sync_set_default(bcmolt_ieee_8021as_time_sync *this);

/** Packs a bcmolt_ieee_8021as_time_sync to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ieee_8021as_time_sync_pack(const bcmolt_ieee_8021as_time_sync *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ieee_8021as_time_sync from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ieee_8021as_time_sync_unpack(bcmolt_ieee_8021as_time_sync *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ieee_8021as_time_sync struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ieee_8021as_time_sync_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ieee_8021as_time_sync is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ieee_8021as_time_sync_bounds_check(const bcmolt_ieee_8021as_time_sync *this);

/** Initializes a bcmolt_indication_shaping struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_indication_shaping_set_default(bcmolt_indication_shaping *this);

/** Packs a bcmolt_indication_shaping to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_indication_shaping_pack(const bcmolt_indication_shaping *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_indication_shaping from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_indication_shaping_unpack(bcmolt_indication_shaping *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_indication_shaping struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_indication_shaping_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_indication_shaping is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_indication_shaping_bounds_check(const bcmolt_indication_shaping *this);

/** Initializes a bcmolt_la_resync_pattern_configuration struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_la_resync_pattern_configuration_set_default(bcmolt_la_resync_pattern_configuration *this);

/** Packs a bcmolt_la_resync_pattern_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_la_resync_pattern_configuration_pack(const bcmolt_la_resync_pattern_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_la_resync_pattern_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_la_resync_pattern_configuration_unpack(bcmolt_la_resync_pattern_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_la_resync_pattern_configuration struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_la_resync_pattern_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_la_resync_pattern_configuration is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_la_resync_pattern_configuration_bounds_check(const bcmolt_la_resync_pattern_configuration *this);

/** Initializes a bcmolt_log_buffer struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_log_buffer_set_default(bcmolt_log_buffer *this);

/** Packs a bcmolt_log_buffer to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_log_buffer_pack(const bcmolt_log_buffer *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_log_buffer from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_log_buffer_unpack(bcmolt_log_buffer *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_log_buffer struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_log_buffer_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_log_buffer is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_log_buffer_bounds_check(const bcmolt_log_buffer *this);

/** Initializes a bcmolt_mac_table_configuration struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_mac_table_configuration_set_default(bcmolt_mac_table_configuration *this);

/** Packs a bcmolt_mac_table_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_mac_table_configuration_pack(const bcmolt_mac_table_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_mac_table_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_mac_table_configuration_unpack(bcmolt_mac_table_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_mac_table_configuration struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_mac_table_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_mac_table_configuration is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_mac_table_configuration_bounds_check(const bcmolt_mac_table_configuration *this);

/** Initializes a bcmolt_macaddress_list_u32 struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_macaddress_list_u32_set_default(bcmolt_macaddress_list_u32 *this);

/** Packs a bcmolt_macaddress_list_u32 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_macaddress_list_u32_pack(const bcmolt_macaddress_list_u32 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_macaddress_list_u32 would occupy on 
 * the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_macaddress_list_u32_get_packed_length(const bcmolt_macaddress_list_u32 *this);

/** Unpacks a bcmolt_macaddress_list_u32 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_macaddress_list_u32_unpack(bcmolt_macaddress_list_u32 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_macaddress_list_u32 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_macaddress_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_macaddress_list_u32 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_macaddress_list_u32_bounds_check(const bcmolt_macaddress_list_u32 *this);

/** Initializes a bcmolt_macaddress_list_u32_max_2048 struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_macaddress_list_u32_max_2048_set_default(bcmolt_macaddress_list_u32_max_2048 *this);

/** Packs a bcmolt_macaddress_list_u32_max_2048 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_macaddress_list_u32_max_2048_pack(const bcmolt_macaddress_list_u32_max_2048 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_macaddress_list_u32_max_2048 would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_macaddress_list_u32_max_2048_get_packed_length(const bcmolt_macaddress_list_u32_max_2048 *this);

/** Unpacks a bcmolt_macaddress_list_u32_max_2048 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_macaddress_list_u32_max_2048_unpack(bcmolt_macaddress_list_u32_max_2048 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_macaddress_list_u32_max_2048 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_macaddress_list_u32_max_2048_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_macaddress_list_u32_max_2048 is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_macaddress_list_u32_max_2048_bounds_check(const bcmolt_macaddress_list_u32_max_2048 *this);

/** Initializes a bcmolt_nni_link_status struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_nni_link_status_set_default(bcmolt_nni_link_status *this);

/** Packs a bcmolt_nni_link_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_nni_link_status_pack(const bcmolt_nni_link_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_nni_link_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_nni_link_status_unpack(bcmolt_nni_link_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_nni_link_status struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_nni_link_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_nni_link_status is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_nni_link_status_bounds_check(const bcmolt_nni_link_status *this);

/** Initializes a bcmolt_oam_heartbeat_config struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_oam_heartbeat_config_set_default(bcmolt_oam_heartbeat_config *this);

/** Packs a bcmolt_oam_heartbeat_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_oam_heartbeat_config_pack(const bcmolt_oam_heartbeat_config *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_oam_heartbeat_config would occupy on 
 * the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_oam_heartbeat_config_get_packed_length(const bcmolt_oam_heartbeat_config *this);

/** Unpacks a bcmolt_oam_heartbeat_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_oam_heartbeat_config_unpack(bcmolt_oam_heartbeat_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_oam_heartbeat_config struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_oam_heartbeat_config_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_oam_heartbeat_config is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_oam_heartbeat_config_bounds_check(const bcmolt_oam_heartbeat_config *this);

/** Initializes a bcmolt_onu_power_management_configuration struct.  This sets 
 * all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_onu_power_management_configuration_set_default(bcmolt_onu_power_management_configuration *this);

/** Packs a bcmolt_onu_power_management_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_onu_power_management_configuration_pack(const bcmolt_onu_power_management_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_onu_power_management_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_onu_power_management_configuration_unpack(bcmolt_onu_power_management_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_onu_power_management_configuration struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_onu_power_management_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_onu_power_management_configuration is out 
 * of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_onu_power_management_configuration_bounds_check(const bcmolt_onu_power_management_configuration *this);

/** Initializes a bcmolt_onu_tuning_configuration struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_onu_tuning_configuration_set_default(bcmolt_onu_tuning_configuration *this);

/** Packs a bcmolt_onu_tuning_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_onu_tuning_configuration_pack(const bcmolt_onu_tuning_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_onu_tuning_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_onu_tuning_configuration_unpack(bcmolt_onu_tuning_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_onu_tuning_configuration struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_onu_tuning_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_onu_tuning_configuration is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_onu_tuning_configuration_bounds_check(const bcmolt_onu_tuning_configuration *this);

/** Initializes a bcmolt_pon_id struct.  This sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_id_set_default(bcmolt_pon_id *this);

/** Packs a bcmolt_pon_id to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_id_pack(const bcmolt_pon_id *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_id from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_id_unpack(bcmolt_pon_id *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_id struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_id_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_id is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_id_bounds_check(const bcmolt_pon_id *this);

/** Initializes a bcmolt_operation_control struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_operation_control_set_default(bcmolt_operation_control *this);

/** Packs a bcmolt_operation_control to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_operation_control_pack(const bcmolt_operation_control *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_operation_control from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_operation_control_unpack(bcmolt_operation_control *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_operation_control struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_operation_control_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_operation_control is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_operation_control_bounds_check(const bcmolt_operation_control *this);

/** Initializes a bcmolt_periodic_standby_pon_monitoring struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_periodic_standby_pon_monitoring_set_default(bcmolt_periodic_standby_pon_monitoring *this);

/** Packs a bcmolt_periodic_standby_pon_monitoring to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_periodic_standby_pon_monitoring_pack(const bcmolt_periodic_standby_pon_monitoring *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_periodic_standby_pon_monitoring from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_periodic_standby_pon_monitoring_unpack(bcmolt_periodic_standby_pon_monitoring *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_periodic_standby_pon_monitoring struct and 
 * collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_periodic_standby_pon_monitoring_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_periodic_standby_pon_monitoring is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_periodic_standby_pon_monitoring_bounds_check(const bcmolt_periodic_standby_pon_monitoring *this);

/** Initializes a bcmolt_pon_aggregate_shaper struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_aggregate_shaper_set_default(bcmolt_pon_aggregate_shaper *this);

/** Packs a bcmolt_pon_aggregate_shaper to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_aggregate_shaper_pack(const bcmolt_pon_aggregate_shaper *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_aggregate_shaper from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_aggregate_shaper_unpack(bcmolt_pon_aggregate_shaper *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_aggregate_shaper struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_aggregate_shaper_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_aggregate_shaper is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_aggregate_shaper_bounds_check(const bcmolt_pon_aggregate_shaper *this);

/** Initializes a bcmolt_pon_alloc_sla struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_alloc_sla_set_default(bcmolt_pon_alloc_sla *this);

/** Packs a bcmolt_pon_alloc_sla to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_alloc_sla_pack(const bcmolt_pon_alloc_sla *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_alloc_sla from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_alloc_sla_unpack(bcmolt_pon_alloc_sla *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_alloc_sla struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_alloc_sla_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_alloc_sla is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_alloc_sla_bounds_check(const bcmolt_pon_alloc_sla *this);

/** Initializes a bcmolt_pon_available_bandwidth struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_available_bandwidth_set_default(bcmolt_pon_available_bandwidth *this);

/** Packs a bcmolt_pon_available_bandwidth to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_available_bandwidth_pack(const bcmolt_pon_available_bandwidth *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_available_bandwidth from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_available_bandwidth_unpack(bcmolt_pon_available_bandwidth *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_available_bandwidth struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_available_bandwidth_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_available_bandwidth is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_available_bandwidth_bounds_check(const bcmolt_pon_available_bandwidth *this);

/** Initializes a bcmolt_pon_dba struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_dba_set_default(bcmolt_pon_dba *this);

/** Packs a bcmolt_pon_dba to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_dba_pack(const bcmolt_pon_dba *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_dba from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_dba_unpack(bcmolt_pon_dba *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_dba struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_dba_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_dba is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_dba_bounds_check(const bcmolt_pon_dba *this);

/** Initializes a bcmolt_pon_distance struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_distance_set_default(bcmolt_pon_distance *this);

/** Packs a bcmolt_pon_distance to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_distance_pack(const bcmolt_pon_distance *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_distance from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_distance_unpack(bcmolt_pon_distance *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_distance struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_distance_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_distance is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_distance_bounds_check(const bcmolt_pon_distance *this);

/** Initializes a bcmolt_pon_drift_control struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_drift_control_set_default(bcmolt_pon_drift_control *this);

/** Packs a bcmolt_pon_drift_control to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_drift_control_pack(const bcmolt_pon_drift_control *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_drift_control from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_drift_control_unpack(bcmolt_pon_drift_control *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_drift_control struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_drift_control_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_drift_control is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_drift_control_bounds_check(const bcmolt_pon_drift_control *this);

/** Initializes a bcmolt_pon_onu_id_list_u32 struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_onu_id_list_u32_set_default(bcmolt_pon_onu_id_list_u32 *this);

/** Packs a bcmolt_pon_onu_id_list_u32 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_onu_id_list_u32_pack(const bcmolt_pon_onu_id_list_u32 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_pon_onu_id_list_u32 would occupy on 
 * the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_pon_onu_id_list_u32_get_packed_length(const bcmolt_pon_onu_id_list_u32 *this);

/** Unpacks a bcmolt_pon_onu_id_list_u32 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_onu_id_list_u32_unpack(bcmolt_pon_onu_id_list_u32 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_onu_id_list_u32 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_onu_id_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_onu_id_list_u32 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_onu_id_list_u32_bounds_check(const bcmolt_pon_onu_id_list_u32 *this);

/** Initializes a bcmolt_pon_power_level struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_power_level_set_default(bcmolt_pon_power_level *this);

/** Packs a bcmolt_pon_power_level to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_power_level_pack(const bcmolt_pon_power_level *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_power_level from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_power_level_unpack(bcmolt_pon_power_level *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_power_level struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_power_level_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_power_level is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_power_level_bounds_check(const bcmolt_pon_power_level *this);

/** Initializes a bcmolt_pon_protection_switching struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_protection_switching_set_default(bcmolt_pon_protection_switching *this);

/** Packs a bcmolt_pon_protection_switching to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_protection_switching_pack(const bcmolt_pon_protection_switching *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_protection_switching from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_protection_switching_unpack(bcmolt_pon_protection_switching *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_protection_switching struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_protection_switching_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_protection_switching is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_protection_switching_bounds_check(const bcmolt_pon_protection_switching *this);

/** Initializes a bcmolt_pon_status struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_pon_status_set_default(bcmolt_pon_status *this);

/** Packs a bcmolt_pon_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_status_pack(const bcmolt_pon_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_pon_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_status_unpack(bcmolt_pon_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_pon_status struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_pon_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_pon_status is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_pon_status_bounds_check(const bcmolt_pon_status *this);

/** Initializes a bcmolt_prbs_checker_config struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_prbs_checker_config_set_default(bcmolt_prbs_checker_config *this);

/** Packs a bcmolt_prbs_checker_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_prbs_checker_config_pack(const bcmolt_prbs_checker_config *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_prbs_checker_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_prbs_checker_config_unpack(bcmolt_prbs_checker_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_prbs_checker_config struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_prbs_checker_config_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_prbs_checker_config is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_prbs_checker_config_bounds_check(const bcmolt_prbs_checker_config *this);

/** Initializes a bcmolt_prbs_generator_config struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_prbs_generator_config_set_default(bcmolt_prbs_generator_config *this);

/** Packs a bcmolt_prbs_generator_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_prbs_generator_config_pack(const bcmolt_prbs_generator_config *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_prbs_generator_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_prbs_generator_config_unpack(bcmolt_prbs_generator_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_prbs_generator_config struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_prbs_generator_config_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_prbs_generator_config is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_prbs_generator_config_bounds_check(const bcmolt_prbs_generator_config *this);

/** Initializes a bcmolt_prbs_status struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_prbs_status_set_default(bcmolt_prbs_status *this);

/** Packs a bcmolt_prbs_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_prbs_status_pack(const bcmolt_prbs_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_prbs_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_prbs_status_unpack(bcmolt_prbs_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_prbs_status struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_prbs_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_prbs_status is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_prbs_status_bounds_check(const bcmolt_prbs_status *this);

/** Initializes a bcmolt_ranging_control_configuration struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ranging_control_configuration_set_default(bcmolt_ranging_control_configuration *this);

/** Packs a bcmolt_ranging_control_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ranging_control_configuration_pack(const bcmolt_ranging_control_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ranging_control_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ranging_control_configuration_unpack(bcmolt_ranging_control_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ranging_control_configuration struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ranging_control_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ranging_control_configuration is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ranging_control_configuration_bounds_check(const bcmolt_ranging_control_configuration *this);

/** Initializes a bcmolt_ranging_resync_conditions struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ranging_resync_conditions_set_default(bcmolt_ranging_resync_conditions *this);

/** Packs a bcmolt_ranging_resync_conditions to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ranging_resync_conditions_pack(const bcmolt_ranging_resync_conditions *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ranging_resync_conditions from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ranging_resync_conditions_unpack(bcmolt_ranging_resync_conditions *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ranging_resync_conditions struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ranging_resync_conditions_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ranging_resync_conditions is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ranging_resync_conditions_bounds_check(const bcmolt_ranging_resync_conditions *this);

/** Initializes a bcmolt_ranging_rssi_control struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_ranging_rssi_control_set_default(bcmolt_ranging_rssi_control *this);

/** Packs a bcmolt_ranging_rssi_control to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ranging_rssi_control_pack(const bcmolt_ranging_rssi_control *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_ranging_rssi_control from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_ranging_rssi_control_unpack(bcmolt_ranging_rssi_control *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_ranging_rssi_control struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_ranging_rssi_control_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_ranging_rssi_control is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_ranging_rssi_control_bounds_check(const bcmolt_ranging_rssi_control *this);

/** Initializes a bcmolt_request_registration_status struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_request_registration_status_set_default(bcmolt_request_registration_status *this);

/** Packs a bcmolt_request_registration_status to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_request_registration_status_pack(const bcmolt_request_registration_status *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_request_registration_status from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_request_registration_status_unpack(bcmolt_request_registration_status *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_request_registration_status struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_request_registration_status_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_request_registration_status is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_request_registration_status_bounds_check(const bcmolt_request_registration_status *this);

/** Initializes a bcmolt_rogue_detection_special_map struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_rogue_detection_special_map_set_default(bcmolt_rogue_detection_special_map *this);

/** Packs a bcmolt_rogue_detection_special_map to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_detection_special_map_pack(const bcmolt_rogue_detection_special_map *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_rogue_detection_special_map from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_detection_special_map_unpack(bcmolt_rogue_detection_special_map *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_rogue_detection_special_map struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_rogue_detection_special_map_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_rogue_detection_special_map is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_detection_special_map_bounds_check(const bcmolt_rogue_detection_special_map *this);

/** Initializes a bcmolt_rogue_detection_special_map_list_u32_max_8 struct.  
 * This sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_rogue_detection_special_map_list_u32_max_8_set_default(bcmolt_rogue_detection_special_map_list_u32_max_8 *this);

/** Packs a bcmolt_rogue_detection_special_map_list_u32_max_8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_detection_special_map_list_u32_max_8_pack(const bcmolt_rogue_detection_special_map_list_u32_max_8 *this, bcmolt_buf *buf);

/** Gets the number of bytes that a 
 * bcmolt_rogue_detection_special_map_list_u32_max_8 would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_rogue_detection_special_map_list_u32_max_8_get_packed_length(const bcmolt_rogue_detection_special_map_list_u32_max_8 *this);

/** Unpacks a bcmolt_rogue_detection_special_map_list_u32_max_8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_detection_special_map_list_u32_max_8_unpack(bcmolt_rogue_detection_special_map_list_u32_max_8 *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_rogue_detection_special_map_list_u32_max_8 struct 
 * and collects memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_rogue_detection_special_map_list_u32_max_8_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_rogue_detection_special_map_list_u32_max_8 
 * is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_detection_special_map_list_u32_max_8_bounds_check(const bcmolt_rogue_detection_special_map_list_u32_max_8 *this);

/** Initializes a bcmolt_rogue_detection_algorithm struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_rogue_detection_algorithm_set_default(bcmolt_rogue_detection_algorithm *this);

/** Packs a bcmolt_rogue_detection_algorithm to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_detection_algorithm_pack(const bcmolt_rogue_detection_algorithm *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_rogue_detection_algorithm would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_rogue_detection_algorithm_get_packed_length(const bcmolt_rogue_detection_algorithm *this);

/** Unpacks a bcmolt_rogue_detection_algorithm from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_detection_algorithm_unpack(bcmolt_rogue_detection_algorithm *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_rogue_detection_algorithm struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_rogue_detection_algorithm_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_rogue_detection_algorithm is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_detection_algorithm_bounds_check(const bcmolt_rogue_detection_algorithm *this);

/** Initializes a bcmolt_rogue_onu_detection_process struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_rogue_onu_detection_process_set_default(bcmolt_rogue_onu_detection_process *this);

/** Packs a bcmolt_rogue_onu_detection_process to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_onu_detection_process_pack(const bcmolt_rogue_onu_detection_process *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_rogue_onu_detection_process would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_rogue_onu_detection_process_get_packed_length(const bcmolt_rogue_onu_detection_process *this);

/** Unpacks a bcmolt_rogue_onu_detection_process from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_onu_detection_process_unpack(bcmolt_rogue_onu_detection_process *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_rogue_onu_detection_process struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_rogue_onu_detection_process_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_rogue_onu_detection_process is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_rogue_onu_detection_process_bounds_check(const bcmolt_rogue_onu_detection_process *this);

/** Initializes a bcmolt_serdes_configuration struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_serdes_configuration_set_default(bcmolt_serdes_configuration *this);

/** Packs a bcmolt_serdes_configuration to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_serdes_configuration_pack(const bcmolt_serdes_configuration *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_serdes_configuration from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_serdes_configuration_unpack(bcmolt_serdes_configuration *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_serdes_configuration struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_serdes_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_serdes_configuration is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_serdes_configuration_bounds_check(const bcmolt_serdes_configuration *this);

/** Initializes a bcmolt_serial_number struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_serial_number_set_default(bcmolt_serial_number *this);

/** Packs a bcmolt_serial_number to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_serial_number_pack(const bcmolt_serial_number *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_serial_number from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_serial_number_unpack(bcmolt_serial_number *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_serial_number struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_serial_number_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_serial_number is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_serial_number_bounds_check(const bcmolt_serial_number *this);

/** Initializes a bcmolt_solicited_scheduler struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_solicited_scheduler_set_default(bcmolt_solicited_scheduler *this);

/** Packs a bcmolt_solicited_scheduler to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_solicited_scheduler_pack(const bcmolt_solicited_scheduler *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_solicited_scheduler from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_solicited_scheduler_unpack(bcmolt_solicited_scheduler *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_solicited_scheduler struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_solicited_scheduler_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_solicited_scheduler is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_solicited_scheduler_bounds_check(const bcmolt_solicited_scheduler *this);

/** Initializes a bcmolt_stat_alarm_trigger_config struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_stat_alarm_trigger_config_set_default(bcmolt_stat_alarm_trigger_config *this);

/** Packs a bcmolt_stat_alarm_trigger_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_stat_alarm_trigger_config_pack(const bcmolt_stat_alarm_trigger_config *this, bcmolt_buf *buf);

/** Gets the number of bytes that a bcmolt_stat_alarm_trigger_config would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmolt_stat_alarm_trigger_config_get_packed_length(const bcmolt_stat_alarm_trigger_config *this);

/** Unpacks a bcmolt_stat_alarm_trigger_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_stat_alarm_trigger_config_unpack(bcmolt_stat_alarm_trigger_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_stat_alarm_trigger_config struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_stat_alarm_trigger_config_scan(bcmolt_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmolt_stat_alarm_trigger_config is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmolt_stat_alarm_trigger_config_bounds_check(const bcmolt_stat_alarm_trigger_config *this);

/** Initializes a bcmolt_stat_alarm_soak_config struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmolt_stat_alarm_soak_config_set_default(bcmolt_stat_alarm_soak_config *this);

/** Packs a bcmolt_stat_alarm_soak_config to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_stat_alarm_soak_config_pack(const bcmolt_stat_alarm_soak_config *this, bcmolt_buf *buf);

/** Unpacks a bcmolt_stat_alarm_soak_config from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmolt_stat_alarm_soak_config_unpack(bcmolt_stat_alarm_soak_config *this, bcmolt_buf *buf, void **extra_mem);

/** Scans past a packed bcmolt_stat_alarm_soak_config struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmolt_stat_a