/*
<:copyright-BRCM:2016:proprietary:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

This program is the proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modified or distributed pursuant
to the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License").  Except as set forth in
an Authorized License, Broadcom grants no license (express or implied), right
to use, or waiver of any kind with respect to the Software, and Broadcom
expressly reserves all rights in and to the Software and all intellectual
property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization,
    constitutes the valuable trade secrets of Broadcom, and you shall use
    all reasonable efforts to protect the confidentiality thereof, and to
    use this information only in connection with your use of Broadcom
    integrated circuit products.

2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
    PERFORMANCE OF THE SOFTWARE.

3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
    LIMITED REMEDY.
:>
*/
#include "bcmolt_model_types.h"
#include "bcmolt_model_ids.h"

/******************************************************************************/
bcmos_bool bcmolt_activation_fail_reason_pack(bcmolt_activation_fail_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_activation_fail_reason_unpack(bcmolt_activation_fail_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_additional_bw_eligibility_pack(bcmolt_additional_bw_eligibility this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_additional_bw_eligibility_unpack(bcmolt_additional_bw_eligibility *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_cfg_id_pack(bcmolt_ae_ni_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_cfg_id_unpack(bcmolt_ae_ni_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_en_state_pack(bcmolt_ae_ni_en_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_en_state_unpack(bcmolt_ae_ni_en_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_key_id_pack(bcmolt_ae_ni_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_key_id_unpack(bcmolt_ae_ni_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_set_ae_ni_en_state_id_pack(bcmolt_ae_ni_set_ae_ni_en_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_set_ae_ni_en_state_id_unpack(bcmolt_ae_ni_set_ae_ni_en_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_auto_cfg_id_pack(bcmolt_ae_path_ds_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_auto_cfg_id_unpack(bcmolt_ae_path_ds_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_key_id_pack(bcmolt_ae_path_ds_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_key_id_unpack(bcmolt_ae_path_ds_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_cleared_id_pack(bcmolt_ae_path_ds_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_cleared_id_unpack(bcmolt_ae_path_ds_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_raised_id_pack(bcmolt_ae_path_ds_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_raised_id_unpack(bcmolt_ae_path_ds_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_cfg_id_pack(bcmolt_ae_path_ds_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_cfg_id_unpack(bcmolt_ae_path_ds_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_id_pack(bcmolt_ae_path_ds_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_id_unpack(bcmolt_ae_path_ds_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_auto_cfg_id_pack(bcmolt_ae_path_us_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_auto_cfg_id_unpack(bcmolt_ae_path_us_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_key_id_pack(bcmolt_ae_path_us_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_key_id_unpack(bcmolt_ae_path_us_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_cleared_id_pack(bcmolt_ae_path_us_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_cleared_id_unpack(bcmolt_ae_path_us_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_raised_id_pack(bcmolt_ae_path_us_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_raised_id_unpack(bcmolt_ae_path_us_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_cfg_id_pack(bcmolt_ae_path_us_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_cfg_id_unpack(bcmolt_ae_path_us_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_id_pack(bcmolt_ae_path_us_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_id_unpack(bcmolt_ae_path_us_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_alloc_operation_pack(bcmolt_alloc_operation this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_alloc_operation_unpack(bcmolt_alloc_operation *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_alloc_state_pack(bcmolt_alloc_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_alloc_state_unpack(bcmolt_alloc_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_alloc_type_pack(bcmolt_alloc_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_alloc_type_unpack(bcmolt_alloc_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_alloc_type_to_scan_pack(bcmolt_alloc_type_to_scan this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_alloc_type_to_scan_unpack(bcmolt_alloc_type_to_scan *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_buffer_mode_pack(bcmolt_api_capture_buffer_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_buffer_mode_unpack(bcmolt_api_capture_buffer_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_location_pack(bcmolt_api_capture_location this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_location_unpack(bcmolt_api_capture_location *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_calibration_record_pack(bcmolt_calibration_record this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_calibration_record_unpack(bcmolt_calibration_record *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_sign_pack(bcmolt_sign this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_sign_unpack(bcmolt_sign *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_upstream_line_rate_capabilities_pack(bcmolt_upstream_line_rate_capabilities this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_upstream_line_rate_capabilities_unpack(bcmolt_upstream_line_rate_capabilities *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_link_type_pack(bcmolt_link_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_link_type_unpack(bcmolt_link_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_capture_strobe_signal_pack(bcmolt_capture_strobe_signal this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_capture_strobe_signal_unpack(bcmolt_capture_strobe_signal *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_cfg_id_pack(bcmolt_channel_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_channel_cfg_id_unpack(bcmolt_channel_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_key_id_pack(bcmolt_channel_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_channel_key_id_unpack(bcmolt_channel_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_console_redirection_pack(bcmolt_console_redirection this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_console_redirection_unpack(bcmolt_console_redirection *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_control_state_pack(bcmolt_control_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_control_state_unpack(bcmolt_control_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_dba_mode_pack(bcmolt_dba_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_dba_mode_unpack(bcmolt_dba_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_dba_ram_pack(bcmolt_dba_ram this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_dba_ram_unpack(bcmolt_dba_ram *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_dba_type_pack(bcmolt_dba_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_dba_type_unpack(bcmolt_dba_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ddr_test_status_pack(bcmolt_ddr_test_status this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ddr_test_status_unpack(bcmolt_ddr_test_status *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ddr_test_result_pack(bcmolt_ddr_test_result this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ddr_test_result_unpack(bcmolt_ddr_test_result *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_host_connection_fail_reason_pack(bcmolt_host_connection_fail_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_host_connection_fail_reason_unpack(bcmolt_host_connection_fail_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_deactivation_reason_pack(bcmolt_deactivation_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_deactivation_reason_unpack(bcmolt_deactivation_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_auto_cfg_id_pack(bcmolt_debug_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_auto_cfg_id_unpack(bcmolt_debug_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cfg_id_pack(bcmolt_debug_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cfg_id_unpack(bcmolt_debug_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_input_id_pack(bcmolt_debug_cli_input_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_input_id_unpack(bcmolt_debug_cli_input_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_output_id_pack(bcmolt_debug_cli_output_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_output_id_unpack(bcmolt_debug_cli_output_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_file_almost_full_id_pack(bcmolt_debug_file_almost_full_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_file_almost_full_id_unpack(bcmolt_debug_file_almost_full_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_key_id_pack(bcmolt_debug_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_key_id_unpack(bcmolt_debug_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_reset_api_capture_id_pack(bcmolt_debug_reset_api_capture_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_reset_api_capture_id_unpack(bcmolt_debug_reset_api_capture_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_start_api_capture_id_pack(bcmolt_debug_start_api_capture_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_start_api_capture_id_unpack(bcmolt_debug_start_api_capture_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_stop_api_capture_id_pack(bcmolt_debug_stop_api_capture_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_stop_api_capture_id_unpack(bcmolt_debug_stop_api_capture_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_auto_cfg_id_pack(bcmolt_device_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_auto_cfg_id_unpack(bcmolt_device_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_cfg_id_pack(bcmolt_device_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_cfg_id_unpack(bcmolt_device_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_chip_revision_pack(bcmolt_device_chip_revision this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_chip_revision_unpack(bcmolt_device_chip_revision *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_connect_id_pack(bcmolt_device_connect_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_connect_id_unpack(bcmolt_device_connect_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_connection_complete_id_pack(bcmolt_device_connection_complete_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_connection_complete_id_unpack(bcmolt_device_connection_complete_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_connection_established_id_pack(bcmolt_device_connection_established_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_connection_established_id_unpack(bcmolt_device_connection_established_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_connection_failure_id_pack(bcmolt_device_connection_failure_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_connection_failure_id_unpack(bcmolt_device_connection_failure_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_ddr_test_complete_id_pack(bcmolt_device_ddr_test_complete_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_ddr_test_complete_id_unpack(bcmolt_device_ddr_test_complete_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_device_keep_alive_id_pack(bcmolt_device_device_keep_alive_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_device_keep_alive_id_unpack(bcmolt_device_device_keep_alive_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_device_ready_id_pack(bcmolt_device_device_ready_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_device_ready_id_unpack(bcmolt_device_device_ready_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_disconnect_id_pack(bcmolt_device_disconnect_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_disconnect_id_unpack(bcmolt_device_disconnect_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_disconnection_complete_id_pack(bcmolt_device_disconnection_complete_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_disconnection_complete_id_unpack(bcmolt_device_disconnection_complete_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_host_keep_alive_id_pack(bcmolt_device_host_keep_alive_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_host_keep_alive_id_unpack(bcmolt_device_host_keep_alive_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_image_transfer_complete_id_pack(bcmolt_device_image_transfer_complete_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_image_transfer_complete_id_unpack(bcmolt_device_image_transfer_complete_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_image_transfer_data_id_pack(bcmolt_device_image_transfer_data_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_image_transfer_data_id_unpack(bcmolt_device_image_transfer_data_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_image_transfer_start_id_pack(bcmolt_device_image_transfer_start_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_image_transfer_start_id_unpack(bcmolt_device_image_transfer_start_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_image_type_pack(bcmolt_device_image_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_image_type_unpack(bcmolt_device_image_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_indications_dropped_id_pack(bcmolt_device_indications_dropped_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_indications_dropped_id_unpack(bcmolt_device_indications_dropped_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_key_id_pack(bcmolt_device_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_key_id_unpack(bcmolt_device_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_speed_pack(bcmolt_nni_speed this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_speed_unpack(bcmolt_nni_speed *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_reset_id_pack(bcmolt_device_reset_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_reset_id_unpack(bcmolt_device_reset_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_reset_mode_pack(bcmolt_device_reset_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_reset_mode_unpack(bcmolt_device_reset_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_run_ddr_test_id_pack(bcmolt_device_run_ddr_test_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_run_ddr_test_id_unpack(bcmolt_device_run_ddr_test_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_state_pack(bcmolt_device_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_state_unpack(bcmolt_device_state *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_sw_error_id_pack(bcmolt_device_sw_error_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_sw_error_id_unpack(bcmolt_device_sw_error_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_sw_exception_id_pack(bcmolt_device_sw_exception_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_sw_exception_id_unpack(bcmolt_device_sw_exception_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_sw_upgrade_activate_id_pack(bcmolt_device_sw_upgrade_activate_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_device_sw_upgrade_activate_id_unpack(bcmolt_device_sw_upgrade_activate_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_disable_serial_number_control_pack(bcmolt_disable_serial_number_control this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_disable_serial_number_control_unpack(bcmolt_disable_serial_number_control *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_drv_icf_id_pack(bcmolt_drv_icf_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_drv_icf_id_unpack(bcmolt_drv_icf_id *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_drv_sgb_id_pack(bcmolt_drv_sgb_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_drv_sgb_id_unpack(bcmolt_drv_sgb_id *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ds_vlan_action_pack(bcmolt_ds_vlan_action this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ds_vlan_action_unpack(bcmolt_ds_vlan_action *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_tfb_trap_behavior_pack(bcmolt_tfb_trap_behavior this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_tfb_trap_behavior_unpack(bcmolt_tfb_trap_behavior *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_tfb_mode_pack(bcmolt_tfb_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_tfb_mode_unpack(bcmolt_tfb_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_lim_sec_mode_up_pack(bcmolt_lim_sec_mode_up this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_lim_sec_mode_up_unpack(bcmolt_lim_sec_mode_up *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_lim_sec_mode_dn_pack(bcmolt_lim_sec_mode_dn this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_lim_sec_mode_dn_unpack(bcmolt_lim_sec_mode_dn *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xim_sec_mode_pack(bcmolt_xim_sec_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xim_sec_mode_unpack(bcmolt_xim_sec_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_hsc_ram_pack(bcmolt_hsc_ram this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_hsc_ram_unpack(bcmolt_hsc_ram *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_lim_ram_pack(bcmolt_lim_ram this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_lim_ram_unpack(bcmolt_lim_ram *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_lky_ram_pack(bcmolt_lky_ram this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_lky_ram_unpack(bcmolt_lky_ram *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_mic_ram_pack(bcmolt_mic_ram this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_mic_ram_unpack(bcmolt_mic_ram *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xpcsrm_ram_pack(bcmolt_xpcsrm_ram this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xpcsrm_ram_unpack(bcmolt_xpcsrm_ram *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_transfer_status_pack(bcmolt_embedded_image_transfer_status this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_transfer_status_unpack(bcmolt_embedded_image_transfer_status *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_information_format_pack(bcmolt_epon_encryption_information_format this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_information_format_unpack(bcmolt_epon_encryption_information_format *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_energy_detect_source_pack(bcmolt_energy_detect_source this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_energy_detect_source_unpack(bcmolt_energy_detect_source *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_1g_turbo_mode_pack(bcmolt_epon_1g_turbo_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_1g_turbo_mode_unpack(bcmolt_epon_1g_turbo_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_clock_transport_mode_pack(bcmolt_epon_clock_transport_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_clock_transport_mode_unpack(bcmolt_epon_clock_transport_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_dba_reporting_mode_pack(bcmolt_epon_dba_reporting_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_dba_reporting_mode_unpack(bcmolt_epon_dba_reporting_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_rate_pack(bcmolt_epon_link_rate this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_rate_unpack(bcmolt_epon_link_rate *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_status_pack(bcmolt_status this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_status_unpack(bcmolt_status *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_auto_cfg_id_pack(bcmolt_epon_denied_link_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_auto_cfg_id_unpack(bcmolt_epon_denied_link_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_cfg_id_pack(bcmolt_epon_denied_link_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_cfg_id_unpack(bcmolt_epon_denied_link_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_key_id_pack(bcmolt_epon_denied_link_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_key_id_unpack(bcmolt_epon_denied_link_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_laser_on_off_violation_id_pack(bcmolt_epon_denied_link_laser_on_off_violation_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_laser_on_off_violation_id_unpack(bcmolt_epon_denied_link_laser_on_off_violation_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_llid_pool_empty_violation_id_pack(bcmolt_epon_denied_link_llid_pool_empty_violation_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_llid_pool_empty_violation_id_unpack(bcmolt_epon_denied_link_llid_pool_empty_violation_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_max_link_violation_id_pack(bcmolt_epon_denied_link_max_link_violation_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_max_link_violation_id_unpack(bcmolt_epon_denied_link_max_link_violation_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_overhead_profile_violation_id_pack(bcmolt_epon_denied_link_overhead_profile_violation_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_overhead_profile_violation_id_unpack(bcmolt_epon_denied_link_overhead_profile_violation_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_range_violation_id_pack(bcmolt_epon_denied_link_range_violation_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_range_violation_id_unpack(bcmolt_epon_denied_link_range_violation_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_rogue_violation_id_pack(bcmolt_epon_denied_link_rogue_violation_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_rogue_violation_id_unpack(bcmolt_epon_denied_link_rogue_violation_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_system_resource_violation_id_pack(bcmolt_epon_denied_link_system_resource_violation_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_system_resource_violation_id_unpack(bcmolt_epon_denied_link_system_resource_violation_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_tdm_channels_exhausted_id_pack(bcmolt_epon_denied_link_tdm_channels_exhausted_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_tdm_channels_exhausted_id_unpack(bcmolt_epon_denied_link_tdm_channels_exhausted_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_unknown_link_violation_id_pack(bcmolt_epon_denied_link_unknown_link_violation_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_unknown_link_violation_id_unpack(bcmolt_epon_denied_link_unknown_link_violation_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_upstream_bandwidth_violation_id_pack(bcmolt_epon_denied_link_upstream_bandwidth_violation_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_upstream_bandwidth_violation_id_unpack(bcmolt_epon_denied_link_upstream_bandwidth_violation_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_mode_pack(bcmolt_epon_encryption_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_mode_unpack(bcmolt_epon_encryption_mode *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_key_choice_pack(bcmolt_epon_key_choice this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_key_choice_unpack(bcmolt_epon_key_choice *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_direction_pack(bcmolt_epon_encryption_direction this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_direction_unpack(bcmolt_epon_encryption_direction *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_fec_en_state_pack(bcmolt_epon_fec_en_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_fec_en_state_unpack(bcmolt_epon_fec_en_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_oam_type_pack(bcmolt_epon_oam_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_oam_type_unpack(bcmolt_epon_oam_type *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_auto_cfg_id_pack(bcmolt_epon_link_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_auto_cfg_id_unpack(bcmolt_epon_link_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_cfg_id_pack(bcmolt_epon_link_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_cfg_id_unpack(bcmolt_epon_link_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_delete_link_id_pack(bcmolt_epon_link_delete_link_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_delete_link_id_unpack(bcmolt_epon_link_delete_link_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_duplicate_mpcp_registration_request_id_pack(bcmolt_epon_link_duplicate_mpcp_registration_request_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_duplicate_mpcp_registration_request_id_unpack(bcmolt_epon_link_duplicate_mpcp_registration_request_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_encryption_enabled_id_pack(bcmolt_epon_link_encryption_enabled_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_encryption_enabled_id_unpack(bcmolt_epon_link_encryption_enabled_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_fec_state_pack(bcmolt_epon_link_fec_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_fec_state_unpack(bcmolt_epon_link_fec_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_force_rediscovery_id_pack(bcmolt_epon_link_force_rediscovery_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_force_rediscovery_id_unpack(bcmolt_epon_link_force_rediscovery_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_frame_captured_id_pack(bcmolt_epon_link_frame_captured_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_frame_captured_id_unpack(bcmolt_epon_link_frame_captured_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_status_pack(bcmolt_epon_link_status this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_status_unpack(bcmolt_epon_link_status *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_mpcp_discovery_info_pack(bcmolt_mpcp_discovery_info this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_mpcp_discovery_info_unpack(bcmolt_mpcp_discovery_info *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_inject_frame_id_pack(bcmolt_epon_link_inject_frame_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_inject_frame_id_unpack(bcmolt_epon_link_inject_frame_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_failure_id_pack(bcmolt_epon_link_key_exchange_failure_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_failure_id_unpack(bcmolt_epon_link_key_exchange_failure_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_start_id_pack(bcmolt_epon_link_key_exchange_start_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_start_id_unpack(bcmolt_epon_link_key_exchange_start_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_started_id_pack(bcmolt_epon_link_key_exchange_started_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_started_id_unpack(bcmolt_epon_link_key_exchange_started_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_stop_id_pack(bcmolt_epon_link_key_exchange_stop_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_stop_id_unpack(bcmolt_epon_link_key_exchange_stop_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_stopped_id_pack(bcmolt_epon_link_key_exchange_stopped_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_exchange_stopped_id_unpack(bcmolt_epon_link_key_exchange_stopped_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_id_pack(bcmolt_epon_link_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_key_id_unpack(bcmolt_epon_link_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_link_deleted_id_pack(bcmolt_epon_link_link_deleted_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_link_deleted_id_unpack(bcmolt_epon_link_link_deleted_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_link_speed_mismatch_id_pack(bcmolt_epon_link_link_speed_mismatch_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_link_speed_mismatch_id_unpack(bcmolt_epon_link_link_speed_mismatch_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_mpcp_deregistered_id_pack(bcmolt_epon_link_mpcp_deregistered_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_mpcp_deregistered_id_unpack(bcmolt_epon_link_mpcp_deregistered_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_mpcp_discovered_id_pack(bcmolt_epon_link_mpcp_discovered_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_mpcp_discovered_id_unpack(bcmolt_epon_link_mpcp_discovered_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_mpcp_reg_ack_timeout_id_pack(bcmolt_epon_link_mpcp_reg_ack_timeout_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_mpcp_reg_ack_timeout_id_unpack(bcmolt_epon_link_mpcp_reg_ack_timeout_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_mpcp_report_timeout_id_pack(bcmolt_epon_link_mpcp_report_timeout_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_mpcp_report_timeout_id_unpack(bcmolt_epon_link_mpcp_report_timeout_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timeout_id_pack(bcmolt_epon_link_oam_keepalive_timeout_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timeout_id_unpack(bcmolt_epon_link_oam_keepalive_timeout_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_start_id_pack(bcmolt_epon_link_oam_keepalive_timer_start_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_start_id_unpack(bcmolt_epon_link_oam_keepalive_timer_start_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_started_id_pack(bcmolt_epon_link_oam_keepalive_timer_started_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_started_id_unpack(bcmolt_epon_link_oam_keepalive_timer_started_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_stop_id_pack(bcmolt_epon_link_oam_keepalive_timer_stop_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_stop_id_unpack(bcmolt_epon_link_oam_keepalive_timer_stop_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_stopped_id_pack(bcmolt_epon_link_oam_keepalive_timer_stopped_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_oam_keepalive_timer_stopped_id_unpack(bcmolt_epon_link_oam_keepalive_timer_stopped_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_preprovisioned_link_created_id_pack(bcmolt_epon_link_preprovisioned_link_created_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_preprovisioned_link_created_id_unpack(bcmolt_epon_link_preprovisioned_link_created_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_protection_switch_occurred_id_pack(bcmolt_epon_link_protection_switch_occurred_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_protection_switch_occurred_id_unpack(bcmolt_epon_link_protection_switch_occurred_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_range_value_changed_id_pack(bcmolt_epon_link_range_value_changed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_range_value_changed_id_unpack(bcmolt_epon_link_range_value_changed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_rerange_failure_id_pack(bcmolt_epon_link_rerange_failure_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_rerange_failure_id_unpack(bcmolt_epon_link_rerange_failure_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_stat_alarm_cleared_id_pack(bcmolt_epon_link_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_stat_alarm_cleared_id_unpack(bcmolt_epon_link_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_stat_alarm_raised_id_pack(bcmolt_epon_link_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_stat_alarm_raised_id_unpack(bcmolt_epon_link_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_stat_cfg_id_pack(bcmolt_epon_link_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_stat_cfg_id_unpack(bcmolt_epon_link_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_stat_id_pack(bcmolt_epon_link_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_stat_id_unpack(bcmolt_epon_link_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_state_flags_pack(bcmolt_epon_link_state_flags this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_state_flags_unpack(bcmolt_epon_link_state_flags *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_static_registration_done_id_pack(bcmolt_epon_link_static_registration_done_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_static_registration_done_id_unpack(bcmolt_epon_link_static_registration_done_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_static_registration_id_pack(bcmolt_epon_link_static_registration_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_static_registration_id_unpack(bcmolt_epon_link_static_registration_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_type_pack(bcmolt_epon_link_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_type_unpack(bcmolt_epon_link_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_mpcp_gate_mode_pack(bcmolt_mpcp_gate_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_mpcp_gate_mode_unpack(bcmolt_mpcp_gate_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_mpcp_registration_gate_flags_pack(bcmolt_mpcp_registration_gate_flags this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_mpcp_registration_gate_flags_unpack(bcmolt_mpcp_registration_gate_flags *this, bcmolt_buf *buf)
{
    uint32_t num_val;
    if (!bcmolt_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_add_link_id_pack(bcmolt_epon_ni_add_link_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_add_link_id_unpack(bcmolt_epon_ni_add_link_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_add_multicast_link_id_pack(bcmolt_epon_ni_add_multicast_link_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_add_multicast_link_id_unpack(bcmolt_epon_ni_add_multicast_link_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_add_protected_standby_link_id_pack(bcmolt_epon_ni_add_protected_standby_link_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_add_protected_standby_link_id_unpack(bcmolt_epon_ni_add_protected_standby_link_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_auto_cfg_id_pack(bcmolt_epon_ni_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_auto_cfg_id_unpack(bcmolt_epon_ni_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_auto_rogue_scan_10g_failure_id_pack(bcmolt_epon_ni_auto_rogue_scan_10g_failure_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_auto_rogue_scan_10g_failure_id_unpack(bcmolt_epon_ni_auto_rogue_scan_10g_failure_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_auto_rogue_scan_1g_failure_id_pack(bcmolt_epon_ni_auto_rogue_scan_1g_failure_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_auto_rogue_scan_1g_failure_id_unpack(bcmolt_epon_ni_auto_rogue_scan_1g_failure_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_cfg_id_pack(bcmolt_epon_ni_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_cfg_id_unpack(bcmolt_epon_ni_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_en_state_pack(bcmolt_epon_ni_en_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_en_state_unpack(bcmolt_epon_ni_en_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_issue_rssi_grant_id_pack(bcmolt_epon_ni_issue_rssi_grant_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_issue_rssi_grant_id_unpack(bcmolt_epon_ni_issue_rssi_grant_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_key_id_pack(bcmolt_epon_ni_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_key_id_unpack(bcmolt_epon_ni_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_llid_quarantined_id_pack(bcmolt_epon_ni_llid_quarantined_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_llid_quarantined_id_unpack(bcmolt_epon_ni_llid_quarantined_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_mpcp_timestamp_changed_id_pack(bcmolt_epon_ni_mpcp_timestamp_changed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_mpcp_timestamp_changed_id_unpack(bcmolt_epon_ni_mpcp_timestamp_changed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_no_reports_id_pack(bcmolt_epon_ni_no_reports_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_no_reports_id_unpack(bcmolt_epon_ni_no_reports_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_onu_upgrade_complete_id_pack(bcmolt_epon_ni_onu_upgrade_complete_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_onu_upgrade_complete_id_unpack(bcmolt_epon_ni_onu_upgrade_complete_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_protection_switching_apply_rerange_delta_id_pack(bcmolt_epon_ni_protection_switching_apply_rerange_delta_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_protection_switching_apply_rerange_delta_id_unpack(bcmolt_epon_ni_protection_switching_apply_rerange_delta_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_rerange_failure_id_pack(bcmolt_epon_ni_rerange_failure_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_rerange_failure_id_unpack(bcmolt_epon_ni_rerange_failure_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_rogue_llid_scan_id_pack(bcmolt_epon_ni_rogue_llid_scan_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_rogue_llid_scan_id_unpack(bcmolt_epon_ni_rogue_llid_scan_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_rogue_scan_complete_id_pack(bcmolt_epon_ni_rogue_scan_complete_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_rogue_scan_complete_id_unpack(bcmolt_epon_ni_rogue_scan_complete_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_rssi_measurement_completed_id_pack(bcmolt_epon_ni_rssi_measurement_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_rssi_measurement_completed_id_unpack(bcmolt_epon_ni_rssi_measurement_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_set_epon_ni_en_state_id_pack(bcmolt_epon_ni_set_epon_ni_en_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_set_epon_ni_en_state_id_unpack(bcmolt_epon_ni_set_epon_ni_en_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_start_onu_upgrade_id_pack(bcmolt_epon_ni_start_onu_upgrade_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_start_onu_upgrade_id_unpack(bcmolt_epon_ni_start_onu_upgrade_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_state_change_completed_id_pack(bcmolt_epon_ni_state_change_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_state_change_completed_id_unpack(bcmolt_epon_ni_state_change_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_oam_extension_type_pack(bcmolt_epon_oam_extension_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_oam_extension_type_unpack(bcmolt_epon_oam_extension_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_auto_cfg_id_pack(bcmolt_epon_onu_10g_us_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_auto_cfg_id_unpack(bcmolt_epon_onu_10g_us_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_cfg_id_pack(bcmolt_epon_onu_10g_us_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_cfg_id_unpack(bcmolt_epon_onu_10g_us_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_key_id_pack(bcmolt_epon_onu_10g_us_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_key_id_unpack(bcmolt_epon_onu_10g_us_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_stat_alarm_cleared_id_pack(bcmolt_epon_onu_10g_us_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_stat_alarm_cleared_id_unpack(bcmolt_epon_onu_10g_us_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_stat_alarm_raised_id_pack(bcmolt_epon_onu_10g_us_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_stat_alarm_raised_id_unpack(bcmolt_epon_onu_10g_us_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_stat_cfg_id_pack(bcmolt_epon_onu_10g_us_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_stat_cfg_id_unpack(bcmolt_epon_onu_10g_us_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_stat_id_pack(bcmolt_epon_onu_10g_us_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_10g_us_stat_id_unpack(bcmolt_epon_onu_10g_us_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_auto_cfg_id_pack(bcmolt_epon_onu_1g_us_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_auto_cfg_id_unpack(bcmolt_epon_onu_1g_us_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_cfg_id_pack(bcmolt_epon_onu_1g_us_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_cfg_id_unpack(bcmolt_epon_onu_1g_us_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_key_id_pack(bcmolt_epon_onu_1g_us_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_key_id_unpack(bcmolt_epon_onu_1g_us_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_stat_alarm_cleared_id_pack(bcmolt_epon_onu_1g_us_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_stat_alarm_cleared_id_unpack(bcmolt_epon_onu_1g_us_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_stat_alarm_raised_id_pack(bcmolt_epon_onu_1g_us_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_stat_alarm_raised_id_unpack(bcmolt_epon_onu_1g_us_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_stat_cfg_id_pack(bcmolt_epon_onu_1g_us_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_stat_cfg_id_unpack(bcmolt_epon_onu_1g_us_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_stat_id_pack(bcmolt_epon_onu_1g_us_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_1g_us_stat_id_unpack(bcmolt_epon_onu_1g_us_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_onu_response_code_pack(bcmolt_epon_onu_upgrade_onu_response_code this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_onu_response_code_unpack(bcmolt_epon_onu_upgrade_onu_response_code *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_return_code_pack(bcmolt_epon_onu_upgrade_return_code this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_return_code_unpack(bcmolt_epon_onu_upgrade_return_code *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_auto_cfg_id_pack(bcmolt_epon_path_10g_ds_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_auto_cfg_id_unpack(bcmolt_epon_path_10g_ds_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_cfg_id_pack(bcmolt_epon_path_10g_ds_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_cfg_id_unpack(bcmolt_epon_path_10g_ds_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_key_id_pack(bcmolt_epon_path_10g_ds_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_key_id_unpack(bcmolt_epon_path_10g_ds_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_stat_alarm_cleared_id_pack(bcmolt_epon_path_10g_ds_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_stat_alarm_cleared_id_unpack(bcmolt_epon_path_10g_ds_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_stat_alarm_raised_id_pack(bcmolt_epon_path_10g_ds_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_stat_alarm_raised_id_unpack(bcmolt_epon_path_10g_ds_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_stat_cfg_id_pack(bcmolt_epon_path_10g_ds_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_stat_cfg_id_unpack(bcmolt_epon_path_10g_ds_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_stat_id_pack(bcmolt_epon_path_10g_ds_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_ds_stat_id_unpack(bcmolt_epon_path_10g_ds_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_auto_cfg_id_pack(bcmolt_epon_path_10g_us_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_auto_cfg_id_unpack(bcmolt_epon_path_10g_us_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_cfg_id_pack(bcmolt_epon_path_10g_us_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_cfg_id_unpack(bcmolt_epon_path_10g_us_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_key_id_pack(bcmolt_epon_path_10g_us_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_key_id_unpack(bcmolt_epon_path_10g_us_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_stat_alarm_cleared_id_pack(bcmolt_epon_path_10g_us_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_stat_alarm_cleared_id_unpack(bcmolt_epon_path_10g_us_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_stat_alarm_raised_id_pack(bcmolt_epon_path_10g_us_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_stat_alarm_raised_id_unpack(bcmolt_epon_path_10g_us_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_stat_cfg_id_pack(bcmolt_epon_path_10g_us_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_stat_cfg_id_unpack(bcmolt_epon_path_10g_us_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_stat_id_pack(bcmolt_epon_path_10g_us_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_10g_us_stat_id_unpack(bcmolt_epon_path_10g_us_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_auto_cfg_id_pack(bcmolt_epon_path_1g_ds_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_auto_cfg_id_unpack(bcmolt_epon_path_1g_ds_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_cfg_id_pack(bcmolt_epon_path_1g_ds_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_cfg_id_unpack(bcmolt_epon_path_1g_ds_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_key_id_pack(bcmolt_epon_path_1g_ds_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_key_id_unpack(bcmolt_epon_path_1g_ds_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_stat_alarm_cleared_id_pack(bcmolt_epon_path_1g_ds_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_stat_alarm_cleared_id_unpack(bcmolt_epon_path_1g_ds_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_stat_alarm_raised_id_pack(bcmolt_epon_path_1g_ds_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_stat_alarm_raised_id_unpack(bcmolt_epon_path_1g_ds_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_stat_cfg_id_pack(bcmolt_epon_path_1g_ds_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_stat_cfg_id_unpack(bcmolt_epon_path_1g_ds_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_stat_id_pack(bcmolt_epon_path_1g_ds_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_ds_stat_id_unpack(bcmolt_epon_path_1g_ds_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_auto_cfg_id_pack(bcmolt_epon_path_1g_us_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_auto_cfg_id_unpack(bcmolt_epon_path_1g_us_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_cfg_id_pack(bcmolt_epon_path_1g_us_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_cfg_id_unpack(bcmolt_epon_path_1g_us_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_key_id_pack(bcmolt_epon_path_1g_us_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_key_id_unpack(bcmolt_epon_path_1g_us_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_stat_alarm_cleared_id_pack(bcmolt_epon_path_1g_us_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_stat_alarm_cleared_id_unpack(bcmolt_epon_path_1g_us_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_stat_alarm_raised_id_pack(bcmolt_epon_path_1g_us_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_stat_alarm_raised_id_unpack(bcmolt_epon_path_1g_us_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_stat_cfg_id_pack(bcmolt_epon_path_1g_us_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_stat_cfg_id_unpack(bcmolt_epon_path_1g_us_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_stat_id_pack(bcmolt_epon_path_1g_us_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_path_1g_us_stat_id_unpack(bcmolt_epon_path_1g_us_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_state_pack(bcmolt_epon_protection_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_state_unpack(bcmolt_epon_protection_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_switching_type_pack(bcmolt_epon_protection_switching_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_switching_type_unpack(bcmolt_epon_protection_switching_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_protection_switching_detection_options_pack(bcmolt_protection_switching_detection_options this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_protection_switching_detection_options_unpack(bcmolt_protection_switching_detection_options *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_switching_reranging_options_pack(bcmolt_epon_protection_switching_reranging_options this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_switching_reranging_options_unpack(bcmolt_epon_protection_switching_reranging_options *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_pin_pack(bcmolt_gpio_pin this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_pin_unpack(bcmolt_gpio_pin *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_polarity_pack(bcmolt_gpio_polarity this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_polarity_unpack(bcmolt_gpio_polarity *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_rp_cfg_id_pack(bcmolt_epon_rp_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_rp_cfg_id_unpack(bcmolt_epon_rp_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_rp_key_id_pack(bcmolt_epon_rp_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_rp_key_id_unpack(bcmolt_epon_rp_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ext_irq_pack(bcmolt_ext_irq this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ext_irq_unpack(bcmolt_ext_irq *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_flush_mac_table_option_pack(bcmolt_flush_mac_table_option this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_flush_mac_table_option_unpack(bcmolt_flush_mac_table_option *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_frequency_adjustment_direction_pack(bcmolt_frequency_adjustment_direction this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_frequency_adjustment_direction_unpack(bcmolt_frequency_adjustment_direction *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_direction_pack(bcmolt_gem_port_direction this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_direction_unpack(bcmolt_gem_port_direction *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_type_pack(bcmolt_gem_port_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_type_unpack(bcmolt_gem_port_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_operation_pack(bcmolt_gem_port_operation this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_operation_unpack(bcmolt_gem_port_operation *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_cfg_id_pack(bcmolt_gpio_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_cfg_id_unpack(bcmolt_gpio_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_key_id_pack(bcmolt_gpio_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_key_id_unpack(bcmolt_gpio_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_pin_dir_pack(bcmolt_gpio_pin_dir this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_pin_dir_unpack(bcmolt_gpio_pin_dir *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_value_pack(bcmolt_gpio_value this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpio_value_unpack(bcmolt_gpio_value *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_auto_cfg_id_pack(bcmolt_gpon_alloc_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_auto_cfg_id_unpack(bcmolt_gpon_alloc_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_cfg_id_pack(bcmolt_gpon_alloc_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_cfg_id_unpack(bcmolt_gpon_alloc_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_configuration_completed_id_pack(bcmolt_gpon_alloc_configuration_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_configuration_completed_id_unpack(bcmolt_gpon_alloc_configuration_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_get_alloc_stats_completed_id_pack(bcmolt_gpon_alloc_get_alloc_stats_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_get_alloc_stats_completed_id_unpack(bcmolt_gpon_alloc_get_alloc_stats_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_get_stats_id_pack(bcmolt_gpon_alloc_get_stats_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_get_stats_id_unpack(bcmolt_gpon_alloc_get_stats_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_key_id_pack(bcmolt_gpon_alloc_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_key_id_unpack(bcmolt_gpon_alloc_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_set_state_id_pack(bcmolt_gpon_alloc_set_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_set_state_id_unpack(bcmolt_gpon_alloc_set_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_stat_alarm_cleared_id_pack(bcmolt_gpon_alloc_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_stat_alarm_cleared_id_unpack(bcmolt_gpon_alloc_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_stat_alarm_raised_id_pack(bcmolt_gpon_alloc_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_stat_alarm_raised_id_unpack(bcmolt_gpon_alloc_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_stat_cfg_id_pack(bcmolt_gpon_alloc_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_stat_cfg_id_unpack(bcmolt_gpon_alloc_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_stat_id_pack(bcmolt_gpon_alloc_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_stat_id_unpack(bcmolt_gpon_alloc_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_auto_cfg_id_pack(bcmolt_gpon_gem_port_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_auto_cfg_id_unpack(bcmolt_gpon_gem_port_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_cfg_id_pack(bcmolt_gpon_gem_port_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_cfg_id_unpack(bcmolt_gpon_gem_port_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_configuration_completed_id_pack(bcmolt_gpon_gem_port_configuration_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_configuration_completed_id_unpack(bcmolt_gpon_gem_port_configuration_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_key_id_pack(bcmolt_gpon_gem_port_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_key_id_unpack(bcmolt_gpon_gem_port_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_set_state_id_pack(bcmolt_gpon_gem_port_set_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_set_state_id_unpack(bcmolt_gpon_gem_port_set_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_stat_alarm_cleared_id_pack(bcmolt_gpon_gem_port_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_stat_alarm_cleared_id_unpack(bcmolt_gpon_gem_port_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_stat_alarm_raised_id_pack(bcmolt_gpon_gem_port_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_stat_alarm_raised_id_unpack(bcmolt_gpon_gem_port_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_stat_cfg_id_pack(bcmolt_gpon_gem_port_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_stat_cfg_id_unpack(bcmolt_gpon_gem_port_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_stat_id_pack(bcmolt_gpon_gem_port_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_stat_id_unpack(bcmolt_gpon_gem_port_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_state_pack(bcmolt_gpon_gem_port_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_state_unpack(bcmolt_gpon_gem_port_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_auto_cfg_id_pack(bcmolt_gpon_iwf_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_auto_cfg_id_unpack(bcmolt_gpon_iwf_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_cfg_id_pack(bcmolt_gpon_iwf_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_cfg_id_unpack(bcmolt_gpon_iwf_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_ds_egress_flow_cfg_id_pack(bcmolt_gpon_iwf_ds_egress_flow_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_ds_egress_flow_cfg_id_unpack(bcmolt_gpon_iwf_ds_egress_flow_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_ds_egress_flow_key_id_pack(bcmolt_gpon_iwf_ds_egress_flow_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_ds_egress_flow_key_id_unpack(bcmolt_gpon_iwf_ds_egress_flow_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_ds_ingress_flow_cfg_id_pack(bcmolt_gpon_iwf_ds_ingress_flow_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_ds_ingress_flow_cfg_id_unpack(bcmolt_gpon_iwf_ds_ingress_flow_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_ds_ingress_flow_key_id_pack(bcmolt_gpon_iwf_ds_ingress_flow_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_ds_ingress_flow_key_id_unpack(bcmolt_gpon_iwf_ds_ingress_flow_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_flush_mac_table_completed_id_pack(bcmolt_gpon_iwf_flush_mac_table_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_flush_mac_table_completed_id_unpack(bcmolt_gpon_iwf_flush_mac_table_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_flush_mac_table_id_pack(bcmolt_gpon_iwf_flush_mac_table_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_flush_mac_table_id_unpack(bcmolt_gpon_iwf_flush_mac_table_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_key_id_pack(bcmolt_gpon_iwf_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_key_id_unpack(bcmolt_gpon_iwf_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_auto_cfg_id_pack(bcmolt_gpon_iwf_mac_table_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_auto_cfg_id_unpack(bcmolt_gpon_iwf_mac_table_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_cfg_id_pack(bcmolt_gpon_iwf_mac_table_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_cfg_id_unpack(bcmolt_gpon_iwf_mac_table_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_key_id_pack(bcmolt_gpon_iwf_mac_table_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_key_id_unpack(bcmolt_gpon_iwf_mac_table_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_aged_id_pack(bcmolt_gpon_iwf_mac_table_mac_aged_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_aged_id_unpack(bcmolt_gpon_iwf_mac_table_mac_aged_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_dropped_id_pack(bcmolt_gpon_iwf_mac_table_mac_dropped_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_dropped_id_unpack(bcmolt_gpon_iwf_mac_table_mac_dropped_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_move_id_pack(bcmolt_gpon_iwf_mac_table_mac_move_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_mac_move_id_unpack(bcmolt_gpon_iwf_mac_table_mac_move_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_new_mac_id_pack(bcmolt_gpon_iwf_mac_table_new_mac_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_mac_table_new_mac_id_unpack(bcmolt_gpon_iwf_mac_table_new_mac_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_scan_mac_table_completed_id_pack(bcmolt_gpon_iwf_scan_mac_table_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_scan_mac_table_completed_id_unpack(bcmolt_gpon_iwf_scan_mac_table_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_scan_mac_table_id_pack(bcmolt_gpon_iwf_scan_mac_table_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_scan_mac_table_id_unpack(bcmolt_gpon_iwf_scan_mac_table_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_stat_alarm_cleared_id_pack(bcmolt_gpon_iwf_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_stat_alarm_cleared_id_unpack(bcmolt_gpon_iwf_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_stat_alarm_raised_id_pack(bcmolt_gpon_iwf_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_stat_alarm_raised_id_unpack(bcmolt_gpon_iwf_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_stat_cfg_id_pack(bcmolt_gpon_iwf_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_stat_cfg_id_unpack(bcmolt_gpon_iwf_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_stat_id_pack(bcmolt_gpon_iwf_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_stat_id_unpack(bcmolt_gpon_iwf_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_us_flow_cfg_id_pack(bcmolt_gpon_iwf_us_flow_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_us_flow_cfg_id_unpack(bcmolt_gpon_iwf_us_flow_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_us_flow_key_id_pack(bcmolt_gpon_iwf_us_flow_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_us_flow_key_id_unpack(bcmolt_gpon_iwf_us_flow_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_key_exchange_mode_pack(bcmolt_key_exchange_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_key_exchange_mode_unpack(bcmolt_key_exchange_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_activate_all_onus_completed_id_pack(bcmolt_gpon_ni_activate_all_onus_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_activate_all_onus_completed_id_unpack(bcmolt_gpon_ni_activate_all_onus_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_auto_cfg_id_pack(bcmolt_gpon_ni_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_auto_cfg_id_unpack(bcmolt_gpon_ni_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_broadcast_ploam_packet_id_pack(bcmolt_gpon_ni_broadcast_ploam_packet_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_broadcast_ploam_packet_id_unpack(bcmolt_gpon_ni_broadcast_ploam_packet_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_cfg_id_pack(bcmolt_gpon_ni_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_cfg_id_unpack(bcmolt_gpon_ni_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_cpu_packets_failure_id_pack(bcmolt_gpon_ni_cpu_packets_failure_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_cpu_packets_failure_id_unpack(bcmolt_gpon_ni_cpu_packets_failure_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_cpu_packets_id_pack(bcmolt_gpon_ni_cpu_packets_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_cpu_packets_id_unpack(bcmolt_gpon_ni_cpu_packets_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_deactivate_all_onus_completed_id_pack(bcmolt_gpon_ni_deactivate_all_onus_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_deactivate_all_onus_completed_id_unpack(bcmolt_gpon_ni_deactivate_all_onus_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_disable_all_onus_completed_id_pack(bcmolt_gpon_ni_disable_all_onus_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_disable_all_onus_completed_id_unpack(bcmolt_gpon_ni_disable_all_onus_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_disable_serial_number_id_pack(bcmolt_gpon_ni_disable_serial_number_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_disable_serial_number_id_unpack(bcmolt_gpon_ni_disable_serial_number_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_enable_all_onus_completed_id_pack(bcmolt_gpon_ni_enable_all_onus_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_enable_all_onus_completed_id_unpack(bcmolt_gpon_ni_enable_all_onus_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_key_id_pack(bcmolt_gpon_ni_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_key_id_unpack(bcmolt_gpon_ni_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_los_id_pack(bcmolt_gpon_ni_los_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_los_id_unpack(bcmolt_gpon_ni_los_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_onu_discovered_id_pack(bcmolt_gpon_ni_onu_discovered_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_onu_discovered_id_unpack(bcmolt_gpon_ni_onu_discovered_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_onu_upgrade_complete_id_pack(bcmolt_gpon_ni_onu_upgrade_complete_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_onu_upgrade_complete_id_unpack(bcmolt_gpon_ni_onu_upgrade_complete_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_protection_switching_onus_ranged_id_pack(bcmolt_gpon_ni_protection_switching_onus_ranged_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_protection_switching_onus_ranged_id_unpack(bcmolt_gpon_ni_protection_switching_onus_ranged_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_protection_switching_switchover_completed_id_pack(bcmolt_gpon_ni_protection_switching_switchover_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_protection_switching_switchover_completed_id_unpack(bcmolt_gpon_ni_protection_switching_switchover_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_protection_switching_traffic_resume_id_pack(bcmolt_gpon_ni_protection_switching_traffic_resume_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_protection_switching_traffic_resume_id_unpack(bcmolt_gpon_ni_protection_switching_traffic_resume_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id_pack(bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id_unpack(bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_reset_id_pack(bcmolt_gpon_ni_reset_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_reset_id_unpack(bcmolt_gpon_ni_reset_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_rogue_detection_completed_id_pack(bcmolt_gpon_ni_rogue_detection_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_rogue_detection_completed_id_unpack(bcmolt_gpon_ni_rogue_detection_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_rogue_detection_window_id_pack(bcmolt_gpon_ni_rogue_detection_window_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_rogue_detection_window_id_unpack(bcmolt_gpon_ni_rogue_detection_window_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id_pack(bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id_unpack(bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id_pack(bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id_unpack(bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_set_onu_state_id_pack(bcmolt_gpon_ni_set_onu_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_set_onu_state_id_unpack(bcmolt_gpon_ni_set_onu_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_set_pon_state_id_pack(bcmolt_gpon_ni_set_pon_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_set_pon_state_id_unpack(bcmolt_gpon_ni_set_pon_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_single_request_standby_pon_monitoring_id_pack(bcmolt_gpon_ni_single_request_standby_pon_monitoring_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_single_request_standby_pon_monitoring_id_unpack(bcmolt_gpon_ni_single_request_standby_pon_monitoring_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id_pack(bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id_unpack(bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_start_onu_upgrade_id_pack(bcmolt_gpon_ni_start_onu_upgrade_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_start_onu_upgrade_id_unpack(bcmolt_gpon_ni_start_onu_upgrade_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_stat_alarm_cleared_id_pack(bcmolt_gpon_ni_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_stat_alarm_cleared_id_unpack(bcmolt_gpon_ni_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_stat_alarm_raised_id_pack(bcmolt_gpon_ni_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_stat_alarm_raised_id_unpack(bcmolt_gpon_ni_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_stat_cfg_id_pack(bcmolt_gpon_ni_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_stat_cfg_id_unpack(bcmolt_gpon_ni_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_stat_id_pack(bcmolt_gpon_ni_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_stat_id_unpack(bcmolt_gpon_ni_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_state_change_completed_id_pack(bcmolt_gpon_ni_state_change_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_state_change_completed_id_unpack(bcmolt_gpon_ni_state_change_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_tod_request_completed_id_pack(bcmolt_gpon_ni_tod_request_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_tod_request_completed_id_unpack(bcmolt_gpon_ni_tod_request_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_tod_request_id_pack(bcmolt_gpon_ni_tod_request_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_tod_request_id_unpack(bcmolt_gpon_ni_tod_request_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_auto_cfg_id_pack(bcmolt_gpon_onu_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_auto_cfg_id_unpack(bcmolt_gpon_onu_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_ber_interval_configuration_completed_id_pack(bcmolt_gpon_onu_ber_interval_configuration_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_ber_interval_configuration_completed_id_unpack(bcmolt_gpon_onu_ber_interval_configuration_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_cfg_id_pack(bcmolt_gpon_onu_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_cfg_id_unpack(bcmolt_gpon_onu_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_change_power_level_id_pack(bcmolt_gpon_onu_change_power_level_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_change_power_level_id_unpack(bcmolt_gpon_onu_change_power_level_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_cpu_packet_id_pack(bcmolt_gpon_onu_cpu_packet_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_cpu_packet_id_unpack(bcmolt_gpon_onu_cpu_packet_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_cpu_packets_id_pack(bcmolt_gpon_onu_cpu_packets_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_cpu_packets_id_unpack(bcmolt_gpon_onu_cpu_packets_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_dfi_id_pack(bcmolt_gpon_onu_dfi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_dfi_id_unpack(bcmolt_gpon_onu_dfi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_dgi_id_pack(bcmolt_gpon_onu_dgi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_dgi_id_unpack(bcmolt_gpon_onu_dgi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_dowi_id_pack(bcmolt_gpon_onu_dowi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_dowi_id_unpack(bcmolt_gpon_onu_dowi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_err_id_pack(bcmolt_gpon_onu_err_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_err_id_unpack(bcmolt_gpon_onu_err_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_invalid_dbru_report_id_pack(bcmolt_gpon_onu_invalid_dbru_report_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_invalid_dbru_report_id_unpack(bcmolt_gpon_onu_invalid_dbru_report_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_completed_id_pack(bcmolt_gpon_onu_key_exchange_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_completed_id_unpack(bcmolt_gpon_onu_key_exchange_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_cycle_skipped_id_pack(bcmolt_gpon_onu_key_exchange_cycle_skipped_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_cycle_skipped_id_unpack(bcmolt_gpon_onu_key_exchange_cycle_skipped_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_decrypt_required_id_pack(bcmolt_gpon_onu_key_exchange_decrypt_required_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_decrypt_required_id_unpack(bcmolt_gpon_onu_key_exchange_decrypt_required_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_key_mismatch_id_pack(bcmolt_gpon_onu_key_exchange_key_mismatch_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_key_mismatch_id_unpack(bcmolt_gpon_onu_key_exchange_key_mismatch_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_key_request_timeout_id_pack(bcmolt_gpon_onu_key_exchange_key_request_timeout_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_key_request_timeout_id_unpack(bcmolt_gpon_onu_key_exchange_key_request_timeout_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_unconsecutive_index_id_pack(bcmolt_gpon_onu_key_exchange_unconsecutive_index_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_exchange_unconsecutive_index_id_unpack(bcmolt_gpon_onu_key_exchange_unconsecutive_index_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_id_pack(bcmolt_gpon_onu_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_key_id_unpack(bcmolt_gpon_onu_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_loai_id_pack(bcmolt_gpon_onu_loai_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_loai_id_unpack(bcmolt_gpon_onu_loai_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_loki_id_pack(bcmolt_gpon_onu_loki_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_loki_id_unpack(bcmolt_gpon_onu_loki_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_memi_id_pack(bcmolt_gpon_onu_memi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_memi_id_unpack(bcmolt_gpon_onu_memi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_omci_packet_id_pack(bcmolt_gpon_onu_omci_packet_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_omci_packet_id_unpack(bcmolt_gpon_onu_omci_packet_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_omci_port_id_configuration_completed_id_pack(bcmolt_gpon_onu_omci_port_id_configuration_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_omci_port_id_configuration_completed_id_unpack(bcmolt_gpon_onu_omci_port_id_configuration_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_activation_completed_id_pack(bcmolt_gpon_onu_onu_activation_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_activation_completed_id_unpack(bcmolt_gpon_onu_onu_activation_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_activation_standby_completed_id_pack(bcmolt_gpon_onu_onu_activation_standby_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_activation_standby_completed_id_unpack(bcmolt_gpon_onu_onu_activation_standby_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_alarm_id_pack(bcmolt_gpon_onu_onu_alarm_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_alarm_id_unpack(bcmolt_gpon_onu_onu_alarm_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_deactivation_completed_id_pack(bcmolt_gpon_onu_onu_deactivation_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_deactivation_completed_id_unpack(bcmolt_gpon_onu_onu_deactivation_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_disable_completed_id_pack(bcmolt_gpon_onu_onu_disable_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_disable_completed_id_unpack(bcmolt_gpon_onu_onu_disable_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_enable_completed_id_pack(bcmolt_gpon_onu_onu_enable_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_onu_enable_completed_id_unpack(bcmolt_gpon_onu_onu_enable_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_optical_reflection_id_pack(bcmolt_gpon_onu_optical_reflection_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_optical_reflection_id_unpack(bcmolt_gpon_onu_optical_reflection_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_password_authentication_completed_id_pack(bcmolt_gpon_onu_password_authentication_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_password_authentication_completed_id_unpack(bcmolt_gpon_onu_password_authentication_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_pee_id_pack(bcmolt_gpon_onu_pee_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_pee_id_unpack(bcmolt_gpon_onu_pee_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_ploam_packet_id_pack(bcmolt_gpon_onu_ploam_packet_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_ploam_packet_id_unpack(bcmolt_gpon_onu_ploam_packet_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_possible_drift_id_pack(bcmolt_gpon_onu_possible_drift_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_possible_drift_id_unpack(bcmolt_gpon_onu_possible_drift_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_power_management_state_change_id_pack(bcmolt_gpon_onu_power_management_state_change_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_power_management_state_change_id_unpack(bcmolt_gpon_onu_power_management_state_change_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_pst_id_pack(bcmolt_gpon_onu_pst_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_pst_id_unpack(bcmolt_gpon_onu_pst_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_ranging_completed_id_pack(bcmolt_gpon_onu_ranging_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_ranging_completed_id_unpack(bcmolt_gpon_onu_ranging_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_rei_id_pack(bcmolt_gpon_onu_rei_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_rei_id_unpack(bcmolt_gpon_onu_rei_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_rssi_measurement_completed_id_pack(bcmolt_gpon_onu_rssi_measurement_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_rssi_measurement_completed_id_unpack(bcmolt_gpon_onu_rssi_measurement_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_rssi_measurement_id_pack(bcmolt_gpon_onu_rssi_measurement_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_rssi_measurement_id_unpack(bcmolt_gpon_onu_rssi_measurement_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_sdi_id_pack(bcmolt_gpon_onu_sdi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_sdi_id_unpack(bcmolt_gpon_onu_sdi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_set_onu_state_id_pack(bcmolt_gpon_onu_set_onu_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_set_onu_state_id_unpack(bcmolt_gpon_onu_set_onu_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_sfi_id_pack(bcmolt_gpon_onu_sfi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_sfi_id_unpack(bcmolt_gpon_onu_sfi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_stat_alarm_cleared_id_pack(bcmolt_gpon_onu_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_stat_alarm_cleared_id_unpack(bcmolt_gpon_onu_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_stat_alarm_raised_id_pack(bcmolt_gpon_onu_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_stat_alarm_raised_id_unpack(bcmolt_gpon_onu_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_stat_cfg_id_pack(bcmolt_gpon_onu_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_stat_cfg_id_unpack(bcmolt_gpon_onu_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_stat_id_pack(bcmolt_gpon_onu_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_stat_id_unpack(bcmolt_gpon_onu_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_sufi_id_pack(bcmolt_gpon_onu_sufi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_sufi_id_unpack(bcmolt_gpon_onu_sufi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_tiwi_id_pack(bcmolt_gpon_onu_tiwi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_tiwi_id_unpack(bcmolt_gpon_onu_tiwi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_omci_device_id_pack(bcmolt_omci_device_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_omci_device_id_unpack(bcmolt_omci_device_id *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_return_code_pack(bcmolt_gpon_onu_upgrade_return_code this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_return_code_unpack(bcmolt_gpon_onu_upgrade_return_code *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_omci_result_code_pack(bcmolt_omci_result_code this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_omci_result_code_unpack(bcmolt_omci_result_code *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_state_pack(bcmolt_onu_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_onu_state_unpack(bcmolt_onu_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rssi_location_sign_pack(bcmolt_rssi_location_sign this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_rssi_location_sign_unpack(bcmolt_rssi_location_sign *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_post_discovery_mode_pack(bcmolt_onu_post_discovery_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_onu_post_discovery_mode_unpack(bcmolt_onu_post_discovery_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_trx_cfg_id_pack(bcmolt_gpon_trx_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_trx_cfg_id_unpack(bcmolt_gpon_trx_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_trx_key_id_pack(bcmolt_gpon_trx_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_trx_key_id_unpack(bcmolt_gpon_trx_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_image_transfer_status_pack(bcmolt_image_transfer_status this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_image_transfer_status_unpack(bcmolt_image_transfer_status *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_iwf_mode_pack(bcmolt_iwf_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_iwf_mode_unpack(bcmolt_iwf_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_auto_cfg_id_pack(bcmolt_log_entry_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_auto_cfg_id_unpack(bcmolt_log_entry_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_cfg_id_pack(bcmolt_log_entry_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_cfg_id_unpack(bcmolt_log_entry_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_key_id_pack(bcmolt_log_entry_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_key_id_unpack(bcmolt_log_entry_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_stat_alarm_cleared_id_pack(bcmolt_log_entry_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_stat_alarm_cleared_id_unpack(bcmolt_log_entry_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_stat_alarm_raised_id_pack(bcmolt_log_entry_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_stat_alarm_raised_id_unpack(bcmolt_log_entry_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_stat_cfg_id_pack(bcmolt_log_entry_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_stat_cfg_id_unpack(bcmolt_log_entry_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_stat_id_pack(bcmolt_log_entry_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_entry_stat_id_unpack(bcmolt_log_entry_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_file_id_pack(bcmolt_log_file_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_file_id_unpack(bcmolt_log_file_id *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_level_pack(bcmolt_log_level this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_level_unpack(bcmolt_log_level *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_style_pack(bcmolt_log_style this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_style_unpack(bcmolt_log_style *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_type_pack(bcmolt_log_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_log_type_unpack(bcmolt_log_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_logger_auto_cfg_id_pack(bcmolt_logger_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_logger_auto_cfg_id_unpack(bcmolt_logger_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_logger_cfg_id_pack(bcmolt_logger_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_logger_cfg_id_unpack(bcmolt_logger_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_logger_clear_log_id_pack(bcmolt_logger_clear_log_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_logger_clear_log_id_unpack(bcmolt_logger_clear_log_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_logger_key_id_pack(bcmolt_logger_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_logger_key_id_unpack(bcmolt_logger_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_logger_stat_alarm_cleared_id_pack(bcmolt_logger_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_logger_stat_alarm_cleared_id_unpack(bcmolt_logger_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_logger_stat_alarm_raised_id_pack(bcmolt_logger_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_logger_stat_alarm_raised_id_unpack(bcmolt_logger_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_logger_stat_cfg_id_pack(bcmolt_logger_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_logger_stat_cfg_id_unpack(bcmolt_logger_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_logger_stat_id_pack(bcmolt_logger_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_logger_stat_id_unpack(bcmolt_logger_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_mac_table_miss_fallback_pack(bcmolt_mac_table_miss_fallback this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_mac_table_miss_fallback_unpack(bcmolt_mac_table_miss_fallback *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_mac_table_learning_mode_pack(bcmolt_mac_table_learning_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_mac_table_learning_mode_unpack(bcmolt_mac_table_learning_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_mapping_tag_method_pack(bcmolt_mapping_tag_method this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_mapping_tag_method_unpack(bcmolt_mapping_tag_method *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_auto_cfg_id_pack(bcmolt_nni_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_auto_cfg_id_unpack(bcmolt_nni_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_cfg_id_pack(bcmolt_nni_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_cfg_id_unpack(bcmolt_nni_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_connection_pack(bcmolt_nni_connection this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_connection_unpack(bcmolt_nni_connection *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_key_id_pack(bcmolt_nni_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_key_id_unpack(bcmolt_nni_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trivalent_pack(bcmolt_trivalent this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trivalent_unpack(bcmolt_trivalent *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_serdes_cfg_id_pack(bcmolt_nni_serdes_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_serdes_cfg_id_unpack(bcmolt_nni_serdes_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_serdes_key_id_pack(bcmolt_nni_serdes_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_serdes_key_id_unpack(bcmolt_nni_serdes_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_stat_alarm_cleared_id_pack(bcmolt_nni_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_stat_alarm_cleared_id_unpack(bcmolt_nni_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_stat_alarm_raised_id_pack(bcmolt_nni_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_stat_alarm_raised_id_unpack(bcmolt_nni_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_stat_cfg_id_pack(bcmolt_nni_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_stat_cfg_id_unpack(bcmolt_nni_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_stat_id_pack(bcmolt_nni_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_stat_id_unpack(bcmolt_nni_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_status_changed_id_pack(bcmolt_nni_status_changed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_status_changed_id_unpack(bcmolt_nni_status_changed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_odn_class_pack(bcmolt_odn_class this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_odn_class_unpack(bcmolt_odn_class *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_omci_port_id_operation_pack(bcmolt_omci_port_id_operation this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_omci_port_id_operation_unpack(bcmolt_omci_port_id_operation *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_operation_pack(bcmolt_onu_operation this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_onu_operation_unpack(bcmolt_onu_operation *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_power_level_pack(bcmolt_onu_power_level this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_onu_power_level_unpack(bcmolt_onu_power_level *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_tc_protocol_pack(bcmolt_tc_protocol this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_tc_protocol_unpack(bcmolt_tc_protocol *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_packet_injection_error_pack(bcmolt_packet_injection_error this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_packet_injection_error_unpack(bcmolt_packet_injection_error *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_packet_type_pack(bcmolt_packet_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_packet_type_unpack(bcmolt_packet_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_password_authentication_fail_reason_pack(bcmolt_password_authentication_fail_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_password_authentication_fail_reason_unpack(bcmolt_password_authentication_fail_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_polarity_pack(bcmolt_polarity this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_polarity_unpack(bcmolt_polarity *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_polling_interval_pack(bcmolt_polling_interval this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_s32(buf, (int32_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_polling_interval_unpack(bcmolt_polling_interval *this, bcmolt_buf *buf)
{
    int32_t num_val;
    if (!bcmolt_buf_read_s32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_operation_pack(bcmolt_pon_operation this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_operation_unpack(bcmolt_pon_operation *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_protection_switching_options_pack(bcmolt_pon_protection_switching_options this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_protection_switching_options_unpack(bcmolt_pon_protection_switching_options *this, bcmolt_buf *buf)
{
    uint32_t num_val;
    if (!bcmolt_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_state_pack(bcmolt_pon_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_state_unpack(bcmolt_pon_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_power_levelling_control_pack(bcmolt_power_levelling_control this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_power_levelling_control_unpack(bcmolt_power_levelling_control *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_power_management_transition_reason_pack(bcmolt_power_management_transition_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_power_management_transition_reason_unpack(bcmolt_power_management_transition_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_polynomial_pack(bcmolt_prbs_polynomial this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_polynomial_unpack(bcmolt_prbs_polynomial *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_checker_mode_pack(bcmolt_prbs_checker_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_checker_mode_unpack(bcmolt_prbs_checker_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_lock_state_pack(bcmolt_prbs_lock_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_lock_state_unpack(bcmolt_prbs_lock_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_raman_mitigation_mode_pack(bcmolt_raman_mitigation_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_raman_mitigation_mode_unpack(bcmolt_raman_mitigation_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_fail_reason_pack(bcmolt_ranging_fail_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_fail_reason_unpack(bcmolt_ranging_fail_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_registration_behavior_pack(bcmolt_registration_behavior this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_registration_behavior_unpack(bcmolt_registration_behavior *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_request_registration_fail_reason_pack(bcmolt_request_registration_fail_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_request_registration_fail_reason_unpack(bcmolt_request_registration_fail_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_result_pack(bcmolt_result this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_result_unpack(bcmolt_result *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_algorithm_type_pack(bcmolt_rogue_detection_algorithm_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_algorithm_type_unpack(bcmolt_rogue_detection_algorithm_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_window_pack(bcmolt_rogue_detection_window this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_window_unpack(bcmolt_rogue_detection_window *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_measurement_result_pack(bcmolt_rogue_measurement_result this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_measurement_result_unpack(bcmolt_rogue_measurement_result *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_scan_status_pack(bcmolt_rogue_scan_status this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_scan_status_unpack(bcmolt_rogue_scan_status *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rssi_measurement_fail_reason_pack(bcmolt_rssi_measurement_fail_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_rssi_measurement_fail_reason_unpack(bcmolt_rssi_measurement_fail_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_secure_mutual_authentication_fail_reason_pack(bcmolt_secure_mutual_authentication_fail_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_secure_mutual_authentication_fail_reason_unpack(bcmolt_secure_mutual_authentication_fail_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_serdes_ranging_mode_pack(bcmolt_serdes_ranging_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_serdes_ranging_mode_unpack(bcmolt_serdes_ranging_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_serdes_instance_pack(bcmolt_serdes_instance this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_serdes_instance_unpack(bcmolt_serdes_instance *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_shaper_mode_pack(bcmolt_shaper_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_shaper_mode_unpack(bcmolt_shaper_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_software_error_cfg_id_pack(bcmolt_software_error_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_software_error_cfg_id_unpack(bcmolt_software_error_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_software_error_key_id_pack(bcmolt_software_error_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_software_error_key_id_unpack(bcmolt_software_error_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_condition_type_pack(bcmolt_stat_condition_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_stat_condition_type_unpack(bcmolt_stat_condition_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_switch_over_type_c_onu_state_pack(bcmolt_switch_over_type_c_onu_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_switch_over_type_c_onu_state_unpack(bcmolt_switch_over_type_c_onu_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_system_mode_pack(bcmolt_system_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_system_mode_unpack(bcmolt_system_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_us_operating_wavelength_bands_pack(bcmolt_us_operating_wavelength_bands this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_us_operating_wavelength_bands_unpack(bcmolt_us_operating_wavelength_bands *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_traffic_resume_result_pack(bcmolt_traffic_resume_result this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_traffic_resume_result_unpack(bcmolt_traffic_resume_result *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_auto_cfg_id_pack(bcmolt_trx_calibration_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_auto_cfg_id_unpack(bcmolt_trx_calibration_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_capture_window_and_statistic_completed_id_pack(bcmolt_trx_calibration_capture_window_and_statistic_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_capture_window_and_statistic_completed_id_unpack(bcmolt_trx_calibration_capture_window_and_statistic_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_key_id_pack(bcmolt_trx_calibration_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_key_id_unpack(bcmolt_trx_calibration_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_start_capture_window_id_pack(bcmolt_trx_calibration_start_capture_window_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_start_capture_window_id_unpack(bcmolt_trx_calibration_start_capture_window_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_stop_capture_window_id_pack(bcmolt_trx_calibration_stop_capture_window_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_stop_capture_window_id_unpack(bcmolt_trx_calibration_stop_capture_window_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_trigger_pack(bcmolt_trx_calibration_trigger this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_trigger_unpack(bcmolt_trx_calibration_trigger *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_trigger_position_pack(bcmolt_trx_calibration_trigger_position this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_trigger_position_unpack(bcmolt_trx_calibration_trigger_position *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_window_mode_pack(bcmolt_trx_calibration_window_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_calibration_window_mode_unpack(bcmolt_trx_calibration_window_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_type_pack(bcmolt_trx_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_type_unpack(bcmolt_trx_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_tune_in_fail_reason_pack(bcmolt_tune_in_fail_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_tune_in_fail_reason_unpack(bcmolt_tune_in_fail_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_tune_out_fail_reason_pack(bcmolt_tune_out_fail_reason this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_tune_out_fail_reason_unpack(bcmolt_tune_out_fail_reason *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_uart_baudrate_pack(bcmolt_uart_baudrate this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_uart_baudrate_unpack(bcmolt_uart_baudrate *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_us_gem_port_destination_pack(bcmolt_us_gem_port_destination this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_us_gem_port_destination_unpack(bcmolt_us_gem_port_destination *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_us_vlan_action_pack(bcmolt_us_vlan_action this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_us_vlan_action_unpack(bcmolt_us_vlan_action *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_vlan_to_flow_mapping_method_pack(bcmolt_vlan_to_flow_mapping_method this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_vlan_to_flow_mapping_method_unpack(bcmolt_vlan_to_flow_mapping_method *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_auto_cfg_id_pack(bcmolt_xgpon_alloc_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_auto_cfg_id_unpack(bcmolt_xgpon_alloc_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_cfg_id_pack(bcmolt_xgpon_alloc_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_cfg_id_unpack(bcmolt_xgpon_alloc_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_configuration_completed_id_pack(bcmolt_xgpon_alloc_configuration_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_configuration_completed_id_unpack(bcmolt_xgpon_alloc_configuration_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_get_alloc_stats_completed_id_pack(bcmolt_xgpon_alloc_get_alloc_stats_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_get_alloc_stats_completed_id_unpack(bcmolt_xgpon_alloc_get_alloc_stats_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_get_stats_id_pack(bcmolt_xgpon_alloc_get_stats_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_get_stats_id_unpack(bcmolt_xgpon_alloc_get_stats_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_key_id_pack(bcmolt_xgpon_alloc_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_key_id_unpack(bcmolt_xgpon_alloc_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_set_state_id_pack(bcmolt_xgpon_alloc_set_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_set_state_id_unpack(bcmolt_xgpon_alloc_set_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_stat_alarm_cleared_id_pack(bcmolt_xgpon_alloc_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_stat_alarm_cleared_id_unpack(bcmolt_xgpon_alloc_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_stat_alarm_raised_id_pack(bcmolt_xgpon_alloc_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_stat_alarm_raised_id_unpack(bcmolt_xgpon_alloc_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_stat_cfg_id_pack(bcmolt_xgpon_alloc_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_stat_cfg_id_unpack(bcmolt_xgpon_alloc_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_stat_id_pack(bcmolt_xgpon_alloc_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_stat_id_unpack(bcmolt_xgpon_alloc_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_auto_cfg_id_pack(bcmolt_xgpon_gem_port_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_auto_cfg_id_unpack(bcmolt_xgpon_gem_port_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_cfg_id_pack(bcmolt_xgpon_gem_port_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_cfg_id_unpack(bcmolt_xgpon_gem_port_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_key_id_pack(bcmolt_xgpon_gem_port_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_key_id_unpack(bcmolt_xgpon_gem_port_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_stat_alarm_cleared_id_pack(bcmolt_xgpon_gem_port_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_stat_alarm_cleared_id_unpack(bcmolt_xgpon_gem_port_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_stat_alarm_raised_id_pack(bcmolt_xgpon_gem_port_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_stat_alarm_raised_id_unpack(bcmolt_xgpon_gem_port_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_stat_cfg_id_pack(bcmolt_xgpon_gem_port_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_stat_cfg_id_unpack(bcmolt_xgpon_gem_port_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_stat_id_pack(bcmolt_xgpon_gem_port_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_stat_id_unpack(bcmolt_xgpon_gem_port_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_state_pack(bcmolt_xgpon_gem_port_state this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_state_unpack(bcmolt_xgpon_gem_port_state *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_iwf_cfg_id_pack(bcmolt_xgpon_iwf_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_iwf_cfg_id_unpack(bcmolt_xgpon_iwf_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_iwf_key_id_pack(bcmolt_xgpon_iwf_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_iwf_key_id_unpack(bcmolt_xgpon_iwf_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_activate_all_onus_completed_id_pack(bcmolt_xgpon_ni_activate_all_onus_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_activate_all_onus_completed_id_unpack(bcmolt_xgpon_ni_activate_all_onus_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_adjust_tx_wavelength_id_pack(bcmolt_xgpon_ni_adjust_tx_wavelength_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_adjust_tx_wavelength_id_unpack(bcmolt_xgpon_ni_adjust_tx_wavelength_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_auto_cfg_id_pack(bcmolt_xgpon_ni_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_auto_cfg_id_unpack(bcmolt_xgpon_ni_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_broadcast_ploam_packet_id_pack(bcmolt_xgpon_ni_broadcast_ploam_packet_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_broadcast_ploam_packet_id_unpack(bcmolt_xgpon_ni_broadcast_ploam_packet_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_cfg_id_pack(bcmolt_xgpon_ni_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_cfg_id_unpack(bcmolt_xgpon_ni_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_cpu_packets_failure_id_pack(bcmolt_xgpon_ni_cpu_packets_failure_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_cpu_packets_failure_id_unpack(bcmolt_xgpon_ni_cpu_packets_failure_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_cpu_packets_id_pack(bcmolt_xgpon_ni_cpu_packets_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_cpu_packets_id_unpack(bcmolt_xgpon_ni_cpu_packets_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_deactivate_all_onus_completed_id_pack(bcmolt_xgpon_ni_deactivate_all_onus_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_deactivate_all_onus_completed_id_unpack(bcmolt_xgpon_ni_deactivate_all_onus_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_disable_all_onus_completed_id_pack(bcmolt_xgpon_ni_disable_all_onus_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_disable_all_onus_completed_id_unpack(bcmolt_xgpon_ni_disable_all_onus_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_disable_serial_number_id_pack(bcmolt_xgpon_ni_disable_serial_number_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_disable_serial_number_id_unpack(bcmolt_xgpon_ni_disable_serial_number_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_enable_all_onus_completed_id_pack(bcmolt_xgpon_ni_enable_all_onus_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_enable_all_onus_completed_id_unpack(bcmolt_xgpon_ni_enable_all_onus_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_key_id_pack(bcmolt_xgpon_ni_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_key_id_unpack(bcmolt_xgpon_ni_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_los_id_pack(bcmolt_xgpon_ni_los_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_los_id_unpack(bcmolt_xgpon_ni_los_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_onu_discovered_id_pack(bcmolt_xgpon_ni_onu_discovered_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_onu_discovered_id_unpack(bcmolt_xgpon_ni_onu_discovered_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_onu_upgrade_complete_id_pack(bcmolt_xgpon_ni_onu_upgrade_complete_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_onu_upgrade_complete_id_unpack(bcmolt_xgpon_ni_onu_upgrade_complete_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_protection_switching_onus_ranged_id_pack(bcmolt_xgpon_ni_protection_switching_onus_ranged_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_protection_switching_onus_ranged_id_unpack(bcmolt_xgpon_ni_protection_switching_onus_ranged_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_protection_switching_switchover_completed_id_pack(bcmolt_xgpon_ni_protection_switching_switchover_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_protection_switching_switchover_completed_id_unpack(bcmolt_xgpon_ni_protection_switching_switchover_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_protection_switching_traffic_resume_id_pack(bcmolt_xgpon_ni_protection_switching_traffic_resume_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_protection_switching_traffic_resume_id_unpack(bcmolt_xgpon_ni_protection_switching_traffic_resume_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_reset_id_pack(bcmolt_xgpon_ni_reset_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_reset_id_unpack(bcmolt_xgpon_ni_reset_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_rogue_detection_completed_id_pack(bcmolt_xgpon_ni_rogue_detection_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_rogue_detection_completed_id_unpack(bcmolt_xgpon_ni_rogue_detection_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_rogue_detection_window_id_pack(bcmolt_xgpon_ni_rogue_detection_window_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_rogue_detection_window_id_unpack(bcmolt_xgpon_ni_rogue_detection_window_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id_pack(bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id_unpack(bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_run_special_bw_map_id_pack(bcmolt_xgpon_ni_run_special_bw_map_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_run_special_bw_map_id_unpack(bcmolt_xgpon_ni_run_special_bw_map_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id_pack(bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id_unpack(bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_set_onu_state_id_pack(bcmolt_xgpon_ni_set_onu_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_set_onu_state_id_unpack(bcmolt_xgpon_ni_set_onu_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_set_pon_state_id_pack(bcmolt_xgpon_ni_set_pon_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_set_pon_state_id_unpack(bcmolt_xgpon_ni_set_pon_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id_pack(bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id_unpack(bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id_pack(bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id_unpack(bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_start_onu_upgrade_id_pack(bcmolt_xgpon_ni_start_onu_upgrade_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_start_onu_upgrade_id_unpack(bcmolt_xgpon_ni_start_onu_upgrade_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_stat_alarm_cleared_id_pack(bcmolt_xgpon_ni_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_stat_alarm_cleared_id_unpack(bcmolt_xgpon_ni_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_stat_alarm_raised_id_pack(bcmolt_xgpon_ni_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_stat_alarm_raised_id_unpack(bcmolt_xgpon_ni_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_stat_cfg_id_pack(bcmolt_xgpon_ni_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_stat_cfg_id_unpack(bcmolt_xgpon_ni_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_stat_id_pack(bcmolt_xgpon_ni_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_stat_id_unpack(bcmolt_xgpon_ni_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_state_change_completed_id_pack(bcmolt_xgpon_ni_state_change_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_state_change_completed_id_unpack(bcmolt_xgpon_ni_state_change_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_tod_request_completed_id_pack(bcmolt_xgpon_ni_tod_request_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_tod_request_completed_id_unpack(bcmolt_xgpon_ni_tod_request_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_tod_request_id_pack(bcmolt_xgpon_ni_tod_request_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_tod_request_id_unpack(bcmolt_xgpon_ni_tod_request_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_num_of_onus_pack(bcmolt_xgpon_num_of_onus this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_num_of_onus_unpack(bcmolt_xgpon_num_of_onus *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_adjust_tx_wavelength_id_pack(bcmolt_xgpon_onu_adjust_tx_wavelength_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_adjust_tx_wavelength_id_unpack(bcmolt_xgpon_onu_adjust_tx_wavelength_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_auto_cfg_id_pack(bcmolt_xgpon_onu_auto_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_auto_cfg_id_unpack(bcmolt_xgpon_onu_auto_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_cfg_id_pack(bcmolt_xgpon_onu_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_cfg_id_unpack(bcmolt_xgpon_onu_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_change_power_levelling_id_pack(bcmolt_xgpon_onu_change_power_levelling_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_change_power_levelling_id_unpack(bcmolt_xgpon_onu_change_power_levelling_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_cpu_packet_id_pack(bcmolt_xgpon_onu_cpu_packet_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_cpu_packet_id_unpack(bcmolt_xgpon_onu_cpu_packet_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_cpu_packets_id_pack(bcmolt_xgpon_onu_cpu_packets_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_cpu_packets_id_unpack(bcmolt_xgpon_onu_cpu_packets_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_dfi_id_pack(bcmolt_xgpon_onu_dfi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_dfi_id_unpack(bcmolt_xgpon_onu_dfi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_dgi_id_pack(bcmolt_xgpon_onu_dgi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_dgi_id_unpack(bcmolt_xgpon_onu_dgi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_dowi_id_pack(bcmolt_xgpon_onu_dowi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_dowi_id_unpack(bcmolt_xgpon_onu_dowi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_get_power_consumption_id_pack(bcmolt_xgpon_onu_get_power_consumption_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_get_power_consumption_id_unpack(bcmolt_xgpon_onu_get_power_consumption_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_get_power_level_id_pack(bcmolt_xgpon_onu_get_power_level_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_get_power_level_id_unpack(bcmolt_xgpon_onu_get_power_level_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_invalid_dbru_report_id_pack(bcmolt_xgpon_onu_invalid_dbru_report_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_invalid_dbru_report_id_unpack(bcmolt_xgpon_onu_invalid_dbru_report_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_exchange_completed_id_pack(bcmolt_xgpon_onu_key_exchange_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_exchange_completed_id_unpack(bcmolt_xgpon_onu_key_exchange_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_exchange_cycle_skipped_id_pack(bcmolt_xgpon_onu_key_exchange_cycle_skipped_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_exchange_cycle_skipped_id_unpack(bcmolt_xgpon_onu_key_exchange_cycle_skipped_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_exchange_key_mismatch_id_pack(bcmolt_xgpon_onu_key_exchange_key_mismatch_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_exchange_key_mismatch_id_unpack(bcmolt_xgpon_onu_key_exchange_key_mismatch_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_exchange_key_request_timeout_id_pack(bcmolt_xgpon_onu_key_exchange_key_request_timeout_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_exchange_key_request_timeout_id_unpack(bcmolt_xgpon_onu_key_exchange_key_request_timeout_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_id_pack(bcmolt_xgpon_onu_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_key_id_unpack(bcmolt_xgpon_onu_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_looci_id_pack(bcmolt_xgpon_onu_looci_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_looci_id_unpack(bcmolt_xgpon_onu_looci_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_omci_packet_id_pack(bcmolt_xgpon_onu_omci_packet_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_omci_packet_id_unpack(bcmolt_xgpon_onu_omci_packet_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_activation_completed_id_pack(bcmolt_xgpon_onu_onu_activation_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_activation_completed_id_unpack(bcmolt_xgpon_onu_onu_activation_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_alarm_id_pack(bcmolt_xgpon_onu_onu_alarm_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_alarm_id_unpack(bcmolt_xgpon_onu_onu_alarm_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_deactivation_completed_id_pack(bcmolt_xgpon_onu_onu_deactivation_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_deactivation_completed_id_unpack(bcmolt_xgpon_onu_onu_deactivation_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_disable_completed_id_pack(bcmolt_xgpon_onu_onu_disable_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_disable_completed_id_unpack(bcmolt_xgpon_onu_onu_disable_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_enable_completed_id_pack(bcmolt_xgpon_onu_onu_enable_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_enable_completed_id_unpack(bcmolt_xgpon_onu_onu_enable_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_tuning_in_completed_id_pack(bcmolt_xgpon_onu_onu_tuning_in_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_tuning_in_completed_id_unpack(bcmolt_xgpon_onu_onu_tuning_in_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_tuning_in_id_pack(bcmolt_xgpon_onu_onu_tuning_in_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_tuning_in_id_unpack(bcmolt_xgpon_onu_onu_tuning_in_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_tuning_out_completed_id_pack(bcmolt_xgpon_onu_onu_tuning_out_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_tuning_out_completed_id_unpack(bcmolt_xgpon_onu_onu_tuning_out_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_tuning_out_id_pack(bcmolt_xgpon_onu_onu_tuning_out_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_onu_tuning_out_id_unpack(bcmolt_xgpon_onu_onu_tuning_out_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_optical_reflection_id_pack(bcmolt_xgpon_onu_optical_reflection_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_optical_reflection_id_unpack(bcmolt_xgpon_onu_optical_reflection_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_ploam_packet_id_pack(bcmolt_xgpon_onu_ploam_packet_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_ploam_packet_id_unpack(bcmolt_xgpon_onu_ploam_packet_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_possible_drift_id_pack(bcmolt_xgpon_onu_possible_drift_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_possible_drift_id_unpack(bcmolt_xgpon_onu_possible_drift_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_power_consumption_report_id_pack(bcmolt_xgpon_onu_power_consumption_report_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_power_consumption_report_id_unpack(bcmolt_xgpon_onu_power_consumption_report_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_power_level_report_id_pack(bcmolt_xgpon_onu_power_level_report_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_power_level_report_id_unpack(bcmolt_xgpon_onu_power_level_report_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_power_management_state_change_id_pack(bcmolt_xgpon_onu_power_management_state_change_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_power_management_state_change_id_unpack(bcmolt_xgpon_onu_power_management_state_change_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_pqsi_id_pack(bcmolt_xgpon_onu_pqsi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_pqsi_id_unpack(bcmolt_xgpon_onu_pqsi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_ranging_completed_id_pack(bcmolt_xgpon_onu_ranging_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_ranging_completed_id_unpack(bcmolt_xgpon_onu_ranging_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_registration_id_id_pack(bcmolt_xgpon_onu_registration_id_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_registration_id_id_unpack(bcmolt_xgpon_onu_registration_id_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_request_registration_id_pack(bcmolt_xgpon_onu_request_registration_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_request_registration_id_unpack(bcmolt_xgpon_onu_request_registration_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_rssi_measurement_completed_id_pack(bcmolt_xgpon_onu_rssi_measurement_completed_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_rssi_measurement_completed_id_unpack(bcmolt_xgpon_onu_rssi_measurement_completed_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_rssi_measurement_id_pack(bcmolt_xgpon_onu_rssi_measurement_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_rssi_measurement_id_unpack(bcmolt_xgpon_onu_rssi_measurement_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_sdi_id_pack(bcmolt_xgpon_onu_sdi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_sdi_id_unpack(bcmolt_xgpon_onu_sdi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_secure_mutual_authentication_failure_id_pack(bcmolt_xgpon_onu_secure_mutual_authentication_failure_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_secure_mutual_authentication_failure_id_unpack(bcmolt_xgpon_onu_secure_mutual_authentication_failure_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_secure_mutual_authentication_id_pack(bcmolt_xgpon_onu_secure_mutual_authentication_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_secure_mutual_authentication_id_unpack(bcmolt_xgpon_onu_secure_mutual_authentication_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_set_onu_state_id_pack(bcmolt_xgpon_onu_set_onu_state_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_set_onu_state_id_unpack(bcmolt_xgpon_onu_set_onu_state_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_sfi_id_pack(bcmolt_xgpon_onu_sfi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_sfi_id_unpack(bcmolt_xgpon_onu_sfi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_stat_alarm_cleared_id_pack(bcmolt_xgpon_onu_stat_alarm_cleared_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_stat_alarm_cleared_id_unpack(bcmolt_xgpon_onu_stat_alarm_cleared_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_stat_alarm_raised_id_pack(bcmolt_xgpon_onu_stat_alarm_raised_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_stat_alarm_raised_id_unpack(bcmolt_xgpon_onu_stat_alarm_raised_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_stat_cfg_id_pack(bcmolt_xgpon_onu_stat_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_stat_cfg_id_unpack(bcmolt_xgpon_onu_stat_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_stat_id_pack(bcmolt_xgpon_onu_stat_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_stat_id_unpack(bcmolt_xgpon_onu_stat_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_sufi_id_pack(bcmolt_xgpon_onu_sufi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_sufi_id_unpack(bcmolt_xgpon_onu_sufi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_tiwi_id_pack(bcmolt_xgpon_onu_tiwi_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_tiwi_id_unpack(bcmolt_xgpon_onu_tiwi_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_tuning_response_id_pack(bcmolt_xgpon_onu_tuning_response_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_tuning_response_id_unpack(bcmolt_xgpon_onu_tuning_response_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_serdes_ranging_mode_pack(bcmolt_xgpon_serdes_ranging_mode this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_serdes_ranging_mode_unpack(bcmolt_xgpon_serdes_ranging_mode *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_cfg_id_pack(bcmolt_xgpon_trx_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_cfg_id_unpack(bcmolt_xgpon_trx_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_key_id_pack(bcmolt_xgpon_trx_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_key_id_unpack(bcmolt_xgpon_trx_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_type_pack(bcmolt_xgpon_trx_type this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_type_unpack(bcmolt_xgpon_trx_type *this, bcmolt_buf *buf)
{
    uint8_t num_val;
    if (!bcmolt_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xpon_serdes_cfg_id_pack(bcmolt_xpon_serdes_cfg_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xpon_serdes_cfg_id_unpack(bcmolt_xpon_serdes_cfg_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xpon_serdes_key_id_pack(bcmolt_xpon_serdes_key_id this, bcmolt_buf *buf)
{
    return bcmolt_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmolt_xpon_serdes_key_id_unpack(bcmolt_xpon_serdes_key_id *this, bcmolt_buf *buf)
{
    uint16_t num_val;
    if (!bcmolt_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_actual_schedulershaper_set_default(bcmolt_actual_schedulershaper *this)
{
    this->actual_mbs_tq = (bcmolt_time_quanta) 0;
    this->actual_weight_tq = (bcmolt_time_quanta) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_actual_schedulershaper_pack(const bcmolt_actual_schedulershaper *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->actual_mbs_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->actual_weight_tq))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_actual_schedulershaper_unpack(bcmolt_actual_schedulershaper *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->actual_mbs_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->actual_weight_tq))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_actual_schedulershaper_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_actual_schedulershaper_bounds_check(const bcmolt_actual_schedulershaper *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_aes_key_set_default(bcmolt_aes_key *this)
{
    memset(this->bytes, 0, sizeof(this->bytes));
}

/******************************************************************************/
bcmos_bool bcmolt_aes_key_pack(const bcmolt_aes_key *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->bytes, 16))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_aes_key_unpack(bcmolt_aes_key *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->bytes, 16))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_aes_key_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 16);
}

/******************************************************************************/
bcmos_bool bcmolt_aes_key_bounds_check(const bcmolt_aes_key *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_api_capture_buffer_reader_set_default(bcmolt_api_capture_buffer_reader *this)
{
    this->offset = 0;
    this->size = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_buffer_reader_pack(const bcmolt_api_capture_buffer_reader *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->offset))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_buffer_reader_unpack(bcmolt_api_capture_buffer_reader *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->offset))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_buffer_reader_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_buffer_reader_bounds_check(const bcmolt_api_capture_buffer_reader *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_api_capture_config_set_default(bcmolt_api_capture_config *this)
{
    this->location = BCMOLT_API_CAPTURE_LOCATION_DEVICE;
    this->buffer_size_bytes = 16384;
    this->buffer_mode = BCMOLT_API_CAPTURE_BUFFER_MODE_WRAP;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_config_pack(const bcmolt_api_capture_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_api_capture_location_pack(this->location, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->buffer_size_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_api_capture_buffer_mode_pack(this->buffer_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_config_unpack(bcmolt_api_capture_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_api_capture_location_unpack(&this->location, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->buffer_size_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_api_capture_buffer_mode_unpack(&this->buffer_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 6);
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_config_bounds_check(const bcmolt_api_capture_config *this)
{
    switch (this->location)
    {
        case BCMOLT_API_CAPTURE_LOCATION_DEVICE:
            break;
        case BCMOLT_API_CAPTURE_LOCATION_HOST:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->buffer_size_bytes < 16384)
    {
        return BCMOS_FALSE;
    }

    switch (this->buffer_mode)
    {
        case BCMOLT_API_CAPTURE_BUFFER_MODE_OVERFLOW:
            break;
        case BCMOLT_API_CAPTURE_BUFFER_MODE_WRAP:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_api_capture_stats_set_default(bcmolt_api_capture_stats *this)
{
    this->buffer_used_bytes = 0;
    this->buffer_wrap_count = 0;
    this->events_recorded = 0;
    this->events_dropped = 0;
    this->readable_bytes = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_stats_pack(const bcmolt_api_capture_stats *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->buffer_used_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->buffer_wrap_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->events_recorded))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->events_dropped))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->readable_bytes))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_stats_unpack(bcmolt_api_capture_stats *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->buffer_used_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->buffer_wrap_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->events_recorded))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->events_dropped))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->readable_bytes))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_stats_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 20);
}

/******************************************************************************/
bcmos_bool bcmolt_api_capture_stats_bounds_check(const bcmolt_api_capture_stats *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_bounds_set_default(bcmolt_bounds *this)
{
    this->best_case = 0;
    this->worst_case = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_bounds_pack(const bcmolt_bounds *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->best_case))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->worst_case))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_bounds_unpack(bcmolt_bounds *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->best_case))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->worst_case))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_bounds_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_bounds_bounds_check(const bcmolt_bounds *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_bounds_8_set_default(bcmolt_arr_bounds_8 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_bounds_8_pack(const bcmolt_arr_bounds_8 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 8; i0++)
    {
        if (!bcmolt_bounds_pack(&this->arr[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_bounds_8_unpack(bcmolt_arr_bounds_8 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 8; i0++)
    {
        if (!bcmolt_bounds_unpack(&this->arr[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_bounds_8_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 64);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_bounds_8_bounds_check(const bcmolt_arr_bounds_8 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_calibration_record_8_set_default(bcmolt_arr_calibration_record_8 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_calibration_record_8_pack(const bcmolt_arr_calibration_record_8 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 8; i0++)
    {
        if (!bcmolt_calibration_record_pack(this->arr[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_calibration_record_8_unpack(bcmolt_arr_calibration_record_8 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 8; i0++)
    {
        if (!bcmolt_calibration_record_unpack(&this->arr[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_calibration_record_8_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_calibration_record_8_bounds_check(const bcmolt_arr_calibration_record_8 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ds_frequency_offset_set_default(bcmolt_ds_frequency_offset *this)
{
    this->sign = BCMOLT_SIGN_POSITIVE;
    this->value = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_ds_frequency_offset_pack(const bcmolt_ds_frequency_offset *this, bcmolt_buf *buf)
{
    if (!bcmolt_sign_pack(this->sign, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->value))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ds_frequency_offset_unpack(bcmolt_ds_frequency_offset *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_sign_unpack(&this->sign, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->value))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ds_frequency_offset_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_ds_frequency_offset_bounds_check(const bcmolt_ds_frequency_offset *this)
{
    switch (this->sign)
    {
        case BCMOLT_SIGN_POSITIVE:
            break;
        case BCMOLT_SIGN_NEGATIVE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_channel_profile_set_default(bcmolt_channel_profile *this)
{
    this->version = 0;
    this->channel_index = 0;
    this->ds_frequency_offset.sign = BCMOLT_SIGN_POSITIVE;
    this->ds_frequency_offset.value = 0;
    this->channel_partition = 0;
    this->uwlch_id = 0;
    this->us_frequency = 0;
    this->us_rate = BCMOLT_UPSTREAM_LINE_RATE_CAPABILITIES_RATE_2_P_5_G;
    this->default_onu_attenuation = 0;
    this->response_threshold = 0;
    this->us_link_type = BCMOLT_LINK_TYPE_UNSPECIFIED;
    this->is_valid = BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_profile_pack(const bcmolt_channel_profile *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->version))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->channel_index))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ds_frequency_offset_pack(&this->ds_frequency_offset, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->channel_partition))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->uwlch_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->us_frequency))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_upstream_line_rate_capabilities_pack(this->us_rate, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->default_onu_attenuation))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->response_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_link_type_pack(this->us_link_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->is_valid))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_profile_unpack(bcmolt_channel_profile *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->version))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->channel_index))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ds_frequency_offset_unpack(&this->ds_frequency_offset, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->channel_partition))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->uwlch_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->us_frequency))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_upstream_line_rate_capabilities_unpack(&this->us_rate, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->default_onu_attenuation))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->response_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_link_type_unpack(&this->us_link_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->is_valid))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_profile_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 15);
}

/******************************************************************************/
bcmos_bool bcmolt_channel_profile_bounds_check(const bcmolt_channel_profile *this)
{
    if (this->version > 15)
    {
        return BCMOS_FALSE;
    }

    if (this->channel_index > 15)
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ds_frequency_offset_bounds_check(&this->ds_frequency_offset))
    {
        return BCMOS_FALSE;
    }

    if (this->channel_partition > 15)
    {
        return BCMOS_FALSE;
    }

    if (this->uwlch_id > 15)
    {
        return BCMOS_FALSE;
    }

    switch (this->us_rate)
    {
        case BCMOLT_UPSTREAM_LINE_RATE_CAPABILITIES_RATE_2_P_5_G:
            break;
        case BCMOLT_UPSTREAM_LINE_RATE_CAPABILITIES_RATE_10_G:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->default_onu_attenuation > 7)
    {
        return BCMOS_FALSE;
    }

    switch (this->us_link_type)
    {
        case BCMOLT_LINK_TYPE_UNSPECIFIED:
            break;
        case BCMOLT_LINK_TYPE_B:
            break;
        case BCMOLT_LINK_TYPE_A:
            break;
        case BCMOLT_LINK_TYPE_A_AND_B:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_channel_profile_8_set_default(bcmolt_arr_channel_profile_8 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_channel_profile_8_pack(const bcmolt_arr_channel_profile_8 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 8; i0++)
    {
        if (!bcmolt_channel_profile_pack(&this->arr[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_channel_profile_8_unpack(bcmolt_arr_channel_profile_8 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 8; i0++)
    {
        if (!bcmolt_channel_profile_unpack(&this->arr[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_channel_profile_8_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 120);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_channel_profile_8_bounds_check(const bcmolt_arr_channel_profile_8 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_power_consumption_channel_report_set_default(bcmolt_power_consumption_channel_report *this)
{
    this->ds_wavelength_channel_id = 0;
    this->us_wavelength_channel_id = 0;
    this->power_consumption = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_power_consumption_channel_report_pack(const bcmolt_power_consumption_channel_report *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->ds_wavelength_channel_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->us_wavelength_channel_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->power_consumption))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_power_consumption_channel_report_unpack(bcmolt_power_consumption_channel_report *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->ds_wavelength_channel_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->us_wavelength_channel_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->power_consumption))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_power_consumption_channel_report_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_power_consumption_channel_report_bounds_check(const bcmolt_power_consumption_channel_report *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_power_consumption_channel_report_8_set_default(bcmolt_arr_power_consumption_channel_report_8 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_power_consumption_channel_report_8_pack(const bcmolt_arr_power_consumption_channel_report_8 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 8; i0++)
    {
        if (!bcmolt_power_consumption_channel_report_pack(&this->arr[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_power_consumption_channel_report_8_unpack(bcmolt_arr_power_consumption_channel_report_8 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 8; i0++)
    {
        if (!bcmolt_power_consumption_channel_report_unpack(&this->arr[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_power_consumption_channel_report_8_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 32);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_power_consumption_channel_report_8_bounds_check(const bcmolt_arr_power_consumption_channel_report_8 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u16_2_set_default(bcmolt_arr_u16_2 *this)
{
    this->arr[0] = 4096;
    this->arr[1] = 8192;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_2_pack(const bcmolt_arr_u16_2 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 2; i0++)
    {
        if (!bcmolt_buf_write_u16(buf, this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_2_unpack(bcmolt_arr_u16_2 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 2; i0++)
    {
        if (!bcmolt_buf_read_u16(buf, &this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_2_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_2_bounds_check(const bcmolt_arr_u16_2 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u16_2_hex_set_default(bcmolt_arr_u16_2_hex *this)
{
    this->arr[0] = 33024U;
    this->arr[1] = 33024U;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_2_hex_pack(const bcmolt_arr_u16_2_hex *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 2; i0++)
    {
        if (!bcmolt_buf_write_u16(buf, this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_2_hex_unpack(bcmolt_arr_u16_2_hex *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 2; i0++)
    {
        if (!bcmolt_buf_read_u16(buf, &this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_2_hex_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_2_hex_bounds_check(const bcmolt_arr_u16_2_hex *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u16_5_hex_set_default(bcmolt_arr_u16_5_hex *this)
{
    this->arr[0] = 33024U;
    this->arr[1] = 34984U;
    this->arr[2] = 37120U;
    this->arr[3] = 37376U;
    this->arr[4] = 33024U;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_5_hex_pack(const bcmolt_arr_u16_5_hex *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 5; i0++)
    {
        if (!bcmolt_buf_write_u16(buf, this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_5_hex_unpack(bcmolt_arr_u16_5_hex *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 5; i0++)
    {
        if (!bcmolt_buf_read_u16(buf, &this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_5_hex_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 10);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_5_hex_bounds_check(const bcmolt_arr_u16_5_hex *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u16_7_set_default(bcmolt_arr_u16_7 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_7_pack(const bcmolt_arr_u16_7 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 7; i0++)
    {
        if (!bcmolt_buf_write_u16(buf, this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_7_unpack(bcmolt_arr_u16_7 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 7; i0++)
    {
        if (!bcmolt_buf_read_u16(buf, &this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_7_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 14);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u16_7_bounds_check(const bcmolt_arr_u16_7 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u32_6_set_default(bcmolt_arr_u32_6 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u32_6_pack(const bcmolt_arr_u32_6 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 6; i0++)
    {
        if (!bcmolt_buf_write_u32(buf, this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u32_6_unpack(bcmolt_arr_u32_6 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 6; i0++)
    {
        if (!bcmolt_buf_read_u32(buf, &this->arr[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u32_6_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 24);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u32_6_bounds_check(const bcmolt_arr_u32_6 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u8_10_set_default(bcmolt_arr_u8_10 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_10_pack(const bcmolt_arr_u8_10 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->arr, 10))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_10_unpack(bcmolt_arr_u8_10 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->arr, 10))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_10_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 10);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_10_bounds_check(const bcmolt_arr_u8_10 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u8_12_set_default(bcmolt_arr_u8_12 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_12_pack(const bcmolt_arr_u8_12 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->arr, 12))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_12_unpack(bcmolt_arr_u8_12 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->arr, 12))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_12_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 12);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_12_bounds_check(const bcmolt_arr_u8_12 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u8_13_set_default(bcmolt_arr_u8_13 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_13_pack(const bcmolt_arr_u8_13 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->arr, 13))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_13_unpack(bcmolt_arr_u8_13 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->arr, 13))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_13_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 13);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_13_bounds_check(const bcmolt_arr_u8_13 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u8_36_set_default(bcmolt_arr_u8_36 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_36_pack(const bcmolt_arr_u8_36 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->arr, 36))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_36_unpack(bcmolt_arr_u8_36 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->arr, 36))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_36_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 36);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_36_bounds_check(const bcmolt_arr_u8_36 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u8_4_set_default(bcmolt_arr_u8_4 *this)
{
    this->arr[0] = 7;
    this->arr[1] = 7;
    this->arr[2] = 7;
    this->arr[3] = 7;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_4_pack(const bcmolt_arr_u8_4 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->arr, 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_4_unpack(bcmolt_arr_u8_4 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->arr, 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_4_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_4_bounds_check(const bcmolt_arr_u8_4 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_u8_40_set_default(bcmolt_arr_u8_40 *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_40_pack(const bcmolt_arr_u8_40 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->arr, 40))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_40_unpack(bcmolt_arr_u8_40 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->arr, 40))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_40_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 40);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_u8_40_bounds_check(const bcmolt_arr_u8_40 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_burst_profile_set_default(bcmolt_xgpon_burst_profile *this)
{
    this->profile_version = 0;
    this->is_fec_on = BCMOS_FALSE;
    this->delimiter_size_in_bytes = 0;
    this->delimiter_pattern_high = 0;
    this->delimiter_pattern_low = 8;
    this->preamble_length_in_bytes = 8;
    this->preamble_repeats_count = 0;
    this->preamble_pattern_high = 0;
    this->preamble_pattern_low = 0;
    this->pon_tag = 0;
    this->num_of_guard_bytes = 0;
    this->is_profile_valid = BCMOS_FALSE;
    this->burst_overhead_size_in_words = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_burst_profile_pack(const bcmolt_xgpon_burst_profile *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->profile_version))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->is_fec_on))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->delimiter_size_in_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->delimiter_pattern_high))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->delimiter_pattern_low))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->preamble_length_in_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->preamble_repeats_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->preamble_pattern_high))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->preamble_pattern_low))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u64(buf, this->pon_tag))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->num_of_guard_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->is_profile_valid))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->burst_overhead_size_in_words))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_burst_profile_unpack(bcmolt_xgpon_burst_profile *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->profile_version))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->is_fec_on))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->delimiter_size_in_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->delimiter_pattern_high))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->delimiter_pattern_low))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->preamble_length_in_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->preamble_repeats_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->preamble_pattern_high))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->preamble_pattern_low))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u64(buf, &this->pon_tag))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->num_of_guard_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->is_profile_valid))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->burst_overhead_size_in_words))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_burst_profile_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 38);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_burst_profile_bounds_check(const bcmolt_xgpon_burst_profile *this)
{
    if (this->delimiter_size_in_bytes > 8)
    {
        return BCMOS_FALSE;
    }

    if (this->preamble_length_in_bytes < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->preamble_length_in_bytes > 8)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_xgpon_burst_profile_4_set_default(bcmolt_arr_xgpon_burst_profile_4 *this)
{
    this->arr[0].profile_version = 0;
    this->arr[0].is_fec_on = BCMOS_FALSE;
    this->arr[0].delimiter_size_in_bytes = 8;
    this->arr[0].delimiter_pattern_high = 3015562000UL;
    this->arr[0].delimiter_pattern_low = 2999259041UL;
    this->arr[0].preamble_length_in_bytes = 8;
    this->arr[0].preamble_repeats_count = 20;
    this->arr[0].preamble_pattern_high = 2863311530UL;
    this->arr[0].preamble_pattern_low = 2863311530UL;
    this->arr[0].pon_tag = 0;
    this->arr[0].num_of_guard_bytes = 16;
    this->arr[0].is_profile_valid = BCMOS_TRUE;
    this->arr[0].burst_overhead_size_in_words = 78;
    this->arr[1].profile_version = 0;
    this->arr[1].is_fec_on = BCMOS_FALSE;
    this->arr[1].delimiter_size_in_bytes = 8;
    this->arr[1].delimiter_pattern_high = 3015562000UL;
    this->arr[1].delimiter_pattern_low = 2999259041UL;
    this->arr[1].preamble_length_in_bytes = 8;
    this->arr[1].preamble_repeats_count = 9;
    this->arr[1].preamble_pattern_high = 2863311530UL;
    this->arr[1].preamble_pattern_low = 2863311530UL;
    this->arr[1].pon_tag = 0;
    this->arr[1].num_of_guard_bytes = 16;
    this->arr[1].is_profile_valid = BCMOS_TRUE;
    this->arr[1].burst_overhead_size_in_words = 56;
    this->arr[2].profile_version = 0;
    this->arr[2].is_fec_on = BCMOS_TRUE;
    this->arr[2].delimiter_size_in_bytes = 8;
    this->arr[2].delimiter_pattern_high = 3015562000UL;
    this->arr[2].delimiter_pattern_low = 2999259041UL;
    this->arr[2].preamble_length_in_bytes = 8;
    this->arr[2].preamble_repeats_count = 20;
    this->arr[2].preamble_pattern_high = 2863311530UL;
    this->arr[2].preamble_pattern_low = 2863311530UL;
    this->arr[2].pon_tag = 0;
    this->arr[2].num_of_guard_bytes = 16;
    this->arr[2].is_profile_valid = BCMOS_TRUE;
    this->arr[2].burst_overhead_size_in_words = 78;
    this->arr[3].profile_version = 0;
    this->arr[3].is_fec_on = BCMOS_TRUE;
    this->arr[3].delimiter_size_in_bytes = 8;
    this->arr[3].delimiter_pattern_high = 3015562000UL;
    this->arr[3].delimiter_pattern_low = 2999259041UL;
    this->arr[3].preamble_length_in_bytes = 8;
    this->arr[3].preamble_repeats_count = 9;
    this->arr[3].preamble_pattern_high = 2863311530UL;
    this->arr[3].preamble_pattern_low = 2863311530UL;
    this->arr[3].pon_tag = 0;
    this->arr[3].num_of_guard_bytes = 16;
    this->arr[3].is_profile_valid = BCMOS_TRUE;
    this->arr[3].burst_overhead_size_in_words = 56;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_xgpon_burst_profile_4_pack(const bcmolt_arr_xgpon_burst_profile_4 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 4; i0++)
    {
        if (!bcmolt_xgpon_burst_profile_pack(&this->arr[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_xgpon_burst_profile_4_unpack(bcmolt_arr_xgpon_burst_profile_4 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 4; i0++)
    {
        if (!bcmolt_xgpon_burst_profile_unpack(&this->arr[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_xgpon_burst_profile_4_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 152);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_xgpon_burst_profile_4_bounds_check(const bcmolt_arr_xgpon_burst_profile_4 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_trx_configuration_set_default(bcmolt_xgpon_trx_configuration *this)
{
    this->trx_reset_pattern_first = 0;
    this->trx_reset_pattern_middle = 0;
    this->trx_reset_pattern_last = 0;
    this->trx_reset_middle_repeats_count = 0;
    this->trx_reset_location = 0;
    this->trx_reset_polarity = BCMOS_FALSE;
    this->bcdr_reset_pattern_first = 0;
    this->bcdr_reset_pattern_middle = 0;
    this->bcdr_reset_pattern_last = 0;
    this->bcdr_reset_middle_repeats_count = 0;
    this->bcdr_reset_location = 0;
    this->bcdr_reset_polarity = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_configuration_pack(const bcmolt_xgpon_trx_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->trx_reset_pattern_first))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->trx_reset_pattern_middle))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->trx_reset_pattern_last))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->trx_reset_middle_repeats_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->trx_reset_location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->trx_reset_polarity))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->bcdr_reset_pattern_first))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->bcdr_reset_pattern_middle))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->bcdr_reset_pattern_last))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->bcdr_reset_middle_repeats_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->bcdr_reset_location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->bcdr_reset_polarity))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_configuration_unpack(bcmolt_xgpon_trx_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->trx_reset_pattern_first))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->trx_reset_pattern_middle))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->trx_reset_pattern_last))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->trx_reset_middle_repeats_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->trx_reset_location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->trx_reset_polarity))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->bcdr_reset_pattern_first))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->bcdr_reset_pattern_middle))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->bcdr_reset_pattern_last))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->bcdr_reset_middle_repeats_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->bcdr_reset_location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->bcdr_reset_polarity))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 31);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_configuration_bounds_check(const bcmolt_xgpon_trx_configuration *this)
{
    if (this->trx_reset_location > 511)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_arr_xgpon_trx_configuration_4_set_default(bcmolt_arr_xgpon_trx_configuration_4 *this)
{
    this->arr[0].trx_reset_pattern_first = 0;
    this->arr[0].trx_reset_pattern_middle = 4294967295UL;
    this->arr[0].trx_reset_pattern_last = 0;
    this->arr[0].trx_reset_middle_repeats_count = 4;
    this->arr[0].trx_reset_location = 0;
    this->arr[0].trx_reset_polarity = BCMOS_FALSE;
    this->arr[0].bcdr_reset_pattern_first = 0;
    this->arr[0].bcdr_reset_pattern_middle = 255;
    this->arr[0].bcdr_reset_pattern_last = 0;
    this->arr[0].bcdr_reset_middle_repeats_count = 1;
    this->arr[0].bcdr_reset_location = 20;
    this->arr[0].bcdr_reset_polarity = BCMOS_FALSE;
    this->arr[1].trx_reset_pattern_first = 0;
    this->arr[1].trx_reset_pattern_middle = 4294967295UL;
    this->arr[1].trx_reset_pattern_last = 0;
    this->arr[1].trx_reset_middle_repeats_count = 4;
    this->arr[1].trx_reset_location = 33;
    this->arr[1].trx_reset_polarity = BCMOS_FALSE;
    this->arr[1].bcdr_reset_pattern_first = 0;
    this->arr[1].bcdr_reset_pattern_middle = 255;
    this->arr[1].bcdr_reset_pattern_last = 0;
    this->arr[1].bcdr_reset_middle_repeats_count = 1;
    this->arr[1].bcdr_reset_location = 23;
    this->arr[1].bcdr_reset_polarity = BCMOS_FALSE;
    this->arr[2].trx_reset_pattern_first = 0;
    this->arr[2].trx_reset_pattern_middle = 4294967295UL;
    this->arr[2].trx_reset_pattern_last = 0;
    this->arr[2].trx_reset_middle_repeats_count = 4;
    this->arr[2].trx_reset_location = 0;
    this->arr[2].trx_reset_polarity = BCMOS_FALSE;
    this->arr[2].bcdr_reset_pattern_first = 0;
    this->arr[2].bcdr_reset_pattern_middle = 255;
    this->arr[2].bcdr_reset_pattern_last = 0;
    this->arr[2].bcdr_reset_middle_repeats_count = 1;
    this->arr[2].bcdr_reset_location = 20;
    this->arr[2].bcdr_reset_polarity = BCMOS_FALSE;
    this->arr[3].trx_reset_pattern_first = 0;
    this->arr[3].trx_reset_pattern_middle = 4294967295UL;
    this->arr[3].trx_reset_pattern_last = 0;
    this->arr[3].trx_reset_middle_repeats_count = 4;
    this->arr[3].trx_reset_location = 33;
    this->arr[3].trx_reset_polarity = BCMOS_FALSE;
    this->arr[3].bcdr_reset_pattern_first = 0;
    this->arr[3].bcdr_reset_pattern_middle = 255;
    this->arr[3].bcdr_reset_pattern_last = 0;
    this->arr[3].bcdr_reset_middle_repeats_count = 1;
    this->arr[3].bcdr_reset_location = 23;
    this->arr[3].bcdr_reset_polarity = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_xgpon_trx_configuration_4_pack(const bcmolt_arr_xgpon_trx_configuration_4 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    for (i0 = 0; i0 < 4; i0++)
    {
        if (!bcmolt_xgpon_trx_configuration_pack(&this->arr[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_xgpon_trx_configuration_4_unpack(bcmolt_arr_xgpon_trx_configuration_4 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    for (i0 = 0; i0 < 4; i0++)
    {
        if (!bcmolt_xgpon_trx_configuration_unpack(&this->arr[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_arr_xgpon_trx_configuration_4_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 124);
}

/******************************************************************************/
bcmos_bool bcmolt_arr_xgpon_trx_configuration_4_bounds_check(const bcmolt_arr_xgpon_trx_configuration_4 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_automatic_onu_deactivation_set_default(bcmolt_automatic_onu_deactivation *this)
{
    this->los = BCMOS_FALSE;
    this->onu_alarms = BCMOS_FALSE;
    this->tiwi = BCMOS_FALSE;
    this->ack_timeout = BCMOS_FALSE;
    this->sfi = BCMOS_FALSE;
    this->loki = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_automatic_onu_deactivation_pack(const bcmolt_automatic_onu_deactivation *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_bool(buf, this->los))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->onu_alarms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->tiwi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->ack_timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->sfi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->loki))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_automatic_onu_deactivation_unpack(bcmolt_automatic_onu_deactivation *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_bool(buf, &this->los))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->onu_alarms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->tiwi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->ack_timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->sfi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->loki))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_automatic_onu_deactivation_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 6);
}

/******************************************************************************/
bcmos_bool bcmolt_automatic_onu_deactivation_bounds_check(const bcmolt_automatic_onu_deactivation *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_resync_control_set_default(bcmolt_resync_control *this)
{
    this->start_pattern = 15;
    this->middle_pattern = 0;
    this->last_pattern = 0;
    this->middle_repetition = 0;
    this->location = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_resync_control_pack(const bcmolt_resync_control *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->start_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->middle_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->last_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->middle_repetition))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->location))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_resync_control_unpack(bcmolt_resync_control *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->start_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->middle_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->last_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->middle_repetition))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->location))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_resync_control_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_resync_control_bounds_check(const bcmolt_resync_control *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_bcdr_resync_pattern_configuration_set_default(bcmolt_bcdr_resync_pattern_configuration *this)
{
    this->resync_control.start_pattern = 15;
    this->resync_control.middle_pattern = 0;
    this->resync_control.last_pattern = 0;
    this->resync_control.middle_repetition = 0;
    this->resync_control.location = 34;
    this->ranging_resync_control.start_pattern = 15;
    this->ranging_resync_control.middle_pattern = 0;
    this->ranging_resync_control.last_pattern = 0;
    this->ranging_resync_control.middle_repetition = 0;
    this->ranging_resync_control.location = 7;
}

/******************************************************************************/
bcmos_bool bcmolt_bcdr_resync_pattern_configuration_pack(const bcmolt_bcdr_resync_pattern_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_resync_control_pack(&this->resync_control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_resync_control_pack(&this->ranging_resync_control, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_bcdr_resync_pattern_configuration_unpack(bcmolt_bcdr_resync_pattern_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_resync_control_unpack(&this->resync_control, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_resync_control_unpack(&this->ranging_resync_control, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_bcdr_resync_pattern_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 10);
}

/******************************************************************************/
bcmos_bool bcmolt_bcdr_resync_pattern_configuration_bounds_check(const bcmolt_bcdr_resync_pattern_configuration *this)
{
    if (!bcmolt_resync_control_bounds_check(&this->resync_control))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_resync_control_bounds_check(&this->ranging_resync_control))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ber_monitor_params_set_default(bcmolt_ber_monitor_params *this)
{
    this->us_ber_interval = 5000;
    this->sf_threshold = 3;
    this->sd_threshold = 5;
}

/******************************************************************************/
bcmos_bool bcmolt_ber_monitor_params_pack(const bcmolt_ber_monitor_params *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->us_ber_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->sf_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->sd_threshold))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ber_monitor_params_unpack(bcmolt_ber_monitor_params *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->us_ber_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->sf_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->sd_threshold))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ber_monitor_params_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 6);
}

/******************************************************************************/
bcmos_bool bcmolt_ber_monitor_params_bounds_check(const bcmolt_ber_monitor_params *this)
{
    if (this->us_ber_interval > 60000UL)
    {
        return BCMOS_FALSE;
    }

    if (this->sf_threshold < 3)
    {
        return BCMOS_FALSE;
    }

    if (this->sf_threshold > 8)
    {
        return BCMOS_FALSE;
    }

    if (this->sd_threshold < 4)
    {
        return BCMOS_FALSE;
    }

    if (this->sd_threshold > 9)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_cbr_rt_allocation_profile_set_default(bcmolt_cbr_rt_allocation_profile *this)
{
    this->ma_7 = 64;
    this->ma_3 = 256;
    this->ma_1 = 512;
}

/******************************************************************************/
bcmos_bool bcmolt_cbr_rt_allocation_profile_pack(const bcmolt_cbr_rt_allocation_profile *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->ma_7))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->ma_3))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->ma_1))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_cbr_rt_allocation_profile_unpack(bcmolt_cbr_rt_allocation_profile *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->ma_7))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->ma_3))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->ma_1))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_cbr_rt_allocation_profile_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 6);
}

/******************************************************************************/
bcmos_bool bcmolt_cbr_rt_allocation_profile_bounds_check(const bcmolt_cbr_rt_allocation_profile *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ddr_test_completed_set_default(bcmolt_ddr_test_completed *this)
{
    this->status = (bcmolt_ddr_test_status) 2;
}

/******************************************************************************/
bcmos_bool bcmolt_ddr_test_completed_pack(const bcmolt_ddr_test_completed *this, bcmolt_buf *buf)
{
    if (!bcmolt_ddr_test_status_pack(this->status, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->status)
    {
        case BCMOLT_DDR_TEST_STATUS_COMPLETED:
            {
                if (!bcmolt_ddr_test_result_pack(this->u.completed.cpu_result, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_ddr_test_result_pack(this->u.completed.ras_0_result, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_ddr_test_result_pack(this->u.completed.ras_1_result, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_CONNECTION_FAILED:
            {
                if (!bcmolt_host_connection_fail_reason_pack(this->u.connection_failed.reason, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_TIMEOUT:
        default:
            {
            }
            break;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ddr_test_completed_get_packed_length(const bcmolt_ddr_test_completed *this)
{
    uint32_t count = 1;
    switch (this->status)
    {
        case BCMOLT_DDR_TEST_STATUS_COMPLETED:
            {
                count += 3;
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_CONNECTION_FAILED:
            {
                count += 1;
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_TIMEOUT:
        default:
            {
            }
            break;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ddr_test_completed_unpack(bcmolt_ddr_test_completed *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_ddr_test_status_unpack(&this->status, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->status)
    {
        case BCMOLT_DDR_TEST_STATUS_COMPLETED:
            {
                if (!bcmolt_ddr_test_result_unpack(&this->u.completed.cpu_result, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_ddr_test_result_unpack(&this->u.completed.ras_0_result, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_ddr_test_result_unpack(&this->u.completed.ras_1_result, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_CONNECTION_FAILED:
            {
                if (!bcmolt_host_connection_fail_reason_unpack(&this->u.connection_failed.reason, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_TIMEOUT:
        default:
            {
            }
            break;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ddr_test_completed_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    bcmolt_ddr_test_status status;
    if (!bcmolt_ddr_test_status_unpack(&status, packed))
    {
        return BCMOS_FALSE;
    }

    switch (status)
    {
        case BCMOLT_DDR_TEST_STATUS_COMPLETED:
            {
                if (!bcmolt_buf_skip(packed, 1))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 1))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 1))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_CONNECTION_FAILED:
            {
                if (!bcmolt_buf_skip(packed, 1))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_TIMEOUT:
        default:
            {
            }
            break;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ddr_test_completed_bounds_check(const bcmolt_ddr_test_completed *this)
{
    switch (this->status)
    {
        case BCMOLT_DDR_TEST_STATUS_COMPLETED:
            {
                switch (this->u.completed.cpu_result)
                {
                    case BCMOLT_DDR_TEST_RESULT_SUCCESS:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_PHY_INIT_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_DRAM_INIT_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_SHMOO_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_EDIS_TEST_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_MEM_TEST_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_NOT_TESTED:
                        break;
                    default:
                        return BCMOS_FALSE;
                }

                switch (this->u.completed.ras_0_result)
                {
                    case BCMOLT_DDR_TEST_RESULT_SUCCESS:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_PHY_INIT_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_DRAM_INIT_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_SHMOO_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_EDIS_TEST_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_MEM_TEST_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_NOT_TESTED:
                        break;
                    default:
                        return BCMOS_FALSE;
                }

                switch (this->u.completed.ras_1_result)
                {
                    case BCMOLT_DDR_TEST_RESULT_SUCCESS:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_PHY_INIT_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_DRAM_INIT_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_SHMOO_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_EDIS_TEST_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_MEM_TEST_ERROR:
                        break;
                    case BCMOLT_DDR_TEST_RESULT_NOT_TESTED:
                        break;
                    default:
                        return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_CONNECTION_FAILED:
            {
                switch (this->u.connection_failed.reason)
                {
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_TIMEOUT:
                        break;
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_KEEPALIVE:
                        break;
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_USER_CALLBACK_ERROR:
                        break;
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_SOFTWARE_VERSION_MISMATCH:
                        break;
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_SYSTEM_MODE_MISMATCH:
                        break;
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_NNI_SPEED_MISMATCH:
                        break;
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_RECONNECT_TIMEOUT:
                        break;
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_INTERNAL_ERROR:
                        break;
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_SYSTEM_MODE_NOT_SUPPORTED:
                        break;
                    case BCMOLT_HOST_CONNECTION_FAIL_REASON_PARAMETER:
                        break;
                    default:
                        return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_DDR_TEST_STATUS_TIMEOUT:
            break;
        default:
            {
            }

            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_debug_device_cfg_set_default(bcmolt_debug_device_cfg *this)
{
    this->host_dma_rx_queue_size = 128;
    this->host_dma_tx_queue_size = 128;
    this->avs_control = BCMOS_FALSE;
    this->use_prev_pon_serdes_firmware = BCMOS_FALSE;
    this->use_prev_nni_serdes_firmware = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_device_cfg_pack(const bcmolt_debug_device_cfg *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->host_dma_rx_queue_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->host_dma_tx_queue_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->avs_control))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->use_prev_pon_serdes_firmware))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->use_prev_nni_serdes_firmware))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_device_cfg_unpack(bcmolt_debug_device_cfg *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->host_dma_rx_queue_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->host_dma_tx_queue_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->avs_control))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->use_prev_pon_serdes_firmware))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->use_prev_nni_serdes_firmware))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_device_cfg_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 7);
}

/******************************************************************************/
bcmos_bool bcmolt_debug_device_cfg_bounds_check(const bcmolt_debug_device_cfg *this)
{
    if (this->host_dma_rx_queue_size < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->host_dma_rx_queue_size > 1024)
    {
        return BCMOS_FALSE;
    }

    if (this->host_dma_tx_queue_size < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->host_dma_tx_queue_size > 1024)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_device_nni_speed_set_default(bcmolt_device_nni_speed *this)
{
    this->first_half = BCMOLT_NNI_SPEED_GBPS_1;
    this->second_half = BCMOLT_NNI_SPEED_GBPS_1;
}

/******************************************************************************/
bcmos_bool bcmolt_device_nni_speed_pack(const bcmolt_device_nni_speed *this, bcmolt_buf *buf)
{
    if (!bcmolt_nni_speed_pack(this->first_half, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_nni_speed_pack(this->second_half, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_nni_speed_unpack(bcmolt_device_nni_speed *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_nni_speed_unpack(&this->first_half, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_nni_speed_unpack(&this->second_half, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_nni_speed_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_device_nni_speed_bounds_check(const bcmolt_device_nni_speed *this)
{
    switch (this->first_half)
    {
        case BCMOLT_NNI_SPEED_GBPS_1:
            break;
        case BCMOLT_NNI_SPEED_GBPS_2P5:
            break;
        case BCMOLT_NNI_SPEED_GBPS_10:
            break;
        case BCMOLT_NNI_SPEED_GBPS_12P5:
            break;
        case BCMOLT_NNI_SPEED_GBPS_10_G_MUX:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->second_half)
    {
        case BCMOLT_NNI_SPEED_GBPS_1:
            break;
        case BCMOLT_NNI_SPEED_GBPS_2P5:
            break;
        case BCMOLT_NNI_SPEED_GBPS_10:
            break;
        case BCMOLT_NNI_SPEED_GBPS_12P5:
            break;
        case BCMOLT_NNI_SPEED_GBPS_10_G_MUX:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/* \cond UNDOCUMENTED_SYMBOLS */

/******************************************************************************/
void bcmolt_dummy_struct_for_embedded_types_set_default(bcmolt_dummy_struct_for_embedded_types *this)
{
    this->ad = (bcmolt_aggregation_domain) 0;
    this->et = (bcmolt_epon_top) 0;
    this->elg = (bcmolt_epm_lim_global) 0;
    this->dba_port = (bcmolt_dba_port) 0;
    this->sgb = BCMOLT_DRV_SGB_ID_IDX0;
    this->icf = BCMOLT_DRV_ICF_ID_IDX0;
    this->tfb_trap_behavior = BCMOLT_TFB_TRAP_BEHAVIOR_DROP;
    this->tfb_mode = BCMOLT_TFB_MODE_GPON;
    this->lim_sec_mode_up = BCMOLT_LIM_SEC_MODE_UP_TEK;
    this->lim_sec_mode_dn = BCMOLT_LIM_SEC_MODE_DN_TEK;
    this->xim_sec_mode = BCMOLT_XIM_SEC_MODE_RESERVED_0;
    this->dba_ram = BCMOLT_DBA_RAM_GRANT_FIFO_RAM_0;
    this->hsc_ram = BCMOLT_HSC_RAM_LLC_T1;
    this->lim_ram = BCMOLT_LIM_RAM_LLID_UP;
    this->lky_ram = BCMOLT_LKY_RAM_TX_KEY_RAM;
    this->mic_ram = BCMOLT_MIC_RAM_RANGE;
    this->xpcs_ram = BCMOLT_XPCSRM_RAM_CAPTURE_FIFO;
    this->xg2g_id = (bcmolt_xg2g_id) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_dummy_struct_for_embedded_types_pack(const bcmolt_dummy_struct_for_embedded_types *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, (uint8_t) this->ad))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, (uint8_t) this->et))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, (uint8_t) this->elg))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, (uint8_t) this->dba_port))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_drv_sgb_id_pack(this->sgb, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_drv_icf_id_pack(this->icf, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_tfb_trap_behavior_pack(this->tfb_trap_behavior, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_tfb_mode_pack(this->tfb_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_lim_sec_mode_up_pack(this->lim_sec_mode_up, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_lim_sec_mode_dn_pack(this->lim_sec_mode_dn, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_xim_sec_mode_pack(this->xim_sec_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_dba_ram_pack(this->dba_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_hsc_ram_pack(this->hsc_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_lim_ram_pack(this->lim_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_lky_ram_pack(this->lky_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_mic_ram_pack(this->mic_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_xpcsrm_ram_pack(this->xpcs_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, (uint8_t) this->xg2g_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_dummy_struct_for_embedded_types_unpack(bcmolt_dummy_struct_for_embedded_types *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, (uint8_t *) &this->ad))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, (uint8_t *) &this->et))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, (uint8_t *) &this->elg))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, (uint8_t *) &this->dba_port))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_drv_sgb_id_unpack(&this->sgb, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_drv_icf_id_unpack(&this->icf, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_tfb_trap_behavior_unpack(&this->tfb_trap_behavior, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_tfb_mode_unpack(&this->tfb_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_lim_sec_mode_up_unpack(&this->lim_sec_mode_up, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_lim_sec_mode_dn_unpack(&this->lim_sec_mode_dn, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_xim_sec_mode_unpack(&this->xim_sec_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_dba_ram_unpack(&this->dba_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_hsc_ram_unpack(&this->hsc_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_lim_ram_unpack(&this->lim_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_lky_ram_unpack(&this->lky_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_mic_ram_unpack(&this->mic_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_xpcsrm_ram_unpack(&this->xpcs_ram, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, (uint8_t *) &this->xg2g_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_dummy_struct_for_embedded_types_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 18);
}

/******************************************************************************/
bcmos_bool bcmolt_dummy_struct_for_embedded_types_bounds_check(const bcmolt_dummy_struct_for_embedded_types *this)
{
    if (this->ad > (bcmolt_aggregation_domain) 1)
    {
        return BCMOS_FALSE;
    }

    if (this->et > (bcmolt_epon_top) 7)
    {
        return BCMOS_FALSE;
    }

    if (this->elg > (bcmolt_epm_lim_global) 15)
    {
        return BCMOS_FALSE;
    }

    if (this->dba_port > (bcmolt_dba_port) 7)
    {
        return BCMOS_FALSE;
    }

    switch (this->sgb)
    {
        case BCMOLT_DRV_SGB_ID_IDX0:
            break;
        case BCMOLT_DRV_SGB_ID_IDX1:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->icf)
    {
        case BCMOLT_DRV_ICF_ID_IDX0:
            break;
        case BCMOLT_DRV_ICF_ID_IDX1:
            break;
        case BCMOLT_DRV_ICF_ID_IDX2:
            break;
        case BCMOLT_DRV_ICF_ID_IDX3:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->tfb_trap_behavior)
    {
        case BCMOLT_TFB_TRAP_BEHAVIOR_DROP:
            break;
        case BCMOLT_TFB_TRAP_BEHAVIOR_FORWARD_NNI:
            break;
        case BCMOLT_TFB_TRAP_BEHAVIOR_FORWARD_CPU:
            break;
        case BCMOLT_TFB_TRAP_BEHAVIOR_SNOOP:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->tfb_mode)
    {
        case BCMOLT_TFB_MODE_GPON:
            break;
        case BCMOLT_TFB_MODE_XGPON:
            break;
        case BCMOLT_TFB_MODE_EPON:
            break;
        case BCMOLT_TFB_MODE_XEPON:
            break;
        case BCMOLT_TFB_MODE_COEX:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lim_sec_mode_up)
    {
        case BCMOLT_LIM_SEC_MODE_UP_TEK:
            break;
        case BCMOLT_LIM_SEC_MODE_UP_PER_LLID:
            break;
        case BCMOLT_LIM_SEC_MODE_UP_NTT:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lim_sec_mode_dn)
    {
        case BCMOLT_LIM_SEC_MODE_DN_TEK:
            break;
        case BCMOLT_LIM_SEC_MODE_DN_PER_LLID:
            break;
        case BCMOLT_LIM_SEC_MODE_DN_NTT:
            break;
        case BCMOLT_LIM_SEC_MODE_DN_CEPON:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->xim_sec_mode)
    {
        case BCMOLT_XIM_SEC_MODE_RESERVED_0:
            break;
        case BCMOLT_XIM_SEC_MODE_PER_LLID:
            break;
        case BCMOLT_XIM_SEC_MODE_RESERVED_2:
            break;
        case BCMOLT_XIM_SEC_MODE_CEPON:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->dba_ram)
    {
        case BCMOLT_DBA_RAM_GRANT_FIFO_RAM_0:
            break;
        case BCMOLT_DBA_RAM_GRANT_FIFO_RAM_1:
            break;
        case BCMOLT_DBA_RAM_GRANT_FIFO_RAM_2:
            break;
        case BCMOLT_DBA_RAM_GRANT_FIFO_RAM_3:
            break;
        case BCMOLT_DBA_RAM_GRANT_FIFO_RAM_4:
            break;
        case BCMOLT_DBA_RAM_GRANT_FIFO_RAM_5:
            break;
        case BCMOLT_DBA_RAM_GRANT_FIFO_RAM_6:
            break;
        case BCMOLT_DBA_RAM_GRANT_FIFO_RAM_7:
            break;
        case BCMOLT_DBA_RAM_GRANTS_OUT_RAM:
            break;
        case BCMOLT_DBA_RAM_GRANTS_IN_RAM:
            break;
        case BCMOLT_DBA_RAM_GRANTS_RETIRED_RAM:
            break;
        case BCMOLT_DBA_RAM_REPORT_RAM:
            break;
        case BCMOLT_DBA_RAM_GRANT_CFG_RAM:
            break;
        case BCMOLT_DBA_RAM_DEFAULT_TOKENS_RAM:
            break;
        case BCMOLT_DBA_RAM_POLL_RECORDS_RAM:
            break;
        case BCMOLT_DBA_RAM_HEIR_POLL_RAM:
            break;
        case BCMOLT_DBA_RAM_LAST_POLL_TIME_RAM:
            break;
        case BCMOLT_DBA_RAM_POLL_ORDER_RAM:
            break;
        case BCMOLT_DBA_RAM_TDM_RAM_0:
            break;
        case BCMOLT_DBA_RAM_TDM_RAM_1:
            break;
        case BCMOLT_DBA_RAM_TDM_RAM_2:
            break;
        case BCMOLT_DBA_RAM_TDM_RAM_3:
            break;
        case BCMOLT_DBA_RAM_TDM_RAM_4:
            break;
        case BCMOLT_DBA_RAM_TDM_RAM_5:
            break;
        case BCMOLT_DBA_RAM_TDM_RAM_6:
            break;
        case BCMOLT_DBA_RAM_TDM_RAM_7:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->hsc_ram)
    {
        case BCMOLT_HSC_RAM_LLC_T1:
            break;
        case BCMOLT_HSC_RAM_LLC_T2:
            break;
        case BCMOLT_HSC_RAM_LLC_T3:
            break;
        case BCMOLT_HSC_RAM_GRP_T2:
            break;
        case BCMOLT_HSC_RAM_GRP_T3:
            break;
        case BCMOLT_HSC_RAM_SHP_T1:
            break;
        case BCMOLT_HSC_RAM_SHP_T2:
            break;
        case BCMOLT_HSC_RAM_SHP_T3:
            break;
        case BCMOLT_HSC_RAM_PRF_T1:
            break;
        case BCMOLT_HSC_RAM_PRF_T2:
            break;
        case BCMOLT_HSC_RAM_PRF_T3:
            break;
        case BCMOLT_HSC_RAM_CRE_T1:
            break;
        case BCMOLT_HSC_RAM_CRE_T2:
            break;
        case BCMOLT_HSC_RAM_CRE_T3:
            break;
        case BCMOLT_HSC_RAM_ELU:
            break;
        case BCMOLT_HSC_RAM_PTR_T1:
            break;
        case BCMOLT_HSC_RAM_PTR_T2:
            break;
        case BCMOLT_HSC_RAM_AGR_SHP_T1:
            break;
        case BCMOLT_HSC_RAM_AEM:
            break;
        case BCMOLT_HSC_RAM_ALL_LLC:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lim_ram)
    {
        case BCMOLT_LIM_RAM_LLID_UP:
            break;
        case BCMOLT_LIM_RAM_PER_ONU_STAT:
            break;
        case BCMOLT_LIM_RAM_FEC_UP_FULL_S:
            break;
        case BCMOLT_LIM_RAM_FEC_UP_DATA:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lky_ram)
    {
        case BCMOLT_LKY_RAM_TX_KEY_RAM:
            break;
        case BCMOLT_LKY_RAM_TX_KEY_BUFFER:
            break;
        case BCMOLT_LKY_RAM_RX_KEY_RAM:
            break;
        case BCMOLT_LKY_RAM_RX_KEY_BUFFER:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->mic_ram)
    {
        case BCMOLT_MIC_RAM_RANGE:
            break;
        case BCMOLT_MIC_RAM_LLID:
            break;
        case BCMOLT_MIC_RAM_IDX:
            break;
        case BCMOLT_MIC_RAM_GRANT_MISS:
            break;
        case BCMOLT_MIC_RAM_GRANT_ID:
            break;
        case BCMOLT_MIC_RAM_TX_IV:
            break;
        case BCMOLT_MIC_RAM_RX_IV:
            break;
        case BCMOLT_MIC_RAM_TX_PORT_STAT:
            break;
        case BCMOLT_MIC_RAM_RX_PORT_STAT:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->xpcs_ram)
    {
        case BCMOLT_XPCSRM_RAM_CAPTURE_FIFO:
            break;
        case BCMOLT_XPCSRM_RAM_FEC_DECODE:
            break;
        case BCMOLT_XPCSRM_RAM_FEC_STATS:
            break;
        case BCMOLT_XPCSRM_RAM_FEC_ENQUEUE:
            break;
        case BCMOLT_XPCSRM_RAM_IDLE_INSERT:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->xg2g_id > (bcmolt_xg2g_id) 7)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/* \endcond */

/******************************************************************************/
void bcmolt_embedded_image_entry_set_default(bcmolt_embedded_image_entry *this)
{
    this->image_type = BCMOLT_DEVICE_IMAGE_TYPE_BOOTLOADER;
    this->image_size = 0;
    this->crc32 = 0;
    this->status = BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS_NONE;
    memset(this->image_name, 0, 64);
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_entry_pack(const bcmolt_embedded_image_entry *this, bcmolt_buf *buf)
{
    if (!bcmolt_device_image_type_pack(this->image_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->image_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->crc32))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_embedded_image_transfer_status_pack(this->status, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->image_name, 64))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_entry_unpack(bcmolt_embedded_image_entry *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_device_image_type_unpack(&this->image_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->image_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->crc32))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_embedded_image_transfer_status_unpack(&this->status, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read(buf, this->image_name, 64))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_entry_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 74);
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_entry_bounds_check(const bcmolt_embedded_image_entry *this)
{
    switch (this->image_type)
    {
        case BCMOLT_DEVICE_IMAGE_TYPE_BOOTLOADER:
            break;
        case BCMOLT_DEVICE_IMAGE_TYPE_APPLICATION:
            break;
        case BCMOLT_DEVICE_IMAGE_TYPE_ITU_PON_ONU_FIRMWARE:
            break;
        case BCMOLT_DEVICE_IMAGE_TYPE_EPON_ONU_FIRMWARE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->status)
    {
        case BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS_NONE:
            break;
        case BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS_IN_PROGRESS:
            break;
        case BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS_SUCCESS:
            break;
        case BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS_FAILURE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_embedded_image_entry_list_u8_set_default(bcmolt_embedded_image_entry_list_u8 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_entry_list_u8_pack(const bcmolt_embedded_image_entry_list_u8 *this, bcmolt_buf *buf)
{
    uint8_t i0;
    if (!bcmolt_buf_write_u8(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_embedded_image_entry_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_embedded_image_entry_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_embedded_image_entry_list_u8_get_packed_length(const bcmolt_embedded_image_entry_list_u8 *this)
{
    return 1 + (74 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_entry_list_u8_unpack(bcmolt_embedded_image_entry_list_u8 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint8_t i0;
    if (!bcmolt_buf_read_u8(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_embedded_image_entry_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_embedded_image_entry *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_embedded_image_entry));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_embedded_image_entry_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_entry_list_u8_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint8_t len;
    if (!bcmolt_buf_read_u8(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_embedded_image_entry) * len);
    if (!bcmolt_buf_skip(packed, len * 74))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_embedded_image_entry_list_u8_bounds_check(const bcmolt_embedded_image_entry_list_u8 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_encryption_information_container_set_default(bcmolt_encryption_information_container *this)
{
    this->format = (bcmolt_epon_encryption_information_format) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_encryption_information_container_pack(const bcmolt_encryption_information_container *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_encryption_information_format_pack(this->format, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->format)
    {
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CFB:
            {
                if (!bcmolt_buf_write(buf, this->u.cfb.key, 16))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CTR:
            {
                if (!bcmolt_buf_write(buf, this->u.ctr.key, 16))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_write(buf, this->u.ctr.sci, 8))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_encryption_information_container_get_packed_length(const bcmolt_encryption_information_container *this)
{
    uint32_t count = 1;
    switch (this->format)
    {
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CFB:
            {
                count += 16;
            }
            break;
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CTR:
            {
                count += 24;
            }
            break;
        default:
            break;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_encryption_information_container_unpack(bcmolt_encryption_information_container *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_encryption_information_format_unpack(&this->format, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->format)
    {
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CFB:
            {
                if (!bcmolt_buf_read(buf, this->u.cfb.key, 16))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CTR:
            {
                if (!bcmolt_buf_read(buf, this->u.ctr.key, 16))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_read(buf, this->u.ctr.sci, 8))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_encryption_information_container_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    bcmolt_epon_encryption_information_format format;
    if (!bcmolt_epon_encryption_information_format_unpack(&format, packed))
    {
        return BCMOS_FALSE;
    }

    switch (format)
    {
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CFB:
            {
                if (!bcmolt_buf_skip(packed, 16))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CTR:
            {
                if (!bcmolt_buf_skip(packed, 16))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 8))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_encryption_information_container_bounds_check(const bcmolt_encryption_information_container *this)
{
    switch (this->format)
    {
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CFB:
            {
            }
            break;
        case BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CTR:
            {
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_clock_transport_configuration_set_default(bcmolt_epon_clock_transport_configuration *this)
{
    this->epon_clock_transport_mode = BCMOLT_EPON_CLOCK_TRANSPORT_MODE_HOST_DRIVEN;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_clock_transport_configuration_pack(const bcmolt_epon_clock_transport_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_clock_transport_mode_pack(this->epon_clock_transport_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_clock_transport_configuration_unpack(bcmolt_epon_clock_transport_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_clock_transport_mode_unpack(&this->epon_clock_transport_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_clock_transport_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 1);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_clock_transport_configuration_bounds_check(const bcmolt_epon_clock_transport_configuration *this)
{
    switch (this->epon_clock_transport_mode)
    {
        case BCMOLT_EPON_CLOCK_TRANSPORT_MODE_HOST_DRIVEN:
            break;
        case BCMOLT_EPON_CLOCK_TRANSPORT_MODE_EMBEDDED_DRIVEN:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_unknown_link_status_set_default(bcmolt_unknown_link_status *this)
{
    this->link_rate = BCMOLT_EPON_LINK_RATE_TEN_TEN;
    this->alarm_status = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_unknown_link_status_pack(const bcmolt_unknown_link_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_link_rate_pack(this->link_rate, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->alarm_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_unknown_link_status_unpack(bcmolt_unknown_link_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_link_rate_unpack(&this->link_rate, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->alarm_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_unknown_link_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_unknown_link_status_bounds_check(const bcmolt_unknown_link_status *this)
{
    switch (this->link_rate)
    {
        case BCMOLT_EPON_LINK_RATE_TEN_TEN:
            break;
        case BCMOLT_EPON_LINK_RATE_TEN_ONE:
            break;
        case BCMOLT_EPON_LINK_RATE_ONE_ONE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->alarm_status)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_laser_on_off_status_set_default(bcmolt_laser_on_off_status *this)
{
    this->laser_on_time = (bcmolt_time_quanta) 0;
    this->laser_off_time = (bcmolt_time_quanta) 0;
    this->alarm_status = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_laser_on_off_status_pack(const bcmolt_laser_on_off_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->laser_on_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->laser_off_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->alarm_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_laser_on_off_status_unpack(bcmolt_laser_on_off_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->laser_on_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->laser_off_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->alarm_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_laser_on_off_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 9);
}

/******************************************************************************/
bcmos_bool bcmolt_laser_on_off_status_bounds_check(const bcmolt_laser_on_off_status *this)
{
    switch (this->alarm_status)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_range_status_set_default(bcmolt_range_status *this)
{
    this->range = (bcmolt_time_quanta) 0;
    this->alarm_status = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_range_status_pack(const bcmolt_range_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->range))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->alarm_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_range_status_unpack(bcmolt_range_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->range))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->alarm_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_range_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_range_status_bounds_check(const bcmolt_range_status *this)
{
    switch (this->alarm_status)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_rogue_status_set_default(bcmolt_rogue_status *this)
{
    this->denied_llid = (bcmolt_epon_llid) 0;
    this->denied_range = (bcmolt_time_quanta) 0;
    this->alarm_status = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_status_pack(const bcmolt_rogue_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->denied_llid))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->denied_range))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->alarm_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_status_unpack(bcmolt_rogue_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->denied_llid))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->denied_range))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->alarm_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 7);
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_status_bounds_check(const bcmolt_rogue_status *this)
{
    switch (this->alarm_status)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_denied_link_alarm_state_set_default(bcmolt_epon_denied_link_alarm_state *this)
{
    this->unknown_link_violation.link_rate = BCMOLT_EPON_LINK_RATE_TEN_TEN;
    this->unknown_link_violation.alarm_status = BCMOLT_STATUS_OFF;
    this->overhead_profile_violation = BCMOLT_STATUS_OFF;
    this->max_link_violation = BCMOLT_STATUS_OFF;
    this->llid_pool_empty_violation = BCMOLT_STATUS_OFF;
    this->laser_on_off_violation.laser_on_time = (bcmolt_time_quanta) 0;
    this->laser_on_off_violation.laser_off_time = (bcmolt_time_quanta) 0;
    this->laser_on_off_violation.alarm_status = BCMOLT_STATUS_OFF;
    this->system_resource_violation = BCMOLT_STATUS_OFF;
    this->range_violation.range = (bcmolt_time_quanta) 0;
    this->range_violation.alarm_status = BCMOLT_STATUS_OFF;
    this->tdm_channels_exhausted = BCMOLT_STATUS_OFF;
    this->rogue_violation.denied_llid = (bcmolt_epon_llid) 0;
    this->rogue_violation.denied_range = (bcmolt_time_quanta) 0;
    this->rogue_violation.alarm_status = BCMOLT_STATUS_OFF;
    this->upstream_bandwidth_violation = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_alarm_state_pack(const bcmolt_epon_denied_link_alarm_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_unknown_link_status_pack(&this->unknown_link_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->overhead_profile_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->max_link_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->llid_pool_empty_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_laser_on_off_status_pack(&this->laser_on_off_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->system_resource_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_range_status_pack(&this->range_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->tdm_channels_exhausted, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_rogue_status_pack(&this->rogue_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->upstream_bandwidth_violation, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_alarm_state_unpack(bcmolt_epon_denied_link_alarm_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_unknown_link_status_unpack(&this->unknown_link_violation, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->overhead_profile_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->max_link_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->llid_pool_empty_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_laser_on_off_status_unpack(&this->laser_on_off_violation, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->system_resource_violation, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_range_status_unpack(&this->range_violation, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->tdm_channels_exhausted, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_rogue_status_unpack(&this->rogue_violation, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->upstream_bandwidth_violation, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_alarm_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 30);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_denied_link_alarm_state_bounds_check(const bcmolt_epon_denied_link_alarm_state *this)
{
    if (!bcmolt_unknown_link_status_bounds_check(&this->unknown_link_violation))
    {
        return BCMOS_FALSE;
    }

    switch (this->overhead_profile_violation)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->max_link_violation)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->llid_pool_empty_violation)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (!bcmolt_laser_on_off_status_bounds_check(&this->laser_on_off_violation))
    {
        return BCMOS_FALSE;
    }

    switch (this->system_resource_violation)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (!bcmolt_range_status_bounds_check(&this->range_violation))
    {
        return BCMOS_FALSE;
    }

    switch (this->tdm_channels_exhausted)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (!bcmolt_rogue_status_bounds_check(&this->rogue_violation))
    {
        return BCMOS_FALSE;
    }

    switch (this->upstream_bandwidth_violation)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_encryption_config_set_default(bcmolt_epon_encryption_config *this)
{
    this->downstream_mode = BCMOLT_EPON_ENCRYPTION_MODE_NO_ENCRYPTION;
    this->downstream_key_choice = BCMOLT_EPON_KEY_CHOICE_KEY_0;
    this->downstream_encryption_information.format = BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CFB;
    memset(this->downstream_encryption_information.u.cfb.key, 0, sizeof(this->downstream_encryption_information.u.cfb.key));
    this->upstream_mode = BCMOLT_EPON_ENCRYPTION_MODE_NO_ENCRYPTION;
    this->upstream_key_choice = BCMOLT_EPON_KEY_CHOICE_KEY_0;
    this->upstream_encryption_information.format = BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CFB;
    memset(this->upstream_encryption_information.u.cfb.key, 0, sizeof(this->upstream_encryption_information.u.cfb.key));
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_config_pack(const bcmolt_epon_encryption_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_encryption_mode_pack(this->downstream_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_key_choice_pack(this->downstream_key_choice, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_encryption_information_container_pack(&this->downstream_encryption_information, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_encryption_mode_pack(this->upstream_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_key_choice_pack(this->upstream_key_choice, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_encryption_information_container_pack(&this->upstream_encryption_information, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_epon_encryption_config_get_packed_length(const bcmolt_epon_encryption_config *this)
{
    return 6 + bcmolt_encryption_information_container_get_packed_length(&this->downstream_encryption_information) + bcmolt_encryption_information_container_get_packed_length(&this->upstream_encryption_information);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_config_unpack(bcmolt_epon_encryption_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_encryption_mode_unpack(&this->downstream_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_key_choice_unpack(&this->downstream_key_choice, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_encryption_information_container_unpack(&this->downstream_encryption_information, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_encryption_mode_unpack(&this->upstream_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_key_choice_unpack(&this->upstream_key_choice, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_encryption_information_container_unpack(&this->upstream_encryption_information, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    if (!bcmolt_buf_skip(packed, 2))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_skip(packed, 1))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_encryption_information_container_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_skip(packed, 2))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_skip(packed, 1))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_encryption_information_container_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_encryption_config_bounds_check(const bcmolt_epon_encryption_config *this)
{
    switch (this->downstream_mode)
    {
        case BCMOLT_EPON_ENCRYPTION_MODE_NO_ENCRYPTION:
            break;
        case BCMOLT_EPON_ENCRYPTION_MODE_EPON_TRIPLE_CHURNING:
            break;
        case BCMOLT_EPON_ENCRYPTION_MODE_EPON_ZERO_OVERHEAD_AES:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->downstream_key_choice)
    {
        case BCMOLT_EPON_KEY_CHOICE_KEY_0:
            break;
        case BCMOLT_EPON_KEY_CHOICE_KEY_1:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (!bcmolt_encryption_information_container_bounds_check(&this->downstream_encryption_information))
    {
        return BCMOS_FALSE;
    }

    switch (this->upstream_mode)
    {
        case BCMOLT_EPON_ENCRYPTION_MODE_NO_ENCRYPTION:
            break;
        case BCMOLT_EPON_ENCRYPTION_MODE_EPON_TRIPLE_CHURNING:
            break;
        case BCMOLT_EPON_ENCRYPTION_MODE_EPON_ZERO_OVERHEAD_AES:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->upstream_key_choice)
    {
        case BCMOLT_EPON_KEY_CHOICE_KEY_0:
            break;
        case BCMOLT_EPON_KEY_CHOICE_KEY_1:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (!bcmolt_encryption_information_container_bounds_check(&this->upstream_encryption_information))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_key_exchange_config_set_default(bcmolt_epon_key_exchange_config *this)
{
    this->oam_type = BCMOLT_EPON_OAM_TYPE_BROADCOM;
    this->period = 0;
    this->direction = BCMOLT_EPON_ENCRYPTION_DIRECTION_DOWNSTREAM_ONLY;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_key_exchange_config_pack(const bcmolt_epon_key_exchange_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_oam_type_pack(this->oam_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->period))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_encryption_direction_pack(this->direction, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_key_exchange_config_unpack(bcmolt_epon_key_exchange_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_oam_type_unpack(&this->oam_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->period))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_encryption_direction_unpack(&this->direction, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_key_exchange_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_key_exchange_config_bounds_check(const bcmolt_epon_key_exchange_config *this)
{
    switch (this->oam_type)
    {
        case BCMOLT_EPON_OAM_TYPE_BROADCOM:
            break;
        case BCMOLT_EPON_OAM_TYPE_CTC:
            break;
        case BCMOLT_EPON_OAM_TYPE_DPOE:
            break;
        case BCMOLT_EPON_OAM_TYPE_SIEPONA:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->direction)
    {
        case BCMOLT_EPON_ENCRYPTION_DIRECTION_DOWNSTREAM_ONLY:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_laser_overhead_parameters_set_default(bcmolt_epon_laser_overhead_parameters *this)
{
    this->laser_on_time = (bcmolt_time_quanta) 32;
    this->laser_off_time = (bcmolt_time_quanta) 32;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_laser_overhead_parameters_pack(const bcmolt_epon_laser_overhead_parameters *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->laser_on_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->laser_off_time))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_laser_overhead_parameters_unpack(bcmolt_epon_laser_overhead_parameters *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->laser_on_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->laser_off_time))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_laser_overhead_parameters_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_laser_overhead_parameters_bounds_check(const bcmolt_epon_laser_overhead_parameters *this)
{
    if (this->laser_on_time > (bcmolt_time_quanta) 62)
    {
        return BCMOS_FALSE;
    }

    if (this->laser_off_time > (bcmolt_time_quanta) 62)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_link_alarm_state_set_default(bcmolt_epon_link_alarm_state *this)
{
    this->key_exchange_failure = BCMOLT_STATUS_OFF;
    this->invalid_mpcp_report_received = BCMOLT_STATUS_OFF;
    this->mpcp_report_timeout = BCMOLT_STATUS_OFF;
    this->oam_keepalive_timeout = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_alarm_state_pack(const bcmolt_epon_link_alarm_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_status_pack(this->key_exchange_failure, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->invalid_mpcp_report_received, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->mpcp_report_timeout, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->oam_keepalive_timeout, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_alarm_state_unpack(bcmolt_epon_link_alarm_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_status_unpack(&this->key_exchange_failure, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->invalid_mpcp_report_received, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->mpcp_report_timeout, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->oam_keepalive_timeout, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_alarm_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_alarm_state_bounds_check(const bcmolt_epon_link_alarm_state *this)
{
    switch (this->key_exchange_failure)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->invalid_mpcp_report_received)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->mpcp_report_timeout)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->oam_keepalive_timeout)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_link_fec_en_set_default(bcmolt_epon_link_fec_en *this)
{
    this->upstream = BCMOLT_EPON_LINK_FEC_STATE_USE_DEFAULT;
    this->downstream = BCMOLT_EPON_LINK_FEC_STATE_USE_DEFAULT;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_fec_en_pack(const bcmolt_epon_link_fec_en *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_link_fec_state_pack(this->upstream, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_link_fec_state_pack(this->downstream, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_fec_en_unpack(bcmolt_epon_link_fec_en *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_link_fec_state_unpack(&this->upstream, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_link_fec_state_unpack(&this->downstream, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_fec_en_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_fec_en_bounds_check(const bcmolt_epon_link_fec_en *this)
{
    switch (this->upstream)
    {
        case BCMOLT_EPON_LINK_FEC_STATE_DISABLED:
            break;
        case BCMOLT_EPON_LINK_FEC_STATE_ENABLED:
            break;
        case BCMOLT_EPON_LINK_FEC_STATE_USE_DEFAULT:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->downstream)
    {
        case BCMOLT_EPON_LINK_FEC_STATE_DISABLED:
            break;
        case BCMOLT_EPON_LINK_FEC_STATE_ENABLED:
            break;
        case BCMOLT_EPON_LINK_FEC_STATE_USE_DEFAULT:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_link_info_set_default(bcmolt_epon_link_info *this)
{
    this->link_status = (bcmolt_epon_link_status) 0;
    this->rate = BCMOLT_EPON_LINK_RATE_TEN_TEN;
    this->llid = (bcmolt_epon_llid) 0;
    this->mpcp_discovery_info = (bcmolt_mpcp_discovery_info) 0;
    this->onu_laser_on_time_tq = (bcmolt_time_quanta) 0;
    this->onu_laser_off_time_tq = (bcmolt_time_quanta) 0;
    this->pending_grants = 0;
    this->range_value_tq = (bcmolt_time_quanta) 0;
    this->tunnel_id = (bcmolt_epon_tunnel_id) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_info_pack(const bcmolt_epon_link_info *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_link_status_pack(this->link_status, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_link_rate_pack(this->rate, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->llid))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_mpcp_discovery_info_pack(this->mpcp_discovery_info, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->onu_laser_on_time_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->onu_laser_off_time_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->pending_grants))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->range_value_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->tunnel_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_info_unpack(bcmolt_epon_link_info *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_link_status_unpack(&this->link_status, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_link_rate_unpack(&this->rate, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->llid))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_mpcp_discovery_info_unpack(&this->mpcp_discovery_info, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->onu_laser_on_time_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->onu_laser_off_time_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->pending_grants))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->range_value_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->tunnel_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_info_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 24);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_link_info_bounds_check(const bcmolt_epon_link_info *this)
{
    if ((this->link_status & 0x00F6) != 0)
    {
        return BCMOS_FALSE;
    }

    switch (this->rate)
    {
        case BCMOLT_EPON_LINK_RATE_TEN_TEN:
            break;
        case BCMOLT_EPON_LINK_RATE_TEN_ONE:
            break;
        case BCMOLT_EPON_LINK_RATE_ONE_ONE:
            break;
        default:
            return BCMOS_FALSE;
    }

    if ((this->mpcp_discovery_info & 0xFFCCU) != 0)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gate_parameters_set_default(bcmolt_gate_parameters *this)
{
    this->flags = (bcmolt_mpcp_registration_gate_flags) 0;
    this->delay_before_ms = 50;
    this->gate_size_tq = (bcmolt_time_quanta) 42;
}

/******************************************************************************/
bcmos_bool bcmolt_gate_parameters_pack(const bcmolt_gate_parameters *this, bcmolt_buf *buf)
{
    if (!bcmolt_mpcp_registration_gate_flags_pack(this->flags, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->delay_before_ms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->gate_size_tq))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gate_parameters_unpack(bcmolt_gate_parameters *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_mpcp_registration_gate_flags_unpack(&this->flags, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->delay_before_ms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->gate_size_tq))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gate_parameters_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 12);
}

/******************************************************************************/
bcmos_bool bcmolt_gate_parameters_bounds_check(const bcmolt_gate_parameters *this)
{
    if ((this->flags & 0xFFFFFFFEUL) != 0)
    {
        return BCMOS_FALSE;
    }

    if (this->delay_before_ms > 3600000UL)
    {
        return BCMOS_FALSE;
    }

    if (this->gate_size_tq > (bcmolt_time_quanta) 65535UL)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gate_parameters_list_u32_set_default(bcmolt_gate_parameters_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gate_parameters_list_u32_pack(const bcmolt_gate_parameters_list_u32 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gate_parameters_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gate_parameters_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gate_parameters_list_u32_get_packed_length(const bcmolt_gate_parameters_list_u32 *this)
{
    return 4 + (12 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gate_parameters_list_u32_unpack(bcmolt_gate_parameters_list_u32 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gate_parameters_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gate_parameters *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gate_parameters));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gate_parameters_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gate_parameters_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gate_parameters) * len);
    if (!bcmolt_buf_skip(packed, len * 12))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gate_parameters_list_u32_bounds_check(const bcmolt_gate_parameters_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_registration_gate_mode_set_default(bcmolt_epon_registration_gate_mode *this)
{
    this->registration_gate_mode = (bcmolt_mpcp_gate_mode) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_registration_gate_mode_pack(const bcmolt_epon_registration_gate_mode *this, bcmolt_buf *buf)
{
    if (!bcmolt_mpcp_gate_mode_pack(this->registration_gate_mode, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->registration_gate_mode)
    {
        case BCMOLT_MPCP_GATE_MODE_TEKNOVUS:
            {
                if (!bcmolt_buf_write_u16(buf, this->u.teknovus.reg_ack_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_MPCP_GATE_MODE_CUSTOM:
            {
                if (!bcmolt_gate_parameters_list_u32_pack(&this->u.custom.gates, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_epon_registration_gate_mode_get_packed_length(const bcmolt_epon_registration_gate_mode *this)
{
    uint32_t count = 1;
    switch (this->registration_gate_mode)
    {
        case BCMOLT_MPCP_GATE_MODE_TEKNOVUS:
            {
                count += 2;
            }
            break;
        case BCMOLT_MPCP_GATE_MODE_CUSTOM:
            {
                count += bcmolt_gate_parameters_list_u32_get_packed_length(&this->u.custom.gates);
            }
            break;
        default:
            break;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_registration_gate_mode_unpack(bcmolt_epon_registration_gate_mode *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_mpcp_gate_mode_unpack(&this->registration_gate_mode, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->registration_gate_mode)
    {
        case BCMOLT_MPCP_GATE_MODE_TEKNOVUS:
            {
                if (!bcmolt_buf_read_u16(buf, &this->u.teknovus.reg_ack_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_MPCP_GATE_MODE_CUSTOM:
            {
                if (!bcmolt_gate_parameters_list_u32_unpack(&this->u.custom.gates, buf, extra_mem))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_registration_gate_mode_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    bcmolt_mpcp_gate_mode registration_gate_mode;
    if (!bcmolt_mpcp_gate_mode_unpack(&registration_gate_mode, packed))
    {
        return BCMOS_FALSE;
    }

    switch (registration_gate_mode)
    {
        case BCMOLT_MPCP_GATE_MODE_TEKNOVUS:
            {
                if (!bcmolt_buf_skip(packed, 2))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_MPCP_GATE_MODE_CUSTOM:
            {
                if (!bcmolt_gate_parameters_list_u32_scan(packed, extra_mem))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_registration_gate_mode_bounds_check(const bcmolt_epon_registration_gate_mode *this)
{
    switch (this->registration_gate_mode)
    {
        case BCMOLT_MPCP_GATE_MODE_TEKNOVUS:
            {
                if (this->u.teknovus.reg_ack_timeout_ms < 50)
                {
                    return BCMOS_FALSE;
                }

                if (this->u.teknovus.reg_ack_timeout_ms > 200)
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_MPCP_GATE_MODE_CUSTOM:
            {
                if (!bcmolt_gate_parameters_list_u32_bounds_check(&this->u.custom.gates))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_logical_link_options_set_default(bcmolt_epon_logical_link_options *this)
{
    this->registration_gate_mode.registration_gate_mode = BCMOLT_MPCP_GATE_MODE_TEKNOVUS;
    this->registration_gate_mode.u.teknovus.reg_ack_timeout_ms = 100;
    this->reporting_mode = BCMOLT_EPON_DBA_REPORTING_MODE_SIEPON_A;
    this->max_links = 512;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_logical_link_options_pack(const bcmolt_epon_logical_link_options *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_registration_gate_mode_pack(&this->registration_gate_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_dba_reporting_mode_pack(this->reporting_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->max_links))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_epon_logical_link_options_get_packed_length(const bcmolt_epon_logical_link_options *this)
{
    return 3 + bcmolt_epon_registration_gate_mode_get_packed_length(&this->registration_gate_mode);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_logical_link_options_unpack(bcmolt_epon_logical_link_options *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_registration_gate_mode_unpack(&this->registration_gate_mode, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_dba_reporting_mode_unpack(&this->reporting_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->max_links))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_logical_link_options_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    if (!bcmolt_epon_registration_gate_mode_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_skip(packed, 1))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_skip(packed, 2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_logical_link_options_bounds_check(const bcmolt_epon_logical_link_options *this)
{
    if (!bcmolt_epon_registration_gate_mode_bounds_check(&this->registration_gate_mode))
    {
        return BCMOS_FALSE;
    }

    switch (this->reporting_mode)
    {
        case BCMOLT_EPON_DBA_REPORTING_MODE_SIEPON_A:
            break;
        case BCMOLT_EPON_DBA_REPORTING_MODE_SIEPON_B:
            break;
        case BCMOLT_EPON_DBA_REPORTING_MODE_SIEPON_C:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->max_links > 2044)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_ni_alarm_state_set_default(bcmolt_epon_ni_alarm_state *this)
{
    this->no_reports = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_alarm_state_pack(const bcmolt_epon_ni_alarm_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_status_pack(this->no_reports, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_alarm_state_unpack(bcmolt_epon_ni_alarm_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_status_unpack(&this->no_reports, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_alarm_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 1);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_alarm_state_bounds_check(const bcmolt_epon_ni_alarm_state *this)
{
    switch (this->no_reports)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_ni_encryption_cfg_set_default(bcmolt_epon_ni_encryption_cfg *this)
{
    this->downstream_encryption_mode = BCMOLT_EPON_ENCRYPTION_MODE_NO_ENCRYPTION;
    this->upstream_encryption_mode = BCMOLT_EPON_ENCRYPTION_MODE_NO_ENCRYPTION;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_encryption_cfg_pack(const bcmolt_epon_ni_encryption_cfg *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_encryption_mode_pack(this->downstream_encryption_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_encryption_mode_pack(this->upstream_encryption_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_encryption_cfg_unpack(bcmolt_epon_ni_encryption_cfg *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_encryption_mode_unpack(&this->downstream_encryption_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_encryption_mode_unpack(&this->upstream_encryption_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_encryption_cfg_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_ni_encryption_cfg_bounds_check(const bcmolt_epon_ni_encryption_cfg *this)
{
    switch (this->downstream_encryption_mode)
    {
        case BCMOLT_EPON_ENCRYPTION_MODE_NO_ENCRYPTION:
            break;
        case BCMOLT_EPON_ENCRYPTION_MODE_EPON_TRIPLE_CHURNING:
            break;
        case BCMOLT_EPON_ENCRYPTION_MODE_EPON_ZERO_OVERHEAD_AES:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->upstream_encryption_mode)
    {
        case BCMOLT_EPON_ENCRYPTION_MODE_NO_ENCRYPTION:
            break;
        case BCMOLT_EPON_ENCRYPTION_MODE_EPON_TRIPLE_CHURNING:
            break;
        case BCMOLT_EPON_ENCRYPTION_MODE_EPON_ZERO_OVERHEAD_AES:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_onu_upgrade_params_set_default(bcmolt_epon_onu_upgrade_params *this)
{
    this->oam_extension_type = (bcmolt_epon_oam_extension_type) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_params_pack(const bcmolt_epon_onu_upgrade_params *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_oam_extension_type_pack(this->oam_extension_type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->oam_extension_type)
    {
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_RESERVED:
            {
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_BROADCOM:
            {
                if (!bcmolt_buf_write_u32(buf, this->u.broadcom.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_CTC:
            {
                if (!bcmolt_buf_write_u32(buf, this->u.ctc.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DASAN:
            {
                if (!bcmolt_buf_write_u32(buf, this->u.dasan.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_KT:
            {
                if (!bcmolt_buf_write_u32(buf, this->u.kt.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DPOE:
            {
                if (!bcmolt_buf_write_u32(buf, this->u.dpoe.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_write_u16(buf, this->u.dpoe.block_size))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_write_u32(buf, this->u.dpoe.final_ack_response_timeout))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_epon_onu_upgrade_params_get_packed_length(const bcmolt_epon_onu_upgrade_params *this)
{
    uint32_t count = 1;
    switch (this->oam_extension_type)
    {
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_RESERVED:
            {
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_BROADCOM:
            {
                count += 4;
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_CTC:
            {
                count += 4;
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DASAN:
            {
                count += 4;
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_KT:
            {
                count += 4;
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DPOE:
            {
                count += 10;
            }
            break;
        default:
            break;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_params_unpack(bcmolt_epon_onu_upgrade_params *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_oam_extension_type_unpack(&this->oam_extension_type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->oam_extension_type)
    {
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_RESERVED:
            {
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_BROADCOM:
            {
                if (!bcmolt_buf_read_u32(buf, &this->u.broadcom.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_CTC:
            {
                if (!bcmolt_buf_read_u32(buf, &this->u.ctc.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DASAN:
            {
                if (!bcmolt_buf_read_u32(buf, &this->u.dasan.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_KT:
            {
                if (!bcmolt_buf_read_u32(buf, &this->u.kt.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DPOE:
            {
                if (!bcmolt_buf_read_u32(buf, &this->u.dpoe.response_timeout_ms))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_read_u16(buf, &this->u.dpoe.block_size))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_read_u32(buf, &this->u.dpoe.final_ack_response_timeout))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_params_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    bcmolt_epon_oam_extension_type oam_extension_type;
    if (!bcmolt_epon_oam_extension_type_unpack(&oam_extension_type, packed))
    {
        return BCMOS_FALSE;
    }

    switch (oam_extension_type)
    {
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_RESERVED:
            {
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_BROADCOM:
            {
                if (!bcmolt_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_CTC:
            {
                if (!bcmolt_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DASAN:
            {
                if (!bcmolt_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_KT:
            {
                if (!bcmolt_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DPOE:
            {
                if (!bcmolt_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 2))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_params_bounds_check(const bcmolt_epon_onu_upgrade_params *this)
{
    switch (this->oam_extension_type)
    {
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_RESERVED:
            {
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_BROADCOM:
            {
                if (this->u.broadcom.response_timeout_ms < 50)
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_CTC:
            {
                if (this->u.ctc.response_timeout_ms < 100)
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DASAN:
            {
                if (this->u.dasan.response_timeout_ms < 50)
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_KT:
            {
                if (this->u.kt.response_timeout_ms < 50)
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_EPON_OAM_EXTENSION_TYPE_DPOE:
            {
                if (this->u.dpoe.response_timeout_ms < 1000)
                {
                    return BCMOS_FALSE;
                }

                if (this->u.dpoe.block_size < 1)
                {
                    return BCMOS_FALSE;
                }

                if (this->u.dpoe.final_ack_response_timeout < 15)
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_onu_upgrade_status_set_default(bcmolt_epon_onu_upgrade_status *this)
{
    bcmos_mac_address_init(&this->onu_id);
    this->error_code = BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_SUCCESS;
    this->onu_return_code = BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_OK;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_status_pack(const bcmolt_epon_onu_upgrade_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_mac_address(buf, this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_onu_upgrade_return_code_pack(this->error_code, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_onu_upgrade_onu_response_code_pack(this->onu_return_code, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_status_unpack(bcmolt_epon_onu_upgrade_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_mac_address(buf, &this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_onu_upgrade_return_code_unpack(&this->error_code, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_onu_upgrade_onu_response_code_unpack(&this->onu_return_code, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_status_bounds_check(const bcmolt_epon_onu_upgrade_status *this)
{
    switch (this->error_code)
    {
        case BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_SUCCESS:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_ONU_RESPONSE_TIMEOUT:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_ONU_ERROR_RESPONSE:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_SYNC_ERROR:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_COMMIT_FAILED:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_INTERNAL:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_PARSE_ERROR:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->onu_return_code)
    {
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_OK:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_UNDEFINED:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_NOT_FOUND:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_NO_ACCESS:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_FULL:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ILLEGAL_OPERATION:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_UNKNOWN_ID:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_BAD_BLOCK:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_TIMEOUT:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_BUSY:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_INCOMPATIBLE_FILE:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_CORRUPTED_FILE:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ERROR_NOT_DEFINED:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ERROR_ALLOC_EXCEEDED:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ERROR_ILLEGAL_OP:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ERROR_FILE_EXISTS:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_END_WRITING_NVS:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_END_CRC_ERROR:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_END_PARAM_ERROR:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_END_CMD_UNSUPPORTED:
            break;
        case BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_LAST:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_onu_upgrade_status_list_u32_set_default(bcmolt_epon_onu_upgrade_status_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_status_list_u32_pack(const bcmolt_epon_onu_upgrade_status_list_u32 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_epon_onu_upgrade_status_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_epon_onu_upgrade_status_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_epon_onu_upgrade_status_list_u32_get_packed_length(const bcmolt_epon_onu_upgrade_status_list_u32 *this)
{
    return 4 + (8 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_status_list_u32_unpack(bcmolt_epon_onu_upgrade_status_list_u32 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_epon_onu_upgrade_status_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_epon_onu_upgrade_status *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_epon_onu_upgrade_status));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_epon_onu_upgrade_status_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_status_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_epon_onu_upgrade_status) * len);
    if (!bcmolt_buf_skip(packed, len * 8))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_onu_upgrade_status_list_u32_bounds_check(const bcmolt_epon_onu_upgrade_status_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_epon_protection_switching_configuration_set_default(bcmolt_epon_protection_switching_configuration *this)
{
    this->protection_type = BCMOLT_EPON_PROTECTION_SWITCHING_TYPE_NO_PROTECTION_SWTICHING;
    this->protection_switching_options = (bcmolt_protection_switching_detection_options) 0;
    this->rerange_options = BCMOLT_EPON_PROTECTION_SWITCHING_RERANGING_OPTIONS_RERANGE_NONE;
    this->rerange_attempts = 0;
    this->rerange_interval = 0;
    this->sync_gate_duration = 0;
    this->gpio_input = BCMOLT_GPIO_PIN_UNCONFIGURED;
    this->gpio_input_polarity = BCMOLT_GPIO_POLARITY_ACTIVE_HIGH;
    this->gpio_output = BCMOLT_GPIO_PIN_UNCONFIGURED;
    this->gpio_output_polarity = BCMOLT_GPIO_POLARITY_ACTIVE_HIGH;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_switching_configuration_pack(const bcmolt_epon_protection_switching_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_epon_protection_switching_type_pack(this->protection_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_protection_switching_detection_options_pack(this->protection_switching_options, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_protection_switching_reranging_options_pack(this->rerange_options, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->rerange_attempts))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->rerange_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->sync_gate_duration))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_pin_pack(this->gpio_input, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_polarity_pack(this->gpio_input_polarity, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_pin_pack(this->gpio_output, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_polarity_pack(this->gpio_output_polarity, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_switching_configuration_unpack(bcmolt_epon_protection_switching_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_epon_protection_switching_type_unpack(&this->protection_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_protection_switching_detection_options_unpack(&this->protection_switching_options, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_epon_protection_switching_reranging_options_unpack(&this->rerange_options, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->rerange_attempts))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->rerange_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->sync_gate_duration))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_pin_unpack(&this->gpio_input, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_polarity_unpack(&this->gpio_input_polarity, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_pin_unpack(&this->gpio_output, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_polarity_unpack(&this->gpio_output_polarity, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_switching_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 12);
}

/******************************************************************************/
bcmos_bool bcmolt_epon_protection_switching_configuration_bounds_check(const bcmolt_epon_protection_switching_configuration *this)
{
    switch (this->protection_type)
    {
        case BCMOLT_EPON_PROTECTION_SWITCHING_TYPE_NO_PROTECTION_SWTICHING:
            break;
        case BCMOLT_EPON_PROTECTION_SWITCHING_TYPE_LINE_CARD_PROTECTION_SWITCHING:
            break;
        default:
            return BCMOS_FALSE;
    }

    if ((this->protection_switching_options & 0x00FE) != 0)
    {
        return BCMOS_FALSE;
    }

    switch (this->rerange_options)
    {
        case BCMOLT_EPON_PROTECTION_SWITCHING_RERANGING_OPTIONS_RERANGE_NONE:
            break;
        case BCMOLT_EPON_PROTECTION_SWITCHING_RERANGING_OPTIONS_RERANGE_SINGLE_LOGICAL_LINK:
            break;
        case BCMOLT_EPON_PROTECTION_SWITCHING_RERANGING_OPTIONS_RERANGE_ALL_LOGICAL_LINKS:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->gpio_input)
    {
        case BCMOLT_GPIO_PIN_PIN0:
            break;
        case BCMOLT_GPIO_PIN_PIN1:
            break;
        case BCMOLT_GPIO_PIN_PIN2:
            break;
        case BCMOLT_GPIO_PIN_PIN3:
            break;
        case BCMOLT_GPIO_PIN_PIN4:
            break;
        case BCMOLT_GPIO_PIN_PIN5:
            break;
        case BCMOLT_GPIO_PIN_PIN6:
            break;
        case BCMOLT_GPIO_PIN_PIN7:
            break;
        case BCMOLT_GPIO_PIN_PIN8:
            break;
        case BCMOLT_GPIO_PIN_PIN9:
            break;
        case BCMOLT_GPIO_PIN_PIN10:
            break;
        case BCMOLT_GPIO_PIN_PIN11:
            break;
        case BCMOLT_GPIO_PIN_PIN12:
            break;
        case BCMOLT_GPIO_PIN_PIN13:
            break;
        case BCMOLT_GPIO_PIN_PIN14:
            break;
        case BCMOLT_GPIO_PIN_PIN15:
            break;
        case BCMOLT_GPIO_PIN_PIN16:
            break;
        case BCMOLT_GPIO_PIN_PIN17:
            break;
        case BCMOLT_GPIO_PIN_PIN18:
            break;
        case BCMOLT_GPIO_PIN_PIN19:
            break;
        case BCMOLT_GPIO_PIN_PIN20:
            break;
        case BCMOLT_GPIO_PIN_PIN21:
            break;
        case BCMOLT_GPIO_PIN_PIN22:
            break;
        case BCMOLT_GPIO_PIN_PIN23:
            break;
        case BCMOLT_GPIO_PIN_PIN24:
            break;
        case BCMOLT_GPIO_PIN_PIN25:
            break;
        case BCMOLT_GPIO_PIN_PIN26:
            break;
        case BCMOLT_GPIO_PIN_PIN27:
            break;
        case BCMOLT_GPIO_PIN_PIN28:
            break;
        case BCMOLT_GPIO_PIN_PIN29:
            break;
        case BCMOLT_GPIO_PIN_PIN30:
            break;
        case BCMOLT_GPIO_PIN_PIN31:
            break;
        case BCMOLT_GPIO_PIN_PIN32:
            break;
        case BCMOLT_GPIO_PIN_PIN33:
            break;
        case BCMOLT_GPIO_PIN_PIN34:
            break;
        case BCMOLT_GPIO_PIN_PIN35:
            break;
        case BCMOLT_GPIO_PIN_PIN36:
            break;
        case BCMOLT_GPIO_PIN_PIN37:
            break;
        case BCMOLT_GPIO_PIN_PIN38:
            break;
        case BCMOLT_GPIO_PIN_PIN39:
            break;
        case BCMOLT_GPIO_PIN_PIN40:
            break;
        case BCMOLT_GPIO_PIN_PIN41:
            break;
        case BCMOLT_GPIO_PIN_PIN42:
            break;
        case BCMOLT_GPIO_PIN_PIN43:
            break;
        case BCMOLT_GPIO_PIN_PIN44:
            break;
        case BCMOLT_GPIO_PIN_PIN45:
            break;
        case BCMOLT_GPIO_PIN_PIN46:
            break;
        case BCMOLT_GPIO_PIN_PIN47:
            break;
        case BCMOLT_GPIO_PIN_PIN48:
            break;
        case BCMOLT_GPIO_PIN_PIN49:
            break;
        case BCMOLT_GPIO_PIN_PIN50:
            break;
        case BCMOLT_GPIO_PIN_PIN51:
            break;
        case BCMOLT_GPIO_PIN_PIN52:
            break;
        case BCMOLT_GPIO_PIN_PIN53:
            break;
        case BCMOLT_GPIO_PIN_PIN54:
            break;
        case BCMOLT_GPIO_PIN_PIN55:
            break;
        case BCMOLT_GPIO_PIN_PIN56:
            break;
        case BCMOLT_GPIO_PIN_PIN57:
            break;
        case BCMOLT_GPIO_PIN_PIN58:
            break;
        case BCMOLT_GPIO_PIN_PIN59:
            break;
        case BCMOLT_GPIO_PIN_PIN60:
            break;
        case BCMOLT_GPIO_PIN_PIN61:
            break;
        case BCMOLT_GPIO_PIN_PIN62:
            break;
        case BCMOLT_GPIO_PIN_PIN63:
            break;
        case BCMOLT_GPIO_PIN_PIN64:
            break;
        case BCMOLT_GPIO_PIN_PIN65:
            break;
        case BCMOLT_GPIO_PIN_PIN66:
            break;
        case BCMOLT_GPIO_PIN_PIN67:
            break;
        case BCMOLT_GPIO_PIN_PIN68:
            break;
        case BCMOLT_GPIO_PIN_PIN69:
            break;
        case BCMOLT_GPIO_PIN_PIN70:
            break;
        case BCMOLT_GPIO_PIN_PIN71:
            break;
        case BCMOLT_GPIO_PIN_PIN72:
            break;
        case BCMOLT_GPIO_PIN_PIN73:
            break;
        case BCMOLT_GPIO_PIN_PIN74:
            break;
        case BCMOLT_GPIO_PIN_PIN75:
            break;
        case BCMOLT_GPIO_PIN_PIN76:
            break;
        case BCMOLT_GPIO_PIN_PIN77:
            break;
        case BCMOLT_GPIO_PIN_PIN78:
            break;
        case BCMOLT_GPIO_PIN_PIN79:
            break;
        case BCMOLT_GPIO_PIN_PIN80:
            break;
        case BCMOLT_GPIO_PIN_PIN81:
            break;
        case BCMOLT_GPIO_PIN_PIN82:
            break;
        case BCMOLT_GPIO_PIN_PIN83:
            break;
        case BCMOLT_GPIO_PIN_PIN84:
            break;
        case BCMOLT_GPIO_PIN_PIN85:
            break;
        case BCMOLT_GPIO_PIN_PIN86:
            break;
        case BCMOLT_GPIO_PIN_PIN87:
            break;
        case BCMOLT_GPIO_PIN_PIN88:
            break;
        case BCMOLT_GPIO_PIN_PIN89:
            break;
        case BCMOLT_GPIO_PIN_PIN90:
            break;
        case BCMOLT_GPIO_PIN_PIN91:
            break;
        case BCMOLT_GPIO_PIN_PIN92:
            break;
        case BCMOLT_GPIO_PIN_PIN93:
            break;
        case BCMOLT_GPIO_PIN_PIN94:
            break;
        case BCMOLT_GPIO_PIN_PIN95:
            break;
        case BCMOLT_GPIO_PIN_PIN96:
            break;
        case BCMOLT_GPIO_PIN_PIN97:
            break;
        case BCMOLT_GPIO_PIN_PIN98:
            break;
        case BCMOLT_GPIO_PIN_PIN99:
            break;
        case BCMOLT_GPIO_PIN_PIN100:
            break;
        case BCMOLT_GPIO_PIN_PIN101:
            break;
        case BCMOLT_GPIO_PIN_PIN102:
            break;
        case BCMOLT_GPIO_PIN_PIN103:
            break;
        case BCMOLT_GPIO_PIN_PIN104:
            break;
        case BCMOLT_GPIO_PIN_PIN105:
            break;
        case BCMOLT_GPIO_PIN_PIN106:
            break;
        case BCMOLT_GPIO_PIN_UNCONFIGURED:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->gpio_input_polarity)
    {
        case BCMOLT_GPIO_POLARITY_ACTIVE_LOW:
            break;
        case BCMOLT_GPIO_POLARITY_ACTIVE_HIGH:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->gpio_output)
    {
        case BCMOLT_GPIO_PIN_PIN0:
            break;
        case BCMOLT_GPIO_PIN_PIN1:
            break;
        case BCMOLT_GPIO_PIN_PIN2:
            break;
        case BCMOLT_GPIO_PIN_PIN3:
            break;
        case BCMOLT_GPIO_PIN_PIN4:
            break;
        case BCMOLT_GPIO_PIN_PIN5:
            break;
        case BCMOLT_GPIO_PIN_PIN6:
            break;
        case BCMOLT_GPIO_PIN_PIN7:
            break;
        case BCMOLT_GPIO_PIN_PIN8:
            break;
        case BCMOLT_GPIO_PIN_PIN9:
            break;
        case BCMOLT_GPIO_PIN_PIN10:
            break;
        case BCMOLT_GPIO_PIN_PIN11:
            break;
        case BCMOLT_GPIO_PIN_PIN12:
            break;
        case BCMOLT_GPIO_PIN_PIN13:
            break;
        case BCMOLT_GPIO_PIN_PIN14:
            break;
        case BCMOLT_GPIO_PIN_PIN15:
            break;
        case BCMOLT_GPIO_PIN_PIN16:
            break;
        case BCMOLT_GPIO_PIN_PIN17:
            break;
        case BCMOLT_GPIO_PIN_PIN18:
            break;
        case BCMOLT_GPIO_PIN_PIN19:
            break;
        case BCMOLT_GPIO_PIN_PIN20:
            break;
        case BCMOLT_GPIO_PIN_PIN21:
            break;
        case BCMOLT_GPIO_PIN_PIN22:
            break;
        case BCMOLT_GPIO_PIN_PIN23:
            break;
        case BCMOLT_GPIO_PIN_PIN24:
            break;
        case BCMOLT_GPIO_PIN_PIN25:
            break;
        case BCMOLT_GPIO_PIN_PIN26:
            break;
        case BCMOLT_GPIO_PIN_PIN27:
            break;
        case BCMOLT_GPIO_PIN_PIN28:
            break;
        case BCMOLT_GPIO_PIN_PIN29:
            break;
        case BCMOLT_GPIO_PIN_PIN30:
            break;
        case BCMOLT_GPIO_PIN_PIN31:
            break;
        case BCMOLT_GPIO_PIN_PIN32:
            break;
        case BCMOLT_GPIO_PIN_PIN33:
            break;
        case BCMOLT_GPIO_PIN_PIN34:
            break;
        case BCMOLT_GPIO_PIN_PIN35:
            break;
        case BCMOLT_GPIO_PIN_PIN36:
            break;
        case BCMOLT_GPIO_PIN_PIN37:
            break;
        case BCMOLT_GPIO_PIN_PIN38:
            break;
        case BCMOLT_GPIO_PIN_PIN39:
            break;
        case BCMOLT_GPIO_PIN_PIN40:
            break;
        case BCMOLT_GPIO_PIN_PIN41:
            break;
        case BCMOLT_GPIO_PIN_PIN42:
            break;
        case BCMOLT_GPIO_PIN_PIN43:
            break;
        case BCMOLT_GPIO_PIN_PIN44:
            break;
        case BCMOLT_GPIO_PIN_PIN45:
            break;
        case BCMOLT_GPIO_PIN_PIN46:
            break;
        case BCMOLT_GPIO_PIN_PIN47:
            break;
        case BCMOLT_GPIO_PIN_PIN48:
            break;
        case BCMOLT_GPIO_PIN_PIN49:
            break;
        case BCMOLT_GPIO_PIN_PIN50:
            break;
        case BCMOLT_GPIO_PIN_PIN51:
            break;
        case BCMOLT_GPIO_PIN_PIN52:
            break;
        case BCMOLT_GPIO_PIN_PIN53:
            break;
        case BCMOLT_GPIO_PIN_PIN54:
            break;
        case BCMOLT_GPIO_PIN_PIN55:
            break;
        case BCMOLT_GPIO_PIN_PIN56:
            break;
        case BCMOLT_GPIO_PIN_PIN57:
            break;
        case BCMOLT_GPIO_PIN_PIN58:
            break;
        case BCMOLT_GPIO_PIN_PIN59:
            break;
        case BCMOLT_GPIO_PIN_PIN60:
            break;
        case BCMOLT_GPIO_PIN_PIN61:
            break;
        case BCMOLT_GPIO_PIN_PIN62:
            break;
        case BCMOLT_GPIO_PIN_PIN63:
            break;
        case BCMOLT_GPIO_PIN_PIN64:
            break;
        case BCMOLT_GPIO_PIN_PIN65:
            break;
        case BCMOLT_GPIO_PIN_PIN66:
            break;
        case BCMOLT_GPIO_PIN_PIN67:
            break;
        case BCMOLT_GPIO_PIN_PIN68:
            break;
        case BCMOLT_GPIO_PIN_PIN69:
            break;
        case BCMOLT_GPIO_PIN_PIN70:
            break;
        case BCMOLT_GPIO_PIN_PIN71:
            break;
        case BCMOLT_GPIO_PIN_PIN72:
            break;
        case BCMOLT_GPIO_PIN_PIN73:
            break;
        case BCMOLT_GPIO_PIN_PIN74:
            break;
        case BCMOLT_GPIO_PIN_PIN75:
            break;
        case BCMOLT_GPIO_PIN_PIN76:
            break;
        case BCMOLT_GPIO_PIN_PIN77:
            break;
        case BCMOLT_GPIO_PIN_PIN78:
            break;
        case BCMOLT_GPIO_PIN_PIN79:
            break;
        case BCMOLT_GPIO_PIN_PIN80:
            break;
        case BCMOLT_GPIO_PIN_PIN81:
            break;
        case BCMOLT_GPIO_PIN_PIN82:
            break;
        case BCMOLT_GPIO_PIN_PIN83:
            break;
        case BCMOLT_GPIO_PIN_PIN84:
            break;
        case BCMOLT_GPIO_PIN_PIN85:
            break;
        case BCMOLT_GPIO_PIN_PIN86:
            break;
        case BCMOLT_GPIO_PIN_PIN87:
            break;
        case BCMOLT_GPIO_PIN_PIN88:
            break;
        case BCMOLT_GPIO_PIN_PIN89:
            break;
        case BCMOLT_GPIO_PIN_PIN90:
            break;
        case BCMOLT_GPIO_PIN_PIN91:
            break;
        case BCMOLT_GPIO_PIN_PIN92:
            break;
        case BCMOLT_GPIO_PIN_PIN93:
            break;
        case BCMOLT_GPIO_PIN_PIN94:
            break;
        case BCMOLT_GPIO_PIN_PIN95:
            break;
        case BCMOLT_GPIO_PIN_PIN96:
            break;
        case BCMOLT_GPIO_PIN_PIN97:
            break;
        case BCMOLT_GPIO_PIN_PIN98:
            break;
        case BCMOLT_GPIO_PIN_PIN99:
            break;
        case BCMOLT_GPIO_PIN_PIN100:
            break;
        case BCMOLT_GPIO_PIN_PIN101:
            break;
        case BCMOLT_GPIO_PIN_PIN102:
            break;
        case BCMOLT_GPIO_PIN_PIN103:
            break;
        case BCMOLT_GPIO_PIN_PIN104:
            break;
        case BCMOLT_GPIO_PIN_PIN105:
            break;
        case BCMOLT_GPIO_PIN_PIN106:
            break;
        case BCMOLT_GPIO_PIN_UNCONFIGURED:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->gpio_output_polarity)
    {
        case BCMOLT_GPIO_POLARITY_ACTIVE_LOW:
            break;
        case BCMOLT_GPIO_POLARITY_ACTIVE_HIGH:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_u8_list_u16_set_default(bcmolt_u8_list_u16 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u16_pack(const bcmolt_u8_list_u16 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u8_list_u16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_u8_list_u16_get_packed_length(const bcmolt_u8_list_u16 *this)
{
    return 2 + this->len;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u16_unpack(bcmolt_u8_list_u16 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u8_list_u16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (uint8_t *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(uint8_t));
        }
    }

    if (!bcmolt_buf_read(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u16_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(uint8_t) * len);
    if (!bcmolt_buf_skip(packed, len * 1))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u16_bounds_check(const bcmolt_u8_list_u16 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ethernet_frame_masked_set_default(bcmolt_ethernet_frame_masked *this)
{
    this->frame_octets.len = 0;
    this->frame_octets.val = NULL;
    this->mask_octets.len = 0;
    this->mask_octets.val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_ethernet_frame_masked_pack(const bcmolt_ethernet_frame_masked *this, bcmolt_buf *buf)
{
    if (!bcmolt_u8_list_u16_pack(&this->frame_octets, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_u8_list_u16_pack(&this->mask_octets, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ethernet_frame_masked_get_packed_length(const bcmolt_ethernet_frame_masked *this)
{
    return bcmolt_u8_list_u16_get_packed_length(&this->frame_octets) + bcmolt_u8_list_u16_get_packed_length(&this->mask_octets);
}

/******************************************************************************/
bcmos_bool bcmolt_ethernet_frame_masked_unpack(bcmolt_ethernet_frame_masked *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_u8_list_u16_unpack(&this->frame_octets, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_u8_list_u16_unpack(&this->mask_octets, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ethernet_frame_masked_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    if (!bcmolt_u8_list_u16_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_u8_list_u16_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ethernet_frame_masked_bounds_check(const bcmolt_ethernet_frame_masked *this)
{
    if (!bcmolt_u8_list_u16_bounds_check(&this->frame_octets))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_u8_list_u16_bounds_check(&this->mask_octets))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ethernet_frame_unmasked_set_default(bcmolt_ethernet_frame_unmasked *this)
{
    this->frame_octets.len = 0;
    this->frame_octets.val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_ethernet_frame_unmasked_pack(const bcmolt_ethernet_frame_unmasked *this, bcmolt_buf *buf)
{
    if (!bcmolt_u8_list_u16_pack(&this->frame_octets, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ethernet_frame_unmasked_get_packed_length(const bcmolt_ethernet_frame_unmasked *this)
{
    return bcmolt_u8_list_u16_get_packed_length(&this->frame_octets);
}

/******************************************************************************/
bcmos_bool bcmolt_ethernet_frame_unmasked_unpack(bcmolt_ethernet_frame_unmasked *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_u8_list_u16_unpack(&this->frame_octets, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ethernet_frame_unmasked_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    if (!bcmolt_u8_list_u16_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ethernet_frame_unmasked_bounds_check(const bcmolt_ethernet_frame_unmasked *this)
{
    if (!bcmolt_u8_list_u16_bounds_check(&this->frame_octets))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_extended_guard_time_set_default(bcmolt_extended_guard_time *this)
{
    this->additional_preburst_guard_time = 0;
    this->additional_postburst_guard_time = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_extended_guard_time_pack(const bcmolt_extended_guard_time *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->additional_preburst_guard_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->additional_postburst_guard_time))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_extended_guard_time_unpack(bcmolt_extended_guard_time *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->additional_preburst_guard_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->additional_postburst_guard_time))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_extended_guard_time_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_extended_guard_time_bounds_check(const bcmolt_extended_guard_time *this)
{
    if (this->additional_preburst_guard_time > 500)
    {
        return BCMOS_FALSE;
    }

    if (this->additional_postburst_guard_time > 500)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_firmware_sw_version_set_default(bcmolt_firmware_sw_version *this)
{
    this->major = 0;
    this->minor = 0;
    this->revision = 0;
    this->model = 0;
    memset(this->build_time, 0, 32);
}

/******************************************************************************/
bcmos_bool bcmolt_firmware_sw_version_pack(const bcmolt_firmware_sw_version *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->major))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->minor))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->revision))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->model))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->build_time, 32))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_firmware_sw_version_unpack(bcmolt_firmware_sw_version *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->major))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->minor))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->revision))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->model))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read(buf, this->build_time, 32))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_firmware_sw_version_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 39);
}

/******************************************************************************/
bcmos_bool bcmolt_firmware_sw_version_bounds_check(const bcmolt_firmware_sw_version *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gem_port_configuration_set_default(bcmolt_gem_port_configuration *this)
{
    this->direction = BCMOLT_GEM_PORT_DIRECTION_DOWNSTREAM;
    this->type = BCMOLT_GEM_PORT_TYPE_UNICAST;
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_configuration_pack(const bcmolt_gem_port_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_gem_port_direction_pack(this->direction, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gem_port_type_pack(this->type, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_configuration_unpack(bcmolt_gem_port_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_gem_port_direction_unpack(&this->direction, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gem_port_type_unpack(&this->type, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_gem_port_configuration_bounds_check(const bcmolt_gem_port_configuration *this)
{
    switch (this->direction)
    {
        case BCMOLT_GEM_PORT_DIRECTION_DOWNSTREAM:
            break;
        case BCMOLT_GEM_PORT_DIRECTION_UPSTREAM:
            break;
        case BCMOLT_GEM_PORT_DIRECTION_BIDIRECTIONAL:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->type)
    {
        case BCMOLT_GEM_PORT_TYPE_UNICAST:
            break;
        case BCMOLT_GEM_PORT_TYPE_MULTICAST:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_alloc_with_state_set_default(bcmolt_gpon_alloc_with_state *this)
{
    this->alloc_id = (bcmolt_gpon_alloc_id) 0;
    this->state = BCMOLT_ALLOC_STATE_NOT_CONFIGURED;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_with_state_pack(const bcmolt_gpon_alloc_with_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->alloc_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_alloc_state_pack(this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_with_state_unpack(bcmolt_gpon_alloc_with_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->alloc_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_alloc_state_unpack(&this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_with_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_with_state_bounds_check(const bcmolt_gpon_alloc_with_state *this)
{
    if (this->alloc_id > (bcmolt_gpon_alloc_id) 4095)
    {
        return BCMOS_FALSE;
    }

    switch (this->state)
    {
        case BCMOLT_ALLOC_STATE_NOT_CONFIGURED:
            break;
        case BCMOLT_ALLOC_STATE_INACTIVE:
            break;
        case BCMOLT_ALLOC_STATE_PROCESSING:
            break;
        case BCMOLT_ALLOC_STATE_ACTIVE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_alloc_with_state_list_u16_max_32_set_default(bcmolt_gpon_alloc_with_state_list_u16_max_32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_with_state_list_u16_max_32_pack(const bcmolt_gpon_alloc_with_state_list_u16_max_32 *this, bcmolt_buf *buf)
{
    uint16_t i0;
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_alloc_with_state_list_u16_max_32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 32)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_alloc_with_state_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gpon_alloc_with_state_list_u16_max_32_get_packed_length(const bcmolt_gpon_alloc_with_state_list_u16_max_32 *this)
{
    return 2 + (3 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_with_state_list_u16_max_32_unpack(bcmolt_gpon_alloc_with_state_list_u16_max_32 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_alloc_with_state_list_u16_max_32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gpon_alloc_with_state *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gpon_alloc_with_state));
        }
    }

    if (this->len > 32)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_alloc_with_state_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_with_state_list_u16_max_32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gpon_alloc_with_state) * len);
    if (!bcmolt_buf_skip(packed, len * 3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_alloc_with_state_list_u16_max_32_bounds_check(const bcmolt_gpon_alloc_with_state_list_u16_max_32 *this)
{
    if (this->len > 32)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_debug_flow_config_set_default(bcmolt_gpon_debug_flow_config *this)
{
    this->untagged_flow = BCMOLT_CONTROL_STATE_DISABLE;
    this->untagged_vid = (bcmolt_vlan_id) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_debug_flow_config_pack(const bcmolt_gpon_debug_flow_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_control_state_pack(this->untagged_flow, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->untagged_vid))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_debug_flow_config_unpack(bcmolt_gpon_debug_flow_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_control_state_unpack(&this->untagged_flow, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->untagged_vid))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_debug_flow_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_debug_flow_config_bounds_check(const bcmolt_gpon_debug_flow_config *this)
{
    switch (this->untagged_flow)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->untagged_vid > (bcmolt_vlan_id) 4095)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_gem_id_list_u8_max_16_set_default(bcmolt_gpon_gem_id_list_u8_max_16 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_id_list_u8_max_16_pack(const bcmolt_gpon_gem_id_list_u8_max_16 *this, bcmolt_buf *buf)
{
    uint8_t i0;
    if (!bcmolt_buf_write_u8(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_gem_id_list_u8_max_16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 16)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_write_u16(buf, (uint16_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gpon_gem_id_list_u8_max_16_get_packed_length(const bcmolt_gpon_gem_id_list_u8_max_16 *this)
{
    return 1 + (2 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_id_list_u8_max_16_unpack(bcmolt_gpon_gem_id_list_u8_max_16 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint8_t i0;
    if (!bcmolt_buf_read_u8(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_gem_id_list_u8_max_16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gpon_gem_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gpon_gem_id));
        }
    }

    if (this->len > 16)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_id_list_u8_max_16_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint8_t len;
    if (!bcmolt_buf_read_u8(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gpon_gem_id) * len);
    if (!bcmolt_buf_skip(packed, len * 2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_id_list_u8_max_16_bounds_check(const bcmolt_gpon_gem_id_list_u8_max_16 *this)
{
    if (this->len > 16)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_gem_port_with_state_set_default(bcmolt_gpon_gem_port_with_state *this)
{
    this->gem_id = (bcmolt_gpon_gem_id) 0;
    this->state = BCMOLT_GPON_GEM_PORT_STATE_NOT_CONFIGURED;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_pack(const bcmolt_gpon_gem_port_with_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->gem_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpon_gem_port_state_pack(this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_unpack(bcmolt_gpon_gem_port_with_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->gem_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpon_gem_port_state_unpack(&this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_bounds_check(const bcmolt_gpon_gem_port_with_state *this)
{
    if (this->gem_id > (bcmolt_gpon_gem_id) 4095)
    {
        return BCMOS_FALSE;
    }

    switch (this->state)
    {
        case BCMOLT_GPON_GEM_PORT_STATE_NOT_CONFIGURED:
            break;
        case BCMOLT_GPON_GEM_PORT_STATE_INACTIVE:
            break;
        case BCMOLT_GPON_GEM_PORT_STATE_PROCESSING:
            break;
        case BCMOLT_GPON_GEM_PORT_STATE_ACTIVE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_gem_port_with_state_list_u16_max_128_set_default(bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_128_pack(const bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this, bcmolt_buf *buf)
{
    uint16_t i0;
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_gem_port_with_state_list_u16_max_128\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 128)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_gem_port_with_state_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gpon_gem_port_with_state_list_u16_max_128_get_packed_length(const bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this)
{
    return 2 + (3 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_128_unpack(bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_gem_port_with_state_list_u16_max_128\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gpon_gem_port_with_state *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gpon_gem_port_with_state));
        }
    }

    if (this->len > 128)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_gem_port_with_state_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_128_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gpon_gem_port_with_state) * len);
    if (!bcmolt_buf_skip(packed, len * 3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_128_bounds_check(const bcmolt_gpon_gem_port_with_state_list_u16_max_128 *this)
{
    if (this->len > 128)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_gem_port_with_state_list_u16_max_256_set_default(bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_256_pack(const bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this, bcmolt_buf *buf)
{
    uint16_t i0;
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_gem_port_with_state_list_u16_max_256\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 256)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_gem_port_with_state_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gpon_gem_port_with_state_list_u16_max_256_get_packed_length(const bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this)
{
    return 2 + (3 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_256_unpack(bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_gem_port_with_state_list_u16_max_256\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gpon_gem_port_with_state *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gpon_gem_port_with_state));
        }
    }

    if (this->len > 256)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_gem_port_with_state_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_256_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gpon_gem_port_with_state) * len);
    if (!bcmolt_buf_skip(packed, len * 3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_gem_port_with_state_list_u16_max_256_bounds_check(const bcmolt_gpon_gem_port_with_state_list_u16_max_256 *this)
{
    if (this->len > 256)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_iwf_debug_flow_config_set_default(bcmolt_gpon_iwf_debug_flow_config *this)
{
    this->learn_untagged_flow_vids = BCMOS_FALSE;
    this->untagged_flow_shaping_ms_per_sec = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_debug_flow_config_pack(const bcmolt_gpon_iwf_debug_flow_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_bool(buf, this->learn_untagged_flow_vids))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->untagged_flow_shaping_ms_per_sec))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_debug_flow_config_unpack(bcmolt_gpon_iwf_debug_flow_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_bool(buf, &this->learn_untagged_flow_vids))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->untagged_flow_shaping_ms_per_sec))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_debug_flow_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_iwf_debug_flow_config_bounds_check(const bcmolt_gpon_iwf_debug_flow_config *this)
{
    if (this->untagged_flow_shaping_ms_per_sec > 1000)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_key_exchange_set_default(bcmolt_gpon_key_exchange *this)
{
    this->interval = 10000;
    this->control = BCMOLT_CONTROL_STATE_DISABLE;
    this->mode = BCMOLT_KEY_EXCHANGE_MODE_NORMAL;
    this->encrypted_ports_only = BCMOLT_CONTROL_STATE_ENABLE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_key_exchange_pack(const bcmolt_gpon_key_exchange *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_key_exchange_mode_pack(this->mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->encrypted_ports_only, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_key_exchange_unpack(bcmolt_gpon_key_exchange *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_key_exchange_mode_unpack(&this->mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->encrypted_ports_only, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_key_exchange_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 7);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_key_exchange_bounds_check(const bcmolt_gpon_key_exchange *this)
{
    if (this->interval < 1000)
    {
        return BCMOS_FALSE;
    }

    if (this->interval > 3600000UL)
    {
        return BCMOS_FALSE;
    }

    switch (this->control)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->mode)
    {
        case BCMOLT_KEY_EXCHANGE_MODE_NORMAL:
            break;
        case BCMOLT_KEY_EXCHANGE_MODE_ENHANCED:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->encrypted_ports_only)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_mac_table_scan_result_set_default(bcmolt_gpon_mac_table_scan_result *this)
{
    this->vlan = (bcmolt_vlan_id) 0;
    this->flow_id = (bcmolt_flow_id) 0;
    this->stat = BCMOS_FALSE;
    this->gem_port_id = (bcmolt_gpon_gem_id) 0;
    this->onu_id = (bcmolt_gpon_onu_id) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_mac_table_scan_result_pack(const bcmolt_gpon_mac_table_scan_result *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->vlan))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->flow_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->stat))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->gem_port_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->onu_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_mac_table_scan_result_unpack(bcmolt_gpon_mac_table_scan_result *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->vlan))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->flow_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->stat))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->gem_port_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->onu_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_mac_table_scan_result_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 9);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_mac_table_scan_result_bounds_check(const bcmolt_gpon_mac_table_scan_result *this)
{
    if (this->flow_id > (bcmolt_flow_id) 4095)
    {
        return BCMOS_FALSE;
    }

    if (this->gem_port_id > (bcmolt_gpon_gem_id) 4095)
    {
        return BCMOS_FALSE;
    }

    if (this->onu_id > (bcmolt_gpon_onu_id) 127)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_mac_table_scan_result_list_u16_set_default(bcmolt_gpon_mac_table_scan_result_list_u16 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_mac_table_scan_result_list_u16_pack(const bcmolt_gpon_mac_table_scan_result_list_u16 *this, bcmolt_buf *buf)
{
    uint16_t i0;
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_mac_table_scan_result_list_u16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_mac_table_scan_result_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gpon_mac_table_scan_result_list_u16_get_packed_length(const bcmolt_gpon_mac_table_scan_result_list_u16 *this)
{
    return 2 + (9 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_mac_table_scan_result_list_u16_unpack(bcmolt_gpon_mac_table_scan_result_list_u16 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_mac_table_scan_result_list_u16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gpon_mac_table_scan_result *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gpon_mac_table_scan_result));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_mac_table_scan_result_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_mac_table_scan_result_list_u16_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gpon_mac_table_scan_result) * len);
    if (!bcmolt_buf_skip(packed, len * 9))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_mac_table_scan_result_list_u16_bounds_check(const bcmolt_gpon_mac_table_scan_result_list_u16 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_ni_debug_set_default(bcmolt_gpon_ni_debug *this)
{
    this->number_of_gem_ports_per_onu = 64;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_debug_pack(const bcmolt_gpon_ni_debug *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->number_of_gem_ports_per_onu))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_debug_unpack(bcmolt_gpon_ni_debug *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->number_of_gem_ports_per_onu))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_debug_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_ni_debug_bounds_check(const bcmolt_gpon_ni_debug *this)
{
    if (this->number_of_gem_ports_per_onu < 8)
    {
        return BCMOS_FALSE;
    }

    if (this->number_of_gem_ports_per_onu > 256)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_activation_set_default(bcmolt_gpon_onu_activation *this)
{
    this->key_exchange = BCMOLT_CONTROL_STATE_DISABLE;
    this->password_authentication = BCMOLT_CONTROL_STATE_ENABLE;
    this->fail_due_to_password_authentication_failure = BCMOLT_CONTROL_STATE_ENABLE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_activation_pack(const bcmolt_gpon_onu_activation *this, bcmolt_buf *buf)
{
    if (!bcmolt_control_state_pack(this->key_exchange, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->password_authentication, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->fail_due_to_password_authentication_failure, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_activation_unpack(bcmolt_gpon_onu_activation *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_control_state_unpack(&this->key_exchange, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->password_authentication, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->fail_due_to_password_authentication_failure, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_activation_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_activation_bounds_check(const bcmolt_gpon_onu_activation *this)
{
    switch (this->key_exchange)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->password_authentication)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->fail_due_to_password_authentication_failure)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_alarm_state_set_default(bcmolt_gpon_onu_alarm_state *this)
{
    this->losi = BCMOLT_STATUS_OFF;
    this->lofi = BCMOLT_STATUS_OFF;
    this->loami = BCMOLT_STATUS_OFF;
    this->dgi = BCMOLT_STATUS_OFF;
    this->tiwi = BCMOLT_STATUS_OFF;
    this->dowi = BCMOLT_STATUS_OFF;
    this->sufi = BCMOLT_STATUS_OFF;
    this->sfi = BCMOLT_STATUS_OFF;
    this->sdi = BCMOLT_STATUS_OFF;
    this->dfi = BCMOLT_STATUS_OFF;
    this->loai = BCMOLT_STATUS_OFF;
    this->loki = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarm_state_pack(const bcmolt_gpon_onu_alarm_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_status_pack(this->losi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->lofi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->loami, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->dgi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->tiwi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->dowi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->sufi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->sfi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->sdi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->dfi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->loai, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->loki, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarm_state_unpack(bcmolt_gpon_onu_alarm_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_status_unpack(&this->losi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->lofi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->loami, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->dgi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->tiwi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->dowi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->sufi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->sfi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->sdi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->dfi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->loai, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->loki, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarm_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 12);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarm_state_bounds_check(const bcmolt_gpon_onu_alarm_state *this)
{
    switch (this->losi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lofi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->loami)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->dgi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->tiwi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->dowi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->sufi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->sfi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->sdi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->dfi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->loai)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->loki)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_alarms_set_default(bcmolt_gpon_onu_alarms *this)
{
    this->losi = BCMOLT_STATUS_OFF;
    this->lofi = BCMOLT_STATUS_OFF;
    this->loami = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarms_pack(const bcmolt_gpon_onu_alarms *this, bcmolt_buf *buf)
{
    if (!bcmolt_status_pack(this->losi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->lofi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->loami, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarms_unpack(bcmolt_gpon_onu_alarms *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_status_unpack(&this->losi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->lofi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->loami, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarms_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarms_bounds_check(const bcmolt_gpon_onu_alarms *this)
{
    switch (this->losi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lofi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->loami)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_alarms_thresholds_set_default(bcmolt_gpon_onu_alarms_thresholds *this)
{
    this->losi = 4;
    this->lofi = 4;
    this->loami = 3;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarms_thresholds_pack(const bcmolt_gpon_onu_alarms_thresholds *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->losi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->lofi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->loami))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarms_thresholds_unpack(bcmolt_gpon_onu_alarms_thresholds *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->losi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->lofi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->loami))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarms_thresholds_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_alarms_thresholds_bounds_check(const bcmolt_gpon_onu_alarms_thresholds *this)
{
    if (this->losi < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->losi > 15)
    {
        return BCMOS_FALSE;
    }

    if (this->lofi < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->lofi > 15)
    {
        return BCMOS_FALSE;
    }

    if (this->loami < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->loami > 15)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_eqd_set_default(bcmolt_gpon_onu_eqd *this)
{
    this->onu_id = (bcmolt_gpon_onu_id) 0;
    this->eqd = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_eqd_pack(const bcmolt_gpon_onu_eqd *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->eqd))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_eqd_unpack(bcmolt_gpon_onu_eqd *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->eqd))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_eqd_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 6);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_eqd_bounds_check(const bcmolt_gpon_onu_eqd *this)
{
    if (this->onu_id > (bcmolt_gpon_onu_id) 127)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_eqd_list_u32_set_default(bcmolt_gpon_onu_eqd_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_eqd_list_u32_pack(const bcmolt_gpon_onu_eqd_list_u32 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_onu_eqd_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_onu_eqd_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gpon_onu_eqd_list_u32_get_packed_length(const bcmolt_gpon_onu_eqd_list_u32 *this)
{
    return 4 + (6 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_eqd_list_u32_unpack(bcmolt_gpon_onu_eqd_list_u32 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_onu_eqd_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gpon_onu_eqd *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gpon_onu_eqd));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_onu_eqd_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_eqd_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gpon_onu_eqd) * len);
    if (!bcmolt_buf_skip(packed, len * 6))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_eqd_list_u32_bounds_check(const bcmolt_gpon_onu_eqd_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_id_list_u32_max_256_set_default(bcmolt_gpon_onu_id_list_u32_max_256 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_id_list_u32_max_256_pack(const bcmolt_gpon_onu_id_list_u32_max_256 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_onu_id_list_u32_max_256\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 256)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_write_u16(buf, (uint16_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gpon_onu_id_list_u32_max_256_get_packed_length(const bcmolt_gpon_onu_id_list_u32_max_256 *this)
{
    return 4 + (2 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_id_list_u32_max_256_unpack(bcmolt_gpon_onu_id_list_u32_max_256 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_onu_id_list_u32_max_256\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gpon_onu_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gpon_onu_id));
        }
    }

    if (this->len > 256)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_id_list_u32_max_256_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gpon_onu_id) * len);
    if (!bcmolt_buf_skip(packed, len * 2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_id_list_u32_max_256_bounds_check(const bcmolt_gpon_onu_id_list_u32_max_256 *this)
{
    if (this->len > 256)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_upgrade_params_set_default(bcmolt_gpon_onu_upgrade_params *this)
{
    this->response_timeout_ms = 1000;
    this->max_retry_count = 23;
    this->omci_format = BCMOLT_OMCI_DEVICE_ID_EXTENDED;
    this->window_size = 32;
    this->activate_commit = BCMOS_FALSE;
    this->delay_for_commit_ms = 40000UL;
    this->max_activation_attempts = 23;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_params_pack(const bcmolt_gpon_onu_upgrade_params *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->response_timeout_ms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->max_retry_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_omci_device_id_pack(this->omci_format, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->activate_commit))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->delay_for_commit_ms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->max_activation_attempts))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_params_unpack(bcmolt_gpon_onu_upgrade_params *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->response_timeout_ms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->max_retry_count))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_omci_device_id_unpack(&this->omci_format, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->activate_commit))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->delay_for_commit_ms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->max_activation_attempts))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_params_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 14);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_params_bounds_check(const bcmolt_gpon_onu_upgrade_params *this)
{
    if (this->response_timeout_ms < 50)
    {
        return BCMOS_FALSE;
    }

    switch (this->omci_format)
    {
        case BCMOLT_OMCI_DEVICE_ID_BASELINE:
            break;
        case BCMOLT_OMCI_DEVICE_ID_EXTENDED:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->window_size < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->window_size > 256)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_upgrade_status_set_default(bcmolt_gpon_onu_upgrade_status *this)
{
    this->onu_id = (bcmolt_pon_onu_id) 0;
    this->error_code = BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_SUCCESS;
    this->fail_reason = BCMOLT_OMCI_RESULT_CODE_NO_ERROR;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_status_pack(const bcmolt_gpon_onu_upgrade_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpon_onu_upgrade_return_code_pack(this->error_code, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_omci_result_code_pack(this->fail_reason, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_status_unpack(bcmolt_gpon_onu_upgrade_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpon_onu_upgrade_return_code_unpack(&this->error_code, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_omci_result_code_unpack(&this->fail_reason, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_status_bounds_check(const bcmolt_gpon_onu_upgrade_status *this)
{
    if (this->onu_id > (bcmolt_pon_onu_id) 511)
    {
        return BCMOS_FALSE;
    }

    switch (this->error_code)
    {
        case BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_SUCCESS:
            break;
        case BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_ONU_RESPONSE_TIMEOUT:
            break;
        case BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_ONU_ERROR_RESPONSE:
            break;
        case BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_TCI_MISMATCH:
            break;
        case BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_GET_IMAGE_FAILED:
            break;
        case BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_ACTIVATION_FAILED:
            break;
        case BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_INTERNAL:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->fail_reason)
    {
        case BCMOLT_OMCI_RESULT_CODE_NO_ERROR:
            break;
        case BCMOLT_OMCI_RESULT_CODE_PROCESSING_ERROR:
            break;
        case BCMOLT_OMCI_RESULT_CODE_NOT_SUPPORTED:
            break;
        case BCMOLT_OMCI_RESULT_CODE_PARAMETER_ERROR:
            break;
        case BCMOLT_OMCI_RESULT_CODE_UNKNOWN_ENTITY:
            break;
        case BCMOLT_OMCI_RESULT_CODE_UNKNOWN_INSTANCE:
            break;
        case BCMOLT_OMCI_RESULT_CODE_DEVICE_BUSY:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_upgrade_status_list_u32_set_default(bcmolt_gpon_onu_upgrade_status_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_status_list_u32_pack(const bcmolt_gpon_onu_upgrade_status_list_u32 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_onu_upgrade_status_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_onu_upgrade_status_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gpon_onu_upgrade_status_list_u32_get_packed_length(const bcmolt_gpon_onu_upgrade_status_list_u32 *this)
{
    return 4 + (4 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_status_list_u32_unpack(bcmolt_gpon_onu_upgrade_status_list_u32 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_onu_upgrade_status_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gpon_onu_upgrade_status *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gpon_onu_upgrade_status));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_onu_upgrade_status_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_status_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gpon_onu_upgrade_status) * len);
    if (!bcmolt_buf_skip(packed, len * 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_upgrade_status_list_u32_bounds_check(const bcmolt_gpon_onu_upgrade_status_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_with_state_set_default(bcmolt_gpon_onu_with_state *this)
{
    this->onu_id = (bcmolt_gpon_onu_id) 0;
    this->state = BCMOLT_ONU_STATE_NOT_CONFIGURED;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_with_state_pack(const bcmolt_gpon_onu_with_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_onu_state_pack(this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_with_state_unpack(bcmolt_gpon_onu_with_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_onu_state_unpack(&this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_with_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_with_state_bounds_check(const bcmolt_gpon_onu_with_state *this)
{
    if (this->onu_id > (bcmolt_gpon_onu_id) 127)
    {
        return BCMOS_FALSE;
    }

    switch (this->state)
    {
        case BCMOLT_ONU_STATE_NOT_CONFIGURED:
            break;
        case BCMOLT_ONU_STATE_INACTIVE:
            break;
        case BCMOLT_ONU_STATE_ACTIVE:
            break;
        case BCMOLT_ONU_STATE_ACTIVE_STANDBY:
            break;
        case BCMOLT_ONU_STATE_DISABLED:
            break;
        case BCMOLT_ONU_STATE_AWAKE_FREE:
            break;
        case BCMOLT_ONU_STATE_PROCESSING:
            break;
        case BCMOLT_ONU_STATE_LOW_POWER_DOZE:
            break;
        case BCMOLT_ONU_STATE_LOW_POWER_SLEEP:
            break;
        case BCMOLT_ONU_STATE_LOW_POWER_WATCH:
            break;
        case BCMOLT_ONU_STATE_UNAWARE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_onu_with_state_list_u16_max_128_set_default(bcmolt_gpon_onu_with_state_list_u16_max_128 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_with_state_list_u16_max_128_pack(const bcmolt_gpon_onu_with_state_list_u16_max_128 *this, bcmolt_buf *buf)
{
    uint16_t i0;
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_onu_with_state_list_u16_max_128\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 128)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_onu_with_state_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_gpon_onu_with_state_list_u16_max_128_get_packed_length(const bcmolt_gpon_onu_with_state_list_u16_max_128 *this)
{
    return 2 + (3 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_with_state_list_u16_max_128_unpack(bcmolt_gpon_onu_with_state_list_u16_max_128 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_gpon_onu_with_state_list_u16_max_128\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_gpon_onu_with_state *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_gpon_onu_with_state));
        }
    }

    if (this->len > 128)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_gpon_onu_with_state_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_with_state_list_u16_max_128_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_gpon_onu_with_state) * len);
    if (!bcmolt_buf_skip(packed, len * 3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_onu_with_state_list_u16_max_128_bounds_check(const bcmolt_gpon_onu_with_state_list_u16_max_128 *this)
{
    if (this->len > 128)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_rssi_general_configuration_set_default(bcmolt_gpon_rssi_general_configuration *this)
{
    this->location = 20;
    this->location_sign = BCMOLT_RSSI_LOCATION_SIGN_BEFORE;
    this->start_pattern = 15;
    this->middle_pattern = 15;
    this->last_pattern = 15;
    this->middle_repertition = 50;
    this->minimum_burst = 55;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_rssi_general_configuration_pack(const bcmolt_gpon_rssi_general_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_rssi_location_sign_pack(this->location_sign, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->start_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->middle_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->last_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->middle_repertition))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->minimum_burst))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_rssi_general_configuration_unpack(bcmolt_gpon_rssi_general_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_rssi_location_sign_unpack(&this->location_sign, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->start_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->middle_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->last_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->middle_repertition))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->minimum_burst))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_rssi_general_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_rssi_general_configuration_bounds_check(const bcmolt_gpon_rssi_general_configuration *this)
{
    switch (this->location_sign)
    {
        case BCMOLT_RSSI_LOCATION_SIGN_BEFORE:
            break;
        case BCMOLT_RSSI_LOCATION_SIGN_AFTER:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_gpon_sn_acquisition_set_default(bcmolt_gpon_sn_acquisition *this)
{
    this->interval = 1000;
    this->control = BCMOLT_CONTROL_STATE_DISABLE;
    this->onu_post_discovery_mode = BCMOLT_ONU_POST_DISCOVERY_MODE_DISABLE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_sn_acquisition_pack(const bcmolt_gpon_sn_acquisition *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_onu_post_discovery_mode_pack(this->onu_post_discovery_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_sn_acquisition_unpack(bcmolt_gpon_sn_acquisition *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_onu_post_discovery_mode_unpack(&this->onu_post_discovery_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_sn_acquisition_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 6);
}

/******************************************************************************/
bcmos_bool bcmolt_gpon_sn_acquisition_bounds_check(const bcmolt_gpon_sn_acquisition *this)
{
    if (this->interval < 1000)
    {
        return BCMOS_FALSE;
    }

    if (this->interval > 2147483UL)
    {
        return BCMOS_FALSE;
    }

    switch (this->control)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->onu_post_discovery_mode)
    {
        case BCMOLT_ONU_POST_DISCOVERY_MODE_NONE:
            break;
        case BCMOLT_ONU_POST_DISCOVERY_MODE_ACTIVATE:
            break;
        case BCMOLT_ONU_POST_DISCOVERY_MODE_DISABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_host_sw_version_set_default(bcmolt_host_sw_version *this)
{
    this->major = 0;
    this->minor = 0;
    this->revision = 0;
    this->model = 0;
    memset(this->build_time, 0, 32);
}

/******************************************************************************/
bcmos_bool bcmolt_host_sw_version_pack(const bcmolt_host_sw_version *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->major))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->minor))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->revision))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->model))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->build_time, 32))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_host_sw_version_unpack(bcmolt_host_sw_version *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->major))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->minor))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->revision))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->model))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read(buf, this->build_time, 32))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_host_sw_version_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 39);
}

/******************************************************************************/
bcmos_bool bcmolt_host_sw_version_bounds_check(const bcmolt_host_sw_version *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_hw_pon_id_set_default(bcmolt_hw_pon_id *this)
{
    this->pon_id_1 = 0;
    this->pon_id_2 = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_hw_pon_id_pack(const bcmolt_hw_pon_id *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->pon_id_1))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->pon_id_2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_hw_pon_id_unpack(bcmolt_hw_pon_id *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->pon_id_1))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->pon_id_2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_hw_pon_id_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_hw_pon_id_bounds_check(const bcmolt_hw_pon_id *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ieee_8021as_port_identity_set_default(bcmolt_ieee_8021as_port_identity *this)
{
    memset(this->clock_identity, 0, sizeof(this->clock_identity));
    this->port_number = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_port_identity_pack(const bcmolt_ieee_8021as_port_identity *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->clock_identity, 8))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->port_number))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_port_identity_unpack(bcmolt_ieee_8021as_port_identity *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->clock_identity, 8))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->port_number))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_port_identity_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 10);
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_port_identity_bounds_check(const bcmolt_ieee_8021as_port_identity *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ieee_8021as_timestamp_set_default(bcmolt_ieee_8021as_timestamp *this)
{
    this->seconds_high = 0;
    this->seconds_low = 0;
    this->nanoseconds = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_timestamp_pack(const bcmolt_ieee_8021as_timestamp *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->seconds_high))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->seconds_low))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->nanoseconds))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_timestamp_unpack(bcmolt_ieee_8021as_timestamp *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->seconds_high))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->seconds_low))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->nanoseconds))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_timestamp_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 10);
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_timestamp_bounds_check(const bcmolt_ieee_8021as_timestamp *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ieee_8021as_time_sync_set_default(bcmolt_ieee_8021as_time_sync *this)
{
    bcmos_mac_address_init(&this->destination_mac);
    bcmos_mac_address_init(&this->source_mac);
    this->eth_type_len = 0;
    this->eth_subtype = 0;
    memset(this->ieee_oui, 0, sizeof(this->ieee_oui));
    this->msg_id = 0;
    this->x = 0;
    this->tod.seconds_high = 0;
    this->tod.seconds_low = 0;
    this->tod.nanoseconds = 0;
    memset(this->port_identity.clock_identity, 0, sizeof(this->port_identity.clock_identity));
    this->port_identity.port_number = 0;
    this->log_msg_interval = 0;
    this->rate_ratio = 0;
    this->gm_time_base_indicator = 0;
    memset(this->last_gm_phase_change, 0, sizeof(this->last_gm_phase_change));
    this->last_frequency_change = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_time_sync_pack(const bcmolt_ieee_8021as_time_sync *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_mac_address(buf, this->destination_mac))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_mac_address(buf, this->source_mac))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->eth_type_len))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->eth_subtype))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->ieee_oui, 3))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->msg_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->x))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ieee_8021as_timestamp_pack(&this->tod, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ieee_8021as_port_identity_pack(&this->port_identity, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_s8(buf, this->log_msg_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_double(buf, this->rate_ratio))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->gm_time_base_indicator))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->last_gm_phase_change, 12))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_s32(buf, this->last_frequency_change))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_time_sync_unpack(bcmolt_ieee_8021as_time_sync *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_mac_address(buf, &this->destination_mac))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_mac_address(buf, &this->source_mac))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->eth_type_len))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->eth_subtype))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read(buf, this->ieee_oui, 3))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->msg_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->x))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ieee_8021as_timestamp_unpack(&this->tod, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ieee_8021as_port_identity_unpack(&this->port_identity, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_s8(buf, &this->log_msg_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_double(buf, &this->rate_ratio))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->gm_time_base_indicator))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read(buf, this->last_gm_phase_change, 12))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_s32(buf, &this->last_frequency_change))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_time_sync_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 71);
}

/******************************************************************************/
bcmos_bool bcmolt_ieee_8021as_time_sync_bounds_check(const bcmolt_ieee_8021as_time_sync *this)
{
    if (!bcmolt_ieee_8021as_timestamp_bounds_check(&this->tod))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ieee_8021as_port_identity_bounds_check(&this->port_identity))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_indication_shaping_set_default(bcmolt_indication_shaping *this)
{
    this->enabled = BCMOS_FALSE;
    this->max_rate = 1000;
    this->max_burst = 100;
}

/******************************************************************************/
bcmos_bool bcmolt_indication_shaping_pack(const bcmolt_indication_shaping *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_bool(buf, this->enabled))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->max_rate))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->max_burst))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_indication_shaping_unpack(bcmolt_indication_shaping *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_bool(buf, &this->enabled))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->max_rate))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->max_burst))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_indication_shaping_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 9);
}

/******************************************************************************/
bcmos_bool bcmolt_indication_shaping_bounds_check(const bcmolt_indication_shaping *this)
{
    if (this->max_rate < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->max_rate > 10000)
    {
        return BCMOS_FALSE;
    }

    if (this->max_burst < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->max_burst > 10000)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_la_resync_pattern_configuration_set_default(bcmolt_la_resync_pattern_configuration *this)
{
    this->resync_control.start_pattern = 15;
    this->resync_control.middle_pattern = 15;
    this->resync_control.last_pattern = 15;
    this->resync_control.middle_repetition = 0;
    this->resync_control.location = 40;
    this->ranging_resync_control.start_pattern = 15;
    this->ranging_resync_control.middle_pattern = 15;
    this->ranging_resync_control.last_pattern = 15;
    this->ranging_resync_control.middle_repetition = 0;
    this->ranging_resync_control.location = 1;
}

/******************************************************************************/
bcmos_bool bcmolt_la_resync_pattern_configuration_pack(const bcmolt_la_resync_pattern_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_resync_control_pack(&this->resync_control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_resync_control_pack(&this->ranging_resync_control, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_la_resync_pattern_configuration_unpack(bcmolt_la_resync_pattern_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_resync_control_unpack(&this->resync_control, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_resync_control_unpack(&this->ranging_resync_control, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_la_resync_pattern_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 10);
}

/******************************************************************************/
bcmos_bool bcmolt_la_resync_pattern_configuration_bounds_check(const bcmolt_la_resync_pattern_configuration *this)
{
    if (!bcmolt_resync_control_bounds_check(&this->resync_control))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_resync_control_bounds_check(&this->ranging_resync_control))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_log_buffer_set_default(bcmolt_log_buffer *this)
{
    memset(this->buff, 0, 2048);
    this->msg_to_read = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_log_buffer_pack(const bcmolt_log_buffer *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->buff, 2048))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->msg_to_read))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_buffer_unpack(bcmolt_log_buffer *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->buff, 2048))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->msg_to_read))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_log_buffer_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2052);
}

/******************************************************************************/
bcmos_bool bcmolt_log_buffer_bounds_check(const bcmolt_log_buffer *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_mac_table_configuration_set_default(bcmolt_mac_table_configuration *this)
{
    this->miss_fallback = BCMOLT_MAC_TABLE_MISS_FALLBACK_DROP;
    this->default_flow_id = (bcmolt_flow_id) 0;
    this->aging_time = 30;
    this->learning_mode = BCMOLT_MAC_TABLE_LEARNING_MODE_NORMAL;
    this->automatic_mac_learning = BCMOLT_CONTROL_STATE_DISABLE;
    this->automatic_mac_aging = BCMOLT_CONTROL_STATE_DISABLE;
    this->automatic_mac_move = BCMOLT_CONTROL_STATE_DISABLE;
    this->automatic_static_mode = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_mac_table_configuration_pack(const bcmolt_mac_table_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_mac_table_miss_fallback_pack(this->miss_fallback, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->default_flow_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->aging_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_mac_table_learning_mode_pack(this->learning_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->automatic_mac_learning, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->automatic_mac_aging, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->automatic_mac_move, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->automatic_static_mode))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_mac_table_configuration_unpack(bcmolt_mac_table_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_mac_table_miss_fallback_unpack(&this->miss_fallback, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->default_flow_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->aging_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_mac_table_learning_mode_unpack(&this->learning_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->automatic_mac_learning, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->automatic_mac_aging, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->automatic_mac_move, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->automatic_static_mode))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_mac_table_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 12);
}

/******************************************************************************/
bcmos_bool bcmolt_mac_table_configuration_bounds_check(const bcmolt_mac_table_configuration *this)
{
    switch (this->miss_fallback)
    {
        case BCMOLT_MAC_TABLE_MISS_FALLBACK_DROP:
            break;
        case BCMOLT_MAC_TABLE_MISS_FALLBACK_DEFAULT_FLOW:
            break;
        case BCMOLT_MAC_TABLE_MISS_FALLBACK_VID:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->default_flow_id > (bcmolt_flow_id) 4095)
    {
        return BCMOS_FALSE;
    }

    if (this->aging_time < 30)
    {
        return BCMOS_FALSE;
    }

    if (this->aging_time > 86400UL)
    {
        return BCMOS_FALSE;
    }

    switch (this->learning_mode)
    {
        case BCMOLT_MAC_TABLE_LEARNING_MODE_NORMAL:
            break;
        case BCMOLT_MAC_TABLE_LEARNING_MODE_MOVE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->automatic_mac_learning)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->automatic_mac_aging)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->automatic_mac_move)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_macaddress_list_u32_set_default(bcmolt_macaddress_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_macaddress_list_u32_pack(const bcmolt_macaddress_list_u32 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_macaddress_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_write_mac_address(buf, this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_macaddress_list_u32_get_packed_length(const bcmolt_macaddress_list_u32 *this)
{
    return 4 + (6 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_macaddress_list_u32_unpack(bcmolt_macaddress_list_u32 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_macaddress_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmos_mac_address *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmos_mac_address));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_read_mac_address(buf, &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_macaddress_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmos_mac_address) * len);
    if (!bcmolt_buf_skip(packed, len * 6))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_macaddress_list_u32_bounds_check(const bcmolt_macaddress_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_macaddress_list_u32_max_2048_set_default(bcmolt_macaddress_list_u32_max_2048 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_macaddress_list_u32_max_2048_pack(const bcmolt_macaddress_list_u32_max_2048 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_macaddress_list_u32_max_2048\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 2048)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_write_mac_address(buf, this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_macaddress_list_u32_max_2048_get_packed_length(const bcmolt_macaddress_list_u32_max_2048 *this)
{
    return 4 + (6 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_macaddress_list_u32_max_2048_unpack(bcmolt_macaddress_list_u32_max_2048 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_macaddress_list_u32_max_2048\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmos_mac_address *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmos_mac_address));
        }
    }

    if (this->len > 2048)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_read_mac_address(buf, &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_macaddress_list_u32_max_2048_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmos_mac_address) * len);
    if (!bcmolt_buf_skip(packed, len * 6))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_macaddress_list_u32_max_2048_bounds_check(const bcmolt_macaddress_list_u32_max_2048 *this)
{
    if (this->len > 2048)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_nni_link_status_set_default(bcmolt_nni_link_status *this)
{
    this->link_status = BCMOLT_TRIVALENT_FALSE;
    this->signal_detected = BCMOLT_TRIVALENT_FALSE;
    this->pmd_locked = BCMOLT_TRIVALENT_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_link_status_pack(const bcmolt_nni_link_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_trivalent_pack(this->link_status, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_trivalent_pack(this->signal_detected, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_trivalent_pack(this->pmd_locked, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_link_status_unpack(bcmolt_nni_link_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_trivalent_unpack(&this->link_status, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_trivalent_unpack(&this->signal_detected, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_trivalent_unpack(&this->pmd_locked, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_nni_link_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_nni_link_status_bounds_check(const bcmolt_nni_link_status *this)
{
    switch (this->link_status)
    {
        case BCMOLT_TRIVALENT_FALSE:
            break;
        case BCMOLT_TRIVALENT_TRUE:
            break;
        case BCMOLT_TRIVALENT_NOT_APPLICABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->signal_detected)
    {
        case BCMOLT_TRIVALENT_FALSE:
            break;
        case BCMOLT_TRIVALENT_TRUE:
            break;
        case BCMOLT_TRIVALENT_NOT_APPLICABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->pmd_locked)
    {
        case BCMOLT_TRIVALENT_FALSE:
            break;
        case BCMOLT_TRIVALENT_TRUE:
            break;
        case BCMOLT_TRIVALENT_NOT_APPLICABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_oam_heartbeat_config_set_default(bcmolt_oam_heartbeat_config *this)
{
    this->send_period = 0;
    this->transmit_frame.len = 0;
    this->transmit_frame.val = NULL;
    this->ignored_receive_frame_template.frame_octets.len = 0;
    this->ignored_receive_frame_template.frame_octets.val = NULL;
    this->ignored_receive_frame_template.mask_octets.len = 0;
    this->ignored_receive_frame_template.mask_octets.val = NULL;
    this->receive_timeout = 1;
    this->maximum_receive_size = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_oam_heartbeat_config_pack(const bcmolt_oam_heartbeat_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->send_period))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_u8_list_u16_pack(&this->transmit_frame, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ethernet_frame_masked_pack(&this->ignored_receive_frame_template, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->receive_timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->maximum_receive_size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_oam_heartbeat_config_get_packed_length(const bcmolt_oam_heartbeat_config *this)
{
    return 6 + bcmolt_u8_list_u16_get_packed_length(&this->transmit_frame) + bcmolt_ethernet_frame_masked_get_packed_length(&this->ignored_receive_frame_template);
}

/******************************************************************************/
bcmos_bool bcmolt_oam_heartbeat_config_unpack(bcmolt_oam_heartbeat_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->send_period))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_u8_list_u16_unpack(&this->transmit_frame, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ethernet_frame_masked_unpack(&this->ignored_receive_frame_template, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->receive_timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->maximum_receive_size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_oam_heartbeat_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    if (!bcmolt_buf_skip(packed, 2))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_u8_list_u16_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ethernet_frame_masked_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_skip(packed, 2))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_skip(packed, 2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_oam_heartbeat_config_bounds_check(const bcmolt_oam_heartbeat_config *this)
{
    if (!bcmolt_u8_list_u16_bounds_check(&this->transmit_frame))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_ethernet_frame_masked_bounds_check(&this->ignored_receive_frame_template))
    {
        return BCMOS_FALSE;
    }

    if (this->receive_timeout < 1)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_onu_power_management_configuration_set_default(bcmolt_onu_power_management_configuration *this)
{
    this->ilowpower = 1600;
    this->iaware = 160;
    this->itransinit = 80;
    this->itxinit = 40;
    this->irxoff = 1600;
    this->low_power_clobi = 8;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_power_management_configuration_pack(const bcmolt_onu_power_management_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->ilowpower))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->iaware))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->itransinit))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->itxinit))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->irxoff))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->low_power_clobi))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_power_management_configuration_unpack(bcmolt_onu_power_management_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->ilowpower))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->iaware))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->itransinit))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->itxinit))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->irxoff))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->low_power_clobi))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_power_management_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 18);
}

/******************************************************************************/
bcmos_bool bcmolt_onu_power_management_configuration_bounds_check(const bcmolt_onu_power_management_configuration *this)
{
    if (this->ilowpower < 8)
    {
        return BCMOS_FALSE;
    }

    if (this->ilowpower > 480000UL)
    {
        return BCMOS_FALSE;
    }

    if (this->iaware < 8)
    {
        return BCMOS_FALSE;
    }

    if (this->iaware > 480000UL)
    {
        return BCMOS_FALSE;
    }

    if (this->itransinit > 8000)
    {
        return BCMOS_FALSE;
    }

    if (this->itxinit > 8000)
    {
        return BCMOS_FALSE;
    }

    if (this->irxoff < 8)
    {
        return BCMOS_FALSE;
    }

    if (this->irxoff > 480000UL)
    {
        return BCMOS_FALSE;
    }

    if (this->low_power_clobi < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->low_power_clobi > 1023)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_onu_tuning_configuration_set_default(bcmolt_onu_tuning_configuration *this)
{
    this->tsource = 1000;
    this->ttarget = 1000;
    this->request_registration_required = BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_tuning_configuration_pack(const bcmolt_onu_tuning_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->tsource))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->ttarget))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->request_registration_required))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_tuning_configuration_unpack(bcmolt_onu_tuning_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->tsource))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->ttarget))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->request_registration_required))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_onu_tuning_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 9);
}

/******************************************************************************/
bcmos_bool bcmolt_onu_tuning_configuration_bounds_check(const bcmolt_onu_tuning_configuration *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_id_set_default(bcmolt_pon_id *this)
{
    this->administrative_label = 0;
    this->dwlch_id = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_id_pack(const bcmolt_pon_id *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->administrative_label))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->dwlch_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_id_unpack(bcmolt_pon_id *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->administrative_label))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->dwlch_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_id_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_id_bounds_check(const bcmolt_pon_id *this)
{
    if (this->administrative_label > 4294967280UL)
    {
        return BCMOS_FALSE;
    }

    if (this->dwlch_id > 7)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_operation_control_set_default(bcmolt_operation_control *this)
{
    this->re = 0;
    this->odn_class = BCMOLT_ODN_CLASS_N1;
    this->ds_fec_mode = BCMOLT_CONTROL_STATE_ENABLE;
    this->protocol = BCMOLT_TC_PROTOCOL_TC_LAYER_PROTOCOL_G_989_P_3;
    this->ds_link_type = BCMOLT_LINK_TYPE_UNSPECIFIED;
    this->pon_id.administrative_label = 0;
    this->pon_id.dwlch_id = 0;
    this->c = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_operation_control_pack(const bcmolt_operation_control *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->re))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_odn_class_pack(this->odn_class, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->ds_fec_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_tc_protocol_pack(this->protocol, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_link_type_pack(this->ds_link_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_pon_id_pack(&this->pon_id, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->c))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_operation_control_unpack(bcmolt_operation_control *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->re))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_odn_class_unpack(&this->odn_class, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->ds_fec_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_tc_protocol_unpack(&this->protocol, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_link_type_unpack(&this->ds_link_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_pon_id_unpack(&this->pon_id, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->c))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_operation_control_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 11);
}

/******************************************************************************/
bcmos_bool bcmolt_operation_control_bounds_check(const bcmolt_operation_control *this)
{
    if (this->re > 1)
    {
        return BCMOS_FALSE;
    }

    switch (this->odn_class)
    {
        case BCMOLT_ODN_CLASS_N1:
            break;
        case BCMOLT_ODN_CLASS_N2:
            break;
        case BCMOLT_ODN_CLASS_E1:
            break;
        case BCMOLT_ODN_CLASS_E2:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->ds_fec_mode)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->protocol)
    {
        case BCMOLT_TC_PROTOCOL_TC_LAYER_PROTOCOL_G_987_P_3:
            break;
        case BCMOLT_TC_PROTOCOL_TC_LAYER_PROTOCOL_G_989_P_3:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->ds_link_type)
    {
        case BCMOLT_LINK_TYPE_UNSPECIFIED:
            break;
        case BCMOLT_LINK_TYPE_B:
            break;
        case BCMOLT_LINK_TYPE_A:
            break;
        case BCMOLT_LINK_TYPE_A_AND_B:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (!bcmolt_pon_id_bounds_check(&this->pon_id))
    {
        return BCMOS_FALSE;
    }

    if (this->c > 1)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_periodic_standby_pon_monitoring_set_default(bcmolt_periodic_standby_pon_monitoring *this)
{
    this->interval = 5000;
    this->control = BCMOLT_CONTROL_STATE_DISABLE;
}

/******************************************************************************/
bcmos_bool bcmolt_periodic_standby_pon_monitoring_pack(const bcmolt_periodic_standby_pon_monitoring *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->control, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_periodic_standby_pon_monitoring_unpack(bcmolt_periodic_standby_pon_monitoring *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->control, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_periodic_standby_pon_monitoring_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_periodic_standby_pon_monitoring_bounds_check(const bcmolt_periodic_standby_pon_monitoring *this)
{
    if (this->interval < 1000)
    {
        return BCMOS_FALSE;
    }

    switch (this->control)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_aggregate_shaper_set_default(bcmolt_pon_aggregate_shaper *this)
{
    this->bandwidth_kbps = 0;
    this->mbs_kB = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_aggregate_shaper_pack(const bcmolt_pon_aggregate_shaper *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->bandwidth_kbps))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->mbs_kB))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_aggregate_shaper_unpack(bcmolt_pon_aggregate_shaper *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->bandwidth_kbps))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->mbs_kB))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_aggregate_shaper_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_aggregate_shaper_bounds_check(const bcmolt_pon_aggregate_shaper *this)
{
    if (this->mbs_kB > 4000)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_alloc_sla_set_default(bcmolt_pon_alloc_sla *this)
{
    this->cbr_rt_bw = 0;
    this->cbr_nrt_bw = 0;
    this->guaranteed_bw = 0;
    this->maximum_bw = 0;
    this->additional_bw_eligibility = BCMOLT_ADDITIONAL_BW_ELIGIBILITY_NONE;
    this->cbr_rt_compensation = BCMOS_FALSE;
    this->cbr_rt_ap_index = 0;
    this->cbr_nrt_ap_index = 0;
    this->alloc_type = BCMOLT_ALLOC_TYPE_NONE;
    this->weight = 0;
    this->priority = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_alloc_sla_pack(const bcmolt_pon_alloc_sla *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->cbr_rt_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->cbr_nrt_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->guaranteed_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->maximum_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_additional_bw_eligibility_pack(this->additional_bw_eligibility, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->cbr_rt_compensation))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->cbr_rt_ap_index))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->cbr_nrt_ap_index))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_alloc_type_pack(this->alloc_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->weight))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->priority))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_alloc_sla_unpack(bcmolt_pon_alloc_sla *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->cbr_rt_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->cbr_nrt_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->guaranteed_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->maximum_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_additional_bw_eligibility_unpack(&this->additional_bw_eligibility, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->cbr_rt_compensation))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->cbr_rt_ap_index))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->cbr_nrt_ap_index))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_alloc_type_unpack(&this->alloc_type, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->weight))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->priority))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_alloc_sla_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 23);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_alloc_sla_bounds_check(const bcmolt_pon_alloc_sla *this)
{
    switch (this->additional_bw_eligibility)
    {
        case BCMOLT_ADDITIONAL_BW_ELIGIBILITY_NONE:
            break;
        case BCMOLT_ADDITIONAL_BW_ELIGIBILITY_NON_ASSURED:
            break;
        case BCMOLT_ADDITIONAL_BW_ELIGIBILITY_BEST_EFFORT:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->cbr_rt_ap_index > 0)
    {
        return BCMOS_FALSE;
    }

    if (this->cbr_nrt_ap_index > 1)
    {
        return BCMOS_FALSE;
    }

    switch (this->alloc_type)
    {
        case BCMOLT_ALLOC_TYPE_NONE:
            break;
        case BCMOLT_ALLOC_TYPE_NSR:
            break;
        case BCMOLT_ALLOC_TYPE_SR:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->weight > 100)
    {
        return BCMOS_FALSE;
    }

    if (this->priority > 7)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_available_bandwidth_set_default(bcmolt_pon_available_bandwidth *this)
{
    this->cbr_bw = 0;
    this->total_bw = 0;
    this->next_onu_total_bw = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_available_bandwidth_pack(const bcmolt_pon_available_bandwidth *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->cbr_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->total_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->next_onu_total_bw))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_available_bandwidth_unpack(bcmolt_pon_available_bandwidth *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->cbr_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->total_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->next_onu_total_bw))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_available_bandwidth_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 12);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_available_bandwidth_bounds_check(const bcmolt_pon_available_bandwidth *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_dba_set_default(bcmolt_pon_dba *this)
{
    this->sr_reporting_block_size = 48;
    this->dba_mode = BCMOLT_DBA_MODE_NORMAL;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_dba_pack(const bcmolt_pon_dba *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->sr_reporting_block_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_dba_mode_pack(this->dba_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_dba_unpack(bcmolt_pon_dba *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->sr_reporting_block_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_dba_mode_unpack(&this->dba_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_dba_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_dba_bounds_check(const bcmolt_pon_dba *this)
{
    switch (this->dba_mode)
    {
        case BCMOLT_DBA_MODE_NORMAL:
            break;
        case BCMOLT_DBA_MODE_EXTENDED:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_distance_set_default(bcmolt_pon_distance *this)
{
    this->max_log_distance = 20;
    this->max_diff_reach = 20;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_distance_pack(const bcmolt_pon_distance *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->max_log_distance))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->max_diff_reach))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_distance_unpack(bcmolt_pon_distance *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->max_log_distance))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->max_diff_reach))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_distance_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_distance_bounds_check(const bcmolt_pon_distance *this)
{
    if (this->max_log_distance < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->max_log_distance > 100)
    {
        return BCMOS_FALSE;
    }

    if (this->max_diff_reach < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->max_diff_reach > 60)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_drift_control_set_default(bcmolt_pon_drift_control *this)
{
    this->drift_interval = 1000;
    this->drift_limit = 4;
    this->transmission_control_limit = 8;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_drift_control_pack(const bcmolt_pon_drift_control *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->drift_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->drift_limit))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->transmission_control_limit))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_drift_control_unpack(bcmolt_pon_drift_control *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->drift_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->drift_limit))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->transmission_control_limit))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_drift_control_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 6);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_drift_control_bounds_check(const bcmolt_pon_drift_control *this)
{
    if (this->drift_interval > 60000UL)
    {
        return BCMOS_FALSE;
    }

    if (this->drift_limit < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->drift_limit > 32)
    {
        return BCMOS_FALSE;
    }

    if (this->transmission_control_limit < 1)
    {
        return BCMOS_FALSE;
    }

    if (this->transmission_control_limit > 64)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_onu_id_list_u32_set_default(bcmolt_pon_onu_id_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_onu_id_list_u32_pack(const bcmolt_pon_onu_id_list_u32 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_pon_onu_id_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_write_u16(buf, (uint16_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_pon_onu_id_list_u32_get_packed_length(const bcmolt_pon_onu_id_list_u32 *this)
{
    return 4 + (2 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_onu_id_list_u32_unpack(bcmolt_pon_onu_id_list_u32 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_pon_onu_id_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_pon_onu_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_pon_onu_id));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_onu_id_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_pon_onu_id) * len);
    if (!bcmolt_buf_skip(packed, len * 2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_onu_id_list_u32_bounds_check(const bcmolt_pon_onu_id_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_power_level_set_default(bcmolt_pon_power_level *this)
{
    this->pls_maximum_allocation_size = 120;
    this->mode = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_power_level_pack(const bcmolt_pon_power_level *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->pls_maximum_allocation_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->mode))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_power_level_unpack(bcmolt_pon_power_level *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->pls_maximum_allocation_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->mode))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_power_level_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_power_level_bounds_check(const bcmolt_pon_power_level *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_protection_switching_set_default(bcmolt_pon_protection_switching *this)
{
    this->timeout = 100;
    this->gpio_pin = BCMOLT_GPIO_PIN_UNCONFIGURED;
    this->options = (bcmolt_pon_protection_switching_options) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_protection_switching_pack(const bcmolt_pon_protection_switching *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_pin_pack(this->gpio_pin, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_pon_protection_switching_options_pack(this->options, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_protection_switching_unpack(bcmolt_pon_protection_switching *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_pin_unpack(&this->gpio_pin, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_pon_protection_switching_options_unpack(&this->options, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_protection_switching_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 7);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_protection_switching_bounds_check(const bcmolt_pon_protection_switching *this)
{
    switch (this->gpio_pin)
    {
        case BCMOLT_GPIO_PIN_PIN0:
            break;
        case BCMOLT_GPIO_PIN_PIN1:
            break;
        case BCMOLT_GPIO_PIN_PIN2:
            break;
        case BCMOLT_GPIO_PIN_PIN3:
            break;
        case BCMOLT_GPIO_PIN_PIN4:
            break;
        case BCMOLT_GPIO_PIN_PIN5:
            break;
        case BCMOLT_GPIO_PIN_PIN6:
            break;
        case BCMOLT_GPIO_PIN_PIN7:
            break;
        case BCMOLT_GPIO_PIN_PIN8:
            break;
        case BCMOLT_GPIO_PIN_PIN9:
            break;
        case BCMOLT_GPIO_PIN_PIN10:
            break;
        case BCMOLT_GPIO_PIN_PIN11:
            break;
        case BCMOLT_GPIO_PIN_PIN12:
            break;
        case BCMOLT_GPIO_PIN_PIN13:
            break;
        case BCMOLT_GPIO_PIN_PIN14:
            break;
        case BCMOLT_GPIO_PIN_PIN15:
            break;
        case BCMOLT_GPIO_PIN_PIN16:
            break;
        case BCMOLT_GPIO_PIN_PIN17:
            break;
        case BCMOLT_GPIO_PIN_PIN18:
            break;
        case BCMOLT_GPIO_PIN_PIN19:
            break;
        case BCMOLT_GPIO_PIN_PIN20:
            break;
        case BCMOLT_GPIO_PIN_PIN21:
            break;
        case BCMOLT_GPIO_PIN_PIN22:
            break;
        case BCMOLT_GPIO_PIN_PIN23:
            break;
        case BCMOLT_GPIO_PIN_PIN24:
            break;
        case BCMOLT_GPIO_PIN_PIN25:
            break;
        case BCMOLT_GPIO_PIN_PIN26:
            break;
        case BCMOLT_GPIO_PIN_PIN27:
            break;
        case BCMOLT_GPIO_PIN_PIN28:
            break;
        case BCMOLT_GPIO_PIN_PIN29:
            break;
        case BCMOLT_GPIO_PIN_PIN30:
            break;
        case BCMOLT_GPIO_PIN_PIN31:
            break;
        case BCMOLT_GPIO_PIN_PIN32:
            break;
        case BCMOLT_GPIO_PIN_PIN33:
            break;
        case BCMOLT_GPIO_PIN_PIN34:
            break;
        case BCMOLT_GPIO_PIN_PIN35:
            break;
        case BCMOLT_GPIO_PIN_PIN36:
            break;
        case BCMOLT_GPIO_PIN_PIN37:
            break;
        case BCMOLT_GPIO_PIN_PIN38:
            break;
        case BCMOLT_GPIO_PIN_PIN39:
            break;
        case BCMOLT_GPIO_PIN_PIN40:
            break;
        case BCMOLT_GPIO_PIN_PIN41:
            break;
        case BCMOLT_GPIO_PIN_PIN42:
            break;
        case BCMOLT_GPIO_PIN_PIN43:
            break;
        case BCMOLT_GPIO_PIN_PIN44:
            break;
        case BCMOLT_GPIO_PIN_PIN45:
            break;
        case BCMOLT_GPIO_PIN_PIN46:
            break;
        case BCMOLT_GPIO_PIN_PIN47:
            break;
        case BCMOLT_GPIO_PIN_PIN48:
            break;
        case BCMOLT_GPIO_PIN_PIN49:
            break;
        case BCMOLT_GPIO_PIN_PIN50:
            break;
        case BCMOLT_GPIO_PIN_PIN51:
            break;
        case BCMOLT_GPIO_PIN_PIN52:
            break;
        case BCMOLT_GPIO_PIN_PIN53:
            break;
        case BCMOLT_GPIO_PIN_PIN54:
            break;
        case BCMOLT_GPIO_PIN_PIN55:
            break;
        case BCMOLT_GPIO_PIN_PIN56:
            break;
        case BCMOLT_GPIO_PIN_PIN57:
            break;
        case BCMOLT_GPIO_PIN_PIN58:
            break;
        case BCMOLT_GPIO_PIN_PIN59:
            break;
        case BCMOLT_GPIO_PIN_PIN60:
            break;
        case BCMOLT_GPIO_PIN_PIN61:
            break;
        case BCMOLT_GPIO_PIN_PIN62:
            break;
        case BCMOLT_GPIO_PIN_PIN63:
            break;
        case BCMOLT_GPIO_PIN_PIN64:
            break;
        case BCMOLT_GPIO_PIN_PIN65:
            break;
        case BCMOLT_GPIO_PIN_PIN66:
            break;
        case BCMOLT_GPIO_PIN_PIN67:
            break;
        case BCMOLT_GPIO_PIN_PIN68:
            break;
        case BCMOLT_GPIO_PIN_PIN69:
            break;
        case BCMOLT_GPIO_PIN_PIN70:
            break;
        case BCMOLT_GPIO_PIN_PIN71:
            break;
        case BCMOLT_GPIO_PIN_PIN72:
            break;
        case BCMOLT_GPIO_PIN_PIN73:
            break;
        case BCMOLT_GPIO_PIN_PIN74:
            break;
        case BCMOLT_GPIO_PIN_PIN75:
            break;
        case BCMOLT_GPIO_PIN_PIN76:
            break;
        case BCMOLT_GPIO_PIN_PIN77:
            break;
        case BCMOLT_GPIO_PIN_PIN78:
            break;
        case BCMOLT_GPIO_PIN_PIN79:
            break;
        case BCMOLT_GPIO_PIN_PIN80:
            break;
        case BCMOLT_GPIO_PIN_PIN81:
            break;
        case BCMOLT_GPIO_PIN_PIN82:
            break;
        case BCMOLT_GPIO_PIN_PIN83:
            break;
        case BCMOLT_GPIO_PIN_PIN84:
            break;
        case BCMOLT_GPIO_PIN_PIN85:
            break;
        case BCMOLT_GPIO_PIN_PIN86:
            break;
        case BCMOLT_GPIO_PIN_PIN87:
            break;
        case BCMOLT_GPIO_PIN_PIN88:
            break;
        case BCMOLT_GPIO_PIN_PIN89:
            break;
        case BCMOLT_GPIO_PIN_PIN90:
            break;
        case BCMOLT_GPIO_PIN_PIN91:
            break;
        case BCMOLT_GPIO_PIN_PIN92:
            break;
        case BCMOLT_GPIO_PIN_PIN93:
            break;
        case BCMOLT_GPIO_PIN_PIN94:
            break;
        case BCMOLT_GPIO_PIN_PIN95:
            break;
        case BCMOLT_GPIO_PIN_PIN96:
            break;
        case BCMOLT_GPIO_PIN_PIN97:
            break;
        case BCMOLT_GPIO_PIN_PIN98:
            break;
        case BCMOLT_GPIO_PIN_PIN99:
            break;
        case BCMOLT_GPIO_PIN_PIN100:
            break;
        case BCMOLT_GPIO_PIN_PIN101:
            break;
        case BCMOLT_GPIO_PIN_PIN102:
            break;
        case BCMOLT_GPIO_PIN_PIN103:
            break;
        case BCMOLT_GPIO_PIN_PIN104:
            break;
        case BCMOLT_GPIO_PIN_PIN105:
            break;
        case BCMOLT_GPIO_PIN_PIN106:
            break;
        case BCMOLT_GPIO_PIN_UNCONFIGURED:
            break;
        default:
            return BCMOS_FALSE;
    }

    if ((this->options & 0xFFFFFFFCUL) != 0)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_pon_status_set_default(bcmolt_pon_status *this)
{
    this->state = BCMOLT_PON_STATE_INACTIVE;
    this->los_status = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_status_pack(const bcmolt_pon_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_pon_state_pack(this->state, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->los_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_status_unpack(bcmolt_pon_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_pon_state_unpack(&this->state, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->los_status, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_pon_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_pon_status_bounds_check(const bcmolt_pon_status *this)
{
    switch (this->state)
    {
        case BCMOLT_PON_STATE_INACTIVE:
            break;
        case BCMOLT_PON_STATE_PROCESSING:
            break;
        case BCMOLT_PON_STATE_ACTIVE_WORKING:
            break;
        case BCMOLT_PON_STATE_ACTIVE_STANDBY:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->los_status)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_prbs_checker_config_set_default(bcmolt_prbs_checker_config *this)
{
    this->polynom = BCMOLT_PRBS_POLYNOMIAL_PRBS_7;
    this->mode = BCMOLT_PRBS_CHECKER_MODE_SELF_SYNC;
    this->data_invert = BCMOS_FALSE;
    this->control = BCMOLT_CONTROL_STATE_DISABLE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_checker_config_pack(const bcmolt_prbs_checker_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_prbs_polynomial_pack(this->polynom, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_prbs_checker_mode_pack(this->mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->data_invert))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->control, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_checker_config_unpack(bcmolt_prbs_checker_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_prbs_polynomial_unpack(&this->polynom, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_prbs_checker_mode_unpack(&this->mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->data_invert))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->control, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_checker_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_checker_config_bounds_check(const bcmolt_prbs_checker_config *this)
{
    switch (this->polynom)
    {
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_7:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_9:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_11:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_15:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_23:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_31:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_58:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->mode)
    {
        case BCMOLT_PRBS_CHECKER_MODE_SELF_SYNC:
            break;
        case BCMOLT_PRBS_CHECKER_MODE_INITIAL_SEED_MODE:
            break;
        case BCMOLT_PRBS_CHECKER_MODE_INITIAL_SEED_MODE_2:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->control)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_prbs_generator_config_set_default(bcmolt_prbs_generator_config *this)
{
    this->polynom = BCMOLT_PRBS_POLYNOMIAL_PRBS_7;
    this->error_insert = BCMOS_FALSE;
    this->invert = BCMOS_FALSE;
    this->control = BCMOLT_CONTROL_STATE_DISABLE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_generator_config_pack(const bcmolt_prbs_generator_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_prbs_polynomial_pack(this->polynom, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->error_insert))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->invert))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->control, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_generator_config_unpack(bcmolt_prbs_generator_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_prbs_polynomial_unpack(&this->polynom, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->error_insert))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->invert))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->control, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_generator_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_generator_config_bounds_check(const bcmolt_prbs_generator_config *this)
{
    switch (this->polynom)
    {
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_7:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_9:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_11:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_15:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_23:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_31:
            break;
        case BCMOLT_PRBS_POLYNOMIAL_PRBS_58:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->control)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_prbs_status_set_default(bcmolt_prbs_status *this)
{
    this->lock_state = BCMOLT_PRBS_LOCK_STATE_UNLOCKED;
    this->error_counts = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_status_pack(const bcmolt_prbs_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_prbs_lock_state_pack(this->lock_state, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->error_counts))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_status_unpack(bcmolt_prbs_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_prbs_lock_state_unpack(&this->lock_state, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->error_counts))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_prbs_status_bounds_check(const bcmolt_prbs_status *this)
{
    switch (this->lock_state)
    {
        case BCMOLT_PRBS_LOCK_STATE_UNLOCKED:
            break;
        case BCMOLT_PRBS_LOCK_STATE_LOCKED:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ranging_control_configuration_set_default(bcmolt_ranging_control_configuration *this)
{
    this->wait_state_1_window_size = 0;
    this->wait_state_2_window_size = 0;
    this->wait_after_resync_4 = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_control_configuration_pack(const bcmolt_ranging_control_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->wait_state_1_window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->wait_state_2_window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->wait_after_resync_4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_control_configuration_unpack(bcmolt_ranging_control_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->wait_state_1_window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->wait_state_2_window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->wait_after_resync_4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_control_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_control_configuration_bounds_check(const bcmolt_ranging_control_configuration *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ranging_resync_conditions_set_default(bcmolt_ranging_resync_conditions *this)
{
    this->after_init = BCMOS_FALSE;
    this->after_no_ed = BCMOS_FALSE;
    this->after_ed = BCMOS_FALSE;
    this->after_no_del = BCMOS_FALSE;
    this->after_ranging_access = BCMOS_FALSE;
    this->med_val = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_resync_conditions_pack(const bcmolt_ranging_resync_conditions *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_bool(buf, this->after_init))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->after_no_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->after_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->after_no_del))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->after_ranging_access))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->med_val))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_resync_conditions_unpack(bcmolt_ranging_resync_conditions *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_bool(buf, &this->after_init))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->after_no_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->after_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->after_no_del))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->after_ranging_access))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->med_val))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_resync_conditions_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 7);
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_resync_conditions_bounds_check(const bcmolt_ranging_resync_conditions *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ranging_rssi_control_set_default(bcmolt_ranging_rssi_control *this)
{
    this->after_no_ed = BCMOS_FALSE;
    this->after_ed = BCMOS_FALSE;
    this->after_reset_3 = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_rssi_control_pack(const bcmolt_ranging_rssi_control *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_bool(buf, this->after_no_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->after_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->after_reset_3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_rssi_control_unpack(bcmolt_ranging_rssi_control *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_bool(buf, &this->after_no_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->after_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->after_reset_3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_rssi_control_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_ranging_rssi_control_bounds_check(const bcmolt_ranging_rssi_control *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_request_registration_status_set_default(bcmolt_request_registration_status *this)
{
    this->request_registration_state = BCMOLT_CONTROL_STATE_DISABLE;
    this->sma_flag = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_request_registration_status_pack(const bcmolt_request_registration_status *this, bcmolt_buf *buf)
{
    if (!bcmolt_control_state_pack(this->request_registration_state, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->sma_flag))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_request_registration_status_unpack(bcmolt_request_registration_status *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_control_state_unpack(&this->request_registration_state, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->sma_flag))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_request_registration_status_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_request_registration_status_bounds_check(const bcmolt_request_registration_status *this)
{
    switch (this->request_registration_state)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_rogue_detection_special_map_set_default(bcmolt_rogue_detection_special_map *this)
{
    this->plo_size = 0;
    this->alloc_id = (bcmolt_pon_alloc_id) 0;
    this->onu_id = (bcmolt_pon_onu_id) 0;
    this->access_size = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_special_map_pack(const bcmolt_rogue_detection_special_map *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->plo_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->alloc_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->access_size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_special_map_unpack(bcmolt_rogue_detection_special_map *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->plo_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->alloc_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->access_size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_special_map_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 9);
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_special_map_bounds_check(const bcmolt_rogue_detection_special_map *this)
{
    if (this->alloc_id > (bcmolt_pon_alloc_id) 16383)
    {
        return BCMOS_FALSE;
    }

    if (this->onu_id > (bcmolt_pon_onu_id) 511)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_rogue_detection_special_map_list_u32_max_8_set_default(bcmolt_rogue_detection_special_map_list_u32_max_8 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_special_map_list_u32_max_8_pack(const bcmolt_rogue_detection_special_map_list_u32_max_8 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_rogue_detection_special_map_list_u32_max_8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 8)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_rogue_detection_special_map_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_rogue_detection_special_map_list_u32_max_8_get_packed_length(const bcmolt_rogue_detection_special_map_list_u32_max_8 *this)
{
    return 4 + (9 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_special_map_list_u32_max_8_unpack(bcmolt_rogue_detection_special_map_list_u32_max_8 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_rogue_detection_special_map_list_u32_max_8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_rogue_detection_special_map *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_rogue_detection_special_map));
        }
    }

    if (this->len > 8)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_rogue_detection_special_map_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_special_map_list_u32_max_8_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_rogue_detection_special_map) * len);
    if (!bcmolt_buf_skip(packed, len * 9))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_special_map_list_u32_max_8_bounds_check(const bcmolt_rogue_detection_special_map_list_u32_max_8 *this)
{
    if (this->len > 8)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_rogue_detection_algorithm_set_default(bcmolt_rogue_detection_algorithm *this)
{
    this->algorithm_type = (bcmolt_rogue_detection_algorithm_type) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_algorithm_pack(const bcmolt_rogue_detection_algorithm *this, bcmolt_buf *buf)
{
    if (!bcmolt_rogue_detection_algorithm_type_pack(this->algorithm_type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->algorithm_type)
    {
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EARLY_ROGUE_DETECTION:
            {
                if (!bcmolt_rogue_detection_window_pack(this->u.early_rogue_detection.measurement_type, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_write_u32(buf, this->u.early_rogue_detection.interval))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_write_bool(buf, this->u.early_rogue_detection.second_ranging_window))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_alloc_type_to_scan_pack(this->u.early_rogue_detection.alloc_type_to_scan, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_SPECIAL_MAP:
            {
                if (!bcmolt_rogue_detection_special_map_list_u32_max_8_pack(&this->u.special_map.accesses, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EXTENDED_GUARD_TIME:
            {
                if (!bcmolt_buf_write_u32(buf, this->u.extended_guard_time.additional_guard_time))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_rogue_detection_algorithm_get_packed_length(const bcmolt_rogue_detection_algorithm *this)
{
    uint32_t count = 1;
    switch (this->algorithm_type)
    {
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EARLY_ROGUE_DETECTION:
            {
                count += 7;
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_SPECIAL_MAP:
            {
                count += bcmolt_rogue_detection_special_map_list_u32_max_8_get_packed_length(&this->u.special_map.accesses);
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EXTENDED_GUARD_TIME:
            {
                count += 4;
            }
            break;
        default:
            break;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_algorithm_unpack(bcmolt_rogue_detection_algorithm *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_rogue_detection_algorithm_type_unpack(&this->algorithm_type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->algorithm_type)
    {
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EARLY_ROGUE_DETECTION:
            {
                if (!bcmolt_rogue_detection_window_unpack(&this->u.early_rogue_detection.measurement_type, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_read_u32(buf, &this->u.early_rogue_detection.interval))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_read_bool(buf, &this->u.early_rogue_detection.second_ranging_window))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_alloc_type_to_scan_unpack(&this->u.early_rogue_detection.alloc_type_to_scan, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_SPECIAL_MAP:
            {
                if (!bcmolt_rogue_detection_special_map_list_u32_max_8_unpack(&this->u.special_map.accesses, buf, extra_mem))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EXTENDED_GUARD_TIME:
            {
                if (!bcmolt_buf_read_u32(buf, &this->u.extended_guard_time.additional_guard_time))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_algorithm_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    bcmolt_rogue_detection_algorithm_type algorithm_type;
    if (!bcmolt_rogue_detection_algorithm_type_unpack(&algorithm_type, packed))
    {
        return BCMOS_FALSE;
    }

    switch (algorithm_type)
    {
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EARLY_ROGUE_DETECTION:
            {
                if (!bcmolt_buf_skip(packed, 1))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 1))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 1))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_SPECIAL_MAP:
            {
                if (!bcmolt_rogue_detection_special_map_list_u32_max_8_scan(packed, extra_mem))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EXTENDED_GUARD_TIME:
            {
                if (!bcmolt_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_detection_algorithm_bounds_check(const bcmolt_rogue_detection_algorithm *this)
{
    switch (this->algorithm_type)
    {
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EARLY_ROGUE_DETECTION:
            {
                switch (this->u.early_rogue_detection.measurement_type)
                {
                    case BCMOLT_ROGUE_DETECTION_WINDOW_SILENT_WINDOW:
                        break;
                    case BCMOLT_ROGUE_DETECTION_WINDOW_CUT_OFF_WINDOW:
                        break;
                    default:
                        return BCMOS_FALSE;
                }

                if (this->u.early_rogue_detection.interval < 1000)
                {
                    return BCMOS_FALSE;
                }

                if (this->u.early_rogue_detection.interval > 10000000UL)
                {
                    return BCMOS_FALSE;
                }

                switch (this->u.early_rogue_detection.alloc_type_to_scan)
                {
                    case BCMOLT_ALLOC_TYPE_TO_SCAN_UNUSED:
                        break;
                    case BCMOLT_ALLOC_TYPE_TO_SCAN_PREVIOUSLY_USED:
                        break;
                    case BCMOLT_ALLOC_TYPE_TO_SCAN_ALL:
                        break;
                    default:
                        return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_SPECIAL_MAP:
            {
                if (this->u.special_map.accesses.len > 8)
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_rogue_detection_special_map_list_u32_max_8_bounds_check(&this->u.special_map.accesses))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EXTENDED_GUARD_TIME:
            {
                if (this->u.extended_guard_time.additional_guard_time > 500)
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_rogue_onu_detection_process_set_default(bcmolt_rogue_onu_detection_process *this)
{
    this->control = BCMOLT_CONTROL_STATE_DISABLE;
    this->detection_algorithm.algorithm_type = BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EARLY_ROGUE_DETECTION;
    this->detection_algorithm.u.early_rogue_detection.measurement_type = BCMOLT_ROGUE_DETECTION_WINDOW_SILENT_WINDOW;
    this->detection_algorithm.u.early_rogue_detection.interval = 10000;
    this->detection_algorithm.u.early_rogue_detection.second_ranging_window = BCMOS_FALSE;
    this->detection_algorithm.u.early_rogue_detection.alloc_type_to_scan = BCMOLT_ALLOC_TYPE_TO_SCAN_ALL;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_onu_detection_process_pack(const bcmolt_rogue_onu_detection_process *this, bcmolt_buf *buf)
{
    if (!bcmolt_control_state_pack(this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_rogue_detection_algorithm_pack(&this->detection_algorithm, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_rogue_onu_detection_process_get_packed_length(const bcmolt_rogue_onu_detection_process *this)
{
    return 1 + bcmolt_rogue_detection_algorithm_get_packed_length(&this->detection_algorithm);
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_onu_detection_process_unpack(bcmolt_rogue_onu_detection_process *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_control_state_unpack(&this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_rogue_detection_algorithm_unpack(&this->detection_algorithm, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_onu_detection_process_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    if (!bcmolt_buf_skip(packed, 1))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_rogue_detection_algorithm_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_rogue_onu_detection_process_bounds_check(const bcmolt_rogue_onu_detection_process *this)
{
    switch (this->control)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (!bcmolt_rogue_detection_algorithm_bounds_check(&this->detection_algorithm))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_serdes_configuration_set_default(bcmolt_serdes_configuration *this)
{
    this->ranging_mode = BCMOLT_SERDES_RANGING_MODE_BCDR_RESET_MODE;
    this->multi_ed_mode = BCMOS_FALSE;
    this->burst_enable_start_offset = 0;
    this->burst_enable_end_offset = 0;
    this->ed_invertion = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_serdes_configuration_pack(const bcmolt_serdes_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_serdes_ranging_mode_pack(this->ranging_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->multi_ed_mode))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->burst_enable_start_offset))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->burst_enable_end_offset))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->ed_invertion))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_serdes_configuration_unpack(bcmolt_serdes_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_serdes_ranging_mode_unpack(&this->ranging_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->multi_ed_mode))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->burst_enable_start_offset))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->burst_enable_end_offset))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->ed_invertion))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_serdes_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 7);
}

/******************************************************************************/
bcmos_bool bcmolt_serdes_configuration_bounds_check(const bcmolt_serdes_configuration *this)
{
    switch (this->ranging_mode)
    {
        case BCMOLT_SERDES_RANGING_MODE_ED_MODE:
            break;
        case BCMOLT_SERDES_RANGING_MODE_BCDR_RESET_MODE:
            break;
        case BCMOLT_SERDES_RANGING_MODE_FAST_MODE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_serial_number_set_default(bcmolt_serial_number *this)
{
    memset(this->vendor_id, 0, sizeof(this->vendor_id));
    memset(this->vendor_specific, 0, sizeof(this->vendor_specific));
}

/******************************************************************************/
bcmos_bool bcmolt_serial_number_pack(const bcmolt_serial_number *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->vendor_id, 4))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->vendor_specific, 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_serial_number_unpack(bcmolt_serial_number *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->vendor_id, 4))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read(buf, this->vendor_specific, 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_serial_number_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_serial_number_bounds_check(const bcmolt_serial_number *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_solicited_scheduler_set_default(bcmolt_solicited_scheduler *this)
{
    this->bandwidth_Kbps = (bcmolt_bandwidth_Kbps) 0;
    this->max_burst_size_tq = (bcmolt_time_quanta) 0;
    this->priority = 0;
    this->weight_tq = (bcmolt_time_quanta) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_solicited_scheduler_pack(const bcmolt_solicited_scheduler *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->bandwidth_Kbps))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->max_burst_size_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->priority))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->weight_tq))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_solicited_scheduler_unpack(bcmolt_solicited_scheduler *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->bandwidth_Kbps))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->max_burst_size_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->priority))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->weight_tq))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_solicited_scheduler_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 13);
}

/******************************************************************************/
bcmos_bool bcmolt_solicited_scheduler_bounds_check(const bcmolt_solicited_scheduler *this)
{
    if (this->priority > 7)
    {
        return BCMOS_FALSE;
    }

    if (this->weight_tq > (bcmolt_time_quanta) 262106UL)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_stat_alarm_trigger_config_set_default(bcmolt_stat_alarm_trigger_config *this)
{
    this->type = (bcmolt_stat_condition_type) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_trigger_config_pack(const bcmolt_stat_alarm_trigger_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_stat_condition_type_pack(this->type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->type)
    {
        case BCMOLT_STAT_CONDITION_TYPE_RATE_THRESHOLD:
            {
                if (!bcmolt_buf_write_u64(buf, this->u.rate_threshold.rising))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_write_u64(buf, this->u.rate_threshold.falling))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_RATE_RANGE:
            {
                if (!bcmolt_buf_write_u64(buf, this->u.rate_range.upper))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_write_u64(buf, this->u.rate_range.lower))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_VALUE_THRESHOLD:
            {
                if (!bcmolt_buf_write_u64(buf, this->u.value_threshold.limit))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_NONE:
            {
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_stat_alarm_trigger_config_get_packed_length(const bcmolt_stat_alarm_trigger_config *this)
{
    uint32_t count = 1;
    switch (this->type)
    {
        case BCMOLT_STAT_CONDITION_TYPE_RATE_THRESHOLD:
            {
                count += 16;
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_RATE_RANGE:
            {
                count += 16;
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_VALUE_THRESHOLD:
            {
                count += 8;
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_NONE:
            {
            }
            break;
        default:
            break;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_trigger_config_unpack(bcmolt_stat_alarm_trigger_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_stat_condition_type_unpack(&this->type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->type)
    {
        case BCMOLT_STAT_CONDITION_TYPE_RATE_THRESHOLD:
            {
                if (!bcmolt_buf_read_u64(buf, &this->u.rate_threshold.rising))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_read_u64(buf, &this->u.rate_threshold.falling))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_RATE_RANGE:
            {
                if (!bcmolt_buf_read_u64(buf, &this->u.rate_range.upper))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_read_u64(buf, &this->u.rate_range.lower))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_VALUE_THRESHOLD:
            {
                if (!bcmolt_buf_read_u64(buf, &this->u.value_threshold.limit))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_NONE:
            {
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_trigger_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    bcmolt_stat_condition_type type;
    if (!bcmolt_stat_condition_type_unpack(&type, packed))
    {
        return BCMOS_FALSE;
    }

    switch (type)
    {
        case BCMOLT_STAT_CONDITION_TYPE_RATE_THRESHOLD:
            {
                if (!bcmolt_buf_skip(packed, 8))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 8))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_RATE_RANGE:
            {
                if (!bcmolt_buf_skip(packed, 8))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmolt_buf_skip(packed, 8))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_VALUE_THRESHOLD:
            {
                if (!bcmolt_buf_skip(packed, 8))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_NONE:
            {
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_trigger_config_bounds_check(const bcmolt_stat_alarm_trigger_config *this)
{
    switch (this->type)
    {
        case BCMOLT_STAT_CONDITION_TYPE_RATE_THRESHOLD:
            {
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_RATE_RANGE:
            {
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_VALUE_THRESHOLD:
            {
            }
            break;
        case BCMOLT_STAT_CONDITION_TYPE_NONE:
            {
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_stat_alarm_soak_config_set_default(bcmolt_stat_alarm_soak_config *this)
{
    this->active_soak_time = 0;
    this->clear_soak_time = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_soak_config_pack(const bcmolt_stat_alarm_soak_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->active_soak_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->clear_soak_time))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_soak_config_unpack(bcmolt_stat_alarm_soak_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->active_soak_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->clear_soak_time))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_soak_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_soak_config_bounds_check(const bcmolt_stat_alarm_soak_config *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_stat_alarm_config_set_default(bcmolt_stat_alarm_config *this)
{
    this->trigger.type = BCMOLT_STAT_CONDITION_TYPE_NONE;
    this->soak.active_soak_time = 0;
    this->soak.clear_soak_time = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_config_pack(const bcmolt_stat_alarm_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_stat_alarm_trigger_config_pack(&this->trigger, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_stat_alarm_soak_config_pack(&this->soak, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_stat_alarm_config_get_packed_length(const bcmolt_stat_alarm_config *this)
{
    return 8 + bcmolt_stat_alarm_trigger_config_get_packed_length(&this->trigger);
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_config_unpack(bcmolt_stat_alarm_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_stat_alarm_trigger_config_unpack(&this->trigger, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_stat_alarm_soak_config_unpack(&this->soak, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    if (!bcmolt_stat_alarm_trigger_config_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_skip(packed, 8))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_stat_alarm_config_bounds_check(const bcmolt_stat_alarm_config *this)
{
    if (!bcmolt_stat_alarm_trigger_config_bounds_check(&this->trigger))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_stat_alarm_soak_config_bounds_check(&this->soak))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_str_100_set_default(bcmolt_str_100 *this)
{
    memset(this->str, 0, 100);
}

/******************************************************************************/
bcmos_bool bcmolt_str_100_pack(const bcmolt_str_100 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->str, 100))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_100_unpack(bcmolt_str_100 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->str, 100))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_100_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 100);
}

/******************************************************************************/
bcmos_bool bcmolt_str_100_bounds_check(const bcmolt_str_100 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_str_1000_set_default(bcmolt_str_1000 *this)
{
    memset(this->str, 0, 1000);
}

/******************************************************************************/
bcmos_bool bcmolt_str_1000_pack(const bcmolt_str_1000 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->str, 1000))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_1000_unpack(bcmolt_str_1000 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->str, 1000))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_1000_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 1000);
}

/******************************************************************************/
bcmos_bool bcmolt_str_1000_bounds_check(const bcmolt_str_1000 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_str_2000_set_default(bcmolt_str_2000 *this)
{
    memset(this->str, 0, 2000);
}

/******************************************************************************/
bcmos_bool bcmolt_str_2000_pack(const bcmolt_str_2000 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->str, 2000))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_2000_unpack(bcmolt_str_2000 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->str, 2000))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_2000_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2000);
}

/******************************************************************************/
bcmos_bool bcmolt_str_2000_bounds_check(const bcmolt_str_2000 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_str_256_set_default(bcmolt_str_256 *this)
{
    memset(this->str, 0, 256);
}

/******************************************************************************/
bcmos_bool bcmolt_str_256_pack(const bcmolt_str_256 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->str, 256))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_256_unpack(bcmolt_str_256 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->str, 256))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_256_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 256);
}

/******************************************************************************/
bcmos_bool bcmolt_str_256_bounds_check(const bcmolt_str_256 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_str_64_set_default(bcmolt_str_64 *this)
{
    memset(this->str, 0, 64);
}

/******************************************************************************/
bcmos_bool bcmolt_str_64_pack(const bcmolt_str_64 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->str, 64))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_64_unpack(bcmolt_str_64 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->str, 64))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_str_64_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 64);
}

/******************************************************************************/
bcmos_bool bcmolt_str_64_bounds_check(const bcmolt_str_64 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_sw_error_set_default(bcmolt_sw_error *this)
{
    this->first_error_time_us = 0;
    this->last_error_time_us = 0;
    this->line_number = 0;
    this->error_counter = 0;
    this->instance = 0;
    memset(this->filename, 0, 64);
    memset(this->task_name, 0, 64);
}

/******************************************************************************/
bcmos_bool bcmolt_sw_error_pack(const bcmolt_sw_error *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u64(buf, this->first_error_time_us))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u64(buf, this->last_error_time_us))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->line_number))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->error_counter))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->instance))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->filename, 64))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->task_name, 64))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_sw_error_unpack(bcmolt_sw_error *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u64(buf, &this->first_error_time_us))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u64(buf, &this->last_error_time_us))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->line_number))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->error_counter))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->instance))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read(buf, this->filename, 64))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read(buf, this->task_name, 64))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_sw_error_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 156);
}

/******************************************************************************/
bcmos_bool bcmolt_sw_error_bounds_check(const bcmolt_sw_error *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_system_profile_set_default(bcmolt_system_profile *this)
{
    this->ng_2_sys_id = 0;
    this->version = 0;
    this->channel_spacing = 0;
    this->us_operating_wavelength_bands = BCMOLT_US_OPERATING_WAVELENGTH_BANDS_EXPANDED_SPECTRUM_WIDE_BAND;
    this->us_mse = 0;
    this->loose_calibration_bound = BCMOLT_CALIBRATION_RECORD_UNSPECIFIED;
    this->fsr = 0;
    this->twdm_channel_count = 8;
}

/******************************************************************************/
bcmos_bool bcmolt_system_profile_pack(const bcmolt_system_profile *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->ng_2_sys_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->version))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->channel_spacing))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_us_operating_wavelength_bands_pack(this->us_operating_wavelength_bands, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->us_mse))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_calibration_record_pack(this->loose_calibration_bound, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->fsr))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->twdm_channel_count))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_system_profile_unpack(bcmolt_system_profile *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->ng_2_sys_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->version))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->channel_spacing))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_us_operating_wavelength_bands_unpack(&this->us_operating_wavelength_bands, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->us_mse))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_calibration_record_unpack(&this->loose_calibration_bound, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->fsr))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->twdm_channel_count))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_system_profile_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 12);
}

/******************************************************************************/
bcmos_bool bcmolt_system_profile_bounds_check(const bcmolt_system_profile *this)
{
    if (this->ng_2_sys_id > 1048575UL)
    {
        return BCMOS_FALSE;
    }

    if (this->version > 15)
    {
        return BCMOS_FALSE;
    }

    switch (this->us_operating_wavelength_bands)
    {
        case BCMOLT_US_OPERATING_WAVELENGTH_BANDS_EXPANDED_SPECTRUM_WIDE_BAND:
            break;
        case BCMOLT_US_OPERATING_WAVELENGTH_BANDS_EXPANDED_SPECTRUM_REDUCED_BAND:
            break;
        case BCMOLT_US_OPERATING_WAVELENGTH_BANDS_EXPANDED_SPECTRUM_NARROW_BAND:
            break;
        case BCMOLT_US_OPERATING_WAVELENGTH_BANDS_SHARED_SPECTRUM_WIDE_BAND:
            break;
        case BCMOLT_US_OPERATING_WAVELENGTH_BANDS_SHARED_SPECTRUM_REDUCED_BAND:
            break;
        case BCMOLT_US_OPERATING_WAVELENGTH_BANDS_SHARED_SPECTRUM_NARROW_BAND:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->loose_calibration_bound)
    {
        case BCMOLT_CALIBRATION_RECORD_UNSPECIFIED:
            break;
        case BCMOLT_CALIBRATION_RECORD_UNCALIBRATED:
            break;
        case BCMOLT_CALIBRATION_RECORD_LOOSE:
            break;
        case BCMOLT_CALIBRATION_RECORD_SUFFICIENT:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->twdm_channel_count > 15)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_trx_delimiter_set_default(bcmolt_trx_delimiter *this)
{
    this->pattern[0] = 171;
    this->pattern[1] = 89;
    this->pattern[2] = 131;
    this->size = 3;
    this->window_size = 124;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_delimiter_pack(const bcmolt_trx_delimiter *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write(buf, this->pattern, 3))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->window_size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_delimiter_unpack(bcmolt_trx_delimiter *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read(buf, this->pattern, 3))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->window_size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_delimiter_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_delimiter_bounds_check(const bcmolt_trx_delimiter *this)
{
    if (this->window_size < 2)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_trx_energy_detect_set_default(bcmolt_trx_energy_detect *this)
{
    this->ranging_ed_source = BCMOLT_ENERGY_DETECT_SOURCE_TRX;
    this->delimiter_ed_source = BCMOLT_ENERGY_DETECT_SOURCE_TRX;
    this->minimum_threshold = 0;
    this->maximum_threshold = 41;
    this->ed_pattern = 170;
    this->ed_pattern_size = 0;
    this->window_size = 124;
    this->inversion = BCMOS_FALSE;
    this->no_ed_threshold = 127;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_energy_detect_pack(const bcmolt_trx_energy_detect *this, bcmolt_buf *buf)
{
    if (!bcmolt_energy_detect_source_pack(this->ranging_ed_source, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_energy_detect_source_pack(this->delimiter_ed_source, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->minimum_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->maximum_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->ed_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->ed_pattern_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->inversion))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->no_ed_threshold))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_energy_detect_unpack(bcmolt_trx_energy_detect *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_energy_detect_source_unpack(&this->ranging_ed_source, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_energy_detect_source_unpack(&this->delimiter_ed_source, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->minimum_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->maximum_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->ed_pattern))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->ed_pattern_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->inversion))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->no_ed_threshold))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_energy_detect_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 9);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_energy_detect_bounds_check(const bcmolt_trx_energy_detect *this)
{
    switch (this->ranging_ed_source)
    {
        case BCMOLT_ENERGY_DETECT_SOURCE_INTERNAL:
            break;
        case BCMOLT_ENERGY_DETECT_SOURCE_TRX:
            break;
        case BCMOLT_ENERGY_DETECT_SOURCE_BCDR:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->delimiter_ed_source)
    {
        case BCMOLT_ENERGY_DETECT_SOURCE_INTERNAL:
            break;
        case BCMOLT_ENERGY_DETECT_SOURCE_TRX:
            break;
        case BCMOLT_ENERGY_DETECT_SOURCE_BCDR:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->window_size < 2)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_trx_preamble_set_default(bcmolt_trx_preamble *this)
{
    this->type_1_size = 0;
    this->type_2_size = 0;
    this->type_3_pre_ranging_size = 50;
    this->type_3_post_ranging_size = 15;
    this->type_3_pattern = 170;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_preamble_pack(const bcmolt_trx_preamble *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->type_1_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->type_2_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->type_3_pre_ranging_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->type_3_post_ranging_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->type_3_pattern))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_preamble_unpack(bcmolt_trx_preamble *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->type_1_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->type_2_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->type_3_pre_ranging_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->type_3_post_ranging_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->type_3_pattern))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_preamble_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_preamble_bounds_check(const bcmolt_trx_preamble *this)
{
    if (this->type_3_post_ranging_size < 5)
    {
        return BCMOS_FALSE;
    }

    if (this->type_3_post_ranging_size > 120)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_trx_rx_configuration_set_default(bcmolt_trx_rx_configuration *this)
{
    this->wait_window_size = 0;
    this->ranging_access_window_size = 15;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_rx_configuration_pack(const bcmolt_trx_rx_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->wait_window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->ranging_access_window_size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_rx_configuration_unpack(bcmolt_trx_rx_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->wait_window_size))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->ranging_access_window_size))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_trx_rx_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_trx_rx_configuration_bounds_check(const bcmolt_trx_rx_configuration *this)
{
    if (this->ranging_access_window_size < 7)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_u32_list_u32_max_500_hex_set_default(bcmolt_u32_list_u32_max_500_hex *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_u32_list_u32_max_500_hex_pack(const bcmolt_u32_list_u32_max_500_hex *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u32_list_u32_max_500_hex\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 500)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_write_u32(buf, this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_u32_list_u32_max_500_hex_get_packed_length(const bcmolt_u32_list_u32_max_500_hex *this)
{
    return 4 + (4 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_u32_list_u32_max_500_hex_unpack(bcmolt_u32_list_u32_max_500_hex *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u32_list_u32_max_500_hex\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (uint32_t *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(uint32_t));
        }
    }

    if (this->len > 500)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_read_u32(buf, &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u32_list_u32_max_500_hex_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(uint32_t) * len);
    if (!bcmolt_buf_skip(packed, len * 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u32_list_u32_max_500_hex_bounds_check(const bcmolt_u32_list_u32_max_500_hex *this)
{
    if (this->len > 500)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_u8_list_u16_hex_set_default(bcmolt_u8_list_u16_hex *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u16_hex_pack(const bcmolt_u8_list_u16_hex *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u8_list_u16_hex\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_u8_list_u16_hex_get_packed_length(const bcmolt_u8_list_u16_hex *this)
{
    return 2 + this->len;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u16_hex_unpack(bcmolt_u8_list_u16_hex *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u8_list_u16_hex\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (uint8_t *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(uint8_t));
        }
    }

    if (!bcmolt_buf_read(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u16_hex_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(uint8_t) * len);
    if (!bcmolt_buf_skip(packed, len * 1))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u16_hex_bounds_check(const bcmolt_u8_list_u16_hex *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_u8_list_u32_set_default(bcmolt_u8_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u32_pack(const bcmolt_u8_list_u32 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u8_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_u8_list_u32_get_packed_length(const bcmolt_u8_list_u32 *this)
{
    return 4 + this->len;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u32_unpack(bcmolt_u8_list_u32 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u8_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (uint8_t *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(uint8_t));
        }
    }

    if (!bcmolt_buf_read(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(uint8_t) * len);
    if (!bcmolt_buf_skip(packed, len * 1))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u32_bounds_check(const bcmolt_u8_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_u8_list_u32_max_2048_set_default(bcmolt_u8_list_u32_max_2048 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u32_max_2048_pack(const bcmolt_u8_list_u32_max_2048 *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u8_list_u32_max_2048\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 2048)
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_u8_list_u32_max_2048_get_packed_length(const bcmolt_u8_list_u32_max_2048 *this)
{
    return 4 + this->len;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u32_max_2048_unpack(bcmolt_u8_list_u32_max_2048 *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_u8_list_u32_max_2048\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (uint8_t *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(uint8_t));
        }
    }

    if (this->len > 2048)
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u32_max_2048_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(uint8_t) * len);
    if (!bcmolt_buf_skip(packed, len * 1))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_u8_list_u32_max_2048_bounds_check(const bcmolt_u8_list_u32_max_2048 *this)
{
    if (this->len > 2048)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ubd_info_set_default(bcmolt_ubd_info *this)
{
    this->actual_polling_interval = 0;
    this->actual_grant_threshold_tq = (bcmolt_time_quanta) 0;
    this->actual_min_schedulershaper.actual_mbs_tq = (bcmolt_time_quanta) 0;
    this->actual_min_schedulershaper.actual_weight_tq = (bcmolt_time_quanta) 0;
    this->actual_max_schedulershaper.actual_mbs_tq = (bcmolt_time_quanta) 0;
    this->actual_max_schedulershaper.actual_weight_tq = (bcmolt_time_quanta) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_ubd_info_pack(const bcmolt_ubd_info *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->actual_polling_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->actual_grant_threshold_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_actual_schedulershaper_pack(&this->actual_min_schedulershaper, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_actual_schedulershaper_pack(&this->actual_max_schedulershaper, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ubd_info_unpack(bcmolt_ubd_info *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->actual_polling_interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->actual_grant_threshold_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_actual_schedulershaper_unpack(&this->actual_min_schedulershaper, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_actual_schedulershaper_unpack(&this->actual_max_schedulershaper, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ubd_info_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 22);
}

/******************************************************************************/
bcmos_bool bcmolt_ubd_info_bounds_check(const bcmolt_ubd_info *this)
{
    if (!bcmolt_actual_schedulershaper_bounds_check(&this->actual_min_schedulershaper))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_actual_schedulershaper_bounds_check(&this->actual_max_schedulershaper))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_upstream_bandwidth_distribution_set_default(bcmolt_upstream_bandwidth_distribution *this)
{
    this->polling_interval_us = BCMOLT_POLLING_INTERVAL_AUTOMATIC;
    this->grant_threshold_tq = (bcmolt_time_quanta) 0;
    this->min_schedulershaper.bandwidth_Kbps = (bcmolt_bandwidth_Kbps) 0;
    this->min_schedulershaper.max_burst_size_tq = (bcmolt_time_quanta) 0;
    this->min_schedulershaper.priority = 0;
    this->min_schedulershaper.weight_tq = (bcmolt_time_quanta) 0;
    this->max_schedulershaper.bandwidth_Kbps = (bcmolt_bandwidth_Kbps) 0;
    this->max_schedulershaper.max_burst_size_tq = (bcmolt_time_quanta) 0;
    this->max_schedulershaper.priority = 0;
    this->max_schedulershaper.weight_tq = (bcmolt_time_quanta) 0;
    this->tdm_grant_size_tq = (bcmolt_time_quanta) 0;
    this->tdm_grant_interval_us = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_upstream_bandwidth_distribution_pack(const bcmolt_upstream_bandwidth_distribution *this, bcmolt_buf *buf)
{
    if (!bcmolt_polling_interval_pack(this->polling_interval_us, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->grant_threshold_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_solicited_scheduler_pack(&this->min_schedulershaper, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_solicited_scheduler_pack(&this->max_schedulershaper, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, (uint32_t) this->tdm_grant_size_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->tdm_grant_interval_us))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_upstream_bandwidth_distribution_unpack(bcmolt_upstream_bandwidth_distribution *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_polling_interval_unpack(&this->polling_interval_us, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->grant_threshold_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_solicited_scheduler_unpack(&this->min_schedulershaper, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_solicited_scheduler_unpack(&this->max_schedulershaper, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, (uint32_t *) &this->tdm_grant_size_tq))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->tdm_grant_interval_us))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_upstream_bandwidth_distribution_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 42);
}

/******************************************************************************/
bcmos_bool bcmolt_upstream_bandwidth_distribution_bounds_check(const bcmolt_upstream_bandwidth_distribution *this)
{
    switch (this->polling_interval_us)
    {
        case BCMOLT_POLLING_INTERVAL_POLLING_DISABLED:
            break;
        case BCMOLT_POLLING_INTERVAL_US_500:
            break;
        case BCMOLT_POLLING_INTERVAL_MS_1:
            break;
        case BCMOLT_POLLING_INTERVAL_MS_2:
            break;
        case BCMOLT_POLLING_INTERVAL_MS_4:
            break;
        case BCMOLT_POLLING_INTERVAL_MS_8:
            break;
        case BCMOLT_POLLING_INTERVAL_MS_16:
            break;
        case BCMOLT_POLLING_INTERVAL_AUTOMATIC:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->grant_threshold_tq > (bcmolt_time_quanta) 65408UL)
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_solicited_scheduler_bounds_check(&this->min_schedulershaper))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_solicited_scheduler_bounds_check(&this->max_schedulershaper))
    {
        return BCMOS_FALSE;
    }

    if (this->tdm_grant_size_tq > (bcmolt_time_quanta) 65408UL)
    {
        return BCMOS_FALSE;
    }

    if (this->tdm_grant_interval_us > 50000UL)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_vlan_tag_set_default(bcmolt_vlan_tag *this)
{
    this->vlan_id = (bcmolt_vlan_id) 0;
    this->pbit = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_vlan_tag_pack(const bcmolt_vlan_tag *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->vlan_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->pbit))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_vlan_tag_unpack(bcmolt_vlan_tag *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->vlan_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->pbit))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_vlan_tag_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_vlan_tag_bounds_check(const bcmolt_vlan_tag *this)
{
    if (this->vlan_id > (bcmolt_vlan_id) 4095)
    {
        return BCMOS_FALSE;
    }

    if (this->pbit > 7)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_alloc_with_state_set_default(bcmolt_xgpon_alloc_with_state *this)
{
    this->alloc_id = (bcmolt_xgpon_alloc_id) 0;
    this->state = BCMOLT_ALLOC_STATE_NOT_CONFIGURED;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_with_state_pack(const bcmolt_xgpon_alloc_with_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->alloc_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_alloc_state_pack(this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_with_state_unpack(bcmolt_xgpon_alloc_with_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->alloc_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_alloc_state_unpack(&this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_with_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_with_state_bounds_check(const bcmolt_xgpon_alloc_with_state *this)
{
    if (this->alloc_id > (bcmolt_xgpon_alloc_id) 16383)
    {
        return BCMOS_FALSE;
    }

    switch (this->state)
    {
        case BCMOLT_ALLOC_STATE_NOT_CONFIGURED:
            break;
        case BCMOLT_ALLOC_STATE_INACTIVE:
            break;
        case BCMOLT_ALLOC_STATE_PROCESSING:
            break;
        case BCMOLT_ALLOC_STATE_ACTIVE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_alloc_with_state_list_u16_max_32_set_default(bcmolt_xgpon_alloc_with_state_list_u16_max_32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_with_state_list_u16_max_32_pack(const bcmolt_xgpon_alloc_with_state_list_u16_max_32 *this, bcmolt_buf *buf)
{
    uint16_t i0;
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_alloc_with_state_list_u16_max_32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 32)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_alloc_with_state_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_xgpon_alloc_with_state_list_u16_max_32_get_packed_length(const bcmolt_xgpon_alloc_with_state_list_u16_max_32 *this)
{
    return 2 + (3 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_with_state_list_u16_max_32_unpack(bcmolt_xgpon_alloc_with_state_list_u16_max_32 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_alloc_with_state_list_u16_max_32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_xgpon_alloc_with_state *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_xgpon_alloc_with_state));
        }
    }

    if (this->len > 32)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_alloc_with_state_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_with_state_list_u16_max_32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_xgpon_alloc_with_state) * len);
    if (!bcmolt_buf_skip(packed, len * 3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_alloc_with_state_list_u16_max_32_bounds_check(const bcmolt_xgpon_alloc_with_state_list_u16_max_32 *this)
{
    if (this->len > 32)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_ed_state_set_default(bcmolt_xgpon_ed_state *this)
{
    this->reset_on_ed_fail = BCMOS_FALSE;
    this->reset_on_ed_success = BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ed_state_pack(const bcmolt_xgpon_ed_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_bool(buf, this->reset_on_ed_fail))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->reset_on_ed_success))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ed_state_unpack(bcmolt_xgpon_ed_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_bool(buf, &this->reset_on_ed_fail))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->reset_on_ed_success))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ed_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ed_state_bounds_check(const bcmolt_xgpon_ed_state *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_gem_id_list_u8_max_16_set_default(bcmolt_xgpon_gem_id_list_u8_max_16 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_id_list_u8_max_16_pack(const bcmolt_xgpon_gem_id_list_u8_max_16 *this, bcmolt_buf *buf)
{
    uint8_t i0;
    if (!bcmolt_buf_write_u8(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_gem_id_list_u8_max_16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 16)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_write_u16(buf, (uint16_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_xgpon_gem_id_list_u8_max_16_get_packed_length(const bcmolt_xgpon_gem_id_list_u8_max_16 *this)
{
    return 1 + (2 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_id_list_u8_max_16_unpack(bcmolt_xgpon_gem_id_list_u8_max_16 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint8_t i0;
    if (!bcmolt_buf_read_u8(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_gem_id_list_u8_max_16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_xgpon_gem_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_xgpon_gem_id));
        }
    }

    if (this->len > 16)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_id_list_u8_max_16_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint8_t len;
    if (!bcmolt_buf_read_u8(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_xgpon_gem_id) * len);
    if (!bcmolt_buf_skip(packed, len * 2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_id_list_u8_max_16_bounds_check(const bcmolt_xgpon_gem_id_list_u8_max_16 *this)
{
    if (this->len > 16)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_gem_port_with_state_set_default(bcmolt_xgpon_gem_port_with_state *this)
{
    this->gem_id = (bcmolt_xgpon_gem_id) 0;
    this->state = BCMOLT_XGPON_GEM_PORT_STATE_NOT_CONFIGURED;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_pack(const bcmolt_xgpon_gem_port_with_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->gem_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_xgpon_gem_port_state_pack(this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_unpack(bcmolt_xgpon_gem_port_with_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->gem_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_xgpon_gem_port_state_unpack(&this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_bounds_check(const bcmolt_xgpon_gem_port_with_state *this)
{
    if (this->gem_id > (bcmolt_xgpon_gem_id) 65533U)
    {
        return BCMOS_FALSE;
    }

    switch (this->state)
    {
        case BCMOLT_XGPON_GEM_PORT_STATE_NOT_CONFIGURED:
            break;
        case BCMOLT_XGPON_GEM_PORT_STATE_INACTIVE:
            break;
        case BCMOLT_XGPON_GEM_PORT_STATE_ACTIVE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_gem_port_with_state_list_u16_max_128_set_default(bcmolt_xgpon_gem_port_with_state_list_u16_max_128 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_list_u16_max_128_pack(const bcmolt_xgpon_gem_port_with_state_list_u16_max_128 *this, bcmolt_buf *buf)
{
    uint16_t i0;
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_gem_port_with_state_list_u16_max_128\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 128)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_gem_port_with_state_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_xgpon_gem_port_with_state_list_u16_max_128_get_packed_length(const bcmolt_xgpon_gem_port_with_state_list_u16_max_128 *this)
{
    return 2 + (3 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_list_u16_max_128_unpack(bcmolt_xgpon_gem_port_with_state_list_u16_max_128 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_gem_port_with_state_list_u16_max_128\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_xgpon_gem_port_with_state *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_xgpon_gem_port_with_state));
        }
    }

    if (this->len > 128)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_gem_port_with_state_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_list_u16_max_128_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_xgpon_gem_port_with_state) * len);
    if (!bcmolt_buf_skip(packed, len * 3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_list_u16_max_128_bounds_check(const bcmolt_xgpon_gem_port_with_state_list_u16_max_128 *this)
{
    if (this->len > 128)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_gem_port_with_state_list_u16_max_256_set_default(bcmolt_xgpon_gem_port_with_state_list_u16_max_256 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_list_u16_max_256_pack(const bcmolt_xgpon_gem_port_with_state_list_u16_max_256 *this, bcmolt_buf *buf)
{
    uint16_t i0;
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_gem_port_with_state_list_u16_max_256\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 256)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_gem_port_with_state_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_xgpon_gem_port_with_state_list_u16_max_256_get_packed_length(const bcmolt_xgpon_gem_port_with_state_list_u16_max_256 *this)
{
    return 2 + (3 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_list_u16_max_256_unpack(bcmolt_xgpon_gem_port_with_state_list_u16_max_256 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_gem_port_with_state_list_u16_max_256\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_xgpon_gem_port_with_state *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_xgpon_gem_port_with_state));
        }
    }

    if (this->len > 256)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_gem_port_with_state_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_list_u16_max_256_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_xgpon_gem_port_with_state) * len);
    if (!bcmolt_buf_skip(packed, len * 3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_gem_port_with_state_list_u16_max_256_bounds_check(const bcmolt_xgpon_gem_port_with_state_list_u16_max_256 *this)
{
    if (this->len > 256)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_key_exchange_set_default(bcmolt_xgpon_key_exchange *this)
{
    this->interval = 10000;
    this->control = BCMOLT_CONTROL_STATE_DISABLE;
    this->encrypted_ports_only = BCMOLT_CONTROL_STATE_DISABLE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_key_exchange_pack(const bcmolt_xgpon_key_exchange *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->encrypted_ports_only, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_key_exchange_unpack(bcmolt_xgpon_key_exchange *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->encrypted_ports_only, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_key_exchange_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 6);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_key_exchange_bounds_check(const bcmolt_xgpon_key_exchange *this)
{
    if (this->interval < 10000)
    {
        return BCMOS_FALSE;
    }

    if (this->interval > 3600000UL)
    {
        return BCMOS_FALSE;
    }

    switch (this->control)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->encrypted_ports_only)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_multicast_key_set_default(bcmolt_xgpon_multicast_key *this)
{
    memset(this->key.bytes, 0, sizeof(this->key.bytes));
    this->key_control = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_multicast_key_pack(const bcmolt_xgpon_multicast_key *this, bcmolt_buf *buf)
{
    if (!bcmolt_aes_key_pack(&this->key, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->key_control))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_multicast_key_unpack(bcmolt_xgpon_multicast_key *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_aes_key_unpack(&this->key, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->key_control))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_multicast_key_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 17);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_multicast_key_bounds_check(const bcmolt_xgpon_multicast_key *this)
{
    if (!bcmolt_aes_key_bounds_check(&this->key))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_ni_debug_set_default(bcmolt_xgpon_ni_debug *this)
{
    this->increase_available_cbr_bw = BCMOS_FALSE;
    this->inter_burst_gap_in_bytes = 512;
    this->number_of_gem_ports_per_onu = 64;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_debug_pack(const bcmolt_xgpon_ni_debug *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_bool(buf, this->increase_available_cbr_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->inter_burst_gap_in_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->number_of_gem_ports_per_onu))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_debug_unpack(bcmolt_xgpon_ni_debug *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_bool(buf, &this->increase_available_cbr_bw))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->inter_burst_gap_in_bytes))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->number_of_gem_ports_per_onu))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_debug_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ni_debug_bounds_check(const bcmolt_xgpon_ni_debug *this)
{
    if (this->number_of_gem_ports_per_onu < 8)
    {
        return BCMOS_FALSE;
    }

    if (this->number_of_gem_ports_per_onu > 256)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_activation_set_default(bcmolt_xgpon_onu_activation *this)
{
    this->key_exchange = BCMOLT_CONTROL_STATE_DISABLE;
    this->fail_due_to_regis_auto_fail = BCMOLT_CONTROL_STATE_ENABLE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_activation_pack(const bcmolt_xgpon_onu_activation *this, bcmolt_buf *buf)
{
    if (!bcmolt_control_state_pack(this->key_exchange, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->fail_due_to_regis_auto_fail, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_activation_unpack(bcmolt_xgpon_onu_activation *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_control_state_unpack(&this->key_exchange, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->fail_due_to_regis_auto_fail, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_activation_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_activation_bounds_check(const bcmolt_xgpon_onu_activation *this)
{
    switch (this->key_exchange)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->fail_due_to_regis_auto_fail)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_aes_key_set_default(bcmolt_xgpon_onu_aes_key *this)
{
    memset(this->encryption_key.bytes, 0, sizeof(this->encryption_key.bytes));
    this->key_index = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_aes_key_pack(const bcmolt_xgpon_onu_aes_key *this, bcmolt_buf *buf)
{
    if (!bcmolt_aes_key_pack(&this->encryption_key, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->key_index))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_aes_key_unpack(bcmolt_xgpon_onu_aes_key *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_aes_key_unpack(&this->encryption_key, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->key_index))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_aes_key_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 17);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_aes_key_bounds_check(const bcmolt_xgpon_onu_aes_key *this)
{
    if (!bcmolt_aes_key_bounds_check(&this->encryption_key))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_alarm_state_set_default(bcmolt_xgpon_onu_alarm_state *this)
{
    this->losi = BCMOLT_STATUS_OFF;
    this->lobi = BCMOLT_STATUS_OFF;
    this->lopci = BCMOLT_STATUS_OFF;
    this->lopci_mic_error = BCMOLT_STATUS_OFF;
    this->looci = BCMOLT_STATUS_OFF;
    this->tiwi = BCMOLT_STATUS_OFF;
    this->dowi = BCMOLT_STATUS_OFF;
    this->sufi = BCMOLT_STATUS_OFF;
    this->sfi = BCMOLT_STATUS_OFF;
    this->sdi = BCMOLT_STATUS_OFF;
    this->dfi = BCMOLT_STATUS_OFF;
    this->dgi = BCMOLT_STATUS_OFF;
    this->pqsi = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarm_state_pack(const bcmolt_xgpon_onu_alarm_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_status_pack(this->losi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->lobi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->lopci, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->lopci_mic_error, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->looci, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->tiwi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->dowi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->sufi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->sfi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->sdi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->dfi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->dgi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->pqsi, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarm_state_unpack(bcmolt_xgpon_onu_alarm_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_status_unpack(&this->losi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->lobi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->lopci, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->lopci_mic_error, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->looci, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->tiwi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->dowi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->sufi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->sfi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->sdi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->dfi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->dgi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->pqsi, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarm_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 13);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarm_state_bounds_check(const bcmolt_xgpon_onu_alarm_state *this)
{
    switch (this->losi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lobi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lopci)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lopci_mic_error)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->looci)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->tiwi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->dowi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->sufi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->sfi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->sdi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->dfi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->dgi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->pqsi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_alarms_set_default(bcmolt_xgpon_onu_alarms *this)
{
    this->losi = BCMOLT_STATUS_OFF;
    this->lobi = BCMOLT_STATUS_OFF;
    this->lopci_miss = BCMOLT_STATUS_OFF;
    this->lopci_mic_error = BCMOLT_STATUS_OFF;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarms_pack(const bcmolt_xgpon_onu_alarms *this, bcmolt_buf *buf)
{
    if (!bcmolt_status_pack(this->losi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->lobi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->lopci_miss, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_pack(this->lopci_mic_error, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarms_unpack(bcmolt_xgpon_onu_alarms *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_status_unpack(&this->losi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->lobi, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->lopci_miss, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_status_unpack(&this->lopci_mic_error, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarms_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarms_bounds_check(const bcmolt_xgpon_onu_alarms *this)
{
    switch (this->losi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lobi)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lopci_miss)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->lopci_mic_error)
    {
        case BCMOLT_STATUS_OFF:
            break;
        case BCMOLT_STATUS_ON:
            break;
        case BCMOLT_STATUS_NO_CHANGE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_alarms_thresholds_set_default(bcmolt_xgpon_onu_alarms_thresholds *this)
{
    this->losi = 4;
    this->lobi = 4;
    this->looci = 3;
    this->lopci = 3;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarms_thresholds_pack(const bcmolt_xgpon_onu_alarms_thresholds *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u8(buf, this->losi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->lobi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->looci))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->lopci))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarms_thresholds_unpack(bcmolt_xgpon_onu_alarms_thresholds *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u8(buf, &this->losi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->lobi))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->looci))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->lopci))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarms_thresholds_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_alarms_thresholds_bounds_check(const bcmolt_xgpon_onu_alarms_thresholds *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_eqd_set_default(bcmolt_xgpon_onu_eqd *this)
{
    this->onu_id = (bcmolt_xgpon_onu_id) 0;
    this->eqd = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_eqd_pack(const bcmolt_xgpon_onu_eqd *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->eqd))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_eqd_unpack(bcmolt_xgpon_onu_eqd *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->eqd))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_eqd_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 6);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_eqd_bounds_check(const bcmolt_xgpon_onu_eqd *this)
{
    if (this->onu_id > (bcmolt_xgpon_onu_id) 511)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_eqd_list_u32_set_default(bcmolt_xgpon_onu_eqd_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_eqd_list_u32_pack(const bcmolt_xgpon_onu_eqd_list_u32 *this, bcmolt_buf *buf)
{
    uint32_t i0;
    if (!bcmolt_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_onu_eqd_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_onu_eqd_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_xgpon_onu_eqd_list_u32_get_packed_length(const bcmolt_xgpon_onu_eqd_list_u32 *this)
{
    return 4 + (6 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_eqd_list_u32_unpack(bcmolt_xgpon_onu_eqd_list_u32 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmolt_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_onu_eqd_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_xgpon_onu_eqd *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_xgpon_onu_eqd));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_onu_eqd_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_eqd_list_u32_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmolt_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_xgpon_onu_eqd) * len);
    if (!bcmolt_buf_skip(packed, len * 6))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_eqd_list_u32_bounds_check(const bcmolt_xgpon_onu_eqd_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_registration_keys_set_default(bcmolt_xgpon_onu_registration_keys *this)
{
    memset(this->ploam_ik.bytes, 0, sizeof(this->ploam_ik.bytes));
    memset(this->omci_ik.bytes, 0, sizeof(this->omci_ik.bytes));
    memset(this->omci_k1.bytes, 0, sizeof(this->omci_k1.bytes));
    memset(this->omci_k2.bytes, 0, sizeof(this->omci_k2.bytes));
    memset(this->kek.bytes, 0, sizeof(this->kek.bytes));
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_registration_keys_pack(const bcmolt_xgpon_onu_registration_keys *this, bcmolt_buf *buf)
{
    if (!bcmolt_aes_key_pack(&this->ploam_ik, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_pack(&this->omci_ik, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_pack(&this->omci_k1, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_pack(&this->omci_k2, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_pack(&this->kek, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_registration_keys_unpack(bcmolt_xgpon_onu_registration_keys *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_aes_key_unpack(&this->ploam_ik, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_unpack(&this->omci_ik, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_unpack(&this->omci_k1, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_unpack(&this->omci_k2, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_unpack(&this->kek, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_registration_keys_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 80);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_registration_keys_bounds_check(const bcmolt_xgpon_onu_registration_keys *this)
{
    if (!bcmolt_aes_key_bounds_check(&this->ploam_ik))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_bounds_check(&this->omci_ik))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_bounds_check(&this->omci_k1))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_bounds_check(&this->omci_k2))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_aes_key_bounds_check(&this->kek))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_with_state_set_default(bcmolt_xgpon_onu_with_state *this)
{
    this->onu_id = (bcmolt_xgpon_onu_id) 0;
    this->state = BCMOLT_ONU_STATE_NOT_CONFIGURED;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_with_state_pack(const bcmolt_xgpon_onu_with_state *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, (uint16_t) this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_onu_state_pack(this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_with_state_unpack(bcmolt_xgpon_onu_with_state *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->onu_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_onu_state_unpack(&this->state, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_with_state_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_with_state_bounds_check(const bcmolt_xgpon_onu_with_state *this)
{
    if (this->onu_id > (bcmolt_xgpon_onu_id) 511)
    {
        return BCMOS_FALSE;
    }

    switch (this->state)
    {
        case BCMOLT_ONU_STATE_NOT_CONFIGURED:
            break;
        case BCMOLT_ONU_STATE_INACTIVE:
            break;
        case BCMOLT_ONU_STATE_ACTIVE:
            break;
        case BCMOLT_ONU_STATE_ACTIVE_STANDBY:
            break;
        case BCMOLT_ONU_STATE_DISABLED:
            break;
        case BCMOLT_ONU_STATE_AWAKE_FREE:
            break;
        case BCMOLT_ONU_STATE_PROCESSING:
            break;
        case BCMOLT_ONU_STATE_LOW_POWER_DOZE:
            break;
        case BCMOLT_ONU_STATE_LOW_POWER_SLEEP:
            break;
        case BCMOLT_ONU_STATE_LOW_POWER_WATCH:
            break;
        case BCMOLT_ONU_STATE_UNAWARE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_onu_with_state_list_u16_max_510_set_default(bcmolt_xgpon_onu_with_state_list_u16_max_510 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_with_state_list_u16_max_510_pack(const bcmolt_xgpon_onu_with_state_list_u16_max_510 *this, bcmolt_buf *buf)
{
    uint16_t i0;
    if (!bcmolt_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_onu_with_state_list_u16_max_510\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (this->len > 510)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_onu_with_state_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_xgpon_onu_with_state_list_u16_max_510_get_packed_length(const bcmolt_xgpon_onu_with_state_list_u16_max_510 *this)
{
    return 2 + (3 * this->len);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_with_state_list_u16_max_510_unpack(bcmolt_xgpon_onu_with_state_list_u16_max_510 *this, bcmolt_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmolt_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmolt_xgpon_onu_with_state_list_u16_max_510\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmolt_xgpon_onu_with_state *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmolt_xgpon_onu_with_state));
        }
    }

    if (this->len > 510)
    {
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmolt_xgpon_onu_with_state_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_with_state_list_u16_max_510_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmolt_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmolt_xgpon_onu_with_state) * len);
    if (!bcmolt_buf_skip(packed, len * 3))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_onu_with_state_list_u16_max_510_bounds_check(const bcmolt_xgpon_onu_with_state_list_u16_max_510 *this)
{
    if (this->len > 510)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_ploam_handling_set_default(bcmolt_xgpon_ploam_handling *this)
{
    this->ack_timeout = 2000;
    this->retrans_ranging_time = 0;
    this->retrans_assign_alloc_id = 0;
    this->retrans_key_control = 0;
    this->retrans_request_registration = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ploam_handling_pack(const bcmolt_xgpon_ploam_handling *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->ack_timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->retrans_ranging_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->retrans_assign_alloc_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->retrans_key_control))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->retrans_request_registration))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ploam_handling_unpack(bcmolt_xgpon_ploam_handling *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->ack_timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->retrans_ranging_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->retrans_assign_alloc_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->retrans_key_control))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->retrans_request_registration))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ploam_handling_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_ploam_handling_bounds_check(const bcmolt_xgpon_ploam_handling *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_protection_switching_set_default(bcmolt_xgpon_protection_switching *this)
{
    this->timeout = 100;
    this->gpio_pin = BCMOLT_GPIO_PIN_UNCONFIGURED;
    this->fast_ranging = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_protection_switching_pack(const bcmolt_xgpon_protection_switching *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_pin_pack(this->gpio_pin, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->fast_ranging))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_protection_switching_unpack(bcmolt_xgpon_protection_switching *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->timeout))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_gpio_pin_unpack(&this->gpio_pin, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->fast_ranging))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_protection_switching_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 4);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_protection_switching_bounds_check(const bcmolt_xgpon_protection_switching *this)
{
    switch (this->gpio_pin)
    {
        case BCMOLT_GPIO_PIN_PIN0:
            break;
        case BCMOLT_GPIO_PIN_PIN1:
            break;
        case BCMOLT_GPIO_PIN_PIN2:
            break;
        case BCMOLT_GPIO_PIN_PIN3:
            break;
        case BCMOLT_GPIO_PIN_PIN4:
            break;
        case BCMOLT_GPIO_PIN_PIN5:
            break;
        case BCMOLT_GPIO_PIN_PIN6:
            break;
        case BCMOLT_GPIO_PIN_PIN7:
            break;
        case BCMOLT_GPIO_PIN_PIN8:
            break;
        case BCMOLT_GPIO_PIN_PIN9:
            break;
        case BCMOLT_GPIO_PIN_PIN10:
            break;
        case BCMOLT_GPIO_PIN_PIN11:
            break;
        case BCMOLT_GPIO_PIN_PIN12:
            break;
        case BCMOLT_GPIO_PIN_PIN13:
            break;
        case BCMOLT_GPIO_PIN_PIN14:
            break;
        case BCMOLT_GPIO_PIN_PIN15:
            break;
        case BCMOLT_GPIO_PIN_PIN16:
            break;
        case BCMOLT_GPIO_PIN_PIN17:
            break;
        case BCMOLT_GPIO_PIN_PIN18:
            break;
        case BCMOLT_GPIO_PIN_PIN19:
            break;
        case BCMOLT_GPIO_PIN_PIN20:
            break;
        case BCMOLT_GPIO_PIN_PIN21:
            break;
        case BCMOLT_GPIO_PIN_PIN22:
            break;
        case BCMOLT_GPIO_PIN_PIN23:
            break;
        case BCMOLT_GPIO_PIN_PIN24:
            break;
        case BCMOLT_GPIO_PIN_PIN25:
            break;
        case BCMOLT_GPIO_PIN_PIN26:
            break;
        case BCMOLT_GPIO_PIN_PIN27:
            break;
        case BCMOLT_GPIO_PIN_PIN28:
            break;
        case BCMOLT_GPIO_PIN_PIN29:
            break;
        case BCMOLT_GPIO_PIN_PIN30:
            break;
        case BCMOLT_GPIO_PIN_PIN31:
            break;
        case BCMOLT_GPIO_PIN_PIN32:
            break;
        case BCMOLT_GPIO_PIN_PIN33:
            break;
        case BCMOLT_GPIO_PIN_PIN34:
            break;
        case BCMOLT_GPIO_PIN_PIN35:
            break;
        case BCMOLT_GPIO_PIN_PIN36:
            break;
        case BCMOLT_GPIO_PIN_PIN37:
            break;
        case BCMOLT_GPIO_PIN_PIN38:
            break;
        case BCMOLT_GPIO_PIN_PIN39:
            break;
        case BCMOLT_GPIO_PIN_PIN40:
            break;
        case BCMOLT_GPIO_PIN_PIN41:
            break;
        case BCMOLT_GPIO_PIN_PIN42:
            break;
        case BCMOLT_GPIO_PIN_PIN43:
            break;
        case BCMOLT_GPIO_PIN_PIN44:
            break;
        case BCMOLT_GPIO_PIN_PIN45:
            break;
        case BCMOLT_GPIO_PIN_PIN46:
            break;
        case BCMOLT_GPIO_PIN_PIN47:
            break;
        case BCMOLT_GPIO_PIN_PIN48:
            break;
        case BCMOLT_GPIO_PIN_PIN49:
            break;
        case BCMOLT_GPIO_PIN_PIN50:
            break;
        case BCMOLT_GPIO_PIN_PIN51:
            break;
        case BCMOLT_GPIO_PIN_PIN52:
            break;
        case BCMOLT_GPIO_PIN_PIN53:
            break;
        case BCMOLT_GPIO_PIN_PIN54:
            break;
        case BCMOLT_GPIO_PIN_PIN55:
            break;
        case BCMOLT_GPIO_PIN_PIN56:
            break;
        case BCMOLT_GPIO_PIN_PIN57:
            break;
        case BCMOLT_GPIO_PIN_PIN58:
            break;
        case BCMOLT_GPIO_PIN_PIN59:
            break;
        case BCMOLT_GPIO_PIN_PIN60:
            break;
        case BCMOLT_GPIO_PIN_PIN61:
            break;
        case BCMOLT_GPIO_PIN_PIN62:
            break;
        case BCMOLT_GPIO_PIN_PIN63:
            break;
        case BCMOLT_GPIO_PIN_PIN64:
            break;
        case BCMOLT_GPIO_PIN_PIN65:
            break;
        case BCMOLT_GPIO_PIN_PIN66:
            break;
        case BCMOLT_GPIO_PIN_PIN67:
            break;
        case BCMOLT_GPIO_PIN_PIN68:
            break;
        case BCMOLT_GPIO_PIN_PIN69:
            break;
        case BCMOLT_GPIO_PIN_PIN70:
            break;
        case BCMOLT_GPIO_PIN_PIN71:
            break;
        case BCMOLT_GPIO_PIN_PIN72:
            break;
        case BCMOLT_GPIO_PIN_PIN73:
            break;
        case BCMOLT_GPIO_PIN_PIN74:
            break;
        case BCMOLT_GPIO_PIN_PIN75:
            break;
        case BCMOLT_GPIO_PIN_PIN76:
            break;
        case BCMOLT_GPIO_PIN_PIN77:
            break;
        case BCMOLT_GPIO_PIN_PIN78:
            break;
        case BCMOLT_GPIO_PIN_PIN79:
            break;
        case BCMOLT_GPIO_PIN_PIN80:
            break;
        case BCMOLT_GPIO_PIN_PIN81:
            break;
        case BCMOLT_GPIO_PIN_PIN82:
            break;
        case BCMOLT_GPIO_PIN_PIN83:
            break;
        case BCMOLT_GPIO_PIN_PIN84:
            break;
        case BCMOLT_GPIO_PIN_PIN85:
            break;
        case BCMOLT_GPIO_PIN_PIN86:
            break;
        case BCMOLT_GPIO_PIN_PIN87:
            break;
        case BCMOLT_GPIO_PIN_PIN88:
            break;
        case BCMOLT_GPIO_PIN_PIN89:
            break;
        case BCMOLT_GPIO_PIN_PIN90:
            break;
        case BCMOLT_GPIO_PIN_PIN91:
            break;
        case BCMOLT_GPIO_PIN_PIN92:
            break;
        case BCMOLT_GPIO_PIN_PIN93:
            break;
        case BCMOLT_GPIO_PIN_PIN94:
            break;
        case BCMOLT_GPIO_PIN_PIN95:
            break;
        case BCMOLT_GPIO_PIN_PIN96:
            break;
        case BCMOLT_GPIO_PIN_PIN97:
            break;
        case BCMOLT_GPIO_PIN_PIN98:
            break;
        case BCMOLT_GPIO_PIN_PIN99:
            break;
        case BCMOLT_GPIO_PIN_PIN100:
            break;
        case BCMOLT_GPIO_PIN_PIN101:
            break;
        case BCMOLT_GPIO_PIN_PIN102:
            break;
        case BCMOLT_GPIO_PIN_PIN103:
            break;
        case BCMOLT_GPIO_PIN_PIN104:
            break;
        case BCMOLT_GPIO_PIN_PIN105:
            break;
        case BCMOLT_GPIO_PIN_PIN106:
            break;
        case BCMOLT_GPIO_PIN_UNCONFIGURED:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_protection_switching_debug_set_default(bcmolt_xgpon_protection_switching_debug *this)
{
    this->data_map_delay_ms = 0;
    this->rerange_send_ranging_time = BCMOS_FALSE;
    this->rerange_send_ranging_time_delay = 0;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_protection_switching_debug_pack(const bcmolt_xgpon_protection_switching_debug *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u16(buf, this->data_map_delay_ms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->rerange_send_ranging_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->rerange_send_ranging_time_delay))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_protection_switching_debug_unpack(bcmolt_xgpon_protection_switching_debug *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u16(buf, &this->data_map_delay_ms))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->rerange_send_ranging_time))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->rerange_send_ranging_time_delay))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_protection_switching_debug_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_protection_switching_debug_bounds_check(const bcmolt_xgpon_protection_switching_debug *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_rssi_normal_config_set_default(bcmolt_xgpon_rssi_normal_config *this)
{
    this->polarity = BCMOLT_POLARITY_LOW;
    this->location = 35;
    this->location_sign = BCMOLT_SIGN_POSITIVE;
    this->pulse_width = 80;
    this->minimum_burst = 200;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rssi_normal_config_pack(const bcmolt_xgpon_rssi_normal_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_polarity_pack(this->polarity, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_sign_pack(this->location_sign, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->pulse_width))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->minimum_burst))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rssi_normal_config_unpack(bcmolt_xgpon_rssi_normal_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_polarity_unpack(&this->polarity, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_sign_unpack(&this->location_sign, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->pulse_width))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->minimum_burst))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rssi_normal_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 7);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rssi_normal_config_bounds_check(const bcmolt_xgpon_rssi_normal_config *this)
{
    switch (this->polarity)
    {
        case BCMOLT_POLARITY_LOW:
            break;
        case BCMOLT_POLARITY_HIGH:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->location_sign)
    {
        case BCMOLT_SIGN_POSITIVE:
            break;
        case BCMOLT_SIGN_NEGATIVE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_rssi_ranging_config_set_default(bcmolt_xgpon_rssi_ranging_config *this)
{
    this->start_on_ed = BCMOS_TRUE;
    this->frame_delay = 0;
    this->word_delay = 20;
    this->frame_delay_after_ed = 0;
    this->word_delay_after_ed = 1;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rssi_ranging_config_pack(const bcmolt_xgpon_rssi_ranging_config *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_bool(buf, this->start_on_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->frame_delay))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->word_delay))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->frame_delay_after_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u16(buf, this->word_delay_after_ed))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rssi_ranging_config_unpack(bcmolt_xgpon_rssi_ranging_config *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_bool(buf, &this->start_on_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->frame_delay))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->word_delay))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->frame_delay_after_ed))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u16(buf, &this->word_delay_after_ed))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rssi_ranging_config_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 7);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rssi_ranging_config_bounds_check(const bcmolt_xgpon_rssi_ranging_config *this)
{
    if (this->frame_delay > 31)
    {
        return BCMOS_FALSE;
    }

    if (this->word_delay > 16383)
    {
        return BCMOS_FALSE;
    }

    if (this->frame_delay_after_ed > 31)
    {
        return BCMOS_FALSE;
    }

    if (this->word_delay_after_ed > 16383)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_rx_ranging_sm_pattern_set_default(bcmolt_xgpon_rx_ranging_sm_pattern *this)
{
    this->trx_reset_pattern_first = 0;
    this->trx_reset_pattern_middle = 0;
    this->trx_reset_pattern_last = 0;
    this->trx_reset_middle_repeats = 0;
    this->trx_reset_location = 0;
    this->bcdr_reset_pattern_first = 0;
    this->bcdr_reset_pattern_middle = 0;
    this->bcdr_reset_pattern_last = 0;
    this->bcdr_reset_middle_repeats = 0;
    this->bcdr_reset_location = 0;
    this->bcdr_reset_polarity = BCMOS_FALSE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rx_ranging_sm_pattern_pack(const bcmolt_xgpon_rx_ranging_sm_pattern *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->trx_reset_pattern_first))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->trx_reset_pattern_middle))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->trx_reset_pattern_last))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->trx_reset_middle_repeats))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->trx_reset_location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->bcdr_reset_pattern_first))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->bcdr_reset_pattern_middle))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u32(buf, this->bcdr_reset_pattern_last))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->bcdr_reset_middle_repeats))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, this->bcdr_reset_location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_bool(buf, this->bcdr_reset_polarity))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rx_ranging_sm_pattern_unpack(bcmolt_xgpon_rx_ranging_sm_pattern *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->trx_reset_pattern_first))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->trx_reset_pattern_middle))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->trx_reset_pattern_last))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->trx_reset_middle_repeats))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->trx_reset_location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->bcdr_reset_pattern_first))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->bcdr_reset_pattern_middle))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u32(buf, &this->bcdr_reset_pattern_last))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->bcdr_reset_middle_repeats))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, &this->bcdr_reset_location))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_bool(buf, &this->bcdr_reset_polarity))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rx_ranging_sm_pattern_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 29);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_rx_ranging_sm_pattern_bounds_check(const bcmolt_xgpon_rx_ranging_sm_pattern *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_serdes_configuration_set_default(bcmolt_xgpon_serdes_configuration *this)
{
    this->multi_ed_mode = BCMOS_FALSE;
    this->ranging_mode = BCMOLT_XGPON_SERDES_RANGING_MODE_BCDR;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_serdes_configuration_pack(const bcmolt_xgpon_serdes_configuration *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_bool(buf, this->multi_ed_mode))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_xgpon_serdes_ranging_mode_pack(this->ranging_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_serdes_configuration_unpack(bcmolt_xgpon_serdes_configuration *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_bool(buf, &this->multi_ed_mode))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_xgpon_serdes_ranging_mode_unpack(&this->ranging_mode, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_serdes_configuration_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_serdes_configuration_bounds_check(const bcmolt_xgpon_serdes_configuration *this)
{
    switch (this->ranging_mode)
    {
        case BCMOLT_XGPON_SERDES_RANGING_MODE_ED:
            break;
        case BCMOLT_XGPON_SERDES_RANGING_MODE_BCDR:
            break;
        case BCMOLT_XGPON_SERDES_RANGING_MODE_FAST_RANGING1:
            break;
        case BCMOLT_XGPON_SERDES_RANGING_MODE_FAST_RANGING2:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_sn_acquisition_set_default(bcmolt_xgpon_sn_acquisition *this)
{
    this->interval = 1000;
    this->control = BCMOLT_CONTROL_STATE_DISABLE;
    this->onu_post_discovery_mode = BCMOLT_ONU_POST_DISCOVERY_MODE_NONE;
    this->burst_profile = (bcmolt_burst_profile_index) 0;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_sn_acquisition_pack(const bcmolt_xgpon_sn_acquisition *this, bcmolt_buf *buf)
{
    if (!bcmolt_buf_write_u32(buf, this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_onu_post_discovery_mode_pack(this->onu_post_discovery_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_write_u8(buf, (uint8_t) this->burst_profile))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_sn_acquisition_unpack(bcmolt_xgpon_sn_acquisition *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_buf_read_u32(buf, &this->interval))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->control, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_onu_post_discovery_mode_unpack(&this->onu_post_discovery_mode, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_buf_read_u8(buf, (uint8_t *) &this->burst_profile))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_sn_acquisition_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 7);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_sn_acquisition_bounds_check(const bcmolt_xgpon_sn_acquisition *this)
{
    if (this->interval < 1000)
    {
        return BCMOS_FALSE;
    }

    if (this->interval > 2147483UL)
    {
        return BCMOS_FALSE;
    }

    switch (this->control)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->onu_post_discovery_mode)
    {
        case BCMOLT_ONU_POST_DISCOVERY_MODE_NONE:
            break;
        case BCMOLT_ONU_POST_DISCOVERY_MODE_ACTIVATE:
            break;
        case BCMOLT_ONU_POST_DISCOVERY_MODE_DISABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    if (this->burst_profile > (bcmolt_burst_profile_index) 3)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_xgpon_trx_debug_set_default(bcmolt_xgpon_trx_debug *this)
{
    this->rx_reversed_polarity = BCMOLT_CONTROL_STATE_DISABLE;
    this->neg_out_bit = BCMOLT_CONTROL_STATE_DISABLE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_debug_pack(const bcmolt_xgpon_trx_debug *this, bcmolt_buf *buf)
{
    if (!bcmolt_control_state_pack(this->rx_reversed_polarity, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_pack(this->neg_out_bit, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_debug_unpack(bcmolt_xgpon_trx_debug *this, bcmolt_buf *buf, void **extra_mem)
{
    if (!bcmolt_control_state_unpack(&this->rx_reversed_polarity, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmolt_control_state_unpack(&this->neg_out_bit, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_debug_scan(bcmolt_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmolt_buf_skip(packed, 2);
}

/******************************************************************************/
bcmos_bool bcmolt_xgpon_trx_debug_bounds_check(const bcmolt_xgpon_trx_debug *this)
{
    switch (this->rx_reversed_polarity)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    switch (this->neg_out_bit)
    {
        case BCMOLT_CONTROL_STATE_DISABLE:
            break;
        case BCMOLT_CONTROL_STATE_ENABLE:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_ni_key_set_default(bcmolt_ae_ni_key *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_KEY_ID_AE_NI)) != 0)
    {
        this->ae_ni = (bcmolt_ae_ni) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_key_pack(const bcmolt_ae_ni_key *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_KEY_ID_AE_NI)) != 0)
    {
        if (!bcmolt_buf_write_u16(buf, (uint16_t) this->ae_ni))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_ni_key_get_packed_length(const bcmolt_ae_ni_key *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_NI_KEY_ID_AE_NI)) != 0)
    {
        count += 2;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_key_unpack(bcmolt_ae_ni_key *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_KEY_ID_AE_NI)) != 0)
    {
        if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->ae_ni))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_key_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_KEY_ID_AE_NI)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_key_bounds_check(const bcmolt_ae_ni_key *this, bcmolt_presence_mask fields_present, bcmolt_ae_ni_key_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_ni_cfg_data_set_default(bcmolt_ae_ni_cfg_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MAC_ADDRESS)) != 0)
    {
        this->mac_address.u8[0] = 0x0000;
        this->mac_address.u8[1] = 0x000D;
        this->mac_address.u8[2] = 0x00B6;
        this->mac_address.u8[3] = 0x0000;
        this->mac_address.u8[4] = 0x0000;
        this->mac_address.u8[5] = 0x0000;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_AE_NI_EN)) != 0)
    {
        this->ae_ni_en = BCMOLT_AE_NI_EN_STATE_DISABLED;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MTU_10G)) != 0)
    {
        this->mtu_10g = 1536;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_GENERATOR)) != 0)
    {
        this->prbs_generator.polynom = BCMOLT_PRBS_POLYNOMIAL_PRBS_7;
        this->prbs_generator.error_insert = BCMOS_FALSE;
        this->prbs_generator.invert = BCMOS_FALSE;
        this->prbs_generator.control = BCMOLT_CONTROL_STATE_DISABLE;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_CHECKER)) != 0)
    {
        this->prbs_checker.polynom = BCMOLT_PRBS_POLYNOMIAL_PRBS_7;
        this->prbs_checker.mode = BCMOLT_PRBS_CHECKER_MODE_SELF_SYNC;
        this->prbs_checker.data_invert = BCMOS_FALSE;
        this->prbs_checker.control = BCMOLT_CONTROL_STATE_DISABLE;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_STATUS)) != 0)
    {
        this->prbs_status.lock_state = BCMOLT_PRBS_LOCK_STATE_UNLOCKED;
        this->prbs_status.error_counts = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_cfg_data_pack(const bcmolt_ae_ni_cfg_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MAC_ADDRESS)) != 0)
    {
        if (!bcmolt_buf_write_mac_address(buf, this->mac_address))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_AE_NI_EN)) != 0)
    {
        if (!bcmolt_ae_ni_en_state_pack(this->ae_ni_en, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MTU_10G)) != 0)
    {
        if (!bcmolt_buf_write_u16(buf, this->mtu_10g))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_GENERATOR)) != 0)
    {
        if (!bcmolt_prbs_generator_config_pack(&this->prbs_generator, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_CHECKER)) != 0)
    {
        if (!bcmolt_prbs_checker_config_pack(&this->prbs_checker, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_STATUS)) != 0)
    {
        if (!bcmolt_prbs_status_pack(&this->prbs_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_ni_cfg_data_get_packed_length(const bcmolt_ae_ni_cfg_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MAC_ADDRESS)) != 0)
    {
        count += 6;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_AE_NI_EN)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MTU_10G)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_GENERATOR)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_CHECKER)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_STATUS)) != 0)
    {
        count += 5;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_cfg_data_unpack(bcmolt_ae_ni_cfg_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MAC_ADDRESS)) != 0)
    {
        if (!bcmolt_buf_read_mac_address(buf, &this->mac_address))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_AE_NI_EN)) != 0)
    {
        if (!bcmolt_ae_ni_en_state_unpack(&this->ae_ni_en, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MTU_10G)) != 0)
    {
        if (!bcmolt_buf_read_u16(buf, &this->mtu_10g))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_GENERATOR)) != 0)
    {
        if (!bcmolt_prbs_generator_config_unpack(&this->prbs_generator, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_CHECKER)) != 0)
    {
        if (!bcmolt_prbs_checker_config_unpack(&this->prbs_checker, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_STATUS)) != 0)
    {
        if (!bcmolt_prbs_status_unpack(&this->prbs_status, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_cfg_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MAC_ADDRESS)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 6))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_AE_NI_EN)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MTU_10G)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_GENERATOR)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_CHECKER)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_STATUS)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 5))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_cfg_data_bounds_check(const bcmolt_ae_ni_cfg_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_ni_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_AE_NI_EN)) != 0)
    {
        switch (this->ae_ni_en)
        {
            case BCMOLT_AE_NI_EN_STATE_DISABLED:
                break;
            case BCMOLT_AE_NI_EN_STATE_ENABLED:
                break;
            default:
                *failed_prop = BCMOLT_AE_NI_CFG_ID_AE_NI_EN;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_MTU_10G)) != 0)
    {
        if (this->mtu_10g < 64)
        {
            *failed_prop = BCMOLT_AE_NI_CFG_ID_MTU_10G;
            return BCMOS_FALSE;
        }

        if (this->mtu_10g > 10000)
        {
            *failed_prop = BCMOLT_AE_NI_CFG_ID_MTU_10G;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_GENERATOR)) != 0)
    {
        if (!bcmolt_prbs_generator_config_bounds_check(&this->prbs_generator))
        {
            *failed_prop = BCMOLT_AE_NI_CFG_ID_PRBS_GENERATOR;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_CHECKER)) != 0)
    {
        if (!bcmolt_prbs_checker_config_bounds_check(&this->prbs_checker))
        {
            *failed_prop = BCMOLT_AE_NI_CFG_ID_PRBS_CHECKER;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_NI_CFG_ID_PRBS_STATUS)) != 0)
    {
        if (!bcmolt_prbs_status_bounds_check(&this->prbs_status))
        {
            *failed_prop = BCMOLT_AE_NI_CFG_ID_PRBS_STATUS;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_ni_set_ae_ni_en_state_data_set_default(bcmolt_ae_ni_set_ae_ni_en_state_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID_NEW_STATE)) != 0)
    {
        this->new_state = BCMOLT_AE_NI_EN_STATE_DISABLED;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_set_ae_ni_en_state_data_pack(const bcmolt_ae_ni_set_ae_ni_en_state_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID_NEW_STATE)) != 0)
    {
        if (!bcmolt_ae_ni_en_state_pack(this->new_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_ni_set_ae_ni_en_state_data_get_packed_length(const bcmolt_ae_ni_set_ae_ni_en_state_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID_NEW_STATE)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_set_ae_ni_en_state_data_unpack(bcmolt_ae_ni_set_ae_ni_en_state_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID_NEW_STATE)) != 0)
    {
        if (!bcmolt_ae_ni_en_state_unpack(&this->new_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_set_ae_ni_en_state_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID_NEW_STATE)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_ni_set_ae_ni_en_state_data_bounds_check(const bcmolt_ae_ni_set_ae_ni_en_state_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_ni_set_ae_ni_en_state_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID_NEW_STATE)) != 0)
    {
        switch (this->new_state)
        {
            case BCMOLT_AE_NI_EN_STATE_DISABLED:
                break;
            case BCMOLT_AE_NI_EN_STATE_ENABLED:
                break;
            default:
                *failed_prop = BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID_NEW_STATE;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_ds_key_set_default(bcmolt_ae_path_ds_key *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_KEY_ID_AE_NI)) != 0)
    {
        this->ae_ni = (bcmolt_ae_ni) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_key_pack(const bcmolt_ae_path_ds_key *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_KEY_ID_AE_NI)) != 0)
    {
        if (!bcmolt_buf_write_u16(buf, (uint16_t) this->ae_ni))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_ds_key_get_packed_length(const bcmolt_ae_path_ds_key *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_KEY_ID_AE_NI)) != 0)
    {
        count += 2;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_key_unpack(bcmolt_ae_path_ds_key *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_KEY_ID_AE_NI)) != 0)
    {
        if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->ae_ni))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_key_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_KEY_ID_AE_NI)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_key_bounds_check(const bcmolt_ae_path_ds_key *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_ds_key_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_ds_stat_data_set_default(bcmolt_ae_path_ds_stat_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BYTES)) != 0)
    {
        this->bytes = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES)) != 0)
    {
        this->frames = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_64)) != 0)
    {
        this->frames_64 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_65_127)) != 0)
    {
        this->frames_65_127 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_128_255)) != 0)
    {
        this->frames_128_255 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_256_511)) != 0)
    {
        this->frames_256_511 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_512_1023)) != 0)
    {
        this->frames_512_1023 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        this->frames_1024_1518 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        this->frames_1519_2047 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        this->frames_2048_4095 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        this->frames_4096_9216 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        this->frames_9217_16383 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        this->broadcast_frames = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_DATA_BYTES)) != 0)
    {
        this->data_bytes = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        this->multicast_frames = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        this->unicast_frames = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_ABORT_FRAMES)) != 0)
    {
        this->abort_frames = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_data_pack(const bcmolt_ae_path_ds_stat_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BYTES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_64)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_64))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_65_127)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_65_127))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_128_255)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_128_255))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_256_511)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_256_511))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_512_1023)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_512_1023))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_1024_1518))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_1519_2047))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_2048_4095))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_4096_9216))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_9217_16383))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->broadcast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_DATA_BYTES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->data_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->multicast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->unicast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_ABORT_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->abort_frames))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_ds_stat_data_get_packed_length(const bcmolt_ae_path_ds_stat_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BYTES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_64)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_65_127)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_128_255)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_256_511)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_512_1023)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_DATA_BYTES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_ABORT_FRAMES)) != 0)
    {
        count += 8;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_data_unpack(bcmolt_ae_path_ds_stat_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BYTES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_64)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_64))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_65_127)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_65_127))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_128_255)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_128_255))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_256_511)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_256_511))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_512_1023)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_512_1023))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_1024_1518))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_1519_2047))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_2048_4095))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_4096_9216))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_9217_16383))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->broadcast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_DATA_BYTES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->data_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->multicast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->unicast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_ABORT_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->abort_frames))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BYTES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_64)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_65_127)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_128_255)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_256_511)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_512_1023)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_DATA_BYTES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ID_ABORT_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_data_bounds_check(const bcmolt_ae_path_ds_stat_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_ds_stat_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_ds_stat_cfg_data_set_default(bcmolt_ae_path_ds_stat_cfg_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_CFG_ID_CFG)) != 0)
    {
        this->cfg.trigger.type = BCMOLT_STAT_CONDITION_TYPE_NONE;
        this->cfg.soak.active_soak_time = 0;
        this->cfg.soak.clear_soak_time = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_cfg_data_pack(const bcmolt_ae_path_ds_stat_cfg_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_CFG_ID_CFG)) != 0)
    {
        if (!bcmolt_stat_alarm_config_pack(&this->cfg, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_ds_stat_cfg_data_get_packed_length(const bcmolt_ae_path_ds_stat_cfg_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_CFG_ID_CFG)) != 0)
    {
        count += bcmolt_stat_alarm_config_get_packed_length(&this->cfg);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_cfg_data_unpack(bcmolt_ae_path_ds_stat_cfg_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_CFG_ID_CFG)) != 0)
    {
        if (!bcmolt_stat_alarm_config_unpack(&this->cfg, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_cfg_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_CFG_ID_CFG)) != 0)
    {
        if (!bcmolt_stat_alarm_config_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_cfg_data_bounds_check(const bcmolt_ae_path_ds_stat_cfg_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_ds_stat_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_CFG_ID_CFG)) != 0)
    {
        if (!bcmolt_stat_alarm_config_bounds_check(&this->cfg))
        {
            *failed_prop = BCMOLT_AE_PATH_DS_STAT_CFG_ID_CFG;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_ds_stat_alarm_cleared_data_set_default(bcmolt_ae_path_ds_stat_alarm_cleared_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        this->stat = BCMOLT_AE_PATH_DS_STAT_ID_BYTES;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_cleared_data_pack(const bcmolt_ae_path_ds_stat_alarm_cleared_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        if (!bcmolt_ae_path_ds_stat_id_pack(this->stat, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_ds_stat_alarm_cleared_data_get_packed_length(const bcmolt_ae_path_ds_stat_alarm_cleared_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        count += 2;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_cleared_data_unpack(bcmolt_ae_path_ds_stat_alarm_cleared_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        if (!bcmolt_ae_path_ds_stat_id_unpack(&this->stat, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_cleared_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_cleared_data_bounds_check(const bcmolt_ae_path_ds_stat_alarm_cleared_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_ds_stat_alarm_cleared_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        switch (this->stat)
        {
            case BCMOLT_AE_PATH_DS_STAT_ID_BYTES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_64:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_65_127:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_128_255:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_256_511:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_512_1023:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1024_1518:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1519_2047:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_2048_4095:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_4096_9216:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_9217_16383:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_BROADCAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_DATA_BYTES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_MULTICAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_UNICAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_ABORT_FRAMES:
                break;
            default:
                *failed_prop = BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID_STAT;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_ds_stat_alarm_raised_data_set_default(bcmolt_ae_path_ds_stat_alarm_raised_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        this->stat = BCMOLT_AE_PATH_DS_STAT_ID_BYTES;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_raised_data_pack(const bcmolt_ae_path_ds_stat_alarm_raised_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        if (!bcmolt_ae_path_ds_stat_id_pack(this->stat, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_ds_stat_alarm_raised_data_get_packed_length(const bcmolt_ae_path_ds_stat_alarm_raised_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        count += 2;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_raised_data_unpack(bcmolt_ae_path_ds_stat_alarm_raised_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        if (!bcmolt_ae_path_ds_stat_id_unpack(&this->stat, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_raised_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_stat_alarm_raised_data_bounds_check(const bcmolt_ae_path_ds_stat_alarm_raised_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_ds_stat_alarm_raised_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        switch (this->stat)
        {
            case BCMOLT_AE_PATH_DS_STAT_ID_BYTES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_64:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_65_127:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_128_255:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_256_511:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_512_1023:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1024_1518:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1519_2047:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_2048_4095:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_4096_9216:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_9217_16383:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_BROADCAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_DATA_BYTES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_MULTICAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_UNICAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_DS_STAT_ID_ABORT_FRAMES:
                break;
            default:
                *failed_prop = BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID_STAT;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_ds_auto_cfg_data_set_default(bcmolt_ae_path_ds_auto_cfg_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        this->stat_alarm_cleared = BCMOS_FALSE;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        this->stat_alarm_raised = BCMOS_FALSE;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_auto_cfg_data_pack(const bcmolt_ae_path_ds_auto_cfg_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        if (!bcmolt_buf_write_bool(buf, this->stat_alarm_cleared))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        if (!bcmolt_buf_write_bool(buf, this->stat_alarm_raised))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_ds_auto_cfg_data_get_packed_length(const bcmolt_ae_path_ds_auto_cfg_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_auto_cfg_data_unpack(bcmolt_ae_path_ds_auto_cfg_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        if (!bcmolt_buf_read_bool(buf, &this->stat_alarm_cleared))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        if (!bcmolt_buf_read_bool(buf, &this->stat_alarm_raised))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_auto_cfg_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_ds_auto_cfg_data_bounds_check(const bcmolt_ae_path_ds_auto_cfg_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_ds_auto_cfg_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_us_key_set_default(bcmolt_ae_path_us_key *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_KEY_ID_AE_NI)) != 0)
    {
        this->ae_ni = (bcmolt_ae_ni) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_key_pack(const bcmolt_ae_path_us_key *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_KEY_ID_AE_NI)) != 0)
    {
        if (!bcmolt_buf_write_u16(buf, (uint16_t) this->ae_ni))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_us_key_get_packed_length(const bcmolt_ae_path_us_key *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_KEY_ID_AE_NI)) != 0)
    {
        count += 2;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_key_unpack(bcmolt_ae_path_us_key *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_KEY_ID_AE_NI)) != 0)
    {
        if (!bcmolt_buf_read_u16(buf, (uint16_t *) &this->ae_ni))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_key_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_KEY_ID_AE_NI)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_key_bounds_check(const bcmolt_ae_path_us_key *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_us_key_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_us_stat_data_set_default(bcmolt_ae_path_us_stat_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BYTES)) != 0)
    {
        this->bytes = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES)) != 0)
    {
        this->frames = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_64)) != 0)
    {
        this->frames_64 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_65_127)) != 0)
    {
        this->frames_65_127 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_128_255)) != 0)
    {
        this->frames_128_255 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_256_511)) != 0)
    {
        this->frames_256_511 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_512_1023)) != 0)
    {
        this->frames_512_1023 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        this->frames_1024_1518 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        this->frames_1519_2047 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        this->frames_2048_4095 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        this->frames_4096_9216 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        this->frames_9217_16383 = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        this->broadcast_frames = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_DATA_BYTES)) != 0)
    {
        this->data_bytes = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        this->multicast_frames = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        this->unicast_frames = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_ABORT_FRAMES)) != 0)
    {
        this->abort_frames = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FCS_ERROR)) != 0)
    {
        this->fcs_error = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_OVERSIZE_ERROR)) != 0)
    {
        this->oversize_error = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_RUNT_ERROR)) != 0)
    {
        this->runt_error = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_data_pack(const bcmolt_ae_path_us_stat_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BYTES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_64)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_64))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_65_127)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_65_127))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_128_255)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_128_255))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_256_511)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_256_511))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_512_1023)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_512_1023))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_1024_1518))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_1519_2047))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_2048_4095))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_4096_9216))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->frames_9217_16383))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->broadcast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_DATA_BYTES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->data_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->multicast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->unicast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_ABORT_FRAMES)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->abort_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FCS_ERROR)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->fcs_error))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_OVERSIZE_ERROR)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->oversize_error))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_RUNT_ERROR)) != 0)
    {
        if (!bcmolt_buf_write_u64(buf, this->runt_error))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_us_stat_data_get_packed_length(const bcmolt_ae_path_us_stat_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BYTES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_64)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_65_127)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_128_255)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_256_511)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_512_1023)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_DATA_BYTES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_ABORT_FRAMES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FCS_ERROR)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_OVERSIZE_ERROR)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_RUNT_ERROR)) != 0)
    {
        count += 8;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_data_unpack(bcmolt_ae_path_us_stat_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BYTES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_64)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_64))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_65_127)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_65_127))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_128_255)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_128_255))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_256_511)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_256_511))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_512_1023)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_512_1023))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_1024_1518))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_1519_2047))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_2048_4095))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_4096_9216))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->frames_9217_16383))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->broadcast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_DATA_BYTES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->data_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->multicast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->unicast_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_ABORT_FRAMES)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->abort_frames))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FCS_ERROR)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->fcs_error))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_OVERSIZE_ERROR)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->oversize_error))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_RUNT_ERROR)) != 0)
    {
        if (!bcmolt_buf_read_u64(buf, &this->runt_error))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BYTES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_64)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_65_127)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_128_255)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_256_511)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_512_1023)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1024_1518)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1519_2047)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_2048_4095)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_4096_9216)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FRAMES_9217_16383)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_BROADCAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_DATA_BYTES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_MULTICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_UNICAST_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_ABORT_FRAMES)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_FCS_ERROR)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_OVERSIZE_ERROR)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ID_RUNT_ERROR)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_data_bounds_check(const bcmolt_ae_path_us_stat_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_us_stat_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_us_stat_cfg_data_set_default(bcmolt_ae_path_us_stat_cfg_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_CFG_ID_CFG)) != 0)
    {
        this->cfg.trigger.type = BCMOLT_STAT_CONDITION_TYPE_NONE;
        this->cfg.soak.active_soak_time = 0;
        this->cfg.soak.clear_soak_time = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_cfg_data_pack(const bcmolt_ae_path_us_stat_cfg_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_CFG_ID_CFG)) != 0)
    {
        if (!bcmolt_stat_alarm_config_pack(&this->cfg, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_us_stat_cfg_data_get_packed_length(const bcmolt_ae_path_us_stat_cfg_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_CFG_ID_CFG)) != 0)
    {
        count += bcmolt_stat_alarm_config_get_packed_length(&this->cfg);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_cfg_data_unpack(bcmolt_ae_path_us_stat_cfg_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_CFG_ID_CFG)) != 0)
    {
        if (!bcmolt_stat_alarm_config_unpack(&this->cfg, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_cfg_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_CFG_ID_CFG)) != 0)
    {
        if (!bcmolt_stat_alarm_config_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_cfg_data_bounds_check(const bcmolt_ae_path_us_stat_cfg_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_us_stat_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_CFG_ID_CFG)) != 0)
    {
        if (!bcmolt_stat_alarm_config_bounds_check(&this->cfg))
        {
            *failed_prop = BCMOLT_AE_PATH_US_STAT_CFG_ID_CFG;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_us_stat_alarm_cleared_data_set_default(bcmolt_ae_path_us_stat_alarm_cleared_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        this->stat = BCMOLT_AE_PATH_US_STAT_ID_BYTES;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_cleared_data_pack(const bcmolt_ae_path_us_stat_alarm_cleared_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        if (!bcmolt_ae_path_us_stat_id_pack(this->stat, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_us_stat_alarm_cleared_data_get_packed_length(const bcmolt_ae_path_us_stat_alarm_cleared_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        count += 2;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_cleared_data_unpack(bcmolt_ae_path_us_stat_alarm_cleared_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        if (!bcmolt_ae_path_us_stat_id_unpack(&this->stat, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_cleared_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_cleared_data_bounds_check(const bcmolt_ae_path_us_stat_alarm_cleared_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_us_stat_alarm_cleared_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID_STAT)) != 0)
    {
        switch (this->stat)
        {
            case BCMOLT_AE_PATH_US_STAT_ID_BYTES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_64:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_65_127:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_128_255:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_256_511:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_512_1023:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1024_1518:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1519_2047:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_2048_4095:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_4096_9216:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_9217_16383:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_BROADCAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_DATA_BYTES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_MULTICAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_UNICAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_ABORT_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FCS_ERROR:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_OVERSIZE_ERROR:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_RUNT_ERROR:
                break;
            default:
                *failed_prop = BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID_STAT;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_us_stat_alarm_raised_data_set_default(bcmolt_ae_path_us_stat_alarm_raised_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        this->stat = BCMOLT_AE_PATH_US_STAT_ID_BYTES;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_raised_data_pack(const bcmolt_ae_path_us_stat_alarm_raised_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        if (!bcmolt_ae_path_us_stat_id_pack(this->stat, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_us_stat_alarm_raised_data_get_packed_length(const bcmolt_ae_path_us_stat_alarm_raised_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        count += 2;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_raised_data_unpack(bcmolt_ae_path_us_stat_alarm_raised_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        if (!bcmolt_ae_path_us_stat_id_unpack(&this->stat, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_raised_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_stat_alarm_raised_data_bounds_check(const bcmolt_ae_path_us_stat_alarm_raised_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_us_stat_alarm_raised_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID_STAT)) != 0)
    {
        switch (this->stat)
        {
            case BCMOLT_AE_PATH_US_STAT_ID_BYTES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_64:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_65_127:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_128_255:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_256_511:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_512_1023:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1024_1518:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1519_2047:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_2048_4095:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_4096_9216:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FRAMES_9217_16383:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_BROADCAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_DATA_BYTES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_MULTICAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_UNICAST_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_ABORT_FRAMES:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_FCS_ERROR:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_OVERSIZE_ERROR:
                break;
            case BCMOLT_AE_PATH_US_STAT_ID_RUNT_ERROR:
                break;
            default:
                *failed_prop = BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID_STAT;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_ae_path_us_auto_cfg_data_set_default(bcmolt_ae_path_us_auto_cfg_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        this->stat_alarm_cleared = BCMOS_FALSE;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        this->stat_alarm_raised = BCMOS_FALSE;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_auto_cfg_data_pack(const bcmolt_ae_path_us_auto_cfg_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        if (!bcmolt_buf_write_bool(buf, this->stat_alarm_cleared))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        if (!bcmolt_buf_write_bool(buf, this->stat_alarm_raised))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_ae_path_us_auto_cfg_data_get_packed_length(const bcmolt_ae_path_us_auto_cfg_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_auto_cfg_data_unpack(bcmolt_ae_path_us_auto_cfg_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        if (!bcmolt_buf_read_bool(buf, &this->stat_alarm_cleared))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        if (!bcmolt_buf_read_bool(buf, &this->stat_alarm_raised))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_auto_cfg_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_CLEARED)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_RAISED)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_ae_path_us_auto_cfg_data_bounds_check(const bcmolt_ae_path_us_auto_cfg_data *this, bcmolt_presence_mask fields_present, bcmolt_ae_path_us_auto_cfg_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_channel_key_set_default(bcmolt_channel_key *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_KEY_ID_PON_NI)) != 0)
    {
        this->pon_ni = (bcmolt_pon_ni) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_channel_key_pack(const bcmolt_channel_key *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_KEY_ID_PON_NI)) != 0)
    {
        if (!bcmolt_buf_write_u8(buf, (uint8_t) this->pon_ni))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_channel_key_get_packed_length(const bcmolt_channel_key *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_KEY_ID_PON_NI)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_key_unpack(bcmolt_channel_key *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_KEY_ID_PON_NI)) != 0)
    {
        if (!bcmolt_buf_read_u8(buf, (uint8_t *) &this->pon_ni))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_key_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_KEY_ID_PON_NI)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_key_bounds_check(const bcmolt_channel_key *this, bcmolt_presence_mask fields_present, bcmolt_channel_key_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_KEY_ID_PON_NI)) != 0)
    {
        if (this->pon_ni > (bcmolt_pon_ni) 15)
        {
            *failed_prop = BCMOLT_CHANNEL_KEY_ID_PON_NI;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_channel_cfg_data_set_default(bcmolt_channel_cfg_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_OPERATION_CONTROL)) != 0)
    {
        this->operation_control.re = 0;
        this->operation_control.odn_class = BCMOLT_ODN_CLASS_N1;
        this->operation_control.ds_fec_mode = BCMOLT_CONTROL_STATE_ENABLE;
        this->operation_control.protocol = BCMOLT_TC_PROTOCOL_TC_LAYER_PROTOCOL_G_989_P_3;
        this->operation_control.ds_link_type = BCMOLT_LINK_TYPE_UNSPECIFIED;
        this->operation_control.pon_id.administrative_label = 0;
        this->operation_control.pon_id.dwlch_id = 0;
        this->operation_control.c = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_TOL)) != 0)
    {
        this->tol = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_SYSTEM_PROFILE)) != 0)
    {
        this->system_profile.ng_2_sys_id = 0;
        this->system_profile.version = 0;
        this->system_profile.channel_spacing = 0;
        this->system_profile.us_operating_wavelength_bands = BCMOLT_US_OPERATING_WAVELENGTH_BANDS_EXPANDED_SPECTRUM_WIDE_BAND;
        this->system_profile.us_mse = 0;
        this->system_profile.loose_calibration_bound = BCMOLT_CALIBRATION_RECORD_UNSPECIFIED;
        this->system_profile.fsr = 0;
        this->system_profile.twdm_channel_count = 8;
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_CHANNEL_PROFILE)) != 0)
    {
        memset(this->channel_profile.arr, 0, sizeof(this->channel_profile.arr));
    }
}

/******************************************************************************/
bcmos_bool bcmolt_channel_cfg_data_pack(const bcmolt_channel_cfg_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_OPERATION_CONTROL)) != 0)
    {
        if (!bcmolt_operation_control_pack(&this->operation_control, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_TOL)) != 0)
    {
        if (!bcmolt_buf_write_u16(buf, this->tol))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_SYSTEM_PROFILE)) != 0)
    {
        if (!bcmolt_system_profile_pack(&this->system_profile, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_CHANNEL_PROFILE)) != 0)
    {
        if (!bcmolt_arr_channel_profile_8_pack(&this->channel_profile, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_channel_cfg_data_get_packed_length(const bcmolt_channel_cfg_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_OPERATION_CONTROL)) != 0)
    {
        count += 11;
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_TOL)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_SYSTEM_PROFILE)) != 0)
    {
        count += 12;
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_CHANNEL_PROFILE)) != 0)
    {
        count += 120;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_cfg_data_unpack(bcmolt_channel_cfg_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_OPERATION_CONTROL)) != 0)
    {
        if (!bcmolt_operation_control_unpack(&this->operation_control, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_TOL)) != 0)
    {
        if (!bcmolt_buf_read_u16(buf, &this->tol))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_SYSTEM_PROFILE)) != 0)
    {
        if (!bcmolt_system_profile_unpack(&this->system_profile, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_CHANNEL_PROFILE)) != 0)
    {
        if (!bcmolt_arr_channel_profile_8_unpack(&this->channel_profile, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_cfg_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_OPERATION_CONTROL)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 11))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_TOL)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_SYSTEM_PROFILE)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 12))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_CHANNEL_PROFILE)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 120))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_channel_cfg_data_bounds_check(const bcmolt_channel_cfg_data *this, bcmolt_presence_mask fields_present, bcmolt_channel_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_OPERATION_CONTROL)) != 0)
    {
        if (!bcmolt_operation_control_bounds_check(&this->operation_control))
        {
            *failed_prop = BCMOLT_CHANNEL_CFG_ID_OPERATION_CONTROL;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_TOL)) != 0)
    {
        if (this->tol > 511)
        {
            *failed_prop = BCMOLT_CHANNEL_CFG_ID_TOL;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_SYSTEM_PROFILE)) != 0)
    {
        if (!bcmolt_system_profile_bounds_check(&this->system_profile))
        {
            *failed_prop = BCMOLT_CHANNEL_CFG_ID_SYSTEM_PROFILE;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_CHANNEL_CFG_ID_CHANNEL_PROFILE)) != 0)
    {
        if (!bcmolt_arr_channel_profile_8_bounds_check(&this->channel_profile))
        {
            *failed_prop = BCMOLT_CHANNEL_CFG_ID_CHANNEL_PROFILE;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_debug_key_set_default(bcmolt_debug_key *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_KEY_ID_RESERVED)) != 0)
    {
        this->reserved = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_debug_key_pack(const bcmolt_debug_key *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_KEY_ID_RESERVED)) != 0)
    {
        if (!bcmolt_buf_write_u32(buf, this->reserved))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_debug_key_get_packed_length(const bcmolt_debug_key *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_DEBUG_KEY_ID_RESERVED)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_key_unpack(bcmolt_debug_key *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_KEY_ID_RESERVED)) != 0)
    {
        if (!bcmolt_buf_read_u32(buf, &this->reserved))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_key_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_KEY_ID_RESERVED)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_key_bounds_check(const bcmolt_debug_key *this, bcmolt_presence_mask fields_present, bcmolt_debug_key_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_debug_cfg_data_set_default(bcmolt_debug_cfg_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_CONSOLE_REDIRECTION)) != 0)
    {
        this->console_redirection = BCMOLT_CONSOLE_REDIRECTION_NONE;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_INDICATIONS_DROPPED)) != 0)
    {
        this->indications_dropped = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_FILE_USED_PERCENT)) != 0)
    {
        this->file_used_percent = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_CFG)) != 0)
    {
        this->api_capture_cfg.location = BCMOLT_API_CAPTURE_LOCATION_DEVICE;
        this->api_capture_cfg.buffer_size_bytes = 16384;
        this->api_capture_cfg.buffer_mode = BCMOLT_API_CAPTURE_BUFFER_MODE_WRAP;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS)) != 0)
    {
        this->api_capture_stats.buffer_used_bytes = 0;
        this->api_capture_stats.buffer_wrap_count = 0;
        this->api_capture_stats.events_recorded = 0;
        this->api_capture_stats.events_dropped = 0;
        this->api_capture_stats.readable_bytes = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER_READ)) != 0)
    {
        this->api_capture_buffer_read.offset = 0;
        this->api_capture_buffer_read.size = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER)) != 0)
    {
        this->api_capture_buffer.len = 0;
        this->api_capture_buffer.val = NULL;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cfg_data_pack(const bcmolt_debug_cfg_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_CONSOLE_REDIRECTION)) != 0)
    {
        if (!bcmolt_console_redirection_pack(this->console_redirection, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_INDICATIONS_DROPPED)) != 0)
    {
        if (!bcmolt_buf_write_u32(buf, this->indications_dropped))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_FILE_USED_PERCENT)) != 0)
    {
        if (!bcmolt_buf_write_u8(buf, this->file_used_percent))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_CFG)) != 0)
    {
        if (!bcmolt_api_capture_config_pack(&this->api_capture_cfg, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS)) != 0)
    {
        if (!bcmolt_api_capture_stats_pack(&this->api_capture_stats, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER_READ)) != 0)
    {
        if (!bcmolt_api_capture_buffer_reader_pack(&this->api_capture_buffer_read, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER)) != 0)
    {
        if (!bcmolt_u8_list_u32_pack(&this->api_capture_buffer, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_debug_cfg_data_get_packed_length(const bcmolt_debug_cfg_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_CONSOLE_REDIRECTION)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_INDICATIONS_DROPPED)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_FILE_USED_PERCENT)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_CFG)) != 0)
    {
        count += 6;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS)) != 0)
    {
        count += 20;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER_READ)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER)) != 0)
    {
        count += bcmolt_u8_list_u32_get_packed_length(&this->api_capture_buffer);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cfg_data_unpack(bcmolt_debug_cfg_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_CONSOLE_REDIRECTION)) != 0)
    {
        if (!bcmolt_console_redirection_unpack(&this->console_redirection, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_INDICATIONS_DROPPED)) != 0)
    {
        if (!bcmolt_buf_read_u32(buf, &this->indications_dropped))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_FILE_USED_PERCENT)) != 0)
    {
        if (!bcmolt_buf_read_u8(buf, &this->file_used_percent))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_CFG)) != 0)
    {
        if (!bcmolt_api_capture_config_unpack(&this->api_capture_cfg, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS)) != 0)
    {
        if (!bcmolt_api_capture_stats_unpack(&this->api_capture_stats, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER_READ)) != 0)
    {
        if (!bcmolt_api_capture_buffer_reader_unpack(&this->api_capture_buffer_read, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER)) != 0)
    {
        if (!bcmolt_u8_list_u32_unpack(&this->api_capture_buffer, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cfg_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_CONSOLE_REDIRECTION)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_INDICATIONS_DROPPED)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_FILE_USED_PERCENT)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_CFG)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 6))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 20))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER_READ)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER)) != 0)
    {
        if (!bcmolt_u8_list_u32_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cfg_data_bounds_check(const bcmolt_debug_cfg_data *this, bcmolt_presence_mask fields_present, bcmolt_debug_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_CONSOLE_REDIRECTION)) != 0)
    {
        switch (this->console_redirection)
        {
            case BCMOLT_CONSOLE_REDIRECTION_NONE:
                break;
            case BCMOLT_CONSOLE_REDIRECTION_REDIRECT:
                break;
            case BCMOLT_CONSOLE_REDIRECTION_CLONE:
                break;
            default:
                *failed_prop = BCMOLT_DEBUG_CFG_ID_CONSOLE_REDIRECTION;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_CFG)) != 0)
    {
        if (!bcmolt_api_capture_config_bounds_check(&this->api_capture_cfg))
        {
            *failed_prop = BCMOLT_DEBUG_CFG_ID_API_CAPTURE_CFG;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS)) != 0)
    {
        if (!bcmolt_api_capture_stats_bounds_check(&this->api_capture_stats))
        {
            *failed_prop = BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER_READ)) != 0)
    {
        if (!bcmolt_api_capture_buffer_reader_bounds_check(&this->api_capture_buffer_read))
        {
            *failed_prop = BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER_READ;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER)) != 0)
    {
        if (!bcmolt_u8_list_u32_bounds_check(&this->api_capture_buffer))
        {
            *failed_prop = BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_debug_cli_output_data_set_default(bcmolt_debug_cli_output_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_OUTPUT_ID_DATA)) != 0)
    {
        this->data.len = 0;
        this->data.val = NULL;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_output_data_pack(const bcmolt_debug_cli_output_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_OUTPUT_ID_DATA)) != 0)
    {
        if (!bcmolt_u8_list_u32_pack(&this->data, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_debug_cli_output_data_get_packed_length(const bcmolt_debug_cli_output_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_OUTPUT_ID_DATA)) != 0)
    {
        count += bcmolt_u8_list_u32_get_packed_length(&this->data);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_output_data_unpack(bcmolt_debug_cli_output_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_OUTPUT_ID_DATA)) != 0)
    {
        if (!bcmolt_u8_list_u32_unpack(&this->data, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_output_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_OUTPUT_ID_DATA)) != 0)
    {
        if (!bcmolt_u8_list_u32_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_output_data_bounds_check(const bcmolt_debug_cli_output_data *this, bcmolt_presence_mask fields_present, bcmolt_debug_cli_output_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_OUTPUT_ID_DATA)) != 0)
    {
        if (!bcmolt_u8_list_u32_bounds_check(&this->data))
        {
            *failed_prop = BCMOLT_DEBUG_CLI_OUTPUT_ID_DATA;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_debug_auto_cfg_data_set_default(bcmolt_debug_auto_cfg_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_CLI_OUTPUT)) != 0)
    {
        this->cli_output = BCMOS_FALSE;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_FILE_ALMOST_FULL)) != 0)
    {
        this->file_almost_full = BCMOS_FALSE;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_debug_auto_cfg_data_pack(const bcmolt_debug_auto_cfg_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_CLI_OUTPUT)) != 0)
    {
        if (!bcmolt_buf_write_bool(buf, this->cli_output))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_FILE_ALMOST_FULL)) != 0)
    {
        if (!bcmolt_buf_write_bool(buf, this->file_almost_full))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_debug_auto_cfg_data_get_packed_length(const bcmolt_debug_auto_cfg_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_CLI_OUTPUT)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_FILE_ALMOST_FULL)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_auto_cfg_data_unpack(bcmolt_debug_auto_cfg_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_CLI_OUTPUT)) != 0)
    {
        if (!bcmolt_buf_read_bool(buf, &this->cli_output))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_FILE_ALMOST_FULL)) != 0)
    {
        if (!bcmolt_buf_read_bool(buf, &this->file_almost_full))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_auto_cfg_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_CLI_OUTPUT)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEBUG_AUTO_CFG_ID_FILE_ALMOST_FULL)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_auto_cfg_data_bounds_check(const bcmolt_debug_auto_cfg_data *this, bcmolt_presence_mask fields_present, bcmolt_debug_auto_cfg_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_debug_cli_input_data_set_default(bcmolt_debug_cli_input_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_INPUT_ID_DATA)) != 0)
    {
        this->data.len = 0;
        this->data.val = NULL;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_input_data_pack(const bcmolt_debug_cli_input_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_INPUT_ID_DATA)) != 0)
    {
        if (!bcmolt_u8_list_u32_pack(&this->data, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_debug_cli_input_data_get_packed_length(const bcmolt_debug_cli_input_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_INPUT_ID_DATA)) != 0)
    {
        count += bcmolt_u8_list_u32_get_packed_length(&this->data);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_input_data_unpack(bcmolt_debug_cli_input_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_INPUT_ID_DATA)) != 0)
    {
        if (!bcmolt_u8_list_u32_unpack(&this->data, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_input_data_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_INPUT_ID_DATA)) != 0)
    {
        if (!bcmolt_u8_list_u32_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_debug_cli_input_data_bounds_check(const bcmolt_debug_cli_input_data *this, bcmolt_presence_mask fields_present, bcmolt_debug_cli_input_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMOLT_DEBUG_CLI_INPUT_ID_DATA)) != 0)
    {
        if (!bcmolt_u8_list_u32_bounds_check(&this->data))
        {
            *failed_prop = BCMOLT_DEBUG_CLI_INPUT_ID_DATA;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_device_key_set_default(bcmolt_device_key *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEVICE_KEY_ID_RESERVED)) != 0)
    {
        this->reserved = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_device_key_pack(const bcmolt_device_key *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEVICE_KEY_ID_RESERVED)) != 0)
    {
        if (!bcmolt_buf_write_u32(buf, this->reserved))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_device_key_get_packed_length(const bcmolt_device_key *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_DEVICE_KEY_ID_RESERVED)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_device_key_unpack(bcmolt_device_key *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEVICE_KEY_ID_RESERVED)) != 0)
    {
        if (!bcmolt_buf_read_u32(buf, &this->reserved))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_key_scan(bcmolt_buf *packed, uint32_t *extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEVICE_KEY_ID_RESERVED)) != 0)
    {
        if (!bcmolt_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmolt_device_key_bounds_check(const bcmolt_device_key *this, bcmolt_presence_mask fields_present, bcmolt_device_key_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmolt_device_cfg_data_set_default(bcmolt_device_cfg_data *this, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_SYSTEM_MODE)) != 0)
    {
        this->system_mode = BCMOLT_SYSTEM_MODE_GPON__16_X;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_KEEPALIVE_INTERVAL)) != 0)
    {
        this->keepalive_interval = 5;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_KEEPALIVE_TOLERANCE)) != 0)
    {
        this->keepalive_tolerance = 3;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_FIRMWARE_SW_VERSION)) != 0)
    {
        this->firmware_sw_version.major = 0;
        this->firmware_sw_version.minor = 0;
        this->firmware_sw_version.revision = 0;
        this->firmware_sw_version.model = 0;
        memset(this->firmware_sw_version.build_time, 0, 32);
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_HOST_SW_VERSION)) != 0)
    {
        this->host_sw_version.major = 0;
        this->host_sw_version.minor = 0;
        this->host_sw_version.revision = 0;
        this->host_sw_version.model = 0;
        memset(this->host_sw_version.build_time, 0, 32);
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_REVISION)) != 0)
    {
        this->chip_revision = (bcmolt_device_chip_revision) 0;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_STATE)) != 0)
    {
        this->state = BCMOLT_DEVICE_STATE_DISCONNECTED;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_DEBUG)) != 0)
    {
        this->debug.host_dma_rx_queue_size = 128;
        this->debug.host_dma_tx_queue_size = 128;
        this->debug.avs_control = BCMOS_FALSE;
        this->debug.use_prev_pon_serdes_firmware = BCMOS_FALSE;
        this->debug.use_prev_nni_serdes_firmware = BCMOS_FALSE;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_NNI_SPEED)) != 0)
    {
        this->nni_speed.first_half = BCMOLT_NNI_SPEED_GBPS_1;
        this->nni_speed.second_half = BCMOLT_NNI_SPEED_GBPS_1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_PROTECTION_SWITCHING_EXT_IRQ)) != 0)
    {
        this->protection_switching_ext_irq = BCMOLT_EXT_IRQ_UNCONFIGURED;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_CLOCK_TRANSPORT_SAMPLE_DELAY)) != 0)
    {
        this->epon_clock_transport_sample_delay = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_INDICATION_SHAPING)) != 0)
    {
        this->indication_shaping.enabled = BCMOS_FALSE;
        this->indication_shaping.max_rate = 1000;
        this->indication_shaping.max_burst = 100;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_TEMPERATURE)) != 0)
    {
        this->chip_temperature = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_ENABLE)) != 0)
    {
        this->gpon_xgpon_tod_enable = BCMOLT_CONTROL_STATE_DISABLE;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_GPIO_PIN)) != 0)
    {
        this->gpon_xgpon_tod_gpio_pin = BCMOLT_GPIO_PIN_UNCONFIGURED;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_CONNECTED_INTERNALLY)) != 0)
    {
        this->gpon_xgpon_tod_connected_internally = BCMOS_FALSE;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_8021_AS_TOD_FORMAT)) != 0)
    {
        memset(this->epon_8021_as_tod_format.str, 0, 256);
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_SHAPER_MODE)) != 0)
    {
        this->epon_shaper_mode = BCMOLT_SHAPER_MODE_LAYER_1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EMBEDDED_IMAGE_LIST)) != 0)
    {
        this->embedded_image_list.len = 0;
        this->embedded_image_list.val = NULL;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_VOLTAGE)) != 0)
    {
        this->chip_voltage = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_TOD_STRING)) != 0)
    {
        memset(this->epon_tod_string.str, 0, 256);
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_XGPON_NUM_OF_ONUS)) != 0)
    {
        this->xgpon_num_of_onus = BCMOLT_XGPON_NUM_OF_ONUS_XGPON_SUPPORT_256_ONUS;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_DEVICE_IP_ADDRESS)) != 0)
    {
        bcmos_ipv4_address_init(&this->device_ip_address);
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_DEVICE_UDP_PORT)) != 0)
    {
        this->device_udp_port = 0;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_TOD_UART_BAUDRATE)) != 0)
    {
        this->tod_uart_baudrate = BCMOLT_UART_BAUDRATE_UART_RATE_9600;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_STRING_LENGTH)) != 0)
    {
        this->gpon_xgpon_tod_string_length = 16;
    }
}

/******************************************************************************/
bcmos_bool bcmolt_device_cfg_data_pack(const bcmolt_device_cfg_data *this, bcmolt_buf *buf, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_SYSTEM_MODE)) != 0)
    {
        if (!bcmolt_system_mode_pack(this->system_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_KEEPALIVE_INTERVAL)) != 0)
    {
        if (!bcmolt_buf_write_u32(buf, this->keepalive_interval))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_KEEPALIVE_TOLERANCE)) != 0)
    {
        if (!bcmolt_buf_write_u32(buf, this->keepalive_tolerance))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_FIRMWARE_SW_VERSION)) != 0)
    {
        if (!bcmolt_firmware_sw_version_pack(&this->firmware_sw_version, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_HOST_SW_VERSION)) != 0)
    {
        if (!bcmolt_host_sw_version_pack(&this->host_sw_version, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_REVISION)) != 0)
    {
        if (!bcmolt_device_chip_revision_pack(this->chip_revision, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_STATE)) != 0)
    {
        if (!bcmolt_device_state_pack(this->state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_DEBUG)) != 0)
    {
        if (!bcmolt_debug_device_cfg_pack(&this->debug, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_NNI_SPEED)) != 0)
    {
        if (!bcmolt_device_nni_speed_pack(&this->nni_speed, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_PROTECTION_SWITCHING_EXT_IRQ)) != 0)
    {
        if (!bcmolt_ext_irq_pack(this->protection_switching_ext_irq, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_CLOCK_TRANSPORT_SAMPLE_DELAY)) != 0)
    {
        if (!bcmolt_buf_write_u32(buf, this->epon_clock_transport_sample_delay))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_INDICATION_SHAPING)) != 0)
    {
        if (!bcmolt_indication_shaping_pack(&this->indication_shaping, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_TEMPERATURE)) != 0)
    {
        if (!bcmolt_buf_write_u32(buf, this->chip_temperature))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_ENABLE)) != 0)
    {
        if (!bcmolt_control_state_pack(this->gpon_xgpon_tod_enable, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_GPIO_PIN)) != 0)
    {
        if (!bcmolt_gpio_pin_pack(this->gpon_xgpon_tod_gpio_pin, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_CONNECTED_INTERNALLY)) != 0)
    {
        if (!bcmolt_buf_write_bool(buf, this->gpon_xgpon_tod_connected_internally))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_8021_AS_TOD_FORMAT)) != 0)
    {
        if (!bcmolt_str_256_pack(&this->epon_8021_as_tod_format, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_SHAPER_MODE)) != 0)
    {
        if (!bcmolt_shaper_mode_pack(this->epon_shaper_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EMBEDDED_IMAGE_LIST)) != 0)
    {
        if (!bcmolt_embedded_image_entry_list_u8_pack(&this->embedded_image_list, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_VOLTAGE)) != 0)
    {
        if (!bcmolt_buf_write_u32(buf, this->chip_voltage))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_TOD_STRING)) != 0)
    {
        if (!bcmolt_str_256_pack(&this->epon_tod_string, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_XGPON_NUM_OF_ONUS)) != 0)
    {
        if (!bcmolt_xgpon_num_of_onus_pack(this->xgpon_num_of_onus, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_DEVICE_IP_ADDRESS)) != 0)
    {
        if (!bcmolt_buf_write_ipv4_address(buf, this->device_ip_address))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_DEVICE_UDP_PORT)) != 0)
    {
        if (!bcmolt_buf_write_u16(buf, this->device_udp_port))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_TOD_UART_BAUDRATE)) != 0)
    {
        if (!bcmolt_uart_baudrate_pack(this->tod_uart_baudrate, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_STRING_LENGTH)) != 0)
    {
        if (!bcmolt_buf_write_u8(buf, this->gpon_xgpon_tod_string_length))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmolt_device_cfg_data_get_packed_length(const bcmolt_device_cfg_data *this, bcmolt_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_SYSTEM_MODE)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_KEEPALIVE_INTERVAL)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_KEEPALIVE_TOLERANCE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_FIRMWARE_SW_VERSION)) != 0)
    {
        count += 39;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_HOST_SW_VERSION)) != 0)
    {
        count += 39;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_REVISION)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_STATE)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_DEBUG)) != 0)
    {
        count += 7;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_NNI_SPEED)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_PROTECTION_SWITCHING_EXT_IRQ)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_CLOCK_TRANSPORT_SAMPLE_DELAY)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_INDICATION_SHAPING)) != 0)
    {
        count += 9;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_TEMPERATURE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_ENABLE)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_GPIO_PIN)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_CONNECTED_INTERNALLY)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_8021_AS_TOD_FORMAT)) != 0)
    {
        count += 256;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_SHAPER_MODE)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EMBEDDED_IMAGE_LIST)) != 0)
    {
        count += bcmolt_embedded_image_entry_list_u8_get_packed_length(&this->embedded_image_list);
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_CHIP_VOLTAGE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_EPON_TOD_STRING)) != 0)
    {
        count += 256;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_XGPON_NUM_OF_ONUS)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_DEVICE_IP_ADDRESS)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_DEVICE_UDP_PORT)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_TOD_UART_BAUDRATE)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_STRING_LENGTH)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmolt_device_cfg_data_unpack(bcmolt_device_cfg_data *this, bcmolt_buf *buf, void **extra_mem, bcmolt_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_SYSTEM_MODE)) != 0)
    {
        if (!bcmolt_system_mode_unpack(&this->system_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_KEEPALIVE_INTERVAL)) != 0)
    {
        if (!bcmolt_buf_read_u32(buf, &this->keepalive_interval))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMOLT_DEVICE_CFG_ID_KEEPALIVE_TOLERANCE)) != 0)
    {
        if (!bcmolt_buf_read_u32(buf, &this->keepalive_tolerance))
        {
         