/*
<:copyright-BRCM:2016:proprietary:standard
 
   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved
 
This program is the proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modified or distributed pursuant
to the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License").  Except as set forth in
an Authorized License, Broadcom grants no license (express or implied), right
to use, or waiver of any kind with respect to the Software, and Broadcom
expressly reserves all rights in and to the Software and all intellectual
property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 
Except as expressly set forth in the Authorized License,
 
1. This program, including its structure, sequence and organization,
    constitutes the valuable trade secrets of Broadcom, and you shall use
    all reasonable efforts to protect the confidentiality thereof, and to
    use this information only in connection with your use of Broadcom
    integrated circuit products.
 
2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
    PERFORMANCE OF THE SOFTWARE.
 
3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
    LIMITED REMEDY.
:>
*/
#ifndef BCMOLT_MODEL_IDS_H_
#define BCMOLT_MODEL_IDS_H_

/** \addtogroup api_data_types 
 * @{ 
 */

/** Identifiers for all properties contained in the ae_ni_cfg group. 
 */
typedef enum bcmolt_ae_ni_cfg_id
{
    BCMOLT_AE_NI_CFG_ID__BEGIN          = 0,
    BCMOLT_AE_NI_CFG_ID_MAC_ADDRESS     = 0,                /**< MAC Address. */
    BCMOLT_AE_NI_CFG_ID_AE_NI_EN        = 1,                /**< AE NI enable state. */
    BCMOLT_AE_NI_CFG_ID_MTU_10G         = 2,                /**< MTU. */
    BCMOLT_AE_NI_CFG_ID_PRBS_GENERATOR  = 3,                /**< PRBS Generator. */
    BCMOLT_AE_NI_CFG_ID_PRBS_CHECKER    = 4,                /**< PRBS Checker. */
    BCMOLT_AE_NI_CFG_ID_PRBS_STATUS     = 5,                /**< PRBS status. */
    BCMOLT_AE_NI_CFG_ID__NUM_OF                             /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_ni_cfg_id;

/** Identifiers for all properties contained in the ae_ni_key group. 
 */
typedef enum bcmolt_ae_ni_key_id
{
    BCMOLT_AE_NI_KEY_ID__BEGIN          = 0,
    BCMOLT_AE_NI_KEY_ID_AE_NI           = 0,                /**< AE NI number. */
    BCMOLT_AE_NI_KEY_ID__NUM_OF                             /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_ni_key_id;

/** Identifiers for all properties contained in the ae_ni_set_ae_ni_en_state 
 * group. 
 */
typedef enum bcmolt_ae_ni_set_ae_ni_en_state_id
{
    BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID__BEGIN   = 0,
    BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID_NEW_STATE= 0,        /**< New AE NI enable state. */
    BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID__NUM_OF              /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_ni_set_ae_ni_en_state_id;

/** Identifiers for all properties contained in the ae_path_ds_auto_cfg group. 
 */
typedef enum bcmolt_ae_path_ds_auto_cfg_id
{
    BCMOLT_AE_PATH_DS_AUTO_CFG_ID__BEGIN            = 0,
    BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED= 0,    /**< Stat Alarm Cleared. */
    BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_RAISED = 1,    /**< Stat Alarm Raised. */
    BCMOLT_AE_PATH_DS_AUTO_CFG_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_ds_auto_cfg_id;

/** Identifiers for all properties contained in the ae_path_ds_key group. 
 */
typedef enum bcmolt_ae_path_ds_key_id
{
    BCMOLT_AE_PATH_DS_KEY_ID__BEGIN                 = 0,
    BCMOLT_AE_PATH_DS_KEY_ID_AE_NI                  = 0,    /**< AE NI (Active Ethernet Network Interface) number. */
    BCMOLT_AE_PATH_DS_KEY_ID__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_ds_key_id;

/** Identifiers for all properties contained in the 
 * ae_path_ds_stat_alarm_cleared group. 
 */
typedef enum bcmolt_ae_path_ds_stat_alarm_cleared_id
{
    BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID__BEGIN  = 0,
    BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID_STAT    = 0,    /**< Statistic ID. */
    BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID__NUM_OF         /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_ds_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the ae_path_ds_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_ae_path_ds_stat_alarm_raised_id
{
    BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID__BEGIN   = 0,
    BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID_STAT     = 0,    /**< Statistic ID. */
    BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID__NUM_OF          /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_ds_stat_alarm_raised_id;

/** Identifiers for all properties contained in the ae_path_ds_stat_cfg group. 
 */
typedef enum bcmolt_ae_path_ds_stat_cfg_id
{
    BCMOLT_AE_PATH_DS_STAT_CFG_ID__BEGIN            = 0,
    BCMOLT_AE_PATH_DS_STAT_CFG_ID_CFG               = 0,    /**< Configuration. */
    BCMOLT_AE_PATH_DS_STAT_CFG_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_ds_stat_cfg_id;

/** Identifiers for all properties contained in the ae_path_ds_stat group. 
 */
typedef enum bcmolt_ae_path_ds_stat_id
{
    BCMOLT_AE_PATH_DS_STAT_ID__BEGIN                = 0,
    BCMOLT_AE_PATH_DS_STAT_ID_BYTES                 = 0,    /**< Bytes. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES                = 1,    /**< Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_64             = 2,    /**< 64 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_65_127         = 3,    /**< 65-127 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_128_255        = 4,    /**< 128-255 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_256_511        = 5,    /**< 256-511 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_512_1023       = 6,    /**< 512-1023 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1024_1518      = 7,    /**< 1024-1518 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1519_2047      = 8,    /**< 1519-2047 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_2048_4095      = 9,    /**< 2048_4095 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_4096_9216      = 10,   /**< 4096-9216 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_9217_16383     = 11,   /**< 9217-16383 Byte Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_BROADCAST_FRAMES      = 12,   /**< Broadcast Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_DATA_BYTES            = 13,   /**< Data Bytes. */
    BCMOLT_AE_PATH_DS_STAT_ID_MULTICAST_FRAMES      = 14,   /**< Mulitcast Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_UNICAST_FRAMES        = 15,   /**< Unicast Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID_ABORT_FRAMES          = 16,   /**< Abort Frames. */
    BCMOLT_AE_PATH_DS_STAT_ID__NUM_OF                       /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_ds_stat_id;

/** Identifiers for all properties contained in the ae_path_us_auto_cfg group. 
 */
typedef enum bcmolt_ae_path_us_auto_cfg_id
{
    BCMOLT_AE_PATH_US_AUTO_CFG_ID__BEGIN            = 0,
    BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_CLEARED= 0,    /**< Stat Alarm Cleared. */
    BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_RAISED = 1,    /**< Stat Alarm Raised. */
    BCMOLT_AE_PATH_US_AUTO_CFG_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_us_auto_cfg_id;

/** Identifiers for all properties contained in the ae_path_us_key group. 
 */
typedef enum bcmolt_ae_path_us_key_id
{
    BCMOLT_AE_PATH_US_KEY_ID__BEGIN                 = 0,
    BCMOLT_AE_PATH_US_KEY_ID_AE_NI                  = 0,    /**< AE NI. */
    BCMOLT_AE_PATH_US_KEY_ID__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_us_key_id;

/** Identifiers for all properties contained in the 
 * ae_path_us_stat_alarm_cleared group. 
 */
typedef enum bcmolt_ae_path_us_stat_alarm_cleared_id
{
    BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID__BEGIN  = 0,
    BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID_STAT    = 0,    /**< Statistic ID. */
    BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID__NUM_OF         /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_us_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the ae_path_us_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_ae_path_us_stat_alarm_raised_id
{
    BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID__BEGIN   = 0,
    BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID_STAT     = 0,    /**< Statistic ID. */
    BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID__NUM_OF          /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_us_stat_alarm_raised_id;

/** Identifiers for all properties contained in the ae_path_us_stat_cfg group. 
 */
typedef enum bcmolt_ae_path_us_stat_cfg_id
{
    BCMOLT_AE_PATH_US_STAT_CFG_ID__BEGIN            = 0,
    BCMOLT_AE_PATH_US_STAT_CFG_ID_CFG               = 0,    /**< Configuration. */
    BCMOLT_AE_PATH_US_STAT_CFG_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_us_stat_cfg_id;

/** Identifiers for all properties contained in the ae_path_us_stat group. 
 */
typedef enum bcmolt_ae_path_us_stat_id
{
    BCMOLT_AE_PATH_US_STAT_ID__BEGIN                = 0,
    BCMOLT_AE_PATH_US_STAT_ID_BYTES                 = 0,    /**< Bytes. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES                = 1,    /**< Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_64             = 2,    /**< 64 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_65_127         = 3,    /**< 65-127 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_128_255        = 4,    /**< 128-255 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_256_511        = 5,    /**< 256-511 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_512_1023       = 6,    /**< 512-1023 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1024_1518      = 7,    /**< 1024-1518 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1519_2047      = 8,    /**< 1519-2047 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_2048_4095      = 9,    /**< 2048_4095 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_4096_9216      = 10,   /**< 4096-9216 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FRAMES_9217_16383     = 11,   /**< 9217-16383 Byte Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_BROADCAST_FRAMES      = 12,   /**< Broadcast Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_DATA_BYTES            = 13,   /**< Data Bytes. */
    BCMOLT_AE_PATH_US_STAT_ID_MULTICAST_FRAMES      = 14,   /**< Mulitcast Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_UNICAST_FRAMES        = 15,   /**< Unicast Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_ABORT_FRAMES          = 16,   /**< Abort Frames. */
    BCMOLT_AE_PATH_US_STAT_ID_FCS_ERROR             = 17,   /**< FCS Error. */
    BCMOLT_AE_PATH_US_STAT_ID_OVERSIZE_ERROR        = 18,   /**< Oversize Error. */
    BCMOLT_AE_PATH_US_STAT_ID_RUNT_ERROR            = 19,   /**< Runt Error. */
    BCMOLT_AE_PATH_US_STAT_ID__NUM_OF                       /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_us_stat_id;

/** Identifiers for all properties contained in the channel_cfg group. 
 */
typedef enum bcmolt_channel_cfg_id
{
    BCMOLT_CHANNEL_CFG_ID__BEGIN                    = 0,
    BCMOLT_CHANNEL_CFG_ID_OPERATION_CONTROL         = 0,    /**< Operation control. */
    BCMOLT_CHANNEL_CFG_ID_TOL                       = 1,    /**< TOL. */
    BCMOLT_CHANNEL_CFG_ID_SYSTEM_PROFILE            = 2,    /**< System profile. */
    BCMOLT_CHANNEL_CFG_ID_CHANNEL_PROFILE           = 3,    /**< Channel profile. */
    BCMOLT_CHANNEL_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_channel_cfg_id;

/** Identifiers for all properties contained in the channel_key group. 
 */
typedef enum bcmolt_channel_key_id
{
    BCMOLT_CHANNEL_KEY_ID__BEGIN                    = 0,
    BCMOLT_CHANNEL_KEY_ID_PON_NI                    = 0,    /**< PON network interface. */
    BCMOLT_CHANNEL_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_channel_key_id;

/** Identifiers for all properties contained in the debug_auto_cfg group. 
 */
typedef enum bcmolt_debug_auto_cfg_id
{
    BCMOLT_DEBUG_AUTO_CFG_ID__BEGIN                 = 0,
    BCMOLT_DEBUG_AUTO_CFG_ID_CLI_OUTPUT             = 0,    /**< cli_output. */
    BCMOLT_DEBUG_AUTO_CFG_ID_FILE_ALMOST_FULL       = 1,    /**< file_almost_full. */
    BCMOLT_DEBUG_AUTO_CFG_ID__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_auto_cfg_id;

/** Identifiers for all properties contained in the debug_cfg group. 
 */
typedef enum bcmolt_debug_cfg_id
{
    BCMOLT_DEBUG_CFG_ID__BEGIN                      = 0,
    BCMOLT_DEBUG_CFG_ID_CONSOLE_REDIRECTION         = 0,    /**< Console_redirection. */
    BCMOLT_DEBUG_CFG_ID_INDICATIONS_DROPPED         = 1,    /**< Indications Dropped. */
    BCMOLT_DEBUG_CFG_ID_FILE_USED_PERCENT           = 2,    /**< File used percent. */
    BCMOLT_DEBUG_CFG_ID_API_CAPTURE_CFG             = 3,    /**< API Capture Cfg. */
    BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS           = 4,    /**< API Capture Stats. */
    BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER_READ     = 5,    /**< API Capture Buffer Read. */
    BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER          = 6,    /**< API Capture Buffer. */
    BCMOLT_DEBUG_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_cfg_id;

/** Identifiers for all properties contained in the debug_cli_input group. 
 */
typedef enum bcmolt_debug_cli_input_id
{
    BCMOLT_DEBUG_CLI_INPUT_ID__BEGIN                = 0,
    BCMOLT_DEBUG_CLI_INPUT_ID_DATA                  = 0,    /**< data. */
    BCMOLT_DEBUG_CLI_INPUT_ID__NUM_OF                       /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_cli_input_id;

/** Identifiers for all properties contained in the debug_cli_output group. 
 */
typedef enum bcmolt_debug_cli_output_id
{
    BCMOLT_DEBUG_CLI_OUTPUT_ID__BEGIN               = 0,
    BCMOLT_DEBUG_CLI_OUTPUT_ID_DATA                 = 0,    /**< data. */
    BCMOLT_DEBUG_CLI_OUTPUT_ID__NUM_OF                      /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_cli_output_id;

/** Identifiers for all properties contained in the debug_file_almost_full 
 * group. 
 */
typedef enum bcmolt_debug_file_almost_full_id
{
    BCMOLT_DEBUG_FILE_ALMOST_FULL_ID__NUM_OF                /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_file_almost_full_id;

/** Identifiers for all properties contained in the debug_key group. 
 */
typedef enum bcmolt_debug_key_id
{
    BCMOLT_DEBUG_KEY_ID__BEGIN                      = 0,
    BCMOLT_DEBUG_KEY_ID_RESERVED                    = 0,    /**< Reserved. */
    BCMOLT_DEBUG_KEY_ID__NUM_OF                 /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_key_id;

/** Identifiers for all properties contained in the debug_reset_api_capture 
 * group. 
 */
typedef enum bcmolt_debug_reset_api_capture_id
{
    BCMOLT_DEBUG_RESET_API_CAPTURE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_reset_api_capture_id;

/** Identifiers for all properties contained in the debug_start_api_capture 
 * group. 
 */
typedef enum bcmolt_debug_start_api_capture_id
{
    BCMOLT_DEBUG_START_API_CAPTURE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_start_api_capture_id;

/** Identifiers for all properties contained in the debug_stop_api_capture 
 * group. 
 */
typedef enum bcmolt_debug_stop_api_capture_id
{
    BCMOLT_DEBUG_STOP_API_CAPTURE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_stop_api_capture_id;

/** Identifiers for all properties contained in the device_auto_cfg group. 
 */
typedef enum bcmolt_device_auto_cfg_id
{
    BCMOLT_DEVICE_AUTO_CFG_ID__BEGIN                    = 0,
    BCMOLT_DEVICE_AUTO_CFG_ID_CONNECTION_COMPLETE       = 0,    /**< Connection Complete. */
    BCMOLT_DEVICE_AUTO_CFG_ID_CONNECTION_ESTABLISHED    = 1,    /**< Connection Established (Internal). */
    BCMOLT_DEVICE_AUTO_CFG_ID_CONNECTION_FAILURE        = 2,    /**< Connection Failure. */
    BCMOLT_DEVICE_AUTO_CFG_ID_DDR_TEST_COMPLETE         = 3,    /**< DDR Test Complete. */
    BCMOLT_DEVICE_AUTO_CFG_ID_DEVICE_KEEP_ALIVE         = 4,    /**< Device Keep Alive (Internal). */
    BCMOLT_DEVICE_AUTO_CFG_ID_DEVICE_READY              = 5,    /**< Device Ready (Internal). */
    BCMOLT_DEVICE_AUTO_CFG_ID_DISCONNECTION_COMPLETE    = 6,    /**< Disconnection Complete. */
    BCMOLT_DEVICE_AUTO_CFG_ID_IMAGE_TRANSFER_COMPLETE   = 7,    /**< Image Transfer Complete. */
    BCMOLT_DEVICE_AUTO_CFG_ID_INDICATIONS_DROPPED       = 8,    /**< Indications Dropped. */
    BCMOLT_DEVICE_AUTO_CFG_ID_SW_ERROR                  = 9,    /**< sw error. */
    BCMOLT_DEVICE_AUTO_CFG_ID_SW_EXCEPTION              = 10,   /**< sw exception. */
    BCMOLT_DEVICE_AUTO_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_device_auto_cfg_id;

/** Identifiers for all properties contained in the device_cfg group. 
 */
typedef enum bcmolt_device_cfg_id
{
    BCMOLT_DEVICE_CFG_ID__BEGIN                             = 0,
    BCMOLT_DEVICE_CFG_ID_SYSTEM_MODE                        = 0,    /**< system_mode. */
    BCMOLT_DEVICE_CFG_ID_KEEPALIVE_INTERVAL                 = 1,    /**< Device Keepalive Interval. */
    BCMOLT_DEVICE_CFG_ID_KEEPALIVE_TOLERANCE                = 2,    /**< Device Keepalive tolerance . */
    BCMOLT_DEVICE_CFG_ID_FIRMWARE_SW_VERSION                = 3,    /**< Firmware SW Version. */
    BCMOLT_DEVICE_CFG_ID_HOST_SW_VERSION                    = 4,    /**< Host SW Version. */
    BCMOLT_DEVICE_CFG_ID_CHIP_REVISION                      = 5,    /**< Chip Revision. */
    BCMOLT_DEVICE_CFG_ID_STATE                              = 6,    /**< Device state. */
    BCMOLT_DEVICE_CFG_ID_DEBUG                              = 7,    /**< debug parameters. */
    BCMOLT_DEVICE_CFG_ID_NNI_SPEED                          = 8,    /**< NNI Speed. */
    BCMOLT_DEVICE_CFG_ID_PROTECTION_SWITCHING_EXT_IRQ       = 9,    /**< Protection Switching External IRQ. */
    BCMOLT_DEVICE_CFG_ID_EPON_CLOCK_TRANSPORT_SAMPLE_DELAY  = 10,   /**< EPON Clock Transport Sample Delay. */
    BCMOLT_DEVICE_CFG_ID_INDICATION_SHAPING                 = 11,   /**< Indication Shaping. */
    BCMOLT_DEVICE_CFG_ID_CHIP_TEMPERATURE                   = 12,   /**< chip temperature . */
    BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_ENABLE              = 13,   /**< GPON/XGPON ToD enable. */
    BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_GPIO_PIN            = 14,   /**< GPON/XGPON ToD GPIO pin. */
    BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_CONNECTED_INTERNALLY= 15,   /**< GPON/XGPON is ToD internally. */
    BCMOLT_DEVICE_CFG_ID_EPON_8021_AS_TOD_FORMAT            = 16,   /**< EPON 802.1AS ToD Format. */
    BCMOLT_DEVICE_CFG_ID_EPON_SHAPER_MODE                   = 17,   /**< EPON Shaper Mode. */
    BCMOLT_DEVICE_CFG_ID_EMBEDDED_IMAGE_LIST                = 18,   /**< Embedded image list. */
    BCMOLT_DEVICE_CFG_ID_CHIP_VOLTAGE                       = 19,   /**< chip voltage. */
    BCMOLT_DEVICE_CFG_ID_EPON_TOD_STRING                    = 20,   /**< EPON ToD String. */
    BCMOLT_DEVICE_CFG_ID_XGPON_NUM_OF_ONUS                  = 21,   /**< xgpon num of onus. */
    BCMOLT_DEVICE_CFG_ID_DEVICE_IP_ADDRESS                  = 22,   /**< Device IP Address. */
    BCMOLT_DEVICE_CFG_ID_DEVICE_UDP_PORT                    = 23,   /**< Device UDP port. */
    BCMOLT_DEVICE_CFG_ID_TOD_UART_BAUDRATE                  = 24,   /**< UART baudrate. */
    BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_STRING_LENGTH       = 25,   /**< GPON/XGPON ToD string length. */
    BCMOLT_DEVICE_CFG_ID__NUM_OF        /**< Number of enum entries, not an entry itself. */
} bcmolt_device_cfg_id;

/** Identifiers for all properties contained in the device_connect group. 
 */
typedef enum bcmolt_device_connect_id
{
    BCMOLT_DEVICE_CONNECT_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_device_connect_id;

/** Identifiers for all properties contained in the device_connection_complete 
 * group. 
 */
typedef enum bcmolt_device_connection_complete_id
{
    BCMOLT_DEVICE_CONNECTION_COMPLETE_ID__BEGIN             = 0,
    BCMOLT_DEVICE_CONNECTION_COMPLETE_ID_STANDALONE         = 0,    /**< Standalone. */
    BCMOLT_DEVICE_CONNECTION_COMPLETE_ID__NUM_OF                    /**< Number of enum entries, not an entry itself. */
} bcmolt_device_connection_complete_id;

/** Identifiers for all properties contained in the 
 * device_connection_established group. 
 */
typedef enum bcmolt_device_connection_established_id
{
    BCMOLT_DEVICE_CONNECTION_ESTABLISHED_ID__NUM_OF                 /**< Number of enum entries, not an entry itself. */
} bcmolt_device_connection_established_id;

/** Identifiers for all properties contained in the device_connection_failure 
 * group. 
 */
typedef enum bcmolt_device_connection_failure_id
{
    BCMOLT_DEVICE_CONNECTION_FAILURE_ID__BEGIN              = 0,
    BCMOLT_DEVICE_CONNECTION_FAILURE_ID_REASON              = 0,    /**< Connection fail reason. */
    BCMOLT_DEVICE_CONNECTION_FAILURE_ID__NUM_OF                     /**< Number of enum entries, not an entry itself. */
} bcmolt_device_connection_failure_id;

/** Identifiers for all properties contained in the device_ddr_test_complete 
 * group. 
 */
typedef enum bcmolt_device_ddr_test_complete_id
{
    BCMOLT_DEVICE_DDR_TEST_COMPLETE_ID__BEGIN               = 0,
    BCMOLT_DEVICE_DDR_TEST_COMPLETE_ID_DDR_TEST             = 0,    /**< DDR Test. */
    BCMOLT_DEVICE_DDR_TEST_COMPLETE_ID__NUM_OF                      /**< Number of enum entries, not an entry itself. */
} bcmolt_device_ddr_test_complete_id;

/** Identifiers for all properties contained in the device_device_keep_alive 
 * group. 
 */
typedef enum bcmolt_device_device_keep_alive_id
{
    BCMOLT_DEVICE_DEVICE_KEEP_ALIVE_ID__BEGIN               = 0,
    BCMOLT_DEVICE_DEVICE_KEEP_ALIVE_ID_SEQUENCE_NUMBER      = 0,    /**< sequence number. */
    BCMOLT_DEVICE_DEVICE_KEEP_ALIVE_ID_TIME_STAMP           = 1,    /**< time stamp. */
    BCMOLT_DEVICE_DEVICE_KEEP_ALIVE_ID__NUM_OF                      /**< Number of enum entries, not an entry itself. */
} bcmolt_device_device_keep_alive_id;

/** Identifiers for all properties contained in the device_device_ready group. 
 */
typedef enum bcmolt_device_device_ready_id
{
    BCMOLT_DEVICE_DEVICE_READY_ID__BEGIN                    = 0,
    BCMOLT_DEVICE_DEVICE_READY_ID_FIRMWARE_SW_VERSION       = 0,    /**< Software Version. */
    BCMOLT_DEVICE_DEVICE_READY_ID_SYSTEM_MODE               = 1,    /**< System Mode. */
    BCMOLT_DEVICE_DEVICE_READY_ID_NNI_SPEED                 = 2,    /**< NNI Speed. */
    BCMOLT_DEVICE_DEVICE_READY_ID_CHIP_REVISION             = 3,    /**< Chip Revision. */
    BCMOLT_DEVICE_DEVICE_READY_ID_TOD_ENABLE                = 4,    /**< ToD control. */
    BCMOLT_DEVICE_DEVICE_READY_ID_TOD_GPIO_PIN              = 5,    /**< GPIO pin is used when ToD UART is not connected to the embedded, and TOD value is obtained by the host. */
    BCMOLT_DEVICE_DEVICE_READY_ID__NUM_OF           /**< Number of enum entries, not an entry itself. */
} bcmolt_device_device_ready_id;

/** Identifiers for all properties contained in the device_disconnect group. 
 */
typedef enum bcmolt_device_disconnect_id
{
    BCMOLT_DEVICE_DISCONNECT_ID__NUM_OF             /**< Number of enum entries, not an entry itself. */
} bcmolt_device_disconnect_id;

/** Identifiers for all properties contained in the 
 * device_disconnection_complete group. 
 */
typedef enum bcmolt_device_disconnection_complete_id
{
    BCMOLT_DEVICE_DISCONNECTION_COMPLETE_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_device_disconnection_complete_id;

/** Identifiers for all properties contained in the device_host_keep_alive 
 * group. 
 */
typedef enum bcmolt_device_host_keep_alive_id
{
    BCMOLT_DEVICE_HOST_KEEP_ALIVE_ID__BEGIN                 = 0,
    BCMOLT_DEVICE_HOST_KEEP_ALIVE_ID_SEQUENCE_NUMBER        = 0,    /**< sequence number. */
    BCMOLT_DEVICE_HOST_KEEP_ALIVE_ID_TIME_STAMP             = 1,    /**< time stamp. */
    BCMOLT_DEVICE_HOST_KEEP_ALIVE_ID__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_device_host_keep_alive_id;

/** Identifiers for all properties contained in the 
 * device_image_transfer_complete group. 
 */
typedef enum bcmolt_device_image_transfer_complete_id
{
    BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID__BEGIN         = 0,
    BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID_IMAGE_TYPE     = 0,    /**< Image type. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID_BLOCK_NUMBER   = 1,    /**< Block number. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID_STATUS         = 2,    /**< Status. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID__NUM_OF                /**< Number of enum entries, not an entry itself. */
} bcmolt_device_image_transfer_complete_id;

/** Identifiers for all properties contained in the device_image_transfer_data 
 * group. 
 */
typedef enum bcmolt_device_image_transfer_data_id
{
    BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID__BEGIN             = 0,
    BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID_BLOCK_NUMBER       = 0,    /**< Block number. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID_MORE_DATA          = 1,    /**< More Data. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID_DATA               = 2,    /**< Data. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID__NUM_OF                    /**< Number of enum entries, not an entry itself. */
} bcmolt_device_image_transfer_data_id;

/** Identifiers for all properties contained in the device_image_transfer_start 
 * group. 
 */
typedef enum bcmolt_device_image_transfer_start_id
{
    BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID__BEGIN            = 0,
    BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID_IMAGE_TYPE        = 0,    /**< Image type. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID_IMAGE_SIZE        = 1,    /**< Image Size. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID_CRC32             = 2,    /**< CRC32. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID_IMAGE_NAME        = 3,    /**< Image name. */
    BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_device_image_transfer_start_id;

/** Identifiers for all properties contained in the device_indications_dropped 
 * group. 
 */
typedef enum bcmolt_device_indications_dropped_id
{
    BCMOLT_DEVICE_INDICATIONS_DROPPED_ID__BEGIN             = 0,
    BCMOLT_DEVICE_INDICATIONS_DROPPED_ID_TOTAL_COUNT        = 0,    /**< Total Count. */
    BCMOLT_DEVICE_INDICATIONS_DROPPED_ID__NUM_OF                    /**< Number of enum entries, not an entry itself. */
} bcmolt_device_indications_dropped_id;

/** Identifiers for all properties contained in the device_key group. 
 */
typedef enum bcmolt_device_key_id
{
    BCMOLT_DEVICE_KEY_ID__BEGIN                             = 0,
    BCMOLT_DEVICE_KEY_ID_RESERVED                           = 0,    /**< Reserved. */
    BCMOLT_DEVICE_KEY_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_device_key_id;

/** Identifiers for all properties contained in the device_reset group. 
 */
typedef enum bcmolt_device_reset_id
{
    BCMOLT_DEVICE_RESET_ID__BEGIN                           = 0,
    BCMOLT_DEVICE_RESET_ID_MODE                             = 0,    /**< Mode. */
    BCMOLT_DEVICE_RESET_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_device_reset_id;

/** Identifiers for all properties contained in the device_run_ddr_test group. 
 */
typedef enum bcmolt_device_run_ddr_test_id
{
    BCMOLT_DEVICE_RUN_DDR_TEST_ID__BEGIN                    = 0,
    BCMOLT_DEVICE_RUN_DDR_TEST_ID_CPU                       = 0,    /**< CPU. */
    BCMOLT_DEVICE_RUN_DDR_TEST_ID_RAS_0                     = 1,    /**< RAS 0. */
    BCMOLT_DEVICE_RUN_DDR_TEST_ID_RAS_1                     = 2,    /**< RAS 1. */
    BCMOLT_DEVICE_RUN_DDR_TEST_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_device_run_ddr_test_id;

/** Identifiers for all properties contained in the device_sw_error group. 
 */
typedef enum bcmolt_device_sw_error_id
{
    BCMOLT_DEVICE_SW_ERROR_ID__BEGIN                        = 0,
    BCMOLT_DEVICE_SW_ERROR_ID_TASK_NAME                     = 0,    /**< task name. */
    BCMOLT_DEVICE_SW_ERROR_ID_FILE_NAME                     = 1,    /**< file name. */
    BCMOLT_DEVICE_SW_ERROR_ID_LINE_NUMBER                   = 2,    /**< line number. */
    BCMOLT_DEVICE_SW_ERROR_ID_PON_NI                        = 3,    /**< pon_ni. */
    BCMOLT_DEVICE_SW_ERROR_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_device_sw_error_id;

/** Identifiers for all properties contained in the device_sw_exception group. 
 */
typedef enum bcmolt_device_sw_exception_id
{
    BCMOLT_DEVICE_SW_EXCEPTION_ID__BEGIN                    = 0,
    BCMOLT_DEVICE_SW_EXCEPTION_ID_CPU_ID                    = 0,    /**< CPU ID. */
    BCMOLT_DEVICE_SW_EXCEPTION_ID_TEXT                      = 1,    /**< text. */
    BCMOLT_DEVICE_SW_EXCEPTION_ID__NUM_OF           /**< Number of enum entries, not an entry itself. */
} bcmolt_device_sw_exception_id;

/** Identifiers for all properties contained in the device_sw_upgrade_activate 
 * group. 
 */
typedef enum bcmolt_device_sw_upgrade_activate_id
{
    BCMOLT_DEVICE_SW_UPGRADE_ACTIVATE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_device_sw_upgrade_activate_id;

/** Identifiers for all properties contained in the epon_denied_link_auto_cfg 
 * group. 
 */
typedef enum bcmolt_epon_denied_link_auto_cfg_id
{
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID__BEGIN                      = 0,
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_LASER_ON_OFF_VIOLATION      = 0,    /**< Laser On/Off Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_LLID_POOL_EMPTY_VIOLATION   = 1,    /**< LLID Pool Empty Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_MAX_LINK_VIOLATION          = 2,    /**< Max Link Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_OVERHEAD_PROFILE_VIOLATION  = 3,    /**< Overhead Profile Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_RANGE_VIOLATION             = 4,    /**< Range Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_ROGUE_VIOLATION             = 5,    /**< Rogue ONU Detected. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_SYSTEM_RESOURCE_VIOLATION   = 6,    /**< System Resource Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_TDM_CHANNELS_EXHAUSTED      = 7,    /**< TDM Channels Exhausted. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_UNKNOWN_LINK_VIOLATION      = 8,    /**< Unknown Link Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_UPSTREAM_BANDWIDTH_VIOLATION= 9,    /**< Upstream Bandwidth Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_auto_cfg_id;

/** Identifiers for all properties contained in the epon_denied_link_cfg group. 
 */
typedef enum bcmolt_epon_denied_link_cfg_id
{
    BCMOLT_EPON_DENIED_LINK_CFG_ID__BEGIN                           = 0,
    BCMOLT_EPON_DENIED_LINK_CFG_ID_ALARM_STATE                      = 0,    /**< Alarm State. */
    BCMOLT_EPON_DENIED_LINK_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_cfg_id;

/** Identifiers for all properties contained in the epon_denied_link_key group. 
 */
typedef enum bcmolt_epon_denied_link_key_id
{
    BCMOLT_EPON_DENIED_LINK_KEY_ID__BEGIN                           = 0,
    BCMOLT_EPON_DENIED_LINK_KEY_ID_EPON_NI                          = 0,    /**< EPON NI Identifier. */
    BCMOLT_EPON_DENIED_LINK_KEY_ID_MAC_ADDRESS                      = 1,    /**< MAC Address. */
    BCMOLT_EPON_DENIED_LINK_KEY_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_key_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_laser_on_off_violation group. 
 */
typedef enum bcmolt_epon_denied_link_laser_on_off_violation_id
{
    BCMOLT_EPON_DENIED_LINK_LASER_ON_OFF_VIOLATION_ID__BEGIN        = 0,
    BCMOLT_EPON_DENIED_LINK_LASER_ON_OFF_VIOLATION_ID_ALARM_STATUS  = 0,        /**< Alarm Status. */
    BCMOLT_EPON_DENIED_LINK_LASER_ON_OFF_VIOLATION_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_laser_on_off_violation_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_llid_pool_empty_violation group. 
 */
typedef enum bcmolt_epon_denied_link_llid_pool_empty_violation_id
{
    BCMOLT_EPON_DENIED_LINK_LLID_POOL_EMPTY_VIOLATION_ID__BEGIN         = 0,
    BCMOLT_EPON_DENIED_LINK_LLID_POOL_EMPTY_VIOLATION_ID_ALARM_STATUS   = 0,    /**< Alarm Status. */
    BCMOLT_EPON_DENIED_LINK_LLID_POOL_EMPTY_VIOLATION_ID__NUM_OF                /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_llid_pool_empty_violation_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_max_link_violation group. 
 */
typedef enum bcmolt_epon_denied_link_max_link_violation_id
{
    BCMOLT_EPON_DENIED_LINK_MAX_LINK_VIOLATION_ID__BEGIN                = 0,
    BCMOLT_EPON_DENIED_LINK_MAX_LINK_VIOLATION_ID_ALARM_STATUS          = 0,    /**< Alarm Status. */
    BCMOLT_EPON_DENIED_LINK_MAX_LINK_VIOLATION_ID__NUM_OF                       /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_max_link_violation_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_overhead_profile_violation group. 
 */
typedef enum bcmolt_epon_denied_link_overhead_profile_violation_id
{
    BCMOLT_EPON_DENIED_LINK_OVERHEAD_PROFILE_VIOLATION_ID__BEGIN        = 0,
    BCMOLT_EPON_DENIED_LINK_OVERHEAD_PROFILE_VIOLATION_ID_ALARM_STATUS  = 0,    /**< Alarm status. */
    BCMOLT_EPON_DENIED_LINK_OVERHEAD_PROFILE_VIOLATION_ID__NUM_OF               /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_overhead_profile_violation_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_range_violation group. 
 */
typedef enum bcmolt_epon_denied_link_range_violation_id
{
    BCMOLT_EPON_DENIED_LINK_RANGE_VIOLATION_ID__BEGIN                   = 0,
    BCMOLT_EPON_DENIED_LINK_RANGE_VIOLATION_ID_ALARM_STATUS             = 0,    /**< Alarm Status. */
    BCMOLT_EPON_DENIED_LINK_RANGE_VIOLATION_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_range_violation_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_rogue_violation group. 
 */
typedef enum bcmolt_epon_denied_link_rogue_violation_id
{
    BCMOLT_EPON_DENIED_LINK_ROGUE_VIOLATION_ID__BEGIN                   = 0,
    BCMOLT_EPON_DENIED_LINK_ROGUE_VIOLATION_ID_ALARM_STATUS             = 0,    /**< Alarm Status. */
    BCMOLT_EPON_DENIED_LINK_ROGUE_VIOLATION_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_rogue_violation_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_system_resource_violation group. 
 */
typedef enum bcmolt_epon_denied_link_system_resource_violation_id
{
    BCMOLT_EPON_DENIED_LINK_SYSTEM_RESOURCE_VIOLATION_ID__BEGIN         = 0,
    BCMOLT_EPON_DENIED_LINK_SYSTEM_RESOURCE_VIOLATION_ID_ALARM_STATUS   = 0,    /**< Alarm Status. */
    BCMOLT_EPON_DENIED_LINK_SYSTEM_RESOURCE_VIOLATION_ID__NUM_OF                /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_system_resource_violation_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_tdm_channels_exhausted group. 
 */
typedef enum bcmolt_epon_denied_link_tdm_channels_exhausted_id
{
    BCMOLT_EPON_DENIED_LINK_TDM_CHANNELS_EXHAUSTED_ID__BEGIN            = 0,
    BCMOLT_EPON_DENIED_LINK_TDM_CHANNELS_EXHAUSTED_ID_ALARM_STATUS      = 0,    /**< Alarm Status. */
    BCMOLT_EPON_DENIED_LINK_TDM_CHANNELS_EXHAUSTED_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_tdm_channels_exhausted_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_unknown_link_violation group. 
 */
typedef enum bcmolt_epon_denied_link_unknown_link_violation_id
{
    BCMOLT_EPON_DENIED_LINK_UNKNOWN_LINK_VIOLATION_ID__BEGIN            = 0,
    BCMOLT_EPON_DENIED_LINK_UNKNOWN_LINK_VIOLATION_ID_ALARM_STATUS      = 0,    /**< Alarm Status. */
    BCMOLT_EPON_DENIED_LINK_UNKNOWN_LINK_VIOLATION_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_unknown_link_violation_id;

/** Identifiers for all properties contained in the 
 * epon_denied_link_upstream_bandwidth_violation group. 
 */
typedef enum bcmolt_epon_denied_link_upstream_bandwidth_violation_id
{
    BCMOLT_EPON_DENIED_LINK_UPSTREAM_BANDWIDTH_VIOLATION_ID__BEGIN      = 0,
    BCMOLT_EPON_DENIED_LINK_UPSTREAM_BANDWIDTH_VIOLATION_ID_ALARM_STATUS= 0,    /**< Alarm Status. */
    BCMOLT_EPON_DENIED_LINK_UPSTREAM_BANDWIDTH_VIOLATION_ID__NUM_OF             /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_upstream_bandwidth_violation_id;

/** Identifiers for all properties contained in the epon_link_auto_cfg group. 
 */
typedef enum bcmolt_epon_link_auto_cfg_id
{
    BCMOLT_EPON_LINK_AUTO_CFG_ID__BEGIN                                 = 0,
    BCMOLT_EPON_LINK_AUTO_CFG_ID_DUPLICATE_MPCP_REGISTRATION_REQUEST    = 0,    /**< Duplicate MPCP Registration Request. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_ENCRYPTION_ENABLED                     = 1,    /**< Encryption Enabled. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_KEY_EXCHANGE_FAILURE                   = 2,    /**< Key Exchange Failure. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_KEY_EXCHANGE_STARTED                   = 3,    /**< key_exchange_started. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_KEY_EXCHANGE_STOPPED                   = 4,    /**< key_exchange_stopped. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_LINK_DELETED                           = 5,    /**< Link Deleted. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_LINK_SPEED_MISMATCH                    = 6,    /**< Link attempted to register at a different speed. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_MPCP_DEREGISTERED                      = 7,    /**< MPCP Deregistered. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_MPCP_DISCOVERED                        = 8,    /**< MPCP Discovered. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_MPCP_REG_ACK_TIMEOUT                   = 9,    /**< MPCP Reg Ack Timeout. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_MPCP_REPORT_TIMEOUT                    = 10,   /**< MPCP Report Timeout. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_OAM_KEEPALIVE_TIMEOUT                  = 11,   /**< OAM Keepalive Timeout. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_OAM_KEEPALIVE_TIMER_STARTED            = 12,   /**< OAM keepalive timer started. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_OAM_KEEPALIVE_TIMER_STOPPED            = 13,   /**< OAM keepalive timer stopped. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_PREPROVISIONED_LINK_CREATED            = 14,   /**< Preprovisioned Link Created. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_PROTECTION_SWITCH_OCCURRED             = 15,   /**< Protection Switch Occurred. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_RANGE_VALUE_CHANGED                    = 16,   /**< Range Value Changed. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_RERANGE_FAILURE                        = 17,   /**< Re-range failure. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_STAT_ALARM_CLEARED                     = 18,   /**< Stat Alarm Cleared. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_STAT_ALARM_RAISED                      = 19,   /**< Stat Alarm Raised. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID_STATIC_REGISTRATION_DONE               = 20,   /**< Static registration done. */
    BCMOLT_EPON_LINK_AUTO_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_auto_cfg_id;

/** Identifiers for all properties contained in the epon_link_cfg group. 
 */
typedef enum bcmolt_epon_link_cfg_id
{
    BCMOLT_EPON_LINK_CFG_ID__BEGIN                                      = 0,
    BCMOLT_EPON_LINK_CFG_ID_LINK_RATE                                   = 0,    /**< EPON link rate. */
    BCMOLT_EPON_LINK_CFG_ID_STATE_FLAGS                                 = 1,    /**< EPON link state flags. */
    BCMOLT_EPON_LINK_CFG_ID_LLID                                        = 2,    /**< EPON logical link identifier. */
    BCMOLT_EPON_LINK_CFG_ID_LASER_ON_TIME_TQ                            = 3,    /**< Laser-on time (TQ). */
    BCMOLT_EPON_LINK_CFG_ID_LASER_OFF_TIME_TQ                           = 4,    /**< Laser-off time (TQ). */
    BCMOLT_EPON_LINK_CFG_ID_RANGE_VALUE_TQ                              = 5,    /**< Range value (TQ). */
    BCMOLT_EPON_LINK_CFG_ID_DISTANCE                                    = 6,    /**< Distance. */
    BCMOLT_EPON_LINK_CFG_ID_ALARM_STATE                                 = 7,    /**< Alarm State. */
    BCMOLT_EPON_LINK_CFG_ID_TUNNEL_ID                                   = 8,    /**< Tunnel ID. */
    BCMOLT_EPON_LINK_CFG_ID_ONU_ID                                      = 9,    /**< Associated ONU. */
    BCMOLT_EPON_LINK_CFG_ID_MIN_LASER_OVERHEAD                          = 10,   /**< Min Laser Overhead. */
    BCMOLT_EPON_LINK_CFG_ID_KEY_EXCHANGE_CONFIG                         = 11,   /**< Key exchange configuration. */
    BCMOLT_EPON_LINK_CFG_ID_EPON_ENCRYPTION                             = 12,   /**< EPON Encryption . */
    BCMOLT_EPON_LINK_CFG_ID_FEC_ENABLE                                  = 13,   /**< FEC enable. */
    BCMOLT_EPON_LINK_CFG_ID_OAM_HEARTBEAT_CONFIG                        = 14,   /**< OAM heartbeat configuration. */
    BCMOLT_EPON_LINK_CFG_ID_UPSTREAM_BANDWIDTH                          = 15,   /**< Upstream Bandwidth. */
    BCMOLT_EPON_LINK_CFG_ID_UBD_INFO                                    = 16,   /**< UBD Info. */
    BCMOLT_EPON_LINK_CFG_ID_CLOCK_TRANSPORT_ENABLE                      = 17,   /**< Clock Transport Enable. */
    BCMOLT_EPON_LINK_CFG_ID_PENDING_GRANTS                              = 18,   /**< Pending grants. */
    BCMOLT_EPON_LINK_CFG_ID_LINK_TYPE                                   = 19,   /**< Link Type. */
    BCMOLT_EPON_LINK_CFG_ID__NUM_OF         /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_cfg_id;

/** Identifiers for all properties contained in the epon_link_delete_link group. 
 */
typedef enum bcmolt_epon_link_delete_link_id
{
    BCMOLT_EPON_LINK_DELETE_LINK_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_delete_link_id;

/** Identifiers for all properties contained in the 
 * epon_link_duplicate_mpcp_registration_request group. 
 */
typedef enum bcmolt_epon_link_duplicate_mpcp_registration_request_id
{
    BCMOLT_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST_ID__BEGIN          = 0,
    BCMOLT_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST_ID_INITIAL_RANGE_TQ= 0,    /**< Initial range. */
    BCMOLT_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST_ID_CURRENT_RANGE_TQ= 1,    /**< Current range. */
    BCMOLT_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST_ID__NUM_OF                 /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_duplicate_mpcp_registration_request_id;

/** Identifiers for all properties contained in the epon_link_encryption_enabled 
 * group. 
 */
typedef enum bcmolt_epon_link_encryption_enabled_id
{
    BCMOLT_EPON_LINK_ENCRYPTION_ENABLED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_encryption_enabled_id;

/** Identifiers for all properties contained in the epon_link_force_rediscovery 
 * group. 
 */
typedef enum bcmolt_epon_link_force_rediscovery_id
{
    BCMOLT_EPON_LINK_FORCE_REDISCOVERY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_force_rediscovery_id;

/** Identifiers for all properties contained in the epon_link_frame_captured 
 * group. 
 */
typedef enum bcmolt_epon_link_frame_captured_id
{
    BCMOLT_EPON_LINK_FRAME_CAPTURED_ID__BEGIN                               = 0,
    BCMOLT_EPON_LINK_FRAME_CAPTURED_ID_FRAME                                = 0,    /**< Received frame. */
    BCMOLT_EPON_LINK_FRAME_CAPTURED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_frame_captured_id;

/** Identifiers for all properties contained in the epon_link_inject_frame 
 * group. 
 */
typedef enum bcmolt_epon_link_inject_frame_id
{
    BCMOLT_EPON_LINK_INJECT_FRAME_ID__BEGIN                                 = 0,
    BCMOLT_EPON_LINK_INJECT_FRAME_ID_FRAME                                  = 0,    /**< Frame to transmit. */
    BCMOLT_EPON_LINK_INJECT_FRAME_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_inject_frame_id;

/** Identifiers for all properties contained in the 
 * epon_link_key_exchange_failure group. 
 */
typedef enum bcmolt_epon_link_key_exchange_failure_id
{
    BCMOLT_EPON_LINK_KEY_EXCHANGE_FAILURE_ID__BEGIN                         = 0,
    BCMOLT_EPON_LINK_KEY_EXCHANGE_FAILURE_ID_ALARM_STATUS                   = 0,    /**< alarm status. */
    BCMOLT_EPON_LINK_KEY_EXCHANGE_FAILURE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_key_exchange_failure_id;

/** Identifiers for all properties contained in the epon_link_key_exchange_start 
 * group. 
 */
typedef enum bcmolt_epon_link_key_exchange_start_id
{
    BCMOLT_EPON_LINK_KEY_EXCHANGE_START_ID__BEGIN                           = 0,
    BCMOLT_EPON_LINK_KEY_EXCHANGE_START_ID_PERIOD                           = 0,    /**< period. */
    BCMOLT_EPON_LINK_KEY_EXCHANGE_START_ID__NUM_OF      /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_key_exchange_start_id;

/** Identifiers for all properties contained in the 
 * epon_link_key_exchange_started group. 
 */
typedef enum bcmolt_epon_link_key_exchange_started_id
{
    BCMOLT_EPON_LINK_KEY_EXCHANGE_STARTED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_key_exchange_started_id;

/** Identifiers for all properties contained in the epon_link_key_exchange_stop 
 * group. 
 */
typedef enum bcmolt_epon_link_key_exchange_stop_id
{
    BCMOLT_EPON_LINK_KEY_EXCHANGE_STOP_ID__NUM_OF       /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_key_exchange_stop_id;

/** Identifiers for all properties contained in the 
 * epon_link_key_exchange_stopped group. 
 */
typedef enum bcmolt_epon_link_key_exchange_stopped_id
{
    BCMOLT_EPON_LINK_KEY_EXCHANGE_STOPPED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_key_exchange_stopped_id;

/** Identifiers for all properties contained in the epon_link_key group. 
 */
typedef enum bcmolt_epon_link_key_id
{
    BCMOLT_EPON_LINK_KEY_ID__BEGIN                                          = 0,
    BCMOLT_EPON_LINK_KEY_ID_EPON_NI                                         = 0,    /**< EPON NI identifier. */
    BCMOLT_EPON_LINK_KEY_ID_MAC_ADDRESS                                     = 1,    /**< MAC address. */
    BCMOLT_EPON_LINK_KEY_ID__NUM_OF             /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_key_id;

/** Identifiers for all properties contained in the epon_link_link_deleted 
 * group. 
 */
typedef enum bcmolt_epon_link_link_deleted_id
{
    BCMOLT_EPON_LINK_LINK_DELETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_link_deleted_id;

/** Identifiers for all properties contained in the 
 * epon_link_link_speed_mismatch group. 
 */
typedef enum bcmolt_epon_link_link_speed_mismatch_id
{
    BCMOLT_EPON_LINK_LINK_SPEED_MISMATCH_ID__BEGIN                          = 0,
    BCMOLT_EPON_LINK_LINK_SPEED_MISMATCH_ID_PREVIOUS_RATE                   = 0,    /**< Previous rate. */
    BCMOLT_EPON_LINK_LINK_SPEED_MISMATCH_ID_CURRENT_RATE                    = 1,    /**< Current rate. */
    BCMOLT_EPON_LINK_LINK_SPEED_MISMATCH_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_link_speed_mismatch_id;

/** Identifiers for all properties contained in the epon_link_mpcp_deregistered 
 * group. 
 */
typedef enum bcmolt_epon_link_mpcp_deregistered_id
{
    BCMOLT_EPON_LINK_MPCP_DEREGISTERED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_mpcp_deregistered_id;

/** Identifiers for all properties contained in the epon_link_mpcp_discovered 
 * group. 
 */
typedef enum bcmolt_epon_link_mpcp_discovered_id
{
    BCMOLT_EPON_LINK_MPCP_DISCOVERED_ID__BEGIN                              = 0,
    BCMOLT_EPON_LINK_MPCP_DISCOVERED_ID_LINK_INFO                           = 0,    /**< Link information. */
    BCMOLT_EPON_LINK_MPCP_DISCOVERED_ID__NUM_OF         /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_mpcp_discovered_id;

/** Identifiers for all properties contained in the 
 * epon_link_mpcp_reg_ack_timeout group. 
 */
typedef enum bcmolt_epon_link_mpcp_reg_ack_timeout_id
{
    BCMOLT_EPON_LINK_MPCP_REG_ACK_TIMEOUT_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_mpcp_reg_ack_timeout_id;

/** Identifiers for all properties contained in the 
 * epon_link_mpcp_report_timeout group. 
 */
typedef enum bcmolt_epon_link_mpcp_report_timeout_id
{
    BCMOLT_EPON_LINK_MPCP_REPORT_TIMEOUT_ID__BEGIN                          = 0,
    BCMOLT_EPON_LINK_MPCP_REPORT_TIMEOUT_ID_ALARM_STATUS                    = 0,    /**< Alarm Status. */
    BCMOLT_EPON_LINK_MPCP_REPORT_TIMEOUT_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_mpcp_report_timeout_id;

/** Identifiers for all properties contained in the 
 * epon_link_oam_keepalive_timeout group. 
 */
typedef enum bcmolt_epon_link_oam_keepalive_timeout_id
{
    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMEOUT_ID__BEGIN                        = 0,
    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMEOUT_ID_ALARM_STATUS                  = 0,    /**< Alarm Status. */
    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMEOUT_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_oam_keepalive_timeout_id;

/** Identifiers for all properties contained in the 
 * epon_link_oam_keepalive_timer_start group. 
 */
typedef enum bcmolt_epon_link_oam_keepalive_timer_start_id
{
    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_START_ID__BEGIN                    = 0,
    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_START_ID_SEND_PERIOD               = 0,    /**< Send period. */
    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_START_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_oam_keepalive_timer_start_id;

/** Identifiers for all properties contained in the 
 * epon_link_oam_keepalive_timer_started group. 
 */
typedef enum bcmolt_epon_link_oam_keepalive_timer_started_id
{
    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_STARTED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_oam_keepalive_timer_started_id;

/** Identifiers for all properties contained in the 
 * epon_link_oam_keepalive_timer_stop group. 
 */
typedef enum bcmolt_epon_link_oam_keepalive_timer_stop_id
{
    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_STOP_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_oam_keepalive_timer_stop_id;

/** Identifiers for all properties contained in the 
 * epon_link_oam_keepalive_timer_stopped group. 
 */
typedef enum bcmolt_epon_link_oam_keepalive_timer_stopped_id
{
    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_STOPPED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_oam_keepalive_timer_stopped_id;

/** Identifiers for all properties contained in the 
 * epon_link_preprovisioned_link_created group. 
 */
typedef enum bcmolt_epon_link_preprovisioned_link_created_id
{
    BCMOLT_EPON_LINK_PREPROVISIONED_LINK_CREATED_ID__BEGIN                  = 0,
    BCMOLT_EPON_LINK_PREPROVISIONED_LINK_CREATED_ID_LINK_INFO               = 0,    /**< Link information. */
    BCMOLT_EPON_LINK_PREPROVISIONED_LINK_CREATED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_preprovisioned_link_created_id;

/** Identifiers for all properties contained in the 
 * epon_link_protection_switch_occurred group. 
 */
typedef enum bcmolt_epon_link_protection_switch_occurred_id
{
    BCMOLT_EPON_LINK_PROTECTION_SWITCH_OCCURRED_ID__BEGIN                   = 0,
    BCMOLT_EPON_LINK_PROTECTION_SWITCH_OCCURRED_ID_PROTECTION_STATUS        = 0,    /**< Protection status. */
    BCMOLT_EPON_LINK_PROTECTION_SWITCH_OCCURRED_ID_RANGE_VALUE_TQ           = 1,    /**< Range value in time quanta. */
    BCMOLT_EPON_LINK_PROTECTION_SWITCH_OCCURRED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_protection_switch_occurred_id;

/** Identifiers for all properties contained in the 
 * epon_link_range_value_changed group. 
 */
typedef enum bcmolt_epon_link_range_value_changed_id
{
    BCMOLT_EPON_LINK_RANGE_VALUE_CHANGED_ID__BEGIN                          = 0,
    BCMOLT_EPON_LINK_RANGE_VALUE_CHANGED_ID_RANGE_VALUE_TQ                  = 0,    /**< Range value in time quanta. */
    BCMOLT_EPON_LINK_RANGE_VALUE_CHANGED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_range_value_changed_id;

/** Identifiers for all properties contained in the epon_link_rerange_failure 
 * group. 
 */
typedef enum bcmolt_epon_link_rerange_failure_id
{
    BCMOLT_EPON_LINK_RERANGE_FAILURE_ID__NUM_OF     /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_rerange_failure_id;

/** Identifiers for all properties contained in the epon_link_stat_alarm_cleared 
 * group. 
 */
typedef enum bcmolt_epon_link_stat_alarm_cleared_id
{
    BCMOLT_EPON_LINK_STAT_ALARM_CLEARED_ID__BEGIN                           = 0,
    BCMOLT_EPON_LINK_STAT_ALARM_CLEARED_ID_STAT                             = 0,    /**< Statistic ID. */
    BCMOLT_EPON_LINK_STAT_ALARM_CLEARED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the epon_link_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_epon_link_stat_alarm_raised_id
{
    BCMOLT_EPON_LINK_STAT_ALARM_RAISED_ID__BEGIN                            = 0,
    BCMOLT_EPON_LINK_STAT_ALARM_RAISED_ID_STAT                              = 0,    /**< Statistic ID. */
    BCMOLT_EPON_LINK_STAT_ALARM_RAISED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_stat_alarm_raised_id;

/** Identifiers for all properties contained in the epon_link_stat_cfg group. 
 */
typedef enum bcmolt_epon_link_stat_cfg_id
{
    BCMOLT_EPON_LINK_STAT_CFG_ID__BEGIN                                     = 0,
    BCMOLT_EPON_LINK_STAT_CFG_ID_CFG                                        = 0,    /**< Configuration. */
    BCMOLT_EPON_LINK_STAT_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_stat_cfg_id;

/** Identifiers for all properties contained in the epon_link_stat group. 
 */
typedef enum bcmolt_epon_link_stat_id
{
    BCMOLT_EPON_LINK_STAT_ID__BEGIN                                         = 0,
    BCMOLT_EPON_LINK_STAT_ID_RX_DATA_BYTES                                  = 0,    /**< Data Bytes RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_DATA_FRAMES                                 = 1,    /**< Data Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_64                                   = 2,    /**< 64 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_65_127                               = 3,    /**< 65-127 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_128_255                              = 4,    /**< 128-255 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_256_511                              = 5,    /**< 256-511 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_512_1023                             = 6,    /**< 512-1023 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_1024_1518                            = 7,    /**< 1024-1518 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_1519_2047                            = 8,    /**< 1519-2047 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_2048_4095                            = 9,    /**< 2048-4095 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_4096_9216                            = 10,   /**< 4096-9216 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_9217_16383                           = 11,   /**< 9217-16383 Byte Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_OAM_BYTES                                   = 12,   /**< OAM Bytes RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_OAM_FRAMES                                  = 13,   /**< OAM Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_MPCP_FRAMES                                 = 14,   /**< MPCP Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_BROADCAST_FRAMES                            = 15,   /**< Broadcast Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_UNICAST_FRAMES                              = 16,   /**< Unicast Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_MULTICAST_FRAMES                            = 17,   /**< Multicast Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_REPORT_FRAMES                               = 18,   /**< Report Frames RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_FCS_ERROR                                   = 19,   /**< FCS Error RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_OVERSIZE_ERROR                              = 20,   /**< Oversize Error RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_RUNT_ERROR                                  = 21,   /**< Runt Error RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_LINE_CODE_ERROR                             = 22,   /**< Line Code Error RX. */
    BCMOLT_EPON_LINK_STAT_ID_RX_LINE_CODE_ERROR_MAX                         = 23,   /**< Line Code Error Max RX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_DATA_BYTES                                  = 24,   /**< Data Bytes TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_DATA_FRAMES                                 = 25,   /**< Data Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_64                                   = 26,   /**< 64 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_65_127                               = 27,   /**< 65-127 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_128_255                              = 28,   /**< 128-255 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_256_511                              = 29,   /**< 256-511 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_512_1023                             = 30,   /**< 512-1023 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_1024_1518                            = 31,   /**< 1024-1518 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_1519_2047                            = 32,   /**< 1519-2047 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_2048_4095                            = 33,   /**< 2048-4095 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_4096_9216                            = 34,   /**< 4096-9216 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_9217_16383                           = 35,   /**< 9217-16383 Byte Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_OAM_BYTES                                   = 36,   /**< OAM Bytes TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_OAM_FRAMES                                  = 37,   /**< OAM Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_MPCP_FRAMES                                 = 38,   /**< MPCP Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_BROADCAST_FRAMES                            = 39,   /**< Broadcast Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_UNICAST_FRAMES                              = 40,   /**< Unicast Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_MULTICAST_FRAMES                            = 41,   /**< Multicast Frames TX. */
    BCMOLT_EPON_LINK_STAT_ID_TX_GATES                                       = 42,   /**< Gates TX. */
    BCMOLT_EPON_LINK_STAT_ID__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_stat_id;

/** Identifiers for all properties contained in the 
 * epon_link_static_registration_done group. 
 */
typedef enum bcmolt_epon_link_static_registration_done_id
{
    BCMOLT_EPON_LINK_STATIC_REGISTRATION_DONE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_static_registration_done_id;

/** Identifiers for all properties contained in the 
 * epon_link_static_registration group. 
 */
typedef enum bcmolt_epon_link_static_registration_id
{
    BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID__BEGIN                          = 0,
    BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID_LASERON_TIME_TQ                 = 0,    /**< Laser-on time (TQ). */
    BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID_LASEROFF_TIME_TQ                = 1,    /**< Laser-off time (TQ). */
    BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID_RANGE_VALUE_TQ                  = 2,    /**< Range value (TQ). */
    BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID_PENDING_GRANTS                  = 3,    /**< Pending Grants. */
    BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_static_registration_id;

/** Identifiers for all properties contained in the epon_ni_add_link group. 
 */
typedef enum bcmolt_epon_ni_add_link_id
{
    BCMOLT_EPON_NI_ADD_LINK_ID__BEGIN                                       = 0,
    BCMOLT_EPON_NI_ADD_LINK_ID_MAC_ADDRESS                                  = 0,    /**< MAC address. */
    BCMOLT_EPON_NI_ADD_LINK_ID_RATE                                         = 1,    /**< Rate. */
    BCMOLT_EPON_NI_ADD_LINK_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_add_link_id;

/** Identifiers for all properties contained in the epon_ni_add_multicast_link 
 * group. 
 */
typedef enum bcmolt_epon_ni_add_multicast_link_id
{
    BCMOLT_EPON_NI_ADD_MULTICAST_LINK_ID__BEGIN                             = 0,
    BCMOLT_EPON_NI_ADD_MULTICAST_LINK_ID_MAC_ADDRESS                        = 0,    /**< MAC address. */
    BCMOLT_EPON_NI_ADD_MULTICAST_LINK_ID_RATE                               = 1,    /**< Rate. */
    BCMOLT_EPON_NI_ADD_MULTICAST_LINK_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_add_multicast_link_id;

/** Identifiers for all properties contained in the 
 * epon_ni_add_protected_standby_link group. 
 */
typedef enum bcmolt_epon_ni_add_protected_standby_link_id
{
    BCMOLT_EPON_NI_ADD_PROTECTED_STANDBY_LINK_ID__BEGIN                     = 0,
    BCMOLT_EPON_NI_ADD_PROTECTED_STANDBY_LINK_ID_MAC_ADDRESS                = 0,    /**< MAC address. */
    BCMOLT_EPON_NI_ADD_PROTECTED_STANDBY_LINK_ID_WORKING_LINK_INFO          = 1,    /**< Working link info. */
    BCMOLT_EPON_NI_ADD_PROTECTED_STANDBY_LINK_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_add_protected_standby_link_id;

/** Identifiers for all properties contained in the epon_ni_auto_cfg group. 
 */
typedef enum bcmolt_epon_ni_auto_cfg_id
{
    BCMOLT_EPON_NI_AUTO_CFG_ID__BEGIN                                       = 0,
    BCMOLT_EPON_NI_AUTO_CFG_ID_AUTO_ROGUE_SCAN_10G_FAILURE                  = 0,    /**< 10G Epon Autonomous Rogue Scan failure detected. */
    BCMOLT_EPON_NI_AUTO_CFG_ID_AUTO_ROGUE_SCAN_1G_FAILURE                   = 1,    /**< 1G Epon Autonomous Rogue Scan failure detected. */
    BCMOLT_EPON_NI_AUTO_CFG_ID_LLID_QUARANTINED                             = 2,    /**< LLID Quarantined. */
    BCMOLT_EPON_NI_AUTO_CFG_ID_MPCP_TIMESTAMP_CHANGED                       = 3,    /**< MPCP Timestamp Changed. */
    BCMOLT_EPON_NI_AUTO_CFG_ID_NO_REPORTS                                   = 4,    /**< No Reports. */
    BCMOLT_EPON_NI_AUTO_CFG_ID_ONU_UPGRADE_COMPLETE                         = 5,    /**< ONU Upgrade Complete. */
    BCMOLT_EPON_NI_AUTO_CFG_ID_RERANGE_FAILURE                              = 6,    /**< Re-range failure. */
    BCMOLT_EPON_NI_AUTO_CFG_ID_ROGUE_SCAN_COMPLETE                          = 7,    /**< Rogue Scan is Complete. */
    BCMOLT_EPON_NI_AUTO_CFG_ID_RSSI_MEASUREMENT_COMPLETED                   = 8,    /**< RSSI Measurement Completed. */
    BCMOLT_EPON_NI_AUTO_CFG_ID_STATE_CHANGE_COMPLETED                       = 9,    /**< State Change Completed. */
    BCMOLT_EPON_NI_AUTO_CFG_ID__NUM_OF                      /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_auto_cfg_id;

/** Identifiers for all properties contained in the 
 * epon_ni_auto_rogue_scan_10g_failure group. 
 */
typedef enum bcmolt_epon_ni_auto_rogue_scan_10g_failure_id
{
    BCMOLT_EPON_NI_AUTO_ROGUE_SCAN_10G_FAILURE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_auto_rogue_scan_10g_failure_id;

/** Identifiers for all properties contained in the 
 * epon_ni_auto_rogue_scan_1g_failure group. 
 */
typedef enum bcmolt_epon_ni_auto_rogue_scan_1g_failure_id
{
    BCMOLT_EPON_NI_AUTO_ROGUE_SCAN_1G_FAILURE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_auto_rogue_scan_1g_failure_id;

/** Identifiers for all properties contained in the epon_ni_cfg group. 
 */
typedef enum bcmolt_epon_ni_cfg_id
{
    BCMOLT_EPON_NI_CFG_ID__BEGIN                                            = 0,
    BCMOLT_EPON_NI_CFG_ID_MAC_ADDRESS                                       = 0,    /**< MAC Address. */
    BCMOLT_EPON_NI_CFG_ID_EPON_NI_EN                                        = 1,    /**< EPON NI enable state. */
    BCMOLT_EPON_NI_CFG_ID_REGISTRATION_BEHAVIOR                             = 2,    /**< Registration Behavior. */
    BCMOLT_EPON_NI_CFG_ID_MTU_1G                                            = 3,    /**< 1G MTU. */
    BCMOLT_EPON_NI_CFG_ID_MTU_10G                                           = 4,    /**< 10G MTU. */
    BCMOLT_EPON_NI_CFG_ID_MINIMUM_FIBER_LENGTH                              = 5,    /**< Minimum Fiber Length. */
    BCMOLT_EPON_NI_CFG_ID_MAXIMUM_FIBER_LENGTH                              = 6,    /**< Maximum Fiber Length. */
    BCMOLT_EPON_NI_CFG_ID_GRANT_SPACING_TQ                                  = 7,    /**< Grant Spacing (TQ). */
    BCMOLT_EPON_NI_CFG_ID_EPON_LOGICAL_LINK_OPTIONS                         = 8,    /**< EPON logical link options. */
    BCMOLT_EPON_NI_CFG_ID_MPCP_DISCOVERY_PERIOD_MS                          = 9,    /**< MPCP discovery period in milliseconds. */
    BCMOLT_EPON_NI_CFG_ID_ALARM_STATE                                       = 10,   /**< Alarm State. */
    BCMOLT_EPON_NI_CFG_ID_ALL_LINKS                                         = 11,   /**< All links. */
    BCMOLT_EPON_NI_CFG_ID_ENCRYPTION_CFG                                    = 12,   /**< EPON NI encryption configuration. */
    BCMOLT_EPON_NI_CFG_ID_PROTECTION_SWITCHING_CFG                          = 13,   /**< Protection switching configuration. */
    BCMOLT_EPON_NI_CFG_ID_CLOCK_TRANSPORT_CFG                               = 14,   /**< Clock transport configuration. */
    BCMOLT_EPON_NI_CFG_ID_DROPDOWN_WEIGHTS                                  = 15,   /**< Drop-down Weights. */
    BCMOLT_EPON_NI_CFG_ID_APPROXIMATE_SOLICITED_USAGE                       = 16,   /**< Approximate Solicited Usage. */
    BCMOLT_EPON_NI_CFG_ID_APPROXIMATE_TDM_USAGE                             = 17,   /**< Approximate TDM Usage. */
    BCMOLT_EPON_NI_CFG_ID_NO_REPORTS_SOAK_TIME                              = 18,   /**< No Reports soak time. */
    BCMOLT_EPON_NI_CFG_ID_PON_AGGREGATE_SHAPER                              = 19,   /**< PON Aggregate Shaper. */
    BCMOLT_EPON_NI_CFG_ID_ESTIMATED_PON_LATENCY_TQ                          = 20,   /**< Estimated PON Latency (TQ). */
    BCMOLT_EPON_NI_CFG_ID_ONU_UPGRADE_PARAMS                                = 21,   /**< ONU upgrade params. */
    BCMOLT_EPON_NI_CFG_ID_AUTO_ROGUE_DETECT_10G_EN                          = 22,   /**< 10G Epon Autonomous Rogue Detection Enable. */
    BCMOLT_EPON_NI_CFG_ID_AUTO_ROGUE_DETECT_1G_EN                           = 23,   /**< 1G Epon Autonomous Rogue Detect Enable. */
    BCMOLT_EPON_NI_CFG_ID_AUTO_ROGUE_DETECT_10G_THRESHOLD                   = 24,   /**< 10G Epon Auto Rogue Detect Threshold. */
    BCMOLT_EPON_NI_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_cfg_id;

/** Identifiers for all properties contained in the epon_ni_issue_rssi_grant 
 * group. 
 */
typedef enum bcmolt_epon_ni_issue_rssi_grant_id
{
    BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID__BEGIN                               = 0,
    BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID_GRANTED_LINK                         = 0,    /**< Granted Link. */
    BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID_TRIGGER_WIDTH                        = 1,    /**< Rssi Trigger Width in ns. */
    BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID_TRIGGER_DELAY                        = 2,    /**< Rssi Trigger Delay in ns. */
    BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID_SAMPLE_PERIOD                        = 3,    /**< Rssi Sampe Period in us. */
    BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_issue_rssi_grant_id;

/** Identifiers for all properties contained in the epon_ni_key group. 
 */
typedef enum bcmolt_epon_ni_key_id
{
    BCMOLT_EPON_NI_KEY_ID__BEGIN                                            = 0,
    BCMOLT_EPON_NI_KEY_ID_EPON_NI                                           = 0,    /**< EPON NI number. */
    BCMOLT_EPON_NI_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_key_id;

/** Identifiers for all properties contained in the epon_ni_llid_quarantined 
 * group. 
 */
typedef enum bcmolt_epon_ni_llid_quarantined_id
{
    BCMOLT_EPON_NI_LLID_QUARANTINED_ID__BEGIN                               = 0,
    BCMOLT_EPON_NI_LLID_QUARANTINED_ID_LLID                                 = 0,    /**< LLID. */
    BCMOLT_EPON_NI_LLID_QUARANTINED_ID_LINK_RATE                            = 1,    /**< Link Rate. */
    BCMOLT_EPON_NI_LLID_QUARANTINED_ID_LINK_MAC                             = 2,    /**< Link MAC. */
    BCMOLT_EPON_NI_LLID_QUARANTINED_ID_RANGE_VALUE_TQ                       = 3,    /**< Range value in time quanta. */
    BCMOLT_EPON_NI_LLID_QUARANTINED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_llid_quarantined_id;

/** Identifiers for all properties contained in the 
 * epon_ni_mpcp_timestamp_changed group. 
 */
typedef enum bcmolt_epon_ni_mpcp_timestamp_changed_id
{
    BCMOLT_EPON_NI_MPCP_TIMESTAMP_CHANGED_ID__BEGIN                         = 0,
    BCMOLT_EPON_NI_MPCP_TIMESTAMP_CHANGED_ID_MPCP_TIMESTAMP                 = 0,    /**< MPCP Timestamp. */
    BCMOLT_EPON_NI_MPCP_TIMESTAMP_CHANGED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_mpcp_timestamp_changed_id;

/** Identifiers for all properties contained in the epon_ni_no_reports group. 
 */
typedef enum bcmolt_epon_ni_no_reports_id
{
    BCMOLT_EPON_NI_NO_REPORTS_ID__BEGIN                                     = 0,
    BCMOLT_EPON_NI_NO_REPORTS_ID_ALARM_STATUS                               = 0,    /**< Alarm Status. */
    BCMOLT_EPON_NI_NO_REPORTS_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_no_reports_id;

/** Identifiers for all properties contained in the epon_ni_onu_upgrade_complete 
 * group. 
 */
typedef enum bcmolt_epon_ni_onu_upgrade_complete_id
{
    BCMOLT_EPON_NI_ONU_UPGRADE_COMPLETE_ID__BEGIN                           = 0,
    BCMOLT_EPON_NI_ONU_UPGRADE_COMPLETE_ID_STATUS                           = 0,    /**< Status. */
    BCMOLT_EPON_NI_ONU_UPGRADE_COMPLETE_ID_LIST_OF_FAILED_ENTITIES          = 1,    /**< List of failed entities. */
    BCMOLT_EPON_NI_ONU_UPGRADE_COMPLETE_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_onu_upgrade_complete_id;

/** Identifiers for all properties contained in the 
 * epon_ni_protection_switching_apply_rerange_delta group. 
 */
typedef enum bcmolt_epon_ni_protection_switching_apply_rerange_delta_id
{
    BCMOLT_EPON_NI_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA_ID__BEGIN       = 0,
    BCMOLT_EPON_NI_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA_ID_RERANGE_DELTA= 0,    /**< Re-range delta. */
    BCMOLT_EPON_NI_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA_ID__NUM_OF              /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_protection_switching_apply_rerange_delta_id;

/** Identifiers for all properties contained in the epon_ni_rerange_failure 
 * group. 
 */
typedef enum bcmolt_epon_ni_rerange_failure_id
{
    BCMOLT_EPON_NI_RERANGE_FAILURE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_rerange_failure_id;

/** Identifiers for all properties contained in the epon_ni_rogue_llid_scan 
 * group. 
 */
typedef enum bcmolt_epon_ni_rogue_llid_scan_id
{
    BCMOLT_EPON_NI_ROGUE_LLID_SCAN_ID__BEGIN                                = 0,
    BCMOLT_EPON_NI_ROGUE_LLID_SCAN_ID_MODE                                  = 0,    /**< Scan All. */
    BCMOLT_EPON_NI_ROGUE_LLID_SCAN_ID_LLID                                  = 1,    /**< LLID. */
    BCMOLT_EPON_NI_ROGUE_LLID_SCAN_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_rogue_llid_scan_id;

/** Identifiers for all properties contained in the epon_ni_rogue_scan_complete 
 * group. 
 */
typedef enum bcmolt_epon_ni_rogue_scan_complete_id
{
    BCMOLT_EPON_NI_ROGUE_SCAN_COMPLETE_ID__BEGIN                            = 0,
    BCMOLT_EPON_NI_ROGUE_SCAN_COMPLETE_ID_RETURN_IND_STATUS                 = 0,    /**< Status of completed scan. */
    BCMOLT_EPON_NI_ROGUE_SCAN_COMPLETE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_rogue_scan_complete_id;

/** Identifiers for all properties contained in the 
 * epon_ni_rssi_measurement_completed group. 
 */
typedef enum bcmolt_epon_ni_rssi_measurement_completed_id
{
    BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID__BEGIN                     = 0,
    BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID_STATUS                     = 0,    /**< status. */
    BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID_LLID                       = 1,    /**< LLID. */
    BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID_LINK_MAC                   = 2,    /**< Link MAC . */
    BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_rssi_measurement_completed_id;

/** Identifiers for all properties contained in the epon_ni_set_epon_ni_en_state 
 * group. 
 */
typedef enum bcmolt_epon_ni_set_epon_ni_en_state_id
{
    BCMOLT_EPON_NI_SET_EPON_NI_EN_STATE_ID__BEGIN                           = 0,
    BCMOLT_EPON_NI_SET_EPON_NI_EN_STATE_ID_NEW_STATE                        = 0,    /**< New EPON NI enable state. */
    BCMOLT_EPON_NI_SET_EPON_NI_EN_STATE_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_set_epon_ni_en_state_id;

/** Identifiers for all properties contained in the epon_ni_start_onu_upgrade 
 * group. 
 */
typedef enum bcmolt_epon_ni_start_onu_upgrade_id
{
    BCMOLT_EPON_NI_START_ONU_UPGRADE_ID__BEGIN                              = 0,
    BCMOLT_EPON_NI_START_ONU_UPGRADE_ID_LIST_OF_ONU_IDS                     = 0,    /**< List of ONU IDs. */
    BCMOLT_EPON_NI_START_ONU_UPGRADE_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_start_onu_upgrade_id;

/** Identifiers for all properties contained in the 
 * epon_ni_state_change_completed group. 
 */
typedef enum bcmolt_epon_ni_state_change_completed_id
{
    BCMOLT_EPON_NI_STATE_CHANGE_COMPLETED_ID__BEGIN                         = 0,
    BCMOLT_EPON_NI_STATE_CHANGE_COMPLETED_ID_NEW_STATE                      = 0,    /**< New EPON NI enable state. */
    BCMOLT_EPON_NI_STATE_CHANGE_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_state_change_completed_id;

/** Identifiers for all properties contained in the epon_onu_10g_us_auto_cfg 
 * group. 
 */
typedef enum bcmolt_epon_onu_10g_us_auto_cfg_id
{
    BCMOLT_EPON_ONU_10G_US_AUTO_CFG_ID__BEGIN                               = 0,
    BCMOLT_EPON_ONU_10G_US_AUTO_CFG_ID_STAT_ALARM_CLEARED                   = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_ONU_10G_US_AUTO_CFG_ID_STAT_ALARM_RAISED                    = 1,    /**< Stat Alarm Raised. */
    BCMOLT_EPON_ONU_10G_US_AUTO_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_10g_us_auto_cfg_id;

/** Identifiers for all properties contained in the epon_onu_10g_us_cfg group. 
 */
typedef enum bcmolt_epon_onu_10g_us_cfg_id
{
    BCMOLT_EPON_ONU_10G_US_CFG_ID__BEGIN                                    = 0,
    BCMOLT_EPON_ONU_10G_US_CFG_ID_ALL_LINKS                                 = 0,    /**< All Links. */
    BCMOLT_EPON_ONU_10G_US_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_10g_us_cfg_id;

/** Identifiers for all properties contained in the epon_onu_10g_us_key group. 
 */
typedef enum bcmolt_epon_onu_10g_us_key_id
{
    BCMOLT_EPON_ONU_10G_US_KEY_ID__BEGIN                                    = 0,
    BCMOLT_EPON_ONU_10G_US_KEY_ID_EPON_NI                                   = 0,    /**< EPON NI. */
    BCMOLT_EPON_ONU_10G_US_KEY_ID_ONU_ID                                    = 1,    /**< ONU ID. */
    BCMOLT_EPON_ONU_10G_US_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_10g_us_key_id;

/** Identifiers for all properties contained in the 
 * epon_onu_10g_us_stat_alarm_cleared group. 
 */
typedef enum bcmolt_epon_onu_10g_us_stat_alarm_cleared_id
{
    BCMOLT_EPON_ONU_10G_US_STAT_ALARM_CLEARED_ID__BEGIN                     = 0,
    BCMOLT_EPON_ONU_10G_US_STAT_ALARM_CLEARED_ID_STAT                       = 0,    /**< Statistic ID. */
    BCMOLT_EPON_ONU_10G_US_STAT_ALARM_CLEARED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_10g_us_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the 
 * epon_onu_10g_us_stat_alarm_raised group. 
 */
typedef enum bcmolt_epon_onu_10g_us_stat_alarm_raised_id
{
    BCMOLT_EPON_ONU_10G_US_STAT_ALARM_RAISED_ID__BEGIN                      = 0,
    BCMOLT_EPON_ONU_10G_US_STAT_ALARM_RAISED_ID_STAT                        = 0,    /**< Statistic ID. */
    BCMOLT_EPON_ONU_10G_US_STAT_ALARM_RAISED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_10g_us_stat_alarm_raised_id;

/** Identifiers for all properties contained in the epon_onu_10g_us_stat_cfg 
 * group. 
 */
typedef enum bcmolt_epon_onu_10g_us_stat_cfg_id
{
    BCMOLT_EPON_ONU_10G_US_STAT_CFG_ID__BEGIN                               = 0,
    BCMOLT_EPON_ONU_10G_US_STAT_CFG_ID_CFG                                  = 0,    /**< Configuration. */
    BCMOLT_EPON_ONU_10G_US_STAT_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_10g_us_stat_cfg_id;

/** Identifiers for all properties contained in the epon_onu_10g_us_stat group. 
 */
typedef enum bcmolt_epon_onu_10g_us_stat_id
{
    BCMOLT_EPON_ONU_10G_US_STAT_ID__BEGIN                                   = 0,
    BCMOLT_EPON_ONU_10G_US_STAT_ID_FEC_CODE_WORDS_TOTAL                     = 0,    /**< FEC Code Words Total. */
    BCMOLT_EPON_ONU_10G_US_STAT_ID_FEC_CODE_WORDS_DECODE_FAILS              = 1,    /**< FEC Code Words Decode Fails. */
    BCMOLT_EPON_ONU_10G_US_STAT_ID_FEC_ZEROES_CORRECTED                     = 2,    /**< FEC Zeroes Corrected. */
    BCMOLT_EPON_ONU_10G_US_STAT_ID_FEC_ONES_CORRECTED                       = 3,    /**< FEC Ones Corrected. */
    BCMOLT_EPON_ONU_10G_US_STAT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_10g_us_stat_id;

/** Identifiers for all properties contained in the epon_onu_1g_us_auto_cfg 
 * group. 
 */
typedef enum bcmolt_epon_onu_1g_us_auto_cfg_id
{
    BCMOLT_EPON_ONU_1G_US_AUTO_CFG_ID__BEGIN                                = 0,
    BCMOLT_EPON_ONU_1G_US_AUTO_CFG_ID_STAT_ALARM_CLEARED                    = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_ONU_1G_US_AUTO_CFG_ID_STAT_ALARM_RAISED                     = 1,    /**< Stat Alarm Raised. */
    BCMOLT_EPON_ONU_1G_US_AUTO_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_1g_us_auto_cfg_id;

/** Identifiers for all properties contained in the epon_onu_1g_us_cfg group. 
 */
typedef enum bcmolt_epon_onu_1g_us_cfg_id
{
    BCMOLT_EPON_ONU_1G_US_CFG_ID__BEGIN                                     = 0,
    BCMOLT_EPON_ONU_1G_US_CFG_ID_ALL_LINKS                                  = 0,    /**< All Links. */
    BCMOLT_EPON_ONU_1G_US_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_1g_us_cfg_id;

/** Identifiers for all properties contained in the epon_onu_1g_us_key group. 
 */
typedef enum bcmolt_epon_onu_1g_us_key_id
{
    BCMOLT_EPON_ONU_1G_US_KEY_ID__BEGIN                                     = 0,
    BCMOLT_EPON_ONU_1G_US_KEY_ID_EPON_NI                                    = 0,    /**< EPON NI. */
    BCMOLT_EPON_ONU_1G_US_KEY_ID_ONU_ID                                     = 1,    /**< ONU ID. */
    BCMOLT_EPON_ONU_1G_US_KEY_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_1g_us_key_id;

/** Identifiers for all properties contained in the 
 * epon_onu_1g_us_stat_alarm_cleared group. 
 */
typedef enum bcmolt_epon_onu_1g_us_stat_alarm_cleared_id
{
    BCMOLT_EPON_ONU_1G_US_STAT_ALARM_CLEARED_ID__BEGIN                      = 0,
    BCMOLT_EPON_ONU_1G_US_STAT_ALARM_CLEARED_ID_STAT                        = 0,    /**< Statistic ID. */
    BCMOLT_EPON_ONU_1G_US_STAT_ALARM_CLEARED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_1g_us_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the 
 * epon_onu_1g_us_stat_alarm_raised group. 
 */
typedef enum bcmolt_epon_onu_1g_us_stat_alarm_raised_id
{
    BCMOLT_EPON_ONU_1G_US_STAT_ALARM_RAISED_ID__BEGIN                       = 0,
    BCMOLT_EPON_ONU_1G_US_STAT_ALARM_RAISED_ID_STAT                         = 0,    /**< Statistic ID. */
    BCMOLT_EPON_ONU_1G_US_STAT_ALARM_RAISED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_1g_us_stat_alarm_raised_id;

/** Identifiers for all properties contained in the epon_onu_1g_us_stat_cfg 
 * group. 
 */
typedef enum bcmolt_epon_onu_1g_us_stat_cfg_id
{
    BCMOLT_EPON_ONU_1G_US_STAT_CFG_ID__BEGIN                                = 0,
    BCMOLT_EPON_ONU_1G_US_STAT_CFG_ID_CFG                                   = 0,    /**< Configuration. */
    BCMOLT_EPON_ONU_1G_US_STAT_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_1g_us_stat_cfg_id;

/** Identifiers for all properties contained in the epon_onu_1g_us_stat group. 
 */
typedef enum bcmolt_epon_onu_1g_us_stat_id
{
    BCMOLT_EPON_ONU_1G_US_STAT_ID__BEGIN                                    = 0,
    BCMOLT_EPON_ONU_1G_US_STAT_ID_GOOD_FRAMES                               = 0,    /**< Good frames. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_GOOD_BYTES                                = 1,    /**< Good bytes. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_OVERSZ_FRAMES                             = 2,    /**< Oversized frames. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_NON_FEC_GOOD_FRAMES                       = 3,    /**< Non-FEC Good Frames. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_NON_FEC_GOOD_BYTES                        = 4,    /**< Non-FEC Good Bytes. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_GOOD_FRAMES                           = 5,    /**< FEC Good Frames. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_GOOD_BYTES                            = 6,    /**< FEC Good Bytes. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_FRAMES_EXC_ERRS                       = 7,    /**< FEC Frames which exceeded 8 symbol errors. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_BLKS_NO_ERRS                          = 8,    /**< FEC Blocks with no errors. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_BLKS_CORR_ERRS                        = 9,    /**< FEC Blocks with correctable errors. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_BLKS_UNCORR_ERRS                      = 10,   /**< FEC Blocks with uncorrectable errors. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_CORR_BYTES                            = 11,   /**< FEC Corrected Bytes. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_CORR_ZEROES                           = 12,   /**< FEC Corrected Zeroes. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_CORR_ONES                             = 13,   /**< FEC Corrected Ones. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_UNDERSZ_FRAMES                            = 14,   /**< Undersize frames. */
    BCMOLT_EPON_ONU_1G_US_STAT_ID_ERRORSZ_FRAMES                            = 15,   /**< Errored frame . */
    BCMOLT_EPON_ONU_1G_US_STAT_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_1g_us_stat_id;

/** Identifiers for all properties contained in the epon_path_10g_ds_auto_cfg 
 * group. 
 */
typedef enum bcmolt_epon_path_10g_ds_auto_cfg_id
{
    BCMOLT_EPON_PATH_10G_DS_AUTO_CFG_ID__BEGIN                              = 0,
    BCMOLT_EPON_PATH_10G_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED                  = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_PATH_10G_DS_AUTO_CFG_ID_STAT_ALARM_RAISED                   = 1,    /**< Stat Alarm Raised. */
    BCMOLT_EPON_PATH_10G_DS_AUTO_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_ds_auto_cfg_id;

/** Identifiers for all properties contained in the epon_path_10g_ds_cfg group. 
 */
typedef enum bcmolt_epon_path_10g_ds_cfg_id
{
    BCMOLT_EPON_PATH_10G_DS_CFG_ID__BEGIN                                   = 0,
    BCMOLT_EPON_PATH_10G_DS_CFG_ID_FEC_STATE                                = 0,    /**< Path FEC state. */
    BCMOLT_EPON_PATH_10G_DS_CFG_ID_PRBS_GENERATOR                           = 1,    /**< PRBS Generator. */
    BCMOLT_EPON_PATH_10G_DS_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_ds_cfg_id;

/** Identifiers for all properties contained in the epon_path_10g_ds_key group. 
 */
typedef enum bcmolt_epon_path_10g_ds_key_id
{
    BCMOLT_EPON_PATH_10G_DS_KEY_ID__BEGIN                                   = 0,
    BCMOLT_EPON_PATH_10G_DS_KEY_ID_EPON_NI                                  = 0,    /**< EPON NI (EPON Network Interface) number. */
    BCMOLT_EPON_PATH_10G_DS_KEY_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_ds_key_id;

/** Identifiers for all properties contained in the 
 * epon_path_10g_ds_stat_alarm_cleared group. 
 */
typedef enum bcmolt_epon_path_10g_ds_stat_alarm_cleared_id
{
    BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_CLEARED_ID__BEGIN                    = 0,
    BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_CLEARED_ID_STAT                      = 0,    /**< Statistic ID. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_CLEARED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_ds_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the 
 * epon_path_10g_ds_stat_alarm_raised group. 
 */
typedef enum bcmolt_epon_path_10g_ds_stat_alarm_raised_id
{
    BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_RAISED_ID__BEGIN                     = 0,
    BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_RAISED_ID_STAT                       = 0,    /**< Statistic ID. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_RAISED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_ds_stat_alarm_raised_id;

/** Identifiers for all properties contained in the epon_path_10g_ds_stat_cfg 
 * group. 
 */
typedef enum bcmolt_epon_path_10g_ds_stat_cfg_id
{
    BCMOLT_EPON_PATH_10G_DS_STAT_CFG_ID__BEGIN                              = 0,
    BCMOLT_EPON_PATH_10G_DS_STAT_CFG_ID_CFG                                 = 0,    /**< Configuration. */
    BCMOLT_EPON_PATH_10G_DS_STAT_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_ds_stat_cfg_id;

/** Identifiers for all properties contained in the epon_path_10g_ds_stat group. 
 */
typedef enum bcmolt_epon_path_10g_ds_stat_id
{
    BCMOLT_EPON_PATH_10G_DS_STAT_ID__BEGIN                                  = 0,
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_BYTES                                   = 0,    /**< Bytes. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES                                  = 1,    /**< Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_64                               = 2,    /**< 64 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_65_127                           = 3,    /**< 65-127 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_128_255                          = 4,    /**< 128-255 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_256_511                          = 5,    /**< 256-511 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_512_1023                         = 6,    /**< 512-1023 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_1024_1518                        = 7,    /**< 1024-1518 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_1519_2047                        = 8,    /**< 1519-2047 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_2048_4095                        = 9,    /**< 2048_4095 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_4096_9216                        = 10,   /**< 4096-9216 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_9217_16383                       = 11,   /**< 9217-16383 Byte Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_BROADCAST_FRAMES                        = 12,   /**< Broadcast Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_DATA_BYTES                              = 13,   /**< Data Bytes. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_MULTICAST_FRAMES                        = 14,   /**< Mulitcast Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_UNICAST_FRAMES                          = 15,   /**< Unicast Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_OAM_BYTES                               = 16,   /**< OAM Bytes. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_OAM_FRAMES                              = 17,   /**< OAM Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_GATE_FRAMES                             = 18,   /**< Gate Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_MPCP_FRAMES                             = 19,   /**< MPCP Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID_ABORT_FRAMES                            = 20,   /**< Abort Frames. */
    BCMOLT_EPON_PATH_10G_DS_STAT_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_ds_stat_id;

/** Identifiers for all properties contained in the epon_path_10g_us_auto_cfg 
 * group. 
 */
typedef enum bcmolt_epon_path_10g_us_auto_cfg_id
{
    BCMOLT_EPON_PATH_10G_US_AUTO_CFG_ID__BEGIN                              = 0,
    BCMOLT_EPON_PATH_10G_US_AUTO_CFG_ID_STAT_ALARM_CLEARED                  = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_PATH_10G_US_AUTO_CFG_ID_STAT_ALARM_RAISED                   = 1,    /**< Stat Alarm Raised. */
    BCMOLT_EPON_PATH_10G_US_AUTO_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_us_auto_cfg_id;

/** Identifiers for all properties contained in the epon_path_10g_us_cfg group. 
 */
typedef enum bcmolt_epon_path_10g_us_cfg_id
{
    BCMOLT_EPON_PATH_10G_US_CFG_ID__BEGIN                                   = 0,
    BCMOLT_EPON_PATH_10G_US_CFG_ID_FEC_STATE                                = 0,    /**< Path FEC state. */
    BCMOLT_EPON_PATH_10G_US_CFG_ID_SYNC_TIME_TQ                             = 1,    /**< Sync Time (TQ). */
    BCMOLT_EPON_PATH_10G_US_CFG_ID_PRBS_CHECKER                             = 2,    /**< PRBS Checker. */
    BCMOLT_EPON_PATH_10G_US_CFG_ID_PRBS_STATUS                              = 3,    /**< PRBS status. */
    BCMOLT_EPON_PATH_10G_US_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_us_cfg_id;

/** Identifiers for all properties contained in the epon_path_10g_us_key group. 
 */
typedef enum bcmolt_epon_path_10g_us_key_id
{
    BCMOLT_EPON_PATH_10G_US_KEY_ID__BEGIN                                   = 0,
    BCMOLT_EPON_PATH_10G_US_KEY_ID_EPON_NI                                  = 0,    /**< EPON NI. */
    BCMOLT_EPON_PATH_10G_US_KEY_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_us_key_id;

/** Identifiers for all properties contained in the 
 * epon_path_10g_us_stat_alarm_cleared group. 
 */
typedef enum bcmolt_epon_path_10g_us_stat_alarm_cleared_id
{
    BCMOLT_EPON_PATH_10G_US_STAT_ALARM_CLEARED_ID__BEGIN                    = 0,
    BCMOLT_EPON_PATH_10G_US_STAT_ALARM_CLEARED_ID_STAT                      = 0,    /**< Statistic ID. */
    BCMOLT_EPON_PATH_10G_US_STAT_ALARM_CLEARED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_us_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the 
 * epon_path_10g_us_stat_alarm_raised group. 
 */
typedef enum bcmolt_epon_path_10g_us_stat_alarm_raised_id
{
    BCMOLT_EPON_PATH_10G_US_STAT_ALARM_RAISED_ID__BEGIN                     = 0,
    BCMOLT_EPON_PATH_10G_US_STAT_ALARM_RAISED_ID_STAT                       = 0,    /**< Statistic ID. */
    BCMOLT_EPON_PATH_10G_US_STAT_ALARM_RAISED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_us_stat_alarm_raised_id;

/** Identifiers for all properties contained in the epon_path_10g_us_stat_cfg 
 * group. 
 */
typedef enum bcmolt_epon_path_10g_us_stat_cfg_id
{
    BCMOLT_EPON_PATH_10G_US_STAT_CFG_ID__BEGIN                              = 0,
    BCMOLT_EPON_PATH_10G_US_STAT_CFG_ID_CFG                                 = 0,    /**< Configuration. */
    BCMOLT_EPON_PATH_10G_US_STAT_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_us_stat_cfg_id;

/** Identifiers for all properties contained in the epon_path_10g_us_stat group. 
 */
typedef enum bcmolt_epon_path_10g_us_stat_id
{
    BCMOLT_EPON_PATH_10G_US_STAT_ID__BEGIN                                  = 0,
    BCMOLT_EPON_PATH_10G_US_STAT_ID_BYTES                                   = 0,    /**< Bytes. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES                                  = 1,    /**< Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_64                               = 2,    /**< 64 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_65_127                           = 3,    /**< 65-127 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_128_255                          = 4,    /**< 128-255 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_256_511                          = 5,    /**< 256-511 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_512_1023                         = 6,    /**< 512-1023 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_1024_1518                        = 7,    /**< 1024-1518 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_1519_2047                        = 8,    /**< 1519-2047 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_2048_4095                        = 9,    /**< 2048_4095 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_4096_9216                        = 10,   /**< 4096-9216 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_9217_16383                       = 11,   /**< 9217-16383 Byte Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_BROADCAST_FRAMES                        = 12,   /**< Broadcast Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_DATA_BYTES                              = 13,   /**< Data Bytes. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_MULTICAST_FRAMES                        = 14,   /**< Mulitcast Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_UNICAST_FRAMES                          = 15,   /**< Unicast Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_MPCP_FRAMES                             = 16,   /**< MPCP Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_OAM_BYTES                               = 17,   /**< OAM Bytes. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_OAM_FRAMES                              = 18,   /**< OAM Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_REPORT_FRAMES                           = 19,   /**< Report Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_ABORT_FRAMES                            = 20,   /**< Abort Frames. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_FCS_ERROR                               = 21,   /**< FCS Error. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_CRC_8_ERROR                             = 22,   /**< CRC8 Error. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_OUT_OF_SLOT                             = 23,   /**< Out of Slot. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_OVERSIZE_ERROR                          = 24,   /**< Oversize Error. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID_RUNT_ERROR                              = 25,   /**< Runt Error. */
    BCMOLT_EPON_PATH_10G_US_STAT_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_us_stat_id;

/** Identifiers for all properties contained in the epon_path_1g_ds_auto_cfg 
 * group. 
 */
typedef enum bcmolt_epon_path_1g_ds_auto_cfg_id
{
    BCMOLT_EPON_PATH_1G_DS_AUTO_CFG_ID__BEGIN                               = 0,
    BCMOLT_EPON_PATH_1G_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED                   = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_PATH_1G_DS_AUTO_CFG_ID_STAT_ALARM_RAISED                    = 1,    /**< Stat Alarm Raised. */
    BCMOLT_EPON_PATH_1G_DS_AUTO_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_ds_auto_cfg_id;

/** Identifiers for all properties contained in the epon_path_1g_ds_cfg group. 
 */
typedef enum bcmolt_epon_path_1g_ds_cfg_id
{
    BCMOLT_EPON_PATH_1G_DS_CFG_ID__BEGIN                                    = 0,
    BCMOLT_EPON_PATH_1G_DS_CFG_ID_DEFAULT_FEC_STATE                         = 0,    /**< Default FEC state. */
    BCMOLT_EPON_PATH_1G_DS_CFG_ID_RAMAN_MODE                                = 1,    /**< Raman mode. */
    BCMOLT_EPON_PATH_1G_DS_CFG_ID_TURBO_2G_MODE                             = 2,    /**< Turbo 2G mode. */
    BCMOLT_EPON_PATH_1G_DS_CFG_ID_PRBS_GENERATOR                            = 3,    /**< PRBS Generator. */
    BCMOLT_EPON_PATH_1G_DS_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_ds_cfg_id;

/** Identifiers for all properties contained in the epon_path_1g_ds_key group. 
 */
typedef enum bcmolt_epon_path_1g_ds_key_id
{
    BCMOLT_EPON_PATH_1G_DS_KEY_ID__BEGIN                                    = 0,
    BCMOLT_EPON_PATH_1G_DS_KEY_ID_EPON_NI                                   = 0,    /**< EPON NI. */
    BCMOLT_EPON_PATH_1G_DS_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_ds_key_id;

/** Identifiers for all properties contained in the 
 * epon_path_1g_ds_stat_alarm_cleared group. 
 */
typedef enum bcmolt_epon_path_1g_ds_stat_alarm_cleared_id
{
    BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_CLEARED_ID__BEGIN                     = 0,
    BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_CLEARED_ID_STAT                       = 0,    /**< Statistic ID. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_CLEARED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_ds_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the 
 * epon_path_1g_ds_stat_alarm_raised group. 
 */
typedef enum bcmolt_epon_path_1g_ds_stat_alarm_raised_id
{
    BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_RAISED_ID__BEGIN                      = 0,
    BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_RAISED_ID_STAT                        = 0,    /**< Statistic ID. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_RAISED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_ds_stat_alarm_raised_id;

/** Identifiers for all properties contained in the epon_path_1g_ds_stat_cfg 
 * group. 
 */
typedef enum bcmolt_epon_path_1g_ds_stat_cfg_id
{
    BCMOLT_EPON_PATH_1G_DS_STAT_CFG_ID__BEGIN                               = 0,
    BCMOLT_EPON_PATH_1G_DS_STAT_CFG_ID_CFG                                  = 0,    /**< Configuration. */
    BCMOLT_EPON_PATH_1G_DS_STAT_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_ds_stat_cfg_id;

/** Identifiers for all properties contained in the epon_path_1g_ds_stat group. 
 */
typedef enum bcmolt_epon_path_1g_ds_stat_id
{
    BCMOLT_EPON_PATH_1G_DS_STAT_ID__BEGIN                                   = 0,
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_BYTES                                    = 0,    /**< Bytes. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES                                   = 1,    /**< Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_64                                = 2,    /**< 64 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_65_127                            = 3,    /**< 65-127 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_128_255                           = 4,    /**< 128-255 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_256_511                           = 5,    /**< 256-511 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_512_1023                          = 6,    /**< 512-1023 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_1024_1518                         = 7,    /**< 1024-1518 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_1519_2047                         = 8,    /**< 1519-2047 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_2048_4095                         = 9,    /**< 2048_4095 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_4096_9216                         = 10,   /**< 4096-9216 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_9217_16383                        = 11,   /**< 9217-16383 Byte Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_BROADCAST_FRAMES                         = 12,   /**< Broadcast Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_DATA_BYTES                               = 13,   /**< Data Bytes. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_MULTICAST_FRAMES                         = 14,   /**< Mulitcast Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_UNICAST_FRAMES                           = 15,   /**< Unicast Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_OAM_BYTES                                = 16,   /**< OAM Bytes. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_OAM_FRAMES                               = 17,   /**< OAM Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_GATE_FRAMES                              = 18,   /**< Gate Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_MPCP_FRAMES                              = 19,   /**< MPCP Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID_ABORT_FRAMES                             = 20,   /**< Abort Frames. */
    BCMOLT_EPON_PATH_1G_DS_STAT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_ds_stat_id;

/** Identifiers for all properties contained in the epon_path_1g_us_auto_cfg 
 * group. 
 */
typedef enum bcmolt_epon_path_1g_us_auto_cfg_id
{
    BCMOLT_EPON_PATH_1G_US_AUTO_CFG_ID__BEGIN                               = 0,
    BCMOLT_EPON_PATH_1G_US_AUTO_CFG_ID_STAT_ALARM_CLEARED                   = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_PATH_1G_US_AUTO_CFG_ID_STAT_ALARM_RAISED                    = 1,    /**< Stat Alarm Raised. */
    BCMOLT_EPON_PATH_1G_US_AUTO_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_us_auto_cfg_id;

/** Identifiers for all properties contained in the epon_path_1g_us_cfg group. 
 */
typedef enum bcmolt_epon_path_1g_us_cfg_id
{
    BCMOLT_EPON_PATH_1G_US_CFG_ID__BEGIN                                    = 0,
    BCMOLT_EPON_PATH_1G_US_CFG_ID_DEFAULT_FEC_STATE                         = 0,    /**< Default FEC state. */
    BCMOLT_EPON_PATH_1G_US_CFG_ID_SYNC_TIME_TQ                              = 1,    /**< Sync Time (TQ). */
    BCMOLT_EPON_PATH_1G_US_CFG_ID_PRBS_CHECKER                              = 2,    /**< PRBS Checker. */
    BCMOLT_EPON_PATH_1G_US_CFG_ID_PRBS_STATUS                               = 3,    /**< PRBS status. */
    BCMOLT_EPON_PATH_1G_US_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_us_cfg_id;

/** Identifiers for all properties contained in the epon_path_1g_us_key group. 
 */
typedef enum bcmolt_epon_path_1g_us_key_id
{
    BCMOLT_EPON_PATH_1G_US_KEY_ID__BEGIN                                    = 0,
    BCMOLT_EPON_PATH_1G_US_KEY_ID_EPON_NI                                   = 0,    /**< EPON NI. */
    BCMOLT_EPON_PATH_1G_US_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_us_key_id;

/** Identifiers for all properties contained in the 
 * epon_path_1g_us_stat_alarm_cleared group. 
 */
typedef enum bcmolt_epon_path_1g_us_stat_alarm_cleared_id
{
    BCMOLT_EPON_PATH_1G_US_STAT_ALARM_CLEARED_ID__BEGIN                     = 0,
    BCMOLT_EPON_PATH_1G_US_STAT_ALARM_CLEARED_ID_STAT                       = 0,    /**< Statistic ID. */
    BCMOLT_EPON_PATH_1G_US_STAT_ALARM_CLEARED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_us_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the 
 * epon_path_1g_us_stat_alarm_raised group. 
 */
typedef enum bcmolt_epon_path_1g_us_stat_alarm_raised_id
{
    BCMOLT_EPON_PATH_1G_US_STAT_ALARM_RAISED_ID__BEGIN                      = 0,
    BCMOLT_EPON_PATH_1G_US_STAT_ALARM_RAISED_ID_STAT                        = 0,    /**< Statistic ID. */
    BCMOLT_EPON_PATH_1G_US_STAT_ALARM_RAISED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_us_stat_alarm_raised_id;

/** Identifiers for all properties contained in the epon_path_1g_us_stat_cfg 
 * group. 
 */
typedef enum bcmolt_epon_path_1g_us_stat_cfg_id
{
    BCMOLT_EPON_PATH_1G_US_STAT_CFG_ID__BEGIN                               = 0,
    BCMOLT_EPON_PATH_1G_US_STAT_CFG_ID_CFG                                  = 0,    /**< Configuration. */
    BCMOLT_EPON_PATH_1G_US_STAT_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_us_stat_cfg_id;

/** Identifiers for all properties contained in the epon_path_1g_us_stat group. 
 */
typedef enum bcmolt_epon_path_1g_us_stat_id
{
    BCMOLT_EPON_PATH_1G_US_STAT_ID__BEGIN                                   = 0,
    BCMOLT_EPON_PATH_1G_US_STAT_ID_BYTES                                    = 0,    /**< Bytes. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES                                   = 1,    /**< Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_64                                = 2,    /**< 64 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_65_127                            = 3,    /**< 65-127 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_128_255                           = 4,    /**< 128-255 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_256_511                           = 5,    /**< 256-511 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_512_1023                          = 6,    /**< 512-1023 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_1024_1518                         = 7,    /**< 1024-1518 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_1519_2047                         = 8,    /**< 1519-2047 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_2048_4095                         = 9,    /**< 2048_4095 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_4096_9216                         = 10,   /**< 4096-9216 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_9217_16383                        = 11,   /**< 9217-16383 Byte Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_BROADCAST_FRAMES                         = 12,   /**< Broadcast Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_DATA_BYTES                               = 13,   /**< Data Bytes. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_MULTICAST_FRAMES                         = 14,   /**< Mulitcast Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_UNICAST_FRAMES                           = 15,   /**< Unicast Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_MPCP_FRAMES                              = 16,   /**< MPCP Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_OAM_BYTES                                = 17,   /**< OAM Bytes. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_OAM_FRAMES                               = 18,   /**< OAM Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_REPORT_FRAMES                            = 19,   /**< Report Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_ABORT_FRAMES                             = 20,   /**< Abort Frames. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_FCS_ERROR                                = 21,   /**< FCS Error. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_CRC_8_ERROR                              = 22,   /**< CRC8 Error. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_OUT_OF_SLOT                              = 23,   /**< Out of Slot. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_OVERSIZE_ERROR                           = 24,   /**< Oversize Error. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID_RUNT_ERROR                               = 25,   /**< Runt Error. */
    BCMOLT_EPON_PATH_1G_US_STAT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_us_stat_id;

/** Identifiers for all properties contained in the epon_rp_cfg group. 
 */
typedef enum bcmolt_epon_rp_cfg_id
{
    BCMOLT_EPON_RP_CFG_ID__BEGIN                                            = 0,
    BCMOLT_EPON_RP_CFG_ID_BASE_LLID                                         = 0,    /**< Base logical link identifier. */
    BCMOLT_EPON_RP_CFG_ID_MPCP_DISC_EN                                      = 1,    /**< MPCP discovery enable. */
    BCMOLT_EPON_RP_CFG_ID_MPCP_DISC_GNT_LEN_TQ                              = 2,    /**< MPCP discovery grant length TQ. */
    BCMOLT_EPON_RP_CFG_ID_MPCP_REPORT_TIMEOUT                               = 3,    /**< MPCP report timeout mS. */
    BCMOLT_EPON_RP_CFG_ID_MAX_MPCP_REG_PER_DISC_WINDOW                      = 4,    /**< Maximum MPCP registrations per discovery window. */
    BCMOLT_EPON_RP_CFG_ID_MAX_LINKS                                         = 5,    /**< Maximum number of links. */
    BCMOLT_EPON_RP_CFG_ID_DEFAULT_UPSTREAM_BANDWIDTH                        = 6,    /**< Default Upstream Bandwidth. */
    BCMOLT_EPON_RP_CFG_ID_RATE_OF_REFRACTION                                = 7,    /**< Rate of Refraction. */
    BCMOLT_EPON_RP_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_rp_cfg_id;

/** Identifiers for all properties contained in the epon_rp_key group. 
 */
typedef enum bcmolt_epon_rp_key_id
{
    BCMOLT_EPON_RP_KEY_ID__BEGIN                                            = 0,
    BCMOLT_EPON_RP_KEY_ID_EPON_NI                                           = 0,    /**< EPON NI number. */
    BCMOLT_EPON_RP_KEY_ID_LINK_RATE                                         = 1,    /**< Link rate. */
    BCMOLT_EPON_RP_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_rp_key_id;

/** Identifiers for all properties contained in the gpio_cfg group. 
 */
typedef enum bcmolt_gpio_cfg_id
{
    BCMOLT_GPIO_CFG_ID__BEGIN                                               = 0,
    BCMOLT_GPIO_CFG_ID_DIRECTION                                            = 0,    /**< Direction. */
    BCMOLT_GPIO_CFG_ID_VALUE                                                = 1,    /**< Value. */
    BCMOLT_GPIO_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpio_cfg_id;

/** Identifiers for all properties contained in the gpio_key group. 
 */
typedef enum bcmolt_gpio_key_id
{
    BCMOLT_GPIO_KEY_ID__BEGIN                                               = 0,
    BCMOLT_GPIO_KEY_ID_RESERVED                                             = 0,    /**< Reserved. */
    BCMOLT_GPIO_KEY_ID_GPIO_ID                                              = 1,    /**< GPIO ID. */
    BCMOLT_GPIO_KEY_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpio_key_id;

/** Identifiers for all properties contained in the gpon_alloc_auto_cfg group. 
 */
typedef enum bcmolt_gpon_alloc_auto_cfg_id
{
    BCMOLT_GPON_ALLOC_AUTO_CFG_ID__BEGIN                                    = 0,
    BCMOLT_GPON_ALLOC_AUTO_CFG_ID_CONFIGURATION_COMPLETED                   = 0,    /**< Configuration Completed. */
    BCMOLT_GPON_ALLOC_AUTO_CFG_ID_GET_ALLOC_STATS_COMPLETED                 = 1,    /**< Get alloc ID statistics completed. */
    BCMOLT_GPON_ALLOC_AUTO_CFG_ID_STAT_ALARM_CLEARED                        = 2,    /**< Stat Alarm Cleared. */
    BCMOLT_GPON_ALLOC_AUTO_CFG_ID_STAT_ALARM_RAISED                         = 3,    /**< Stat Alarm Raised. */
    BCMOLT_GPON_ALLOC_AUTO_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_auto_cfg_id;

/** Identifiers for all properties contained in the gpon_alloc_cfg group. 
 */
typedef enum bcmolt_gpon_alloc_cfg_id
{
    BCMOLT_GPON_ALLOC_CFG_ID__BEGIN                                         = 0,
    BCMOLT_GPON_ALLOC_CFG_ID_STATE                                          = 0,    /**< Alloc ID state. */
    BCMOLT_GPON_ALLOC_CFG_ID_SLA                                            = 1,    /**< Alloc ID SLA. */
    BCMOLT_GPON_ALLOC_CFG_ID_ONU_ID                                         = 2,    /**< onu_id. */
    BCMOLT_GPON_ALLOC_CFG_ID_COLLECT_STATS                                  = 3,    /**< Enable statistics collection on the alloc id. */
    BCMOLT_GPON_ALLOC_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_cfg_id;

/** Identifiers for all properties contained in the 
 * gpon_alloc_configuration_completed group. 
 */
typedef enum bcmolt_gpon_alloc_configuration_completed_id
{
    BCMOLT_GPON_ALLOC_CONFIGURATION_COMPLETED_ID__BEGIN                     = 0,
    BCMOLT_GPON_ALLOC_CONFIGURATION_COMPLETED_ID_STATUS                     = 0,    /**< Status. */
    BCMOLT_GPON_ALLOC_CONFIGURATION_COMPLETED_ID_NEW_STATE                  = 1,    /**< new state. */
    BCMOLT_GPON_ALLOC_CONFIGURATION_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_configuration_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_alloc_get_alloc_stats_completed group. 
 */
typedef enum bcmolt_gpon_alloc_get_alloc_stats_completed_id
{
    BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID__BEGIN                   = 0,
    BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_STATUS                   = 0,    /**< status. */
    BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_NSR_USED         = 1,    /**< Average NSR used bytes. */
    BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_NSR_ALLOCATED    = 2,    /**< Average NSR allocated bytes. */
    BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_SR_REPORT        = 3,    /**< Average SR report. */
    BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_get_alloc_stats_completed_id;

/** Identifiers for all properties contained in the gpon_alloc_get_stats group. 
 */
typedef enum bcmolt_gpon_alloc_get_stats_id
{
    BCMOLT_GPON_ALLOC_GET_STATS_ID__BEGIN                                   = 0,
    BCMOLT_GPON_ALLOC_GET_STATS_ID_NUM_OF_CYCLES                            = 0,    /**< Number of cycles. */
    BCMOLT_GPON_ALLOC_GET_STATS_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_get_stats_id;

/** Identifiers for all properties contained in the gpon_alloc_key group. 
 */
typedef enum bcmolt_gpon_alloc_key_id
{
    BCMOLT_GPON_ALLOC_KEY_ID__BEGIN                                         = 0,
    BCMOLT_GPON_ALLOC_KEY_ID_PON_NI                                         = 0,    /**< PON network interface. */
    BCMOLT_GPON_ALLOC_KEY_ID_ALLOC_ID                                       = 1,    /**< Alloc ID. */
    BCMOLT_GPON_ALLOC_KEY_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_key_id;

/** Identifiers for all properties contained in the gpon_alloc_set_state group. 
 */
typedef enum bcmolt_gpon_alloc_set_state_id
{
    BCMOLT_GPON_ALLOC_SET_STATE_ID__BEGIN                                   = 0,
    BCMOLT_GPON_ALLOC_SET_STATE_ID_STATE                                    = 0,    /**< State. */
    BCMOLT_GPON_ALLOC_SET_STATE_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_set_state_id;

/** Identifiers for all properties contained in the 
 * gpon_alloc_stat_alarm_cleared group. 
 */
typedef enum bcmolt_gpon_alloc_stat_alarm_cleared_id
{
    BCMOLT_GPON_ALLOC_STAT_ALARM_CLEARED_ID__BEGIN                          = 0,
    BCMOLT_GPON_ALLOC_STAT_ALARM_CLEARED_ID_STAT                            = 0,    /**< Statistic ID. */
    BCMOLT_GPON_ALLOC_STAT_ALARM_CLEARED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the gpon_alloc_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_gpon_alloc_stat_alarm_raised_id
{
    BCMOLT_GPON_ALLOC_STAT_ALARM_RAISED_ID__BEGIN                           = 0,
    BCMOLT_GPON_ALLOC_STAT_ALARM_RAISED_ID_STAT                             = 0,    /**< Statistic ID. */
    BCMOLT_GPON_ALLOC_STAT_ALARM_RAISED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_stat_alarm_raised_id;

/** Identifiers for all properties contained in the gpon_alloc_stat_cfg group. 
 */
typedef enum bcmolt_gpon_alloc_stat_cfg_id
{
    BCMOLT_GPON_ALLOC_STAT_CFG_ID__BEGIN                                    = 0,
    BCMOLT_GPON_ALLOC_STAT_CFG_ID_CFG                                       = 0,    /**< Configuration. */
    BCMOLT_GPON_ALLOC_STAT_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_stat_cfg_id;

/** Identifiers for all properties contained in the gpon_alloc_stat group. 
 */
typedef enum bcmolt_gpon_alloc_stat_id
{
    BCMOLT_GPON_ALLOC_STAT_ID__BEGIN                                        = 0,
    BCMOLT_GPON_ALLOC_STAT_ID_RX_BYTES                                      = 0,    /**< Received Bytes. */
    BCMOLT_GPON_ALLOC_STAT_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_stat_id;

/** Identifiers for all properties contained in the gpon_gem_port_auto_cfg 
 * group. 
 */
typedef enum bcmolt_gpon_gem_port_auto_cfg_id
{
    BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID__BEGIN                                 = 0,
    BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID_CONFIGURATION_COMPLETED                = 0,    /**< Configuration Completed. */
    BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID_STAT_ALARM_CLEARED                     = 1,    /**< Stat Alarm Cleared. */
    BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID_STAT_ALARM_RAISED                      = 2,    /**< Stat Alarm Raised. */
    BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_auto_cfg_id;

/** Identifiers for all properties contained in the gpon_gem_port_cfg group. 
 */
typedef enum bcmolt_gpon_gem_port_cfg_id
{
    BCMOLT_GPON_GEM_PORT_CFG_ID__BEGIN                                      = 0,
    BCMOLT_GPON_GEM_PORT_CFG_ID_CONFIGURATION                               = 0,    /**< Configuration. */
    BCMOLT_GPON_GEM_PORT_CFG_ID_ONU_ID                                      = 1,    /**< ONU ID. */
    BCMOLT_GPON_GEM_PORT_CFG_ID_GEM_PORT_STATE                              = 2,    /**< gem port state. */
    BCMOLT_GPON_GEM_PORT_CFG_ID_DOWNSTREAM_ENCRYPTION_MODE                  = 3,    /**< Downstream encryption mode. */
    BCMOLT_GPON_GEM_PORT_CFG_ID_UPSTREAM_DESTINATION_QUEUE                  = 4,    /**< Upstream destination queue. */
    BCMOLT_GPON_GEM_PORT_CFG_ID_CONTROL                                     = 5,    /**< control. */
    BCMOLT_GPON_GEM_PORT_CFG_ID_DEBUG_FLOW_CONFIG                           = 6,    /**< Debug flow config. */
    BCMOLT_GPON_GEM_PORT_CFG_ID_MAC_TABLE_ENTRY_LIMIT                       = 7,    /**< MAC table entry limit. */
    BCMOLT_GPON_GEM_PORT_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_cfg_id;

/** Identifiers for all properties contained in the 
 * gpon_gem_port_configuration_completed group. 
 */
typedef enum bcmolt_gpon_gem_port_configuration_completed_id
{
    BCMOLT_GPON_GEM_PORT_CONFIGURATION_COMPLETED_ID__BEGIN                  = 0,
    BCMOLT_GPON_GEM_PORT_CONFIGURATION_COMPLETED_ID_STATUS                  = 0,    /**< status. */
    BCMOLT_GPON_GEM_PORT_CONFIGURATION_COMPLETED_ID_NEW_STATE               = 1,    /**< new state. */
    BCMOLT_GPON_GEM_PORT_CONFIGURATION_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_configuration_completed_id;

/** Identifiers for all properties contained in the gpon_gem_port_key group. 
 */
typedef enum bcmolt_gpon_gem_port_key_id
{
    BCMOLT_GPON_GEM_PORT_KEY_ID__BEGIN                                      = 0,
    BCMOLT_GPON_GEM_PORT_KEY_ID_PON_NI                                      = 0,    /**< PON network interface. */
    BCMOLT_GPON_GEM_PORT_KEY_ID_GEM_PORT_ID                                 = 1,    /**< GEM Port ID. */
    BCMOLT_GPON_GEM_PORT_KEY_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_key_id;

/** Identifiers for all properties contained in the gpon_gem_port_set_state 
 * group. 
 */
typedef enum bcmolt_gpon_gem_port_set_state_id
{
    BCMOLT_GPON_GEM_PORT_SET_STATE_ID__BEGIN                                = 0,
    BCMOLT_GPON_GEM_PORT_SET_STATE_ID_STATE                                 = 0,    /**< State. */
    BCMOLT_GPON_GEM_PORT_SET_STATE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_set_state_id;

/** Identifiers for all properties contained in the 
 * gpon_gem_port_stat_alarm_cleared group. 
 */
typedef enum bcmolt_gpon_gem_port_stat_alarm_cleared_id
{
    BCMOLT_GPON_GEM_PORT_STAT_ALARM_CLEARED_ID__BEGIN                       = 0,
    BCMOLT_GPON_GEM_PORT_STAT_ALARM_CLEARED_ID_STAT                         = 0,    /**< Statistic ID. */
    BCMOLT_GPON_GEM_PORT_STAT_ALARM_CLEARED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the 
 * gpon_gem_port_stat_alarm_raised group. 
 */
typedef enum bcmolt_gpon_gem_port_stat_alarm_raised_id
{
    BCMOLT_GPON_GEM_PORT_STAT_ALARM_RAISED_ID__BEGIN                        = 0,
    BCMOLT_GPON_GEM_PORT_STAT_ALARM_RAISED_ID_STAT                          = 0,    /**< Statistic ID. */
    BCMOLT_GPON_GEM_PORT_STAT_ALARM_RAISED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_stat_alarm_raised_id;

/** Identifiers for all properties contained in the gpon_gem_port_stat_cfg 
 * group. 
 */
typedef enum bcmolt_gpon_gem_port_stat_cfg_id
{
    BCMOLT_GPON_GEM_PORT_STAT_CFG_ID__BEGIN                                 = 0,
    BCMOLT_GPON_GEM_PORT_STAT_CFG_ID_CFG                                    = 0,    /**< Configuration. */
    BCMOLT_GPON_GEM_PORT_STAT_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_stat_cfg_id;

/** Identifiers for all properties contained in the gpon_gem_port_stat group. 
 */
typedef enum bcmolt_gpon_gem_port_stat_id
{
    BCMOLT_GPON_GEM_PORT_STAT_ID__BEGIN                                     = 0,
    BCMOLT_GPON_GEM_PORT_STAT_ID_RX_PACKETS                                 = 0,    /**< Received GEM frames. */
    BCMOLT_GPON_GEM_PORT_STAT_ID_RX_BYTES                                   = 1,    /**< Received bytes. */
    BCMOLT_GPON_GEM_PORT_STAT_ID_TX_PACKETS                                 = 2,    /**< Transmitted GEM frames. */
    BCMOLT_GPON_GEM_PORT_STAT_ID_TX_BYTES                                   = 3,    /**< Transmitted bytes. */
    BCMOLT_GPON_GEM_PORT_STAT_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_stat_id;

/** Identifiers for all properties contained in the gpon_iwf_auto_cfg group. 
 */
typedef enum bcmolt_gpon_iwf_auto_cfg_id
{
    BCMOLT_GPON_IWF_AUTO_CFG_ID__BEGIN                                      = 0,
    BCMOLT_GPON_IWF_AUTO_CFG_ID_FLUSH_MAC_TABLE_COMPLETED                   = 0,    /**< Flush MAC Table Completed. */
    BCMOLT_GPON_IWF_AUTO_CFG_ID_SCAN_MAC_TABLE_COMPLETED                    = 1,    /**< Scan MAC Table Completed. */
    BCMOLT_GPON_IWF_AUTO_CFG_ID_STAT_ALARM_CLEARED                          = 2,    /**< Stat Alarm Cleared. */
    BCMOLT_GPON_IWF_AUTO_CFG_ID_STAT_ALARM_RAISED                           = 3,    /**< Stat Alarm Raised. */
    BCMOLT_GPON_IWF_AUTO_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_auto_cfg_id;

/** Identifiers for all properties contained in the gpon_iwf_cfg group. 
 */
typedef enum bcmolt_gpon_iwf_cfg_id
{
    BCMOLT_GPON_IWF_CFG_ID__BEGIN                                           = 0,
    BCMOLT_GPON_IWF_CFG_ID_IWF_MODE                                         = 0,    /**< IWF mode. */
    BCMOLT_GPON_IWF_CFG_ID_US_TPID_PER_FLOW                                 = 1,    /**< US tpid per flow. */
    BCMOLT_GPON_IWF_CFG_ID_US_OTAG_DIRECT_TPID                              = 2,    /**< US otag direct tpid. */
    BCMOLT_GPON_IWF_CFG_ID_US_OTAG_DIRECT_PBIT                              = 3,    /**< US otag direct pbit. */
    BCMOLT_GPON_IWF_CFG_ID_DS_TPID                                          = 4,    /**< DS tpid. */
    BCMOLT_GPON_IWF_CFG_ID_MAC_TABLE_CONFIGURATION                          = 5,    /**< MAC table configuration. */
    BCMOLT_GPON_IWF_CFG_ID_DEBUG_FLOW_CONFIGURATION                         = 6,    /**< Debug flow configuration. */
    BCMOLT_GPON_IWF_CFG_ID_MAC_TABLE_COUNT                                  = 7,    /**< MAC table entry count. */
    BCMOLT_GPON_IWF_CFG_ID_FORBIDDEN_VLAN_FLOW_GEM_RANGE_START              = 8,    /**< Vlan, flow, Gem forbidden range start value. */
    BCMOLT_GPON_IWF_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_cfg_id;

/** Identifiers for all properties contained in the gpon_iwf_ds_egress_flow_cfg 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_ds_egress_flow_cfg_id
{
    BCMOLT_GPON_IWF_DS_EGRESS_FLOW_CFG_ID__BEGIN                            = 0,
    BCMOLT_GPON_IWF_DS_EGRESS_FLOW_CFG_ID_GEM_PORT                          = 0,    /**< GEM port. */
    BCMOLT_GPON_IWF_DS_EGRESS_FLOW_CFG_ID_PBIT_CONTROL                      = 1,    /**< Pbit control. */
    BCMOLT_GPON_IWF_DS_EGRESS_FLOW_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_ds_egress_flow_cfg_id;

/** Identifiers for all properties contained in the gpon_iwf_ds_egress_flow_key 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_ds_egress_flow_key_id
{
    BCMOLT_GPON_IWF_DS_EGRESS_FLOW_KEY_ID__BEGIN                            = 0,
    BCMOLT_GPON_IWF_DS_EGRESS_FLOW_KEY_ID_PON_NI                            = 0,    /**< PON network interface. */
    BCMOLT_GPON_IWF_DS_EGRESS_FLOW_KEY_ID_FLOW_ID                           = 1,    /**< Flow ID. */
    BCMOLT_GPON_IWF_DS_EGRESS_FLOW_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_ds_egress_flow_key_id;

/** Identifiers for all properties contained in the gpon_iwf_ds_ingress_flow_cfg 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_ds_ingress_flow_cfg_id
{
    BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID__BEGIN                           = 0,
    BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID_MAPPING_METHOD                   = 0,    /**< Mapping method. */
    BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID_MAPPING_TAG                      = 1,    /**< Mapping tag. */
    BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID_VLAN_ACTION                      = 2,    /**< VLAN action. */
    BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_ds_ingress_flow_cfg_id;

/** Identifiers for all properties contained in the gpon_iwf_ds_ingress_flow_key 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_ds_ingress_flow_key_id
{
    BCMOLT_GPON_IWF_DS_INGRESS_FLOW_KEY_ID__BEGIN                           = 0,
    BCMOLT_GPON_IWF_DS_INGRESS_FLOW_KEY_ID_PON_NI                           = 0,    /**< PON network interface. */
    BCMOLT_GPON_IWF_DS_INGRESS_FLOW_KEY_ID_VLAN_ID                          = 1,    /**< vlan ID. */
    BCMOLT_GPON_IWF_DS_INGRESS_FLOW_KEY_ID__NUM_OF          /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_ds_ingress_flow_key_id;

/** Identifiers for all properties contained in the 
 * gpon_iwf_flush_mac_table_completed group. 
 */
typedef enum bcmolt_gpon_iwf_flush_mac_table_completed_id
{
    BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_flush_mac_table_completed_id;

/** Identifiers for all properties contained in the gpon_iwf_flush_mac_table 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_flush_mac_table_id
{
    BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID__BEGIN                               = 0,
    BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID_CONTROL                              = 0,    /**< control. */
    BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID_VID                                  = 1,    /**< VID. */
    BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID_FLOW_ID                              = 2,    /**< FLOW ID. */
    BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_flush_mac_table_id;

/** Identifiers for all properties contained in the gpon_iwf_key group. 
 */
typedef enum bcmolt_gpon_iwf_key_id
{
    BCMOLT_GPON_IWF_KEY_ID__BEGIN                                           = 0,
    BCMOLT_GPON_IWF_KEY_ID_PON_NI                                           = 0,    /**< PON network interface. */
    BCMOLT_GPON_IWF_KEY_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_key_id;

/** Identifiers for all properties contained in the gpon_iwf_mac_table_auto_cfg 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_mac_table_auto_cfg_id
{
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID__BEGIN                            = 0,
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID_MAC_AGED                          = 0,    /**< MAC Aged. */
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID_MAC_DROPPED                       = 1,    /**< MAC Dropped. */
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID_MAC_MOVE                          = 2,    /**< MAC Move. */
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID_NEW_MAC                           = 3,    /**< New MAC. */
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_mac_table_auto_cfg_id;

/** Identifiers for all properties contained in the gpon_iwf_mac_table_cfg 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_mac_table_cfg_id
{
    BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID__BEGIN                                 = 0,
    BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_FLOW_ID                                = 0,    /**< Flow ID. */
    BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_STAT                                   = 1,    /**< static. */
    BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_GEM_PORT_ID                            = 2,    /**< GEM Port ID. */
    BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_ONU_ID                                 = 3,    /**< ONU ID. */
    BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_mac_table_cfg_id;

/** Identifiers for all properties contained in the gpon_iwf_mac_table_key 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_mac_table_key_id
{
    BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID__BEGIN                                 = 0,
    BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID_PON_NI                                 = 0,    /**< PON network interface. */
    BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID_MAC_ADDRESS                            = 1,    /**< MAC address. */
    BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID_VLAN                                   = 2,    /**< VLAN. */
    BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID__NUM_OF        /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_mac_table_key_id;

/** Identifiers for all properties contained in the gpon_iwf_mac_table_mac_aged 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_mac_table_mac_aged_id
{
    BCMOLT_GPON_IWF_MAC_TABLE_MAC_AGED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_mac_table_mac_aged_id;

/** Identifiers for all properties contained in the 
 * gpon_iwf_mac_table_mac_dropped group. 
 */
typedef enum bcmolt_gpon_iwf_mac_table_mac_dropped_id
{
    BCMOLT_GPON_IWF_MAC_TABLE_MAC_DROPPED_ID__BEGIN                         = 0,
    BCMOLT_GPON_IWF_MAC_TABLE_MAC_DROPPED_ID_FLOW_ID                        = 0,    /**< flow ID. */
    BCMOLT_GPON_IWF_MAC_TABLE_MAC_DROPPED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_mac_table_mac_dropped_id;

/** Identifiers for all properties contained in the gpon_iwf_mac_table_mac_move 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_mac_table_mac_move_id
{
    BCMOLT_GPON_IWF_MAC_TABLE_MAC_MOVE_ID__BEGIN                            = 0,
    BCMOLT_GPON_IWF_MAC_TABLE_MAC_MOVE_ID_OLD_FLOW_ID                       = 0,    /**< old flow ID. */
    BCMOLT_GPON_IWF_MAC_TABLE_MAC_MOVE_ID_NEW_FLOW_ID                       = 1,    /**< new flow id. */
    BCMOLT_GPON_IWF_MAC_TABLE_MAC_MOVE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_mac_table_mac_move_id;

/** Identifiers for all properties contained in the gpon_iwf_mac_table_new_mac 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_mac_table_new_mac_id
{
    BCMOLT_GPON_IWF_MAC_TABLE_NEW_MAC_ID__BEGIN                             = 0,
    BCMOLT_GPON_IWF_MAC_TABLE_NEW_MAC_ID_FLOW_ID                            = 0,    /**< flow ID. */
    BCMOLT_GPON_IWF_MAC_TABLE_NEW_MAC_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_mac_table_new_mac_id;

/** Identifiers for all properties contained in the 
 * gpon_iwf_scan_mac_table_completed group. 
 */
typedef enum bcmolt_gpon_iwf_scan_mac_table_completed_id
{
    BCMOLT_GPON_IWF_SCAN_MAC_TABLE_COMPLETED_ID__BEGIN                      = 0,
    BCMOLT_GPON_IWF_SCAN_MAC_TABLE_COMPLETED_ID_MAC_ADDRESS                 = 0,    /**< MAC Address. */
    BCMOLT_GPON_IWF_SCAN_MAC_TABLE_COMPLETED_ID_ENTRIES                     = 1,    /**< Entries. */
    BCMOLT_GPON_IWF_SCAN_MAC_TABLE_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_scan_mac_table_completed_id;

/** Identifiers for all properties contained in the gpon_iwf_scan_mac_table 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_scan_mac_table_id
{
    BCMOLT_GPON_IWF_SCAN_MAC_TABLE_ID__BEGIN                                = 0,
    BCMOLT_GPON_IWF_SCAN_MAC_TABLE_ID_MAC_ADDRESS                           = 0,    /**< MAC Address. */
    BCMOLT_GPON_IWF_SCAN_MAC_TABLE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_scan_mac_table_id;

/** Identifiers for all properties contained in the gpon_iwf_stat_alarm_cleared 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_stat_alarm_cleared_id
{
    BCMOLT_GPON_IWF_STAT_ALARM_CLEARED_ID__BEGIN                            = 0,
    BCMOLT_GPON_IWF_STAT_ALARM_CLEARED_ID_STAT                              = 0,    /**< Statistic ID. */
    BCMOLT_GPON_IWF_STAT_ALARM_CLEARED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the gpon_iwf_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_gpon_iwf_stat_alarm_raised_id
{
    BCMOLT_GPON_IWF_STAT_ALARM_RAISED_ID__BEGIN                             = 0,
    BCMOLT_GPON_IWF_STAT_ALARM_RAISED_ID_STAT                               = 0,    /**< Statistic ID. */
    BCMOLT_GPON_IWF_STAT_ALARM_RAISED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_stat_alarm_raised_id;

/** Identifiers for all properties contained in the gpon_iwf_stat_cfg group. 
 */
typedef enum bcmolt_gpon_iwf_stat_cfg_id
{
    BCMOLT_GPON_IWF_STAT_CFG_ID__BEGIN                                      = 0,
    BCMOLT_GPON_IWF_STAT_CFG_ID_CFG                                         = 0,    /**< Configuration. */
    BCMOLT_GPON_IWF_STAT_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_stat_cfg_id;

/** Identifiers for all properties contained in the gpon_iwf_stat group. 
 */
typedef enum bcmolt_gpon_iwf_stat_id
{
    BCMOLT_GPON_IWF_STAT_ID__BEGIN                                          = 0,
    BCMOLT_GPON_IWF_STAT_ID_DS_HIT_EVENT                                    = 0,    /**< DS hit event. */
    BCMOLT_GPON_IWF_STAT_ID_DS_MISS_EVENT                                   = 1,    /**< DS miss event. */
    BCMOLT_GPON_IWF_STAT_ID_DS_DROP_DUE_TO_MISS_EVENT                       = 2,    /**< DS drop due to miss event. */
    BCMOLT_GPON_IWF_STAT_ID_DS_DROP_DUE_TO_HIT_EVENT                        = 3,    /**< DS drop due to hit event. */
    BCMOLT_GPON_IWF_STAT_ID_DS_DROP_TO_DISABLED_GEM                         = 4,    /**< DS drop to disabled GEM. */
    BCMOLT_GPON_IWF_STAT_ID_NEW_MAC_DISCOVERED                              = 5,    /**< New MAC discovered. */
    BCMOLT_GPON_IWF_STAT_ID_MOVE_EVENT                                      = 6,    /**< Move event. */
    BCMOLT_GPON_IWF_STAT_ID_NEW_MAC_DROP_DUE_TO_FIFO_FULL                   = 7,    /**< New MAC drop due to fifo full. */
    BCMOLT_GPON_IWF_STAT_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_stat_id;

/** Identifiers for all properties contained in the gpon_iwf_us_flow_cfg group. 
 */
typedef enum bcmolt_gpon_iwf_us_flow_cfg_id
{
    BCMOLT_GPON_IWF_US_FLOW_CFG_ID__BEGIN                                   = 0,
    BCMOLT_GPON_IWF_US_FLOW_CFG_ID_FLOW_ID                                  = 0,    /**< Flow ID. */
    BCMOLT_GPON_IWF_US_FLOW_CFG_ID_MAC_LEARNING                             = 1,    /**< MAC learning. */
    BCMOLT_GPON_IWF_US_FLOW_CFG_ID_VLAN_ACTION                              = 2,    /**< VLAN action. */
    BCMOLT_GPON_IWF_US_FLOW_CFG_ID_VLAN_TAG                                 = 3,    /**< Vlan tag. */
    BCMOLT_GPON_IWF_US_FLOW_CFG_ID_TPID_INDEX                               = 4,    /**< TPID index. */
    BCMOLT_GPON_IWF_US_FLOW_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_us_flow_cfg_id;

/** Identifiers for all properties contained in the gpon_iwf_us_flow_key group. 
 */
typedef enum bcmolt_gpon_iwf_us_flow_key_id
{
    BCMOLT_GPON_IWF_US_FLOW_KEY_ID__BEGIN                                   = 0,
    BCMOLT_GPON_IWF_US_FLOW_KEY_ID_PON_NI                                   = 0,    /**< PON network interface. */
    BCMOLT_GPON_IWF_US_FLOW_KEY_ID_GEM_PORT_ID                              = 1,    /**< GEM Port  ID. */
    BCMOLT_GPON_IWF_US_FLOW_KEY_ID__NUM_OF                  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_us_flow_key_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_activate_all_onus_completed group. 
 */
typedef enum bcmolt_gpon_ni_activate_all_onus_completed_id
{
    BCMOLT_GPON_NI_ACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_activate_all_onus_completed_id;

/** Identifiers for all properties contained in the gpon_ni_auto_cfg group. 
 */
typedef enum bcmolt_gpon_ni_auto_cfg_id
{
    BCMOLT_GPON_NI_AUTO_CFG_ID__BEGIN                                       = 0,
    BCMOLT_GPON_NI_AUTO_CFG_ID_ACTIVATE_ALL_ONUS_COMPLETED                  = 0,    /**< activate all onus completed. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_CPU_PACKETS_FAILURE                          = 1,    /**< CPU Packets Failure. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_DEACTIVATE_ALL_ONUS_COMPLETED                = 2,    /**< deactivate all onus completed. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_DISABLE_ALL_ONUS_COMPLETED                   = 3,    /**< disable all onus completed. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_ENABLE_ALL_ONUS_COMPLETED                    = 4,    /**< enable all onus completed. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_LOS                                          = 5,    /**< LOS. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_ONU_DISCOVERED                               = 6,    /**< ONU Discovered. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_ONU_UPGRADE_COMPLETE                         = 7,    /**< ONU Upgrade Complete. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_ONUS_RANGED             = 8,    /**< Protection Switching ONUs Ranged. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED    = 9,    /**< Protection Switching Switchover Completed. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_TRAFFIC_RESUME          = 10,   /**< Protection Switching Traffic Resume. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_ROGUE_DETECTION_COMPLETED                    = 11,   /**< Rogue detection completed. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_ROGUE_ONU_SPECIAL_MAP_CYCLE_START            = 12,   /**< Rogue ONU special map cycle start. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_SERIAL_NUMBER_ACQUISITION_CYCLE_START        = 13,   /**< Serial Number Acquisition Cycle Start. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_STANDBY_PON_MONITORING_CYCLE_COMPLETED       = 14,   /**< Standby PON Monitoring Cycle Completed. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_STAT_ALARM_CLEARED                           = 15,   /**< Stat Alarm Cleared. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_STAT_ALARM_RAISED                            = 16,   /**< Stat Alarm Raised. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_STATE_CHANGE_COMPLETED                       = 17,   /**< State Change Completed. */
    BCMOLT_GPON_NI_AUTO_CFG_ID_TOD_REQUEST_COMPLETED                        = 18,   /**< TOD request completed. */
    BCMOLT_GPON_NI_AUTO_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_auto_cfg_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_broadcast_ploam_packet group. 
 */
typedef enum bcmolt_gpon_ni_broadcast_ploam_packet_id
{
    BCMOLT_GPON_NI_BROADCAST_PLOAM_PACKET_ID__BEGIN                         = 0,
    BCMOLT_GPON_NI_BROADCAST_PLOAM_PACKET_ID_PLOAM                          = 0,    /**< ploam. */
    BCMOLT_GPON_NI_BROADCAST_PLOAM_PACKET_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_broadcast_ploam_packet_id;

/** Identifiers for all properties contained in the gpon_ni_cfg group. 
 */
typedef enum bcmolt_gpon_ni_cfg_id
{
    BCMOLT_GPON_NI_CFG_ID__BEGIN                                            = 0,
    BCMOLT_GPON_NI_CFG_ID_PON_STATUS                                        = 0,    /**< PON status. */
    BCMOLT_GPON_NI_CFG_ID_AVAILABLE_BANDWIDTH                               = 1,    /**< Available Bandwidth. */
    BCMOLT_GPON_NI_CFG_ID_NUMBER_OF_ACTIVE_ONUS                             = 2,    /**< number of active onus. */
    BCMOLT_GPON_NI_CFG_ID_NUMBER_OF_ACTIVE_STANDBY_ONUS                     = 3,    /**< number of active standby onus. */
    BCMOLT_GPON_NI_CFG_ID_PRBS_STATUS                                       = 4,    /**< PRBS status. */
    BCMOLT_GPON_NI_CFG_ID_PON_DISTANCE                                      = 5,    /**< Pon distance. */
    BCMOLT_GPON_NI_CFG_ID_RANGING_WINDOW_SIZE                               = 6,    /**< Ranging window size. */
    BCMOLT_GPON_NI_CFG_ID_PREASSIGNED_EQUALIZATION_DELAY                    = 7,    /**< Pre-assigned Equalization Delay [bits]. */
    BCMOLT_GPON_NI_CFG_ID_EQD_CYCLES_NUMBER                                 = 8,    /**< EqD measurement cycles number. */
    BCMOLT_GPON_NI_CFG_ID_POWER_LEVEL                                       = 9,    /**< Power level. */
    BCMOLT_GPON_NI_CFG_ID_DS_FEC_MODE                                       = 10,   /**< DS FEC mode. */
    BCMOLT_GPON_NI_CFG_ID_DRIFT_CONTROL                                     = 11,   /**< Drift control. */
    BCMOLT_GPON_NI_CFG_ID_DS_BER_REPORTING_INTERVAL                         = 12,   /**< DS BER reporting interval in ms. */
    BCMOLT_GPON_NI_CFG_ID_LOS_ALARM_THRESHOLD                               = 13,   /**< LOS alarm threshold. */
    BCMOLT_GPON_NI_CFG_ID_LOS_INITIAL_VALUE                                 = 14,   /**< LOS initial value. */
    BCMOLT_GPON_NI_CFG_ID_ONU_ALARMS_THRESHOLDS                             = 15,   /**< ONU alarms thresholds. */
    BCMOLT_GPON_NI_CFG_ID_BER_MONITOR                                       = 16,   /**< BER monitoring params. */
    BCMOLT_GPON_NI_CFG_ID_PLOAM_ACK_TIMEOUT                                 = 17,   /**< Ploam ACK timeout. */
    BCMOLT_GPON_NI_CFG_ID_ONU_ACTIVATION                                    = 18,   /**< ONU activation. */
    BCMOLT_GPON_NI_CFG_ID_SN_ACQUISITION                                    = 19,   /**< SN Acquisition . */
    BCMOLT_GPON_NI_CFG_ID_KEY_EXCHANGE                                      = 20,   /**< Key exchange. */
    BCMOLT_GPON_NI_CFG_ID_PROTECTION_SWITCHING                              = 21,   /**< Protection switching. */
    BCMOLT_GPON_NI_CFG_ID_CBR_RT_ALLOCATION_PROFILE                         = 22,   /**< CBR RT Allocation profile. */
    BCMOLT_GPON_NI_CFG_ID_CBR_NRT_ALLOCATION_PROFILE                        = 23,   /**< CBR NRT Allocation Profile. */
    BCMOLT_GPON_NI_CFG_ID_DBA                                               = 24,   /**< DBA. */
    BCMOLT_GPON_NI_CFG_ID_POWER_MANAGEMENT                                  = 25,   /**< Power Management. */
    BCMOLT_GPON_NI_CFG_ID_ROGUE_ONU_DETECTION_PROCESS                       = 26,   /**< Rogue ONU detection process. */
    BCMOLT_GPON_NI_CFG_ID_PERIODIC_STANDBY_PON_MONITORING                   = 27,   /**< Periodic Standby PON monitoring. */
    BCMOLT_GPON_NI_CFG_ID_PRBS_CHECKER                                      = 28,   /**< PRBS Checker. */
    BCMOLT_GPON_NI_CFG_ID_PRBS_GENERATOR                                    = 29,   /**< PRBS Generator. */
    BCMOLT_GPON_NI_CFG_ID_MIN_DATA_ALLOC_ID                                 = 30,   /**< Minimum Data Alloc ID. */
    BCMOLT_GPON_NI_CFG_ID_AUTOMATIC_ONU_DEACTIVATION                        = 31,   /**< Automatic ONU deactivation. */
    BCMOLT_GPON_NI_CFG_ID_US_BANDWIDTH_LIMIT                                = 32,   /**< US bandwidth Limit. */
    BCMOLT_GPON_NI_CFG_ID_ALL_ONUS                                          = 33,   /**< all ONUs. */
    BCMOLT_GPON_NI_CFG_ID_ALL_MCAST_GEM_PORTS                               = 34,   /**< all multicast GEM ports. */
    BCMOLT_GPON_NI_CFG_ID_DEBUG                                             = 35,   /**< PON NI debug parameters. */
    BCMOLT_GPON_NI_CFG_ID_ONU_UPGRADE_PARAMS                                = 36,   /**< ONU upgrade params. */
    BCMOLT_GPON_NI_CFG_ID_PS_C_WAIT_BEFORE_DEACTIVATION_TIMEOUT             = 37,   /**< protection switching type c wait before deactivation timeout. */
    BCMOLT_GPON_NI_CFG_ID_BIP32_INDICATION_CONTROL                          = 38,   /**< bip32 indication control. */
    BCMOLT_GPON_NI_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_cfg_id;

/** Identifiers for all properties contained in the gpon_ni_cpu_packets_failure 
 * group. 
 */
typedef enum bcmolt_gpon_ni_cpu_packets_failure_id
{
    BCMOLT_GPON_NI_CPU_PACKETS_FAILURE_ID__BEGIN                            = 0,
    BCMOLT_GPON_NI_CPU_PACKETS_FAILURE_ID_ERROR                             = 0,    /**< Error. */
    BCMOLT_GPON_NI_CPU_PACKETS_FAILURE_ID_GEM_PORT_ID                       = 1,    /**< GEM Port ID. */
    BCMOLT_GPON_NI_CPU_PACKETS_FAILURE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_cpu_packets_failure_id;

/** Identifiers for all properties contained in the gpon_ni_cpu_packets group. 
 */
typedef enum bcmolt_gpon_ni_cpu_packets_id
{
    BCMOLT_GPON_NI_CPU_PACKETS_ID__BEGIN                                    = 0,
    BCMOLT_GPON_NI_CPU_PACKETS_ID_PACKET_TYPE                               = 0,    /**< packet type. */
    BCMOLT_GPON_NI_CPU_PACKETS_ID_CALC_CRC                                  = 1,    /**< calc crc. */
    BCMOLT_GPON_NI_CPU_PACKETS_ID_GEM_PORT_LIST                             = 2,    /**< gem port list. */
    BCMOLT_GPON_NI_CPU_PACKETS_ID_BUFFER                                    = 3,    /**< buffer. */
    BCMOLT_GPON_NI_CPU_PACKETS_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_cpu_packets_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_deactivate_all_onus_completed group. 
 */
typedef enum bcmolt_gpon_ni_deactivate_all_onus_completed_id
{
    BCMOLT_GPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_deactivate_all_onus_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_disable_all_onus_completed group. 
 */
typedef enum bcmolt_gpon_ni_disable_all_onus_completed_id
{
    BCMOLT_GPON_NI_DISABLE_ALL_ONUS_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_disable_all_onus_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_disable_serial_number group. 
 */
typedef enum bcmolt_gpon_ni_disable_serial_number_id
{
    BCMOLT_GPON_NI_DISABLE_SERIAL_NUMBER_ID__BEGIN                          = 0,
    BCMOLT_GPON_NI_DISABLE_SERIAL_NUMBER_ID_CONTROL                         = 0,    /**< control. */
    BCMOLT_GPON_NI_DISABLE_SERIAL_NUMBER_ID_SERIAL_NUMBER                   = 1,    /**< serial number. */
    BCMOLT_GPON_NI_DISABLE_SERIAL_NUMBER_ID__NUM_OF     /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_disable_serial_number_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_enable_all_onus_completed group. 
 */
typedef enum bcmolt_gpon_ni_enable_all_onus_completed_id
{
    BCMOLT_GPON_NI_ENABLE_ALL_ONUS_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_enable_all_onus_completed_id;

/** Identifiers for all properties contained in the gpon_ni_key group. 
 */
typedef enum bcmolt_gpon_ni_key_id
{
    BCMOLT_GPON_NI_KEY_ID__BEGIN                                            = 0,
    BCMOLT_GPON_NI_KEY_ID_PON_NI                                            = 0,    /**< PON network interface. */
    BCMOLT_GPON_NI_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_key_id;

/** Identifiers for all properties contained in the gpon_ni_los group. 
 */
typedef enum bcmolt_gpon_ni_los_id
{
    BCMOLT_GPON_NI_LOS_ID__BEGIN                                            = 0,
    BCMOLT_GPON_NI_LOS_ID_STATUS                                            = 0,    /**< status. */
    BCMOLT_GPON_NI_LOS_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_los_id;

/** Identifiers for all properties contained in the gpon_ni_onu_discovered 
 * group. 
 */
typedef enum bcmolt_gpon_ni_onu_discovered_id
{
    BCMOLT_GPON_NI_ONU_DISCOVERED_ID__BEGIN                                 = 0,
    BCMOLT_GPON_NI_ONU_DISCOVERED_ID_SERIAL_NUMBER                          = 0,    /**< serial number. */
    BCMOLT_GPON_NI_ONU_DISCOVERED_ID_RANGING_TIME                           = 1,    /**< ranging time. */
    BCMOLT_GPON_NI_ONU_DISCOVERED_ID_ONU_ID                                 = 2,    /**< onu_id. */
    BCMOLT_GPON_NI_ONU_DISCOVERED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_onu_discovered_id;

/** Identifiers for all properties contained in the gpon_ni_onu_upgrade_complete 
 * group. 
 */
typedef enum bcmolt_gpon_ni_onu_upgrade_complete_id
{
    BCMOLT_GPON_NI_ONU_UPGRADE_COMPLETE_ID__BEGIN                           = 0,
    BCMOLT_GPON_NI_ONU_UPGRADE_COMPLETE_ID_STATUS                           = 0,    /**< Status. */
    BCMOLT_GPON_NI_ONU_UPGRADE_COMPLETE_ID_LIST_OF_FAILED_ENTITIES          = 1,    /**< List of failed entities. */
    BCMOLT_GPON_NI_ONU_UPGRADE_COMPLETE_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_onu_upgrade_complete_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_protection_switching_onus_ranged group. 
 */
typedef enum bcmolt_gpon_ni_protection_switching_onus_ranged_id
{
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID__BEGIN               = 0,
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID_ONUS                 = 0,            /**< ONUs. */
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID__NUM_OF                              /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_protection_switching_onus_ranged_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_protection_switching_switchover_completed group. 
 */
typedef enum bcmolt_gpon_ni_protection_switching_switchover_completed_id
{
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID__BEGIN      = 0,
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID_RESULT      = 0,            /**< Result. */
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID__NUM_OF                     /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_protection_switching_switchover_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_protection_switching_traffic_resume group. 
 */
typedef enum bcmolt_gpon_ni_protection_switching_traffic_resume_id
{
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID__BEGIN            = 0,
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID_RESULT            = 0,            /**< Result. */
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID__NUM_OF                           /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_protection_switching_traffic_resume_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_protection_switching_type_c_set_multiple_onu_state group. 
 */
typedef enum bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id
{
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE_ID__BEGIN     = 0,
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE_ID_ONU_STATE  = 0,    /**< onu state. */
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE_ID_ONU_LIST   = 1,    /**< onu list. */
    BCMOLT_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE_ID__NUM_OF            /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id;

/** Identifiers for all properties contained in the gpon_ni_reset group. 
 */
typedef enum bcmolt_gpon_ni_reset_id
{
    BCMOLT_GPON_NI_RESET_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_reset_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_rogue_detection_completed group. 
 */
typedef enum bcmolt_gpon_ni_rogue_detection_completed_id
{
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID__BEGIN                              = 0,
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_WINDOW_TYPE                         = 0,    /**< Window type. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_MEASUREMENT_STATUS                  = 1,    /**< Measurement status. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_ALLOC_ID                            = 2,    /**< Alloc ID. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_ONU_ID                              = 3,    /**< ONU ID. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_IS_DELINEATION                      = 4,    /**< Is delineation. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_IS_ED                               = 5,    /**< Is ED. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_RX_DATA                             = 6,    /**< Received data. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_PLOAM_RECEIVED_ONU_ID               = 7,    /**< ploam_received_onu_id. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_PLOAM_RECEIVED_CRC_ERROR            = 8,    /**< ploam_received_crc_error. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_rogue_detection_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_rogue_detection_window group. 
 */
typedef enum bcmolt_gpon_ni_rogue_detection_window_id
{
    BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID__BEGIN                                 = 0,
    BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID_WINDOW_TYPE                            = 0,    /**< Window type. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID_ALLOC_ID                               = 1,    /**< Alloc ID. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID_ONU_ID                                 = 2,    /**< ONU ID. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID_SECOND_RANGING_WINDOW                  = 3,    /**< Second ranging window. */
    BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID__NUM_OF                /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_rogue_detection_window_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_rogue_onu_special_map_cycle_start group. 
 */
typedef enum bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id
{
    BCMOLT_GPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START_ID__NUM_OF     /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_serial_number_acquisition_cycle_start group. 
 */
typedef enum bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id
{
    BCMOLT_GPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id;

/** Identifiers for all properties contained in the gpon_ni_set_onu_state group. 
 */
typedef enum bcmolt_gpon_ni_set_onu_state_id
{
    BCMOLT_GPON_NI_SET_ONU_STATE_ID__BEGIN                                          = 0,
    BCMOLT_GPON_NI_SET_ONU_STATE_ID_ONU_STATE                                       = 0,    /**< ONU state. */
    BCMOLT_GPON_NI_SET_ONU_STATE_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_set_onu_state_id;

/** Identifiers for all properties contained in the gpon_ni_set_pon_state group. 
 */
typedef enum bcmolt_gpon_ni_set_pon_state_id
{
    BCMOLT_GPON_NI_SET_PON_STATE_ID__BEGIN                                          = 0,
    BCMOLT_GPON_NI_SET_PON_STATE_ID_PON_STATE                                       = 0,    /**< PON state. */
    BCMOLT_GPON_NI_SET_PON_STATE_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_set_pon_state_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_single_request_standby_pon_monitoring group. 
 */
typedef enum bcmolt_gpon_ni_single_request_standby_pon_monitoring_id
{
    BCMOLT_GPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_single_request_standby_pon_monitoring_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_standby_pon_monitoring_cycle_completed group. 
 */
typedef enum bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id
{
    BCMOLT_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID__BEGIN                         = 0,
    BCMOLT_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID_NUMBER_OF_DETECTED_DELIMITER   = 0,    /**< number of detected delimiter. */
    BCMOLT_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID_ENERGY_DETECT_SIGNAL           = 1,    /**< energy detect signal. */
    BCMOLT_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id;

/** Identifiers for all properties contained in the gpon_ni_start_onu_upgrade 
 * group. 
 */
typedef enum bcmolt_gpon_ni_start_onu_upgrade_id
{
    BCMOLT_GPON_NI_START_ONU_UPGRADE_ID__BEGIN                                              = 0,
    BCMOLT_GPON_NI_START_ONU_UPGRADE_ID_LIST_OF_ONU_IDS                                     = 0,    /**< List of ONU IDs. */
    BCMOLT_GPON_NI_START_ONU_UPGRADE_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_start_onu_upgrade_id;

/** Identifiers for all properties contained in the gpon_ni_stat_alarm_cleared 
 * group. 
 */
typedef enum bcmolt_gpon_ni_stat_alarm_cleared_id
{
    BCMOLT_GPON_NI_STAT_ALARM_CLEARED_ID__BEGIN                                             = 0,
    BCMOLT_GPON_NI_STAT_ALARM_CLEARED_ID_STAT                                               = 0,    /**< Statistic ID. */
    BCMOLT_GPON_NI_STAT_ALARM_CLEARED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the gpon_ni_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_gpon_ni_stat_alarm_raised_id
{
    BCMOLT_GPON_NI_STAT_ALARM_RAISED_ID__BEGIN                                              = 0,
    BCMOLT_GPON_NI_STAT_ALARM_RAISED_ID_STAT                                                = 0,    /**< Statistic ID. */
    BCMOLT_GPON_NI_STAT_ALARM_RAISED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_stat_alarm_raised_id;

/** Identifiers for all properties contained in the gpon_ni_stat_cfg group. 
 */
typedef enum bcmolt_gpon_ni_stat_cfg_id
{
    BCMOLT_GPON_NI_STAT_CFG_ID__BEGIN                                                       = 0,
    BCMOLT_GPON_NI_STAT_CFG_ID_CFG                                                          = 0,    /**< Configuration. */
    BCMOLT_GPON_NI_STAT_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_stat_cfg_id;

/** Identifiers for all properties contained in the gpon_ni_stat group. 
 */
typedef enum bcmolt_gpon_ni_stat_id
{
    BCMOLT_GPON_NI_STAT_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_NI_STAT_ID_FEC_CODEWORDS                                                    = 0,    /**< Received FEC codewords. */
    BCMOLT_GPON_NI_STAT_ID_FEC_CODEWORDS_UNCORRECTED                                        = 1,    /**< Received uncorrected FEC codewords. */
    BCMOLT_GPON_NI_STAT_ID_BIP8_BYTES                                                       = 2,    /**< Received bytes protected by bip8. */
    BCMOLT_GPON_NI_STAT_ID_BIP8_ERRORS                                                      = 3,    /**< Received bip8 errors. */
    BCMOLT_GPON_NI_STAT_ID_RX_GEM_PACKETS                                                   = 4,    /**< Received GEM frames. */
    BCMOLT_GPON_NI_STAT_ID_RX_GEM_DROPPED                                                   = 5,    /**< Received dropped GEM ID packets. */
    BCMOLT_GPON_NI_STAT_ID_RX_GEM_IDLE                                                      = 6,    /**< Received idle GEM frames. */
    BCMOLT_GPON_NI_STAT_ID_RX_GEM_CORRECTED                                                 = 7,    /**< Received corrected GEM frames. */
    BCMOLT_GPON_NI_STAT_ID_RX_GEM_ILLEGAL                                                   = 8,    /**< Received illegal GEM frames. */
    BCMOLT_GPON_NI_STAT_ID_RX_ALLOCATIONS_VALID                                             = 9,    /**< Received valid allocations. */
    BCMOLT_GPON_NI_STAT_ID_RX_ALLOCATIONS_INVALID                                           = 10,   /**< Received invalid allocations. */
    BCMOLT_GPON_NI_STAT_ID_RX_ALLOCATIONS_DISABLED                                          = 11,   /**< Received disabled allocations. */
    BCMOLT_GPON_NI_STAT_ID_RX_PLOAMS                                                        = 12,   /**< Received Ploams. */
    BCMOLT_GPON_NI_STAT_ID_RX_PLOAMS_NON_IDLE                                               = 13,   /**< Received non idle Ploams. */
    BCMOLT_GPON_NI_STAT_ID_RX_PLOAMS_ERROR                                                  = 14,   /**< Received error Ploams. */
    BCMOLT_GPON_NI_STAT_ID_RX_PLOAMS_DROPPED                                                = 15,   /**< Received dropped Ploams. */
    BCMOLT_GPON_NI_STAT_ID_RX_CPU                                                           = 16,   /**< Received CPU packets. */
    BCMOLT_GPON_NI_STAT_ID_RX_OMCI                                                          = 17,   /**< Received OMCI packets. */
    BCMOLT_GPON_NI_STAT_ID_RX_OMCI_PACKETS_CRC_ERROR                                        = 18,   /**< Received OMCI packets with CRC errors. */
    BCMOLT_GPON_NI_STAT_ID_RX_DROPPED_TOO_SHORT                                             = 19,   /**< Received packets dropped due to length too short. */
    BCMOLT_GPON_NI_STAT_ID_RX_DROPPED_TOO_LONG                                              = 20,   /**< Received packet dropped due to length too long. */
    BCMOLT_GPON_NI_STAT_ID_RX_CRC_ERRORS                                                    = 21,   /**< Received packet dropped due to crc error. */
    BCMOLT_GPON_NI_STAT_ID_RX_KEY_ERRORS                                                    = 22,   /**< Received packet dropped due to key error. */
    BCMOLT_GPON_NI_STAT_ID_RX_FRAGMENTS_ERRORS                                              = 23,   /**< Received packet dropped due to fragmentation error. */
    BCMOLT_GPON_NI_STAT_ID_RX_PACKETS_DROPPED                                               = 24,   /**< Global dropped packets. */
    BCMOLT_GPON_NI_STAT_ID_TX_GEM                                                           = 25,   /**< Transmitted GEM frames. */
    BCMOLT_GPON_NI_STAT_ID_TX_PLOAMS                                                        = 26,   /**< Transmitted Ploams. */
    BCMOLT_GPON_NI_STAT_ID_TX_GEM_FRAGMENTS                                                 = 27,   /**< Transmitted GEM fragments. */
    BCMOLT_GPON_NI_STAT_ID_TX_CPU                                                           = 28,   /**< Transmitted CPU packets. */
    BCMOLT_GPON_NI_STAT_ID_TX_OMCI                                                          = 29,   /**< Transmitted OMCI packets. */
    BCMOLT_GPON_NI_STAT_ID_TX_CPU_OMCI_PACKETS_DROPPED                                      = 30,   /**< Transmit packets dropped due to illegal length. */
    BCMOLT_GPON_NI_STAT_ID_TX_DROPPED_ILLEGAL_LENGTH                                        = 31,   /**< Transmitted packet dropped due to illegal length. */
    BCMOLT_GPON_NI_STAT_ID_TX_DROPPED_TPID_MISS                                             = 32,   /**< Dropped because of TPID miss. */
    BCMOLT_GPON_NI_STAT_ID_TX_DROPPED_VID_MISS                                              = 33,   /**< Dropped because of VID miss. */
    BCMOLT_GPON_NI_STAT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_stat_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_state_change_completed group. 
 */
typedef enum bcmolt_gpon_ni_state_change_completed_id
{
    BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID__BEGIN                                         = 0,
    BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID_RESULT                                         = 0,    /**< Result. */
    BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID_PREVIOUS_STATE                                 = 1,    /**< Previous state. */
    BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID_NEW_STATE                                      = 2,    /**< New state. */
    BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_state_change_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_ni_tod_request_completed group. 
 */
typedef enum bcmolt_gpon_ni_tod_request_completed_id
{
    BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID__BEGIN                                          = 0,
    BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_TOD_STRING                                      = 0,    /**< tod_string. */
    BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_SFC                                             = 1,    /**< sfc. */
    BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_RTC_OFFSET_SEC                                  = 2,    /**< rtc_offset_sec. */
    BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_RTC_OFFSET_NSEC                                 = 3,    /**< rtc_offset_nsec. */
    BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_STATUS                                          = 4,    /**< status. */
    BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_tod_request_completed_id;

/** Identifiers for all properties contained in the gpon_ni_tod_request group. 
 */
typedef enum bcmolt_gpon_ni_tod_request_id
{
    BCMOLT_GPON_NI_TOD_REQUEST_ID__NUM_OF           /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_tod_request_id;

/** Identifiers for all properties contained in the gpon_onu_auto_cfg group. 
 */
typedef enum bcmolt_gpon_onu_auto_cfg_id
{
    BCMOLT_GPON_ONU_AUTO_CFG_ID__BEGIN                                                      = 0,
    BCMOLT_GPON_ONU_AUTO_CFG_ID_BER_INTERVAL_CONFIGURATION_COMPLETED                        = 0,    /**< BER Interval Configuration Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_DFI                                                         = 1,    /**< Receive Dying-Gasp of ONUi. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_DGI                                                         = 2,    /**< Receive Dying-Gasp of ONUi. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_DOWI                                                        = 3,    /**< Drift of Window of ONUi. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_ERR                                                         = 4,    /**< ERR. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_INVALID_DBRU_REPORT                                         = 5,    /**< Invalid DBRu Report. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_COMPLETED                                      = 6,    /**< Key Exchange Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_CYCLE_SKIPPED                                  = 7,    /**< Key Exchange Cycle Skipped. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_DECRYPT_REQUIRED                               = 8,    /**< Key Exchange Decrypt Required. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_KEY_MISMATCH                                   = 9,    /**< Key Exchange Key Mismatch. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT                            = 10,   /**< Key Exchange Key Request Timeout. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_UNCONSECUTIVE_INDEX                            = 11,   /**< Key Exchange Unconsecutive Index. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_LOAI                                                        = 12,   /**< LOAi. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_LOKI                                                        = 13,   /**< LOki. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_MEMI                                                        = 14,   /**< MEMi. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_OMCI_PORT_ID_CONFIGURATION_COMPLETED                        = 15,   /**< OMCI PORT ID Configuration Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_ACTIVATION_COMPLETED                                    = 16,   /**< ONU Activation Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_ACTIVATION_STANDBY_COMPLETED                            = 17,   /**< onu activation standby completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_ALARM                                                   = 18,   /**< ONU Alarm. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_DEACTIVATION_COMPLETED                                  = 19,   /**< ONU Deactivation Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_DISABLE_COMPLETED                                       = 20,   /**< ONU Disable Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_ENABLE_COMPLETED                                        = 21,   /**< ONU Enable Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_OPTICAL_REFLECTION                                          = 22,   /**< Optical Reflection. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_PASSWORD_AUTHENTICATION_COMPLETED                           = 23,   /**< Password Authentication Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_PEE                                                         = 24,   /**< PEE. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_POSSIBLE_DRIFT                                              = 25,   /**< Possible Drift. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_POWER_MANAGEMENT_STATE_CHANGE                               = 26,   /**< Power Management State Change. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_PST                                                         = 27,   /**< PST. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_RANGING_COMPLETED                                           = 28,   /**< Ranging Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_REI                                                         = 29,   /**< REI. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_RSSI_MEASUREMENT_COMPLETED                                  = 30,   /**< RSSI Measurement Completed. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_SDI                                                         = 31,   /**< Signal Degraded of ONUi. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_SFI                                                         = 32,   /**< Signal Fail of ONUi. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_STAT_ALARM_CLEARED                                          = 33,   /**< Stat Alarm Cleared. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_STAT_ALARM_RAISED                                           = 34,   /**< Stat Alarm Raised. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_SUFI                                                        = 35,   /**< SUFi. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID_TIWI                                                        = 36,   /**< Transmission Interference Warning. */
    BCMOLT_GPON_ONU_AUTO_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_auto_cfg_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_ber_interval_configuration_completed group. 
 */
typedef enum bcmolt_gpon_onu_ber_interval_configuration_completed_id
{
    BCMOLT_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED_ID__BEGIN                          = 0,
    BCMOLT_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED_ID_BER_INTERVAL                    = 0,    /**< BER interval in ms. */
    BCMOLT_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED_ID_RESULT                          = 1,    /**< Result. */
    BCMOLT_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_ber_interval_configuration_completed_id;

/** Identifiers for all properties contained in the gpon_onu_cfg group. 
 */
typedef enum bcmolt_gpon_onu_cfg_id
{
    BCMOLT_GPON_ONU_CFG_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_CFG_ID_ONU_STATE                                                        = 0,    /**< onu state. */
    BCMOLT_GPON_ONU_CFG_ID_SERIAL_NUMBER                                                    = 1,    /**< Serial number. */
    BCMOLT_GPON_ONU_CFG_ID_PASSWORD                                                         = 2,    /**< password. */
    BCMOLT_GPON_ONU_CFG_ID_AUTO_PASSWORD_LEARNING                                           = 3,    /**< auto password learning. */
    BCMOLT_GPON_ONU_CFG_ID_US_FEC                                                           = 4,    /**< US FEC. */
    BCMOLT_GPON_ONU_CFG_ID_OMCI_PORT_ID                                                     = 5,    /**< OMCI port ID. */
    BCMOLT_GPON_ONU_CFG_ID_DS_BER_REPORTING_INTERVAL                                        = 6,    /**< DS BER reporting interval in ms. */
    BCMOLT_GPON_ONU_CFG_ID_AES_ENCRYPTION_KEY                                               = 7,    /**< AES encryption key. */
    BCMOLT_GPON_ONU_CFG_ID_ALARM_STATE                                                      = 8,    /**< alarm state. */
    BCMOLT_GPON_ONU_CFG_ID_RANGING_TIME                                                     = 9,    /**< ranging time. */
    BCMOLT_GPON_ONU_CFG_ID_DISABLED_AFTER_DISCOVERY                                         = 10,   /**< Disabled after Discovery. */
    BCMOLT_GPON_ONU_CFG_ID_DEACTIVATION_REASON                                              = 11,   /**< deactivation reason. */
    BCMOLT_GPON_ONU_CFG_ID_ALL_GEM_PORTS                                                    = 12,   /**< all GEM ports. */
    BCMOLT_GPON_ONU_CFG_ID_ALL_ALLOCS                                                       = 13,   /**< all allocs. */
    BCMOLT_GPON_ONU_CFG_ID_ONU_PS_TYPE_C                                                    = 14,   /**< onu protection switching type c. */
    BCMOLT_GPON_ONU_CFG_ID_EXTENDED_GUARD_TIME                                              = 15,   /**< Extended Guard Time. */
    BCMOLT_GPON_ONU_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_cfg_id;

/** Identifiers for all properties contained in the gpon_onu_change_power_level 
 * group. 
 */
typedef enum bcmolt_gpon_onu_change_power_level_id
{
    BCMOLT_GPON_ONU_CHANGE_POWER_LEVEL_ID__BEGIN                                            = 0,
    BCMOLT_GPON_ONU_CHANGE_POWER_LEVEL_ID_POWER_LEVEL_ACTION                                = 0,    /**< power level action. */
    BCMOLT_GPON_ONU_CHANGE_POWER_LEVEL_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_change_power_level_id;

/** Identifiers for all properties contained in the gpon_onu_cpu_packet group. 
 */
typedef enum bcmolt_gpon_onu_cpu_packet_id
{
    BCMOLT_GPON_ONU_CPU_PACKET_ID__BEGIN                                                    = 0,
    BCMOLT_GPON_ONU_CPU_PACKET_ID_PORT_ID                                                   = 0,    /**< port_id. */
    BCMOLT_GPON_ONU_CPU_PACKET_ID_CRC_OK                                                    = 1,    /**< crc_ok. */
    BCMOLT_GPON_ONU_CPU_PACKET_ID_PACKET_SIZE                                               = 2,    /**< packet_size. */
    BCMOLT_GPON_ONU_CPU_PACKET_ID_BUFFER                                                    = 3,    /**< buffer. */
    BCMOLT_GPON_ONU_CPU_PACKET_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_cpu_packet_id;

/** Identifiers for all properties contained in the gpon_onu_cpu_packets group. 
 */
typedef enum bcmolt_gpon_onu_cpu_packets_id
{
    BCMOLT_GPON_ONU_CPU_PACKETS_ID__BEGIN                                                   = 0,
    BCMOLT_GPON_ONU_CPU_PACKETS_ID_PACKET_TYPE                                              = 0,    /**< packet type. */
    BCMOLT_GPON_ONU_CPU_PACKETS_ID_CALC_CRC                                                 = 1,    /**< calc crc. */
    BCMOLT_GPON_ONU_CPU_PACKETS_ID_NUMBER_OF_PACKETS                                        = 2,    /**< number of packets. */
    BCMOLT_GPON_ONU_CPU_PACKETS_ID_PACKET_SIZE                                              = 3,    /**< Single packet size. */
    BCMOLT_GPON_ONU_CPU_PACKETS_ID_BUFFER                                                   = 4,    /**< buffer. */
    BCMOLT_GPON_ONU_CPU_PACKETS_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_cpu_packets_id;

/** Identifiers for all properties contained in the gpon_onu_dfi group. 
 */
typedef enum bcmolt_gpon_onu_dfi_id
{
    BCMOLT_GPON_ONU_DFI_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_DFI_ID_ALARM_STATUS                                                     = 0,    /**< alarm status. */
    BCMOLT_GPON_ONU_DFI_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_dfi_id;

/** Identifiers for all properties contained in the gpon_onu_dgi group. 
 */
typedef enum bcmolt_gpon_onu_dgi_id
{
    BCMOLT_GPON_ONU_DGI_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_DGI_ID_ALARM_STATUS                                                     = 0,    /**< alarm status. */
    BCMOLT_GPON_ONU_DGI_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_dgi_id;

/** Identifiers for all properties contained in the gpon_onu_dowi group. 
 */
typedef enum bcmolt_gpon_onu_dowi_id
{
    BCMOLT_GPON_ONU_DOWI_ID__BEGIN                                                          = 0,
    BCMOLT_GPON_ONU_DOWI_ID_ALARM_STATUS                                                    = 0,    /**< Alarm status. */
    BCMOLT_GPON_ONU_DOWI_ID_DRIFT_VALUE                                                     = 1,    /**< Drift value. */
    BCMOLT_GPON_ONU_DOWI_ID_NEW_EQD                                                         = 2,    /**< New EQD. */
    BCMOLT_GPON_ONU_DOWI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_dowi_id;

/** Identifiers for all properties contained in the gpon_onu_err group. 
 */
typedef enum bcmolt_gpon_onu_err_id
{
    BCMOLT_GPON_ONU_ERR_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_ERR_ID_BIP8_ERRORS                                                      = 0,    /**< BIP8 errors. */
    BCMOLT_GPON_ONU_ERR_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_err_id;

/** Identifiers for all properties contained in the gpon_onu_invalid_dbru_report 
 * group. 
 */
typedef enum bcmolt_gpon_onu_invalid_dbru_report_id
{
    BCMOLT_GPON_ONU_INVALID_DBRU_REPORT_ID__BEGIN                                           = 0,
    BCMOLT_GPON_ONU_INVALID_DBRU_REPORT_ID_ALLOC_ID                                         = 0,    /**< Alloc-ID. */
    BCMOLT_GPON_ONU_INVALID_DBRU_REPORT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_invalid_dbru_report_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_key_exchange_completed group. 
 */
typedef enum bcmolt_gpon_onu_key_exchange_completed_id
{
    BCMOLT_GPON_ONU_KEY_EXCHANGE_COMPLETED_ID__BEGIN                                        = 0,
    BCMOLT_GPON_ONU_KEY_EXCHANGE_COMPLETED_ID_NEW_KEY                                       = 0,    /**< new key. */
    BCMOLT_GPON_ONU_KEY_EXCHANGE_COMPLETED_ID__NUM_OF       /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_key_exchange_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_key_exchange_cycle_skipped group. 
 */
typedef enum bcmolt_gpon_onu_key_exchange_cycle_skipped_id
{
    BCMOLT_GPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_key_exchange_cycle_skipped_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_key_exchange_decrypt_required group. 
 */
typedef enum bcmolt_gpon_onu_key_exchange_decrypt_required_id
{
    BCMOLT_GPON_ONU_KEY_EXCHANGE_DECRYPT_REQUIRED_ID__BEGIN                                 = 0,
    BCMOLT_GPON_ONU_KEY_EXCHANGE_DECRYPT_REQUIRED_ID_NEW_KEY                                = 0,    /**< new key. */
    BCMOLT_GPON_ONU_KEY_EXCHANGE_DECRYPT_REQUIRED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_key_exchange_decrypt_required_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_key_exchange_key_mismatch group. 
 */
typedef enum bcmolt_gpon_onu_key_exchange_key_mismatch_id
{
    BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID__BEGIN                                     = 0,
    BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID_EXPECTED_KEY                               = 0,    /**< expected key. */
    BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID_RECEIVED_KEY                               = 1,    /**< received key. */
    BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID__NUM_OF        /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_key_exchange_key_mismatch_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_key_exchange_key_request_timeout group. 
 */
typedef enum bcmolt_gpon_onu_key_exchange_key_request_timeout_id
{
    BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_key_exchange_key_request_timeout_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_key_exchange_unconsecutive_index group. 
 */
typedef enum bcmolt_gpon_onu_key_exchange_unconsecutive_index_id
{
    BCMOLT_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX_ID__BEGIN                              = 0,
    BCMOLT_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX_ID_EXPECTED_INDEX                      = 0,    /**< expected index. */
    BCMOLT_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX_ID_ACTUAL_INDEX                        = 1,    /**< actual index. */
    BCMOLT_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_key_exchange_unconsecutive_index_id;

/** Identifiers for all properties contained in the gpon_onu_key group. 
 */
typedef enum bcmolt_gpon_onu_key_id
{
    BCMOLT_GPON_ONU_KEY_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_KEY_ID_PON_NI                                                           = 0,    /**< PON network interface. */
    BCMOLT_GPON_ONU_KEY_ID_ONU_ID                                                           = 1,    /**< ONU ID. */
    BCMOLT_GPON_ONU_KEY_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_key_id;

/** Identifiers for all properties contained in the gpon_onu_loai group. 
 */
typedef enum bcmolt_gpon_onu_loai_id
{
    BCMOLT_GPON_ONU_LOAI_ID__BEGIN                                                          = 0,
    BCMOLT_GPON_ONU_LOAI_ID_ALARM_STATUS                                                    = 0,    /**< alarm status. */
    BCMOLT_GPON_ONU_LOAI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_loai_id;

/** Identifiers for all properties contained in the gpon_onu_loki group. 
 */
typedef enum bcmolt_gpon_onu_loki_id
{
    BCMOLT_GPON_ONU_LOKI_ID__BEGIN                                                          = 0,
    BCMOLT_GPON_ONU_LOKI_ID_ALARM_STATUS                                                    = 0,    /**< alarm status. */
    BCMOLT_GPON_ONU_LOKI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_loki_id;

/** Identifiers for all properties contained in the gpon_onu_memi group. 
 */
typedef enum bcmolt_gpon_onu_memi_id
{
    BCMOLT_GPON_ONU_MEMI_ID__BEGIN                                                          = 0,
    BCMOLT_GPON_ONU_MEMI_ID_PLOAM_BUFFER                                                    = 0,    /**< PLOAM buffer. */
    BCMOLT_GPON_ONU_MEMI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_memi_id;

/** Identifiers for all properties contained in the gpon_onu_omci_packet group. 
 */
typedef enum bcmolt_gpon_onu_omci_packet_id
{
    BCMOLT_GPON_ONU_OMCI_PACKET_ID__BEGIN                                                   = 0,
    BCMOLT_GPON_ONU_OMCI_PACKET_ID_PORT_ID                                                  = 0,    /**< port_id. */
    BCMOLT_GPON_ONU_OMCI_PACKET_ID_CRC_OK                                                   = 1,    /**< crc_ok. */
    BCMOLT_GPON_ONU_OMCI_PACKET_ID_PACKET_SIZE                                              = 2,    /**< packet_size. */
    BCMOLT_GPON_ONU_OMCI_PACKET_ID_BUFFER                                                   = 3,    /**< buffer. */
    BCMOLT_GPON_ONU_OMCI_PACKET_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_omci_packet_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_omci_port_id_configuration_completed group. 
 */
typedef enum bcmolt_gpon_onu_omci_port_id_configuration_completed_id
{
    BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID__BEGIN                          = 0,
    BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID_GEM_PORT                        = 0,    /**< GEM Port ID. */
    BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID_STATUS                          = 1,    /**< status. */
    BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID_OPERATION                       = 2,    /**< Operation. */
    BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_omci_port_id_configuration_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_onu_activation_completed group. 
 */
typedef enum bcmolt_gpon_onu_onu_activation_completed_id
{
    BCMOLT_GPON_ONU_ONU_ACTIVATION_COMPLETED_ID__BEGIN                                      = 0,
    BCMOLT_GPON_ONU_ONU_ACTIVATION_COMPLETED_ID_STATUS                                      = 0,    /**< status. */
    BCMOLT_GPON_ONU_ONU_ACTIVATION_COMPLETED_ID_FAIL_REASON                                 = 1,    /**< fail reason. */
    BCMOLT_GPON_ONU_ONU_ACTIVATION_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_onu_activation_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_onu_activation_standby_completed group. 
 */
typedef enum bcmolt_gpon_onu_onu_activation_standby_completed_id
{
    BCMOLT_GPON_ONU_ONU_ACTIVATION_STANDBY_COMPLETED_ID__BEGIN                              = 0,
    BCMOLT_GPON_ONU_ONU_ACTIVATION_STANDBY_COMPLETED_ID_RESULT                              = 0,    /**< result. */
    BCMOLT_GPON_ONU_ONU_ACTIVATION_STANDBY_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_onu_activation_standby_completed_id;

/** Identifiers for all properties contained in the gpon_onu_onu_alarm group. 
 */
typedef enum bcmolt_gpon_onu_onu_alarm_id
{
    BCMOLT_GPON_ONU_ONU_ALARM_ID__BEGIN                                                     = 0,
    BCMOLT_GPON_ONU_ONU_ALARM_ID_ONU_ALARM                                                  = 0,    /**< onu alarm. */
    BCMOLT_GPON_ONU_ONU_ALARM_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_onu_alarm_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_onu_deactivation_completed group. 
 */
typedef enum bcmolt_gpon_onu_onu_deactivation_completed_id
{
    BCMOLT_GPON_ONU_ONU_DEACTIVATION_COMPLETED_ID__BEGIN                                    = 0,
    BCMOLT_GPON_ONU_ONU_DEACTIVATION_COMPLETED_ID_STATUS                                    = 0,    /**< status. */
    BCMOLT_GPON_ONU_ONU_DEACTIVATION_COMPLETED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_onu_deactivation_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_onu_disable_completed group. 
 */
typedef enum bcmolt_gpon_onu_onu_disable_completed_id
{
    BCMOLT_GPON_ONU_ONU_DISABLE_COMPLETED_ID__BEGIN                                         = 0,
    BCMOLT_GPON_ONU_ONU_DISABLE_COMPLETED_ID_SERIAL_NUMBER                                  = 0,    /**< serial number. */
    BCMOLT_GPON_ONU_ONU_DISABLE_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_onu_disable_completed_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_onu_enable_completed group. 
 */
typedef enum bcmolt_gpon_onu_onu_enable_completed_id
{
    BCMOLT_GPON_ONU_ONU_ENABLE_COMPLETED_ID__BEGIN                                          = 0,
    BCMOLT_GPON_ONU_ONU_ENABLE_COMPLETED_ID_SERIAL_NUMBER                                   = 0,    /**< serial number. */
    BCMOLT_GPON_ONU_ONU_ENABLE_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_onu_enable_completed_id;

/** Identifiers for all properties contained in the gpon_onu_optical_reflection 
 * group. 
 */
typedef enum bcmolt_gpon_onu_optical_reflection_id
{
    BCMOLT_GPON_ONU_OPTICAL_REFLECTION_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_optical_reflection_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_password_authentication_completed group. 
 */
typedef enum bcmolt_gpon_onu_password_authentication_completed_id
{
    BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID__BEGIN                             = 0,
    BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID_STATUS                             = 0,    /**< status. */
    BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID_FAIL_REASON                        = 1,    /**< fail reason. */
    BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID_PASSWORD                           = 2,    /**< password. */
    BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_password_authentication_completed_id;

/** Identifiers for all properties contained in the gpon_onu_pee group. 
 */
typedef enum bcmolt_gpon_onu_pee_id
{
    BCMOLT_GPON_ONU_PEE_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_PEE_ID_ALARM_STATUS                                                     = 0,    /**< alarm status. */
    BCMOLT_GPON_ONU_PEE_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_pee_id;

/** Identifiers for all properties contained in the gpon_onu_ploam_packet group. 
 */
typedef enum bcmolt_gpon_onu_ploam_packet_id
{
    BCMOLT_GPON_ONU_PLOAM_PACKET_ID__BEGIN                                                  = 0,
    BCMOLT_GPON_ONU_PLOAM_PACKET_ID_PLOAM                                                   = 0,    /**< ploam. */
    BCMOLT_GPON_ONU_PLOAM_PACKET_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_ploam_packet_id;

/** Identifiers for all properties contained in the gpon_onu_possible_drift 
 * group. 
 */
typedef enum bcmolt_gpon_onu_possible_drift_id
{
    BCMOLT_GPON_ONU_POSSIBLE_DRIFT_ID__BEGIN                                                = 0,
    BCMOLT_GPON_ONU_POSSIBLE_DRIFT_ID_ALARM_STATUS                                          = 0,    /**< Alarm Status. */
    BCMOLT_GPON_ONU_POSSIBLE_DRIFT_ID_ESTIMATED_DRIFT                                       = 1,    /**< Estimated Drift. */
    BCMOLT_GPON_ONU_POSSIBLE_DRIFT_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_possible_drift_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_power_management_state_change group. 
 */
typedef enum bcmolt_gpon_onu_power_management_state_change_id
{
    BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID__BEGIN                                 = 0,
    BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_OLD_STATE                              = 0,    /**< Old State. */
    BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_NEW_STATE                              = 1,    /**< New State. */
    BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_REASON                                 = 2,    /**< Reason. */
    BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_power_management_state_change_id;

/** Identifiers for all properties contained in the gpon_onu_pst group. 
 */
typedef enum bcmolt_gpon_onu_pst_id
{
    BCMOLT_GPON_ONU_PST_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_PST_ID_LINK_NUMBER                                                      = 0,    /**< link number. */
    BCMOLT_GPON_ONU_PST_ID_K1                                                               = 1,    /**< K1. */
    BCMOLT_GPON_ONU_PST_ID_K2                                                               = 2,    /**< K2. */
    BCMOLT_GPON_ONU_PST_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_pst_id;

/** Identifiers for all properties contained in the gpon_onu_ranging_completed 
 * group. 
 */
typedef enum bcmolt_gpon_onu_ranging_completed_id
{
    BCMOLT_GPON_ONU_RANGING_COMPLETED_ID__BEGIN                                             = 0,
    BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_STATUS                                             = 0,    /**< status. */
    BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_FAIL_REASON                                        = 1,    /**< fail reason. */
    BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_NUMBER_OF_PLOAMS                                   = 2,    /**< number of PLOAMs. */
    BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_EQD                                                = 3,    /**< EQD. */
    BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_POWER_LEVEL                                        = 4,    /**< Power Level. */
    BCMOLT_GPON_ONU_RANGING_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_ranging_completed_id;

/** Identifiers for all properties contained in the gpon_onu_rei group. 
 */
typedef enum bcmolt_gpon_onu_rei_id
{
    BCMOLT_GPON_ONU_REI_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_REI_ID_BIP8_ERRORS                                                      = 0,    /**< BIP8 errors. */
    BCMOLT_GPON_ONU_REI_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_rei_id;

/** Identifiers for all properties contained in the 
 * gpon_onu_rssi_measurement_completed group. 
 */
typedef enum bcmolt_gpon_onu_rssi_measurement_completed_id
{
    BCMOLT_GPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID__BEGIN                                    = 0,
    BCMOLT_GPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID_STATUS                                    = 0,    /**< status. */
    BCMOLT_GPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID_FAIL_REASON                               = 1,    /**< fail reason. */
    BCMOLT_GPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_rssi_measurement_completed_id;

/** Identifiers for all properties contained in the gpon_onu_rssi_measurement 
 * group. 
 */
typedef enum bcmolt_gpon_onu_rssi_measurement_id
{
    BCMOLT_GPON_ONU_RSSI_MEASUREMENT_ID__NUM_OF             /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_rssi_measurement_id;

/** Identifiers for all properties contained in the gpon_onu_sdi group. 
 */
typedef enum bcmolt_gpon_onu_sdi_id
{
    BCMOLT_GPON_ONU_SDI_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_SDI_ID_ALARM_STATUS                                                     = 0,    /**< alarm status. */
    BCMOLT_GPON_ONU_SDI_ID_BER                                                              = 1,    /**< BER. */
    BCMOLT_GPON_ONU_SDI_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_sdi_id;

/** Identifiers for all properties contained in the gpon_onu_set_onu_state 
 * group. 
 */
typedef enum bcmolt_gpon_onu_set_onu_state_id
{
    BCMOLT_GPON_ONU_SET_ONU_STATE_ID__BEGIN                                                 = 0,
    BCMOLT_GPON_ONU_SET_ONU_STATE_ID_ONU_STATE                                              = 0,    /**< ONU state. */
    BCMOLT_GPON_ONU_SET_ONU_STATE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_set_onu_state_id;

/** Identifiers for all properties contained in the gpon_onu_sfi group. 
 */
typedef enum bcmolt_gpon_onu_sfi_id
{
    BCMOLT_GPON_ONU_SFI_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_ONU_SFI_ID_ALARM_STATUS                                                     = 0,    /**< alarm status. */
    BCMOLT_GPON_ONU_SFI_ID_BER                                                              = 1,    /**< BER. */
    BCMOLT_GPON_ONU_SFI_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_sfi_id;

/** Identifiers for all properties contained in the gpon_onu_stat_alarm_cleared 
 * group. 
 */
typedef enum bcmolt_gpon_onu_stat_alarm_cleared_id
{
    BCMOLT_GPON_ONU_STAT_ALARM_CLEARED_ID__BEGIN                                            = 0,
    BCMOLT_GPON_ONU_STAT_ALARM_CLEARED_ID_STAT                                              = 0,    /**< Statistic ID. */
    BCMOLT_GPON_ONU_STAT_ALARM_CLEARED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the gpon_onu_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_gpon_onu_stat_alarm_raised_id
{
    BCMOLT_GPON_ONU_STAT_ALARM_RAISED_ID__BEGIN                                             = 0,
    BCMOLT_GPON_ONU_STAT_ALARM_RAISED_ID_STAT                                               = 0,    /**< Statistic ID. */
    BCMOLT_GPON_ONU_STAT_ALARM_RAISED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_stat_alarm_raised_id;

/** Identifiers for all properties contained in the gpon_onu_stat_cfg group. 
 */
typedef enum bcmolt_gpon_onu_stat_cfg_id
{
    BCMOLT_GPON_ONU_STAT_CFG_ID__BEGIN                                                      = 0,
    BCMOLT_GPON_ONU_STAT_CFG_ID_CFG                                                         = 0,    /**< Configuration. */
    BCMOLT_GPON_ONU_STAT_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_stat_cfg_id;

/** Identifiers for all properties contained in the gpon_onu_stat group. 
 */
typedef enum bcmolt_gpon_onu_stat_id
{
    BCMOLT_GPON_ONU_STAT_ID__BEGIN                                                          = 0,
    BCMOLT_GPON_ONU_STAT_ID_FEC_CODEWORDS                                                   = 0,    /**< Total received FEC codewords. */
    BCMOLT_GPON_ONU_STAT_ID_FEC_BYTES_CORRECTED                                             = 1,    /**< FEC codewords corrected bytes. */
    BCMOLT_GPON_ONU_STAT_ID_FEC_CODEWORDS_CORRECTED                                         = 2,    /**< FEC corrected codewords error . */
    BCMOLT_GPON_ONU_STAT_ID_FEC_CODEWORDS_UNCORRECTED                                       = 3,    /**< FEC not corrected codewords error. */
    BCMOLT_GPON_ONU_STAT_ID_BIP8_BYTES                                                      = 4,    /**< Received bytes for BIP8. */
    BCMOLT_GPON_ONU_STAT_ID_BIP8_ERRORS                                                     = 5,    /**< Bit error according to BIP8. */
    BCMOLT_GPON_ONU_STAT_ID_RX_PLOAMS_CRC_ERROR                                             = 6,    /**< Received PLOAMs with CRC error. */
    BCMOLT_GPON_ONU_STAT_ID_RX_PLOAMS_NON_IDLE                                              = 7,    /**< Received non idle PLOAMs. */
    BCMOLT_GPON_ONU_STAT_ID_POSITIVE_DRIFT                                                  = 8,    /**< Positive drift. */
    BCMOLT_GPON_ONU_STAT_ID_NEGATIVE_DRIFT                                                  = 9,    /**< Negative drift. */
    BCMOLT_GPON_ONU_STAT_ID_RX_OMCI                                                         = 10,   /**< Received OMCI packets. */
    BCMOLT_GPON_ONU_STAT_ID_RX_OMCI_PACKETS_CRC_ERROR                                       = 11,   /**< Received OMCI packets with CRC errors. */
    BCMOLT_GPON_ONU_STAT_ID_BER_REPORTED                                                    = 12,   /**< BER reported. */
    BCMOLT_GPON_ONU_STAT_ID_UNRECEIVED_BURST                                                = 13,   /**< Unreceived burst. */
    BCMOLT_GPON_ONU_STAT_ID_LCDG_ERRORS                                                     = 14,   /**< LCDG errors. */
    BCMOLT_GPON_ONU_STAT_ID_RDI_ERRORS                                                      = 15,   /**< RDI errors. */
    BCMOLT_GPON_ONU_STAT_ID_RX_BYTES                                                        = 16,   /**< rx bytes. */
    BCMOLT_GPON_ONU_STAT_ID_RX_PACKETS                                                      = 17,   /**< rx packets. */
    BCMOLT_GPON_ONU_STAT_ID_TX_BYTES                                                        = 18,   /**< tx bytes. */
    BCMOLT_GPON_ONU_STAT_ID_TX_PACKETS                                                      = 19,   /**< tx packets. */
    BCMOLT_GPON_ONU_STAT_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_stat_id;

/** Identifiers for all properties contained in the gpon_onu_sufi group. 
 */
typedef enum bcmolt_gpon_onu_sufi_id
{
    BCMOLT_GPON_ONU_SUFI_ID__BEGIN                                                          = 0,
    BCMOLT_GPON_ONU_SUFI_ID_ALARM_STATUS                                                    = 0,    /**< alarm status. */
    BCMOLT_GPON_ONU_SUFI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_sufi_id;

/** Identifiers for all properties contained in the gpon_onu_tiwi group. 
 */
typedef enum bcmolt_gpon_onu_tiwi_id
{
    BCMOLT_GPON_ONU_TIWI_ID__BEGIN                                                          = 0,
    BCMOLT_GPON_ONU_TIWI_ID_ALARM_STATUS                                                    = 0,    /**< Alarm status. */
    BCMOLT_GPON_ONU_TIWI_ID_DRIFT_VALUE                                                     = 1,    /**< Drift value. */
    BCMOLT_GPON_ONU_TIWI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_tiwi_id;

/** Identifiers for all properties contained in the gpon_trx_cfg group. 
 */
typedef enum bcmolt_gpon_trx_cfg_id
{
    BCMOLT_GPON_TRX_CFG_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_TRX_CFG_ID_TRANSCEIVER_TYPE                                                 = 0,    /**< transceiver type. */
    BCMOLT_GPON_TRX_CFG_ID_LA_CONFIGURATION                                                 = 1,    /**< LA configuration. */
    BCMOLT_GPON_TRX_CFG_ID_BCDR                                                             = 2,    /**< BCDR. */
    BCMOLT_GPON_TRX_CFG_ID_LA_RANGING_AFTER_NO_ED_RESYNC                                    = 3,    /**< LA ranging after no ed resync . */
    BCMOLT_GPON_TRX_CFG_ID_BCDR_RANGING_AFTER_NO_ED_RESYNC                                  = 4,    /**< BCDR ranging after no ed resync configuration. */
    BCMOLT_GPON_TRX_CFG_ID_LA_RANGING_AFTER_ED_RESYNC                                       = 5,    /**< LA ranging after ed resync . */
    BCMOLT_GPON_TRX_CFG_ID_BCDR_RANGING_AFTER_ED_RESYNC                                     = 6,    /**< BCDR ranging after ed resync. */
    BCMOLT_GPON_TRX_CFG_ID_LA_RESYNC_POLARITY                                               = 7,    /**< la resync polarity. */
    BCMOLT_GPON_TRX_CFG_ID_BCDR_RESYNC_POLARITY                                             = 8,    /**< BCDR resync polarity. */
    BCMOLT_GPON_TRX_CFG_ID_BCDR_RANGING_RESYNC_CONDITIONS                                   = 9,    /**< bcdr ranging resync conditions. */
    BCMOLT_GPON_TRX_CFG_ID_LA_RANGING_RESYNC_CONDITIONS                                     = 10,   /**< la ranging resync conditions. */
    BCMOLT_GPON_TRX_CFG_ID_RX_CONFIGURATION                                                 = 11,   /**< RX configuration. */
    BCMOLT_GPON_TRX_CFG_ID_RANGING_CONTROL_STAGES_CONFIGURATION                             = 12,   /**< ranging control stages configuration. */
    BCMOLT_GPON_TRX_CFG_ID_ENERGY_DETECT                                                    = 13,   /**< Energy Detect. */
    BCMOLT_GPON_TRX_CFG_ID_END_OF_BURST_DATA_PATTERN                                        = 14,   /**< end of burst data pattern . */
    BCMOLT_GPON_TRX_CFG_ID_END_OF_BURST_RANGING_PATTERN                                     = 15,   /**< end of burst ranging pattern. */
    BCMOLT_GPON_TRX_CFG_ID_PREAMBLE                                                         = 16,   /**< Preamble. */
    BCMOLT_GPON_TRX_CFG_ID_DELIMITER                                                        = 17,   /**< Delimiter. */
    BCMOLT_GPON_TRX_CFG_ID_GUARD_BITS                                                       = 18,   /**< Guard bits. */
    BCMOLT_GPON_TRX_CFG_ID_SERDES_CONFIGURATION                                             = 19,   /**< serdes configuration. */
    BCMOLT_GPON_TRX_CFG_ID_PLO_RANGING                                                      = 20,   /**< PLO for ranging. */
    BCMOLT_GPON_TRX_CFG_ID_PLO_DATA                                                         = 21,   /**< PLO for data. */
    BCMOLT_GPON_TRX_CFG_ID_RSSI_NORMAL_CONFIG                                               = 22,   /**< rssi normal config. */
    BCMOLT_GPON_TRX_CFG_ID_RANGING_RSSI_RESYNC_CONTROL                                      = 23,   /**< ranging rssi resync control. */
    BCMOLT_GPON_TRX_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_trx_cfg_id;

/** Identifiers for all properties contained in the gpon_trx_key group. 
 */
typedef enum bcmolt_gpon_trx_key_id
{
    BCMOLT_GPON_TRX_KEY_ID__BEGIN                                                           = 0,
    BCMOLT_GPON_TRX_KEY_ID_PON_NI                                                           = 0,    /**< PON network interface. */
    BCMOLT_GPON_TRX_KEY_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_trx_key_id;

/** Identifiers for all properties contained in the log_entry_auto_cfg group. 
 */
typedef enum bcmolt_log_entry_auto_cfg_id
{
    BCMOLT_LOG_ENTRY_AUTO_CFG_ID__BEGIN                                                     = 0,
    BCMOLT_LOG_ENTRY_AUTO_CFG_ID_STAT_ALARM_CLEARED                                         = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_LOG_ENTRY_AUTO_CFG_ID_STAT_ALARM_RAISED                                          = 1,    /**< Stat Alarm Raised. */
    BCMOLT_LOG_ENTRY_AUTO_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_log_entry_auto_cfg_id;

/** Identifiers for all properties contained in the log_entry_cfg group. 
 */
typedef enum bcmolt_log_entry_cfg_id
{
    BCMOLT_LOG_ENTRY_CFG_ID__BEGIN                                                          = 0,
    BCMOLT_LOG_ENTRY_CFG_ID_DEFAULT_LOG_LEVEL                                               = 0,    /**< default log level. */
    BCMOLT_LOG_ENTRY_CFG_ID_DEFAULT_LOG_TYPE                                                = 1,    /**< default log type. */
    BCMOLT_LOG_ENTRY_CFG_ID_LOG_LEVEL_PRINT                                                 = 2,    /**< log level print. */
    BCMOLT_LOG_ENTRY_CFG_ID_LOG_LEVEL_SAVE                                                  = 3,    /**< log level save. */
    BCMOLT_LOG_ENTRY_CFG_ID_LOG_TYPE                                                        = 4,    /**< log type. */
    BCMOLT_LOG_ENTRY_CFG_ID_LOG_STYLE                                                       = 5,    /**< log_style. */
    BCMOLT_LOG_ENTRY_CFG_ID_LOG_NAME                                                        = 6,    /**< log name. */
    BCMOLT_LOG_ENTRY_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_log_entry_cfg_id;

/** Identifiers for all properties contained in the log_entry_key group. 
 */
typedef enum bcmolt_log_entry_key_id
{
    BCMOLT_LOG_ENTRY_KEY_ID__BEGIN                                                          = 0,
    BCMOLT_LOG_ENTRY_KEY_ID_LOG_ID                                                          = 0,    /**< log id. */
    BCMOLT_LOG_ENTRY_KEY_ID_RESERVED                                                        = 1,    /**< reserved. */
    BCMOLT_LOG_ENTRY_KEY_ID_NAME                                                            = 2,    /**< name. */
    BCMOLT_LOG_ENTRY_KEY_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_log_entry_key_id;

/** Identifiers for all properties contained in the log_entry_stat_alarm_cleared 
 * group. 
 */
typedef enum bcmolt_log_entry_stat_alarm_cleared_id
{
    BCMOLT_LOG_ENTRY_STAT_ALARM_CLEARED_ID__BEGIN                                           = 0,
    BCMOLT_LOG_ENTRY_STAT_ALARM_CLEARED_ID_STAT                                             = 0,    /**< Statistic ID. */
    BCMOLT_LOG_ENTRY_STAT_ALARM_CLEARED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_log_entry_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the log_entry_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_log_entry_stat_alarm_raised_id
{
    BCMOLT_LOG_ENTRY_STAT_ALARM_RAISED_ID__BEGIN                                            = 0,
    BCMOLT_LOG_ENTRY_STAT_ALARM_RAISED_ID_STAT                                              = 0,    /**< Statistic ID. */
    BCMOLT_LOG_ENTRY_STAT_ALARM_RAISED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_log_entry_stat_alarm_raised_id;

/** Identifiers for all properties contained in the log_entry_stat_cfg group. 
 */
typedef enum bcmolt_log_entry_stat_cfg_id
{
    BCMOLT_LOG_ENTRY_STAT_CFG_ID__BEGIN                                                     = 0,
    BCMOLT_LOG_ENTRY_STAT_CFG_ID_CFG                                                        = 0,    /**< Configuration. */
    BCMOLT_LOG_ENTRY_STAT_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_log_entry_stat_cfg_id;

/** Identifiers for all properties contained in the log_entry_stat group. 
 */
typedef enum bcmolt_log_entry_stat_id
{
    BCMOLT_LOG_ENTRY_STAT_ID__BEGIN                                                         = 0,
    BCMOLT_LOG_ENTRY_STAT_ID_MSG_COUNT                                                      = 0,    /**< msg count. */
    BCMOLT_LOG_ENTRY_STAT_ID_LOST_MSG_COUNT                                                 = 1,    /**< lost msg count. */
    BCMOLT_LOG_ENTRY_STAT_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_log_entry_stat_id;

/** Identifiers for all properties contained in the logger_auto_cfg group. 
 */
typedef enum bcmolt_logger_auto_cfg_id
{
    BCMOLT_LOGGER_AUTO_CFG_ID__BEGIN                                                        = 0,
    BCMOLT_LOGGER_AUTO_CFG_ID_STAT_ALARM_CLEARED                                            = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_LOGGER_AUTO_CFG_ID_STAT_ALARM_RAISED                                             = 1,    /**< Stat Alarm Raised. */
    BCMOLT_LOGGER_AUTO_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_auto_cfg_id;

/** Identifiers for all properties contained in the logger_cfg group. 
 */
typedef enum bcmolt_logger_cfg_id
{
    BCMOLT_LOGGER_CFG_ID__BEGIN                                                             = 0,
    BCMOLT_LOGGER_CFG_ID_BUFFER                                                             = 0,    /**< buffer. */
    BCMOLT_LOGGER_CFG_ID_WRAP_AROUND                                                        = 1,    /**< wrap around. */
    BCMOLT_LOGGER_CFG_ID_CLEAR_AFTER_READ                                                   = 2,    /**< clear_after_read. */
    BCMOLT_LOGGER_CFG_ID_ENABLE_LOG                                                         = 3,    /**< enable log. */
    BCMOLT_LOGGER_CFG_ID_LOG_NAMES                                                          = 4,    /**< log_names. */
    BCMOLT_LOGGER_CFG_ID__NUM_OF        /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_cfg_id;

/** Identifiers for all properties contained in the logger_clear_log group. 
 */
typedef enum bcmolt_logger_clear_log_id
{
    BCMOLT_LOGGER_CLEAR_LOG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_clear_log_id;

/** Identifiers for all properties contained in the logger_key group. 
 */
typedef enum bcmolt_logger_key_id
{
    BCMOLT_LOGGER_KEY_ID__BEGIN                                                             = 0,
    BCMOLT_LOGGER_KEY_ID_RESERVED                                                           = 0,    /**< reserved. */
    BCMOLT_LOGGER_KEY_ID_FILE_ID                                                            = 1,    /**< file id. */
    BCMOLT_LOGGER_KEY_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_key_id;

/** Identifiers for all properties contained in the logger_stat_alarm_cleared 
 * group. 
 */
typedef enum bcmolt_logger_stat_alarm_cleared_id
{
    BCMOLT_LOGGER_STAT_ALARM_CLEARED_ID__BEGIN                                              = 0,
    BCMOLT_LOGGER_STAT_ALARM_CLEARED_ID_STAT                                                = 0,    /**< Statistic ID. */
    BCMOLT_LOGGER_STAT_ALARM_CLEARED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the logger_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_logger_stat_alarm_raised_id
{
    BCMOLT_LOGGER_STAT_ALARM_RAISED_ID__BEGIN                                               = 0,
    BCMOLT_LOGGER_STAT_ALARM_RAISED_ID_STAT                                                 = 0,    /**< Statistic ID. */
    BCMOLT_LOGGER_STAT_ALARM_RAISED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_stat_alarm_raised_id;

/** Identifiers for all properties contained in the logger_stat_cfg group. 
 */
typedef enum bcmolt_logger_stat_cfg_id
{
    BCMOLT_LOGGER_STAT_CFG_ID__BEGIN                                                        = 0,
    BCMOLT_LOGGER_STAT_CFG_ID_CFG                                                           = 0,    /**< Configuration. */
    BCMOLT_LOGGER_STAT_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_stat_cfg_id;

/** Identifiers for all properties contained in the logger_stat group. 
 */
typedef enum bcmolt_logger_stat_id
{
    BCMOLT_LOGGER_STAT_ID__BEGIN                                                            = 0,
    BCMOLT_LOGGER_STAT_ID_LINES_IN_LOG                                                      = 0,    /**< lines in log. */
    BCMOLT_LOGGER_STAT_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_stat_id;

/** Identifiers for all properties contained in the nni_auto_cfg group. 
 */
typedef enum bcmolt_nni_auto_cfg_id
{
    BCMOLT_NNI_AUTO_CFG_ID__BEGIN                                                           = 0,
    BCMOLT_NNI_AUTO_CFG_ID_STAT_ALARM_CLEARED                                               = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_NNI_AUTO_CFG_ID_STAT_ALARM_RAISED                                                = 1,    /**< Stat Alarm Raised. */
    BCMOLT_NNI_AUTO_CFG_ID_STATUS_CHANGED                                                   = 2,    /**< Status changed. */
    BCMOLT_NNI_AUTO_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_auto_cfg_id;

/** Identifiers for all properties contained in the nni_cfg group. 
 */
typedef enum bcmolt_nni_cfg_id
{
    BCMOLT_NNI_CFG_ID__BEGIN                                                                = 0,
    BCMOLT_NNI_CFG_ID_REMOTE_LOOPBACK                                                       = 0,    /**< Remote loopback. */
    BCMOLT_NNI_CFG_ID_LINE_LOOPBACK                                                         = 1,    /**< Line loopback. */
    BCMOLT_NNI_CFG_ID_MAC_ADDRESS                                                           = 2,    /**< Mac Address. */
    BCMOLT_NNI_CFG_ID_NNI_STATUS                                                            = 3,    /**< NNI Status. */
    BCMOLT_NNI_CFG_ID_NNI_BACKUP_STATUS                                                     = 4,    /**< NNI Backup Status. */
    BCMOLT_NNI_CFG_ID_ACTIVE_NNI                                                            = 5,    /**< Active NNI. */
    BCMOLT_NNI_CFG_ID_NNI_STATUS_POLLING_INTERVAL_MS                                        = 6,    /**< NNI Status Polling Interval (ms). */
    BCMOLT_NNI_CFG_ID_AUTOSWITCH                                                            = 7,    /**< Auto-Switch. */
    BCMOLT_NNI_CFG_ID_FLOW_CONTROL                                                          = 8,    /**< Flow Control. */
    BCMOLT_NNI_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_cfg_id;

/** Identifiers for all properties contained in the nni_key group. 
 */
typedef enum bcmolt_nni_key_id
{
    BCMOLT_NNI_KEY_ID__BEGIN                                                                = 0,
    BCMOLT_NNI_KEY_ID_PON_NI                                                                = 0,    /**< PON NI. */
    BCMOLT_NNI_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_key_id;

/** Identifiers for all properties contained in the nni_serdes_cfg group. 
 */
typedef enum bcmolt_nni_serdes_cfg_id
{
    BCMOLT_NNI_SERDES_CFG_ID__BEGIN                                                         = 0,
    BCMOLT_NNI_SERDES_CFG_ID_RX_VGA                                                         = 0,    /**< Rx Vga. */
    BCMOLT_NNI_SERDES_CFG_ID_RX_PF                                                          = 1,    /**< Rx PF. */
    BCMOLT_NNI_SERDES_CFG_ID_RX_LFPF                                                        = 2,    /**< Rx LFPF. */
    BCMOLT_NNI_SERDES_CFG_ID_RX_DFE1                                                        = 3,    /**< Rx DFE1. */
    BCMOLT_NNI_SERDES_CFG_ID_RX_DFE2                                                        = 4,    /**< Rx DFE2. */
    BCMOLT_NNI_SERDES_CFG_ID_RX_DFE3                                                        = 5,    /**< Rx DFE3. */
    BCMOLT_NNI_SERDES_CFG_ID_RX_DFE4                                                        = 6,    /**< Rx DFE4. */
    BCMOLT_NNI_SERDES_CFG_ID_RX_DFE5                                                        = 7,    /**< Rx DFE5. */
    BCMOLT_NNI_SERDES_CFG_ID_TX_PRE                                                         = 8,    /**< Tx Pre. */
    BCMOLT_NNI_SERDES_CFG_ID_TX_MAIN                                                        = 9,    /**< Tx Main. */
    BCMOLT_NNI_SERDES_CFG_ID_TX_POST1                                                       = 10,   /**< Tx Post1. */
    BCMOLT_NNI_SERDES_CFG_ID_TX_POST2                                                       = 11,   /**< Tx Post2. */
    BCMOLT_NNI_SERDES_CFG_ID_TX_POST3                                                       = 12,   /**< Tx Post3. */
    BCMOLT_NNI_SERDES_CFG_ID_TX_AMP                                                         = 13,   /**< Tx Amp. */
    BCMOLT_NNI_SERDES_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_serdes_cfg_id;

/** Identifiers for all properties contained in the nni_serdes_key group. 
 */
typedef enum bcmolt_nni_serdes_key_id
{
    BCMOLT_NNI_SERDES_KEY_ID__BEGIN                                                         = 0,
    BCMOLT_NNI_SERDES_KEY_ID_PON_NI                                                         = 0,    /**< PON NI. */
    BCMOLT_NNI_SERDES_KEY_ID_INSTANCE                                                       = 1,    /**< Instance. */
    BCMOLT_NNI_SERDES_KEY_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_serdes_key_id;

/** Identifiers for all properties contained in the nni_stat_alarm_cleared 
 * group. 
 */
typedef enum bcmolt_nni_stat_alarm_cleared_id
{
    BCMOLT_NNI_STAT_ALARM_CLEARED_ID__BEGIN                                                 = 0,
    BCMOLT_NNI_STAT_ALARM_CLEARED_ID_STAT                                                   = 0,    /**< Statistic ID. */
    BCMOLT_NNI_STAT_ALARM_CLEARED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the nni_stat_alarm_raised group. 
 */
typedef enum bcmolt_nni_stat_alarm_raised_id
{
    BCMOLT_NNI_STAT_ALARM_RAISED_ID__BEGIN                                                  = 0,
    BCMOLT_NNI_STAT_ALARM_RAISED_ID_STAT                                                    = 0,    /**< Statistic ID. */
    BCMOLT_NNI_STAT_ALARM_RAISED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_stat_alarm_raised_id;

/** Identifiers for all properties contained in the nni_stat_cfg group. 
 */
typedef enum bcmolt_nni_stat_cfg_id
{
    BCMOLT_NNI_STAT_CFG_ID__BEGIN                                                           = 0,
    BCMOLT_NNI_STAT_CFG_ID_CFG                                                              = 0,    /**< Configuration. */
    BCMOLT_NNI_STAT_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_stat_cfg_id;

/** Identifiers for all properties contained in the nni_stat group. 
 */
typedef enum bcmolt_nni_stat_id
{
    BCMOLT_NNI_STAT_ID__BEGIN                                                               = 0,
    BCMOLT_NNI_STAT_ID_RX_FRAMES_64                                                         = 0,    /**< RX 64 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES_65_127                                                     = 1,    /**< RX 65-127 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES_128_255                                                    = 2,    /**< RX 128-255 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES_256_511                                                    = 3,    /**< RX 256-511 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES_512_1023                                                   = 4,    /**< RX 512-1023 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES_1024_1518                                                  = 5,    /**< RX 1024-1518 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES_1519_2047                                                  = 6,    /**< RX 1519-2047 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES_2048_4095                                                  = 7,    /**< RX 2048-4095 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES_4096_9216                                                  = 8,    /**< RX 4096-9216 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES_9217_16383                                                 = 9,    /**< RX 9217-16383 Byte Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAMES                                                            = 10,   /**< RX Frames. */
    BCMOLT_NNI_STAT_ID_RX_BYTES                                                             = 11,   /**< RX Bytes. */
    BCMOLT_NNI_STAT_ID_RX_GOOD_FRAMES                                                       = 12,   /**< RX Good Frames. */
    BCMOLT_NNI_STAT_ID_RX_UNICAST_FRAMES                                                    = 13,   /**< RX Unicast Frames. */
    BCMOLT_NNI_STAT_ID_RX_MULTICAST_FRAMES                                                  = 14,   /**< RX Multicast Frames. */
    BCMOLT_NNI_STAT_ID_RX_BROADCAST_FRAMES                                                  = 15,   /**< RX Broadcast Frames. */
    BCMOLT_NNI_STAT_ID_RX_FCS_ERRORS                                                        = 16,   /**< RX FCS Errors. */
    BCMOLT_NNI_STAT_ID_RX_CONTROL_FRAMES                                                    = 17,   /**< RX Control Frames. */
    BCMOLT_NNI_STAT_ID_RX_PAUSE_FRAMES                                                      = 18,   /**< RX Pause Frames. */
    BCMOLT_NNI_STAT_ID_RX_PFC_FRAMES                                                        = 19,   /**< RX PFC Frames. */
    BCMOLT_NNI_STAT_ID_RX_UNSUPPORTED_OPCODE                                                = 20,   /**< RX Unsupported Opcode Frames. */
    BCMOLT_NNI_STAT_ID_RX_UNSUPPORTED_DA                                                    = 21,   /**< RX Unsupported DA Frames. */
    BCMOLT_NNI_STAT_ID_RX_ALIGNMENT_ERRORS                                                  = 22,   /**< RX Alignment Errors. */
    BCMOLT_NNI_STAT_ID_RX_LENGTH_OUT_OF_RANGE                                               = 23,   /**< RX Length Out of Range. */
    BCMOLT_NNI_STAT_ID_RX_CODE_ERRORS                                                       = 24,   /**< RX Code Errors. */
    BCMOLT_NNI_STAT_ID_RX_OVERSIZED_FRAMES                                                  = 25,   /**< RX Oversized Frames. */
    BCMOLT_NNI_STAT_ID_RX_JABBER_FRAMES                                                     = 26,   /**< RX Jabber Frames. */
    BCMOLT_NNI_STAT_ID_RX_MTU_CHECK_ERRORS                                                  = 27,   /**< RX MTU Check Errors. */
    BCMOLT_NNI_STAT_ID_RX_PROMISCUOUS_FRAMES                                                = 28,   /**< RX Promiscuous Frames. */
    BCMOLT_NNI_STAT_ID_RX_VLAN_FRAMES                                                       = 29,   /**< RX VLAN Frames. */
    BCMOLT_NNI_STAT_ID_RX_DOUBLE_VLAN_FRAMES                                                = 30,   /**< RX Double VLAN Frames. */
    BCMOLT_NNI_STAT_ID_RX_TRUNCATED_FRAMES                                                  = 31,   /**< RX Truncated Frames. */
    BCMOLT_NNI_STAT_ID_RX_UNDERSIZE_FRAMES                                                  = 32,   /**< RX Undersized Frames. */
    BCMOLT_NNI_STAT_ID_RX_FRAGMENTED_FRAMES                                                 = 33,   /**< RX Fragmented Frames. */
    BCMOLT_NNI_STAT_ID_RX_RUNT_FRAMES                                                       = 34,   /**< RX Runt Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_64                                                         = 35,   /**< TX 64 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_65_127                                                     = 36,   /**< TX 65-127 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_128_255                                                    = 37,   /**< TX 128-255 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_256_511                                                    = 38,   /**< TX 256-511 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_512_1023                                                   = 39,   /**< TX 512-1023 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_1024_1518                                                  = 40,   /**< TX 1024-1518 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_1519_2047                                                  = 41,   /**< TX 1519-2047 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_2048_4095                                                  = 42,   /**< TX 2048-4095 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_4096_9216                                                  = 43,   /**< TX 4096-9216 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES_9217_16383                                                 = 44,   /**< TX 9217-16383 Byte Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAMES                                                            = 45,   /**< TX Frames. */
    BCMOLT_NNI_STAT_ID_TX_BYTES                                                             = 46,   /**< TX Bytes. */
    BCMOLT_NNI_STAT_ID_TX_GOOD_FRAMES                                                       = 47,   /**< TX Good Frames. */
    BCMOLT_NNI_STAT_ID_TX_UNICAST_FRAMES                                                    = 48,   /**< TX Unicast Frames. */
    BCMOLT_NNI_STAT_ID_TX_MULTICAST_FRAMES                                                  = 49,   /**< TX Multicast Frames. */
    BCMOLT_NNI_STAT_ID_TX_BROADCAST_FRAMES                                                  = 50,   /**< TX Broadcast Frames. */
    BCMOLT_NNI_STAT_ID_TX_PAUSE_FRAMES                                                      = 51,   /**< TX Pause Frames. */
    BCMOLT_NNI_STAT_ID_TX_PFC_FRAMES                                                        = 52,   /**< TX PFC Frames. */
    BCMOLT_NNI_STAT_ID_TX_JABBER_FRAMES                                                     = 53,   /**< TX Jabber Frames. */
    BCMOLT_NNI_STAT_ID_TX_FCS_ERRORS                                                        = 54,   /**< TX FCS Errors. */
    BCMOLT_NNI_STAT_ID_TX_CONTROL_FRAMES                                                    = 55,   /**< TX Control Frames. */
    BCMOLT_NNI_STAT_ID_TX_OVERSIZE_FRAMES                                                   = 56,   /**< TX Oversize Frames. */
    BCMOLT_NNI_STAT_ID_TX_FRAGMENTED_FRAMES                                                 = 57,   /**< TX Fragmented Frames. */
    BCMOLT_NNI_STAT_ID_TX_ERROR_FRAMES                                                      = 58,   /**< TX Error Frames. */
    BCMOLT_NNI_STAT_ID_TX_VLAN_FRAMES                                                       = 59,   /**< TX VLAN Frames. */
    BCMOLT_NNI_STAT_ID_TX_DOUBLE_VLAN_FRAMES                                                = 60,   /**< TX Double VLAN Frames. */
    BCMOLT_NNI_STAT_ID_TX_RUNT_FRAMES                                                       = 61,   /**< TX Runt Frames. */
    BCMOLT_NNI_STAT_ID_TX_UNDERRUN_FRAMES                                                   = 62,   /**< TX Underrun Frames. */
    BCMOLT_NNI_STAT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_stat_id;

/** Identifiers for all properties contained in the nni_status_changed group. 
 */
typedef enum bcmolt_nni_status_changed_id
{
    BCMOLT_NNI_STATUS_CHANGED_ID__BEGIN                                                     = 0,
    BCMOLT_NNI_STATUS_CHANGED_ID_NEW_STATUS                                                 = 0,    /**< New NNI Link Status. */
    BCMOLT_NNI_STATUS_CHANGED_ID_LINK                                                       = 1,    /**< Link. */
    BCMOLT_NNI_STATUS_CHANGED_ID_PREVIOUS_ACTIVE                                            = 2,    /**< Previous Active. */
    BCMOLT_NNI_STATUS_CHANGED_ID_NEW_ACTIVE                                                 = 3,    /**< New Active. */
    BCMOLT_NNI_STATUS_CHANGED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_status_changed_id;

/** Identifiers for all properties contained in the software_error_cfg group. 
 */
typedef enum bcmolt_software_error_cfg_id
{
    BCMOLT_SOFTWARE_ERROR_CFG_ID__BEGIN                                                     = 0,
    BCMOLT_SOFTWARE_ERROR_CFG_ID_ENTRY                                                      = 0,    /**< Entry. */
    BCMOLT_SOFTWARE_ERROR_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_software_error_cfg_id;

/** Identifiers for all properties contained in the software_error_key group. 
 */
typedef enum bcmolt_software_error_key_id
{
    BCMOLT_SOFTWARE_ERROR_KEY_ID__BEGIN                                                     = 0,
    BCMOLT_SOFTWARE_ERROR_KEY_ID_RESERVED                                                   = 0,    /**< Reserved. */
    BCMOLT_SOFTWARE_ERROR_KEY_ID_IDX                                                        = 1,    /**< Index. */
    BCMOLT_SOFTWARE_ERROR_KEY_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_software_error_key_id;

/** Identifiers for all properties contained in the trx_calibration_auto_cfg 
 * group. 
 */
typedef enum bcmolt_trx_calibration_auto_cfg_id
{
    BCMOLT_TRX_CALIBRATION_AUTO_CFG_ID__BEGIN                                               = 0,
    BCMOLT_TRX_CALIBRATION_AUTO_CFG_ID_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED               = 0,    /**< Capture window and statistic completed. */
    BCMOLT_TRX_CALIBRATION_AUTO_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_auto_cfg_id;

/** Identifiers for all properties contained in the 
 * trx_calibration_capture_window_and_statistic_completed group. 
 */
typedef enum bcmolt_trx_calibration_capture_window_and_statistic_completed_id
{
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID__BEGIN                 = 0,
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_DATA_WINDOW            = 0,    /**< data window. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_STROBE_WINDOW          = 1,    /**< strobe window. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_RISE_MIN_MIN      = 2,    /**< edge rise min min. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_RISE_MIN_MAX      = 3,    /**< edge rise min max. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_RISE_MAX_MIN      = 4,    /**< edge rise max min. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_RISE_MAX_MAX      = 5,    /**< edge rise max max. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_FALL_MIN_MIN      = 6,    /**< edge fall min min . */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_FALL_MIN_MAX      = 7,    /**< edge fall min max. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_FALL_MAX_MIN      = 8,    /**< edge fall max min. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_FALL_MAX_MAX      = 9,    /**< edge fall max max. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_RESULT                 = 10,   /**< result. */
    BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_capture_window_and_statistic_completed_id;

/** Identifiers for all properties contained in the trx_calibration_key group. 
 */
typedef enum bcmolt_trx_calibration_key_id
{
    BCMOLT_TRX_CALIBRATION_KEY_ID__BEGIN                                                    = 0,
    BCMOLT_TRX_CALIBRATION_KEY_ID_RESERVED                                                  = 0,    /**< Reserved. */
    BCMOLT_TRX_CALIBRATION_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_key_id;

/** Identifiers for all properties contained in the 
 * trx_calibration_start_capture_window group. 
 */
typedef enum bcmolt_trx_calibration_start_capture_window_id
{
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID__BEGIN                                   = 0,
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_PON_NI                                   = 0,    /**< pon_ni. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_TRIGGER                                  = 1,    /**< trigger. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_STROBE                                   = 2,    /**< strobe. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_WINDOW_MODE                              = 3,    /**< window mode. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_ONU_ID                                   = 4,    /**< onu id. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_TRIGGER_POSITION                         = 5,    /**< trigger position. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_STOP_DUE_TO_CORRUPT_STROBE               = 6,    /**< stop due to corrupt strobe. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_START_OFFSET                             = 7,    /**< start offset. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_END_OFFSET                               = 8,    /**< end offset. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_NUMBER_OF_CYCLES                         = 9,    /**< number of cycles. */
    BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_start_capture_window_id;

/** Identifiers for all properties contained in the 
 * trx_calibration_stop_capture_window group. 
 */
typedef enum bcmolt_trx_calibration_stop_capture_window_id
{
    BCMOLT_TRX_CALIBRATION_STOP_CAPTURE_WINDOW_ID__BEGIN                                    = 0,
    BCMOLT_TRX_CALIBRATION_STOP_CAPTURE_WINDOW_ID_PON_NI                                    = 0,    /**< pon_ni. */
    BCMOLT_TRX_CALIBRATION_STOP_CAPTURE_WINDOW_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_stop_capture_window_id;

/** Identifiers for all properties contained in the xgpon_alloc_auto_cfg group. 
 */
typedef enum bcmolt_xgpon_alloc_auto_cfg_id
{
    BCMOLT_XGPON_ALLOC_AUTO_CFG_ID__BEGIN                                                   = 0,
    BCMOLT_XGPON_ALLOC_AUTO_CFG_ID_CONFIGURATION_COMPLETED                                  = 0,    /**< Configuration Completed. */
    BCMOLT_XGPON_ALLOC_AUTO_CFG_ID_GET_ALLOC_STATS_COMPLETED                                = 1,    /**< Get alloc ID statistics completed. */
    BCMOLT_XGPON_ALLOC_AUTO_CFG_ID_STAT_ALARM_CLEARED                                       = 2,    /**< Stat Alarm Cleared. */
    BCMOLT_XGPON_ALLOC_AUTO_CFG_ID_STAT_ALARM_RAISED                                        = 3,    /**< Stat Alarm Raised. */
    BCMOLT_XGPON_ALLOC_AUTO_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_auto_cfg_id;

/** Identifiers for all properties contained in the xgpon_alloc_cfg group. 
 */
typedef enum bcmolt_xgpon_alloc_cfg_id
{
    BCMOLT_XGPON_ALLOC_CFG_ID__BEGIN                                                        = 0,
    BCMOLT_XGPON_ALLOC_CFG_ID_STATE                                                         = 0,    /**< state. */
    BCMOLT_XGPON_ALLOC_CFG_ID_SLA                                                           = 1,    /**< sla. */
    BCMOLT_XGPON_ALLOC_CFG_ID_ONU_ID                                                        = 2,    /**< onu_id. */
    BCMOLT_XGPON_ALLOC_CFG_ID_COLLECT_STATS                                                 = 3,    /**< Enable statistics collection on the alloc id. */
    BCMOLT_XGPON_ALLOC_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_cfg_id;

/** Identifiers for all properties contained in the 
 * xgpon_alloc_configuration_completed group. 
 */
typedef enum bcmolt_xgpon_alloc_configuration_completed_id
{
    BCMOLT_XGPON_ALLOC_CONFIGURATION_COMPLETED_ID__BEGIN                                    = 0,
    BCMOLT_XGPON_ALLOC_CONFIGURATION_COMPLETED_ID_STATUS                                    = 0,    /**< status. */
    BCMOLT_XGPON_ALLOC_CONFIGURATION_COMPLETED_ID_NEW_STATE                                 = 1,    /**< new state. */
    BCMOLT_XGPON_ALLOC_CONFIGURATION_COMPLETED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_configuration_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_alloc_get_alloc_stats_completed group. 
 */
typedef enum bcmolt_xgpon_alloc_get_alloc_stats_completed_id
{
    BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID__BEGIN                                  = 0,
    BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_STATUS                                  = 0,    /**< status. */
    BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_NSR_USED                        = 1,    /**< Average NSR used words. */
    BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_NSR_ALLOCATED                   = 2,    /**< Average NSR allocated words. */
    BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_SR_REPORT                       = 3,    /**< Average SR report. */
    BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_get_alloc_stats_completed_id;

/** Identifiers for all properties contained in the xgpon_alloc_get_stats group. 
 */
typedef enum bcmolt_xgpon_alloc_get_stats_id
{
    BCMOLT_XGPON_ALLOC_GET_STATS_ID__BEGIN                                                  = 0,
    BCMOLT_XGPON_ALLOC_GET_STATS_ID_NUM_OF_CYCLES                                           = 0,    /**< Number of cycles. */
    BCMOLT_XGPON_ALLOC_GET_STATS_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_get_stats_id;

/** Identifiers for all properties contained in the xgpon_alloc_key group. 
 */
typedef enum bcmolt_xgpon_alloc_key_id
{
    BCMOLT_XGPON_ALLOC_KEY_ID__BEGIN                                                        = 0,
    BCMOLT_XGPON_ALLOC_KEY_ID_PON_NI                                                        = 0,    /**< PON network interface. */
    BCMOLT_XGPON_ALLOC_KEY_ID_ALLOC_ID                                                      = 1,    /**< Alloc ID. */
    BCMOLT_XGPON_ALLOC_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_key_id;

/** Identifiers for all properties contained in the xgpon_alloc_set_state group. 
 */
typedef enum bcmolt_xgpon_alloc_set_state_id
{
    BCMOLT_XGPON_ALLOC_SET_STATE_ID__BEGIN                                                  = 0,
    BCMOLT_XGPON_ALLOC_SET_STATE_ID_STATE                                                   = 0,    /**< State. */
    BCMOLT_XGPON_ALLOC_SET_STATE_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_set_state_id;

/** Identifiers for all properties contained in the 
 * xgpon_alloc_stat_alarm_cleared group. 
 */
typedef enum bcmolt_xgpon_alloc_stat_alarm_cleared_id
{
    BCMOLT_XGPON_ALLOC_STAT_ALARM_CLEARED_ID__BEGIN                                         = 0,
    BCMOLT_XGPON_ALLOC_STAT_ALARM_CLEARED_ID_STAT                                           = 0,    /**< Statistic ID. */
    BCMOLT_XGPON_ALLOC_STAT_ALARM_CLEARED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the 
 * xgpon_alloc_stat_alarm_raised group. 
 */
typedef enum bcmolt_xgpon_alloc_stat_alarm_raised_id
{
    BCMOLT_XGPON_ALLOC_STAT_ALARM_RAISED_ID__BEGIN                                          = 0,
    BCMOLT_XGPON_ALLOC_STAT_ALARM_RAISED_ID_STAT                                            = 0,    /**< Statistic ID. */
    BCMOLT_XGPON_ALLOC_STAT_ALARM_RAISED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_stat_alarm_raised_id;

/** Identifiers for all properties contained in the xgpon_alloc_stat_cfg group. 
 */
typedef enum bcmolt_xgpon_alloc_stat_cfg_id
{
    BCMOLT_XGPON_ALLOC_STAT_CFG_ID__BEGIN                                                   = 0,
    BCMOLT_XGPON_ALLOC_STAT_CFG_ID_CFG                                                      = 0,    /**< Configuration. */
    BCMOLT_XGPON_ALLOC_STAT_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_stat_cfg_id;

/** Identifiers for all properties contained in the xgpon_alloc_stat group. 
 */
typedef enum bcmolt_xgpon_alloc_stat_id
{
    BCMOLT_XGPON_ALLOC_STAT_ID__BEGIN                                                       = 0,
    BCMOLT_XGPON_ALLOC_STAT_ID_RX_BYTES                                                     = 0,    /**< Received Bytes. */
    BCMOLT_XGPON_ALLOC_STAT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_stat_id;

/** Identifiers for all properties contained in the xgpon_gem_port_auto_cfg 
 * group. 
 */
typedef enum bcmolt_xgpon_gem_port_auto_cfg_id
{
    BCMOLT_XGPON_GEM_PORT_AUTO_CFG_ID__BEGIN                                                = 0,
    BCMOLT_XGPON_GEM_PORT_AUTO_CFG_ID_STAT_ALARM_CLEARED                                    = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_XGPON_GEM_PORT_AUTO_CFG_ID_STAT_ALARM_RAISED                                     = 1,    /**< Stat Alarm Raised. */
    BCMOLT_XGPON_GEM_PORT_AUTO_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_gem_port_auto_cfg_id;

/** Identifiers for all properties contained in the xgpon_gem_port_cfg group. 
 */
typedef enum bcmolt_xgpon_gem_port_cfg_id
{
    BCMOLT_XGPON_GEM_PORT_CFG_ID__BEGIN                                                     = 0,
    BCMOLT_XGPON_GEM_PORT_CFG_ID_CONFIGURATION                                              = 0,    /**< Configuration. */
    BCMOLT_XGPON_GEM_PORT_CFG_ID_ONU_ID                                                     = 1,    /**< ONU ID. */
    BCMOLT_XGPON_GEM_PORT_CFG_ID_GEM_PORT_STATE                                             = 2,    /**< gem port state. */
    BCMOLT_XGPON_GEM_PORT_CFG_ID_ENCRYPTION_MODE                                            = 3,    /**< Encryption mode. */
    BCMOLT_XGPON_GEM_PORT_CFG_ID_UPSTREAM_DESTINATION_QUEUE                                 = 4,    /**< Upstream destination queue. */
    BCMOLT_XGPON_GEM_PORT_CFG_ID_CONTROL                                                    = 5,    /**< control. */
    BCMOLT_XGPON_GEM_PORT_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_gem_port_cfg_id;

/** Identifiers for all properties contained in the xgpon_gem_port_key group. 
 */
typedef enum bcmolt_xgpon_gem_port_key_id
{
    BCMOLT_XGPON_GEM_PORT_KEY_ID__BEGIN                                                     = 0,
    BCMOLT_XGPON_GEM_PORT_KEY_ID_PON_NI                                                     = 0,    /**< PON network interface. */
    BCMOLT_XGPON_GEM_PORT_KEY_ID_GEM_PORT_ID                                                = 1,    /**< GEM PORT ID. */
    BCMOLT_XGPON_GEM_PORT_KEY_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_gem_port_key_id;

/** Identifiers for all properties contained in the 
 * xgpon_gem_port_stat_alarm_cleared group. 
 */
typedef enum bcmolt_xgpon_gem_port_stat_alarm_cleared_id
{
    BCMOLT_XGPON_GEM_PORT_STAT_ALARM_CLEARED_ID__BEGIN                                      = 0,
    BCMOLT_XGPON_GEM_PORT_STAT_ALARM_CLEARED_ID_STAT                                        = 0,    /**< Statistic ID. */
    BCMOLT_XGPON_GEM_PORT_STAT_ALARM_CLEARED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_gem_port_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the 
 * xgpon_gem_port_stat_alarm_raised group. 
 */
typedef enum bcmolt_xgpon_gem_port_stat_alarm_raised_id
{
    BCMOLT_XGPON_GEM_PORT_STAT_ALARM_RAISED_ID__BEGIN                                       = 0,
    BCMOLT_XGPON_GEM_PORT_STAT_ALARM_RAISED_ID_STAT                                         = 0,    /**< Statistic ID. */
    BCMOLT_XGPON_GEM_PORT_STAT_ALARM_RAISED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_gem_port_stat_alarm_raised_id;

/** Identifiers for all properties contained in the xgpon_gem_port_stat_cfg 
 * group. 
 */
typedef enum bcmolt_xgpon_gem_port_stat_cfg_id
{
    BCMOLT_XGPON_GEM_PORT_STAT_CFG_ID__BEGIN                                                = 0,
    BCMOLT_XGPON_GEM_PORT_STAT_CFG_ID_CFG                                                   = 0,    /**< Configuration. */
    BCMOLT_XGPON_GEM_PORT_STAT_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_gem_port_stat_cfg_id;

/** Identifiers for all properties contained in the xgpon_gem_port_stat group. 
 */
typedef enum bcmolt_xgpon_gem_port_stat_id
{
    BCMOLT_XGPON_GEM_PORT_STAT_ID__BEGIN                                                    = 0,
    BCMOLT_XGPON_GEM_PORT_STAT_ID_TX_BYTES                                                  = 0,    /**< TX bytes. */
    BCMOLT_XGPON_GEM_PORT_STAT_ID_TX_PACKETS                                                = 1,    /**< TX packets. */
    BCMOLT_XGPON_GEM_PORT_STAT_ID_RX_PACKETS                                                = 2,    /**< RX packets. */
    BCMOLT_XGPON_GEM_PORT_STAT_ID_RX_BYTES                                                  = 3,    /**< RX bytes. */
    BCMOLT_XGPON_GEM_PORT_STAT_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_gem_port_stat_id;

/** Identifiers for all properties contained in the xgpon_iwf_cfg group. 
 */
typedef enum bcmolt_xgpon_iwf_cfg_id
{
    BCMOLT_XGPON_IWF_CFG_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_IWF_CFG_ID_US_OTAG_DIRECT_TPID                                             = 0,    /**< US otag direct tpid. */
    BCMOLT_XGPON_IWF_CFG_ID_DS_TPID                                                         = 1,    /**< DS tpid. */
    BCMOLT_XGPON_IWF_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_iwf_cfg_id;

/** Identifiers for all properties contained in the xgpon_iwf_key group. 
 */
typedef enum bcmolt_xgpon_iwf_key_id
{
    BCMOLT_XGPON_IWF_KEY_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_IWF_KEY_ID_PON_NI                                                          = 0,    /**< PON network interface. */
    BCMOLT_XGPON_IWF_KEY_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_iwf_key_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_activate_all_onus_completed group. 
 */
typedef enum bcmolt_xgpon_ni_activate_all_onus_completed_id
{
    BCMOLT_XGPON_NI_ACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_activate_all_onus_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_adjust_tx_wavelength group. 
 */
typedef enum bcmolt_xgpon_ni_adjust_tx_wavelength_id
{
    BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID__BEGIN                                          = 0,
    BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID_SERIAL_NUMBER                                   = 0,    /**< Seril number. */
    BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID_FREQENCY_ADJUSTMENT_DIRECTION                   = 1,    /**< Frequncy adjustment direction. */
    BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID_FREQUENCY_ADJUSTMENT_SIZE                       = 2,    /**< Frequency adjustment size. */
    BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_adjust_tx_wavelength_id;

/** Identifiers for all properties contained in the xgpon_ni_auto_cfg group. 
 */
typedef enum bcmolt_xgpon_ni_auto_cfg_id
{
    BCMOLT_XGPON_NI_AUTO_CFG_ID__BEGIN                                                      = 0,
    BCMOLT_XGPON_NI_AUTO_CFG_ID_ACTIVATE_ALL_ONUS_COMPLETED                                 = 0,    /**< activate all onus completed. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_CPU_PACKETS_FAILURE                                         = 1,    /**< CPU Packets Failure. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_DEACTIVATE_ALL_ONUS_COMPLETED                               = 2,    /**< deactivate all onus completed. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_DISABLE_ALL_ONUS_COMPLETED                                  = 3,    /**< disable all onus completed. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_ENABLE_ALL_ONUS_COMPLETED                                   = 4,    /**< enable all onus completed. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_LOS                                                         = 5,    /**< LOS. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_ONU_DISCOVERED                                              = 6,    /**< ONU Discovered. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_ONU_UPGRADE_COMPLETE                                        = 7,    /**< ONU Upgrade Complete. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_ONUS_RANGED                            = 8,    /**< Protection Switching ONUs Ranged. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED                   = 9,    /**< Protection Switching Switchover Completed. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_TRAFFIC_RESUME                         = 10,   /**< Protection Switching Traffic Resume. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_ROGUE_DETECTION_COMPLETED                                   = 11,   /**< Rogue detection completed. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_ROGUE_ONU_SPECIAL_MAP_CYCLE_START                           = 12,   /**< Rogue ONU special map cycle start. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_SERIAL_NUMBER_ACQUISITION_CYCLE_START                       = 13,   /**< Serial Number Acquisition Cycle Start. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_STANDBY_PON_MONITORING_CYCLE_COMPLETED                      = 14,   /**< Standby PON Monitoring Cycle Completed. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_STAT_ALARM_CLEARED                                          = 15,   /**< Stat Alarm Cleared. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_STAT_ALARM_RAISED                                           = 16,   /**< Stat Alarm Raised. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_STATE_CHANGE_COMPLETED                                      = 17,   /**< State Change Completed. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID_TOD_REQUEST_COMPLETED                                       = 18,   /**< TOD request completed. */
    BCMOLT_XGPON_NI_AUTO_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_auto_cfg_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_broadcast_ploam_packet group. 
 */
typedef enum bcmolt_xgpon_ni_broadcast_ploam_packet_id
{
    BCMOLT_XGPON_NI_BROADCAST_PLOAM_PACKET_ID__BEGIN                                        = 0,
    BCMOLT_XGPON_NI_BROADCAST_PLOAM_PACKET_ID_PLOAM                                         = 0,    /**< ploam. */
    BCMOLT_XGPON_NI_BROADCAST_PLOAM_PACKET_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_broadcast_ploam_packet_id;

/** Identifiers for all properties contained in the xgpon_ni_cfg group. 
 */
typedef enum bcmolt_xgpon_ni_cfg_id
{
    BCMOLT_XGPON_NI_CFG_ID__BEGIN                                                           = 0,
    BCMOLT_XGPON_NI_CFG_ID_HW_PON_ID                                                        = 0,    /**< HW pon id. */
    BCMOLT_XGPON_NI_CFG_ID_AVAILABLE_BANDWIDTH                                              = 1,    /**< Available Bandwidth. */
    BCMOLT_XGPON_NI_CFG_ID_NUMBER_OF_ACTIVE_ONUS                                            = 2,    /**< number of active onus. */
    BCMOLT_XGPON_NI_CFG_ID_PON_STATUS                                                       = 3,    /**< PON status. */
    BCMOLT_XGPON_NI_CFG_ID_PON_DISTANCE                                                     = 4,    /**< PON distance. */
    BCMOLT_XGPON_NI_CFG_ID_RANGING_WINDOW_SIZE                                              = 5,    /**< Ranging window size. */
    BCMOLT_XGPON_NI_CFG_ID_EQD_CYCLES_NUMBER                                                = 6,    /**< EqD measurement cycles number. */
    BCMOLT_XGPON_NI_CFG_ID_DRIFT_CONTROL                                                    = 7,    /**< drift control. */
    BCMOLT_XGPON_NI_CFG_ID_LOS_ALARM_THRESHOLD                                              = 8,    /**< los alarm threshold. */
    BCMOLT_XGPON_NI_CFG_ID_LOS_INITIAL_VALUE                                                = 9,    /**< los initialization value. */
    BCMOLT_XGPON_NI_CFG_ID_ONU_ALARMS_THRESHOLDS                                            = 10,   /**< ONU alarms thresholds. */
    BCMOLT_XGPON_NI_CFG_ID_BER_MONITOR                                                      = 11,   /**< BER monitoring params. */
    BCMOLT_XGPON_NI_CFG_ID_ONU_ACTIVATION                                                   = 12,   /**< ONU Activation. */
    BCMOLT_XGPON_NI_CFG_ID_SN_ACQUISITION                                                   = 13,   /**< sn acquisition. */
    BCMOLT_XGPON_NI_CFG_ID_KEY_EXCHANGE                                                     = 14,   /**< key exchange. */
    BCMOLT_XGPON_NI_CFG_ID_PROTECTION_SWITCHING                                             = 15,   /**< Protection switching. */
    BCMOLT_XGPON_NI_CFG_ID_PROTECTION_SWITCHING_DEBUG                                       = 16,   /**< protection switching debug . */
    BCMOLT_XGPON_NI_CFG_ID_CBR_RT_ALLOCATION_PROFILE                                        = 17,   /**< CBR RT Allocation profile. */
    BCMOLT_XGPON_NI_CFG_ID_CBR_NRT_ALLOCATION_PROFILE                                       = 18,   /**< CBR NRT Allocation Profile. */
    BCMOLT_XGPON_NI_CFG_ID_POWER_MANAGEMENT                                                 = 19,   /**< Power Management. */
    BCMOLT_XGPON_NI_CFG_ID_ROGUE_ONU_DETECTION_PROCESS                                      = 20,   /**< Rogue ONU detection process. */
    BCMOLT_XGPON_NI_CFG_ID_PERIODIC_STANDBY_PON_MONITORING                                  = 21,   /**< Periodic standby PON monitoring. */
    BCMOLT_XGPON_NI_CFG_ID_DBA_MODE                                                         = 22,   /**< DBA mode. */
    BCMOLT_XGPON_NI_CFG_ID_PLOAM_HANDLING                                                   = 23,   /**< Ploam handling. */
    BCMOLT_XGPON_NI_CFG_ID_MIN_DATA_ALLOC_ID                                                = 24,   /**< Minimum data alloc id. */
    BCMOLT_XGPON_NI_CFG_ID_MIN_DATA_GEM_PORT_ID                                             = 25,   /**< Minimum data port id. */
    BCMOLT_XGPON_NI_CFG_ID_MULTICAST_KEY                                                    = 26,   /**< multicast key. */
    BCMOLT_XGPON_NI_CFG_ID_PRBS_CHECKER                                                     = 27,   /**< PRBS Checker. */
    BCMOLT_XGPON_NI_CFG_ID_PRBS_GENERATOR                                                   = 28,   /**< PRBS Generator. */
    BCMOLT_XGPON_NI_CFG_ID_PRBS_STATUS                                                      = 29,   /**< PRBS status. */
    BCMOLT_XGPON_NI_CFG_ID_AUTOMATIC_ONU_DEACTIVATION                                       = 30,   /**< Automatic ONU deactivation. */
    BCMOLT_XGPON_NI_CFG_ID_US_BANDWIDTH_LIMIT                                               = 31,   /**< US bandwidth Limit. */
    BCMOLT_XGPON_NI_CFG_ID_ALL_ONUS                                                         = 32,   /**< all ONUs. */
    BCMOLT_XGPON_NI_CFG_ID_ALL_MCAST_GEM_PORTS                                              = 33,   /**< all multicast GEM ports. */
    BCMOLT_XGPON_NI_CFG_ID_DEBUG                                                            = 34,   /**< PON NI debug parameters. */
    BCMOLT_XGPON_NI_CFG_ID_ONU_UPGRADE_PARAMS                                               = 35,   /**< ONU upgrade params. */
    BCMOLT_XGPON_NI_CFG_ID_DS_FEC_MODE                                                      = 36,   /**< DS FEC mode. */
    BCMOLT_XGPON_NI_CFG_ID_DBA_TYPE                                                         = 37,   /**< DBA type. */
    BCMOLT_XGPON_NI_CFG_ID_ONU_TUNING                                                       = 38,   /**< onu tuning. */
    BCMOLT_XGPON_NI_CFG_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_cfg_id;

/** Identifiers for all properties contained in the xgpon_ni_cpu_packets_failure 
 * group. 
 */
typedef enum bcmolt_xgpon_ni_cpu_packets_failure_id
{
    BCMOLT_XGPON_NI_CPU_PACKETS_FAILURE_ID__BEGIN                                           = 0,
    BCMOLT_XGPON_NI_CPU_PACKETS_FAILURE_ID_ERROR                                            = 0,    /**< Error. */
    BCMOLT_XGPON_NI_CPU_PACKETS_FAILURE_ID_GEM_PORT_ID                                      = 1,    /**< GEM Port ID. */
    BCMOLT_XGPON_NI_CPU_PACKETS_FAILURE_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_cpu_packets_failure_id;

/** Identifiers for all properties contained in the xgpon_ni_cpu_packets group. 
 */
typedef enum bcmolt_xgpon_ni_cpu_packets_id
{
    BCMOLT_XGPON_NI_CPU_PACKETS_ID__BEGIN                                                   = 0,
    BCMOLT_XGPON_NI_CPU_PACKETS_ID_PACKET_TYPE                                              = 0,    /**< packet type. */
    BCMOLT_XGPON_NI_CPU_PACKETS_ID_CALC_CRC                                                 = 1,    /**< calc crc. */
    BCMOLT_XGPON_NI_CPU_PACKETS_ID_GEM_PORT_LIST                                            = 2,    /**< gem port list. */
    BCMOLT_XGPON_NI_CPU_PACKETS_ID_BUFFER                                                   = 3,    /**< buffer. */
    BCMOLT_XGPON_NI_CPU_PACKETS_ID__NUM_OF                      /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_cpu_packets_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_deactivate_all_onus_completed group. 
 */
typedef enum bcmolt_xgpon_ni_deactivate_all_onus_completed_id
{
    BCMOLT_XGPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_deactivate_all_onus_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_disable_all_onus_completed group. 
 */
typedef enum bcmolt_xgpon_ni_disable_all_onus_completed_id
{
    BCMOLT_XGPON_NI_DISABLE_ALL_ONUS_COMPLETED_ID__NUM_OF       /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_disable_all_onus_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_disable_serial_number group. 
 */
typedef enum bcmolt_xgpon_ni_disable_serial_number_id
{
    BCMOLT_XGPON_NI_DISABLE_SERIAL_NUMBER_ID__BEGIN                                         = 0,
    BCMOLT_XGPON_NI_DISABLE_SERIAL_NUMBER_ID_CONTROL                                        = 0,    /**< control. */
    BCMOLT_XGPON_NI_DISABLE_SERIAL_NUMBER_ID_SERIAL_NUMBER                                  = 1,    /**< serial number. */
    BCMOLT_XGPON_NI_DISABLE_SERIAL_NUMBER_ID__NUM_OF        /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_disable_serial_number_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_enable_all_onus_completed group. 
 */
typedef enum bcmolt_xgpon_ni_enable_all_onus_completed_id
{
    BCMOLT_XGPON_NI_ENABLE_ALL_ONUS_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_enable_all_onus_completed_id;

/** Identifiers for all properties contained in the xgpon_ni_key group. 
 */
typedef enum bcmolt_xgpon_ni_key_id
{
    BCMOLT_XGPON_NI_KEY_ID__BEGIN                                                           = 0,
    BCMOLT_XGPON_NI_KEY_ID_PON_NI                                                           = 0,    /**< PON network interface. */
    BCMOLT_XGPON_NI_KEY_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_key_id;

/** Identifiers for all properties contained in the xgpon_ni_los group. 
 */
typedef enum bcmolt_xgpon_ni_los_id
{
    BCMOLT_XGPON_NI_LOS_ID__BEGIN                                                           = 0,
    BCMOLT_XGPON_NI_LOS_ID_STATUS                                                           = 0,    /**< status. */
    BCMOLT_XGPON_NI_LOS_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_los_id;

/** Identifiers for all properties contained in the xgpon_ni_onu_discovered 
 * group. 
 */
typedef enum bcmolt_xgpon_ni_onu_discovered_id
{
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID__BEGIN                                                = 0,
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_SERIAL_NUMBER                                         = 0,    /**< serial number. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_RANGING_TIME                                          = 1,    /**< ranging time. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_ONU_ID                                                = 2,    /**< onu_id. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_UPSTREAM_LINE_RATE_CAPABILITIES                       = 3,    /**< upstream line rate capabilities. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_CURRENT_DOWNSTREAM_PON_ID                             = 4,    /**< current downstream pon id. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_CURRENT_UPSTREAM_PON_ID                               = 5,    /**< current upstream pon id. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_CALIBRATION_RECORD                                    = 6,    /**< calibration record. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_TUNING_GRANULARITY                                    = 7,    /**< tuning granularity. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_STEP_TUNING_TIME                                      = 8,    /**< step tuning time. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_ATTENUATION                                           = 9,    /**< attenuetion. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_POWER_LEVELLING_CAPABILITIES                          = 10,   /**< power levelling capabilities. */
    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_onu_discovered_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_onu_upgrade_complete group. 
 */
typedef enum bcmolt_xgpon_ni_onu_upgrade_complete_id
{
    BCMOLT_XGPON_NI_ONU_UPGRADE_COMPLETE_ID__BEGIN                                          = 0,
    BCMOLT_XGPON_NI_ONU_UPGRADE_COMPLETE_ID_STATUS                                          = 0,    /**< Status. */
    BCMOLT_XGPON_NI_ONU_UPGRADE_COMPLETE_ID_LIST_OF_FAILED_ENTITIES                         = 1,    /**< List of failed entities. */
    BCMOLT_XGPON_NI_ONU_UPGRADE_COMPLETE_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_onu_upgrade_complete_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_protection_switching_onus_ranged group. 
 */
typedef enum bcmolt_xgpon_ni_protection_switching_onus_ranged_id
{
    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID__BEGIN                              = 0,
    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID_ONUS                                = 0,    /**< ONUs. */
    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_protection_switching_onus_ranged_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_protection_switching_switchover_completed group. 
 */
typedef enum bcmolt_xgpon_ni_protection_switching_switchover_completed_id
{
    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID__BEGIN                     = 0,
    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID_RESULT                     = 0,    /**< Result. */
    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_protection_switching_switchover_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_protection_switching_traffic_resume group. 
 */
typedef enum bcmolt_xgpon_ni_protection_switching_traffic_resume_id
{
    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID__BEGIN                           = 0,
    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID_RESULT                           = 0,    /**< Result. */
    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_protection_switching_traffic_resume_id;

/** Identifiers for all properties contained in the xgpon_ni_reset group. 
 */
typedef enum bcmolt_xgpon_ni_reset_id
{
    BCMOLT_XGPON_NI_RESET_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_reset_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_rogue_detection_completed group. 
 */
typedef enum bcmolt_xgpon_ni_rogue_detection_completed_id
{
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID__BEGIN                                     = 0,
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_WINDOW_TYPE                                = 0,    /**< Window type. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_MEASUREMENT_STATUS                         = 1,    /**< Measurement status. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_ALLOC_ID                                   = 2,    /**< Alloc ID. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_ONU_ID                                     = 3,    /**< ONU ID. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_IS_DELINEATION                             = 4,    /**< Is delineation. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_IS_ED                                      = 5,    /**< Is ED. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_RX_DATA                                    = 6,    /**< Received data. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_PLOAM_RECEIVED_ONU_ID                      = 7,    /**< ploam_received_onu_id. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_PLOAM_RECEIVED_MIC_ERROR                   = 8,    /**< ploam_received_mic_error. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_rogue_detection_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_rogue_detection_window group. 
 */
typedef enum bcmolt_xgpon_ni_rogue_detection_window_id
{
    BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID__BEGIN                                        = 0,
    BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID_WINDOW_TYPE                                   = 0,    /**< Window type. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID_ALLOC_ID                                      = 1,    /**< Alloc ID. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID_ONU_ID                                        = 2,    /**< ONU ID. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID_SECOND_RANGING_WINDOW                         = 3,    /**< Second ranging window. */
    BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID__NUM_OF               /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_rogue_detection_window_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_rogue_onu_special_map_cycle_start group. 
 */
typedef enum bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id
{
    BCMOLT_XGPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id;

/** Identifiers for all properties contained in the xgpon_ni_run_special_bw_map 
 * group. 
 */
typedef enum bcmolt_xgpon_ni_run_special_bw_map_id
{
    BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID__BEGIN                                            = 0,
    BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID_NUMBER_OF_CYCLE                                   = 0,    /**< number of cycle. */
    BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID_ALLOCATION_NUMBER                                 = 1,    /**< allocation number. */
    BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID_BW_MAP_ARRAY                                      = 2,    /**< bw map array. */
    BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID__NUM_OF                       /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_run_special_bw_map_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_serial_number_acquisition_cycle_start group. 
 */
typedef enum bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id
{
    BCMOLT_XGPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id;

/** Identifiers for all properties contained in the xgpon_ni_set_onu_state 
 * group. 
 */
typedef enum bcmolt_xgpon_ni_set_onu_state_id
{
    BCMOLT_XGPON_NI_SET_ONU_STATE_ID__BEGIN                                                 = 0,
    BCMOLT_XGPON_NI_SET_ONU_STATE_ID_ONU_STATE                                              = 0,    /**< ONU state. */
    BCMOLT_XGPON_NI_SET_ONU_STATE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_set_onu_state_id;

/** Identifiers for all properties contained in the xgpon_ni_set_pon_state 
 * group. 
 */
typedef enum bcmolt_xgpon_ni_set_pon_state_id
{
    BCMOLT_XGPON_NI_SET_PON_STATE_ID__BEGIN                                                 = 0,
    BCMOLT_XGPON_NI_SET_PON_STATE_ID_PON_STATE                                              = 0,    /**< PON state. */
    BCMOLT_XGPON_NI_SET_PON_STATE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_set_pon_state_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_single_request_standby_pon_monitoring group. 
 */
typedef enum bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id
{
    BCMOLT_XGPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_standby_pon_monitoring_cycle_completed group. 
 */
typedef enum bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id
{
    BCMOLT_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID__BEGIN                        = 0,
    BCMOLT_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID_NUMBER_OF_DETECTED_DELIMITER  = 0,    /**< number of detected delimiter. */
    BCMOLT_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID_ENERGY_DETECT_SIGNAL          = 1,    /**< energy detect signal. */
    BCMOLT_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id;

/** Identifiers for all properties contained in the xgpon_ni_start_onu_upgrade 
 * group. 
 */
typedef enum bcmolt_xgpon_ni_start_onu_upgrade_id
{
    BCMOLT_XGPON_NI_START_ONU_UPGRADE_ID__BEGIN                                             = 0,
    BCMOLT_XGPON_NI_START_ONU_UPGRADE_ID_LIST_OF_ONU_IDS                                    = 0,    /**< List of ONU IDs. */
    BCMOLT_XGPON_NI_START_ONU_UPGRADE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_start_onu_upgrade_id;

/** Identifiers for all properties contained in the xgpon_ni_stat_alarm_cleared 
 * group. 
 */
typedef enum bcmolt_xgpon_ni_stat_alarm_cleared_id
{
    BCMOLT_XGPON_NI_STAT_ALARM_CLEARED_ID__BEGIN                                            = 0,
    BCMOLT_XGPON_NI_STAT_ALARM_CLEARED_ID_STAT                                              = 0,    /**< Statistic ID. */
    BCMOLT_XGPON_NI_STAT_ALARM_CLEARED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the xgpon_ni_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_xgpon_ni_stat_alarm_raised_id
{
    BCMOLT_XGPON_NI_STAT_ALARM_RAISED_ID__BEGIN                                             = 0,
    BCMOLT_XGPON_NI_STAT_ALARM_RAISED_ID_STAT                                               = 0,    /**< Statistic ID. */
    BCMOLT_XGPON_NI_STAT_ALARM_RAISED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_stat_alarm_raised_id;

/** Identifiers for all properties contained in the xgpon_ni_stat_cfg group. 
 */
typedef enum bcmolt_xgpon_ni_stat_cfg_id
{
    BCMOLT_XGPON_NI_STAT_CFG_ID__BEGIN                                                      = 0,
    BCMOLT_XGPON_NI_STAT_CFG_ID_CFG                                                         = 0,    /**< Configuration. */
    BCMOLT_XGPON_NI_STAT_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_stat_cfg_id;

/** Identifiers for all properties contained in the xgpon_ni_stat group. 
 */
typedef enum bcmolt_xgpon_ni_stat_id
{
    BCMOLT_XGPON_NI_STAT_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_NI_STAT_ID_FEC_CODEWORDS                                                   = 0,    /**< Receive FEC codewords. */
    BCMOLT_XGPON_NI_STAT_ID_BIP32_BYTES                                                     = 1,    /**< Received bytes protected by bip32. */
    BCMOLT_XGPON_NI_STAT_ID_BIP32_ERRORS                                                    = 2,    /**< Received bip32 errors. */
    BCMOLT_XGPON_NI_STAT_ID_RX_XGTC_HEADERS                                                 = 3,    /**< Received valid XGTC headers. */
    BCMOLT_XGPON_NI_STAT_ID_RX_XGTC_CORRECTED                                               = 4,    /**< Received corrected XGTC headers. */
    BCMOLT_XGPON_NI_STAT_ID_RX_XGTC_UNCORRECTED                                             = 5,    /**< Received uncorrected XGTC headers. */
    BCMOLT_XGPON_NI_STAT_ID_RX_XGEM                                                         = 6,    /**< Received valid XGEM frames. */
    BCMOLT_XGPON_NI_STAT_ID_RX_XGEM_DROPPED                                                 = 7,    /**< Received dropped XGEM ID frames. */
    BCMOLT_XGPON_NI_STAT_ID_RX_XGEM_IDLE                                                    = 8,    /**< Received idle XGEM frames. */
    BCMOLT_XGPON_NI_STAT_ID_RX_XGEM_CORRECTED                                               = 9,    /**< Received corrected XGEM frames. */
    BCMOLT_XGPON_NI_STAT_ID_RX_CRC_ERROR                                                    = 10,   /**< Received packets with CRC error. */
    BCMOLT_XGPON_NI_STAT_ID_RX_FRAGMENT_ERROR                                               = 11,   /**< Received fragment errors. */
    BCMOLT_XGPON_NI_STAT_ID_RX_PACKETS_DROPPED                                              = 12,   /**< Global dropped packets. */
    BCMOLT_XGPON_NI_STAT_ID_RX_DROPPED_TOO_SHORT                                            = 13,   /**< Received packets dropped due to length too short. */
    BCMOLT_XGPON_NI_STAT_ID_RX_DROPPED_TOO_LONG                                             = 14,   /**< Received packet dropped due to length too long. */
    BCMOLT_XGPON_NI_STAT_ID_RX_KEY_ERROR                                                    = 15,   /**< Received key errors. */
    BCMOLT_XGPON_NI_STAT_ID_TX_PLOAMS                                                       = 16,   /**< Transmitted Ploams. */
    BCMOLT_XGPON_NI_STAT_ID_RX_PLOAMS_DROPPED                                               = 17,   /**< Received dropped Ploams. */
    BCMOLT_XGPON_NI_STAT_ID_RX_ALLOCATIONS_VALID                                            = 18,   /**< Received valid allocations. */
    BCMOLT_XGPON_NI_STAT_ID_RX_ALLOCATIONS_INVALID                                          = 19,   /**< Received invalid allocations. */
    BCMOLT_XGPON_NI_STAT_ID_RX_ALLOCATIONS_DISABLED                                         = 20,   /**< Received disabled allocations. */
    BCMOLT_XGPON_NI_STAT_ID_RX_PLOAMS                                                       = 21,   /**< Received Ploams. */
    BCMOLT_XGPON_NI_STAT_ID_RX_PLOAMS_NON_IDLE                                              = 22,   /**< Received non idle Ploams. */
    BCMOLT_XGPON_NI_STAT_ID_RX_PLOAMS_ERROR                                                 = 23,   /**< Received error Ploams. */
    BCMOLT_XGPON_NI_STAT_ID_RX_CPU                                                          = 24,   /**< Received CPU packets. */
    BCMOLT_XGPON_NI_STAT_ID_RX_OMCI                                                         = 25,   /**< Received OMCI packets. */
    BCMOLT_XGPON_NI_STAT_ID_RX_OMCI_PACKETS_CRC_ERROR                                       = 26,   /**< Received OMCI packets with CRC errors. */
    BCMOLT_XGPON_NI_STAT_ID_TX_PACKETS                                                      = 27,   /**< Transmitted packets. */
    BCMOLT_XGPON_NI_STAT_ID_TX_XGEM                                                         = 28,   /**< Transmitted XGEM fragments. */
    BCMOLT_XGPON_NI_STAT_ID_TX_CPU                                                          = 29,   /**< Transmitted CPU packets. */
    BCMOLT_XGPON_NI_STAT_ID_TX_OMCI                                                         = 30,   /**< Transmitted OMCI packets. */
    BCMOLT_XGPON_NI_STAT_ID_TX_CPU_OMCI_PACKETS_DROPPED                                     = 31,   /**< Transmit packets dropped due to illegal length. */
    BCMOLT_XGPON_NI_STAT_ID_TX_DROPPED_ILLEGAL_LENGTH                                       = 32,   /**< Transmit packets dropped due to illegal length. */
    BCMOLT_XGPON_NI_STAT_ID_TX_DROPPED_TPID_MISS                                            = 33,   /**< Transmit packets dropped due to TPID miss. */
    BCMOLT_XGPON_NI_STAT_ID_TX_DROPPED_VID_MISS                                             = 34,   /**< Transmit packets droped due to VID miss. */
    BCMOLT_XGPON_NI_STAT_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_stat_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_state_change_completed group. 
 */
typedef enum bcmolt_xgpon_ni_state_change_completed_id
{
    BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID__BEGIN                                        = 0,
    BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID_RESULT                                        = 0,    /**< Result. */
    BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID_PREVIOUS_STATE                                = 1,    /**< Previous state. */
    BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID_NEW_STATE                                     = 2,    /**< new state. */
    BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_state_change_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_ni_tod_request_completed group. 
 */
typedef enum bcmolt_xgpon_ni_tod_request_completed_id
{
    BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID__BEGIN                                         = 0,
    BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_TOD_STRING                                     = 0,    /**< tod_string. */
    BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_SFC                                            = 1,    /**< sfc. */
    BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_RTC_OFFSET_SEC                                 = 2,    /**< rtc_offset_sec. */
    BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_RTC_OFFSET_NSEC                                = 3,    /**< rtc_offset_nsec. */
    BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_STATUS                                         = 4,    /**< status. */
    BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_tod_request_completed_id;

/** Identifiers for all properties contained in the xgpon_ni_tod_request group. 
 */
typedef enum bcmolt_xgpon_ni_tod_request_id
{
    BCMOLT_XGPON_NI_TOD_REQUEST_ID__NUM_OF              /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_tod_request_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_adjust_tx_wavelength group. 
 */
typedef enum bcmolt_xgpon_onu_adjust_tx_wavelength_id
{
    BCMOLT_XGPON_ONU_ADJUST_TX_WAVELENGTH_ID__BEGIN                                         = 0,
    BCMOLT_XGPON_ONU_ADJUST_TX_WAVELENGTH_ID_FREQUENCY_ADJUSTMENT_DIRECTION                 = 0,    /**< Frequency adjustment direction. */
    BCMOLT_XGPON_ONU_ADJUST_TX_WAVELENGTH_ID_FREQUENCY_ADJUSTMENT_SIZE                      = 1,    /**< Frequency adjustment size. */
    BCMOLT_XGPON_ONU_ADJUST_TX_WAVELENGTH_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_adjust_tx_wavelength_id;

/** Identifiers for all properties contained in the xgpon_onu_auto_cfg group. 
 */
typedef enum bcmolt_xgpon_onu_auto_cfg_id
{
    BCMOLT_XGPON_ONU_AUTO_CFG_ID__BEGIN                                                     = 0,
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_DFI                                                        = 0,    /**< Receive Dying-Gasp of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_DGI                                                        = 1,    /**< Receive Dying-Gasp of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_DOWI                                                       = 2,    /**< Drift of Window of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_INVALID_DBRU_REPORT                                        = 3,    /**< Invalid DBRu Report. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_COMPLETED                                     = 4,    /**< Key Exchange Completed. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_CYCLE_SKIPPED                                 = 5,    /**< Key Exchange Cycle Skipped. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_KEY_MISMATCH                                  = 6,    /**< Key Exchange Key Mismatch. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT                           = 7,    /**< Key Exchange Key Request Timeout. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_LOOCI                                                      = 8,    /**< LOOCi. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_ACTIVATION_COMPLETED                                   = 9,    /**< ONU Activation Completed. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_ALARM                                                  = 10,   /**< ONU Alarm. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_DEACTIVATION_COMPLETED                                 = 11,   /**< ONU Deactivation Completed. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_DISABLE_COMPLETED                                      = 12,   /**< ONU Disable Completed. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_ENABLE_COMPLETED                                       = 13,   /**< ONU Enable Completed. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_TUNING_IN_COMPLETED                                    = 14,   /**< ONU Tuning in completed. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_TUNING_OUT_COMPLETED                                   = 15,   /**< ONU Tuning out completed. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_OPTICAL_REFLECTION                                         = 16,   /**< Optical Reflection. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_POSSIBLE_DRIFT                                             = 17,   /**< Possible Drift. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_POWER_CONSUMPTION_REPORT                                   = 18,   /**< Power consumption report. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_POWER_LEVEL_REPORT                                         = 19,   /**< Power level report. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_POWER_MANAGEMENT_STATE_CHANGE                              = 20,   /**< Power Management State Change. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_PQSI                                                       = 21,   /**< ploam queue status. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_RANGING_COMPLETED                                          = 22,   /**< Ranging Completed. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_REGISTRATION_ID                                            = 23,   /**< Registration ID. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_RSSI_MEASUREMENT_COMPLETED                                 = 24,   /**< RSSI Measurement Completed. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_SDI                                                        = 25,   /**< Signal Degraded of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_SECURE_MUTUAL_AUTHENTICATION_FAILURE                       = 26,   /**< secure mutual authentication failure. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_SFI                                                        = 27,   /**< Signal Fail of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_STAT_ALARM_CLEARED                                         = 28,   /**< Stat Alarm Cleared. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_STAT_ALARM_RAISED                                          = 29,   /**< Stat Alarm Raised. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_SUFI                                                       = 30,   /**< SUFi. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_TIWI                                                       = 31,   /**< Transmission Interference Warning. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID_TUNING_RESPONSE                                            = 32,   /**< Tuning response. */
    BCMOLT_XGPON_ONU_AUTO_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_auto_cfg_id;

/** Identifiers for all properties contained in the xgpon_onu_cfg group. 
 */
typedef enum bcmolt_xgpon_onu_cfg_id
{
    BCMOLT_XGPON_ONU_CFG_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_ONU_CFG_ID_ONU_STATE                                                       = 0,    /**< onu state. */
    BCMOLT_XGPON_ONU_CFG_ID_ONU_OLD_STATE                                                   = 1,    /**< onu old state. */
    BCMOLT_XGPON_ONU_CFG_ID_ALARM_STATE                                                     = 2,    /**< alarm state. */
    BCMOLT_XGPON_ONU_CFG_ID_REGISTRATION_ENCRYPTION_KEYS                                    = 3,    /**< registration encryption keys. */
    BCMOLT_XGPON_ONU_CFG_ID_CURRENT_ENCRYPTION_KEY                                          = 4,    /**< current encryption key. */
    BCMOLT_XGPON_ONU_CFG_ID_SERIAL_NUMBER                                                   = 5,    /**< serial number. */
    BCMOLT_XGPON_ONU_CFG_ID_REGISTRATION_ID                                                 = 6,    /**< registration id. */
    BCMOLT_XGPON_ONU_CFG_ID_REGISTRATION_ID_AUTO_LEARNING                                   = 7,    /**< Registration ID auto learning. */
    BCMOLT_XGPON_ONU_CFG_ID_RANGING_BURST_PROFILE                                           = 8,    /**< ranging burst profile. */
    BCMOLT_XGPON_ONU_CFG_ID_DATA_BURST_PROFILE                                              = 9,    /**< data burst profile. */
    BCMOLT_XGPON_ONU_CFG_ID_RANGING_TIME                                                    = 10,   /**< ranging time. */
    BCMOLT_XGPON_ONU_CFG_ID_DISABLED_AFTER_DISCOVERY                                        = 11,   /**< Disabled after Discovery. */
    BCMOLT_XGPON_ONU_CFG_ID_DEACTIVATION_REASON                                             = 12,   /**< deactivation reason. */
    BCMOLT_XGPON_ONU_CFG_ID_ALL_GEM_PORTS                                                   = 13,   /**< all GEM ports. */
    BCMOLT_XGPON_ONU_CFG_ID_ALL_ALLOCS                                                      = 14,   /**< all allocs. */
    BCMOLT_XGPON_ONU_CFG_ID_EXTENDED_GUARD_TIME                                             = 15,   /**< Extended Guard Time. */
    BCMOLT_XGPON_ONU_CFG_ID_US_LINE_RATE                                                    = 16,   /**< US line rate. */
    BCMOLT_XGPON_ONU_CFG_ID_CALIBRATION_RECORD                                              = 17,   /**< Calibration record. */
    BCMOLT_XGPON_ONU_CFG_ID_TUNING_GRANULARITY                                              = 18,   /**< Tuning granularity. */
    BCMOLT_XGPON_ONU_CFG_ID_STEP_TUNING_TIME                                                = 19,   /**< Step tuning time. */
    BCMOLT_XGPON_ONU_CFG_ID_POWER_LEVELLING_CAPABILITIES                                    = 20,   /**< Power levelling capabilities. */
    BCMOLT_XGPON_ONU_CFG_ID_REQUEST_REGISTRATION_STATUS                                     = 21,   /**< Request registration status. */
    BCMOLT_XGPON_ONU_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_cfg_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_change_power_levelling group. 
 */
typedef enum bcmolt_xgpon_onu_change_power_levelling_id
{
    BCMOLT_XGPON_ONU_CHANGE_POWER_LEVELLING_ID__BEGIN                                       = 0,
    BCMOLT_XGPON_ONU_CHANGE_POWER_LEVELLING_ID_CONTROL                                      = 0,    /**< control. */
    BCMOLT_XGPON_ONU_CHANGE_POWER_LEVELLING_ID_ATTENUATION                                  = 1,    /**< Attenuation. */
    BCMOLT_XGPON_ONU_CHANGE_POWER_LEVELLING_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_change_power_levelling_id;

/** Identifiers for all properties contained in the xgpon_onu_cpu_packet group. 
 */
typedef enum bcmolt_xgpon_onu_cpu_packet_id
{
    BCMOLT_XGPON_ONU_CPU_PACKET_ID__BEGIN                                                   = 0,
    BCMOLT_XGPON_ONU_CPU_PACKET_ID_PORT_ID                                                  = 0,    /**< port id. */
    BCMOLT_XGPON_ONU_CPU_PACKET_ID_CRC_OK                                                   = 1,    /**< crc ok. */
    BCMOLT_XGPON_ONU_CPU_PACKET_ID_PACKET_SIZE                                              = 2,    /**< packet size. */
    BCMOLT_XGPON_ONU_CPU_PACKET_ID_BUFFER                                                   = 3,    /**< buffer. */
    BCMOLT_XGPON_ONU_CPU_PACKET_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_cpu_packet_id;

/** Identifiers for all properties contained in the xgpon_onu_cpu_packets group. 
 */
typedef enum bcmolt_xgpon_onu_cpu_packets_id
{
    BCMOLT_XGPON_ONU_CPU_PACKETS_ID__BEGIN                                                  = 0,
    BCMOLT_XGPON_ONU_CPU_PACKETS_ID_PACKET_TYPE                                             = 0,    /**< packet type. */
    BCMOLT_XGPON_ONU_CPU_PACKETS_ID_CALC_CRC                                                = 1,    /**< calc crc. */
    BCMOLT_XGPON_ONU_CPU_PACKETS_ID_NUMBER_OF_PACKETS                                       = 2,    /**< number of packets. */
    BCMOLT_XGPON_ONU_CPU_PACKETS_ID_PACKET_SIZE                                             = 3,    /**< Single packet size. */
    BCMOLT_XGPON_ONU_CPU_PACKETS_ID_BUFFER                                                  = 4,    /**< buffer. */
    BCMOLT_XGPON_ONU_CPU_PACKETS_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_cpu_packets_id;

/** Identifiers for all properties contained in the xgpon_onu_dfi group. 
 */
typedef enum bcmolt_xgpon_onu_dfi_id
{
    BCMOLT_XGPON_ONU_DFI_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_ONU_DFI_ID_ALARM_STATUS                                                    = 0,    /**< alarm status. */
    BCMOLT_XGPON_ONU_DFI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_dfi_id;

/** Identifiers for all properties contained in the xgpon_onu_dgi group. 
 */
typedef enum bcmolt_xgpon_onu_dgi_id
{
    BCMOLT_XGPON_ONU_DGI_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_ONU_DGI_ID_ALARM_STATUS                                                    = 0,    /**< alarm status. */
    BCMOLT_XGPON_ONU_DGI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_dgi_id;

/** Identifiers for all properties contained in the xgpon_onu_dowi group. 
 */
typedef enum bcmolt_xgpon_onu_dowi_id
{
    BCMOLT_XGPON_ONU_DOWI_ID__BEGIN                                                         = 0,
    BCMOLT_XGPON_ONU_DOWI_ID_ALARM_STATUS                                                   = 0,    /**< Alarm status. */
    BCMOLT_XGPON_ONU_DOWI_ID_DRIFT_VALUE                                                    = 1,    /**< Drift value. */
    BCMOLT_XGPON_ONU_DOWI_ID_NEW_EQD                                                        = 2,    /**< New EQD. */
    BCMOLT_XGPON_ONU_DOWI_ID__NUM_OF                    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_dowi_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_get_power_consumption group. 
 */
typedef enum bcmolt_xgpon_onu_get_power_consumption_id
{
    BCMOLT_XGPON_ONU_GET_POWER_CONSUMPTION_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_get_power_consumption_id;

/** Identifiers for all properties contained in the xgpon_onu_get_power_level 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_get_power_level_id
{
    BCMOLT_XGPON_ONU_GET_POWER_LEVEL_ID__NUM_OF         /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_get_power_level_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_invalid_dbru_report group. 
 */
typedef enum bcmolt_xgpon_onu_invalid_dbru_report_id
{
    BCMOLT_XGPON_ONU_INVALID_DBRU_REPORT_ID__BEGIN                                          = 0,
    BCMOLT_XGPON_ONU_INVALID_DBRU_REPORT_ID_ALLOC_ID                                        = 0,    /**< Alloc-ID. */
    BCMOLT_XGPON_ONU_INVALID_DBRU_REPORT_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_invalid_dbru_report_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_key_exchange_completed group. 
 */
typedef enum bcmolt_xgpon_onu_key_exchange_completed_id
{
    BCMOLT_XGPON_ONU_KEY_EXCHANGE_COMPLETED_ID__BEGIN                                       = 0,
    BCMOLT_XGPON_ONU_KEY_EXCHANGE_COMPLETED_ID_NEW_KEY                                      = 0,    /**< new key. */
    BCMOLT_XGPON_ONU_KEY_EXCHANGE_COMPLETED_ID__NUM_OF      /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_key_exchange_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_key_exchange_cycle_skipped group. 
 */
typedef enum bcmolt_xgpon_onu_key_exchange_cycle_skipped_id
{
    BCMOLT_XGPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_key_exchange_cycle_skipped_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_key_exchange_key_mismatch group. 
 */
typedef enum bcmolt_xgpon_onu_key_exchange_key_mismatch_id
{
    BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID__BEGIN                                    = 0,
    BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID_EXPECTED_KEY                              = 0,    /**< expected key. */
    BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID_RECEIVED_KEY                              = 1,    /**< received key. */
    BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID__NUM_OF           /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_key_exchange_key_mismatch_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_key_exchange_key_request_timeout group. 
 */
typedef enum bcmolt_xgpon_onu_key_exchange_key_request_timeout_id
{
    BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_key_exchange_key_request_timeout_id;

/** Identifiers for all properties contained in the xgpon_onu_key group. 
 */
typedef enum bcmolt_xgpon_onu_key_id
{
    BCMOLT_XGPON_ONU_KEY_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_ONU_KEY_ID_PON_NI                                                          = 0,    /**< PON network interface. */
    BCMOLT_XGPON_ONU_KEY_ID_ONU_ID                                                          = 1,    /**< onu id. */
    BCMOLT_XGPON_ONU_KEY_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_key_id;

/** Identifiers for all properties contained in the xgpon_onu_looci group. 
 */
typedef enum bcmolt_xgpon_onu_looci_id
{
    BCMOLT_XGPON_ONU_LOOCI_ID__BEGIN                                                        = 0,
    BCMOLT_XGPON_ONU_LOOCI_ID_ALARM_STATUS                                                  = 0,    /**< alarm status. */
    BCMOLT_XGPON_ONU_LOOCI_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_looci_id;

/** Identifiers for all properties contained in the xgpon_onu_omci_packet group. 
 */
typedef enum bcmolt_xgpon_onu_omci_packet_id
{
    BCMOLT_XGPON_ONU_OMCI_PACKET_ID__BEGIN                                                  = 0,
    BCMOLT_XGPON_ONU_OMCI_PACKET_ID_PORT_ID                                                 = 0,    /**< port id. */
    BCMOLT_XGPON_ONU_OMCI_PACKET_ID_CRC_OK                                                  = 1,    /**< crc ok. */
    BCMOLT_XGPON_ONU_OMCI_PACKET_ID_PACKET_SIZE                                             = 2,    /**< packet size. */
    BCMOLT_XGPON_ONU_OMCI_PACKET_ID_BUFFER                                                  = 3,    /**< buffer. */
    BCMOLT_XGPON_ONU_OMCI_PACKET_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_omci_packet_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_onu_activation_completed group. 
 */
typedef enum bcmolt_xgpon_onu_onu_activation_completed_id
{
    BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID__BEGIN                                     = 0,
    BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID_STATUS                                     = 0,    /**< status. */
    BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID_FAIL_REASON                                = 1,    /**< fail reason. */
    BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID_REGISTRATION_ID                            = 2,    /**< registration id. */
    BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID_REGISTRATION_ENCRYPTION_KEYS               = 3,    /**< registration encryption keys. */
    BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_onu_activation_completed_id;

/** Identifiers for all properties contained in the xgpon_onu_onu_alarm group. 
 */
typedef enum bcmolt_xgpon_onu_onu_alarm_id
{
    BCMOLT_XGPON_ONU_ONU_ALARM_ID__BEGIN                                                    = 0,
    BCMOLT_XGPON_ONU_ONU_ALARM_ID_ONU_ALARM                                                 = 0,    /**< onu alarm. */
    BCMOLT_XGPON_ONU_ONU_ALARM_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_onu_alarm_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_onu_deactivation_completed group. 
 */
typedef enum bcmolt_xgpon_onu_onu_deactivation_completed_id
{
    BCMOLT_XGPON_ONU_ONU_DEACTIVATION_COMPLETED_ID__BEGIN                                   = 0,
    BCMOLT_XGPON_ONU_ONU_DEACTIVATION_COMPLETED_ID_STATUS                                   = 0,    /**< Status. */
    BCMOLT_XGPON_ONU_ONU_DEACTIVATION_COMPLETED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_onu_deactivation_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_onu_disable_completed group. 
 */
typedef enum bcmolt_xgpon_onu_onu_disable_completed_id
{
    BCMOLT_XGPON_ONU_ONU_DISABLE_COMPLETED_ID__BEGIN                                        = 0,
    BCMOLT_XGPON_ONU_ONU_DISABLE_COMPLETED_ID_SERIAL_NUMBER                                 = 0,    /**< serial number. */
    BCMOLT_XGPON_ONU_ONU_DISABLE_COMPLETED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_onu_disable_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_onu_enable_completed group. 
 */
typedef enum bcmolt_xgpon_onu_onu_enable_completed_id
{
    BCMOLT_XGPON_ONU_ONU_ENABLE_COMPLETED_ID__BEGIN                                         = 0,
    BCMOLT_XGPON_ONU_ONU_ENABLE_COMPLETED_ID_SERIAL_NUMBER                                  = 0,    /**< serial number. */
    BCMOLT_XGPON_ONU_ONU_ENABLE_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_onu_enable_completed_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_onu_tuning_in_completed group. 
 */
typedef enum bcmolt_xgpon_onu_onu_tuning_in_completed_id
{
    BCMOLT_XGPON_ONU_ONU_TUNING_IN_COMPLETED_ID__BEGIN                                      = 0,
    BCMOLT_XGPON_ONU_ONU_TUNING_IN_COMPLETED_ID_RESULT                                      = 0,    /**< result. */
    BCMOLT_XGPON_ONU_ONU_TUNING_IN_COMPLETED_ID_FAIL_REASON                                 = 1,    /**< fail reason. */
    BCMOLT_XGPON_ONU_ONU_TUNING_IN_COMPLETED_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_onu_tuning_in_completed_id;

/** Identifiers for all properties contained in the xgpon_onu_onu_tuning_in 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_onu_tuning_in_id
{
    BCMOLT_XGPON_ONU_ONU_TUNING_IN_ID__NUM_OF           /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_onu_tuning_in_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_onu_tuning_out_completed group. 
 */
typedef enum bcmolt_xgpon_onu_onu_tuning_out_completed_id
{
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_COMPLETED_ID__BEGIN                                     = 0,
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_COMPLETED_ID_RESULT                                     = 0,    /**< result. */
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_COMPLETED_ID_FAIL_REASON                                = 1,    /**< fail reason. */
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_COMPLETED_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_onu_tuning_out_completed_id;

/** Identifiers for all properties contained in the xgpon_onu_onu_tuning_out 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_onu_tuning_out_id
{
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID__BEGIN                                               = 0,
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_TARGET_DS_PON_ID                                     = 0,    /**< target ds pon id. */
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_TARGET_US_PON_ID                                     = 1,    /**< target us pon id. */
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_TIME_TO_SWITCH                                       = 2,    /**< time to switch. */
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_ROLLBACK                                             = 3,    /**< rollback. */
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_STATUS                                               = 4,    /**< status. */
    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID__NUM_OF      /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_onu_tuning_out_id;

/** Identifiers for all properties contained in the xgpon_onu_optical_reflection 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_optical_reflection_id
{
    BCMOLT_XGPON_ONU_OPTICAL_REFLECTION_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_optical_reflection_id;

/** Identifiers for all properties contained in the xgpon_onu_ploam_packet 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_ploam_packet_id
{
    BCMOLT_XGPON_ONU_PLOAM_PACKET_ID__BEGIN                                                 = 0,
    BCMOLT_XGPON_ONU_PLOAM_PACKET_ID_DEFAULT_KEY                                            = 0,    /**< default key. */
    BCMOLT_XGPON_ONU_PLOAM_PACKET_ID_PLOAM                                                  = 1,    /**< ploam. */
    BCMOLT_XGPON_ONU_PLOAM_PACKET_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_ploam_packet_id;

/** Identifiers for all properties contained in the xgpon_onu_possible_drift 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_possible_drift_id
{
    BCMOLT_XGPON_ONU_POSSIBLE_DRIFT_ID__BEGIN                                               = 0,
    BCMOLT_XGPON_ONU_POSSIBLE_DRIFT_ID_ALARM_STATUS                                         = 0,    /**< Alarm Status. */
    BCMOLT_XGPON_ONU_POSSIBLE_DRIFT_ID_ESTIMATED_DRIFT                                      = 1,    /**< Estimated Drift. */
    BCMOLT_XGPON_ONU_POSSIBLE_DRIFT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_possible_drift_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_power_consumption_report group. 
 */
typedef enum bcmolt_xgpon_onu_power_consumption_report_id
{
    BCMOLT_XGPON_ONU_POWER_CONSUMPTION_REPORT_ID__BEGIN                                     = 0,
    BCMOLT_XGPON_ONU_POWER_CONSUMPTION_REPORT_ID_POWER_CONSUMPTION_REPORT                   = 0,    /**< power consumption report. */
    BCMOLT_XGPON_ONU_POWER_CONSUMPTION_REPORT_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_power_consumption_report_id;

/** Identifiers for all properties contained in the xgpon_onu_power_level_report 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_power_level_report_id
{
    BCMOLT_XGPON_ONU_POWER_LEVEL_REPORT_ID__BEGIN                                           = 0,
    BCMOLT_XGPON_ONU_POWER_LEVEL_REPORT_ID_ATTENUATION                                      = 0,    /**< Attenuation. */
    BCMOLT_XGPON_ONU_POWER_LEVEL_REPORT_ID_POWER_LEVELLING_CAPABILITY                       = 1,    /**< Power levelling capability. */
    BCMOLT_XGPON_ONU_POWER_LEVEL_REPORT_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_power_level_report_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_power_management_state_change group. 
 */
typedef enum bcmolt_xgpon_onu_power_management_state_change_id
{
    BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID__BEGIN                                = 0,
    BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_OLD_STATE                             = 0,    /**< Old State. */
    BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_NEW_STATE                             = 1,    /**< New State. */
    BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_REASON                                = 2,    /**< Reason. */
    BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_power_management_state_change_id;

/** Identifiers for all properties contained in the xgpon_onu_pqsi group. 
 */
typedef enum bcmolt_xgpon_onu_pqsi_id
{
    BCMOLT_XGPON_ONU_PQSI_ID__BEGIN                                                         = 0,
    BCMOLT_XGPON_ONU_PQSI_ID_ALARM_STATUS                                                   = 0,    /**< alarm status. */
    BCMOLT_XGPON_ONU_PQSI_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_pqsi_id;

/** Identifiers for all properties contained in the xgpon_onu_ranging_completed 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_ranging_completed_id
{
    BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID__BEGIN                                            = 0,
    BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_STATUS                                            = 0,    /**< status. */
    BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_FAIL_REASON                                       = 1,    /**< fail reason. */
    BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_EQD                                               = 2,    /**< EQD. */
    BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_NUMBER_OF_PLOAMS                                  = 3,    /**< number of ploams. */
    BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_POWER_LEVEL                                       = 4,    /**< power level. */
    BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_ranging_completed_id;

/** Identifiers for all properties contained in the xgpon_onu_registration_id 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_registration_id_id
{
    BCMOLT_XGPON_ONU_REGISTRATION_ID_ID__BEGIN                                              = 0,
    BCMOLT_XGPON_ONU_REGISTRATION_ID_ID_REGISTRATION_ID                                     = 0,    /**< Registration ID. */
    BCMOLT_XGPON_ONU_REGISTRATION_ID_ID_REQUEST_REGISTRATION_STATUS                         = 1,    /**< request registration status. */
    BCMOLT_XGPON_ONU_REGISTRATION_ID_ID_REQUEST_REGISTRATION_FAIL_REASON                    = 2,    /**< request registration fail reason. */
    BCMOLT_XGPON_ONU_REGISTRATION_ID_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_registration_id_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_request_registration group. 
 */
typedef enum bcmolt_xgpon_onu_request_registration_id
{
    BCMOLT_XGPON_ONU_REQUEST_REGISTRATION_ID__BEGIN                                         = 0,
    BCMOLT_XGPON_ONU_REQUEST_REGISTRATION_ID_SMA_FLAG                                       = 0,    /**< SMA flag. */
    BCMOLT_XGPON_ONU_REQUEST_REGISTRATION_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_request_registration_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_rssi_measurement_completed group. 
 */
typedef enum bcmolt_xgpon_onu_rssi_measurement_completed_id
{
    BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID__BEGIN                                   = 0,
    BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID_STATUS                                   = 0,    /**< status. */
    BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID_FAIL_REASON                              = 1,    /**< fail reason. */
    BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_rssi_measurement_completed_id;

/** Identifiers for all properties contained in the xgpon_onu_rssi_measurement 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_rssi_measurement_id
{
    BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_ID__NUM_OF            /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_rssi_measurement_id;

/** Identifiers for all properties contained in the xgpon_onu_sdi group. 
 */
typedef enum bcmolt_xgpon_onu_sdi_id
{
    BCMOLT_XGPON_ONU_SDI_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_ONU_SDI_ID_ALARM_STATUS                                                    = 0,    /**< alarm status. */
    BCMOLT_XGPON_ONU_SDI_ID_BER                                                             = 1,    /**< BER. */
    BCMOLT_XGPON_ONU_SDI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_sdi_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_secure_mutual_authentication_failure group. 
 */
typedef enum bcmolt_xgpon_onu_secure_mutual_authentication_failure_id
{
    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE_ID__BEGIN                         = 0,
    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE_ID_STATUS                         = 0,    /**< status. */
    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE_ID_FAIL_REASON                    = 1,    /**< secure mutual authentication fail reason. */
    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_secure_mutual_authentication_failure_id;

/** Identifiers for all properties contained in the 
 * xgpon_onu_secure_mutual_authentication group. 
 */
typedef enum bcmolt_xgpon_onu_secure_mutual_authentication_id
{
    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID__BEGIN                                 = 0,
    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID_MASTER_KEY                             = 0,    /**< master key. */
    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID_BUFFER                                 = 1,    /**< OMCI data buffer. */
    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID_MIC                                    = 2,    /**< mic. */
    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_secure_mutual_authentication_id;

/** Identifiers for all properties contained in the xgpon_onu_set_onu_state 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_set_onu_state_id
{
    BCMOLT_XGPON_ONU_SET_ONU_STATE_ID__BEGIN                                                = 0,
    BCMOLT_XGPON_ONU_SET_ONU_STATE_ID_ONU_STATE                                             = 0,    /**< ONU state. */
    BCMOLT_XGPON_ONU_SET_ONU_STATE_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_set_onu_state_id;

/** Identifiers for all properties contained in the xgpon_onu_sfi group. 
 */
typedef enum bcmolt_xgpon_onu_sfi_id
{
    BCMOLT_XGPON_ONU_SFI_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_ONU_SFI_ID_ALARM_STATUS                                                    = 0,    /**< alarm status. */
    BCMOLT_XGPON_ONU_SFI_ID_BER                                                             = 1,    /**< BER. */
    BCMOLT_XGPON_ONU_SFI_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_sfi_id;

/** Identifiers for all properties contained in the xgpon_onu_stat_alarm_cleared 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_stat_alarm_cleared_id
{
    BCMOLT_XGPON_ONU_STAT_ALARM_CLEARED_ID__BEGIN                                           = 0,
    BCMOLT_XGPON_ONU_STAT_ALARM_CLEARED_ID_STAT                                             = 0,    /**< Statistic ID. */
    BCMOLT_XGPON_ONU_STAT_ALARM_CLEARED_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_stat_alarm_cleared_id;

/** Identifiers for all properties contained in the xgpon_onu_stat_alarm_raised 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_stat_alarm_raised_id
{
    BCMOLT_XGPON_ONU_STAT_ALARM_RAISED_ID__BEGIN                                            = 0,
    BCMOLT_XGPON_ONU_STAT_ALARM_RAISED_ID_STAT                                              = 0,    /**< Statistic ID. */
    BCMOLT_XGPON_ONU_STAT_ALARM_RAISED_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_stat_alarm_raised_id;

/** Identifiers for all properties contained in the xgpon_onu_stat_cfg group. 
 */
typedef enum bcmolt_xgpon_onu_stat_cfg_id
{
    BCMOLT_XGPON_ONU_STAT_CFG_ID__BEGIN                                                     = 0,
    BCMOLT_XGPON_ONU_STAT_CFG_ID_CFG                                                        = 0,    /**< Configuration. */
    BCMOLT_XGPON_ONU_STAT_CFG_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_stat_cfg_id;

/** Identifiers for all properties contained in the xgpon_onu_stat group. 
 */
typedef enum bcmolt_xgpon_onu_stat_id
{
    BCMOLT_XGPON_ONU_STAT_ID__BEGIN                                                         = 0,
    BCMOLT_XGPON_ONU_STAT_ID_POSITIVE_DRIFT                                                 = 0,    /**< positive drift. */
    BCMOLT_XGPON_ONU_STAT_ID_NEGATIVE_DRIFT                                                 = 1,    /**< negative drift. */
    BCMOLT_XGPON_ONU_STAT_ID_DELIMITER_MISS_DETECTION                                       = 2,    /**< delimiter miss detection. */
    BCMOLT_XGPON_ONU_STAT_ID_BIP32_ERRORS                                                   = 3,    /**< bip32 errors. */
    BCMOLT_XGPON_ONU_STAT_ID_RX_WORDS                                                       = 4,    /**< received words. */
    BCMOLT_XGPON_ONU_STAT_ID_FEC_CORRECTED_SYMBOLS                                          = 5,    /**< fec corrected symbols. */
    BCMOLT_XGPON_ONU_STAT_ID_FEC_CORRECTED_CODEWORDS                                        = 6,    /**< fec corrected codewords. */
    BCMOLT_XGPON_ONU_STAT_ID_FEC_UNCORRECTABLE_CODEWORDS                                    = 7,    /**< fec uncorrectable codewords. */
    BCMOLT_XGPON_ONU_STAT_ID_FEC_CODEWORDS                                                  = 8,    /**< fec total codewords. */
    BCMOLT_XGPON_ONU_STAT_ID_FEC_CORRECTED_BITS                                             = 9,    /**< fec corrected bits. */
    BCMOLT_XGPON_ONU_STAT_ID_XGEM_KEY_ERRORS                                                = 10,   /**< xgem key error. */
    BCMOLT_XGPON_ONU_STAT_ID_XGEM_LOSS                                                      = 11,   /**< xgem loss . */
    BCMOLT_XGPON_ONU_STAT_ID_RX_PLOAMS_MIC_ERROR                                            = 12,   /**< mic error ploam. */
    BCMOLT_XGPON_ONU_STAT_ID_RX_PLOAMS_NON_IDLE                                             = 13,   /**< non idle ploam. */
    BCMOLT_XGPON_ONU_STAT_ID_RX_OMCI                                                        = 14,   /**< Received OMCI packets. */
    BCMOLT_XGPON_ONU_STAT_ID_RX_OMCI_PACKETS_CRC_ERROR                                      = 15,   /**< Received OMCI packets with CRC errors. */
    BCMOLT_XGPON_ONU_STAT_ID_RX_BYTES                                                       = 16,   /**< rx bytes. */
    BCMOLT_XGPON_ONU_STAT_ID_RX_PACKETS                                                     = 17,   /**< rx packets. */
    BCMOLT_XGPON_ONU_STAT_ID_TX_BYTES                                                       = 18,   /**< tx bytes. */
    BCMOLT_XGPON_ONU_STAT_ID_TX_PACKETS                                                     = 19,   /**< tx packets. */
    BCMOLT_XGPON_ONU_STAT_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_stat_id;

/** Identifiers for all properties contained in the xgpon_onu_sufi group. 
 */
typedef enum bcmolt_xgpon_onu_sufi_id
{
    BCMOLT_XGPON_ONU_SUFI_ID__BEGIN                                                         = 0,
    BCMOLT_XGPON_ONU_SUFI_ID_ALARM_STATUS                                                   = 0,    /**< alarm status. */
    BCMOLT_XGPON_ONU_SUFI_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_sufi_id;

/** Identifiers for all properties contained in the xgpon_onu_tiwi group. 
 */
typedef enum bcmolt_xgpon_onu_tiwi_id
{
    BCMOLT_XGPON_ONU_TIWI_ID__BEGIN                                                         = 0,
    BCMOLT_XGPON_ONU_TIWI_ID_ALARM_STATUS                                                   = 0,    /**< Alarm status. */
    BCMOLT_XGPON_ONU_TIWI_ID_DRIFT_VALUE                                                    = 1,    /**< Drift value. */
    BCMOLT_XGPON_ONU_TIWI_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_tiwi_id;

/** Identifiers for all properties contained in the xgpon_onu_tuning_response 
 * group. 
 */
typedef enum bcmolt_xgpon_onu_tuning_response_id
{
    BCMOLT_XGPON_ONU_TUNING_RESPONSE_ID__BEGIN                                              = 0,
    BCMOLT_XGPON_ONU_TUNING_RESPONSE_ID_ACK                                                 = 0,    /**< ack. */
    BCMOLT_XGPON_ONU_TUNING_RESPONSE_ID_RESULT                                              = 1,    /**< result. */
    BCMOLT_XGPON_ONU_TUNING_RESPONSE_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_tuning_response_id;

/** Identifiers for all properties contained in the xgpon_trx_cfg group. 
 */
typedef enum bcmolt_xgpon_trx_cfg_id
{
    BCMOLT_XGPON_TRX_CFG_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_TRX_CFG_ID_BURST_PROFILE                                                   = 0,    /**< burst profile. */
    BCMOLT_XGPON_TRX_CFG_ID_TRANSCEIVER_CONFIG                                              = 1,    /**< transceiver config. */
    BCMOLT_XGPON_TRX_CFG_ID_TRANSCEIVER_TYPE                                                = 2,    /**< trx type. */
    BCMOLT_XGPON_TRX_CFG_ID_DEBUG                                                           = 3,    /**< debug. */
    BCMOLT_XGPON_TRX_CFG_ID_RSSI_NORMAL_CONFIG                                              = 4,    /**< rssi normal config. */
    BCMOLT_XGPON_TRX_CFG_ID_RSSI_RANGING_CONFIG                                             = 5,    /**< rssi ranging config. */
    BCMOLT_XGPON_TRX_CFG_ID_SERDES_CONFIGURATION                                            = 6,    /**< serdes configuration. */
    BCMOLT_XGPON_TRX_CFG_ID_BURST_PROFILE_DELIMITER_MAX_ERRORS                              = 7,    /**< burst profile delimiter max errors. */
    BCMOLT_XGPON_TRX_CFG_ID_RANGING_SM_PATTERNS_AT_INIT                                     = 8,    /**< ranging sm patterns at init. */
    BCMOLT_XGPON_TRX_CFG_ID_RANGING_SM_PATTERNS_ED_FAILURE                                  = 9,    /**< ranging sm patterns ED failure. */
    BCMOLT_XGPON_TRX_CFG_ID_RESET_ON_DEL_MISS                                               = 10,   /**< reset on del miss. */
    BCMOLT_XGPON_TRX_CFG_ID_ED_STATE                                                        = 11,   /**< ed state. */
    BCMOLT_XGPON_TRX_CFG_ID_INVERT_ED                                                       = 12,   /**< invert ED. */
    BCMOLT_XGPON_TRX_CFG_ID_END_OF_BURST_RESET                                              = 13,   /**< end of burst reset. */
    BCMOLT_XGPON_TRX_CFG_ID_TRX_RST_POLARITY                                                = 14,   /**< TRX reset polarity. */
    BCMOLT_XGPON_TRX_CFG_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_trx_cfg_id;

/** Identifiers for all properties contained in the xgpon_trx_key group. 
 */
typedef enum bcmolt_xgpon_trx_key_id
{
    BCMOLT_XGPON_TRX_KEY_ID__BEGIN                                                          = 0,
    BCMOLT_XGPON_TRX_KEY_ID_PON_NI                                                          = 0,    /**< PON network interface. */
    BCMOLT_XGPON_TRX_KEY_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_trx_key_id;

/** Identifiers for all properties contained in the xpon_serdes_cfg group. 
 */
typedef enum bcmolt_xpon_serdes_cfg_id
{
    BCMOLT_XPON_SERDES_CFG_ID__BEGIN                                                        = 0,
    BCMOLT_XPON_SERDES_CFG_ID_RX_VGA                                                        = 0,    /**< Rx Vga. */
    BCMOLT_XPON_SERDES_CFG_ID_RX_PF                                                         = 1,    /**< Rx PF. */
    BCMOLT_XPON_SERDES_CFG_ID_RX_LFPF                                                       = 2,    /**< Rx LFPF. */
    BCMOLT_XPON_SERDES_CFG_ID_RX_DFE1                                                       = 3,    /**< Rx DFE1. */
    BCMOLT_XPON_SERDES_CFG_ID_RX_DFE2                                                       = 4,    /**< Rx DFE2. */
    BCMOLT_XPON_SERDES_CFG_ID_RX_DFE3                                                       = 5,    /**< Rx DFE3. */
    BCMOLT_XPON_SERDES_CFG_ID_RX_DFE4                                                       = 6,    /**< Rx DFE4. */
    BCMOLT_XPON_SERDES_CFG_ID_RX_DFE5                                                       = 7,    /**< Rx DFE5. */
    BCMOLT_XPON_SERDES_CFG_ID_TX_PRE                                                        = 8,    /**< Tx Pre. */
    BCMOLT_XPON_SERDES_CFG_ID_TX_MAIN                                                       = 9,    /**< Tx Main. */
    BCMOLT_XPON_SERDES_CFG_ID_TX_POST1                                                      = 10,   /**< Tx Post1. */
    BCMOLT_XPON_SERDES_CFG_ID_TX_POST2                                                      = 11,   /**< Tx Post2. */
    BCMOLT_XPON_SERDES_CFG_ID_TX_POST3                                                      = 12,   /**< Tx Post3. */
    BCMOLT_XPON_SERDES_CFG_ID_TX_AMP                                                        = 13,   /**< Tx Amp. */
    BCMOLT_XPON_SERDES_CFG_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xpon_serdes_cfg_id;

/** Identifiers for all properties contained in the xpon_serdes_key group. 
 */
typedef enum bcmolt_xpon_serdes_key_id
{
    BCMOLT_XPON_SERDES_KEY_ID__BEGIN                                                        = 0,
    BCMOLT_XPON_SERDES_KEY_ID_PON_NI                                                        = 0,    /**< PON NI. */
    BCMOLT_XPON_SERDES_KEY_ID_INSTANCE                                                      = 1,    /**< Instance. */
    BCMOLT_XPON_SERDES_KEY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xpon_serdes_key_id;

/** All object tags for all objects in the system. 
 */
typedef enum bcmolt_obj_tag
{
    BCMOLT_OBJ_TAG__BEGIN,
    BCMOLT_OBJ_TAG_EPON                                                                     = 0,
    BCMOLT_OBJ_TAG_AE,
    BCMOLT_OBJ_TAG_GPON,
    BCMOLT_OBJ_TAG_XGPON,
    BCMOLT_OBJ_TAG__NUM_OF              /**< Number of enum entries, not an entry itself. */
} bcmolt_obj_tag;

/* The following config modes are enabled for this build */
#define BCMOLT_CONFIG_MODE_EPON 1

/* The following config modes are enabled for this build */
#define BCMOLT_CONFIG_MODE_AE   1

/* The following config modes are enabled for this build */
#define BCMOLT_CONFIG_MODE_GPON 1

/* The following config modes are enabled for this build */
#define BCMOLT_CONFIG_MODE_XGPON    1

/** Identifiers for all objects in the system. 
 */
typedef enum bcmolt_obj_id
{
    BCMOLT_OBJ_ID__BEGIN,
    BCMOLT_OBJ_ID_AE_NI                                                                     = 0,    /**< AE NI (Active Ethernet Network Interface) */
    BCMOLT_OBJ_ID_AE_PATH_DS                                                                = 1,    /**< AE path downstream */
    BCMOLT_OBJ_ID_AE_PATH_US                                                                = 2,    /**< AE path upstream */
    BCMOLT_OBJ_ID_CHANNEL                                                                   = 3,    /**< Channel */
    BCMOLT_OBJ_ID_DEBUG                                                                     = 4,    /**< Debug */
    BCMOLT_OBJ_ID_DEVICE                                                                    = 5,    /**< Device */
    BCMOLT_OBJ_ID_EPON_DENIED_LINK                                                          = 6,    /**< EPON Denied Link */
    BCMOLT_OBJ_ID_EPON_LINK                                                                 = 7,    /**< EPON link */
    BCMOLT_OBJ_ID_EPON_NI                                                                   = 8,    /**< EPON NI (EPON Network Interface) */
    BCMOLT_OBJ_ID_EPON_ONU_10G_US                                                           = 9,    /**< EPON ONU 10G US */
    BCMOLT_OBJ_ID_EPON_ONU_1G_US                                                            = 10,   /**< EPON ONU 1G US */
    BCMOLT_OBJ_ID_EPON_PATH_10G_DS                                                          = 11,   /**< EPON path 10G downstream */
    BCMOLT_OBJ_ID_EPON_PATH_10G_US                                                          = 12,   /**< EPON path 10G upstream */
    BCMOLT_OBJ_ID_EPON_PATH_1G_DS                                                           = 13,   /**< EPON path 1G downstream */
    BCMOLT_OBJ_ID_EPON_PATH_1G_US                                                           = 14,   /**< EPON path 1G upstream */
    BCMOLT_OBJ_ID_EPON_RP                                                                   = 15,   /**< EPON Reconciliation Path */
    BCMOLT_OBJ_ID_GPIO                                                                      = 16,   /**< GPIO */
    BCMOLT_OBJ_ID_GPON_ALLOC                                                                = 17,   /**< GPON Alloc */
    BCMOLT_OBJ_ID_GPON_GEM_PORT                                                             = 18,   /**< GPON GEM Port */
    BCMOLT_OBJ_ID_GPON_IWF                                                                  = 19,   /**< GPON IWF */
    BCMOLT_OBJ_ID_GPON_IWF_DS_EGRESS_FLOW                                                   = 20,   /**< GPON IWF DS egress flow */
    BCMOLT_OBJ_ID_GPON_IWF_DS_INGRESS_FLOW                                                  = 21,   /**< GPON IWF DS ingress flow */
    BCMOLT_OBJ_ID_GPON_IWF_MAC_TABLE                                                        = 22,   /**< GPON IWF MAC table */
    BCMOLT_OBJ_ID_GPON_IWF_US_FLOW                                                          = 23,   /**< GPON IWF US flow */
    BCMOLT_OBJ_ID_GPON_NI                                                                   = 24,   /**< GPON network interface */
    BCMOLT_OBJ_ID_GPON_ONU                                                                  = 25,   /**< GPON ONU */
    BCMOLT_OBJ_ID_GPON_TRX                                                                  = 26,   /**< GPON TRX */
    BCMOLT_OBJ_ID_LOG_ENTRY                                                                 = 27,   /**< log entry */
    BCMOLT_OBJ_ID_LOGGER                                                                    = 28,   /**< logger */
    BCMOLT_OBJ_ID_NNI                                                                       = 29,   /**< NNI */
    BCMOLT_OBJ_ID_NNI_SERDES                                                                = 30,   /**< nni_serdes */
    BCMOLT_OBJ_ID_SOFTWARE_ERROR                                                            = 31,   /**< Software Error */
    BCMOLT_OBJ_ID_TRX_CALIBRATION                                                           = 32,   /**< TRX Calibration */
    BCMOLT_OBJ_ID_XGPON_ALLOC                                                               = 33,   /**< XGPON Alloc */
    BCMOLT_OBJ_ID_XGPON_GEM_PORT                                                            = 34,   /**< XGPON GEM port */
    BCMOLT_OBJ_ID_XGPON_IWF                                                                 = 35,   /**< XGPON IWF */
    BCMOLT_OBJ_ID_XGPON_NI                                                                  = 36,   /**< XGPON network interface */
    BCMOLT_OBJ_ID_XGPON_ONU                                                                 = 37,   /**< XGPON ONU */
    BCMOLT_OBJ_ID_XGPON_TRX                                                                 = 38,   /**< XGPON TRX */
    BCMOLT_OBJ_ID_XPON_SERDES                                                               = 39,   /**< xpon_serdes */
    BCMOLT_OBJ_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_obj_id;

/** Identifiers for all possible groups under all objects in the system. 
 */
typedef enum bcmolt_group_id
{
    BCMOLT_GROUP_ID__BEGIN,
    BCMOLT_GROUP_ID_AE_NI_KEY                                                               = 0,    /**< AE NI (Active Ethernet Network Interface) - key */
    BCMOLT_GROUP_ID_AE_NI_CFG                                                               = 1,    /**< AE NI (Active Ethernet Network Interface) - cfg */
    BCMOLT_GROUP_ID_AE_NI_SET_AE_NI_EN_STATE                                                = 2,    /**< AE NI (Active Ethernet Network Interface) - Set AE NI Enable State */
    BCMOLT_GROUP_ID_AE_PATH_DS_KEY                                                          = 3,    /**< AE path downstream - key */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT                                                         = 4,    /**< AE path downstream - stat */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_BYTES                                               = 5,    /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES                                              = 6,    /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_64                                           = 7,    /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_65_127                                       = 8,    /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_128_255                                      = 9,    /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_256_511                                      = 10,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_512_1023                                     = 11,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_1024_1518                                    = 12,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_1519_2047                                    = 13,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_2048_4095                                    = 14,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_4096_9216                                    = 15,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_FRAMES_9217_16383                                   = 16,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_BROADCAST_FRAMES                                    = 17,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_DATA_BYTES                                          = 18,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_MULTICAST_FRAMES                                    = 19,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_UNICAST_FRAMES                                      = 20,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_CFG_ABORT_FRAMES                                        = 21,   /**< AE path downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_ALARM_CLEARED                                           = 22,   /**< AE path downstream - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_AE_PATH_DS_STAT_ALARM_RAISED                                            = 23,   /**< AE path downstream - Stat Alarm Raised */
    BCMOLT_GROUP_ID_AE_PATH_DS_AUTO_CFG                                                     = 24,   /**< AE path downstream - Indication Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_KEY                                                          = 25,   /**< AE path upstream - key */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT                                                         = 26,   /**< AE path upstream - stat */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_BYTES                                               = 27,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES                                              = 28,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_64                                           = 29,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_65_127                                       = 30,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_128_255                                      = 31,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_256_511                                      = 32,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_512_1023                                     = 33,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_1024_1518                                    = 34,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_1519_2047                                    = 35,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_2048_4095                                    = 36,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_4096_9216                                    = 37,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FRAMES_9217_16383                                   = 38,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_BROADCAST_FRAMES                                    = 39,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_DATA_BYTES                                          = 40,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_MULTICAST_FRAMES                                    = 41,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_UNICAST_FRAMES                                      = 42,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_ABORT_FRAMES                                        = 43,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_FCS_ERROR                                           = 44,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_OVERSIZE_ERROR                                      = 45,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_CFG_RUNT_ERROR                                          = 46,   /**< AE path upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_ALARM_CLEARED                                           = 47,   /**< AE path upstream - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_AE_PATH_US_STAT_ALARM_RAISED                                            = 48,   /**< AE path upstream - Stat Alarm Raised */
    BCMOLT_GROUP_ID_AE_PATH_US_AUTO_CFG                                                     = 49,   /**< AE path upstream - Indication Configuration */
    BCMOLT_GROUP_ID_CHANNEL_KEY                                                             = 50,   /**< Channel - key */
    BCMOLT_GROUP_ID_CHANNEL_CFG                                                             = 51,   /**< Channel - cfg */
    BCMOLT_GROUP_ID_DEBUG_KEY                                                               = 52,   /**< Debug - key */
    BCMOLT_GROUP_ID_DEBUG_CFG                                                               = 53,   /**< Debug - cfg */
    BCMOLT_GROUP_ID_DEBUG_CLI_OUTPUT                                                        = 54,   /**< Debug - cli_output */
    BCMOLT_GROUP_ID_DEBUG_FILE_ALMOST_FULL                                                  = 55,   /**< Debug - file_almost_full */
    BCMOLT_GROUP_ID_DEBUG_AUTO_CFG                                                          = 56,   /**< Debug - Indication Configuration */
    BCMOLT_GROUP_ID_DEBUG_CLI_INPUT                                                         = 57,   /**< Debug - CLI_input */
    BCMOLT_GROUP_ID_DEBUG_RESET_API_CAPTURE                                                 = 58,   /**< Debug - Reset API Capture */
    BCMOLT_GROUP_ID_DEBUG_START_API_CAPTURE                                                 = 59,   /**< Debug - Start API Capture */
    BCMOLT_GROUP_ID_DEBUG_STOP_API_CAPTURE                                                  = 60,   /**< Debug - Stop API Capture */
    BCMOLT_GROUP_ID_DEVICE_KEY                                                              = 61,   /**< Device - key */
    BCMOLT_GROUP_ID_DEVICE_CFG                                                              = 62,   /**< Device - cfg */
    BCMOLT_GROUP_ID_DEVICE_CONNECTION_COMPLETE                                              = 63,   /**< Device - Connection Complete */
    BCMOLT_GROUP_ID_DEVICE_CONNECTION_ESTABLISHED                                           = 64,   /**< Device - Connection Established (Internal) */
    BCMOLT_GROUP_ID_DEVICE_CONNECTION_FAILURE                                               = 65,   /**< Device - Connection Failure */
    BCMOLT_GROUP_ID_DEVICE_DDR_TEST_COMPLETE                                                = 66,   /**< Device - DDR Test Complete */
    BCMOLT_GROUP_ID_DEVICE_DEVICE_KEEP_ALIVE                                                = 67,   /**< Device - Device Keep Alive (Internal) */
    BCMOLT_GROUP_ID_DEVICE_DEVICE_READY                                                     = 68,   /**< Device - Device Ready (Internal) */
    BCMOLT_GROUP_ID_DEVICE_DISCONNECTION_COMPLETE                                           = 69,   /**< Device - Disconnection Complete */
    BCMOLT_GROUP_ID_DEVICE_IMAGE_TRANSFER_COMPLETE                                          = 70,   /**< Device - Image Transfer Complete */
    BCMOLT_GROUP_ID_DEVICE_INDICATIONS_DROPPED                                              = 71,   /**< Device - Indications Dropped */
    BCMOLT_GROUP_ID_DEVICE_SW_ERROR                                                         = 72,   /**< Device - sw error */
    BCMOLT_GROUP_ID_DEVICE_SW_EXCEPTION                                                     = 73,   /**< Device - sw exception */
    BCMOLT_GROUP_ID_DEVICE_AUTO_CFG                                                         = 74,   /**< Device - Indication Configuration */
    BCMOLT_GROUP_ID_DEVICE_CONNECT                                                          = 75,   /**< Device - Connect */
    BCMOLT_GROUP_ID_DEVICE_DISCONNECT                                                       = 76,   /**< Device - Device Disconnect */
    BCMOLT_GROUP_ID_DEVICE_HOST_KEEP_ALIVE                                                  = 77,   /**< Device - Host Keep Alive (Internal) */
    BCMOLT_GROUP_ID_DEVICE_IMAGE_TRANSFER_DATA                                              = 78,   /**< Device - Image Data Transfer Operation (Internal) */
    BCMOLT_GROUP_ID_DEVICE_IMAGE_TRANSFER_START                                             = 79,   /**< Device - Start Image Transfer Operation */
    BCMOLT_GROUP_ID_DEVICE_RESET                                                            = 80,   /**< Device - Device Reset */
    BCMOLT_GROUP_ID_DEVICE_RUN_DDR_TEST                                                     = 81,   /**< Device - Run DDR Test */
    BCMOLT_GROUP_ID_DEVICE_SW_UPGRADE_ACTIVATE                                              = 82,   /**< Device - SW upgrade activate */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_KEY                                                    = 83,   /**< EPON Denied Link - key */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_CFG                                                    = 84,   /**< EPON Denied Link - cfg */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_LASER_ON_OFF_VIOLATION                                 = 85,   /**< EPON Denied Link - Laser On/Off Violation */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_LLID_POOL_EMPTY_VIOLATION                              = 86,   /**< EPON Denied Link - LLID Pool Empty Violation */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_MAX_LINK_VIOLATION                                     = 87,   /**< EPON Denied Link - Max Link Violation */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_OVERHEAD_PROFILE_VIOLATION                             = 88,   /**< EPON Denied Link - Overhead Profile Violation */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_RANGE_VIOLATION                                        = 89,   /**< EPON Denied Link - Range Violation */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_ROGUE_VIOLATION                                        = 90,   /**< EPON Denied Link - Rogue ONU Detected */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_SYSTEM_RESOURCE_VIOLATION                              = 91,   /**< EPON Denied Link - System Resource Violation */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_TDM_CHANNELS_EXHAUSTED                                 = 92,   /**< EPON Denied Link - TDM Channels Exhausted */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_UNKNOWN_LINK_VIOLATION                                 = 93,   /**< EPON Denied Link - Unknown Link Violation */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_UPSTREAM_BANDWIDTH_VIOLATION                           = 94,   /**< EPON Denied Link - Upstream Bandwidth Violation */
    BCMOLT_GROUP_ID_EPON_DENIED_LINK_AUTO_CFG                                               = 95,   /**< EPON Denied Link - Indication Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_KEY                                                           = 96,   /**< EPON link - key */
    BCMOLT_GROUP_ID_EPON_LINK_CFG                                                           = 97,   /**< EPON link - cfg */
    BCMOLT_GROUP_ID_EPON_LINK_STAT                                                          = 98,   /**< EPON link - stat */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_DATA_BYTES                                        = 99,   /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_DATA_FRAMES                                       = 100,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_64                                         = 101,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_65_127                                     = 102,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_128_255                                    = 103,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_256_511                                    = 104,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_512_1023                                   = 105,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_1024_1518                                  = 106,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_1519_2047                                  = 107,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_2048_4095                                  = 108,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_4096_9216                                  = 109,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FRAMES_9217_16383                                 = 110,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_OAM_BYTES                                         = 111,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_OAM_FRAMES                                        = 112,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_MPCP_FRAMES                                       = 113,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_BROADCAST_FRAMES                                  = 114,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_UNICAST_FRAMES                                    = 115,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_MULTICAST_FRAMES                                  = 116,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_REPORT_FRAMES                                     = 117,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_FCS_ERROR                                         = 118,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_OVERSIZE_ERROR                                    = 119,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_RUNT_ERROR                                        = 120,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_LINE_CODE_ERROR                                   = 121,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_RX_LINE_CODE_ERROR_MAX                               = 122,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_DATA_BYTES                                        = 123,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_DATA_FRAMES                                       = 124,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_64                                         = 125,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_65_127                                     = 126,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_128_255                                    = 127,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_256_511                                    = 128,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_512_1023                                   = 129,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_1024_1518                                  = 130,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_1519_2047                                  = 131,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_2048_4095                                  = 132,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_4096_9216                                  = 133,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_FRAMES_9217_16383                                 = 134,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_OAM_BYTES                                         = 135,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_OAM_FRAMES                                        = 136,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_MPCP_FRAMES                                       = 137,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_BROADCAST_FRAMES                                  = 138,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_UNICAST_FRAMES                                    = 139,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_MULTICAST_FRAMES                                  = 140,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_CFG_TX_GATES                                             = 141,  /**< EPON link - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST                           = 142,  /**< EPON link - Duplicate MPCP Registration Request */
    BCMOLT_GROUP_ID_EPON_LINK_ENCRYPTION_ENABLED                                            = 143,  /**< EPON link - Encryption Enabled */
    BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_FAILURE                                          = 144,  /**< EPON link - Key Exchange Failure */
    BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_STARTED                                          = 145,  /**< EPON link - key_exchange_started */
    BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_STOPPED                                          = 146,  /**< EPON link - key_exchange_stopped */
    BCMOLT_GROUP_ID_EPON_LINK_LINK_DELETED                                                  = 147,  /**< EPON link - Link Deleted */
    BCMOLT_GROUP_ID_EPON_LINK_LINK_SPEED_MISMATCH                                           = 148,  /**< EPON link - Link attempted to register at a different speed */
    BCMOLT_GROUP_ID_EPON_LINK_MPCP_DEREGISTERED                                             = 149,  /**< EPON link - MPCP Deregistered */
    BCMOLT_GROUP_ID_EPON_LINK_MPCP_DISCOVERED                                               = 150,  /**< EPON link - MPCP Discovered */
    BCMOLT_GROUP_ID_EPON_LINK_MPCP_REG_ACK_TIMEOUT                                          = 151,  /**< EPON link - MPCP Reg Ack Timeout */
    BCMOLT_GROUP_ID_EPON_LINK_MPCP_REPORT_TIMEOUT                                           = 152,  /**< EPON link - MPCP Report Timeout */
    BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMEOUT                                         = 153,  /**< EPON link - OAM Keepalive Timeout */
    BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMER_STARTED                                   = 154,  /**< EPON link - OAM keepalive timer started */
    BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMER_STOPPED                                   = 155,  /**< EPON link - OAM keepalive timer stopped */
    BCMOLT_GROUP_ID_EPON_LINK_PREPROVISIONED_LINK_CREATED                                   = 156,  /**< EPON link - Preprovisioned Link Created */
    BCMOLT_GROUP_ID_EPON_LINK_PROTECTION_SWITCH_OCCURRED                                    = 157,  /**< EPON link - Protection Switch Occurred */
    BCMOLT_GROUP_ID_EPON_LINK_RANGE_VALUE_CHANGED                                           = 158,  /**< EPON link - Range Value Changed */
    BCMOLT_GROUP_ID_EPON_LINK_RERANGE_FAILURE                                               = 159,  /**< EPON link - Re-range failure */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_ALARM_CLEARED                                            = 160,  /**< EPON link - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_EPON_LINK_STAT_ALARM_RAISED                                             = 161,  /**< EPON link - Stat Alarm Raised */
    BCMOLT_GROUP_ID_EPON_LINK_STATIC_REGISTRATION_DONE                                      = 162,  /**< EPON link - Static registration done */
    BCMOLT_GROUP_ID_EPON_LINK_AUTO_CFG                                                      = 163,  /**< EPON link - Indication Configuration */
    BCMOLT_GROUP_ID_EPON_LINK_DELETE_LINK                                                   = 164,  /**< EPON link - Delete Link */
    BCMOLT_GROUP_ID_EPON_LINK_FORCE_REDISCOVERY                                             = 165,  /**< EPON link - Force Link Rediscovery */
    BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_START                                            = 166,  /**< EPON link - Key exchange start */
    BCMOLT_GROUP_ID_EPON_LINK_KEY_EXCHANGE_STOP                                             = 167,  /**< EPON link - Key exchange stop */
    BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMER_START                                     = 168,  /**< EPON link - OAM Keepalive Timer Start */
    BCMOLT_GROUP_ID_EPON_LINK_OAM_KEEPALIVE_TIMER_STOP                                      = 169,  /**< EPON link - OAM Keepalive Timer Stop */
    BCMOLT_GROUP_ID_EPON_LINK_STATIC_REGISTRATION                                           = 170,  /**< EPON link - static_registration */
    BCMOLT_GROUP_ID_EPON_LINK_INJECT_FRAME                                                  = 171,  /**< EPON link - Inject Frame */
    BCMOLT_GROUP_ID_EPON_LINK_FRAME_CAPTURED                                                = 172,  /**< EPON link - Frame Captured */
    BCMOLT_GROUP_ID_EPON_NI_KEY                                                             = 173,  /**< EPON NI (EPON Network Interface) - key */
    BCMOLT_GROUP_ID_EPON_NI_CFG                                                             = 174,  /**< EPON NI (EPON Network Interface) - cfg */
    BCMOLT_GROUP_ID_EPON_NI_AUTO_ROGUE_SCAN_10G_FAILURE                                     = 175,  /**< EPON NI (EPON Network Interface) - 10G Epon Autonomous Rogue Scan failure detected */
    BCMOLT_GROUP_ID_EPON_NI_AUTO_ROGUE_SCAN_1G_FAILURE                                      = 176,  /**< EPON NI (EPON Network Interface) - 1G Epon Autonomous Rogue Scan failure detected */
    BCMOLT_GROUP_ID_EPON_NI_LLID_QUARANTINED                                                = 177,  /**< EPON NI (EPON Network Interface) - LLID Quarantined */
    BCMOLT_GROUP_ID_EPON_NI_MPCP_TIMESTAMP_CHANGED                                          = 178,  /**< EPON NI (EPON Network Interface) - MPCP Timestamp Changed */
    BCMOLT_GROUP_ID_EPON_NI_NO_REPORTS                                                      = 179,  /**< EPON NI (EPON Network Interface) - No Reports */
    BCMOLT_GROUP_ID_EPON_NI_ONU_UPGRADE_COMPLETE                                            = 180,  /**< EPON NI (EPON Network Interface) - ONU Upgrade Complete */
    BCMOLT_GROUP_ID_EPON_NI_RERANGE_FAILURE                                                 = 181,  /**< EPON NI (EPON Network Interface) - Re-range failure */
    BCMOLT_GROUP_ID_EPON_NI_ROGUE_SCAN_COMPLETE                                             = 182,  /**< EPON NI (EPON Network Interface) - Rogue Scan is Complete */
    BCMOLT_GROUP_ID_EPON_NI_RSSI_MEASUREMENT_COMPLETED                                      = 183,  /**< EPON NI (EPON Network Interface) - RSSI Measurement Completed */
    BCMOLT_GROUP_ID_EPON_NI_STATE_CHANGE_COMPLETED                                          = 184,  /**< EPON NI (EPON Network Interface) - State Change Completed */
    BCMOLT_GROUP_ID_EPON_NI_AUTO_CFG                                                        = 185,  /**< EPON NI (EPON Network Interface) - Indication Configuration */
    BCMOLT_GROUP_ID_EPON_NI_ADD_LINK                                                        = 186,  /**< EPON NI (EPON Network Interface) - Add link */
    BCMOLT_GROUP_ID_EPON_NI_ADD_MULTICAST_LINK                                              = 187,  /**< EPON NI (EPON Network Interface) - Add Mutlticastlink */
    BCMOLT_GROUP_ID_EPON_NI_ADD_PROTECTED_STANDBY_LINK                                      = 188,  /**< EPON NI (EPON Network Interface) - Add Protected Standby Link */
    BCMOLT_GROUP_ID_EPON_NI_ISSUE_RSSI_GRANT                                                = 189,  /**< EPON NI (EPON Network Interface) - Issue an Rx Power Measurement Request */
    BCMOLT_GROUP_ID_EPON_NI_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA                        = 190,  /**< EPON NI (EPON Network Interface) - Protection switching apply re-range delta */
    BCMOLT_GROUP_ID_EPON_NI_ROGUE_LLID_SCAN                                                 = 191,  /**< EPON NI (EPON Network Interface) - Run Rogue LLID Scan */
    BCMOLT_GROUP_ID_EPON_NI_SET_EPON_NI_EN_STATE                                            = 192,  /**< EPON NI (EPON Network Interface) - Set EPON NI Enable State */
    BCMOLT_GROUP_ID_EPON_NI_START_ONU_UPGRADE                                               = 193,  /**< EPON NI (EPON Network Interface) - Start ONU Firmware Upgrade */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_KEY                                                     = 194,  /**< EPON ONU 10G US - key */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_CFG                                                     = 195,  /**< EPON ONU 10G US - cfg */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT                                                    = 196,  /**< EPON ONU 10G US - stat */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_CFG_FEC_CODE_WORDS_TOTAL                           = 197,  /**< EPON ONU 10G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_CFG_FEC_CODE_WORDS_DECODE_FAILS                    = 198,  /**< EPON ONU 10G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_CFG_FEC_ZEROES_CORRECTED                           = 199,  /**< EPON ONU 10G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_CFG_FEC_ONES_CORRECTED                             = 200,  /**< EPON ONU 10G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_ALARM_CLEARED                                      = 201,  /**< EPON ONU 10G US - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_STAT_ALARM_RAISED                                       = 202,  /**< EPON ONU 10G US - Stat Alarm Raised */
    BCMOLT_GROUP_ID_EPON_ONU_10G_US_AUTO_CFG                                                = 203,  /**< EPON ONU 10G US - Indication Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_KEY                                                      = 204,  /**< EPON ONU 1G US - key */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_CFG                                                      = 205,  /**< EPON ONU 1G US - cfg */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT                                                     = 206,  /**< EPON ONU 1G US - stat */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_GOOD_FRAMES                                     = 207,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_GOOD_BYTES                                      = 208,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_OVERSZ_FRAMES                                   = 209,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_NON_FEC_GOOD_FRAMES                             = 210,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_NON_FEC_GOOD_BYTES                              = 211,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_GOOD_FRAMES                                 = 212,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_GOOD_BYTES                                  = 213,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_FRAMES_EXC_ERRS                             = 214,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_BLKS_NO_ERRS                                = 215,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_BLKS_CORR_ERRS                              = 216,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_BLKS_UNCORR_ERRS                            = 217,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_CORR_BYTES                                  = 218,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_CORR_ZEROES                                 = 219,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_FEC_CORR_ONES                                   = 220,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_UNDERSZ_FRAMES                                  = 221,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_CFG_ERRORSZ_FRAMES                                  = 222,  /**< EPON ONU 1G US - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_ALARM_CLEARED                                       = 223,  /**< EPON ONU 1G US - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_STAT_ALARM_RAISED                                        = 224,  /**< EPON ONU 1G US - Stat Alarm Raised */
    BCMOLT_GROUP_ID_EPON_ONU_1G_US_AUTO_CFG                                                 = 225,  /**< EPON ONU 1G US - Indication Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_KEY                                                    = 226,  /**< EPON path 10G downstream - key */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_CFG                                                    = 227,  /**< EPON path 10G downstream - cfg */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT                                                   = 228,  /**< EPON path 10G downstream - stat */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_BYTES                                         = 229,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES                                        = 230,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_64                                     = 231,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_65_127                                 = 232,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_128_255                                = 233,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_256_511                                = 234,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_512_1023                               = 235,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_1024_1518                              = 236,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_1519_2047                              = 237,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_2048_4095                              = 238,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_4096_9216                              = 239,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_FRAMES_9217_16383                             = 240,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_BROADCAST_FRAMES                              = 241,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_DATA_BYTES                                    = 242,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_MULTICAST_FRAMES                              = 243,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_UNICAST_FRAMES                                = 244,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_OAM_BYTES                                     = 245,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_OAM_FRAMES                                    = 246,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_GATE_FRAMES                                   = 247,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_MPCP_FRAMES                                   = 248,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_CFG_ABORT_FRAMES                                  = 249,  /**< EPON path 10G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_ALARM_CLEARED                                     = 250,  /**< EPON path 10G downstream - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_STAT_ALARM_RAISED                                      = 251,  /**< EPON path 10G downstream - Stat Alarm Raised */
    BCMOLT_GROUP_ID_EPON_PATH_10G_DS_AUTO_CFG                                               = 252,  /**< EPON path 10G downstream - Indication Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_KEY                                                    = 253,  /**< EPON path 10G upstream - key */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_CFG                                                    = 254,  /**< EPON path 10G upstream - cfg */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT                                                   = 255,  /**< EPON path 10G upstream - stat */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_BYTES                                         = 256,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES                                        = 257,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_64                                     = 258,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_65_127                                 = 259,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_128_255                                = 260,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_256_511                                = 261,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_512_1023                               = 262,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_1024_1518                              = 263,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_1519_2047                              = 264,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_2048_4095                              = 265,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_4096_9216                              = 266,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FRAMES_9217_16383                             = 267,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_BROADCAST_FRAMES                              = 268,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_DATA_BYTES                                    = 269,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_MULTICAST_FRAMES                              = 270,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_UNICAST_FRAMES                                = 271,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_MPCP_FRAMES                                   = 272,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_OAM_BYTES                                     = 273,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_OAM_FRAMES                                    = 274,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_REPORT_FRAMES                                 = 275,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_ABORT_FRAMES                                  = 276,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_FCS_ERROR                                     = 277,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_CRC_8_ERROR                                   = 278,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_OUT_OF_SLOT                                   = 279,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_OVERSIZE_ERROR                                = 280,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_CFG_RUNT_ERROR                                    = 281,  /**< EPON path 10G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_ALARM_CLEARED                                     = 282,  /**< EPON path 10G upstream - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_STAT_ALARM_RAISED                                      = 283,  /**< EPON path 10G upstream - Stat Alarm Raised */
    BCMOLT_GROUP_ID_EPON_PATH_10G_US_AUTO_CFG                                               = 284,  /**< EPON path 10G upstream - Indication Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_KEY                                                     = 285,  /**< EPON path 1G downstream - key */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_CFG                                                     = 286,  /**< EPON path 1G downstream - cfg */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT                                                    = 287,  /**< EPON path 1G downstream - stat */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_BYTES                                          = 288,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES                                         = 289,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_64                                      = 290,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_65_127                                  = 291,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_128_255                                 = 292,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_256_511                                 = 293,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_512_1023                                = 294,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_1024_1518                               = 295,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_1519_2047                               = 296,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_2048_4095                               = 297,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_4096_9216                               = 298,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_FRAMES_9217_16383                              = 299,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_BROADCAST_FRAMES                               = 300,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_DATA_BYTES                                     = 301,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_MULTICAST_FRAMES                               = 302,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_UNICAST_FRAMES                                 = 303,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_OAM_BYTES                                      = 304,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_OAM_FRAMES                                     = 305,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_GATE_FRAMES                                    = 306,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_MPCP_FRAMES                                    = 307,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_CFG_ABORT_FRAMES                                   = 308,  /**< EPON path 1G downstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_ALARM_CLEARED                                      = 309,  /**< EPON path 1G downstream - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_STAT_ALARM_RAISED                                       = 310,  /**< EPON path 1G downstream - Stat Alarm Raised */
    BCMOLT_GROUP_ID_EPON_PATH_1G_DS_AUTO_CFG                                                = 311,  /**< EPON path 1G downstream - Indication Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_KEY                                                     = 312,  /**< EPON path 1G upstream - key */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_CFG                                                     = 313,  /**< EPON path 1G upstream - cfg */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT                                                    = 314,  /**< EPON path 1G upstream - stat */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_BYTES                                          = 315,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES                                         = 316,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_64                                      = 317,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_65_127                                  = 318,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_128_255                                 = 319,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_256_511                                 = 320,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_512_1023                                = 321,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_1024_1518                               = 322,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_1519_2047                               = 323,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_2048_4095                               = 324,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_4096_9216                               = 325,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FRAMES_9217_16383                              = 326,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_BROADCAST_FRAMES                               = 327,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_DATA_BYTES                                     = 328,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_MULTICAST_FRAMES                               = 329,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_UNICAST_FRAMES                                 = 330,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_MPCP_FRAMES                                    = 331,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_OAM_BYTES                                      = 332,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_OAM_FRAMES                                     = 333,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_REPORT_FRAMES                                  = 334,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_ABORT_FRAMES                                   = 335,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_FCS_ERROR                                      = 336,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_CRC_8_ERROR                                    = 337,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_OUT_OF_SLOT                                    = 338,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_OVERSIZE_ERROR                                 = 339,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_CFG_RUNT_ERROR                                     = 340,  /**< EPON path 1G upstream - Statistic Configuration */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_ALARM_CLEARED                                      = 341,  /**< EPON path 1G upstream - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_STAT_ALARM_RAISED                                       = 342,  /**< EPON path 1G upstream - Stat Alarm Raised */
    BCMOLT_GROUP_ID_EPON_PATH_1G_US_AUTO_CFG                                                = 343,  /**< EPON path 1G upstream - Indication Configuration */
    BCMOLT_GROUP_ID_EPON_RP_KEY                                                             = 344,  /**< EPON Reconciliation Path - key */
    BCMOLT_GROUP_ID_EPON_RP_CFG                                                             = 345,  /**< EPON Reconciliation Path - cfg */
    BCMOLT_GROUP_ID_GPIO_KEY                                                                = 346,  /**< GPIO - key */
    BCMOLT_GROUP_ID_GPIO_CFG                                                                = 347,  /**< GPIO - cfg */
    BCMOLT_GROUP_ID_GPON_ALLOC_KEY                                                          = 348,  /**< GPON Alloc - key */
    BCMOLT_GROUP_ID_GPON_ALLOC_CFG                                                          = 349,  /**< GPON Alloc - cfg */
    BCMOLT_GROUP_ID_GPON_ALLOC_STAT                                                         = 350,  /**< GPON Alloc - stat */
    BCMOLT_GROUP_ID_GPON_ALLOC_STAT_CFG_RX_BYTES                                            = 351,  /**< GPON Alloc - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ALLOC_CONFIGURATION_COMPLETED                                      = 352,  /**< GPON Alloc - Configuration Completed */
    BCMOLT_GROUP_ID_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED                                    = 353,  /**< GPON Alloc - Get alloc ID statistics completed */
    BCMOLT_GROUP_ID_GPON_ALLOC_STAT_ALARM_CLEARED                                           = 354,  /**< GPON Alloc - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_GPON_ALLOC_STAT_ALARM_RAISED                                            = 355,  /**< GPON Alloc - Stat Alarm Raised */
    BCMOLT_GROUP_ID_GPON_ALLOC_AUTO_CFG                                                     = 356,  /**< GPON Alloc - Indication Configuration */
    BCMOLT_GROUP_ID_GPON_ALLOC_GET_STATS                                                    = 357,  /**< GPON Alloc - Get statistics */
    BCMOLT_GROUP_ID_GPON_ALLOC_SET_STATE                                                    = 358,  /**< GPON Alloc - Set state */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_KEY                                                       = 359,  /**< GPON GEM Port - key */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_CFG                                                       = 360,  /**< GPON GEM Port - cfg */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT                                                      = 361,  /**< GPON GEM Port - stat */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_CFG_RX_PACKETS                                       = 362,  /**< GPON GEM Port - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_CFG_RX_BYTES                                         = 363,  /**< GPON GEM Port - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_CFG_TX_PACKETS                                       = 364,  /**< GPON GEM Port - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_CFG_TX_BYTES                                         = 365,  /**< GPON GEM Port - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_CONFIGURATION_COMPLETED                                   = 366,  /**< GPON GEM Port - Configuration Completed */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_ALARM_CLEARED                                        = 367,  /**< GPON GEM Port - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_STAT_ALARM_RAISED                                         = 368,  /**< GPON GEM Port - Stat Alarm Raised */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_AUTO_CFG                                                  = 369,  /**< GPON GEM Port - Indication Configuration */
    BCMOLT_GROUP_ID_GPON_GEM_PORT_SET_STATE                                                 = 370,  /**< GPON GEM Port - Set state */
    BCMOLT_GROUP_ID_GPON_IWF_KEY                                                            = 371,  /**< GPON IWF - key */
    BCMOLT_GROUP_ID_GPON_IWF_CFG                                                            = 372,  /**< GPON IWF - cfg */
    BCMOLT_GROUP_ID_GPON_IWF_STAT                                                           = 373,  /**< GPON IWF - stat */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_HIT_EVENT                                          = 374,  /**< GPON IWF - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_MISS_EVENT                                         = 375,  /**< GPON IWF - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_DROP_DUE_TO_MISS_EVENT                             = 376,  /**< GPON IWF - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_DROP_DUE_TO_HIT_EVENT                              = 377,  /**< GPON IWF - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_DS_DROP_TO_DISABLED_GEM                               = 378,  /**< GPON IWF - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_NEW_MAC_DISCOVERED                                    = 379,  /**< GPON IWF - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_MOVE_EVENT                                            = 380,  /**< GPON IWF - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_CFG_NEW_MAC_DROP_DUE_TO_FIFO_FULL                         = 381,  /**< GPON IWF - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_FLUSH_MAC_TABLE_COMPLETED                                      = 382,  /**< GPON IWF - Flush MAC Table Completed */
    BCMOLT_GROUP_ID_GPON_IWF_SCAN_MAC_TABLE_COMPLETED                                       = 383,  /**< GPON IWF - Scan MAC Table Completed */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_ALARM_CLEARED                                             = 384,  /**< GPON IWF - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_GPON_IWF_STAT_ALARM_RAISED                                              = 385,  /**< GPON IWF - Stat Alarm Raised */
    BCMOLT_GROUP_ID_GPON_IWF_AUTO_CFG                                                       = 386,  /**< GPON IWF - Indication Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_FLUSH_MAC_TABLE                                                = 387,  /**< GPON IWF - Flush MAC Table */
    BCMOLT_GROUP_ID_GPON_IWF_SCAN_MAC_TABLE                                                 = 388,  /**< GPON IWF - Scan MAC Table */
    BCMOLT_GROUP_ID_GPON_IWF_DS_EGRESS_FLOW_KEY                                             = 389,  /**< GPON IWF DS egress flow - key */
    BCMOLT_GROUP_ID_GPON_IWF_DS_EGRESS_FLOW_CFG                                             = 390,  /**< GPON IWF DS egress flow - cfg */
    BCMOLT_GROUP_ID_GPON_IWF_DS_INGRESS_FLOW_KEY                                            = 391,  /**< GPON IWF DS ingress flow - key */
    BCMOLT_GROUP_ID_GPON_IWF_DS_INGRESS_FLOW_CFG                                            = 392,  /**< GPON IWF DS ingress flow - cfg */
    BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_KEY                                                  = 393,  /**< GPON IWF MAC table - key */
    BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_CFG                                                  = 394,  /**< GPON IWF MAC table - cfg */
    BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_MAC_AGED                                             = 395,  /**< GPON IWF MAC table - MAC Aged */
    BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_MAC_DROPPED                                          = 396,  /**< GPON IWF MAC table - MAC Dropped */
    BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_MAC_MOVE                                             = 397,  /**< GPON IWF MAC table - MAC Move */
    BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_NEW_MAC                                              = 398,  /**< GPON IWF MAC table - New MAC */
    BCMOLT_GROUP_ID_GPON_IWF_MAC_TABLE_AUTO_CFG                                             = 399,  /**< GPON IWF MAC table - Indication Configuration */
    BCMOLT_GROUP_ID_GPON_IWF_US_FLOW_KEY                                                    = 400,  /**< GPON IWF US flow - key */
    BCMOLT_GROUP_ID_GPON_IWF_US_FLOW_CFG                                                    = 401,  /**< GPON IWF US flow - cfg */
    BCMOLT_GROUP_ID_GPON_NI_KEY                                                             = 402,  /**< GPON network interface - key */
    BCMOLT_GROUP_ID_GPON_NI_CFG                                                             = 403,  /**< GPON network interface - cfg */
    BCMOLT_GROUP_ID_GPON_NI_STAT                                                            = 404,  /**< GPON network interface - stat */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_FEC_CODEWORDS                                          = 405,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_FEC_CODEWORDS_UNCORRECTED                              = 406,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_BIP8_BYTES                                             = 407,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_BIP8_ERRORS                                            = 408,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_PACKETS                                         = 409,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_DROPPED                                         = 410,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_IDLE                                            = 411,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_CORRECTED                                       = 412,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_GEM_ILLEGAL                                         = 413,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_ALLOCATIONS_VALID                                   = 414,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_ALLOCATIONS_INVALID                                 = 415,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_ALLOCATIONS_DISABLED                                = 416,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PLOAMS                                              = 417,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PLOAMS_NON_IDLE                                     = 418,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PLOAMS_ERROR                                        = 419,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PLOAMS_DROPPED                                      = 420,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_CPU                                                 = 421,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_OMCI                                                = 422,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_OMCI_PACKETS_CRC_ERROR                              = 423,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_DROPPED_TOO_SHORT                                   = 424,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_DROPPED_TOO_LONG                                    = 425,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_CRC_ERRORS                                          = 426,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_KEY_ERRORS                                          = 427,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_FRAGMENTS_ERRORS                                    = 428,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_RX_PACKETS_DROPPED                                     = 429,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_GEM                                                 = 430,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_PLOAMS                                              = 431,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_GEM_FRAGMENTS                                       = 432,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_CPU                                                 = 433,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_OMCI                                                = 434,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_CPU_OMCI_PACKETS_DROPPED                            = 435,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_DROPPED_ILLEGAL_LENGTH                              = 436,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_DROPPED_TPID_MISS                                   = 437,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_STAT_CFG_TX_DROPPED_VID_MISS                                    = 438,  /**< GPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_NI_ACTIVATE_ALL_ONUS_COMPLETED                                     = 439,  /**< GPON network interface - activate all onus completed */
    BCMOLT_GROUP_ID_GPON_NI_CPU_PACKETS_FAILURE                                             = 440,  /**< GPON network interface - CPU Packets Failure */
    BCMOLT_GROUP_ID_GPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED                                   = 441,  /**< GPON network interface - deactivate all onus completed */
    BCMOLT_GROUP_ID_GPON_NI_DISABLE_ALL_ONUS_COMPLETED                                      = 442,  /**< GPON network interface - disable all onus completed */
    BCMOLT_GROUP_ID_GPON_NI_ENABLE_ALL_ONUS_COMPLETED                                       = 443,  /**< GPON network interface - enable all onus completed */
    BCMOLT_GROUP_ID_GPON_NI_LOS                                                             = 444,  /**< GPON network interface - LOS */
    BCMOLT_GROUP_ID_GPON_NI_ONU_DISCOVERED                                                  = 445,  /**< GPON network interface - ONU Discovered */
    BCMOLT_GROUP_ID_GPON_NI_ONU_UPGRADE_COMPLETE                                            = 446,  /**< GPON network interface - ONU Upgrade Complete */
    BCMOLT_GROUP_ID_GPON_NI_PROTECTION_SWITCHING_ONUS_RANGED                                = 447,  /**< GPON network interface - Protection Switching ONUs Ranged */
    BCMOLT_GROUP_ID_GPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED                       = 448,  /**< GPON network interface - Protection Switching Switchover Completed */
    BCMOLT_GROUP_ID_GPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME                             = 449,  /**< GPON network interface - Protection Switching Traffic Resume */
    BCMOLT_GROUP_ID_GPON_NI_ROGUE_DETECTION_COMPLETED                                       = 450,  /**< GPON network interface - Rogue detection completed */
    BCMOLT_GROUP_ID_GPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START                               = 451,  /**< GPON network interface - Rogue ONU special map cycle start */
    BCMOLT_GROUP_ID_GPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START                           = 452,  /**< GPON network interface - Serial Number Acquisition Cycle Start */
    BCMOLT_GROUP_ID_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED                          = 453,  /**< GPON network interface - Standby PON Monitoring Cycle Completed */
    BCMOLT_GROUP_ID_GPON_NI_STAT_ALARM_CLEARED                                              = 454,  /**< GPON network interface - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_GPON_NI_STAT_ALARM_RAISED                                               = 455,  /**< GPON network interface - Stat Alarm Raised */
    BCMOLT_GROUP_ID_GPON_NI_STATE_CHANGE_COMPLETED                                          = 456,  /**< GPON network interface - State Change Completed */
    BCMOLT_GROUP_ID_GPON_NI_TOD_REQUEST_COMPLETED                                           = 457,  /**< GPON network interface - TOD request completed */
    BCMOLT_GROUP_ID_GPON_NI_AUTO_CFG                                                        = 458,  /**< GPON network interface - Indication Configuration */
    BCMOLT_GROUP_ID_GPON_NI_DISABLE_SERIAL_NUMBER                                           = 459,  /**< GPON network interface - Disable Serial Number */
    BCMOLT_GROUP_ID_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE              = 460,  /**< GPON network interface - protection switching type c set multiple onu state */
    BCMOLT_GROUP_ID_GPON_NI_RESET                                                           = 461,  /**< GPON network interface - Reset */
    BCMOLT_GROUP_ID_GPON_NI_ROGUE_DETECTION_WINDOW                                          = 462,  /**< GPON network interface - Rogue Detection Window */
    BCMOLT_GROUP_ID_GPON_NI_SET_ONU_STATE                                                   = 463,  /**< GPON network interface - Set ONU State */
    BCMOLT_GROUP_ID_GPON_NI_SET_PON_STATE                                                   = 464,  /**< GPON network interface - Set PON State */
    BCMOLT_GROUP_ID_GPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING                           = 465,  /**< GPON network interface - Single request for standby PON monitoring */
    BCMOLT_GROUP_ID_GPON_NI_START_ONU_UPGRADE                                               = 466,  /**< GPON network interface - Start ONU Firmware Upgrade */
    BCMOLT_GROUP_ID_GPON_NI_TOD_REQUEST                                                     = 467,  /**< GPON network interface - TOD request */
    BCMOLT_GROUP_ID_GPON_NI_BROADCAST_PLOAM_PACKET                                          = 468,  /**< GPON network interface - Broadcast PLOAM Packet */
    BCMOLT_GROUP_ID_GPON_NI_CPU_PACKETS                                                     = 469,  /**< GPON network interface - GPON CPU Packets */
    BCMOLT_GROUP_ID_GPON_ONU_KEY                                                            = 470,  /**< GPON ONU - key */
    BCMOLT_GROUP_ID_GPON_ONU_CFG                                                            = 471,  /**< GPON ONU - cfg */
    BCMOLT_GROUP_ID_GPON_ONU_STAT                                                           = 472,  /**< GPON ONU - stat */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_FEC_CODEWORDS                                         = 473,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_FEC_BYTES_CORRECTED                                   = 474,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_FEC_CODEWORDS_CORRECTED                               = 475,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_FEC_CODEWORDS_UNCORRECTED                             = 476,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_BIP8_BYTES                                            = 477,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_BIP8_ERRORS                                           = 478,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_PLOAMS_CRC_ERROR                                   = 479,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_PLOAMS_NON_IDLE                                    = 480,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_POSITIVE_DRIFT                                        = 481,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_NEGATIVE_DRIFT                                        = 482,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_OMCI                                               = 483,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_OMCI_PACKETS_CRC_ERROR                             = 484,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_BER_REPORTED                                          = 485,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_UNRECEIVED_BURST                                      = 486,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_LCDG_ERRORS                                           = 487,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RDI_ERRORS                                            = 488,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_BYTES                                              = 489,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_RX_PACKETS                                            = 490,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_TX_BYTES                                              = 491,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_CFG_TX_PACKETS                                            = 492,  /**< GPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED                           = 493,  /**< GPON ONU - BER Interval Configuration Completed */
    BCMOLT_GROUP_ID_GPON_ONU_DFI                                                            = 494,  /**< GPON ONU - Receive Dying-Gasp of ONUi */
    BCMOLT_GROUP_ID_GPON_ONU_DGI                                                            = 495,  /**< GPON ONU - Receive Dying-Gasp of ONUi */
    BCMOLT_GROUP_ID_GPON_ONU_DOWI                                                           = 496,  /**< GPON ONU - Drift of Window of ONUi */
    BCMOLT_GROUP_ID_GPON_ONU_ERR                                                            = 497,  /**< GPON ONU - ERR */
    BCMOLT_GROUP_ID_GPON_ONU_INVALID_DBRU_REPORT                                            = 498,  /**< GPON ONU - Invalid DBRu Report */
    BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_COMPLETED                                         = 499,  /**< GPON ONU - Key Exchange Completed */
    BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED                                     = 500,  /**< GPON ONU - Key Exchange Cycle Skipped */
    BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_DECRYPT_REQUIRED                                  = 501,  /**< GPON ONU - Key Exchange Decrypt Required */
    BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH                                      = 502,  /**< GPON ONU - Key Exchange Key Mismatch */
    BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT                               = 503,  /**< GPON ONU - Key Exchange Key Request Timeout */
    BCMOLT_GROUP_ID_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX                               = 504,  /**< GPON ONU - Key Exchange Unconsecutive Index */
    BCMOLT_GROUP_ID_GPON_ONU_LOAI                                                           = 505,  /**< GPON ONU - LOAi */
    BCMOLT_GROUP_ID_GPON_ONU_LOKI                                                           = 506,  /**< GPON ONU - LOki */
    BCMOLT_GROUP_ID_GPON_ONU_MEMI                                                           = 507,  /**< GPON ONU - MEMi */
    BCMOLT_GROUP_ID_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED                           = 508,  /**< GPON ONU - OMCI PORT ID Configuration Completed */
    BCMOLT_GROUP_ID_GPON_ONU_ONU_ACTIVATION_COMPLETED                                       = 509,  /**< GPON ONU - ONU Activation Completed */
    BCMOLT_GROUP_ID_GPON_ONU_ONU_ACTIVATION_STANDBY_COMPLETED                               = 510,  /**< GPON ONU - onu activation standby completed */
    BCMOLT_GROUP_ID_GPON_ONU_ONU_ALARM                                                      = 511,  /**< GPON ONU - ONU Alarm */
    BCMOLT_GROUP_ID_GPON_ONU_ONU_DEACTIVATION_COMPLETED                                     = 512,  /**< GPON ONU - ONU Deactivation Completed */
    BCMOLT_GROUP_ID_GPON_ONU_ONU_DISABLE_COMPLETED                                          = 513,  /**< GPON ONU - ONU Disable Completed */
    BCMOLT_GROUP_ID_GPON_ONU_ONU_ENABLE_COMPLETED                                           = 514,  /**< GPON ONU - ONU Enable Completed */
    BCMOLT_GROUP_ID_GPON_ONU_OPTICAL_REFLECTION                                             = 515,  /**< GPON ONU - Optical Reflection */
    BCMOLT_GROUP_ID_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED                              = 516,  /**< GPON ONU - Password Authentication Completed */
    BCMOLT_GROUP_ID_GPON_ONU_PEE                                                            = 517,  /**< GPON ONU - PEE */
    BCMOLT_GROUP_ID_GPON_ONU_POSSIBLE_DRIFT                                                 = 518,  /**< GPON ONU - Possible Drift */
    BCMOLT_GROUP_ID_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE                                  = 519,  /**< GPON ONU - Power Management State Change */
    BCMOLT_GROUP_ID_GPON_ONU_PST                                                            = 520,  /**< GPON ONU - PST */
    BCMOLT_GROUP_ID_GPON_ONU_RANGING_COMPLETED                                              = 521,  /**< GPON ONU - Ranging Completed */
    BCMOLT_GROUP_ID_GPON_ONU_REI                                                            = 522,  /**< GPON ONU - REI */
    BCMOLT_GROUP_ID_GPON_ONU_RSSI_MEASUREMENT_COMPLETED                                     = 523,  /**< GPON ONU - RSSI Measurement Completed */
    BCMOLT_GROUP_ID_GPON_ONU_SDI                                                            = 524,  /**< GPON ONU - Signal Degraded of ONUi */
    BCMOLT_GROUP_ID_GPON_ONU_SFI                                                            = 525,  /**< GPON ONU - Signal Fail of ONUi */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_ALARM_CLEARED                                             = 526,  /**< GPON ONU - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_GPON_ONU_STAT_ALARM_RAISED                                              = 527,  /**< GPON ONU - Stat Alarm Raised */
    BCMOLT_GROUP_ID_GPON_ONU_SUFI                                                           = 528,  /**< GPON ONU - SUFi */
    BCMOLT_GROUP_ID_GPON_ONU_TIWI                                                           = 529,  /**< GPON ONU - Transmission Interference Warning */
    BCMOLT_GROUP_ID_GPON_ONU_AUTO_CFG                                                       = 530,  /**< GPON ONU - Indication Configuration */
    BCMOLT_GROUP_ID_GPON_ONU_CHANGE_POWER_LEVEL                                             = 531,  /**< GPON ONU - Change Power Level */
    BCMOLT_GROUP_ID_GPON_ONU_RSSI_MEASUREMENT                                               = 532,  /**< GPON ONU - RSSI Measurement */
    BCMOLT_GROUP_ID_GPON_ONU_SET_ONU_STATE                                                  = 533,  /**< GPON ONU - Set ONU State */
    BCMOLT_GROUP_ID_GPON_ONU_CPU_PACKETS                                                    = 534,  /**< GPON ONU - GPON CPU Packets */
    BCMOLT_GROUP_ID_GPON_ONU_PLOAM_PACKET                                                   = 535,  /**< GPON ONU - PLOAM Packet */
    BCMOLT_GROUP_ID_GPON_ONU_CPU_PACKET                                                     = 536,  /**< GPON ONU - GPON CPU packet */
    BCMOLT_GROUP_ID_GPON_ONU_OMCI_PACKET                                                    = 537,  /**< GPON ONU - GPON OMCI packet */
    BCMOLT_GROUP_ID_GPON_TRX_KEY                                                            = 538,  /**< GPON TRX - key */
    BCMOLT_GROUP_ID_GPON_TRX_CFG                                                            = 539,  /**< GPON TRX - cfg */
    BCMOLT_GROUP_ID_LOG_ENTRY_KEY                                                           = 540,  /**< log entry - key */
    BCMOLT_GROUP_ID_LOG_ENTRY_CFG                                                           = 541,  /**< log entry - cfg */
    BCMOLT_GROUP_ID_LOG_ENTRY_STAT                                                          = 542,  /**< log entry - stat */
    BCMOLT_GROUP_ID_LOG_ENTRY_STAT_CFG_MSG_COUNT                                            = 543,  /**< log entry - Statistic Configuration */
    BCMOLT_GROUP_ID_LOG_ENTRY_STAT_CFG_LOST_MSG_COUNT                                       = 544,  /**< log entry - Statistic Configuration */
    BCMOLT_GROUP_ID_LOG_ENTRY_STAT_ALARM_CLEARED                                            = 545,  /**< log entry - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_LOG_ENTRY_STAT_ALARM_RAISED                                             = 546,  /**< log entry - Stat Alarm Raised */
    BCMOLT_GROUP_ID_LOG_ENTRY_AUTO_CFG                                                      = 547,  /**< log entry - Indication Configuration */
    BCMOLT_GROUP_ID_LOGGER_KEY                                                              = 548,  /**< logger - key */
    BCMOLT_GROUP_ID_LOGGER_CFG                                                              = 549,  /**< logger - cfg */
    BCMOLT_GROUP_ID_LOGGER_STAT                                                             = 550,  /**< logger - stat */
    BCMOLT_GROUP_ID_LOGGER_STAT_CFG_LINES_IN_LOG                                            = 551,  /**< logger - Statistic Configuration */
    BCMOLT_GROUP_ID_LOGGER_STAT_ALARM_CLEARED                                               = 552,  /**< logger - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_LOGGER_STAT_ALARM_RAISED                                                = 553,  /**< logger - Stat Alarm Raised */
    BCMOLT_GROUP_ID_LOGGER_AUTO_CFG                                                         = 554,  /**< logger - Indication Configuration */
    BCMOLT_GROUP_ID_LOGGER_CLEAR_LOG                                                        = 555,  /**< logger - clear log */
    BCMOLT_GROUP_ID_NNI_KEY                                                                 = 556,  /**< NNI - key */
    BCMOLT_GROUP_ID_NNI_CFG                                                                 = 557,  /**< NNI - cfg */
    BCMOLT_GROUP_ID_NNI_STAT                                                                = 558,  /**< NNI - stat */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_64                                               = 559,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_65_127                                           = 560,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_128_255                                          = 561,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_256_511                                          = 562,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_512_1023                                         = 563,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_1024_1518                                        = 564,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_1519_2047                                        = 565,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_2048_4095                                        = 566,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_4096_9216                                        = 567,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES_9217_16383                                       = 568,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAMES                                                  = 569,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_BYTES                                                   = 570,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_GOOD_FRAMES                                             = 571,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_UNICAST_FRAMES                                          = 572,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_MULTICAST_FRAMES                                        = 573,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_BROADCAST_FRAMES                                        = 574,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FCS_ERRORS                                              = 575,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_CONTROL_FRAMES                                          = 576,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_PAUSE_FRAMES                                            = 577,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_PFC_FRAMES                                              = 578,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_UNSUPPORTED_OPCODE                                      = 579,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_UNSUPPORTED_DA                                          = 580,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_ALIGNMENT_ERRORS                                        = 581,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_LENGTH_OUT_OF_RANGE                                     = 582,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_CODE_ERRORS                                             = 583,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_OVERSIZED_FRAMES                                        = 584,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_JABBER_FRAMES                                           = 585,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_MTU_CHECK_ERRORS                                        = 586,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_PROMISCUOUS_FRAMES                                      = 587,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_VLAN_FRAMES                                             = 588,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_DOUBLE_VLAN_FRAMES                                      = 589,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_TRUNCATED_FRAMES                                        = 590,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_UNDERSIZE_FRAMES                                        = 591,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_FRAGMENTED_FRAMES                                       = 592,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_RX_RUNT_FRAMES                                             = 593,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_64                                               = 594,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_65_127                                           = 595,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_128_255                                          = 596,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_256_511                                          = 597,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_512_1023                                         = 598,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_1024_1518                                        = 599,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_1519_2047                                        = 600,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_2048_4095                                        = 601,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_4096_9216                                        = 602,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES_9217_16383                                       = 603,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAMES                                                  = 604,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_BYTES                                                   = 605,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_GOOD_FRAMES                                             = 606,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_UNICAST_FRAMES                                          = 607,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_MULTICAST_FRAMES                                        = 608,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_BROADCAST_FRAMES                                        = 609,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_PAUSE_FRAMES                                            = 610,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_PFC_FRAMES                                              = 611,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_JABBER_FRAMES                                           = 612,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FCS_ERRORS                                              = 613,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_CONTROL_FRAMES                                          = 614,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_OVERSIZE_FRAMES                                         = 615,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_FRAGMENTED_FRAMES                                       = 616,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_ERROR_FRAMES                                            = 617,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_VLAN_FRAMES                                             = 618,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_DOUBLE_VLAN_FRAMES                                      = 619,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_RUNT_FRAMES                                             = 620,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_CFG_TX_UNDERRUN_FRAMES                                         = 621,  /**< NNI - Statistic Configuration */
    BCMOLT_GROUP_ID_NNI_STAT_ALARM_CLEARED                                                  = 622,  /**< NNI - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_NNI_STAT_ALARM_RAISED                                                   = 623,  /**< NNI - Stat Alarm Raised */
    BCMOLT_GROUP_ID_NNI_STATUS_CHANGED                                                      = 624,  /**< NNI - Status changed */
    BCMOLT_GROUP_ID_NNI_AUTO_CFG                                                            = 625,  /**< NNI - Indication Configuration */
    BCMOLT_GROUP_ID_NNI_SERDES_KEY                                                          = 626,  /**< nni_serdes - key */
    BCMOLT_GROUP_ID_NNI_SERDES_CFG                                                          = 627,  /**< nni_serdes - cfg */
    BCMOLT_GROUP_ID_SOFTWARE_ERROR_KEY                                                      = 628,  /**< Software Error - key */
    BCMOLT_GROUP_ID_SOFTWARE_ERROR_CFG                                                      = 629,  /**< Software Error - cfg */
    BCMOLT_GROUP_ID_TRX_CALIBRATION_KEY                                                     = 630,  /**< TRX Calibration - key */
    BCMOLT_GROUP_ID_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED                  = 631,  /**< TRX Calibration - Capture window and statistic completed */
    BCMOLT_GROUP_ID_TRX_CALIBRATION_AUTO_CFG                                                = 632,  /**< TRX Calibration - Indication Configuration */
    BCMOLT_GROUP_ID_TRX_CALIBRATION_START_CAPTURE_WINDOW                                    = 633,  /**< TRX Calibration - start capture window */
    BCMOLT_GROUP_ID_TRX_CALIBRATION_STOP_CAPTURE_WINDOW                                     = 634,  /**< TRX Calibration - stop capture window */
    BCMOLT_GROUP_ID_XGPON_ALLOC_KEY                                                         = 635,  /**< XGPON Alloc - key */
    BCMOLT_GROUP_ID_XGPON_ALLOC_CFG                                                         = 636,  /**< XGPON Alloc - cfg */
    BCMOLT_GROUP_ID_XGPON_ALLOC_STAT                                                        = 637,  /**< XGPON Alloc - stat */
    BCMOLT_GROUP_ID_XGPON_ALLOC_STAT_CFG_RX_BYTES                                           = 638,  /**< XGPON Alloc - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ALLOC_CONFIGURATION_COMPLETED                                     = 639,  /**< XGPON Alloc - Configuration Completed */
    BCMOLT_GROUP_ID_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED                                   = 640,  /**< XGPON Alloc - Get alloc ID statistics completed */
    BCMOLT_GROUP_ID_XGPON_ALLOC_STAT_ALARM_CLEARED                                          = 641,  /**< XGPON Alloc - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_XGPON_ALLOC_STAT_ALARM_RAISED                                           = 642,  /**< XGPON Alloc - Stat Alarm Raised */
    BCMOLT_GROUP_ID_XGPON_ALLOC_AUTO_CFG                                                    = 643,  /**< XGPON Alloc - Indication Configuration */
    BCMOLT_GROUP_ID_XGPON_ALLOC_GET_STATS                                                   = 644,  /**< XGPON Alloc - Get statistics */
    BCMOLT_GROUP_ID_XGPON_ALLOC_SET_STATE                                                   = 645,  /**< XGPON Alloc - Set state */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_KEY                                                      = 646,  /**< XGPON GEM port - key */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_CFG                                                      = 647,  /**< XGPON GEM port - cfg */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT                                                     = 648,  /**< XGPON GEM port - stat */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_CFG_TX_BYTES                                        = 649,  /**< XGPON GEM port - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_CFG_TX_PACKETS                                      = 650,  /**< XGPON GEM port - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_CFG_RX_PACKETS                                      = 651,  /**< XGPON GEM port - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_CFG_RX_BYTES                                        = 652,  /**< XGPON GEM port - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_ALARM_CLEARED                                       = 653,  /**< XGPON GEM port - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_STAT_ALARM_RAISED                                        = 654,  /**< XGPON GEM port - Stat Alarm Raised */
    BCMOLT_GROUP_ID_XGPON_GEM_PORT_AUTO_CFG                                                 = 655,  /**< XGPON GEM port - Indication Configuration */
    BCMOLT_GROUP_ID_XGPON_IWF_KEY                                                           = 656,  /**< XGPON IWF - key */
    BCMOLT_GROUP_ID_XGPON_IWF_CFG                                                           = 657,  /**< XGPON IWF - cfg */
    BCMOLT_GROUP_ID_XGPON_NI_KEY                                                            = 658,  /**< XGPON network interface - key */
    BCMOLT_GROUP_ID_XGPON_NI_CFG                                                            = 659,  /**< XGPON network interface - cfg */
    BCMOLT_GROUP_ID_XGPON_NI_STAT                                                           = 660,  /**< XGPON network interface - stat */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_FEC_CODEWORDS                                         = 661,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_BIP32_BYTES                                           = 662,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_BIP32_ERRORS                                          = 663,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGTC_HEADERS                                       = 664,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGTC_CORRECTED                                     = 665,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGTC_UNCORRECTED                                   = 666,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGEM                                               = 667,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGEM_DROPPED                                       = 668,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGEM_IDLE                                          = 669,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_XGEM_CORRECTED                                     = 670,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_CRC_ERROR                                          = 671,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_FRAGMENT_ERROR                                     = 672,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PACKETS_DROPPED                                    = 673,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_DROPPED_TOO_SHORT                                  = 674,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_DROPPED_TOO_LONG                                   = 675,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_KEY_ERROR                                          = 676,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_PLOAMS                                             = 677,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PLOAMS_DROPPED                                     = 678,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_ALLOCATIONS_VALID                                  = 679,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_ALLOCATIONS_INVALID                                = 680,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_ALLOCATIONS_DISABLED                               = 681,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PLOAMS                                             = 682,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PLOAMS_NON_IDLE                                    = 683,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_PLOAMS_ERROR                                       = 684,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_CPU                                                = 685,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_OMCI                                               = 686,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_RX_OMCI_PACKETS_CRC_ERROR                             = 687,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_PACKETS                                            = 688,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_XGEM                                               = 689,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_CPU                                                = 690,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_OMCI                                               = 691,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_CPU_OMCI_PACKETS_DROPPED                           = 692,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_DROPPED_ILLEGAL_LENGTH                             = 693,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_DROPPED_TPID_MISS                                  = 694,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_CFG_TX_DROPPED_VID_MISS                                   = 695,  /**< XGPON network interface - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_ACTIVATE_ALL_ONUS_COMPLETED                                    = 696,  /**< XGPON network interface - activate all onus completed */
    BCMOLT_GROUP_ID_XGPON_NI_CPU_PACKETS_FAILURE                                            = 697,  /**< XGPON network interface - CPU Packets Failure */
    BCMOLT_GROUP_ID_XGPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED                                  = 698,  /**< XGPON network interface - deactivate all onus completed */
    BCMOLT_GROUP_ID_XGPON_NI_DISABLE_ALL_ONUS_COMPLETED                                     = 699,  /**< XGPON network interface - disable all onus completed */
    BCMOLT_GROUP_ID_XGPON_NI_ENABLE_ALL_ONUS_COMPLETED                                      = 700,  /**< XGPON network interface - enable all onus completed */
    BCMOLT_GROUP_ID_XGPON_NI_LOS                                                            = 701,  /**< XGPON network interface - LOS */
    BCMOLT_GROUP_ID_XGPON_NI_ONU_DISCOVERED                                                 = 702,  /**< XGPON network interface - ONU Discovered */
    BCMOLT_GROUP_ID_XGPON_NI_ONU_UPGRADE_COMPLETE                                           = 703,  /**< XGPON network interface - ONU Upgrade Complete */
    BCMOLT_GROUP_ID_XGPON_NI_PROTECTION_SWITCHING_ONUS_RANGED                               = 704,  /**< XGPON network interface - Protection Switching ONUs Ranged */
    BCMOLT_GROUP_ID_XGPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED                      = 705,  /**< XGPON network interface - Protection Switching Switchover Completed */
    BCMOLT_GROUP_ID_XGPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME                            = 706,  /**< XGPON network interface - Protection Switching Traffic Resume */
    BCMOLT_GROUP_ID_XGPON_NI_ROGUE_DETECTION_COMPLETED                                      = 707,  /**< XGPON network interface - Rogue detection completed */
    BCMOLT_GROUP_ID_XGPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START                              = 708,  /**< XGPON network interface - Rogue ONU special map cycle start */
    BCMOLT_GROUP_ID_XGPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START                          = 709,  /**< XGPON network interface - Serial Number Acquisition Cycle Start */
    BCMOLT_GROUP_ID_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED                         = 710,  /**< XGPON network interface - Standby PON Monitoring Cycle Completed */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_ALARM_CLEARED                                             = 711,  /**< XGPON network interface - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_XGPON_NI_STAT_ALARM_RAISED                                              = 712,  /**< XGPON network interface - Stat Alarm Raised */
    BCMOLT_GROUP_ID_XGPON_NI_STATE_CHANGE_COMPLETED                                         = 713,  /**< XGPON network interface - State Change Completed */
    BCMOLT_GROUP_ID_XGPON_NI_TOD_REQUEST_COMPLETED                                          = 714,  /**< XGPON network interface - TOD request completed */
    BCMOLT_GROUP_ID_XGPON_NI_AUTO_CFG                                                       = 715,  /**< XGPON network interface - Indication Configuration */
    BCMOLT_GROUP_ID_XGPON_NI_ADJUST_TX_WAVELENGTH                                           = 716,  /**< XGPON network interface - Adjust Tx Wavelengh */
    BCMOLT_GROUP_ID_XGPON_NI_DISABLE_SERIAL_NUMBER                                          = 717,  /**< XGPON network interface - Disable Serial Number */
    BCMOLT_GROUP_ID_XGPON_NI_RESET                                                          = 718,  /**< XGPON network interface - Reset */
    BCMOLT_GROUP_ID_XGPON_NI_ROGUE_DETECTION_WINDOW                                         = 719,  /**< XGPON network interface - Rogue Detection Window */
    BCMOLT_GROUP_ID_XGPON_NI_RUN_SPECIAL_BW_MAP                                             = 720,  /**< XGPON network interface - Run Special BW Map */
    BCMOLT_GROUP_ID_XGPON_NI_SET_ONU_STATE                                                  = 721,  /**< XGPON network interface - Set ONU State */
    BCMOLT_GROUP_ID_XGPON_NI_SET_PON_STATE                                                  = 722,  /**< XGPON network interface - Set PON State */
    BCMOLT_GROUP_ID_XGPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING                          = 723,  /**< XGPON network interface - Single request standby PON Monitoring */
    BCMOLT_GROUP_ID_XGPON_NI_START_ONU_UPGRADE                                              = 724,  /**< XGPON network interface - Start ONU Firmware Upgrade */
    BCMOLT_GROUP_ID_XGPON_NI_TOD_REQUEST                                                    = 725,  /**< XGPON network interface - TOD request */
    BCMOLT_GROUP_ID_XGPON_NI_BROADCAST_PLOAM_PACKET                                         = 726,  /**< XGPON network interface - Broadcast PLOAM Packet */
    BCMOLT_GROUP_ID_XGPON_NI_CPU_PACKETS                                                    = 727,  /**< XGPON network interface - XGPON CPU packets */
    BCMOLT_GROUP_ID_XGPON_ONU_KEY                                                           = 728,  /**< XGPON ONU - key */
    BCMOLT_GROUP_ID_XGPON_ONU_CFG                                                           = 729,  /**< XGPON ONU - cfg */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT                                                          = 730,  /**< XGPON ONU - stat */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_POSITIVE_DRIFT                                       = 731,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_NEGATIVE_DRIFT                                       = 732,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_DELIMITER_MISS_DETECTION                             = 733,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_BIP32_ERRORS                                         = 734,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_WORDS                                             = 735,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_CORRECTED_SYMBOLS                                = 736,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_CORRECTED_CODEWORDS                              = 737,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_UNCORRECTABLE_CODEWORDS                          = 738,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_CODEWORDS                                        = 739,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_FEC_CORRECTED_BITS                                   = 740,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_XGEM_KEY_ERRORS                                      = 741,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_XGEM_LOSS                                            = 742,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_PLOAMS_MIC_ERROR                                  = 743,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_PLOAMS_NON_IDLE                                   = 744,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_OMCI                                              = 745,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_OMCI_PACKETS_CRC_ERROR                            = 746,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_BYTES                                             = 747,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_RX_PACKETS                                           = 748,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_TX_BYTES                                             = 749,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_CFG_TX_PACKETS                                           = 750,  /**< XGPON ONU - Statistic Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_DFI                                                           = 751,  /**< XGPON ONU - Receive Dying-Gasp of ONUi */
    BCMOLT_GROUP_ID_XGPON_ONU_DGI                                                           = 752,  /**< XGPON ONU - Receive Dying-Gasp of ONUi */
    BCMOLT_GROUP_ID_XGPON_ONU_DOWI                                                          = 753,  /**< XGPON ONU - Drift of Window of ONUi */
    BCMOLT_GROUP_ID_XGPON_ONU_INVALID_DBRU_REPORT                                           = 754,  /**< XGPON ONU - Invalid DBRu Report */
    BCMOLT_GROUP_ID_XGPON_ONU_KEY_EXCHANGE_COMPLETED                                        = 755,  /**< XGPON ONU - Key Exchange Completed */
    BCMOLT_GROUP_ID_XGPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED                                    = 756,  /**< XGPON ONU - Key Exchange Cycle Skipped */
    BCMOLT_GROUP_ID_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH                                     = 757,  /**< XGPON ONU - Key Exchange Key Mismatch */
    BCMOLT_GROUP_ID_XGPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT                              = 758,  /**< XGPON ONU - Key Exchange Key Request Timeout */
    BCMOLT_GROUP_ID_XGPON_ONU_LOOCI                                                         = 759,  /**< XGPON ONU - LOOCi */
    BCMOLT_GROUP_ID_XGPON_ONU_ONU_ACTIVATION_COMPLETED                                      = 760,  /**< XGPON ONU - ONU Activation Completed */
    BCMOLT_GROUP_ID_XGPON_ONU_ONU_ALARM                                                     = 761,  /**< XGPON ONU - ONU Alarm */
    BCMOLT_GROUP_ID_XGPON_ONU_ONU_DEACTIVATION_COMPLETED                                    = 762,  /**< XGPON ONU - ONU Deactivation Completed */
    BCMOLT_GROUP_ID_XGPON_ONU_ONU_DISABLE_COMPLETED                                         = 763,  /**< XGPON ONU - ONU Disable Completed */
    BCMOLT_GROUP_ID_XGPON_ONU_ONU_ENABLE_COMPLETED                                          = 764,  /**< XGPON ONU - ONU Enable Completed */
    BCMOLT_GROUP_ID_XGPON_ONU_ONU_TUNING_IN_COMPLETED                                       = 765,  /**< XGPON ONU - ONU Tuning in completed */
    BCMOLT_GROUP_ID_XGPON_ONU_ONU_TUNING_OUT_COMPLETED                                      = 766,  /**< XGPON ONU - ONU Tuning out completed */
    BCMOLT_GROUP_ID_XGPON_ONU_OPTICAL_REFLECTION                                            = 767,  /**< XGPON ONU - Optical Reflection */
    BCMOLT_GROUP_ID_XGPON_ONU_POSSIBLE_DRIFT                                                = 768,  /**< XGPON ONU - Possible Drift */
    BCMOLT_GROUP_ID_XGPON_ONU_POWER_CONSUMPTION_REPORT                                      = 769,  /**< XGPON ONU - Power consumption report */
    BCMOLT_GROUP_ID_XGPON_ONU_POWER_LEVEL_REPORT                                            = 770,  /**< XGPON ONU - Power level report */
    BCMOLT_GROUP_ID_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE                                 = 771,  /**< XGPON ONU - Power Management State Change */
    BCMOLT_GROUP_ID_XGPON_ONU_PQSI                                                          = 772,  /**< XGPON ONU - ploam queue status */
    BCMOLT_GROUP_ID_XGPON_ONU_RANGING_COMPLETED                                             = 773,  /**< XGPON ONU - Ranging Completed */
    BCMOLT_GROUP_ID_XGPON_ONU_REGISTRATION_ID                                               = 774,  /**< XGPON ONU - Registration ID */
    BCMOLT_GROUP_ID_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED                                    = 775,  /**< XGPON ONU - RSSI Measurement Completed */
    BCMOLT_GROUP_ID_XGPON_ONU_SDI                                                           = 776,  /**< XGPON ONU - Signal Degraded of ONUi */
    BCMOLT_GROUP_ID_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE                          = 777,  /**< XGPON ONU - secure mutual authentication failure */
    BCMOLT_GROUP_ID_XGPON_ONU_SFI                                                           = 778,  /**< XGPON ONU - Signal Fail of ONUi */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_ALARM_CLEARED                                            = 779,  /**< XGPON ONU - Stat Alarm Cleared */
    BCMOLT_GROUP_ID_XGPON_ONU_STAT_ALARM_RAISED                                             = 780,  /**< XGPON ONU - Stat Alarm Raised */
    BCMOLT_GROUP_ID_XGPON_ONU_SUFI                                                          = 781,  /**< XGPON ONU - SUFi */
    BCMOLT_GROUP_ID_XGPON_ONU_TIWI                                                          = 782,  /**< XGPON ONU - Transmission Interference Warning */
    BCMOLT_GROUP_ID_XGPON_ONU_TUNING_RESPONSE                                               = 783,  /**< XGPON ONU - Tuning response */
    BCMOLT_GROUP_ID_XGPON_ONU_AUTO_CFG                                                      = 784,  /**< XGPON ONU - Indication Configuration */
    BCMOLT_GROUP_ID_XGPON_ONU_ADJUST_TX_WAVELENGTH                                          = 785,  /**< XGPON ONU - Adjust Tx wavelength */
    BCMOLT_GROUP_ID_XGPON_ONU_CHANGE_POWER_LEVELLING                                        = 786,  /**< XGPON ONU - Change power levelling */
    BCMOLT_GROUP_ID_XGPON_ONU_GET_POWER_CONSUMPTION                                         = 787,  /**< XGPON ONU - Get power consumption */
    BCMOLT_GROUP_ID_XGPON_ONU_GET_POWER_LEVEL                                               = 788,  /**< XGPON ONU - Get power level */
    BCMOLT_GROUP_ID_XGPON_ONU_ONU_TUNING_IN                                                 = 789,  /**< XGPON ONU - ONU Tuning in */
    BCMOLT_GROUP_ID_XGPON_ONU_ONU_TUNING_OUT                                                = 790,  /**< XGPON ONU - ONU Tuning out */
    BCMOLT_GROUP_ID_XGPON_ONU_REQUEST_REGISTRATION                                          = 791,  /**< XGPON ONU - Request registration */
    BCMOLT_GROUP_ID_XGPON_ONU_RSSI_MEASUREMENT                                              = 792,  /**< XGPON ONU - RSSI Measurement */
    BCMOLT_GROUP_ID_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION                                  = 793,  /**< XGPON ONU - Secure mutual authentication */
    BCMOLT_GROUP_ID_XGPON_ONU_SET_ONU_STATE                                                 = 794,  /**< XGPON ONU - Set ONU State */
    BCMOLT_GROUP_ID_XGPON_ONU_CPU_PACKETS                                                   = 795,  /**< XGPON ONU - XGPON CPU packets */
    BCMOLT_GROUP_ID_XGPON_ONU_PLOAM_PACKET                                                  = 796,  /**< XGPON ONU - PLOAM Packet */
    BCMOLT_GROUP_ID_XGPON_ONU_CPU_PACKET                                                    = 797,  /**< XGPON ONU - XGPON CPU packet */
    BCMOLT_GROUP_ID_XGPON_ONU_OMCI_PACKET                                                   = 798,  /**< XGPON ONU - XGPON OMCI packet */
    BCMOLT_GROUP_ID_XGPON_TRX_KEY                                                           = 799,  /**< XGPON TRX - key */
    BCMOLT_GROUP_ID_XGPON_TRX_CFG                                                           = 800,  /**< XGPON TRX - cfg */
    BCMOLT_GROUP_ID_XPON_SERDES_KEY                                                         = 801,  /**< xpon_serdes - key */
    BCMOLT_GROUP_ID_XPON_SERDES_CFG                                                         = 802,  /**< xpon_serdes - cfg */
    BCMOLT_GROUP_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_group_id;

/** List of all ae_ni groups of type oper. 
 */
typedef enum bcmolt_ae_ni_oper_id
{
    BCMOLT_AE_NI_OPER_ID__BEGIN,
    BCMOLT_AE_NI_OPER_ID_SET_AE_NI_EN_STATE                                                 = 0,    /**< Set AE NI Enable State. */
    BCMOLT_AE_NI_OPER_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_ni_oper_id;

/** List of all ae_path_ds groups of type auto. 
 */
typedef enum bcmolt_ae_path_ds_auto_id
{
    BCMOLT_AE_PATH_DS_AUTO_ID__BEGIN,
    BCMOLT_AE_PATH_DS_AUTO_ID_STAT_ALARM_CLEARED                                            = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_AE_PATH_DS_AUTO_ID_STAT_ALARM_RAISED,    /**< Stat Alarm Raised. */
    BCMOLT_AE_PATH_DS_AUTO_ID__NUM_OF               /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_ds_auto_id;

/** List of all ae_path_us groups of type auto. 
 */
typedef enum bcmolt_ae_path_us_auto_id
{
    BCMOLT_AE_PATH_US_AUTO_ID__BEGIN,
    BCMOLT_AE_PATH_US_AUTO_ID_STAT_ALARM_CLEARED                                            = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_AE_PATH_US_AUTO_ID_STAT_ALARM_RAISED,    /**< Stat Alarm Raised. */
    BCMOLT_AE_PATH_US_AUTO_ID__NUM_OF               /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_path_us_auto_id;

/** List of all debug groups of type auto. 
 */
typedef enum bcmolt_debug_auto_id
{
    BCMOLT_DEBUG_AUTO_ID__BEGIN,
    BCMOLT_DEBUG_AUTO_ID_CLI_OUTPUT                                                         = 0,    /**< cli_output. */
    BCMOLT_DEBUG_AUTO_ID_FILE_ALMOST_FULL,  /**< file_almost_full. */
    BCMOLT_DEBUG_AUTO_ID__NUM_OF            /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_auto_id;

/** List of all debug groups of type oper. 
 */
typedef enum bcmolt_debug_oper_id
{
    BCMOLT_DEBUG_OPER_ID__BEGIN,
    BCMOLT_DEBUG_OPER_ID_CLI_INPUT                                                          = 0,    /**< CLI_input. */
    BCMOLT_DEBUG_OPER_ID_RESET_API_CAPTURE, /**< Reset API Capture. */
    BCMOLT_DEBUG_OPER_ID_START_API_CAPTURE, /**< Start API Capture. */
    BCMOLT_DEBUG_OPER_ID_STOP_API_CAPTURE,  /**< Stop API Capture. */
    BCMOLT_DEBUG_OPER_ID__NUM_OF            /**< Number of enum entries, not an entry itself. */
} bcmolt_debug_oper_id;

/** List of all device groups of type auto. 
 */
typedef enum bcmolt_device_auto_id
{
    BCMOLT_DEVICE_AUTO_ID__BEGIN,
    BCMOLT_DEVICE_AUTO_ID_CONNECTION_COMPLETE                                               = 0,    /**< Connection Complete. */
    BCMOLT_DEVICE_AUTO_ID_CONNECTION_ESTABLISHED,   /**< Connection Established (Internal). */
    BCMOLT_DEVICE_AUTO_ID_CONNECTION_FAILURE,       /**< Connection Failure. */
    BCMOLT_DEVICE_AUTO_ID_DDR_TEST_COMPLETE,        /**< DDR Test Complete. */
    BCMOLT_DEVICE_AUTO_ID_DEVICE_KEEP_ALIVE,        /**< Device Keep Alive (Internal). */
    BCMOLT_DEVICE_AUTO_ID_DEVICE_READY,             /**< Device Ready (Internal). */
    BCMOLT_DEVICE_AUTO_ID_DISCONNECTION_COMPLETE,   /**< Disconnection Complete. */
    BCMOLT_DEVICE_AUTO_ID_IMAGE_TRANSFER_COMPLETE,  /**< Image Transfer Complete. */
    BCMOLT_DEVICE_AUTO_ID_INDICATIONS_DROPPED,      /**< Indications Dropped. */
    BCMOLT_DEVICE_AUTO_ID_SW_ERROR,                 /**< sw error. */
    BCMOLT_DEVICE_AUTO_ID_SW_EXCEPTION,             /**< sw exception. */
    BCMOLT_DEVICE_AUTO_ID__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_device_auto_id;

/** List of all device groups of type oper. 
 */
typedef enum bcmolt_device_oper_id
{
    BCMOLT_DEVICE_OPER_ID__BEGIN,
    BCMOLT_DEVICE_OPER_ID_CONNECT                                                           = 0,    /**< Connect. */
    BCMOLT_DEVICE_OPER_ID_DISCONNECT,           /**< Device Disconnect. */
    BCMOLT_DEVICE_OPER_ID_HOST_KEEP_ALIVE,      /**< Host Keep Alive (Internal). */
    BCMOLT_DEVICE_OPER_ID_IMAGE_TRANSFER_DATA,  /**< Image Data Transfer Operation (Internal). */
    BCMOLT_DEVICE_OPER_ID_IMAGE_TRANSFER_START, /**< Start Image Transfer Operation. */
    BCMOLT_DEVICE_OPER_ID_RESET,                /**< Device Reset. */
    BCMOLT_DEVICE_OPER_ID_RUN_DDR_TEST,         /**< Run DDR Test. */
    BCMOLT_DEVICE_OPER_ID_SW_UPGRADE_ACTIVATE,  /**< SW upgrade activate. */
    BCMOLT_DEVICE_OPER_ID__NUM_OF               /**< Number of enum entries, not an entry itself. */
} bcmolt_device_oper_id;

/** List of all epon_denied_link groups of type auto. 
 */
typedef enum bcmolt_epon_denied_link_auto_id
{
    BCMOLT_EPON_DENIED_LINK_AUTO_ID__BEGIN,
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_LASER_ON_OFF_VIOLATION                                  = 0,    /**< Laser On/Off Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_LLID_POOL_EMPTY_VIOLATION,      /**< LLID Pool Empty Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_MAX_LINK_VIOLATION,             /**< Max Link Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_OVERHEAD_PROFILE_VIOLATION,     /**< Overhead Profile Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_RANGE_VIOLATION,                /**< Range Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_ROGUE_VIOLATION,                /**< Rogue ONU Detected. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_SYSTEM_RESOURCE_VIOLATION,      /**< System Resource Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_TDM_CHANNELS_EXHAUSTED,         /**< TDM Channels Exhausted. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_UNKNOWN_LINK_VIOLATION,         /**< Unknown Link Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID_UPSTREAM_BANDWIDTH_VIOLATION,   /**< Upstream Bandwidth Violation. */
    BCMOLT_EPON_DENIED_LINK_AUTO_ID__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_denied_link_auto_id;

/** List of all epon_link groups of type auto. 
 */
typedef enum bcmolt_epon_link_auto_id
{
    BCMOLT_EPON_LINK_AUTO_ID__BEGIN,
    BCMOLT_EPON_LINK_AUTO_ID_DUPLICATE_MPCP_REGISTRATION_REQUEST                            = 0,    /**< Duplicate MPCP Registration Request. */
    BCMOLT_EPON_LINK_AUTO_ID_ENCRYPTION_ENABLED,            /**< Encryption Enabled. */
    BCMOLT_EPON_LINK_AUTO_ID_KEY_EXCHANGE_FAILURE,          /**< Key Exchange Failure. */
    BCMOLT_EPON_LINK_AUTO_ID_KEY_EXCHANGE_STARTED,          /**< key_exchange_started. */
    BCMOLT_EPON_LINK_AUTO_ID_KEY_EXCHANGE_STOPPED,          /**< key_exchange_stopped. */
    BCMOLT_EPON_LINK_AUTO_ID_LINK_DELETED,                  /**< Link Deleted. */
    BCMOLT_EPON_LINK_AUTO_ID_LINK_SPEED_MISMATCH,           /**< Link attempted to register at a different speed. */
    BCMOLT_EPON_LINK_AUTO_ID_MPCP_DEREGISTERED,             /**< MPCP Deregistered. */
    BCMOLT_EPON_LINK_AUTO_ID_MPCP_DISCOVERED,               /**< MPCP Discovered. */
    BCMOLT_EPON_LINK_AUTO_ID_MPCP_REG_ACK_TIMEOUT,          /**< MPCP Reg Ack Timeout. */
    BCMOLT_EPON_LINK_AUTO_ID_MPCP_REPORT_TIMEOUT,           /**< MPCP Report Timeout. */
    BCMOLT_EPON_LINK_AUTO_ID_OAM_KEEPALIVE_TIMEOUT,         /**< OAM Keepalive Timeout. */
    BCMOLT_EPON_LINK_AUTO_ID_OAM_KEEPALIVE_TIMER_STARTED,   /**< OAM keepalive timer started. */
    BCMOLT_EPON_LINK_AUTO_ID_OAM_KEEPALIVE_TIMER_STOPPED,   /**< OAM keepalive timer stopped. */
    BCMOLT_EPON_LINK_AUTO_ID_PREPROVISIONED_LINK_CREATED,   /**< Preprovisioned Link Created. */
    BCMOLT_EPON_LINK_AUTO_ID_PROTECTION_SWITCH_OCCURRED,    /**< Protection Switch Occurred. */
    BCMOLT_EPON_LINK_AUTO_ID_RANGE_VALUE_CHANGED,           /**< Range Value Changed. */
    BCMOLT_EPON_LINK_AUTO_ID_RERANGE_FAILURE,               /**< Re-range failure. */
    BCMOLT_EPON_LINK_AUTO_ID_STAT_ALARM_CLEARED,            /**< Stat Alarm Cleared. */
    BCMOLT_EPON_LINK_AUTO_ID_STAT_ALARM_RAISED,             /**< Stat Alarm Raised. */
    BCMOLT_EPON_LINK_AUTO_ID_STATIC_REGISTRATION_DONE,      /**< Static registration done. */
    BCMOLT_EPON_LINK_AUTO_ID__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_auto_id;

/** List of all epon_link groups of type oper. 
 */
typedef enum bcmolt_epon_link_oper_id
{
    BCMOLT_EPON_LINK_OPER_ID__BEGIN,
    BCMOLT_EPON_LINK_OPER_ID_DELETE_LINK                                                    = 0,    /**< Delete Link. */
    BCMOLT_EPON_LINK_OPER_ID_FORCE_REDISCOVERY,         /**< Force Link Rediscovery. */
    BCMOLT_EPON_LINK_OPER_ID_KEY_EXCHANGE_START,        /**< Key exchange start. */
    BCMOLT_EPON_LINK_OPER_ID_KEY_EXCHANGE_STOP,         /**< Key exchange stop. */
    BCMOLT_EPON_LINK_OPER_ID_OAM_KEEPALIVE_TIMER_START, /**< OAM Keepalive Timer Start. */
    BCMOLT_EPON_LINK_OPER_ID_OAM_KEEPALIVE_TIMER_STOP,  /**< OAM Keepalive Timer Stop. */
    BCMOLT_EPON_LINK_OPER_ID_STATIC_REGISTRATION,       /**< static_registration. */
    BCMOLT_EPON_LINK_OPER_ID__NUM_OF                    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_oper_id;

/** List of all epon_link groups of type proxy. 
 */
typedef enum bcmolt_epon_link_proxy_id
{
    BCMOLT_EPON_LINK_PROXY_ID__BEGIN,
    BCMOLT_EPON_LINK_PROXY_ID_INJECT_FRAME                                                  = 0,    /**< Inject Frame. */
    BCMOLT_EPON_LINK_PROXY_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_proxy_id;

/** List of all epon_link groups of type proxy_rx. 
 */
typedef enum bcmolt_epon_link_proxy_rx_id
{
    BCMOLT_EPON_LINK_PROXY_RX_ID__BEGIN,
    BCMOLT_EPON_LINK_PROXY_RX_ID_FRAME_CAPTURED                                             = 0,    /**< Frame Captured. */
    BCMOLT_EPON_LINK_PROXY_RX_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_proxy_rx_id;

/** List of all epon_ni groups of type auto. 
 */
typedef enum bcmolt_epon_ni_auto_id
{
    BCMOLT_EPON_NI_AUTO_ID__BEGIN,
    BCMOLT_EPON_NI_AUTO_ID_AUTO_ROGUE_SCAN_10G_FAILURE                                      = 0,    /**< 10G Epon Autonomous Rogue Scan failure detected. */
    BCMOLT_EPON_NI_AUTO_ID_AUTO_ROGUE_SCAN_1G_FAILURE,  /**< 1G Epon Autonomous Rogue Scan failure detected. */
    BCMOLT_EPON_NI_AUTO_ID_LLID_QUARANTINED,            /**< LLID Quarantined. */
    BCMOLT_EPON_NI_AUTO_ID_MPCP_TIMESTAMP_CHANGED,      /**< MPCP Timestamp Changed. */
    BCMOLT_EPON_NI_AUTO_ID_NO_REPORTS,                  /**< No Reports. */
    BCMOLT_EPON_NI_AUTO_ID_ONU_UPGRADE_COMPLETE,        /**< ONU Upgrade Complete. */
    BCMOLT_EPON_NI_AUTO_ID_RERANGE_FAILURE,             /**< Re-range failure. */
    BCMOLT_EPON_NI_AUTO_ID_ROGUE_SCAN_COMPLETE,         /**< Rogue Scan is Complete. */
    BCMOLT_EPON_NI_AUTO_ID_RSSI_MEASUREMENT_COMPLETED,  /**< RSSI Measurement Completed. */
    BCMOLT_EPON_NI_AUTO_ID_STATE_CHANGE_COMPLETED,      /**< State Change Completed. */
    BCMOLT_EPON_NI_AUTO_ID__NUM_OF                      /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_auto_id;

/** List of all epon_ni groups of type oper. 
 */
typedef enum bcmolt_epon_ni_oper_id
{
    BCMOLT_EPON_NI_OPER_ID__BEGIN,
    BCMOLT_EPON_NI_OPER_ID_ADD_LINK                                                         = 0,    /**< Add link. */
    BCMOLT_EPON_NI_OPER_ID_ADD_MULTICAST_LINK,          /**< Add Mutlticastlink. */
    BCMOLT_EPON_NI_OPER_ID_ADD_PROTECTED_STANDBY_LINK,  /**< Add Protected Standby Link. */
    BCMOLT_EPON_NI_OPER_ID_ISSUE_RSSI_GRANT,            /**< Issue an Rx Power Measurement Request. */
    BCMOLT_EPON_NI_OPER_ID_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA,    /**< Protection switching apply re-range delta. */
    BCMOLT_EPON_NI_OPER_ID_ROGUE_LLID_SCAN,         /**< Run Rogue LLID Scan. */
    BCMOLT_EPON_NI_OPER_ID_SET_EPON_NI_EN_STATE,    /**< Set EPON NI Enable State. */
    BCMOLT_EPON_NI_OPER_ID_START_ONU_UPGRADE,       /**< Start ONU Firmware Upgrade. */
    BCMOLT_EPON_NI_OPER_ID__NUM_OF                  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_oper_id;

/** List of all epon_onu_10g_us groups of type auto. 
 */
typedef enum bcmolt_epon_onu_10g_us_auto_id
{
    BCMOLT_EPON_ONU_10G_US_AUTO_ID__BEGIN,
    BCMOLT_EPON_ONU_10G_US_AUTO_ID_STAT_ALARM_CLEARED                                       = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_ONU_10G_US_AUTO_ID_STAT_ALARM_RAISED,   /**< Stat Alarm Raised. */
    BCMOLT_EPON_ONU_10G_US_AUTO_ID__NUM_OF              /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_10g_us_auto_id;

/** List of all epon_onu_1g_us groups of type auto. 
 */
typedef enum bcmolt_epon_onu_1g_us_auto_id
{
    BCMOLT_EPON_ONU_1G_US_AUTO_ID__BEGIN,
    BCMOLT_EPON_ONU_1G_US_AUTO_ID_STAT_ALARM_CLEARED                                        = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_ONU_1G_US_AUTO_ID_STAT_ALARM_RAISED,    /**< Stat Alarm Raised. */
    BCMOLT_EPON_ONU_1G_US_AUTO_ID__NUM_OF               /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_1g_us_auto_id;

/** List of all epon_path_10g_ds groups of type auto. 
 */
typedef enum bcmolt_epon_path_10g_ds_auto_id
{
    BCMOLT_EPON_PATH_10G_DS_AUTO_ID__BEGIN,
    BCMOLT_EPON_PATH_10G_DS_AUTO_ID_STAT_ALARM_CLEARED                                      = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_PATH_10G_DS_AUTO_ID_STAT_ALARM_RAISED,  /**< Stat Alarm Raised. */
    BCMOLT_EPON_PATH_10G_DS_AUTO_ID__NUM_OF             /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_ds_auto_id;

/** List of all epon_path_10g_us groups of type auto. 
 */
typedef enum bcmolt_epon_path_10g_us_auto_id
{
    BCMOLT_EPON_PATH_10G_US_AUTO_ID__BEGIN,
    BCMOLT_EPON_PATH_10G_US_AUTO_ID_STAT_ALARM_CLEARED                                      = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_PATH_10G_US_AUTO_ID_STAT_ALARM_RAISED,  /**< Stat Alarm Raised. */
    BCMOLT_EPON_PATH_10G_US_AUTO_ID__NUM_OF             /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_10g_us_auto_id;

/** List of all epon_path_1g_ds groups of type auto. 
 */
typedef enum bcmolt_epon_path_1g_ds_auto_id
{
    BCMOLT_EPON_PATH_1G_DS_AUTO_ID__BEGIN,
    BCMOLT_EPON_PATH_1G_DS_AUTO_ID_STAT_ALARM_CLEARED                                       = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_PATH_1G_DS_AUTO_ID_STAT_ALARM_RAISED,   /**< Stat Alarm Raised. */
    BCMOLT_EPON_PATH_1G_DS_AUTO_ID__NUM_OF              /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_ds_auto_id;

/** List of all epon_path_1g_us groups of type auto. 
 */
typedef enum bcmolt_epon_path_1g_us_auto_id
{
    BCMOLT_EPON_PATH_1G_US_AUTO_ID__BEGIN,
    BCMOLT_EPON_PATH_1G_US_AUTO_ID_STAT_ALARM_CLEARED                                       = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_EPON_PATH_1G_US_AUTO_ID_STAT_ALARM_RAISED,   /**< Stat Alarm Raised. */
    BCMOLT_EPON_PATH_1G_US_AUTO_ID__NUM_OF              /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_path_1g_us_auto_id;

/** List of all gpon_alloc groups of type auto. 
 */
typedef enum bcmolt_gpon_alloc_auto_id
{
    BCMOLT_GPON_ALLOC_AUTO_ID__BEGIN,
    BCMOLT_GPON_ALLOC_AUTO_ID_CONFIGURATION_COMPLETED                                       = 0,    /**< Configuration Completed. */
    BCMOLT_GPON_ALLOC_AUTO_ID_GET_ALLOC_STATS_COMPLETED,    /**< Get alloc ID statistics completed. */
    BCMOLT_GPON_ALLOC_AUTO_ID_STAT_ALARM_CLEARED,           /**< Stat Alarm Cleared. */
    BCMOLT_GPON_ALLOC_AUTO_ID_STAT_ALARM_RAISED,            /**< Stat Alarm Raised. */
    BCMOLT_GPON_ALLOC_AUTO_ID__NUM_OF                       /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_auto_id;

/** List of all gpon_alloc groups of type oper. 
 */
typedef enum bcmolt_gpon_alloc_oper_id
{
    BCMOLT_GPON_ALLOC_OPER_ID__BEGIN,
    BCMOLT_GPON_ALLOC_OPER_ID_GET_STATS                                                     = 0,    /**< Get statistics. */
    BCMOLT_GPON_ALLOC_OPER_ID_SET_STATE,    /**< Set state. */
    BCMOLT_GPON_ALLOC_OPER_ID__NUM_OF       /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_alloc_oper_id;

/** List of all gpon_gem_port groups of type auto. 
 */
typedef enum bcmolt_gpon_gem_port_auto_id
{
    BCMOLT_GPON_GEM_PORT_AUTO_ID__BEGIN,
    BCMOLT_GPON_GEM_PORT_AUTO_ID_CONFIGURATION_COMPLETED                                    = 0,    /**< Configuration Completed. */
    BCMOLT_GPON_GEM_PORT_AUTO_ID_STAT_ALARM_CLEARED,    /**< Stat Alarm Cleared. */
    BCMOLT_GPON_GEM_PORT_AUTO_ID_STAT_ALARM_RAISED,     /**< Stat Alarm Raised. */
    BCMOLT_GPON_GEM_PORT_AUTO_ID__NUM_OF                /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_auto_id;

/** List of all gpon_gem_port groups of type oper. 
 */
typedef enum bcmolt_gpon_gem_port_oper_id
{
    BCMOLT_GPON_GEM_PORT_OPER_ID__BEGIN,
    BCMOLT_GPON_GEM_PORT_OPER_ID_SET_STATE                                                  = 0,    /**< Set state. */
    BCMOLT_GPON_GEM_PORT_OPER_ID__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_oper_id;

/** List of all gpon_iwf groups of type auto. 
 */
typedef enum bcmolt_gpon_iwf_auto_id
{
    BCMOLT_GPON_IWF_AUTO_ID__BEGIN,
    BCMOLT_GPON_IWF_AUTO_ID_FLUSH_MAC_TABLE_COMPLETED                                       = 0,    /**< Flush MAC Table Completed. */
    BCMOLT_GPON_IWF_AUTO_ID_SCAN_MAC_TABLE_COMPLETED,   /**< Scan MAC Table Completed. */
    BCMOLT_GPON_IWF_AUTO_ID_STAT_ALARM_CLEARED,         /**< Stat Alarm Cleared. */
    BCMOLT_GPON_IWF_AUTO_ID_STAT_ALARM_RAISED,          /**< Stat Alarm Raised. */
    BCMOLT_GPON_IWF_AUTO_ID__NUM_OF                     /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_auto_id;

/** List of all gpon_iwf groups of type oper. 
 */
typedef enum bcmolt_gpon_iwf_oper_id
{
    BCMOLT_GPON_IWF_OPER_ID__BEGIN,
    BCMOLT_GPON_IWF_OPER_ID_FLUSH_MAC_TABLE                                                 = 0,    /**< Flush MAC Table. */
    BCMOLT_GPON_IWF_OPER_ID_SCAN_MAC_TABLE, /**< Scan MAC Table. */
    BCMOLT_GPON_IWF_OPER_ID__NUM_OF         /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_oper_id;

/** List of all gpon_iwf_mac_table groups of type auto. 
 */
typedef enum bcmolt_gpon_iwf_mac_table_auto_id
{
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID__BEGIN,
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID_MAC_AGED                                              = 0,    /**< MAC Aged. */
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID_MAC_DROPPED,  /**< MAC Dropped. */
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID_MAC_MOVE,     /**< MAC Move. */
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID_NEW_MAC,      /**< New MAC. */
    BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID__NUM_OF       /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_iwf_mac_table_auto_id;

/** List of all gpon_ni groups of type auto. 
 */
typedef enum bcmolt_gpon_ni_auto_id
{
    BCMOLT_GPON_NI_AUTO_ID__BEGIN,
    BCMOLT_GPON_NI_AUTO_ID_ACTIVATE_ALL_ONUS_COMPLETED                                      = 0,    /**< activate all onus completed. */
    BCMOLT_GPON_NI_AUTO_ID_CPU_PACKETS_FAILURE,             /**< CPU Packets Failure. */
    BCMOLT_GPON_NI_AUTO_ID_DEACTIVATE_ALL_ONUS_COMPLETED,   /**< deactivate all onus completed. */
    BCMOLT_GPON_NI_AUTO_ID_DISABLE_ALL_ONUS_COMPLETED,      /**< disable all onus completed. */
    BCMOLT_GPON_NI_AUTO_ID_ENABLE_ALL_ONUS_COMPLETED,       /**< enable all onus completed. */
    BCMOLT_GPON_NI_AUTO_ID_LOS,                     /**< LOS. */
    BCMOLT_GPON_NI_AUTO_ID_ONU_DISCOVERED,          /**< ONU Discovered. */
    BCMOLT_GPON_NI_AUTO_ID_ONU_UPGRADE_COMPLETE,    /**< ONU Upgrade Complete. */
    BCMOLT_GPON_NI_AUTO_ID_PROTECTION_SWITCHING_ONUS_RANGED,            /**< Protection Switching ONUs Ranged. */
    BCMOLT_GPON_NI_AUTO_ID_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED,   /**< Protection Switching Switchover Completed. */
    BCMOLT_GPON_NI_AUTO_ID_PROTECTION_SWITCHING_TRAFFIC_RESUME,         /**< Protection Switching Traffic Resume. */
    BCMOLT_GPON_NI_AUTO_ID_ROGUE_DETECTION_COMPLETED,                   /**< Rogue detection completed. */
    BCMOLT_GPON_NI_AUTO_ID_ROGUE_ONU_SPECIAL_MAP_CYCLE_START,           /**< Rogue ONU special map cycle start. */
    BCMOLT_GPON_NI_AUTO_ID_SERIAL_NUMBER_ACQUISITION_CYCLE_START,       /**< Serial Number Acquisition Cycle Start. */
    BCMOLT_GPON_NI_AUTO_ID_STANDBY_PON_MONITORING_CYCLE_COMPLETED,      /**< Standby PON Monitoring Cycle Completed. */
    BCMOLT_GPON_NI_AUTO_ID_STAT_ALARM_CLEARED,      /**< Stat Alarm Cleared. */
    BCMOLT_GPON_NI_AUTO_ID_STAT_ALARM_RAISED,       /**< Stat Alarm Raised. */
    BCMOLT_GPON_NI_AUTO_ID_STATE_CHANGE_COMPLETED,  /**< State Change Completed. */
    BCMOLT_GPON_NI_AUTO_ID_TOD_REQUEST_COMPLETED,   /**< TOD request completed. */
    BCMOLT_GPON_NI_AUTO_ID__NUM_OF                  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_auto_id;

/** List of all gpon_ni groups of type oper. 
 */
typedef enum bcmolt_gpon_ni_oper_id
{
    BCMOLT_GPON_NI_OPER_ID__BEGIN,
    BCMOLT_GPON_NI_OPER_ID_DISABLE_SERIAL_NUMBER                                            = 0,    /**< Disable Serial Number. */
    BCMOLT_GPON_NI_OPER_ID_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE,                      /**< protection switching type c set multiple onu state. */
    BCMOLT_GPON_NI_OPER_ID_RESET,                   /**< Reset. */
    BCMOLT_GPON_NI_OPER_ID_ROGUE_DETECTION_WINDOW,  /**< Rogue Detection Window. */
    BCMOLT_GPON_NI_OPER_ID_SET_ONU_STATE,           /**< Set ONU State. */
    BCMOLT_GPON_NI_OPER_ID_SET_PON_STATE,           /**< Set PON State. */
    BCMOLT_GPON_NI_OPER_ID_SINGLE_REQUEST_STANDBY_PON_MONITORING,   /**< Single request for standby PON monitoring. */
    BCMOLT_GPON_NI_OPER_ID_START_ONU_UPGRADE,                       /**< Start ONU Firmware Upgrade. */
    BCMOLT_GPON_NI_OPER_ID_TOD_REQUEST, /**< TOD request. */
    BCMOLT_GPON_NI_OPER_ID__NUM_OF      /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_oper_id;

/** List of all gpon_ni groups of type proxy. 
 */
typedef enum bcmolt_gpon_ni_proxy_id
{
    BCMOLT_GPON_NI_PROXY_ID__BEGIN,
    BCMOLT_GPON_NI_PROXY_ID_BROADCAST_PLOAM_PACKET                                          = 0,    /**< Broadcast PLOAM Packet. */
    BCMOLT_GPON_NI_PROXY_ID_CPU_PACKETS,    /**< GPON CPU Packets. */
    BCMOLT_GPON_NI_PROXY_ID__NUM_OF         /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_ni_proxy_id;

/** List of all gpon_onu groups of type auto. 
 */
typedef enum bcmolt_gpon_onu_auto_id
{
    BCMOLT_GPON_ONU_AUTO_ID__BEGIN,
    BCMOLT_GPON_ONU_AUTO_ID_BER_INTERVAL_CONFIGURATION_COMPLETED                            = 0,    /**< BER Interval Configuration Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_DFI,                        /**< Receive Dying-Gasp of ONUi. */
    BCMOLT_GPON_ONU_AUTO_ID_DGI,                        /**< Receive Dying-Gasp of ONUi. */
    BCMOLT_GPON_ONU_AUTO_ID_DOWI,                       /**< Drift of Window of ONUi. */
    BCMOLT_GPON_ONU_AUTO_ID_ERR,                        /**< ERR. */
    BCMOLT_GPON_ONU_AUTO_ID_INVALID_DBRU_REPORT,        /**< Invalid DBRu Report. */
    BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_COMPLETED,     /**< Key Exchange Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_CYCLE_SKIPPED, /**< Key Exchange Cycle Skipped. */
    BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_DECRYPT_REQUIRED,      /**< Key Exchange Decrypt Required. */
    BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_KEY_MISMATCH,          /**< Key Exchange Key Mismatch. */
    BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT,   /**< Key Exchange Key Request Timeout. */
    BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_UNCONSECUTIVE_INDEX,   /**< Key Exchange Unconsecutive Index. */
    BCMOLT_GPON_ONU_AUTO_ID_LOAI,   /**< LOAi. */
    BCMOLT_GPON_ONU_AUTO_ID_LOKI,   /**< LOki. */
    BCMOLT_GPON_ONU_AUTO_ID_MEMI,   /**< MEMi. */
    BCMOLT_GPON_ONU_AUTO_ID_OMCI_PORT_ID_CONFIGURATION_COMPLETED,   /**< OMCI PORT ID Configuration Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_ONU_ACTIVATION_COMPLETED,               /**< ONU Activation Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_ONU_ACTIVATION_STANDBY_COMPLETED,       /**< onu activation standby completed. */
    BCMOLT_GPON_ONU_AUTO_ID_ONU_ALARM,                  /**< ONU Alarm. */
    BCMOLT_GPON_ONU_AUTO_ID_ONU_DEACTIVATION_COMPLETED, /**< ONU Deactivation Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_ONU_DISABLE_COMPLETED,      /**< ONU Disable Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_ONU_ENABLE_COMPLETED,       /**< ONU Enable Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_OPTICAL_REFLECTION,         /**< Optical Reflection. */
    BCMOLT_GPON_ONU_AUTO_ID_PASSWORD_AUTHENTICATION_COMPLETED,  /**< Password Authentication Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_PEE,            /**< PEE. */
    BCMOLT_GPON_ONU_AUTO_ID_POSSIBLE_DRIFT, /**< Possible Drift. */
    BCMOLT_GPON_ONU_AUTO_ID_POWER_MANAGEMENT_STATE_CHANGE,  /**< Power Management State Change. */
    BCMOLT_GPON_ONU_AUTO_ID_PST,                        /**< PST. */
    BCMOLT_GPON_ONU_AUTO_ID_RANGING_COMPLETED,          /**< Ranging Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_REI,                        /**< REI. */
    BCMOLT_GPON_ONU_AUTO_ID_RSSI_MEASUREMENT_COMPLETED, /**< RSSI Measurement Completed. */
    BCMOLT_GPON_ONU_AUTO_ID_SDI,                        /**< Signal Degraded of ONUi. */
    BCMOLT_GPON_ONU_AUTO_ID_SFI,                        /**< Signal Fail of ONUi. */
    BCMOLT_GPON_ONU_AUTO_ID_STAT_ALARM_CLEARED,         /**< Stat Alarm Cleared. */
    BCMOLT_GPON_ONU_AUTO_ID_STAT_ALARM_RAISED,          /**< Stat Alarm Raised. */
    BCMOLT_GPON_ONU_AUTO_ID_SUFI,                       /**< SUFi. */
    BCMOLT_GPON_ONU_AUTO_ID_TIWI,                       /**< Transmission Interference Warning. */
    BCMOLT_GPON_ONU_AUTO_ID__NUM_OF                     /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_auto_id;

/** List of all gpon_onu groups of type oper. 
 */
typedef enum bcmolt_gpon_onu_oper_id
{
    BCMOLT_GPON_ONU_OPER_ID__BEGIN,
    BCMOLT_GPON_ONU_OPER_ID_CHANGE_POWER_LEVEL                                              = 0,    /**< Change Power Level. */
    BCMOLT_GPON_ONU_OPER_ID_RSSI_MEASUREMENT,   /**< RSSI Measurement. */
    BCMOLT_GPON_ONU_OPER_ID_SET_ONU_STATE,      /**< Set ONU State. */
    BCMOLT_GPON_ONU_OPER_ID__NUM_OF             /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_oper_id;

/** List of all gpon_onu groups of type proxy. 
 */
typedef enum bcmolt_gpon_onu_proxy_id
{
    BCMOLT_GPON_ONU_PROXY_ID__BEGIN,
    BCMOLT_GPON_ONU_PROXY_ID_CPU_PACKETS                                                    = 0,    /**< GPON CPU Packets. */
    BCMOLT_GPON_ONU_PROXY_ID_PLOAM_PACKET,  /**< PLOAM Packet. */
    BCMOLT_GPON_ONU_PROXY_ID__NUM_OF        /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_proxy_id;

/** List of all gpon_onu groups of type proxy_rx. 
 */
typedef enum bcmolt_gpon_onu_proxy_rx_id
{
    BCMOLT_GPON_ONU_PROXY_RX_ID__BEGIN,
    BCMOLT_GPON_ONU_PROXY_RX_ID_CPU_PACKET                                                  = 0,    /**< GPON CPU packet. */
    BCMOLT_GPON_ONU_PROXY_RX_ID_OMCI_PACKET,    /**< GPON OMCI packet. */
    BCMOLT_GPON_ONU_PROXY_RX_ID__NUM_OF         /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_proxy_rx_id;

/** List of all log_entry groups of type auto. 
 */
typedef enum bcmolt_log_entry_auto_id
{
    BCMOLT_LOG_ENTRY_AUTO_ID__BEGIN,
    BCMOLT_LOG_ENTRY_AUTO_ID_STAT_ALARM_CLEARED                                             = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_LOG_ENTRY_AUTO_ID_STAT_ALARM_RAISED, /**< Stat Alarm Raised. */
    BCMOLT_LOG_ENTRY_AUTO_ID__NUM_OF            /**< Number of enum entries, not an entry itself. */
} bcmolt_log_entry_auto_id;

/** List of all logger groups of type auto. 
 */
typedef enum bcmolt_logger_auto_id
{
    BCMOLT_LOGGER_AUTO_ID__BEGIN,
    BCMOLT_LOGGER_AUTO_ID_STAT_ALARM_CLEARED                                                = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_LOGGER_AUTO_ID_STAT_ALARM_RAISED,    /**< Stat Alarm Raised. */
    BCMOLT_LOGGER_AUTO_ID__NUM_OF               /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_auto_id;

/** List of all logger groups of type oper. 
 */
typedef enum bcmolt_logger_oper_id
{
    BCMOLT_LOGGER_OPER_ID__BEGIN,
    BCMOLT_LOGGER_OPER_ID_CLEAR_LOG                                                         = 0,    /**< clear log. */
    BCMOLT_LOGGER_OPER_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_logger_oper_id;

/** List of all nni groups of type auto. 
 */
typedef enum bcmolt_nni_auto_id
{
    BCMOLT_NNI_AUTO_ID__BEGIN,
    BCMOLT_NNI_AUTO_ID_STAT_ALARM_CLEARED                                                   = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_NNI_AUTO_ID_STAT_ALARM_RAISED,   /**< Stat Alarm Raised. */
    BCMOLT_NNI_AUTO_ID_STATUS_CHANGED,      /**< Status changed. */
    BCMOLT_NNI_AUTO_ID__NUM_OF              /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_auto_id;

/** List of all trx_calibration groups of type auto. 
 */
typedef enum bcmolt_trx_calibration_auto_id
{
    BCMOLT_TRX_CALIBRATION_AUTO_ID__BEGIN,
    BCMOLT_TRX_CALIBRATION_AUTO_ID_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED                   = 0,    /**< Capture window and statistic completed. */
    BCMOLT_TRX_CALIBRATION_AUTO_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_auto_id;

/** List of all trx_calibration groups of type oper. 
 */
typedef enum bcmolt_trx_calibration_oper_id
{
    BCMOLT_TRX_CALIBRATION_OPER_ID__BEGIN,
    BCMOLT_TRX_CALIBRATION_OPER_ID_START_CAPTURE_WINDOW                                     = 0,    /**< start capture window. */
    BCMOLT_TRX_CALIBRATION_OPER_ID_STOP_CAPTURE_WINDOW, /**< stop capture window. */
    BCMOLT_TRX_CALIBRATION_OPER_ID__NUM_OF              /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_oper_id;

/** List of all xgpon_alloc groups of type auto. 
 */
typedef enum bcmolt_xgpon_alloc_auto_id
{
    BCMOLT_XGPON_ALLOC_AUTO_ID__BEGIN,
    BCMOLT_XGPON_ALLOC_AUTO_ID_CONFIGURATION_COMPLETED                                      = 0,    /**< Configuration Completed. */
    BCMOLT_XGPON_ALLOC_AUTO_ID_GET_ALLOC_STATS_COMPLETED,   /**< Get alloc ID statistics completed. */
    BCMOLT_XGPON_ALLOC_AUTO_ID_STAT_ALARM_CLEARED,          /**< Stat Alarm Cleared. */
    BCMOLT_XGPON_ALLOC_AUTO_ID_STAT_ALARM_RAISED,           /**< Stat Alarm Raised. */
    BCMOLT_XGPON_ALLOC_AUTO_ID__NUM_OF                      /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_auto_id;

/** List of all xgpon_alloc groups of type oper. 
 */
typedef enum bcmolt_xgpon_alloc_oper_id
{
    BCMOLT_XGPON_ALLOC_OPER_ID__BEGIN,
    BCMOLT_XGPON_ALLOC_OPER_ID_GET_STATS                                                    = 0,    /**< Get statistics. */
    BCMOLT_XGPON_ALLOC_OPER_ID_SET_STATE,   /**< Set state. */
    BCMOLT_XGPON_ALLOC_OPER_ID__NUM_OF      /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_alloc_oper_id;

/** List of all xgpon_gem_port groups of type auto. 
 */
typedef enum bcmolt_xgpon_gem_port_auto_id
{
    BCMOLT_XGPON_GEM_PORT_AUTO_ID__BEGIN,
    BCMOLT_XGPON_GEM_PORT_AUTO_ID_STAT_ALARM_CLEARED                                        = 0,    /**< Stat Alarm Cleared. */
    BCMOLT_XGPON_GEM_PORT_AUTO_ID_STAT_ALARM_RAISED,    /**< Stat Alarm Raised. */
    BCMOLT_XGPON_GEM_PORT_AUTO_ID__NUM_OF               /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_gem_port_auto_id;

/** List of all xgpon_ni groups of type auto. 
 */
typedef enum bcmolt_xgpon_ni_auto_id
{
    BCMOLT_XGPON_NI_AUTO_ID__BEGIN,
    BCMOLT_XGPON_NI_AUTO_ID_ACTIVATE_ALL_ONUS_COMPLETED                                     = 0,    /**< activate all onus completed. */
    BCMOLT_XGPON_NI_AUTO_ID_CPU_PACKETS_FAILURE,            /**< CPU Packets Failure. */
    BCMOLT_XGPON_NI_AUTO_ID_DEACTIVATE_ALL_ONUS_COMPLETED,  /**< deactivate all onus completed. */
    BCMOLT_XGPON_NI_AUTO_ID_DISABLE_ALL_ONUS_COMPLETED,     /**< disable all onus completed. */
    BCMOLT_XGPON_NI_AUTO_ID_ENABLE_ALL_ONUS_COMPLETED,      /**< enable all onus completed. */
    BCMOLT_XGPON_NI_AUTO_ID_LOS,                    /**< LOS. */
    BCMOLT_XGPON_NI_AUTO_ID_ONU_DISCOVERED,         /**< ONU Discovered. */
    BCMOLT_XGPON_NI_AUTO_ID_ONU_UPGRADE_COMPLETE,   /**< ONU Upgrade Complete. */
    BCMOLT_XGPON_NI_AUTO_ID_PROTECTION_SWITCHING_ONUS_RANGED,           /**< Protection Switching ONUs Ranged. */
    BCMOLT_XGPON_NI_AUTO_ID_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED,  /**< Protection Switching Switchover Completed. */
    BCMOLT_XGPON_NI_AUTO_ID_PROTECTION_SWITCHING_TRAFFIC_RESUME,        /**< Protection Switching Traffic Resume. */
    BCMOLT_XGPON_NI_AUTO_ID_ROGUE_DETECTION_COMPLETED,                  /**< Rogue detection completed. */
    BCMOLT_XGPON_NI_AUTO_ID_ROGUE_ONU_SPECIAL_MAP_CYCLE_START,          /**< Rogue ONU special map cycle start. */
    BCMOLT_XGPON_NI_AUTO_ID_SERIAL_NUMBER_ACQUISITION_CYCLE_START,      /**< Serial Number Acquisition Cycle Start. */
    BCMOLT_XGPON_NI_AUTO_ID_STANDBY_PON_MONITORING_CYCLE_COMPLETED,     /**< Standby PON Monitoring Cycle Completed. */
    BCMOLT_XGPON_NI_AUTO_ID_STAT_ALARM_CLEARED,     /**< Stat Alarm Cleared. */
    BCMOLT_XGPON_NI_AUTO_ID_STAT_ALARM_RAISED,      /**< Stat Alarm Raised. */
    BCMOLT_XGPON_NI_AUTO_ID_STATE_CHANGE_COMPLETED, /**< State Change Completed. */
    BCMOLT_XGPON_NI_AUTO_ID_TOD_REQUEST_COMPLETED,  /**< TOD request completed. */
    BCMOLT_XGPON_NI_AUTO_ID__NUM_OF                 /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_auto_id;

/** List of all xgpon_ni groups of type oper. 
 */
typedef enum bcmolt_xgpon_ni_oper_id
{
    BCMOLT_XGPON_NI_OPER_ID__BEGIN,
    BCMOLT_XGPON_NI_OPER_ID_ADJUST_TX_WAVELENGTH                                            = 0,    /**< Adjust Tx Wavelengh. */
    BCMOLT_XGPON_NI_OPER_ID_DISABLE_SERIAL_NUMBER,                  /**< Disable Serial Number. */
    BCMOLT_XGPON_NI_OPER_ID_RESET,                                  /**< Reset. */
    BCMOLT_XGPON_NI_OPER_ID_ROGUE_DETECTION_WINDOW,                 /**< Rogue Detection Window. */
    BCMOLT_XGPON_NI_OPER_ID_RUN_SPECIAL_BW_MAP,                     /**< Run Special BW Map. */
    BCMOLT_XGPON_NI_OPER_ID_SET_ONU_STATE,                          /**< Set ONU State. */
    BCMOLT_XGPON_NI_OPER_ID_SET_PON_STATE,                          /**< Set PON State. */
    BCMOLT_XGPON_NI_OPER_ID_SINGLE_REQUEST_STANDBY_PON_MONITORING,  /**< Single request standby PON Monitoring. */
    BCMOLT_XGPON_NI_OPER_ID_START_ONU_UPGRADE,                      /**< Start ONU Firmware Upgrade. */
    BCMOLT_XGPON_NI_OPER_ID_TOD_REQUEST,    /**< TOD request. */
    BCMOLT_XGPON_NI_OPER_ID__NUM_OF         /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_oper_id;

/** List of all xgpon_ni groups of type proxy. 
 */
typedef enum bcmolt_xgpon_ni_proxy_id
{
    BCMOLT_XGPON_NI_PROXY_ID__BEGIN,
    BCMOLT_XGPON_NI_PROXY_ID_BROADCAST_PLOAM_PACKET                                         = 0,    /**< Broadcast PLOAM Packet. */
    BCMOLT_XGPON_NI_PROXY_ID_CPU_PACKETS,   /**< XGPON CPU packets. */
    BCMOLT_XGPON_NI_PROXY_ID__NUM_OF        /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_ni_proxy_id;

/** List of all xgpon_onu groups of type auto. 
 */
typedef enum bcmolt_xgpon_onu_auto_id
{
    BCMOLT_XGPON_ONU_AUTO_ID__BEGIN,
    BCMOLT_XGPON_ONU_AUTO_ID_DFI                                                            = 0,    /**< Receive Dying-Gasp of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_ID_DGI,                       /**< Receive Dying-Gasp of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_ID_DOWI,                      /**< Drift of Window of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_ID_INVALID_DBRU_REPORT,       /**< Invalid DBRu Report. */
    BCMOLT_XGPON_ONU_AUTO_ID_KEY_EXCHANGE_COMPLETED,    /**< Key Exchange Completed. */
    BCMOLT_XGPON_ONU_AUTO_ID_KEY_EXCHANGE_CYCLE_SKIPPED,        /**< Key Exchange Cycle Skipped. */
    BCMOLT_XGPON_ONU_AUTO_ID_KEY_EXCHANGE_KEY_MISMATCH,         /**< Key Exchange Key Mismatch. */
    BCMOLT_XGPON_ONU_AUTO_ID_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT,  /**< Key Exchange Key Request Timeout. */
    BCMOLT_XGPON_ONU_AUTO_ID_LOOCI,                     /**< LOOCi. */
    BCMOLT_XGPON_ONU_AUTO_ID_ONU_ACTIVATION_COMPLETED,  /**< ONU Activation Completed. */
    BCMOLT_XGPON_ONU_AUTO_ID_ONU_ALARM,                 /**< ONU Alarm. */
    BCMOLT_XGPON_ONU_AUTO_ID_ONU_DEACTIVATION_COMPLETED,    /**< ONU Deactivation Completed. */
    BCMOLT_XGPON_ONU_AUTO_ID_ONU_DISABLE_COMPLETED,         /**< ONU Disable Completed. */
    BCMOLT_XGPON_ONU_AUTO_ID_ONU_ENABLE_COMPLETED,          /**< ONU Enable Completed. */
    BCMOLT_XGPON_ONU_AUTO_ID_ONU_TUNING_IN_COMPLETED,       /**< ONU Tuning in completed. */
    BCMOLT_XGPON_ONU_AUTO_ID_ONU_TUNING_OUT_COMPLETED,      /**< ONU Tuning out completed. */
    BCMOLT_XGPON_ONU_AUTO_ID_OPTICAL_REFLECTION,            /**< Optical Reflection. */
    BCMOLT_XGPON_ONU_AUTO_ID_POSSIBLE_DRIFT,                /**< Possible Drift. */
    BCMOLT_XGPON_ONU_AUTO_ID_POWER_CONSUMPTION_REPORT,      /**< Power consumption report. */
    BCMOLT_XGPON_ONU_AUTO_ID_POWER_LEVEL_REPORT,            /**< Power level report. */
    BCMOLT_XGPON_ONU_AUTO_ID_POWER_MANAGEMENT_STATE_CHANGE, /**< Power Management State Change. */
    BCMOLT_XGPON_ONU_AUTO_ID_PQSI,              /**< ploam queue status. */
    BCMOLT_XGPON_ONU_AUTO_ID_RANGING_COMPLETED, /**< Ranging Completed. */
    BCMOLT_XGPON_ONU_AUTO_ID_REGISTRATION_ID,   /**< Registration ID. */
    BCMOLT_XGPON_ONU_AUTO_ID_RSSI_MEASUREMENT_COMPLETED,    /**< RSSI Measurement Completed. */
    BCMOLT_XGPON_ONU_AUTO_ID_SDI,   /**< Signal Degraded of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_ID_SECURE_MUTUAL_AUTHENTICATION_FAILURE,  /**< secure mutual authentication failure. */
    BCMOLT_XGPON_ONU_AUTO_ID_SFI,                   /**< Signal Fail of ONUi. */
    BCMOLT_XGPON_ONU_AUTO_ID_STAT_ALARM_CLEARED,    /**< Stat Alarm Cleared. */
    BCMOLT_XGPON_ONU_AUTO_ID_STAT_ALARM_RAISED,     /**< Stat Alarm Raised. */
    BCMOLT_XGPON_ONU_AUTO_ID_SUFI,                  /**< SUFi. */
    BCMOLT_XGPON_ONU_AUTO_ID_TIWI,                  /**< Transmission Interference Warning. */
    BCMOLT_XGPON_ONU_AUTO_ID_TUNING_RESPONSE,       /**< Tuning response. */
    BCMOLT_XGPON_ONU_AUTO_ID__NUM_OF                /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_auto_id;

/** List of all xgpon_onu groups of type oper. 
 */
typedef enum bcmolt_xgpon_onu_oper_id
{
    BCMOLT_XGPON_ONU_OPER_ID__BEGIN,
    BCMOLT_XGPON_ONU_OPER_ID_ADJUST_TX_WAVELENGTH                                           = 0,    /**< Adjust Tx wavelength. */
    BCMOLT_XGPON_ONU_OPER_ID_CHANGE_POWER_LEVELLING,        /**< Change power levelling. */
    BCMOLT_XGPON_ONU_OPER_ID_GET_POWER_CONSUMPTION,         /**< Get power consumption. */
    BCMOLT_XGPON_ONU_OPER_ID_GET_POWER_LEVEL,               /**< Get power level. */
    BCMOLT_XGPON_ONU_OPER_ID_ONU_TUNING_IN,                 /**< ONU Tuning in. */
    BCMOLT_XGPON_ONU_OPER_ID_ONU_TUNING_OUT,                /**< ONU Tuning out. */
    BCMOLT_XGPON_ONU_OPER_ID_REQUEST_REGISTRATION,          /**< Request registration. */
    BCMOLT_XGPON_ONU_OPER_ID_RSSI_MEASUREMENT,              /**< RSSI Measurement. */
    BCMOLT_XGPON_ONU_OPER_ID_SECURE_MUTUAL_AUTHENTICATION,  /**< Secure mutual authentication. */
    BCMOLT_XGPON_ONU_OPER_ID_SET_ONU_STATE,                 /**< Set ONU State. */
    BCMOLT_XGPON_ONU_OPER_ID__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_oper_id;

/** List of all xgpon_onu groups of type proxy. 
 */
typedef enum bcmolt_xgpon_onu_proxy_id
{
    BCMOLT_XGPON_ONU_PROXY_ID__BEGIN,
    BCMOLT_XGPON_ONU_PROXY_ID_CPU_PACKETS                                                   = 0,    /**< XGPON CPU packets. */
    BCMOLT_XGPON_ONU_PROXY_ID_PLOAM_PACKET, /**< PLOAM Packet. */
    BCMOLT_XGPON_ONU_PROXY_ID__NUM_OF       /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_proxy_id;

/** List of all xgpon_onu groups of type proxy_rx. 
 */
typedef enum bcmolt_xgpon_onu_proxy_rx_id
{
    BCMOLT_XGPON_ONU_PROXY_RX_ID__BEGIN,
    BCMOLT_XGPON_ONU_PROXY_RX_ID_CPU_PACKET                                                 = 0,    /**< XGPON CPU packet. */
    BCMOLT_XGPON_ONU_PROXY_RX_ID_OMCI_PACKET,   /**< XGPON OMCI packet. */
    BCMOLT_XGPON_ONU_PROXY_RX_ID__NUM_OF        /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_onu_proxy_rx_id;

#define bcmolt_ae_ni_key_id_all_properties                                                  BCMOLT_AE_NI_KEY_ID__NUM_OF
#define bcmolt_ae_ni_cfg_id_all_properties                                                  BCMOLT_AE_NI_CFG_ID__NUM_OF
#define bcmolt_ae_ni_set_ae_ni_en_state_id_all_properties                                   BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID__NUM_OF
#define bcmolt_ae_path_ds_key_id_all_properties                                             BCMOLT_AE_PATH_DS_KEY_ID__NUM_OF
#define bcmolt_ae_path_ds_stat_id_all_properties                                            BCMOLT_AE_PATH_DS_STAT_ID__NUM_OF
#define bcmolt_ae_path_ds_stat_cfg_id_all_properties                                        BCMOLT_AE_PATH_DS_STAT_CFG_ID__NUM_OF
#define bcmolt_ae_path_ds_stat_alarm_raised_id_all_properties                               BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_ae_path_ds_stat_alarm_cleared_id_all_properties                              BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_ae_path_ds_auto_cfg_id_all_properties                                        BCMOLT_AE_PATH_DS_AUTO_CFG_ID__NUM_OF
#define bcmolt_ae_path_us_key_id_all_properties                                             BCMOLT_AE_PATH_US_KEY_ID__NUM_OF
#define bcmolt_ae_path_us_stat_id_all_properties                                            BCMOLT_AE_PATH_US_STAT_ID__NUM_OF
#define bcmolt_ae_path_us_stat_cfg_id_all_properties                                        BCMOLT_AE_PATH_US_STAT_CFG_ID__NUM_OF
#define bcmolt_ae_path_us_stat_alarm_raised_id_all_properties                               BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_ae_path_us_stat_alarm_cleared_id_all_properties                              BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_ae_path_us_auto_cfg_id_all_properties                                        BCMOLT_AE_PATH_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_channel_key_id_all_properties                                                BCMOLT_CHANNEL_KEY_ID__NUM_OF
#define bcmolt_channel_cfg_id_all_properties                                                BCMOLT_CHANNEL_CFG_ID__NUM_OF
#define bcmolt_debug_key_id_all_properties                                                  BCMOLT_DEBUG_KEY_ID__NUM_OF
#define bcmolt_debug_cli_input_id_all_properties                                            BCMOLT_DEBUG_CLI_INPUT_ID__NUM_OF
#define bcmolt_debug_cli_output_id_all_properties                                           BCMOLT_DEBUG_CLI_OUTPUT_ID__NUM_OF
#define bcmolt_debug_cfg_id_all_properties                                                  BCMOLT_DEBUG_CFG_ID__NUM_OF
#define bcmolt_debug_file_almost_full_id_all_properties                                     BCMOLT_DEBUG_FILE_ALMOST_FULL_ID__NUM_OF
#define bcmolt_debug_start_api_capture_id_all_properties                                    BCMOLT_DEBUG_START_API_CAPTURE_ID__NUM_OF
#define bcmolt_debug_stop_api_capture_id_all_properties                                     BCMOLT_DEBUG_STOP_API_CAPTURE_ID__NUM_OF
#define bcmolt_debug_reset_api_capture_id_all_properties                                    BCMOLT_DEBUG_RESET_API_CAPTURE_ID__NUM_OF
#define bcmolt_debug_auto_cfg_id_all_properties                                             BCMOLT_DEBUG_AUTO_CFG_ID__NUM_OF
#define bcmolt_device_cfg_id_all_properties                                                 BCMOLT_DEVICE_CFG_ID__NUM_OF
#define bcmolt_device_key_id_all_properties                                                 BCMOLT_DEVICE_KEY_ID__NUM_OF
#define bcmolt_device_connect_id_all_properties                                             BCMOLT_DEVICE_CONNECT_ID__NUM_OF
#define bcmolt_device_disconnect_id_all_properties                                          BCMOLT_DEVICE_DISCONNECT_ID__NUM_OF
#define bcmolt_device_reset_id_all_properties                                               BCMOLT_DEVICE_RESET_ID__NUM_OF
#define bcmolt_device_host_keep_alive_id_all_properties                                     BCMOLT_DEVICE_HOST_KEEP_ALIVE_ID__NUM_OF
#define bcmolt_device_sw_upgrade_activate_id_all_properties                                 BCMOLT_DEVICE_SW_UPGRADE_ACTIVATE_ID__NUM_OF
#define bcmolt_device_device_ready_id_all_properties                                        BCMOLT_DEVICE_DEVICE_READY_ID__NUM_OF
#define bcmolt_device_connection_established_id_all_properties                              BCMOLT_DEVICE_CONNECTION_ESTABLISHED_ID__NUM_OF
#define bcmolt_device_device_keep_alive_id_all_properties                                   BCMOLT_DEVICE_DEVICE_KEEP_ALIVE_ID__NUM_OF
#define bcmolt_device_connection_failure_id_all_properties                                  BCMOLT_DEVICE_CONNECTION_FAILURE_ID__NUM_OF
#define bcmolt_device_connection_complete_id_all_properties                                 BCMOLT_DEVICE_CONNECTION_COMPLETE_ID__NUM_OF
#define bcmolt_device_disconnection_complete_id_all_properties                              BCMOLT_DEVICE_DISCONNECTION_COMPLETE_ID__NUM_OF
#define bcmolt_device_sw_error_id_all_properties                                            BCMOLT_DEVICE_SW_ERROR_ID__NUM_OF
#define bcmolt_device_sw_exception_id_all_properties                                        BCMOLT_DEVICE_SW_EXCEPTION_ID__NUM_OF
#define bcmolt_device_indications_dropped_id_all_properties                                 BCMOLT_DEVICE_INDICATIONS_DROPPED_ID__NUM_OF
#define bcmolt_device_image_transfer_start_id_all_properties                                BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID__NUM_OF
#define bcmolt_device_image_transfer_data_id_all_properties                                 BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID__NUM_OF
#define bcmolt_device_image_transfer_complete_id_all_properties                             BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID__NUM_OF
#define bcmolt_device_run_ddr_test_id_all_properties                                        BCMOLT_DEVICE_RUN_DDR_TEST_ID__NUM_OF
#define bcmolt_device_ddr_test_complete_id_all_properties                                   BCMOLT_DEVICE_DDR_TEST_COMPLETE_ID__NUM_OF
#define bcmolt_device_auto_cfg_id_all_properties                                            BCMOLT_DEVICE_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_denied_link_key_id_all_properties                                       BCMOLT_EPON_DENIED_LINK_KEY_ID__NUM_OF
#define bcmolt_epon_denied_link_cfg_id_all_properties                                       BCMOLT_EPON_DENIED_LINK_CFG_ID__NUM_OF
#define bcmolt_epon_denied_link_unknown_link_violation_id_all_properties                    BCMOLT_EPON_DENIED_LINK_UNKNOWN_LINK_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_overhead_profile_violation_id_all_properties                BCMOLT_EPON_DENIED_LINK_OVERHEAD_PROFILE_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_laser_on_off_violation_id_all_properties                    BCMOLT_EPON_DENIED_LINK_LASER_ON_OFF_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_max_link_violation_id_all_properties                        BCMOLT_EPON_DENIED_LINK_MAX_LINK_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_llid_pool_empty_violation_id_all_properties                 BCMOLT_EPON_DENIED_LINK_LLID_POOL_EMPTY_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_system_resource_violation_id_all_properties                 BCMOLT_EPON_DENIED_LINK_SYSTEM_RESOURCE_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_range_violation_id_all_properties                           BCMOLT_EPON_DENIED_LINK_RANGE_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_tdm_channels_exhausted_id_all_properties                    BCMOLT_EPON_DENIED_LINK_TDM_CHANNELS_EXHAUSTED_ID__NUM_OF
#define bcmolt_epon_denied_link_rogue_violation_id_all_properties                           BCMOLT_EPON_DENIED_LINK_ROGUE_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_upstream_bandwidth_violation_id_all_properties              BCMOLT_EPON_DENIED_LINK_UPSTREAM_BANDWIDTH_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_auto_cfg_id_all_properties                                  BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_link_key_id_all_properties                                              BCMOLT_EPON_LINK_KEY_ID__NUM_OF
#define bcmolt_epon_link_cfg_id_all_properties                                              BCMOLT_EPON_LINK_CFG_ID__NUM_OF
#define bcmolt_epon_link_stat_id_all_properties                                             BCMOLT_EPON_LINK_STAT_ID__NUM_OF
#define bcmolt_epon_link_force_rediscovery_id_all_properties                                BCMOLT_EPON_LINK_FORCE_REDISCOVERY_ID__NUM_OF
#define bcmolt_epon_link_delete_link_id_all_properties                                      BCMOLT_EPON_LINK_DELETE_LINK_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_failure_id_all_properties                             BCMOLT_EPON_LINK_KEY_EXCHANGE_FAILURE_ID__NUM_OF
#define bcmolt_epon_link_encryption_enabled_id_all_properties                               BCMOLT_EPON_LINK_ENCRYPTION_ENABLED_ID__NUM_OF
#define bcmolt_epon_link_mpcp_reg_ack_timeout_id_all_properties                             BCMOLT_EPON_LINK_MPCP_REG_ACK_TIMEOUT_ID__NUM_OF
#define bcmolt_epon_link_range_value_changed_id_all_properties                              BCMOLT_EPON_LINK_RANGE_VALUE_CHANGED_ID__NUM_OF
#define bcmolt_epon_link_protection_switch_occurred_id_all_properties                       BCMOLT_EPON_LINK_PROTECTION_SWITCH_OCCURRED_ID__NUM_OF
#define bcmolt_epon_link_duplicate_mpcp_registration_request_id_all_properties              BCMOLT_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST_ID__NUM_OF
#define bcmolt_epon_link_link_speed_mismatch_id_all_properties                              BCMOLT_EPON_LINK_LINK_SPEED_MISMATCH_ID__NUM_OF
#define bcmolt_epon_link_mpcp_report_timeout_id_all_properties                              BCMOLT_EPON_LINK_MPCP_REPORT_TIMEOUT_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timeout_id_all_properties                            BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMEOUT_ID__NUM_OF
#define bcmolt_epon_link_mpcp_discovered_id_all_properties                                  BCMOLT_EPON_LINK_MPCP_DISCOVERED_ID__NUM_OF
#define bcmolt_epon_link_mpcp_deregistered_id_all_properties                                BCMOLT_EPON_LINK_MPCP_DEREGISTERED_ID__NUM_OF
#define bcmolt_epon_link_preprovisioned_link_created_id_all_properties                      BCMOLT_EPON_LINK_PREPROVISIONED_LINK_CREATED_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timer_start_id_all_properties                        BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_START_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timer_stop_id_all_properties                         BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_STOP_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_start_id_all_properties                               BCMOLT_EPON_LINK_KEY_EXCHANGE_START_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_stop_id_all_properties                                BCMOLT_EPON_LINK_KEY_EXCHANGE_STOP_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timer_started_id_all_properties                      BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_STARTED_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timer_stopped_id_all_properties                      BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_STOPPED_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_started_id_all_properties                             BCMOLT_EPON_LINK_KEY_EXCHANGE_STARTED_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_stopped_id_all_properties                             BCMOLT_EPON_LINK_KEY_EXCHANGE_STOPPED_ID__NUM_OF
#define bcmolt_epon_link_static_registration_id_all_properties                              BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID__NUM_OF
#define bcmolt_epon_link_static_registration_done_id_all_properties                         BCMOLT_EPON_LINK_STATIC_REGISTRATION_DONE_ID__NUM_OF
#define bcmolt_epon_link_rerange_failure_id_all_properties                                  BCMOLT_EPON_LINK_RERANGE_FAILURE_ID__NUM_OF
#define bcmolt_epon_link_inject_frame_id_all_properties                                     BCMOLT_EPON_LINK_INJECT_FRAME_ID__NUM_OF
#define bcmolt_epon_link_frame_captured_id_all_properties                                   BCMOLT_EPON_LINK_FRAME_CAPTURED_ID__NUM_OF
#define bcmolt_epon_link_link_deleted_id_all_properties                                     BCMOLT_EPON_LINK_LINK_DELETED_ID__NUM_OF
#define bcmolt_epon_link_stat_cfg_id_all_properties                                         BCMOLT_EPON_LINK_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_link_stat_alarm_raised_id_all_properties                                BCMOLT_EPON_LINK_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_link_stat_alarm_cleared_id_all_properties                               BCMOLT_EPON_LINK_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_link_auto_cfg_id_all_properties                                         BCMOLT_EPON_LINK_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_ni_key_id_all_properties                                                BCMOLT_EPON_NI_KEY_ID__NUM_OF
#define bcmolt_epon_ni_cfg_id_all_properties                                                BCMOLT_EPON_NI_CFG_ID__NUM_OF
#define bcmolt_epon_ni_set_epon_ni_en_state_id_all_properties                               BCMOLT_EPON_NI_SET_EPON_NI_EN_STATE_ID__NUM_OF
#define bcmolt_epon_ni_issue_rssi_grant_id_all_properties                                   BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID__NUM_OF
#define bcmolt_epon_ni_add_link_id_all_properties                                           BCMOLT_EPON_NI_ADD_LINK_ID__NUM_OF
#define bcmolt_epon_ni_add_multicast_link_id_all_properties                                 BCMOLT_EPON_NI_ADD_MULTICAST_LINK_ID__NUM_OF
#define bcmolt_epon_ni_add_protected_standby_link_id_all_properties                         BCMOLT_EPON_NI_ADD_PROTECTED_STANDBY_LINK_ID__NUM_OF
#define bcmolt_epon_ni_no_reports_id_all_properties                                         BCMOLT_EPON_NI_NO_REPORTS_ID__NUM_OF
#define bcmolt_epon_ni_llid_quarantined_id_all_properties                                   BCMOLT_EPON_NI_LLID_QUARANTINED_ID__NUM_OF
#define bcmolt_epon_ni_state_change_completed_id_all_properties                             BCMOLT_EPON_NI_STATE_CHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_epon_ni_protection_switching_apply_rerange_delta_id_all_properties           BCMOLT_EPON_NI_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA_ID__NUM_OF
#define bcmolt_epon_ni_rerange_failure_id_all_properties                                    BCMOLT_EPON_NI_RERANGE_FAILURE_ID__NUM_OF
#define bcmolt_epon_ni_rssi_measurement_completed_id_all_properties                         BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID__NUM_OF
#define bcmolt_epon_ni_rogue_llid_scan_id_all_properties                                    BCMOLT_EPON_NI_ROGUE_LLID_SCAN_ID__NUM_OF
#define bcmolt_epon_ni_start_onu_upgrade_id_all_properties                                  BCMOLT_EPON_NI_START_ONU_UPGRADE_ID__NUM_OF
#define bcmolt_epon_ni_onu_upgrade_complete_id_all_properties                               BCMOLT_EPON_NI_ONU_UPGRADE_COMPLETE_ID__NUM_OF
#define bcmolt_epon_ni_rogue_scan_complete_id_all_properties                                BCMOLT_EPON_NI_ROGUE_SCAN_COMPLETE_ID__NUM_OF
#define bcmolt_epon_ni_mpcp_timestamp_changed_id_all_properties                             BCMOLT_EPON_NI_MPCP_TIMESTAMP_CHANGED_ID__NUM_OF
#define bcmolt_epon_ni_auto_rogue_scan_1g_failure_id_all_properties                         BCMOLT_EPON_NI_AUTO_ROGUE_SCAN_1G_FAILURE_ID__NUM_OF
#define bcmolt_epon_ni_auto_rogue_scan_10g_failure_id_all_properties                        BCMOLT_EPON_NI_AUTO_ROGUE_SCAN_10G_FAILURE_ID__NUM_OF
#define bcmolt_epon_ni_auto_cfg_id_all_properties                                           BCMOLT_EPON_NI_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_key_id_all_properties                                        BCMOLT_EPON_ONU_10G_US_KEY_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_stat_id_all_properties                                       BCMOLT_EPON_ONU_10G_US_STAT_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_cfg_id_all_properties                                        BCMOLT_EPON_ONU_10G_US_CFG_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_stat_cfg_id_all_properties                                   BCMOLT_EPON_ONU_10G_US_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_stat_alarm_raised_id_all_properties                          BCMOLT_EPON_ONU_10G_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_stat_alarm_cleared_id_all_properties                         BCMOLT_EPON_ONU_10G_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_auto_cfg_id_all_properties                                   BCMOLT_EPON_ONU_10G_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_key_id_all_properties                                         BCMOLT_EPON_ONU_1G_US_KEY_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_stat_id_all_properties                                        BCMOLT_EPON_ONU_1G_US_STAT_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_cfg_id_all_properties                                         BCMOLT_EPON_ONU_1G_US_CFG_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_stat_cfg_id_all_properties                                    BCMOLT_EPON_ONU_1G_US_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_stat_alarm_raised_id_all_properties                           BCMOLT_EPON_ONU_1G_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_stat_alarm_cleared_id_all_properties                          BCMOLT_EPON_ONU_1G_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_auto_cfg_id_all_properties                                    BCMOLT_EPON_ONU_1G_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_key_id_all_properties                                       BCMOLT_EPON_PATH_10G_DS_KEY_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_cfg_id_all_properties                                       BCMOLT_EPON_PATH_10G_DS_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_stat_id_all_properties                                      BCMOLT_EPON_PATH_10G_DS_STAT_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_stat_cfg_id_all_properties                                  BCMOLT_EPON_PATH_10G_DS_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_stat_alarm_raised_id_all_properties                         BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_stat_alarm_cleared_id_all_properties                        BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_auto_cfg_id_all_properties                                  BCMOLT_EPON_PATH_10G_DS_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_us_key_id_all_properties                                       BCMOLT_EPON_PATH_10G_US_KEY_ID__NUM_OF
#define bcmolt_epon_path_10g_us_cfg_id_all_properties                                       BCMOLT_EPON_PATH_10G_US_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_us_stat_id_all_properties                                      BCMOLT_EPON_PATH_10G_US_STAT_ID__NUM_OF
#define bcmolt_epon_path_10g_us_stat_cfg_id_all_properties                                  BCMOLT_EPON_PATH_10G_US_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_us_stat_alarm_raised_id_all_properties                         BCMOLT_EPON_PATH_10G_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_path_10g_us_stat_alarm_cleared_id_all_properties                        BCMOLT_EPON_PATH_10G_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_path_10g_us_auto_cfg_id_all_properties                                  BCMOLT_EPON_PATH_10G_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_key_id_all_properties                                        BCMOLT_EPON_PATH_1G_DS_KEY_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_cfg_id_all_properties                                        BCMOLT_EPON_PATH_1G_DS_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_stat_id_all_properties                                       BCMOLT_EPON_PATH_1G_DS_STAT_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_stat_cfg_id_all_properties                                   BCMOLT_EPON_PATH_1G_DS_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_stat_alarm_raised_id_all_properties                          BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_stat_alarm_cleared_id_all_properties                         BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_auto_cfg_id_all_properties                                   BCMOLT_EPON_PATH_1G_DS_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_us_key_id_all_properties                                        BCMOLT_EPON_PATH_1G_US_KEY_ID__NUM_OF
#define bcmolt_epon_path_1g_us_cfg_id_all_properties                                        BCMOLT_EPON_PATH_1G_US_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_us_stat_id_all_properties                                       BCMOLT_EPON_PATH_1G_US_STAT_ID__NUM_OF
#define bcmolt_epon_path_1g_us_stat_cfg_id_all_properties                                   BCMOLT_EPON_PATH_1G_US_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_us_stat_alarm_raised_id_all_properties                          BCMOLT_EPON_PATH_1G_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_path_1g_us_stat_alarm_cleared_id_all_properties                         BCMOLT_EPON_PATH_1G_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_path_1g_us_auto_cfg_id_all_properties                                   BCMOLT_EPON_PATH_1G_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_rp_key_id_all_properties                                                BCMOLT_EPON_RP_KEY_ID__NUM_OF
#define bcmolt_epon_rp_cfg_id_all_properties                                                BCMOLT_EPON_RP_CFG_ID__NUM_OF
#define bcmolt_gpio_key_id_all_properties                                                   BCMOLT_GPIO_KEY_ID__NUM_OF
#define bcmolt_gpio_cfg_id_all_properties                                                   BCMOLT_GPIO_CFG_ID__NUM_OF
#define bcmolt_gpon_alloc_key_id_all_properties                                             BCMOLT_GPON_ALLOC_KEY_ID__NUM_OF
#define bcmolt_gpon_alloc_cfg_id_all_properties                                             BCMOLT_GPON_ALLOC_CFG_ID__NUM_OF
#define bcmolt_gpon_alloc_stat_id_all_properties                                            BCMOLT_GPON_ALLOC_STAT_ID__NUM_OF
#define bcmolt_gpon_alloc_configuration_completed_id_all_properties                         BCMOLT_GPON_ALLOC_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_alloc_set_state_id_all_properties                                       BCMOLT_GPON_ALLOC_SET_STATE_ID__NUM_OF
#define bcmolt_gpon_alloc_get_stats_id_all_properties                                       BCMOLT_GPON_ALLOC_GET_STATS_ID__NUM_OF
#define bcmolt_gpon_alloc_get_alloc_stats_completed_id_all_properties                       BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_alloc_stat_cfg_id_all_properties                                        BCMOLT_GPON_ALLOC_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_alloc_stat_alarm_raised_id_all_properties                               BCMOLT_GPON_ALLOC_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_alloc_stat_alarm_cleared_id_all_properties                              BCMOLT_GPON_ALLOC_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_alloc_auto_cfg_id_all_properties                                        BCMOLT_GPON_ALLOC_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_gem_port_key_id_all_properties                                          BCMOLT_GPON_GEM_PORT_KEY_ID__NUM_OF
#define bcmolt_gpon_gem_port_cfg_id_all_properties                                          BCMOLT_GPON_GEM_PORT_CFG_ID__NUM_OF
#define bcmolt_gpon_gem_port_stat_id_all_properties                                         BCMOLT_GPON_GEM_PORT_STAT_ID__NUM_OF
#define bcmolt_gpon_gem_port_configuration_completed_id_all_properties                      BCMOLT_GPON_GEM_PORT_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_gem_port_set_state_id_all_properties                                    BCMOLT_GPON_GEM_PORT_SET_STATE_ID__NUM_OF
#define bcmolt_gpon_gem_port_stat_cfg_id_all_properties                                     BCMOLT_GPON_GEM_PORT_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_gem_port_stat_alarm_raised_id_all_properties                            BCMOLT_GPON_GEM_PORT_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_gem_port_stat_alarm_cleared_id_all_properties                           BCMOLT_GPON_GEM_PORT_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_gem_port_auto_cfg_id_all_properties                                     BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_key_id_all_properties                                               BCMOLT_GPON_IWF_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_cfg_id_all_properties                                               BCMOLT_GPON_IWF_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_stat_id_all_properties                                              BCMOLT_GPON_IWF_STAT_ID__NUM_OF
#define bcmolt_gpon_iwf_flush_mac_table_id_all_properties                                   BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID__NUM_OF
#define bcmolt_gpon_iwf_scan_mac_table_id_all_properties                                    BCMOLT_GPON_IWF_SCAN_MAC_TABLE_ID__NUM_OF
#define bcmolt_gpon_iwf_flush_mac_table_completed_id_all_properties                         BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_iwf_scan_mac_table_completed_id_all_properties                          BCMOLT_GPON_IWF_SCAN_MAC_TABLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_iwf_stat_cfg_id_all_properties                                          BCMOLT_GPON_IWF_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_stat_alarm_raised_id_all_properties                                 BCMOLT_GPON_IWF_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_iwf_stat_alarm_cleared_id_all_properties                                BCMOLT_GPON_IWF_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_iwf_auto_cfg_id_all_properties                                          BCMOLT_GPON_IWF_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_ds_egress_flow_key_id_all_properties                                BCMOLT_GPON_IWF_DS_EGRESS_FLOW_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_ds_egress_flow_cfg_id_all_properties                                BCMOLT_GPON_IWF_DS_EGRESS_FLOW_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_ds_ingress_flow_key_id_all_properties                               BCMOLT_GPON_IWF_DS_INGRESS_FLOW_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_ds_ingress_flow_cfg_id_all_properties                               BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_key_id_all_properties                                     BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_cfg_id_all_properties                                     BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_new_mac_id_all_properties                                 BCMOLT_GPON_IWF_MAC_TABLE_NEW_MAC_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_mac_aged_id_all_properties                                BCMOLT_GPON_IWF_MAC_TABLE_MAC_AGED_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_mac_move_id_all_properties                                BCMOLT_GPON_IWF_MAC_TABLE_MAC_MOVE_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_mac_dropped_id_all_properties                             BCMOLT_GPON_IWF_MAC_TABLE_MAC_DROPPED_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_auto_cfg_id_all_properties                                BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_us_flow_key_id_all_properties                                       BCMOLT_GPON_IWF_US_FLOW_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_us_flow_cfg_id_all_properties                                       BCMOLT_GPON_IWF_US_FLOW_CFG_ID__NUM_OF
#define bcmolt_gpon_ni_key_id_all_properties                                                BCMOLT_GPON_NI_KEY_ID__NUM_OF
#define bcmolt_gpon_ni_cfg_id_all_properties                                                BCMOLT_GPON_NI_CFG_ID__NUM_OF
#define bcmolt_gpon_ni_stat_id_all_properties                                               BCMOLT_GPON_NI_STAT_ID__NUM_OF
#define bcmolt_gpon_ni_set_pon_state_id_all_properties                                      BCMOLT_GPON_NI_SET_PON_STATE_ID__NUM_OF
#define bcmolt_gpon_ni_reset_id_all_properties                                              BCMOLT_GPON_NI_RESET_ID__NUM_OF
#define bcmolt_gpon_ni_disable_serial_number_id_all_properties                              BCMOLT_GPON_NI_DISABLE_SERIAL_NUMBER_ID__NUM_OF
#define bcmolt_gpon_ni_single_request_standby_pon_monitoring_id_all_properties              BCMOLT_GPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING_ID__NUM_OF
#define bcmolt_gpon_ni_set_onu_state_id_all_properties                                      BCMOLT_GPON_NI_SET_ONU_STATE_ID__NUM_OF
#define bcmolt_gpon_ni_state_change_completed_id_all_properties                             BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_los_id_all_properties                                                BCMOLT_GPON_NI_LOS_ID__NUM_OF
#define bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id_all_properties              BCMOLT_GPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START_ID__NUM_OF
#define bcmolt_gpon_ni_protection_switching_traffic_resume_id_all_properties                BCMOLT_GPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID__NUM_OF
#define bcmolt_gpon_ni_protection_switching_onus_ranged_id_all_properties                   BCMOLT_GPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID__NUM_OF
#define bcmolt_gpon_ni_protection_switching_switchover_completed_id_all_properties          BCMOLT_GPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id_all_properties             BCMOLT_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_onu_discovered_id_all_properties                                     BCMOLT_GPON_NI_ONU_DISCOVERED_ID__NUM_OF
#define bcmolt_gpon_ni_cpu_packets_failure_id_all_properties                                BCMOLT_GPON_NI_CPU_PACKETS_FAILURE_ID__NUM_OF
#define bcmolt_gpon_ni_cpu_packets_id_all_properties                                        BCMOLT_GPON_NI_CPU_PACKETS_ID__NUM_OF
#define bcmolt_gpon_ni_broadcast_ploam_packet_id_all_properties                             BCMOLT_GPON_NI_BROADCAST_PLOAM_PACKET_ID__NUM_OF
#define bcmolt_gpon_ni_rogue_detection_window_id_all_properties                             BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID__NUM_OF
#define bcmolt_gpon_ni_rogue_detection_completed_id_all_properties                          BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_deactivate_all_onus_completed_id_all_properties                      BCMOLT_GPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_disable_all_onus_completed_id_all_properties                         BCMOLT_GPON_NI_DISABLE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_activate_all_onus_completed_id_all_properties                        BCMOLT_GPON_NI_ACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_enable_all_onus_completed_id_all_properties                          BCMOLT_GPON_NI_ENABLE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_tod_request_id_all_properties                                        BCMOLT_GPON_NI_TOD_REQUEST_ID__NUM_OF
#define bcmolt_gpon_ni_tod_request_completed_id_all_properties                              BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id_all_properties BCMOLT_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE_ID__NUM_OF
#define bcmolt_gpon_ni_start_onu_upgrade_id_all_properties                                  BCMOLT_GPON_NI_START_ONU_UPGRADE_ID__NUM_OF
#define bcmolt_gpon_ni_onu_upgrade_complete_id_all_properties                               BCMOLT_GPON_NI_ONU_UPGRADE_COMPLETE_ID__NUM_OF
#define bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id_all_properties                  BCMOLT_GPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START_ID__NUM_OF
#define bcmolt_gpon_ni_stat_cfg_id_all_properties                                           BCMOLT_GPON_NI_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_ni_stat_alarm_raised_id_all_properties                                  BCMOLT_GPON_NI_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_ni_stat_alarm_cleared_id_all_properties                                 BCMOLT_GPON_NI_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_ni_auto_cfg_id_all_properties                                           BCMOLT_GPON_NI_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_onu_key_id_all_properties                                               BCMOLT_GPON_ONU_KEY_ID__NUM_OF
#define bcmolt_gpon_onu_cfg_id_all_properties                                               BCMOLT_GPON_ONU_CFG_ID__NUM_OF
#define bcmolt_gpon_onu_stat_id_all_properties                                              BCMOLT_GPON_ONU_STAT_ID__NUM_OF
#define bcmolt_gpon_onu_set_onu_state_id_all_properties                                     BCMOLT_GPON_ONU_SET_ONU_STATE_ID__NUM_OF
#define bcmolt_gpon_onu_rssi_measurement_id_all_properties                                  BCMOLT_GPON_ONU_RSSI_MEASUREMENT_ID__NUM_OF
#define bcmolt_gpon_onu_change_power_level_id_all_properties                                BCMOLT_GPON_ONU_CHANGE_POWER_LEVEL_ID__NUM_OF
#define bcmolt_gpon_onu_onu_alarm_id_all_properties                                         BCMOLT_GPON_ONU_ONU_ALARM_ID__NUM_OF
#define bcmolt_gpon_onu_dowi_id_all_properties                                              BCMOLT_GPON_ONU_DOWI_ID__NUM_OF
#define bcmolt_gpon_onu_sfi_id_all_properties                                               BCMOLT_GPON_ONU_SFI_ID__NUM_OF
#define bcmolt_gpon_onu_sdi_id_all_properties                                               BCMOLT_GPON_ONU_SDI_ID__NUM_OF
#define bcmolt_gpon_onu_dfi_id_all_properties                                               BCMOLT_GPON_ONU_DFI_ID__NUM_OF
#define bcmolt_gpon_onu_sufi_id_all_properties                                              BCMOLT_GPON_ONU_SUFI_ID__NUM_OF
#define bcmolt_gpon_onu_loai_id_all_properties                                              BCMOLT_GPON_ONU_LOAI_ID__NUM_OF
#define bcmolt_gpon_onu_dgi_id_all_properties                                               BCMOLT_GPON_ONU_DGI_ID__NUM_OF
#define bcmolt_gpon_onu_pee_id_all_properties                                               BCMOLT_GPON_ONU_PEE_ID__NUM_OF
#define bcmolt_gpon_onu_pst_id_all_properties                                               BCMOLT_GPON_ONU_PST_ID__NUM_OF
#define bcmolt_gpon_onu_tiwi_id_all_properties                                              BCMOLT_GPON_ONU_TIWI_ID__NUM_OF
#define bcmolt_gpon_onu_loki_id_all_properties                                              BCMOLT_GPON_ONU_LOKI_ID__NUM_OF
#define bcmolt_gpon_onu_memi_id_all_properties                                              BCMOLT_GPON_ONU_MEMI_ID__NUM_OF
#define bcmolt_gpon_onu_omci_port_id_configuration_completed_id_all_properties              BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_ber_interval_configuration_completed_id_all_properties              BCMOLT_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_err_id_all_properties                                               BCMOLT_GPON_ONU_ERR_ID__NUM_OF
#define bcmolt_gpon_onu_rei_id_all_properties                                               BCMOLT_GPON_ONU_REI_ID__NUM_OF
#define bcmolt_gpon_onu_ranging_completed_id_all_properties                                 BCMOLT_GPON_ONU_RANGING_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_password_authentication_completed_id_all_properties                 BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_onu_activation_completed_id_all_properties                          BCMOLT_GPON_ONU_ONU_ACTIVATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_onu_deactivation_completed_id_all_properties                        BCMOLT_GPON_ONU_ONU_DEACTIVATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_onu_enable_completed_id_all_properties                              BCMOLT_GPON_ONU_ONU_ENABLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_onu_disable_completed_id_all_properties                             BCMOLT_GPON_ONU_ONU_DISABLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_invalid_dbru_report_id_all_properties                               BCMOLT_GPON_ONU_INVALID_DBRU_REPORT_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_completed_id_all_properties                            BCMOLT_GPON_ONU_KEY_EXCHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_key_request_timeout_id_all_properties                  BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_cycle_skipped_id_all_properties                        BCMOLT_GPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_key_mismatch_id_all_properties                         BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_unconsecutive_index_id_all_properties                  BCMOLT_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX_ID__NUM_OF
#define bcmolt_gpon_onu_rssi_measurement_completed_id_all_properties                        BCMOLT_GPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_decrypt_required_id_all_properties                     BCMOLT_GPON_ONU_KEY_EXCHANGE_DECRYPT_REQUIRED_ID__NUM_OF
#define bcmolt_gpon_onu_optical_reflection_id_all_properties                                BCMOLT_GPON_ONU_OPTICAL_REFLECTION_ID__NUM_OF
#define bcmolt_gpon_onu_cpu_packets_id_all_properties                                       BCMOLT_GPON_ONU_CPU_PACKETS_ID__NUM_OF
#define bcmolt_gpon_onu_ploam_packet_id_all_properties                                      BCMOLT_GPON_ONU_PLOAM_PACKET_ID__NUM_OF
#define bcmolt_gpon_onu_cpu_packet_id_all_properties                                        BCMOLT_GPON_ONU_CPU_PACKET_ID__NUM_OF
#define bcmolt_gpon_onu_omci_packet_id_all_properties                                       BCMOLT_GPON_ONU_OMCI_PACKET_ID__NUM_OF
#define bcmolt_gpon_onu_onu_activation_standby_completed_id_all_properties                  BCMOLT_GPON_ONU_ONU_ACTIVATION_STANDBY_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_power_management_state_change_id_all_properties                     BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID__NUM_OF
#define bcmolt_gpon_onu_possible_drift_id_all_properties                                    BCMOLT_GPON_ONU_POSSIBLE_DRIFT_ID__NUM_OF
#define bcmolt_gpon_onu_stat_cfg_id_all_properties                                          BCMOLT_GPON_ONU_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_onu_stat_alarm_raised_id_all_properties                                 BCMOLT_GPON_ONU_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_onu_stat_alarm_cleared_id_all_properties                                BCMOLT_GPON_ONU_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_onu_auto_cfg_id_all_properties                                          BCMOLT_GPON_ONU_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_trx_key_id_all_properties                                               BCMOLT_GPON_TRX_KEY_ID__NUM_OF
#define bcmolt_gpon_trx_cfg_id_all_properties                                               BCMOLT_GPON_TRX_CFG_ID__NUM_OF
#define bcmolt_log_entry_key_id_all_properties                                              BCMOLT_LOG_ENTRY_KEY_ID__NUM_OF
#define bcmolt_log_entry_cfg_id_all_properties                                              BCMOLT_LOG_ENTRY_CFG_ID__NUM_OF
#define bcmolt_log_entry_stat_id_all_properties                                             BCMOLT_LOG_ENTRY_STAT_ID__NUM_OF
#define bcmolt_log_entry_stat_cfg_id_all_properties                                         BCMOLT_LOG_ENTRY_STAT_CFG_ID__NUM_OF
#define bcmolt_log_entry_stat_alarm_raised_id_all_properties                                BCMOLT_LOG_ENTRY_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_log_entry_stat_alarm_cleared_id_all_properties                               BCMOLT_LOG_ENTRY_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_log_entry_auto_cfg_id_all_properties                                         BCMOLT_LOG_ENTRY_AUTO_CFG_ID__NUM_OF
#define bcmolt_logger_key_id_all_properties                                                 BCMOLT_LOGGER_KEY_ID__NUM_OF
#define bcmolt_logger_cfg_id_all_properties                                                 BCMOLT_LOGGER_CFG_ID__NUM_OF
#define bcmolt_logger_stat_id_all_properties                                                BCMOLT_LOGGER_STAT_ID__NUM_OF
#define bcmolt_logger_clear_log_id_all_properties                                           BCMOLT_LOGGER_CLEAR_LOG_ID__NUM_OF
#define bcmolt_logger_stat_cfg_id_all_properties                                            BCMOLT_LOGGER_STAT_CFG_ID__NUM_OF
#define bcmolt_logger_stat_alarm_raised_id_all_properties                                   BCMOLT_LOGGER_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_logger_stat_alarm_cleared_id_all_properties                                  BCMOLT_LOGGER_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_logger_auto_cfg_id_all_properties                                            BCMOLT_LOGGER_AUTO_CFG_ID__NUM_OF
#define bcmolt_nni_key_id_all_properties                                                    BCMOLT_NNI_KEY_ID__NUM_OF
#define bcmolt_nni_cfg_id_all_properties                                                    BCMOLT_NNI_CFG_ID__NUM_OF
#define bcmolt_nni_stat_id_all_properties                                                   BCMOLT_NNI_STAT_ID__NUM_OF
#define bcmolt_nni_status_changed_id_all_properties                                         BCMOLT_NNI_STATUS_CHANGED_ID__NUM_OF
#define bcmolt_nni_stat_cfg_id_all_properties                                               BCMOLT_NNI_STAT_CFG_ID__NUM_OF
#define bcmolt_nni_stat_alarm_raised_id_all_properties                                      BCMOLT_NNI_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_nni_stat_alarm_cleared_id_all_properties                                     BCMOLT_NNI_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_nni_auto_cfg_id_all_properties                                               BCMOLT_NNI_AUTO_CFG_ID__NUM_OF
#define bcmolt_nni_serdes_key_id_all_properties                                             BCMOLT_NNI_SERDES_KEY_ID__NUM_OF
#define bcmolt_nni_serdes_cfg_id_all_properties                                             BCMOLT_NNI_SERDES_CFG_ID__NUM_OF
#define bcmolt_software_error_key_id_all_properties                                         BCMOLT_SOFTWARE_ERROR_KEY_ID__NUM_OF
#define bcmolt_software_error_cfg_id_all_properties                                         BCMOLT_SOFTWARE_ERROR_CFG_ID__NUM_OF
#define bcmolt_trx_calibration_key_id_all_properties                                        BCMOLT_TRX_CALIBRATION_KEY_ID__NUM_OF
#define bcmolt_trx_calibration_start_capture_window_id_all_properties                       BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID__NUM_OF
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_all_properties     BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID__NUM_OF
#define bcmolt_trx_calibration_stop_capture_window_id_all_properties                        BCMOLT_TRX_CALIBRATION_STOP_CAPTURE_WINDOW_ID__NUM_OF
#define bcmolt_trx_calibration_auto_cfg_id_all_properties                                   BCMOLT_TRX_CALIBRATION_AUTO_CFG_ID__NUM_OF
#define bcmolt_xgpon_alloc_key_id_all_properties                                            BCMOLT_XGPON_ALLOC_KEY_ID__NUM_OF
#define bcmolt_xgpon_alloc_cfg_id_all_properties                                            BCMOLT_XGPON_ALLOC_CFG_ID__NUM_OF
#define bcmolt_xgpon_alloc_configuration_completed_id_all_properties                        BCMOLT_XGPON_ALLOC_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_alloc_get_stats_id_all_properties                                      BCMOLT_XGPON_ALLOC_GET_STATS_ID__NUM_OF
#define bcmolt_xgpon_alloc_get_alloc_stats_completed_id_all_properties                      BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_alloc_set_state_id_all_properties                                      BCMOLT_XGPON_ALLOC_SET_STATE_ID__NUM_OF
#define bcmolt_xgpon_alloc_stat_id_all_properties                                           BCMOLT_XGPON_ALLOC_STAT_ID__NUM_OF
#define bcmolt_xgpon_alloc_stat_cfg_id_all_properties                                       BCMOLT_XGPON_ALLOC_STAT_CFG_ID__NUM_OF
#define bcmolt_xgpon_alloc_stat_alarm_raised_id_all_properties                              BCMOLT_XGPON_ALLOC_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_xgpon_alloc_stat_alarm_cleared_id_all_properties                             BCMOLT_XGPON_ALLOC_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_xgpon_alloc_auto_cfg_id_all_properties                                       BCMOLT_XGPON_ALLOC_AUTO_CFG_ID__NUM_OF
#define bcmolt_xgpon_gem_port_key_id_all_properties                                         BCMOLT_XGPON_GEM_PORT_KEY_ID__NUM_OF
#define bcmolt_xgpon_gem_port_cfg_id_all_properties                                         BCMOLT_XGPON_GEM_PORT_CFG_ID__NUM_OF
#define bcmolt_xgpon_gem_port_stat_id_all_properties                                        BCMOLT_XGPON_GEM_PORT_STAT_ID__NUM_OF
#define bcmolt_xgpon_gem_port_stat_cfg_id_all_properties                                    BCMOLT_XGPON_GEM_PORT_STAT_CFG_ID__NUM_OF
#define bcmolt_xgpon_gem_port_stat_alarm_raised_id_all_properties                           BCMOLT_XGPON_GEM_PORT_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_xgpon_gem_port_stat_alarm_cleared_id_all_properties                          BCMOLT_XGPON_GEM_PORT_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_xgpon_gem_port_auto_cfg_id_all_properties                                    BCMOLT_XGPON_GEM_PORT_AUTO_CFG_ID__NUM_OF
#define bcmolt_xgpon_iwf_key_id_all_properties                                              BCMOLT_XGPON_IWF_KEY_ID__NUM_OF
#define bcmolt_xgpon_iwf_cfg_id_all_properties                                              BCMOLT_XGPON_IWF_CFG_ID__NUM_OF
#define bcmolt_xgpon_ni_key_id_all_properties                                               BCMOLT_XGPON_NI_KEY_ID__NUM_OF
#define bcmolt_xgpon_ni_cfg_id_all_properties                                               BCMOLT_XGPON_NI_CFG_ID__NUM_OF
#define bcmolt_xgpon_ni_stat_id_all_properties                                              BCMOLT_XGPON_NI_STAT_ID__NUM_OF
#define bcmolt_xgpon_ni_set_pon_state_id_all_properties                                     BCMOLT_XGPON_NI_SET_PON_STATE_ID__NUM_OF
#define bcmolt_xgpon_ni_reset_id_all_properties                                             BCMOLT_XGPON_NI_RESET_ID__NUM_OF
#define bcmolt_xgpon_ni_disable_serial_number_id_all_properties                             BCMOLT_XGPON_NI_DISABLE_SERIAL_NUMBER_ID__NUM_OF
#define bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id_all_properties             BCMOLT_XGPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING_ID__NUM_OF
#define bcmolt_xgpon_ni_set_onu_state_id_all_properties                                     BCMOLT_XGPON_NI_SET_ONU_STATE_ID__NUM_OF
#define bcmolt_xgpon_ni_run_special_bw_map_id_all_properties                                BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID__NUM_OF
#define bcmolt_xgpon_ni_rogue_detection_window_id_all_properties                            BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID__NUM_OF
#define bcmolt_xgpon_ni_state_change_completed_id_all_properties                            BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_los_id_all_properties                                               BCMOLT_XGPON_NI_LOS_ID__NUM_OF
#define bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id_all_properties             BCMOLT_XGPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START_ID__NUM_OF
#define bcmolt_xgpon_ni_protection_switching_traffic_resume_id_all_properties               BCMOLT_XGPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID__NUM_OF
#define bcmolt_xgpon_ni_protection_switching_onus_ranged_id_all_properties                  BCMOLT_XGPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID__NUM_OF
#define bcmolt_xgpon_ni_protection_switching_switchover_completed_id_all_properties         BCMOLT_XGPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id_all_properties            BCMOLT_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_onu_discovered_id_all_properties                                    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID__NUM_OF
#define bcmolt_xgpon_ni_cpu_packets_failure_id_all_properties                               BCMOLT_XGPON_NI_CPU_PACKETS_FAILURE_ID__NUM_OF
#define bcmolt_xgpon_ni_cpu_packets_id_all_properties                                       BCMOLT_XGPON_NI_CPU_PACKETS_ID__NUM_OF
#define bcmolt_xgpon_ni_broadcast_ploam_packet_id_all_properties                            BCMOLT_XGPON_NI_BROADCAST_PLOAM_PACKET_ID__NUM_OF
#define bcmolt_xgpon_ni_rogue_detection_completed_id_all_properties                         BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_deactivate_all_onus_completed_id_all_properties                     BCMOLT_XGPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_disable_all_onus_completed_id_all_properties                        BCMOLT_XGPON_NI_DISABLE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_activate_all_onus_completed_id_all_properties                       BCMOLT_XGPON_NI_ACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_enable_all_onus_completed_id_all_properties                         BCMOLT_XGPON_NI_ENABLE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_tod_request_completed_id_all_properties                             BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_tod_request_id_all_properties                                       BCMOLT_XGPON_NI_TOD_REQUEST_ID__NUM_OF
#define bcmolt_xgpon_ni_start_onu_upgrade_id_all_properties                                 BCMOLT_XGPON_NI_START_ONU_UPGRADE_ID__NUM_OF
#define bcmolt_xgpon_ni_onu_upgrade_complete_id_all_properties                              BCMOLT_XGPON_NI_ONU_UPGRADE_COMPLETE_ID__NUM_OF
#define bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id_all_properties                 BCMOLT_XGPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START_ID__NUM_OF
#define bcmolt_xgpon_ni_adjust_tx_wavelength_id_all_properties                              BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID__NUM_OF
#define bcmolt_xgpon_ni_stat_cfg_id_all_properties                                          BCMOLT_XGPON_NI_STAT_CFG_ID__NUM_OF
#define bcmolt_xgpon_ni_stat_alarm_raised_id_all_properties                                 BCMOLT_XGPON_NI_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_xgpon_ni_stat_alarm_cleared_id_all_properties                                BCMOLT_XGPON_NI_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_xgpon_ni_auto_cfg_id_all_properties                                          BCMOLT_XGPON_NI_AUTO_CFG_ID__NUM_OF
#define bcmolt_xgpon_onu_key_id_all_properties                                              BCMOLT_XGPON_ONU_KEY_ID__NUM_OF
#define bcmolt_xgpon_onu_cfg_id_all_properties                                              BCMOLT_XGPON_ONU_CFG_ID__NUM_OF
#define bcmolt_xgpon_onu_stat_id_all_properties                                             BCMOLT_XGPON_ONU_STAT_ID__NUM_OF
#define bcmolt_xgpon_onu_set_onu_state_id_all_properties                                    BCMOLT_XGPON_ONU_SET_ONU_STATE_ID__NUM_OF
#define bcmolt_xgpon_onu_rssi_measurement_id_all_properties                                 BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_alarm_id_all_properties                                        BCMOLT_XGPON_ONU_ONU_ALARM_ID__NUM_OF
#define bcmolt_xgpon_onu_dowi_id_all_properties                                             BCMOLT_XGPON_ONU_DOWI_ID__NUM_OF
#define bcmolt_xgpon_onu_sfi_id_all_properties                                              BCMOLT_XGPON_ONU_SFI_ID__NUM_OF
#define bcmolt_xgpon_onu_sdi_id_all_properties                                              BCMOLT_XGPON_ONU_SDI_ID__NUM_OF
#define bcmolt_xgpon_onu_dfi_id_all_properties                                              BCMOLT_XGPON_ONU_DFI_ID__NUM_OF
#define bcmolt_xgpon_onu_pqsi_id_all_properties                                             BCMOLT_XGPON_ONU_PQSI_ID__NUM_OF
#define bcmolt_xgpon_onu_sufi_id_all_properties                                             BCMOLT_XGPON_ONU_SUFI_ID__NUM_OF
#define bcmolt_xgpon_onu_tiwi_id_all_properties                                             BCMOLT_XGPON_ONU_TIWI_ID__NUM_OF
#define bcmolt_xgpon_onu_looci_id_all_properties                                            BCMOLT_XGPON_ONU_LOOCI_ID__NUM_OF
#define bcmolt_xgpon_onu_ranging_completed_id_all_properties                                BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_activation_completed_id_all_properties                         BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_deactivation_completed_id_all_properties                       BCMOLT_XGPON_ONU_ONU_DEACTIVATION_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_enable_completed_id_all_properties                             BCMOLT_XGPON_ONU_ONU_ENABLE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_disable_completed_id_all_properties                            BCMOLT_XGPON_ONU_ONU_DISABLE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_rssi_measurement_completed_id_all_properties                       BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_invalid_dbru_report_id_all_properties                              BCMOLT_XGPON_ONU_INVALID_DBRU_REPORT_ID__NUM_OF
#define bcmolt_xgpon_onu_key_exchange_completed_id_all_properties                           BCMOLT_XGPON_ONU_KEY_EXCHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_key_exchange_key_request_timeout_id_all_properties                 BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT_ID__NUM_OF
#define bcmolt_xgpon_onu_key_exchange_cycle_skipped_id_all_properties                       BCMOLT_XGPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED_ID__NUM_OF
#define bcmolt_xgpon_onu_key_exchange_key_mismatch_id_all_properties                        BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID__NUM_OF
#define bcmolt_xgpon_onu_optical_reflection_id_all_properties                               BCMOLT_XGPON_ONU_OPTICAL_REFLECTION_ID__NUM_OF
#define bcmolt_xgpon_onu_ploam_packet_id_all_properties                                     BCMOLT_XGPON_ONU_PLOAM_PACKET_ID__NUM_OF
#define bcmolt_xgpon_onu_cpu_packets_id_all_properties                                      BCMOLT_XGPON_ONU_CPU_PACKETS_ID__NUM_OF
#define bcmolt_xgpon_onu_cpu_packet_id_all_properties                                       BCMOLT_XGPON_ONU_CPU_PACKET_ID__NUM_OF
#define bcmolt_xgpon_onu_omci_packet_id_all_properties                                      BCMOLT_XGPON_ONU_OMCI_PACKET_ID__NUM_OF
#define bcmolt_xgpon_onu_dgi_id_all_properties                                              BCMOLT_XGPON_ONU_DGI_ID__NUM_OF
#define bcmolt_xgpon_onu_power_management_state_change_id_all_properties                    BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID__NUM_OF
#define bcmolt_xgpon_onu_possible_drift_id_all_properties                                   BCMOLT_XGPON_ONU_POSSIBLE_DRIFT_ID__NUM_OF
#define bcmolt_xgpon_onu_request_registration_id_all_properties                             BCMOLT_XGPON_ONU_REQUEST_REGISTRATION_ID__NUM_OF
#define bcmolt_xgpon_onu_change_power_levelling_id_all_properties                           BCMOLT_XGPON_ONU_CHANGE_POWER_LEVELLING_ID__NUM_OF
#define bcmolt_xgpon_onu_get_power_level_id_all_properties                                  BCMOLT_XGPON_ONU_GET_POWER_LEVEL_ID__NUM_OF
#define bcmolt_xgpon_onu_get_power_consumption_id_all_properties                            BCMOLT_XGPON_ONU_GET_POWER_CONSUMPTION_ID__NUM_OF
#define bcmolt_xgpon_onu_adjust_tx_wavelength_id_all_properties                             BCMOLT_XGPON_ONU_ADJUST_TX_WAVELENGTH_ID__NUM_OF
#define bcmolt_xgpon_onu_registration_id_id_all_properties                                  BCMOLT_XGPON_ONU_REGISTRATION_ID_ID__NUM_OF
#define bcmolt_xgpon_onu_power_level_report_id_all_properties                               BCMOLT_XGPON_ONU_POWER_LEVEL_REPORT_ID__NUM_OF
#define bcmolt_xgpon_onu_power_consumption_report_id_all_properties                         BCMOLT_XGPON_ONU_POWER_CONSUMPTION_REPORT_ID__NUM_OF
#define bcmolt_xgpon_onu_secure_mutual_authentication_id_all_properties                     BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID__NUM_OF
#define bcmolt_xgpon_onu_secure_mutual_authentication_failure_id_all_properties             BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_tuning_in_id_all_properties                                    BCMOLT_XGPON_ONU_ONU_TUNING_IN_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_tuning_out_id_all_properties                                   BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_tuning_out_completed_id_all_properties                         BCMOLT_XGPON_ONU_ONU_TUNING_OUT_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_tuning_in_completed_id_all_properties                          BCMOLT_XGPON_ONU_ONU_TUNING_IN_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_tuning_response_id_all_properties                                  BCMOLT_XGPON_ONU_TUNING_RESPONSE_ID__NUM_OF
#define bcmolt_xgpon_onu_stat_cfg_id_all_properties                                         BCMOLT_XGPON_ONU_STAT_CFG_ID__NUM_OF
#define bcmolt_xgpon_onu_stat_alarm_raised_id_all_properties                                BCMOLT_XGPON_ONU_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_xgpon_onu_stat_alarm_cleared_id_all_properties                               BCMOLT_XGPON_ONU_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_xgpon_onu_auto_cfg_id_all_properties                                         BCMOLT_XGPON_ONU_AUTO_CFG_ID__NUM_OF
#define bcmolt_xgpon_trx_key_id_all_properties                                              BCMOLT_XGPON_TRX_KEY_ID__NUM_OF
#define bcmolt_xgpon_trx_cfg_id_all_properties                                              BCMOLT_XGPON_TRX_CFG_ID__NUM_OF
#define bcmolt_xpon_serdes_key_id_all_properties                                            BCMOLT_XPON_SERDES_KEY_ID__NUM_OF
#define bcmolt_xpon_serdes_cfg_id_all_properties                                            BCMOLT_XPON_SERDES_CFG_ID__NUM_OF

/* The following are required for the API Init/Set/etc macros */
#define bcmolt_obj_id__begin                                                                    BCMOLT_OBJ_ID__BEGIN
#define bcmolt_obj_id_ae_ni                                                                     BCMOLT_OBJ_ID_AE_NI
#define bcmolt_obj_id_ae_path_ds                                                                BCMOLT_OBJ_ID_AE_PATH_DS
#define bcmolt_obj_id_ae_path_us                                                                BCMOLT_OBJ_ID_AE_PATH_US
#define bcmolt_obj_id_channel                                                                   BCMOLT_OBJ_ID_CHANNEL
#define bcmolt_obj_id_debug                                                                     BCMOLT_OBJ_ID_DEBUG
#define bcmolt_obj_id_device                                                                    BCMOLT_OBJ_ID_DEVICE
#define bcmolt_obj_id_epon_denied_link                                                          BCMOLT_OBJ_ID_EPON_DENIED_LINK
#define bcmolt_obj_id_epon_link                                                                 BCMOLT_OBJ_ID_EPON_LINK
#define bcmolt_obj_id_epon_ni                                                                   BCMOLT_OBJ_ID_EPON_NI
#define bcmolt_obj_id_epon_onu_10g_us                                                           BCMOLT_OBJ_ID_EPON_ONU_10G_US
#define bcmolt_obj_id_epon_onu_1g_us                                                            BCMOLT_OBJ_ID_EPON_ONU_1G_US
#define bcmolt_obj_id_epon_path_10g_ds                                                          BCMOLT_OBJ_ID_EPON_PATH_10G_DS
#define bcmolt_obj_id_epon_path_10g_us                                                          BCMOLT_OBJ_ID_EPON_PATH_10G_US
#define bcmolt_obj_id_epon_path_1g_ds                                                           BCMOLT_OBJ_ID_EPON_PATH_1G_DS
#define bcmolt_obj_id_epon_path_1g_us                                                           BCMOLT_OBJ_ID_EPON_PATH_1G_US
#define bcmolt_obj_id_epon_rp                                                                   BCMOLT_OBJ_ID_EPON_RP
#define bcmolt_obj_id_gpio                                                                      BCMOLT_OBJ_ID_GPIO
#define bcmolt_obj_id_gpon_alloc                                                                BCMOLT_OBJ_ID_GPON_ALLOC
#define bcmolt_obj_id_gpon_gem_port                                                             BCMOLT_OBJ_ID_GPON_GEM_PORT
#define bcmolt_obj_id_gpon_iwf                                                                  BCMOLT_OBJ_ID_GPON_IWF
#define bcmolt_obj_id_gpon_iwf_ds_egress_flow                                                   BCMOLT_OBJ_ID_GPON_IWF_DS_EGRESS_FLOW
#define bcmolt_obj_id_gpon_iwf_ds_ingress_flow                                                  BCMOLT_OBJ_ID_GPON_IWF_DS_INGRESS_FLOW
#define bcmolt_obj_id_gpon_iwf_mac_table                                                        BCMOLT_OBJ_ID_GPON_IWF_MAC_TABLE
#define bcmolt_obj_id_gpon_iwf_us_flow                                                          BCMOLT_OBJ_ID_GPON_IWF_US_FLOW
#define bcmolt_obj_id_gpon_ni                                                                   BCMOLT_OBJ_ID_GPON_NI
#define bcmolt_obj_id_gpon_onu                                                                  BCMOLT_OBJ_ID_GPON_ONU
#define bcmolt_obj_id_gpon_trx                                                                  BCMOLT_OBJ_ID_GPON_TRX
#define bcmolt_obj_id_log_entry                                                                 BCMOLT_OBJ_ID_LOG_ENTRY
#define bcmolt_obj_id_logger                                                                    BCMOLT_OBJ_ID_LOGGER
#define bcmolt_obj_id_nni                                                                       BCMOLT_OBJ_ID_NNI
#define bcmolt_obj_id_nni_serdes                                                                BCMOLT_OBJ_ID_NNI_SERDES
#define bcmolt_obj_id_software_error                                                            BCMOLT_OBJ_ID_SOFTWARE_ERROR
#define bcmolt_obj_id_trx_calibration                                                           BCMOLT_OBJ_ID_TRX_CALIBRATION
#define bcmolt_obj_id_xgpon_alloc                                                               BCMOLT_OBJ_ID_XGPON_ALLOC
#define bcmolt_obj_id_xgpon_gem_port                                                            BCMOLT_OBJ_ID_XGPON_GEM_PORT
#define bcmolt_obj_id_xgpon_iwf                                                                 BCMOLT_OBJ_ID_XGPON_IWF
#define bcmolt_obj_id_xgpon_ni                                                                  BCMOLT_OBJ_ID_XGPON_NI
#define bcmolt_obj_id_xgpon_onu                                                                 BCMOLT_OBJ_ID_XGPON_ONU
#define bcmolt_obj_id_xgpon_trx                                                                 BCMOLT_OBJ_ID_XGPON_TRX
#define bcmolt_obj_id_xpon_serdes                                                               BCMOLT_OBJ_ID_XPON_SERDES
#define bcmolt_obj_id__num_of                                                                   BCMOLT_OBJ_ID__NUM_OF
#define bcmolt_ae_ni_oper_id__begin                                                             BCMOLT_AE_NI_OPER_ID__BEGIN
#define bcmolt_ae_ni_oper_id_set_ae_ni_en_state                                                 BCMOLT_AE_NI_OPER_ID_SET_AE_NI_EN_STATE
#define bcmolt_ae_ni_oper_id__num_of                                                            BCMOLT_AE_NI_OPER_ID__NUM_OF
#define bcmolt_ae_path_ds_auto_id__begin                                                        BCMOLT_AE_PATH_DS_AUTO_ID__BEGIN
#define bcmolt_ae_path_ds_auto_id_stat_alarm_cleared                                            BCMOLT_AE_PATH_DS_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_ae_path_ds_auto_id_stat_alarm_raised                                             BCMOLT_AE_PATH_DS_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_ae_path_ds_auto_id__num_of                                                       BCMOLT_AE_PATH_DS_AUTO_ID__NUM_OF
#define bcmolt_ae_path_us_auto_id__begin                                                        BCMOLT_AE_PATH_US_AUTO_ID__BEGIN
#define bcmolt_ae_path_us_auto_id_stat_alarm_cleared                                            BCMOLT_AE_PATH_US_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_ae_path_us_auto_id_stat_alarm_raised                                             BCMOLT_AE_PATH_US_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_ae_path_us_auto_id__num_of                                                       BCMOLT_AE_PATH_US_AUTO_ID__NUM_OF
#define bcmolt_debug_auto_id__begin                                                             BCMOLT_DEBUG_AUTO_ID__BEGIN
#define bcmolt_debug_auto_id_cli_output                                                         BCMOLT_DEBUG_AUTO_ID_CLI_OUTPUT
#define bcmolt_debug_auto_id_file_almost_full                                                   BCMOLT_DEBUG_AUTO_ID_FILE_ALMOST_FULL
#define bcmolt_debug_auto_id__num_of                                                            BCMOLT_DEBUG_AUTO_ID__NUM_OF
#define bcmolt_debug_oper_id__begin                                                             BCMOLT_DEBUG_OPER_ID__BEGIN
#define bcmolt_debug_oper_id_cli_input                                                          BCMOLT_DEBUG_OPER_ID_CLI_INPUT
#define bcmolt_debug_oper_id_reset_api_capture                                                  BCMOLT_DEBUG_OPER_ID_RESET_API_CAPTURE
#define bcmolt_debug_oper_id_start_api_capture                                                  BCMOLT_DEBUG_OPER_ID_START_API_CAPTURE
#define bcmolt_debug_oper_id_stop_api_capture                                                   BCMOLT_DEBUG_OPER_ID_STOP_API_CAPTURE
#define bcmolt_debug_oper_id__num_of                                                            BCMOLT_DEBUG_OPER_ID__NUM_OF
#define bcmolt_device_auto_id__begin                                                            BCMOLT_DEVICE_AUTO_ID__BEGIN
#define bcmolt_device_auto_id_connection_complete                                               BCMOLT_DEVICE_AUTO_ID_CONNECTION_COMPLETE
#define bcmolt_device_auto_id_connection_established                                            BCMOLT_DEVICE_AUTO_ID_CONNECTION_ESTABLISHED
#define bcmolt_device_auto_id_connection_failure                                                BCMOLT_DEVICE_AUTO_ID_CONNECTION_FAILURE
#define bcmolt_device_auto_id_ddr_test_complete                                                 BCMOLT_DEVICE_AUTO_ID_DDR_TEST_COMPLETE
#define bcmolt_device_auto_id_device_keep_alive                                                 BCMOLT_DEVICE_AUTO_ID_DEVICE_KEEP_ALIVE
#define bcmolt_device_auto_id_device_ready                                                      BCMOLT_DEVICE_AUTO_ID_DEVICE_READY
#define bcmolt_device_auto_id_disconnection_complete                                            BCMOLT_DEVICE_AUTO_ID_DISCONNECTION_COMPLETE
#define bcmolt_device_auto_id_image_transfer_complete                                           BCMOLT_DEVICE_AUTO_ID_IMAGE_TRANSFER_COMPLETE
#define bcmolt_device_auto_id_indications_dropped                                               BCMOLT_DEVICE_AUTO_ID_INDICATIONS_DROPPED
#define bcmolt_device_auto_id_sw_error                                                          BCMOLT_DEVICE_AUTO_ID_SW_ERROR
#define bcmolt_device_auto_id_sw_exception                                                      BCMOLT_DEVICE_AUTO_ID_SW_EXCEPTION
#define bcmolt_device_auto_id__num_of                                                           BCMOLT_DEVICE_AUTO_ID__NUM_OF
#define bcmolt_device_oper_id__begin                                                            BCMOLT_DEVICE_OPER_ID__BEGIN
#define bcmolt_device_oper_id_connect                                                           BCMOLT_DEVICE_OPER_ID_CONNECT
#define bcmolt_device_oper_id_disconnect                                                        BCMOLT_DEVICE_OPER_ID_DISCONNECT
#define bcmolt_device_oper_id_host_keep_alive                                                   BCMOLT_DEVICE_OPER_ID_HOST_KEEP_ALIVE
#define bcmolt_device_oper_id_image_transfer_data                                               BCMOLT_DEVICE_OPER_ID_IMAGE_TRANSFER_DATA
#define bcmolt_device_oper_id_image_transfer_start                                              BCMOLT_DEVICE_OPER_ID_IMAGE_TRANSFER_START
#define bcmolt_device_oper_id_reset                                                             BCMOLT_DEVICE_OPER_ID_RESET
#define bcmolt_device_oper_id_run_ddr_test                                                      BCMOLT_DEVICE_OPER_ID_RUN_DDR_TEST
#define bcmolt_device_oper_id_sw_upgrade_activate                                               BCMOLT_DEVICE_OPER_ID_SW_UPGRADE_ACTIVATE
#define bcmolt_device_oper_id__num_of                                                           BCMOLT_DEVICE_OPER_ID__NUM_OF
#define bcmolt_epon_denied_link_auto_id__begin                                                  BCMOLT_EPON_DENIED_LINK_AUTO_ID__BEGIN
#define bcmolt_epon_denied_link_auto_id_laser_on_off_violation                                  BCMOLT_EPON_DENIED_LINK_AUTO_ID_LASER_ON_OFF_VIOLATION
#define bcmolt_epon_denied_link_auto_id_llid_pool_empty_violation                               BCMOLT_EPON_DENIED_LINK_AUTO_ID_LLID_POOL_EMPTY_VIOLATION
#define bcmolt_epon_denied_link_auto_id_max_link_violation                                      BCMOLT_EPON_DENIED_LINK_AUTO_ID_MAX_LINK_VIOLATION
#define bcmolt_epon_denied_link_auto_id_overhead_profile_violation                              BCMOLT_EPON_DENIED_LINK_AUTO_ID_OVERHEAD_PROFILE_VIOLATION
#define bcmolt_epon_denied_link_auto_id_range_violation                                         BCMOLT_EPON_DENIED_LINK_AUTO_ID_RANGE_VIOLATION
#define bcmolt_epon_denied_link_auto_id_rogue_violation                                         BCMOLT_EPON_DENIED_LINK_AUTO_ID_ROGUE_VIOLATION
#define bcmolt_epon_denied_link_auto_id_system_resource_violation                               BCMOLT_EPON_DENIED_LINK_AUTO_ID_SYSTEM_RESOURCE_VIOLATION
#define bcmolt_epon_denied_link_auto_id_tdm_channels_exhausted                                  BCMOLT_EPON_DENIED_LINK_AUTO_ID_TDM_CHANNELS_EXHAUSTED
#define bcmolt_epon_denied_link_auto_id_unknown_link_violation                                  BCMOLT_EPON_DENIED_LINK_AUTO_ID_UNKNOWN_LINK_VIOLATION
#define bcmolt_epon_denied_link_auto_id_upstream_bandwidth_violation                            BCMOLT_EPON_DENIED_LINK_AUTO_ID_UPSTREAM_BANDWIDTH_VIOLATION
#define bcmolt_epon_denied_link_auto_id__num_of                                                 BCMOLT_EPON_DENIED_LINK_AUTO_ID__NUM_OF
#define bcmolt_epon_link_auto_id__begin                                                         BCMOLT_EPON_LINK_AUTO_ID__BEGIN
#define bcmolt_epon_link_auto_id_duplicate_mpcp_registration_request                            BCMOLT_EPON_LINK_AUTO_ID_DUPLICATE_MPCP_REGISTRATION_REQUEST
#define bcmolt_epon_link_auto_id_encryption_enabled                                             BCMOLT_EPON_LINK_AUTO_ID_ENCRYPTION_ENABLED
#define bcmolt_epon_link_auto_id_key_exchange_failure                                           BCMOLT_EPON_LINK_AUTO_ID_KEY_EXCHANGE_FAILURE
#define bcmolt_epon_link_auto_id_key_exchange_started                                           BCMOLT_EPON_LINK_AUTO_ID_KEY_EXCHANGE_STARTED
#define bcmolt_epon_link_auto_id_key_exchange_stopped                                           BCMOLT_EPON_LINK_AUTO_ID_KEY_EXCHANGE_STOPPED
#define bcmolt_epon_link_auto_id_link_deleted                                                   BCMOLT_EPON_LINK_AUTO_ID_LINK_DELETED
#define bcmolt_epon_link_auto_id_link_speed_mismatch                                            BCMOLT_EPON_LINK_AUTO_ID_LINK_SPEED_MISMATCH
#define bcmolt_epon_link_auto_id_mpcp_deregistered                                              BCMOLT_EPON_LINK_AUTO_ID_MPCP_DEREGISTERED
#define bcmolt_epon_link_auto_id_mpcp_discovered                                                BCMOLT_EPON_LINK_AUTO_ID_MPCP_DISCOVERED
#define bcmolt_epon_link_auto_id_mpcp_reg_ack_timeout                                           BCMOLT_EPON_LINK_AUTO_ID_MPCP_REG_ACK_TIMEOUT
#define bcmolt_epon_link_auto_id_mpcp_report_timeout                                            BCMOLT_EPON_LINK_AUTO_ID_MPCP_REPORT_TIMEOUT
#define bcmolt_epon_link_auto_id_oam_keepalive_timeout                                          BCMOLT_EPON_LINK_AUTO_ID_OAM_KEEPALIVE_TIMEOUT
#define bcmolt_epon_link_auto_id_oam_keepalive_timer_started                                    BCMOLT_EPON_LINK_AUTO_ID_OAM_KEEPALIVE_TIMER_STARTED
#define bcmolt_epon_link_auto_id_oam_keepalive_timer_stopped                                    BCMOLT_EPON_LINK_AUTO_ID_OAM_KEEPALIVE_TIMER_STOPPED
#define bcmolt_epon_link_auto_id_preprovisioned_link_created                                    BCMOLT_EPON_LINK_AUTO_ID_PREPROVISIONED_LINK_CREATED
#define bcmolt_epon_link_auto_id_protection_switch_occurred                                     BCMOLT_EPON_LINK_AUTO_ID_PROTECTION_SWITCH_OCCURRED
#define bcmolt_epon_link_auto_id_range_value_changed                                            BCMOLT_EPON_LINK_AUTO_ID_RANGE_VALUE_CHANGED
#define bcmolt_epon_link_auto_id_rerange_failure                                                BCMOLT_EPON_LINK_AUTO_ID_RERANGE_FAILURE
#define bcmolt_epon_link_auto_id_stat_alarm_cleared                                             BCMOLT_EPON_LINK_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_link_auto_id_stat_alarm_raised                                              BCMOLT_EPON_LINK_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_epon_link_auto_id_static_registration_done                                       BCMOLT_EPON_LINK_AUTO_ID_STATIC_REGISTRATION_DONE
#define bcmolt_epon_link_auto_id__num_of                                                        BCMOLT_EPON_LINK_AUTO_ID__NUM_OF
#define bcmolt_epon_link_oper_id__begin                                                         BCMOLT_EPON_LINK_OPER_ID__BEGIN
#define bcmolt_epon_link_oper_id_delete_link                                                    BCMOLT_EPON_LINK_OPER_ID_DELETE_LINK
#define bcmolt_epon_link_oper_id_force_rediscovery                                              BCMOLT_EPON_LINK_OPER_ID_FORCE_REDISCOVERY
#define bcmolt_epon_link_oper_id_key_exchange_start                                             BCMOLT_EPON_LINK_OPER_ID_KEY_EXCHANGE_START
#define bcmolt_epon_link_oper_id_key_exchange_stop                                              BCMOLT_EPON_LINK_OPER_ID_KEY_EXCHANGE_STOP
#define bcmolt_epon_link_oper_id_oam_keepalive_timer_start                                      BCMOLT_EPON_LINK_OPER_ID_OAM_KEEPALIVE_TIMER_START
#define bcmolt_epon_link_oper_id_oam_keepalive_timer_stop                                       BCMOLT_EPON_LINK_OPER_ID_OAM_KEEPALIVE_TIMER_STOP
#define bcmolt_epon_link_oper_id_static_registration                                            BCMOLT_EPON_LINK_OPER_ID_STATIC_REGISTRATION
#define bcmolt_epon_link_oper_id__num_of                                                        BCMOLT_EPON_LINK_OPER_ID__NUM_OF
#define bcmolt_epon_link_proxy_id__begin                                                        BCMOLT_EPON_LINK_PROXY_ID__BEGIN
#define bcmolt_epon_link_proxy_id_inject_frame                                                  BCMOLT_EPON_LINK_PROXY_ID_INJECT_FRAME
#define bcmolt_epon_link_proxy_id__num_of                                                       BCMOLT_EPON_LINK_PROXY_ID__NUM_OF
#define bcmolt_epon_link_proxy_rx_id__begin                                                     BCMOLT_EPON_LINK_PROXY_RX_ID__BEGIN
#define bcmolt_epon_link_proxy_rx_id_frame_captured                                             BCMOLT_EPON_LINK_PROXY_RX_ID_FRAME_CAPTURED
#define bcmolt_epon_link_proxy_rx_id__num_of                                                    BCMOLT_EPON_LINK_PROXY_RX_ID__NUM_OF
#define bcmolt_epon_ni_auto_id__begin                                                           BCMOLT_EPON_NI_AUTO_ID__BEGIN
#define bcmolt_epon_ni_auto_id_auto_rogue_scan_10g_failure                                      BCMOLT_EPON_NI_AUTO_ID_AUTO_ROGUE_SCAN_10G_FAILURE
#define bcmolt_epon_ni_auto_id_auto_rogue_scan_1g_failure                                       BCMOLT_EPON_NI_AUTO_ID_AUTO_ROGUE_SCAN_1G_FAILURE
#define bcmolt_epon_ni_auto_id_llid_quarantined                                                 BCMOLT_EPON_NI_AUTO_ID_LLID_QUARANTINED
#define bcmolt_epon_ni_auto_id_mpcp_timestamp_changed                                           BCMOLT_EPON_NI_AUTO_ID_MPCP_TIMESTAMP_CHANGED
#define bcmolt_epon_ni_auto_id_no_reports                                                       BCMOLT_EPON_NI_AUTO_ID_NO_REPORTS
#define bcmolt_epon_ni_auto_id_onu_upgrade_complete                                             BCMOLT_EPON_NI_AUTO_ID_ONU_UPGRADE_COMPLETE
#define bcmolt_epon_ni_auto_id_rerange_failure                                                  BCMOLT_EPON_NI_AUTO_ID_RERANGE_FAILURE
#define bcmolt_epon_ni_auto_id_rogue_scan_complete                                              BCMOLT_EPON_NI_AUTO_ID_ROGUE_SCAN_COMPLETE
#define bcmolt_epon_ni_auto_id_rssi_measurement_completed                                       BCMOLT_EPON_NI_AUTO_ID_RSSI_MEASUREMENT_COMPLETED
#define bcmolt_epon_ni_auto_id_state_change_completed                                           BCMOLT_EPON_NI_AUTO_ID_STATE_CHANGE_COMPLETED
#define bcmolt_epon_ni_auto_id__num_of                                                          BCMOLT_EPON_NI_AUTO_ID__NUM_OF
#define bcmolt_epon_ni_oper_id__begin                                                           BCMOLT_EPON_NI_OPER_ID__BEGIN
#define bcmolt_epon_ni_oper_id_add_link                                                         BCMOLT_EPON_NI_OPER_ID_ADD_LINK
#define bcmolt_epon_ni_oper_id_add_multicast_link                                               BCMOLT_EPON_NI_OPER_ID_ADD_MULTICAST_LINK
#define bcmolt_epon_ni_oper_id_add_protected_standby_link                                       BCMOLT_EPON_NI_OPER_ID_ADD_PROTECTED_STANDBY_LINK
#define bcmolt_epon_ni_oper_id_issue_rssi_grant                                                 BCMOLT_EPON_NI_OPER_ID_ISSUE_RSSI_GRANT
#define bcmolt_epon_ni_oper_id_protection_switching_apply_rerange_delta                         BCMOLT_EPON_NI_OPER_ID_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA
#define bcmolt_epon_ni_oper_id_rogue_llid_scan                                                  BCMOLT_EPON_NI_OPER_ID_ROGUE_LLID_SCAN
#define bcmolt_epon_ni_oper_id_set_epon_ni_en_state                                             BCMOLT_EPON_NI_OPER_ID_SET_EPON_NI_EN_STATE
#define bcmolt_epon_ni_oper_id_start_onu_upgrade                                                BCMOLT_EPON_NI_OPER_ID_START_ONU_UPGRADE
#define bcmolt_epon_ni_oper_id__num_of                                                          BCMOLT_EPON_NI_OPER_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_auto_id__begin                                                   BCMOLT_EPON_ONU_10G_US_AUTO_ID__BEGIN
#define bcmolt_epon_onu_10g_us_auto_id_stat_alarm_cleared                                       BCMOLT_EPON_ONU_10G_US_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_onu_10g_us_auto_id_stat_alarm_raised                                        BCMOLT_EPON_ONU_10G_US_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_epon_onu_10g_us_auto_id__num_of                                                  BCMOLT_EPON_ONU_10G_US_AUTO_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_auto_id__begin                                                    BCMOLT_EPON_ONU_1G_US_AUTO_ID__BEGIN
#define bcmolt_epon_onu_1g_us_auto_id_stat_alarm_cleared                                        BCMOLT_EPON_ONU_1G_US_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_onu_1g_us_auto_id_stat_alarm_raised                                         BCMOLT_EPON_ONU_1G_US_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_epon_onu_1g_us_auto_id__num_of                                                   BCMOLT_EPON_ONU_1G_US_AUTO_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_auto_id__begin                                                  BCMOLT_EPON_PATH_10G_DS_AUTO_ID__BEGIN
#define bcmolt_epon_path_10g_ds_auto_id_stat_alarm_cleared                                      BCMOLT_EPON_PATH_10G_DS_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_path_10g_ds_auto_id_stat_alarm_raised                                       BCMOLT_EPON_PATH_10G_DS_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_epon_path_10g_ds_auto_id__num_of                                                 BCMOLT_EPON_PATH_10G_DS_AUTO_ID__NUM_OF
#define bcmolt_epon_path_10g_us_auto_id__begin                                                  BCMOLT_EPON_PATH_10G_US_AUTO_ID__BEGIN
#define bcmolt_epon_path_10g_us_auto_id_stat_alarm_cleared                                      BCMOLT_EPON_PATH_10G_US_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_path_10g_us_auto_id_stat_alarm_raised                                       BCMOLT_EPON_PATH_10G_US_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_epon_path_10g_us_auto_id__num_of                                                 BCMOLT_EPON_PATH_10G_US_AUTO_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_auto_id__begin                                                   BCMOLT_EPON_PATH_1G_DS_AUTO_ID__BEGIN
#define bcmolt_epon_path_1g_ds_auto_id_stat_alarm_cleared                                       BCMOLT_EPON_PATH_1G_DS_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_path_1g_ds_auto_id_stat_alarm_raised                                        BCMOLT_EPON_PATH_1G_DS_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_epon_path_1g_ds_auto_id__num_of                                                  BCMOLT_EPON_PATH_1G_DS_AUTO_ID__NUM_OF
#define bcmolt_epon_path_1g_us_auto_id__begin                                                   BCMOLT_EPON_PATH_1G_US_AUTO_ID__BEGIN
#define bcmolt_epon_path_1g_us_auto_id_stat_alarm_cleared                                       BCMOLT_EPON_PATH_1G_US_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_path_1g_us_auto_id_stat_alarm_raised                                        BCMOLT_EPON_PATH_1G_US_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_epon_path_1g_us_auto_id__num_of                                                  BCMOLT_EPON_PATH_1G_US_AUTO_ID__NUM_OF
#define bcmolt_gpon_alloc_auto_id__begin                                                        BCMOLT_GPON_ALLOC_AUTO_ID__BEGIN
#define bcmolt_gpon_alloc_auto_id_configuration_completed                                       BCMOLT_GPON_ALLOC_AUTO_ID_CONFIGURATION_COMPLETED
#define bcmolt_gpon_alloc_auto_id_get_alloc_stats_completed                                     BCMOLT_GPON_ALLOC_AUTO_ID_GET_ALLOC_STATS_COMPLETED
#define bcmolt_gpon_alloc_auto_id_stat_alarm_cleared                                            BCMOLT_GPON_ALLOC_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_alloc_auto_id_stat_alarm_raised                                             BCMOLT_GPON_ALLOC_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_alloc_auto_id__num_of                                                       BCMOLT_GPON_ALLOC_AUTO_ID__NUM_OF
#define bcmolt_gpon_alloc_oper_id__begin                                                        BCMOLT_GPON_ALLOC_OPER_ID__BEGIN
#define bcmolt_gpon_alloc_oper_id_get_stats                                                     BCMOLT_GPON_ALLOC_OPER_ID_GET_STATS
#define bcmolt_gpon_alloc_oper_id_set_state                                                     BCMOLT_GPON_ALLOC_OPER_ID_SET_STATE
#define bcmolt_gpon_alloc_oper_id__num_of                                                       BCMOLT_GPON_ALLOC_OPER_ID__NUM_OF
#define bcmolt_gpon_gem_port_auto_id__begin                                                     BCMOLT_GPON_GEM_PORT_AUTO_ID__BEGIN
#define bcmolt_gpon_gem_port_auto_id_configuration_completed                                    BCMOLT_GPON_GEM_PORT_AUTO_ID_CONFIGURATION_COMPLETED
#define bcmolt_gpon_gem_port_auto_id_stat_alarm_cleared                                         BCMOLT_GPON_GEM_PORT_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_gem_port_auto_id_stat_alarm_raised                                          BCMOLT_GPON_GEM_PORT_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_gem_port_auto_id__num_of                                                    BCMOLT_GPON_GEM_PORT_AUTO_ID__NUM_OF
#define bcmolt_gpon_gem_port_oper_id__begin                                                     BCMOLT_GPON_GEM_PORT_OPER_ID__BEGIN
#define bcmolt_gpon_gem_port_oper_id_set_state                                                  BCMOLT_GPON_GEM_PORT_OPER_ID_SET_STATE
#define bcmolt_gpon_gem_port_oper_id__num_of                                                    BCMOLT_GPON_GEM_PORT_OPER_ID__NUM_OF
#define bcmolt_gpon_iwf_auto_id__begin                                                          BCMOLT_GPON_IWF_AUTO_ID__BEGIN
#define bcmolt_gpon_iwf_auto_id_flush_mac_table_completed                                       BCMOLT_GPON_IWF_AUTO_ID_FLUSH_MAC_TABLE_COMPLETED
#define bcmolt_gpon_iwf_auto_id_scan_mac_table_completed                                        BCMOLT_GPON_IWF_AUTO_ID_SCAN_MAC_TABLE_COMPLETED
#define bcmolt_gpon_iwf_auto_id_stat_alarm_cleared                                              BCMOLT_GPON_IWF_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_iwf_auto_id_stat_alarm_raised                                               BCMOLT_GPON_IWF_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_iwf_auto_id__num_of                                                         BCMOLT_GPON_IWF_AUTO_ID__NUM_OF
#define bcmolt_gpon_iwf_oper_id__begin                                                          BCMOLT_GPON_IWF_OPER_ID__BEGIN
#define bcmolt_gpon_iwf_oper_id_flush_mac_table                                                 BCMOLT_GPON_IWF_OPER_ID_FLUSH_MAC_TABLE
#define bcmolt_gpon_iwf_oper_id_scan_mac_table                                                  BCMOLT_GPON_IWF_OPER_ID_SCAN_MAC_TABLE
#define bcmolt_gpon_iwf_oper_id__num_of                                                         BCMOLT_GPON_IWF_OPER_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_auto_id__begin                                                BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID__BEGIN
#define bcmolt_gpon_iwf_mac_table_auto_id_mac_aged                                              BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID_MAC_AGED
#define bcmolt_gpon_iwf_mac_table_auto_id_mac_dropped                                           BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID_MAC_DROPPED
#define bcmolt_gpon_iwf_mac_table_auto_id_mac_move                                              BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID_MAC_MOVE
#define bcmolt_gpon_iwf_mac_table_auto_id_new_mac                                               BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID_NEW_MAC
#define bcmolt_gpon_iwf_mac_table_auto_id__num_of                                               BCMOLT_GPON_IWF_MAC_TABLE_AUTO_ID__NUM_OF
#define bcmolt_gpon_ni_auto_id__begin                                                           BCMOLT_GPON_NI_AUTO_ID__BEGIN
#define bcmolt_gpon_ni_auto_id_activate_all_onus_completed                                      BCMOLT_GPON_NI_AUTO_ID_ACTIVATE_ALL_ONUS_COMPLETED
#define bcmolt_gpon_ni_auto_id_cpu_packets_failure                                              BCMOLT_GPON_NI_AUTO_ID_CPU_PACKETS_FAILURE
#define bcmolt_gpon_ni_auto_id_deactivate_all_onus_completed                                    BCMOLT_GPON_NI_AUTO_ID_DEACTIVATE_ALL_ONUS_COMPLETED
#define bcmolt_gpon_ni_auto_id_disable_all_onus_completed                                       BCMOLT_GPON_NI_AUTO_ID_DISABLE_ALL_ONUS_COMPLETED
#define bcmolt_gpon_ni_auto_id_enable_all_onus_completed                                        BCMOLT_GPON_NI_AUTO_ID_ENABLE_ALL_ONUS_COMPLETED
#define bcmolt_gpon_ni_auto_id_los                                                              BCMOLT_GPON_NI_AUTO_ID_LOS
#define bcmolt_gpon_ni_auto_id_onu_discovered                                                   BCMOLT_GPON_NI_AUTO_ID_ONU_DISCOVERED
#define bcmolt_gpon_ni_auto_id_onu_upgrade_complete                                             BCMOLT_GPON_NI_AUTO_ID_ONU_UPGRADE_COMPLETE
#define bcmolt_gpon_ni_auto_id_protection_switching_onus_ranged                                 BCMOLT_GPON_NI_AUTO_ID_PROTECTION_SWITCHING_ONUS_RANGED
#define bcmolt_gpon_ni_auto_id_protection_switching_switchover_completed                        BCMOLT_GPON_NI_AUTO_ID_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED
#define bcmolt_gpon_ni_auto_id_protection_switching_traffic_resume                              BCMOLT_GPON_NI_AUTO_ID_PROTECTION_SWITCHING_TRAFFIC_RESUME
#define bcmolt_gpon_ni_auto_id_rogue_detection_completed                                        BCMOLT_GPON_NI_AUTO_ID_ROGUE_DETECTION_COMPLETED
#define bcmolt_gpon_ni_auto_id_rogue_onu_special_map_cycle_start                                BCMOLT_GPON_NI_AUTO_ID_ROGUE_ONU_SPECIAL_MAP_CYCLE_START
#define bcmolt_gpon_ni_auto_id_serial_number_acquisition_cycle_start                            BCMOLT_GPON_NI_AUTO_ID_SERIAL_NUMBER_ACQUISITION_CYCLE_START
#define bcmolt_gpon_ni_auto_id_standby_pon_monitoring_cycle_completed                           BCMOLT_GPON_NI_AUTO_ID_STANDBY_PON_MONITORING_CYCLE_COMPLETED
#define bcmolt_gpon_ni_auto_id_stat_alarm_cleared                                               BCMOLT_GPON_NI_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_ni_auto_id_stat_alarm_raised                                                BCMOLT_GPON_NI_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_ni_auto_id_state_change_completed                                           BCMOLT_GPON_NI_AUTO_ID_STATE_CHANGE_COMPLETED
#define bcmolt_gpon_ni_auto_id_tod_request_completed                                            BCMOLT_GPON_NI_AUTO_ID_TOD_REQUEST_COMPLETED
#define bcmolt_gpon_ni_auto_id__num_of                                                          BCMOLT_GPON_NI_AUTO_ID__NUM_OF
#define bcmolt_gpon_ni_oper_id__begin                                                           BCMOLT_GPON_NI_OPER_ID__BEGIN
#define bcmolt_gpon_ni_oper_id_disable_serial_number                                            BCMOLT_GPON_NI_OPER_ID_DISABLE_SERIAL_NUMBER
#define bcmolt_gpon_ni_oper_id_protection_switching_type_c_set_multiple_onu_state               BCMOLT_GPON_NI_OPER_ID_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE
#define bcmolt_gpon_ni_oper_id_reset                                                            BCMOLT_GPON_NI_OPER_ID_RESET
#define bcmolt_gpon_ni_oper_id_rogue_detection_window                                           BCMOLT_GPON_NI_OPER_ID_ROGUE_DETECTION_WINDOW
#define bcmolt_gpon_ni_oper_id_set_onu_state                                                    BCMOLT_GPON_NI_OPER_ID_SET_ONU_STATE
#define bcmolt_gpon_ni_oper_id_set_pon_state                                                    BCMOLT_GPON_NI_OPER_ID_SET_PON_STATE
#define bcmolt_gpon_ni_oper_id_single_request_standby_pon_monitoring                            BCMOLT_GPON_NI_OPER_ID_SINGLE_REQUEST_STANDBY_PON_MONITORING
#define bcmolt_gpon_ni_oper_id_start_onu_upgrade                                                BCMOLT_GPON_NI_OPER_ID_START_ONU_UPGRADE
#define bcmolt_gpon_ni_oper_id_tod_request                                                      BCMOLT_GPON_NI_OPER_ID_TOD_REQUEST
#define bcmolt_gpon_ni_oper_id__num_of                                                          BCMOLT_GPON_NI_OPER_ID__NUM_OF
#define bcmolt_gpon_ni_proxy_id__begin                                                          BCMOLT_GPON_NI_PROXY_ID__BEGIN
#define bcmolt_gpon_ni_proxy_id_broadcast_ploam_packet                                          BCMOLT_GPON_NI_PROXY_ID_BROADCAST_PLOAM_PACKET
#define bcmolt_gpon_ni_proxy_id_cpu_packets                                                     BCMOLT_GPON_NI_PROXY_ID_CPU_PACKETS
#define bcmolt_gpon_ni_proxy_id__num_of                                                         BCMOLT_GPON_NI_PROXY_ID__NUM_OF
#define bcmolt_gpon_onu_auto_id__begin                                                          BCMOLT_GPON_ONU_AUTO_ID__BEGIN
#define bcmolt_gpon_onu_auto_id_ber_interval_configuration_completed                            BCMOLT_GPON_ONU_AUTO_ID_BER_INTERVAL_CONFIGURATION_COMPLETED
#define bcmolt_gpon_onu_auto_id_dfi                                                             BCMOLT_GPON_ONU_AUTO_ID_DFI
#define bcmolt_gpon_onu_auto_id_dgi                                                             BCMOLT_GPON_ONU_AUTO_ID_DGI
#define bcmolt_gpon_onu_auto_id_dowi                                                            BCMOLT_GPON_ONU_AUTO_ID_DOWI
#define bcmolt_gpon_onu_auto_id_err                                                             BCMOLT_GPON_ONU_AUTO_ID_ERR
#define bcmolt_gpon_onu_auto_id_invalid_dbru_report                                             BCMOLT_GPON_ONU_AUTO_ID_INVALID_DBRU_REPORT
#define bcmolt_gpon_onu_auto_id_key_exchange_completed                                          BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_COMPLETED
#define bcmolt_gpon_onu_auto_id_key_exchange_cycle_skipped                                      BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_CYCLE_SKIPPED
#define bcmolt_gpon_onu_auto_id_key_exchange_decrypt_required                                   BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_DECRYPT_REQUIRED
#define bcmolt_gpon_onu_auto_id_key_exchange_key_mismatch                                       BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_KEY_MISMATCH
#define bcmolt_gpon_onu_auto_id_key_exchange_key_request_timeout                                BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT
#define bcmolt_gpon_onu_auto_id_key_exchange_unconsecutive_index                                BCMOLT_GPON_ONU_AUTO_ID_KEY_EXCHANGE_UNCONSECUTIVE_INDEX
#define bcmolt_gpon_onu_auto_id_loai                                                            BCMOLT_GPON_ONU_AUTO_ID_LOAI
#define bcmolt_gpon_onu_auto_id_loki                                                            BCMOLT_GPON_ONU_AUTO_ID_LOKI
#define bcmolt_gpon_onu_auto_id_memi                                                            BCMOLT_GPON_ONU_AUTO_ID_MEMI
#define bcmolt_gpon_onu_auto_id_omci_port_id_configuration_completed                            BCMOLT_GPON_ONU_AUTO_ID_OMCI_PORT_ID_CONFIGURATION_COMPLETED
#define bcmolt_gpon_onu_auto_id_onu_activation_completed                                        BCMOLT_GPON_ONU_AUTO_ID_ONU_ACTIVATION_COMPLETED
#define bcmolt_gpon_onu_auto_id_onu_activation_standby_completed                                BCMOLT_GPON_ONU_AUTO_ID_ONU_ACTIVATION_STANDBY_COMPLETED
#define bcmolt_gpon_onu_auto_id_onu_alarm                                                       BCMOLT_GPON_ONU_AUTO_ID_ONU_ALARM
#define bcmolt_gpon_onu_auto_id_onu_deactivation_completed                                      BCMOLT_GPON_ONU_AUTO_ID_ONU_DEACTIVATION_COMPLETED
#define bcmolt_gpon_onu_auto_id_onu_disable_completed                                           BCMOLT_GPON_ONU_AUTO_ID_ONU_DISABLE_COMPLETED
#define bcmolt_gpon_onu_auto_id_onu_enable_completed                                            BCMOLT_GPON_ONU_AUTO_ID_ONU_ENABLE_COMPLETED
#define bcmolt_gpon_onu_auto_id_optical_reflection                                              BCMOLT_GPON_ONU_AUTO_ID_OPTICAL_REFLECTION
#define bcmolt_gpon_onu_auto_id_password_authentication_completed                               BCMOLT_GPON_ONU_AUTO_ID_PASSWORD_AUTHENTICATION_COMPLETED
#define bcmolt_gpon_onu_auto_id_pee                                                             BCMOLT_GPON_ONU_AUTO_ID_PEE
#define bcmolt_gpon_onu_auto_id_possible_drift                                                  BCMOLT_GPON_ONU_AUTO_ID_POSSIBLE_DRIFT
#define bcmolt_gpon_onu_auto_id_power_management_state_change                                   BCMOLT_GPON_ONU_AUTO_ID_POWER_MANAGEMENT_STATE_CHANGE
#define bcmolt_gpon_onu_auto_id_pst                                                             BCMOLT_GPON_ONU_AUTO_ID_PST
#define bcmolt_gpon_onu_auto_id_ranging_completed                                               BCMOLT_GPON_ONU_AUTO_ID_RANGING_COMPLETED
#define bcmolt_gpon_onu_auto_id_rei                                                             BCMOLT_GPON_ONU_AUTO_ID_REI
#define bcmolt_gpon_onu_auto_id_rssi_measurement_completed                                      BCMOLT_GPON_ONU_AUTO_ID_RSSI_MEASUREMENT_COMPLETED
#define bcmolt_gpon_onu_auto_id_sdi                                                             BCMOLT_GPON_ONU_AUTO_ID_SDI
#define bcmolt_gpon_onu_auto_id_sfi                                                             BCMOLT_GPON_ONU_AUTO_ID_SFI
#define bcmolt_gpon_onu_auto_id_stat_alarm_cleared                                              BCMOLT_GPON_ONU_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_onu_auto_id_stat_alarm_raised                                               BCMOLT_GPON_ONU_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_onu_auto_id_sufi                                                            BCMOLT_GPON_ONU_AUTO_ID_SUFI
#define bcmolt_gpon_onu_auto_id_tiwi                                                            BCMOLT_GPON_ONU_AUTO_ID_TIWI
#define bcmolt_gpon_onu_auto_id__num_of                                                         BCMOLT_GPON_ONU_AUTO_ID__NUM_OF
#define bcmolt_gpon_onu_oper_id__begin                                                          BCMOLT_GPON_ONU_OPER_ID__BEGIN
#define bcmolt_gpon_onu_oper_id_change_power_level                                              BCMOLT_GPON_ONU_OPER_ID_CHANGE_POWER_LEVEL
#define bcmolt_gpon_onu_oper_id_rssi_measurement                                                BCMOLT_GPON_ONU_OPER_ID_RSSI_MEASUREMENT
#define bcmolt_gpon_onu_oper_id_set_onu_state                                                   BCMOLT_GPON_ONU_OPER_ID_SET_ONU_STATE
#define bcmolt_gpon_onu_oper_id__num_of                                                         BCMOLT_GPON_ONU_OPER_ID__NUM_OF
#define bcmolt_gpon_onu_proxy_id__begin                                                         BCMOLT_GPON_ONU_PROXY_ID__BEGIN
#define bcmolt_gpon_onu_proxy_id_cpu_packets                                                    BCMOLT_GPON_ONU_PROXY_ID_CPU_PACKETS
#define bcmolt_gpon_onu_proxy_id_ploam_packet                                                   BCMOLT_GPON_ONU_PROXY_ID_PLOAM_PACKET
#define bcmolt_gpon_onu_proxy_id__num_of                                                        BCMOLT_GPON_ONU_PROXY_ID__NUM_OF
#define bcmolt_gpon_onu_proxy_rx_id__begin                                                      BCMOLT_GPON_ONU_PROXY_RX_ID__BEGIN
#define bcmolt_gpon_onu_proxy_rx_id_cpu_packet                                                  BCMOLT_GPON_ONU_PROXY_RX_ID_CPU_PACKET
#define bcmolt_gpon_onu_proxy_rx_id_omci_packet                                                 BCMOLT_GPON_ONU_PROXY_RX_ID_OMCI_PACKET
#define bcmolt_gpon_onu_proxy_rx_id__num_of                                                     BCMOLT_GPON_ONU_PROXY_RX_ID__NUM_OF
#define bcmolt_log_entry_auto_id__begin                                                         BCMOLT_LOG_ENTRY_AUTO_ID__BEGIN
#define bcmolt_log_entry_auto_id_stat_alarm_cleared                                             BCMOLT_LOG_ENTRY_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_log_entry_auto_id_stat_alarm_raised                                              BCMOLT_LOG_ENTRY_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_log_entry_auto_id__num_of                                                        BCMOLT_LOG_ENTRY_AUTO_ID__NUM_OF
#define bcmolt_logger_auto_id__begin                                                            BCMOLT_LOGGER_AUTO_ID__BEGIN
#define bcmolt_logger_auto_id_stat_alarm_cleared                                                BCMOLT_LOGGER_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_logger_auto_id_stat_alarm_raised                                                 BCMOLT_LOGGER_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_logger_auto_id__num_of                                                           BCMOLT_LOGGER_AUTO_ID__NUM_OF
#define bcmolt_logger_oper_id__begin                                                            BCMOLT_LOGGER_OPER_ID__BEGIN
#define bcmolt_logger_oper_id_clear_log                                                         BCMOLT_LOGGER_OPER_ID_CLEAR_LOG
#define bcmolt_logger_oper_id__num_of                                                           BCMOLT_LOGGER_OPER_ID__NUM_OF
#define bcmolt_nni_auto_id__begin                                                               BCMOLT_NNI_AUTO_ID__BEGIN
#define bcmolt_nni_auto_id_stat_alarm_cleared                                                   BCMOLT_NNI_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_nni_auto_id_stat_alarm_raised                                                    BCMOLT_NNI_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_nni_auto_id_status_changed                                                       BCMOLT_NNI_AUTO_ID_STATUS_CHANGED
#define bcmolt_nni_auto_id__num_of                                                              BCMOLT_NNI_AUTO_ID__NUM_OF
#define bcmolt_trx_calibration_auto_id__begin                                                   BCMOLT_TRX_CALIBRATION_AUTO_ID__BEGIN
#define bcmolt_trx_calibration_auto_id_capture_window_and_statistic_completed                   BCMOLT_TRX_CALIBRATION_AUTO_ID_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED
#define bcmolt_trx_calibration_auto_id__num_of                                                  BCMOLT_TRX_CALIBRATION_AUTO_ID__NUM_OF
#define bcmolt_trx_calibration_oper_id__begin                                                   BCMOLT_TRX_CALIBRATION_OPER_ID__BEGIN
#define bcmolt_trx_calibration_oper_id_start_capture_window                                     BCMOLT_TRX_CALIBRATION_OPER_ID_START_CAPTURE_WINDOW
#define bcmolt_trx_calibration_oper_id_stop_capture_window                                      BCMOLT_TRX_CALIBRATION_OPER_ID_STOP_CAPTURE_WINDOW
#define bcmolt_trx_calibration_oper_id__num_of                                                  BCMOLT_TRX_CALIBRATION_OPER_ID__NUM_OF
#define bcmolt_xgpon_alloc_auto_id__begin                                                       BCMOLT_XGPON_ALLOC_AUTO_ID__BEGIN
#define bcmolt_xgpon_alloc_auto_id_configuration_completed                                      BCMOLT_XGPON_ALLOC_AUTO_ID_CONFIGURATION_COMPLETED
#define bcmolt_xgpon_alloc_auto_id_get_alloc_stats_completed                                    BCMOLT_XGPON_ALLOC_AUTO_ID_GET_ALLOC_STATS_COMPLETED
#define bcmolt_xgpon_alloc_auto_id_stat_alarm_cleared                                           BCMOLT_XGPON_ALLOC_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_xgpon_alloc_auto_id_stat_alarm_raised                                            BCMOLT_XGPON_ALLOC_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_xgpon_alloc_auto_id__num_of                                                      BCMOLT_XGPON_ALLOC_AUTO_ID__NUM_OF
#define bcmolt_xgpon_alloc_oper_id__begin                                                       BCMOLT_XGPON_ALLOC_OPER_ID__BEGIN
#define bcmolt_xgpon_alloc_oper_id_get_stats                                                    BCMOLT_XGPON_ALLOC_OPER_ID_GET_STATS
#define bcmolt_xgpon_alloc_oper_id_set_state                                                    BCMOLT_XGPON_ALLOC_OPER_ID_SET_STATE
#define bcmolt_xgpon_alloc_oper_id__num_of                                                      BCMOLT_XGPON_ALLOC_OPER_ID__NUM_OF
#define bcmolt_xgpon_gem_port_auto_id__begin                                                    BCMOLT_XGPON_GEM_PORT_AUTO_ID__BEGIN
#define bcmolt_xgpon_gem_port_auto_id_stat_alarm_cleared                                        BCMOLT_XGPON_GEM_PORT_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_xgpon_gem_port_auto_id_stat_alarm_raised                                         BCMOLT_XGPON_GEM_PORT_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_xgpon_gem_port_auto_id__num_of                                                   BCMOLT_XGPON_GEM_PORT_AUTO_ID__NUM_OF
#define bcmolt_xgpon_ni_auto_id__begin                                                          BCMOLT_XGPON_NI_AUTO_ID__BEGIN
#define bcmolt_xgpon_ni_auto_id_activate_all_onus_completed                                     BCMOLT_XGPON_NI_AUTO_ID_ACTIVATE_ALL_ONUS_COMPLETED
#define bcmolt_xgpon_ni_auto_id_cpu_packets_failure                                             BCMOLT_XGPON_NI_AUTO_ID_CPU_PACKETS_FAILURE
#define bcmolt_xgpon_ni_auto_id_deactivate_all_onus_completed                                   BCMOLT_XGPON_NI_AUTO_ID_DEACTIVATE_ALL_ONUS_COMPLETED
#define bcmolt_xgpon_ni_auto_id_disable_all_onus_completed                                      BCMOLT_XGPON_NI_AUTO_ID_DISABLE_ALL_ONUS_COMPLETED
#define bcmolt_xgpon_ni_auto_id_enable_all_onus_completed                                       BCMOLT_XGPON_NI_AUTO_ID_ENABLE_ALL_ONUS_COMPLETED
#define bcmolt_xgpon_ni_auto_id_los                                                             BCMOLT_XGPON_NI_AUTO_ID_LOS
#define bcmolt_xgpon_ni_auto_id_onu_discovered                                                  BCMOLT_XGPON_NI_AUTO_ID_ONU_DISCOVERED
#define bcmolt_xgpon_ni_auto_id_onu_upgrade_complete                                            BCMOLT_XGPON_NI_AUTO_ID_ONU_UPGRADE_COMPLETE
#define bcmolt_xgpon_ni_auto_id_protection_switching_onus_ranged                                BCMOLT_XGPON_NI_AUTO_ID_PROTECTION_SWITCHING_ONUS_RANGED
#define bcmolt_xgpon_ni_auto_id_protection_switching_switchover_completed                       BCMOLT_XGPON_NI_AUTO_ID_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED
#define bcmolt_xgpon_ni_auto_id_protection_switching_traffic_resume                             BCMOLT_XGPON_NI_AUTO_ID_PROTECTION_SWITCHING_TRAFFIC_RESUME
#define bcmolt_xgpon_ni_auto_id_rogue_detection_completed                                       BCMOLT_XGPON_NI_AUTO_ID_ROGUE_DETECTION_COMPLETED
#define bcmolt_xgpon_ni_auto_id_rogue_onu_special_map_cycle_start                               BCMOLT_XGPON_NI_AUTO_ID_ROGUE_ONU_SPECIAL_MAP_CYCLE_START
#define bcmolt_xgpon_ni_auto_id_serial_number_acquisition_cycle_start                           BCMOLT_XGPON_NI_AUTO_ID_SERIAL_NUMBER_ACQUISITION_CYCLE_START
#define bcmolt_xgpon_ni_auto_id_standby_pon_monitoring_cycle_completed                          BCMOLT_XGPON_NI_AUTO_ID_STANDBY_PON_MONITORING_CYCLE_COMPLETED
#define bcmolt_xgpon_ni_auto_id_stat_alarm_cleared                                              BCMOLT_XGPON_NI_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_xgpon_ni_auto_id_stat_alarm_raised                                               BCMOLT_XGPON_NI_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_xgpon_ni_auto_id_state_change_completed                                          BCMOLT_XGPON_NI_AUTO_ID_STATE_CHANGE_COMPLETED
#define bcmolt_xgpon_ni_auto_id_tod_request_completed                                           BCMOLT_XGPON_NI_AUTO_ID_TOD_REQUEST_COMPLETED
#define bcmolt_xgpon_ni_auto_id__num_of                                                         BCMOLT_XGPON_NI_AUTO_ID__NUM_OF
#define bcmolt_xgpon_ni_oper_id__begin                                                          BCMOLT_XGPON_NI_OPER_ID__BEGIN
#define bcmolt_xgpon_ni_oper_id_adjust_tx_wavelength                                            BCMOLT_XGPON_NI_OPER_ID_ADJUST_TX_WAVELENGTH
#define bcmolt_xgpon_ni_oper_id_disable_serial_number                                           BCMOLT_XGPON_NI_OPER_ID_DISABLE_SERIAL_NUMBER
#define bcmolt_xgpon_ni_oper_id_reset                                                           BCMOLT_XGPON_NI_OPER_ID_RESET
#define bcmolt_xgpon_ni_oper_id_rogue_detection_window                                          BCMOLT_XGPON_NI_OPER_ID_ROGUE_DETECTION_WINDOW
#define bcmolt_xgpon_ni_oper_id_run_special_bw_map                                              BCMOLT_XGPON_NI_OPER_ID_RUN_SPECIAL_BW_MAP
#define bcmolt_xgpon_ni_oper_id_set_onu_state                                                   BCMOLT_XGPON_NI_OPER_ID_SET_ONU_STATE
#define bcmolt_xgpon_ni_oper_id_set_pon_state                                                   BCMOLT_XGPON_NI_OPER_ID_SET_PON_STATE
#define bcmolt_xgpon_ni_oper_id_single_request_standby_pon_monitoring                           BCMOLT_XGPON_NI_OPER_ID_SINGLE_REQUEST_STANDBY_PON_MONITORING
#define bcmolt_xgpon_ni_oper_id_start_onu_upgrade                                               BCMOLT_XGPON_NI_OPER_ID_START_ONU_UPGRADE
#define bcmolt_xgpon_ni_oper_id_tod_request                                                     BCMOLT_XGPON_NI_OPER_ID_TOD_REQUEST
#define bcmolt_xgpon_ni_oper_id__num_of                                                         BCMOLT_XGPON_NI_OPER_ID__NUM_OF
#define bcmolt_xgpon_ni_proxy_id__begin                                                         BCMOLT_XGPON_NI_PROXY_ID__BEGIN
#define bcmolt_xgpon_ni_proxy_id_broadcast_ploam_packet                                         BCMOLT_XGPON_NI_PROXY_ID_BROADCAST_PLOAM_PACKET
#define bcmolt_xgpon_ni_proxy_id_cpu_packets                                                    BCMOLT_XGPON_NI_PROXY_ID_CPU_PACKETS
#define bcmolt_xgpon_ni_proxy_id__num_of                                                        BCMOLT_XGPON_NI_PROXY_ID__NUM_OF
#define bcmolt_xgpon_onu_auto_id__begin                                                         BCMOLT_XGPON_ONU_AUTO_ID__BEGIN
#define bcmolt_xgpon_onu_auto_id_dfi                                                            BCMOLT_XGPON_ONU_AUTO_ID_DFI
#define bcmolt_xgpon_onu_auto_id_dgi                                                            BCMOLT_XGPON_ONU_AUTO_ID_DGI
#define bcmolt_xgpon_onu_auto_id_dowi                                                           BCMOLT_XGPON_ONU_AUTO_ID_DOWI
#define bcmolt_xgpon_onu_auto_id_invalid_dbru_report                                            BCMOLT_XGPON_ONU_AUTO_ID_INVALID_DBRU_REPORT
#define bcmolt_xgpon_onu_auto_id_key_exchange_completed                                         BCMOLT_XGPON_ONU_AUTO_ID_KEY_EXCHANGE_COMPLETED
#define bcmolt_xgpon_onu_auto_id_key_exchange_cycle_skipped                                     BCMOLT_XGPON_ONU_AUTO_ID_KEY_EXCHANGE_CYCLE_SKIPPED
#define bcmolt_xgpon_onu_auto_id_key_exchange_key_mismatch                                      BCMOLT_XGPON_ONU_AUTO_ID_KEY_EXCHANGE_KEY_MISMATCH
#define bcmolt_xgpon_onu_auto_id_key_exchange_key_request_timeout                               BCMOLT_XGPON_ONU_AUTO_ID_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT
#define bcmolt_xgpon_onu_auto_id_looci                                                          BCMOLT_XGPON_ONU_AUTO_ID_LOOCI
#define bcmolt_xgpon_onu_auto_id_onu_activation_completed                                       BCMOLT_XGPON_ONU_AUTO_ID_ONU_ACTIVATION_COMPLETED
#define bcmolt_xgpon_onu_auto_id_onu_alarm                                                      BCMOLT_XGPON_ONU_AUTO_ID_ONU_ALARM
#define bcmolt_xgpon_onu_auto_id_onu_deactivation_completed                                     BCMOLT_XGPON_ONU_AUTO_ID_ONU_DEACTIVATION_COMPLETED
#define bcmolt_xgpon_onu_auto_id_onu_disable_completed                                          BCMOLT_XGPON_ONU_AUTO_ID_ONU_DISABLE_COMPLETED
#define bcmolt_xgpon_onu_auto_id_onu_enable_completed                                           BCMOLT_XGPON_ONU_AUTO_ID_ONU_ENABLE_COMPLETED
#define bcmolt_xgpon_onu_auto_id_onu_tuning_in_completed                                        BCMOLT_XGPON_ONU_AUTO_ID_ONU_TUNING_IN_COMPLETED
#define bcmolt_xgpon_onu_auto_id_onu_tuning_out_completed                                       BCMOLT_XGPON_ONU_AUTO_ID_ONU_TUNING_OUT_COMPLETED
#define bcmolt_xgpon_onu_auto_id_optical_reflection                                             BCMOLT_XGPON_ONU_AUTO_ID_OPTICAL_REFLECTION
#define bcmolt_xgpon_onu_auto_id_possible_drift                                                 BCMOLT_XGPON_ONU_AUTO_ID_POSSIBLE_DRIFT
#define bcmolt_xgpon_onu_auto_id_power_consumption_report                                       BCMOLT_XGPON_ONU_AUTO_ID_POWER_CONSUMPTION_REPORT
#define bcmolt_xgpon_onu_auto_id_power_level_report                                             BCMOLT_XGPON_ONU_AUTO_ID_POWER_LEVEL_REPORT
#define bcmolt_xgpon_onu_auto_id_power_management_state_change                                  BCMOLT_XGPON_ONU_AUTO_ID_POWER_MANAGEMENT_STATE_CHANGE
#define bcmolt_xgpon_onu_auto_id_pqsi                                                           BCMOLT_XGPON_ONU_AUTO_ID_PQSI
#define bcmolt_xgpon_onu_auto_id_ranging_completed                                              BCMOLT_XGPON_ONU_AUTO_ID_RANGING_COMPLETED
#define bcmolt_xgpon_onu_auto_id_registration_id                                                BCMOLT_XGPON_ONU_AUTO_ID_REGISTRATION_ID
#define bcmolt_xgpon_onu_auto_id_rssi_measurement_completed                                     BCMOLT_XGPON_ONU_AUTO_ID_RSSI_MEASUREMENT_COMPLETED
#define bcmolt_xgpon_onu_auto_id_sdi                                                            BCMOLT_XGPON_ONU_AUTO_ID_SDI
#define bcmolt_xgpon_onu_auto_id_secure_mutual_authentication_failure                           BCMOLT_XGPON_ONU_AUTO_ID_SECURE_MUTUAL_AUTHENTICATION_FAILURE
#define bcmolt_xgpon_onu_auto_id_sfi                                                            BCMOLT_XGPON_ONU_AUTO_ID_SFI
#define bcmolt_xgpon_onu_auto_id_stat_alarm_cleared                                             BCMOLT_XGPON_ONU_AUTO_ID_STAT_ALARM_CLEARED
#define bcmolt_xgpon_onu_auto_id_stat_alarm_raised                                              BCMOLT_XGPON_ONU_AUTO_ID_STAT_ALARM_RAISED
#define bcmolt_xgpon_onu_auto_id_sufi                                                           BCMOLT_XGPON_ONU_AUTO_ID_SUFI
#define bcmolt_xgpon_onu_auto_id_tiwi                                                           BCMOLT_XGPON_ONU_AUTO_ID_TIWI
#define bcmolt_xgpon_onu_auto_id_tuning_response                                                BCMOLT_XGPON_ONU_AUTO_ID_TUNING_RESPONSE
#define bcmolt_xgpon_onu_auto_id__num_of                                                        BCMOLT_XGPON_ONU_AUTO_ID__NUM_OF
#define bcmolt_xgpon_onu_oper_id__begin                                                         BCMOLT_XGPON_ONU_OPER_ID__BEGIN
#define bcmolt_xgpon_onu_oper_id_adjust_tx_wavelength                                           BCMOLT_XGPON_ONU_OPER_ID_ADJUST_TX_WAVELENGTH
#define bcmolt_xgpon_onu_oper_id_change_power_levelling                                         BCMOLT_XGPON_ONU_OPER_ID_CHANGE_POWER_LEVELLING
#define bcmolt_xgpon_onu_oper_id_get_power_consumption                                          BCMOLT_XGPON_ONU_OPER_ID_GET_POWER_CONSUMPTION
#define bcmolt_xgpon_onu_oper_id_get_power_level                                                BCMOLT_XGPON_ONU_OPER_ID_GET_POWER_LEVEL
#define bcmolt_xgpon_onu_oper_id_onu_tuning_in                                                  BCMOLT_XGPON_ONU_OPER_ID_ONU_TUNING_IN
#define bcmolt_xgpon_onu_oper_id_onu_tuning_out                                                 BCMOLT_XGPON_ONU_OPER_ID_ONU_TUNING_OUT
#define bcmolt_xgpon_onu_oper_id_request_registration                                           BCMOLT_XGPON_ONU_OPER_ID_REQUEST_REGISTRATION
#define bcmolt_xgpon_onu_oper_id_rssi_measurement                                               BCMOLT_XGPON_ONU_OPER_ID_RSSI_MEASUREMENT
#define bcmolt_xgpon_onu_oper_id_secure_mutual_authentication                                   BCMOLT_XGPON_ONU_OPER_ID_SECURE_MUTUAL_AUTHENTICATION
#define bcmolt_xgpon_onu_oper_id_set_onu_state                                                  BCMOLT_XGPON_ONU_OPER_ID_SET_ONU_STATE
#define bcmolt_xgpon_onu_oper_id__num_of                                                        BCMOLT_XGPON_ONU_OPER_ID__NUM_OF
#define bcmolt_xgpon_onu_proxy_id__begin                                                        BCMOLT_XGPON_ONU_PROXY_ID__BEGIN
#define bcmolt_xgpon_onu_proxy_id_cpu_packets                                                   BCMOLT_XGPON_ONU_PROXY_ID_CPU_PACKETS
#define bcmolt_xgpon_onu_proxy_id_ploam_packet                                                  BCMOLT_XGPON_ONU_PROXY_ID_PLOAM_PACKET
#define bcmolt_xgpon_onu_proxy_id__num_of                                                       BCMOLT_XGPON_ONU_PROXY_ID__NUM_OF
#define bcmolt_xgpon_onu_proxy_rx_id__begin                                                     BCMOLT_XGPON_ONU_PROXY_RX_ID__BEGIN
#define bcmolt_xgpon_onu_proxy_rx_id_cpu_packet                                                 BCMOLT_XGPON_ONU_PROXY_RX_ID_CPU_PACKET
#define bcmolt_xgpon_onu_proxy_rx_id_omci_packet                                                BCMOLT_XGPON_ONU_PROXY_RX_ID_OMCI_PACKET
#define bcmolt_xgpon_onu_proxy_rx_id__num_of                                                    BCMOLT_XGPON_ONU_PROXY_RX_ID__NUM_OF
#define bcmolt_ae_ni_key_id_ae_ni                                                               BCMOLT_AE_NI_KEY_ID_AE_NI
#define bcmolt_ae_ni_key_id__num_of                                                             BCMOLT_AE_NI_KEY_ID__NUM_OF
#define bcmolt_ae_ni_cfg_id_mac_address                                                         BCMOLT_AE_NI_CFG_ID_MAC_ADDRESS
#define bcmolt_ae_ni_cfg_id_ae_ni_en                                                            BCMOLT_AE_NI_CFG_ID_AE_NI_EN
#define bcmolt_ae_ni_cfg_id_mtu_10g                                                             BCMOLT_AE_NI_CFG_ID_MTU_10G
#define bcmolt_ae_ni_cfg_id_prbs_generator                                                      BCMOLT_AE_NI_CFG_ID_PRBS_GENERATOR
#define bcmolt_ae_ni_cfg_id_prbs_checker                                                        BCMOLT_AE_NI_CFG_ID_PRBS_CHECKER
#define bcmolt_ae_ni_cfg_id_prbs_status                                                         BCMOLT_AE_NI_CFG_ID_PRBS_STATUS
#define bcmolt_ae_ni_cfg_id__num_of                                                             BCMOLT_AE_NI_CFG_ID__NUM_OF
#define bcmolt_ae_ni_set_ae_ni_en_state_id_new_state                                            BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID_NEW_STATE
#define bcmolt_ae_ni_set_ae_ni_en_state_id__num_of                                              BCMOLT_AE_NI_SET_AE_NI_EN_STATE_ID__NUM_OF
#define bcmolt_ae_path_ds_key_id_ae_ni                                                          BCMOLT_AE_PATH_DS_KEY_ID_AE_NI
#define bcmolt_ae_path_ds_key_id__num_of                                                        BCMOLT_AE_PATH_DS_KEY_ID__NUM_OF
#define bcmolt_ae_path_ds_stat_id_bytes                                                         BCMOLT_AE_PATH_DS_STAT_ID_BYTES
#define bcmolt_ae_path_ds_stat_id_frames                                                        BCMOLT_AE_PATH_DS_STAT_ID_FRAMES
#define bcmolt_ae_path_ds_stat_id_frames_64                                                     BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_64
#define bcmolt_ae_path_ds_stat_id_frames_65_127                                                 BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_65_127
#define bcmolt_ae_path_ds_stat_id_frames_128_255                                                BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_128_255
#define bcmolt_ae_path_ds_stat_id_frames_256_511                                                BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_256_511
#define bcmolt_ae_path_ds_stat_id_frames_512_1023                                               BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_512_1023
#define bcmolt_ae_path_ds_stat_id_frames_1024_1518                                              BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1024_1518
#define bcmolt_ae_path_ds_stat_id_frames_1519_2047                                              BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_1519_2047
#define bcmolt_ae_path_ds_stat_id_frames_2048_4095                                              BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_2048_4095
#define bcmolt_ae_path_ds_stat_id_frames_4096_9216                                              BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_4096_9216
#define bcmolt_ae_path_ds_stat_id_frames_9217_16383                                             BCMOLT_AE_PATH_DS_STAT_ID_FRAMES_9217_16383
#define bcmolt_ae_path_ds_stat_id_broadcast_frames                                              BCMOLT_AE_PATH_DS_STAT_ID_BROADCAST_FRAMES
#define bcmolt_ae_path_ds_stat_id_data_bytes                                                    BCMOLT_AE_PATH_DS_STAT_ID_DATA_BYTES
#define bcmolt_ae_path_ds_stat_id_multicast_frames                                              BCMOLT_AE_PATH_DS_STAT_ID_MULTICAST_FRAMES
#define bcmolt_ae_path_ds_stat_id_unicast_frames                                                BCMOLT_AE_PATH_DS_STAT_ID_UNICAST_FRAMES
#define bcmolt_ae_path_ds_stat_id_abort_frames                                                  BCMOLT_AE_PATH_DS_STAT_ID_ABORT_FRAMES
#define bcmolt_ae_path_ds_stat_id__num_of                                                       BCMOLT_AE_PATH_DS_STAT_ID__NUM_OF
#define bcmolt_ae_path_ds_stat_cfg_id_cfg                                                       BCMOLT_AE_PATH_DS_STAT_CFG_ID_CFG
#define bcmolt_ae_path_ds_stat_cfg_id__num_of                                                   BCMOLT_AE_PATH_DS_STAT_CFG_ID__NUM_OF
#define bcmolt_ae_path_ds_stat_alarm_cleared_id_stat                                            BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_ae_path_ds_stat_alarm_cleared_id__num_of                                         BCMOLT_AE_PATH_DS_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_ae_path_ds_stat_alarm_raised_id_stat                                             BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_ae_path_ds_stat_alarm_raised_id__num_of                                          BCMOLT_AE_PATH_DS_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_ae_path_ds_auto_cfg_id_stat_alarm_cleared                                        BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_ae_path_ds_auto_cfg_id_stat_alarm_raised                                         BCMOLT_AE_PATH_DS_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_ae_path_ds_auto_cfg_id__num_of                                                   BCMOLT_AE_PATH_DS_AUTO_CFG_ID__NUM_OF
#define bcmolt_ae_path_us_key_id_ae_ni                                                          BCMOLT_AE_PATH_US_KEY_ID_AE_NI
#define bcmolt_ae_path_us_key_id__num_of                                                        BCMOLT_AE_PATH_US_KEY_ID__NUM_OF
#define bcmolt_ae_path_us_stat_id_bytes                                                         BCMOLT_AE_PATH_US_STAT_ID_BYTES
#define bcmolt_ae_path_us_stat_id_frames                                                        BCMOLT_AE_PATH_US_STAT_ID_FRAMES
#define bcmolt_ae_path_us_stat_id_frames_64                                                     BCMOLT_AE_PATH_US_STAT_ID_FRAMES_64
#define bcmolt_ae_path_us_stat_id_frames_65_127                                                 BCMOLT_AE_PATH_US_STAT_ID_FRAMES_65_127
#define bcmolt_ae_path_us_stat_id_frames_128_255                                                BCMOLT_AE_PATH_US_STAT_ID_FRAMES_128_255
#define bcmolt_ae_path_us_stat_id_frames_256_511                                                BCMOLT_AE_PATH_US_STAT_ID_FRAMES_256_511
#define bcmolt_ae_path_us_stat_id_frames_512_1023                                               BCMOLT_AE_PATH_US_STAT_ID_FRAMES_512_1023
#define bcmolt_ae_path_us_stat_id_frames_1024_1518                                              BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1024_1518
#define bcmolt_ae_path_us_stat_id_frames_1519_2047                                              BCMOLT_AE_PATH_US_STAT_ID_FRAMES_1519_2047
#define bcmolt_ae_path_us_stat_id_frames_2048_4095                                              BCMOLT_AE_PATH_US_STAT_ID_FRAMES_2048_4095
#define bcmolt_ae_path_us_stat_id_frames_4096_9216                                              BCMOLT_AE_PATH_US_STAT_ID_FRAMES_4096_9216
#define bcmolt_ae_path_us_stat_id_frames_9217_16383                                             BCMOLT_AE_PATH_US_STAT_ID_FRAMES_9217_16383
#define bcmolt_ae_path_us_stat_id_broadcast_frames                                              BCMOLT_AE_PATH_US_STAT_ID_BROADCAST_FRAMES
#define bcmolt_ae_path_us_stat_id_data_bytes                                                    BCMOLT_AE_PATH_US_STAT_ID_DATA_BYTES
#define bcmolt_ae_path_us_stat_id_multicast_frames                                              BCMOLT_AE_PATH_US_STAT_ID_MULTICAST_FRAMES
#define bcmolt_ae_path_us_stat_id_unicast_frames                                                BCMOLT_AE_PATH_US_STAT_ID_UNICAST_FRAMES
#define bcmolt_ae_path_us_stat_id_abort_frames                                                  BCMOLT_AE_PATH_US_STAT_ID_ABORT_FRAMES
#define bcmolt_ae_path_us_stat_id_fcs_error                                                     BCMOLT_AE_PATH_US_STAT_ID_FCS_ERROR
#define bcmolt_ae_path_us_stat_id_oversize_error                                                BCMOLT_AE_PATH_US_STAT_ID_OVERSIZE_ERROR
#define bcmolt_ae_path_us_stat_id_runt_error                                                    BCMOLT_AE_PATH_US_STAT_ID_RUNT_ERROR
#define bcmolt_ae_path_us_stat_id__num_of                                                       BCMOLT_AE_PATH_US_STAT_ID__NUM_OF
#define bcmolt_ae_path_us_stat_cfg_id_cfg                                                       BCMOLT_AE_PATH_US_STAT_CFG_ID_CFG
#define bcmolt_ae_path_us_stat_cfg_id__num_of                                                   BCMOLT_AE_PATH_US_STAT_CFG_ID__NUM_OF
#define bcmolt_ae_path_us_stat_alarm_cleared_id_stat                                            BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_ae_path_us_stat_alarm_cleared_id__num_of                                         BCMOLT_AE_PATH_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_ae_path_us_stat_alarm_raised_id_stat                                             BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_ae_path_us_stat_alarm_raised_id__num_of                                          BCMOLT_AE_PATH_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_ae_path_us_auto_cfg_id_stat_alarm_cleared                                        BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_ae_path_us_auto_cfg_id_stat_alarm_raised                                         BCMOLT_AE_PATH_US_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_ae_path_us_auto_cfg_id__num_of                                                   BCMOLT_AE_PATH_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_channel_key_id_pon_ni                                                            BCMOLT_CHANNEL_KEY_ID_PON_NI
#define bcmolt_channel_key_id__num_of                                                           BCMOLT_CHANNEL_KEY_ID__NUM_OF
#define bcmolt_channel_cfg_id_operation_control                                                 BCMOLT_CHANNEL_CFG_ID_OPERATION_CONTROL
#define bcmolt_channel_cfg_id_tol                                                               BCMOLT_CHANNEL_CFG_ID_TOL
#define bcmolt_channel_cfg_id_system_profile                                                    BCMOLT_CHANNEL_CFG_ID_SYSTEM_PROFILE
#define bcmolt_channel_cfg_id_channel_profile                                                   BCMOLT_CHANNEL_CFG_ID_CHANNEL_PROFILE
#define bcmolt_channel_cfg_id__num_of                                                           BCMOLT_CHANNEL_CFG_ID__NUM_OF
#define bcmolt_debug_key_id_reserved                                                            BCMOLT_DEBUG_KEY_ID_RESERVED
#define bcmolt_debug_key_id__num_of                                                             BCMOLT_DEBUG_KEY_ID__NUM_OF
#define bcmolt_debug_cfg_id_console_redirection                                                 BCMOLT_DEBUG_CFG_ID_CONSOLE_REDIRECTION
#define bcmolt_debug_cfg_id_indications_dropped                                                 BCMOLT_DEBUG_CFG_ID_INDICATIONS_DROPPED
#define bcmolt_debug_cfg_id_file_used_percent                                                   BCMOLT_DEBUG_CFG_ID_FILE_USED_PERCENT
#define bcmolt_debug_cfg_id_api_capture_cfg                                                     BCMOLT_DEBUG_CFG_ID_API_CAPTURE_CFG
#define bcmolt_debug_cfg_id_api_capture_stats                                                   BCMOLT_DEBUG_CFG_ID_API_CAPTURE_STATS
#define bcmolt_debug_cfg_id_api_capture_buffer_read                                             BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER_READ
#define bcmolt_debug_cfg_id_api_capture_buffer                                                  BCMOLT_DEBUG_CFG_ID_API_CAPTURE_BUFFER
#define bcmolt_debug_cfg_id__num_of                                                             BCMOLT_DEBUG_CFG_ID__NUM_OF
#define bcmolt_debug_cli_output_id_data                                                         BCMOLT_DEBUG_CLI_OUTPUT_ID_DATA
#define bcmolt_debug_cli_output_id__num_of                                                      BCMOLT_DEBUG_CLI_OUTPUT_ID__NUM_OF
#define bcmolt_debug_file_almost_full_id__num_of                                                BCMOLT_DEBUG_FILE_ALMOST_FULL_ID__NUM_OF
#define bcmolt_debug_auto_cfg_id_cli_output                                                     BCMOLT_DEBUG_AUTO_CFG_ID_CLI_OUTPUT
#define bcmolt_debug_auto_cfg_id_file_almost_full                                               BCMOLT_DEBUG_AUTO_CFG_ID_FILE_ALMOST_FULL
#define bcmolt_debug_auto_cfg_id__num_of                                                        BCMOLT_DEBUG_AUTO_CFG_ID__NUM_OF
#define bcmolt_debug_cli_input_id_data                                                          BCMOLT_DEBUG_CLI_INPUT_ID_DATA
#define bcmolt_debug_cli_input_id__num_of                                                       BCMOLT_DEBUG_CLI_INPUT_ID__NUM_OF
#define bcmolt_debug_reset_api_capture_id__num_of                                               BCMOLT_DEBUG_RESET_API_CAPTURE_ID__NUM_OF
#define bcmolt_debug_start_api_capture_id__num_of                                               BCMOLT_DEBUG_START_API_CAPTURE_ID__NUM_OF
#define bcmolt_debug_stop_api_capture_id__num_of                                                BCMOLT_DEBUG_STOP_API_CAPTURE_ID__NUM_OF
#define bcmolt_device_key_id_reserved                                                           BCMOLT_DEVICE_KEY_ID_RESERVED
#define bcmolt_device_key_id__num_of                                                            BCMOLT_DEVICE_KEY_ID__NUM_OF
#define bcmolt_device_cfg_id_system_mode                                                        BCMOLT_DEVICE_CFG_ID_SYSTEM_MODE
#define bcmolt_device_cfg_id_keepalive_interval                                                 BCMOLT_DEVICE_CFG_ID_KEEPALIVE_INTERVAL
#define bcmolt_device_cfg_id_keepalive_tolerance                                                BCMOLT_DEVICE_CFG_ID_KEEPALIVE_TOLERANCE
#define bcmolt_device_cfg_id_firmware_sw_version                                                BCMOLT_DEVICE_CFG_ID_FIRMWARE_SW_VERSION
#define bcmolt_device_cfg_id_host_sw_version                                                    BCMOLT_DEVICE_CFG_ID_HOST_SW_VERSION
#define bcmolt_device_cfg_id_chip_revision                                                      BCMOLT_DEVICE_CFG_ID_CHIP_REVISION
#define bcmolt_device_cfg_id_state                                                              BCMOLT_DEVICE_CFG_ID_STATE
#define bcmolt_device_cfg_id_debug                                                              BCMOLT_DEVICE_CFG_ID_DEBUG
#define bcmolt_device_cfg_id_nni_speed                                                          BCMOLT_DEVICE_CFG_ID_NNI_SPEED
#define bcmolt_device_cfg_id_protection_switching_ext_irq                                       BCMOLT_DEVICE_CFG_ID_PROTECTION_SWITCHING_EXT_IRQ
#define bcmolt_device_cfg_id_epon_clock_transport_sample_delay                                  BCMOLT_DEVICE_CFG_ID_EPON_CLOCK_TRANSPORT_SAMPLE_DELAY
#define bcmolt_device_cfg_id_indication_shaping                                                 BCMOLT_DEVICE_CFG_ID_INDICATION_SHAPING
#define bcmolt_device_cfg_id_chip_temperature                                                   BCMOLT_DEVICE_CFG_ID_CHIP_TEMPERATURE
#define bcmolt_device_cfg_id_gpon_xgpon_tod_enable                                              BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_ENABLE
#define bcmolt_device_cfg_id_gpon_xgpon_tod_gpio_pin                                            BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_GPIO_PIN
#define bcmolt_device_cfg_id_gpon_xgpon_tod_connected_internally                                BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_CONNECTED_INTERNALLY
#define bcmolt_device_cfg_id_epon_8021_as_tod_format                                            BCMOLT_DEVICE_CFG_ID_EPON_8021_AS_TOD_FORMAT
#define bcmolt_device_cfg_id_epon_shaper_mode                                                   BCMOLT_DEVICE_CFG_ID_EPON_SHAPER_MODE
#define bcmolt_device_cfg_id_embedded_image_list                                                BCMOLT_DEVICE_CFG_ID_EMBEDDED_IMAGE_LIST
#define bcmolt_device_cfg_id_chip_voltage                                                       BCMOLT_DEVICE_CFG_ID_CHIP_VOLTAGE
#define bcmolt_device_cfg_id_epon_tod_string                                                    BCMOLT_DEVICE_CFG_ID_EPON_TOD_STRING
#define bcmolt_device_cfg_id_xgpon_num_of_onus                                                  BCMOLT_DEVICE_CFG_ID_XGPON_NUM_OF_ONUS
#define bcmolt_device_cfg_id_device_ip_address                                                  BCMOLT_DEVICE_CFG_ID_DEVICE_IP_ADDRESS
#define bcmolt_device_cfg_id_device_udp_port                                                    BCMOLT_DEVICE_CFG_ID_DEVICE_UDP_PORT
#define bcmolt_device_cfg_id_tod_uart_baudrate                                                  BCMOLT_DEVICE_CFG_ID_TOD_UART_BAUDRATE
#define bcmolt_device_cfg_id_gpon_xgpon_tod_string_length                                       BCMOLT_DEVICE_CFG_ID_GPON_XGPON_TOD_STRING_LENGTH
#define bcmolt_device_cfg_id__num_of                                                            BCMOLT_DEVICE_CFG_ID__NUM_OF
#define bcmolt_device_connection_complete_id_standalone                                         BCMOLT_DEVICE_CONNECTION_COMPLETE_ID_STANDALONE
#define bcmolt_device_connection_complete_id__num_of                                            BCMOLT_DEVICE_CONNECTION_COMPLETE_ID__NUM_OF
#define bcmolt_device_connection_established_id__num_of                                         BCMOLT_DEVICE_CONNECTION_ESTABLISHED_ID__NUM_OF
#define bcmolt_device_connection_failure_id_reason                                              BCMOLT_DEVICE_CONNECTION_FAILURE_ID_REASON
#define bcmolt_device_connection_failure_id__num_of                                             BCMOLT_DEVICE_CONNECTION_FAILURE_ID__NUM_OF
#define bcmolt_device_ddr_test_complete_id_ddr_test                                             BCMOLT_DEVICE_DDR_TEST_COMPLETE_ID_DDR_TEST
#define bcmolt_device_ddr_test_complete_id__num_of                                              BCMOLT_DEVICE_DDR_TEST_COMPLETE_ID__NUM_OF
#define bcmolt_device_device_keep_alive_id_sequence_number                                      BCMOLT_DEVICE_DEVICE_KEEP_ALIVE_ID_SEQUENCE_NUMBER
#define bcmolt_device_device_keep_alive_id_time_stamp                                           BCMOLT_DEVICE_DEVICE_KEEP_ALIVE_ID_TIME_STAMP
#define bcmolt_device_device_keep_alive_id__num_of                                              BCMOLT_DEVICE_DEVICE_KEEP_ALIVE_ID__NUM_OF
#define bcmolt_device_device_ready_id_firmware_sw_version                                       BCMOLT_DEVICE_DEVICE_READY_ID_FIRMWARE_SW_VERSION
#define bcmolt_device_device_ready_id_system_mode                                               BCMOLT_DEVICE_DEVICE_READY_ID_SYSTEM_MODE
#define bcmolt_device_device_ready_id_nni_speed                                                 BCMOLT_DEVICE_DEVICE_READY_ID_NNI_SPEED
#define bcmolt_device_device_ready_id_chip_revision                                             BCMOLT_DEVICE_DEVICE_READY_ID_CHIP_REVISION
#define bcmolt_device_device_ready_id_tod_enable                                                BCMOLT_DEVICE_DEVICE_READY_ID_TOD_ENABLE
#define bcmolt_device_device_ready_id_tod_gpio_pin                                              BCMOLT_DEVICE_DEVICE_READY_ID_TOD_GPIO_PIN
#define bcmolt_device_device_ready_id__num_of                                                   BCMOLT_DEVICE_DEVICE_READY_ID__NUM_OF
#define bcmolt_device_disconnection_complete_id__num_of                                         BCMOLT_DEVICE_DISCONNECTION_COMPLETE_ID__NUM_OF
#define bcmolt_device_image_transfer_complete_id_image_type                                     BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID_IMAGE_TYPE
#define bcmolt_device_image_transfer_complete_id_block_number                                   BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID_BLOCK_NUMBER
#define bcmolt_device_image_transfer_complete_id_status                                         BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID_STATUS
#define bcmolt_device_image_transfer_complete_id__num_of                                        BCMOLT_DEVICE_IMAGE_TRANSFER_COMPLETE_ID__NUM_OF
#define bcmolt_device_indications_dropped_id_total_count                                        BCMOLT_DEVICE_INDICATIONS_DROPPED_ID_TOTAL_COUNT
#define bcmolt_device_indications_dropped_id__num_of                                            BCMOLT_DEVICE_INDICATIONS_DROPPED_ID__NUM_OF
#define bcmolt_device_sw_error_id_task_name                                                     BCMOLT_DEVICE_SW_ERROR_ID_TASK_NAME
#define bcmolt_device_sw_error_id_file_name                                                     BCMOLT_DEVICE_SW_ERROR_ID_FILE_NAME
#define bcmolt_device_sw_error_id_line_number                                                   BCMOLT_DEVICE_SW_ERROR_ID_LINE_NUMBER
#define bcmolt_device_sw_error_id_pon_ni                                                        BCMOLT_DEVICE_SW_ERROR_ID_PON_NI
#define bcmolt_device_sw_error_id__num_of                                                       BCMOLT_DEVICE_SW_ERROR_ID__NUM_OF
#define bcmolt_device_sw_exception_id_cpu_id                                                    BCMOLT_DEVICE_SW_EXCEPTION_ID_CPU_ID
#define bcmolt_device_sw_exception_id_text                                                      BCMOLT_DEVICE_SW_EXCEPTION_ID_TEXT
#define bcmolt_device_sw_exception_id__num_of                                                   BCMOLT_DEVICE_SW_EXCEPTION_ID__NUM_OF
#define bcmolt_device_auto_cfg_id_connection_complete                                           BCMOLT_DEVICE_AUTO_CFG_ID_CONNECTION_COMPLETE
#define bcmolt_device_auto_cfg_id_connection_established                                        BCMOLT_DEVICE_AUTO_CFG_ID_CONNECTION_ESTABLISHED
#define bcmolt_device_auto_cfg_id_connection_failure                                            BCMOLT_DEVICE_AUTO_CFG_ID_CONNECTION_FAILURE
#define bcmolt_device_auto_cfg_id_ddr_test_complete                                             BCMOLT_DEVICE_AUTO_CFG_ID_DDR_TEST_COMPLETE
#define bcmolt_device_auto_cfg_id_device_keep_alive                                             BCMOLT_DEVICE_AUTO_CFG_ID_DEVICE_KEEP_ALIVE
#define bcmolt_device_auto_cfg_id_device_ready                                                  BCMOLT_DEVICE_AUTO_CFG_ID_DEVICE_READY
#define bcmolt_device_auto_cfg_id_disconnection_complete                                        BCMOLT_DEVICE_AUTO_CFG_ID_DISCONNECTION_COMPLETE
#define bcmolt_device_auto_cfg_id_image_transfer_complete                                       BCMOLT_DEVICE_AUTO_CFG_ID_IMAGE_TRANSFER_COMPLETE
#define bcmolt_device_auto_cfg_id_indications_dropped                                           BCMOLT_DEVICE_AUTO_CFG_ID_INDICATIONS_DROPPED
#define bcmolt_device_auto_cfg_id_sw_error                                                      BCMOLT_DEVICE_AUTO_CFG_ID_SW_ERROR
#define bcmolt_device_auto_cfg_id_sw_exception                                                  BCMOLT_DEVICE_AUTO_CFG_ID_SW_EXCEPTION
#define bcmolt_device_auto_cfg_id__num_of                                                       BCMOLT_DEVICE_AUTO_CFG_ID__NUM_OF
#define bcmolt_device_connect_id__num_of                                                        BCMOLT_DEVICE_CONNECT_ID__NUM_OF
#define bcmolt_device_disconnect_id__num_of                                                     BCMOLT_DEVICE_DISCONNECT_ID__NUM_OF
#define bcmolt_device_host_keep_alive_id_sequence_number                                        BCMOLT_DEVICE_HOST_KEEP_ALIVE_ID_SEQUENCE_NUMBER
#define bcmolt_device_host_keep_alive_id_time_stamp                                             BCMOLT_DEVICE_HOST_KEEP_ALIVE_ID_TIME_STAMP
#define bcmolt_device_host_keep_alive_id__num_of                                                BCMOLT_DEVICE_HOST_KEEP_ALIVE_ID__NUM_OF
#define bcmolt_device_image_transfer_data_id_block_number                                       BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID_BLOCK_NUMBER
#define bcmolt_device_image_transfer_data_id_more_data                                          BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID_MORE_DATA
#define bcmolt_device_image_transfer_data_id_data                                               BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID_DATA
#define bcmolt_device_image_transfer_data_id__num_of                                            BCMOLT_DEVICE_IMAGE_TRANSFER_DATA_ID__NUM_OF
#define bcmolt_device_image_transfer_start_id_image_type                                        BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID_IMAGE_TYPE
#define bcmolt_device_image_transfer_start_id_image_size                                        BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID_IMAGE_SIZE
#define bcmolt_device_image_transfer_start_id_crc32                                             BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID_CRC32
#define bcmolt_device_image_transfer_start_id_image_name                                        BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID_IMAGE_NAME
#define bcmolt_device_image_transfer_start_id__num_of                                           BCMOLT_DEVICE_IMAGE_TRANSFER_START_ID__NUM_OF
#define bcmolt_device_reset_id_mode                                                             BCMOLT_DEVICE_RESET_ID_MODE
#define bcmolt_device_reset_id__num_of                                                          BCMOLT_DEVICE_RESET_ID__NUM_OF
#define bcmolt_device_run_ddr_test_id_cpu                                                       BCMOLT_DEVICE_RUN_DDR_TEST_ID_CPU
#define bcmolt_device_run_ddr_test_id_ras_0                                                     BCMOLT_DEVICE_RUN_DDR_TEST_ID_RAS_0
#define bcmolt_device_run_ddr_test_id_ras_1                                                     BCMOLT_DEVICE_RUN_DDR_TEST_ID_RAS_1
#define bcmolt_device_run_ddr_test_id__num_of                                                   BCMOLT_DEVICE_RUN_DDR_TEST_ID__NUM_OF
#define bcmolt_device_sw_upgrade_activate_id__num_of                                            BCMOLT_DEVICE_SW_UPGRADE_ACTIVATE_ID__NUM_OF
#define bcmolt_epon_denied_link_key_id_epon_ni                                                  BCMOLT_EPON_DENIED_LINK_KEY_ID_EPON_NI
#define bcmolt_epon_denied_link_key_id_mac_address                                              BCMOLT_EPON_DENIED_LINK_KEY_ID_MAC_ADDRESS
#define bcmolt_epon_denied_link_key_id__num_of                                                  BCMOLT_EPON_DENIED_LINK_KEY_ID__NUM_OF
#define bcmolt_epon_denied_link_cfg_id_alarm_state                                              BCMOLT_EPON_DENIED_LINK_CFG_ID_ALARM_STATE
#define bcmolt_epon_denied_link_cfg_id__num_of                                                  BCMOLT_EPON_DENIED_LINK_CFG_ID__NUM_OF
#define bcmolt_epon_denied_link_laser_on_off_violation_id_alarm_status                          BCMOLT_EPON_DENIED_LINK_LASER_ON_OFF_VIOLATION_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_laser_on_off_violation_id__num_of                               BCMOLT_EPON_DENIED_LINK_LASER_ON_OFF_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_llid_pool_empty_violation_id_alarm_status                       BCMOLT_EPON_DENIED_LINK_LLID_POOL_EMPTY_VIOLATION_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_llid_pool_empty_violation_id__num_of                            BCMOLT_EPON_DENIED_LINK_LLID_POOL_EMPTY_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_max_link_violation_id_alarm_status                              BCMOLT_EPON_DENIED_LINK_MAX_LINK_VIOLATION_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_max_link_violation_id__num_of                                   BCMOLT_EPON_DENIED_LINK_MAX_LINK_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_overhead_profile_violation_id_alarm_status                      BCMOLT_EPON_DENIED_LINK_OVERHEAD_PROFILE_VIOLATION_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_overhead_profile_violation_id__num_of                           BCMOLT_EPON_DENIED_LINK_OVERHEAD_PROFILE_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_range_violation_id_alarm_status                                 BCMOLT_EPON_DENIED_LINK_RANGE_VIOLATION_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_range_violation_id__num_of                                      BCMOLT_EPON_DENIED_LINK_RANGE_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_rogue_violation_id_alarm_status                                 BCMOLT_EPON_DENIED_LINK_ROGUE_VIOLATION_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_rogue_violation_id__num_of                                      BCMOLT_EPON_DENIED_LINK_ROGUE_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_system_resource_violation_id_alarm_status                       BCMOLT_EPON_DENIED_LINK_SYSTEM_RESOURCE_VIOLATION_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_system_resource_violation_id__num_of                            BCMOLT_EPON_DENIED_LINK_SYSTEM_RESOURCE_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_tdm_channels_exhausted_id_alarm_status                          BCMOLT_EPON_DENIED_LINK_TDM_CHANNELS_EXHAUSTED_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_tdm_channels_exhausted_id__num_of                               BCMOLT_EPON_DENIED_LINK_TDM_CHANNELS_EXHAUSTED_ID__NUM_OF
#define bcmolt_epon_denied_link_unknown_link_violation_id_alarm_status                          BCMOLT_EPON_DENIED_LINK_UNKNOWN_LINK_VIOLATION_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_unknown_link_violation_id__num_of                               BCMOLT_EPON_DENIED_LINK_UNKNOWN_LINK_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_upstream_bandwidth_violation_id_alarm_status                    BCMOLT_EPON_DENIED_LINK_UPSTREAM_BANDWIDTH_VIOLATION_ID_ALARM_STATUS
#define bcmolt_epon_denied_link_upstream_bandwidth_violation_id__num_of                         BCMOLT_EPON_DENIED_LINK_UPSTREAM_BANDWIDTH_VIOLATION_ID__NUM_OF
#define bcmolt_epon_denied_link_auto_cfg_id_laser_on_off_violation                              BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_LASER_ON_OFF_VIOLATION
#define bcmolt_epon_denied_link_auto_cfg_id_llid_pool_empty_violation                           BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_LLID_POOL_EMPTY_VIOLATION
#define bcmolt_epon_denied_link_auto_cfg_id_max_link_violation                                  BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_MAX_LINK_VIOLATION
#define bcmolt_epon_denied_link_auto_cfg_id_overhead_profile_violation                          BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_OVERHEAD_PROFILE_VIOLATION
#define bcmolt_epon_denied_link_auto_cfg_id_range_violation                                     BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_RANGE_VIOLATION
#define bcmolt_epon_denied_link_auto_cfg_id_rogue_violation                                     BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_ROGUE_VIOLATION
#define bcmolt_epon_denied_link_auto_cfg_id_system_resource_violation                           BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_SYSTEM_RESOURCE_VIOLATION
#define bcmolt_epon_denied_link_auto_cfg_id_tdm_channels_exhausted                              BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_TDM_CHANNELS_EXHAUSTED
#define bcmolt_epon_denied_link_auto_cfg_id_unknown_link_violation                              BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_UNKNOWN_LINK_VIOLATION
#define bcmolt_epon_denied_link_auto_cfg_id_upstream_bandwidth_violation                        BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID_UPSTREAM_BANDWIDTH_VIOLATION
#define bcmolt_epon_denied_link_auto_cfg_id__num_of                                             BCMOLT_EPON_DENIED_LINK_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_link_key_id_epon_ni                                                         BCMOLT_EPON_LINK_KEY_ID_EPON_NI
#define bcmolt_epon_link_key_id_mac_address                                                     BCMOLT_EPON_LINK_KEY_ID_MAC_ADDRESS
#define bcmolt_epon_link_key_id__num_of                                                         BCMOLT_EPON_LINK_KEY_ID__NUM_OF
#define bcmolt_epon_link_cfg_id_link_rate                                                       BCMOLT_EPON_LINK_CFG_ID_LINK_RATE
#define bcmolt_epon_link_cfg_id_state_flags                                                     BCMOLT_EPON_LINK_CFG_ID_STATE_FLAGS
#define bcmolt_epon_link_cfg_id_llid                                                            BCMOLT_EPON_LINK_CFG_ID_LLID
#define bcmolt_epon_link_cfg_id_laser_on_time_tq                                                BCMOLT_EPON_LINK_CFG_ID_LASER_ON_TIME_TQ
#define bcmolt_epon_link_cfg_id_laser_off_time_tq                                               BCMOLT_EPON_LINK_CFG_ID_LASER_OFF_TIME_TQ
#define bcmolt_epon_link_cfg_id_range_value_tq                                                  BCMOLT_EPON_LINK_CFG_ID_RANGE_VALUE_TQ
#define bcmolt_epon_link_cfg_id_distance                                                        BCMOLT_EPON_LINK_CFG_ID_DISTANCE
#define bcmolt_epon_link_cfg_id_alarm_state                                                     BCMOLT_EPON_LINK_CFG_ID_ALARM_STATE
#define bcmolt_epon_link_cfg_id_tunnel_id                                                       BCMOLT_EPON_LINK_CFG_ID_TUNNEL_ID
#define bcmolt_epon_link_cfg_id_onu_id                                                          BCMOLT_EPON_LINK_CFG_ID_ONU_ID
#define bcmolt_epon_link_cfg_id_min_laser_overhead                                              BCMOLT_EPON_LINK_CFG_ID_MIN_LASER_OVERHEAD
#define bcmolt_epon_link_cfg_id_key_exchange_config                                             BCMOLT_EPON_LINK_CFG_ID_KEY_EXCHANGE_CONFIG
#define bcmolt_epon_link_cfg_id_epon_encryption                                                 BCMOLT_EPON_LINK_CFG_ID_EPON_ENCRYPTION
#define bcmolt_epon_link_cfg_id_fec_enable                                                      BCMOLT_EPON_LINK_CFG_ID_FEC_ENABLE
#define bcmolt_epon_link_cfg_id_oam_heartbeat_config                                            BCMOLT_EPON_LINK_CFG_ID_OAM_HEARTBEAT_CONFIG
#define bcmolt_epon_link_cfg_id_upstream_bandwidth                                              BCMOLT_EPON_LINK_CFG_ID_UPSTREAM_BANDWIDTH
#define bcmolt_epon_link_cfg_id_ubd_info                                                        BCMOLT_EPON_LINK_CFG_ID_UBD_INFO
#define bcmolt_epon_link_cfg_id_clock_transport_enable                                          BCMOLT_EPON_LINK_CFG_ID_CLOCK_TRANSPORT_ENABLE
#define bcmolt_epon_link_cfg_id_pending_grants                                                  BCMOLT_EPON_LINK_CFG_ID_PENDING_GRANTS
#define bcmolt_epon_link_cfg_id_link_type                                                       BCMOLT_EPON_LINK_CFG_ID_LINK_TYPE
#define bcmolt_epon_link_cfg_id__num_of                                                         BCMOLT_EPON_LINK_CFG_ID__NUM_OF
#define bcmolt_epon_link_stat_id_rx_data_bytes                                                  BCMOLT_EPON_LINK_STAT_ID_RX_DATA_BYTES
#define bcmolt_epon_link_stat_id_rx_data_frames                                                 BCMOLT_EPON_LINK_STAT_ID_RX_DATA_FRAMES
#define bcmolt_epon_link_stat_id_rx_frames_64                                                   BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_64
#define bcmolt_epon_link_stat_id_rx_frames_65_127                                               BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_65_127
#define bcmolt_epon_link_stat_id_rx_frames_128_255                                              BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_128_255
#define bcmolt_epon_link_stat_id_rx_frames_256_511                                              BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_256_511
#define bcmolt_epon_link_stat_id_rx_frames_512_1023                                             BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_512_1023
#define bcmolt_epon_link_stat_id_rx_frames_1024_1518                                            BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_1024_1518
#define bcmolt_epon_link_stat_id_rx_frames_1519_2047                                            BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_1519_2047
#define bcmolt_epon_link_stat_id_rx_frames_2048_4095                                            BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_2048_4095
#define bcmolt_epon_link_stat_id_rx_frames_4096_9216                                            BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_4096_9216
#define bcmolt_epon_link_stat_id_rx_frames_9217_16383                                           BCMOLT_EPON_LINK_STAT_ID_RX_FRAMES_9217_16383
#define bcmolt_epon_link_stat_id_rx_oam_bytes                                                   BCMOLT_EPON_LINK_STAT_ID_RX_OAM_BYTES
#define bcmolt_epon_link_stat_id_rx_oam_frames                                                  BCMOLT_EPON_LINK_STAT_ID_RX_OAM_FRAMES
#define bcmolt_epon_link_stat_id_rx_mpcp_frames                                                 BCMOLT_EPON_LINK_STAT_ID_RX_MPCP_FRAMES
#define bcmolt_epon_link_stat_id_rx_broadcast_frames                                            BCMOLT_EPON_LINK_STAT_ID_RX_BROADCAST_FRAMES
#define bcmolt_epon_link_stat_id_rx_unicast_frames                                              BCMOLT_EPON_LINK_STAT_ID_RX_UNICAST_FRAMES
#define bcmolt_epon_link_stat_id_rx_multicast_frames                                            BCMOLT_EPON_LINK_STAT_ID_RX_MULTICAST_FRAMES
#define bcmolt_epon_link_stat_id_rx_report_frames                                               BCMOLT_EPON_LINK_STAT_ID_RX_REPORT_FRAMES
#define bcmolt_epon_link_stat_id_rx_fcs_error                                                   BCMOLT_EPON_LINK_STAT_ID_RX_FCS_ERROR
#define bcmolt_epon_link_stat_id_rx_oversize_error                                              BCMOLT_EPON_LINK_STAT_ID_RX_OVERSIZE_ERROR
#define bcmolt_epon_link_stat_id_rx_runt_error                                                  BCMOLT_EPON_LINK_STAT_ID_RX_RUNT_ERROR
#define bcmolt_epon_link_stat_id_rx_line_code_error                                             BCMOLT_EPON_LINK_STAT_ID_RX_LINE_CODE_ERROR
#define bcmolt_epon_link_stat_id_rx_line_code_error_max                                         BCMOLT_EPON_LINK_STAT_ID_RX_LINE_CODE_ERROR_MAX
#define bcmolt_epon_link_stat_id_tx_data_bytes                                                  BCMOLT_EPON_LINK_STAT_ID_TX_DATA_BYTES
#define bcmolt_epon_link_stat_id_tx_data_frames                                                 BCMOLT_EPON_LINK_STAT_ID_TX_DATA_FRAMES
#define bcmolt_epon_link_stat_id_tx_frames_64                                                   BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_64
#define bcmolt_epon_link_stat_id_tx_frames_65_127                                               BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_65_127
#define bcmolt_epon_link_stat_id_tx_frames_128_255                                              BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_128_255
#define bcmolt_epon_link_stat_id_tx_frames_256_511                                              BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_256_511
#define bcmolt_epon_link_stat_id_tx_frames_512_1023                                             BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_512_1023
#define bcmolt_epon_link_stat_id_tx_frames_1024_1518                                            BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_1024_1518
#define bcmolt_epon_link_stat_id_tx_frames_1519_2047                                            BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_1519_2047
#define bcmolt_epon_link_stat_id_tx_frames_2048_4095                                            BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_2048_4095
#define bcmolt_epon_link_stat_id_tx_frames_4096_9216                                            BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_4096_9216
#define bcmolt_epon_link_stat_id_tx_frames_9217_16383                                           BCMOLT_EPON_LINK_STAT_ID_TX_FRAMES_9217_16383
#define bcmolt_epon_link_stat_id_tx_oam_bytes                                                   BCMOLT_EPON_LINK_STAT_ID_TX_OAM_BYTES
#define bcmolt_epon_link_stat_id_tx_oam_frames                                                  BCMOLT_EPON_LINK_STAT_ID_TX_OAM_FRAMES
#define bcmolt_epon_link_stat_id_tx_mpcp_frames                                                 BCMOLT_EPON_LINK_STAT_ID_TX_MPCP_FRAMES
#define bcmolt_epon_link_stat_id_tx_broadcast_frames                                            BCMOLT_EPON_LINK_STAT_ID_TX_BROADCAST_FRAMES
#define bcmolt_epon_link_stat_id_tx_unicast_frames                                              BCMOLT_EPON_LINK_STAT_ID_TX_UNICAST_FRAMES
#define bcmolt_epon_link_stat_id_tx_multicast_frames                                            BCMOLT_EPON_LINK_STAT_ID_TX_MULTICAST_FRAMES
#define bcmolt_epon_link_stat_id_tx_gates                                                       BCMOLT_EPON_LINK_STAT_ID_TX_GATES
#define bcmolt_epon_link_stat_id__num_of                                                        BCMOLT_EPON_LINK_STAT_ID__NUM_OF
#define bcmolt_epon_link_stat_cfg_id_cfg                                                        BCMOLT_EPON_LINK_STAT_CFG_ID_CFG
#define bcmolt_epon_link_stat_cfg_id__num_of                                                    BCMOLT_EPON_LINK_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_link_duplicate_mpcp_registration_request_id_initial_range_tq                BCMOLT_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST_ID_INITIAL_RANGE_TQ
#define bcmolt_epon_link_duplicate_mpcp_registration_request_id_current_range_tq                BCMOLT_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST_ID_CURRENT_RANGE_TQ
#define bcmolt_epon_link_duplicate_mpcp_registration_request_id__num_of                         BCMOLT_EPON_LINK_DUPLICATE_MPCP_REGISTRATION_REQUEST_ID__NUM_OF
#define bcmolt_epon_link_encryption_enabled_id__num_of                                          BCMOLT_EPON_LINK_ENCRYPTION_ENABLED_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_failure_id_alarm_status                                   BCMOLT_EPON_LINK_KEY_EXCHANGE_FAILURE_ID_ALARM_STATUS
#define bcmolt_epon_link_key_exchange_failure_id__num_of                                        BCMOLT_EPON_LINK_KEY_EXCHANGE_FAILURE_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_started_id__num_of                                        BCMOLT_EPON_LINK_KEY_EXCHANGE_STARTED_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_stopped_id__num_of                                        BCMOLT_EPON_LINK_KEY_EXCHANGE_STOPPED_ID__NUM_OF
#define bcmolt_epon_link_link_deleted_id__num_of                                                BCMOLT_EPON_LINK_LINK_DELETED_ID__NUM_OF
#define bcmolt_epon_link_link_speed_mismatch_id_previous_rate                                   BCMOLT_EPON_LINK_LINK_SPEED_MISMATCH_ID_PREVIOUS_RATE
#define bcmolt_epon_link_link_speed_mismatch_id_current_rate                                    BCMOLT_EPON_LINK_LINK_SPEED_MISMATCH_ID_CURRENT_RATE
#define bcmolt_epon_link_link_speed_mismatch_id__num_of                                         BCMOLT_EPON_LINK_LINK_SPEED_MISMATCH_ID__NUM_OF
#define bcmolt_epon_link_mpcp_deregistered_id__num_of                                           BCMOLT_EPON_LINK_MPCP_DEREGISTERED_ID__NUM_OF
#define bcmolt_epon_link_mpcp_discovered_id_link_info                                           BCMOLT_EPON_LINK_MPCP_DISCOVERED_ID_LINK_INFO
#define bcmolt_epon_link_mpcp_discovered_id__num_of                                             BCMOLT_EPON_LINK_MPCP_DISCOVERED_ID__NUM_OF
#define bcmolt_epon_link_mpcp_reg_ack_timeout_id__num_of                                        BCMOLT_EPON_LINK_MPCP_REG_ACK_TIMEOUT_ID__NUM_OF
#define bcmolt_epon_link_mpcp_report_timeout_id_alarm_status                                    BCMOLT_EPON_LINK_MPCP_REPORT_TIMEOUT_ID_ALARM_STATUS
#define bcmolt_epon_link_mpcp_report_timeout_id__num_of                                         BCMOLT_EPON_LINK_MPCP_REPORT_TIMEOUT_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timeout_id_alarm_status                                  BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMEOUT_ID_ALARM_STATUS
#define bcmolt_epon_link_oam_keepalive_timeout_id__num_of                                       BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMEOUT_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timer_started_id__num_of                                 BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_STARTED_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timer_stopped_id__num_of                                 BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_STOPPED_ID__NUM_OF
#define bcmolt_epon_link_preprovisioned_link_created_id_link_info                               BCMOLT_EPON_LINK_PREPROVISIONED_LINK_CREATED_ID_LINK_INFO
#define bcmolt_epon_link_preprovisioned_link_created_id__num_of                                 BCMOLT_EPON_LINK_PREPROVISIONED_LINK_CREATED_ID__NUM_OF
#define bcmolt_epon_link_protection_switch_occurred_id_protection_status                        BCMOLT_EPON_LINK_PROTECTION_SWITCH_OCCURRED_ID_PROTECTION_STATUS
#define bcmolt_epon_link_protection_switch_occurred_id_range_value_tq                           BCMOLT_EPON_LINK_PROTECTION_SWITCH_OCCURRED_ID_RANGE_VALUE_TQ
#define bcmolt_epon_link_protection_switch_occurred_id__num_of                                  BCMOLT_EPON_LINK_PROTECTION_SWITCH_OCCURRED_ID__NUM_OF
#define bcmolt_epon_link_range_value_changed_id_range_value_tq                                  BCMOLT_EPON_LINK_RANGE_VALUE_CHANGED_ID_RANGE_VALUE_TQ
#define bcmolt_epon_link_range_value_changed_id__num_of                                         BCMOLT_EPON_LINK_RANGE_VALUE_CHANGED_ID__NUM_OF
#define bcmolt_epon_link_rerange_failure_id__num_of                                             BCMOLT_EPON_LINK_RERANGE_FAILURE_ID__NUM_OF
#define bcmolt_epon_link_stat_alarm_cleared_id_stat                                             BCMOLT_EPON_LINK_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_epon_link_stat_alarm_cleared_id__num_of                                          BCMOLT_EPON_LINK_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_link_stat_alarm_raised_id_stat                                              BCMOLT_EPON_LINK_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_epon_link_stat_alarm_raised_id__num_of                                           BCMOLT_EPON_LINK_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_link_static_registration_done_id__num_of                                    BCMOLT_EPON_LINK_STATIC_REGISTRATION_DONE_ID__NUM_OF
#define bcmolt_epon_link_auto_cfg_id_duplicate_mpcp_registration_request                        BCMOLT_EPON_LINK_AUTO_CFG_ID_DUPLICATE_MPCP_REGISTRATION_REQUEST
#define bcmolt_epon_link_auto_cfg_id_encryption_enabled                                         BCMOLT_EPON_LINK_AUTO_CFG_ID_ENCRYPTION_ENABLED
#define bcmolt_epon_link_auto_cfg_id_key_exchange_failure                                       BCMOLT_EPON_LINK_AUTO_CFG_ID_KEY_EXCHANGE_FAILURE
#define bcmolt_epon_link_auto_cfg_id_key_exchange_started                                       BCMOLT_EPON_LINK_AUTO_CFG_ID_KEY_EXCHANGE_STARTED
#define bcmolt_epon_link_auto_cfg_id_key_exchange_stopped                                       BCMOLT_EPON_LINK_AUTO_CFG_ID_KEY_EXCHANGE_STOPPED
#define bcmolt_epon_link_auto_cfg_id_link_deleted                                               BCMOLT_EPON_LINK_AUTO_CFG_ID_LINK_DELETED
#define bcmolt_epon_link_auto_cfg_id_link_speed_mismatch                                        BCMOLT_EPON_LINK_AUTO_CFG_ID_LINK_SPEED_MISMATCH
#define bcmolt_epon_link_auto_cfg_id_mpcp_deregistered                                          BCMOLT_EPON_LINK_AUTO_CFG_ID_MPCP_DEREGISTERED
#define bcmolt_epon_link_auto_cfg_id_mpcp_discovered                                            BCMOLT_EPON_LINK_AUTO_CFG_ID_MPCP_DISCOVERED
#define bcmolt_epon_link_auto_cfg_id_mpcp_reg_ack_timeout                                       BCMOLT_EPON_LINK_AUTO_CFG_ID_MPCP_REG_ACK_TIMEOUT
#define bcmolt_epon_link_auto_cfg_id_mpcp_report_timeout                                        BCMOLT_EPON_LINK_AUTO_CFG_ID_MPCP_REPORT_TIMEOUT
#define bcmolt_epon_link_auto_cfg_id_oam_keepalive_timeout                                      BCMOLT_EPON_LINK_AUTO_CFG_ID_OAM_KEEPALIVE_TIMEOUT
#define bcmolt_epon_link_auto_cfg_id_oam_keepalive_timer_started                                BCMOLT_EPON_LINK_AUTO_CFG_ID_OAM_KEEPALIVE_TIMER_STARTED
#define bcmolt_epon_link_auto_cfg_id_oam_keepalive_timer_stopped                                BCMOLT_EPON_LINK_AUTO_CFG_ID_OAM_KEEPALIVE_TIMER_STOPPED
#define bcmolt_epon_link_auto_cfg_id_preprovisioned_link_created                                BCMOLT_EPON_LINK_AUTO_CFG_ID_PREPROVISIONED_LINK_CREATED
#define bcmolt_epon_link_auto_cfg_id_protection_switch_occurred                                 BCMOLT_EPON_LINK_AUTO_CFG_ID_PROTECTION_SWITCH_OCCURRED
#define bcmolt_epon_link_auto_cfg_id_range_value_changed                                        BCMOLT_EPON_LINK_AUTO_CFG_ID_RANGE_VALUE_CHANGED
#define bcmolt_epon_link_auto_cfg_id_rerange_failure                                            BCMOLT_EPON_LINK_AUTO_CFG_ID_RERANGE_FAILURE
#define bcmolt_epon_link_auto_cfg_id_stat_alarm_cleared                                         BCMOLT_EPON_LINK_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_link_auto_cfg_id_stat_alarm_raised                                          BCMOLT_EPON_LINK_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_epon_link_auto_cfg_id_static_registration_done                                   BCMOLT_EPON_LINK_AUTO_CFG_ID_STATIC_REGISTRATION_DONE
#define bcmolt_epon_link_auto_cfg_id__num_of                                                    BCMOLT_EPON_LINK_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_link_delete_link_id__num_of                                                 BCMOLT_EPON_LINK_DELETE_LINK_ID__NUM_OF
#define bcmolt_epon_link_force_rediscovery_id__num_of                                           BCMOLT_EPON_LINK_FORCE_REDISCOVERY_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_start_id_period                                           BCMOLT_EPON_LINK_KEY_EXCHANGE_START_ID_PERIOD
#define bcmolt_epon_link_key_exchange_start_id__num_of                                          BCMOLT_EPON_LINK_KEY_EXCHANGE_START_ID__NUM_OF
#define bcmolt_epon_link_key_exchange_stop_id__num_of                                           BCMOLT_EPON_LINK_KEY_EXCHANGE_STOP_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timer_start_id_send_period                               BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_START_ID_SEND_PERIOD
#define bcmolt_epon_link_oam_keepalive_timer_start_id__num_of                                   BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_START_ID__NUM_OF
#define bcmolt_epon_link_oam_keepalive_timer_stop_id__num_of                                    BCMOLT_EPON_LINK_OAM_KEEPALIVE_TIMER_STOP_ID__NUM_OF
#define bcmolt_epon_link_static_registration_id_laseron_time_tq                                 BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID_LASERON_TIME_TQ
#define bcmolt_epon_link_static_registration_id_laseroff_time_tq                                BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID_LASEROFF_TIME_TQ
#define bcmolt_epon_link_static_registration_id_range_value_tq                                  BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID_RANGE_VALUE_TQ
#define bcmolt_epon_link_static_registration_id_pending_grants                                  BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID_PENDING_GRANTS
#define bcmolt_epon_link_static_registration_id__num_of                                         BCMOLT_EPON_LINK_STATIC_REGISTRATION_ID__NUM_OF
#define bcmolt_epon_link_inject_frame_id_frame                                                  BCMOLT_EPON_LINK_INJECT_FRAME_ID_FRAME
#define bcmolt_epon_link_inject_frame_id__num_of                                                BCMOLT_EPON_LINK_INJECT_FRAME_ID__NUM_OF
#define bcmolt_epon_link_frame_captured_id_frame                                                BCMOLT_EPON_LINK_FRAME_CAPTURED_ID_FRAME
#define bcmolt_epon_link_frame_captured_id__num_of                                              BCMOLT_EPON_LINK_FRAME_CAPTURED_ID__NUM_OF
#define bcmolt_epon_ni_key_id_epon_ni                                                           BCMOLT_EPON_NI_KEY_ID_EPON_NI
#define bcmolt_epon_ni_key_id__num_of                                                           BCMOLT_EPON_NI_KEY_ID__NUM_OF
#define bcmolt_epon_ni_cfg_id_mac_address                                                       BCMOLT_EPON_NI_CFG_ID_MAC_ADDRESS
#define bcmolt_epon_ni_cfg_id_epon_ni_en                                                        BCMOLT_EPON_NI_CFG_ID_EPON_NI_EN
#define bcmolt_epon_ni_cfg_id_registration_behavior                                             BCMOLT_EPON_NI_CFG_ID_REGISTRATION_BEHAVIOR
#define bcmolt_epon_ni_cfg_id_mtu_1g                                                            BCMOLT_EPON_NI_CFG_ID_MTU_1G
#define bcmolt_epon_ni_cfg_id_mtu_10g                                                           BCMOLT_EPON_NI_CFG_ID_MTU_10G
#define bcmolt_epon_ni_cfg_id_minimum_fiber_length                                              BCMOLT_EPON_NI_CFG_ID_MINIMUM_FIBER_LENGTH
#define bcmolt_epon_ni_cfg_id_maximum_fiber_length                                              BCMOLT_EPON_NI_CFG_ID_MAXIMUM_FIBER_LENGTH
#define bcmolt_epon_ni_cfg_id_grant_spacing_tq                                                  BCMOLT_EPON_NI_CFG_ID_GRANT_SPACING_TQ
#define bcmolt_epon_ni_cfg_id_epon_logical_link_options                                         BCMOLT_EPON_NI_CFG_ID_EPON_LOGICAL_LINK_OPTIONS
#define bcmolt_epon_ni_cfg_id_mpcp_discovery_period_ms                                          BCMOLT_EPON_NI_CFG_ID_MPCP_DISCOVERY_PERIOD_MS
#define bcmolt_epon_ni_cfg_id_alarm_state                                                       BCMOLT_EPON_NI_CFG_ID_ALARM_STATE
#define bcmolt_epon_ni_cfg_id_all_links                                                         BCMOLT_EPON_NI_CFG_ID_ALL_LINKS
#define bcmolt_epon_ni_cfg_id_encryption_cfg                                                    BCMOLT_EPON_NI_CFG_ID_ENCRYPTION_CFG
#define bcmolt_epon_ni_cfg_id_protection_switching_cfg                                          BCMOLT_EPON_NI_CFG_ID_PROTECTION_SWITCHING_CFG
#define bcmolt_epon_ni_cfg_id_clock_transport_cfg                                               BCMOLT_EPON_NI_CFG_ID_CLOCK_TRANSPORT_CFG
#define bcmolt_epon_ni_cfg_id_dropdown_weights                                                  BCMOLT_EPON_NI_CFG_ID_DROPDOWN_WEIGHTS
#define bcmolt_epon_ni_cfg_id_approximate_solicited_usage                                       BCMOLT_EPON_NI_CFG_ID_APPROXIMATE_SOLICITED_USAGE
#define bcmolt_epon_ni_cfg_id_approximate_tdm_usage                                             BCMOLT_EPON_NI_CFG_ID_APPROXIMATE_TDM_USAGE
#define bcmolt_epon_ni_cfg_id_no_reports_soak_time                                              BCMOLT_EPON_NI_CFG_ID_NO_REPORTS_SOAK_TIME
#define bcmolt_epon_ni_cfg_id_pon_aggregate_shaper                                              BCMOLT_EPON_NI_CFG_ID_PON_AGGREGATE_SHAPER
#define bcmolt_epon_ni_cfg_id_estimated_pon_latency_tq                                          BCMOLT_EPON_NI_CFG_ID_ESTIMATED_PON_LATENCY_TQ
#define bcmolt_epon_ni_cfg_id_onu_upgrade_params                                                BCMOLT_EPON_NI_CFG_ID_ONU_UPGRADE_PARAMS
#define bcmolt_epon_ni_cfg_id_auto_rogue_detect_10g_en                                          BCMOLT_EPON_NI_CFG_ID_AUTO_ROGUE_DETECT_10G_EN
#define bcmolt_epon_ni_cfg_id_auto_rogue_detect_1g_en                                           BCMOLT_EPON_NI_CFG_ID_AUTO_ROGUE_DETECT_1G_EN
#define bcmolt_epon_ni_cfg_id_auto_rogue_detect_10g_threshold                                   BCMOLT_EPON_NI_CFG_ID_AUTO_ROGUE_DETECT_10G_THRESHOLD
#define bcmolt_epon_ni_cfg_id__num_of                                                           BCMOLT_EPON_NI_CFG_ID__NUM_OF
#define bcmolt_epon_ni_auto_rogue_scan_10g_failure_id__num_of                                   BCMOLT_EPON_NI_AUTO_ROGUE_SCAN_10G_FAILURE_ID__NUM_OF
#define bcmolt_epon_ni_auto_rogue_scan_1g_failure_id__num_of                                    BCMOLT_EPON_NI_AUTO_ROGUE_SCAN_1G_FAILURE_ID__NUM_OF
#define bcmolt_epon_ni_llid_quarantined_id_llid                                                 BCMOLT_EPON_NI_LLID_QUARANTINED_ID_LLID
#define bcmolt_epon_ni_llid_quarantined_id_link_rate                                            BCMOLT_EPON_NI_LLID_QUARANTINED_ID_LINK_RATE
#define bcmolt_epon_ni_llid_quarantined_id_link_mac                                             BCMOLT_EPON_NI_LLID_QUARANTINED_ID_LINK_MAC
#define bcmolt_epon_ni_llid_quarantined_id_range_value_tq                                       BCMOLT_EPON_NI_LLID_QUARANTINED_ID_RANGE_VALUE_TQ
#define bcmolt_epon_ni_llid_quarantined_id__num_of                                              BCMOLT_EPON_NI_LLID_QUARANTINED_ID__NUM_OF
#define bcmolt_epon_ni_mpcp_timestamp_changed_id_mpcp_timestamp                                 BCMOLT_EPON_NI_MPCP_TIMESTAMP_CHANGED_ID_MPCP_TIMESTAMP
#define bcmolt_epon_ni_mpcp_timestamp_changed_id__num_of                                        BCMOLT_EPON_NI_MPCP_TIMESTAMP_CHANGED_ID__NUM_OF
#define bcmolt_epon_ni_no_reports_id_alarm_status                                               BCMOLT_EPON_NI_NO_REPORTS_ID_ALARM_STATUS
#define bcmolt_epon_ni_no_reports_id__num_of                                                    BCMOLT_EPON_NI_NO_REPORTS_ID__NUM_OF
#define bcmolt_epon_ni_onu_upgrade_complete_id_status                                           BCMOLT_EPON_NI_ONU_UPGRADE_COMPLETE_ID_STATUS
#define bcmolt_epon_ni_onu_upgrade_complete_id_list_of_failed_entities                          BCMOLT_EPON_NI_ONU_UPGRADE_COMPLETE_ID_LIST_OF_FAILED_ENTITIES
#define bcmolt_epon_ni_onu_upgrade_complete_id__num_of                                          BCMOLT_EPON_NI_ONU_UPGRADE_COMPLETE_ID__NUM_OF
#define bcmolt_epon_ni_rerange_failure_id__num_of                                               BCMOLT_EPON_NI_RERANGE_FAILURE_ID__NUM_OF
#define bcmolt_epon_ni_rogue_scan_complete_id_return_ind_status                                 BCMOLT_EPON_NI_ROGUE_SCAN_COMPLETE_ID_RETURN_IND_STATUS
#define bcmolt_epon_ni_rogue_scan_complete_id__num_of                                           BCMOLT_EPON_NI_ROGUE_SCAN_COMPLETE_ID__NUM_OF
#define bcmolt_epon_ni_rssi_measurement_completed_id_status                                     BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID_STATUS
#define bcmolt_epon_ni_rssi_measurement_completed_id_llid                                       BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID_LLID
#define bcmolt_epon_ni_rssi_measurement_completed_id_link_mac                                   BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID_LINK_MAC
#define bcmolt_epon_ni_rssi_measurement_completed_id__num_of                                    BCMOLT_EPON_NI_RSSI_MEASUREMENT_COMPLETED_ID__NUM_OF
#define bcmolt_epon_ni_state_change_completed_id_new_state                                      BCMOLT_EPON_NI_STATE_CHANGE_COMPLETED_ID_NEW_STATE
#define bcmolt_epon_ni_state_change_completed_id__num_of                                        BCMOLT_EPON_NI_STATE_CHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_epon_ni_auto_cfg_id_auto_rogue_scan_10g_failure                                  BCMOLT_EPON_NI_AUTO_CFG_ID_AUTO_ROGUE_SCAN_10G_FAILURE
#define bcmolt_epon_ni_auto_cfg_id_auto_rogue_scan_1g_failure                                   BCMOLT_EPON_NI_AUTO_CFG_ID_AUTO_ROGUE_SCAN_1G_FAILURE
#define bcmolt_epon_ni_auto_cfg_id_llid_quarantined                                             BCMOLT_EPON_NI_AUTO_CFG_ID_LLID_QUARANTINED
#define bcmolt_epon_ni_auto_cfg_id_mpcp_timestamp_changed                                       BCMOLT_EPON_NI_AUTO_CFG_ID_MPCP_TIMESTAMP_CHANGED
#define bcmolt_epon_ni_auto_cfg_id_no_reports                                                   BCMOLT_EPON_NI_AUTO_CFG_ID_NO_REPORTS
#define bcmolt_epon_ni_auto_cfg_id_onu_upgrade_complete                                         BCMOLT_EPON_NI_AUTO_CFG_ID_ONU_UPGRADE_COMPLETE
#define bcmolt_epon_ni_auto_cfg_id_rerange_failure                                              BCMOLT_EPON_NI_AUTO_CFG_ID_RERANGE_FAILURE
#define bcmolt_epon_ni_auto_cfg_id_rogue_scan_complete                                          BCMOLT_EPON_NI_AUTO_CFG_ID_ROGUE_SCAN_COMPLETE
#define bcmolt_epon_ni_auto_cfg_id_rssi_measurement_completed                                   BCMOLT_EPON_NI_AUTO_CFG_ID_RSSI_MEASUREMENT_COMPLETED
#define bcmolt_epon_ni_auto_cfg_id_state_change_completed                                       BCMOLT_EPON_NI_AUTO_CFG_ID_STATE_CHANGE_COMPLETED
#define bcmolt_epon_ni_auto_cfg_id__num_of                                                      BCMOLT_EPON_NI_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_ni_add_link_id_mac_address                                                  BCMOLT_EPON_NI_ADD_LINK_ID_MAC_ADDRESS
#define bcmolt_epon_ni_add_link_id_rate                                                         BCMOLT_EPON_NI_ADD_LINK_ID_RATE
#define bcmolt_epon_ni_add_link_id__num_of                                                      BCMOLT_EPON_NI_ADD_LINK_ID__NUM_OF
#define bcmolt_epon_ni_add_multicast_link_id_mac_address                                        BCMOLT_EPON_NI_ADD_MULTICAST_LINK_ID_MAC_ADDRESS
#define bcmolt_epon_ni_add_multicast_link_id_rate                                               BCMOLT_EPON_NI_ADD_MULTICAST_LINK_ID_RATE
#define bcmolt_epon_ni_add_multicast_link_id__num_of                                            BCMOLT_EPON_NI_ADD_MULTICAST_LINK_ID__NUM_OF
#define bcmolt_epon_ni_add_protected_standby_link_id_mac_address                                BCMOLT_EPON_NI_ADD_PROTECTED_STANDBY_LINK_ID_MAC_ADDRESS
#define bcmolt_epon_ni_add_protected_standby_link_id_working_link_info                          BCMOLT_EPON_NI_ADD_PROTECTED_STANDBY_LINK_ID_WORKING_LINK_INFO
#define bcmolt_epon_ni_add_protected_standby_link_id__num_of                                    BCMOLT_EPON_NI_ADD_PROTECTED_STANDBY_LINK_ID__NUM_OF
#define bcmolt_epon_ni_issue_rssi_grant_id_granted_link                                         BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID_GRANTED_LINK
#define bcmolt_epon_ni_issue_rssi_grant_id_trigger_width                                        BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID_TRIGGER_WIDTH
#define bcmolt_epon_ni_issue_rssi_grant_id_trigger_delay                                        BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID_TRIGGER_DELAY
#define bcmolt_epon_ni_issue_rssi_grant_id_sample_period                                        BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID_SAMPLE_PERIOD
#define bcmolt_epon_ni_issue_rssi_grant_id__num_of                                              BCMOLT_EPON_NI_ISSUE_RSSI_GRANT_ID__NUM_OF
#define bcmolt_epon_ni_protection_switching_apply_rerange_delta_id_rerange_delta                BCMOLT_EPON_NI_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA_ID_RERANGE_DELTA
#define bcmolt_epon_ni_protection_switching_apply_rerange_delta_id__num_of                      BCMOLT_EPON_NI_PROTECTION_SWITCHING_APPLY_RERANGE_DELTA_ID__NUM_OF
#define bcmolt_epon_ni_rogue_llid_scan_id_mode                                                  BCMOLT_EPON_NI_ROGUE_LLID_SCAN_ID_MODE
#define bcmolt_epon_ni_rogue_llid_scan_id_llid                                                  BCMOLT_EPON_NI_ROGUE_LLID_SCAN_ID_LLID
#define bcmolt_epon_ni_rogue_llid_scan_id__num_of                                               BCMOLT_EPON_NI_ROGUE_LLID_SCAN_ID__NUM_OF
#define bcmolt_epon_ni_set_epon_ni_en_state_id_new_state                                        BCMOLT_EPON_NI_SET_EPON_NI_EN_STATE_ID_NEW_STATE
#define bcmolt_epon_ni_set_epon_ni_en_state_id__num_of                                          BCMOLT_EPON_NI_SET_EPON_NI_EN_STATE_ID__NUM_OF
#define bcmolt_epon_ni_start_onu_upgrade_id_list_of_onu_ids                                     BCMOLT_EPON_NI_START_ONU_UPGRADE_ID_LIST_OF_ONU_IDS
#define bcmolt_epon_ni_start_onu_upgrade_id__num_of                                             BCMOLT_EPON_NI_START_ONU_UPGRADE_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_key_id_epon_ni                                                   BCMOLT_EPON_ONU_10G_US_KEY_ID_EPON_NI
#define bcmolt_epon_onu_10g_us_key_id_onu_id                                                    BCMOLT_EPON_ONU_10G_US_KEY_ID_ONU_ID
#define bcmolt_epon_onu_10g_us_key_id__num_of                                                   BCMOLT_EPON_ONU_10G_US_KEY_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_cfg_id_all_links                                                 BCMOLT_EPON_ONU_10G_US_CFG_ID_ALL_LINKS
#define bcmolt_epon_onu_10g_us_cfg_id__num_of                                                   BCMOLT_EPON_ONU_10G_US_CFG_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_stat_id_fec_code_words_total                                     BCMOLT_EPON_ONU_10G_US_STAT_ID_FEC_CODE_WORDS_TOTAL
#define bcmolt_epon_onu_10g_us_stat_id_fec_code_words_decode_fails                              BCMOLT_EPON_ONU_10G_US_STAT_ID_FEC_CODE_WORDS_DECODE_FAILS
#define bcmolt_epon_onu_10g_us_stat_id_fec_zeroes_corrected                                     BCMOLT_EPON_ONU_10G_US_STAT_ID_FEC_ZEROES_CORRECTED
#define bcmolt_epon_onu_10g_us_stat_id_fec_ones_corrected                                       BCMOLT_EPON_ONU_10G_US_STAT_ID_FEC_ONES_CORRECTED
#define bcmolt_epon_onu_10g_us_stat_id__num_of                                                  BCMOLT_EPON_ONU_10G_US_STAT_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_stat_cfg_id_cfg                                                  BCMOLT_EPON_ONU_10G_US_STAT_CFG_ID_CFG
#define bcmolt_epon_onu_10g_us_stat_cfg_id__num_of                                              BCMOLT_EPON_ONU_10G_US_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_stat_alarm_cleared_id_stat                                       BCMOLT_EPON_ONU_10G_US_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_epon_onu_10g_us_stat_alarm_cleared_id__num_of                                    BCMOLT_EPON_ONU_10G_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_stat_alarm_raised_id_stat                                        BCMOLT_EPON_ONU_10G_US_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_epon_onu_10g_us_stat_alarm_raised_id__num_of                                     BCMOLT_EPON_ONU_10G_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_onu_10g_us_auto_cfg_id_stat_alarm_cleared                                   BCMOLT_EPON_ONU_10G_US_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_onu_10g_us_auto_cfg_id_stat_alarm_raised                                    BCMOLT_EPON_ONU_10G_US_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_epon_onu_10g_us_auto_cfg_id__num_of                                              BCMOLT_EPON_ONU_10G_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_key_id_epon_ni                                                    BCMOLT_EPON_ONU_1G_US_KEY_ID_EPON_NI
#define bcmolt_epon_onu_1g_us_key_id_onu_id                                                     BCMOLT_EPON_ONU_1G_US_KEY_ID_ONU_ID
#define bcmolt_epon_onu_1g_us_key_id__num_of                                                    BCMOLT_EPON_ONU_1G_US_KEY_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_cfg_id_all_links                                                  BCMOLT_EPON_ONU_1G_US_CFG_ID_ALL_LINKS
#define bcmolt_epon_onu_1g_us_cfg_id__num_of                                                    BCMOLT_EPON_ONU_1G_US_CFG_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_stat_id_good_frames                                               BCMOLT_EPON_ONU_1G_US_STAT_ID_GOOD_FRAMES
#define bcmolt_epon_onu_1g_us_stat_id_good_bytes                                                BCMOLT_EPON_ONU_1G_US_STAT_ID_GOOD_BYTES
#define bcmolt_epon_onu_1g_us_stat_id_oversz_frames                                             BCMOLT_EPON_ONU_1G_US_STAT_ID_OVERSZ_FRAMES
#define bcmolt_epon_onu_1g_us_stat_id_non_fec_good_frames                                       BCMOLT_EPON_ONU_1G_US_STAT_ID_NON_FEC_GOOD_FRAMES
#define bcmolt_epon_onu_1g_us_stat_id_non_fec_good_bytes                                        BCMOLT_EPON_ONU_1G_US_STAT_ID_NON_FEC_GOOD_BYTES
#define bcmolt_epon_onu_1g_us_stat_id_fec_good_frames                                           BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_GOOD_FRAMES
#define bcmolt_epon_onu_1g_us_stat_id_fec_good_bytes                                            BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_GOOD_BYTES
#define bcmolt_epon_onu_1g_us_stat_id_fec_frames_exc_errs                                       BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_FRAMES_EXC_ERRS
#define bcmolt_epon_onu_1g_us_stat_id_fec_blks_no_errs                                          BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_BLKS_NO_ERRS
#define bcmolt_epon_onu_1g_us_stat_id_fec_blks_corr_errs                                        BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_BLKS_CORR_ERRS
#define bcmolt_epon_onu_1g_us_stat_id_fec_blks_uncorr_errs                                      BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_BLKS_UNCORR_ERRS
#define bcmolt_epon_onu_1g_us_stat_id_fec_corr_bytes                                            BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_CORR_BYTES
#define bcmolt_epon_onu_1g_us_stat_id_fec_corr_zeroes                                           BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_CORR_ZEROES
#define bcmolt_epon_onu_1g_us_stat_id_fec_corr_ones                                             BCMOLT_EPON_ONU_1G_US_STAT_ID_FEC_CORR_ONES
#define bcmolt_epon_onu_1g_us_stat_id_undersz_frames                                            BCMOLT_EPON_ONU_1G_US_STAT_ID_UNDERSZ_FRAMES
#define bcmolt_epon_onu_1g_us_stat_id_errorsz_frames                                            BCMOLT_EPON_ONU_1G_US_STAT_ID_ERRORSZ_FRAMES
#define bcmolt_epon_onu_1g_us_stat_id__num_of                                                   BCMOLT_EPON_ONU_1G_US_STAT_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_stat_cfg_id_cfg                                                   BCMOLT_EPON_ONU_1G_US_STAT_CFG_ID_CFG
#define bcmolt_epon_onu_1g_us_stat_cfg_id__num_of                                               BCMOLT_EPON_ONU_1G_US_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_stat_alarm_cleared_id_stat                                        BCMOLT_EPON_ONU_1G_US_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_epon_onu_1g_us_stat_alarm_cleared_id__num_of                                     BCMOLT_EPON_ONU_1G_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_stat_alarm_raised_id_stat                                         BCMOLT_EPON_ONU_1G_US_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_epon_onu_1g_us_stat_alarm_raised_id__num_of                                      BCMOLT_EPON_ONU_1G_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_onu_1g_us_auto_cfg_id_stat_alarm_cleared                                    BCMOLT_EPON_ONU_1G_US_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_onu_1g_us_auto_cfg_id_stat_alarm_raised                                     BCMOLT_EPON_ONU_1G_US_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_epon_onu_1g_us_auto_cfg_id__num_of                                               BCMOLT_EPON_ONU_1G_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_key_id_epon_ni                                                  BCMOLT_EPON_PATH_10G_DS_KEY_ID_EPON_NI
#define bcmolt_epon_path_10g_ds_key_id__num_of                                                  BCMOLT_EPON_PATH_10G_DS_KEY_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_cfg_id_fec_state                                                BCMOLT_EPON_PATH_10G_DS_CFG_ID_FEC_STATE
#define bcmolt_epon_path_10g_ds_cfg_id_prbs_generator                                           BCMOLT_EPON_PATH_10G_DS_CFG_ID_PRBS_GENERATOR
#define bcmolt_epon_path_10g_ds_cfg_id__num_of                                                  BCMOLT_EPON_PATH_10G_DS_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_stat_id_bytes                                                   BCMOLT_EPON_PATH_10G_DS_STAT_ID_BYTES
#define bcmolt_epon_path_10g_ds_stat_id_frames                                                  BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES
#define bcmolt_epon_path_10g_ds_stat_id_frames_64                                               BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_64
#define bcmolt_epon_path_10g_ds_stat_id_frames_65_127                                           BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_65_127
#define bcmolt_epon_path_10g_ds_stat_id_frames_128_255                                          BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_128_255
#define bcmolt_epon_path_10g_ds_stat_id_frames_256_511                                          BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_256_511
#define bcmolt_epon_path_10g_ds_stat_id_frames_512_1023                                         BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_512_1023
#define bcmolt_epon_path_10g_ds_stat_id_frames_1024_1518                                        BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_1024_1518
#define bcmolt_epon_path_10g_ds_stat_id_frames_1519_2047                                        BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_1519_2047
#define bcmolt_epon_path_10g_ds_stat_id_frames_2048_4095                                        BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_2048_4095
#define bcmolt_epon_path_10g_ds_stat_id_frames_4096_9216                                        BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_4096_9216
#define bcmolt_epon_path_10g_ds_stat_id_frames_9217_16383                                       BCMOLT_EPON_PATH_10G_DS_STAT_ID_FRAMES_9217_16383
#define bcmolt_epon_path_10g_ds_stat_id_broadcast_frames                                        BCMOLT_EPON_PATH_10G_DS_STAT_ID_BROADCAST_FRAMES
#define bcmolt_epon_path_10g_ds_stat_id_data_bytes                                              BCMOLT_EPON_PATH_10G_DS_STAT_ID_DATA_BYTES
#define bcmolt_epon_path_10g_ds_stat_id_multicast_frames                                        BCMOLT_EPON_PATH_10G_DS_STAT_ID_MULTICAST_FRAMES
#define bcmolt_epon_path_10g_ds_stat_id_unicast_frames                                          BCMOLT_EPON_PATH_10G_DS_STAT_ID_UNICAST_FRAMES
#define bcmolt_epon_path_10g_ds_stat_id_oam_bytes                                               BCMOLT_EPON_PATH_10G_DS_STAT_ID_OAM_BYTES
#define bcmolt_epon_path_10g_ds_stat_id_oam_frames                                              BCMOLT_EPON_PATH_10G_DS_STAT_ID_OAM_FRAMES
#define bcmolt_epon_path_10g_ds_stat_id_gate_frames                                             BCMOLT_EPON_PATH_10G_DS_STAT_ID_GATE_FRAMES
#define bcmolt_epon_path_10g_ds_stat_id_mpcp_frames                                             BCMOLT_EPON_PATH_10G_DS_STAT_ID_MPCP_FRAMES
#define bcmolt_epon_path_10g_ds_stat_id_abort_frames                                            BCMOLT_EPON_PATH_10G_DS_STAT_ID_ABORT_FRAMES
#define bcmolt_epon_path_10g_ds_stat_id__num_of                                                 BCMOLT_EPON_PATH_10G_DS_STAT_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_stat_cfg_id_cfg                                                 BCMOLT_EPON_PATH_10G_DS_STAT_CFG_ID_CFG
#define bcmolt_epon_path_10g_ds_stat_cfg_id__num_of                                             BCMOLT_EPON_PATH_10G_DS_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_stat_alarm_cleared_id_stat                                      BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_epon_path_10g_ds_stat_alarm_cleared_id__num_of                                   BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_stat_alarm_raised_id_stat                                       BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_epon_path_10g_ds_stat_alarm_raised_id__num_of                                    BCMOLT_EPON_PATH_10G_DS_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_path_10g_ds_auto_cfg_id_stat_alarm_cleared                                  BCMOLT_EPON_PATH_10G_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_path_10g_ds_auto_cfg_id_stat_alarm_raised                                   BCMOLT_EPON_PATH_10G_DS_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_epon_path_10g_ds_auto_cfg_id__num_of                                             BCMOLT_EPON_PATH_10G_DS_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_us_key_id_epon_ni                                                  BCMOLT_EPON_PATH_10G_US_KEY_ID_EPON_NI
#define bcmolt_epon_path_10g_us_key_id__num_of                                                  BCMOLT_EPON_PATH_10G_US_KEY_ID__NUM_OF
#define bcmolt_epon_path_10g_us_cfg_id_fec_state                                                BCMOLT_EPON_PATH_10G_US_CFG_ID_FEC_STATE
#define bcmolt_epon_path_10g_us_cfg_id_sync_time_tq                                             BCMOLT_EPON_PATH_10G_US_CFG_ID_SYNC_TIME_TQ
#define bcmolt_epon_path_10g_us_cfg_id_prbs_checker                                             BCMOLT_EPON_PATH_10G_US_CFG_ID_PRBS_CHECKER
#define bcmolt_epon_path_10g_us_cfg_id_prbs_status                                              BCMOLT_EPON_PATH_10G_US_CFG_ID_PRBS_STATUS
#define bcmolt_epon_path_10g_us_cfg_id__num_of                                                  BCMOLT_EPON_PATH_10G_US_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_us_stat_id_bytes                                                   BCMOLT_EPON_PATH_10G_US_STAT_ID_BYTES
#define bcmolt_epon_path_10g_us_stat_id_frames                                                  BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES
#define bcmolt_epon_path_10g_us_stat_id_frames_64                                               BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_64
#define bcmolt_epon_path_10g_us_stat_id_frames_65_127                                           BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_65_127
#define bcmolt_epon_path_10g_us_stat_id_frames_128_255                                          BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_128_255
#define bcmolt_epon_path_10g_us_stat_id_frames_256_511                                          BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_256_511
#define bcmolt_epon_path_10g_us_stat_id_frames_512_1023                                         BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_512_1023
#define bcmolt_epon_path_10g_us_stat_id_frames_1024_1518                                        BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_1024_1518
#define bcmolt_epon_path_10g_us_stat_id_frames_1519_2047                                        BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_1519_2047
#define bcmolt_epon_path_10g_us_stat_id_frames_2048_4095                                        BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_2048_4095
#define bcmolt_epon_path_10g_us_stat_id_frames_4096_9216                                        BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_4096_9216
#define bcmolt_epon_path_10g_us_stat_id_frames_9217_16383                                       BCMOLT_EPON_PATH_10G_US_STAT_ID_FRAMES_9217_16383
#define bcmolt_epon_path_10g_us_stat_id_broadcast_frames                                        BCMOLT_EPON_PATH_10G_US_STAT_ID_BROADCAST_FRAMES
#define bcmolt_epon_path_10g_us_stat_id_data_bytes                                              BCMOLT_EPON_PATH_10G_US_STAT_ID_DATA_BYTES
#define bcmolt_epon_path_10g_us_stat_id_multicast_frames                                        BCMOLT_EPON_PATH_10G_US_STAT_ID_MULTICAST_FRAMES
#define bcmolt_epon_path_10g_us_stat_id_unicast_frames                                          BCMOLT_EPON_PATH_10G_US_STAT_ID_UNICAST_FRAMES
#define bcmolt_epon_path_10g_us_stat_id_mpcp_frames                                             BCMOLT_EPON_PATH_10G_US_STAT_ID_MPCP_FRAMES
#define bcmolt_epon_path_10g_us_stat_id_oam_bytes                                               BCMOLT_EPON_PATH_10G_US_STAT_ID_OAM_BYTES
#define bcmolt_epon_path_10g_us_stat_id_oam_frames                                              BCMOLT_EPON_PATH_10G_US_STAT_ID_OAM_FRAMES
#define bcmolt_epon_path_10g_us_stat_id_report_frames                                           BCMOLT_EPON_PATH_10G_US_STAT_ID_REPORT_FRAMES
#define bcmolt_epon_path_10g_us_stat_id_abort_frames                                            BCMOLT_EPON_PATH_10G_US_STAT_ID_ABORT_FRAMES
#define bcmolt_epon_path_10g_us_stat_id_fcs_error                                               BCMOLT_EPON_PATH_10G_US_STAT_ID_FCS_ERROR
#define bcmolt_epon_path_10g_us_stat_id_crc_8_error                                             BCMOLT_EPON_PATH_10G_US_STAT_ID_CRC_8_ERROR
#define bcmolt_epon_path_10g_us_stat_id_out_of_slot                                             BCMOLT_EPON_PATH_10G_US_STAT_ID_OUT_OF_SLOT
#define bcmolt_epon_path_10g_us_stat_id_oversize_error                                          BCMOLT_EPON_PATH_10G_US_STAT_ID_OVERSIZE_ERROR
#define bcmolt_epon_path_10g_us_stat_id_runt_error                                              BCMOLT_EPON_PATH_10G_US_STAT_ID_RUNT_ERROR
#define bcmolt_epon_path_10g_us_stat_id__num_of                                                 BCMOLT_EPON_PATH_10G_US_STAT_ID__NUM_OF
#define bcmolt_epon_path_10g_us_stat_cfg_id_cfg                                                 BCMOLT_EPON_PATH_10G_US_STAT_CFG_ID_CFG
#define bcmolt_epon_path_10g_us_stat_cfg_id__num_of                                             BCMOLT_EPON_PATH_10G_US_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_path_10g_us_stat_alarm_cleared_id_stat                                      BCMOLT_EPON_PATH_10G_US_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_epon_path_10g_us_stat_alarm_cleared_id__num_of                                   BCMOLT_EPON_PATH_10G_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_path_10g_us_stat_alarm_raised_id_stat                                       BCMOLT_EPON_PATH_10G_US_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_epon_path_10g_us_stat_alarm_raised_id__num_of                                    BCMOLT_EPON_PATH_10G_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_path_10g_us_auto_cfg_id_stat_alarm_cleared                                  BCMOLT_EPON_PATH_10G_US_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_path_10g_us_auto_cfg_id_stat_alarm_raised                                   BCMOLT_EPON_PATH_10G_US_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_epon_path_10g_us_auto_cfg_id__num_of                                             BCMOLT_EPON_PATH_10G_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_key_id_epon_ni                                                   BCMOLT_EPON_PATH_1G_DS_KEY_ID_EPON_NI
#define bcmolt_epon_path_1g_ds_key_id__num_of                                                   BCMOLT_EPON_PATH_1G_DS_KEY_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_cfg_id_default_fec_state                                         BCMOLT_EPON_PATH_1G_DS_CFG_ID_DEFAULT_FEC_STATE
#define bcmolt_epon_path_1g_ds_cfg_id_raman_mode                                                BCMOLT_EPON_PATH_1G_DS_CFG_ID_RAMAN_MODE
#define bcmolt_epon_path_1g_ds_cfg_id_turbo_2g_mode                                             BCMOLT_EPON_PATH_1G_DS_CFG_ID_TURBO_2G_MODE
#define bcmolt_epon_path_1g_ds_cfg_id_prbs_generator                                            BCMOLT_EPON_PATH_1G_DS_CFG_ID_PRBS_GENERATOR
#define bcmolt_epon_path_1g_ds_cfg_id__num_of                                                   BCMOLT_EPON_PATH_1G_DS_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_stat_id_bytes                                                    BCMOLT_EPON_PATH_1G_DS_STAT_ID_BYTES
#define bcmolt_epon_path_1g_ds_stat_id_frames                                                   BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES
#define bcmolt_epon_path_1g_ds_stat_id_frames_64                                                BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_64
#define bcmolt_epon_path_1g_ds_stat_id_frames_65_127                                            BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_65_127
#define bcmolt_epon_path_1g_ds_stat_id_frames_128_255                                           BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_128_255
#define bcmolt_epon_path_1g_ds_stat_id_frames_256_511                                           BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_256_511
#define bcmolt_epon_path_1g_ds_stat_id_frames_512_1023                                          BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_512_1023
#define bcmolt_epon_path_1g_ds_stat_id_frames_1024_1518                                         BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_1024_1518
#define bcmolt_epon_path_1g_ds_stat_id_frames_1519_2047                                         BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_1519_2047
#define bcmolt_epon_path_1g_ds_stat_id_frames_2048_4095                                         BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_2048_4095
#define bcmolt_epon_path_1g_ds_stat_id_frames_4096_9216                                         BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_4096_9216
#define bcmolt_epon_path_1g_ds_stat_id_frames_9217_16383                                        BCMOLT_EPON_PATH_1G_DS_STAT_ID_FRAMES_9217_16383
#define bcmolt_epon_path_1g_ds_stat_id_broadcast_frames                                         BCMOLT_EPON_PATH_1G_DS_STAT_ID_BROADCAST_FRAMES
#define bcmolt_epon_path_1g_ds_stat_id_data_bytes                                               BCMOLT_EPON_PATH_1G_DS_STAT_ID_DATA_BYTES
#define bcmolt_epon_path_1g_ds_stat_id_multicast_frames                                         BCMOLT_EPON_PATH_1G_DS_STAT_ID_MULTICAST_FRAMES
#define bcmolt_epon_path_1g_ds_stat_id_unicast_frames                                           BCMOLT_EPON_PATH_1G_DS_STAT_ID_UNICAST_FRAMES
#define bcmolt_epon_path_1g_ds_stat_id_oam_bytes                                                BCMOLT_EPON_PATH_1G_DS_STAT_ID_OAM_BYTES
#define bcmolt_epon_path_1g_ds_stat_id_oam_frames                                               BCMOLT_EPON_PATH_1G_DS_STAT_ID_OAM_FRAMES
#define bcmolt_epon_path_1g_ds_stat_id_gate_frames                                              BCMOLT_EPON_PATH_1G_DS_STAT_ID_GATE_FRAMES
#define bcmolt_epon_path_1g_ds_stat_id_mpcp_frames                                              BCMOLT_EPON_PATH_1G_DS_STAT_ID_MPCP_FRAMES
#define bcmolt_epon_path_1g_ds_stat_id_abort_frames                                             BCMOLT_EPON_PATH_1G_DS_STAT_ID_ABORT_FRAMES
#define bcmolt_epon_path_1g_ds_stat_id__num_of                                                  BCMOLT_EPON_PATH_1G_DS_STAT_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_stat_cfg_id_cfg                                                  BCMOLT_EPON_PATH_1G_DS_STAT_CFG_ID_CFG
#define bcmolt_epon_path_1g_ds_stat_cfg_id__num_of                                              BCMOLT_EPON_PATH_1G_DS_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_stat_alarm_cleared_id_stat                                       BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_epon_path_1g_ds_stat_alarm_cleared_id__num_of                                    BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_stat_alarm_raised_id_stat                                        BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_epon_path_1g_ds_stat_alarm_raised_id__num_of                                     BCMOLT_EPON_PATH_1G_DS_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_path_1g_ds_auto_cfg_id_stat_alarm_cleared                                   BCMOLT_EPON_PATH_1G_DS_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_path_1g_ds_auto_cfg_id_stat_alarm_raised                                    BCMOLT_EPON_PATH_1G_DS_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_epon_path_1g_ds_auto_cfg_id__num_of                                              BCMOLT_EPON_PATH_1G_DS_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_us_key_id_epon_ni                                                   BCMOLT_EPON_PATH_1G_US_KEY_ID_EPON_NI
#define bcmolt_epon_path_1g_us_key_id__num_of                                                   BCMOLT_EPON_PATH_1G_US_KEY_ID__NUM_OF
#define bcmolt_epon_path_1g_us_cfg_id_default_fec_state                                         BCMOLT_EPON_PATH_1G_US_CFG_ID_DEFAULT_FEC_STATE
#define bcmolt_epon_path_1g_us_cfg_id_sync_time_tq                                              BCMOLT_EPON_PATH_1G_US_CFG_ID_SYNC_TIME_TQ
#define bcmolt_epon_path_1g_us_cfg_id_prbs_checker                                              BCMOLT_EPON_PATH_1G_US_CFG_ID_PRBS_CHECKER
#define bcmolt_epon_path_1g_us_cfg_id_prbs_status                                               BCMOLT_EPON_PATH_1G_US_CFG_ID_PRBS_STATUS
#define bcmolt_epon_path_1g_us_cfg_id__num_of                                                   BCMOLT_EPON_PATH_1G_US_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_us_stat_id_bytes                                                    BCMOLT_EPON_PATH_1G_US_STAT_ID_BYTES
#define bcmolt_epon_path_1g_us_stat_id_frames                                                   BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES
#define bcmolt_epon_path_1g_us_stat_id_frames_64                                                BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_64
#define bcmolt_epon_path_1g_us_stat_id_frames_65_127                                            BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_65_127
#define bcmolt_epon_path_1g_us_stat_id_frames_128_255                                           BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_128_255
#define bcmolt_epon_path_1g_us_stat_id_frames_256_511                                           BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_256_511
#define bcmolt_epon_path_1g_us_stat_id_frames_512_1023                                          BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_512_1023
#define bcmolt_epon_path_1g_us_stat_id_frames_1024_1518                                         BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_1024_1518
#define bcmolt_epon_path_1g_us_stat_id_frames_1519_2047                                         BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_1519_2047
#define bcmolt_epon_path_1g_us_stat_id_frames_2048_4095                                         BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_2048_4095
#define bcmolt_epon_path_1g_us_stat_id_frames_4096_9216                                         BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_4096_9216
#define bcmolt_epon_path_1g_us_stat_id_frames_9217_16383                                        BCMOLT_EPON_PATH_1G_US_STAT_ID_FRAMES_9217_16383
#define bcmolt_epon_path_1g_us_stat_id_broadcast_frames                                         BCMOLT_EPON_PATH_1G_US_STAT_ID_BROADCAST_FRAMES
#define bcmolt_epon_path_1g_us_stat_id_data_bytes                                               BCMOLT_EPON_PATH_1G_US_STAT_ID_DATA_BYTES
#define bcmolt_epon_path_1g_us_stat_id_multicast_frames                                         BCMOLT_EPON_PATH_1G_US_STAT_ID_MULTICAST_FRAMES
#define bcmolt_epon_path_1g_us_stat_id_unicast_frames                                           BCMOLT_EPON_PATH_1G_US_STAT_ID_UNICAST_FRAMES
#define bcmolt_epon_path_1g_us_stat_id_mpcp_frames                                              BCMOLT_EPON_PATH_1G_US_STAT_ID_MPCP_FRAMES
#define bcmolt_epon_path_1g_us_stat_id_oam_bytes                                                BCMOLT_EPON_PATH_1G_US_STAT_ID_OAM_BYTES
#define bcmolt_epon_path_1g_us_stat_id_oam_frames                                               BCMOLT_EPON_PATH_1G_US_STAT_ID_OAM_FRAMES
#define bcmolt_epon_path_1g_us_stat_id_report_frames                                            BCMOLT_EPON_PATH_1G_US_STAT_ID_REPORT_FRAMES
#define bcmolt_epon_path_1g_us_stat_id_abort_frames                                             BCMOLT_EPON_PATH_1G_US_STAT_ID_ABORT_FRAMES
#define bcmolt_epon_path_1g_us_stat_id_fcs_error                                                BCMOLT_EPON_PATH_1G_US_STAT_ID_FCS_ERROR
#define bcmolt_epon_path_1g_us_stat_id_crc_8_error                                              BCMOLT_EPON_PATH_1G_US_STAT_ID_CRC_8_ERROR
#define bcmolt_epon_path_1g_us_stat_id_out_of_slot                                              BCMOLT_EPON_PATH_1G_US_STAT_ID_OUT_OF_SLOT
#define bcmolt_epon_path_1g_us_stat_id_oversize_error                                           BCMOLT_EPON_PATH_1G_US_STAT_ID_OVERSIZE_ERROR
#define bcmolt_epon_path_1g_us_stat_id_runt_error                                               BCMOLT_EPON_PATH_1G_US_STAT_ID_RUNT_ERROR
#define bcmolt_epon_path_1g_us_stat_id__num_of                                                  BCMOLT_EPON_PATH_1G_US_STAT_ID__NUM_OF
#define bcmolt_epon_path_1g_us_stat_cfg_id_cfg                                                  BCMOLT_EPON_PATH_1G_US_STAT_CFG_ID_CFG
#define bcmolt_epon_path_1g_us_stat_cfg_id__num_of                                              BCMOLT_EPON_PATH_1G_US_STAT_CFG_ID__NUM_OF
#define bcmolt_epon_path_1g_us_stat_alarm_cleared_id_stat                                       BCMOLT_EPON_PATH_1G_US_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_epon_path_1g_us_stat_alarm_cleared_id__num_of                                    BCMOLT_EPON_PATH_1G_US_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_epon_path_1g_us_stat_alarm_raised_id_stat                                        BCMOLT_EPON_PATH_1G_US_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_epon_path_1g_us_stat_alarm_raised_id__num_of                                     BCMOLT_EPON_PATH_1G_US_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_epon_path_1g_us_auto_cfg_id_stat_alarm_cleared                                   BCMOLT_EPON_PATH_1G_US_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_epon_path_1g_us_auto_cfg_id_stat_alarm_raised                                    BCMOLT_EPON_PATH_1G_US_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_epon_path_1g_us_auto_cfg_id__num_of                                              BCMOLT_EPON_PATH_1G_US_AUTO_CFG_ID__NUM_OF
#define bcmolt_epon_rp_key_id_epon_ni                                                           BCMOLT_EPON_RP_KEY_ID_EPON_NI
#define bcmolt_epon_rp_key_id_link_rate                                                         BCMOLT_EPON_RP_KEY_ID_LINK_RATE
#define bcmolt_epon_rp_key_id__num_of                                                           BCMOLT_EPON_RP_KEY_ID__NUM_OF
#define bcmolt_epon_rp_cfg_id_base_llid                                                         BCMOLT_EPON_RP_CFG_ID_BASE_LLID
#define bcmolt_epon_rp_cfg_id_mpcp_disc_en                                                      BCMOLT_EPON_RP_CFG_ID_MPCP_DISC_EN
#define bcmolt_epon_rp_cfg_id_mpcp_disc_gnt_len_tq                                              BCMOLT_EPON_RP_CFG_ID_MPCP_DISC_GNT_LEN_TQ
#define bcmolt_epon_rp_cfg_id_mpcp_report_timeout                                               BCMOLT_EPON_RP_CFG_ID_MPCP_REPORT_TIMEOUT
#define bcmolt_epon_rp_cfg_id_max_mpcp_reg_per_disc_window                                      BCMOLT_EPON_RP_CFG_ID_MAX_MPCP_REG_PER_DISC_WINDOW
#define bcmolt_epon_rp_cfg_id_max_links                                                         BCMOLT_EPON_RP_CFG_ID_MAX_LINKS
#define bcmolt_epon_rp_cfg_id_default_upstream_bandwidth                                        BCMOLT_EPON_RP_CFG_ID_DEFAULT_UPSTREAM_BANDWIDTH
#define bcmolt_epon_rp_cfg_id_rate_of_refraction                                                BCMOLT_EPON_RP_CFG_ID_RATE_OF_REFRACTION
#define bcmolt_epon_rp_cfg_id__num_of                                                           BCMOLT_EPON_RP_CFG_ID__NUM_OF
#define bcmolt_gpio_key_id_reserved                                                             BCMOLT_GPIO_KEY_ID_RESERVED
#define bcmolt_gpio_key_id_gpio_id                                                              BCMOLT_GPIO_KEY_ID_GPIO_ID
#define bcmolt_gpio_key_id__num_of                                                              BCMOLT_GPIO_KEY_ID__NUM_OF
#define bcmolt_gpio_cfg_id_direction                                                            BCMOLT_GPIO_CFG_ID_DIRECTION
#define bcmolt_gpio_cfg_id_value                                                                BCMOLT_GPIO_CFG_ID_VALUE
#define bcmolt_gpio_cfg_id__num_of                                                              BCMOLT_GPIO_CFG_ID__NUM_OF
#define bcmolt_gpon_alloc_key_id_pon_ni                                                         BCMOLT_GPON_ALLOC_KEY_ID_PON_NI
#define bcmolt_gpon_alloc_key_id_alloc_id                                                       BCMOLT_GPON_ALLOC_KEY_ID_ALLOC_ID
#define bcmolt_gpon_alloc_key_id__num_of                                                        BCMOLT_GPON_ALLOC_KEY_ID__NUM_OF
#define bcmolt_gpon_alloc_cfg_id_state                                                          BCMOLT_GPON_ALLOC_CFG_ID_STATE
#define bcmolt_gpon_alloc_cfg_id_sla                                                            BCMOLT_GPON_ALLOC_CFG_ID_SLA
#define bcmolt_gpon_alloc_cfg_id_onu_id                                                         BCMOLT_GPON_ALLOC_CFG_ID_ONU_ID
#define bcmolt_gpon_alloc_cfg_id_collect_stats                                                  BCMOLT_GPON_ALLOC_CFG_ID_COLLECT_STATS
#define bcmolt_gpon_alloc_cfg_id__num_of                                                        BCMOLT_GPON_ALLOC_CFG_ID__NUM_OF
#define bcmolt_gpon_alloc_stat_id_rx_bytes                                                      BCMOLT_GPON_ALLOC_STAT_ID_RX_BYTES
#define bcmolt_gpon_alloc_stat_id__num_of                                                       BCMOLT_GPON_ALLOC_STAT_ID__NUM_OF
#define bcmolt_gpon_alloc_stat_cfg_id_cfg                                                       BCMOLT_GPON_ALLOC_STAT_CFG_ID_CFG
#define bcmolt_gpon_alloc_stat_cfg_id__num_of                                                   BCMOLT_GPON_ALLOC_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_alloc_configuration_completed_id_status                                     BCMOLT_GPON_ALLOC_CONFIGURATION_COMPLETED_ID_STATUS
#define bcmolt_gpon_alloc_configuration_completed_id_new_state                                  BCMOLT_GPON_ALLOC_CONFIGURATION_COMPLETED_ID_NEW_STATE
#define bcmolt_gpon_alloc_configuration_completed_id__num_of                                    BCMOLT_GPON_ALLOC_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_alloc_get_alloc_stats_completed_id_status                                   BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_STATUS
#define bcmolt_gpon_alloc_get_alloc_stats_completed_id_average_nsr_used                         BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_NSR_USED
#define bcmolt_gpon_alloc_get_alloc_stats_completed_id_average_nsr_allocated                    BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_NSR_ALLOCATED
#define bcmolt_gpon_alloc_get_alloc_stats_completed_id_average_sr_report                        BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_SR_REPORT
#define bcmolt_gpon_alloc_get_alloc_stats_completed_id__num_of                                  BCMOLT_GPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_alloc_stat_alarm_cleared_id_stat                                            BCMOLT_GPON_ALLOC_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_gpon_alloc_stat_alarm_cleared_id__num_of                                         BCMOLT_GPON_ALLOC_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_alloc_stat_alarm_raised_id_stat                                             BCMOLT_GPON_ALLOC_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_gpon_alloc_stat_alarm_raised_id__num_of                                          BCMOLT_GPON_ALLOC_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_alloc_auto_cfg_id_configuration_completed                                   BCMOLT_GPON_ALLOC_AUTO_CFG_ID_CONFIGURATION_COMPLETED
#define bcmolt_gpon_alloc_auto_cfg_id_get_alloc_stats_completed                                 BCMOLT_GPON_ALLOC_AUTO_CFG_ID_GET_ALLOC_STATS_COMPLETED
#define bcmolt_gpon_alloc_auto_cfg_id_stat_alarm_cleared                                        BCMOLT_GPON_ALLOC_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_alloc_auto_cfg_id_stat_alarm_raised                                         BCMOLT_GPON_ALLOC_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_alloc_auto_cfg_id__num_of                                                   BCMOLT_GPON_ALLOC_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_alloc_get_stats_id_num_of_cycles                                            BCMOLT_GPON_ALLOC_GET_STATS_ID_NUM_OF_CYCLES
#define bcmolt_gpon_alloc_get_stats_id__num_of                                                  BCMOLT_GPON_ALLOC_GET_STATS_ID__NUM_OF
#define bcmolt_gpon_alloc_set_state_id_state                                                    BCMOLT_GPON_ALLOC_SET_STATE_ID_STATE
#define bcmolt_gpon_alloc_set_state_id__num_of                                                  BCMOLT_GPON_ALLOC_SET_STATE_ID__NUM_OF
#define bcmolt_gpon_gem_port_key_id_pon_ni                                                      BCMOLT_GPON_GEM_PORT_KEY_ID_PON_NI
#define bcmolt_gpon_gem_port_key_id_gem_port_id                                                 BCMOLT_GPON_GEM_PORT_KEY_ID_GEM_PORT_ID
#define bcmolt_gpon_gem_port_key_id__num_of                                                     BCMOLT_GPON_GEM_PORT_KEY_ID__NUM_OF
#define bcmolt_gpon_gem_port_cfg_id_configuration                                               BCMOLT_GPON_GEM_PORT_CFG_ID_CONFIGURATION
#define bcmolt_gpon_gem_port_cfg_id_onu_id                                                      BCMOLT_GPON_GEM_PORT_CFG_ID_ONU_ID
#define bcmolt_gpon_gem_port_cfg_id_gem_port_state                                              BCMOLT_GPON_GEM_PORT_CFG_ID_GEM_PORT_STATE
#define bcmolt_gpon_gem_port_cfg_id_downstream_encryption_mode                                  BCMOLT_GPON_GEM_PORT_CFG_ID_DOWNSTREAM_ENCRYPTION_MODE
#define bcmolt_gpon_gem_port_cfg_id_upstream_destination_queue                                  BCMOLT_GPON_GEM_PORT_CFG_ID_UPSTREAM_DESTINATION_QUEUE
#define bcmolt_gpon_gem_port_cfg_id_control                                                     BCMOLT_GPON_GEM_PORT_CFG_ID_CONTROL
#define bcmolt_gpon_gem_port_cfg_id_debug_flow_config                                           BCMOLT_GPON_GEM_PORT_CFG_ID_DEBUG_FLOW_CONFIG
#define bcmolt_gpon_gem_port_cfg_id_mac_table_entry_limit                                       BCMOLT_GPON_GEM_PORT_CFG_ID_MAC_TABLE_ENTRY_LIMIT
#define bcmolt_gpon_gem_port_cfg_id__num_of                                                     BCMOLT_GPON_GEM_PORT_CFG_ID__NUM_OF
#define bcmolt_gpon_gem_port_stat_id_rx_packets                                                 BCMOLT_GPON_GEM_PORT_STAT_ID_RX_PACKETS
#define bcmolt_gpon_gem_port_stat_id_rx_bytes                                                   BCMOLT_GPON_GEM_PORT_STAT_ID_RX_BYTES
#define bcmolt_gpon_gem_port_stat_id_tx_packets                                                 BCMOLT_GPON_GEM_PORT_STAT_ID_TX_PACKETS
#define bcmolt_gpon_gem_port_stat_id_tx_bytes                                                   BCMOLT_GPON_GEM_PORT_STAT_ID_TX_BYTES
#define bcmolt_gpon_gem_port_stat_id__num_of                                                    BCMOLT_GPON_GEM_PORT_STAT_ID__NUM_OF
#define bcmolt_gpon_gem_port_stat_cfg_id_cfg                                                    BCMOLT_GPON_GEM_PORT_STAT_CFG_ID_CFG
#define bcmolt_gpon_gem_port_stat_cfg_id__num_of                                                BCMOLT_GPON_GEM_PORT_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_gem_port_configuration_completed_id_status                                  BCMOLT_GPON_GEM_PORT_CONFIGURATION_COMPLETED_ID_STATUS
#define bcmolt_gpon_gem_port_configuration_completed_id_new_state                               BCMOLT_GPON_GEM_PORT_CONFIGURATION_COMPLETED_ID_NEW_STATE
#define bcmolt_gpon_gem_port_configuration_completed_id__num_of                                 BCMOLT_GPON_GEM_PORT_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_gem_port_stat_alarm_cleared_id_stat                                         BCMOLT_GPON_GEM_PORT_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_gpon_gem_port_stat_alarm_cleared_id__num_of                                      BCMOLT_GPON_GEM_PORT_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_gem_port_stat_alarm_raised_id_stat                                          BCMOLT_GPON_GEM_PORT_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_gpon_gem_port_stat_alarm_raised_id__num_of                                       BCMOLT_GPON_GEM_PORT_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_gem_port_auto_cfg_id_configuration_completed                                BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID_CONFIGURATION_COMPLETED
#define bcmolt_gpon_gem_port_auto_cfg_id_stat_alarm_cleared                                     BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_gem_port_auto_cfg_id_stat_alarm_raised                                      BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_gem_port_auto_cfg_id__num_of                                                BCMOLT_GPON_GEM_PORT_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_gem_port_set_state_id_state                                                 BCMOLT_GPON_GEM_PORT_SET_STATE_ID_STATE
#define bcmolt_gpon_gem_port_set_state_id__num_of                                               BCMOLT_GPON_GEM_PORT_SET_STATE_ID__NUM_OF
#define bcmolt_gpon_iwf_key_id_pon_ni                                                           BCMOLT_GPON_IWF_KEY_ID_PON_NI
#define bcmolt_gpon_iwf_key_id__num_of                                                          BCMOLT_GPON_IWF_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_cfg_id_iwf_mode                                                         BCMOLT_GPON_IWF_CFG_ID_IWF_MODE
#define bcmolt_gpon_iwf_cfg_id_us_tpid_per_flow                                                 BCMOLT_GPON_IWF_CFG_ID_US_TPID_PER_FLOW
#define bcmolt_gpon_iwf_cfg_id_us_otag_direct_tpid                                              BCMOLT_GPON_IWF_CFG_ID_US_OTAG_DIRECT_TPID
#define bcmolt_gpon_iwf_cfg_id_us_otag_direct_pbit                                              BCMOLT_GPON_IWF_CFG_ID_US_OTAG_DIRECT_PBIT
#define bcmolt_gpon_iwf_cfg_id_ds_tpid                                                          BCMOLT_GPON_IWF_CFG_ID_DS_TPID
#define bcmolt_gpon_iwf_cfg_id_mac_table_configuration                                          BCMOLT_GPON_IWF_CFG_ID_MAC_TABLE_CONFIGURATION
#define bcmolt_gpon_iwf_cfg_id_debug_flow_configuration                                         BCMOLT_GPON_IWF_CFG_ID_DEBUG_FLOW_CONFIGURATION
#define bcmolt_gpon_iwf_cfg_id_mac_table_count                                                  BCMOLT_GPON_IWF_CFG_ID_MAC_TABLE_COUNT
#define bcmolt_gpon_iwf_cfg_id_forbidden_vlan_flow_gem_range_start                              BCMOLT_GPON_IWF_CFG_ID_FORBIDDEN_VLAN_FLOW_GEM_RANGE_START
#define bcmolt_gpon_iwf_cfg_id__num_of                                                          BCMOLT_GPON_IWF_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_stat_id_ds_hit_event                                                    BCMOLT_GPON_IWF_STAT_ID_DS_HIT_EVENT
#define bcmolt_gpon_iwf_stat_id_ds_miss_event                                                   BCMOLT_GPON_IWF_STAT_ID_DS_MISS_EVENT
#define bcmolt_gpon_iwf_stat_id_ds_drop_due_to_miss_event                                       BCMOLT_GPON_IWF_STAT_ID_DS_DROP_DUE_TO_MISS_EVENT
#define bcmolt_gpon_iwf_stat_id_ds_drop_due_to_hit_event                                        BCMOLT_GPON_IWF_STAT_ID_DS_DROP_DUE_TO_HIT_EVENT
#define bcmolt_gpon_iwf_stat_id_ds_drop_to_disabled_gem                                         BCMOLT_GPON_IWF_STAT_ID_DS_DROP_TO_DISABLED_GEM
#define bcmolt_gpon_iwf_stat_id_new_mac_discovered                                              BCMOLT_GPON_IWF_STAT_ID_NEW_MAC_DISCOVERED
#define bcmolt_gpon_iwf_stat_id_move_event                                                      BCMOLT_GPON_IWF_STAT_ID_MOVE_EVENT
#define bcmolt_gpon_iwf_stat_id_new_mac_drop_due_to_fifo_full                                   BCMOLT_GPON_IWF_STAT_ID_NEW_MAC_DROP_DUE_TO_FIFO_FULL
#define bcmolt_gpon_iwf_stat_id__num_of                                                         BCMOLT_GPON_IWF_STAT_ID__NUM_OF
#define bcmolt_gpon_iwf_stat_cfg_id_cfg                                                         BCMOLT_GPON_IWF_STAT_CFG_ID_CFG
#define bcmolt_gpon_iwf_stat_cfg_id__num_of                                                     BCMOLT_GPON_IWF_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_flush_mac_table_completed_id__num_of                                    BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_iwf_scan_mac_table_completed_id_mac_address                                 BCMOLT_GPON_IWF_SCAN_MAC_TABLE_COMPLETED_ID_MAC_ADDRESS
#define bcmolt_gpon_iwf_scan_mac_table_completed_id_entries                                     BCMOLT_GPON_IWF_SCAN_MAC_TABLE_COMPLETED_ID_ENTRIES
#define bcmolt_gpon_iwf_scan_mac_table_completed_id__num_of                                     BCMOLT_GPON_IWF_SCAN_MAC_TABLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_iwf_stat_alarm_cleared_id_stat                                              BCMOLT_GPON_IWF_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_gpon_iwf_stat_alarm_cleared_id__num_of                                           BCMOLT_GPON_IWF_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_iwf_stat_alarm_raised_id_stat                                               BCMOLT_GPON_IWF_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_gpon_iwf_stat_alarm_raised_id__num_of                                            BCMOLT_GPON_IWF_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_iwf_auto_cfg_id_flush_mac_table_completed                                   BCMOLT_GPON_IWF_AUTO_CFG_ID_FLUSH_MAC_TABLE_COMPLETED
#define bcmolt_gpon_iwf_auto_cfg_id_scan_mac_table_completed                                    BCMOLT_GPON_IWF_AUTO_CFG_ID_SCAN_MAC_TABLE_COMPLETED
#define bcmolt_gpon_iwf_auto_cfg_id_stat_alarm_cleared                                          BCMOLT_GPON_IWF_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_iwf_auto_cfg_id_stat_alarm_raised                                           BCMOLT_GPON_IWF_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_iwf_auto_cfg_id__num_of                                                     BCMOLT_GPON_IWF_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_flush_mac_table_id_control                                              BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID_CONTROL
#define bcmolt_gpon_iwf_flush_mac_table_id_vid                                                  BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID_VID
#define bcmolt_gpon_iwf_flush_mac_table_id_flow_id                                              BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID_FLOW_ID
#define bcmolt_gpon_iwf_flush_mac_table_id__num_of                                              BCMOLT_GPON_IWF_FLUSH_MAC_TABLE_ID__NUM_OF
#define bcmolt_gpon_iwf_scan_mac_table_id_mac_address                                           BCMOLT_GPON_IWF_SCAN_MAC_TABLE_ID_MAC_ADDRESS
#define bcmolt_gpon_iwf_scan_mac_table_id__num_of                                               BCMOLT_GPON_IWF_SCAN_MAC_TABLE_ID__NUM_OF
#define bcmolt_gpon_iwf_ds_egress_flow_key_id_pon_ni                                            BCMOLT_GPON_IWF_DS_EGRESS_FLOW_KEY_ID_PON_NI
#define bcmolt_gpon_iwf_ds_egress_flow_key_id_flow_id                                           BCMOLT_GPON_IWF_DS_EGRESS_FLOW_KEY_ID_FLOW_ID
#define bcmolt_gpon_iwf_ds_egress_flow_key_id__num_of                                           BCMOLT_GPON_IWF_DS_EGRESS_FLOW_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_ds_egress_flow_cfg_id_gem_port                                          BCMOLT_GPON_IWF_DS_EGRESS_FLOW_CFG_ID_GEM_PORT
#define bcmolt_gpon_iwf_ds_egress_flow_cfg_id_pbit_control                                      BCMOLT_GPON_IWF_DS_EGRESS_FLOW_CFG_ID_PBIT_CONTROL
#define bcmolt_gpon_iwf_ds_egress_flow_cfg_id__num_of                                           BCMOLT_GPON_IWF_DS_EGRESS_FLOW_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_ds_ingress_flow_key_id_pon_ni                                           BCMOLT_GPON_IWF_DS_INGRESS_FLOW_KEY_ID_PON_NI
#define bcmolt_gpon_iwf_ds_ingress_flow_key_id_vlan_id                                          BCMOLT_GPON_IWF_DS_INGRESS_FLOW_KEY_ID_VLAN_ID
#define bcmolt_gpon_iwf_ds_ingress_flow_key_id__num_of                                          BCMOLT_GPON_IWF_DS_INGRESS_FLOW_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_ds_ingress_flow_cfg_id_mapping_method                                   BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID_MAPPING_METHOD
#define bcmolt_gpon_iwf_ds_ingress_flow_cfg_id_mapping_tag                                      BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID_MAPPING_TAG
#define bcmolt_gpon_iwf_ds_ingress_flow_cfg_id_vlan_action                                      BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID_VLAN_ACTION
#define bcmolt_gpon_iwf_ds_ingress_flow_cfg_id__num_of                                          BCMOLT_GPON_IWF_DS_INGRESS_FLOW_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_key_id_pon_ni                                                 BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID_PON_NI
#define bcmolt_gpon_iwf_mac_table_key_id_mac_address                                            BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID_MAC_ADDRESS
#define bcmolt_gpon_iwf_mac_table_key_id_vlan                                                   BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID_VLAN
#define bcmolt_gpon_iwf_mac_table_key_id__num_of                                                BCMOLT_GPON_IWF_MAC_TABLE_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_cfg_id_flow_id                                                BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_FLOW_ID
#define bcmolt_gpon_iwf_mac_table_cfg_id_stat                                                   BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_STAT
#define bcmolt_gpon_iwf_mac_table_cfg_id_gem_port_id                                            BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_GEM_PORT_ID
#define bcmolt_gpon_iwf_mac_table_cfg_id_onu_id                                                 BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID_ONU_ID
#define bcmolt_gpon_iwf_mac_table_cfg_id__num_of                                                BCMOLT_GPON_IWF_MAC_TABLE_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_mac_aged_id__num_of                                           BCMOLT_GPON_IWF_MAC_TABLE_MAC_AGED_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_mac_dropped_id_flow_id                                        BCMOLT_GPON_IWF_MAC_TABLE_MAC_DROPPED_ID_FLOW_ID
#define bcmolt_gpon_iwf_mac_table_mac_dropped_id__num_of                                        BCMOLT_GPON_IWF_MAC_TABLE_MAC_DROPPED_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_mac_move_id_old_flow_id                                       BCMOLT_GPON_IWF_MAC_TABLE_MAC_MOVE_ID_OLD_FLOW_ID
#define bcmolt_gpon_iwf_mac_table_mac_move_id_new_flow_id                                       BCMOLT_GPON_IWF_MAC_TABLE_MAC_MOVE_ID_NEW_FLOW_ID
#define bcmolt_gpon_iwf_mac_table_mac_move_id__num_of                                           BCMOLT_GPON_IWF_MAC_TABLE_MAC_MOVE_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_new_mac_id_flow_id                                            BCMOLT_GPON_IWF_MAC_TABLE_NEW_MAC_ID_FLOW_ID
#define bcmolt_gpon_iwf_mac_table_new_mac_id__num_of                                            BCMOLT_GPON_IWF_MAC_TABLE_NEW_MAC_ID__NUM_OF
#define bcmolt_gpon_iwf_mac_table_auto_cfg_id_mac_aged                                          BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID_MAC_AGED
#define bcmolt_gpon_iwf_mac_table_auto_cfg_id_mac_dropped                                       BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID_MAC_DROPPED
#define bcmolt_gpon_iwf_mac_table_auto_cfg_id_mac_move                                          BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID_MAC_MOVE
#define bcmolt_gpon_iwf_mac_table_auto_cfg_id_new_mac                                           BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID_NEW_MAC
#define bcmolt_gpon_iwf_mac_table_auto_cfg_id__num_of                                           BCMOLT_GPON_IWF_MAC_TABLE_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_iwf_us_flow_key_id_pon_ni                                                   BCMOLT_GPON_IWF_US_FLOW_KEY_ID_PON_NI
#define bcmolt_gpon_iwf_us_flow_key_id_gem_port_id                                              BCMOLT_GPON_IWF_US_FLOW_KEY_ID_GEM_PORT_ID
#define bcmolt_gpon_iwf_us_flow_key_id__num_of                                                  BCMOLT_GPON_IWF_US_FLOW_KEY_ID__NUM_OF
#define bcmolt_gpon_iwf_us_flow_cfg_id_flow_id                                                  BCMOLT_GPON_IWF_US_FLOW_CFG_ID_FLOW_ID
#define bcmolt_gpon_iwf_us_flow_cfg_id_mac_learning                                             BCMOLT_GPON_IWF_US_FLOW_CFG_ID_MAC_LEARNING
#define bcmolt_gpon_iwf_us_flow_cfg_id_vlan_action                                              BCMOLT_GPON_IWF_US_FLOW_CFG_ID_VLAN_ACTION
#define bcmolt_gpon_iwf_us_flow_cfg_id_vlan_tag                                                 BCMOLT_GPON_IWF_US_FLOW_CFG_ID_VLAN_TAG
#define bcmolt_gpon_iwf_us_flow_cfg_id_tpid_index                                               BCMOLT_GPON_IWF_US_FLOW_CFG_ID_TPID_INDEX
#define bcmolt_gpon_iwf_us_flow_cfg_id__num_of                                                  BCMOLT_GPON_IWF_US_FLOW_CFG_ID__NUM_OF
#define bcmolt_gpon_ni_key_id_pon_ni                                                            BCMOLT_GPON_NI_KEY_ID_PON_NI
#define bcmolt_gpon_ni_key_id__num_of                                                           BCMOLT_GPON_NI_KEY_ID__NUM_OF
#define bcmolt_gpon_ni_cfg_id_pon_status                                                        BCMOLT_GPON_NI_CFG_ID_PON_STATUS
#define bcmolt_gpon_ni_cfg_id_available_bandwidth                                               BCMOLT_GPON_NI_CFG_ID_AVAILABLE_BANDWIDTH
#define bcmolt_gpon_ni_cfg_id_number_of_active_onus                                             BCMOLT_GPON_NI_CFG_ID_NUMBER_OF_ACTIVE_ONUS
#define bcmolt_gpon_ni_cfg_id_number_of_active_standby_onus                                     BCMOLT_GPON_NI_CFG_ID_NUMBER_OF_ACTIVE_STANDBY_ONUS
#define bcmolt_gpon_ni_cfg_id_prbs_status                                                       BCMOLT_GPON_NI_CFG_ID_PRBS_STATUS
#define bcmolt_gpon_ni_cfg_id_pon_distance                                                      BCMOLT_GPON_NI_CFG_ID_PON_DISTANCE
#define bcmolt_gpon_ni_cfg_id_ranging_window_size                                               BCMOLT_GPON_NI_CFG_ID_RANGING_WINDOW_SIZE
#define bcmolt_gpon_ni_cfg_id_preassigned_equalization_delay                                    BCMOLT_GPON_NI_CFG_ID_PREASSIGNED_EQUALIZATION_DELAY
#define bcmolt_gpon_ni_cfg_id_eqd_cycles_number                                                 BCMOLT_GPON_NI_CFG_ID_EQD_CYCLES_NUMBER
#define bcmolt_gpon_ni_cfg_id_power_level                                                       BCMOLT_GPON_NI_CFG_ID_POWER_LEVEL
#define bcmolt_gpon_ni_cfg_id_ds_fec_mode                                                       BCMOLT_GPON_NI_CFG_ID_DS_FEC_MODE
#define bcmolt_gpon_ni_cfg_id_drift_control                                                     BCMOLT_GPON_NI_CFG_ID_DRIFT_CONTROL
#define bcmolt_gpon_ni_cfg_id_ds_ber_reporting_interval                                         BCMOLT_GPON_NI_CFG_ID_DS_BER_REPORTING_INTERVAL
#define bcmolt_gpon_ni_cfg_id_los_alarm_threshold                                               BCMOLT_GPON_NI_CFG_ID_LOS_ALARM_THRESHOLD
#define bcmolt_gpon_ni_cfg_id_los_initial_value                                                 BCMOLT_GPON_NI_CFG_ID_LOS_INITIAL_VALUE
#define bcmolt_gpon_ni_cfg_id_onu_alarms_thresholds                                             BCMOLT_GPON_NI_CFG_ID_ONU_ALARMS_THRESHOLDS
#define bcmolt_gpon_ni_cfg_id_ber_monitor                                                       BCMOLT_GPON_NI_CFG_ID_BER_MONITOR
#define bcmolt_gpon_ni_cfg_id_ploam_ack_timeout                                                 BCMOLT_GPON_NI_CFG_ID_PLOAM_ACK_TIMEOUT
#define bcmolt_gpon_ni_cfg_id_onu_activation                                                    BCMOLT_GPON_NI_CFG_ID_ONU_ACTIVATION
#define bcmolt_gpon_ni_cfg_id_sn_acquisition                                                    BCMOLT_GPON_NI_CFG_ID_SN_ACQUISITION
#define bcmolt_gpon_ni_cfg_id_key_exchange                                                      BCMOLT_GPON_NI_CFG_ID_KEY_EXCHANGE
#define bcmolt_gpon_ni_cfg_id_protection_switching                                              BCMOLT_GPON_NI_CFG_ID_PROTECTION_SWITCHING
#define bcmolt_gpon_ni_cfg_id_cbr_rt_allocation_profile                                         BCMOLT_GPON_NI_CFG_ID_CBR_RT_ALLOCATION_PROFILE
#define bcmolt_gpon_ni_cfg_id_cbr_nrt_allocation_profile                                        BCMOLT_GPON_NI_CFG_ID_CBR_NRT_ALLOCATION_PROFILE
#define bcmolt_gpon_ni_cfg_id_dba                                                               BCMOLT_GPON_NI_CFG_ID_DBA
#define bcmolt_gpon_ni_cfg_id_power_management                                                  BCMOLT_GPON_NI_CFG_ID_POWER_MANAGEMENT
#define bcmolt_gpon_ni_cfg_id_rogue_onu_detection_process                                       BCMOLT_GPON_NI_CFG_ID_ROGUE_ONU_DETECTION_PROCESS
#define bcmolt_gpon_ni_cfg_id_periodic_standby_pon_monitoring                                   BCMOLT_GPON_NI_CFG_ID_PERIODIC_STANDBY_PON_MONITORING
#define bcmolt_gpon_ni_cfg_id_prbs_checker                                                      BCMOLT_GPON_NI_CFG_ID_PRBS_CHECKER
#define bcmolt_gpon_ni_cfg_id_prbs_generator                                                    BCMOLT_GPON_NI_CFG_ID_PRBS_GENERATOR
#define bcmolt_gpon_ni_cfg_id_min_data_alloc_id                                                 BCMOLT_GPON_NI_CFG_ID_MIN_DATA_ALLOC_ID
#define bcmolt_gpon_ni_cfg_id_automatic_onu_deactivation                                        BCMOLT_GPON_NI_CFG_ID_AUTOMATIC_ONU_DEACTIVATION
#define bcmolt_gpon_ni_cfg_id_us_bandwidth_limit                                                BCMOLT_GPON_NI_CFG_ID_US_BANDWIDTH_LIMIT
#define bcmolt_gpon_ni_cfg_id_all_onus                                                          BCMOLT_GPON_NI_CFG_ID_ALL_ONUS
#define bcmolt_gpon_ni_cfg_id_all_mcast_gem_ports                                               BCMOLT_GPON_NI_CFG_ID_ALL_MCAST_GEM_PORTS
#define bcmolt_gpon_ni_cfg_id_debug                                                             BCMOLT_GPON_NI_CFG_ID_DEBUG
#define bcmolt_gpon_ni_cfg_id_onu_upgrade_params                                                BCMOLT_GPON_NI_CFG_ID_ONU_UPGRADE_PARAMS
#define bcmolt_gpon_ni_cfg_id_ps_c_wait_before_deactivation_timeout                             BCMOLT_GPON_NI_CFG_ID_PS_C_WAIT_BEFORE_DEACTIVATION_TIMEOUT
#define bcmolt_gpon_ni_cfg_id_bip32_indication_control                                          BCMOLT_GPON_NI_CFG_ID_BIP32_INDICATION_CONTROL
#define bcmolt_gpon_ni_cfg_id__num_of                                                           BCMOLT_GPON_NI_CFG_ID__NUM_OF
#define bcmolt_gpon_ni_stat_id_fec_codewords                                                    BCMOLT_GPON_NI_STAT_ID_FEC_CODEWORDS
#define bcmolt_gpon_ni_stat_id_fec_codewords_uncorrected                                        BCMOLT_GPON_NI_STAT_ID_FEC_CODEWORDS_UNCORRECTED
#define bcmolt_gpon_ni_stat_id_bip8_bytes                                                       BCMOLT_GPON_NI_STAT_ID_BIP8_BYTES
#define bcmolt_gpon_ni_stat_id_bip8_errors                                                      BCMOLT_GPON_NI_STAT_ID_BIP8_ERRORS
#define bcmolt_gpon_ni_stat_id_rx_gem_packets                                                   BCMOLT_GPON_NI_STAT_ID_RX_GEM_PACKETS
#define bcmolt_gpon_ni_stat_id_rx_gem_dropped                                                   BCMOLT_GPON_NI_STAT_ID_RX_GEM_DROPPED
#define bcmolt_gpon_ni_stat_id_rx_gem_idle                                                      BCMOLT_GPON_NI_STAT_ID_RX_GEM_IDLE
#define bcmolt_gpon_ni_stat_id_rx_gem_corrected                                                 BCMOLT_GPON_NI_STAT_ID_RX_GEM_CORRECTED
#define bcmolt_gpon_ni_stat_id_rx_gem_illegal                                                   BCMOLT_GPON_NI_STAT_ID_RX_GEM_ILLEGAL
#define bcmolt_gpon_ni_stat_id_rx_allocations_valid                                             BCMOLT_GPON_NI_STAT_ID_RX_ALLOCATIONS_VALID
#define bcmolt_gpon_ni_stat_id_rx_allocations_invalid                                           BCMOLT_GPON_NI_STAT_ID_RX_ALLOCATIONS_INVALID
#define bcmolt_gpon_ni_stat_id_rx_allocations_disabled                                          BCMOLT_GPON_NI_STAT_ID_RX_ALLOCATIONS_DISABLED
#define bcmolt_gpon_ni_stat_id_rx_ploams                                                        BCMOLT_GPON_NI_STAT_ID_RX_PLOAMS
#define bcmolt_gpon_ni_stat_id_rx_ploams_non_idle                                               BCMOLT_GPON_NI_STAT_ID_RX_PLOAMS_NON_IDLE
#define bcmolt_gpon_ni_stat_id_rx_ploams_error                                                  BCMOLT_GPON_NI_STAT_ID_RX_PLOAMS_ERROR
#define bcmolt_gpon_ni_stat_id_rx_ploams_dropped                                                BCMOLT_GPON_NI_STAT_ID_RX_PLOAMS_DROPPED
#define bcmolt_gpon_ni_stat_id_rx_cpu                                                           BCMOLT_GPON_NI_STAT_ID_RX_CPU
#define bcmolt_gpon_ni_stat_id_rx_omci                                                          BCMOLT_GPON_NI_STAT_ID_RX_OMCI
#define bcmolt_gpon_ni_stat_id_rx_omci_packets_crc_error                                        BCMOLT_GPON_NI_STAT_ID_RX_OMCI_PACKETS_CRC_ERROR
#define bcmolt_gpon_ni_stat_id_rx_dropped_too_short                                             BCMOLT_GPON_NI_STAT_ID_RX_DROPPED_TOO_SHORT
#define bcmolt_gpon_ni_stat_id_rx_dropped_too_long                                              BCMOLT_GPON_NI_STAT_ID_RX_DROPPED_TOO_LONG
#define bcmolt_gpon_ni_stat_id_rx_crc_errors                                                    BCMOLT_GPON_NI_STAT_ID_RX_CRC_ERRORS
#define bcmolt_gpon_ni_stat_id_rx_key_errors                                                    BCMOLT_GPON_NI_STAT_ID_RX_KEY_ERRORS
#define bcmolt_gpon_ni_stat_id_rx_fragments_errors                                              BCMOLT_GPON_NI_STAT_ID_RX_FRAGMENTS_ERRORS
#define bcmolt_gpon_ni_stat_id_rx_packets_dropped                                               BCMOLT_GPON_NI_STAT_ID_RX_PACKETS_DROPPED
#define bcmolt_gpon_ni_stat_id_tx_gem                                                           BCMOLT_GPON_NI_STAT_ID_TX_GEM
#define bcmolt_gpon_ni_stat_id_tx_ploams                                                        BCMOLT_GPON_NI_STAT_ID_TX_PLOAMS
#define bcmolt_gpon_ni_stat_id_tx_gem_fragments                                                 BCMOLT_GPON_NI_STAT_ID_TX_GEM_FRAGMENTS
#define bcmolt_gpon_ni_stat_id_tx_cpu                                                           BCMOLT_GPON_NI_STAT_ID_TX_CPU
#define bcmolt_gpon_ni_stat_id_tx_omci                                                          BCMOLT_GPON_NI_STAT_ID_TX_OMCI
#define bcmolt_gpon_ni_stat_id_tx_cpu_omci_packets_dropped                                      BCMOLT_GPON_NI_STAT_ID_TX_CPU_OMCI_PACKETS_DROPPED
#define bcmolt_gpon_ni_stat_id_tx_dropped_illegal_length                                        BCMOLT_GPON_NI_STAT_ID_TX_DROPPED_ILLEGAL_LENGTH
#define bcmolt_gpon_ni_stat_id_tx_dropped_tpid_miss                                             BCMOLT_GPON_NI_STAT_ID_TX_DROPPED_TPID_MISS
#define bcmolt_gpon_ni_stat_id_tx_dropped_vid_miss                                              BCMOLT_GPON_NI_STAT_ID_TX_DROPPED_VID_MISS
#define bcmolt_gpon_ni_stat_id__num_of                                                          BCMOLT_GPON_NI_STAT_ID__NUM_OF
#define bcmolt_gpon_ni_stat_cfg_id_cfg                                                          BCMOLT_GPON_NI_STAT_CFG_ID_CFG
#define bcmolt_gpon_ni_stat_cfg_id__num_of                                                      BCMOLT_GPON_NI_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_ni_activate_all_onus_completed_id__num_of                                   BCMOLT_GPON_NI_ACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_cpu_packets_failure_id_error                                             BCMOLT_GPON_NI_CPU_PACKETS_FAILURE_ID_ERROR
#define bcmolt_gpon_ni_cpu_packets_failure_id_gem_port_id                                       BCMOLT_GPON_NI_CPU_PACKETS_FAILURE_ID_GEM_PORT_ID
#define bcmolt_gpon_ni_cpu_packets_failure_id__num_of                                           BCMOLT_GPON_NI_CPU_PACKETS_FAILURE_ID__NUM_OF
#define bcmolt_gpon_ni_deactivate_all_onus_completed_id__num_of                                 BCMOLT_GPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_disable_all_onus_completed_id__num_of                                    BCMOLT_GPON_NI_DISABLE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_enable_all_onus_completed_id__num_of                                     BCMOLT_GPON_NI_ENABLE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_los_id_status                                                            BCMOLT_GPON_NI_LOS_ID_STATUS
#define bcmolt_gpon_ni_los_id__num_of                                                           BCMOLT_GPON_NI_LOS_ID__NUM_OF
#define bcmolt_gpon_ni_onu_discovered_id_serial_number                                          BCMOLT_GPON_NI_ONU_DISCOVERED_ID_SERIAL_NUMBER
#define bcmolt_gpon_ni_onu_discovered_id_ranging_time                                           BCMOLT_GPON_NI_ONU_DISCOVERED_ID_RANGING_TIME
#define bcmolt_gpon_ni_onu_discovered_id_onu_id                                                 BCMOLT_GPON_NI_ONU_DISCOVERED_ID_ONU_ID
#define bcmolt_gpon_ni_onu_discovered_id__num_of                                                BCMOLT_GPON_NI_ONU_DISCOVERED_ID__NUM_OF
#define bcmolt_gpon_ni_onu_upgrade_complete_id_status                                           BCMOLT_GPON_NI_ONU_UPGRADE_COMPLETE_ID_STATUS
#define bcmolt_gpon_ni_onu_upgrade_complete_id_list_of_failed_entities                          BCMOLT_GPON_NI_ONU_UPGRADE_COMPLETE_ID_LIST_OF_FAILED_ENTITIES
#define bcmolt_gpon_ni_onu_upgrade_complete_id__num_of                                          BCMOLT_GPON_NI_ONU_UPGRADE_COMPLETE_ID__NUM_OF
#define bcmolt_gpon_ni_protection_switching_onus_ranged_id_onus                                 BCMOLT_GPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID_ONUS
#define bcmolt_gpon_ni_protection_switching_onus_ranged_id__num_of                              BCMOLT_GPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID__NUM_OF
#define bcmolt_gpon_ni_protection_switching_switchover_completed_id_result                      BCMOLT_GPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID_RESULT
#define bcmolt_gpon_ni_protection_switching_switchover_completed_id__num_of                     BCMOLT_GPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_protection_switching_traffic_resume_id_result                            BCMOLT_GPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID_RESULT
#define bcmolt_gpon_ni_protection_switching_traffic_resume_id__num_of                           BCMOLT_GPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID__NUM_OF
#define bcmolt_gpon_ni_rogue_detection_completed_id_window_type                                 BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_WINDOW_TYPE
#define bcmolt_gpon_ni_rogue_detection_completed_id_measurement_status                          BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_MEASUREMENT_STATUS
#define bcmolt_gpon_ni_rogue_detection_completed_id_alloc_id                                    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_ALLOC_ID
#define bcmolt_gpon_ni_rogue_detection_completed_id_onu_id                                      BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_ONU_ID
#define bcmolt_gpon_ni_rogue_detection_completed_id_is_delineation                              BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_IS_DELINEATION
#define bcmolt_gpon_ni_rogue_detection_completed_id_is_ed                                       BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_IS_ED
#define bcmolt_gpon_ni_rogue_detection_completed_id_rx_data                                     BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_RX_DATA
#define bcmolt_gpon_ni_rogue_detection_completed_id_ploam_received_onu_id                       BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_PLOAM_RECEIVED_ONU_ID
#define bcmolt_gpon_ni_rogue_detection_completed_id_ploam_received_crc_error                    BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID_PLOAM_RECEIVED_CRC_ERROR
#define bcmolt_gpon_ni_rogue_detection_completed_id__num_of                                     BCMOLT_GPON_NI_ROGUE_DETECTION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_rogue_onu_special_map_cycle_start_id__num_of                             BCMOLT_GPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START_ID__NUM_OF
#define bcmolt_gpon_ni_serial_number_acquisition_cycle_start_id__num_of                         BCMOLT_GPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START_ID__NUM_OF
#define bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id_number_of_detected_delimiter   BCMOLT_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID_NUMBER_OF_DETECTED_DELIMITER
#define bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id_energy_detect_signal           BCMOLT_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID_ENERGY_DETECT_SIGNAL
#define bcmolt_gpon_ni_standby_pon_monitoring_cycle_completed_id__num_of                        BCMOLT_GPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_stat_alarm_cleared_id_stat                                               BCMOLT_GPON_NI_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_gpon_ni_stat_alarm_cleared_id__num_of                                            BCMOLT_GPON_NI_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_ni_stat_alarm_raised_id_stat                                                BCMOLT_GPON_NI_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_gpon_ni_stat_alarm_raised_id__num_of                                             BCMOLT_GPON_NI_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_ni_state_change_completed_id_result                                         BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID_RESULT
#define bcmolt_gpon_ni_state_change_completed_id_previous_state                                 BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID_PREVIOUS_STATE
#define bcmolt_gpon_ni_state_change_completed_id_new_state                                      BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID_NEW_STATE
#define bcmolt_gpon_ni_state_change_completed_id__num_of                                        BCMOLT_GPON_NI_STATE_CHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_tod_request_completed_id_tod_string                                      BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_TOD_STRING
#define bcmolt_gpon_ni_tod_request_completed_id_sfc                                             BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_SFC
#define bcmolt_gpon_ni_tod_request_completed_id_rtc_offset_sec                                  BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_RTC_OFFSET_SEC
#define bcmolt_gpon_ni_tod_request_completed_id_rtc_offset_nsec                                 BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_RTC_OFFSET_NSEC
#define bcmolt_gpon_ni_tod_request_completed_id_status                                          BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID_STATUS
#define bcmolt_gpon_ni_tod_request_completed_id__num_of                                         BCMOLT_GPON_NI_TOD_REQUEST_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_ni_auto_cfg_id_activate_all_onus_completed                                  BCMOLT_GPON_NI_AUTO_CFG_ID_ACTIVATE_ALL_ONUS_COMPLETED
#define bcmolt_gpon_ni_auto_cfg_id_cpu_packets_failure                                          BCMOLT_GPON_NI_AUTO_CFG_ID_CPU_PACKETS_FAILURE
#define bcmolt_gpon_ni_auto_cfg_id_deactivate_all_onus_completed                                BCMOLT_GPON_NI_AUTO_CFG_ID_DEACTIVATE_ALL_ONUS_COMPLETED
#define bcmolt_gpon_ni_auto_cfg_id_disable_all_onus_completed                                   BCMOLT_GPON_NI_AUTO_CFG_ID_DISABLE_ALL_ONUS_COMPLETED
#define bcmolt_gpon_ni_auto_cfg_id_enable_all_onus_completed                                    BCMOLT_GPON_NI_AUTO_CFG_ID_ENABLE_ALL_ONUS_COMPLETED
#define bcmolt_gpon_ni_auto_cfg_id_los                                                          BCMOLT_GPON_NI_AUTO_CFG_ID_LOS
#define bcmolt_gpon_ni_auto_cfg_id_onu_discovered                                               BCMOLT_GPON_NI_AUTO_CFG_ID_ONU_DISCOVERED
#define bcmolt_gpon_ni_auto_cfg_id_onu_upgrade_complete                                         BCMOLT_GPON_NI_AUTO_CFG_ID_ONU_UPGRADE_COMPLETE
#define bcmolt_gpon_ni_auto_cfg_id_protection_switching_onus_ranged                             BCMOLT_GPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_ONUS_RANGED
#define bcmolt_gpon_ni_auto_cfg_id_protection_switching_switchover_completed                    BCMOLT_GPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED
#define bcmolt_gpon_ni_auto_cfg_id_protection_switching_traffic_resume                          BCMOLT_GPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_TRAFFIC_RESUME
#define bcmolt_gpon_ni_auto_cfg_id_rogue_detection_completed                                    BCMOLT_GPON_NI_AUTO_CFG_ID_ROGUE_DETECTION_COMPLETED
#define bcmolt_gpon_ni_auto_cfg_id_rogue_onu_special_map_cycle_start                            BCMOLT_GPON_NI_AUTO_CFG_ID_ROGUE_ONU_SPECIAL_MAP_CYCLE_START
#define bcmolt_gpon_ni_auto_cfg_id_serial_number_acquisition_cycle_start                        BCMOLT_GPON_NI_AUTO_CFG_ID_SERIAL_NUMBER_ACQUISITION_CYCLE_START
#define bcmolt_gpon_ni_auto_cfg_id_standby_pon_monitoring_cycle_completed                       BCMOLT_GPON_NI_AUTO_CFG_ID_STANDBY_PON_MONITORING_CYCLE_COMPLETED
#define bcmolt_gpon_ni_auto_cfg_id_stat_alarm_cleared                                           BCMOLT_GPON_NI_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_ni_auto_cfg_id_stat_alarm_raised                                            BCMOLT_GPON_NI_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_ni_auto_cfg_id_state_change_completed                                       BCMOLT_GPON_NI_AUTO_CFG_ID_STATE_CHANGE_COMPLETED
#define bcmolt_gpon_ni_auto_cfg_id_tod_request_completed                                        BCMOLT_GPON_NI_AUTO_CFG_ID_TOD_REQUEST_COMPLETED
#define bcmolt_gpon_ni_auto_cfg_id__num_of                                                      BCMOLT_GPON_NI_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_ni_disable_serial_number_id_control                                         BCMOLT_GPON_NI_DISABLE_SERIAL_NUMBER_ID_CONTROL
#define bcmolt_gpon_ni_disable_serial_number_id_serial_number                                   BCMOLT_GPON_NI_DISABLE_SERIAL_NUMBER_ID_SERIAL_NUMBER
#define bcmolt_gpon_ni_disable_serial_number_id__num_of                                         BCMOLT_GPON_NI_DISABLE_SERIAL_NUMBER_ID__NUM_OF
#define bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id_onu_state          BCMOLT_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE_ID_ONU_STATE
#define bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id_onu_list           BCMOLT_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE_ID_ONU_LIST
#define bcmolt_gpon_ni_protection_switching_type_c_set_multiple_onu_state_id__num_of            BCMOLT_GPON_NI_PROTECTION_SWITCHING_TYPE_C_SET_MULTIPLE_ONU_STATE_ID__NUM_OF
#define bcmolt_gpon_ni_reset_id__num_of                                                         BCMOLT_GPON_NI_RESET_ID__NUM_OF
#define bcmolt_gpon_ni_rogue_detection_window_id_window_type                                    BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID_WINDOW_TYPE
#define bcmolt_gpon_ni_rogue_detection_window_id_alloc_id                                       BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID_ALLOC_ID
#define bcmolt_gpon_ni_rogue_detection_window_id_onu_id                                         BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID_ONU_ID
#define bcmolt_gpon_ni_rogue_detection_window_id_second_ranging_window                          BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID_SECOND_RANGING_WINDOW
#define bcmolt_gpon_ni_rogue_detection_window_id__num_of                                        BCMOLT_GPON_NI_ROGUE_DETECTION_WINDOW_ID__NUM_OF
#define bcmolt_gpon_ni_set_onu_state_id_onu_state                                               BCMOLT_GPON_NI_SET_ONU_STATE_ID_ONU_STATE
#define bcmolt_gpon_ni_set_onu_state_id__num_of                                                 BCMOLT_GPON_NI_SET_ONU_STATE_ID__NUM_OF
#define bcmolt_gpon_ni_set_pon_state_id_pon_state                                               BCMOLT_GPON_NI_SET_PON_STATE_ID_PON_STATE
#define bcmolt_gpon_ni_set_pon_state_id__num_of                                                 BCMOLT_GPON_NI_SET_PON_STATE_ID__NUM_OF
#define bcmolt_gpon_ni_single_request_standby_pon_monitoring_id__num_of                         BCMOLT_GPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING_ID__NUM_OF
#define bcmolt_gpon_ni_start_onu_upgrade_id_list_of_onu_ids                                     BCMOLT_GPON_NI_START_ONU_UPGRADE_ID_LIST_OF_ONU_IDS
#define bcmolt_gpon_ni_start_onu_upgrade_id__num_of                                             BCMOLT_GPON_NI_START_ONU_UPGRADE_ID__NUM_OF
#define bcmolt_gpon_ni_tod_request_id__num_of                                                   BCMOLT_GPON_NI_TOD_REQUEST_ID__NUM_OF
#define bcmolt_gpon_ni_broadcast_ploam_packet_id_ploam                                          BCMOLT_GPON_NI_BROADCAST_PLOAM_PACKET_ID_PLOAM
#define bcmolt_gpon_ni_broadcast_ploam_packet_id__num_of                                        BCMOLT_GPON_NI_BROADCAST_PLOAM_PACKET_ID__NUM_OF
#define bcmolt_gpon_ni_cpu_packets_id_packet_type                                               BCMOLT_GPON_NI_CPU_PACKETS_ID_PACKET_TYPE
#define bcmolt_gpon_ni_cpu_packets_id_calc_crc                                                  BCMOLT_GPON_NI_CPU_PACKETS_ID_CALC_CRC
#define bcmolt_gpon_ni_cpu_packets_id_gem_port_list                                             BCMOLT_GPON_NI_CPU_PACKETS_ID_GEM_PORT_LIST
#define bcmolt_gpon_ni_cpu_packets_id_buffer                                                    BCMOLT_GPON_NI_CPU_PACKETS_ID_BUFFER
#define bcmolt_gpon_ni_cpu_packets_id__num_of                                                   BCMOLT_GPON_NI_CPU_PACKETS_ID__NUM_OF
#define bcmolt_gpon_onu_key_id_pon_ni                                                           BCMOLT_GPON_ONU_KEY_ID_PON_NI
#define bcmolt_gpon_onu_key_id_onu_id                                                           BCMOLT_GPON_ONU_KEY_ID_ONU_ID
#define bcmolt_gpon_onu_key_id__num_of                                                          BCMOLT_GPON_ONU_KEY_ID__NUM_OF
#define bcmolt_gpon_onu_cfg_id_onu_state                                                        BCMOLT_GPON_ONU_CFG_ID_ONU_STATE
#define bcmolt_gpon_onu_cfg_id_serial_number                                                    BCMOLT_GPON_ONU_CFG_ID_SERIAL_NUMBER
#define bcmolt_gpon_onu_cfg_id_password                                                         BCMOLT_GPON_ONU_CFG_ID_PASSWORD
#define bcmolt_gpon_onu_cfg_id_auto_password_learning                                           BCMOLT_GPON_ONU_CFG_ID_AUTO_PASSWORD_LEARNING
#define bcmolt_gpon_onu_cfg_id_us_fec                                                           BCMOLT_GPON_ONU_CFG_ID_US_FEC
#define bcmolt_gpon_onu_cfg_id_omci_port_id                                                     BCMOLT_GPON_ONU_CFG_ID_OMCI_PORT_ID
#define bcmolt_gpon_onu_cfg_id_ds_ber_reporting_interval                                        BCMOLT_GPON_ONU_CFG_ID_DS_BER_REPORTING_INTERVAL
#define bcmolt_gpon_onu_cfg_id_aes_encryption_key                                               BCMOLT_GPON_ONU_CFG_ID_AES_ENCRYPTION_KEY
#define bcmolt_gpon_onu_cfg_id_alarm_state                                                      BCMOLT_GPON_ONU_CFG_ID_ALARM_STATE
#define bcmolt_gpon_onu_cfg_id_ranging_time                                                     BCMOLT_GPON_ONU_CFG_ID_RANGING_TIME
#define bcmolt_gpon_onu_cfg_id_disabled_after_discovery                                         BCMOLT_GPON_ONU_CFG_ID_DISABLED_AFTER_DISCOVERY
#define bcmolt_gpon_onu_cfg_id_deactivation_reason                                              BCMOLT_GPON_ONU_CFG_ID_DEACTIVATION_REASON
#define bcmolt_gpon_onu_cfg_id_all_gem_ports                                                    BCMOLT_GPON_ONU_CFG_ID_ALL_GEM_PORTS
#define bcmolt_gpon_onu_cfg_id_all_allocs                                                       BCMOLT_GPON_ONU_CFG_ID_ALL_ALLOCS
#define bcmolt_gpon_onu_cfg_id_onu_ps_type_c                                                    BCMOLT_GPON_ONU_CFG_ID_ONU_PS_TYPE_C
#define bcmolt_gpon_onu_cfg_id_extended_guard_time                                              BCMOLT_GPON_ONU_CFG_ID_EXTENDED_GUARD_TIME
#define bcmolt_gpon_onu_cfg_id__num_of                                                          BCMOLT_GPON_ONU_CFG_ID__NUM_OF
#define bcmolt_gpon_onu_stat_id_fec_codewords                                                   BCMOLT_GPON_ONU_STAT_ID_FEC_CODEWORDS
#define bcmolt_gpon_onu_stat_id_fec_bytes_corrected                                             BCMOLT_GPON_ONU_STAT_ID_FEC_BYTES_CORRECTED
#define bcmolt_gpon_onu_stat_id_fec_codewords_corrected                                         BCMOLT_GPON_ONU_STAT_ID_FEC_CODEWORDS_CORRECTED
#define bcmolt_gpon_onu_stat_id_fec_codewords_uncorrected                                       BCMOLT_GPON_ONU_STAT_ID_FEC_CODEWORDS_UNCORRECTED
#define bcmolt_gpon_onu_stat_id_bip8_bytes                                                      BCMOLT_GPON_ONU_STAT_ID_BIP8_BYTES
#define bcmolt_gpon_onu_stat_id_bip8_errors                                                     BCMOLT_GPON_ONU_STAT_ID_BIP8_ERRORS
#define bcmolt_gpon_onu_stat_id_rx_ploams_crc_error                                             BCMOLT_GPON_ONU_STAT_ID_RX_PLOAMS_CRC_ERROR
#define bcmolt_gpon_onu_stat_id_rx_ploams_non_idle                                              BCMOLT_GPON_ONU_STAT_ID_RX_PLOAMS_NON_IDLE
#define bcmolt_gpon_onu_stat_id_positive_drift                                                  BCMOLT_GPON_ONU_STAT_ID_POSITIVE_DRIFT
#define bcmolt_gpon_onu_stat_id_negative_drift                                                  BCMOLT_GPON_ONU_STAT_ID_NEGATIVE_DRIFT
#define bcmolt_gpon_onu_stat_id_rx_omci                                                         BCMOLT_GPON_ONU_STAT_ID_RX_OMCI
#define bcmolt_gpon_onu_stat_id_rx_omci_packets_crc_error                                       BCMOLT_GPON_ONU_STAT_ID_RX_OMCI_PACKETS_CRC_ERROR
#define bcmolt_gpon_onu_stat_id_ber_reported                                                    BCMOLT_GPON_ONU_STAT_ID_BER_REPORTED
#define bcmolt_gpon_onu_stat_id_unreceived_burst                                                BCMOLT_GPON_ONU_STAT_ID_UNRECEIVED_BURST
#define bcmolt_gpon_onu_stat_id_lcdg_errors                                                     BCMOLT_GPON_ONU_STAT_ID_LCDG_ERRORS
#define bcmolt_gpon_onu_stat_id_rdi_errors                                                      BCMOLT_GPON_ONU_STAT_ID_RDI_ERRORS
#define bcmolt_gpon_onu_stat_id_rx_bytes                                                        BCMOLT_GPON_ONU_STAT_ID_RX_BYTES
#define bcmolt_gpon_onu_stat_id_rx_packets                                                      BCMOLT_GPON_ONU_STAT_ID_RX_PACKETS
#define bcmolt_gpon_onu_stat_id_tx_bytes                                                        BCMOLT_GPON_ONU_STAT_ID_TX_BYTES
#define bcmolt_gpon_onu_stat_id_tx_packets                                                      BCMOLT_GPON_ONU_STAT_ID_TX_PACKETS
#define bcmolt_gpon_onu_stat_id__num_of                                                         BCMOLT_GPON_ONU_STAT_ID__NUM_OF
#define bcmolt_gpon_onu_stat_cfg_id_cfg                                                         BCMOLT_GPON_ONU_STAT_CFG_ID_CFG
#define bcmolt_gpon_onu_stat_cfg_id__num_of                                                     BCMOLT_GPON_ONU_STAT_CFG_ID__NUM_OF
#define bcmolt_gpon_onu_ber_interval_configuration_completed_id_ber_interval                    BCMOLT_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED_ID_BER_INTERVAL
#define bcmolt_gpon_onu_ber_interval_configuration_completed_id_result                          BCMOLT_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED_ID_RESULT
#define bcmolt_gpon_onu_ber_interval_configuration_completed_id__num_of                         BCMOLT_GPON_ONU_BER_INTERVAL_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_dfi_id_alarm_status                                                     BCMOLT_GPON_ONU_DFI_ID_ALARM_STATUS
#define bcmolt_gpon_onu_dfi_id__num_of                                                          BCMOLT_GPON_ONU_DFI_ID__NUM_OF
#define bcmolt_gpon_onu_dgi_id_alarm_status                                                     BCMOLT_GPON_ONU_DGI_ID_ALARM_STATUS
#define bcmolt_gpon_onu_dgi_id__num_of                                                          BCMOLT_GPON_ONU_DGI_ID__NUM_OF
#define bcmolt_gpon_onu_dowi_id_alarm_status                                                    BCMOLT_GPON_ONU_DOWI_ID_ALARM_STATUS
#define bcmolt_gpon_onu_dowi_id_drift_value                                                     BCMOLT_GPON_ONU_DOWI_ID_DRIFT_VALUE
#define bcmolt_gpon_onu_dowi_id_new_eqd                                                         BCMOLT_GPON_ONU_DOWI_ID_NEW_EQD
#define bcmolt_gpon_onu_dowi_id__num_of                                                         BCMOLT_GPON_ONU_DOWI_ID__NUM_OF
#define bcmolt_gpon_onu_err_id_bip8_errors                                                      BCMOLT_GPON_ONU_ERR_ID_BIP8_ERRORS
#define bcmolt_gpon_onu_err_id__num_of                                                          BCMOLT_GPON_ONU_ERR_ID__NUM_OF
#define bcmolt_gpon_onu_invalid_dbru_report_id_alloc_id                                         BCMOLT_GPON_ONU_INVALID_DBRU_REPORT_ID_ALLOC_ID
#define bcmolt_gpon_onu_invalid_dbru_report_id__num_of                                          BCMOLT_GPON_ONU_INVALID_DBRU_REPORT_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_completed_id_new_key                                       BCMOLT_GPON_ONU_KEY_EXCHANGE_COMPLETED_ID_NEW_KEY
#define bcmolt_gpon_onu_key_exchange_completed_id__num_of                                       BCMOLT_GPON_ONU_KEY_EXCHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_cycle_skipped_id__num_of                                   BCMOLT_GPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_decrypt_required_id_new_key                                BCMOLT_GPON_ONU_KEY_EXCHANGE_DECRYPT_REQUIRED_ID_NEW_KEY
#define bcmolt_gpon_onu_key_exchange_decrypt_required_id__num_of                                BCMOLT_GPON_ONU_KEY_EXCHANGE_DECRYPT_REQUIRED_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_key_mismatch_id_expected_key                               BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID_EXPECTED_KEY
#define bcmolt_gpon_onu_key_exchange_key_mismatch_id_received_key                               BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID_RECEIVED_KEY
#define bcmolt_gpon_onu_key_exchange_key_mismatch_id__num_of                                    BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_key_request_timeout_id__num_of                             BCMOLT_GPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT_ID__NUM_OF
#define bcmolt_gpon_onu_key_exchange_unconsecutive_index_id_expected_index                      BCMOLT_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX_ID_EXPECTED_INDEX
#define bcmolt_gpon_onu_key_exchange_unconsecutive_index_id_actual_index                        BCMOLT_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX_ID_ACTUAL_INDEX
#define bcmolt_gpon_onu_key_exchange_unconsecutive_index_id__num_of                             BCMOLT_GPON_ONU_KEY_EXCHANGE_UNCONSECUTIVE_INDEX_ID__NUM_OF
#define bcmolt_gpon_onu_loai_id_alarm_status                                                    BCMOLT_GPON_ONU_LOAI_ID_ALARM_STATUS
#define bcmolt_gpon_onu_loai_id__num_of                                                         BCMOLT_GPON_ONU_LOAI_ID__NUM_OF
#define bcmolt_gpon_onu_loki_id_alarm_status                                                    BCMOLT_GPON_ONU_LOKI_ID_ALARM_STATUS
#define bcmolt_gpon_onu_loki_id__num_of                                                         BCMOLT_GPON_ONU_LOKI_ID__NUM_OF
#define bcmolt_gpon_onu_memi_id_ploam_buffer                                                    BCMOLT_GPON_ONU_MEMI_ID_PLOAM_BUFFER
#define bcmolt_gpon_onu_memi_id__num_of                                                         BCMOLT_GPON_ONU_MEMI_ID__NUM_OF
#define bcmolt_gpon_onu_omci_port_id_configuration_completed_id_gem_port                        BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID_GEM_PORT
#define bcmolt_gpon_onu_omci_port_id_configuration_completed_id_status                          BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID_STATUS
#define bcmolt_gpon_onu_omci_port_id_configuration_completed_id_operation                       BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID_OPERATION
#define bcmolt_gpon_onu_omci_port_id_configuration_completed_id__num_of                         BCMOLT_GPON_ONU_OMCI_PORT_ID_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_onu_activation_completed_id_status                                      BCMOLT_GPON_ONU_ONU_ACTIVATION_COMPLETED_ID_STATUS
#define bcmolt_gpon_onu_onu_activation_completed_id_fail_reason                                 BCMOLT_GPON_ONU_ONU_ACTIVATION_COMPLETED_ID_FAIL_REASON
#define bcmolt_gpon_onu_onu_activation_completed_id__num_of                                     BCMOLT_GPON_ONU_ONU_ACTIVATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_onu_activation_standby_completed_id_result                              BCMOLT_GPON_ONU_ONU_ACTIVATION_STANDBY_COMPLETED_ID_RESULT
#define bcmolt_gpon_onu_onu_activation_standby_completed_id__num_of                             BCMOLT_GPON_ONU_ONU_ACTIVATION_STANDBY_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_onu_alarm_id_onu_alarm                                                  BCMOLT_GPON_ONU_ONU_ALARM_ID_ONU_ALARM
#define bcmolt_gpon_onu_onu_alarm_id__num_of                                                    BCMOLT_GPON_ONU_ONU_ALARM_ID__NUM_OF
#define bcmolt_gpon_onu_onu_deactivation_completed_id_status                                    BCMOLT_GPON_ONU_ONU_DEACTIVATION_COMPLETED_ID_STATUS
#define bcmolt_gpon_onu_onu_deactivation_completed_id__num_of                                   BCMOLT_GPON_ONU_ONU_DEACTIVATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_onu_disable_completed_id_serial_number                                  BCMOLT_GPON_ONU_ONU_DISABLE_COMPLETED_ID_SERIAL_NUMBER
#define bcmolt_gpon_onu_onu_disable_completed_id__num_of                                        BCMOLT_GPON_ONU_ONU_DISABLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_onu_enable_completed_id_serial_number                                   BCMOLT_GPON_ONU_ONU_ENABLE_COMPLETED_ID_SERIAL_NUMBER
#define bcmolt_gpon_onu_onu_enable_completed_id__num_of                                         BCMOLT_GPON_ONU_ONU_ENABLE_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_optical_reflection_id__num_of                                           BCMOLT_GPON_ONU_OPTICAL_REFLECTION_ID__NUM_OF
#define bcmolt_gpon_onu_password_authentication_completed_id_status                             BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID_STATUS
#define bcmolt_gpon_onu_password_authentication_completed_id_fail_reason                        BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID_FAIL_REASON
#define bcmolt_gpon_onu_password_authentication_completed_id_password                           BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID_PASSWORD
#define bcmolt_gpon_onu_password_authentication_completed_id__num_of                            BCMOLT_GPON_ONU_PASSWORD_AUTHENTICATION_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_pee_id_alarm_status                                                     BCMOLT_GPON_ONU_PEE_ID_ALARM_STATUS
#define bcmolt_gpon_onu_pee_id__num_of                                                          BCMOLT_GPON_ONU_PEE_ID__NUM_OF
#define bcmolt_gpon_onu_possible_drift_id_alarm_status                                          BCMOLT_GPON_ONU_POSSIBLE_DRIFT_ID_ALARM_STATUS
#define bcmolt_gpon_onu_possible_drift_id_estimated_drift                                       BCMOLT_GPON_ONU_POSSIBLE_DRIFT_ID_ESTIMATED_DRIFT
#define bcmolt_gpon_onu_possible_drift_id__num_of                                               BCMOLT_GPON_ONU_POSSIBLE_DRIFT_ID__NUM_OF
#define bcmolt_gpon_onu_power_management_state_change_id_old_state                              BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_OLD_STATE
#define bcmolt_gpon_onu_power_management_state_change_id_new_state                              BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_NEW_STATE
#define bcmolt_gpon_onu_power_management_state_change_id_reason                                 BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_REASON
#define bcmolt_gpon_onu_power_management_state_change_id__num_of                                BCMOLT_GPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID__NUM_OF
#define bcmolt_gpon_onu_pst_id_link_number                                                      BCMOLT_GPON_ONU_PST_ID_LINK_NUMBER
#define bcmolt_gpon_onu_pst_id_k1                                                               BCMOLT_GPON_ONU_PST_ID_K1
#define bcmolt_gpon_onu_pst_id_k2                                                               BCMOLT_GPON_ONU_PST_ID_K2
#define bcmolt_gpon_onu_pst_id__num_of                                                          BCMOLT_GPON_ONU_PST_ID__NUM_OF
#define bcmolt_gpon_onu_ranging_completed_id_status                                             BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_STATUS
#define bcmolt_gpon_onu_ranging_completed_id_fail_reason                                        BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_FAIL_REASON
#define bcmolt_gpon_onu_ranging_completed_id_number_of_ploams                                   BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_NUMBER_OF_PLOAMS
#define bcmolt_gpon_onu_ranging_completed_id_eqd                                                BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_EQD
#define bcmolt_gpon_onu_ranging_completed_id_power_level                                        BCMOLT_GPON_ONU_RANGING_COMPLETED_ID_POWER_LEVEL
#define bcmolt_gpon_onu_ranging_completed_id__num_of                                            BCMOLT_GPON_ONU_RANGING_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_rei_id_bip8_errors                                                      BCMOLT_GPON_ONU_REI_ID_BIP8_ERRORS
#define bcmolt_gpon_onu_rei_id__num_of                                                          BCMOLT_GPON_ONU_REI_ID__NUM_OF
#define bcmolt_gpon_onu_rssi_measurement_completed_id_status                                    BCMOLT_GPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID_STATUS
#define bcmolt_gpon_onu_rssi_measurement_completed_id_fail_reason                               BCMOLT_GPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID_FAIL_REASON
#define bcmolt_gpon_onu_rssi_measurement_completed_id__num_of                                   BCMOLT_GPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID__NUM_OF
#define bcmolt_gpon_onu_sdi_id_alarm_status                                                     BCMOLT_GPON_ONU_SDI_ID_ALARM_STATUS
#define bcmolt_gpon_onu_sdi_id_ber                                                              BCMOLT_GPON_ONU_SDI_ID_BER
#define bcmolt_gpon_onu_sdi_id__num_of                                                          BCMOLT_GPON_ONU_SDI_ID__NUM_OF
#define bcmolt_gpon_onu_sfi_id_alarm_status                                                     BCMOLT_GPON_ONU_SFI_ID_ALARM_STATUS
#define bcmolt_gpon_onu_sfi_id_ber                                                              BCMOLT_GPON_ONU_SFI_ID_BER
#define bcmolt_gpon_onu_sfi_id__num_of                                                          BCMOLT_GPON_ONU_SFI_ID__NUM_OF
#define bcmolt_gpon_onu_stat_alarm_cleared_id_stat                                              BCMOLT_GPON_ONU_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_gpon_onu_stat_alarm_cleared_id__num_of                                           BCMOLT_GPON_ONU_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_gpon_onu_stat_alarm_raised_id_stat                                               BCMOLT_GPON_ONU_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_gpon_onu_stat_alarm_raised_id__num_of                                            BCMOLT_GPON_ONU_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_gpon_onu_sufi_id_alarm_status                                                    BCMOLT_GPON_ONU_SUFI_ID_ALARM_STATUS
#define bcmolt_gpon_onu_sufi_id__num_of                                                         BCMOLT_GPON_ONU_SUFI_ID__NUM_OF
#define bcmolt_gpon_onu_tiwi_id_alarm_status                                                    BCMOLT_GPON_ONU_TIWI_ID_ALARM_STATUS
#define bcmolt_gpon_onu_tiwi_id_drift_value                                                     BCMOLT_GPON_ONU_TIWI_ID_DRIFT_VALUE
#define bcmolt_gpon_onu_tiwi_id__num_of                                                         BCMOLT_GPON_ONU_TIWI_ID__NUM_OF
#define bcmolt_gpon_onu_auto_cfg_id_ber_interval_configuration_completed                        BCMOLT_GPON_ONU_AUTO_CFG_ID_BER_INTERVAL_CONFIGURATION_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_dfi                                                         BCMOLT_GPON_ONU_AUTO_CFG_ID_DFI
#define bcmolt_gpon_onu_auto_cfg_id_dgi                                                         BCMOLT_GPON_ONU_AUTO_CFG_ID_DGI
#define bcmolt_gpon_onu_auto_cfg_id_dowi                                                        BCMOLT_GPON_ONU_AUTO_CFG_ID_DOWI
#define bcmolt_gpon_onu_auto_cfg_id_err                                                         BCMOLT_GPON_ONU_AUTO_CFG_ID_ERR
#define bcmolt_gpon_onu_auto_cfg_id_invalid_dbru_report                                         BCMOLT_GPON_ONU_AUTO_CFG_ID_INVALID_DBRU_REPORT
#define bcmolt_gpon_onu_auto_cfg_id_key_exchange_completed                                      BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_key_exchange_cycle_skipped                                  BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_CYCLE_SKIPPED
#define bcmolt_gpon_onu_auto_cfg_id_key_exchange_decrypt_required                               BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_DECRYPT_REQUIRED
#define bcmolt_gpon_onu_auto_cfg_id_key_exchange_key_mismatch                                   BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_KEY_MISMATCH
#define bcmolt_gpon_onu_auto_cfg_id_key_exchange_key_request_timeout                            BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT
#define bcmolt_gpon_onu_auto_cfg_id_key_exchange_unconsecutive_index                            BCMOLT_GPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_UNCONSECUTIVE_INDEX
#define bcmolt_gpon_onu_auto_cfg_id_loai                                                        BCMOLT_GPON_ONU_AUTO_CFG_ID_LOAI
#define bcmolt_gpon_onu_auto_cfg_id_loki                                                        BCMOLT_GPON_ONU_AUTO_CFG_ID_LOKI
#define bcmolt_gpon_onu_auto_cfg_id_memi                                                        BCMOLT_GPON_ONU_AUTO_CFG_ID_MEMI
#define bcmolt_gpon_onu_auto_cfg_id_omci_port_id_configuration_completed                        BCMOLT_GPON_ONU_AUTO_CFG_ID_OMCI_PORT_ID_CONFIGURATION_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_onu_activation_completed                                    BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_ACTIVATION_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_onu_activation_standby_completed                            BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_ACTIVATION_STANDBY_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_onu_alarm                                                   BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_ALARM
#define bcmolt_gpon_onu_auto_cfg_id_onu_deactivation_completed                                  BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_DEACTIVATION_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_onu_disable_completed                                       BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_DISABLE_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_onu_enable_completed                                        BCMOLT_GPON_ONU_AUTO_CFG_ID_ONU_ENABLE_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_optical_reflection                                          BCMOLT_GPON_ONU_AUTO_CFG_ID_OPTICAL_REFLECTION
#define bcmolt_gpon_onu_auto_cfg_id_password_authentication_completed                           BCMOLT_GPON_ONU_AUTO_CFG_ID_PASSWORD_AUTHENTICATION_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_pee                                                         BCMOLT_GPON_ONU_AUTO_CFG_ID_PEE
#define bcmolt_gpon_onu_auto_cfg_id_possible_drift                                              BCMOLT_GPON_ONU_AUTO_CFG_ID_POSSIBLE_DRIFT
#define bcmolt_gpon_onu_auto_cfg_id_power_management_state_change                               BCMOLT_GPON_ONU_AUTO_CFG_ID_POWER_MANAGEMENT_STATE_CHANGE
#define bcmolt_gpon_onu_auto_cfg_id_pst                                                         BCMOLT_GPON_ONU_AUTO_CFG_ID_PST
#define bcmolt_gpon_onu_auto_cfg_id_ranging_completed                                           BCMOLT_GPON_ONU_AUTO_CFG_ID_RANGING_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_rei                                                         BCMOLT_GPON_ONU_AUTO_CFG_ID_REI
#define bcmolt_gpon_onu_auto_cfg_id_rssi_measurement_completed                                  BCMOLT_GPON_ONU_AUTO_CFG_ID_RSSI_MEASUREMENT_COMPLETED
#define bcmolt_gpon_onu_auto_cfg_id_sdi                                                         BCMOLT_GPON_ONU_AUTO_CFG_ID_SDI
#define bcmolt_gpon_onu_auto_cfg_id_sfi                                                         BCMOLT_GPON_ONU_AUTO_CFG_ID_SFI
#define bcmolt_gpon_onu_auto_cfg_id_stat_alarm_cleared                                          BCMOLT_GPON_ONU_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_gpon_onu_auto_cfg_id_stat_alarm_raised                                           BCMOLT_GPON_ONU_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_gpon_onu_auto_cfg_id_sufi                                                        BCMOLT_GPON_ONU_AUTO_CFG_ID_SUFI
#define bcmolt_gpon_onu_auto_cfg_id_tiwi                                                        BCMOLT_GPON_ONU_AUTO_CFG_ID_TIWI
#define bcmolt_gpon_onu_auto_cfg_id__num_of                                                     BCMOLT_GPON_ONU_AUTO_CFG_ID__NUM_OF
#define bcmolt_gpon_onu_change_power_level_id_power_level_action                                BCMOLT_GPON_ONU_CHANGE_POWER_LEVEL_ID_POWER_LEVEL_ACTION
#define bcmolt_gpon_onu_change_power_level_id__num_of                                           BCMOLT_GPON_ONU_CHANGE_POWER_LEVEL_ID__NUM_OF
#define bcmolt_gpon_onu_rssi_measurement_id__num_of                                             BCMOLT_GPON_ONU_RSSI_MEASUREMENT_ID__NUM_OF
#define bcmolt_gpon_onu_set_onu_state_id_onu_state                                              BCMOLT_GPON_ONU_SET_ONU_STATE_ID_ONU_STATE
#define bcmolt_gpon_onu_set_onu_state_id__num_of                                                BCMOLT_GPON_ONU_SET_ONU_STATE_ID__NUM_OF
#define bcmolt_gpon_onu_cpu_packets_id_packet_type                                              BCMOLT_GPON_ONU_CPU_PACKETS_ID_PACKET_TYPE
#define bcmolt_gpon_onu_cpu_packets_id_calc_crc                                                 BCMOLT_GPON_ONU_CPU_PACKETS_ID_CALC_CRC
#define bcmolt_gpon_onu_cpu_packets_id_number_of_packets                                        BCMOLT_GPON_ONU_CPU_PACKETS_ID_NUMBER_OF_PACKETS
#define bcmolt_gpon_onu_cpu_packets_id_packet_size                                              BCMOLT_GPON_ONU_CPU_PACKETS_ID_PACKET_SIZE
#define bcmolt_gpon_onu_cpu_packets_id_buffer                                                   BCMOLT_GPON_ONU_CPU_PACKETS_ID_BUFFER
#define bcmolt_gpon_onu_cpu_packets_id__num_of                                                  BCMOLT_GPON_ONU_CPU_PACKETS_ID__NUM_OF
#define bcmolt_gpon_onu_ploam_packet_id_ploam                                                   BCMOLT_GPON_ONU_PLOAM_PACKET_ID_PLOAM
#define bcmolt_gpon_onu_ploam_packet_id__num_of                                                 BCMOLT_GPON_ONU_PLOAM_PACKET_ID__NUM_OF
#define bcmolt_gpon_onu_cpu_packet_id_port_id                                                   BCMOLT_GPON_ONU_CPU_PACKET_ID_PORT_ID
#define bcmolt_gpon_onu_cpu_packet_id_crc_ok                                                    BCMOLT_GPON_ONU_CPU_PACKET_ID_CRC_OK
#define bcmolt_gpon_onu_cpu_packet_id_packet_size                                               BCMOLT_GPON_ONU_CPU_PACKET_ID_PACKET_SIZE
#define bcmolt_gpon_onu_cpu_packet_id_buffer                                                    BCMOLT_GPON_ONU_CPU_PACKET_ID_BUFFER
#define bcmolt_gpon_onu_cpu_packet_id__num_of                                                   BCMOLT_GPON_ONU_CPU_PACKET_ID__NUM_OF
#define bcmolt_gpon_onu_omci_packet_id_port_id                                                  BCMOLT_GPON_ONU_OMCI_PACKET_ID_PORT_ID
#define bcmolt_gpon_onu_omci_packet_id_crc_ok                                                   BCMOLT_GPON_ONU_OMCI_PACKET_ID_CRC_OK
#define bcmolt_gpon_onu_omci_packet_id_packet_size                                              BCMOLT_GPON_ONU_OMCI_PACKET_ID_PACKET_SIZE
#define bcmolt_gpon_onu_omci_packet_id_buffer                                                   BCMOLT_GPON_ONU_OMCI_PACKET_ID_BUFFER
#define bcmolt_gpon_onu_omci_packet_id__num_of                                                  BCMOLT_GPON_ONU_OMCI_PACKET_ID__NUM_OF
#define bcmolt_gpon_trx_key_id_pon_ni                                                           BCMOLT_GPON_TRX_KEY_ID_PON_NI
#define bcmolt_gpon_trx_key_id__num_of                                                          BCMOLT_GPON_TRX_KEY_ID__NUM_OF
#define bcmolt_gpon_trx_cfg_id_transceiver_type                                                 BCMOLT_GPON_TRX_CFG_ID_TRANSCEIVER_TYPE
#define bcmolt_gpon_trx_cfg_id_la_configuration                                                 BCMOLT_GPON_TRX_CFG_ID_LA_CONFIGURATION
#define bcmolt_gpon_trx_cfg_id_bcdr                                                             BCMOLT_GPON_TRX_CFG_ID_BCDR
#define bcmolt_gpon_trx_cfg_id_la_ranging_after_no_ed_resync                                    BCMOLT_GPON_TRX_CFG_ID_LA_RANGING_AFTER_NO_ED_RESYNC
#define bcmolt_gpon_trx_cfg_id_bcdr_ranging_after_no_ed_resync                                  BCMOLT_GPON_TRX_CFG_ID_BCDR_RANGING_AFTER_NO_ED_RESYNC
#define bcmolt_gpon_trx_cfg_id_la_ranging_after_ed_resync                                       BCMOLT_GPON_TRX_CFG_ID_LA_RANGING_AFTER_ED_RESYNC
#define bcmolt_gpon_trx_cfg_id_bcdr_ranging_after_ed_resync                                     BCMOLT_GPON_TRX_CFG_ID_BCDR_RANGING_AFTER_ED_RESYNC
#define bcmolt_gpon_trx_cfg_id_la_resync_polarity                                               BCMOLT_GPON_TRX_CFG_ID_LA_RESYNC_POLARITY
#define bcmolt_gpon_trx_cfg_id_bcdr_resync_polarity                                             BCMOLT_GPON_TRX_CFG_ID_BCDR_RESYNC_POLARITY
#define bcmolt_gpon_trx_cfg_id_bcdr_ranging_resync_conditions                                   BCMOLT_GPON_TRX_CFG_ID_BCDR_RANGING_RESYNC_CONDITIONS
#define bcmolt_gpon_trx_cfg_id_la_ranging_resync_conditions                                     BCMOLT_GPON_TRX_CFG_ID_LA_RANGING_RESYNC_CONDITIONS
#define bcmolt_gpon_trx_cfg_id_rx_configuration                                                 BCMOLT_GPON_TRX_CFG_ID_RX_CONFIGURATION
#define bcmolt_gpon_trx_cfg_id_ranging_control_stages_configuration                             BCMOLT_GPON_TRX_CFG_ID_RANGING_CONTROL_STAGES_CONFIGURATION
#define bcmolt_gpon_trx_cfg_id_energy_detect                                                    BCMOLT_GPON_TRX_CFG_ID_ENERGY_DETECT
#define bcmolt_gpon_trx_cfg_id_end_of_burst_data_pattern                                        BCMOLT_GPON_TRX_CFG_ID_END_OF_BURST_DATA_PATTERN
#define bcmolt_gpon_trx_cfg_id_end_of_burst_ranging_pattern                                     BCMOLT_GPON_TRX_CFG_ID_END_OF_BURST_RANGING_PATTERN
#define bcmolt_gpon_trx_cfg_id_preamble                                                         BCMOLT_GPON_TRX_CFG_ID_PREAMBLE
#define bcmolt_gpon_trx_cfg_id_delimiter                                                        BCMOLT_GPON_TRX_CFG_ID_DELIMITER
#define bcmolt_gpon_trx_cfg_id_guard_bits                                                       BCMOLT_GPON_TRX_CFG_ID_GUARD_BITS
#define bcmolt_gpon_trx_cfg_id_serdes_configuration                                             BCMOLT_GPON_TRX_CFG_ID_SERDES_CONFIGURATION
#define bcmolt_gpon_trx_cfg_id_plo_ranging                                                      BCMOLT_GPON_TRX_CFG_ID_PLO_RANGING
#define bcmolt_gpon_trx_cfg_id_plo_data                                                         BCMOLT_GPON_TRX_CFG_ID_PLO_DATA
#define bcmolt_gpon_trx_cfg_id_rssi_normal_config                                               BCMOLT_GPON_TRX_CFG_ID_RSSI_NORMAL_CONFIG
#define bcmolt_gpon_trx_cfg_id_ranging_rssi_resync_control                                      BCMOLT_GPON_TRX_CFG_ID_RANGING_RSSI_RESYNC_CONTROL
#define bcmolt_gpon_trx_cfg_id__num_of                                                          BCMOLT_GPON_TRX_CFG_ID__NUM_OF
#define bcmolt_log_entry_key_id_log_id                                                          BCMOLT_LOG_ENTRY_KEY_ID_LOG_ID
#define bcmolt_log_entry_key_id_reserved                                                        BCMOLT_LOG_ENTRY_KEY_ID_RESERVED
#define bcmolt_log_entry_key_id_name                                                            BCMOLT_LOG_ENTRY_KEY_ID_NAME
#define bcmolt_log_entry_key_id__num_of                                                         BCMOLT_LOG_ENTRY_KEY_ID__NUM_OF
#define bcmolt_log_entry_cfg_id_default_log_level                                               BCMOLT_LOG_ENTRY_CFG_ID_DEFAULT_LOG_LEVEL
#define bcmolt_log_entry_cfg_id_default_log_type                                                BCMOLT_LOG_ENTRY_CFG_ID_DEFAULT_LOG_TYPE
#define bcmolt_log_entry_cfg_id_log_level_print                                                 BCMOLT_LOG_ENTRY_CFG_ID_LOG_LEVEL_PRINT
#define bcmolt_log_entry_cfg_id_log_level_save                                                  BCMOLT_LOG_ENTRY_CFG_ID_LOG_LEVEL_SAVE
#define bcmolt_log_entry_cfg_id_log_type                                                        BCMOLT_LOG_ENTRY_CFG_ID_LOG_TYPE
#define bcmolt_log_entry_cfg_id_log_style                                                       BCMOLT_LOG_ENTRY_CFG_ID_LOG_STYLE
#define bcmolt_log_entry_cfg_id_log_name                                                        BCMOLT_LOG_ENTRY_CFG_ID_LOG_NAME
#define bcmolt_log_entry_cfg_id__num_of                                                         BCMOLT_LOG_ENTRY_CFG_ID__NUM_OF
#define bcmolt_log_entry_stat_id_msg_count                                                      BCMOLT_LOG_ENTRY_STAT_ID_MSG_COUNT
#define bcmolt_log_entry_stat_id_lost_msg_count                                                 BCMOLT_LOG_ENTRY_STAT_ID_LOST_MSG_COUNT
#define bcmolt_log_entry_stat_id__num_of                                                        BCMOLT_LOG_ENTRY_STAT_ID__NUM_OF
#define bcmolt_log_entry_stat_cfg_id_cfg                                                        BCMOLT_LOG_ENTRY_STAT_CFG_ID_CFG
#define bcmolt_log_entry_stat_cfg_id__num_of                                                    BCMOLT_LOG_ENTRY_STAT_CFG_ID__NUM_OF
#define bcmolt_log_entry_stat_alarm_cleared_id_stat                                             BCMOLT_LOG_ENTRY_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_log_entry_stat_alarm_cleared_id__num_of                                          BCMOLT_LOG_ENTRY_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_log_entry_stat_alarm_raised_id_stat                                              BCMOLT_LOG_ENTRY_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_log_entry_stat_alarm_raised_id__num_of                                           BCMOLT_LOG_ENTRY_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_log_entry_auto_cfg_id_stat_alarm_cleared                                         BCMOLT_LOG_ENTRY_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_log_entry_auto_cfg_id_stat_alarm_raised                                          BCMOLT_LOG_ENTRY_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_log_entry_auto_cfg_id__num_of                                                    BCMOLT_LOG_ENTRY_AUTO_CFG_ID__NUM_OF
#define bcmolt_logger_key_id_reserved                                                           BCMOLT_LOGGER_KEY_ID_RESERVED
#define bcmolt_logger_key_id_file_id                                                            BCMOLT_LOGGER_KEY_ID_FILE_ID
#define bcmolt_logger_key_id__num_of                                                            BCMOLT_LOGGER_KEY_ID__NUM_OF
#define bcmolt_logger_cfg_id_buffer                                                             BCMOLT_LOGGER_CFG_ID_BUFFER
#define bcmolt_logger_cfg_id_wrap_around                                                        BCMOLT_LOGGER_CFG_ID_WRAP_AROUND
#define bcmolt_logger_cfg_id_clear_after_read                                                   BCMOLT_LOGGER_CFG_ID_CLEAR_AFTER_READ
#define bcmolt_logger_cfg_id_enable_log                                                         BCMOLT_LOGGER_CFG_ID_ENABLE_LOG
#define bcmolt_logger_cfg_id_log_names                                                          BCMOLT_LOGGER_CFG_ID_LOG_NAMES
#define bcmolt_logger_cfg_id__num_of                                                            BCMOLT_LOGGER_CFG_ID__NUM_OF
#define bcmolt_logger_stat_id_lines_in_log                                                      BCMOLT_LOGGER_STAT_ID_LINES_IN_LOG
#define bcmolt_logger_stat_id__num_of                                                           BCMOLT_LOGGER_STAT_ID__NUM_OF
#define bcmolt_logger_stat_cfg_id_cfg                                                           BCMOLT_LOGGER_STAT_CFG_ID_CFG
#define bcmolt_logger_stat_cfg_id__num_of                                                       BCMOLT_LOGGER_STAT_CFG_ID__NUM_OF
#define bcmolt_logger_stat_alarm_cleared_id_stat                                                BCMOLT_LOGGER_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_logger_stat_alarm_cleared_id__num_of                                             BCMOLT_LOGGER_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_logger_stat_alarm_raised_id_stat                                                 BCMOLT_LOGGER_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_logger_stat_alarm_raised_id__num_of                                              BCMOLT_LOGGER_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_logger_auto_cfg_id_stat_alarm_cleared                                            BCMOLT_LOGGER_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_logger_auto_cfg_id_stat_alarm_raised                                             BCMOLT_LOGGER_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_logger_auto_cfg_id__num_of                                                       BCMOLT_LOGGER_AUTO_CFG_ID__NUM_OF
#define bcmolt_logger_clear_log_id__num_of                                                      BCMOLT_LOGGER_CLEAR_LOG_ID__NUM_OF
#define bcmolt_nni_key_id_pon_ni                                                                BCMOLT_NNI_KEY_ID_PON_NI
#define bcmolt_nni_key_id__num_of                                                               BCMOLT_NNI_KEY_ID__NUM_OF
#define bcmolt_nni_cfg_id_remote_loopback                                                       BCMOLT_NNI_CFG_ID_REMOTE_LOOPBACK
#define bcmolt_nni_cfg_id_line_loopback                                                         BCMOLT_NNI_CFG_ID_LINE_LOOPBACK
#define bcmolt_nni_cfg_id_mac_address                                                           BCMOLT_NNI_CFG_ID_MAC_ADDRESS
#define bcmolt_nni_cfg_id_nni_status                                                            BCMOLT_NNI_CFG_ID_NNI_STATUS
#define bcmolt_nni_cfg_id_nni_backup_status                                                     BCMOLT_NNI_CFG_ID_NNI_BACKUP_STATUS
#define bcmolt_nni_cfg_id_active_nni                                                            BCMOLT_NNI_CFG_ID_ACTIVE_NNI
#define bcmolt_nni_cfg_id_nni_status_polling_interval_ms                                        BCMOLT_NNI_CFG_ID_NNI_STATUS_POLLING_INTERVAL_MS
#define bcmolt_nni_cfg_id_autoswitch                                                            BCMOLT_NNI_CFG_ID_AUTOSWITCH
#define bcmolt_nni_cfg_id_flow_control                                                          BCMOLT_NNI_CFG_ID_FLOW_CONTROL
#define bcmolt_nni_cfg_id__num_of                                                               BCMOLT_NNI_CFG_ID__NUM_OF
#define bcmolt_nni_stat_id_rx_frames_64                                                         BCMOLT_NNI_STAT_ID_RX_FRAMES_64
#define bcmolt_nni_stat_id_rx_frames_65_127                                                     BCMOLT_NNI_STAT_ID_RX_FRAMES_65_127
#define bcmolt_nni_stat_id_rx_frames_128_255                                                    BCMOLT_NNI_STAT_ID_RX_FRAMES_128_255
#define bcmolt_nni_stat_id_rx_frames_256_511                                                    BCMOLT_NNI_STAT_ID_RX_FRAMES_256_511
#define bcmolt_nni_stat_id_rx_frames_512_1023                                                   BCMOLT_NNI_STAT_ID_RX_FRAMES_512_1023
#define bcmolt_nni_stat_id_rx_frames_1024_1518                                                  BCMOLT_NNI_STAT_ID_RX_FRAMES_1024_1518
#define bcmolt_nni_stat_id_rx_frames_1519_2047                                                  BCMOLT_NNI_STAT_ID_RX_FRAMES_1519_2047
#define bcmolt_nni_stat_id_rx_frames_2048_4095                                                  BCMOLT_NNI_STAT_ID_RX_FRAMES_2048_4095
#define bcmolt_nni_stat_id_rx_frames_4096_9216                                                  BCMOLT_NNI_STAT_ID_RX_FRAMES_4096_9216
#define bcmolt_nni_stat_id_rx_frames_9217_16383                                                 BCMOLT_NNI_STAT_ID_RX_FRAMES_9217_16383
#define bcmolt_nni_stat_id_rx_frames                                                            BCMOLT_NNI_STAT_ID_RX_FRAMES
#define bcmolt_nni_stat_id_rx_bytes                                                             BCMOLT_NNI_STAT_ID_RX_BYTES
#define bcmolt_nni_stat_id_rx_good_frames                                                       BCMOLT_NNI_STAT_ID_RX_GOOD_FRAMES
#define bcmolt_nni_stat_id_rx_unicast_frames                                                    BCMOLT_NNI_STAT_ID_RX_UNICAST_FRAMES
#define bcmolt_nni_stat_id_rx_multicast_frames                                                  BCMOLT_NNI_STAT_ID_RX_MULTICAST_FRAMES
#define bcmolt_nni_stat_id_rx_broadcast_frames                                                  BCMOLT_NNI_STAT_ID_RX_BROADCAST_FRAMES
#define bcmolt_nni_stat_id_rx_fcs_errors                                                        BCMOLT_NNI_STAT_ID_RX_FCS_ERRORS
#define bcmolt_nni_stat_id_rx_control_frames                                                    BCMOLT_NNI_STAT_ID_RX_CONTROL_FRAMES
#define bcmolt_nni_stat_id_rx_pause_frames                                                      BCMOLT_NNI_STAT_ID_RX_PAUSE_FRAMES
#define bcmolt_nni_stat_id_rx_pfc_frames                                                        BCMOLT_NNI_STAT_ID_RX_PFC_FRAMES
#define bcmolt_nni_stat_id_rx_unsupported_opcode                                                BCMOLT_NNI_STAT_ID_RX_UNSUPPORTED_OPCODE
#define bcmolt_nni_stat_id_rx_unsupported_da                                                    BCMOLT_NNI_STAT_ID_RX_UNSUPPORTED_DA
#define bcmolt_nni_stat_id_rx_alignment_errors                                                  BCMOLT_NNI_STAT_ID_RX_ALIGNMENT_ERRORS
#define bcmolt_nni_stat_id_rx_length_out_of_range                                               BCMOLT_NNI_STAT_ID_RX_LENGTH_OUT_OF_RANGE
#define bcmolt_nni_stat_id_rx_code_errors                                                       BCMOLT_NNI_STAT_ID_RX_CODE_ERRORS
#define bcmolt_nni_stat_id_rx_oversized_frames                                                  BCMOLT_NNI_STAT_ID_RX_OVERSIZED_FRAMES
#define bcmolt_nni_stat_id_rx_jabber_frames                                                     BCMOLT_NNI_STAT_ID_RX_JABBER_FRAMES
#define bcmolt_nni_stat_id_rx_mtu_check_errors                                                  BCMOLT_NNI_STAT_ID_RX_MTU_CHECK_ERRORS
#define bcmolt_nni_stat_id_rx_promiscuous_frames                                                BCMOLT_NNI_STAT_ID_RX_PROMISCUOUS_FRAMES
#define bcmolt_nni_stat_id_rx_vlan_frames                                                       BCMOLT_NNI_STAT_ID_RX_VLAN_FRAMES
#define bcmolt_nni_stat_id_rx_double_vlan_frames                                                BCMOLT_NNI_STAT_ID_RX_DOUBLE_VLAN_FRAMES
#define bcmolt_nni_stat_id_rx_truncated_frames                                                  BCMOLT_NNI_STAT_ID_RX_TRUNCATED_FRAMES
#define bcmolt_nni_stat_id_rx_undersize_frames                                                  BCMOLT_NNI_STAT_ID_RX_UNDERSIZE_FRAMES
#define bcmolt_nni_stat_id_rx_fragmented_frames                                                 BCMOLT_NNI_STAT_ID_RX_FRAGMENTED_FRAMES
#define bcmolt_nni_stat_id_rx_runt_frames                                                       BCMOLT_NNI_STAT_ID_RX_RUNT_FRAMES
#define bcmolt_nni_stat_id_tx_frames_64                                                         BCMOLT_NNI_STAT_ID_TX_FRAMES_64
#define bcmolt_nni_stat_id_tx_frames_65_127                                                     BCMOLT_NNI_STAT_ID_TX_FRAMES_65_127
#define bcmolt_nni_stat_id_tx_frames_128_255                                                    BCMOLT_NNI_STAT_ID_TX_FRAMES_128_255
#define bcmolt_nni_stat_id_tx_frames_256_511                                                    BCMOLT_NNI_STAT_ID_TX_FRAMES_256_511
#define bcmolt_nni_stat_id_tx_frames_512_1023                                                   BCMOLT_NNI_STAT_ID_TX_FRAMES_512_1023
#define bcmolt_nni_stat_id_tx_frames_1024_1518                                                  BCMOLT_NNI_STAT_ID_TX_FRAMES_1024_1518
#define bcmolt_nni_stat_id_tx_frames_1519_2047                                                  BCMOLT_NNI_STAT_ID_TX_FRAMES_1519_2047
#define bcmolt_nni_stat_id_tx_frames_2048_4095                                                  BCMOLT_NNI_STAT_ID_TX_FRAMES_2048_4095
#define bcmolt_nni_stat_id_tx_frames_4096_9216                                                  BCMOLT_NNI_STAT_ID_TX_FRAMES_4096_9216
#define bcmolt_nni_stat_id_tx_frames_9217_16383                                                 BCMOLT_NNI_STAT_ID_TX_FRAMES_9217_16383
#define bcmolt_nni_stat_id_tx_frames                                                            BCMOLT_NNI_STAT_ID_TX_FRAMES
#define bcmolt_nni_stat_id_tx_bytes                                                             BCMOLT_NNI_STAT_ID_TX_BYTES
#define bcmolt_nni_stat_id_tx_good_frames                                                       BCMOLT_NNI_STAT_ID_TX_GOOD_FRAMES
#define bcmolt_nni_stat_id_tx_unicast_frames                                                    BCMOLT_NNI_STAT_ID_TX_UNICAST_FRAMES
#define bcmolt_nni_stat_id_tx_multicast_frames                                                  BCMOLT_NNI_STAT_ID_TX_MULTICAST_FRAMES
#define bcmolt_nni_stat_id_tx_broadcast_frames                                                  BCMOLT_NNI_STAT_ID_TX_BROADCAST_FRAMES
#define bcmolt_nni_stat_id_tx_pause_frames                                                      BCMOLT_NNI_STAT_ID_TX_PAUSE_FRAMES
#define bcmolt_nni_stat_id_tx_pfc_frames                                                        BCMOLT_NNI_STAT_ID_TX_PFC_FRAMES
#define bcmolt_nni_stat_id_tx_jabber_frames                                                     BCMOLT_NNI_STAT_ID_TX_JABBER_FRAMES
#define bcmolt_nni_stat_id_tx_fcs_errors                                                        BCMOLT_NNI_STAT_ID_TX_FCS_ERRORS
#define bcmolt_nni_stat_id_tx_control_frames                                                    BCMOLT_NNI_STAT_ID_TX_CONTROL_FRAMES
#define bcmolt_nni_stat_id_tx_oversize_frames                                                   BCMOLT_NNI_STAT_ID_TX_OVERSIZE_FRAMES
#define bcmolt_nni_stat_id_tx_fragmented_frames                                                 BCMOLT_NNI_STAT_ID_TX_FRAGMENTED_FRAMES
#define bcmolt_nni_stat_id_tx_error_frames                                                      BCMOLT_NNI_STAT_ID_TX_ERROR_FRAMES
#define bcmolt_nni_stat_id_tx_vlan_frames                                                       BCMOLT_NNI_STAT_ID_TX_VLAN_FRAMES
#define bcmolt_nni_stat_id_tx_double_vlan_frames                                                BCMOLT_NNI_STAT_ID_TX_DOUBLE_VLAN_FRAMES
#define bcmolt_nni_stat_id_tx_runt_frames                                                       BCMOLT_NNI_STAT_ID_TX_RUNT_FRAMES
#define bcmolt_nni_stat_id_tx_underrun_frames                                                   BCMOLT_NNI_STAT_ID_TX_UNDERRUN_FRAMES
#define bcmolt_nni_stat_id__num_of                                                              BCMOLT_NNI_STAT_ID__NUM_OF
#define bcmolt_nni_stat_cfg_id_cfg                                                              BCMOLT_NNI_STAT_CFG_ID_CFG
#define bcmolt_nni_stat_cfg_id__num_of                                                          BCMOLT_NNI_STAT_CFG_ID__NUM_OF
#define bcmolt_nni_stat_alarm_cleared_id_stat                                                   BCMOLT_NNI_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_nni_stat_alarm_cleared_id__num_of                                                BCMOLT_NNI_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_nni_stat_alarm_raised_id_stat                                                    BCMOLT_NNI_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_nni_stat_alarm_raised_id__num_of                                                 BCMOLT_NNI_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_nni_status_changed_id_new_status                                                 BCMOLT_NNI_STATUS_CHANGED_ID_NEW_STATUS
#define bcmolt_nni_status_changed_id_link                                                       BCMOLT_NNI_STATUS_CHANGED_ID_LINK
#define bcmolt_nni_status_changed_id_previous_active                                            BCMOLT_NNI_STATUS_CHANGED_ID_PREVIOUS_ACTIVE
#define bcmolt_nni_status_changed_id_new_active                                                 BCMOLT_NNI_STATUS_CHANGED_ID_NEW_ACTIVE
#define bcmolt_nni_status_changed_id__num_of                                                    BCMOLT_NNI_STATUS_CHANGED_ID__NUM_OF
#define bcmolt_nni_auto_cfg_id_stat_alarm_cleared                                               BCMOLT_NNI_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_nni_auto_cfg_id_stat_alarm_raised                                                BCMOLT_NNI_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_nni_auto_cfg_id_status_changed                                                   BCMOLT_NNI_AUTO_CFG_ID_STATUS_CHANGED
#define bcmolt_nni_auto_cfg_id__num_of                                                          BCMOLT_NNI_AUTO_CFG_ID__NUM_OF
#define bcmolt_nni_serdes_key_id_pon_ni                                                         BCMOLT_NNI_SERDES_KEY_ID_PON_NI
#define bcmolt_nni_serdes_key_id_instance                                                       BCMOLT_NNI_SERDES_KEY_ID_INSTANCE
#define bcmolt_nni_serdes_key_id__num_of                                                        BCMOLT_NNI_SERDES_KEY_ID__NUM_OF
#define bcmolt_nni_serdes_cfg_id_rx_vga                                                         BCMOLT_NNI_SERDES_CFG_ID_RX_VGA
#define bcmolt_nni_serdes_cfg_id_rx_pf                                                          BCMOLT_NNI_SERDES_CFG_ID_RX_PF
#define bcmolt_nni_serdes_cfg_id_rx_lfpf                                                        BCMOLT_NNI_SERDES_CFG_ID_RX_LFPF
#define bcmolt_nni_serdes_cfg_id_rx_dfe1                                                        BCMOLT_NNI_SERDES_CFG_ID_RX_DFE1
#define bcmolt_nni_serdes_cfg_id_rx_dfe2                                                        BCMOLT_NNI_SERDES_CFG_ID_RX_DFE2
#define bcmolt_nni_serdes_cfg_id_rx_dfe3                                                        BCMOLT_NNI_SERDES_CFG_ID_RX_DFE3
#define bcmolt_nni_serdes_cfg_id_rx_dfe4                                                        BCMOLT_NNI_SERDES_CFG_ID_RX_DFE4
#define bcmolt_nni_serdes_cfg_id_rx_dfe5                                                        BCMOLT_NNI_SERDES_CFG_ID_RX_DFE5
#define bcmolt_nni_serdes_cfg_id_tx_pre                                                         BCMOLT_NNI_SERDES_CFG_ID_TX_PRE
#define bcmolt_nni_serdes_cfg_id_tx_main                                                        BCMOLT_NNI_SERDES_CFG_ID_TX_MAIN
#define bcmolt_nni_serdes_cfg_id_tx_post1                                                       BCMOLT_NNI_SERDES_CFG_ID_TX_POST1
#define bcmolt_nni_serdes_cfg_id_tx_post2                                                       BCMOLT_NNI_SERDES_CFG_ID_TX_POST2
#define bcmolt_nni_serdes_cfg_id_tx_post3                                                       BCMOLT_NNI_SERDES_CFG_ID_TX_POST3
#define bcmolt_nni_serdes_cfg_id_tx_amp                                                         BCMOLT_NNI_SERDES_CFG_ID_TX_AMP
#define bcmolt_nni_serdes_cfg_id__num_of                                                        BCMOLT_NNI_SERDES_CFG_ID__NUM_OF
#define bcmolt_software_error_key_id_reserved                                                   BCMOLT_SOFTWARE_ERROR_KEY_ID_RESERVED
#define bcmolt_software_error_key_id_idx                                                        BCMOLT_SOFTWARE_ERROR_KEY_ID_IDX
#define bcmolt_software_error_key_id__num_of                                                    BCMOLT_SOFTWARE_ERROR_KEY_ID__NUM_OF
#define bcmolt_software_error_cfg_id_entry                                                      BCMOLT_SOFTWARE_ERROR_CFG_ID_ENTRY
#define bcmolt_software_error_cfg_id__num_of                                                    BCMOLT_SOFTWARE_ERROR_CFG_ID__NUM_OF
#define bcmolt_trx_calibration_key_id_reserved                                                  BCMOLT_TRX_CALIBRATION_KEY_ID_RESERVED
#define bcmolt_trx_calibration_key_id__num_of                                                   BCMOLT_TRX_CALIBRATION_KEY_ID__NUM_OF
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_data_window            BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_DATA_WINDOW
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_strobe_window          BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_STROBE_WINDOW
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_edge_rise_min_min      BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_RISE_MIN_MIN
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_edge_rise_min_max      BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_RISE_MIN_MAX
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_edge_rise_max_min      BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_RISE_MAX_MIN
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_edge_rise_max_max      BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_RISE_MAX_MAX
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_edge_fall_min_min      BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_FALL_MIN_MIN
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_edge_fall_min_max      BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_FALL_MIN_MAX
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_edge_fall_max_min      BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_FALL_MAX_MIN
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_edge_fall_max_max      BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_EDGE_FALL_MAX_MAX
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id_result                 BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID_RESULT
#define bcmolt_trx_calibration_capture_window_and_statistic_completed_id__num_of                BCMOLT_TRX_CALIBRATION_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED_ID__NUM_OF
#define bcmolt_trx_calibration_auto_cfg_id_capture_window_and_statistic_completed               BCMOLT_TRX_CALIBRATION_AUTO_CFG_ID_CAPTURE_WINDOW_AND_STATISTIC_COMPLETED
#define bcmolt_trx_calibration_auto_cfg_id__num_of                                              BCMOLT_TRX_CALIBRATION_AUTO_CFG_ID__NUM_OF
#define bcmolt_trx_calibration_start_capture_window_id_pon_ni                                   BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_PON_NI
#define bcmolt_trx_calibration_start_capture_window_id_trigger                                  BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_TRIGGER
#define bcmolt_trx_calibration_start_capture_window_id_strobe                                   BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_STROBE
#define bcmolt_trx_calibration_start_capture_window_id_window_mode                              BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_WINDOW_MODE
#define bcmolt_trx_calibration_start_capture_window_id_onu_id                                   BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_ONU_ID
#define bcmolt_trx_calibration_start_capture_window_id_trigger_position                         BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_TRIGGER_POSITION
#define bcmolt_trx_calibration_start_capture_window_id_stop_due_to_corrupt_strobe               BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_STOP_DUE_TO_CORRUPT_STROBE
#define bcmolt_trx_calibration_start_capture_window_id_start_offset                             BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_START_OFFSET
#define bcmolt_trx_calibration_start_capture_window_id_end_offset                               BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_END_OFFSET
#define bcmolt_trx_calibration_start_capture_window_id_number_of_cycles                         BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID_NUMBER_OF_CYCLES
#define bcmolt_trx_calibration_start_capture_window_id__num_of                                  BCMOLT_TRX_CALIBRATION_START_CAPTURE_WINDOW_ID__NUM_OF
#define bcmolt_trx_calibration_stop_capture_window_id_pon_ni                                    BCMOLT_TRX_CALIBRATION_STOP_CAPTURE_WINDOW_ID_PON_NI
#define bcmolt_trx_calibration_stop_capture_window_id__num_of                                   BCMOLT_TRX_CALIBRATION_STOP_CAPTURE_WINDOW_ID__NUM_OF
#define bcmolt_xgpon_alloc_key_id_pon_ni                                                        BCMOLT_XGPON_ALLOC_KEY_ID_PON_NI
#define bcmolt_xgpon_alloc_key_id_alloc_id                                                      BCMOLT_XGPON_ALLOC_KEY_ID_ALLOC_ID
#define bcmolt_xgpon_alloc_key_id__num_of                                                       BCMOLT_XGPON_ALLOC_KEY_ID__NUM_OF
#define bcmolt_xgpon_alloc_cfg_id_state                                                         BCMOLT_XGPON_ALLOC_CFG_ID_STATE
#define bcmolt_xgpon_alloc_cfg_id_sla                                                           BCMOLT_XGPON_ALLOC_CFG_ID_SLA
#define bcmolt_xgpon_alloc_cfg_id_onu_id                                                        BCMOLT_XGPON_ALLOC_CFG_ID_ONU_ID
#define bcmolt_xgpon_alloc_cfg_id_collect_stats                                                 BCMOLT_XGPON_ALLOC_CFG_ID_COLLECT_STATS
#define bcmolt_xgpon_alloc_cfg_id__num_of                                                       BCMOLT_XGPON_ALLOC_CFG_ID__NUM_OF
#define bcmolt_xgpon_alloc_stat_id_rx_bytes                                                     BCMOLT_XGPON_ALLOC_STAT_ID_RX_BYTES
#define bcmolt_xgpon_alloc_stat_id__num_of                                                      BCMOLT_XGPON_ALLOC_STAT_ID__NUM_OF
#define bcmolt_xgpon_alloc_stat_cfg_id_cfg                                                      BCMOLT_XGPON_ALLOC_STAT_CFG_ID_CFG
#define bcmolt_xgpon_alloc_stat_cfg_id__num_of                                                  BCMOLT_XGPON_ALLOC_STAT_CFG_ID__NUM_OF
#define bcmolt_xgpon_alloc_configuration_completed_id_status                                    BCMOLT_XGPON_ALLOC_CONFIGURATION_COMPLETED_ID_STATUS
#define bcmolt_xgpon_alloc_configuration_completed_id_new_state                                 BCMOLT_XGPON_ALLOC_CONFIGURATION_COMPLETED_ID_NEW_STATE
#define bcmolt_xgpon_alloc_configuration_completed_id__num_of                                   BCMOLT_XGPON_ALLOC_CONFIGURATION_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_alloc_get_alloc_stats_completed_id_status                                  BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_STATUS
#define bcmolt_xgpon_alloc_get_alloc_stats_completed_id_average_nsr_used                        BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_NSR_USED
#define bcmolt_xgpon_alloc_get_alloc_stats_completed_id_average_nsr_allocated                   BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_NSR_ALLOCATED
#define bcmolt_xgpon_alloc_get_alloc_stats_completed_id_average_sr_report                       BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID_AVERAGE_SR_REPORT
#define bcmolt_xgpon_alloc_get_alloc_stats_completed_id__num_of                                 BCMOLT_XGPON_ALLOC_GET_ALLOC_STATS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_alloc_stat_alarm_cleared_id_stat                                           BCMOLT_XGPON_ALLOC_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_xgpon_alloc_stat_alarm_cleared_id__num_of                                        BCMOLT_XGPON_ALLOC_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_xgpon_alloc_stat_alarm_raised_id_stat                                            BCMOLT_XGPON_ALLOC_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_xgpon_alloc_stat_alarm_raised_id__num_of                                         BCMOLT_XGPON_ALLOC_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_xgpon_alloc_auto_cfg_id_configuration_completed                                  BCMOLT_XGPON_ALLOC_AUTO_CFG_ID_CONFIGURATION_COMPLETED
#define bcmolt_xgpon_alloc_auto_cfg_id_get_alloc_stats_completed                                BCMOLT_XGPON_ALLOC_AUTO_CFG_ID_GET_ALLOC_STATS_COMPLETED
#define bcmolt_xgpon_alloc_auto_cfg_id_stat_alarm_cleared                                       BCMOLT_XGPON_ALLOC_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_xgpon_alloc_auto_cfg_id_stat_alarm_raised                                        BCMOLT_XGPON_ALLOC_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_xgpon_alloc_auto_cfg_id__num_of                                                  BCMOLT_XGPON_ALLOC_AUTO_CFG_ID__NUM_OF
#define bcmolt_xgpon_alloc_get_stats_id_num_of_cycles                                           BCMOLT_XGPON_ALLOC_GET_STATS_ID_NUM_OF_CYCLES
#define bcmolt_xgpon_alloc_get_stats_id__num_of                                                 BCMOLT_XGPON_ALLOC_GET_STATS_ID__NUM_OF
#define bcmolt_xgpon_alloc_set_state_id_state                                                   BCMOLT_XGPON_ALLOC_SET_STATE_ID_STATE
#define bcmolt_xgpon_alloc_set_state_id__num_of                                                 BCMOLT_XGPON_ALLOC_SET_STATE_ID__NUM_OF
#define bcmolt_xgpon_gem_port_key_id_pon_ni                                                     BCMOLT_XGPON_GEM_PORT_KEY_ID_PON_NI
#define bcmolt_xgpon_gem_port_key_id_gem_port_id                                                BCMOLT_XGPON_GEM_PORT_KEY_ID_GEM_PORT_ID
#define bcmolt_xgpon_gem_port_key_id__num_of                                                    BCMOLT_XGPON_GEM_PORT_KEY_ID__NUM_OF
#define bcmolt_xgpon_gem_port_cfg_id_configuration                                              BCMOLT_XGPON_GEM_PORT_CFG_ID_CONFIGURATION
#define bcmolt_xgpon_gem_port_cfg_id_onu_id                                                     BCMOLT_XGPON_GEM_PORT_CFG_ID_ONU_ID
#define bcmolt_xgpon_gem_port_cfg_id_gem_port_state                                             BCMOLT_XGPON_GEM_PORT_CFG_ID_GEM_PORT_STATE
#define bcmolt_xgpon_gem_port_cfg_id_encryption_mode                                            BCMOLT_XGPON_GEM_PORT_CFG_ID_ENCRYPTION_MODE
#define bcmolt_xgpon_gem_port_cfg_id_upstream_destination_queue                                 BCMOLT_XGPON_GEM_PORT_CFG_ID_UPSTREAM_DESTINATION_QUEUE
#define bcmolt_xgpon_gem_port_cfg_id_control                                                    BCMOLT_XGPON_GEM_PORT_CFG_ID_CONTROL
#define bcmolt_xgpon_gem_port_cfg_id__num_of                                                    BCMOLT_XGPON_GEM_PORT_CFG_ID__NUM_OF
#define bcmolt_xgpon_gem_port_stat_id_tx_bytes                                                  BCMOLT_XGPON_GEM_PORT_STAT_ID_TX_BYTES
#define bcmolt_xgpon_gem_port_stat_id_tx_packets                                                BCMOLT_XGPON_GEM_PORT_STAT_ID_TX_PACKETS
#define bcmolt_xgpon_gem_port_stat_id_rx_packets                                                BCMOLT_XGPON_GEM_PORT_STAT_ID_RX_PACKETS
#define bcmolt_xgpon_gem_port_stat_id_rx_bytes                                                  BCMOLT_XGPON_GEM_PORT_STAT_ID_RX_BYTES
#define bcmolt_xgpon_gem_port_stat_id__num_of                                                   BCMOLT_XGPON_GEM_PORT_STAT_ID__NUM_OF
#define bcmolt_xgpon_gem_port_stat_cfg_id_cfg                                                   BCMOLT_XGPON_GEM_PORT_STAT_CFG_ID_CFG
#define bcmolt_xgpon_gem_port_stat_cfg_id__num_of                                               BCMOLT_XGPON_GEM_PORT_STAT_CFG_ID__NUM_OF
#define bcmolt_xgpon_gem_port_stat_alarm_cleared_id_stat                                        BCMOLT_XGPON_GEM_PORT_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_xgpon_gem_port_stat_alarm_cleared_id__num_of                                     BCMOLT_XGPON_GEM_PORT_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_xgpon_gem_port_stat_alarm_raised_id_stat                                         BCMOLT_XGPON_GEM_PORT_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_xgpon_gem_port_stat_alarm_raised_id__num_of                                      BCMOLT_XGPON_GEM_PORT_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_xgpon_gem_port_auto_cfg_id_stat_alarm_cleared                                    BCMOLT_XGPON_GEM_PORT_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_xgpon_gem_port_auto_cfg_id_stat_alarm_raised                                     BCMOLT_XGPON_GEM_PORT_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_xgpon_gem_port_auto_cfg_id__num_of                                               BCMOLT_XGPON_GEM_PORT_AUTO_CFG_ID__NUM_OF
#define bcmolt_xgpon_iwf_key_id_pon_ni                                                          BCMOLT_XGPON_IWF_KEY_ID_PON_NI
#define bcmolt_xgpon_iwf_key_id__num_of                                                         BCMOLT_XGPON_IWF_KEY_ID__NUM_OF
#define bcmolt_xgpon_iwf_cfg_id_us_otag_direct_tpid                                             BCMOLT_XGPON_IWF_CFG_ID_US_OTAG_DIRECT_TPID
#define bcmolt_xgpon_iwf_cfg_id_ds_tpid                                                         BCMOLT_XGPON_IWF_CFG_ID_DS_TPID
#define bcmolt_xgpon_iwf_cfg_id__num_of                                                         BCMOLT_XGPON_IWF_CFG_ID__NUM_OF
#define bcmolt_xgpon_ni_key_id_pon_ni                                                           BCMOLT_XGPON_NI_KEY_ID_PON_NI
#define bcmolt_xgpon_ni_key_id__num_of                                                          BCMOLT_XGPON_NI_KEY_ID__NUM_OF
#define bcmolt_xgpon_ni_cfg_id_hw_pon_id                                                        BCMOLT_XGPON_NI_CFG_ID_HW_PON_ID
#define bcmolt_xgpon_ni_cfg_id_available_bandwidth                                              BCMOLT_XGPON_NI_CFG_ID_AVAILABLE_BANDWIDTH
#define bcmolt_xgpon_ni_cfg_id_number_of_active_onus                                            BCMOLT_XGPON_NI_CFG_ID_NUMBER_OF_ACTIVE_ONUS
#define bcmolt_xgpon_ni_cfg_id_pon_status                                                       BCMOLT_XGPON_NI_CFG_ID_PON_STATUS
#define bcmolt_xgpon_ni_cfg_id_pon_distance                                                     BCMOLT_XGPON_NI_CFG_ID_PON_DISTANCE
#define bcmolt_xgpon_ni_cfg_id_ranging_window_size                                              BCMOLT_XGPON_NI_CFG_ID_RANGING_WINDOW_SIZE
#define bcmolt_xgpon_ni_cfg_id_eqd_cycles_number                                                BCMOLT_XGPON_NI_CFG_ID_EQD_CYCLES_NUMBER
#define bcmolt_xgpon_ni_cfg_id_drift_control                                                    BCMOLT_XGPON_NI_CFG_ID_DRIFT_CONTROL
#define bcmolt_xgpon_ni_cfg_id_los_alarm_threshold                                              BCMOLT_XGPON_NI_CFG_ID_LOS_ALARM_THRESHOLD
#define bcmolt_xgpon_ni_cfg_id_los_initial_value                                                BCMOLT_XGPON_NI_CFG_ID_LOS_INITIAL_VALUE
#define bcmolt_xgpon_ni_cfg_id_onu_alarms_thresholds                                            BCMOLT_XGPON_NI_CFG_ID_ONU_ALARMS_THRESHOLDS
#define bcmolt_xgpon_ni_cfg_id_ber_monitor                                                      BCMOLT_XGPON_NI_CFG_ID_BER_MONITOR
#define bcmolt_xgpon_ni_cfg_id_onu_activation                                                   BCMOLT_XGPON_NI_CFG_ID_ONU_ACTIVATION
#define bcmolt_xgpon_ni_cfg_id_sn_acquisition                                                   BCMOLT_XGPON_NI_CFG_ID_SN_ACQUISITION
#define bcmolt_xgpon_ni_cfg_id_key_exchange                                                     BCMOLT_XGPON_NI_CFG_ID_KEY_EXCHANGE
#define bcmolt_xgpon_ni_cfg_id_protection_switching                                             BCMOLT_XGPON_NI_CFG_ID_PROTECTION_SWITCHING
#define bcmolt_xgpon_ni_cfg_id_protection_switching_debug                                       BCMOLT_XGPON_NI_CFG_ID_PROTECTION_SWITCHING_DEBUG
#define bcmolt_xgpon_ni_cfg_id_cbr_rt_allocation_profile                                        BCMOLT_XGPON_NI_CFG_ID_CBR_RT_ALLOCATION_PROFILE
#define bcmolt_xgpon_ni_cfg_id_cbr_nrt_allocation_profile                                       BCMOLT_XGPON_NI_CFG_ID_CBR_NRT_ALLOCATION_PROFILE
#define bcmolt_xgpon_ni_cfg_id_power_management                                                 BCMOLT_XGPON_NI_CFG_ID_POWER_MANAGEMENT
#define bcmolt_xgpon_ni_cfg_id_rogue_onu_detection_process                                      BCMOLT_XGPON_NI_CFG_ID_ROGUE_ONU_DETECTION_PROCESS
#define bcmolt_xgpon_ni_cfg_id_periodic_standby_pon_monitoring                                  BCMOLT_XGPON_NI_CFG_ID_PERIODIC_STANDBY_PON_MONITORING
#define bcmolt_xgpon_ni_cfg_id_dba_mode                                                         BCMOLT_XGPON_NI_CFG_ID_DBA_MODE
#define bcmolt_xgpon_ni_cfg_id_ploam_handling                                                   BCMOLT_XGPON_NI_CFG_ID_PLOAM_HANDLING
#define bcmolt_xgpon_ni_cfg_id_min_data_alloc_id                                                BCMOLT_XGPON_NI_CFG_ID_MIN_DATA_ALLOC_ID
#define bcmolt_xgpon_ni_cfg_id_min_data_gem_port_id                                             BCMOLT_XGPON_NI_CFG_ID_MIN_DATA_GEM_PORT_ID
#define bcmolt_xgpon_ni_cfg_id_multicast_key                                                    BCMOLT_XGPON_NI_CFG_ID_MULTICAST_KEY
#define bcmolt_xgpon_ni_cfg_id_prbs_checker                                                     BCMOLT_XGPON_NI_CFG_ID_PRBS_CHECKER
#define bcmolt_xgpon_ni_cfg_id_prbs_generator                                                   BCMOLT_XGPON_NI_CFG_ID_PRBS_GENERATOR
#define bcmolt_xgpon_ni_cfg_id_prbs_status                                                      BCMOLT_XGPON_NI_CFG_ID_PRBS_STATUS
#define bcmolt_xgpon_ni_cfg_id_automatic_onu_deactivation                                       BCMOLT_XGPON_NI_CFG_ID_AUTOMATIC_ONU_DEACTIVATION
#define bcmolt_xgpon_ni_cfg_id_us_bandwidth_limit                                               BCMOLT_XGPON_NI_CFG_ID_US_BANDWIDTH_LIMIT
#define bcmolt_xgpon_ni_cfg_id_all_onus                                                         BCMOLT_XGPON_NI_CFG_ID_ALL_ONUS
#define bcmolt_xgpon_ni_cfg_id_all_mcast_gem_ports                                              BCMOLT_XGPON_NI_CFG_ID_ALL_MCAST_GEM_PORTS
#define bcmolt_xgpon_ni_cfg_id_debug                                                            BCMOLT_XGPON_NI_CFG_ID_DEBUG
#define bcmolt_xgpon_ni_cfg_id_onu_upgrade_params                                               BCMOLT_XGPON_NI_CFG_ID_ONU_UPGRADE_PARAMS
#define bcmolt_xgpon_ni_cfg_id_ds_fec_mode                                                      BCMOLT_XGPON_NI_CFG_ID_DS_FEC_MODE
#define bcmolt_xgpon_ni_cfg_id_dba_type                                                         BCMOLT_XGPON_NI_CFG_ID_DBA_TYPE
#define bcmolt_xgpon_ni_cfg_id_onu_tuning                                                       BCMOLT_XGPON_NI_CFG_ID_ONU_TUNING
#define bcmolt_xgpon_ni_cfg_id__num_of                                                          BCMOLT_XGPON_NI_CFG_ID__NUM_OF
#define bcmolt_xgpon_ni_stat_id_fec_codewords                                                   BCMOLT_XGPON_NI_STAT_ID_FEC_CODEWORDS
#define bcmolt_xgpon_ni_stat_id_bip32_bytes                                                     BCMOLT_XGPON_NI_STAT_ID_BIP32_BYTES
#define bcmolt_xgpon_ni_stat_id_bip32_errors                                                    BCMOLT_XGPON_NI_STAT_ID_BIP32_ERRORS
#define bcmolt_xgpon_ni_stat_id_rx_xgtc_headers                                                 BCMOLT_XGPON_NI_STAT_ID_RX_XGTC_HEADERS
#define bcmolt_xgpon_ni_stat_id_rx_xgtc_corrected                                               BCMOLT_XGPON_NI_STAT_ID_RX_XGTC_CORRECTED
#define bcmolt_xgpon_ni_stat_id_rx_xgtc_uncorrected                                             BCMOLT_XGPON_NI_STAT_ID_RX_XGTC_UNCORRECTED
#define bcmolt_xgpon_ni_stat_id_rx_xgem                                                         BCMOLT_XGPON_NI_STAT_ID_RX_XGEM
#define bcmolt_xgpon_ni_stat_id_rx_xgem_dropped                                                 BCMOLT_XGPON_NI_STAT_ID_RX_XGEM_DROPPED
#define bcmolt_xgpon_ni_stat_id_rx_xgem_idle                                                    BCMOLT_XGPON_NI_STAT_ID_RX_XGEM_IDLE
#define bcmolt_xgpon_ni_stat_id_rx_xgem_corrected                                               BCMOLT_XGPON_NI_STAT_ID_RX_XGEM_CORRECTED
#define bcmolt_xgpon_ni_stat_id_rx_crc_error                                                    BCMOLT_XGPON_NI_STAT_ID_RX_CRC_ERROR
#define bcmolt_xgpon_ni_stat_id_rx_fragment_error                                               BCMOLT_XGPON_NI_STAT_ID_RX_FRAGMENT_ERROR
#define bcmolt_xgpon_ni_stat_id_rx_packets_dropped                                              BCMOLT_XGPON_NI_STAT_ID_RX_PACKETS_DROPPED
#define bcmolt_xgpon_ni_stat_id_rx_dropped_too_short                                            BCMOLT_XGPON_NI_STAT_ID_RX_DROPPED_TOO_SHORT
#define bcmolt_xgpon_ni_stat_id_rx_dropped_too_long                                             BCMOLT_XGPON_NI_STAT_ID_RX_DROPPED_TOO_LONG
#define bcmolt_xgpon_ni_stat_id_rx_key_error                                                    BCMOLT_XGPON_NI_STAT_ID_RX_KEY_ERROR
#define bcmolt_xgpon_ni_stat_id_tx_ploams                                                       BCMOLT_XGPON_NI_STAT_ID_TX_PLOAMS
#define bcmolt_xgpon_ni_stat_id_rx_ploams_dropped                                               BCMOLT_XGPON_NI_STAT_ID_RX_PLOAMS_DROPPED
#define bcmolt_xgpon_ni_stat_id_rx_allocations_valid                                            BCMOLT_XGPON_NI_STAT_ID_RX_ALLOCATIONS_VALID
#define bcmolt_xgpon_ni_stat_id_rx_allocations_invalid                                          BCMOLT_XGPON_NI_STAT_ID_RX_ALLOCATIONS_INVALID
#define bcmolt_xgpon_ni_stat_id_rx_allocations_disabled                                         BCMOLT_XGPON_NI_STAT_ID_RX_ALLOCATIONS_DISABLED
#define bcmolt_xgpon_ni_stat_id_rx_ploams                                                       BCMOLT_XGPON_NI_STAT_ID_RX_PLOAMS
#define bcmolt_xgpon_ni_stat_id_rx_ploams_non_idle                                              BCMOLT_XGPON_NI_STAT_ID_RX_PLOAMS_NON_IDLE
#define bcmolt_xgpon_ni_stat_id_rx_ploams_error                                                 BCMOLT_XGPON_NI_STAT_ID_RX_PLOAMS_ERROR
#define bcmolt_xgpon_ni_stat_id_rx_cpu                                                          BCMOLT_XGPON_NI_STAT_ID_RX_CPU
#define bcmolt_xgpon_ni_stat_id_rx_omci                                                         BCMOLT_XGPON_NI_STAT_ID_RX_OMCI
#define bcmolt_xgpon_ni_stat_id_rx_omci_packets_crc_error                                       BCMOLT_XGPON_NI_STAT_ID_RX_OMCI_PACKETS_CRC_ERROR
#define bcmolt_xgpon_ni_stat_id_tx_packets                                                      BCMOLT_XGPON_NI_STAT_ID_TX_PACKETS
#define bcmolt_xgpon_ni_stat_id_tx_xgem                                                         BCMOLT_XGPON_NI_STAT_ID_TX_XGEM
#define bcmolt_xgpon_ni_stat_id_tx_cpu                                                          BCMOLT_XGPON_NI_STAT_ID_TX_CPU
#define bcmolt_xgpon_ni_stat_id_tx_omci                                                         BCMOLT_XGPON_NI_STAT_ID_TX_OMCI
#define bcmolt_xgpon_ni_stat_id_tx_cpu_omci_packets_dropped                                     BCMOLT_XGPON_NI_STAT_ID_TX_CPU_OMCI_PACKETS_DROPPED
#define bcmolt_xgpon_ni_stat_id_tx_dropped_illegal_length                                       BCMOLT_XGPON_NI_STAT_ID_TX_DROPPED_ILLEGAL_LENGTH
#define bcmolt_xgpon_ni_stat_id_tx_dropped_tpid_miss                                            BCMOLT_XGPON_NI_STAT_ID_TX_DROPPED_TPID_MISS
#define bcmolt_xgpon_ni_stat_id_tx_dropped_vid_miss                                             BCMOLT_XGPON_NI_STAT_ID_TX_DROPPED_VID_MISS
#define bcmolt_xgpon_ni_stat_id__num_of                                                         BCMOLT_XGPON_NI_STAT_ID__NUM_OF
#define bcmolt_xgpon_ni_stat_cfg_id_cfg                                                         BCMOLT_XGPON_NI_STAT_CFG_ID_CFG
#define bcmolt_xgpon_ni_stat_cfg_id__num_of                                                     BCMOLT_XGPON_NI_STAT_CFG_ID__NUM_OF
#define bcmolt_xgpon_ni_activate_all_onus_completed_id__num_of                                  BCMOLT_XGPON_NI_ACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_cpu_packets_failure_id_error                                            BCMOLT_XGPON_NI_CPU_PACKETS_FAILURE_ID_ERROR
#define bcmolt_xgpon_ni_cpu_packets_failure_id_gem_port_id                                      BCMOLT_XGPON_NI_CPU_PACKETS_FAILURE_ID_GEM_PORT_ID
#define bcmolt_xgpon_ni_cpu_packets_failure_id__num_of                                          BCMOLT_XGPON_NI_CPU_PACKETS_FAILURE_ID__NUM_OF
#define bcmolt_xgpon_ni_deactivate_all_onus_completed_id__num_of                                BCMOLT_XGPON_NI_DEACTIVATE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_disable_all_onus_completed_id__num_of                                   BCMOLT_XGPON_NI_DISABLE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_enable_all_onus_completed_id__num_of                                    BCMOLT_XGPON_NI_ENABLE_ALL_ONUS_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_los_id_status                                                           BCMOLT_XGPON_NI_LOS_ID_STATUS
#define bcmolt_xgpon_ni_los_id__num_of                                                          BCMOLT_XGPON_NI_LOS_ID__NUM_OF
#define bcmolt_xgpon_ni_onu_discovered_id_serial_number                                         BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_SERIAL_NUMBER
#define bcmolt_xgpon_ni_onu_discovered_id_ranging_time                                          BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_RANGING_TIME
#define bcmolt_xgpon_ni_onu_discovered_id_onu_id                                                BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_ONU_ID
#define bcmolt_xgpon_ni_onu_discovered_id_upstream_line_rate_capabilities                       BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_UPSTREAM_LINE_RATE_CAPABILITIES
#define bcmolt_xgpon_ni_onu_discovered_id_current_downstream_pon_id                             BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_CURRENT_DOWNSTREAM_PON_ID
#define bcmolt_xgpon_ni_onu_discovered_id_current_upstream_pon_id                               BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_CURRENT_UPSTREAM_PON_ID
#define bcmolt_xgpon_ni_onu_discovered_id_calibration_record                                    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_CALIBRATION_RECORD
#define bcmolt_xgpon_ni_onu_discovered_id_tuning_granularity                                    BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_TUNING_GRANULARITY
#define bcmolt_xgpon_ni_onu_discovered_id_step_tuning_time                                      BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_STEP_TUNING_TIME
#define bcmolt_xgpon_ni_onu_discovered_id_attenuation                                           BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_ATTENUATION
#define bcmolt_xgpon_ni_onu_discovered_id_power_levelling_capabilities                          BCMOLT_XGPON_NI_ONU_DISCOVERED_ID_POWER_LEVELLING_CAPABILITIES
#define bcmolt_xgpon_ni_onu_discovered_id__num_of                                               BCMOLT_XGPON_NI_ONU_DISCOVERED_ID__NUM_OF
#define bcmolt_xgpon_ni_onu_upgrade_complete_id_status                                          BCMOLT_XGPON_NI_ONU_UPGRADE_COMPLETE_ID_STATUS
#define bcmolt_xgpon_ni_onu_upgrade_complete_id_list_of_failed_entities                         BCMOLT_XGPON_NI_ONU_UPGRADE_COMPLETE_ID_LIST_OF_FAILED_ENTITIES
#define bcmolt_xgpon_ni_onu_upgrade_complete_id__num_of                                         BCMOLT_XGPON_NI_ONU_UPGRADE_COMPLETE_ID__NUM_OF
#define bcmolt_xgpon_ni_protection_switching_onus_ranged_id_onus                                BCMOLT_XGPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID_ONUS
#define bcmolt_xgpon_ni_protection_switching_onus_ranged_id__num_of                             BCMOLT_XGPON_NI_PROTECTION_SWITCHING_ONUS_RANGED_ID__NUM_OF
#define bcmolt_xgpon_ni_protection_switching_switchover_completed_id_result                     BCMOLT_XGPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID_RESULT
#define bcmolt_xgpon_ni_protection_switching_switchover_completed_id__num_of                    BCMOLT_XGPON_NI_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_protection_switching_traffic_resume_id_result                           BCMOLT_XGPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID_RESULT
#define bcmolt_xgpon_ni_protection_switching_traffic_resume_id__num_of                          BCMOLT_XGPON_NI_PROTECTION_SWITCHING_TRAFFIC_RESUME_ID__NUM_OF
#define bcmolt_xgpon_ni_rogue_detection_completed_id_window_type                                BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_WINDOW_TYPE
#define bcmolt_xgpon_ni_rogue_detection_completed_id_measurement_status                         BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_MEASUREMENT_STATUS
#define bcmolt_xgpon_ni_rogue_detection_completed_id_alloc_id                                   BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_ALLOC_ID
#define bcmolt_xgpon_ni_rogue_detection_completed_id_onu_id                                     BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_ONU_ID
#define bcmolt_xgpon_ni_rogue_detection_completed_id_is_delineation                             BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_IS_DELINEATION
#define bcmolt_xgpon_ni_rogue_detection_completed_id_is_ed                                      BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_IS_ED
#define bcmolt_xgpon_ni_rogue_detection_completed_id_rx_data                                    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_RX_DATA
#define bcmolt_xgpon_ni_rogue_detection_completed_id_ploam_received_onu_id                      BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_PLOAM_RECEIVED_ONU_ID
#define bcmolt_xgpon_ni_rogue_detection_completed_id_ploam_received_mic_error                   BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID_PLOAM_RECEIVED_MIC_ERROR
#define bcmolt_xgpon_ni_rogue_detection_completed_id__num_of                                    BCMOLT_XGPON_NI_ROGUE_DETECTION_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_rogue_onu_special_map_cycle_start_id__num_of                            BCMOLT_XGPON_NI_ROGUE_ONU_SPECIAL_MAP_CYCLE_START_ID__NUM_OF
#define bcmolt_xgpon_ni_serial_number_acquisition_cycle_start_id__num_of                        BCMOLT_XGPON_NI_SERIAL_NUMBER_ACQUISITION_CYCLE_START_ID__NUM_OF
#define bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id_number_of_detected_delimiter  BCMOLT_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID_NUMBER_OF_DETECTED_DELIMITER
#define bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id_energy_detect_signal          BCMOLT_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID_ENERGY_DETECT_SIGNAL
#define bcmolt_xgpon_ni_standby_pon_monitoring_cycle_completed_id__num_of                       BCMOLT_XGPON_NI_STANDBY_PON_MONITORING_CYCLE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_stat_alarm_cleared_id_stat                                              BCMOLT_XGPON_NI_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_xgpon_ni_stat_alarm_cleared_id__num_of                                           BCMOLT_XGPON_NI_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_xgpon_ni_stat_alarm_raised_id_stat                                               BCMOLT_XGPON_NI_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_xgpon_ni_stat_alarm_raised_id__num_of                                            BCMOLT_XGPON_NI_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_xgpon_ni_state_change_completed_id_result                                        BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID_RESULT
#define bcmolt_xgpon_ni_state_change_completed_id_previous_state                                BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID_PREVIOUS_STATE
#define bcmolt_xgpon_ni_state_change_completed_id_new_state                                     BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID_NEW_STATE
#define bcmolt_xgpon_ni_state_change_completed_id__num_of                                       BCMOLT_XGPON_NI_STATE_CHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_tod_request_completed_id_tod_string                                     BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_TOD_STRING
#define bcmolt_xgpon_ni_tod_request_completed_id_sfc                                            BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_SFC
#define bcmolt_xgpon_ni_tod_request_completed_id_rtc_offset_sec                                 BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_RTC_OFFSET_SEC
#define bcmolt_xgpon_ni_tod_request_completed_id_rtc_offset_nsec                                BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_RTC_OFFSET_NSEC
#define bcmolt_xgpon_ni_tod_request_completed_id_status                                         BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID_STATUS
#define bcmolt_xgpon_ni_tod_request_completed_id__num_of                                        BCMOLT_XGPON_NI_TOD_REQUEST_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_ni_auto_cfg_id_activate_all_onus_completed                                 BCMOLT_XGPON_NI_AUTO_CFG_ID_ACTIVATE_ALL_ONUS_COMPLETED
#define bcmolt_xgpon_ni_auto_cfg_id_cpu_packets_failure                                         BCMOLT_XGPON_NI_AUTO_CFG_ID_CPU_PACKETS_FAILURE
#define bcmolt_xgpon_ni_auto_cfg_id_deactivate_all_onus_completed                               BCMOLT_XGPON_NI_AUTO_CFG_ID_DEACTIVATE_ALL_ONUS_COMPLETED
#define bcmolt_xgpon_ni_auto_cfg_id_disable_all_onus_completed                                  BCMOLT_XGPON_NI_AUTO_CFG_ID_DISABLE_ALL_ONUS_COMPLETED
#define bcmolt_xgpon_ni_auto_cfg_id_enable_all_onus_completed                                   BCMOLT_XGPON_NI_AUTO_CFG_ID_ENABLE_ALL_ONUS_COMPLETED
#define bcmolt_xgpon_ni_auto_cfg_id_los                                                         BCMOLT_XGPON_NI_AUTO_CFG_ID_LOS
#define bcmolt_xgpon_ni_auto_cfg_id_onu_discovered                                              BCMOLT_XGPON_NI_AUTO_CFG_ID_ONU_DISCOVERED
#define bcmolt_xgpon_ni_auto_cfg_id_onu_upgrade_complete                                        BCMOLT_XGPON_NI_AUTO_CFG_ID_ONU_UPGRADE_COMPLETE
#define bcmolt_xgpon_ni_auto_cfg_id_protection_switching_onus_ranged                            BCMOLT_XGPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_ONUS_RANGED
#define bcmolt_xgpon_ni_auto_cfg_id_protection_switching_switchover_completed                   BCMOLT_XGPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_SWITCHOVER_COMPLETED
#define bcmolt_xgpon_ni_auto_cfg_id_protection_switching_traffic_resume                         BCMOLT_XGPON_NI_AUTO_CFG_ID_PROTECTION_SWITCHING_TRAFFIC_RESUME
#define bcmolt_xgpon_ni_auto_cfg_id_rogue_detection_completed                                   BCMOLT_XGPON_NI_AUTO_CFG_ID_ROGUE_DETECTION_COMPLETED
#define bcmolt_xgpon_ni_auto_cfg_id_rogue_onu_special_map_cycle_start                           BCMOLT_XGPON_NI_AUTO_CFG_ID_ROGUE_ONU_SPECIAL_MAP_CYCLE_START
#define bcmolt_xgpon_ni_auto_cfg_id_serial_number_acquisition_cycle_start                       BCMOLT_XGPON_NI_AUTO_CFG_ID_SERIAL_NUMBER_ACQUISITION_CYCLE_START
#define bcmolt_xgpon_ni_auto_cfg_id_standby_pon_monitoring_cycle_completed                      BCMOLT_XGPON_NI_AUTO_CFG_ID_STANDBY_PON_MONITORING_CYCLE_COMPLETED
#define bcmolt_xgpon_ni_auto_cfg_id_stat_alarm_cleared                                          BCMOLT_XGPON_NI_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_xgpon_ni_auto_cfg_id_stat_alarm_raised                                           BCMOLT_XGPON_NI_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_xgpon_ni_auto_cfg_id_state_change_completed                                      BCMOLT_XGPON_NI_AUTO_CFG_ID_STATE_CHANGE_COMPLETED
#define bcmolt_xgpon_ni_auto_cfg_id_tod_request_completed                                       BCMOLT_XGPON_NI_AUTO_CFG_ID_TOD_REQUEST_COMPLETED
#define bcmolt_xgpon_ni_auto_cfg_id__num_of                                                     BCMOLT_XGPON_NI_AUTO_CFG_ID__NUM_OF
#define bcmolt_xgpon_ni_adjust_tx_wavelength_id_serial_number                                   BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID_SERIAL_NUMBER
#define bcmolt_xgpon_ni_adjust_tx_wavelength_id_freqency_adjustment_direction                   BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID_FREQENCY_ADJUSTMENT_DIRECTION
#define bcmolt_xgpon_ni_adjust_tx_wavelength_id_frequency_adjustment_size                       BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID_FREQUENCY_ADJUSTMENT_SIZE
#define bcmolt_xgpon_ni_adjust_tx_wavelength_id__num_of                                         BCMOLT_XGPON_NI_ADJUST_TX_WAVELENGTH_ID__NUM_OF
#define bcmolt_xgpon_ni_disable_serial_number_id_control                                        BCMOLT_XGPON_NI_DISABLE_SERIAL_NUMBER_ID_CONTROL
#define bcmolt_xgpon_ni_disable_serial_number_id_serial_number                                  BCMOLT_XGPON_NI_DISABLE_SERIAL_NUMBER_ID_SERIAL_NUMBER
#define bcmolt_xgpon_ni_disable_serial_number_id__num_of                                        BCMOLT_XGPON_NI_DISABLE_SERIAL_NUMBER_ID__NUM_OF
#define bcmolt_xgpon_ni_reset_id__num_of                                                        BCMOLT_XGPON_NI_RESET_ID__NUM_OF
#define bcmolt_xgpon_ni_rogue_detection_window_id_window_type                                   BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID_WINDOW_TYPE
#define bcmolt_xgpon_ni_rogue_detection_window_id_alloc_id                                      BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID_ALLOC_ID
#define bcmolt_xgpon_ni_rogue_detection_window_id_onu_id                                        BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID_ONU_ID
#define bcmolt_xgpon_ni_rogue_detection_window_id_second_ranging_window                         BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID_SECOND_RANGING_WINDOW
#define bcmolt_xgpon_ni_rogue_detection_window_id__num_of                                       BCMOLT_XGPON_NI_ROGUE_DETECTION_WINDOW_ID__NUM_OF
#define bcmolt_xgpon_ni_run_special_bw_map_id_number_of_cycle                                   BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID_NUMBER_OF_CYCLE
#define bcmolt_xgpon_ni_run_special_bw_map_id_allocation_number                                 BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID_ALLOCATION_NUMBER
#define bcmolt_xgpon_ni_run_special_bw_map_id_bw_map_array                                      BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID_BW_MAP_ARRAY
#define bcmolt_xgpon_ni_run_special_bw_map_id__num_of                                           BCMOLT_XGPON_NI_RUN_SPECIAL_BW_MAP_ID__NUM_OF
#define bcmolt_xgpon_ni_set_onu_state_id_onu_state                                              BCMOLT_XGPON_NI_SET_ONU_STATE_ID_ONU_STATE
#define bcmolt_xgpon_ni_set_onu_state_id__num_of                                                BCMOLT_XGPON_NI_SET_ONU_STATE_ID__NUM_OF
#define bcmolt_xgpon_ni_set_pon_state_id_pon_state                                              BCMOLT_XGPON_NI_SET_PON_STATE_ID_PON_STATE
#define bcmolt_xgpon_ni_set_pon_state_id__num_of                                                BCMOLT_XGPON_NI_SET_PON_STATE_ID__NUM_OF
#define bcmolt_xgpon_ni_single_request_standby_pon_monitoring_id__num_of                        BCMOLT_XGPON_NI_SINGLE_REQUEST_STANDBY_PON_MONITORING_ID__NUM_OF
#define bcmolt_xgpon_ni_start_onu_upgrade_id_list_of_onu_ids                                    BCMOLT_XGPON_NI_START_ONU_UPGRADE_ID_LIST_OF_ONU_IDS
#define bcmolt_xgpon_ni_start_onu_upgrade_id__num_of                                            BCMOLT_XGPON_NI_START_ONU_UPGRADE_ID__NUM_OF
#define bcmolt_xgpon_ni_tod_request_id__num_of                                                  BCMOLT_XGPON_NI_TOD_REQUEST_ID__NUM_OF
#define bcmolt_xgpon_ni_broadcast_ploam_packet_id_ploam                                         BCMOLT_XGPON_NI_BROADCAST_PLOAM_PACKET_ID_PLOAM
#define bcmolt_xgpon_ni_broadcast_ploam_packet_id__num_of                                       BCMOLT_XGPON_NI_BROADCAST_PLOAM_PACKET_ID__NUM_OF
#define bcmolt_xgpon_ni_cpu_packets_id_packet_type                                              BCMOLT_XGPON_NI_CPU_PACKETS_ID_PACKET_TYPE
#define bcmolt_xgpon_ni_cpu_packets_id_calc_crc                                                 BCMOLT_XGPON_NI_CPU_PACKETS_ID_CALC_CRC
#define bcmolt_xgpon_ni_cpu_packets_id_gem_port_list                                            BCMOLT_XGPON_NI_CPU_PACKETS_ID_GEM_PORT_LIST
#define bcmolt_xgpon_ni_cpu_packets_id_buffer                                                   BCMOLT_XGPON_NI_CPU_PACKETS_ID_BUFFER
#define bcmolt_xgpon_ni_cpu_packets_id__num_of                                                  BCMOLT_XGPON_NI_CPU_PACKETS_ID__NUM_OF
#define bcmolt_xgpon_onu_key_id_pon_ni                                                          BCMOLT_XGPON_ONU_KEY_ID_PON_NI
#define bcmolt_xgpon_onu_key_id_onu_id                                                          BCMOLT_XGPON_ONU_KEY_ID_ONU_ID
#define bcmolt_xgpon_onu_key_id__num_of                                                         BCMOLT_XGPON_ONU_KEY_ID__NUM_OF
#define bcmolt_xgpon_onu_cfg_id_onu_state                                                       BCMOLT_XGPON_ONU_CFG_ID_ONU_STATE
#define bcmolt_xgpon_onu_cfg_id_onu_old_state                                                   BCMOLT_XGPON_ONU_CFG_ID_ONU_OLD_STATE
#define bcmolt_xgpon_onu_cfg_id_alarm_state                                                     BCMOLT_XGPON_ONU_CFG_ID_ALARM_STATE
#define bcmolt_xgpon_onu_cfg_id_registration_encryption_keys                                    BCMOLT_XGPON_ONU_CFG_ID_REGISTRATION_ENCRYPTION_KEYS
#define bcmolt_xgpon_onu_cfg_id_current_encryption_key                                          BCMOLT_XGPON_ONU_CFG_ID_CURRENT_ENCRYPTION_KEY
#define bcmolt_xgpon_onu_cfg_id_serial_number                                                   BCMOLT_XGPON_ONU_CFG_ID_SERIAL_NUMBER
#define bcmolt_xgpon_onu_cfg_id_registration_id                                                 BCMOLT_XGPON_ONU_CFG_ID_REGISTRATION_ID
#define bcmolt_xgpon_onu_cfg_id_registration_id_auto_learning                                   BCMOLT_XGPON_ONU_CFG_ID_REGISTRATION_ID_AUTO_LEARNING
#define bcmolt_xgpon_onu_cfg_id_ranging_burst_profile                                           BCMOLT_XGPON_ONU_CFG_ID_RANGING_BURST_PROFILE
#define bcmolt_xgpon_onu_cfg_id_data_burst_profile                                              BCMOLT_XGPON_ONU_CFG_ID_DATA_BURST_PROFILE
#define bcmolt_xgpon_onu_cfg_id_ranging_time                                                    BCMOLT_XGPON_ONU_CFG_ID_RANGING_TIME
#define bcmolt_xgpon_onu_cfg_id_disabled_after_discovery                                        BCMOLT_XGPON_ONU_CFG_ID_DISABLED_AFTER_DISCOVERY
#define bcmolt_xgpon_onu_cfg_id_deactivation_reason                                             BCMOLT_XGPON_ONU_CFG_ID_DEACTIVATION_REASON
#define bcmolt_xgpon_onu_cfg_id_all_gem_ports                                                   BCMOLT_XGPON_ONU_CFG_ID_ALL_GEM_PORTS
#define bcmolt_xgpon_onu_cfg_id_all_allocs                                                      BCMOLT_XGPON_ONU_CFG_ID_ALL_ALLOCS
#define bcmolt_xgpon_onu_cfg_id_extended_guard_time                                             BCMOLT_XGPON_ONU_CFG_ID_EXTENDED_GUARD_TIME
#define bcmolt_xgpon_onu_cfg_id_us_line_rate                                                    BCMOLT_XGPON_ONU_CFG_ID_US_LINE_RATE
#define bcmolt_xgpon_onu_cfg_id_calibration_record                                              BCMOLT_XGPON_ONU_CFG_ID_CALIBRATION_RECORD
#define bcmolt_xgpon_onu_cfg_id_tuning_granularity                                              BCMOLT_XGPON_ONU_CFG_ID_TUNING_GRANULARITY
#define bcmolt_xgpon_onu_cfg_id_step_tuning_time                                                BCMOLT_XGPON_ONU_CFG_ID_STEP_TUNING_TIME
#define bcmolt_xgpon_onu_cfg_id_power_levelling_capabilities                                    BCMOLT_XGPON_ONU_CFG_ID_POWER_LEVELLING_CAPABILITIES
#define bcmolt_xgpon_onu_cfg_id_request_registration_status                                     BCMOLT_XGPON_ONU_CFG_ID_REQUEST_REGISTRATION_STATUS
#define bcmolt_xgpon_onu_cfg_id__num_of                                                         BCMOLT_XGPON_ONU_CFG_ID__NUM_OF
#define bcmolt_xgpon_onu_stat_id_positive_drift                                                 BCMOLT_XGPON_ONU_STAT_ID_POSITIVE_DRIFT
#define bcmolt_xgpon_onu_stat_id_negative_drift                                                 BCMOLT_XGPON_ONU_STAT_ID_NEGATIVE_DRIFT
#define bcmolt_xgpon_onu_stat_id_delimiter_miss_detection                                       BCMOLT_XGPON_ONU_STAT_ID_DELIMITER_MISS_DETECTION
#define bcmolt_xgpon_onu_stat_id_bip32_errors                                                   BCMOLT_XGPON_ONU_STAT_ID_BIP32_ERRORS
#define bcmolt_xgpon_onu_stat_id_rx_words                                                       BCMOLT_XGPON_ONU_STAT_ID_RX_WORDS
#define bcmolt_xgpon_onu_stat_id_fec_corrected_symbols                                          BCMOLT_XGPON_ONU_STAT_ID_FEC_CORRECTED_SYMBOLS
#define bcmolt_xgpon_onu_stat_id_fec_corrected_codewords                                        BCMOLT_XGPON_ONU_STAT_ID_FEC_CORRECTED_CODEWORDS
#define bcmolt_xgpon_onu_stat_id_fec_uncorrectable_codewords                                    BCMOLT_XGPON_ONU_STAT_ID_FEC_UNCORRECTABLE_CODEWORDS
#define bcmolt_xgpon_onu_stat_id_fec_codewords                                                  BCMOLT_XGPON_ONU_STAT_ID_FEC_CODEWORDS
#define bcmolt_xgpon_onu_stat_id_fec_corrected_bits                                             BCMOLT_XGPON_ONU_STAT_ID_FEC_CORRECTED_BITS
#define bcmolt_xgpon_onu_stat_id_xgem_key_errors                                                BCMOLT_XGPON_ONU_STAT_ID_XGEM_KEY_ERRORS
#define bcmolt_xgpon_onu_stat_id_xgem_loss                                                      BCMOLT_XGPON_ONU_STAT_ID_XGEM_LOSS
#define bcmolt_xgpon_onu_stat_id_rx_ploams_mic_error                                            BCMOLT_XGPON_ONU_STAT_ID_RX_PLOAMS_MIC_ERROR
#define bcmolt_xgpon_onu_stat_id_rx_ploams_non_idle                                             BCMOLT_XGPON_ONU_STAT_ID_RX_PLOAMS_NON_IDLE
#define bcmolt_xgpon_onu_stat_id_rx_omci                                                        BCMOLT_XGPON_ONU_STAT_ID_RX_OMCI
#define bcmolt_xgpon_onu_stat_id_rx_omci_packets_crc_error                                      BCMOLT_XGPON_ONU_STAT_ID_RX_OMCI_PACKETS_CRC_ERROR
#define bcmolt_xgpon_onu_stat_id_rx_bytes                                                       BCMOLT_XGPON_ONU_STAT_ID_RX_BYTES
#define bcmolt_xgpon_onu_stat_id_rx_packets                                                     BCMOLT_XGPON_ONU_STAT_ID_RX_PACKETS
#define bcmolt_xgpon_onu_stat_id_tx_bytes                                                       BCMOLT_XGPON_ONU_STAT_ID_TX_BYTES
#define bcmolt_xgpon_onu_stat_id_tx_packets                                                     BCMOLT_XGPON_ONU_STAT_ID_TX_PACKETS
#define bcmolt_xgpon_onu_stat_id__num_of                                                        BCMOLT_XGPON_ONU_STAT_ID__NUM_OF
#define bcmolt_xgpon_onu_stat_cfg_id_cfg                                                        BCMOLT_XGPON_ONU_STAT_CFG_ID_CFG
#define bcmolt_xgpon_onu_stat_cfg_id__num_of                                                    BCMOLT_XGPON_ONU_STAT_CFG_ID__NUM_OF
#define bcmolt_xgpon_onu_dfi_id_alarm_status                                                    BCMOLT_XGPON_ONU_DFI_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_dfi_id__num_of                                                         BCMOLT_XGPON_ONU_DFI_ID__NUM_OF
#define bcmolt_xgpon_onu_dgi_id_alarm_status                                                    BCMOLT_XGPON_ONU_DGI_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_dgi_id__num_of                                                         BCMOLT_XGPON_ONU_DGI_ID__NUM_OF
#define bcmolt_xgpon_onu_dowi_id_alarm_status                                                   BCMOLT_XGPON_ONU_DOWI_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_dowi_id_drift_value                                                    BCMOLT_XGPON_ONU_DOWI_ID_DRIFT_VALUE
#define bcmolt_xgpon_onu_dowi_id_new_eqd                                                        BCMOLT_XGPON_ONU_DOWI_ID_NEW_EQD
#define bcmolt_xgpon_onu_dowi_id__num_of                                                        BCMOLT_XGPON_ONU_DOWI_ID__NUM_OF
#define bcmolt_xgpon_onu_invalid_dbru_report_id_alloc_id                                        BCMOLT_XGPON_ONU_INVALID_DBRU_REPORT_ID_ALLOC_ID
#define bcmolt_xgpon_onu_invalid_dbru_report_id__num_of                                         BCMOLT_XGPON_ONU_INVALID_DBRU_REPORT_ID__NUM_OF
#define bcmolt_xgpon_onu_key_exchange_completed_id_new_key                                      BCMOLT_XGPON_ONU_KEY_EXCHANGE_COMPLETED_ID_NEW_KEY
#define bcmolt_xgpon_onu_key_exchange_completed_id__num_of                                      BCMOLT_XGPON_ONU_KEY_EXCHANGE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_key_exchange_cycle_skipped_id__num_of                                  BCMOLT_XGPON_ONU_KEY_EXCHANGE_CYCLE_SKIPPED_ID__NUM_OF
#define bcmolt_xgpon_onu_key_exchange_key_mismatch_id_expected_key                              BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID_EXPECTED_KEY
#define bcmolt_xgpon_onu_key_exchange_key_mismatch_id_received_key                              BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID_RECEIVED_KEY
#define bcmolt_xgpon_onu_key_exchange_key_mismatch_id__num_of                                   BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_MISMATCH_ID__NUM_OF
#define bcmolt_xgpon_onu_key_exchange_key_request_timeout_id__num_of                            BCMOLT_XGPON_ONU_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT_ID__NUM_OF
#define bcmolt_xgpon_onu_looci_id_alarm_status                                                  BCMOLT_XGPON_ONU_LOOCI_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_looci_id__num_of                                                       BCMOLT_XGPON_ONU_LOOCI_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_activation_completed_id_status                                     BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID_STATUS
#define bcmolt_xgpon_onu_onu_activation_completed_id_fail_reason                                BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID_FAIL_REASON
#define bcmolt_xgpon_onu_onu_activation_completed_id_registration_id                            BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID_REGISTRATION_ID
#define bcmolt_xgpon_onu_onu_activation_completed_id_registration_encryption_keys               BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID_REGISTRATION_ENCRYPTION_KEYS
#define bcmolt_xgpon_onu_onu_activation_completed_id__num_of                                    BCMOLT_XGPON_ONU_ONU_ACTIVATION_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_alarm_id_onu_alarm                                                 BCMOLT_XGPON_ONU_ONU_ALARM_ID_ONU_ALARM
#define bcmolt_xgpon_onu_onu_alarm_id__num_of                                                   BCMOLT_XGPON_ONU_ONU_ALARM_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_deactivation_completed_id_status                                   BCMOLT_XGPON_ONU_ONU_DEACTIVATION_COMPLETED_ID_STATUS
#define bcmolt_xgpon_onu_onu_deactivation_completed_id__num_of                                  BCMOLT_XGPON_ONU_ONU_DEACTIVATION_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_disable_completed_id_serial_number                                 BCMOLT_XGPON_ONU_ONU_DISABLE_COMPLETED_ID_SERIAL_NUMBER
#define bcmolt_xgpon_onu_onu_disable_completed_id__num_of                                       BCMOLT_XGPON_ONU_ONU_DISABLE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_enable_completed_id_serial_number                                  BCMOLT_XGPON_ONU_ONU_ENABLE_COMPLETED_ID_SERIAL_NUMBER
#define bcmolt_xgpon_onu_onu_enable_completed_id__num_of                                        BCMOLT_XGPON_ONU_ONU_ENABLE_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_tuning_in_completed_id_result                                      BCMOLT_XGPON_ONU_ONU_TUNING_IN_COMPLETED_ID_RESULT
#define bcmolt_xgpon_onu_onu_tuning_in_completed_id_fail_reason                                 BCMOLT_XGPON_ONU_ONU_TUNING_IN_COMPLETED_ID_FAIL_REASON
#define bcmolt_xgpon_onu_onu_tuning_in_completed_id__num_of                                     BCMOLT_XGPON_ONU_ONU_TUNING_IN_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_tuning_out_completed_id_result                                     BCMOLT_XGPON_ONU_ONU_TUNING_OUT_COMPLETED_ID_RESULT
#define bcmolt_xgpon_onu_onu_tuning_out_completed_id_fail_reason                                BCMOLT_XGPON_ONU_ONU_TUNING_OUT_COMPLETED_ID_FAIL_REASON
#define bcmolt_xgpon_onu_onu_tuning_out_completed_id__num_of                                    BCMOLT_XGPON_ONU_ONU_TUNING_OUT_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_optical_reflection_id__num_of                                          BCMOLT_XGPON_ONU_OPTICAL_REFLECTION_ID__NUM_OF
#define bcmolt_xgpon_onu_possible_drift_id_alarm_status                                         BCMOLT_XGPON_ONU_POSSIBLE_DRIFT_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_possible_drift_id_estimated_drift                                      BCMOLT_XGPON_ONU_POSSIBLE_DRIFT_ID_ESTIMATED_DRIFT
#define bcmolt_xgpon_onu_possible_drift_id__num_of                                              BCMOLT_XGPON_ONU_POSSIBLE_DRIFT_ID__NUM_OF
#define bcmolt_xgpon_onu_power_consumption_report_id_power_consumption_report                   BCMOLT_XGPON_ONU_POWER_CONSUMPTION_REPORT_ID_POWER_CONSUMPTION_REPORT
#define bcmolt_xgpon_onu_power_consumption_report_id__num_of                                    BCMOLT_XGPON_ONU_POWER_CONSUMPTION_REPORT_ID__NUM_OF
#define bcmolt_xgpon_onu_power_level_report_id_attenuation                                      BCMOLT_XGPON_ONU_POWER_LEVEL_REPORT_ID_ATTENUATION
#define bcmolt_xgpon_onu_power_level_report_id_power_levelling_capability                       BCMOLT_XGPON_ONU_POWER_LEVEL_REPORT_ID_POWER_LEVELLING_CAPABILITY
#define bcmolt_xgpon_onu_power_level_report_id__num_of                                          BCMOLT_XGPON_ONU_POWER_LEVEL_REPORT_ID__NUM_OF
#define bcmolt_xgpon_onu_power_management_state_change_id_old_state                             BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_OLD_STATE
#define bcmolt_xgpon_onu_power_management_state_change_id_new_state                             BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_NEW_STATE
#define bcmolt_xgpon_onu_power_management_state_change_id_reason                                BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID_REASON
#define bcmolt_xgpon_onu_power_management_state_change_id__num_of                               BCMOLT_XGPON_ONU_POWER_MANAGEMENT_STATE_CHANGE_ID__NUM_OF
#define bcmolt_xgpon_onu_pqsi_id_alarm_status                                                   BCMOLT_XGPON_ONU_PQSI_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_pqsi_id__num_of                                                        BCMOLT_XGPON_ONU_PQSI_ID__NUM_OF
#define bcmolt_xgpon_onu_ranging_completed_id_status                                            BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_STATUS
#define bcmolt_xgpon_onu_ranging_completed_id_fail_reason                                       BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_FAIL_REASON
#define bcmolt_xgpon_onu_ranging_completed_id_eqd                                               BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_EQD
#define bcmolt_xgpon_onu_ranging_completed_id_number_of_ploams                                  BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_NUMBER_OF_PLOAMS
#define bcmolt_xgpon_onu_ranging_completed_id_power_level                                       BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID_POWER_LEVEL
#define bcmolt_xgpon_onu_ranging_completed_id__num_of                                           BCMOLT_XGPON_ONU_RANGING_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_registration_id_id_registration_id                                     BCMOLT_XGPON_ONU_REGISTRATION_ID_ID_REGISTRATION_ID
#define bcmolt_xgpon_onu_registration_id_id_request_registration_status                         BCMOLT_XGPON_ONU_REGISTRATION_ID_ID_REQUEST_REGISTRATION_STATUS
#define bcmolt_xgpon_onu_registration_id_id_request_registration_fail_reason                    BCMOLT_XGPON_ONU_REGISTRATION_ID_ID_REQUEST_REGISTRATION_FAIL_REASON
#define bcmolt_xgpon_onu_registration_id_id__num_of                                             BCMOLT_XGPON_ONU_REGISTRATION_ID_ID__NUM_OF
#define bcmolt_xgpon_onu_rssi_measurement_completed_id_status                                   BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID_STATUS
#define bcmolt_xgpon_onu_rssi_measurement_completed_id_fail_reason                              BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID_FAIL_REASON
#define bcmolt_xgpon_onu_rssi_measurement_completed_id__num_of                                  BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_COMPLETED_ID__NUM_OF
#define bcmolt_xgpon_onu_sdi_id_alarm_status                                                    BCMOLT_XGPON_ONU_SDI_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_sdi_id_ber                                                             BCMOLT_XGPON_ONU_SDI_ID_BER
#define bcmolt_xgpon_onu_sdi_id__num_of                                                         BCMOLT_XGPON_ONU_SDI_ID__NUM_OF
#define bcmolt_xgpon_onu_secure_mutual_authentication_failure_id_status                         BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE_ID_STATUS
#define bcmolt_xgpon_onu_secure_mutual_authentication_failure_id_fail_reason                    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE_ID_FAIL_REASON
#define bcmolt_xgpon_onu_secure_mutual_authentication_failure_id__num_of                        BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_FAILURE_ID__NUM_OF
#define bcmolt_xgpon_onu_sfi_id_alarm_status                                                    BCMOLT_XGPON_ONU_SFI_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_sfi_id_ber                                                             BCMOLT_XGPON_ONU_SFI_ID_BER
#define bcmolt_xgpon_onu_sfi_id__num_of                                                         BCMOLT_XGPON_ONU_SFI_ID__NUM_OF
#define bcmolt_xgpon_onu_stat_alarm_cleared_id_stat                                             BCMOLT_XGPON_ONU_STAT_ALARM_CLEARED_ID_STAT
#define bcmolt_xgpon_onu_stat_alarm_cleared_id__num_of                                          BCMOLT_XGPON_ONU_STAT_ALARM_CLEARED_ID__NUM_OF
#define bcmolt_xgpon_onu_stat_alarm_raised_id_stat                                              BCMOLT_XGPON_ONU_STAT_ALARM_RAISED_ID_STAT
#define bcmolt_xgpon_onu_stat_alarm_raised_id__num_of                                           BCMOLT_XGPON_ONU_STAT_ALARM_RAISED_ID__NUM_OF
#define bcmolt_xgpon_onu_sufi_id_alarm_status                                                   BCMOLT_XGPON_ONU_SUFI_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_sufi_id__num_of                                                        BCMOLT_XGPON_ONU_SUFI_ID__NUM_OF
#define bcmolt_xgpon_onu_tiwi_id_alarm_status                                                   BCMOLT_XGPON_ONU_TIWI_ID_ALARM_STATUS
#define bcmolt_xgpon_onu_tiwi_id_drift_value                                                    BCMOLT_XGPON_ONU_TIWI_ID_DRIFT_VALUE
#define bcmolt_xgpon_onu_tiwi_id__num_of                                                        BCMOLT_XGPON_ONU_TIWI_ID__NUM_OF
#define bcmolt_xgpon_onu_tuning_response_id_ack                                                 BCMOLT_XGPON_ONU_TUNING_RESPONSE_ID_ACK
#define bcmolt_xgpon_onu_tuning_response_id_result                                              BCMOLT_XGPON_ONU_TUNING_RESPONSE_ID_RESULT
#define bcmolt_xgpon_onu_tuning_response_id__num_of                                             BCMOLT_XGPON_ONU_TUNING_RESPONSE_ID__NUM_OF
#define bcmolt_xgpon_onu_auto_cfg_id_dfi                                                        BCMOLT_XGPON_ONU_AUTO_CFG_ID_DFI
#define bcmolt_xgpon_onu_auto_cfg_id_dgi                                                        BCMOLT_XGPON_ONU_AUTO_CFG_ID_DGI
#define bcmolt_xgpon_onu_auto_cfg_id_dowi                                                       BCMOLT_XGPON_ONU_AUTO_CFG_ID_DOWI
#define bcmolt_xgpon_onu_auto_cfg_id_invalid_dbru_report                                        BCMOLT_XGPON_ONU_AUTO_CFG_ID_INVALID_DBRU_REPORT
#define bcmolt_xgpon_onu_auto_cfg_id_key_exchange_completed                                     BCMOLT_XGPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_COMPLETED
#define bcmolt_xgpon_onu_auto_cfg_id_key_exchange_cycle_skipped                                 BCMOLT_XGPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_CYCLE_SKIPPED
#define bcmolt_xgpon_onu_auto_cfg_id_key_exchange_key_mismatch                                  BCMOLT_XGPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_KEY_MISMATCH
#define bcmolt_xgpon_onu_auto_cfg_id_key_exchange_key_request_timeout                           BCMOLT_XGPON_ONU_AUTO_CFG_ID_KEY_EXCHANGE_KEY_REQUEST_TIMEOUT
#define bcmolt_xgpon_onu_auto_cfg_id_looci                                                      BCMOLT_XGPON_ONU_AUTO_CFG_ID_LOOCI
#define bcmolt_xgpon_onu_auto_cfg_id_onu_activation_completed                                   BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_ACTIVATION_COMPLETED
#define bcmolt_xgpon_onu_auto_cfg_id_onu_alarm                                                  BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_ALARM
#define bcmolt_xgpon_onu_auto_cfg_id_onu_deactivation_completed                                 BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_DEACTIVATION_COMPLETED
#define bcmolt_xgpon_onu_auto_cfg_id_onu_disable_completed                                      BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_DISABLE_COMPLETED
#define bcmolt_xgpon_onu_auto_cfg_id_onu_enable_completed                                       BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_ENABLE_COMPLETED
#define bcmolt_xgpon_onu_auto_cfg_id_onu_tuning_in_completed                                    BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_TUNING_IN_COMPLETED
#define bcmolt_xgpon_onu_auto_cfg_id_onu_tuning_out_completed                                   BCMOLT_XGPON_ONU_AUTO_CFG_ID_ONU_TUNING_OUT_COMPLETED
#define bcmolt_xgpon_onu_auto_cfg_id_optical_reflection                                         BCMOLT_XGPON_ONU_AUTO_CFG_ID_OPTICAL_REFLECTION
#define bcmolt_xgpon_onu_auto_cfg_id_possible_drift                                             BCMOLT_XGPON_ONU_AUTO_CFG_ID_POSSIBLE_DRIFT
#define bcmolt_xgpon_onu_auto_cfg_id_power_consumption_report                                   BCMOLT_XGPON_ONU_AUTO_CFG_ID_POWER_CONSUMPTION_REPORT
#define bcmolt_xgpon_onu_auto_cfg_id_power_level_report                                         BCMOLT_XGPON_ONU_AUTO_CFG_ID_POWER_LEVEL_REPORT
#define bcmolt_xgpon_onu_auto_cfg_id_power_management_state_change                              BCMOLT_XGPON_ONU_AUTO_CFG_ID_POWER_MANAGEMENT_STATE_CHANGE
#define bcmolt_xgpon_onu_auto_cfg_id_pqsi                                                       BCMOLT_XGPON_ONU_AUTO_CFG_ID_PQSI
#define bcmolt_xgpon_onu_auto_cfg_id_ranging_completed                                          BCMOLT_XGPON_ONU_AUTO_CFG_ID_RANGING_COMPLETED
#define bcmolt_xgpon_onu_auto_cfg_id_registration_id                                            BCMOLT_XGPON_ONU_AUTO_CFG_ID_REGISTRATION_ID
#define bcmolt_xgpon_onu_auto_cfg_id_rssi_measurement_completed                                 BCMOLT_XGPON_ONU_AUTO_CFG_ID_RSSI_MEASUREMENT_COMPLETED
#define bcmolt_xgpon_onu_auto_cfg_id_sdi                                                        BCMOLT_XGPON_ONU_AUTO_CFG_ID_SDI
#define bcmolt_xgpon_onu_auto_cfg_id_secure_mutual_authentication_failure                       BCMOLT_XGPON_ONU_AUTO_CFG_ID_SECURE_MUTUAL_AUTHENTICATION_FAILURE
#define bcmolt_xgpon_onu_auto_cfg_id_sfi                                                        BCMOLT_XGPON_ONU_AUTO_CFG_ID_SFI
#define bcmolt_xgpon_onu_auto_cfg_id_stat_alarm_cleared                                         BCMOLT_XGPON_ONU_AUTO_CFG_ID_STAT_ALARM_CLEARED
#define bcmolt_xgpon_onu_auto_cfg_id_stat_alarm_raised                                          BCMOLT_XGPON_ONU_AUTO_CFG_ID_STAT_ALARM_RAISED
#define bcmolt_xgpon_onu_auto_cfg_id_sufi                                                       BCMOLT_XGPON_ONU_AUTO_CFG_ID_SUFI
#define bcmolt_xgpon_onu_auto_cfg_id_tiwi                                                       BCMOLT_XGPON_ONU_AUTO_CFG_ID_TIWI
#define bcmolt_xgpon_onu_auto_cfg_id_tuning_response                                            BCMOLT_XGPON_ONU_AUTO_CFG_ID_TUNING_RESPONSE
#define bcmolt_xgpon_onu_auto_cfg_id__num_of                                                    BCMOLT_XGPON_ONU_AUTO_CFG_ID__NUM_OF
#define bcmolt_xgpon_onu_adjust_tx_wavelength_id_frequency_adjustment_direction                 BCMOLT_XGPON_ONU_ADJUST_TX_WAVELENGTH_ID_FREQUENCY_ADJUSTMENT_DIRECTION
#define bcmolt_xgpon_onu_adjust_tx_wavelength_id_frequency_adjustment_size                      BCMOLT_XGPON_ONU_ADJUST_TX_WAVELENGTH_ID_FREQUENCY_ADJUSTMENT_SIZE
#define bcmolt_xgpon_onu_adjust_tx_wavelength_id__num_of                                        BCMOLT_XGPON_ONU_ADJUST_TX_WAVELENGTH_ID__NUM_OF
#define bcmolt_xgpon_onu_change_power_levelling_id_control                                      BCMOLT_XGPON_ONU_CHANGE_POWER_LEVELLING_ID_CONTROL
#define bcmolt_xgpon_onu_change_power_levelling_id_attenuation                                  BCMOLT_XGPON_ONU_CHANGE_POWER_LEVELLING_ID_ATTENUATION
#define bcmolt_xgpon_onu_change_power_levelling_id__num_of                                      BCMOLT_XGPON_ONU_CHANGE_POWER_LEVELLING_ID__NUM_OF
#define bcmolt_xgpon_onu_get_power_consumption_id__num_of                                       BCMOLT_XGPON_ONU_GET_POWER_CONSUMPTION_ID__NUM_OF
#define bcmolt_xgpon_onu_get_power_level_id__num_of                                             BCMOLT_XGPON_ONU_GET_POWER_LEVEL_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_tuning_in_id__num_of                                               BCMOLT_XGPON_ONU_ONU_TUNING_IN_ID__NUM_OF
#define bcmolt_xgpon_onu_onu_tuning_out_id_target_ds_pon_id                                     BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_TARGET_DS_PON_ID
#define bcmolt_xgpon_onu_onu_tuning_out_id_target_us_pon_id                                     BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_TARGET_US_PON_ID
#define bcmolt_xgpon_onu_onu_tuning_out_id_time_to_switch                                       BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_TIME_TO_SWITCH
#define bcmolt_xgpon_onu_onu_tuning_out_id_rollback                                             BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_ROLLBACK
#define bcmolt_xgpon_onu_onu_tuning_out_id_status                                               BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID_STATUS
#define bcmolt_xgpon_onu_onu_tuning_out_id__num_of                                              BCMOLT_XGPON_ONU_ONU_TUNING_OUT_ID__NUM_OF
#define bcmolt_xgpon_onu_request_registration_id_sma_flag                                       BCMOLT_XGPON_ONU_REQUEST_REGISTRATION_ID_SMA_FLAG
#define bcmolt_xgpon_onu_request_registration_id__num_of                                        BCMOLT_XGPON_ONU_REQUEST_REGISTRATION_ID__NUM_OF
#define bcmolt_xgpon_onu_rssi_measurement_id__num_of                                            BCMOLT_XGPON_ONU_RSSI_MEASUREMENT_ID__NUM_OF
#define bcmolt_xgpon_onu_secure_mutual_authentication_id_master_key                             BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID_MASTER_KEY
#define bcmolt_xgpon_onu_secure_mutual_authentication_id_buffer                                 BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID_BUFFER
#define bcmolt_xgpon_onu_secure_mutual_authentication_id_mic                                    BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID_MIC
#define bcmolt_xgpon_onu_secure_mutual_authentication_id__num_of                                BCMOLT_XGPON_ONU_SECURE_MUTUAL_AUTHENTICATION_ID__NUM_OF
#define bcmolt_xgpon_onu_set_onu_state_id_onu_state                                             BCMOLT_XGPON_ONU_SET_ONU_STATE_ID_ONU_STATE
#define bcmolt_xgpon_onu_set_onu_state_id__num_of                                               BCMOLT_XGPON_ONU_SET_ONU_STATE_ID__NUM_OF
#define bcmolt_xgpon_onu_cpu_packets_id_packet_type                                             BCMOLT_XGPON_ONU_CPU_PACKETS_ID_PACKET_TYPE
#define bcmolt_xgpon_onu_cpu_packets_id_calc_crc                                                BCMOLT_XGPON_ONU_CPU_PACKETS_ID_CALC_CRC
#define bcmolt_xgpon_onu_cpu_packets_id_number_of_packets                                       BCMOLT_XGPON_ONU_CPU_PACKETS_ID_NUMBER_OF_PACKETS
#define bcmolt_xgpon_onu_cpu_packets_id_packet_size                                             BCMOLT_XGPON_ONU_CPU_PACKETS_ID_PACKET_SIZE
#define bcmolt_xgpon_onu_cpu_packets_id_buffer                                                  BCMOLT_XGPON_ONU_CPU_PACKETS_ID_BUFFER
#define bcmolt_xgpon_onu_cpu_packets_id__num_of                                                 BCMOLT_XGPON_ONU_CPU_PACKETS_ID__NUM_OF
#define bcmolt_xgpon_onu_ploam_packet_id_default_key                                            BCMOLT_XGPON_ONU_PLOAM_PACKET_ID_DEFAULT_KEY
#define bcmolt_xgpon_onu_ploam_packet_id_ploam                                                  BCMOLT_XGPON_ONU_PLOAM_PACKET_ID_PLOAM
#define bcmolt_xgpon_onu_ploam_packet_id__num_of                                                BCMOLT_XGPON_ONU_PLOAM_PACKET_ID__NUM_OF
#define bcmolt_xgpon_onu_cpu_packet_id_port_id                                                  BCMOLT_XGPON_ONU_CPU_PACKET_ID_PORT_ID
#define bcmolt_xgpon_onu_cpu_packet_id_crc_ok                                                   BCMOLT_XGPON_ONU_CPU_PACKET_ID_CRC_OK
#define bcmolt_xgpon_onu_cpu_packet_id_packet_size                                              BCMOLT_XGPON_ONU_CPU_PACKET_ID_PACKET_SIZE
#define bcmolt_xgpon_onu_cpu_packet_id_buffer                                                   BCMOLT_XGPON_ONU_CPU_PACKET_ID_BUFFER
#define bcmolt_xgpon_onu_cpu_packet_id__num_of                                                  BCMOLT_XGPON_ONU_CPU_PACKET_ID__NUM_OF
#define bcmolt_xgpon_onu_omci_packet_id_port_id                                                 BCMOLT_XGPON_ONU_OMCI_PACKET_ID_PORT_ID
#define bcmolt_xgpon_onu_omci_packet_id_crc_ok                                                  BCMOLT_XGPON_ONU_OMCI_PACKET_ID_CRC_OK
#define bcmolt_xgpon_onu_omci_packet_id_packet_size                                             BCMOLT_XGPON_ONU_OMCI_PACKET_ID_PACKET_SIZE
#define bcmolt_xgpon_onu_omci_packet_id_buffer                                                  BCMOLT_XGPON_ONU_OMCI_PACKET_ID_BUFFER
#define bcmolt_xgpon_onu_omci_packet_id__num_of                                                 BCMOLT_XGPON_ONU_OMCI_PACKET_ID__NUM_OF
#define bcmolt_xgpon_trx_key_id_pon_ni                                                          BCMOLT_XGPON_TRX_KEY_ID_PON_NI
#define bcmolt_xgpon_trx_key_id__num_of                                                         BCMOLT_XGPON_TRX_KEY_ID__NUM_OF
#define bcmolt_xgpon_trx_cfg_id_burst_profile                                                   BCMOLT_XGPON_TRX_CFG_ID_BURST_PROFILE
#define bcmolt_xgpon_trx_cfg_id_transceiver_config                                              BCMOLT_XGPON_TRX_CFG_ID_TRANSCEIVER_CONFIG
#define bcmolt_xgpon_trx_cfg_id_transceiver_type                                                BCMOLT_XGPON_TRX_CFG_ID_TRANSCEIVER_TYPE
#define bcmolt_xgpon_trx_cfg_id_debug                                                           BCMOLT_XGPON_TRX_CFG_ID_DEBUG
#define bcmolt_xgpon_trx_cfg_id_rssi_normal_config                                              BCMOLT_XGPON_TRX_CFG_ID_RSSI_NORMAL_CONFIG
#define bcmolt_xgpon_trx_cfg_id_rssi_ranging_config                                             BCMOLT_XGPON_TRX_CFG_ID_RSSI_RANGING_CONFIG
#define bcmolt_xgpon_trx_cfg_id_serdes_configuration                                            BCMOLT_XGPON_TRX_CFG_ID_SERDES_CONFIGURATION
#define bcmolt_xgpon_trx_cfg_id_burst_profile_delimiter_max_errors                              BCMOLT_XGPON_TRX_CFG_ID_BURST_PROFILE_DELIMITER_MAX_ERRORS
#define bcmolt_xgpon_trx_cfg_id_ranging_sm_patterns_at_init                                     BCMOLT_XGPON_TRX_CFG_ID_RANGING_SM_PATTERNS_AT_INIT
#define bcmolt_xgpon_trx_cfg_id_ranging_sm_patterns_ed_failure                                  BCMOLT_XGPON_TRX_CFG_ID_RANGING_SM_PATTERNS_ED_FAILURE
#define bcmolt_xgpon_trx_cfg_id_reset_on_del_miss                                               BCMOLT_XGPON_TRX_CFG_ID_RESET_ON_DEL_MISS
#define bcmolt_xgpon_trx_cfg_id_ed_state                                                        BCMOLT_XGPON_TRX_CFG_ID_ED_STATE
#define bcmolt_xgpon_trx_cfg_id_invert_ed                                                       BCMOLT_XGPON_TRX_CFG_ID_INVERT_ED
#define bcmolt_xgpon_trx_cfg_id_end_of_burst_reset                                              BCMOLT_XGPON_TRX_CFG_ID_END_OF_BURST_RESET
#define bcmolt_xgpon_trx_cfg_id_trx_rst_polarity                                                BCMOLT_XGPON_TRX_CFG_ID_TRX_RST_POLARITY
#define bcmolt_xgpon_trx_cfg_id__num_of                                                         BCMOLT_XGPON_TRX_CFG_ID__NUM_OF
#define bcmolt_xpon_serdes_key_id_pon_ni                                                        BCMOLT_XPON_SERDES_KEY_ID_PON_NI
#define bcmolt_xpon_serdes_key_id_instance                                                      BCMOLT_XPON_SERDES_KEY_ID_INSTANCE
#define bcmolt_xpon_serdes_key_id__num_of                                                       BCMOLT_XPON_SERDES_KEY_ID__NUM_OF
#define bcmolt_xpon_serdes_cfg_id_rx_vga                                                        BCMOLT_XPON_SERDES_CFG_ID_RX_VGA
#define bcmolt_xpon_serdes_cfg_id_rx_pf                                                         BCMOLT_XPON_SERDES_CFG_ID_RX_PF
#define bcmolt_xpon_serdes_cfg_id_rx_lfpf                                                       BCMOLT_XPON_SERDES_CFG_ID_RX_LFPF
#define bcmolt_xpon_serdes_cfg_id_rx_dfe1                                                       BCMOLT_XPON_SERDES_CFG_ID_RX_DFE1
#define bcmolt_xpon_serdes_cfg_id_rx_dfe2                                                       BCMOLT_XPON_SERDES_CFG_ID_RX_DFE2
#define bcmolt_xpon_serdes_cfg_id_rx_dfe3                                                       BCMOLT_XPON_SERDES_CFG_ID_RX_DFE3
#define bcmolt_xpon_serdes_cfg_id_rx_dfe4                                                       BCMOLT_XPON_SERDES_CFG_ID_RX_DFE4
#define bcmolt_xpon_serdes_cfg_id_rx_dfe5                                                       BCMOLT_XPON_SERDES_CFG_ID_RX_DFE5
#define bcmolt_xpon_serdes_cfg_id_tx_pre                                                        BCMOLT_XPON_SERDES_CFG_ID_TX_PRE
#define bcmolt_xpon_serdes_cfg_id_tx_main                                                       BCMOLT_XPON_SERDES_CFG_ID_TX_MAIN
#define bcmolt_xpon_serdes_cfg_id_tx_post1                                                      BCMOLT_XPON_SERDES_CFG_ID_TX_POST1
#define bcmolt_xpon_serdes_cfg_id_tx_post2                                                      BCMOLT_XPON_SERDES_CFG_ID_TX_POST2
#define bcmolt_xpon_serdes_cfg_id_tx_post3                                                      BCMOLT_XPON_SERDES_CFG_ID_TX_POST3
#define bcmolt_xpon_serdes_cfg_id_tx_amp                                                        BCMOLT_XPON_SERDES_CFG_ID_TX_AMP
#define bcmolt_xpon_serdes_cfg_id__num_of                                                       BCMOLT_XPON_SERDES_CFG_ID__NUM_OF

/** Checks whether the given object type has the given tag. 
 *
 * \return true if the given object has the given tag, false otherwise 
 */
bcmos_bool bcmolt_obj_has_tag(bcmolt_obj_id obj, bcmolt_obj_tag tag);

/** @} */
#endif /* BCMOLT_MODEL_IDS_H_ */
