/*
<:copyright-BRCM:2016:proprietary:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

This program is the proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modified or distributed pursuant
to the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License").  Except as set forth in
an Authorized License, Broadcom grants no license (express or implied), right
to use, or waiver of any kind with respect to the Software, and Broadcom
expressly reserves all rights in and to the Software and all intellectual
property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization,
    constitutes the valuable trade secrets of Broadcom, and you shall use
    all reasonable efforts to protect the confidentiality thereof, and to
    use this information only in connection with your use of Broadcom
    integrated circuit products.

2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
    PERFORMANCE OF THE SOFTWARE.

3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
    LIMITED REMEDY.
:>
*/
#ifndef BCMOLT_MODEL_DATA_H_
#define BCMOLT_MODEL_DATA_H_

#include "bcmos_system.h"

/** \addtogroup object_model
 * @{
 */
typedef uint32_t bcmolt_time_quanta;                                /**< bcmolt_time_quanta: typed alias for a 32-bit unsigned integer. */
typedef uint16_t bcmolt_ae_ni;                                      /**< bcmolt_ae_ni: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_AE_NI_AE_NI_INVALID  ((bcmolt_ae_ni) 65535U)
typedef uint8_t bcmolt_aggregation_domain;                          /**< bcmolt_aggregation_domain: typed alias for a 8-bit unsigned integer. */
typedef uint32_t bcmolt_bandwidth_Kbps;                             /**< bcmolt_bandwidth_Kbps: typed alias for a 32-bit unsigned integer. */
typedef uint32_t bcmolt_ber_interval;                               /**< bcmolt_ber_interval: typed alias for a 32-bit unsigned integer. */
#define BCMOLT_BER_INTERVAL_BER_INTERVAL_NOT_CONFIGURED ((bcmolt_ber_interval) 0)
typedef uint8_t bcmolt_burst_profile_index;                         /**< bcmolt_burst_profile_index: typed alias for a 8-bit unsigned integer. */
typedef uint8_t bcmolt_dba_port;                                    /**< bcmolt_dba_port: typed alias for a 8-bit unsigned integer. */
#define BCMOLT_DBA_PORT_COUNT   ((bcmolt_dba_port) 8)
typedef uint8_t bcmolt_epon_top;                                    /**< bcmolt_epon_top: typed alias for a 8-bit unsigned integer. */
#define BCMOLT_EPON_TOP_COUNT   ((bcmolt_epon_top) 8)
typedef uint8_t bcmolt_epm_lim_global;                              /**< bcmolt_epm_lim_global: typed alias for a 8-bit unsigned integer. */
#define BCMOLT_EPM_LIM_GLOBAL_COUNT ((bcmolt_epm_lim_global) 16)
typedef uint8_t bcmolt_xg2g_id;                                     /**< bcmolt_xg2g_id: typed alias for a 8-bit unsigned integer. */
typedef uint16_t bcmolt_epon_llid;                                  /**< bcmolt_epon_llid: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_EPON_LLID_BROADCAST_LLID_10G ((bcmolt_epon_llid) 32766)
#define BCMOLT_EPON_LLID_BROADCAST_LLID_1G  ((bcmolt_epon_llid) 32767)
typedef uint32_t bcmolt_epon_tunnel_id;                             /**< bcmolt_epon_tunnel_id: typed alias for a 32-bit unsigned integer. */
typedef uint16_t bcmolt_epon_ni;                                    /**< bcmolt_epon_ni: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_EPON_NI_INVALID  ((bcmolt_epon_ni) 65535U)
typedef uint8_t bcmolt_epon_onu_id;                                 /**< bcmolt_epon_onu_id: typed alias for a 8-bit unsigned integer. */
#define BCMOLT_EPON_ONU_ID_UNKNOWN_ONU  ((bcmolt_epon_onu_id) 255)
typedef uint16_t bcmolt_flow_id;                                    /**< bcmolt_flow_id: typed alias for a 16-bit unsigned integer. */
typedef uint16_t bcmolt_gpon_alloc_id;                              /**< bcmolt_gpon_alloc_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_GPON_ALLOC_ID_ANY        ((bcmolt_gpon_alloc_id) 65534U)
#define BCMOLT_GPON_ALLOC_ID_INVALID    ((bcmolt_gpon_alloc_id) 65535U)
typedef uint16_t bcmolt_vlan_id;                                    /**< bcmolt_vlan_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_VLAN_ID_MAX  ((bcmolt_vlan_id) 4095)
#define BCMOLT_VLAN_ID_ANY  ((bcmolt_vlan_id) 65535U)
typedef uint16_t bcmolt_gpon_gem_id;                                /**< bcmolt_gpon_gem_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_GPON_GEM_ID_ANY      ((bcmolt_gpon_gem_id) 65534U)
#define BCMOLT_GPON_GEM_ID_INVALID  ((bcmolt_gpon_gem_id) 65535U)
typedef uint16_t bcmolt_gpon_onu_id;                                /**< bcmolt_gpon_onu_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_GPON_ONU_ID_ANY      ((bcmolt_gpon_onu_id) 65534U)
#define BCMOLT_GPON_ONU_ID_INVALID  ((bcmolt_gpon_onu_id) 65535U)
typedef uint8_t bcmolt_gpon_ni;                                     /**< bcmolt_gpon_ni: typed alias for a 8-bit unsigned integer. */
#define BCMOLT_GPON_NI_INVALID  ((bcmolt_gpon_ni) 255)
typedef uint16_t bcmolt_pon_onu_id;                                 /**< bcmolt_pon_onu_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_PON_ONU_ID_INVALID   ((bcmolt_pon_onu_id) 65535U)
typedef uint8_t bcmolt_mac_table_idx_cam;                           /**< bcmolt_mac_table_idx_cam: typed alias for a 8-bit unsigned integer. */
#define BCMOLT_MAC_TABLE_IDX_CAM_NONE   ((bcmolt_mac_table_idx_cam) 255)
typedef uint16_t bcmolt_mac_table_idx_combined;                     /**< bcmolt_mac_table_idx_combined: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_MAC_TABLE_IDX_COMBINED_NONE  ((bcmolt_mac_table_idx_combined) 65535U)
typedef uint16_t bcmolt_mac_table_idx_main;                         /**< bcmolt_mac_table_idx_main: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_MAC_TABLE_IDX_MAIN_NONE  ((bcmolt_mac_table_idx_main) 65535U)
typedef uint32_t bcmolt_meters;                                     /**< bcmolt_meters: typed alias for a 32-bit unsigned integer. */
typedef uint16_t bcmolt_pon_alloc_id;                               /**< bcmolt_pon_alloc_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_PON_ALLOC_ID_INVALID ((bcmolt_pon_alloc_id) 65535U)
typedef uint16_t bcmolt_pon_alloc_index;                            /**< bcmolt_pon_alloc_index: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_PON_ALLOC_INDEX_INVALID  ((bcmolt_pon_alloc_index) 65535U)
typedef uint16_t bcmolt_pon_gem_port_id;                            /**< bcmolt_pon_gem_port_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_PON_GEM_PORT_ID_INVALID  ((bcmolt_pon_gem_port_id) 65535U)
typedef uint16_t bcmolt_pon_gem_port_index;                         /**< bcmolt_pon_gem_port_index: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_PON_GEM_PORT_INDEX_INVALID   ((bcmolt_pon_gem_port_index) 65535U)
typedef uint8_t bcmolt_pon_ni;                                      /**< bcmolt_pon_ni: typed alias for a 8-bit unsigned integer. */
#define BCMOLT_PON_NI_INVALID   ((bcmolt_pon_ni) 255)
typedef uint16_t bcmolt_xgpon_alloc_id;                             /**< bcmolt_xgpon_alloc_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_XGPON_ALLOC_ID_ANY       ((bcmolt_xgpon_alloc_id) 65534U)
#define BCMOLT_XGPON_ALLOC_ID_INVALID   ((bcmolt_xgpon_alloc_id) 65535U)
typedef uint16_t bcmolt_xgpon_gem_id;                               /**< bcmolt_xgpon_gem_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_XGPON_GEM_ID_ANY     ((bcmolt_xgpon_gem_id) 65534U)
#define BCMOLT_XGPON_GEM_ID_INVALID ((bcmolt_xgpon_gem_id) 65535U)
typedef uint8_t bcmolt_xgpon_ni;                                    /**< bcmolt_xgpon_ni: typed alias for a 8-bit unsigned integer. */
#define BCMOLT_XGPON_NI_INVALID ((bcmolt_xgpon_ni) 255)
typedef uint16_t bcmolt_xgpon_onu_id;                               /**< bcmolt_xgpon_onu_id: typed alias for a 16-bit unsigned integer. */
#define BCMOLT_XGPON_ONU_ID_ANY     ((bcmolt_xgpon_onu_id) 65534U)
#define BCMOLT_XGPON_ONU_ID_INVALID ((bcmolt_xgpon_onu_id) 65535U)

/** activation fail reason. 
 */
typedef enum bcmolt_activation_fail_reason
{
    BCMOLT_ACTIVATION_FAIL_REASON__BEGIN                    = 0,
    BCMOLT_ACTIVATION_FAIL_REASON_NONE                      = 0,    /**< None. */
    BCMOLT_ACTIVATION_FAIL_REASON_RANGING                   = 1,    /**< Ranging. */
    BCMOLT_ACTIVATION_FAIL_REASON_PASSWORD_AUTHENTICATION   = 2,    /**< Password authentication. */
    BCMOLT_ACTIVATION_FAIL_REASON_LOS                       = 3,    /**< LOS. */
    BCMOLT_ACTIVATION_FAIL_REASON_ONU_ALARM                 = 4,    /**< ONU Alarm. */
    BCMOLT_ACTIVATION_FAIL_REASON__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_activation_fail_reason;

/** Additional BW eligibility. 
 */
typedef enum bcmolt_additional_bw_eligibility
{
    BCMOLT_ADDITIONAL_BW_ELIGIBILITY__BEGIN                 = 0,
    BCMOLT_ADDITIONAL_BW_ELIGIBILITY_NONE                   = 0,    /**< None. */
    BCMOLT_ADDITIONAL_BW_ELIGIBILITY_NON_ASSURED            = 1,    /**< Non Assured. */
    BCMOLT_ADDITIONAL_BW_ELIGIBILITY_BEST_EFFORT            = 2,    /**< Best Effort. */
    BCMOLT_ADDITIONAL_BW_ELIGIBILITY__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_additional_bw_eligibility;

/** Enable state of the AE NI. 
 */
typedef enum bcmolt_ae_ni_en_state
{
    BCMOLT_AE_NI_EN_STATE__BEGIN                            = 0,
    BCMOLT_AE_NI_EN_STATE_DISABLED                          = 0,    /**< AE NI is fully disabled. */
    BCMOLT_AE_NI_EN_STATE_ENABLED                           = 1,    /**< AE NI is fully enabled. */
    BCMOLT_AE_NI_EN_STATE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_ae_ni_en_state;

/** Alloc operation. 
 */
typedef enum bcmolt_alloc_operation
{
    BCMOLT_ALLOC_OPERATION__BEGIN                           = 0,
    BCMOLT_ALLOC_OPERATION_ACTIVATE                         = 0,    /**< Activate. */
    BCMOLT_ALLOC_OPERATION_DEACTIVATE                       = 1,    /**< Deactivate. */
    BCMOLT_ALLOC_OPERATION__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_alloc_operation;

/** Alloc State. 
 */
typedef enum bcmolt_alloc_state
{
    BCMOLT_ALLOC_STATE__BEGIN                               = 0,
    BCMOLT_ALLOC_STATE_NOT_CONFIGURED                       = 0,    /**< Not configured. */
    BCMOLT_ALLOC_STATE_INACTIVE                             = 1,    /**< Inactive. */
    BCMOLT_ALLOC_STATE_PROCESSING                           = 2,    /**< Processing. */
    BCMOLT_ALLOC_STATE_ACTIVE                               = 3,    /**< Active. */
    BCMOLT_ALLOC_STATE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_alloc_state;

/** Alloc Type. 
 */
typedef enum bcmolt_alloc_type
{
    BCMOLT_ALLOC_TYPE__BEGIN                                = 0,
    BCMOLT_ALLOC_TYPE_NONE                                  = 0,    /**< None. */
    BCMOLT_ALLOC_TYPE_NSR                                   = 1,    /**< Non Status Report. */
    BCMOLT_ALLOC_TYPE_SR                                    = 2,    /**< Status Report. */
    BCMOLT_ALLOC_TYPE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_alloc_type;

/** Alloc Type to scan during the rogue onu detection process. 
 */
typedef enum bcmolt_alloc_type_to_scan
{
    BCMOLT_ALLOC_TYPE_TO_SCAN__BEGIN                        = 0,
    BCMOLT_ALLOC_TYPE_TO_SCAN_UNUSED                        = 0,    /**< Scan only the Alloc-IDs that have not been used. */
    BCMOLT_ALLOC_TYPE_TO_SCAN_PREVIOUSLY_USED               = 1,    /**< Scan only the Alloc-IDs that has been used but currently not being used.  This is for detecting the case when the OLT has released the Alloc, but the ONU is still holding it due to an error. */
    BCMOLT_ALLOC_TYPE_TO_SCAN_ALL                           = 2,    /**< Scan both used and unused Alloc-IDs. */
    BCMOLT_ALLOC_TYPE_TO_SCAN__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_alloc_type_to_scan;

/** What to do when the capture buffer is full. 
 */
typedef enum bcmolt_api_capture_buffer_mode
{
    BCMOLT_API_CAPTURE_BUFFER_MODE__BEGIN                   = 0,
    BCMOLT_API_CAPTURE_BUFFER_MODE_OVERFLOW                 = 0,    /**< Drop messages when the buffer is full. */
    BCMOLT_API_CAPTURE_BUFFER_MODE_WRAP                     = 1,    /**< Wrap back to the beginning when the buffer is full. */
    BCMOLT_API_CAPTURE_BUFFER_MODE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_api_capture_buffer_mode;

/** Where to perform the API capture. 
 */
typedef enum bcmolt_api_capture_location
{
    BCMOLT_API_CAPTURE_LOCATION__BEGIN                      = 0,
    BCMOLT_API_CAPTURE_LOCATION_DEVICE                      = 0,    /**< On the device. */
    BCMOLT_API_CAPTURE_LOCATION_HOST                        = 1,    /**< On the host. */
    BCMOLT_API_CAPTURE_LOCATION__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_api_capture_location;

/** Calibration Record. 
 */
typedef enum bcmolt_calibration_record
{
    BCMOLT_CALIBRATION_RECORD__BEGIN                        = 0,
    BCMOLT_CALIBRATION_RECORD_UNSPECIFIED                   = 0,    /**< Unspecified. */
    BCMOLT_CALIBRATION_RECORD_UNCALIBRATED                  = 1,    /**< Uncalibrated. */
    BCMOLT_CALIBRATION_RECORD_LOOSE                         = 2,    /**< Loose. */
    BCMOLT_CALIBRATION_RECORD_SUFFICIENT                    = 3,    /**< Sufficient. */
    BCMOLT_CALIBRATION_RECORD__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_calibration_record;

/** sign. 
 */
typedef enum bcmolt_sign
{
    BCMOLT_SIGN__BEGIN                                      = 0,
    BCMOLT_SIGN_POSITIVE                                    = 0,    /**< Positive. */
    BCMOLT_SIGN_NEGATIVE                                    = 1,    /**< Negative. */
    BCMOLT_SIGN__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_sign;

/** XGPON ni upstream line rate capabilities 
 */
typedef enum bcmolt_upstream_line_rate_capabilities
{
    BCMOLT_UPSTREAM_LINE_RATE_CAPABILITIES__BEGIN           = 0,
    BCMOLT_UPSTREAM_LINE_RATE_CAPABILITIES_RATE_2_P_5_G     = 0,    /**< 2.5G Upstream line rate capability */
    BCMOLT_UPSTREAM_LINE_RATE_CAPABILITIES_RATE_10_G        = 1,    /**< 10G Upstream line rate capability */
    BCMOLT_UPSTREAM_LINE_RATE_CAPABILITIES__NUM_OF                  /**< Number of enum entries, not an entry itself. */
} bcmolt_upstream_line_rate_capabilities;

/** Link type. 
 */
typedef enum bcmolt_link_type
{
    BCMOLT_LINK_TYPE__BEGIN                                 = 0,
    BCMOLT_LINK_TYPE_UNSPECIFIED                            = 0,    /**< Link type unspecified */
    BCMOLT_LINK_TYPE_B                                      = 1,    /**< Link type A is not supported, link type B is supported */
    BCMOLT_LINK_TYPE_A                                      = 2,    /**< Link type A is supported, link type B is not supported */
    BCMOLT_LINK_TYPE_A_AND_B                                = 3,    /**< Both link types A and B are supported */
    BCMOLT_LINK_TYPE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_link_type;

/** capture strobe signal. 
 */
typedef enum bcmolt_capture_strobe_signal
{
    BCMOLT_CAPTURE_STROBE_SIGNAL__BEGIN                     = 0,
    BCMOLT_CAPTURE_STROBE_SIGNAL_GPON_BCDR_RESET            = 0,    /**< gpon bcdr reset. */
    BCMOLT_CAPTURE_STROBE_SIGNAL_GPON_TRX_ED                = 1,    /**< gpon trx ed. */
    BCMOLT_CAPTURE_STROBE_SIGNAL_GPON_RSSI                  = 2,    /**< gpon rssi. */
    BCMOLT_CAPTURE_STROBE_SIGNAL_GPON_EOB                   = 3,    /**< gpon eob. */
    BCMOLT_CAPTURE_STROBE_SIGNAL_SERDES_BURST_EN            = 4,    /**< serdes burst en. */
    BCMOLT_CAPTURE_STROBE_SIGNAL_SERDES_RX_LOCK             = 5,    /**< serdes rx lock. */
    BCMOLT_CAPTURE_STROBE_SIGNAL__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_capture_strobe_signal;

/** Console Redirection Type. 
 */
typedef enum bcmolt_console_redirection
{
    BCMOLT_CONSOLE_REDIRECTION__BEGIN                       = 0,
    BCMOLT_CONSOLE_REDIRECTION_NONE                         = 0,    /**< No redirection */
    BCMOLT_CONSOLE_REDIRECTION_REDIRECT                     = 1,    /**< Embedded console output is redirected to the host */
    BCMOLT_CONSOLE_REDIRECTION_CLONE                        = 2,    /**< Embedded console output is cloned to the host */
    BCMOLT_CONSOLE_REDIRECTION__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_console_redirection;

/** control state. 
 */
typedef enum bcmolt_control_state
{
    BCMOLT_CONTROL_STATE__BEGIN                             = 0,
    BCMOLT_CONTROL_STATE_DISABLE                            = 0,    /**< Disabled. */
    BCMOLT_CONTROL_STATE_ENABLE                             = 1,    /**< Enabled. */
    BCMOLT_CONTROL_STATE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_control_state;

/** dba mode. 
 */
typedef enum bcmolt_dba_mode
{
    BCMOLT_DBA_MODE__BEGIN                                  = 0,
    BCMOLT_DBA_MODE_NORMAL                                  = 0,    /**< normal. */
    BCMOLT_DBA_MODE_EXTENDED                                = 1,    /**< extended. */
    BCMOLT_DBA_MODE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_dba_mode;

/** DBA RAM. 
 */
typedef enum bcmolt_dba_ram
{
    BCMOLT_DBA_RAM__BEGIN                                   = 0,
    BCMOLT_DBA_RAM_GRANT_FIFO_RAM_0                         = 0,    /**< Grant FIFO RAM 0. */
    BCMOLT_DBA_RAM_GRANT_FIFO_RAM_1                         = 1,    /**< Grant FIFO RAM 1. */
    BCMOLT_DBA_RAM_GRANT_FIFO_RAM_2                         = 2,    /**< Grant FIFO RAM 2. */
    BCMOLT_DBA_RAM_GRANT_FIFO_RAM_3                         = 3,    /**< Grant FIFO RAM 3. */
    BCMOLT_DBA_RAM_GRANT_FIFO_RAM_4                         = 4,    /**< Grant FIFO RAM 4. */
    BCMOLT_DBA_RAM_GRANT_FIFO_RAM_5                         = 5,    /**< Grant FIFO RAM 5. */
    BCMOLT_DBA_RAM_GRANT_FIFO_RAM_6                         = 6,    /**< Grant FIFO RAM 6. */
    BCMOLT_DBA_RAM_GRANT_FIFO_RAM_7                         = 7,    /**< Grant FIFO RAM 7. */
    BCMOLT_DBA_RAM_GRANTS_OUT_RAM                           = 8,    /**< Grants Out RAM. */
    BCMOLT_DBA_RAM_GRANTS_IN_RAM                            = 9,    /**< Grants In RAM. */
    BCMOLT_DBA_RAM_GRANTS_RETIRED_RAM                       = 10,   /**< Grants Retired RAM. */
    BCMOLT_DBA_RAM_REPORT_RAM                               = 11,   /**< Report RAM. */
    BCMOLT_DBA_RAM_GRANT_CFG_RAM                            = 12,   /**< Grant Cfg RAM. */
    BCMOLT_DBA_RAM_DEFAULT_TOKENS_RAM                       = 13,   /**< Default Tokens RAM. */
    BCMOLT_DBA_RAM_POLL_RECORDS_RAM                         = 14,   /**< Poll Records RAM. */
    BCMOLT_DBA_RAM_HEIR_POLL_RAM                            = 15,   /**< Heir Poll RAM. */
    BCMOLT_DBA_RAM_LAST_POLL_TIME_RAM                       = 16,   /**< Last Poll Time RAM. */
    BCMOLT_DBA_RAM_POLL_ORDER_RAM                           = 17,   /**< Poll Order RAM. */
    BCMOLT_DBA_RAM_TDM_RAM_0                                = 18,   /**< TDM RAM 0. */
    BCMOLT_DBA_RAM_TDM_RAM_1                                = 19,   /**< TDM RAM 1. */
    BCMOLT_DBA_RAM_TDM_RAM_2                                = 20,   /**< TDM RAM 2. */
    BCMOLT_DBA_RAM_TDM_RAM_3                                = 21,   /**< TDM RAM 3. */
    BCMOLT_DBA_RAM_TDM_RAM_4                                = 22,   /**< TDM RAM 4. */
    BCMOLT_DBA_RAM_TDM_RAM_5                                = 23,   /**< TDM RAM 5. */
    BCMOLT_DBA_RAM_TDM_RAM_6                                = 24,   /**< TDM RAM 6. */
    BCMOLT_DBA_RAM_TDM_RAM_7                                = 25,   /**< TDM RAM 7. */
    BCMOLT_DBA_RAM__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_dba_ram;

/** DBA type. 
 */
typedef enum bcmolt_dba_type
{
    BCMOLT_DBA_TYPE__BEGIN                                  = 0,
    BCMOLT_DBA_TYPE_INTERNAL                                = 0,    /**< DBA internal implementation */
    BCMOLT_DBA_TYPE_PARTIAL_EXTERNAL                        = 1,    /**< DBA partial external implementation (DE, BA are implemented externally) */
    BCMOLT_DBA_TYPE_EXTERNAL                                = 2,    /**< DBA external implementation  */
    BCMOLT_DBA_TYPE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_dba_type;

/** DDR Test Status. 
 */
typedef enum bcmolt_ddr_test_status
{
    BCMOLT_DDR_TEST_STATUS__BEGIN                           = 0,
    BCMOLT_DDR_TEST_STATUS_COMPLETED                        = 0,    /**< The DDR test ran to completion */
    BCMOLT_DDR_TEST_STATUS_CONNECTION_FAILED                = 1,    /**< The DDR test failed due to an issue loading the bootloader */
    BCMOLT_DDR_TEST_STATUS_TIMEOUT                          = 2,    /**< The DDR test failed to complete within the expected time */
    BCMOLT_DDR_TEST_STATUS__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_ddr_test_status;

/** DDR Test Result. 
 */
typedef enum bcmolt_ddr_test_result
{
    BCMOLT_DDR_TEST_RESULT_SUCCESS                          = 0,        /**< Success. */
    BCMOLT_DDR_TEST_RESULT_PHY_INIT_ERROR                   = 1,        /**< PHY Init Error. */
    BCMOLT_DDR_TEST_RESULT_DRAM_INIT_ERROR                  = 2,        /**< DRAM Init Error. */
    BCMOLT_DDR_TEST_RESULT_SHMOO_ERROR                      = 3,        /**< SHMOO Error. */
    BCMOLT_DDR_TEST_RESULT_EDIS_TEST_ERROR                  = 4,        /**< EDIS Test Error. */
    BCMOLT_DDR_TEST_RESULT_MEM_TEST_ERROR                   = 5,        /**< Mem Test Error. */
    BCMOLT_DDR_TEST_RESULT_NOT_TESTED                       = 127       /**< Not Tested. */
} bcmolt_ddr_test_result;

/** Reasons why the connection between the host and the device failed 
 */
typedef enum bcmolt_host_connection_fail_reason
{
    BCMOLT_HOST_CONNECTION_FAIL_REASON__BEGIN                   = 0,
    BCMOLT_HOST_CONNECTION_FAIL_REASON_TIMEOUT                  = 0,    /**< The connection process has timed out. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON_KEEPALIVE                = 1,    /**< Too much time has passed between keepalive messages from the device. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON_USER_CALLBACK_ERROR      = 2,    /**< A user callback returned a nonzero error code.  Check log output to determine which callback failed. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON_SOFTWARE_VERSION_MISMATCH= 3,    /**< The software version on the running device doesn't match the version in the host software.  Only the revision number is allowed to differ - major/minor/model must match. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON_SYSTEM_MODE_MISMATCH     = 4,    /**< The system mode on the running device doesn't match the version in the host software. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON_NNI_SPEED_MISMATCH       = 5,    /**< The NNI speed on the running device doesn't match the version in the host software. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON_RECONNECT_TIMEOUT        = 6,    /**< A running device didn't respond to the request to reconnect. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON_INTERNAL_ERROR           = 7,    /**< An unspecified internal error occurred - check the log output for details. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON_SYSTEM_MODE_NOT_SUPPORTED= 8,    /**< The given system mode is not supported on this device. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON_PARAMETER                = 9,    /**< One of the initial connection parameters was incorrect. */
    BCMOLT_HOST_CONNECTION_FAIL_REASON__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_host_connection_fail_reason;

/** deactivation reason. 
 */
typedef enum bcmolt_deactivation_reason
{
    BCMOLT_DEACTIVATION_REASON__BEGIN                           = 0,
    BCMOLT_DEACTIVATION_REASON_NONE                             = 0,    /**< none. */
    BCMOLT_DEACTIVATION_REASON_DEACTIVATION                     = 1,    /**< deactivation. */
    BCMOLT_DEACTIVATION_REASON_ACK_TIMEOUT                      = 2,    /**< ack timeout. */
    BCMOLT_DEACTIVATION_REASON_SFI                              = 3,    /**< sfi alarm. */
    BCMOLT_DEACTIVATION_REASON_TIWI                             = 4,    /**< tiwi. */
    BCMOLT_DEACTIVATION_REASON_PASSWORD_AUTHENTICATION          = 5,    /**< password authentication. */
    BCMOLT_DEACTIVATION_REASON_ONU_ALARM                        = 6,    /**< onu alarm. */
    BCMOLT_DEACTIVATION_REASON_LOS                              = 7,    /**< los. */
    BCMOLT_DEACTIVATION_REASON_LOKI                             = 8,    /**< loki. */
    BCMOLT_DEACTIVATION_REASON_RERANGE_FAILURE                  = 9,    /**< re-range failure. */
    BCMOLT_DEACTIVATION_REASON__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_deactivation_reason;

/** Revision of the BCM68620 device. 
 */
typedef enum bcmolt_device_chip_revision
{
    BCMOLT_DEVICE_CHIP_REVISION_A0                              = 160,  /**< A0. */
    BCMOLT_DEVICE_CHIP_REVISION_B0                              = 176   /**< B0. */
} bcmolt_device_chip_revision;

/** Device Image Type. 
 */
typedef enum bcmolt_device_image_type
{
    BCMOLT_DEVICE_IMAGE_TYPE__BEGIN                             = 0,
    BCMOLT_DEVICE_IMAGE_TYPE_BOOTLOADER                         = 0,    /**< Bootloader. */
    BCMOLT_DEVICE_IMAGE_TYPE_APPLICATION                        = 1,    /**< Application. */
    BCMOLT_DEVICE_IMAGE_TYPE_ITU_PON_ONU_FIRMWARE               = 2,    /**< ITU PON ONU firmware. */
    BCMOLT_DEVICE_IMAGE_TYPE_EPON_ONU_FIRMWARE                  = 3,    /**< EPON ONU firmware. */
    BCMOLT_DEVICE_IMAGE_TYPE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_device_image_type;

/** Network interface speed 
 */
typedef enum bcmolt_nni_speed
{
    BCMOLT_NNI_SPEED__BEGIN                                     = 0,
    BCMOLT_NNI_SPEED_GBPS_1                                     = 0,    /**< 1Gbps */
    BCMOLT_NNI_SPEED_GBPS_2P5                                   = 1,    /**< 2.5Gbps */
    BCMOLT_NNI_SPEED_GBPS_10                                    = 2,    /**< 10Gbps */
    BCMOLT_NNI_SPEED_GBPS_12P5                                  = 3,    /**< 12.5Gbps */
    BCMOLT_NNI_SPEED_GBPS_10_G_MUX                              = 4,    /**< 10Gbps Mux */
    BCMOLT_NNI_SPEED__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_speed;

/** Options for the reset operation. 
 */
typedef enum bcmolt_device_reset_mode
{
    BCMOLT_DEVICE_RESET_MODE_DEVICE                             = 1,    /**< Turn off the embedded device's processor. */
    BCMOLT_DEVICE_RESET_MODE_HOST                               = 2,    /**< Reset the host processor. */
    BCMOLT_DEVICE_RESET_MODE_ALL                                = 3     /**< Turn off the embedded device's processor and reset the host processor. */
} bcmolt_device_reset_mode;

/** The overall state of the host's connection to the device. 
 */
typedef enum bcmolt_device_state
{
    BCMOLT_DEVICE_STATE__BEGIN                                  = 0,
    BCMOLT_DEVICE_STATE_DISCONNECTED                            = 0,    /**< The host is not connected to the device. */
    BCMOLT_DEVICE_STATE_CONNECTING                              = 1,    /**< The host is in the process of connecting to the device. */
    BCMOLT_DEVICE_STATE_READY                                   = 2,    /**< The device is connected to the host and is ready to accept any command from the host. */
    BCMOLT_DEVICE_STATE_WAITING_FOR_DEVICE                      = 3,    /**< Waiting for the embedded side to respond to a configuration message. */
    BCMOLT_DEVICE_STATE_TESTING_DDR                             = 4,    /**< A DDR test is currently in progress */
    BCMOLT_DEVICE_STATE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_device_state;

/** Disable Serial Number Control. 
 */
typedef enum bcmolt_disable_serial_number_control
{
    BCMOLT_DISABLE_SERIAL_NUMBER_CONTROL__BEGIN                 = 0,
    BCMOLT_DISABLE_SERIAL_NUMBER_CONTROL_UNICAST_DISABLE        = 0,    /**< Unicast Disable. */
    BCMOLT_DISABLE_SERIAL_NUMBER_CONTROL_UNICAST_ENABLE         = 1,    /**< Unicast Enable. */
    BCMOLT_DISABLE_SERIAL_NUMBER_CONTROL_BROADCAST_ENABLE       = 2,    /**< Broadcast Enable. */
    BCMOLT_DISABLE_SERIAL_NUMBER_CONTROL_BROADCAST_DISABLE      = 3,    /**< Broadcast Disable. */
    BCMOLT_DISABLE_SERIAL_NUMBER_CONTROL_DISABLE_DISCOVERY      = 4,    /**< Disable Discovery. */
    BCMOLT_DISABLE_SERIAL_NUMBER_CONTROL__NUM_OF                        /**< Number of enum entries, not an entry itself. */
} bcmolt_disable_serial_number_control;

/** drv_icf_id. 
 */
typedef enum bcmolt_drv_icf_id
{
    BCMOLT_DRV_ICF_ID__BEGIN                                    = 0,
    BCMOLT_DRV_ICF_ID_IDX0                                      = 0,    /**< IDX0. */
    BCMOLT_DRV_ICF_ID_IDX1                                      = 1,    /**< IDX1. */
    BCMOLT_DRV_ICF_ID_IDX2                                      = 2,    /**< IDX2. */
    BCMOLT_DRV_ICF_ID_IDX3                                      = 3,    /**< IDX3. */
    BCMOLT_DRV_ICF_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_drv_icf_id;

/** drv_sgb_id. 
 */
typedef enum bcmolt_drv_sgb_id
{
    BCMOLT_DRV_SGB_ID__BEGIN                                    = 0,
    BCMOLT_DRV_SGB_ID_IDX0                                      = 0,    /**< IDX0. */
    BCMOLT_DRV_SGB_ID_IDX1                                      = 1,    /**< IDX1. */
    BCMOLT_DRV_SGB_ID__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_drv_sgb_id;

/** DS VLAN action. 
 */
typedef enum bcmolt_ds_vlan_action
{
    BCMOLT_DS_VLAN_ACTION__BEGIN                                = 0,
    BCMOLT_DS_VLAN_ACTION_REMOVE                                = 0,    /**< Remove. */
    BCMOLT_DS_VLAN_ACTION_TRANSPARENT                           = 1,    /**< Transparent. */
    BCMOLT_DS_VLAN_ACTION__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_ds_vlan_action;

/** TFB Trap Behavior. 
 */
typedef enum bcmolt_tfb_trap_behavior
{
    BCMOLT_TFB_TRAP_BEHAVIOR__BEGIN                             = 0,
    BCMOLT_TFB_TRAP_BEHAVIOR_DROP                               = 0,    /**< Drop. */
    BCMOLT_TFB_TRAP_BEHAVIOR_FORWARD_NNI                        = 1,    /**< Forward NNI. */
    BCMOLT_TFB_TRAP_BEHAVIOR_FORWARD_CPU                        = 2,    /**< Forward CPU. */
    BCMOLT_TFB_TRAP_BEHAVIOR_SNOOP                              = 3,    /**< Snoop. */
    BCMOLT_TFB_TRAP_BEHAVIOR__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_tfb_trap_behavior;

/** TFB Mode. 
 */
typedef enum bcmolt_tfb_mode
{
    BCMOLT_TFB_MODE__BEGIN                                      = 0,
    BCMOLT_TFB_MODE_GPON                                        = 0,    /**< GPON. */
    BCMOLT_TFB_MODE_XGPON                                       = 1,    /**< XGPON. */
    BCMOLT_TFB_MODE_EPON                                        = 2,    /**< EPON. */
    BCMOLT_TFB_MODE_XEPON                                       = 3,    /**< XEPON. */
    BCMOLT_TFB_MODE_COEX                                        = 4,    /**< COEX. */
    BCMOLT_TFB_MODE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_tfb_mode;

/** LIM SEC Mode Up. 
 */
typedef enum bcmolt_lim_sec_mode_up
{
    BCMOLT_LIM_SEC_MODE_UP__BEGIN                               = 0,
    BCMOLT_LIM_SEC_MODE_UP_TEK                                  = 0,    /**< Teknovus encryption mode */
    BCMOLT_LIM_SEC_MODE_UP_PER_LLID                             = 1,    /**< Encryption per LLID, 802.1ae/zero-overhead */
    BCMOLT_LIM_SEC_MODE_UP_NTT                                  = 2,    /**< EPON (NTT) encryption mode */
    BCMOLT_LIM_SEC_MODE_UP__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_lim_sec_mode_up;

/** LIM SEC Mode Dn. 
 */
typedef enum bcmolt_lim_sec_mode_dn
{
    BCMOLT_LIM_SEC_MODE_DN__BEGIN                               = 0,
    BCMOLT_LIM_SEC_MODE_DN_TEK                                  = 0,    /**< Teknovus encryption mode */
    BCMOLT_LIM_SEC_MODE_DN_PER_LLID                             = 1,    /**< Encryption per LLID, 802.1ae/zero-overhead */
    BCMOLT_LIM_SEC_MODE_DN_NTT                                  = 2,    /**< EPON (NTT) encryption mode */
    BCMOLT_LIM_SEC_MODE_DN_CEPON                                = 3,    /**< CEPON (3Churn) encryption mode */
    BCMOLT_LIM_SEC_MODE_DN__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_lim_sec_mode_dn;

/** XIM SEC Mode. 
 */
typedef enum bcmolt_xim_sec_mode
{
    BCMOLT_XIM_SEC_MODE__BEGIN                                  = 0,
    BCMOLT_XIM_SEC_MODE_RESERVED_0                              = 0,    /**< Reserved 0. */
    BCMOLT_XIM_SEC_MODE_PER_LLID                                = 1,    /**< Per LLID. */
    BCMOLT_XIM_SEC_MODE_RESERVED_2                              = 2,    /**< Reserved 2. */
    BCMOLT_XIM_SEC_MODE_CEPON                                   = 3,    /**< CEPON. */
    BCMOLT_XIM_SEC_MODE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_xim_sec_mode;

/** HSC RAM. 
 */
typedef enum bcmolt_hsc_ram
{
    BCMOLT_HSC_RAM__BEGIN                                       = 0,
    BCMOLT_HSC_RAM_LLC_T1                                       = 0,    /**< LLC T1. */
    BCMOLT_HSC_RAM_LLC_T2                                       = 1,    /**< LLC T2. */
    BCMOLT_HSC_RAM_LLC_T3                                       = 2,    /**< LLC T3. */
    BCMOLT_HSC_RAM_GRP_T2                                       = 3,    /**< Grp T2. */
    BCMOLT_HSC_RAM_GRP_T3                                       = 4,    /**< Grp T3. */
    BCMOLT_HSC_RAM_SHP_T1                                       = 5,    /**< Shp T1. */
    BCMOLT_HSC_RAM_SHP_T2                                       = 6,    /**< Shp T2. */
    BCMOLT_HSC_RAM_SHP_T3                                       = 7,    /**< Shp T3. */
    BCMOLT_HSC_RAM_PRF_T1                                       = 8,    /**< Prf T1. */
    BCMOLT_HSC_RAM_PRF_T2                                       = 9,    /**< Prf T2. */
    BCMOLT_HSC_RAM_PRF_T3                                       = 10,   /**< Prf T3. */
    BCMOLT_HSC_RAM_CRE_T1                                       = 11,   /**< Cre T1. */
    BCMOLT_HSC_RAM_CRE_T2                                       = 12,   /**< Cre T2. */
    BCMOLT_HSC_RAM_CRE_T3                                       = 13,   /**< Cre T3. */
    BCMOLT_HSC_RAM_ELU                                          = 14,   /**< ELU. */
    BCMOLT_HSC_RAM_PTR_T1                                       = 15,   /**< Ptr T1. */
    BCMOLT_HSC_RAM_PTR_T2                                       = 16,   /**< Ptr T2. */
    BCMOLT_HSC_RAM_AGR_SHP_T1                                   = 17,   /**< Agr Shp T1. */
    BCMOLT_HSC_RAM_AEM                                          = 18,   /**< AEM. */
    BCMOLT_HSC_RAM_ALL_LLC                                      = 19,   /**< All LLC. */
    BCMOLT_HSC_RAM__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_hsc_ram;

/** LIM RAM. 
 */
typedef enum bcmolt_lim_ram
{
    BCMOLT_LIM_RAM__BEGIN                                       = 0,
    BCMOLT_LIM_RAM_LLID_UP                                      = 0,    /**< LLID Up. */
    BCMOLT_LIM_RAM_PER_ONU_STAT                                 = 1,    /**< Per ONU Stat. */
    BCMOLT_LIM_RAM_FEC_UP_FULL_S                                = 2,    /**< FEC Up Full S. */
    BCMOLT_LIM_RAM_FEC_UP_DATA                                  = 3,    /**< FEC Up Data. */
    BCMOLT_LIM_RAM__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_lim_ram;

/** LKY RAM. 
 */
typedef enum bcmolt_lky_ram
{
    BCMOLT_LKY_RAM__BEGIN                                       = 0,
    BCMOLT_LKY_RAM_TX_KEY_RAM                                   = 0,    /**< Tx Key RAM. */
    BCMOLT_LKY_RAM_TX_KEY_BUFFER                                = 1,    /**< Tx Key Buffer. */
    BCMOLT_LKY_RAM_RX_KEY_RAM                                   = 2,    /**< Rx Key RAM. */
    BCMOLT_LKY_RAM_RX_KEY_BUFFER                                = 3,    /**< Rx Key Buffer. */
    BCMOLT_LKY_RAM__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_lky_ram;

/** MIC RAM. 
 */
typedef enum bcmolt_mic_ram
{
    BCMOLT_MIC_RAM__BEGIN                                       = 0,
    BCMOLT_MIC_RAM_RANGE                                        = 0,    /**< Range. */
    BCMOLT_MIC_RAM_LLID                                         = 1,    /**< LLID. */
    BCMOLT_MIC_RAM_IDX                                          = 2,    /**< Index. */
    BCMOLT_MIC_RAM_GRANT_MISS                                   = 3,    /**< Grant Miss. */
    BCMOLT_MIC_RAM_GRANT_ID                                     = 4,    /**< Grant ID. */
    BCMOLT_MIC_RAM_TX_IV                                        = 5,    /**< Tx IV. */
    BCMOLT_MIC_RAM_RX_IV                                        = 6,    /**< Rx IV. */
    BCMOLT_MIC_RAM_TX_PORT_STAT                                 = 7,    /**< Tx Port Stat. */
    BCMOLT_MIC_RAM_RX_PORT_STAT                                 = 8,    /**< Rx Port Stat. */
    BCMOLT_MIC_RAM__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_mic_ram;

/** XPCSRM RAM. 
 */
typedef enum bcmolt_xpcsrm_ram
{
    BCMOLT_XPCSRM_RAM__BEGIN                                    = 0,
    BCMOLT_XPCSRM_RAM_CAPTURE_FIFO                              = 0,    /**< Capture FIFO. */
    BCMOLT_XPCSRM_RAM_FEC_DECODE                                = 1,    /**< FEC Decode. */
    BCMOLT_XPCSRM_RAM_FEC_STATS                                 = 2,    /**< FEC Stats. */
    BCMOLT_XPCSRM_RAM_FEC_ENQUEUE                               = 3,    /**< FEC Enqueue. */
    BCMOLT_XPCSRM_RAM_IDLE_INSERT                               = 4,    /**< Idle Insert. */
    BCMOLT_XPCSRM_RAM__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xpcsrm_ram;

/** embedded image transfer status. 
 */
typedef enum bcmolt_embedded_image_transfer_status
{
    BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS__BEGIN                = 0,
    BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS_NONE                  = 0,    /**< No file.  Transfer has never started for this entry. */
    BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS_IN_PROGRESS           = 1,    /**< Transfer has started and not finished. */
    BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS_SUCCESS               = 2,    /**< Transfer has finished successfully. */
    BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS_FAILURE               = 3,    /**< Transfer failed.  Typically due to CRC error. */
    BCMOLT_EMBEDDED_IMAGE_TRANSFER_STATUS__NUM_OF                       /**< Number of enum entries, not an entry itself. */
} bcmolt_embedded_image_transfer_status;

/** EPON Encryption information format. 
 */
typedef enum bcmolt_epon_encryption_information_format
{
    BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT__BEGIN            = 0,
    BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CFB               = 0,    /**< CFB. */
    BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT_CTR               = 1,    /**< CTR. */
    BCMOLT_EPON_ENCRYPTION_INFORMATION_FORMAT__NUM_OF                   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_encryption_information_format;

/** energy detect source. 
 */
typedef enum bcmolt_energy_detect_source
{
    BCMOLT_ENERGY_DETECT_SOURCE__BEGIN                          = 0,
    BCMOLT_ENERGY_DETECT_SOURCE_INTERNAL                        = 0,    /**< internal. */
    BCMOLT_ENERGY_DETECT_SOURCE_TRX                             = 1,    /**< TRX. */
    BCMOLT_ENERGY_DETECT_SOURCE_BCDR                            = 2,    /**< BCDR. */
    BCMOLT_ENERGY_DETECT_SOURCE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_energy_detect_source;

/** EPON turbo mode.  Enables double downstream speed (2G) on 1G EPON NIs 
 */
typedef enum bcmolt_epon_1g_turbo_mode
{
    BCMOLT_EPON_1G_TURBO_MODE__BEGIN                            = 0,
    BCMOLT_EPON_1G_TURBO_MODE_DISABLED                          = 0,    /**< Turbo mode is disabled - EPON NI has a dowstream data rate of 1G. */
    BCMOLT_EPON_1G_TURBO_MODE_ENABLED                           = 1,    /**< Turbo mode is enabled - EPON NI has a dowstream data rate of 2G. */
    BCMOLT_EPON_1G_TURBO_MODE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_1g_turbo_mode;

/** EPON Clock Transport Mode. 
 */
typedef enum bcmolt_epon_clock_transport_mode
{
    BCMOLT_EPON_CLOCK_TRANSPORT_MODE__BEGIN                     = 0,
    BCMOLT_EPON_CLOCK_TRANSPORT_MODE_HOST_DRIVEN                = 0,    /**< At each pulse, the Maple will issue an indication to the host containing the equivalent MPCP time for this PON. */
    BCMOLT_EPON_CLOCK_TRANSPORT_MODE_EMBEDDED_DRIVEN            = 1,    /**< At each pulse, the Maple will parse the ToD from the second UART (if available) and then format and send down an IEEE 802.1as clock transport time sync message to each user link. */
    BCMOLT_EPON_CLOCK_TRANSPORT_MODE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_clock_transport_mode;

/** Control for how the DBA handles received MPCP report frames. 
 */
typedef enum bcmolt_epon_dba_reporting_mode
{
    BCMOLT_EPON_DBA_REPORTING_MODE__BEGIN                       = 0,
    BCMOLT_EPON_DBA_REPORTING_MODE_SIEPON_A                     = 0,    /**< Handle reports as specified by SIEPON package A. */
    BCMOLT_EPON_DBA_REPORTING_MODE_SIEPON_B                     = 1,    /**< Handle reports as specified by SIEPON package B. */
    BCMOLT_EPON_DBA_REPORTING_MODE_SIEPON_C                     = 2,    /**< Handle reports as specified by SIEPON package C */
    BCMOLT_EPON_DBA_REPORTING_MODE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_dba_reporting_mode;

/** EPON link rate. 
 */
typedef enum bcmolt_epon_link_rate
{
    BCMOLT_EPON_LINK_RATE__BEGIN                                = 0,
    BCMOLT_EPON_LINK_RATE_TEN_TEN                               = 0,    /**< Ten_Ten. */
    BCMOLT_EPON_LINK_RATE_TEN_ONE                               = 1,    /**< Ten_One. */
    BCMOLT_EPON_LINK_RATE_ONE_ONE                               = 2,    /**< One_One. */
    BCMOLT_EPON_LINK_RATE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_rate;

/** Status. 
 */
typedef enum bcmolt_status
{
    BCMOLT_STATUS__BEGIN                                        = 0,
    BCMOLT_STATUS_OFF                                           = 0,    /**< Status is off. */
    BCMOLT_STATUS_ON                                            = 1,    /**< Status is on. */
    BCMOLT_STATUS_NO_CHANGE                                     = 2,    /**< Status should not be changed (valid for SET API calls only). */
    BCMOLT_STATUS__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_status;

/** EPON encryption mode. 
 */
typedef enum bcmolt_epon_encryption_mode
{
    BCMOLT_EPON_ENCRYPTION_MODE__BEGIN                          = 0,
    BCMOLT_EPON_ENCRYPTION_MODE_NO_ENCRYPTION                   = 0,    /**< No encryption of any kind. */
    BCMOLT_EPON_ENCRYPTION_MODE_EPON_TRIPLE_CHURNING            = 1,    /**< EPON triple-churning mode per CTC specification.  */
    BCMOLT_EPON_ENCRYPTION_MODE_EPON_ZERO_OVERHEAD_AES          = 2,    /**< EPON zero-overhead AES mode. */
    BCMOLT_EPON_ENCRYPTION_MODE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_encryption_mode;

/** Epon Key Choice. 
 */
typedef enum bcmolt_epon_key_choice
{
    BCMOLT_EPON_KEY_CHOICE__BEGIN                               = 0,
    BCMOLT_EPON_KEY_CHOICE_KEY_0                                = 0,    /**< Key 0. */
    BCMOLT_EPON_KEY_CHOICE_KEY_1                                = 1,    /**< Key 1. */
    BCMOLT_EPON_KEY_CHOICE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_key_choice;

/** EPON Encryption Direction. 
 */
typedef enum bcmolt_epon_encryption_direction
{
    BCMOLT_EPON_ENCRYPTION_DIRECTION__BEGIN                     = 0,
    BCMOLT_EPON_ENCRYPTION_DIRECTION_DOWNSTREAM_ONLY            = 0,    /**< Encrypt downstream traffic only. */
    BCMOLT_EPON_ENCRYPTION_DIRECTION__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_encryption_direction;

/** EPON FEC enable state.  See flag descriptions for restrictions. 
 */
typedef enum bcmolt_epon_fec_en_state
{
    BCMOLT_EPON_FEC_EN_STATE__BEGIN                             = 0,
    BCMOLT_EPON_FEC_EN_STATE_DISABLED                           = 0,    /**< FEC is disabled. */
    BCMOLT_EPON_FEC_EN_STATE_ENABLED                            = 1,    /**< FEC is enabled.   Note: FEC can only be enabled and disabled PON-wide for 10G paths, but can be enabled and disabled with logical link granularity for 1G paths. */
    BCMOLT_EPON_FEC_EN_STATE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_fec_en_state;

/** The types of OAM to choose from. 
 */
typedef enum bcmolt_epon_oam_type
{
    BCMOLT_EPON_OAM_TYPE__BEGIN                                 = 0,
    BCMOLT_EPON_OAM_TYPE_BROADCOM                               = 0,    /**< Broadcom OAM (formerly TEK). */
    BCMOLT_EPON_OAM_TYPE_CTC                                    = 1,    /**< CTC OAM. */
    BCMOLT_EPON_OAM_TYPE_DPOE                                   = 2,    /**< DPoE OAM */
    BCMOLT_EPON_OAM_TYPE_SIEPONA                                = 3,    /**< SiEPON OAM. (Mostly similar to DPoE). */
    BCMOLT_EPON_OAM_TYPE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_oam_type;

/** epon link fec state. 
 */
typedef enum bcmolt_epon_link_fec_state
{
    BCMOLT_EPON_LINK_FEC_STATE__BEGIN                           = 0,
    BCMOLT_EPON_LINK_FEC_STATE_DISABLED                         = 0,    /**< Disabled. */
    BCMOLT_EPON_LINK_FEC_STATE_ENABLED                          = 1,    /**< Enabled. */
    BCMOLT_EPON_LINK_FEC_STATE_USE_DEFAULT                      = 2,    /**< Use defaults. */
    BCMOLT_EPON_LINK_FEC_STATE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_fec_state;

/** The current registration status of a link. 
 */
typedef enum bcmolt_epon_link_status
{
    BCMOLT_EPON_LINK_STATUS_NONE                                = 0,
    BCMOLT_EPON_LINK_STATUS_DISCOVERED                          = 0x0001,   /**< Link has completed MPCP registration. */
    BCMOLT_EPON_LINK_STATUS_REGISTRATION_PREVENTED              = 0x0008    /**< Link is being prevented from registering. */
} bcmolt_epon_link_status;

/** MPCP discovery info. 
 */
typedef enum bcmolt_mpcp_discovery_info
{
    BCMOLT_MPCP_DISCOVERY_INFO_NONE                             = 0,
    BCMOLT_MPCP_DISCOVERY_INFO_ONE_G_CAPABLE                    = 0x0001,   /**< 1G Capable. */
    BCMOLT_MPCP_DISCOVERY_INFO_TEN_G_CAPABLE                    = 0x0002,   /**< 10G Capable. */
    BCMOLT_MPCP_DISCOVERY_INFO_ONE_G_WINDOW                     = 0x0010,   /**< 1G window. */
    BCMOLT_MPCP_DISCOVERY_INFO_TEN_G_WINDOW                     = 0x0020    /**< 10G window. */
} bcmolt_mpcp_discovery_info;

/** EPON link state flags reflect the current status of the link.  
 */
typedef enum bcmolt_epon_link_state_flags
{
    BCMOLT_EPON_LINK_STATE_FLAGS_NONE                           = 0,
    BCMOLT_EPON_LINK_STATE_FLAGS_MPCP_REGISTRATION_COMPLETE     = 0x0001    /**< Link has completed MPCP registration. */
} bcmolt_epon_link_state_flags;

/** EPON Link Type. 
 */
typedef enum bcmolt_epon_link_type
{
    BCMOLT_EPON_LINK_TYPE__BEGIN                                = 0,
    BCMOLT_EPON_LINK_TYPE_SYSTEM                                = 0,        /**< A Link automatically created for system usage. */
    BCMOLT_EPON_LINK_TYPE_DOWNSTREAM_ONLY                       = 1,        /**< A Link that does not consume upstream bandwidth. */
    BCMOLT_EPON_LINK_TYPE_BIDIRECTIONAL                         = 2,        /**< A Link that undergoes the MPCP registration process. */
    BCMOLT_EPON_LINK_TYPE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_link_type;

/** MPCP gate mode. 
 */
typedef enum bcmolt_mpcp_gate_mode
{
    BCMOLT_MPCP_GATE_MODE__BEGIN                                = 0,
    BCMOLT_MPCP_GATE_MODE_TEKNOVUS                              = 0,    /**< Teknovus MPCP registration mode. */
    BCMOLT_MPCP_GATE_MODE_CUSTOM                                = 1,    /**< Non-Teknovus MPCP registration mode. */
    BCMOLT_MPCP_GATE_MODE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_mpcp_gate_mode;

/** MPCP registration gate flags. 
 */
typedef enum bcmolt_mpcp_registration_gate_flags
{
    BCMOLT_MPCP_REGISTRATION_GATE_FLAGS_NONE                    = 0,
    BCMOLT_MPCP_REGISTRATION_GATE_FLAGS_FORCE_REPORT            = 0x0001    /**< Force report bit. */
} bcmolt_mpcp_registration_gate_flags;

/** Enable state of the EPON NI.  Initially the only enable states defined are 
 * `disabled' and `enabled', but this may later be extended to include 
 * different degrees of enablement. 
 */
typedef enum bcmolt_epon_ni_en_state
{
    BCMOLT_EPON_NI_EN_STATE__BEGIN                              = 0,
    BCMOLT_EPON_NI_EN_STATE_DISABLED                            = 0,        /**< EPON NI is fully disabled. */
    BCMOLT_EPON_NI_EN_STATE_ENABLED                             = 1,        /**< EPON NI is fully enabled. */
    BCMOLT_EPON_NI_EN_STATE_PROTECTED_WORKING                   = 2,        /**< EPON NI is fully enabled. redundant and activily carrying traffic. */
    BCMOLT_EPON_NI_EN_STATE_PROTECTED_STANDBY                   = 3,        /**< EPON NI is fully enabled. redundant and protecting another PON. */
    BCMOLT_EPON_NI_EN_STATE_PROCESSING                          = 4,        /**< EPON NI is currently transitioning between states */
    BCMOLT_EPON_NI_EN_STATE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_ni_en_state;

/** EPON OAM Extension Type. 
 */
typedef enum bcmolt_epon_oam_extension_type
{
    BCMOLT_EPON_OAM_EXTENSION_TYPE__BEGIN                       = 0,
    BCMOLT_EPON_OAM_EXTENSION_TYPE_RESERVED                     = 0,    /**< Reserved */
    BCMOLT_EPON_OAM_EXTENSION_TYPE_BROADCOM                     = 1,    /**< Broadcom */
    BCMOLT_EPON_OAM_EXTENSION_TYPE_CTC                          = 2,    /**< China Telecom */
    BCMOLT_EPON_OAM_EXTENSION_TYPE_DASAN                        = 3,    /**< Dasan Networks */
    BCMOLT_EPON_OAM_EXTENSION_TYPE_KT                           = 4,    /**< Korea Telecom */
    BCMOLT_EPON_OAM_EXTENSION_TYPE_DPOE                         = 5,    /**< DPoE */
    BCMOLT_EPON_OAM_EXTENSION_TYPE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_oam_extension_type;

/** 1 to 11 matche the DPoE response code.  Refer to DPoE-SP-OAMv1.0-I08-140807, 
 * Cl. 12.1.3. 21 to 28 are used for CTC. 
 */
typedef enum bcmolt_epon_onu_upgrade_onu_response_code
{
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_OK                    = 0,    /**< No errors. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_UNDEFINED             = 1,    /**< Unknown error, or one not covered elsewhere. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_NOT_FOUND             = 2,    /**< Read requested file that is not available. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_NO_ACCESS             = 3,    /**< Access permissions do not allow the requested read/write. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_FULL                  = 4,    /**< Storage is full, and cannot hold the written file. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ILLEGAL_OPERATION     = 5,    /**< Cannot perform requested operation in current state. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_UNKNOWN_ID            = 6,    /**< Requested file ID is not supported by this device. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_BAD_BLOCK             = 7,    /**< Block received in error. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_TIMEOUT               = 8,    /**< No block received before timer expiration. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_BUSY                  = 9,    /**< Cannot perform requested action due to other activity. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_INCOMPATIBLE_FILE     = 10,   /**< Received file is incompatible with this device. File incompatibility is determined by the device vendor. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_CORRUPTED_FILE        = 11,   /**< File was received corrupted and is unusable by this device. File integrity is determined by the device vendor. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ERROR_NOT_DEFINED     = 21,   /**< ONU returned ERROR PDU: Undefined error code. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ERROR_ALLOC_EXCEEDED  = 22,   /**< ONU returned ERROR PDU: Disk full or allocation exceeded. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ERROR_ILLEGAL_OP      = 23,   /**< ONU returned ERROR PDU: Illegal TFTP operation. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_ERROR_FILE_EXISTS     = 24,   /**< ONU returned ERROR PDU: Mirror file already exists. */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_END_WRITING_NVS       = 25,   /**< ONU returned END RESPONSE PDU with error: Writing file to NVS */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_END_CRC_ERROR         = 26,   /**< ONU returned END RESPONSE PDU with error: CRC32 error */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_END_PARAM_ERROR       = 27,   /**< ONU returned END RESPONSE PDU with error: Parameter error */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_END_CMD_UNSUPPORTED   = 28,   /**< ONU returned END RESPONSE PDU with error: Command not supported */
    BCMOLT_EPON_ONU_UPGRADE_ONU_RESPONSE_CODE_LAST                  = 29    /**< Last. */
} bcmolt_epon_onu_upgrade_onu_response_code;

/** EPON ONU Upgrade Return Code. 
 */
typedef enum bcmolt_epon_onu_upgrade_return_code
{
    BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE__BEGIN                      = 0,
    BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_SUCCESS                     = 0,    /**< Command succeeded. */
    BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_ONU_RESPONSE_TIMEOUT        = 1,    /**< ONU did not respond to a message within the time specified by the "Write request timeout". */
    BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_ONU_ERROR_RESPONSE          = 2,    /**< Error found in the ONU response. */
    BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_SYNC_ERROR                  = 3,    /**< Block number sync error. */
    BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_COMMIT_FAILED               = 4,    /**< Commit software command failed. */
    BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_INTERNAL                    = 5,    /**< Internal error. */
    BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE_PARSE_ERROR                 = 6,    /**< Unable to parse the ONU response. */
    BCMOLT_EPON_ONU_UPGRADE_RETURN_CODE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_onu_upgrade_return_code;

/** Indicates whether links are unprotected, protected standby, or protected 
 * working. 
 */
typedef enum bcmolt_epon_protection_state
{
    BCMOLT_EPON_PROTECTION_STATE__BEGIN                             = 0,
    BCMOLT_EPON_PROTECTION_STATE_UNPROTECTED                        = 0,    /**< The link is not a member of a protection pair. */
    BCMOLT_EPON_PROTECTION_STATE_PROTECTED_STANDBY                  = 1,    /**< The link is a member of a protection pair in the standby role. */
    BCMOLT_EPON_PROTECTION_STATE_PROTECTED_WORKING                  = 2,    /**< The link is a member of a protection pair in the working role. */
    BCMOLT_EPON_PROTECTION_STATE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_protection_state;

/** EPON Protection Switching Type. 
 */
typedef enum bcmolt_epon_protection_switching_type
{
    BCMOLT_EPON_PROTECTION_SWITCHING_TYPE__BEGIN                        = 0,
    BCMOLT_EPON_PROTECTION_SWITCHING_TYPE_NO_PROTECTION_SWTICHING       = 0,    /**< No protection swtiching. */
    BCMOLT_EPON_PROTECTION_SWITCHING_TYPE_LINE_CARD_PROTECTION_SWITCHING= 1,    /**< Line card protection switching. */
    BCMOLT_EPON_PROTECTION_SWITCHING_TYPE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_epon_protection_switching_type;

/** Protection Switching Detection Options. 
 */
typedef enum bcmolt_protection_switching_detection_options
{
    BCMOLT_PROTECTION_SWITCHING_DETECTION_OPTIONS_NONE                  = 0,
    BCMOLT_PROTECTION_SWITCHING_DETECTION_OPTIONS_STANDBY_LOS_DETECTION = 0x0001            /**< Standby LOS detection. */
} bcmolt_protection_switching_detection_options;

/** Criteria for logical link selection during re-ranging process 
 */
typedef enum bcmolt_epon_protection_switching_reranging_options
{
    BCMOLT_EPON_PROTECTION_SWITCHING_RERANGING_OPTIONS_RERANGE_NONE                 = 1,    /**< No re-ranging at all */
    BCMOLT_EPON_PROTECTION_SWITCHING_RERANGING_OPTIONS_RERANGE_SINGLE_LOGICAL_LINK  = 2,    /**< Pick minimum logical links to re-range */
    BCMOLT_EPON_PROTECTION_SWITCHING_RERANGING_OPTIONS_RERANGE_ALL_LOGICAL_LINKS    = 4     /**< Individually re-range all logical links */
} bcmolt_epon_protection_switching_reranging_options;

/** GPIO pin number. 
 */
typedef enum bcmolt_gpio_pin
{
    BCMOLT_GPIO_PIN_PIN0                                                            = 0,    /**< GPIO pin 0. */
    BCMOLT_GPIO_PIN_PIN1                                                            = 1,    /**< GPIO pin 1. */
    BCMOLT_GPIO_PIN_PIN2                                                            = 2,    /**< GPIO pin 2. */
    BCMOLT_GPIO_PIN_PIN3                                                            = 3,    /**< GPIO pin 3. */
    BCMOLT_GPIO_PIN_PIN4                                                            = 4,    /**< GPIO pin 4. */
    BCMOLT_GPIO_PIN_PIN5                                                            = 5,    /**< GPIO pin 5. */
    BCMOLT_GPIO_PIN_PIN6                                                            = 6,    /**< GPIO pin 6. */
    BCMOLT_GPIO_PIN_PIN7                                                            = 7,    /**< GPIO pin 7. */
    BCMOLT_GPIO_PIN_PIN8                                                            = 8,    /**< GPIO pin 8. */
    BCMOLT_GPIO_PIN_PIN9                                                            = 9,    /**< GPIO pin 9. */
    BCMOLT_GPIO_PIN_PIN10                                                           = 10,   /**< GPIO pin 10. */
    BCMOLT_GPIO_PIN_PIN11                                                           = 11,   /**< GPIO pin 11. */
    BCMOLT_GPIO_PIN_PIN12                                                           = 12,   /**< GPIO pin 12. */
    BCMOLT_GPIO_PIN_PIN13                                                           = 13,   /**< GPIO pin 13. */
    BCMOLT_GPIO_PIN_PIN14                                                           = 14,   /**< GPIO pin 14. */
    BCMOLT_GPIO_PIN_PIN15                                                           = 15,   /**< GPIO pin 15. */
    BCMOLT_GPIO_PIN_PIN16                                                           = 16,   /**< GPIO pin 16. */
    BCMOLT_GPIO_PIN_PIN17                                                           = 17,   /**< GPIO pin 17. */
    BCMOLT_GPIO_PIN_PIN18                                                           = 18,   /**< GPIO pin 18. */
    BCMOLT_GPIO_PIN_PIN19                                                           = 19,   /**< GPIO pin 19. */
    BCMOLT_GPIO_PIN_PIN20                                                           = 20,   /**< GPIO pin 20. */
    BCMOLT_GPIO_PIN_PIN21                                                           = 21,   /**< GPIO pin 21. */
    BCMOLT_GPIO_PIN_PIN22                                                           = 22,   /**< GPIO pin 22. */
    BCMOLT_GPIO_PIN_PIN23                                                           = 23,   /**< GPIO pin 23. */
    BCMOLT_GPIO_PIN_PIN24                                                           = 24,   /**< GPIO pin 24. */
    BCMOLT_GPIO_PIN_PIN25                                                           = 25,   /**< GPIO pin 25. */
    BCMOLT_GPIO_PIN_PIN26                                                           = 26,   /**< GPIO pin 26. */
    BCMOLT_GPIO_PIN_PIN27                                                           = 27,   /**< GPIO pin 27. */
    BCMOLT_GPIO_PIN_PIN28                                                           = 28,   /**< GPIO pin 28. */
    BCMOLT_GPIO_PIN_PIN29                                                           = 29,   /**< GPIO pin 29. */
    BCMOLT_GPIO_PIN_PIN30                                                           = 30,   /**< GPIO pin 30. */
    BCMOLT_GPIO_PIN_PIN31                                                           = 31,   /**< GPIO pin 31. */
    BCMOLT_GPIO_PIN_PIN32                                                           = 32,   /**< GPIO pin 32. */
    BCMOLT_GPIO_PIN_PIN33                                                           = 33,   /**< GPIO pin 33. */
    BCMOLT_GPIO_PIN_PIN34                                                           = 34,   /**< GPIO pin 34. */
    BCMOLT_GPIO_PIN_PIN35                                                           = 35,   /**< GPIO pin 35. */
    BCMOLT_GPIO_PIN_PIN36                                                           = 36,   /**< GPIO pin 36. */
    BCMOLT_GPIO_PIN_PIN37                                                           = 37,   /**< GPIO pin 37. */
    BCMOLT_GPIO_PIN_PIN38                                                           = 38,   /**< GPIO pin 38. */
    BCMOLT_GPIO_PIN_PIN39                                                           = 39,   /**< GPIO pin 39. */
    BCMOLT_GPIO_PIN_PIN40                                                           = 40,   /**< GPIO pin 40. */
    BCMOLT_GPIO_PIN_PIN41                                                           = 41,   /**< GPIO pin 41. */
    BCMOLT_GPIO_PIN_PIN42                                                           = 42,   /**< GPIO pin 42. */
    BCMOLT_GPIO_PIN_PIN43                                                           = 43,   /**< GPIO pin 43. */
    BCMOLT_GPIO_PIN_PIN44                                                           = 44,   /**< GPIO pin 44. */
    BCMOLT_GPIO_PIN_PIN45                                                           = 45,   /**< GPIO pin 45. */
    BCMOLT_GPIO_PIN_PIN46                                                           = 46,   /**< GPIO pin 46. */
    BCMOLT_GPIO_PIN_PIN47                                                           = 47,   /**< GPIO pin 47. */
    BCMOLT_GPIO_PIN_PIN48                                                           = 48,   /**< GPIO pin 48. */
    BCMOLT_GPIO_PIN_PIN49                                                           = 49,   /**< GPIO pin 49. */
    BCMOLT_GPIO_PIN_PIN50                                                           = 50,   /**< GPIO pin 50. */
    BCMOLT_GPIO_PIN_PIN51                                                           = 51,   /**< GPIO pin 51. */
    BCMOLT_GPIO_PIN_PIN52                                                           = 52,   /**< GPIO pin 52. */
    BCMOLT_GPIO_PIN_PIN53                                                           = 53,   /**< GPIO pin 53. */
    BCMOLT_GPIO_PIN_PIN54                                                           = 54,   /**< GPIO pin 54. */
    BCMOLT_GPIO_PIN_PIN55                                                           = 55,   /**< GPIO pin 55. */
    BCMOLT_GPIO_PIN_PIN56                                                           = 56,   /**< GPIO pin 56. */
    BCMOLT_GPIO_PIN_PIN57                                                           = 57,   /**< GPIO pin 57. */
    BCMOLT_GPIO_PIN_PIN58                                                           = 58,   /**< GPIO pin 58. */
    BCMOLT_GPIO_PIN_PIN59                                                           = 59,   /**< GPIO pin 59. */
    BCMOLT_GPIO_PIN_PIN60                                                           = 60,   /**< GPIO pin 60. */
    BCMOLT_GPIO_PIN_PIN61                                                           = 61,   /**< GPIO pin 61. */
    BCMOLT_GPIO_PIN_PIN62                                                           = 62,   /**< GPIO pin 62. */
    BCMOLT_GPIO_PIN_PIN63                                                           = 63,   /**< GPIO pin 63. */
    BCMOLT_GPIO_PIN_PIN64                                                           = 64,   /**< GPIO pin 64. */
    BCMOLT_GPIO_PIN_PIN65                                                           = 65,   /**< GPIO pin 65. */
    BCMOLT_GPIO_PIN_PIN66                                                           = 66,   /**< GPIO pin 66. */
    BCMOLT_GPIO_PIN_PIN67                                                           = 67,   /**< GPIO pin 67. */
    BCMOLT_GPIO_PIN_PIN68                                                           = 68,   /**< GPIO pin 68. */
    BCMOLT_GPIO_PIN_PIN69                                                           = 69,   /**< GPIO pin 69. */
    BCMOLT_GPIO_PIN_PIN70                                                           = 70,   /**< GPIO pin 70. */
    BCMOLT_GPIO_PIN_PIN71                                                           = 71,   /**< GPIO pin 71. */
    BCMOLT_GPIO_PIN_PIN72                                                           = 72,   /**< GPIO pin 72. */
    BCMOLT_GPIO_PIN_PIN73                                                           = 73,   /**< GPIO pin 73. */
    BCMOLT_GPIO_PIN_PIN74                                                           = 74,   /**< GPIO pin 74. */
    BCMOLT_GPIO_PIN_PIN75                                                           = 75,   /**< GPIO pin 75. */
    BCMOLT_GPIO_PIN_PIN76                                                           = 76,   /**< GPIO pin 76. */
    BCMOLT_GPIO_PIN_PIN77                                                           = 77,   /**< GPIO pin 77. */
    BCMOLT_GPIO_PIN_PIN78                                                           = 78,   /**< GPIO pin 78. */
    BCMOLT_GPIO_PIN_PIN79                                                           = 79,   /**< GPIO pin 79. */
    BCMOLT_GPIO_PIN_PIN80                                                           = 80,   /**< GPIO pin 80. */
    BCMOLT_GPIO_PIN_PIN81                                                           = 81,   /**< GPIO pin 81. */
    BCMOLT_GPIO_PIN_PIN82                                                           = 82,   /**< GPIO pin 82. */
    BCMOLT_GPIO_PIN_PIN83                                                           = 83,   /**< GPIO pin 83. */
    BCMOLT_GPIO_PIN_PIN84                                                           = 84,   /**< GPIO pin 84. */
    BCMOLT_GPIO_PIN_PIN85                                                           = 85,   /**< GPIO pin 85. */
    BCMOLT_GPIO_PIN_PIN86                                                           = 86,   /**< GPIO pin 86. */
    BCMOLT_GPIO_PIN_PIN87                                                           = 87,   /**< GPIO pin 87. */
    BCMOLT_GPIO_PIN_PIN88                                                           = 88,   /**< GPIO pin 88. */
    BCMOLT_GPIO_PIN_PIN89                                                           = 89,   /**< GPIO pin 89. */
    BCMOLT_GPIO_PIN_PIN90                                                           = 90,   /**< GPIO pin 90. */
    BCMOLT_GPIO_PIN_PIN91                                                           = 91,   /**< GPIO pin 91. */
    BCMOLT_GPIO_PIN_PIN92                                                           = 92,   /**< GPIO pin 92. */
    BCMOLT_GPIO_PIN_PIN93                                                           = 93,   /**< GPIO pin 93. */
    BCMOLT_GPIO_PIN_PIN94                                                           = 94,   /**< GPIO pin 94. */
    BCMOLT_GPIO_PIN_PIN95                                                           = 95,   /**< GPIO pin 95. */
    BCMOLT_GPIO_PIN_PIN96                                                           = 96,   /**< GPIO pin 96. */
    BCMOLT_GPIO_PIN_PIN97                                                           = 97,   /**< GPIO pin 97. */
    BCMOLT_GPIO_PIN_PIN98                                                           = 98,   /**< GPIO pin 98. */
    BCMOLT_GPIO_PIN_PIN99                                                           = 99,   /**< GPIO pin 99. */
    BCMOLT_GPIO_PIN_PIN100                                                          = 100,  /**< GPIO pin 100. */
    BCMOLT_GPIO_PIN_PIN101                                                          = 101,  /**< GPIO pin 101. */
    BCMOLT_GPIO_PIN_PIN102                                                          = 102,  /**< GPIO pin 102. */
    BCMOLT_GPIO_PIN_PIN103                                                          = 103,  /**< GPIO pin 103. */
    BCMOLT_GPIO_PIN_PIN104                                                          = 104,  /**< GPIO pin 104. */
    BCMOLT_GPIO_PIN_PIN105                                                          = 105,  /**< GPIO pin 105. */
    BCMOLT_GPIO_PIN_PIN106                                                          = 106,  /**< GPIO pin 106. */
    BCMOLT_GPIO_PIN_UNCONFIGURED                                                    = 255   /**< Unconfigured GPIO pin. */
} bcmolt_gpio_pin;

/** GPIO Polarity. 
 */
typedef enum bcmolt_gpio_polarity
{
    BCMOLT_GPIO_POLARITY__BEGIN                                                     = 0,
    BCMOLT_GPIO_POLARITY_ACTIVE_LOW                                                 = 0,    /**< Active Low. */
    BCMOLT_GPIO_POLARITY_ACTIVE_HIGH                                                = 1,    /**< Active High. */
    BCMOLT_GPIO_POLARITY__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gpio_polarity;

/** External IRQ. 
 */
typedef enum bcmolt_ext_irq
{
    BCMOLT_EXT_IRQ_EXT_IRQ0                                                         = 0,    /**< External IRQ 0. */
    BCMOLT_EXT_IRQ_EXT_IRQ1                                                         = 1,    /**< External IRQ 1. */
    BCMOLT_EXT_IRQ_EXT_IRQ2                                                         = 2,    /**< External IRQ 2. */
    BCMOLT_EXT_IRQ_EXT_IRQ3                                                         = 3,    /**< External IRQ 3. */
    BCMOLT_EXT_IRQ_EXT_IRQ4                                                         = 4,    /**< External IRQ 4. */
    BCMOLT_EXT_IRQ_EXT_IRQ5                                                         = 5,    /**< External IRQ 5. */
    BCMOLT_EXT_IRQ_UNCONFIGURED                                                     = 255   /**< Unconfigured external IRQ. */
} bcmolt_ext_irq;

/** Flush MAC table option. 
 */
typedef enum bcmolt_flush_mac_table_option
{
    BCMOLT_FLUSH_MAC_TABLE_OPTION__BEGIN                                            = 0,
    BCMOLT_FLUSH_MAC_TABLE_OPTION_ALL                                               = 0,    /**< All. */
    BCMOLT_FLUSH_MAC_TABLE_OPTION_PER_VID                                           = 1,    /**< PER VID. */
    BCMOLT_FLUSH_MAC_TABLE_OPTION_PER_FLOW                                          = 2,    /**< PER flow. */
    BCMOLT_FLUSH_MAC_TABLE_OPTION_VID_PLUS_FLOW                                     = 3,    /**< VID+flow. */
    BCMOLT_FLUSH_MAC_TABLE_OPTION__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_flush_mac_table_option;

/** Frequency adjustment direction 
 */
typedef enum bcmolt_frequency_adjustment_direction
{
    BCMOLT_FREQUENCY_ADJUSTMENT_DIRECTION__BEGIN                                    = 0,
    BCMOLT_FREQUENCY_ADJUSTMENT_DIRECTION_LOWER                                     = 0,    /**< Lower */
    BCMOLT_FREQUENCY_ADJUSTMENT_DIRECTION_HIGHER                                    = 1,    /**< Higher */
    BCMOLT_FREQUENCY_ADJUSTMENT_DIRECTION__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_frequency_adjustment_direction;

/** GEM port ID direction. 
 */
typedef enum bcmolt_gem_port_direction
{
    BCMOLT_GEM_PORT_DIRECTION__BEGIN                                                = 0,
    BCMOLT_GEM_PORT_DIRECTION_DOWNSTREAM                                            = 0,    /**< downstream port ID. */
    BCMOLT_GEM_PORT_DIRECTION_UPSTREAM                                              = 1,    /**< upstream port ID. */
    BCMOLT_GEM_PORT_DIRECTION_BIDIRECTIONAL                                         = 2,    /**< bidirectional port  ID. */
    BCMOLT_GEM_PORT_DIRECTION__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gem_port_direction;

/** GEM port type. 
 */
typedef enum bcmolt_gem_port_type
{
    BCMOLT_GEM_PORT_TYPE__BEGIN                                                     = 0,
    BCMOLT_GEM_PORT_TYPE_UNICAST                                                    = 0,    /**< unicast port ID. */
    BCMOLT_GEM_PORT_TYPE_MULTICAST                                                  = 1,    /**< multicast port ID. */
    BCMOLT_GEM_PORT_TYPE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_gem_port_type;

/** GEM port operation. 
 */
typedef enum bcmolt_gem_port_operation
{
    BCMOLT_GEM_PORT_OPERATION__BEGIN                                                = 0,
    BCMOLT_GEM_PORT_OPERATION_ACTIVATE                                              = 0,    /**< Activate. */
    BCMOLT_GEM_PORT_OPERATION_DEACTIVATE                                            = 1,    /**< Deactivate. */
    BCMOLT_GEM_PORT_OPERATION__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gem_port_operation;

/** GPIO PIN Direction. 
 */
typedef enum bcmolt_gpio_pin_dir
{
    BCMOLT_GPIO_PIN_DIR__BEGIN                                                      = 0,
    BCMOLT_GPIO_PIN_DIR_INPUT                                                       = 0,    /**< Input. */
    BCMOLT_GPIO_PIN_DIR_OUTPUT                                                      = 1,    /**< Output. */
    BCMOLT_GPIO_PIN_DIR__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpio_pin_dir;

/** GPIO Value. 
 */
typedef enum bcmolt_gpio_value
{
    BCMOLT_GPIO_VALUE__BEGIN                                                        = 0,
    BCMOLT_GPIO_VALUE_CLEAR                                                         = 0,    /**< Clear. */
    BCMOLT_GPIO_VALUE_SET                                                           = 1,    /**< Set. */
    BCMOLT_GPIO_VALUE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_gpio_value;

/** GPON GEM Port State. 
 */
typedef enum bcmolt_gpon_gem_port_state
{
    BCMOLT_GPON_GEM_PORT_STATE__BEGIN                                               = 0,
    BCMOLT_GPON_GEM_PORT_STATE_NOT_CONFIGURED                                       = 0,    /**< not configured. */
    BCMOLT_GPON_GEM_PORT_STATE_INACTIVE                                             = 1,    /**< inactive. */
    BCMOLT_GPON_GEM_PORT_STATE_PROCESSING                                           = 2,    /**< processing. */
    BCMOLT_GPON_GEM_PORT_STATE_ACTIVE                                               = 3,    /**< active. */
    BCMOLT_GPON_GEM_PORT_STATE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_gem_port_state;

/** Key exchange mode. 
 */
typedef enum bcmolt_key_exchange_mode
{
    BCMOLT_KEY_EXCHANGE_MODE__BEGIN                                                 = 0,
    BCMOLT_KEY_EXCHANGE_MODE_NORMAL                                                 = 0,    /**< Normal. */
    BCMOLT_KEY_EXCHANGE_MODE_ENHANCED                                               = 1,    /**< Enhanced. */
    BCMOLT_KEY_EXCHANGE_MODE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_key_exchange_mode;

/** OMCI Device ID. 
 */
typedef enum bcmolt_omci_device_id
{
    BCMOLT_OMCI_DEVICE_ID_BASELINE                                                  = 10,   /**< Baseline. */
    BCMOLT_OMCI_DEVICE_ID_EXTENDED                                                  = 11    /**< Extended. */
} bcmolt_omci_device_id;

/** GPON ONU Upgrade Return Code. 
 */
typedef enum bcmolt_gpon_onu_upgrade_return_code
{
    BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE__BEGIN                                      = 0,
    BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_SUCCESS                                     = 0,    /**< Command succeeded. */
    BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_ONU_RESPONSE_TIMEOUT                        = 1,    /**< ONU did not respond to a message within the time specified by the "Write request timeout". */
    BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_ONU_ERROR_RESPONSE                          = 2,    /**< Error found in the ONU response. */
    BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_TCI_MISMATCH                                = 3,    /**< Transaction ID mismatch. */
    BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_GET_IMAGE_FAILED                            = 4,    /**< Get Image Info command failed. */
    BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_ACTIVATION_FAILED                           = 5,    /**< Activation software command failed. */
    BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE_INTERNAL                                    = 6,    /**< Internal error. */
    BCMOLT_GPON_ONU_UPGRADE_RETURN_CODE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_gpon_onu_upgrade_return_code;

/** G.988 OMCI Result Code. 
 */
typedef enum bcmolt_omci_result_code
{
    BCMOLT_OMCI_RESULT_CODE__BEGIN                                                  = 0,
    BCMOLT_OMCI_RESULT_CODE_NO_ERROR                                                = 0,    /**< Command processed successfully. */
    BCMOLT_OMCI_RESULT_CODE_PROCESSING_ERROR                                        = 1,    /**< Command processing error. */
    BCMOLT_OMCI_RESULT_CODE_NOT_SUPPORTED                                           = 2,    /**< Command not supported, or not applicable for End software download message. */
    BCMOLT_OMCI_RESULT_CODE_PARAMETER_ERROR                                         = 3,    /**< Parameter error, or not applicable for End software download message. */
    BCMOLT_OMCI_RESULT_CODE_UNKNOWN_ENTITY                                          = 4,    /**< Unknown managed entity. */
    BCMOLT_OMCI_RESULT_CODE_UNKNOWN_INSTANCE                                        = 5,    /**< Unknown managed entity instance. */
    BCMOLT_OMCI_RESULT_CODE_DEVICE_BUSY                                             = 6,    /**< Device busy. */
    BCMOLT_OMCI_RESULT_CODE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_omci_result_code;

/** ONU state. 
 */
typedef enum bcmolt_onu_state
{
    BCMOLT_ONU_STATE_NOT_CONFIGURED                                                 = 0,    /**< not_configured. */
    BCMOLT_ONU_STATE_INACTIVE                                                       = 1,    /**< inactive. */
    BCMOLT_ONU_STATE_ACTIVE                                                         = 2,    /**< active. */
    BCMOLT_ONU_STATE_ACTIVE_STANDBY                                                 = 3,    /**< active standby. */
    BCMOLT_ONU_STATE_DISABLED                                                       = 4,    /**< disabled. */
    BCMOLT_ONU_STATE_AWAKE_FREE                                                     = 5,    /**< ONU is active, but power management is enabled. ONU is allowed to enter low power states at its own discretion. */
    BCMOLT_ONU_STATE_PROCESSING                                                     = 7,    /**< processing. */
    BCMOLT_ONU_STATE_LOW_POWER_DOZE                                                 = 8,    /**< ONU has entered the Doze low power state. */
    BCMOLT_ONU_STATE_LOW_POWER_SLEEP                                                = 9,    /**< ONU has entered the Sleep low power state. */
    BCMOLT_ONU_STATE_LOW_POWER_WATCH                                                = 10,   /**< ONU has entered the Watchful Sleep low power state. */
    BCMOLT_ONU_STATE_UNAWARE                                                        = 11    /**< ONU is added to data base but no bws is saved  */
} bcmolt_onu_state;

/** rssi location sign. 
 */
typedef enum bcmolt_rssi_location_sign
{
    BCMOLT_RSSI_LOCATION_SIGN__BEGIN                                                = 0,
    BCMOLT_RSSI_LOCATION_SIGN_BEFORE                                                = 0,    /**< before. */
    BCMOLT_RSSI_LOCATION_SIGN_AFTER                                                 = 1,    /**< after. */
    BCMOLT_RSSI_LOCATION_SIGN__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_rssi_location_sign;

/** ONU post discovery mode. 
 */
typedef enum bcmolt_onu_post_discovery_mode
{
    BCMOLT_ONU_POST_DISCOVERY_MODE__BEGIN                                           = 0,
    BCMOLT_ONU_POST_DISCOVERY_MODE_NONE                                             = 0,    /**< none. */
    BCMOLT_ONU_POST_DISCOVERY_MODE_ACTIVATE                                         = 1,    /**< activate. */
    BCMOLT_ONU_POST_DISCOVERY_MODE_DISABLE                                          = 2,    /**< disable. */
    BCMOLT_ONU_POST_DISCOVERY_MODE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_onu_post_discovery_mode;

/** Image transfer status. 
 */
typedef enum bcmolt_image_transfer_status
{
    BCMOLT_IMAGE_TRANSFER_STATUS__BEGIN                                             = 0,
    BCMOLT_IMAGE_TRANSFER_STATUS_SUCCESS                                            = 0,    /**< Success. */
    BCMOLT_IMAGE_TRANSFER_STATUS_MEMORY_ALLOCATION_FAILURE                          = 1,    /**< Memory allocation failure. */
    BCMOLT_IMAGE_TRANSFER_STATUS_UNSUPPORTED_FILE_TYPE                              = 2,    /**< Unsupported file type. */
    BCMOLT_IMAGE_TRANSFER_STATUS_CRC_ERROR                                          = 3,    /**< CRC checksum error. */
    BCMOLT_IMAGE_TRANSFER_STATUS_BLOCK_OUT_OF_SYNC                                  = 4,    /**< Block out of sync. */
    BCMOLT_IMAGE_TRANSFER_STATUS_INTERNAL_ERROR                                     = 5,    /**< Internal error. */
    BCMOLT_IMAGE_TRANSFER_STATUS_INVALID_STATE                                      = 6,    /**< Invalid state. */
    BCMOLT_IMAGE_TRANSFER_STATUS_PREMATURE_TERMINATION                              = 7,    /**< Premature termination. */
    BCMOLT_IMAGE_TRANSFER_STATUS_ACK_TIMEOUT                                        = 8,    /**< ACK timeout. */
    BCMOLT_IMAGE_TRANSFER_STATUS__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_image_transfer_status;

/** iwf mode. 
 */
typedef enum bcmolt_iwf_mode
{
    BCMOLT_IWF_MODE__BEGIN                                                          = 0,
    BCMOLT_IWF_MODE_DIRECT_MAPPING_MODE                                             = 0,    /**< DIRECT MAPPING MODE. */
    BCMOLT_IWF_MODE_PER_FLOW_MODE                                                   = 1,    /**< PER FLOW MODE. */
    BCMOLT_IWF_MODE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_iwf_mode;

/** log file id. 
 */
typedef enum bcmolt_log_file_id
{
    BCMOLT_LOG_FILE_ID__BEGIN                                                       = 0,
    BCMOLT_LOG_FILE_ID_SRAM                                                         = 0,    /**< SRAM. */
    BCMOLT_LOG_FILE_ID_DDR                                                          = 1,    /**< DDR. */
    BCMOLT_LOG_FILE_ID__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_log_file_id;

/** log level. 
 */
typedef enum bcmolt_log_level
{
    BCMOLT_LOG_LEVEL__BEGIN                                                         = 0,
    BCMOLT_LOG_LEVEL_NO_LOG                                                         = 0,    /**< no log. */
    BCMOLT_LOG_LEVEL_FATAL                                                          = 1,    /**< fatal. */
    BCMOLT_LOG_LEVEL_ERROR                                                          = 2,    /**< error. */
    BCMOLT_LOG_LEVEL_WARNING                                                        = 3,    /**< warning. */
    BCMOLT_LOG_LEVEL_INFO                                                           = 4,    /**< info. */
    BCMOLT_LOG_LEVEL_DEBUG                                                          = 5,    /**< debug. */
    BCMOLT_LOG_LEVEL__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_log_level;

/** log style. 
 */
typedef enum bcmolt_log_style
{
    BCMOLT_LOG_STYLE__BEGIN                                                         = 0,
    BCMOLT_LOG_STYLE_NORMAL                                                         = 0,    /**< normal. */
    BCMOLT_LOG_STYLE_BOLD                                                           = 1,    /**< bold. */
    BCMOLT_LOG_STYLE_UNDERLINE                                                      = 2,    /**< underline. */
    BCMOLT_LOG_STYLE_BLINK                                                          = 3,    /**< blink. */
    BCMOLT_LOG_STYLE_REVERSE_VIDEO                                                  = 4,    /**< reverse video. */
    BCMOLT_LOG_STYLE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_log_style;

/** log type. 
 */
typedef enum bcmolt_log_type
{
    BCMOLT_LOG_TYPE__BEGIN                                                          = 0,
    BCMOLT_LOG_TYPE_NONE                                                            = 0,    /**< dont show log  */
    BCMOLT_LOG_TYPE_PRINT                                                           = 1,    /**< print. */
    BCMOLT_LOG_TYPE_SAVE                                                            = 2,    /**< save. */
    BCMOLT_LOG_TYPE_BOTH                                                            = 3,    /**< both. */
    BCMOLT_LOG_TYPE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_log_type;

/** MAC table miss fallback. 
 */
typedef enum bcmolt_mac_table_miss_fallback
{
    BCMOLT_MAC_TABLE_MISS_FALLBACK__BEGIN                                           = 0,
    BCMOLT_MAC_TABLE_MISS_FALLBACK_DROP                                             = 0,    /**< The packet is dropped. */
    BCMOLT_MAC_TABLE_MISS_FALLBACK_DEFAULT_FLOW                                     = 1,    /**< The packet is forwarded with the provisioned default flow ID. */
    BCMOLT_MAC_TABLE_MISS_FALLBACK_VID                                              = 2,    /**< The packet is forwarded with a flow ID equal to its VID. */
    BCMOLT_MAC_TABLE_MISS_FALLBACK__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_mac_table_miss_fallback;

/** MAC table Learning mode. 
 */
typedef enum bcmolt_mac_table_learning_mode
{
    BCMOLT_MAC_TABLE_LEARNING_MODE__BEGIN                                           = 0,
    BCMOLT_MAC_TABLE_LEARNING_MODE_NORMAL                                           = 0,    /**< Normal mode: upstream traffic that matches on MAC/VID but doesn't match on flow ID is still allowed to pass. */
    BCMOLT_MAC_TABLE_LEARNING_MODE_MOVE                                             = 1,    /**< Normal mode: upstream traffic that matches on MAC/VID but doesn't match on flow ID is considered to be a MAC move condition. */
    BCMOLT_MAC_TABLE_LEARNING_MODE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_mac_table_learning_mode;

/** Mapping tag method. 
 */
typedef enum bcmolt_mapping_tag_method
{
    BCMOLT_MAPPING_TAG_METHOD_OUTER_VID                                             = 1,    /**< Outer VID. */
    BCMOLT_MAPPING_TAG_METHOD_INNER_VID                                             = 0     /**< Inner VID. */
} bcmolt_mapping_tag_method;

/** NNI Connection. 
 */
typedef enum bcmolt_nni_connection
{
    BCMOLT_NNI_CONNECTION__BEGIN                                                    = 0,
    BCMOLT_NNI_CONNECTION_PRIMARY                                                   = 0,    /**< Primary. */
    BCMOLT_NNI_CONNECTION_BACKUP                                                    = 1,    /**< Backup. */
    BCMOLT_NNI_CONNECTION__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_nni_connection;

/** Trivalent. 
 */
typedef enum bcmolt_trivalent
{
    BCMOLT_TRIVALENT__BEGIN                                                         = 0,
    BCMOLT_TRIVALENT_FALSE                                                          = 0,    /**< False. */
    BCMOLT_TRIVALENT_TRUE                                                           = 1,    /**< True. */
    BCMOLT_TRIVALENT_NOT_APPLICABLE                                                 = 2,    /**< Not Applicable. */
    BCMOLT_TRIVALENT__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_trivalent;

/** ODN Class. 
 */
typedef enum bcmolt_odn_class
{
    BCMOLT_ODN_CLASS_N1                                                             = 0,    /**< N1. */
    BCMOLT_ODN_CLASS_N2                                                             = 1,    /**< N2. */
    BCMOLT_ODN_CLASS_E1                                                             = 3,    /**< E1. */
    BCMOLT_ODN_CLASS_E2                                                             = 4     /**< E2. */
} bcmolt_odn_class;

/** OMCI Port ID operation. 
 */
typedef enum bcmolt_omci_port_id_operation
{
    BCMOLT_OMCI_PORT_ID_OPERATION__BEGIN                                            = 0,
    BCMOLT_OMCI_PORT_ID_OPERATION_CONFIGURE                                         = 0,    /**< configure. */
    BCMOLT_OMCI_PORT_ID_OPERATION_REMOVE                                            = 1,    /**< remove. */
    BCMOLT_OMCI_PORT_ID_OPERATION__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_omci_port_id_operation;

/** ONU operation. 
 */
typedef enum bcmolt_onu_operation
{
    BCMOLT_ONU_OPERATION__BEGIN                                                     = 0,
    BCMOLT_ONU_OPERATION_INACTIVE                                                   = 0,    /**< Inactive. */
    BCMOLT_ONU_OPERATION_ACTIVE                                                     = 1,    /**< Active. */
    BCMOLT_ONU_OPERATION_DISABLE                                                    = 2,    /**< Disable. */
    BCMOLT_ONU_OPERATION_ENABLE                                                     = 3,    /**< Enable. */
    BCMOLT_ONU_OPERATION_ACTIVE_STANDBY                                             = 4,    /**< Active Standby. */
    BCMOLT_ONU_OPERATION_AWAKE_FREE                                                 = 5,    /**< Transitions the ONU to an active state with power management enabled. Allowed in inactive, disabled, and active states. */
    BCMOLT_ONU_OPERATION__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_onu_operation;

/** ONU Power level. 
 */
typedef enum bcmolt_onu_power_level
{
    BCMOLT_ONU_POWER_LEVEL__BEGIN                                                   = 0,
    BCMOLT_ONU_POWER_LEVEL_INCREASE                                                 = 0,    /**< increase. */
    BCMOLT_ONU_POWER_LEVEL_DECREASE                                                 = 1,    /**< decrease. */
    BCMOLT_ONU_POWER_LEVEL__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_onu_power_level;

/** TC layer protocol. 
 */
typedef enum bcmolt_tc_protocol
{
    BCMOLT_TC_PROTOCOL__BEGIN                                                       = 0,
    BCMOLT_TC_PROTOCOL_TC_LAYER_PROTOCOL_G_987_P_3                                  = 0,    /**< TC layer protocol G.987.3 */
    BCMOLT_TC_PROTOCOL_TC_LAYER_PROTOCOL_G_989_P_3                                  = 1,    /**< TC layer protocol G.989.3 */
    BCMOLT_TC_PROTOCOL__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_tc_protocol;

/** Packet Injection Error. 
 */
typedef enum bcmolt_packet_injection_error
{
    BCMOLT_PACKET_INJECTION_ERROR__BEGIN                                            = 0,
    BCMOLT_PACKET_INJECTION_ERROR_GEM_PORT_NOT_ACTIVE                               = 0,    /**< GEM Port Not Active. */
    BCMOLT_PACKET_INJECTION_ERROR__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_packet_injection_error;

/** packet type. 
 */
typedef enum bcmolt_packet_type
{
    BCMOLT_PACKET_TYPE__BEGIN                                                       = 0,
    BCMOLT_PACKET_TYPE_CPU                                                          = 0,    /**< CPU. */
    BCMOLT_PACKET_TYPE_OMCI                                                         = 1,    /**< OMCI. */
    BCMOLT_PACKET_TYPE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_packet_type;

/** Password authentication fail reason. 
 */
typedef enum bcmolt_password_authentication_fail_reason
{
    BCMOLT_PASSWORD_AUTHENTICATION_FAIL_REASON__BEGIN                               = 0,
    BCMOLT_PASSWORD_AUTHENTICATION_FAIL_REASON_NONE                                 = 0,    /**< none. */
    BCMOLT_PASSWORD_AUTHENTICATION_FAIL_REASON_PASSWORD_INCONSISTENCY               = 1,    /**< Password inconsistency. */
    BCMOLT_PASSWORD_AUTHENTICATION_FAIL_REASON_PASSWORD_MISMATCH                    = 2,    /**< Password mismatch. */
    BCMOLT_PASSWORD_AUTHENTICATION_FAIL_REASON_PASSWORD_AUTHENTICATION_TIMEOUT      = 3,    /**< Password authentication timeout. */
    BCMOLT_PASSWORD_AUTHENTICATION_FAIL_REASON_ONU_ALARM                            = 4,    /**< onu alarm. */
    BCMOLT_PASSWORD_AUTHENTICATION_FAIL_REASON_LOS_EVENT                            = 5,    /**< los event. */
    BCMOLT_PASSWORD_AUTHENTICATION_FAIL_REASON_DISABLE_EVENT                        = 6,    /**< disable event. */
    BCMOLT_PASSWORD_AUTHENTICATION_FAIL_REASON__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_password_authentication_fail_reason;

/** Polarity. 
 */
typedef enum bcmolt_polarity
{
    BCMOLT_POLARITY__BEGIN                                                          = 0,
    BCMOLT_POLARITY_LOW                                                             = 0,    /**< Low. */
    BCMOLT_POLARITY_HIGH                                                            = 1,    /**< High. */
    BCMOLT_POLARITY__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_polarity;

/** Polling Interval. 
 */
typedef enum bcmolt_polling_interval
{
    BCMOLT_POLLING_INTERVAL_POLLING_DISABLED                                        = 0,            /**< No polling gates will be sent to this LLID. */
    BCMOLT_POLLING_INTERVAL_US_500                                                  = 500,          /**< 500 us. */
    BCMOLT_POLLING_INTERVAL_MS_1                                                    = 1000,         /**< 1 ms. */
    BCMOLT_POLLING_INTERVAL_MS_2                                                    = 2000,         /**< 2 ms. */
    BCMOLT_POLLING_INTERVAL_MS_4                                                    = 4000,         /**< 4 ms. */
    BCMOLT_POLLING_INTERVAL_MS_8                                                    = 8000,         /**< 8 ms. */
    BCMOLT_POLLING_INTERVAL_MS_16                                                   = 16000,        /**< 16 ms. */
    BCMOLT_POLLING_INTERVAL_AUTOMATIC                                               = 2147483647L   /**< Firmware will choose an appropriate value. */
} bcmolt_polling_interval;

/** PON Operation. 
 */
typedef enum bcmolt_pon_operation
{
    BCMOLT_PON_OPERATION__BEGIN                                                     = 0,
    BCMOLT_PON_OPERATION_INACTIVE                                                   = 0,            /**< Inactive. */
    BCMOLT_PON_OPERATION_ACTIVE_WORKING                                             = 1,            /**< Active Working. */
    BCMOLT_PON_OPERATION_ACTIVE_STANDBY                                             = 2,            /**< Active Standby. */
    BCMOLT_PON_OPERATION__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_pon_operation;

/** PON Protection Switching Options. 
 */
typedef enum bcmolt_pon_protection_switching_options
{
    BCMOLT_PON_PROTECTION_SWITCHING_OPTIONS_NONE                                    = 0,
    BCMOLT_PON_PROTECTION_SWITCHING_OPTIONS_SWIFT_POPUP                             = 0x0001,   /**< If set, switchovers will utilize the Swift_POPUP and Ranging_Adjustment PLOAMs added in G.984 annex D. */
    BCMOLT_PON_PROTECTION_SWITCHING_OPTIONS_DEBUG_FAST_RANGING                      = 0x0002    /**< If set, ONU EQDs will not be calculated as part of a switchover.  Instead, each ONU's new EQD will be equal to its last EQD when the PON NI was in active-working state.  This provides a fast switchover, but can only be used if the trunk distance never changes. */
} bcmolt_pon_protection_switching_options;

/** PON state. 
 */
typedef enum bcmolt_pon_state
{
    BCMOLT_PON_STATE__BEGIN                                                         = 0,
    BCMOLT_PON_STATE_INACTIVE                                                       = 0,        /**< Inactive. */
    BCMOLT_PON_STATE_PROCESSING                                                     = 1,        /**< Processing. */
    BCMOLT_PON_STATE_ACTIVE_WORKING                                                 = 2,        /**< Active Working. */
    BCMOLT_PON_STATE_ACTIVE_STANDBY                                                 = 3,        /**< Active Standby. */
    BCMOLT_PON_STATE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_pon_state;

/** power levelling control. 
 */
typedef enum bcmolt_power_levelling_control
{
    BCMOLT_POWER_LEVELLING_CONTROL__BEGIN                                           = 0,
    BCMOLT_POWER_LEVELLING_CONTROL_DIRECT                                           = 0,    /**< Direct. */
    BCMOLT_POWER_LEVELLING_CONTROL_DECREASE                                         = 1,    /**< Decrease. */
    BCMOLT_POWER_LEVELLING_CONTROL_INCREASE                                         = 2,    /**< Increase. */
    BCMOLT_POWER_LEVELLING_CONTROL__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_power_levelling_control;

/** The reason that a power management state change occurred. 
 */
typedef enum bcmolt_power_management_transition_reason
{
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON__BEGIN                                = 0,
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON_POWER_MANAGEMENT_ENABLED              = 0,    /**< Host requested power management enable. */
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON_POWER_MANAGEMENT_DISABLED             = 1,    /**< Host requested power management disable. */
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON_SLEEP_REQUEST_AWAKE                   = 2,    /**< Received sleep request PLOAM from ONU. */
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON_SLEEP_REQUEST_DOZE                    = 3,    /**< Received sleep request PLOAM from ONU. */
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON_SLEEP_REQUEST_SLEEP                   = 4,    /**< Received sleep request PLOAM from ONU. */
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON_SLEEP_REQUEST_WATCH                   = 5,    /**< Received sleep request PLOAM from ONU. */
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON_TERI_EXPIRED                          = 6,    /**< Teri timer expired. It has been too long since we have received an upstream burst from an ONU in a low power state. */
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON_TALERTED_EXPIRED                      = 7,    /**< Talerted timer expired. It has been too long since the ONU was requested to wake up with no idication that it has complied. */
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON_ALARM                                 = 8,    /**< A LOSi/LOFi/LOBi alarm has ben raised against the ONU. */
    BCMOLT_POWER_MANAGEMENT_TRANSITION_REASON__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_power_management_transition_reason;

/** PRBS Polynomial. 
 */
typedef enum bcmolt_prbs_polynomial
{
    BCMOLT_PRBS_POLYNOMIAL__BEGIN                                                   = 0,
    BCMOLT_PRBS_POLYNOMIAL_PRBS_7                                                   = 0,    /**< PRBS_7. */
    BCMOLT_PRBS_POLYNOMIAL_PRBS_9                                                   = 1,    /**< PRBS_9. */
    BCMOLT_PRBS_POLYNOMIAL_PRBS_11                                                  = 2,    /**< PRBS_11. */
    BCMOLT_PRBS_POLYNOMIAL_PRBS_15                                                  = 3,    /**< PRBS_15. */
    BCMOLT_PRBS_POLYNOMIAL_PRBS_23                                                  = 4,    /**< PRBS_23. */
    BCMOLT_PRBS_POLYNOMIAL_PRBS_31                                                  = 5,    /**< PRBS_31. */
    BCMOLT_PRBS_POLYNOMIAL_PRBS_58                                                  = 6,    /**< PRBS_58. */
    BCMOLT_PRBS_POLYNOMIAL__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_prbs_polynomial;

/** PRBS checker mode. 
 */
typedef enum bcmolt_prbs_checker_mode
{
    BCMOLT_PRBS_CHECKER_MODE__BEGIN                                                 = 0,
    BCMOLT_PRBS_CHECKER_MODE_SELF_SYNC                                              = 0,    /**< Self-sync mode w/ hysteresis. PRBS seed register is continuously seeded with previous received bits.  This mode results in faster locking, but bit errors are counted multiple times (often by 3x).  */
    BCMOLT_PRBS_CHECKER_MODE_INITIAL_SEED_MODE                                      = 1,    /**< Initial seed mode w/ hysteresis. PRBS seed registers is seeded with previous received bits only till PRBS lock is  acquired and then they run locally independently from the received data until the checker goes out of PRBS lock.  */
    BCMOLT_PRBS_CHECKER_MODE_INITIAL_SEED_MODE_2                                    = 2,    /**< Initial seed mode w/o hysteresis. Similar to mode 1 above except once locked it stays locked until PRBS is disabled.    */
    BCMOLT_PRBS_CHECKER_MODE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_prbs_checker_mode;

/** PRBS Lock State. 
 */
typedef enum bcmolt_prbs_lock_state
{
    BCMOLT_PRBS_LOCK_STATE__BEGIN                                                   = 0,
    BCMOLT_PRBS_LOCK_STATE_UNLOCKED                                                 = 0,    /**< PRBS Checker is out of LOCK state and state machine is searching for a LOCK */
    BCMOLT_PRBS_LOCK_STATE_LOCKED                                                   = 1,    /**< PRBS Checker is in LOCKED state */
    BCMOLT_PRBS_LOCK_STATE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_prbs_lock_state;

/** Possible Raman Mitigation settings.  Raman mitigation injects pseudo-noise 
 * into the 1G downstream data path to reduce interference with analog video 
 * signals on other wavelengths. 
 */
typedef enum bcmolt_raman_mitigation_mode
{
    BCMOLT_RAMAN_MITIGATION_MODE__BEGIN                                             = 0,
    BCMOLT_RAMAN_MITIGATION_MODE_DISABLED                                           = 0,    /**< No packets are generated. */
    BCMOLT_RAMAN_MITIGATION_MODE_RANDOM                                             = 1,    /**< Pseudo-random packets are generated. */
    BCMOLT_RAMAN_MITIGATION_MODE_FIXED                                              = 2,    /**< Fixed background packets are generated. */
    BCMOLT_RAMAN_MITIGATION_MODE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_raman_mitigation_mode;

/** Ranging fail reason. 
 */
typedef enum bcmolt_ranging_fail_reason
{
    BCMOLT_RANGING_FAIL_REASON__BEGIN                                               = 0,
    BCMOLT_RANGING_FAIL_REASON_NONE                                                 = 0,    /**< none. */
    BCMOLT_RANGING_FAIL_REASON_RANGING_ACK_TIMEOUT                                  = 1,    /**< ranging ack timeout. */
    BCMOLT_RANGING_FAIL_REASON_PLOAM_DATA_MISMATCH                                  = 2,    /**< ploam data mismatch. */
    BCMOLT_RANGING_FAIL_REASON_PLOAM_TYPE_MISMATCH                                  = 3,    /**< ploam type mismatch. */
    BCMOLT_RANGING_FAIL_REASON_PLOAM_ONU_ID_MISMATCH                                = 4,    /**< ploam onu id mismatch. */
    BCMOLT_RANGING_FAIL_REASON_DRIFT_EXCEEDED                                       = 5,    /**< drift exceeded. */
    BCMOLT_RANGING_FAIL_REASON_NO_PLOAM_RECEIVED                                    = 6,    /**< no ploam received. */
    BCMOLT_RANGING_FAIL_REASON_LOS                                                  = 7,    /**< los. */
    BCMOLT_RANGING_FAIL_REASON_ALARMS                                               = 8,    /**< alarms. */
    BCMOLT_RANGING_FAIL_REASON__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_ranging_fail_reason;

/** Registration Behavior. 
 */
typedef enum bcmolt_registration_behavior
{
    BCMOLT_REGISTRATION_BEHAVIOR__BEGIN                                             = 0,
    BCMOLT_REGISTRATION_BEHAVIOR_AUTOMATIC                                          = 0,    /**< All links will be allowed to register. */
    BCMOLT_REGISTRATION_BEHAVIOR_NOTIFY_UNKNOWN                                     = 1,    /**< Links that are not pre-provisioned will not be allowed to register.  A maskable indication will be sent to the host which can then decide if the link should be provisioned. */
    BCMOLT_REGISTRATION_BEHAVIOR__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_registration_behavior;

/** request registration fail reason. 
 */
typedef enum bcmolt_request_registration_fail_reason
{
    BCMOLT_REQUEST_REGISTRATION_FAIL_REASON__BEGIN                                  = 0,
    BCMOLT_REQUEST_REGISTRATION_FAIL_REASON_NONE                                    = 0,    /**< None. */
    BCMOLT_REQUEST_REGISTRATION_FAIL_REASON_REGISTRATION_PLOAM_TIMEOUT              = 1,    /**< registration ploam timeout. */
    BCMOLT_REQUEST_REGISTRATION_FAIL_REASON_ONU_ALARM                               = 2,    /**< onu alarm. */
    BCMOLT_REQUEST_REGISTRATION_FAIL_REASON_DEACTIVATION                            = 3,    /**< deactivation. */
    BCMOLT_REQUEST_REGISTRATION_FAIL_REASON_DISABLE                                 = 4,    /**< disable. */
    BCMOLT_REQUEST_REGISTRATION_FAIL_REASON__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_request_registration_fail_reason;

/** Result. 
 */
typedef enum bcmolt_result
{
    BCMOLT_RESULT__BEGIN                                                            = 0,
    BCMOLT_RESULT_SUCCESS                                                           = 0,    /**< Success. */
    BCMOLT_RESULT_FAIL                                                              = 1,    /**< Fail. */
    BCMOLT_RESULT__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_result;

/** Type of the rogue detection algorithm. 
 */
typedef enum bcmolt_rogue_detection_algorithm_type
{
    BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE__BEGIN                                    = 0,
    BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EARLY_ROGUE_DETECTION                     = 0,    /**< Firmware-driven periodic process which runs in the background to detect the potential rogue ONU. */
    BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_SPECIAL_MAP                               = 1,    /**< Use the user-provisioned special bandwidth map until it is told to stop. */
    BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE_EXTENDED_GUARD_TIME                       = 2,    /**< Destructive tool that extends the guard time on all bursts. */
    BCMOLT_ROGUE_DETECTION_ALGORITHM_TYPE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_rogue_detection_algorithm_type;

/** Rogue ONU detection measurement type. 
 */
typedef enum bcmolt_rogue_detection_window
{
    BCMOLT_ROGUE_DETECTION_WINDOW__BEGIN                                            = 0,
    BCMOLT_ROGUE_DETECTION_WINDOW_SILENT_WINDOW                                     = 0,    /**< Silent window measurement. */
    BCMOLT_ROGUE_DETECTION_WINDOW_CUT_OFF_WINDOW                                    = 1,    /**< Cut-off window measurement. */
    BCMOLT_ROGUE_DETECTION_WINDOW__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_rogue_detection_window;

/** Status of the rogue ONU detection result. 
 */
typedef enum bcmolt_rogue_measurement_result
{
    BCMOLT_ROGUE_MEASUREMENT_RESULT__BEGIN                                          = 0,
    BCMOLT_ROGUE_MEASUREMENT_RESULT_RSSI_COMPLETE                                   = 0,    /**< Rogue ONU RSSI detection activity completed. */
    BCMOLT_ROGUE_MEASUREMENT_RESULT_NOT_PERFORMED                                   = 1,    /**< Rogue ONU detection not performed. */
    BCMOLT_ROGUE_MEASUREMENT_RESULT_ROGUE_CYCLE_STOP                                = 2,    /**< Rogue ONU cycle detection stopped. */
    BCMOLT_ROGUE_MEASUREMENT_RESULT_RSSI_ERROR                                      = 3,    /**< There was an error in the RSSI measurement. */
    BCMOLT_ROGUE_MEASUREMENT_RESULT_RSSI_NOT_COMPLETE                               = 4,    /**< The RSSI mesaurement was not complete. */
    BCMOLT_ROGUE_MEASUREMENT_RESULT__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_rogue_measurement_result;

/** Rogue Scan Indication Status . 
 */
typedef enum bcmolt_rogue_scan_status
{
    BCMOLT_ROGUE_SCAN_STATUS__BEGIN                                                 = 0,
    BCMOLT_ROGUE_SCAN_STATUS_COMPLETE                                               = 0,    /**< Rogue Scan was completed. */
    BCMOLT_ROGUE_SCAN_STATUS_LLID_STATE_IS_BAD                                      = 1,    /**< llid in targeted scan was an active link. */
    BCMOLT_ROGUE_SCAN_STATUS_LLID_IS_OOR                                            = 2,    /**< llid in targeted scan is out of range for pon. */
    BCMOLT_ROGUE_SCAN_STATUS_SCAN_ERR_NORES                                         = 3,    /**< There were no available LIM indexes for the scan.. */
    BCMOLT_ROGUE_SCAN_STATUS_SCAN_ERR_INTERNAL                                      = 4,    /**< An internal software was encountered.. */
    BCMOLT_ROGUE_SCAN_STATUS__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_rogue_scan_status;

/** RSSI measurement fail reason. 
 */
typedef enum bcmolt_rssi_measurement_fail_reason
{
    BCMOLT_RSSI_MEASUREMENT_FAIL_REASON__BEGIN                                      = 0,
    BCMOLT_RSSI_MEASUREMENT_FAIL_REASON_NONE                                        = 0,    /**< None. */
    BCMOLT_RSSI_MEASUREMENT_FAIL_REASON_NO_DELIMITER                                = 1,    /**< No delimiter. */
    BCMOLT_RSSI_MEASUREMENT_FAIL_REASON_NO_ACCESS                                   = 2,    /**< No access. */
    BCMOLT_RSSI_MEASUREMENT_FAIL_REASON__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_rssi_measurement_fail_reason;

/** secure mutual authentication fail reason. 
 */
typedef enum bcmolt_secure_mutual_authentication_fail_reason
{
    BCMOLT_SECURE_MUTUAL_AUTHENTICATION_FAIL_REASON__BEGIN                          = 0,
    BCMOLT_SECURE_MUTUAL_AUTHENTICATION_FAIL_REASON_TIMEOUT                         = 0,    /**< secure mutual authentication timeout. */
    BCMOLT_SECURE_MUTUAL_AUTHENTICATION_FAIL_REASON__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_secure_mutual_authentication_fail_reason;

/** serdes ranging mode. 
 */
typedef enum bcmolt_serdes_ranging_mode
{
    BCMOLT_SERDES_RANGING_MODE__BEGIN                                               = 0,
    BCMOLT_SERDES_RANGING_MODE_ED_MODE                                              = 0,    /**< ed mode. */
    BCMOLT_SERDES_RANGING_MODE_BCDR_RESET_MODE                                      = 1,    /**< BCDR reset mode. */
    BCMOLT_SERDES_RANGING_MODE_FAST_MODE                                            = 2,    /**< fast mode. */
    BCMOLT_SERDES_RANGING_MODE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_serdes_ranging_mode;

/** SerDes Instance. 
 */
typedef enum bcmolt_serdes_instance
{
    BCMOLT_SERDES_INSTANCE__BEGIN                                                   = 0,
    BCMOLT_SERDES_INSTANCE_INSTANCE_0                                               = 0,    /**< Primary Serdes, or 10G SerDes for EPON pon_ids. */
    BCMOLT_SERDES_INSTANCE_INSTANCE_1                                               = 1,    /**< Secondary Serdes, or 1G/2G SerDes for EPON pon_ids. */
    BCMOLT_SERDES_INSTANCE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_serdes_instance;

/** Shaper Mode. 
 */
typedef enum bcmolt_shaper_mode
{
    BCMOLT_SHAPER_MODE__BEGIN                                                       = 0,
    BCMOLT_SHAPER_MODE_LAYER_1                                                      = 0,    /**< Shapers will count IPG, preamble, frame, and FCS */
    BCMOLT_SHAPER_MODE_LAYER_2                                                      = 1,    /**< Shapers will count frame and FCS. */
    BCMOLT_SHAPER_MODE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_shaper_mode;

/** All possible statistic alarm trigger conditions. 
 */
typedef enum bcmolt_stat_condition_type
{
    BCMOLT_STAT_CONDITION_TYPE__BEGIN                                               = 0,
    BCMOLT_STAT_CONDITION_TYPE_NONE                                                 = 0,    /**< The alarm is disabled. */
    BCMOLT_STAT_CONDITION_TYPE_RATE_THRESHOLD                                       = 1,    /**< The alarm is triggered if the stats delta value between samples crosses the configured threshold boundary. */
    BCMOLT_STAT_CONDITION_TYPE_RATE_RANGE                                           = 2,    /**< The alarm is triggered if the stats delta value between samples deviates from the configured range. */
    BCMOLT_STAT_CONDITION_TYPE_VALUE_THRESHOLD                                      = 3,    /**< The alarm is raised if the stats sample value becomes greater than this level.  The alarm is cleared when the host read the stats. */
    BCMOLT_STAT_CONDITION_TYPE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_stat_condition_type;

/** Switch over type c onu state. 
 */
typedef enum bcmolt_switch_over_type_c_onu_state
{
    BCMOLT_SWITCH_OVER_TYPE_C_ONU_STATE__BEGIN                                      = 0,
    BCMOLT_SWITCH_OVER_TYPE_C_ONU_STATE_ACTIVE                                      = 0,    /**< Active. */
    BCMOLT_SWITCH_OVER_TYPE_C_ONU_STATE_ACTIVE_STANDBY                              = 1,    /**< Active standby. */
    BCMOLT_SWITCH_OVER_TYPE_C_ONU_STATE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_switch_over_type_c_onu_state;

/** System working mode (GPON/EPON etc.) 
 */
typedef enum bcmolt_system_mode
{
    BCMOLT_SYSTEM_MODE__BEGIN                                                       = 0,
    BCMOLT_SYSTEM_MODE_GPON__16_X                                                   = 0,    /**< 16x GPON */
    BCMOLT_SYSTEM_MODE_GPON__8_X                                                    = 1,    /**< 8x GPON */
    BCMOLT_SYSTEM_MODE_GPON__4_X                                                    = 2,    /**< 4x GPON */
    BCMOLT_SYSTEM_MODE_EPON__16_X                                                   = 3,    /**< 16x EPON */
    BCMOLT_SYSTEM_MODE_XGPON_1__8_X                                                 = 4,    /**< 8x XGPON1 */
    BCMOLT_SYSTEM_MODE_EPON__8_X_COEXISTENCE_TDMA                                   = 5,    /**< 8x EPON coexistence TDMA */
    BCMOLT_SYSTEM_MODE_AE_8_X                                                       = 6,    /**< 8x 10G Active Ethernet */
    BCMOLT_SYSTEM_MODE_EPON__8_X_10_G                                               = 7,    /**< 8x EPON (10/10 only) */
    BCMOLT_SYSTEM_MODE_GPON_8_XGPON_4_X_COEXISTENCE                                 = 8,    /**< 8x GPON 4x XGPON coexistence */
    BCMOLT_SYSTEM_MODE_EPON__8_X                                                    = 9,    /**< 8x EPON (1/1 only) */
    BCMOLT_SYSTEM_MODE_EPON__4_X                                                    = 10,   /**< 4x EPON (1/1 only) */
    BCMOLT_SYSTEM_MODE_EPON__4_X_COEXISTENCE_TDMA                                   = 11,   /**< 4x EPON coexistence TDMA */
    BCMOLT_SYSTEM_MODE_EPON__4_X_10_G                                               = 12,   /**< 4x EPON (10/10 only) */
    BCMOLT_SYSTEM_MODE_XGS__2_X_10_G                                                = 13,   /**< 2x XGS-PON (10/10) */
    BCMOLT_SYSTEM_MODE_NGPON2__2_X_10_G                                             = 14,   /**< 2x NGPON2 (10/10) */
    BCMOLT_SYSTEM_MODE_NGPON2__8_X_2_P_5_G                                          = 15,   /**< 8x NGPON2 (10/2.5) */
    BCMOLT_SYSTEM_MODE_XGPON_1__4_X                                                 = 16,   /**< 4x XGPON1 */
    BCMOLT_SYSTEM_MODE_EPON__2_X_10_G                                               = 17,   /**< 2x EPON (10/10 only) */
    BCMOLT_SYSTEM_MODE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_system_mode;

/** US operating wavelength bands. 
 */
typedef enum bcmolt_us_operating_wavelength_bands
{
    BCMOLT_US_OPERATING_WAVELENGTH_BANDS_EXPANDED_SPECTRUM_WIDE_BAND                = 0,    /**< Expanded spectrum wide band option */
    BCMOLT_US_OPERATING_WAVELENGTH_BANDS_EXPANDED_SPECTRUM_REDUCED_BAND             = 1,    /**< Expanded spectrum reduced band option */
    BCMOLT_US_OPERATING_WAVELENGTH_BANDS_EXPANDED_SPECTRUM_NARROW_BAND              = 2,    /**< Expanded spectrum reduced band option */
    BCMOLT_US_OPERATING_WAVELENGTH_BANDS_SHARED_SPECTRUM_WIDE_BAND                  = 16,   /**< Shared spectrum wide band option */
    BCMOLT_US_OPERATING_WAVELENGTH_BANDS_SHARED_SPECTRUM_REDUCED_BAND               = 17,   /**< Shared spectrum reduced band option */
    BCMOLT_US_OPERATING_WAVELENGTH_BANDS_SHARED_SPECTRUM_NARROW_BAND                = 18    /**< Shared spectrum wide narrow option */
} bcmolt_us_operating_wavelength_bands;

/** Traffic resume result. 
 */
typedef enum bcmolt_traffic_resume_result
{
    BCMOLT_TRAFFIC_RESUME_RESULT__BEGIN                                             = 0,
    BCMOLT_TRAFFIC_RESUME_RESULT_SUCCESS                                            = 0,    /**< Success. */
    BCMOLT_TRAFFIC_RESUME_RESULT_FAILURE                                            = 1,    /**< Failure. */
    BCMOLT_TRAFFIC_RESUME_RESULT_SUSPECTED_LOS                                      = 2,    /**< suspected_los. */
    BCMOLT_TRAFFIC_RESUME_RESULT__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_traffic_resume_result;

/** trx calibration trigger. 
 */
typedef enum bcmolt_trx_calibration_trigger
{
    BCMOLT_TRX_CALIBRATION_TRIGGER__BEGIN                                           = 0,
    BCMOLT_TRX_CALIBRATION_TRIGGER_EPON_STAT                                        = 0,    /**< epon stat. */
    BCMOLT_TRX_CALIBRATION_TRIGGER_GPON_BCDR_RESET                                  = 1,    /**< gpon bcdr reset. */
    BCMOLT_TRX_CALIBRATION_TRIGGER_GPON_TRX_RESET                                   = 2,    /**< gpon trx reset. */
    BCMOLT_TRX_CALIBRATION_TRIGGER_GPON_TRX_ED                                      = 3,    /**< gpon trx ed. */
    BCMOLT_TRX_CALIBRATION_TRIGGER_GPON_RSSI                                        = 4,    /**< gpon rssi. */
    BCMOLT_TRX_CALIBRATION_TRIGGER_GPON_EOB                                         = 5,    /**< gpon eob. */
    BCMOLT_TRX_CALIBRATION_TRIGGER_GPON_RANGING                                     = 6,    /**< gpon ranging. */
    BCMOLT_TRX_CALIBRATION_TRIGGER_SERDES_BURST_EN                                  = 7,    /**< serdes burst en. */
    BCMOLT_TRX_CALIBRATION_TRIGGER__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_trigger;

/** trx calibration trigger position. 
 */
typedef enum bcmolt_trx_calibration_trigger_position
{
    BCMOLT_TRX_CALIBRATION_TRIGGER_POSITION__BEGIN                                  = 0,
    BCMOLT_TRX_CALIBRATION_TRIGGER_POSITION_RISING                                  = 0,    /**< rising edge. */
    BCMOLT_TRX_CALIBRATION_TRIGGER_POSITION_FALLING                                 = 1,    /**< falling edge. */
    BCMOLT_TRX_CALIBRATION_TRIGGER_POSITION__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_trigger_position;

/** trx calibration window mode. 
 */
typedef enum bcmolt_trx_calibration_window_mode
{
    BCMOLT_TRX_CALIBRATION_WINDOW_MODE__BEGIN                                       = 0,
    BCMOLT_TRX_CALIBRATION_WINDOW_MODE_RANGING                                      = 0,    /**< ranging. */
    BCMOLT_TRX_CALIBRATION_WINDOW_MODE_NON_RANGING                                  = 1,    /**< non ranging. */
    BCMOLT_TRX_CALIBRATION_WINDOW_MODE_BOTH                                         = 2,    /**< ranging and non ranging. */
    BCMOLT_TRX_CALIBRATION_WINDOW_MODE__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_calibration_window_mode;

/** TRX type. 
 */
typedef enum bcmolt_trx_type
{
    BCMOLT_TRX_TYPE__BEGIN                                                          = 0,
    BCMOLT_TRX_TYPE_SPS_43_48_H_HP_CDE_SD_2013                                      = 0,    /**< SourcePhotonics - SPS-43-48H-HP-CDE-SD Reset is required BEFORE, TRX is Squelched. till 2013 rev.  */
    BCMOLT_TRX_TYPE_SOG_4321_PSGB                                                   = 1,    /**< Superxon B+ type */
    BCMOLT_TRX_TYPE_LTE_3680_M                                                      = 2,    /**< LIGENT LTE3680M. */
    BCMOLT_TRX_TYPE_SOURCE_PHOTONICS                                                = 3,    /**< Source Photonics. */
    BCMOLT_TRX_TYPE_LTE_3680_P_TYPE_C_PLUS                                          = 4,    /**< LIGENT LTE3680P_TYPE_C_PLUS. */
    BCMOLT_TRX_TYPE_ANY                                                             = 5,    /**< Any. */
    BCMOLT_TRX_TYPE_ANY_RESET_GUARD                                                 = 6,    /**< Any reset guard. */
    BCMOLT_TRX_TYPE_ANY_RESET_PREAMBLE                                              = 7,    /**< Any reset preamble. */
    BCMOLT_TRX_TYPE_WTD_RTXM_167_526_CPLUS                                          = 8,    /**< WTD RTXM167 526 C+. */
    BCMOLT_TRX_TYPE_WTD_RTXM_167_522_BPLUS                                          = 9,    /**< WTD RTXM167 522 B+. */
    BCMOLT_TRX_TYPE_LTE_3680_P_BC                                                   = 10,   /**< LIGENT HiSense LTE3680P-BC. */
    BCMOLT_TRX_TYPE_SOGQ_4321_PSGB_C_PLUS                                           = 11,   /**< Superxon C+ type */
    BCMOLT_TRX_TYPE_WTD_RTXM167_521                                                 = 12,   /**< WTD RTXM167_521. */
    BCMOLT_TRX_TYPE_LTE3678                                                         = 13,   /**< LTE3678. */
    BCMOLT_TRX_TYPE_SOGP_4321_PSGA                                                  = 14,   /**< Superxon SOGP4321-PSGA. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_1                                                  = 15,   /**< gpon general 1. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_2                                                  = 16,   /**< gpon general 2. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_3                                                  = 17,   /**< gpon general 3. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_4                                                  = 18,   /**< gpon general 4. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_5                                                  = 19,   /**< gpon general 5. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_6                                                  = 20,   /**< gpon general 6. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_7                                                  = 21,   /**< gpon general 7. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_8                                                  = 22,   /**< gpon general 8. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_9                                                  = 23,   /**< gpon general 9. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_10                                                 = 24,   /**< gpon general 10. */
    BCMOLT_TRX_TYPE_GPON_GENERAL_11                                                 = 25,   /**< gpon general 11. */
    BCMOLT_TRX_TYPE__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_trx_type;

/** Tune in fail reason. 
 */
typedef enum bcmolt_tune_in_fail_reason
{
    BCMOLT_TUNE_IN_FAIL_REASON__BEGIN                                               = 0,
    BCMOLT_TUNE_IN_FAIL_REASON_NONE                                                 = 0,    /**< none. */
    BCMOLT_TUNE_IN_FAIL_REASON_NO_TUNING_RESPONSE_PLOAM_RECEIVED                    = 1,    /**< No tuning response ploam received. */
    BCMOLT_TUNE_IN_FAIL_REASON_ONU_ACTIVATION_FAILED                                = 2,    /**< onu activation failed. */
    BCMOLT_TUNE_IN_FAIL_REASON__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_tune_in_fail_reason;

/** Tune out fail reason. 
 */
typedef enum bcmolt_tune_out_fail_reason
{
    BCMOLT_TUNE_OUT_FAIL_REASON__BEGIN                                              = 0,
    BCMOLT_TUNE_OUT_FAIL_REASON_NONE                                                = 0,    /**< none. */
    BCMOLT_TUNE_OUT_FAIL_REASON_NACK_PLOAM_RECEIVED                                 = 1,    /**< NACK ploam received. */
    BCMOLT_TUNE_OUT_FAIL_REASON_NO_TUNING_RESPONSE_PLOAM_RECEIVED                   = 2,    /**< no tuning response ploam received. */
    BCMOLT_TUNE_OUT_FAIL_REASON_TSOURCE_TIMEOUT                                     = 3,    /**< tsource timeout. */
    BCMOLT_TUNE_OUT_FAIL_REASON_ROLLBACK_REQUEST                                    = 4,    /**< rollback request. */
    BCMOLT_TUNE_OUT_FAIL_REASON__NUM_OF /**< Number of enum entries, not an entry itself. */
} bcmolt_tune_out_fail_reason;

/** UART baud rate. 
 */
typedef enum bcmolt_uart_baudrate
{
    BCMOLT_UART_BAUDRATE__BEGIN                                                     = 0,
    BCMOLT_UART_BAUDRATE_UART_RATE_4800                                             = 0,    /**< UART rate 4800. */
    BCMOLT_UART_BAUDRATE_UART_RATE_9600                                             = 1,    /**< UART rate 9600. */
    BCMOLT_UART_BAUDRATE_UART_RATE_14400                                            = 2,    /**< UART rate 14400. */
    BCMOLT_UART_BAUDRATE_UART_RATE_19200                                            = 3,    /**< UART rate 19200. */
    BCMOLT_UART_BAUDRATE_UART_RATE_38400                                            = 4,    /**< UART rate 38400. */
    BCMOLT_UART_BAUDRATE_UART_RATE_57600                                            = 5,    /**< UART rate 57600. */
    BCMOLT_UART_BAUDRATE_UART_RATE_115200                                           = 6,    /**< UART rate 115200. */
    BCMOLT_UART_BAUDRATE_UART_RATE_230400                                           = 7,    /**< UART rate 230400. */
    BCMOLT_UART_BAUDRATE_UART_RATE_380400                                           = 8,    /**< UART rate 380400. */
    BCMOLT_UART_BAUDRATE_UART_RATE_460800                                           = 9,    /**< UART rate 460800. */
    BCMOLT_UART_BAUDRATE_UART_RATE_921600                                           = 10,   /**< UART rate 921600. */
    BCMOLT_UART_BAUDRATE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_uart_baudrate;

/** us_gem_port_destination. 
 */
typedef enum bcmolt_us_gem_port_destination
{
    BCMOLT_US_GEM_PORT_DESTINATION__BEGIN                                           = 0,
    BCMOLT_US_GEM_PORT_DESTINATION_DATA                                             = 0,    /**< data. */
    BCMOLT_US_GEM_PORT_DESTINATION_CPU                                              = 1,    /**< cpu. */
    BCMOLT_US_GEM_PORT_DESTINATION_OMCI                                             = 2,    /**< omci. */
    BCMOLT_US_GEM_PORT_DESTINATION__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_us_gem_port_destination;

/** US VLAN action. 
 */
typedef enum bcmolt_us_vlan_action
{
    BCMOLT_US_VLAN_ACTION_ADD                                                       = 1,    /**< Add. */
    BCMOLT_US_VLAN_ACTION_TRANSPARENT                                               = 0     /**< Transparent. */
} bcmolt_us_vlan_action;

/** VLAN to flow mapping method. 
 */
typedef enum bcmolt_vlan_to_flow_mapping_method
{
    BCMOLT_VLAN_TO_FLOW_MAPPING_METHOD__BEGIN                                       = 0,
    BCMOLT_VLAN_TO_FLOW_MAPPING_METHOD_VID                                          = 0,    /**< VID. */
    BCMOLT_VLAN_TO_FLOW_MAPPING_METHOD_MACPLUSVID                                   = 1,    /**< MAC+VID. */
    BCMOLT_VLAN_TO_FLOW_MAPPING_METHOD__NUM_OF  /**< Number of enum entries, not an entry itself. */
} bcmolt_vlan_to_flow_mapping_method;

/** XGPON GEM Port State. 
 */
typedef enum bcmolt_xgpon_gem_port_state
{
    BCMOLT_XGPON_GEM_PORT_STATE_NOT_CONFIGURED                                      = 0,    /**< not configured. */
    BCMOLT_XGPON_GEM_PORT_STATE_INACTIVE                                            = 1,    /**< inactive. */
    BCMOLT_XGPON_GEM_PORT_STATE_ACTIVE                                              = 3     /**< active. */
} bcmolt_xgpon_gem_port_state;

/** xgpon num of onus. 
 */
typedef enum bcmolt_xgpon_num_of_onus
{
    BCMOLT_XGPON_NUM_OF_ONUS__BEGIN                                                 = 0,
    BCMOLT_XGPON_NUM_OF_ONUS_XGPON_SUPPORT_256_ONUS                                 = 0,    /**< xgpon support 256 onus. */
    BCMOLT_XGPON_NUM_OF_ONUS_XGPON_SUPPORT_510_ONUS                                 = 1,    /**< xgpon support 510 onus. */
    BCMOLT_XGPON_NUM_OF_ONUS__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_num_of_onus;

/** xgpon serdes ranging mode. 
 */
typedef enum bcmolt_xgpon_serdes_ranging_mode
{
    BCMOLT_XGPON_SERDES_RANGING_MODE__BEGIN                                         = 0,
    BCMOLT_XGPON_SERDES_RANGING_MODE_ED                                             = 0,    /**< ed. */
    BCMOLT_XGPON_SERDES_RANGING_MODE_BCDR                                           = 1,    /**< bcdr. */
    BCMOLT_XGPON_SERDES_RANGING_MODE_FAST_RANGING1                                  = 2,    /**< fast ranging1. */
    BCMOLT_XGPON_SERDES_RANGING_MODE_FAST_RANGING2                                  = 3,    /**< fast ranging2. */
    BCMOLT_XGPON_SERDES_RANGING_MODE__NUM_OF    /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_serdes_ranging_mode;

/** XGPON TRX type. 
 */
typedef enum bcmolt_xgpon_trx_type
{
    BCMOLT_XGPON_TRX_TYPE__BEGIN                                                    = 0,
    BCMOLT_XGPON_TRX_TYPE_LTH_7222_PC                                               = 0,    /**< Ligent LTH 7222-PC. */
    BCMOLT_XGPON_TRX_TYPE_USER_DEFINED                                              = 1,    /**< User Defined. */
    BCMOLT_XGPON_TRX_TYPE_WTD_RTXM266_702                                           = 2,    /**< WTD_RTXM266_702. */
    BCMOLT_XGPON_TRX_TYPE_LTH_7222_BC_PLUS                                          = 3,    /**< SFP+ */
    BCMOLT_XGPON_TRX_TYPE_LTH_7226_PC                                               = 4,    /**< XGS */
    BCMOLT_XGPON_TRX_TYPE_LTH_5302_PC                                               = 5,    /**< 10G EPON for XGS mode */
    BCMOLT_XGPON_TRX_TYPE_XGPON_GENERAL_1                                           = 6,    /**< xgpon general 1. */
    BCMOLT_XGPON_TRX_TYPE_XGPON_GENERAL_2                                           = 7,    /**< xgpon general 2. */
    BCMOLT_XGPON_TRX_TYPE_LTW_627_X_PC                                              = 8,    /**< Supports NGPON2 TRx for various channels */
    BCMOLT_XGPON_TRX_TYPE_XPP_XE_R_3_CDFB                                           = 9,    /**< 10G EPON for XGS mode */
    BCMOLT_XGPON_TRX_TYPE__NUM_OF   /**< Number of enum entries, not an entry itself. */
} bcmolt_xgpon_trx_type;

/** Actual Scheduler/Shaper. 
 */
typedef struct bcmolt_actual_schedulershaper
{
    bcmolt_time_quanta actual_mbs_tq;       /**< Actual MBS (TQ). */
    bcmolt_time_quanta actual_weight_tq;    /**< Actual Weight (TQ). */
} bcmolt_actual_schedulershaper;

/** 128-bit AES key used for ONU authentication. 
 */
typedef struct bcmolt_aes_key
{
    uint8_t bytes[16];  /**< Bytes that comprise the key. */
} bcmolt_aes_key;

/** What portion of the capture buffer to read. 
 */
typedef struct bcmolt_api_capture_buffer_reader
{
    uint32_t offset;    /**< The bytes offset to read from. */
    uint32_t size;      /**< The number of bytes to read. */
} bcmolt_api_capture_buffer_reader;

/** Configuration for API capture. 
 */
typedef struct bcmolt_api_capture_config
{
    bcmolt_api_capture_location location;   /**< Where to perform the API capture. */
    uint32_t buffer_size_bytes;             /**< Maximum number of bytes to capture. */
    bcmolt_api_capture_buffer_mode buffer_mode; /**< What to do when the capture buffer is full. */
} bcmolt_api_capture_config;

/** Statistics on the most recent API capture. 
 */
typedef struct bcmolt_api_capture_stats
{
    uint32_t buffer_used_bytes; /**< Used space in the capture buffer (in bytes). */
    uint32_t buffer_wrap_count; /**< Number of times the capture buffer has wrapped. */
    uint32_t events_recorded;   /**< Number of events recorded in the capture buffer. */
    uint32_t events_dropped;    /**< Number of events dropped due to overflow. */
    uint32_t readable_bytes;    /**< Number of bytes needed to retrieve capture buffer. */
} bcmolt_api_capture_stats;

/** Bounds. 
 */
typedef struct bcmolt_bounds
{
    uint32_t best_case;     /**< Best Case. */
    uint32_t worst_case;    /**< Worst Case. */
} bcmolt_bounds;

/** Fixed-Length list: 8x bounds. 
 */
typedef struct bcmolt_arr_bounds_8
{
    bcmolt_bounds arr[8];   /**< Array. */
} bcmolt_arr_bounds_8;

/** Fixed-Length list: 8x calibration_record. 
 */
typedef struct bcmolt_arr_calibration_record_8
{
    bcmolt_calibration_record arr[8];   /**< Array. */
} bcmolt_arr_calibration_record_8;

/** DS frequency offset. 
 */
typedef struct bcmolt_ds_frequency_offset
{
    bcmolt_sign sign;   /**< sign. */
    uint8_t value;      /**< value. */
} bcmolt_ds_frequency_offset;

/** Channel Profile 
 */
typedef struct bcmolt_channel_profile
{
    uint8_t version;        /**< Channel profile version */
    uint8_t channel_index;  /**< Channel profile index */
    bcmolt_ds_frequency_offset ds_frequency_offset; /**< The difference between the actual OLT CT Tx frequency and the nominal central frequency for the given DWLCH ID, expressed in units of 0.1GHz */
    uint8_t channel_partition;                      /**< Channel partition */
    uint8_t uwlch_id;       /**< The assigned upstream wavelength channel ID */
    uint32_t us_frequency;  /**< The nominal central frequency of the upstream wavelength channel or a root frequency of the cyclic set of central frequencies forming an upstream wavelength channel, indicates the value in units of 0.1 GHz. */
    bcmolt_upstream_line_rate_capabilities us_rate; /**< US rate. */
    uint8_t default_onu_attenuation;                /**< The default ONU attenuation level in steps of 3dB */
    uint8_t response_threshold;                     /**< Threshold represent the maximum number of Ploams the ONU can transmit at non-zero attenuation level while attempting to establish communication with OLT CT */
    bcmolt_link_type us_link_type;                  /**< US link type. */
    bcmos_bool is_valid;    /**< is valid. */
} bcmolt_channel_profile;

/** Fixed-Length list: 8x channel_profile. 
 */
typedef struct bcmolt_arr_channel_profile_8
{
    bcmolt_channel_profile arr[8];  /**< Array. */
} bcmolt_arr_channel_profile_8;

/** Power consumption report per channel 
 */
typedef struct bcmolt_power_consumption_channel_report
{
    uint8_t ds_wavelength_channel_id;   /**< Downstream wavelength channel ID */
    uint8_t us_wavelength_channel_id;   /**< Upstream wavelength channel ID */
    uint16_t power_consumption;         /**< Power consumption */
} bcmolt_power_consumption_channel_report;

/** Fixed-Length list: 8x power_consumption_channel_report. 
 */
typedef struct bcmolt_arr_power_consumption_channel_report_8
{
    bcmolt_power_consumption_channel_report arr[8]; /**< Array. */
} bcmolt_arr_power_consumption_channel_report_8;

/** Fixed-Length list: 2x U16. 
 */
typedef struct bcmolt_arr_u16_2
{
    uint16_t arr[2];    /**< Array. */
} bcmolt_arr_u16_2;

/** Fixed-Length list: 2x U16. 
 */
typedef struct bcmolt_arr_u16_2_hex
{
    uint16_t arr[2];    /**< Array. */
} bcmolt_arr_u16_2_hex;

/** Fixed-Length list: 5x U16. 
 */
typedef struct bcmolt_arr_u16_5_hex
{
    uint16_t arr[5];    /**< Array. */
} bcmolt_arr_u16_5_hex;

/** Fixed-Length list: 7x U16. 
 */
typedef struct bcmolt_arr_u16_7
{
    uint16_t arr[7];    /**< Array. */
} bcmolt_arr_u16_7;

/** Fixed-Length list: 6x U32. 
 */
typedef struct bcmolt_arr_u32_6
{
    uint32_t arr[6];    /**< Array. */
} bcmolt_arr_u32_6;

/** Fixed-Length list: 10x U8. 
 */
typedef struct bcmolt_arr_u8_10
{
    uint8_t arr[10];    /**< Array. */
} bcmolt_arr_u8_10;

/** Fixed-Length list: 12x U8. 
 */
typedef struct bcmolt_arr_u8_12
{
    uint8_t arr[12];    /**< Array. */
} bcmolt_arr_u8_12;

/** Fixed-Length list: 13x U8. 
 */
typedef struct bcmolt_arr_u8_13
{
    uint8_t arr[13];    /**< Array. */
} bcmolt_arr_u8_13;

/** Fixed-Length list: 36x U8. 
 */
typedef struct bcmolt_arr_u8_36
{
    uint8_t arr[36];    /**< Array. */
} bcmolt_arr_u8_36;

/** Fixed-Length list: 4x U8. 
 */
typedef struct bcmolt_arr_u8_4
{
    uint8_t arr[4]; /**< Array. */
} bcmolt_arr_u8_4;

/** Fixed-Length list: 40x U8. 
 */
typedef struct bcmolt_arr_u8_40
{
    uint8_t arr[40];    /**< Array. */
} bcmolt_arr_u8_40;

/** XGPON burst profile. 
 */
typedef struct bcmolt_xgpon_burst_profile
{
    uint8_t profile_version;            /**< profile version. */
    bcmos_bool is_fec_on;               /**< is fec on. */
    uint8_t delimiter_size_in_bytes;    /**< delimiter size in bytes. */
    uint32_t delimiter_pattern_high;    /**< delimiter pattern high. */
    uint32_t delimiter_pattern_low;     /**< delimiter pattern low. */
    uint8_t preamble_length_in_bytes;   /**< preamble length in bytes. */
    uint8_t preamble_repeats_count;     /**< preamble repeats count. */
    uint32_t preamble_pattern_high;     /**< preamble pattern high. */
    uint32_t preamble_pattern_low;      /**< preamble pattern low. */
    uint64_t pon_tag;                   /**< PON tag. */
    uint32_t num_of_guard_bytes;        /**< number of guard bytes. */
    bcmos_bool is_profile_valid;        /**< is profile valid. */
    uint32_t burst_overhead_size_in_words;  /**< Burst overhead size in 4-byte words (word size is 4 bytes regardless of upstream data rate). */
} bcmolt_xgpon_burst_profile;

/** Fixed-Length list: 4x xgpon_burst_profile. 
 */
typedef struct bcmolt_arr_xgpon_burst_profile_4
{
    bcmolt_xgpon_burst_profile arr[4];  /**< Array. */
} bcmolt_arr_xgpon_burst_profile_4;

/** XGPON TRX configuration. 
 */
typedef struct bcmolt_xgpon_trx_configuration
{
    uint32_t trx_reset_pattern_first;           /**< trx reset pattern first. */
    uint32_t trx_reset_pattern_middle;          /**< trx reset pattern middle. */
    uint32_t trx_reset_pattern_last;            /**< trx reset pattern last. */
    uint8_t trx_reset_middle_repeats_count;     /**< trx reset middle repeats count. */
    uint16_t trx_reset_location;                /**< trx reset location. */
    bcmos_bool trx_reset_polarity;              /**< trx reset polarity. */
    uint32_t bcdr_reset_pattern_first;          /**< bcdr reset pattern first. */
    uint32_t bcdr_reset_pattern_middle;         /**< bcdr reset pattern middle. */
    uint32_t bcdr_reset_pattern_last;           /**< bcdr reset pattern last. */
    uint8_t bcdr_reset_middle_repeats_count;    /**< bcdr reset middle repeats count. */
    uint8_t bcdr_reset_location;                /**< bcdr reset location. */
    bcmos_bool bcdr_reset_polarity;             /**< bcdr reset polarity. */
} bcmolt_xgpon_trx_configuration;

/** Fixed-Length list: 4x xgpon_trx_configuration. 
 */
typedef struct bcmolt_arr_xgpon_trx_configuration_4
{
    bcmolt_xgpon_trx_configuration arr[4];  /**< Array. */
} bcmolt_arr_xgpon_trx_configuration_4;

/** Automatic ONU deactivation. 
 */
typedef struct bcmolt_automatic_onu_deactivation
{
    bcmos_bool los;         /**< Auto deactivate ONU due to LOS */
    bcmos_bool onu_alarms;  /**< Auto deactivate ONU due to ONU alarms */
    bcmos_bool tiwi;        /**< Auto deactivate ONU due to TIWi alarm */
    bcmos_bool ack_timeout; /**< Auto deactivate ONU due to Ack timeout */
    bcmos_bool sfi;         /**< Auto deactivate ONU due to SFi alarm */
    bcmos_bool loki;        /**< Auto deactivate ONU due to Loki alarm */
} bcmolt_automatic_onu_deactivation;

/** TRX Resync pattern control. 
 */
typedef struct bcmolt_resync_control
{
    uint8_t start_pattern;      /**< start pattern. */
    uint8_t middle_pattern;     /**< middle pattern. */
    uint8_t last_pattern;       /**< last pattern. */
    uint8_t middle_repetition;  /**< middle repetition. */
    uint8_t location;           /**< location. */
} bcmolt_resync_control;

/** BCDR resync pattern configuration. 
 */
typedef struct bcmolt_bcdr_resync_pattern_configuration
{
    bcmolt_resync_control resync_control;           /**< resync control. */
    bcmolt_resync_control ranging_resync_control;   /**< ranging resync control. */
} bcmolt_bcdr_resync_pattern_configuration;

/** BER monitoring parameters. 
 */
typedef struct bcmolt_ber_monitor_params
{
    uint32_t us_ber_interval;   /**< Interval in milliseconds for upstream BER monitoring (0 = disabled). */
    uint8_t sf_threshold;       /**< Signal fail alarm is raised when BER raises to 10^-x, where x is this number. */
    uint8_t sd_threshold;       /**< Signal degrade alarm is raised when BER raises to 10^-x, where x is this number. */
} bcmolt_ber_monitor_params;

/** CBR RT Allocation profile. 
 */
typedef struct bcmolt_cbr_rt_allocation_profile
{
    uint16_t ma_7;  /**< CBA maximum allocation size for frame gap 7 */
    uint16_t ma_3;  /**< CBA maximum allocation size for frame gap 3 */
    uint16_t ma_1;  /**< CBA maximum allocation size for frame gap 1 */
} bcmolt_cbr_rt_allocation_profile;

/** Results of the DDR test 
 */
typedef struct bcmolt_ddr_test_completed
{
    bcmolt_ddr_test_status status;  /**< Outcome of the DDR test */
    union
    {
        struct
        {
            bcmolt_ddr_test_result cpu_result;          /**< CPU Result. */
            bcmolt_ddr_test_result ras_0_result;        /**< RAS 0 Result. */
            bcmolt_ddr_test_result ras_1_result;        /**< RAS 1 Result. */
        } completed;

        struct
        {
            bcmolt_host_connection_fail_reason reason;  /**< Connection fail reason. */
        } connection_failed;
    } u;
} bcmolt_ddr_test_completed;

/** Debug parameters for device configuration 
 */
typedef struct bcmolt_debug_device_cfg
{
    uint16_t host_dma_rx_queue_size;            /**< RX Queue size of the host DMA     */
    uint16_t host_dma_tx_queue_size;            /**< TX Queue size of the host DMA     */
    bcmos_bool avs_control;                     /**< AVS control. */
    bcmos_bool use_prev_pon_serdes_firmware;    /**< This is a fallback option if there are issues with the new firmware */
    bcmos_bool use_prev_nni_serdes_firmware;    /**< This is a fallback option if there are issues with the new firmware */
} bcmolt_debug_device_cfg;

/** Device NNI Speed. 
 */
typedef struct bcmolt_device_nni_speed
{
    bcmolt_nni_speed first_half;    /**< Interface speed for the first half of the NNI ports on the system. */
    bcmolt_nni_speed second_half;   /**< Interface speed for the second half of the NNI ports on the system. */
} bcmolt_device_nni_speed;

/* \cond UNDOCUMENTED_SYMBOLS */

/** Dummy Struct For Embedded Types. 
 */
typedef struct bcmolt_dummy_struct_for_embedded_types
{
    bcmolt_aggregation_domain ad;               /**< ad. */
    bcmolt_epon_top et;                         /**< et. */
    bcmolt_epm_lim_global elg;                  /**< elg. */
    bcmolt_dba_port dba_port;                   /**< dba port. */
    bcmolt_drv_sgb_id sgb;                      /**< sgb. */
    bcmolt_drv_icf_id icf;                      /**< icf. */
    bcmolt_tfb_trap_behavior tfb_trap_behavior; /**< tfb trap behavior. */
    bcmolt_tfb_mode tfb_mode;                   /**< tfb mode. */
    bcmolt_lim_sec_mode_up lim_sec_mode_up;     /**< lim sec mode up. */
    bcmolt_lim_sec_mode_dn lim_sec_mode_dn;     /**< lim sec mode dn. */
    bcmolt_xim_sec_mode xim_sec_mode;           /**< xim sec mode. */
    bcmolt_dba_ram dba_ram;                     /**< dba ram. */
    bcmolt_hsc_ram hsc_ram;                     /**< hsc ram. */
    bcmolt_lim_ram lim_ram;                     /**< lim ram. */
    bcmolt_lky_ram lky_ram;                     /**< lky ram. */
    bcmolt_mic_ram mic_ram;                     /**< mic ram. */
    bcmolt_xpcsrm_ram xpcs_ram;                 /**< xpcs ram. */
    bcmolt_xg2g_id xg2g_id;                     /**< xg2g id. */
} bcmolt_dummy_struct_for_embedded_types;

/* \endcond */

/** Embedded image entry. 
 */
typedef struct bcmolt_embedded_image_entry
{
    bcmolt_device_image_type image_type;    /**< Type of the embedded file image. */
    uint32_t image_size;                    /**< Size of the embedded file image.  Unit is bytes. */
    uint32_t crc32; /**< CRC 32 checksum of entire file image data. */
    bcmolt_embedded_image_transfer_status status;   /**< Image transfer status. */
    char image_name[64];    /**< Name of the file image.  Null-terminated string.  This is required for the DPoE ONU only.  DPoE requires the write request OAM contains the name of the file. */
} bcmolt_embedded_image_entry;

/** Variable-length list of embedded_image_entry. 
 */
typedef struct bcmolt_embedded_image_entry_list_u8
{
    uint8_t len;                        /**< List length. */
    bcmolt_embedded_image_entry *val;   /**< List contents. */
} bcmolt_embedded_image_entry_list_u8;

/** Encryption_information_container. 
 */
typedef struct bcmolt_encryption_information_container
{
    bcmolt_epon_encryption_information_format format;   /**< Format. */
    union
    {
        struct
        {
            uint8_t key[16];    /**< Key. */
        } cfb;

        struct
        {
            uint8_t key[16];    /**< Key. */
            uint8_t sci[8];     /**< SCI. */
        } ctr;
    } u;
} bcmolt_encryption_information_container;

/** EPON clock transport configuration 
 */
typedef struct bcmolt_epon_clock_transport_configuration
{
    bcmolt_epon_clock_transport_mode epon_clock_transport_mode; /**< Clock Transport mode on this OLT PON Port. */
} bcmolt_epon_clock_transport_configuration;

/** Data of unknown link, including rate and alarm status 
 */
typedef struct bcmolt_unknown_link_status
{
    bcmolt_epon_link_rate link_rate;    /**< The rate of the unknown link */
    bcmolt_status alarm_status;         /**< Whether the unknown link alarm is raised or cleared. */
} bcmolt_unknown_link_status;

/** Data of laser on/off violating link, including attempted laser on time, 
 * attempted laser off time, and alarm status. 
 */
typedef struct bcmolt_laser_on_off_status
{
    bcmolt_time_quanta laser_on_time;   /**< The laser on time of the ONU that is violating. */
    bcmolt_time_quanta laser_off_time;  /**< The laser off time of the ONU that is violating. */
    bcmolt_status alarm_status;         /**< Whether the laser on/off violation alarm is raised or cleared. */
} bcmolt_laser_on_off_status;

/** Data of range violating link, including the range it attempted to use, and 
 * alarm status. 
 */
typedef struct bcmolt_range_status
{
    bcmolt_time_quanta range;   /**< The range that the violating link attempted to register at. */
    bcmolt_status alarm_status; /**< Whether the range violation alarm is raised or cleared. */
} bcmolt_range_status;

/** Details of Suspected Rogue ONU provided in Denied Link Alarm 
 */
typedef struct bcmolt_rogue_status
{
    bcmolt_epon_llid denied_llid;       /**< LLID. */
    bcmolt_time_quanta denied_range;    /**< ONU Range. */
    bcmolt_status alarm_status;         /**< Alarm State. */
} bcmolt_rogue_status;

/** The state of all alarms on an EPON Denied Link. 
 */
typedef struct bcmolt_epon_denied_link_alarm_state
{
    bcmolt_unknown_link_status unknown_link_violation;  /**< Unknown Link Violation. */
    bcmolt_status overhead_profile_violation;           /**< Overhead Profile Violation. */
    bcmolt_status max_link_violation;                   /**< Max Link Violation. */
    bcmolt_status llid_pool_empty_violation;            /**< LLID Pool Empty Violation. */
    bcmolt_laser_on_off_status laser_on_off_violation;  /**< Laser On/Off Violation. */
    bcmolt_status system_resource_violation;            /**< System Resource Violation. */
    bcmolt_range_status range_violation;                /**< Range Violation. */
    bcmolt_status tdm_channels_exhausted;               /**< TDM Channels Exhausted. */
    bcmolt_rogue_status rogue_violation;                /**< Rogue ONU Violation. */
    bcmolt_status upstream_bandwidth_violation;         /**< Upstream Bandwidth Violation. */
} bcmolt_epon_denied_link_alarm_state;

/** Keys and mode for encrypting the EPON logical link. 
 */
typedef struct bcmolt_epon_encryption_config
{
    bcmolt_epon_encryption_mode downstream_mode;    /**< Downstream Mode. */
    bcmolt_epon_key_choice downstream_key_choice;   /**< Downstream Key Choice. */
    bcmolt_encryption_information_container downstream_encryption_information;  /**< Downstream Encryption Information. */
    bcmolt_epon_encryption_mode upstream_mode;  /**< Upstream Mode. */
    bcmolt_epon_key_choice upstream_key_choice; /**< Upstream Key Choice. */
    bcmolt_encryption_information_container upstream_encryption_information;    /**< Upstream Encryption Information. */
} bcmolt_epon_encryption_config;

/** Key exchange configuration that applies to the EPON link. 
 */
typedef struct bcmolt_epon_key_exchange_config
{
    bcmolt_epon_oam_type oam_type;              /**< The type of OAM that is sent to start the key exchange. */
    uint16_t period;                            /**< Key exchange period in seconds.  0 means disable encryption. */
    bcmolt_epon_encryption_direction direction; /**< Encryption direction: Downstream only or Bi-directional. */
} bcmolt_epon_key_exchange_config;

/** EPON laser overhead parameters. (Laser On and Laser Off times) 
 */
typedef struct bcmolt_epon_laser_overhead_parameters
{
    bcmolt_time_quanta laser_on_time;   /**< Number of time quanta to allow for ONUs' laser-on transition. */
    bcmolt_time_quanta laser_off_time;  /**< Number of time quanta to allow for ONUs' laser-off transition. */
} bcmolt_epon_laser_overhead_parameters;

/** The state of all alarms on an EPON Link. 
 */
typedef struct bcmolt_epon_link_alarm_state
{
    bcmolt_status key_exchange_failure;         /**< Key Exchange Failure. */
    bcmolt_status invalid_mpcp_report_received; /**< Invalid MPCP Report Received. */
    bcmolt_status mpcp_report_timeout;          /**< MPCP Report Timeout. */
    bcmolt_status oam_keepalive_timeout;        /**< OAM Keepalive Timeout. */
} bcmolt_epon_link_alarm_state;

/** Downstream and upstream FEC enable state for an EPON link. 
 */
typedef struct bcmolt_epon_link_fec_en
{
    bcmolt_epon_link_fec_state upstream;    /**< FEC enable state for upstream path. */
    bcmolt_epon_link_fec_state downstream;  /**< FEC enable state for downstream path. */
} bcmolt_epon_link_fec_en;

/** EPON logical link. 
 */
typedef struct bcmolt_epon_link_info
{
    bcmolt_epon_link_status link_status;            /**< Link status flags. */
    bcmolt_epon_link_rate rate;                     /**< The rate at which the link operates. */
    bcmolt_epon_llid llid;                          /**< The LLID of the link. */
    bcmolt_mpcp_discovery_info mpcp_discovery_info; /**< Flags from MPCP discovery. */
    bcmolt_time_quanta onu_laser_on_time_tq;        /**< Laser on time reported by ONU.  This is set to 0 for 1G/1G links as 1G MPCP does not include this field. */
    bcmolt_time_quanta onu_laser_off_time_tq;       /**< Laser off time reported by ONU. */
    uint8_t pending_grants;             /**< The number of pending grants. */
    bcmolt_time_quanta range_value_tq;  /**< The link's range value in TQ. */
    bcmolt_epon_tunnel_id tunnel_id;    /**< The tunnel ID to use when sending traffic to the link. */
} bcmolt_epon_link_info;

/** Gate parameters. 
 */
typedef struct bcmolt_gate_parameters
{
    bcmolt_mpcp_registration_gate_flags flags;  /**< Flags to set for this gate. */
    uint32_t delay_before_ms;                   /**< Delay before sending this gate in milliseconds. */
    bcmolt_time_quanta gate_size_tq;            /**< Size of this gate in time quanta. */
} bcmolt_gate_parameters;

/** Variable-length list of gate_parameters. 
 */
typedef struct bcmolt_gate_parameters_list_u32
{
    uint32_t len;                   /**< List length. */
    bcmolt_gate_parameters *val;    /**< List contents. */
} bcmolt_gate_parameters_list_u32;

/** Specification of the EPON gate mode and associated parameters. 
 */
typedef struct bcmolt_epon_registration_gate_mode
{
    bcmolt_mpcp_gate_mode registration_gate_mode;   /**< MPCP registration gate mode. */
    union
    {
        struct
        {
            uint16_t reg_ack_timeout_ms;            /**< Amount of time to wait for a link to respond with a register ack after a register is sent. */
        } teknovus;

        struct
        {
            bcmolt_gate_parameters_list_u32 gates;  /**< Gates to send for REG ACK. */
        } custom;
    } u;
} bcmolt_epon_registration_gate_mode;

/** Configuration related to EPON logical link registration and reporting. 
 */
typedef struct bcmolt_epon_logical_link_options
{
    bcmolt_epon_registration_gate_mode registration_gate_mode;  /**< EPON registration gate mode. */
    bcmolt_epon_dba_reporting_mode reporting_mode;              /**< Control for how the DBA handles received MPCP report frames. */
    uint16_t max_links; /**< Maximum number of links to register on the EPON NI.  A value of zero indicates no fixed limit. This is an aggregate limit on the number of non-system links on a PON. This limit applies to both registered and non-registered links. This value cannot be reduced below the count of links currently allocated, nor is it valid to increase it above the sum of the per RP mac_links limits. */
} bcmolt_epon_logical_link_options;

/** The list of alarms defined for an EPON NI 
 */
typedef struct bcmolt_epon_ni_alarm_state
{
    bcmolt_status no_reports;   /**< No Reports. */
} bcmolt_epon_ni_alarm_state;

/** Encryption configuration that applies to the EPON NI as a whole. 
 */
typedef struct bcmolt_epon_ni_encryption_cfg
{
    bcmolt_epon_encryption_mode downstream_encryption_mode; /**< Downstream encryption mode. */
    bcmolt_epon_encryption_mode upstream_encryption_mode;   /**< Upstream encryption mode. */
} bcmolt_epon_ni_encryption_cfg;

/** EPON ONU Upgrade Parameters. 
 */
typedef struct bcmolt_epon_onu_upgrade_params
{
    bcmolt_epon_oam_extension_type oam_extension_type;  /**< OAM Extension Type. */
    union
    {
        struct
        {
            uint32_t response_timeout_ms;               /**< The length of time that the OLT will wait for the ONU to respond. */
        } broadcom;

        struct
        {
            uint32_t response_timeout_ms;               /**< The length of time that the OLT will wait for the ONU to respond. */
        } ctc;

        struct
        {
            uint32_t response_timeout_ms;               /**< The length of time that the OLT will wait for the ONU to respond. */
        } dasan;

        struct
        {
            uint32_t response_timeout_ms;               /**< The length of time that the OLT will wait for the ONU to respond. */
        } kt;

        struct
        {
            uint32_t response_timeout_ms;               /**< The length of time that the OLT will wait for the ONU to respond. */
            uint16_t block_size;                        /**< Number of byte per data block. */
            uint32_t final_ack_response_timeout;        /**< Timeout for the final ACK response.  The DPoE standard 1.0 specifies this should be at least 15 seconds.  Unit is seconds. */
        } dpoe;
    } u;
} bcmolt_epon_onu_upgrade_params;

/** EPON ONU Upgrade Status. 
 */
typedef struct bcmolt_epon_onu_upgrade_status
{
    bcmos_mac_address onu_id;                       /**< ONU ID. */
    bcmolt_epon_onu_upgrade_return_code error_code; /**< Upgrade status. */
    bcmolt_epon_onu_upgrade_onu_response_code onu_return_code;  /**< Response code from the ONU. */
} bcmolt_epon_onu_upgrade_status;

/** Variable-length list of epon_onu_upgrade_status. 
 */
typedef struct bcmolt_epon_onu_upgrade_status_list_u32
{
    uint32_t len;   /**< List length. */
    bcmolt_epon_onu_upgrade_status *val;    /**< List contents. */
} bcmolt_epon_onu_upgrade_status_list_u32;

/** EPON protection switching configuration 
 */
typedef struct bcmolt_epon_protection_switching_configuration
{
    bcmolt_epon_protection_switching_type protection_type;  /**< Protection scheme. */
    bcmolt_protection_switching_detection_options protection_switching_options; /**< Protection switching options. */
    bcmolt_epon_protection_switching_reranging_options rerange_options;         /**< Re-ranging algorithm selection */
    uint8_t rerange_attempts;                   /**< Number of times to re range during a switch */
    uint16_t rerange_interval;                  /**< Interval between re-range attempts. */
    uint16_t sync_gate_duration;                /**< Duration of sync gate. */
    bcmolt_gpio_pin gpio_input;                 /**< Configures state on PON (working/standby) */
    bcmolt_gpio_polarity gpio_input_polarity;   /**< GPIO Input Polarity. */
    bcmolt_gpio_pin gpio_output;                /**< Indicates state on PON (working/standby) */
    bcmolt_gpio_polarity gpio_output_polarity;  /**< GPIO Output Polarity. */
} bcmolt_epon_protection_switching_configuration;

/** Variable-length list of U8. 
 */
typedef struct bcmolt_u8_list_u16
{
    uint16_t len;   /**< List length. */
    uint8_t *val;   /**< List contents. */
} bcmolt_u8_list_u16;

/** A template for an Ethernet frame of some fixed length, accompanied by a mask 
 * vector of equal size.  When used in the context of frame transmission, the 
 * mask vector distinguishes bit regions of the template that should be 
 * transmitted verbatim (e.g. the content of an OAM message) from bit regions 
 * that should be filled in farther along the data path (e.g. Ethernet source 
 * or destination addresses).  When used in the context of frame reception, the 
 * mask vector distinguishes bit regions of the template that are to be 
 * compared with received frames (e.g. flags within OAM heartbeat messages 
 * received from ONUs) from "don't care" bit regions (e.g. Ethernet source 
 * addresses from those same messages).  
 */
typedef struct bcmolt_ethernet_frame_masked
{
    bcmolt_u8_list_u16 frame_octets;    /**< A complete Ethernet frame.  For every zero bit in the mask_octets */
    bcmolt_u8_list_u16 mask_octets;     /**< A bit vector of the same length as frame_octets. */
} bcmolt_ethernet_frame_masked;

/** A complete Ethernet frame, beginning with the DA (layer 2 destination 
 * address) and ending just before the FCS (frame check sequence).  In contrast 
 * to `masked Ethernet frames,' which see, unmasked Ethernet frames are 
 * transmitted or interpreted/relayed verbatim.  
 */
typedef struct bcmolt_ethernet_frame_unmasked
{
    bcmolt_u8_list_u16 frame_octets;    /**< Complete content of the Ethernet frame, beginning with the DA (layer 2 destination */
} bcmolt_ethernet_frame_unmasked;

/** Extended Guard Time. 
 */
typedef struct bcmolt_extended_guard_time
{
    uint32_t additional_preburst_guard_time;    /**< Additional guard time (in bytes) before all bursts for this ONU. */
    uint32_t additional_postburst_guard_time;   /**< Additional guard time (in bytes) after all bursts for this ONU. */
} bcmolt_extended_guard_time;

/** Firmware SW Version 
 */
typedef struct bcmolt_firmware_sw_version
{
    uint8_t major;          /**< Major . */
    uint8_t minor;          /**< Minor. */
    uint8_t revision;       /**< Revision. */
    uint32_t model;         /**< Model. */
    char build_time[32];    /**< Firmware SW build time */
} bcmolt_firmware_sw_version;

/** GEM port configuration. 
 */
typedef struct bcmolt_gem_port_configuration
{
    bcmolt_gem_port_direction direction;    /**< GEM port direction */
    bcmolt_gem_port_type type;              /**< GEM port type */
} bcmolt_gem_port_configuration;

/** GPON Alloc With State. 
 */
typedef struct bcmolt_gpon_alloc_with_state
{
    bcmolt_gpon_alloc_id alloc_id;  /**< Alloc ID. */
    bcmolt_alloc_state state;       /**< State. */
} bcmolt_gpon_alloc_with_state;

/** Variable-length list of gpon_alloc_with_state. 
 */
typedef struct bcmolt_gpon_alloc_with_state_list_u16_max_32
{
    uint16_t len;                       /**< List length. */
    bcmolt_gpon_alloc_with_state *val;  /**< List contents. */
} bcmolt_gpon_alloc_with_state_list_u16_max_32;

/** GPON Debug Flow Config. 
 */
typedef struct bcmolt_gpon_debug_flow_config
{
    bcmolt_control_state untagged_flow; /**< If enabled, this GEM port will expect upstream traffic to be untagged and downstream traffic to use a custom VLAN tag. */
    bcmolt_vlan_id untagged_vid;        /**< The VLAN ID to use when adding MAC table entries for untagged traffic. */
} bcmolt_gpon_debug_flow_config;

/** Variable-length list of gpon_gem_id. 
 */
typedef struct bcmolt_gpon_gem_id_list_u8_max_16
{
    uint8_t len;                /**< List length. */
    bcmolt_gpon_gem_id *val;    /**< List contents. */
} bcmolt_gpon_gem_id_list_u8_max_16;

/** GPON GEM Port With State. 
 */
typedef struct bcmolt_gpon_gem_port_with_state
{
    bcmolt_gpon_gem_id gem_id;          /**< GEM ID. */
    bcmolt_gpon_gem_port_state state;   /**< State. */
} bcmolt_gpon_gem_port_with_state;

/** Variable-length list of gpon_gem_port_with_state. 
 */
typedef struct bcmolt_gpon_gem_port_with_state_list_u16_max_128
{
    uint16_t len;   /**< List length. */
    bcmolt_gpon_gem_port_with_state *val;   /**< List contents. */
} bcmolt_gpon_gem_port_with_state_list_u16_max_128;

/** Variable-length list of gpon_gem_port_with_state. 
 */
typedef struct bcmolt_gpon_gem_port_with_state_list_u16_max_256
{
    uint16_t len;   /**< List length. */
    bcmolt_gpon_gem_port_with_state *val;   /**< List contents. */
} bcmolt_gpon_gem_port_with_state_list_u16_max_256;

/** Options for configuring the "untagged flow" feature. 
 */
typedef struct bcmolt_gpon_iwf_debug_flow_config
{
    bcmos_bool learn_untagged_flow_vids;        /**< When a MAC/VID is learned on an untagged flow, learn the received MAC address with both the untagged VID and the received VID (even though it will be invalid). */
    uint16_t untagged_flow_shaping_ms_per_sec;  /**< If this value is greater than 0, learning events on untagged flows will only be enabled for N milliseconds every second.  For example, a value of 10 would mean learning is only enabled for 1% of the total time. */
} bcmolt_gpon_iwf_debug_flow_config;

/** GPON Key Exchange . 
 */
typedef struct bcmolt_gpon_key_exchange
{
    uint32_t interval;              /**< Key Exchange process interval in milliseconds */
    bcmolt_control_state control;   /**< Enable\disable periodic process of Key Exchange for active ONUs */
    bcmolt_key_exchange_mode mode;  /**< Key exchange mode */
    bcmolt_control_state encrypted_ports_only;  /**< Perform key exchange only to ONUs with GEM ports that have downstream encryption enabled */
} bcmolt_gpon_key_exchange;

/** GPON MAC table scan result for a single MAC table entry. 
 */
typedef struct bcmolt_gpon_mac_table_scan_result
{
    bcmolt_vlan_id vlan;            /**< The VLAN ID of the entry. */
    bcmolt_flow_id flow_id;         /**< The flow ID assigned to traffic that matches this MAC table entry. */
    bcmos_bool stat;                /**< Whether or not the MAC entry is static.  Static entries don't age. */
    bcmolt_gpon_gem_id gem_port_id; /**< The GEM port ID of the traffic that created this table entry.  This only applies to automatically-learned entries.  Manually-added entries will have the value BCMOLT_PON_GEM_PORT_ID_INVALID. */
    bcmolt_gpon_onu_id onu_id;      /**< The ONU ID for the traffic that created this table entry.  This only valid if gem_port_id is valid.  Otherwise this will be set to BCMOLT_GPON_ONU_ID_INVALID. */
} bcmolt_gpon_mac_table_scan_result;

/** Variable-length list of gpon_mac_table_scan_result. 
 */
typedef struct bcmolt_gpon_mac_table_scan_result_list_u16
{
    uint16_t len;   /**< List length. */
    bcmolt_gpon_mac_table_scan_result *val; /**< List contents. */
} bcmolt_gpon_mac_table_scan_result_list_u16;

/** GPON NI Debug parameters 
 */
typedef struct bcmolt_gpon_ni_debug
{
    uint16_t number_of_gem_ports_per_onu;   /**< Number of Gem ports per ONU */
} bcmolt_gpon_ni_debug;

/** GPON ONU activation. 
 */
typedef struct bcmolt_gpon_onu_activation
{
    bcmolt_control_state key_exchange;              /**< Perform single key exchange during activation. */
    bcmolt_control_state password_authentication;   /**< Perform password authentication during activation */
    bcmolt_control_state fail_due_to_password_authentication_failure;   /**< Deactivate ONU due to password authentication failure */
} bcmolt_gpon_onu_activation;

/** GPON ONU alarm status. 
 */
typedef struct bcmolt_gpon_onu_alarm_state
{
    bcmolt_status losi;     /**< Loss of signal. */
    bcmolt_status lofi;     /**< Loss of frame. */
    bcmolt_status loami;    /**< Loss of PLOAM. */
    bcmolt_status dgi;      /**< Dying Gasp. */
    bcmolt_status tiwi;     /**< Transmission interference Alarm. */
    bcmolt_status dowi;     /**< Drift of Window. */
    bcmolt_status sufi;     /**< Start UP Failure. */
    bcmolt_status sfi;      /**< Signal Fail. */
    bcmolt_status sdi;      /**< Signal Degraded. */
    bcmolt_status dfi;      /**< Deactivation Failure. */
    bcmolt_status loai;     /**< Loss of ack. */
    bcmolt_status loki;     /**< loss of key. */
} bcmolt_gpon_onu_alarm_state;

/** GPON ONU alarms. 
 */
typedef struct bcmolt_gpon_onu_alarms
{
    bcmolt_status losi;     /**< LOSi. */
    bcmolt_status lofi;     /**< LOFi. */
    bcmolt_status loami;    /**< LOAMi. */
} bcmolt_gpon_onu_alarms;

/** GPON ONU alarms thresholds. 
 */
typedef struct bcmolt_gpon_onu_alarms_thresholds
{
    uint8_t losi;   /**< Threshold for asserting LOSi alarm */
    uint8_t lofi;   /**< Threshold for asserting LOFi alarm */
    uint8_t loami;  /**< Threshold for asserting LOAMi alarm */
} bcmolt_gpon_onu_alarms_thresholds;

/** GPON ONU EQD. 
 */
typedef struct bcmolt_gpon_onu_eqd
{
    bcmolt_gpon_onu_id onu_id;  /**< ONU ID. */
    uint32_t eqd;               /**< EQD. */
} bcmolt_gpon_onu_eqd;

/** Variable-length list of gpon_onu_eqd. 
 */
typedef struct bcmolt_gpon_onu_eqd_list_u32
{
    uint32_t len;               /**< List length. */
    bcmolt_gpon_onu_eqd *val;   /**< List contents. */
} bcmolt_gpon_onu_eqd_list_u32;

/** Variable-length list of gpon_onu_id. 
 */
typedef struct bcmolt_gpon_onu_id_list_u32_max_256
{
    uint32_t len;               /**< List length. */
    bcmolt_gpon_onu_id *val;    /**< List contents. */
} bcmolt_gpon_onu_id_list_u32_max_256;

/** GPON ONU upgrade params. 
 */
typedef struct bcmolt_gpon_onu_upgrade_params
{
    uint32_t response_timeout_ms;       /**< The length of time that the OLT will wait for the ONU to respond. */
    uint8_t max_retry_count;            /**< The number of retries. */
    bcmolt_omci_device_id omci_format;  /**< Baseline (0x0A) or Extended (0x0B). */
    uint16_t window_size;               /**< Number of sections per window. */
    bcmos_bool activate_commit;         /**< Automatically activate the new image and commit. */
    uint32_t delay_for_commit_ms;       /**< Delay time before COMMIT command.  Unit is milliseconds. */
    uint8_t max_activation_attempts;    /**< Maximum number of re-attempts to activate the ONU. */
} bcmolt_gpon_onu_upgrade_params;

/** GPON ONU Upgrade Status. 
 */
typedef struct bcmolt_gpon_onu_upgrade_status
{
    bcmolt_pon_onu_id onu_id;   /**< ONU ID. */
    bcmolt_gpon_onu_upgrade_return_code error_code; /**< Error Code. */
    bcmolt_omci_result_code fail_reason;            /**< Failure reason specific to the Error Code above. */
} bcmolt_gpon_onu_upgrade_status;

/** Variable-length list of gpon_onu_upgrade_status. 
 */
typedef struct bcmolt_gpon_onu_upgrade_status_list_u32
{
    uint32_t len;   /**< List length. */
    bcmolt_gpon_onu_upgrade_status *val;    /**< List contents. */
} bcmolt_gpon_onu_upgrade_status_list_u32;

/** GPON ONU With State. 
 */
typedef struct bcmolt_gpon_onu_with_state
{
    bcmolt_gpon_onu_id onu_id;  /**< ONU ID. */
    bcmolt_onu_state state;     /**< State. */
} bcmolt_gpon_onu_with_state;

/** Variable-length list of gpon_onu_with_state. 
 */
typedef struct bcmolt_gpon_onu_with_state_list_u16_max_128
{
    uint16_t len;                       /**< List length. */
    bcmolt_gpon_onu_with_state *val;    /**< List contents. */
} bcmolt_gpon_onu_with_state_list_u16_max_128;

/** gpon RSSI general configuration. 
 */
typedef struct bcmolt_gpon_rssi_general_configuration
{
    uint8_t location;   /**< the pattern activation location in clock cycles relative (before) to start of burst. */
    bcmolt_rssi_location_sign location_sign;    /**< this bit determines whether the location of the RSSI in data mode (configured as RSSI pattern 1) will be before or after the burst start. */
    uint8_t start_pattern;                      /**< the value of the first cycle of the pattern (will be transmitted once). */
    uint8_t middle_pattern;                     /**< the value of the pattern that will be transmitted middle_repetition times between the start and the end of the pattern. */
    uint8_t last_pattern;                       /**< the value of the last cycle of the pattern. will be transmitted once. */
    uint8_t middle_repertition;                 /**< the number of times the middle pattern will be repeated. */
    uint16_t minimum_burst;                     /**< the minimum burst size needed measurement */
} bcmolt_gpon_rssi_general_configuration;

/** GPON SN Acquisition. 
 */
typedef struct bcmolt_gpon_sn_acquisition
{
    uint32_t interval;              /**< SN process interval in milliseconds */
    bcmolt_control_state control;   /**< SN process control */
    bcmolt_onu_post_discovery_mode onu_post_discovery_mode; /**< Automatic operation following ONU discovery */
} bcmolt_gpon_sn_acquisition;

/** Host SW Version 
 */
typedef struct bcmolt_host_sw_version
{
    uint8_t major;          /**< Major . */
    uint8_t minor;          /**< Minor. */
    uint8_t revision;       /**< Revision. */
    uint32_t model;         /**< Model. */
    char build_time[32];    /**< Firmware SW build time */
} bcmolt_host_sw_version;

/** HW PON ID. 
 */
typedef struct bcmolt_hw_pon_id
{
    uint32_t pon_id_1;  /**< LSB 32 bits of PON ID. */
    uint32_t pon_id_2;  /**< MSB 19 bits of PON ID. */
} bcmolt_hw_pon_id;

/** Port Identity used in IEEE 802.1as Clock Tranport. 
 */
typedef struct bcmolt_ieee_8021as_port_identity
{
    uint8_t clock_identity[8];  /**< Clock identity is a unique identifier used in IEEE 802.1as clock transport. */
    uint16_t port_number;       /**< Port Number. */
} bcmolt_ieee_8021as_port_identity;

/** Timestamp used in IEEE 802.1as clock transport. 
 */
typedef struct bcmolt_ieee_8021as_timestamp
{
    uint16_t seconds_high;  /**< The high 16 bits of the 48 bit seconds field as required by IEEE. */
    uint32_t seconds_low;   /**< The low 32 bts of the 48 bit seconds field as required by IEEE. */
    uint32_t nanoseconds;   /**< The Nanoseconds part of the timestamp. */
} bcmolt_ieee_8021as_timestamp;

/** Full frame of the IEEE 802.1as time sync message used in clock transport. 
 */
typedef struct bcmolt_ieee_8021as_time_sync
{
    bcmos_mac_address destination_mac;  /**< Destination MAC Address. */
    bcmos_mac_address source_mac;       /**< Source MAC Address. */
    uint16_t eth_type_len;              /**< Type of Ethernet PDU. */
    uint8_t eth_subtype;                /**< Slow protocol Subtype. */
    uint8_t ieee_oui[3];                /**< IEEE OUI. */
    uint16_t msg_id;                    /**< Message ID. */
    uint32_t x; /**< Reference Time. */
    bcmolt_ieee_8021as_timestamp tod;               /**< Time of day timestamp. */
    bcmolt_ieee_8021as_port_identity port_identity; /**< Source port identity. */
    int8_t log_msg_interval;                        /**< Log message interval (currently unused but required by spec). */
    double rate_ratio;                  /**< Ratio of local second to grandmaster second. */
    uint16_t gm_time_base_indicator;    /**< Grandmaster time base indicator (currently unused but required by spec). */
    uint8_t last_gm_phase_change[12];   /**< Time of the current grandmaster minus the time of the previous grandmaster, in units of 2^-16 ns (currently unused but required by spec). */
    int32_t last_frequency_change;      /**< Fractional frequency offset of the current grandmaster relative to the previous grandmaster (Not currently used but required by spec). */
} bcmolt_ieee_8021as_time_sync;

/** Rate limiting / shaping for the indication channel. 
 */
typedef struct bcmolt_indication_shaping
{
    bcmos_bool enabled; /**< Whether or not the device will limit the rate of indications sent to the host. */
    uint32_t max_rate;  /**< Maximum number of indications per second to be generated by the device. */
    uint32_t max_burst; /**< Maximum number of indications that are allowed to be sent back-to-back. */
} bcmolt_indication_shaping;

/** LA resync pattern configuration. 
 */
typedef struct bcmolt_la_resync_pattern_configuration
{
    bcmolt_resync_control resync_control;   /**< used in normal mode */
    bcmolt_resync_control ranging_resync_control;   /**< used in ranging mode at the beginning of each ranging cycle */
} bcmolt_la_resync_pattern_configuration;

/** log buffer. 
 */
typedef struct bcmolt_log_buffer
{
    char buff[2048];        /**< buff. */
    uint32_t msg_to_read;   /**< msg_to_read. */
} bcmolt_log_buffer;

/** MAC table configuration. 
 */
typedef struct bcmolt_mac_table_configuration
{
    bcmolt_mac_table_miss_fallback miss_fallback;   /**< Behavior for downstream traffic when MAC table lookup fails. */
    bcmolt_flow_id default_flow_id;                 /**< Flow ID assigned to upstream traffic on a MAC table miss if miss_fallback is set to default_flow. */
    uint32_t aging_time;    /**< Aging time in seconds.  If no traffic is seen for a given MAC address / VID for this length of time, the entry will age and the host will be notified via indication. */
    bcmolt_mac_table_learning_mode learning_mode;   /**< Learning table mode. */
    bcmolt_control_state automatic_mac_learning;    /**< If enabled, new MAC table entries are added automatically the first time a new MAC address/VID combination is seen.  If disabled, no actions are taken automatically except notifying the host via indication. */
    bcmolt_control_state automatic_mac_aging;       /**< If enabled, MAC table entries are deleted automatically when they age.  If disabled, no actions are taken automatically except notifying the host via indication. */
    bcmolt_control_state automatic_mac_move;        /**< Only applicable if learning_mode is move.  If enabled, MAC table entries are automatically updated when a MAC move condition is encountered.  If disabled, no actions are taken automatically except notifying the host via indication. */
    bcmos_bool automatic_static_mode;               /**< If enabled, all MAC entries that are added automatically via automatic_mac_learning and automatic_mac_move will be treated as static (not aging). */
} bcmolt_mac_table_configuration;

/** Variable-length list of MacAddress. 
 */
typedef struct bcmolt_macaddress_list_u32
{
    uint32_t len;           /**< List length. */
    bcmos_mac_address *val; /**< List contents. */
} bcmolt_macaddress_list_u32;

/** Variable-length list of MacAddress. 
 */
typedef struct bcmolt_macaddress_list_u32_max_2048
{
    uint32_t len;           /**< List length. */
    bcmos_mac_address *val; /**< List contents. */
} bcmolt_macaddress_list_u32_max_2048;

/** NNI Link Status. 
 */
typedef struct bcmolt_nni_link_status
{
    bcmolt_trivalent link_status;       /**< The local and remote partners are abled and ready to transmit/receive traffic. */
    bcmolt_trivalent signal_detected;   /**< Serdes controller has detected energy on the line.  debugging purpose. */
    bcmolt_trivalent pmd_locked;        /**< Indicates PMD locked.  debugging purpose.  If this is true, but the links status is not, that means the transceiver is not enabled. */
} bcmolt_nni_link_status;

/** OAM heartbeat configuration 
 */
typedef struct bcmolt_oam_heartbeat_config
{
    uint16_t send_period;               /**< The period at which to send OAM info frames, and expect info responses on this link (in seconds). */
    bcmolt_u8_list_u16 transmit_frame;  /**< The OAM PDU payload from the Flags field (offset 15) to the end of the PDU (before the FCS). */
    bcmolt_ethernet_frame_masked ignored_receive_frame_template;    /**< OAM packets matching this masked payload will be dropped rather than forwarded to the host. */
    uint16_t receive_timeout;       /**< The time (in seconds) to report OAM timeout after the last received OAM frame. */
    uint16_t maximum_receive_size;  /**< Maximum size of received frames.  Setting this value to zero will cause all OAM frames to be dropped. */
} bcmolt_oam_heartbeat_config;

/** Configuration parameters for the ONU power management feature. These should 
 * match the parameters sent to the ONU via OMCI. 
 */
typedef struct bcmolt_onu_power_management_configuration
{
    uint32_t ilowpower;         /**< The maximum amount of time any ONU on this NI may spend in a low power state in units of 125us. */
    uint32_t iaware;            /**< The minimum amount of time every ONU on his NI must spend in an aware state in units of 125us. */
    uint16_t itransinit;        /**< The maximum amount of time required by any ONU on this NI to power up its transmitter only from a low power state in units of 125us. */
    uint16_t itxinit;           /**< The maximum amount of time required by any ONU on this NI to power up its transceiver (transmitter + receiver) from a low power state in units of 125us. */
    uint32_t irxoff;            /**< The maximum amount of time any ONU on this NI may spend with its receiver disabled in units of 125us. */
    uint16_t low_power_clobi;   /**< The number of consecutive non-contiguous missing allocations to allow before raising the LOSi/LOFi/LOBi alarms on any ONU on this NI. */
} bcmolt_onu_power_management_configuration;

/** onu tuning configuration. 
 */
typedef struct bcmolt_onu_tuning_configuration
{
    uint32_t tsource;   /**< Tsource timer in msec */
    uint32_t ttarget;   /**< Ttarget timer in msec */
    bcmos_bool request_registration_required;   /**< is request registration part of the tuning in process */
} bcmolt_onu_tuning_configuration;

/** Identifies the TWDM channel termination within a certain domain 
 */
typedef struct bcmolt_pon_id
{
    uint32_t administrative_label;  /**< MSB 28 bit of the PON ID */
    uint8_t dwlch_id;               /**< LSB 4 bits of the PON ID */
} bcmolt_pon_id;

/** Operation Control 
 */
typedef struct bcmolt_operation_control
{
    uint8_t re;                 /**< Indicates whether the Transmit Optical Level (TOL) contains the launch power of the OTL (RE=0) or of a reach extender (RE=1) */
    bcmolt_odn_class odn_class; /**< Identifies the nominal optical parameters of the transceiver according to the ODN Optical Path Loss (OPL) */
    bcmolt_control_state ds_fec_mode;   /**< Enable/Disable the downstream FEC. Default is Enable. Attribute can be set only when PON NI state is Inactive. */
    bcmolt_tc_protocol protocol;        /**< When system mode is NGPON2, this parameter Indicate the TC layer protocol: ITU-T G.989.3 or ITU-T G.987.3 */
    bcmolt_link_type ds_link_type;      /**< Optical link type (Unspecified, A, B, Both) */
    bcmolt_pon_id pon_id;               /**< Identifies the TWDM channel termination within a certain domain */
    uint8_t c;  /**< Transmit optical level (TOL) reference point indicator: S/R-CG or S/R-CP */
} bcmolt_operation_control;

/** Periodic Standby PON monitoring. 
 */
typedef struct bcmolt_periodic_standby_pon_monitoring
{
    uint32_t interval;              /**< interval in ms. */
    bcmolt_control_state control;   /**< control. */
} bcmolt_periodic_standby_pon_monitoring;

/** Port Level Shaper Configuration:. 
 */
typedef struct bcmolt_pon_aggregate_shaper
{
    uint32_t bandwidth_kbps;    /**< Rate in kbps, 0 is disabled, If rate is >1G then use 256kbps increments, if rate is < 1G then use 64kbps increments.  */
    uint32_t mbs_kB;            /**< Maximum Burst Size in KB : range is 2KB to 4MB in 1KB increments.  */
} bcmolt_pon_aggregate_shaper;

/** PON Alloc SLA. 
 */
typedef struct bcmolt_pon_alloc_sla
{
    uint32_t cbr_rt_bw;     /**< CBR Real Time Bandwidth which require shaping of the bandwidth allocations in a fine granularity.  */
    uint32_t cbr_nrt_bw;    /**< Fixed Bandwidth with no critical requirement of shaping */
    uint32_t guaranteed_bw; /**< Dynamic bandwidth which the OLT is committed to allocate upon demand */
    uint32_t maximum_bw;    /**< Maximum allocated bandwidth allowed for this alloc ID */
    bcmolt_additional_bw_eligibility additional_bw_eligibility; /**< Alloc ID additional BW eligibility */
    bcmos_bool cbr_rt_compensation; /**< Set to True for AllocID with CBR RT Bandwidth that requires compensation for skipped allocations during quiet window */
    uint8_t cbr_rt_ap_index;        /**< Allocation Profile index for CBR RT Bandwidth */
    uint8_t cbr_nrt_ap_index;       /**< Allocation Profile index for CBR non-RT Bandwidth */
    bcmolt_alloc_type alloc_type;   /**< Type of the alloc ID  */
    uint8_t weight;                 /**< Alloc ID Weight used in case of Extended DBA mode */
    uint8_t priority;               /**< Alloc ID Priority used in case of Extended DBA mode */
} bcmolt_pon_alloc_sla;

/** PON available bandwidth. 
 */
typedef struct bcmolt_pon_available_bandwidth
{
    uint32_t cbr_bw;            /**< Total BW available for CBR real-time traffic (bytes/sec). */
    uint32_t total_bw;          /**< Total BW available for guaranteed traffic (bytes/sec) */
    uint32_t next_onu_total_bw; /**< Total BW available for guaranteed traffic after new ONU is added (bytes/sec). */
} bcmolt_pon_available_bandwidth;

/** PON DBA. 
 */
typedef struct bcmolt_pon_dba
{
    uint8_t sr_reporting_block_size;    /**< ONU status report block size in bytes */
    bcmolt_dba_mode dba_mode;           /**< DBA mode */
} bcmolt_pon_dba;

/** PON Distance. 
 */
typedef struct bcmolt_pon_distance
{
    uint32_t max_log_distance;  /**< Max logical distance of an ONU on the PON */
    uint32_t max_diff_reach;    /**< Max distance between the closest and farthest ONU */
} bcmolt_pon_distance;

/** PON Drift Control. 
 */
typedef struct bcmolt_pon_drift_control
{
    uint32_t drift_interval;            /**< Interval in milliseconds for ONU transmission drift monitoring (0 = disabled). */
    uint8_t drift_limit;                /**< DOWi threshold in bits */
    uint8_t transmission_control_limit; /**< TIWi threshold in bits */
} bcmolt_pon_drift_control;

/** Variable-length list of pon_onu_id. 
 */
typedef struct bcmolt_pon_onu_id_list_u32
{
    uint32_t len;           /**< List length. */
    bcmolt_pon_onu_id *val; /**< List contents. */
} bcmolt_pon_onu_id_list_u32;

/** PON Power Level. 
 */
typedef struct bcmolt_pon_power_level
{
    uint32_t pls_maximum_allocation_size;   /**< Max allocation size for PLS transmission */
    uint8_t mode;   /**< ONU default power level mode */
} bcmolt_pon_power_level;

/** GPON protection switching configuration. 
 */
typedef struct bcmolt_pon_protection_switching
{
    uint16_t timeout;           /**< LOS switch over timeout in milliseconds */
    bcmolt_gpio_pin gpio_pin;   /**< GPIO pin for input/output signal */
    bcmolt_pon_protection_switching_options options;    /**< Options to control the protection switching process */
} bcmolt_pon_protection_switching;

/** PON Status. 
 */
typedef struct bcmolt_pon_status
{
    bcmolt_pon_state state;     /**< state. */
    bcmolt_status los_status;   /**< LOS status. */
} bcmolt_pon_status;

/** PRBS checker config. 
 */
typedef struct bcmolt_prbs_checker_config
{
    bcmolt_prbs_polynomial polynom; /**< PRBS polynom type */
    bcmolt_prbs_checker_mode mode;  /**< PRBS LOCK state machine. */
    bcmos_bool data_invert;         /**< Invert or no invert for received PRBS data */
    bcmolt_control_state control;   /**< Enable\Disable the US PRBS checker */
} bcmolt_prbs_checker_config;

/** PRBS Generator config. 
 */
typedef struct bcmolt_prbs_generator_config
{
    bcmolt_prbs_polynomial polynom; /**< PRBS polynom type */
    bcmos_bool error_insert;        /**< 0 to 1 transition on this signal will insert single bit error in the MSB bit of the data bus. */
    bcmos_bool invert;              /**< Invert or no invert for transmitted PRBS data */
    bcmolt_control_state control;   /**< Enable\Disable the DS PRBS generator */
} bcmolt_prbs_generator_config;

/** That state of the PRBS test, lock state, and error counters. 
 */
typedef struct bcmolt_prbs_status
{
    bcmolt_prbs_lock_state lock_state;  /**< The state of the PRBS lock */
    uint32_t error_counts;              /**< The bit errors observed during the PRBS test.  This field is clear on read. */
} bcmolt_prbs_status;

/** ranging control configuration. 
 */
typedef struct bcmolt_ranging_control_configuration
{
    uint8_t wait_state_1_window_size;   /**< wait state 1 window size. */
    uint8_t wait_state_2_window_size;   /**< wait state 2 window size. */
    bcmos_bool wait_after_resync_4;     /**< wait after resync 4. */
} bcmolt_ranging_control_configuration;

/** ranging resync conditions. 
 */
typedef struct bcmolt_ranging_resync_conditions
{
    bcmos_bool after_init;              /**< after init. */
    bcmos_bool after_no_ed;             /**< after no ed. */
    bcmos_bool after_ed;                /**< after ed. */
    bcmos_bool after_no_del;            /**< after no del. */
    bcmos_bool after_ranging_access;    /**< after ranging access. */
    uint16_t med_val;                   /**< med val. */
} bcmolt_ranging_resync_conditions;

/** ranging rssi control. 
 */
typedef struct bcmolt_ranging_rssi_control
{
    bcmos_bool after_no_ed;     /**< after no ed. */
    bcmos_bool after_ed;        /**< after ed. */
    bcmos_bool after_reset_3;   /**< after reset 3. */
} bcmolt_ranging_rssi_control;

/** request registration status. 
 */
typedef struct bcmolt_request_registration_status
{
    bcmolt_control_state request_registration_state;    /**< request registration state. */
    bcmos_bool sma_flag;    /**< is request registration is part of sma process */
} bcmolt_request_registration_status;

/** Rogue Detection Special Map. 
 */
typedef struct bcmolt_rogue_detection_special_map
{
    uint32_t plo_size;              /**< PLO size. */
    bcmolt_pon_alloc_id alloc_id;   /**< Alloc ID. */
    bcmolt_pon_onu_id onu_id;       /**< ONU ID. */
    uint8_t access_size;            /**< Access size. */
} bcmolt_rogue_detection_special_map;

/** Variable-length list of rogue_detection_special_map. 
 */
typedef struct bcmolt_rogue_detection_special_map_list_u32_max_8
{
    uint32_t len;   /**< List length. */
    bcmolt_rogue_detection_special_map *val;    /**< List contents. */
} bcmolt_rogue_detection_special_map_list_u32_max_8;

/** Type and attributes of the rogue detection algorithm. 
 */
typedef struct bcmolt_rogue_detection_algorithm
{
    bcmolt_rogue_detection_algorithm_type algorithm_type;   /**< Type of the rogue detection algorithm. */
    union
    {
        struct
        {
            bcmolt_rogue_detection_window measurement_type; /**< Silent Window or Cut off Window */
            uint32_t interval;                  /**< Periodic process timer interval in milliseconds */
            bcmos_bool second_ranging_window;   /**< Determines whether the second ranging window should be invoked or not. */
            bcmolt_alloc_type_to_scan alloc_type_to_scan;               /**< Alloc type to scan during rogue detection.  Unused, previously used, or all Alloc-IDs. */
        } early_rogue_detection;

        struct
        {
            bcmolt_rogue_detection_special_map_list_u32_max_8 accesses; /**< Accesses. */
        } special_map;

        struct
        {
            uint32_t additional_guard_time; /**< Additional guard time (in bytes) for all ONUs on this PON. */
        } extended_guard_time;
    } u;
} bcmolt_rogue_detection_algorithm;

/** Configures the attributes of the rogue ONU detection periodic process. 
 */
typedef struct bcmolt_rogue_onu_detection_process
{
    bcmolt_control_state control;   /**< Enable/Disable the rogue ONU detection process. */
    bcmolt_rogue_detection_algorithm detection_algorithm;   /**< Type and attributes of the rogue detection algorithm. */
} bcmolt_rogue_onu_detection_process;

/** serdes configuration. 
 */
typedef struct bcmolt_serdes_configuration
{
    bcmolt_serdes_ranging_mode ranging_mode;    /**< Select ranging mode for GPON/XGPON */
    bcmos_bool multi_ed_mode;                   /**< Allow for multiple ED for ED mode for GPON/XGPON */
    uint16_t burst_enable_start_offset;         /**< Start offset for stat capture on SERDES channel */
    uint16_t burst_enable_end_offset;           /**< End offset for stat capture on SERDES channel  */
    bcmos_bool ed_invertion;                    /**< ed invertion. */
} bcmolt_serdes_configuration;

/** serial number. 
 */
typedef struct bcmolt_serial_number
{
    uint8_t vendor_id[4];       /**< vendor id. */
    uint8_t vendor_specific[4]; /**< vendor specific. */
} bcmolt_serial_number;

/** Solicited Scheduler. 
 */
typedef struct bcmolt_solicited_scheduler
{
    bcmolt_bandwidth_Kbps bandwidth_Kbps;   /**< The maximum layer 1 throughput provided by this scheduler (in Kbps). */
    bcmolt_time_quanta max_burst_size_tq;   /**< The maximum burst size (in TQ). */
    uint8_t priority;                       /**< The priority at which this scheduler runs.  This field is read-only and fixed at 0 for the MIN Shaper/Scheduler  element. */
    bcmolt_time_quanta weight_tq;           /**< The weight of this scheduler (in TQ rounded up to nearest 128). Must be greater than or equal to Grant Threshold. */
} bcmolt_solicited_scheduler;

/** Statistic alarm trigger configuration. 
 */
typedef struct bcmolt_stat_alarm_trigger_config
{
    bcmolt_stat_condition_type type;    /**< Type of condition to trigger the alarm. */
    union
    {
        struct
        {
            uint64_t rising;            /**< The alarm is raised if the stats delta value per second becomes greater than this threshold level. */
            uint64_t falling;           /**< The alarm is cleared if the stats delta value per second becomes less than this threshold level. */
        } rate_threshold;

        struct
        {
            uint64_t upper;             /**< The alarm is raised if the stats delta value per second becomes greater than this upper level. */
            uint64_t lower;             /**< The alarm is raised if the stats delta value per second becomes less than this lower level. */
        } rate_range;

        struct
        {
            uint64_t limit;             /**< The alarm is raised if the stats sample value becomes greater than this level.  The alarm is cleared when the host clears the stats. */
        } value_threshold;
    } u;
} bcmolt_stat_alarm_trigger_config;

/** Statistics alarm soaking configuration 
 */
typedef struct bcmolt_stat_alarm_soak_config
{
    uint32_t active_soak_time;  /**< If the alarm condition is raised and stays in the raised state for at least this amount of time (unit=seconds), the alarm indication is sent to the host. */
    uint32_t clear_soak_time;   /**< After the alarm is raised, if it is cleared and stays in the cleared state for at least this amount of time (unit=seconds), the alarm indication is sent to the host. */
} bcmolt_stat_alarm_soak_config;

/** Statistic alarm configuration. 
 */
typedef struct bcmolt_stat_alarm_config
{
    bcmolt_stat_alarm_trigger_config trigger;   /**< Statistics alarm trigger configuration. */
    bcmolt_stat_alarm_soak_config soak;         /**< Statistics alarm soaking configuration */
} bcmolt_stat_alarm_config;

/** ASCII string with max length 100. 
 */
typedef struct bcmolt_str_100
{
    char str[100];  /**< String. */
} bcmolt_str_100;

/** ASCII string with max length 1000. 
 */
typedef struct bcmolt_str_1000
{
    char str[1000]; /**< String. */
} bcmolt_str_1000;

/** ASCII string with max length 2000. 
 */
typedef struct bcmolt_str_2000
{
    char str[2000]; /**< String. */
} bcmolt_str_2000;

/** ASCII string with max length 256. 
 */
typedef struct bcmolt_str_256
{
    char str[256];  /**< String. */
} bcmolt_str_256;

/** ASCII string with max length 64. 
 */
typedef struct bcmolt_str_64
{
    char str[64];   /**< String. */
} bcmolt_str_64;

/** SW Error. 
 */
typedef struct bcmolt_sw_error
{
    uint64_t first_error_time_us;   /**< Timestamp (in us) when his error first occurred */
    uint64_t last_error_time_us;    /**< Timestamp (in us) when his error last occurred */
    uint32_t line_number;           /**< Line Number. */
    uint32_t error_counter;         /**< The number of times this error has occurred */
    uint32_t instance;              /**< Instance. */
    char filename[64];              /**< Filename. */
    char task_name[64];             /**< Task Name. */
} bcmolt_sw_error;

/** System profile 
 */
typedef struct bcmolt_system_profile
{
    uint32_t ng_2_sys_id;       /**< 20-bit identifier of the NGPON2 system */
    uint8_t version;            /**< System profile version. */
    uint8_t channel_spacing;    /**< An integer indicating the channel spacing in units of 1GHz */
    bcmolt_us_operating_wavelength_bands us_operating_wavelength_bands; /**< Upstream operating wavelength bands */
    uint8_t us_mse; /**< Upstream Maximum Spectral Excursion (MSE) represented as an unsigned integer indicating the value in units of 1GHz */
    bcmolt_calibration_record loose_calibration_bound;  /**< Spectral excursion bound below which a TWDM ONU can be considered as loosely calibrated */
    uint16_t fsr;               /**< If a cyclic WM is used in the upstream, Free Spectral Range indicates the value in units of 0.1 GHz */
    uint8_t twdm_channel_count; /**< The number of Channel_Profile PLOAM messages with distinct Channel Profile indices that an ONU can expect to receive while listening to this downstream wavelength channel */
} bcmolt_system_profile;

/** TRX Delimiter. 
 */
typedef struct bcmolt_trx_delimiter
{
    uint8_t pattern[3];     /**< pattern. */
    uint8_t size;           /**< Size in bytes. */
    uint8_t window_size;    /**< Window size. */
} bcmolt_trx_delimiter;

/** TRX Energy detect. 
 */
typedef struct bcmolt_trx_energy_detect
{
    bcmolt_energy_detect_source ranging_ed_source;      /**< Ranging ED source. */
    bcmolt_energy_detect_source delimiter_ed_source;    /**< Delimiter ED source. */
    uint8_t minimum_threshold;  /**< Minimum threshold. */
    uint8_t maximum_threshold;  /**< Maximum threshold. */
    uint8_t ed_pattern;         /**< ED pattern. */
    uint8_t ed_pattern_size;    /**< ED pattern size. */
    uint8_t window_size;        /**< Window size. */
    bcmos_bool inversion;       /**< Inversion. */
    uint8_t no_ed_threshold;    /**< no ed threshold. */
} bcmolt_trx_energy_detect;

/** TRX Preamble. 
 */
typedef struct bcmolt_trx_preamble
{
    uint8_t type_1_size;                /**< Type 1 size. */
    uint8_t type_2_size;                /**< Type 2 size. */
    uint8_t type_3_pre_ranging_size;    /**< Type 3 pre ranging size. */
    uint8_t type_3_post_ranging_size;   /**< Type 3 post ranging size. */
    uint8_t type_3_pattern;             /**< Type 3 pattern. */
} bcmolt_trx_preamble;

/** TRX RX configuration. 
 */
typedef struct bcmolt_trx_rx_configuration
{
    uint8_t wait_window_size;           /**< Wait Window size. */
    uint8_t ranging_access_window_size; /**< Ranging access window size. */
} bcmolt_trx_rx_configuration;

/** Variable-length list of U32. 
 */
typedef struct bcmolt_u32_list_u32_max_500_hex
{
    uint32_t len;   /**< List length. */
    uint32_t *val;  /**< List contents. */
} bcmolt_u32_list_u32_max_500_hex;

/** Variable-length list of U8. 
 */
typedef struct bcmolt_u8_list_u16_hex
{
    uint16_t len;   /**< List length. */
    uint8_t *val;   /**< List contents. */
} bcmolt_u8_list_u16_hex;

/** Variable-length list of U8. 
 */
typedef struct bcmolt_u8_list_u32
{
    uint32_t len;   /**< List length. */
    uint8_t *val;   /**< List contents. */
} bcmolt_u8_list_u32;

/** Variable-length list of U8. 
 */
typedef struct bcmolt_u8_list_u32_max_2048
{
    uint32_t len;   /**< List length. */
    uint8_t *val;   /**< List contents. */
} bcmolt_u8_list_u32_max_2048;

/** UBD Info. 
 */
typedef struct bcmolt_ubd_info
{
    uint16_t actual_polling_interval;   /**< Units: 65.536us */
    bcmolt_time_quanta actual_grant_threshold_tq;               /**< Actual Grant Threshold (TQ). */
    bcmolt_actual_schedulershaper actual_min_schedulershaper;   /**< Actual Min Scheduler/Shaper. */
    bcmolt_actual_schedulershaper actual_max_schedulershaper;   /**< Actual Max Scheduler/Shaper. */
} bcmolt_ubd_info;

/** The upstream bandwidth distribution for this LLID. 
 */
typedef struct bcmolt_upstream_bandwidth_distribution
{
    bcmolt_polling_interval polling_interval_us;    /**< The amount of time between when this LLID last reported upstream data and when it will next be polled (approximate: rounded down to the nearest 65.536 us). */
    bcmolt_time_quanta grant_threshold_tq;          /**< Used to determine the maximum grant size that will be issued to this LLID (in TQ; rounded up to the nearest 128TQ; 1TQ = 16ns = 2Bytes@1G or 20Bytes@10G). */
    bcmolt_solicited_scheduler min_schedulershaper; /**< Min Scheduler/Shaper. */
    bcmolt_solicited_scheduler max_schedulershaper; /**< Max Scheduler/Shaper. */
    bcmolt_time_quanta tdm_grant_size_tq;           /**< Size of TDM grants (in TQ). */
    uint32_t tdm_grant_interval_us;                 /**< Interval between TDM grants (in us). */
} bcmolt_upstream_bandwidth_distribution;

/** VLAN tag. 
 */
typedef struct bcmolt_vlan_tag
{
    bcmolt_vlan_id vlan_id; /**< VLAN ID. */
    uint8_t pbit;           /**< Pbit. */
} bcmolt_vlan_tag;

/** XGPON Alloc With State. 
 */
typedef struct bcmolt_xgpon_alloc_with_state
{
    bcmolt_xgpon_alloc_id alloc_id; /**< Alloc ID. */
    bcmolt_alloc_state state;       /**< State. */
} bcmolt_xgpon_alloc_with_state;

/** Variable-length list of xgpon_alloc_with_state. 
 */
typedef struct bcmolt_xgpon_alloc_with_state_list_u16_max_32
{
    uint16_t len;                       /**< List length. */
    bcmolt_xgpon_alloc_with_state *val; /**< List contents. */
} bcmolt_xgpon_alloc_with_state_list_u16_max_32;

/** xgpon ed state. 
 */
typedef struct bcmolt_xgpon_ed_state
{
    bcmos_bool reset_on_ed_fail;    /**< reset on ED fail. */
    bcmos_bool reset_on_ed_success; /**< reset on ED success. */
} bcmolt_xgpon_ed_state;

/** Variable-length list of xgpon_gem_id. 
 */
typedef struct bcmolt_xgpon_gem_id_list_u8_max_16
{
    uint8_t len;                /**< List length. */
    bcmolt_xgpon_gem_id *val;   /**< List contents. */
} bcmolt_xgpon_gem_id_list_u8_max_16;

/** XGPON GEM Port With State. 
 */
typedef struct bcmolt_xgpon_gem_port_with_state
{
    bcmolt_xgpon_gem_id gem_id;         /**< GEM ID. */
    bcmolt_xgpon_gem_port_state state;  /**< State. */
} bcmolt_xgpon_gem_port_with_state;

/** Variable-length list of xgpon_gem_port_with_state. 
 */
typedef struct bcmolt_xgpon_gem_port_with_state_list_u16_max_128
{
    uint16_t len;   /**< List length. */
    bcmolt_xgpon_gem_port_with_state *val;  /**< List contents. */
} bcmolt_xgpon_gem_port_with_state_list_u16_max_128;

/** Variable-length list of xgpon_gem_port_with_state. 
 */
typedef struct bcmolt_xgpon_gem_port_with_state_list_u16_max_256
{
    uint16_t len;   /**< List length. */
    bcmolt_xgpon_gem_port_with_state *val;  /**< List contents. */
} bcmolt_xgpon_gem_port_with_state_list_u16_max_256;

/** XGPON Key Exchange. 
 */
typedef struct bcmolt_xgpon_key_exchange
{
    uint32_t interval;              /**< Key Exchange process interval in milliseconds */
    bcmolt_control_state control;   /**< Enable\disable periodic process of Key Exchange for active ONUs */
    bcmolt_control_state encrypted_ports_only;  /**< Perform key exchange only to ONUs with GEM ports that have downstream encryption enabled */
} bcmolt_xgpon_key_exchange;

/** XGPON Multicast key. 
 */
typedef struct bcmolt_xgpon_multicast_key
{
    bcmolt_aes_key key;     /**< AES encryption key for multicsat XGEM port IDs */
    bcmos_bool key_control; /**< Enable\Disable encryption on multicast XGEM ports */
} bcmolt_xgpon_multicast_key;

/** XGPON NI Debug parameters 
 */
typedef struct bcmolt_xgpon_ni_debug
{
    bcmos_bool increase_available_cbr_bw;   /**< Use increase available CBR bandwidth for better BW utilization */
    uint16_t inter_burst_gap_in_bytes;      /**< Gap between two consecutive bursts for the same ONU */
    uint16_t number_of_gem_ports_per_onu;   /**< Number of gem ports per onu */
} bcmolt_xgpon_ni_debug;

/** XGPON ONU Activation. 
 */
typedef struct bcmolt_xgpon_onu_activation
{
    bcmolt_control_state key_exchange;  /**< Perform single key exchange during activation. */
    bcmolt_control_state fail_due_to_regis_auto_fail;   /**< Deactivate ONU due to registration authentication failure */
} bcmolt_xgpon_onu_activation;

/** XGPON ONU AES KEY. 
 */
typedef struct bcmolt_xgpon_onu_aes_key
{
    bcmolt_aes_key encryption_key;  /**< encryption key. */
    uint8_t key_index;              /**< key index. */
} bcmolt_xgpon_onu_aes_key;

/** XGPON ONU alarm status. 
 */
typedef struct bcmolt_xgpon_onu_alarm_state
{
    bcmolt_status losi;             /**< Loss of signal. */
    bcmolt_status lobi;             /**< Loss of burst. */
    bcmolt_status lopci;            /**< Loss of PLOAM channel. */
    bcmolt_status lopci_mic_error;  /**< Mic error on ploam channel. */
    bcmolt_status looci;            /**< Loss of OMCI channel. */
    bcmolt_status tiwi;             /**< Transmission interference Alarm. */
    bcmolt_status dowi;             /**< Drift of Window. */
    bcmolt_status sufi;             /**< Start UP Failure. */
    bcmolt_status sfi;              /**< Signal Fail. */
    bcmolt_status sdi;              /**< Signal Degraded. */
    bcmolt_status dfi;              /**< Deactivation Failure. */
    bcmolt_status dgi;              /**< Dying gasp. */
    bcmolt_status pqsi;             /**< Ploam queue status. */
} bcmolt_xgpon_onu_alarm_state;

/** XGPON ONU alarms. 
 */
typedef struct bcmolt_xgpon_onu_alarms
{
    bcmolt_status losi;             /**< LOSi. */
    bcmolt_status lobi;             /**< LOBi. */
    bcmolt_status lopci_miss;       /**< LOPCi miss. */
    bcmolt_status lopci_mic_error;  /**< LOPCi mic error. */
} bcmolt_xgpon_onu_alarms;

/** XGPON ONU alarms thresholds. 
 */
typedef struct bcmolt_xgpon_onu_alarms_thresholds
{
    uint8_t losi;   /**< Threshold for asserting LOSi alarm. */
    uint8_t lobi;   /**< Threshold for asserting LOBi alarm. */
    uint8_t looci;  /**< Threshold for asserting LOOCi alarm. */
    uint8_t lopci;  /**< Threshold for asserting LOPCi alarm.  */
} bcmolt_xgpon_onu_alarms_thresholds;

/** XGPON ONU EQD. 
 */
typedef struct bcmolt_xgpon_onu_eqd
{
    bcmolt_xgpon_onu_id onu_id; /**< ONU ID. */
    uint32_t eqd;               /**< EQD. */
} bcmolt_xgpon_onu_eqd;

/** Variable-length list of xgpon_onu_eqd. 
 */
typedef struct bcmolt_xgpon_onu_eqd_list_u32
{
    uint32_t len;               /**< List length. */
    bcmolt_xgpon_onu_eqd *val;  /**< List contents. */
} bcmolt_xgpon_onu_eqd_list_u32;

/** XGPON ONU registration keys. 
 */
typedef struct bcmolt_xgpon_onu_registration_keys
{
    bcmolt_aes_key ploam_ik;    /**< ploam ik. */
    bcmolt_aes_key omci_ik;     /**< omci ik. */
    bcmolt_aes_key omci_k1;     /**< omci k1. */
    bcmolt_aes_key omci_k2;     /**< omci k2. */
    bcmolt_aes_key kek;         /**< kek. */
} bcmolt_xgpon_onu_registration_keys;

/** XGPON ONU With State. 
 */
typedef struct bcmolt_xgpon_onu_with_state
{
    bcmolt_xgpon_onu_id onu_id; /**< ONU ID. */
    bcmolt_onu_state state;     /**< State. */
} bcmolt_xgpon_onu_with_state;

/** Variable-length list of xgpon_onu_with_state. 
 */
typedef struct bcmolt_xgpon_onu_with_state_list_u16_max_510
{
    uint16_t len;                       /**< List length. */
    bcmolt_xgpon_onu_with_state *val;   /**< List contents. */
} bcmolt_xgpon_onu_with_state_list_u16_max_510;

/** XGPON PLOAM handling. 
 */
typedef struct bcmolt_xgpon_ploam_handling
{
    uint32_t ack_timeout;               /**< Timeout for receiving ACK ploam */
    uint8_t retrans_ranging_time;       /**< Number of Ranging Time ploam retransmissions in case of ACK timeout */
    uint8_t retrans_assign_alloc_id;    /**< Number of Assign Alloc ID ploam retransmissions in case of ACK timeout */
    uint8_t retrans_key_control;        /**< Number of Key Control ploam retransmissions in case of ACK timeout */
    uint8_t retrans_request_registration;   /**< Number of Request Registration ploam retransmissions in case of ACK timeout */
} bcmolt_xgpon_ploam_handling;

/** XGPON protection switching configuration. 
 */
typedef struct bcmolt_xgpon_protection_switching
{
    uint16_t timeout;           /**< LOS switch over timeout in milliseconds */
    bcmolt_gpio_pin gpio_pin;   /**< GPIO pin for input/output signal */
    bcmos_bool fast_ranging;    /**< fast ranging  */
} bcmolt_xgpon_protection_switching;

/** xgpon protection switching debug. 
 */
typedef struct bcmolt_xgpon_protection_switching_debug
{
    uint16_t data_map_delay_ms;             /**< delay to wait after sending ranging time delta before running the data map   */
    bcmos_bool rerange_send_ranging_time;   /**< Should the SM send the current ranging time before doing the re-ranging  */
    uint16_t rerange_send_ranging_time_delay;   /**< the delay between sending the ranging time and starting the rerange  */
} bcmolt_xgpon_protection_switching_debug;

/** XGPON RSSI normal configuration. 
 */
typedef struct bcmolt_xgpon_rssi_normal_config
{
    bcmolt_polarity polarity;   /**< RSSI signal polarity */
    uint8_t location;           /**< RSSI signal location in words */
    bcmolt_sign location_sign;  /**< RSSI signal location sign */
    uint16_t pulse_width;       /**< RSSI pulse width in words */
    uint16_t minimum_burst;     /**< Data minimum burst size in words */
} bcmolt_xgpon_rssi_normal_config;

/** xgpon rssi ranging config. 
 */
typedef struct bcmolt_xgpon_rssi_ranging_config
{
    bcmos_bool start_on_ed;         /**< start on ED. */
    uint8_t frame_delay;            /**< frame delay from ED */
    uint16_t word_delay;            /**< word delay from ED */
    uint8_t frame_delay_after_ed;   /**< frame delay from start  of ranging window */
    uint16_t word_delay_after_ed;   /**< word delay from start  of ranging window */
} bcmolt_xgpon_rssi_ranging_config;

/** xgpon rx ranging SM patterns. 
 */
typedef struct bcmolt_xgpon_rx_ranging_sm_pattern
{
    uint32_t trx_reset_pattern_first;   /**< trx reset pattern first. */
    uint32_t trx_reset_pattern_middle;  /**< trx reset pattern middle. */
    uint32_t trx_reset_pattern_last;    /**< trx reset pattern last. */
    uint8_t trx_reset_middle_repeats;   /**< trx reset middle repeats. */
    uint8_t trx_reset_location;         /**< trx reset location. */
    uint32_t bcdr_reset_pattern_first;  /**< bcdr reset pattern first. */
    uint32_t bcdr_reset_pattern_middle; /**< bcdr reset pattern middle. */
    uint32_t bcdr_reset_pattern_last;   /**< bcdr reset pattern last. */
    uint8_t bcdr_reset_middle_repeats;  /**< bcdr reset middle repeats. */
    uint8_t bcdr_reset_location;        /**< bcdr reset location. */
    bcmos_bool bcdr_reset_polarity;     /**< bcdr reset polarity. */
} bcmolt_xgpon_rx_ranging_sm_pattern;

/** xgpon serdes configuration. 
 */
typedef struct bcmolt_xgpon_serdes_configuration
{
    bcmos_bool multi_ed_mode;   /**< multi ed mode. */
    bcmolt_xgpon_serdes_ranging_mode ranging_mode;  /**< ranging mode. */
} bcmolt_xgpon_serdes_configuration;

/** XGPON SN Acquisition. 
 */
typedef struct bcmolt_xgpon_sn_acquisition
{
    uint32_t interval;              /**< SN process interval in milliseconds */
    bcmolt_control_state control;   /**< SN process control */
    bcmolt_onu_post_discovery_mode onu_post_discovery_mode; /**< Automatic operation following ONU discovery */
    bcmolt_burst_profile_index burst_profile;               /**< Burst profile index to use during SN acquisition window */
} bcmolt_xgpon_sn_acquisition;

/** xgpon_trx_debug. 
 */
typedef struct bcmolt_xgpon_trx_debug
{
    bcmolt_control_state rx_reversed_polarity;  /**< transceiver reversed polarity */
    bcmolt_control_state neg_out_bit;           /**< turn all 1 to 0 and all 0 to 1 at the output. default is not to make negative bits */
} bcmolt_xgpon_trx_debug;

/** @} */
#endif /* BCMOLT_MODEL_DATA_H_ */
