/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#ifndef BCM_FLD_COMMON_H
#define BCM_FLD_COMMON_H

#define BCM_FLD_SRAM_SIZE                           0x00010000 /* 64 KB */

/******************************/
/* FLD communication area */
/******************************/
#define COMM_WORD_SIZE                              4                   /* 32 bit, 4 byte */
#define BCM_FLD_COMMUNICATION_AREA_TOP              BCM_FLD_SRAM_SIZE

/* Please do not change PCIE_OPAQUE_DATA_SIZE define, MUST be same as used by pcie dma driver */
#define PCIE_OPAQUE_DATA_SIZE                       (2*4)               /* two pointers (BD and SBD) */

#define BOOTRECORD_RESERVED                         (2*COMM_WORD_SIZE)  /* 4 words reserved for future needs */
#define BCM_FLD_CPU_POSTMORTEM_BUF_SIZE             0x00001000

#define BCM_FLD_CPU_STATE_OFFSET                    (BCM_FLD_COMMUNICATION_AREA_TOP       - COMM_WORD_SIZE)     /* 0xfffc */
#define BCM_FLD_HOST_STATE_OFFSET                   (BCM_FLD_CPU_STATE_OFFSET             - COMM_WORD_SIZE)
#define BCM_FLD_CPU_DEBUG_STATE_OFFSET              (BCM_FLD_HOST_STATE_OFFSET            - COMM_WORD_SIZE)
#define BCM_FLD_HOST_DEBUG_STATE_OFFSET             (BCM_FLD_CPU_DEBUG_STATE_OFFSET       - COMM_WORD_SIZE)
#define BCM_FLD_CPU_BOOTREC_STATE_OFFSET            (BCM_FLD_HOST_DEBUG_STATE_OFFSET      - COMM_WORD_SIZE)
#define BCM_FLD_HOST_BOOTREC_STATE_OFFSET           (BCM_FLD_CPU_BOOTREC_STATE_OFFSET     - COMM_WORD_SIZE)

#define BCM_FLD_CPU_RESET_REASON_OFFSET             (BCM_FLD_HOST_BOOTREC_STATE_OFFSET    - COMM_WORD_SIZE)
#define BCM_FLD_CPU_EXCEP_REASON_OFFSET             (BCM_FLD_CPU_RESET_REASON_OFFSET      - COMM_WORD_SIZE)
#define BCM_FLD_CPU_DDR_MEMC_STATE_OFFSET           (BCM_FLD_CPU_EXCEP_REASON_OFFSET      - COMM_WORD_SIZE)
#define BCM_FLD_RAS_0_DDR_MEMC_STATE_OFFSET         (BCM_FLD_CPU_DDR_MEMC_STATE_OFFSET    - COMM_WORD_SIZE)
#define BCM_FLD_RAS_1_DDR_MEMC_STATE_OFFSET         (BCM_FLD_RAS_0_DDR_MEMC_STATE_OFFSET  - COMM_WORD_SIZE)

#define BCM_FLD_CPU_DDR_PHY_STATE_OFFSET            (BCM_FLD_RAS_1_DDR_MEMC_STATE_OFFSET  - COMM_WORD_SIZE)
#define BCM_FLD_RAS_0_DDR_PHY_STATE_OFFSET          (BCM_FLD_CPU_DDR_PHY_STATE_OFFSET     - 6*COMM_WORD_SIZE)
#define BCM_FLD_RAS_1_DDR_PHY_STATE_OFFSET          (BCM_FLD_RAS_0_DDR_PHY_STATE_OFFSET   - 6*COMM_WORD_SIZE)
#define BCM_FLD_BOOT_PROTOCOL_VERSION_OFFSET        (BCM_FLD_RAS_1_DDR_PHY_STATE_OFFSET   - 6*COMM_WORD_SIZE)
#define BCM_FLD_OS_ENTRY_OFFSET                     (BCM_FLD_BOOT_PROTOCOL_VERSION_OFFSET - COMM_WORD_SIZE)
#define BCM_FLD_CPU_SET_QUEUES_SIZE                 (BCM_FLD_OS_ENTRY_OFFSET - COMM_WORD_SIZE)

/******************************/
/* Boot-record  area */
/******************************/
/* host write for SoC its rx queue size */
#define BCM_FLD_HOST_RX_QUEUE_SIZE_OFFSET           (BCM_FLD_CPU_SET_QUEUES_SIZE - COMM_WORD_SIZE)
#define BCM_FLD_CPU_RX_QUEUE_SIZE_OFFSET            (BCM_FLD_HOST_RX_QUEUE_SIZE_OFFSET - COMM_WORD_SIZE)

#define BCM_FLD_CPU_BOOTRECORD_OFFSET               (BCM_FLD_CPU_RX_QUEUE_SIZE_OFFSET - BOOTRECORD_RESERVED)

#define BCM_FLD_HOST_BOOTRECORD_OFFSET              (BCM_FLD_CPU_BOOTRECORD_OFFSET - PCIE_OPAQUE_DATA_SIZE - BOOTRECORD_RESERVED )

#define BCM_FLD_CPU1_POSTMORTEM_STATE               (BCM_FLD_HOST_BOOTRECORD_OFFSET - COMM_WORD_SIZE)
#define BCM_FLD_CPU0_POSTMORTEM_STATE               (BCM_FLD_CPU1_POSTMORTEM_STATE - COMM_WORD_SIZE)

#define BCM_FLD_RAS_0_SETTINGS                      (BCM_FLD_CPU0_POSTMORTEM_STATE - COMM_WORD_SIZE)
#define BCM_FLD_RAS_1_SETTINGS                      (BCM_FLD_RAS_0_SETTINGS - COMM_WORD_SIZE)

#define BCM_RAS_DISABLE                              0x0
#define BCM_RAS_MODE_GPON                            0x1
#define BCM_RAS_MODE_XGPON                           0x2

#define BCM_FLD_AVS_SETTINGS                         (BCM_FLD_RAS_1_SETTINGS - COMM_WORD_SIZE)
#define BCM_FLD_AVS_STOP                             0x0
#define BCM_FLD_AVS_CONT                             0x1

#ifdef TX_ENABLE_EVENT_TRACE
#define BCM_FLD_EVENT_TRACE_OFFSET                   (BCM_FLD_AVS_SETTINGS - COMM_WORD_SIZE)

/*********************************************************************************
 PAY ATTENTION !!! BCM_FLD_COMMUNICATION_AREA_BASE must be equal first byte in the FLD
            communication area therefore  it should be equal to the last define above
*********************************************************************************/

#define BCM_FLD_COMMUNICATION_AREA_BASE             BCM_FLD_EVENT_TRACE_OFFSET
#else
#define BCM_FLD_COMMUNICATION_AREA_BASE             BCM_FLD_RAS_1_SETTINGS
#endif
#define BCM_FLD_COMMUNICATION_AREA_SIZE             BCM_FLD_COMMUNICATION_AREA_TOP - BCM_FLD_COMMUNICATION_AREA_BASE

/*********************************************************************************
 PAY ATTENTION !!! POSTMORTEM_BUF_OFFSET must be outside the communication area
             therefore  it should be defined from BCM_FLD_COMMUNICATION_AREA_BASE
*********************************************************************************/

#define BCM_FLD_CPU1_POSTMORTEM_BUF_OFFSET          (BCM_FLD_COMMUNICATION_AREA_BASE - BCM_FLD_CPU_POSTMORTEM_BUF_SIZE)
#define BCM_FLD_CPU0_POSTMORTEM_BUF_OFFSET          (BCM_FLD_CPU1_POSTMORTEM_BUF_OFFSET - BCM_FLD_CPU_POSTMORTEM_BUF_SIZE)
#define BCM_FLD_HOST_EVENT                          (BCM_FLD_CPU0_POSTMORTEM_BUF_OFFSET - COMM_WORD_SIZE)

#define BCM_FLD_DDR_TEST_RESULTS_SIZE               (3 * COMM_WORD_SIZE) /* CPU + RAS 0 + RAS 1 */
#define BCM_FLD_DDR_TEST_RESULTS                    (BCM_FLD_HOST_EVENT - BCM_FLD_DDR_TEST_RESULTS_SIZE)

/* SW Error table */
#define BCM_FLD_SW_ERROR_TABLE_SIZE                 (1171 * COMM_WORD_SIZE)
#define BCM_FLD_SW_ERROR_TABLE                      (BCM_FLD_DDR_TEST_RESULTS - BCM_FLD_SW_ERROR_TABLE_SIZE)

/* logger will NOT overwrite other fields */
#define BCM_FLD_LOGGER_TOP                          BCM_FLD_SW_ERROR_TABLE
#define BCM_FLD_LOGGER_BASE                         0 /* logger will overwrite the bootloader */

/* BCM68620 (Maple) functional states */
#define BCM_FLD_CPU_FINISH_BOOTLOADER_SHIFT         0
#define BCM_FLD_CPU_FINISH_BOOTLOADER_MASK          (0x1 << BCM_FLD_CPU_FINISH_BOOTLOADER_SHIFT)

#define BCM_FLD_CPU_READY_SHIFT                     1
#define BCM_FLD_CPU_READY_MASK                      (0x1 << BCM_FLD_CPU_READY_SHIFT)

#define BCM_FLD_DDR_TEST_DONE_SHIFT                 2
#define BCM_FLD_DDR_TEST_DONE_MASK                  (0x1 << BCM_FLD_DDR_TEST_DONE_SHIFT)

/* BCM68620 (Host) functional states */
#define BCM_FLD_HOST_FINISH_WRITE_DDR_SHIFT         0
#define BCM_FLD_HOST_FINISH_WRITE_DDR_MASK          (0x1 << BCM_FLD_HOST_FINISH_WRITE_DDR_SHIFT)

#define BCM_FLD_HOST_RUN_CPU_DDR_TEST_SHIFT         1
#define BCM_FLD_HOST_RUN_CPU_DDR_TEST_MASK          (0x1 << BCM_FLD_HOST_RUN_CPU_DDR_TEST_SHIFT)

#define BCM_FLD_HOST_RUN_RAS_0_TEST_SHIFT           2
#define BCM_FLD_HOST_RUN_RAS_0_TEST_MASK            (0x1 << BCM_FLD_HOST_RUN_RAS_0_TEST_SHIFT)

#define BCM_FLD_HOST_RUN_RAS_1_TEST_SHIFT           3
#define BCM_FLD_HOST_RUN_RAS_1_TEST_MASK            (0x1 << BCM_FLD_HOST_RUN_RAS_1_TEST_SHIFT)

/* host bootrecord states */
#define BCM_FLD_HOST_PRM_VALID_SHIFT                0
#define BCM_FLD_HOST_PRM_VALID_MASK                 (0x1 << BCM_FLD_HOST_PRM_VALID_SHIFT)

/* device bootrecord states */
#define BCM_FLD_CPU_PRM_VALID_SHIFT                 0
#define BCM_FLD_CPU_PRM_VALID_MASK                  (0x1 << BCM_FLD_CPU_PRM_VALID_SHIFT)

/* queue validity flag */
#define BCM_FLD_CPU_QUEUE_VALID_SHIFT               0
#define BCM_FLD_CPU_QUEUE_VALID_MASK                (0x1 << BCM_FLD_CPU_QUEUE_VALID_SHIFT)

/* CPU debug states */
#define CPU_DEBUG_BOOT_FLASH        (1<<0)
#define CPU_DEBUG_RUN__FROM_SRAM    (1<<1)
#define CPU_DEBUG_LUT_DONE          (1<<2)
#define CPU_DEBUG_B15_CFG_DONE      (1<<3)
#define CPU_DEBUG_UART_INIT_DONE    (1<<4)
#define CPU_DEBUG_CLEAR_BSS_DONE    (1<<5)
#define CPU_DEBUG_RUN_C             (1<<6)
#define CPU_DEBUG_FLASH_READ_FAILED (1<<7)
#define CPU_DEBUG_OS_FAILED         (1<<8)

/* CPU exception reason */
#define CPU_EXCEP_UNDEF_INSTR       (1<<0)
#define CPU_EXCEP_SW_INTR           (1<<1)
#define CPU_EXCEP_PREFETCH_ABORT    (1<<2)
#define CPU_EXCEP_DATA_ABORT        (1<<3)
#define CPU_EXCEP_IRQ               (1<<4)
#define CPU_EXCEP_FIQ               (1<<5)

#ifndef __ASSEMBLER__
/* SoC states values */
typedef enum
{
    BCM_FLD_CPU_STATE_UNKNOWN,
    BCM_FLD_SRAM_BOOT_DONE,
    BCM_FLD_BOOT_FROM_DDR,
    BCM_FLD_RUN_FROM_DDR,
    BCM_FLD_CPU_READY,
    BCM_FLD_HOST_READY,
    BCM_FLD_CPU_FINISH_BOOTLOADER
} BCM_FLD_CPU_STATE;

/* SoC reset values */
typedef enum
{
    BCM_FLD_CPU_RESET_UNKNOWN
} BCM_FLD_CPU_RESET_REASON;

typedef enum
{
    BCM_FLD_RAS_MODE_NOT_CONFIGURED,
    BCM_FLD_RAS_MODE_GPON,
    BCM_FLD_RAS_MODE_XGPON,
    BCM_FLD_RAS_MODE_XGS_NGPON2,
} BCM_FLD_RSM_MODE;

typedef struct
{
    unsigned int magic;
    unsigned int msg_len;
    char msg[1];
} BCM_FLD_POSTMORTEM_LOG;
#endif

#define BCM_FLD_POSTMORTEM_LOG_MAGIC      0xFEEDBACC

/* device_debug_states */
#define BCM_FLD_CPU_BOOT_FROM_SRAM_STATES_SHIFT     0
#define BCM_FLD_CPU_BOOT_FROM_SRAM_STATES_MASK      0x000000ffU
#define BCM_FLD_CPU_BOOT_FROM_SRAM_ERRORS_SHIFT     8
#define BCM_FLD_CPU_BOOT_FROM_SRAM_ERRORS_MASK      0x0000ff00U
#define BCM_FLD_CPU_BOOT_FROM_SRAM_EXCEPTION_SHIFT  16
#define BCM_FLD_CPU_BOOT_FROM_SRAM_EXCEPTION_MASK   0x00ff0000U
#define BCM_FLD_CPU_RUN_FROM_DDR_STATES_SHIFT       24
#define BCM_FLD_CPU_RUN_FROM_DDR_STATES_MASK        0xff000000U
/* host_debug_states */
#define BCM_FLD_HOST_WRITE_SRAM_SHIFT               0
#define BCM_FLD_HOST_WRITE_SRAM_MASK                0x00000001U
#define BCM_FLD_HOST_START_CPU_SHIFT                1
#define BCM_FLD_HOST_START_CPU_MASK                 0x00000002U
#define BCM_FLD_HOST_WRITE_DDR_SHIFT                2
#define BCM_FLD_HOST_WRITE_DDR_MASK                 0x00000004U

#define CPU_2_PCIE_MEM_WIN0_BASE    0x90000000
#define CPU_2_PCIE_MEM_WIN0_SIZE    0x00100000
#define MAX_PMC_SIZE                0x8000

#ifdef TX_ENABLE_EVENT_TRACE
#define EVENT_BUFFER_SIZE           0x00600000 /* 6 Mbyte */
/* leave 1 Mbyte gap between windows */
#define CPU_2_PCIE_MEM_WIN1_BASE    CPU_2_PCIE_MEM_WIN0_BASE + CPU_2_PCIE_MEM_WIN0_SIZE + 0x100000
#define CPU_2_PCIE_MEM_WIN1_SIZE    EVENT_BUFFER_SIZE
#endif

#endif
