/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#ifndef BCMOLT_DEBUG_API_COMMON_H_
#define BCMOLT_DEBUG_API_COMMON_H_

#include "bcmolt_model_types.h"
#include "bcm_dev_log.h"

typedef struct
{
    bcmolt_debug_cfg_data cfg;
    uint8_t *capture_buffer;
    dev_log_id log_id;
} bcmolt_debug_api_db;

typedef struct
{
    bcmolt_debug_api_db old_db;
    bcmolt_debug_api_db *new_db;
} debug_trans_handle;

bcmos_errno bcmolt_debug_api_common_get(bcmolt_devid device, bcmolt_msg *msg, bcmolt_debug_api_db *db);

debug_trans_handle *bcmolt_debug_api_common_cfg_trans_start(bcmolt_debug_api_db *db);

void bcmolt_debug_api_common_cfg_trans_fail(bcmolt_debug_api_db *db, debug_trans_handle *handle);

void bcmolt_debug_api_common_cfg_trans_succeed(bcmolt_devid device, debug_trans_handle *handle);

bcmos_errno bcmolt_debug_api_common_set(
    bcmolt_devid device,
    bcmolt_msg *msg,
    const bcmolt_debug_cfg_data *data,
    debug_trans_handle *handle,
    bcmolt_api_capture_location local);

bcmos_errno bcmolt_debug_api_common_oper_start_api_capture(bcmolt_devid device, bcmolt_msg *msg);

bcmos_errno bcmolt_debug_api_common_oper_stop_api_capture(bcmolt_devid device, bcmolt_msg *msg, bcmolt_debug_api_db *db);

bcmos_errno bcmolt_debug_api_common_oper_reset_api_capture(bcmolt_devid device, bcmolt_msg *msg, bcmolt_debug_api_db *db);

void bcmolt_debug_api_common_init(bcmolt_devid device, bcmolt_debug_api_db *db);

#endif /* BCMOLT_DEBUG_API_COMMON_H_ */

