/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#ifndef BCMOLT_CONFIG_H_
#define BCMOLT_CONFIG_H_

/** \defgroup config Configuration Constants
 * Configuration constants that must be revised by customer
 * @{
 */

/** CPU Endianness. Must be set to BCMOS_ENDIAN_BIG or BCMOS_ENDIAN_LITTLE. */
#ifndef BCM_CPU_ENDIAN

#error BCM_CPU_ENDIAN must be set BCMOS_ENDIAN_BIG or BCMOS_ENDIAN_LITTLE

#endif /* #ifndef BCM_CPU_ENDIAN */

/** Transport layer configuration defaults */
#define BCMTR_TR_TYPE              BCMTR_TYPE_UDP       /**< Transport type: raw/udp */
#define BCMTR_TR_UDP_HOST_IP       0x7f000001
#define BCMTR_TR_UDP_OLT_IP        0x7f000001
#define BCMTR_TR_UDP_HOST_PORT     0x4000
#define BCMTR_TR_UDP_OLT_PORT      0x4010

#define BCMTR_MAX_OLTS             2      /**< Max number of OLTs */
#define BCMTR_MAX_INSTANCES        16     /**< Max number of message handler instances - typically a number of PON's */
#define BCMTR_MAX_RETRIES          0      /**< Max number of request retransmissions */
#define BCMTR_MSG_TIMEOUT          500    /**< Max time to wait for response or next message part (ms) */
#define BCMTR_MAX_REQUESTS         64     /**< Max number of outstanding requests per application per OLT */
#define BCMTR_MAX_AUTOS            256    /**< Maximum number of simultaneous multi-part autonomous messages */
#define BCMTR_MAX_FRAGMENTS        500    /**< Maximum number of fragments per message */
#define BCMTR_MSG_WAIT_MS          5      /**< length of time to wait on conn read */
#define BCMTR_MSG_READY_MS         50     /**< Time to wait for application to peak up response */
#define BCMTR_MAX_MTU_SIZE         4096   /**< max MTU size */
#define BCMTR_RX_THREAD_STACK      0      /**< Rx thread stack size */

/** Debug output configuration */
#define BCM_DBG_MAX_MSG_SIZE       128    /**< Max number of message bytes to include in message dump */

#define BCMTR_BUF_EXTRA_HEADROOM   0      /**< Extra headroom to reserve is system buffer */

#define BCMTR_PCIE_START_TIMEOUT   15000  /**< Application start timeout (ms) */
#define BCMTR_PCIE_CONNECT_TIMEOUT 15000  /**< Connect timeout (ms) */
/** @} */

#define BCMTR_MAX_RXQ_SIZE         256

#endif /* BCMOLT_CONFIG_H_ */
