/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#ifndef BCMOLT_TR_PCIE_SPECIFIC_H_
#define BCMOLT_TR_PCIE_SPECIFIC_H_

#include "bcmos_system.h"
#include "bcmtr_pcie.h"

#define DESCRIPTOR_CONTROL      0x00064410 /* Tx Software Descriptor List Control and Status */
#define WAKEUP_DMA              0x00064414 /* Tx Wake Control */
#define ERROR_STATUS            0x00064418 /* Tx Engine Error Status */

#define INTR2_PCI_STATUS        0x00064318 /* PCI interrupt Status Register */

#define DMA_TX_SW_DESC_LIST_CTRL_STS_TX_DMA_RUN_STOP_MASK   0x00000001
#define DMA_TX_WAKE_CTRL_WAKE_MASK                          0x00000001

#define DMA_INTR_STATUS	        0x00064318 /* PCI interrupt Status Register */
#define DMA_INTR_CLEAR          0x00064320 /* PCI interrupt Clear Register */
#define DMA_INTR_MASK_SET       0x00064328 /* PCI interrupt Mask Set Register */
#define DMA_INTR_MASK_CLEAR     0x0006432c /* PCI interrupt Mask Clear Register */
#define DMA_INTR_MASK_STATUS    0x00064324 /* PCI interrupt Mask & Status Register */

#define DMA_RX_ERROR_MASK       0x00000008
#define DMA_RX_DONE_MASK        0x00000004
#define DMA_TX_DONE_MASK        0x00000001
#define DMA_TX_ERROR_MASK       0x00000002

#define PCIE_L2_INTR_MASK       0x00000020 /* L2 interrupt bit in L1 interrupt status */

#define DMA_INTR1_STATUS        0x00069300 /* Interrupt Status Register */
#define DMA_INTR1_MASK_CLEAR    0x0006930c /* Interrupt Mask Clear Register */
#define DMA_INTR1_MASK_SET      0x00069308 /* Interrupt Mask Set Register */
#define DMA_INTA_MASK           0x00000002
#define DMA_INTA_SHIFT          1
#define PCIE_STATUS_OFFSET      0x00064068 /* PCIE_PCIE_PCIE_0_PCIE_PCIE_0_MISC_PCIE_STATUS */

void bcmtr_connect_isr(void *isr_info);

/* first parameter is the dest PD, the second parameter is the source field */
static inline void bcmtr_set_dest_buffer_address(uint32_t *pd, void *value)
{
    uint64_t tmp = bcmos_virt_to_phys(value);

    bcm_pci_write32(&pd[PCI_PACKET_LOW_INDEX],  (uint32_t)( tmp & 0xffffffffUL));
    bcm_pci_write32(&pd[PCI_PACKET_HIGH_INDEX], (uint32_t)((tmp >> 32) & 0xffffffffUL));
}

/* first parameter is the dest PD, the second parameter is the source field */
static inline void bcmtr_set_source_buffer_address(uint32_t *pd, void *value)
{
    uint64_t tmp = bcmos_virt_to_phys(value);

    bcm_pci_write32(&pd[PCI_PACKET_LOW_INDEX],  (uint32_t)( tmp & 0xffffffffUL));
    bcm_pci_write32(&pd[PCI_PACKET_HIGH_INDEX], (uint32_t)((tmp >> 32) & 0xffffffffUL));
}

static inline bcmos_errno bcmtr_create_tu_rings(uint32_t txlength, uint32_t rxlength,
                                          void **txptr, void **rxptr,
                                          void **txptr_orig, void **rxptr_orig,
                                          unsigned long pcie_reg_base)
{
    *txptr      = NULL;
    *rxptr_orig = NULL;
    *txptr      = NULL;
    *rxptr_orig = NULL;

    return BCM_ERR_OK;
}
static inline void bcmtr_pcie_specific_init(unsigned long pcie_reg_base) {}
static inline void bcmtr_pcie_free_rings(uint32_t device, uint32_t *tx_ptr, uint32_t * rx_ptr){}
static inline void bcmtr_pcie_free_irq(uint32_t irq, void *priv)
{
#ifndef SIMULATION_BUILD
    bcmos_int_disconnect((int)irq, priv);
#endif
}

#define TX_LOCKDEF         bcmos_mutex  tx_lock;
#define CREATE_TXLOCK(i)   bcmos_mutex_create(&bcmtr_pcie_data[i].tx_lock, 0, NULL)
#define DESTROY_TXLOCK(i)  bcmos_mutex_destroy(&bcmtr_pcie_data[i].tx_lock)
#define LOCK_TX()          bcmos_mutex_lock(&current_device->tx_lock)
#define UNLOCK_TX()        bcmos_mutex_unlock(&current_device->tx_lock)

#endif

