#ifndef _BCMOLT_I2C_DEVS_IOCTL_H_
#define _BCMOLT_I2C_DEVS_IOCTL_H_

#include <linux/ioctl.h>

typedef struct
{
    uint32_t count;
    uint32_t addr;
    uint32_t val;
} maple_i2c_ioctl_param;

#define MAPLE_I2C_IOCTL_MAGIC 'I'

#define MAPLE_I2C_IOCTL_OP_DEV_CHANGE _IOW(MAPLE_I2C_IOCTL_MAGIC, 1, maple_i2c_ioctl_param)
#define MAPLE_I2C_IOCTL_OP_DEV_WRITE _IOW(MAPLE_I2C_IOCTL_MAGIC, 2, maple_i2c_ioctl_param)
#define MAPLE_I2C_IOCTL_OP_DEV_READ _IOWR(MAPLE_I2C_IOCTL_MAGIC, 3, maple_i2c_ioctl_param)
#define MAPLE_I2C_IOCTL_OP_SWITCH_WRITE _IOW(MAPLE_I2C_IOCTL_MAGIC, 4, maple_i2c_ioctl_param)
#define MAPLE_I2C_IOCTL_OP_SWITCH_READ _IOR(MAPLE_I2C_IOCTL_MAGIC, 5, maple_i2c_ioctl_param)
#define MAPLE_I2C_IOCTL_OP_FPGA_WRITE _IOW(MAPLE_I2C_IOCTL_MAGIC, 6, maple_i2c_ioctl_param)
#define MAPLE_I2C_IOCTL_OP_FPGA_READ _IOWR(MAPLE_I2C_IOCTL_MAGIC, 7, maple_i2c_ioctl_param)

#endif

