/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#ifndef _BCMOLT_I2C_DEVS_H_
#define _BCMOLT_I2C_DEVS_H_

/* When inserting the module (with insmod) onlt the I2C switch devices (I2C_SWX_I2C_ADDR) 
   will be automatically detected, and therefore will be probed.
   Probing all other devices can be done after inerting the module via sysfs.
   for example, in order to probe FPGA device, the following line should be applied:
   -- echo maple_i2c FPGA_I2C_ADDR > /sys/bus/i2c/devices/i2c-0/new_device --
*/ 
enum client_num
{
    SLAVE_SWITCH_70    = 0,
    SLAVE_SWITCH_71    = 1,
    SLAVE_SWITCH_72    = 2,
    SLAVE_SWITCH_73    = 3,
    SLAVE_SWITCH_74    = 4,
    SLAVE_SFP_50       = 5,
    SLAVE_SFP_51       = 6,
    SLAVE_FPGA_40      = 7,
    SLAVE_PON_DPLL_68  = 8,
    SLAVE_PM_DPLL_6A   = 9,
    SLAVE_CXP_R_54     = 10,
    SLAVE_PCIE_SW_3C   = 11,
    SLAVE_NUM_OF_SLAVES
};


/*****************************************************************
   maple_i2c_write

   DESCRIPTION:
       Writes serially data to I2C device

   PARAMETERS:
       client num - The client to write to.
       buf        - The buffer to write.
       count      - Number of bytes to write

   OUTPUT:
       The number of bytes that were written, when fails return negative number
********************************************************************/
ssize_t maple_i2c_write(unsigned char client_num, char *buf, size_t count);

/*****************************************************************
   maple_i2c_read

   DESCRIPTION:
       Read serially data from I2C device

   PARAMETERS:
       client num - The client to write to.
       buf        - The buffer to read to.
       count      - Number of bytes to read

   OUTPUT:
       The number of bytes that were read, when fails return negative number
********************************************************************/
ssize_t maple_i2c_read(unsigned char client_num, char *buf, size_t count);

/*****************************************************************
   maple_i2c_write_byte

   DESCRIPTION:
       Write byte to I2C device

   PARAMETERS:
       client num - The client to write to.
       offset     - The offset to write to.
       val        - Tha data to write.

   OUTPUT:
       0 on success, -1 on failure.
********************************************************************/
int maple_i2c_write_byte(unsigned char client_num, unsigned char offset, unsigned char val);

/*****************************************************************
   maple_i2c_read_byte

   DESCRIPTION:
       Read byte from I2C device

   PARAMETERS:
       client num - The client to read from.
       offset     - The offset to read from.
       data       - the read value is written to this pointer.
   OUTPUT:
       0 on success, -1 on failure.
********************************************************************/
int maple_i2c_read_byte(unsigned char client_num, unsigned char offset, unsigned char* data);

/*****************************************************************
   maple_i2c_write_word

   DESCRIPTION:
       Write 16 bit word to I2C device

   PARAMETERS:
       client num - The client to write to.
       offset     - The offset to write to.
       val        - Tha data to write.

   OUTPUT:
       0 on success, -1 on failure.
********************************************************************/
int maple_i2c_write_word(unsigned char client_num, unsigned char offset, unsigned short val);

/*****************************************************************
   maple_i2c_read_word

   DESCRIPTION:
       Read 16 bit word from I2C device

   PARAMETERS:
       client num - The client to read from.
       offset     - The offset to read from.
       data       - the read value is written to this pointer.
   OUTPUT:
       0 on success, -1 on failure.
********************************************************************/
int maple_i2c_read_word(unsigned char client_num, unsigned char offset, unsigned short* data);

/*****************************************************************
   maple_i2c_write_reg

   DESCRIPTION:
       Write 32 bit register to I2C device

   PARAMETERS:
       client num - The client to write to.
       offset     - The offset to write to.
       val        - Tha data to write.

   OUTPUT:
       0 on success, -1 on failure.
********************************************************************/
int maple_i2c_write_reg(unsigned char client_num, unsigned char offset, int val);

/*****************************************************************
   maple_i2c_read_reg

   DESCRIPTION:
       Read 32 bit word from I2C device

   PARAMETERS:
       client num - The client to read from.
       offset     - The offset to read from.
       data       - the read value is written to this pointer.
   OUTPUT:
       0 on success, -1 on failure.
********************************************************************/
int maple_i2c_read_reg(unsigned char client_num, unsigned char offset, unsigned int* data);

/*****************************************************************
   maple_i2c_write_fpga

   DESCRIPTION:
       Write 32 bit register to I2C fpga device

   PARAMETERS:
       client num - The client to write to.
       offset     - The offset to write to.
       val        - Tha data to write.

   OUTPUT:
       0 on success, -1 on failure.
********************************************************************/
int maple_i2c_write_fpga(unsigned char client_num, unsigned int offset, unsigned int val);

/*****************************************************************
   maple_i2c_read_fpga

   DESCRIPTION:
       Read 32 bit word from I2C fpga device

   PARAMETERS:
       client num - The client to read from.
       offset     - The offset to read from.
       data       - the read value is written to this pointer.
   OUTPUT:
       0 on success, -1 on failure.
********************************************************************/
int maple_i2c_read_fpga(unsigned char client_num, unsigned int offset, unsigned int* data);

/*****************************************************************
   maple_i2c_get_client

   DESCRIPTION:
       Gets an I2C client number from an address

   PARAMETERS:
       addr       - The address of the client.
   OUTPUT:
       The client number for this client, or SLAVE_NUM_OF_SLAVES on failure.
********************************************************************/
enum client_num maple_i2c_get_client(unsigned int addr);

#endif   /* _MAPLE_I2C_DEVS_H_ */
