#!/bin/sh
###############################################################################
#
#  <:copyright-BRCM:2016:proprietary:standard
#   
#     Broadcom Ltd. Proprietary and Confidential.(c) 2016 Broadcom Ltd.
#     All Rights Reserved
#   
#  This program is the proprietary software of Broadcom Ltd. and/or its
#  licensors, and may only be used, duplicated, modified or distributed pursuant
#  to the terms and conditions of a separate, written license agreement executed
#  between you and Broadcom Ltd. (an "Authorized License").  Except as set forth in
#  an Authorized License, Broadcom Ltd. grants no license (express or implied), right
#  to use, or waiver of any kind with respect to the Software, and Broadcom Ltd.
#  expressly reserves all rights in and to the Software and all intellectual
#  property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
#  NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
#  BROADCOM LTD AND DISCONTINUE ALL USE OF THE SOFTWARE.
#   
#  Except as expressly set forth in the Authorized License,
#   
#  1. This program, including its structure, sequence and organization,
#      constitutes the valuable trade secrets of Broadcom Ltd., and you shall use
#      all reasonable efforts to protect the confidentiality thereof, and to
#      use this information only in connection with your use of Broadcom Ltd.
#      integrated circuit products.
#   
#  2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
#      AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
#      WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
#      RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
#      ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
#      FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
#      COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
#      TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
#      PERFORMANCE OF THE SOFTWARE.
#   
#  3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
#      ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
#      INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
#      WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
#      IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
#      OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
#      SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
#      SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
#      LIMITED REMEDY.
#  :>
#
###############################################################################
#
#  Script:  update_copyright.sh
#
#  Purpose: This script updates the copyright comment headers in
#           c/c++, shell script, and Makefiles. Depending on the options
#           specified below, this script will also automatically create a
#           Perforce changelist and checkout the files before updating the
#           copyright headers.
#
#  Usage:   ./update_copyright.sh [-c chglist num|"none"] <files>
#             Options:
#
#             -c num|"none"    If -c is specified with a Perforce changelist 
#                              number, then files that are updated by this
#                              script will be put into the specified changelist.
#
#                              If '-c none' is specified, the script will not 
#                              execute any Perforce commands before updating the
#                              copyright in files. The user is expected to checkout 
#                              the files prior to excuting this script.
#
#                              If -c is not specified (default), a new change list 
#                              is created and all updated files are put into the new 
#                              change list.
#
#
#  This script makes use of the following perl scripts:
#      strip_c_copyright.pl   - Strips a copyright header from a c/c++ file.
#      strip_sh_copyright.pl  - Strips a copyright header from a Makefile or shell 
#                               script.
#      insert_copyright.pl    - Inserts a copyright header into a c/c++, shell script, 
#                               or Makefile file.
#
#
#  --------------------------
#  Copyright Update Procedure
#  --------------------------
#
#  The following procedure should be used to update the copyright information.
#
#  1) find . -regextype egrep -regex '.*\.c|.*\.h|.*\.cpp|.*Makefile|.*Makefile\.sdk|.*\.mk|.*\.sh' | xargs $PROJROOT/tools/copyright_tools/update_copyright.sh
#
#  To exlude a directory from the search, use the following command
#
#  1a) find . -path ./3rdparty -prune -o -regextype egrep -regex '.*\.c|.*\.h|.*\.cpp|.*Makefile|.*Makefile\.sdk|.*\.mk|.*\.sh' | xargs $PROJROOT/tools/copyright_tools/update_copyright.sh
#
#  2) Update the "Copyright (c)" statement in the debug CLI (./lib/libdbg/dbgCli.c)
#        - Note: newer versions of the script may already handle this automatically.
#
#  3) Update the following files by hand because they do not follow
#     the standard source file naming conventions:
#         - bal/cur/3rdparty/indigo/indigo/modules/ofpal_driver/module/src/ofpal_driver.c
#         - bal/cur/3rdparty/indigo/indigo/modules/ofpal-driver/utest/main.c
#         - bal/cur/doxygen/Makefile
#
#      Also, you can use the following command to find additional straglers...
#
#         find . | xargs grep 2013
#
#  (Optional) Use the following procedure to verify the changes.
#
#        a) Use p4 to build a list of files that are being modified by this CL.
#
#           p4 describe <CL from step1> | grep '^\.\.\.' | awk '{print $2}' | sed 's%//SystemSoftware/Rel/pioneer/dml/%%g' | sed 's%\#.$%%g'  > p4_changes_files.txt
#        
#        b) Add the following bash script to a file called temp.sh and
#           add execute permissions to the file.
#
#            #!/bin/sh
#            #
#            while read -r line; do
#                echo "$line:  "`p4 diff -ds $line | grep changed`
#            done < p4_changes_files.txt
#        
#        c) Run the script
#
#            ./temp.sh | tee p4_diffs.txt
#        
#        d) Check the scripe for unusual/unexpected changes and use 'p4 diff file'
#           to investigate.
#
#            cat p4_diffs.txt | grep -v "changed 1 chunks 1 / 1 lines" | tee t1.txt
#
#
###############################################################################

COPYRIGHT_FILE=${PROJROOT}/COPYRIGHT
P4_CHANGELIST_DESC="Copyright Header Update - "`date`

if [ "$1" = "-c" ]
    then
    P4_CHANGELIST_NUM="$2"

    if [ "$P4_CHANGELIST_NUM" = "" ]
        then
        echo "ERROR: must specify 'none' or P4 change list number for the '-c' option."
        exit 1
    elif [ "$P4_CHANGELIST_NUM" = "none" ]
        then
        echo "NOTE: Perforce commands will be skipped"
    else
        echo "Using existing change list $P4_CHANGELIST_NUM"
    fi
    shift ; shift
else
    P4_CHANGELIST_NUM=`echo -e "Change: new\nDescription: ${P4_CHANGELIST_DESC}" | p4 change -i | cut -d " " -f 2`
    echo "Created change list $P4_CHANGELIST_NUM"
fi

for path in "$@"
do
  file=`basename $path`

  file_ext="${file#*.}"

  # Only checkout files from perforce is an existing or new change list was specified 
  if [ "$P4_CHANGELIST_NUM" != "none" ]
      then

      # Only update text files
      p4_file_type=`p4 fstat $path | grep headType | cut -d " " -f 3 | grep -o text`
      if [ "$p4_file_type" != "text" ]
          then
          echo "WARNING: skipping file '$path' because it it not a text file."
          continue  ### resumes iteration of an enclosing for loop ###
      fi

      # Open the file for editing
      p4 opened $path 2>&1 | grep -q "not opened"
      if [ $? != 0 ]
          then
          echo "WARNING: file '$path' is already opened for edit..."
      else
          p4 edit -c $P4_CHANGELIST_NUM $path &>/dev/null
      fi
  fi

  # Update the Copyright based on file type
  if [ "$file_ext" == "c" ] || [ "$file_ext" == "h" ] || [ "$file_ext" == "cpp" ]
      then
      #
      # C/C++ files
      #
      echo -ne "Updating '$file', type = c/c++ ... "
      cat $path | perl ${PROJROOT}/tools/copyright_tools/strip_c_copyright.pl > $path"_crtemp";
      perl ${PROJROOT}/tools/copyright_tools/insert_copyright.pl -t c -l ${COPYRIGHT_FILE} $path"_crtemp" > $path;
      rm $path"_crtemp"
      echo "done."
  elif [ "$file_ext" == "sh" ]
      then
      #
      # Shell script files
      #
      echo -ne "Updating '$file', type = shell script ... "
      cat $path | perl ${PROJROOT}/tools/copyright_tools/strip_sh_copyright.pl > $path"_crtemp";
      perl ${PROJROOT}/tools/copyright_tools/insert_copyright.pl -t s -l ${COPYRIGHT_FILE} $path"_crtemp" > $path;
      rm $path"_crtemp"
      echo "done."
  elif [ "$file" == "Makefile" ] || [ "$file" == "Makefile.sdk" ] || [ "$file_ext" == "mk" ]
      then
      #
      # Makefiles
      #
      echo -ne "Updating '$file', type = Makefile ... "
      cat $path | perl ${PROJROOT}/tools/copyright_tools/strip_sh_copyright.pl > $path"_crtemp";
      perl ${PROJROOT}/tools/copyright_tools/insert_copyright.pl -t m -l ${COPYRIGHT_FILE} $path"_crtemp" > $path;
      rm $path"_crtemp"
      echo "done."
  else
      echo "Skipping $file, type = unknown type"
  fi
done