/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_utils.h
 * @brief BAL Utilities include file
 *
 */

#ifndef BALUTILS_H
#define BALUTILS_H

/*@{*/

/** 
 * @brief General purpose BAL String structure.
 *
 * This is typically used for debugging or log messages.
 */
#define BAL_STRING_LENGTH 256

#define MAC_STR_LEN 18

/**
 * @brief BAL String Structure
 */
typedef struct bal_string
{
    char str[BAL_STRING_LENGTH+1]; /**< The string */
} bal_string;

extern char *mac_addr_to_str(char *buffer, bcmos_mac_address mac);
extern  bcmos_bool mac_add_is_null(bcmos_mac_address mac);

/*@}*/

#endif /* BALUTILS_H */
