/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
#ifndef _RSC_MGR_COMMON_H_
#define _RSC_MGR_COMMON_H_
 
#include <bcmolt_host_api.h>
#include <bcm_dev_log.h>
#include <bal_objs.h>
#include <bcmolt_math.h>

#define RSC_MGR_MIN_RANGE_SIZE 1
#define RSC_MGR_MAX_RANGE_SIZE 8

#define RSC_MGR_PON_TOPO_CONTEXT(pon_id) ((rsc_mgr_topo_pon_context *)bcm_topo_pon_get_context(pon_id, BCM_TOPO_PON_CONTEXT_ID_RSC_MGR))

typedef enum rsc_mgr_obj_type
{
    RSC_MGR_OBJ_TYPE_INVALID = 0,
    RSC_MGR_OBJ_TYPE_GEM_PORT_UNICAST,
    RSC_MGR_OBJ_TYPE_GEM_PORT_MULTICAST,
    RSC_MGR_OBJ_TYPE_GEM_PORT_BROADCAST,
    RSC_MGR_OBJ_TYPE_ALLOC_ID,
    RSC_MGR_OBJ_TYPE_TM_SCHED,
} rsc_mgr_obj_type;

#define RSC_MGR_OBJ_TYPE_STR(_type) \
    ((_type) == RSC_MGR_OBJ_TYPE_GEM_PORT_UNICAST ? "gem_port_unicast":\
        (_type) == RSC_MGR_OBJ_TYPE_GEM_PORT_MULTICAST ? "gem_port_multicast":\
            (_type) == RSC_MGR_OBJ_TYPE_GEM_PORT_BROADCAST ? "gem_port_broadcast":\
                (_type) == RSC_MGR_OBJ_TYPE_ALLOC_ID ? "alloc_id":\
                    (_type) == RSC_MGR_OBJ_TYPE_TM_SCHED ? "tm_sched":"invalid")


typedef struct
{
    bcmos_bool is_initialized;
} rsc_mgr_context_t;

extern rsc_mgr_context_t rsc_mgr_context;

/** @brief container for storing user data */
typedef struct rsc_mgr_user_data_entry
{
    TAILQ_ENTRY(rsc_mgr_user_data_entry) next;
    void *user_data;
} rsc_mgr_user_data_entry;

/** @brief linked list of flow entries sharing the same GEM port or Alloc Id */
typedef TAILQ_HEAD(, rsc_mgr_user_data_entry) shared_obj_user_data_list;

/* An object ID can be either alloc ID or GEM port. */
typedef uint32_t rsc_mgr_obj_id;

/* An element for an object linked list. */
typedef struct rsc_mgr_obj
{
    TAILQ_ENTRY(rsc_mgr_obj) list;
    struct rsc_mgr_obj *base_obj; /* The last object of a range points to the base object of the range. */
    rsc_mgr_obj_id id;
    uint32_t ref_count;
    uint32_t range_size;
    rsc_mgr_obj_type type;
    shared_obj_user_data_list user_data_list; /* this stores a list of flows sharing the same gem or alloc id object */
} rsc_mgr_obj;

typedef TAILQ_HEAD(, rsc_mgr_obj) rsc_mgr_obj_list;

typedef bcmos_bool (*rsc_mgr_is_valid_data_obj_id_cb_t)(bcmolt_pon_ni pon_id, rsc_mgr_obj_id id, rsc_mgr_obj_id min_data_obj_id);
typedef rsc_mgr_obj_id (*rsc_mgr_get_last_data_obj_id_cb_t)(bcmolt_pon_ni pon_id, rsc_mgr_obj_id min_data_obj_id);

typedef struct
{
    const char *obj_name;
    rsc_mgr_is_valid_data_obj_id_cb_t is_valid_data_obj_id_cb;
    rsc_mgr_get_last_data_obj_id_cb_t get_last_data_obj_id_cb;
    rsc_mgr_obj_list free_objs;
    rsc_mgr_obj_list allocated_objs;
    rsc_mgr_obj *objs; /* Dynamically allocated */
    uint32_t num_of_objs;
    rsc_mgr_obj_id min_data_obj_id;
} rsc_mgr_obj_rsc;

typedef struct
{
    rsc_mgr_obj_rsc alloc_ids;
    rsc_mgr_obj_rsc gems;
    uint16_t num_of_alloc_ids;
    uint16_t num_of_gem_ports;
#ifndef MULTIPLE_MULTICAST_GEM_PORTS_PER_PON
    uint16_t multicast_gem_port; /* For validation purposes (validate there is no more than a single multicast GEM port per PON). */
#endif
#ifndef MULTIPLE_BROADCAST_GEM_PORTS_PER_PON
    uint16_t broadcast_gem_port; /* For validation purposes (validate there is no more than a single broadcast GEM port per PON). */
#endif
#ifdef ENABLE_LOG
    dev_log_id log_id;
    char log_id_name[MAX_DEV_LOG_ID_NAME];
#endif
} rsc_mgr_topo_pon_context;

typedef struct
{
    rsc_mgr_obj_rsc tm_sched_auto_key_ids;
    uint16_t num_of_tm_sched_auto_key_ids;
#ifdef ENABLE_LOG
    dev_log_id log_id;
    char log_id_name[MAX_DEV_LOG_ID_NAME];
#endif

} rsc_mgr_tm_context;
#ifdef ENABLE_LOG
extern dev_log_id rsc_mgr_log_id;
#endif

bcmos_errno rsc_mgr_init_validate(void);

#endif

