/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
#include <bcm_topo.h>
#include "rsc_mgr_common.h"

#ifdef ENABLE_LOG
dev_log_id rsc_mgr_log_id = DEV_LOG_INVALID_ID;
#endif

bcmos_errno rsc_mgr_init_validate(void)
{
    if (!rsc_mgr_context.is_initialized)
    {
#ifdef ENABLE_LOG
        if (rsc_mgr_log_id == DEV_LOG_INVALID_ID)
        {
            rsc_mgr_log_id = bcm_dev_log_id_register("RSC_MGR", DEV_LOG_LEVEL_INFO, DEV_LOG_ID_TYPE_BOTH);
            BUG_ON(rsc_mgr_log_id == DEV_LOG_INVALID_ID);
        }
#endif
        return BCM_ERR_STATE;
    }

    if (!bcm_topo_is_initialized())
    {
        BCM_LOG(ERROR, rsc_mgr_log_id, "Resource manager cannot be called before topology is initialized\n");
        return BCM_ERR_STATE;
    }

    return BCM_ERR_OK;
}

