#ifndef BAL_OBJ_MSG_PACK_UNPACK_H_
#define BAL_OBJ_MSG_PACK_UNPACK_H_

#include "bcmos_system.h"
#include "bcmos_errno.h"
#include "bal_model_types.h"
#include "bal_model_funcs.h"


bcmos_errno bcmbal_obj_msg_pack(bal_comm_msg_hdr *unpacked_bal_msg,/* unpacked msg */ 
                                bcmos_msg **packed_msg);    /* packed message */

bcmos_errno bcmbal_obj_msg_unpack(bcmos_msg *packed_msg,    /* packed message */ 
                                  bal_comm_msg_hdr **unpacked_bal_msg); /* the unpacked bal msg */

/** Returns the instance number of a given message, as determined by the object key.
 *
 * \param msg The message to check.
 * \return The instance number of the message.
 */
uint8_t bcmbal_obj_msg_instance(const bcmbal_obj *msg);

/** Gets a mask of all readonly properties for an object's cfg group.
 *
 * \param obj The objecct to check.
 * \param mask A mask of bits set to 1 per read-only property.
 * \return An error code or BCM_ERR_OK for success. 
 */
bcmos_errno bcmbal_get_prop_readonly_mask(bcmbal_obj_id obj, bcmbal_presence_mask *mask);

/** Clones a message by packing it to a buffer then unpacking it into the destination message.
 * This uses _bcmbal_obj_msg_unpack, so if *dest is NULL, memory will by allocated dynamically using bcmos_calloc.
 *
 * \param dest A pointer to the location in memory that will hold the cloned message.
 * \param src The message that should be copied.
 * \return An error code or BCM_ERR_OK for success.
 */
bcmos_errno bcmbal_obj_msg_clone(bal_comm_msg_hdr **dest, bal_comm_msg_hdr *src);

/** Converts a generic group ID into a specific object type, group and subgroup.
 *
 * \param group_id The generic group ID.
 * \param obj The object type that corresponds to the group ID.
 * \param group The group type that corresponds to the group ID.
 * \param subgroup The subgroup index that corresponds to the group ID.
 * \return An error code or BCM_ERR_OK for success. 
 */
bcmos_errno _bcmbal_obj_group_id_split(bcmbal_obj_group_id group_id, bcmbal_obj_id *obj, bcmbal_mgt_group *group, uint16_t *subgroup);


#endif /* BAL_OBJ_MSG_PACK_UNPACK_H_ */
