#ifndef BAL_MODEL_FUNCS
#define BAL_MODEL_FUNCS

#include "bcmos_system.h"
#include "bcmos_errno.h"
#include "bal_buf.h"
#include "bal_model_ids.h"
#include "bal_model_types.h"

/** Packs a bcmbal_access_terminal_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_access_terminal_cfg_id_pack(bcmbal_access_terminal_cfg_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_access_terminal_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_access_terminal_cfg_id_unpack(bcmbal_access_terminal_cfg_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_access_terminal_ind_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_access_terminal_ind_id_pack(bcmbal_access_terminal_ind_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_access_terminal_ind_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_access_terminal_ind_id_unpack(bcmbal_access_terminal_ind_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_access_terminal_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_access_terminal_key_id_pack(bcmbal_access_terminal_key_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_access_terminal_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_access_terminal_key_id_unpack(bcmbal_access_terminal_key_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_action_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_action_id_pack(bcmbal_action_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_action_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_action_id_unpack(bcmbal_action_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_action_cmd_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_action_cmd_id_pack(bcmbal_action_cmd_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_action_cmd_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_action_cmd_id_unpack(bcmbal_action_cmd_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_classifier_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_classifier_id_pack(bcmbal_classifier_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_classifier_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_classifier_id_unpack(bcmbal_classifier_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_pkt_tag_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_pkt_tag_type_pack(bcmbal_pkt_tag_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_pkt_tag_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_pkt_tag_type_unpack(bcmbal_pkt_tag_type *this, bcmbal_buf *buf);

/** Packs a bcmbal_control to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_control_pack(bcmbal_control this, bcmbal_buf *buf);

/** Unpacks a bcmbal_control from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_control_unpack(bcmbal_control *this, bcmbal_buf *buf);

/** Packs a bcmbal_dest_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_dest_type_pack(bcmbal_dest_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_dest_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_dest_type_unpack(bcmbal_dest_type *this, bcmbal_buf *buf);

/** Packs a bcmbal_ds_miss_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_ds_miss_mode_pack(bcmbal_ds_miss_mode this, bcmbal_buf *buf);

/** Unpacks a bcmbal_ds_miss_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_ds_miss_mode_unpack(bcmbal_ds_miss_mode *this, bcmbal_buf *buf);

/** Packs a bcmbal_extra_bw_eligibility_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_extra_bw_eligibility_type_pack(bcmbal_extra_bw_eligibility_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_extra_bw_eligibility_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_extra_bw_eligibility_type_unpack(bcmbal_extra_bw_eligibility_type *this, bcmbal_buf *buf);

/** Packs a bcmbal_flow_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_flow_cfg_id_pack(bcmbal_flow_cfg_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_flow_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_flow_cfg_id_unpack(bcmbal_flow_cfg_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_flow_ind_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_flow_ind_id_pack(bcmbal_flow_ind_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_flow_ind_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_flow_ind_id_unpack(bcmbal_flow_ind_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_flow_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_flow_key_id_pack(bcmbal_flow_key_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_flow_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_flow_key_id_unpack(bcmbal_flow_key_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_flow_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_flow_stat_id_pack(bcmbal_flow_stat_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_flow_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_flow_stat_id_unpack(bcmbal_flow_stat_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_flow_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_flow_type_pack(bcmbal_flow_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_flow_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_flow_type_unpack(bcmbal_flow_type *this, bcmbal_buf *buf);

/** Packs a bcmbal_group_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_group_cfg_id_pack(bcmbal_group_cfg_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_group_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_group_cfg_id_unpack(bcmbal_group_cfg_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_group_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_group_key_id_pack(bcmbal_group_key_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_group_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_group_key_id_unpack(bcmbal_group_key_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_group_member_cmd to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_group_member_cmd_pack(bcmbal_group_member_cmd this, bcmbal_buf *buf);

/** Unpacks a bcmbal_group_member_cmd from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_group_member_cmd_unpack(bcmbal_group_member_cmd *this, bcmbal_buf *buf);

/** Packs a bcmbal_group_owner to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_group_owner_pack(bcmbal_group_owner this, bcmbal_buf *buf);

/** Unpacks a bcmbal_group_owner from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_group_owner_unpack(bcmbal_group_owner *this, bcmbal_buf *buf);

/** Packs a bcmbal_interface_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_interface_cfg_id_pack(bcmbal_interface_cfg_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_interface_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_interface_cfg_id_unpack(bcmbal_interface_cfg_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_interface_ind_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_interface_ind_id_pack(bcmbal_interface_ind_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_interface_ind_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_interface_ind_id_unpack(bcmbal_interface_ind_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_interface_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_interface_key_id_pack(bcmbal_interface_key_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_interface_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_interface_key_id_unpack(bcmbal_interface_key_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_interface_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_interface_stat_id_pack(bcmbal_interface_stat_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_interface_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_interface_stat_id_unpack(bcmbal_interface_stat_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_intf_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_intf_type_pack(bcmbal_intf_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_intf_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_intf_type_unpack(bcmbal_intf_type *this, bcmbal_buf *buf);

/** Packs a bcmbal_iwf_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_iwf_mode_pack(bcmbal_iwf_mode this, bcmbal_buf *buf);

/** Unpacks a bcmbal_iwf_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_iwf_mode_unpack(bcmbal_iwf_mode *this, bcmbal_buf *buf);

/** Packs a bcmbal_packet_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_packet_cfg_id_pack(bcmbal_packet_cfg_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_packet_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_packet_cfg_id_unpack(bcmbal_packet_cfg_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_packet_ind_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_packet_ind_id_pack(bcmbal_packet_ind_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_packet_ind_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_packet_ind_id_unpack(bcmbal_packet_ind_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_packet_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_packet_key_id_pack(bcmbal_packet_key_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_packet_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_packet_key_id_unpack(bcmbal_packet_key_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_sla_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_sla_id_pack(bcmbal_sla_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_sla_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_sla_id_unpack(bcmbal_sla_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_state to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_state_pack(bcmbal_state this, bcmbal_buf *buf);

/** Unpacks a bcmbal_state from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_state_unpack(bcmbal_state *this, bcmbal_buf *buf);

/** Packs a bcmbal_status to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_status_pack(bcmbal_status this, bcmbal_buf *buf);

/** Unpacks a bcmbal_status from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_status_unpack(bcmbal_status *this, bcmbal_buf *buf);

/** Packs a bcmbal_subscriber_terminal_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_subscriber_terminal_cfg_id_pack(bcmbal_subscriber_terminal_cfg_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_subscriber_terminal_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_subscriber_terminal_cfg_id_unpack(bcmbal_subscriber_terminal_cfg_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_subscriber_terminal_ind_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_subscriber_terminal_ind_id_pack(bcmbal_subscriber_terminal_ind_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_subscriber_terminal_ind_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_subscriber_terminal_ind_id_unpack(bcmbal_subscriber_terminal_ind_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_subscriber_terminal_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_subscriber_terminal_key_id_pack(bcmbal_subscriber_terminal_key_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_subscriber_terminal_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_subscriber_terminal_key_id_unpack(bcmbal_subscriber_terminal_key_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_subscriber_terminal_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_subscriber_terminal_stat_id_pack(bcmbal_subscriber_terminal_stat_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_subscriber_terminal_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_subscriber_terminal_stat_id_unpack(bcmbal_subscriber_terminal_stat_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_bac_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_bac_type_pack(bcmbal_tm_bac_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_bac_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_bac_type_unpack(bcmbal_tm_bac_type *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_creation_mode to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_creation_mode_pack(bcmbal_tm_creation_mode this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_creation_mode from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_creation_mode_unpack(bcmbal_tm_creation_mode *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_queue_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_queue_cfg_id_pack(bcmbal_tm_queue_cfg_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_queue_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_queue_cfg_id_unpack(bcmbal_tm_queue_cfg_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_queue_ind_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_queue_ind_id_pack(bcmbal_tm_queue_ind_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_queue_ind_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_queue_ind_id_unpack(bcmbal_tm_queue_ind_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_queue_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_queue_key_id_pack(bcmbal_tm_queue_key_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_queue_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_queue_key_id_unpack(bcmbal_tm_queue_key_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_queue_stat_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_queue_stat_id_pack(bcmbal_tm_queue_stat_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_queue_stat_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_queue_stat_id_unpack(bcmbal_tm_queue_stat_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_sched_cfg_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_sched_cfg_id_pack(bcmbal_tm_sched_cfg_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_sched_cfg_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_sched_cfg_id_unpack(bcmbal_tm_sched_cfg_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_sched_child_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_sched_child_type_pack(bcmbal_tm_sched_child_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_sched_child_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_sched_child_type_unpack(bcmbal_tm_sched_child_type *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_sched_dir to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_sched_dir_pack(bcmbal_tm_sched_dir this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_sched_dir from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_sched_dir_unpack(bcmbal_tm_sched_dir *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_sched_ind_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_sched_ind_id_pack(bcmbal_tm_sched_ind_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_sched_ind_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_sched_ind_id_unpack(bcmbal_tm_sched_ind_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_sched_key_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_sched_key_id_pack(bcmbal_tm_sched_key_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_sched_key_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_sched_key_id_unpack(bcmbal_tm_sched_key_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_sched_owner_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_sched_owner_type_pack(bcmbal_tm_sched_owner_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_sched_owner_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_sched_owner_type_unpack(bcmbal_tm_sched_owner_type *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_sched_owner_agg_port_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_sched_owner_agg_port_id_pack(bcmbal_tm_sched_owner_agg_port_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_sched_owner_agg_port_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_sched_owner_agg_port_id_unpack(bcmbal_tm_sched_owner_agg_port_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_sched_parent_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_sched_parent_id_pack(bcmbal_tm_sched_parent_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_sched_parent_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_sched_parent_id_unpack(bcmbal_tm_sched_parent_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_sched_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_sched_type_pack(bcmbal_tm_sched_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_sched_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_sched_type_unpack(bcmbal_tm_sched_type *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_shaping_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_shaping_id_pack(bcmbal_tm_shaping_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_shaping_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_shaping_id_unpack(bcmbal_tm_shaping_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_tm_tcont_sla_id to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_tm_tcont_sla_id_pack(bcmbal_tm_tcont_sla_id this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_tcont_sla_id from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_tm_tcont_sla_id_unpack(bcmbal_tm_tcont_sla_id *this, bcmbal_buf *buf);

/** Packs a bcmbal_trx_type to bytes 
 *
 * \param this The enumeration to pack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the pack was successful 
 */
bcmos_bool bcmbal_trx_type_pack(bcmbal_trx_type this, bcmbal_buf *buf);

/** Unpacks a bcmbal_trx_type from bytes 
 *
 * \param this Pointer to the enumeration to unpack 
 * \param buf Pointer to the buffer to write to 
 * \return Whether or not the unpack was successful 
 */
bcmos_bool bcmbal_trx_type_unpack(bcmbal_trx_type *this, bcmbal_buf *buf);

/** Initializes a bcmbal_action struct.  This sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_action_set_default(bcmbal_action *this);

/** Packs a bcmbal_action to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_action_pack(const bcmbal_action *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_action would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_action_get_packed_length(const bcmbal_action *this);

/** Unpacks a bcmbal_action from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_action_unpack(bcmbal_action *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_action struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_action_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_action is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_action_bounds_check(const bcmbal_action *this);

/** Initializes a bcmbal_aggregation_port_id_list_u8 struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_aggregation_port_id_list_u8_set_default(bcmbal_aggregation_port_id_list_u8 *this);

/** Packs a bcmbal_aggregation_port_id_list_u8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_aggregation_port_id_list_u8_pack(const bcmbal_aggregation_port_id_list_u8 *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_aggregation_port_id_list_u8 would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_aggregation_port_id_list_u8_get_packed_length(const bcmbal_aggregation_port_id_list_u8 *this);

/** Unpacks a bcmbal_aggregation_port_id_list_u8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_aggregation_port_id_list_u8_unpack(bcmbal_aggregation_port_id_list_u8 *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_aggregation_port_id_list_u8 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_aggregation_port_id_list_u8_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_aggregation_port_id_list_u8 is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_aggregation_port_id_list_u8_bounds_check(const bcmbal_aggregation_port_id_list_u8 *this);

/** Initializes a bcmbal_classifier struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_classifier_set_default(bcmbal_classifier *this);

/** Packs a bcmbal_classifier to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_classifier_pack(const bcmbal_classifier *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_classifier would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_classifier_get_packed_length(const bcmbal_classifier *this);

/** Unpacks a bcmbal_classifier from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_classifier_unpack(bcmbal_classifier *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_classifier struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_classifier_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_classifier is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_classifier_bounds_check(const bcmbal_classifier *this);

/** Initializes a bcmbal_dest struct.  This sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_dest_set_default(bcmbal_dest *this);

/** Packs a bcmbal_dest to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_dest_pack(const bcmbal_dest *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_dest would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_dest_get_packed_length(const bcmbal_dest *this);

/** Unpacks a bcmbal_dest from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_dest_unpack(bcmbal_dest *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_dest struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_dest_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_dest is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_dest_bounds_check(const bcmbal_dest *this);

/** Initializes a bcmbal_flow_id_list_u32 struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_flow_id_list_u32_set_default(bcmbal_flow_id_list_u32 *this);

/** Packs a bcmbal_flow_id_list_u32 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_id_list_u32_pack(const bcmbal_flow_id_list_u32 *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_flow_id_list_u32 would occupy on the 
 * wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_flow_id_list_u32_get_packed_length(const bcmbal_flow_id_list_u32 *this);

/** Unpacks a bcmbal_flow_id_list_u32 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_id_list_u32_unpack(bcmbal_flow_id_list_u32 *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_flow_id_list_u32 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_flow_id_list_u32_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_flow_id_list_u32 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_id_list_u32_bounds_check(const bcmbal_flow_id_list_u32 *this);

/** Initializes a bcmbal_tm_queue_ref struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_tm_queue_ref_set_default(bcmbal_tm_queue_ref *this);

/** Packs a bcmbal_tm_queue_ref to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_ref_pack(const bcmbal_tm_queue_ref *this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_queue_ref from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_ref_unpack(bcmbal_tm_queue_ref *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_tm_queue_ref struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_queue_ref_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_tm_queue_ref is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_ref_bounds_check(const bcmbal_tm_queue_ref *this);

/** Initializes a bcmbal_group_member_info struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_group_member_info_set_default(bcmbal_group_member_info *this);

/** Packs a bcmbal_group_member_info to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_group_member_info_pack(const bcmbal_group_member_info *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_group_member_info would occupy on the 
 * wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_group_member_info_get_packed_length(const bcmbal_group_member_info *this);

/** Unpacks a bcmbal_group_member_info from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_group_member_info_unpack(bcmbal_group_member_info *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_group_member_info struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_group_member_info_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_group_member_info is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_group_member_info_bounds_check(const bcmbal_group_member_info *this);

/** Initializes a bcmbal_group_member_info_list_u16 struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_group_member_info_list_u16_set_default(bcmbal_group_member_info_list_u16 *this);

/** Packs a bcmbal_group_member_info_list_u16 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_group_member_info_list_u16_pack(const bcmbal_group_member_info_list_u16 *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_group_member_info_list_u16 would 
 * occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_group_member_info_list_u16_get_packed_length(const bcmbal_group_member_info_list_u16 *this);

/** Unpacks a bcmbal_group_member_info_list_u16 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_group_member_info_list_u16_unpack(bcmbal_group_member_info_list_u16 *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_group_member_info_list_u16 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_group_member_info_list_u16_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_group_member_info_list_u16 is out of 
 * bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_group_member_info_list_u16_bounds_check(const bcmbal_group_member_info_list_u16 *this);

/** Initializes a bcmbal_password struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_password_set_default(bcmbal_password *this);

/** Packs a bcmbal_password to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_password_pack(const bcmbal_password *this, bcmbal_buf *buf);

/** Unpacks a bcmbal_password from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_password_unpack(bcmbal_password *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_password struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_password_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_password is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_password_bounds_check(const bcmbal_password *this);

/** Initializes a bcmbal_registration_id struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_registration_id_set_default(bcmbal_registration_id *this);

/** Packs a bcmbal_registration_id to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_registration_id_pack(const bcmbal_registration_id *this, bcmbal_buf *buf);

/** Unpacks a bcmbal_registration_id from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_registration_id_unpack(bcmbal_registration_id *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_registration_id struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_registration_id_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_registration_id is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_registration_id_bounds_check(const bcmbal_registration_id *this);

/** Initializes a bcmbal_serial_number struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_serial_number_set_default(bcmbal_serial_number *this);

/** Packs a bcmbal_serial_number to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_serial_number_pack(const bcmbal_serial_number *this, bcmbal_buf *buf);

/** Unpacks a bcmbal_serial_number from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_serial_number_unpack(bcmbal_serial_number *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_serial_number struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_serial_number_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_serial_number is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_serial_number_bounds_check(const bcmbal_serial_number *this);

/** Initializes a bcmbal_service_port_id_list_u8 struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_service_port_id_list_u8_set_default(bcmbal_service_port_id_list_u8 *this);

/** Packs a bcmbal_service_port_id_list_u8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_service_port_id_list_u8_pack(const bcmbal_service_port_id_list_u8 *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_service_port_id_list_u8 would occupy 
 * on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_service_port_id_list_u8_get_packed_length(const bcmbal_service_port_id_list_u8 *this);

/** Unpacks a bcmbal_service_port_id_list_u8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_service_port_id_list_u8_unpack(bcmbal_service_port_id_list_u8 *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_service_port_id_list_u8 struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_service_port_id_list_u8_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_service_port_id_list_u8 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_service_port_id_list_u8_bounds_check(const bcmbal_service_port_id_list_u8 *this);

/** Initializes a bcmbal_sla struct.  This sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_sla_set_default(bcmbal_sla *this);

/** Packs a bcmbal_sla to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_sla_pack(const bcmbal_sla *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_sla would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_sla_get_packed_length(const bcmbal_sla *this);

/** Unpacks a bcmbal_sla from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_sla_unpack(bcmbal_sla *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_sla struct and collects memory requirements above 
 * and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_sla_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_sla is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_sla_bounds_check(const bcmbal_sla *this);

/** Initializes a bcmbal_sub_id_list_u16 struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_sub_id_list_u16_set_default(bcmbal_sub_id_list_u16 *this);

/** Packs a bcmbal_sub_id_list_u16 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_sub_id_list_u16_pack(const bcmbal_sub_id_list_u16 *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_sub_id_list_u16 would occupy on the 
 * wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_sub_id_list_u16_get_packed_length(const bcmbal_sub_id_list_u16 *this);

/** Unpacks a bcmbal_sub_id_list_u16 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_sub_id_list_u16_unpack(bcmbal_sub_id_list_u16 *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_sub_id_list_u16 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_sub_id_list_u16_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_sub_id_list_u16 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_sub_id_list_u16_bounds_check(const bcmbal_sub_id_list_u16 *this);

/** Initializes a bcmbal_tm_red struct.  This sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_tm_red_set_default(bcmbal_tm_red *this);

/** Packs a bcmbal_tm_red to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_red_pack(const bcmbal_tm_red *this, bcmbal_buf *buf);

/** Unpacks a bcmbal_tm_red from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_red_unpack(bcmbal_tm_red *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_tm_red struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_red_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_tm_red is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_red_bounds_check(const bcmbal_tm_red *this);

/** Initializes a bcmbal_tm_bac struct.  This sets all fields to default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_tm_bac_set_default(bcmbal_tm_bac *this);

/** Packs a bcmbal_tm_bac to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_bac_pack(const bcmbal_tm_bac *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_tm_bac would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_bac_get_packed_length(const bcmbal_tm_bac *this);

/** Unpacks a bcmbal_tm_bac from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_bac_unpack(bcmbal_tm_bac *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_tm_bac struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_bac_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_tm_bac is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_bac_bounds_check(const bcmbal_tm_bac *this);

/** Initializes a bcmbal_tm_queue_id_list_u8 struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_tm_queue_id_list_u8_set_default(bcmbal_tm_queue_id_list_u8 *this);

/** Packs a bcmbal_tm_queue_id_list_u8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_id_list_u8_pack(const bcmbal_tm_queue_id_list_u8 *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_tm_queue_id_list_u8 would occupy on 
 * the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_queue_id_list_u8_get_packed_length(const bcmbal_tm_queue_id_list_u8 *this);

/** Unpacks a bcmbal_tm_queue_id_list_u8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_id_list_u8_unpack(bcmbal_tm_queue_id_list_u8 *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_tm_queue_id_list_u8 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_queue_id_list_u8_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_tm_queue_id_list_u8 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_id_list_u8_bounds_check(const bcmbal_tm_queue_id_list_u8 *this);

/** Initializes a bcmbal_tm_sched_id_list_u8 struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_tm_sched_id_list_u8_set_default(bcmbal_tm_sched_id_list_u8 *this);

/** Packs a bcmbal_tm_sched_id_list_u8 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_id_list_u8_pack(const bcmbal_tm_sched_id_list_u8 *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_tm_sched_id_list_u8 would occupy on 
 * the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_sched_id_list_u8_get_packed_length(const bcmbal_tm_sched_id_list_u8 *this);

/** Unpacks a bcmbal_tm_sched_id_list_u8 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_id_list_u8_unpack(bcmbal_tm_sched_id_list_u8 *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_tm_sched_id_list_u8 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_sched_id_list_u8_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_tm_sched_id_list_u8 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_id_list_u8_bounds_check(const bcmbal_tm_sched_id_list_u8 *this);

/** Initializes a bcmbal_tm_sched_owner struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_tm_sched_owner_set_default(bcmbal_tm_sched_owner *this);

/** Packs a bcmbal_tm_sched_owner to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_owner_pack(const bcmbal_tm_sched_owner *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_tm_sched_owner would occupy on the 
 * wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_sched_owner_get_packed_length(const bcmbal_tm_sched_owner *this);

/** Unpacks a bcmbal_tm_sched_owner from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_owner_unpack(bcmbal_tm_sched_owner *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_tm_sched_owner struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_sched_owner_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_tm_sched_owner is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_owner_bounds_check(const bcmbal_tm_sched_owner *this);

/** Initializes a bcmbal_tm_sched_parent struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_tm_sched_parent_set_default(bcmbal_tm_sched_parent *this);

/** Packs a bcmbal_tm_sched_parent to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_parent_pack(const bcmbal_tm_sched_parent *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_tm_sched_parent would occupy on the 
 * wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_sched_parent_get_packed_length(const bcmbal_tm_sched_parent *this);

/** Unpacks a bcmbal_tm_sched_parent from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_parent_unpack(bcmbal_tm_sched_parent *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_tm_sched_parent struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_sched_parent_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_tm_sched_parent is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_parent_bounds_check(const bcmbal_tm_sched_parent *this);

/** Initializes a bcmbal_tm_shaping struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_tm_shaping_set_default(bcmbal_tm_shaping *this);

/** Packs a bcmbal_tm_shaping to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_shaping_pack(const bcmbal_tm_shaping *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_tm_shaping would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_shaping_get_packed_length(const bcmbal_tm_shaping *this);

/** Unpacks a bcmbal_tm_shaping from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_shaping_unpack(bcmbal_tm_shaping *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_tm_shaping struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_shaping_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_tm_shaping is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_shaping_bounds_check(const bcmbal_tm_shaping *this);

/** Initializes a bcmbal_tm_tcont_sla struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_tm_tcont_sla_set_default(bcmbal_tm_tcont_sla *this);

/** Packs a bcmbal_tm_tcont_sla to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_tcont_sla_pack(const bcmbal_tm_tcont_sla *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_tm_tcont_sla would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_tcont_sla_get_packed_length(const bcmbal_tm_tcont_sla *this);

/** Unpacks a bcmbal_tm_tcont_sla from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_tcont_sla_unpack(bcmbal_tm_tcont_sla *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_tm_tcont_sla struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_tcont_sla_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_tm_tcont_sla is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_tcont_sla_bounds_check(const bcmbal_tm_tcont_sla *this);

/** Initializes a bcmbal_u8_list_u32 struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 */
void bcmbal_u8_list_u32_set_default(bcmbal_u8_list_u32 *this);

/** Packs a bcmbal_u8_list_u32 to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_u8_list_u32_pack(const bcmbal_u8_list_u32 *this, bcmbal_buf *buf);

/** Gets the number of bytes that a bcmbal_u8_list_u32 would occupy on the wire 
 *
 * \return The structure size in bytes 
 */
uint32_t bcmbal_u8_list_u32_get_packed_length(const bcmbal_u8_list_u32 *this);

/** Unpacks a bcmbal_u8_list_u32 from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_u8_list_u32_unpack(bcmbal_u8_list_u32 *this, bcmbal_buf *buf, void **extra_mem);

/** Scans past a packed bcmbal_u8_list_u32 struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_u8_list_u32_scan(bcmbal_buf *packed, uint32_t *extra_mem);

/** Checks if any field in the bcmbal_u8_list_u32 is out of bounds 
 *
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_u8_list_u32_bounds_check(const bcmbal_u8_list_u32 *this);

/** Initializes a bcmbal_access_terminal_key struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_access_terminal_key_set_default(bcmbal_access_terminal_key *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_access_terminal_key to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_access_terminal_key_pack(const bcmbal_access_terminal_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_access_terminal_key would occupy on 
 * the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_access_terminal_key_get_packed_length(const bcmbal_access_terminal_key *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_access_terminal_key from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_access_terminal_key_unpack(bcmbal_access_terminal_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_access_terminal_key struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_access_terminal_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_access_terminal_key is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_access_terminal_key_bounds_check(const bcmbal_access_terminal_key *this, bcmbal_presence_mask fields_present, bcmbal_access_terminal_key_id *failed_prop);

/** Initializes a bcmbal_access_terminal_cfg_data struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_access_terminal_cfg_data_set_default(bcmbal_access_terminal_cfg_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_access_terminal_cfg_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_access_terminal_cfg_data_pack(const bcmbal_access_terminal_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_access_terminal_cfg_data would occupy 
 * on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_access_terminal_cfg_data_get_packed_length(const bcmbal_access_terminal_cfg_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_access_terminal_cfg_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_access_terminal_cfg_data_unpack(bcmbal_access_terminal_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_access_terminal_cfg_data struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_access_terminal_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_access_terminal_cfg_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_access_terminal_cfg_data_bounds_check(const bcmbal_access_terminal_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_access_terminal_cfg_id *failed_prop);

/** Initializes a bcmbal_access_terminal_ind_data struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_access_terminal_ind_data_set_default(bcmbal_access_terminal_ind_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_access_terminal_ind_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_access_terminal_ind_data_pack(const bcmbal_access_terminal_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_access_terminal_ind_data would occupy 
 * on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_access_terminal_ind_data_get_packed_length(const bcmbal_access_terminal_ind_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_access_terminal_ind_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_access_terminal_ind_data_unpack(bcmbal_access_terminal_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_access_terminal_ind_data struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_access_terminal_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_access_terminal_ind_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_access_terminal_ind_data_bounds_check(const bcmbal_access_terminal_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_access_terminal_ind_id *failed_prop);

/** Initializes a bcmbal_flow_key struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_flow_key_set_default(bcmbal_flow_key *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_flow_key to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_key_pack(const bcmbal_flow_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_flow_key would occupy on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_flow_key_get_packed_length(const bcmbal_flow_key *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_flow_key from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_key_unpack(bcmbal_flow_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_flow_key struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_flow_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_flow_key is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_key_bounds_check(const bcmbal_flow_key *this, bcmbal_presence_mask fields_present, bcmbal_flow_key_id *failed_prop);

/** Initializes a bcmbal_flow_cfg_data struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_flow_cfg_data_set_default(bcmbal_flow_cfg_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_flow_cfg_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_cfg_data_pack(const bcmbal_flow_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_flow_cfg_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_flow_cfg_data_get_packed_length(const bcmbal_flow_cfg_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_flow_cfg_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_cfg_data_unpack(bcmbal_flow_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_flow_cfg_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_flow_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_flow_cfg_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_cfg_data_bounds_check(const bcmbal_flow_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_flow_cfg_id *failed_prop);

/** Initializes a bcmbal_flow_stat_data struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_flow_stat_data_set_default(bcmbal_flow_stat_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_flow_stat_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_stat_data_pack(const bcmbal_flow_stat_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_flow_stat_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_flow_stat_data_get_packed_length(const bcmbal_flow_stat_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_flow_stat_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_stat_data_unpack(bcmbal_flow_stat_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_flow_stat_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_flow_stat_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_flow_stat_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_stat_data_bounds_check(const bcmbal_flow_stat_data *this, bcmbal_presence_mask fields_present, bcmbal_flow_stat_id *failed_prop);

/** Initializes a bcmbal_flow_ind_data struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_flow_ind_data_set_default(bcmbal_flow_ind_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_flow_ind_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_ind_data_pack(const bcmbal_flow_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_flow_ind_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_flow_ind_data_get_packed_length(const bcmbal_flow_ind_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_flow_ind_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_ind_data_unpack(bcmbal_flow_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_flow_ind_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_flow_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_flow_ind_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_flow_ind_data_bounds_check(const bcmbal_flow_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_flow_ind_id *failed_prop);

/** Initializes a bcmbal_group_key struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_group_key_set_default(bcmbal_group_key *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_group_key to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_group_key_pack(const bcmbal_group_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_group_key would occupy on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_group_key_get_packed_length(const bcmbal_group_key *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_group_key from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_group_key_unpack(bcmbal_group_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_group_key struct and collects memory requirements 
 * above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_group_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_group_key is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_group_key_bounds_check(const bcmbal_group_key *this, bcmbal_presence_mask fields_present, bcmbal_group_key_id *failed_prop);

/** Initializes a bcmbal_group_cfg_data struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_group_cfg_data_set_default(bcmbal_group_cfg_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_group_cfg_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_group_cfg_data_pack(const bcmbal_group_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_group_cfg_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_group_cfg_data_get_packed_length(const bcmbal_group_cfg_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_group_cfg_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_group_cfg_data_unpack(bcmbal_group_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_group_cfg_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_group_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_group_cfg_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_group_cfg_data_bounds_check(const bcmbal_group_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_group_cfg_id *failed_prop);

/** Initializes a bcmbal_interface_key struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_interface_key_set_default(bcmbal_interface_key *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_interface_key to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_key_pack(const bcmbal_interface_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_interface_key would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_interface_key_get_packed_length(const bcmbal_interface_key *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_interface_key from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_key_unpack(bcmbal_interface_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_interface_key struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_interface_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_interface_key is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_key_bounds_check(const bcmbal_interface_key *this, bcmbal_presence_mask fields_present, bcmbal_interface_key_id *failed_prop);

/** Initializes a bcmbal_interface_cfg_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_interface_cfg_data_set_default(bcmbal_interface_cfg_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_interface_cfg_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_cfg_data_pack(const bcmbal_interface_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_interface_cfg_data would occupy on 
 * the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_interface_cfg_data_get_packed_length(const bcmbal_interface_cfg_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_interface_cfg_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_cfg_data_unpack(bcmbal_interface_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_interface_cfg_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_interface_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_interface_cfg_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_cfg_data_bounds_check(const bcmbal_interface_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_interface_cfg_id *failed_prop);

/** Initializes a bcmbal_interface_stat_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_interface_stat_data_set_default(bcmbal_interface_stat_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_interface_stat_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_stat_data_pack(const bcmbal_interface_stat_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_interface_stat_data would occupy on 
 * the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_interface_stat_data_get_packed_length(const bcmbal_interface_stat_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_interface_stat_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_stat_data_unpack(bcmbal_interface_stat_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_interface_stat_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_interface_stat_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_interface_stat_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_stat_data_bounds_check(const bcmbal_interface_stat_data *this, bcmbal_presence_mask fields_present, bcmbal_interface_stat_id *failed_prop);

/** Initializes a bcmbal_interface_ind_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_interface_ind_data_set_default(bcmbal_interface_ind_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_interface_ind_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_ind_data_pack(const bcmbal_interface_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_interface_ind_data would occupy on 
 * the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_interface_ind_data_get_packed_length(const bcmbal_interface_ind_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_interface_ind_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_ind_data_unpack(bcmbal_interface_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_interface_ind_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_interface_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_interface_ind_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_interface_ind_data_bounds_check(const bcmbal_interface_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_interface_ind_id *failed_prop);

/** Initializes a bcmbal_packet_key struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_packet_key_set_default(bcmbal_packet_key *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_packet_key to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_packet_key_pack(const bcmbal_packet_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_packet_key would occupy on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_packet_key_get_packed_length(const bcmbal_packet_key *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_packet_key from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_packet_key_unpack(bcmbal_packet_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_packet_key struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_packet_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_packet_key is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_packet_key_bounds_check(const bcmbal_packet_key *this, bcmbal_presence_mask fields_present, bcmbal_packet_key_id *failed_prop);

/** Initializes a bcmbal_packet_cfg_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_packet_cfg_data_set_default(bcmbal_packet_cfg_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_packet_cfg_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_packet_cfg_data_pack(const bcmbal_packet_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_packet_cfg_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_packet_cfg_data_get_packed_length(const bcmbal_packet_cfg_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_packet_cfg_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_packet_cfg_data_unpack(bcmbal_packet_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_packet_cfg_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_packet_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_packet_cfg_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_packet_cfg_data_bounds_check(const bcmbal_packet_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_packet_cfg_id *failed_prop);

/** Initializes a bcmbal_packet_ind_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_packet_ind_data_set_default(bcmbal_packet_ind_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_packet_ind_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_packet_ind_data_pack(const bcmbal_packet_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_packet_ind_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_packet_ind_data_get_packed_length(const bcmbal_packet_ind_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_packet_ind_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_packet_ind_data_unpack(bcmbal_packet_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_packet_ind_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_packet_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_packet_ind_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_packet_ind_data_bounds_check(const bcmbal_packet_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_packet_ind_id *failed_prop);

/** Initializes a bcmbal_subscriber_terminal_key struct.  This sets all fields 
 * to default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_subscriber_terminal_key_set_default(bcmbal_subscriber_terminal_key *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_subscriber_terminal_key to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_key_pack(const bcmbal_subscriber_terminal_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_subscriber_terminal_key would occupy 
 * on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_subscriber_terminal_key_get_packed_length(const bcmbal_subscriber_terminal_key *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_subscriber_terminal_key from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_key_unpack(bcmbal_subscriber_terminal_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_subscriber_terminal_key struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_subscriber_terminal_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_subscriber_terminal_key is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_key_bounds_check(const bcmbal_subscriber_terminal_key *this, bcmbal_presence_mask fields_present, bcmbal_subscriber_terminal_key_id *failed_prop);

/** Initializes a bcmbal_subscriber_terminal_cfg_data struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_subscriber_terminal_cfg_data_set_default(bcmbal_subscriber_terminal_cfg_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_subscriber_terminal_cfg_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_cfg_data_pack(const bcmbal_subscriber_terminal_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_subscriber_terminal_cfg_data would 
 * occupy on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_subscriber_terminal_cfg_data_get_packed_length(const bcmbal_subscriber_terminal_cfg_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_subscriber_terminal_cfg_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_cfg_data_unpack(bcmbal_subscriber_terminal_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_subscriber_terminal_cfg_data struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_subscriber_terminal_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_subscriber_terminal_cfg_data is out of 
 * bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_cfg_data_bounds_check(const bcmbal_subscriber_terminal_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_subscriber_terminal_cfg_id *failed_prop);

/** Initializes a bcmbal_subscriber_terminal_stat_data struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_subscriber_terminal_stat_data_set_default(bcmbal_subscriber_terminal_stat_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_subscriber_terminal_stat_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_stat_data_pack(const bcmbal_subscriber_terminal_stat_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_subscriber_terminal_stat_data would 
 * occupy on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_subscriber_terminal_stat_data_get_packed_length(const bcmbal_subscriber_terminal_stat_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_subscriber_terminal_stat_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_stat_data_unpack(bcmbal_subscriber_terminal_stat_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_subscriber_terminal_stat_data struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_subscriber_terminal_stat_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_subscriber_terminal_stat_data is out of 
 * bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_stat_data_bounds_check(const bcmbal_subscriber_terminal_stat_data *this, bcmbal_presence_mask fields_present, bcmbal_subscriber_terminal_stat_id *failed_prop);

/** Initializes a bcmbal_subscriber_terminal_ind_data struct.  This sets all 
 * fields to default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_subscriber_terminal_ind_data_set_default(bcmbal_subscriber_terminal_ind_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_subscriber_terminal_ind_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_ind_data_pack(const bcmbal_subscriber_terminal_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_subscriber_terminal_ind_data would 
 * occupy on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_subscriber_terminal_ind_data_get_packed_length(const bcmbal_subscriber_terminal_ind_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_subscriber_terminal_ind_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_ind_data_unpack(bcmbal_subscriber_terminal_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_subscriber_terminal_ind_data struct and collects 
 * memory requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_subscriber_terminal_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_subscriber_terminal_ind_data is out of 
 * bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_subscriber_terminal_ind_data_bounds_check(const bcmbal_subscriber_terminal_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_subscriber_terminal_ind_id *failed_prop);

/** Initializes a bcmbal_tm_queue_key struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_tm_queue_key_set_default(bcmbal_tm_queue_key *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_tm_queue_key to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_key_pack(const bcmbal_tm_queue_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_tm_queue_key would occupy on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_queue_key_get_packed_length(const bcmbal_tm_queue_key *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_tm_queue_key from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_key_unpack(bcmbal_tm_queue_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_tm_queue_key struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_queue_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_tm_queue_key is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_key_bounds_check(const bcmbal_tm_queue_key *this, bcmbal_presence_mask fields_present, bcmbal_tm_queue_key_id *failed_prop);

/** Initializes a bcmbal_tm_queue_cfg_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_tm_queue_cfg_data_set_default(bcmbal_tm_queue_cfg_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_tm_queue_cfg_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_cfg_data_pack(const bcmbal_tm_queue_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_tm_queue_cfg_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_queue_cfg_data_get_packed_length(const bcmbal_tm_queue_cfg_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_tm_queue_cfg_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_cfg_data_unpack(bcmbal_tm_queue_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_tm_queue_cfg_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_queue_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_tm_queue_cfg_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_cfg_data_bounds_check(const bcmbal_tm_queue_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_queue_cfg_id *failed_prop);

/** Initializes a bcmbal_tm_queue_stat_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_tm_queue_stat_data_set_default(bcmbal_tm_queue_stat_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_tm_queue_stat_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_stat_data_pack(const bcmbal_tm_queue_stat_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_tm_queue_stat_data would occupy on 
 * the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_queue_stat_data_get_packed_length(const bcmbal_tm_queue_stat_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_tm_queue_stat_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_stat_data_unpack(bcmbal_tm_queue_stat_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_tm_queue_stat_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_queue_stat_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_tm_queue_stat_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_stat_data_bounds_check(const bcmbal_tm_queue_stat_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_queue_stat_id *failed_prop);

/** Initializes a bcmbal_tm_queue_ind_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_tm_queue_ind_data_set_default(bcmbal_tm_queue_ind_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_tm_queue_ind_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_ind_data_pack(const bcmbal_tm_queue_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_tm_queue_ind_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_queue_ind_data_get_packed_length(const bcmbal_tm_queue_ind_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_tm_queue_ind_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_ind_data_unpack(bcmbal_tm_queue_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_tm_queue_ind_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_queue_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_tm_queue_ind_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_queue_ind_data_bounds_check(const bcmbal_tm_queue_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_queue_ind_id *failed_prop);

/** Initializes a bcmbal_tm_sched_key struct.  This sets all fields to default 
 * values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_tm_sched_key_set_default(bcmbal_tm_sched_key *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_tm_sched_key to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_key_pack(const bcmbal_tm_sched_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_tm_sched_key would occupy on the wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_sched_key_get_packed_length(const bcmbal_tm_sched_key *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_tm_sched_key from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_key_unpack(bcmbal_tm_sched_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_tm_sched_key struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_sched_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_tm_sched_key is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_key_bounds_check(const bcmbal_tm_sched_key *this, bcmbal_presence_mask fields_present, bcmbal_tm_sched_key_id *failed_prop);

/** Initializes a bcmbal_tm_sched_cfg_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_tm_sched_cfg_data_set_default(bcmbal_tm_sched_cfg_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_tm_sched_cfg_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_cfg_data_pack(const bcmbal_tm_sched_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_tm_sched_cfg_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_sched_cfg_data_get_packed_length(const bcmbal_tm_sched_cfg_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_tm_sched_cfg_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_cfg_data_unpack(bcmbal_tm_sched_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_tm_sched_cfg_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_sched_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_tm_sched_cfg_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_cfg_data_bounds_check(const bcmbal_tm_sched_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_sched_cfg_id *failed_prop);

/** Initializes a bcmbal_tm_sched_ind_data struct.  This sets all fields to 
 * default values. 
 *
 * \param this Pointer to the structure 
 * \param fields_present Bitmask of which fields are present in the structure. 
 */
void bcmbal_tm_sched_ind_data_set_default(bcmbal_tm_sched_ind_data *this, bcmbal_presence_mask fields_present);

/** Packs a bcmbal_tm_sched_ind_data to bytes 
 *
 * \param this Pointer to the object to pack 
 * \param buf Pointer to the buffer to write to 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the pack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_ind_data_pack(const bcmbal_tm_sched_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present);

/** Gets the number of bytes that a bcmbal_tm_sched_ind_data would occupy on the 
 * wire 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return The structure size in bytes 
 */
uint32_t bcmbal_tm_sched_ind_data_get_packed_length(const bcmbal_tm_sched_ind_data *this, bcmbal_presence_mask fields_present);

/** Unpacks a bcmbal_tm_sched_ind_data from bytes 
 *
 * \param this Pointer to the object to unpack 
 * \param buf Pointer to the buffer to read from 
 * \param extra_mem Pointer to the first location in memory to use to store 
 * pointer fields that are NULL.  Setting this to NULL will cause an error when 
 * a NULL pointer is encountered. 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE if the unpack was successful, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_ind_data_unpack(bcmbal_tm_sched_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present);

/** Scans past a packed bcmbal_tm_sched_ind_data struct and collects memory 
 * requirements above and beyond sizeof() 
 *
 * \param packed A stream pointing to the packed byte stream 
 * \param extra_mem Number of additional storage bytes required 
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \return TRUE on success, FALSE on failure 
 */
bcmos_bool bcmbal_tm_sched_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present);

/** Checks if any field in the bcmbal_tm_sched_ind_data is out of bounds 
 *
 * \param fields_present Bitmask of which fields are present in the structure. 
 * \param failed_prop Reference to the property that was out of range (only set 
 * on failure) 
 * \return TRUE if all fields are in the correct range, FALSE otherwise 
 */
bcmos_bool bcmbal_tm_sched_ind_data_bounds_check(const bcmbal_tm_sched_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_sched_ind_id *failed_prop);
#endif /* BAL_MODEL_FUNCS */
