#include <bcmos_system.h>
#include "bal_model_funcs.h"

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_cfg_id_pack(bcmbal_access_terminal_cfg_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_cfg_id_unpack(bcmbal_access_terminal_cfg_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_ind_id_pack(bcmbal_access_terminal_ind_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_ind_id_unpack(bcmbal_access_terminal_ind_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_key_id_pack(bcmbal_access_terminal_key_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_key_id_unpack(bcmbal_access_terminal_key_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_action_id_pack(bcmbal_action_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u64(buf, (uint64_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_action_id_unpack(bcmbal_action_id *this, bcmbal_buf *buf)
{
    uint64_t num_val;
    if (!bcmbal_buf_read_u64(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_action_cmd_id_pack(bcmbal_action_cmd_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_action_cmd_id_unpack(bcmbal_action_cmd_id *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_classifier_id_pack(bcmbal_classifier_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u64(buf, (uint64_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_classifier_id_unpack(bcmbal_classifier_id *this, bcmbal_buf *buf)
{
    uint64_t num_val;
    if (!bcmbal_buf_read_u64(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_pkt_tag_type_pack(bcmbal_pkt_tag_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_pkt_tag_type_unpack(bcmbal_pkt_tag_type *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_control_pack(bcmbal_control this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_control_unpack(bcmbal_control *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_dest_type_pack(bcmbal_dest_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_dest_type_unpack(bcmbal_dest_type *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_ds_miss_mode_pack(bcmbal_ds_miss_mode this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_ds_miss_mode_unpack(bcmbal_ds_miss_mode *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_extra_bw_eligibility_type_pack(bcmbal_extra_bw_eligibility_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_extra_bw_eligibility_type_unpack(bcmbal_extra_bw_eligibility_type *this, bcmbal_buf *buf)
{
    uint8_t num_val;
    if (!bcmbal_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_cfg_id_pack(bcmbal_flow_cfg_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_flow_cfg_id_unpack(bcmbal_flow_cfg_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_ind_id_pack(bcmbal_flow_ind_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_flow_ind_id_unpack(bcmbal_flow_ind_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_key_id_pack(bcmbal_flow_key_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_flow_key_id_unpack(bcmbal_flow_key_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_stat_id_pack(bcmbal_flow_stat_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_flow_stat_id_unpack(bcmbal_flow_stat_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_type_pack(bcmbal_flow_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_flow_type_unpack(bcmbal_flow_type *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_cfg_id_pack(bcmbal_group_cfg_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_group_cfg_id_unpack(bcmbal_group_cfg_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_key_id_pack(bcmbal_group_key_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_group_key_id_unpack(bcmbal_group_key_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_cmd_pack(bcmbal_group_member_cmd this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_cmd_unpack(bcmbal_group_member_cmd *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_owner_pack(bcmbal_group_owner this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_group_owner_unpack(bcmbal_group_owner *this, bcmbal_buf *buf)
{
    uint8_t num_val;
    if (!bcmbal_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_cfg_id_pack(bcmbal_interface_cfg_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_interface_cfg_id_unpack(bcmbal_interface_cfg_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_ind_id_pack(bcmbal_interface_ind_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_interface_ind_id_unpack(bcmbal_interface_ind_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_key_id_pack(bcmbal_interface_key_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_interface_key_id_unpack(bcmbal_interface_key_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_stat_id_pack(bcmbal_interface_stat_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_interface_stat_id_unpack(bcmbal_interface_stat_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_intf_type_pack(bcmbal_intf_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_intf_type_unpack(bcmbal_intf_type *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_iwf_mode_pack(bcmbal_iwf_mode this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_iwf_mode_unpack(bcmbal_iwf_mode *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_cfg_id_pack(bcmbal_packet_cfg_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_packet_cfg_id_unpack(bcmbal_packet_cfg_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_ind_id_pack(bcmbal_packet_ind_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_packet_ind_id_unpack(bcmbal_packet_ind_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_key_id_pack(bcmbal_packet_key_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_packet_key_id_unpack(bcmbal_packet_key_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_sla_id_pack(bcmbal_sla_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u64(buf, (uint64_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_sla_id_unpack(bcmbal_sla_id *this, bcmbal_buf *buf)
{
    uint64_t num_val;
    if (!bcmbal_buf_read_u64(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_state_pack(bcmbal_state this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_state_unpack(bcmbal_state *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_status_pack(bcmbal_status this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_status_unpack(bcmbal_status *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_cfg_id_pack(bcmbal_subscriber_terminal_cfg_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_cfg_id_unpack(bcmbal_subscriber_terminal_cfg_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_ind_id_pack(bcmbal_subscriber_terminal_ind_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_ind_id_unpack(bcmbal_subscriber_terminal_ind_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_key_id_pack(bcmbal_subscriber_terminal_key_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_key_id_unpack(bcmbal_subscriber_terminal_key_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_stat_id_pack(bcmbal_subscriber_terminal_stat_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_stat_id_unpack(bcmbal_subscriber_terminal_stat_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_bac_type_pack(bcmbal_tm_bac_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_bac_type_unpack(bcmbal_tm_bac_type *this, bcmbal_buf *buf)
{
    uint8_t num_val;
    if (!bcmbal_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_creation_mode_pack(bcmbal_tm_creation_mode this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_creation_mode_unpack(bcmbal_tm_creation_mode *this, bcmbal_buf *buf)
{
    uint8_t num_val;
    if (!bcmbal_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_cfg_id_pack(bcmbal_tm_queue_cfg_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_cfg_id_unpack(bcmbal_tm_queue_cfg_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ind_id_pack(bcmbal_tm_queue_ind_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ind_id_unpack(bcmbal_tm_queue_ind_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_key_id_pack(bcmbal_tm_queue_key_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_key_id_unpack(bcmbal_tm_queue_key_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_stat_id_pack(bcmbal_tm_queue_stat_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_stat_id_unpack(bcmbal_tm_queue_stat_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_cfg_id_pack(bcmbal_tm_sched_cfg_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_cfg_id_unpack(bcmbal_tm_sched_cfg_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_child_type_pack(bcmbal_tm_sched_child_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_child_type_unpack(bcmbal_tm_sched_child_type *this, bcmbal_buf *buf)
{
    uint8_t num_val;
    if (!bcmbal_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_dir_pack(bcmbal_tm_sched_dir this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_dir_unpack(bcmbal_tm_sched_dir *this, bcmbal_buf *buf)
{
    uint8_t num_val;
    if (!bcmbal_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_ind_id_pack(bcmbal_tm_sched_ind_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_ind_id_unpack(bcmbal_tm_sched_ind_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_key_id_pack(bcmbal_tm_sched_key_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u16(buf, (uint16_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_key_id_unpack(bcmbal_tm_sched_key_id *this, bcmbal_buf *buf)
{
    uint16_t num_val;
    if (!bcmbal_buf_read_u16(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_owner_type_pack(bcmbal_tm_sched_owner_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_owner_type_unpack(bcmbal_tm_sched_owner_type *this, bcmbal_buf *buf)
{
    uint8_t num_val;
    if (!bcmbal_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_owner_agg_port_id_pack(bcmbal_tm_sched_owner_agg_port_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u64(buf, (uint64_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_owner_agg_port_id_unpack(bcmbal_tm_sched_owner_agg_port_id *this, bcmbal_buf *buf)
{
    uint64_t num_val;
    if (!bcmbal_buf_read_u64(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_parent_id_pack(bcmbal_tm_sched_parent_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u64(buf, (uint64_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_parent_id_unpack(bcmbal_tm_sched_parent_id *this, bcmbal_buf *buf)
{
    uint64_t num_val;
    if (!bcmbal_buf_read_u64(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_type_pack(bcmbal_tm_sched_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u8(buf, (uint8_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_type_unpack(bcmbal_tm_sched_type *this, bcmbal_buf *buf)
{
    uint8_t num_val;
    if (!bcmbal_buf_read_u8(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_shaping_id_pack(bcmbal_tm_shaping_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u64(buf, (uint64_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_shaping_id_unpack(bcmbal_tm_shaping_id *this, bcmbal_buf *buf)
{
    uint64_t num_val;
    if (!bcmbal_buf_read_u64(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_tcont_sla_id_pack(bcmbal_tm_tcont_sla_id this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u64(buf, (uint64_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_tcont_sla_id_unpack(bcmbal_tm_tcont_sla_id *this, bcmbal_buf *buf)
{
    uint64_t num_val;
    if (!bcmbal_buf_read_u64(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_trx_type_pack(bcmbal_trx_type this, bcmbal_buf *buf)
{
    return bcmbal_buf_write_u32(buf, (uint32_t) this);
}

/******************************************************************************/
bcmos_bool bcmbal_trx_type_unpack(bcmbal_trx_type *this, bcmbal_buf *buf)
{
    uint32_t num_val;
    if (!bcmbal_buf_read_u32(buf, &num_val))
    {
        return BCMOS_FALSE;
    }

    *this = num_val;
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_action_set_default(bcmbal_action *this)
{
    this->presence_mask = (bcmbal_action_id) 0;
    this->cmds_bitmask = (bcmbal_action_cmd_id) 0;
    this->o_vid = 0;
    this->o_pbits = 0;
    this->o_tpid = 0;
    this->i_vid = 0;
    this->i_pbits = 0;
    this->i_tpid = 0;
}

/******************************************************************************/
bcmos_bool bcmbal_action_pack(const bcmbal_action *this, bcmbal_buf *buf)
{
    if (!bcmbal_action_id_pack(this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_action_cmd_id_pack(this->cmds_bitmask, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_write_u16(buf, this->o_vid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_write_u8(buf, this->o_pbits))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0008) == 0x0008))
    {
        if (!bcmbal_buf_write_u16(buf, this->o_tpid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0010) == 0x0010))
    {
        if (!bcmbal_buf_write_u16(buf, this->i_vid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0020) == 0x0020))
    {
        if (!bcmbal_buf_write_u8(buf, this->i_pbits))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0040) == 0x0040))
    {
        if (!bcmbal_buf_write_u16(buf, this->i_tpid))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_action_get_packed_length(const bcmbal_action *this)
{
    uint32_t count = 8;
    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        count += 4;
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0008) == 0x0008))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x0010) == 0x0010))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x0020) == 0x0020))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0040) == 0x0040))
    {
        count += 2;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_action_unpack(bcmbal_action *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_action_id_unpack(&this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_action_cmd_id_unpack(&this->cmds_bitmask, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_read_u16(buf, &this->o_vid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_read_u8(buf, &this->o_pbits))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0008) == 0x0008))
    {
        if (!bcmbal_buf_read_u16(buf, &this->o_tpid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0010) == 0x0010))
    {
        if (!bcmbal_buf_read_u16(buf, &this->i_vid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0020) == 0x0020))
    {
        if (!bcmbal_buf_read_u8(buf, &this->i_pbits))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0040) == 0x0040))
    {
        if (!bcmbal_buf_read_u16(buf, &this->i_tpid))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_action_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    bcmbal_action_id presence_mask;
    if (!bcmbal_action_id_unpack(&presence_mask, packed))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0008) == 0x0008))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0010) == 0x0010))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0020) == 0x0020))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0040) == 0x0040))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_action_bounds_check(const bcmbal_action *this)
{
    if ((this->presence_mask & 0xFFFFFFFFFFFFFF80ULL) != 0)
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if ((this->cmds_bitmask & 0xFFFFE000UL) != 0)
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_aggregation_port_id_list_u8_set_default(bcmbal_aggregation_port_id_list_u8 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmbal_aggregation_port_id_list_u8_pack(const bcmbal_aggregation_port_id_list_u8 *this, bcmbal_buf *buf)
{
    uint8_t i0;
    if (!bcmbal_buf_write_u8(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_aggregation_port_id_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_write_u16(buf, (uint16_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_aggregation_port_id_list_u8_get_packed_length(const bcmbal_aggregation_port_id_list_u8 *this)
{
    return 1 + (2 * this->len);
}

/******************************************************************************/
bcmos_bool bcmbal_aggregation_port_id_list_u8_unpack(bcmbal_aggregation_port_id_list_u8 *this, bcmbal_buf *buf, void **extra_mem)
{
    uint8_t i0;
    if (!bcmbal_buf_read_u8(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_aggregation_port_id_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmbal_aggregation_port_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmbal_aggregation_port_id));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_aggregation_port_id_list_u8_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    uint8_t len;
    if (!bcmbal_buf_read_u8(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmbal_aggregation_port_id) * len);
    if (!bcmbal_buf_skip(packed, len * 2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_aggregation_port_id_list_u8_bounds_check(const bcmbal_aggregation_port_id_list_u8 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_classifier_set_default(bcmbal_classifier *this)
{
    this->presence_mask = (bcmbal_classifier_id) 0;
    this->o_tpid = 0;
    this->o_vid = 0;
    this->i_tpid = 0;
    this->i_vid = 0;
    this->o_pbits = 0;
    this->i_pbits = 0;
    this->ether_type = 0;
    bcmos_mac_address_init(&this->dst_mac);
    bcmos_mac_address_init(&this->src_mac);
    this->ip_proto = 0;
    bcmos_ipv4_address_init(&this->dst_ip);
    bcmos_ipv4_address_init(&this->src_ip);
    this->src_port = 0;
    this->dst_port = 0;
    this->pkt_tag_type = (bcmbal_pkt_tag_type) 0;
}

/******************************************************************************/
bcmos_bool bcmbal_classifier_pack(const bcmbal_classifier *this, bcmbal_buf *buf)
{
    if (!bcmbal_classifier_id_pack(this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_write_u16(buf, this->o_tpid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_write_u16(buf, this->o_vid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_write_u16(buf, this->i_tpid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0008) == 0x0008))
    {
        if (!bcmbal_buf_write_u16(buf, this->i_vid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0010) == 0x0010))
    {
        if (!bcmbal_buf_write_u8(buf, this->o_pbits))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0020) == 0x0020))
    {
        if (!bcmbal_buf_write_u8(buf, this->i_pbits))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0040) == 0x0040))
    {
        if (!bcmbal_buf_write_u16(buf, this->ether_type))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0080) == 0x0080))
    {
        if (!bcmbal_buf_write_mac_address(buf, this->dst_mac))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0100) == 0x0100))
    {
        if (!bcmbal_buf_write_mac_address(buf, this->src_mac))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0200) == 0x0200))
    {
        if (!bcmbal_buf_write_u8(buf, this->ip_proto))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0400) == 0x0400))
    {
        if (!bcmbal_buf_write_ipv4_address(buf, this->dst_ip))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0800) == 0x0800))
    {
        if (!bcmbal_buf_write_ipv4_address(buf, this->src_ip))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x1000) == 0x1000))
    {
        if (!bcmbal_buf_write_u16(buf, this->src_port))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x2000) == 0x2000))
    {
        if (!bcmbal_buf_write_u16(buf, this->dst_port))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x4000) == 0x4000))
    {
        if (!bcmbal_pkt_tag_type_pack(this->pkt_tag_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_classifier_get_packed_length(const bcmbal_classifier *this)
{
    uint32_t count = 8;
    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x0008) == 0x0008))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x0010) == 0x0010))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0020) == 0x0020))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0040) == 0x0040))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x0080) == 0x0080))
    {
        count += 6;
    }

    if ((((uint64_t) this->presence_mask & 0x0100) == 0x0100))
    {
        count += 6;
    }

    if ((((uint64_t) this->presence_mask & 0x0200) == 0x0200))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0400) == 0x0400))
    {
        count += 4;
    }

    if ((((uint64_t) this->presence_mask & 0x0800) == 0x0800))
    {
        count += 4;
    }

    if ((((uint64_t) this->presence_mask & 0x1000) == 0x1000))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x2000) == 0x2000))
    {
        count += 2;
    }

    if ((((uint64_t) this->presence_mask & 0x4000) == 0x4000))
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_classifier_unpack(bcmbal_classifier *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_classifier_id_unpack(&this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_read_u16(buf, &this->o_tpid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_read_u16(buf, &this->o_vid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_read_u16(buf, &this->i_tpid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0008) == 0x0008))
    {
        if (!bcmbal_buf_read_u16(buf, &this->i_vid))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0010) == 0x0010))
    {
        if (!bcmbal_buf_read_u8(buf, &this->o_pbits))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0020) == 0x0020))
    {
        if (!bcmbal_buf_read_u8(buf, &this->i_pbits))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0040) == 0x0040))
    {
        if (!bcmbal_buf_read_u16(buf, &this->ether_type))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0080) == 0x0080))
    {
        if (!bcmbal_buf_read_mac_address(buf, &this->dst_mac))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0100) == 0x0100))
    {
        if (!bcmbal_buf_read_mac_address(buf, &this->src_mac))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0200) == 0x0200))
    {
        if (!bcmbal_buf_read_u8(buf, &this->ip_proto))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0400) == 0x0400))
    {
        if (!bcmbal_buf_read_ipv4_address(buf, &this->dst_ip))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0800) == 0x0800))
    {
        if (!bcmbal_buf_read_ipv4_address(buf, &this->src_ip))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x1000) == 0x1000))
    {
        if (!bcmbal_buf_read_u16(buf, &this->src_port))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x2000) == 0x2000))
    {
        if (!bcmbal_buf_read_u16(buf, &this->dst_port))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x4000) == 0x4000))
    {
        if (!bcmbal_pkt_tag_type_unpack(&this->pkt_tag_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_classifier_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    bcmbal_classifier_id presence_mask;
    if (!bcmbal_classifier_id_unpack(&presence_mask, packed))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0008) == 0x0008))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0010) == 0x0010))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0020) == 0x0020))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0040) == 0x0040))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0080) == 0x0080))
    {
        if (!bcmbal_buf_skip(packed, 6))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0100) == 0x0100))
    {
        if (!bcmbal_buf_skip(packed, 6))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0200) == 0x0200))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0400) == 0x0400))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0800) == 0x0800))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x1000) == 0x1000))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x2000) == 0x2000))
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x4000) == 0x4000))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_classifier_bounds_check(const bcmbal_classifier *this)
{
    if ((this->presence_mask & 0xFFFFFFFFFFFF8000ULL) != 0)
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x4000) == 0x4000))
    {
        if ((this->pkt_tag_type & 0xFFFFFFF8UL) != 0)
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_dest_set_default(bcmbal_dest *this)
{
    this->type = (bcmbal_dest_type) 0;
}

/******************************************************************************/
bcmos_bool bcmbal_dest_pack(const bcmbal_dest *this, bcmbal_buf *buf)
{
    if (!bcmbal_dest_type_pack(this->type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->type)
    {
        case BCMBAL_DEST_TYPE_NNI:
            {
                if (!bcmbal_buf_write_u32(buf, (uint32_t) this->u.nni.int_id))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_DEST_TYPE_SUB_TERM:
            {
                if (!bcmbal_buf_write_u32(buf, (uint32_t) this->u.sub_term.sub_term_id))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_write_u16(buf, this->u.sub_term.sub_term_uni))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_write_u16(buf, this->u.sub_term.int_id))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_DEST_TYPE_HOST:
            {
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_dest_get_packed_length(const bcmbal_dest *this)
{
    uint32_t count = 4;
    switch (this->type)
    {
        case BCMBAL_DEST_TYPE_NNI:
            {
                count += 4;
            }
            break;
        case BCMBAL_DEST_TYPE_SUB_TERM:
            {
                count += 8;
            }
            break;
        case BCMBAL_DEST_TYPE_HOST:
            {
            }
            break;
        default:
            break;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_dest_unpack(bcmbal_dest *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_dest_type_unpack(&this->type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->type)
    {
        case BCMBAL_DEST_TYPE_NNI:
            {
                if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->u.nni.int_id))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_DEST_TYPE_SUB_TERM:
            {
                if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->u.sub_term.sub_term_id))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_read_u16(buf, &this->u.sub_term.sub_term_uni))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_read_u16(buf, &this->u.sub_term.int_id))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_DEST_TYPE_HOST:
            {
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_dest_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    bcmbal_dest_type type;
    if (!bcmbal_dest_type_unpack(&type, packed))
    {
        return BCMOS_FALSE;
    }

    switch (type)
    {
        case BCMBAL_DEST_TYPE_NNI:
            {
                if (!bcmbal_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_DEST_TYPE_SUB_TERM:
            {
                if (!bcmbal_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_skip(packed, 2))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_skip(packed, 2))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_DEST_TYPE_HOST:
            {
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_dest_bounds_check(const bcmbal_dest *this)
{
    switch (this->type)
    {
        case BCMBAL_DEST_TYPE_NNI:
            {
            }
            break;
        case BCMBAL_DEST_TYPE_SUB_TERM:
            {
            }
            break;
        case BCMBAL_DEST_TYPE_HOST:
            {
            }
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_flow_id_list_u32_set_default(bcmbal_flow_id_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_id_list_u32_pack(const bcmbal_flow_id_list_u32 *this, bcmbal_buf *buf)
{
    uint32_t i0;
    if (!bcmbal_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_flow_id_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_flow_id_list_u32_get_packed_length(const bcmbal_flow_id_list_u32 *this)
{
    return 4 + (4 * this->len);
}

/******************************************************************************/
bcmos_bool bcmbal_flow_id_list_u32_unpack(bcmbal_flow_id_list_u32 *this, bcmbal_buf *buf, void **extra_mem)
{
    uint32_t i0;
    if (!bcmbal_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_flow_id_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmbal_flow_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmbal_flow_id));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_id_list_u32_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmbal_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmbal_flow_id) * len);
    if (!bcmbal_buf_skip(packed, len * 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_id_list_u32_bounds_check(const bcmbal_flow_id_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_queue_ref_set_default(bcmbal_tm_queue_ref *this)
{
    this->sched_id = (bcmbal_tm_sched_id) 0;
    this->queue_id = (bcmbal_tm_queue_id) 0;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ref_pack(const bcmbal_tm_queue_ref *this, bcmbal_buf *buf)
{
    if (!bcmbal_buf_write_u32(buf, (uint32_t) this->sched_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_write_u8(buf, (uint8_t) this->queue_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ref_unpack(bcmbal_tm_queue_ref *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->sched_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->queue_id))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ref_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmbal_buf_skip(packed, 5);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ref_bounds_check(const bcmbal_tm_queue_ref *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_group_member_info_set_default(bcmbal_group_member_info *this)
{
    this->intf_id = (bcmbal_intf_id) 0;
    this->svc_port_id = (bcmbal_service_port_id) 0;
    this->action.presence_mask = (bcmbal_action_id) 0;
    this->action.cmds_bitmask = (bcmbal_action_cmd_id) 0;
    this->action.o_vid = 0;
    this->action.o_pbits = 0;
    this->action.o_tpid = 0;
    this->action.i_vid = 0;
    this->action.i_pbits = 0;
    this->action.i_tpid = 0;
    this->queue.sched_id = (bcmbal_tm_sched_id) 0;
    this->queue.queue_id = (bcmbal_tm_queue_id) 0;
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_info_pack(const bcmbal_group_member_info *this, bcmbal_buf *buf)
{
    if (!bcmbal_buf_write_u32(buf, (uint32_t) this->intf_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_write_u16(buf, (uint16_t) this->svc_port_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_action_pack(&this->action, buf))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_tm_queue_ref_pack(&this->queue, buf))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_group_member_info_get_packed_length(const bcmbal_group_member_info *this)
{
    return 11 + bcmbal_action_get_packed_length(&this->action);
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_info_unpack(bcmbal_group_member_info *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->intf_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->svc_port_id))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_action_unpack(&this->action, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_tm_queue_ref_unpack(&this->queue, buf, extra_mem))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_info_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    if (!bcmbal_buf_skip(packed, 4))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_skip(packed, 2))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_action_scan(packed, extra_mem))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_skip(packed, 5))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_info_bounds_check(const bcmbal_group_member_info *this)
{
    if (!bcmbal_action_bounds_check(&this->action))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_tm_queue_ref_bounds_check(&this->queue))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_group_member_info_list_u16_set_default(bcmbal_group_member_info_list_u16 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_info_list_u16_pack(const bcmbal_group_member_info_list_u16 *this, bcmbal_buf *buf)
{
    uint16_t i0;
    if (!bcmbal_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_group_member_info_list_u16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_group_member_info_pack(&this->val[i0], buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_group_member_info_list_u16_get_packed_length(const bcmbal_group_member_info_list_u16 *this)
{
    uint32_t count = 2;
    uint32_t i0;
    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"len\" of struct \"bcmbal_group_member_info_list_u16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return 0;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        count += bcmbal_group_member_info_get_packed_length(&this->val[i0]);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_info_list_u16_unpack(bcmbal_group_member_info_list_u16 *this, bcmbal_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmbal_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_group_member_info_list_u16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmbal_group_member_info *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmbal_group_member_info));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_group_member_info_unpack(&this->val[i0], buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_info_list_u16_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    uint16_t i0;
    if (!bcmbal_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmbal_group_member_info) * len);
    for (i0 = 0; i0 < len; i0++)
    {
        if (!bcmbal_group_member_info_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_member_info_list_u16_bounds_check(const bcmbal_group_member_info_list_u16 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_password_set_default(bcmbal_password *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmbal_password_pack(const bcmbal_password *this, bcmbal_buf *buf)
{
    if (!bcmbal_buf_write(buf, this->arr, 10))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_password_unpack(bcmbal_password *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_buf_read(buf, this->arr, 10))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_password_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmbal_buf_skip(packed, 10);
}

/******************************************************************************/
bcmos_bool bcmbal_password_bounds_check(const bcmbal_password *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_registration_id_set_default(bcmbal_registration_id *this)
{
    memset(this->arr, 0, sizeof(this->arr));
}

/******************************************************************************/
bcmos_bool bcmbal_registration_id_pack(const bcmbal_registration_id *this, bcmbal_buf *buf)
{
    if (!bcmbal_buf_write(buf, this->arr, 36))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_registration_id_unpack(bcmbal_registration_id *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_buf_read(buf, this->arr, 36))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_registration_id_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmbal_buf_skip(packed, 36);
}

/******************************************************************************/
bcmos_bool bcmbal_registration_id_bounds_check(const bcmbal_registration_id *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_serial_number_set_default(bcmbal_serial_number *this)
{
    memset(this->vendor_id, 0, sizeof(this->vendor_id));
    memset(this->vendor_specific, 0, sizeof(this->vendor_specific));
}

/******************************************************************************/
bcmos_bool bcmbal_serial_number_pack(const bcmbal_serial_number *this, bcmbal_buf *buf)
{
    if (!bcmbal_buf_write(buf, this->vendor_id, 4))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_write(buf, this->vendor_specific, 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_serial_number_unpack(bcmbal_serial_number *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_buf_read(buf, this->vendor_id, 4))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_read(buf, this->vendor_specific, 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_serial_number_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmbal_buf_skip(packed, 8);
}

/******************************************************************************/
bcmos_bool bcmbal_serial_number_bounds_check(const bcmbal_serial_number *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_service_port_id_list_u8_set_default(bcmbal_service_port_id_list_u8 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmbal_service_port_id_list_u8_pack(const bcmbal_service_port_id_list_u8 *this, bcmbal_buf *buf)
{
    uint8_t i0;
    if (!bcmbal_buf_write_u8(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_service_port_id_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_write_u16(buf, (uint16_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_service_port_id_list_u8_get_packed_length(const bcmbal_service_port_id_list_u8 *this)
{
    return 1 + (2 * this->len);
}

/******************************************************************************/
bcmos_bool bcmbal_service_port_id_list_u8_unpack(bcmbal_service_port_id_list_u8 *this, bcmbal_buf *buf, void **extra_mem)
{
    uint8_t i0;
    if (!bcmbal_buf_read_u8(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_service_port_id_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmbal_service_port_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmbal_service_port_id));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_service_port_id_list_u8_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    uint8_t len;
    if (!bcmbal_buf_read_u8(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmbal_service_port_id) * len);
    if (!bcmbal_buf_skip(packed, len * 2))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_service_port_id_list_u8_bounds_check(const bcmbal_service_port_id_list_u8 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_sla_set_default(bcmbal_sla *this)
{
    this->presence_mask = (bcmbal_sla_id) 0;
    this->min_rate = 0;
    this->max_rate = 0;
}

/******************************************************************************/
bcmos_bool bcmbal_sla_pack(const bcmbal_sla *this, bcmbal_buf *buf)
{
    if (!bcmbal_sla_id_pack(this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_write_u32(buf, this->min_rate))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_write_u32(buf, this->max_rate))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_sla_get_packed_length(const bcmbal_sla *this)
{
    uint32_t count = 8;
    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        count += 4;
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_sla_unpack(bcmbal_sla *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_sla_id_unpack(&this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_read_u32(buf, &this->min_rate))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_read_u32(buf, &this->max_rate))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_sla_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    bcmbal_sla_id presence_mask;
    if (!bcmbal_sla_id_unpack(&presence_mask, packed))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_sla_bounds_check(const bcmbal_sla *this)
{
    if ((this->presence_mask & 0xFFFFFFFFFFFFFFFCULL) != 0)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_sub_id_list_u16_set_default(bcmbal_sub_id_list_u16 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmbal_sub_id_list_u16_pack(const bcmbal_sub_id_list_u16 *this, bcmbal_buf *buf)
{
    uint16_t i0;
    if (!bcmbal_buf_write_u16(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_sub_id_list_u16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_sub_id_list_u16_get_packed_length(const bcmbal_sub_id_list_u16 *this)
{
    return 2 + (4 * this->len);
}

/******************************************************************************/
bcmos_bool bcmbal_sub_id_list_u16_unpack(bcmbal_sub_id_list_u16 *this, bcmbal_buf *buf, void **extra_mem)
{
    uint16_t i0;
    if (!bcmbal_buf_read_u16(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_sub_id_list_u16\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmbal_sub_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmbal_sub_id));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_sub_id_list_u16_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    uint16_t len;
    if (!bcmbal_buf_read_u16(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmbal_sub_id) * len);
    if (!bcmbal_buf_skip(packed, len * 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_sub_id_list_u16_bounds_check(const bcmbal_sub_id_list_u16 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_red_set_default(bcmbal_tm_red *this)
{
    this->min_threshold = (bcmbal_percent) 0;
    this->max_threshold = (bcmbal_percent) 0;
    this->max_probability = (bcmbal_percent) 0;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_red_pack(const bcmbal_tm_red *this, bcmbal_buf *buf)
{
    if (!bcmbal_buf_write_u8(buf, (uint8_t) this->min_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_write_u8(buf, (uint8_t) this->max_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_write_u8(buf, (uint8_t) this->max_probability))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_red_unpack(bcmbal_tm_red *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->min_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->max_threshold))
    {
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->max_probability))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_red_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    (void)extra_mem;
    return bcmbal_buf_skip(packed, 3);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_red_bounds_check(const bcmbal_tm_red *this)
{
    if (this->min_threshold > (bcmbal_percent) 100)
    {
        return BCMOS_FALSE;
    }

    if (this->max_threshold > (bcmbal_percent) 100)
    {
        return BCMOS_FALSE;
    }

    if (this->max_probability > (bcmbal_percent) 100)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_bac_set_default(bcmbal_tm_bac *this)
{
    this->type = (bcmbal_tm_bac_type) 0;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_bac_pack(const bcmbal_tm_bac *this, bcmbal_buf *buf)
{
    if (!bcmbal_tm_bac_type_pack(this->type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->type)
    {
        case BCMBAL_TM_BAC_TYPE_TAILDROP:
            {
                if (!bcmbal_buf_write_u32(buf, this->u.taildrop.max_size))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_RED:
            {
                if (!bcmbal_tm_red_pack(&this->u.red.red, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WRED:
            {
                if (!bcmbal_tm_red_pack(&this->u.wred.green, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_tm_red_pack(&this->u.wred.yellow, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_tm_red_pack(&this->u.wred.red, buf))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WTAILDROP:
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_bac_get_packed_length(const bcmbal_tm_bac *this)
{
    uint32_t count = 1;
    switch (this->type)
    {
        case BCMBAL_TM_BAC_TYPE_TAILDROP:
            {
                count += 4;
            }
            break;
        case BCMBAL_TM_BAC_TYPE_RED:
            {
                count += 3;
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WRED:
            {
                count += 9;
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WTAILDROP:
        default:
            break;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_bac_unpack(bcmbal_tm_bac *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_tm_bac_type_unpack(&this->type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->type)
    {
        case BCMBAL_TM_BAC_TYPE_TAILDROP:
            {
                if (!bcmbal_buf_read_u32(buf, &this->u.taildrop.max_size))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_RED:
            {
                if (!bcmbal_tm_red_unpack(&this->u.red.red, buf, extra_mem))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WRED:
            {
                if (!bcmbal_tm_red_unpack(&this->u.wred.green, buf, extra_mem))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_tm_red_unpack(&this->u.wred.yellow, buf, extra_mem))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_tm_red_unpack(&this->u.wred.red, buf, extra_mem))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WTAILDROP:
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_bac_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    bcmbal_tm_bac_type type;
    if (!bcmbal_tm_bac_type_unpack(&type, packed))
    {
        return BCMOS_FALSE;
    }

    switch (type)
    {
        case BCMBAL_TM_BAC_TYPE_TAILDROP:
            {
                if (!bcmbal_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_RED:
            {
                if (!bcmbal_buf_skip(packed, 3))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WRED:
            {
                if (!bcmbal_buf_skip(packed, 3))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_skip(packed, 3))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_skip(packed, 3))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WTAILDROP:
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_bac_bounds_check(const bcmbal_tm_bac *this)
{
    switch (this->type)
    {
        case BCMBAL_TM_BAC_TYPE_TAILDROP:
            {
            }
            break;
        case BCMBAL_TM_BAC_TYPE_RED:
            {
                if (!bcmbal_tm_red_bounds_check(&this->u.red.red))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WRED:
            {
                if (!bcmbal_tm_red_bounds_check(&this->u.wred.green))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_tm_red_bounds_check(&this->u.wred.yellow))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_tm_red_bounds_check(&this->u.wred.red))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_BAC_TYPE_WTAILDROP:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_queue_id_list_u8_set_default(bcmbal_tm_queue_id_list_u8 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_id_list_u8_pack(const bcmbal_tm_queue_id_list_u8 *this, bcmbal_buf *buf)
{
    uint8_t i0;
    if (!bcmbal_buf_write_u8(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_tm_queue_id_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_write_u8(buf, (uint8_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_queue_id_list_u8_get_packed_length(const bcmbal_tm_queue_id_list_u8 *this)
{
    return 1 + this->len;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_id_list_u8_unpack(bcmbal_tm_queue_id_list_u8 *this, bcmbal_buf *buf, void **extra_mem)
{
    uint8_t i0;
    if (!bcmbal_buf_read_u8(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_tm_queue_id_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmbal_tm_queue_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmbal_tm_queue_id));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_id_list_u8_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    uint8_t len;
    if (!bcmbal_buf_read_u8(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmbal_tm_queue_id) * len);
    if (!bcmbal_buf_skip(packed, len * 1))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_id_list_u8_bounds_check(const bcmbal_tm_queue_id_list_u8 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_sched_id_list_u8_set_default(bcmbal_tm_sched_id_list_u8 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_id_list_u8_pack(const bcmbal_tm_sched_id_list_u8 *this, bcmbal_buf *buf)
{
    uint8_t i0;
    if (!bcmbal_buf_write_u8(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_tm_sched_id_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_sched_id_list_u8_get_packed_length(const bcmbal_tm_sched_id_list_u8 *this)
{
    return 1 + (4 * this->len);
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_id_list_u8_unpack(bcmbal_tm_sched_id_list_u8 *this, bcmbal_buf *buf, void **extra_mem)
{
    uint8_t i0;
    if (!bcmbal_buf_read_u8(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_tm_sched_id_list_u8\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (bcmbal_tm_sched_id *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(bcmbal_tm_sched_id));
        }
    }

    for (i0 = 0; i0 < this->len; i0++)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->val[i0]))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_id_list_u8_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    uint8_t len;
    if (!bcmbal_buf_read_u8(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(bcmbal_tm_sched_id) * len);
    if (!bcmbal_buf_skip(packed, len * 4))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_id_list_u8_bounds_check(const bcmbal_tm_sched_id_list_u8 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_sched_owner_set_default(bcmbal_tm_sched_owner *this)
{
    this->type = (bcmbal_tm_sched_owner_type) 0;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_owner_pack(const bcmbal_tm_sched_owner *this, bcmbal_buf *buf)
{
    if (!bcmbal_tm_sched_owner_type_pack(this->type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->type)
    {
        case BCMBAL_TM_SCHED_OWNER_TYPE_INTERFACE:
            {
                if (!bcmbal_intf_type_pack(this->u.interface.intf_type, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_write_u32(buf, (uint32_t) this->u.interface.intf_id))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_SUB_TERM:
            {
                if (!bcmbal_buf_write_u32(buf, (uint32_t) this->u.sub_term.intf_id))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_write_u32(buf, (uint32_t) this->u.sub_term.sub_term_id))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_AGG_PORT:
            {
                if (!bcmbal_tm_sched_owner_agg_port_id_pack(this->u.agg_port.presence_mask, buf))
                {
                    return BCMOS_FALSE;
                }

                if ((((uint64_t) this->u.agg_port.presence_mask & 0x0001) == 0x0001))
                {
                    if (!bcmbal_buf_write_u8(buf, this->u.agg_port.intf_id))
                    {
                        return BCMOS_FALSE;
                    }
                }

                if ((((uint64_t) this->u.agg_port.presence_mask & 0x0002) == 0x0002))
                {
                    if (!bcmbal_buf_write_u32(buf, (uint32_t) this->u.agg_port.sub_term_id))
                    {
                        return BCMOS_FALSE;
                    }
                }

                if ((((uint64_t) this->u.agg_port.presence_mask & 0x0004) == 0x0004))
                {
                    if (!bcmbal_buf_write_u16(buf, (uint16_t) this->u.agg_port.agg_port_id))
                    {
                        return BCMOS_FALSE;
                    }
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNI:
            {
                if (!bcmbal_buf_write_u8(buf, this->u.uni.intf_id))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_write_u32(buf, (uint32_t) this->u.uni.sub_term_id))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_write_u8(buf, this->u.uni.idx))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_VIRTUAL:
            {
                if (!bcmbal_buf_write_u32(buf, this->u.virtual.idx))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNDEFINED:
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_sched_owner_get_packed_length(const bcmbal_tm_sched_owner *this)
{
    uint32_t count = 1;
    switch (this->type)
    {
        case BCMBAL_TM_SCHED_OWNER_TYPE_INTERFACE:
            {
                count += 8;
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_SUB_TERM:
            {
                count += 8;
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_AGG_PORT:
            {
                count += 15;
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNI:
            {
                count += 6;
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_VIRTUAL:
            {
                count += 4;
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNDEFINED:
        default:
            break;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_owner_unpack(bcmbal_tm_sched_owner *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_tm_sched_owner_type_unpack(&this->type, buf))
    {
        return BCMOS_FALSE;
    }

    switch (this->type)
    {
        case BCMBAL_TM_SCHED_OWNER_TYPE_INTERFACE:
            {
                if (!bcmbal_intf_type_unpack(&this->u.interface.intf_type, buf))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->u.interface.intf_id))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_SUB_TERM:
            {
                if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->u.sub_term.intf_id))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->u.sub_term.sub_term_id))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_AGG_PORT:
            {
                if (!bcmbal_tm_sched_owner_agg_port_id_unpack(&this->u.agg_port.presence_mask, buf))
                {
                    return BCMOS_FALSE;
                }

                if ((((uint64_t) this->u.agg_port.presence_mask & 0x0001) == 0x0001))
                {
                    if (!bcmbal_buf_read_u8(buf, &this->u.agg_port.intf_id))
                    {
                        return BCMOS_FALSE;
                    }
                }

                if ((((uint64_t) this->u.agg_port.presence_mask & 0x0002) == 0x0002))
                {
                    if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->u.agg_port.sub_term_id))
                    {
                        return BCMOS_FALSE;
                    }
                }

                if ((((uint64_t) this->u.agg_port.presence_mask & 0x0004) == 0x0004))
                {
                    if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->u.agg_port.agg_port_id))
                    {
                        return BCMOS_FALSE;
                    }
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNI:
            {
                if (!bcmbal_buf_read_u8(buf, &this->u.uni.intf_id))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->u.uni.sub_term_id))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_read_u8(buf, &this->u.uni.idx))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_VIRTUAL:
            {
                if (!bcmbal_buf_read_u32(buf, &this->u.virtual.idx))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNDEFINED:
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_owner_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    bcmbal_tm_sched_owner_type type;
    if (!bcmbal_tm_sched_owner_type_unpack(&type, packed))
    {
        return BCMOS_FALSE;
    }

    switch (type)
    {
        case BCMBAL_TM_SCHED_OWNER_TYPE_INTERFACE:
            {
                if (!bcmbal_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_SUB_TERM:
            {
                if (!bcmbal_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_AGG_PORT:
            {
                bcmbal_tm_sched_owner_agg_port_id presence_mask;
                if (!bcmbal_tm_sched_owner_agg_port_id_unpack(&presence_mask, packed))
                {
                    return BCMOS_FALSE;
                }

                if ((((uint64_t) presence_mask & 0x0001) == 0x0001))
                {
                    if (!bcmbal_buf_skip(packed, 1))
                    {
                        return BCMOS_FALSE;
                    }
                }

                if ((((uint64_t) presence_mask & 0x0002) == 0x0002))
                {
                    if (!bcmbal_buf_skip(packed, 4))
                    {
                        return BCMOS_FALSE;
                    }
                }

                if ((((uint64_t) presence_mask & 0x0004) == 0x0004))
                {
                    if (!bcmbal_buf_skip(packed, 2))
                    {
                        return BCMOS_FALSE;
                    }
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNI:
            {
                if (!bcmbal_buf_skip(packed, 1))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }

                if (!bcmbal_buf_skip(packed, 1))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_VIRTUAL:
            {
                if (!bcmbal_buf_skip(packed, 4))
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNDEFINED:
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_owner_bounds_check(const bcmbal_tm_sched_owner *this)
{
    switch (this->type)
    {
        case BCMBAL_TM_SCHED_OWNER_TYPE_INTERFACE:
            {
                switch (this->u.interface.intf_type)
                {
                    case BCMBAL_INTF_TYPE_NNI:
                        break;
                    case BCMBAL_INTF_TYPE_PON:
                        break;
                    default:
                        return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_SUB_TERM:
            {
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_AGG_PORT:
            {
                if ((this->u.agg_port.presence_mask & 0xFFFFFFFFFFFFFFF8ULL) != 0)
                {
                    return BCMOS_FALSE;
                }
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNI:
            {
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_VIRTUAL:
            {
            }
            break;
        case BCMBAL_TM_SCHED_OWNER_TYPE_UNDEFINED:
            break;
        default:
            return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_sched_parent_set_default(bcmbal_tm_sched_parent *this)
{
    this->presence_mask = (bcmbal_tm_sched_parent_id) 0;
    this->sched_id = (bcmbal_tm_sched_id) 0;
    this->priority = (bcmbal_tm_priority) 0;
    this->weight = (bcmbal_tm_weight) 0;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_parent_pack(const bcmbal_tm_sched_parent *this, bcmbal_buf *buf)
{
    if (!bcmbal_tm_sched_parent_id_pack(this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->sched_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_write_u8(buf, (uint8_t) this->priority))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_write_u8(buf, (uint8_t) this->weight))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_sched_parent_get_packed_length(const bcmbal_tm_sched_parent *this)
{
    uint32_t count = 8;
    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        count += 4;
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_parent_unpack(bcmbal_tm_sched_parent *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_tm_sched_parent_id_unpack(&this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->sched_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->priority))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->weight))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_parent_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    bcmbal_tm_sched_parent_id presence_mask;
    if (!bcmbal_tm_sched_parent_id_unpack(&presence_mask, packed))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_parent_bounds_check(const bcmbal_tm_sched_parent *this)
{
    if ((this->presence_mask & 0xFFFFFFFFFFFFFFF8ULL) != 0)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_shaping_set_default(bcmbal_tm_shaping *this)
{
    this->presence_mask = (bcmbal_tm_shaping_id) 0;
    this->sbr = 0;
    this->pbr = 0;
    this->burst = 0;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_shaping_pack(const bcmbal_tm_shaping *this, bcmbal_buf *buf)
{
    if (!bcmbal_tm_shaping_id_pack(this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_write_u32(buf, this->sbr))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_write_u32(buf, this->pbr))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_write_u32(buf, this->burst))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_shaping_get_packed_length(const bcmbal_tm_shaping *this)
{
    uint32_t count = 8;
    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        count += 4;
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        count += 4;
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_shaping_unpack(bcmbal_tm_shaping *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_tm_shaping_id_unpack(&this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_read_u32(buf, &this->sbr))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_read_u32(buf, &this->pbr))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_read_u32(buf, &this->burst))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_shaping_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    bcmbal_tm_shaping_id presence_mask;
    if (!bcmbal_tm_shaping_id_unpack(&presence_mask, packed))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_shaping_bounds_check(const bcmbal_tm_shaping *this)
{
    if ((this->presence_mask & 0xFFFFFFFFFFFFFFF8ULL) != 0)
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_tcont_sla_set_default(bcmbal_tm_tcont_sla *this)
{
    this->presence_mask = (bcmbal_tm_tcont_sla_id) 0;
    this->extra_bw_elig = BCMBAL_EXTRA_BW_ELIGIBILITY_TYPE_NONE;
    this->nrt_cbr = 0;
    this->rt_cbr = 0;
    this->rt_profile = 0;
    this->nrt_profile = 0;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_tcont_sla_pack(const bcmbal_tm_tcont_sla *this, bcmbal_buf *buf)
{
    if (!bcmbal_tm_tcont_sla_id_pack(this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_extra_bw_eligibility_type_pack(this->extra_bw_elig, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_write_u8(buf, this->nrt_cbr))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_write_u8(buf, this->rt_cbr))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0008) == 0x0008))
    {
        if (!bcmbal_buf_write_u8(buf, this->rt_profile))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0010) == 0x0010))
    {
        if (!bcmbal_buf_write_u8(buf, this->nrt_profile))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_tcont_sla_get_packed_length(const bcmbal_tm_tcont_sla *this)
{
    uint32_t count = 8;
    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0008) == 0x0008))
    {
        count += 1;
    }

    if ((((uint64_t) this->presence_mask & 0x0010) == 0x0010))
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_tcont_sla_unpack(bcmbal_tm_tcont_sla *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_tm_tcont_sla_id_unpack(&this->presence_mask, buf))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_extra_bw_eligibility_type_unpack(&this->extra_bw_elig, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_read_u8(buf, &this->nrt_cbr))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_read_u8(buf, &this->rt_cbr))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0008) == 0x0008))
    {
        if (!bcmbal_buf_read_u8(buf, &this->rt_profile))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) this->presence_mask & 0x0010) == 0x0010))
    {
        if (!bcmbal_buf_read_u8(buf, &this->nrt_profile))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_tcont_sla_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    bcmbal_tm_tcont_sla_id presence_mask;
    if (!bcmbal_tm_tcont_sla_id_unpack(&presence_mask, packed))
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) presence_mask & 0x0001) == 0x0001))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0002) == 0x0002))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0004) == 0x0004))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0008) == 0x0008))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((((uint64_t) presence_mask & 0x0010) == 0x0010))
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_tcont_sla_bounds_check(const bcmbal_tm_tcont_sla *this)
{
    if ((this->presence_mask & 0xFFFFFFFFFFFFFFE0ULL) != 0)
    {
        return BCMOS_FALSE;
    }

    if ((((uint64_t) this->presence_mask & 0x0001) == 0x0001))
    {
        switch (this->extra_bw_elig)
        {
            case BCMBAL_EXTRA_BW_ELIGIBILITY_TYPE_NONE:
                break;
            case BCMBAL_EXTRA_BW_ELIGIBILITY_TYPE_NOT_ASSURED:
                break;
            case BCMBAL_EXTRA_BW_ELIGIBILITY_TYPE_BEST_EFFORT:
                break;
            default:
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_u8_list_u32_set_default(bcmbal_u8_list_u32 *this)
{
    this->len = 0;
    this->val = NULL;
}

/******************************************************************************/
bcmos_bool bcmbal_u8_list_u32_pack(const bcmbal_u8_list_u32 *this, bcmbal_buf *buf)
{
    if (!bcmbal_buf_write_u32(buf, this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_u8_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
        return BCMOS_FALSE;
    }

    if (!bcmbal_buf_write(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_u8_list_u32_get_packed_length(const bcmbal_u8_list_u32 *this)
{
    return 4 + this->len;
}

/******************************************************************************/
bcmos_bool bcmbal_u8_list_u32_unpack(bcmbal_u8_list_u32 *this, bcmbal_buf *buf, void **extra_mem)
{
    if (!bcmbal_buf_read_u32(buf, &this->len))
    {
        return BCMOS_FALSE;
    }

    if ((this->len > 0) && (this->val == NULL))
    {
        if (extra_mem == NULL)
        {
            bcmos_trace(BCMOS_TRACE_LEVEL_ERROR, "Error: list field \"val\" of struct \"bcmbal_u8_list_u32\" is uninitialized (NULL).  You must allocate memory for this pointer before sending/receiving the message.\n");
            return BCMOS_FALSE;
        }
        else
        {
            this->val = (uint8_t *) *extra_mem;
            *extra_mem = ((uint8_t *) *extra_mem) + BCMOS_ROUND_TO_WORD(this->len * sizeof(uint8_t));
        }
    }

    if (!bcmbal_buf_read(buf, this->val, this->len))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_u8_list_u32_scan(bcmbal_buf *packed, uint32_t *extra_mem)
{
    uint32_t len;
    if (!bcmbal_buf_read_u32(packed, &len))
    {
        return BCMOS_FALSE;
    }

    *extra_mem += BCMOS_ROUND_TO_WORD(sizeof(uint8_t) * len);
    if (!bcmbal_buf_skip(packed, len * 1))
    {
        return BCMOS_FALSE;
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_u8_list_u32_bounds_check(const bcmbal_u8_list_u32 *this)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_access_terminal_key_set_default(bcmbal_access_terminal_key *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID)) != 0)
    {
        this->access_term_id = (bcmbal_access_id) 1;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_key_pack(const bcmbal_access_terminal_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->access_term_id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_access_terminal_key_get_packed_length(const bcmbal_access_terminal_key *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_key_unpack(bcmbal_access_terminal_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->access_term_id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_key_bounds_check(const bcmbal_access_terminal_key *this, bcmbal_presence_mask fields_present, bcmbal_access_terminal_key_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID)) != 0)
    {
        if (this->access_term_id < (bcmbal_access_id) 1)
        {
            *failed_prop = BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID;
            return BCMOS_FALSE;
        }

        if (this->access_term_id > (bcmbal_access_id) 1)
        {
            *failed_prop = BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_access_terminal_cfg_data_set_default(bcmbal_access_terminal_cfg_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        this->admin_state = (bcmbal_state) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        this->oper_status = (bcmbal_status) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_IWF_MODE)) != 0)
    {
        this->iwf_mode = BCMBAL_IWF_MODE_DIRECT_MAPPING;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_cfg_data_pack(const bcmbal_access_terminal_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_pack(this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_pack(this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_IWF_MODE)) != 0)
    {
        if (!bcmbal_iwf_mode_pack(this->iwf_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_access_terminal_cfg_data_get_packed_length(const bcmbal_access_terminal_cfg_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_IWF_MODE)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_cfg_data_unpack(bcmbal_access_terminal_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_unpack(&this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_unpack(&this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_IWF_MODE)) != 0)
    {
        if (!bcmbal_iwf_mode_unpack(&this->iwf_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_IWF_MODE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_cfg_data_bounds_check(const bcmbal_access_terminal_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_access_terminal_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        switch (this->admin_state)
        {
            case BCMBAL_STATE_UP:
                break;
            case BCMBAL_STATE_DOWN:
                break;
            case BCMBAL_STATE_TESTING:
                break;
            default:
                *failed_prop = BCMBAL_ACCESS_TERMINAL_CFG_ID_ADMIN_STATE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        switch (this->oper_status)
        {
            case BCMBAL_STATUS_UP:
                break;
            case BCMBAL_STATUS_DOWN:
                break;
            case BCMBAL_STATUS_TESTING:
                break;
            case BCMBAL_STATUS_NOT_PRESENT:
                break;
            case BCMBAL_STATUS_LOWER_LAYER_DOWN:
                break;
            case BCMBAL_STATUS_UNKNOWN:
                break;
            default:
                *failed_prop = BCMBAL_ACCESS_TERMINAL_CFG_ID_OPER_STATUS;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_CFG_ID_IWF_MODE)) != 0)
    {
        switch (this->iwf_mode)
        {
            case BCMBAL_IWF_MODE_DIRECT_MAPPING:
                break;
            case BCMBAL_IWF_MODE_PER_FLOW:
                break;
            default:
                *failed_prop = BCMBAL_ACCESS_TERMINAL_CFG_ID_IWF_MODE;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_access_terminal_ind_data_set_default(bcmbal_access_terminal_ind_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        this->admin_state = (bcmbal_state) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        this->oper_status = (bcmbal_status) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_IWF_MODE)) != 0)
    {
        this->iwf_mode = BCMBAL_IWF_MODE_DIRECT_MAPPING;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_ind_data_pack(const bcmbal_access_terminal_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_pack(this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_pack(this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_IWF_MODE)) != 0)
    {
        if (!bcmbal_iwf_mode_pack(this->iwf_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_access_terminal_ind_data_get_packed_length(const bcmbal_access_terminal_ind_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_IWF_MODE)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_ind_data_unpack(bcmbal_access_terminal_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_unpack(&this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_unpack(&this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_IWF_MODE)) != 0)
    {
        if (!bcmbal_iwf_mode_unpack(&this->iwf_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_IWF_MODE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_access_terminal_ind_data_bounds_check(const bcmbal_access_terminal_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_access_terminal_ind_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        switch (this->admin_state)
        {
            case BCMBAL_STATE_UP:
                break;
            case BCMBAL_STATE_DOWN:
                break;
            case BCMBAL_STATE_TESTING:
                break;
            default:
                *failed_prop = BCMBAL_ACCESS_TERMINAL_IND_ID_ADMIN_STATE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        switch (this->oper_status)
        {
            case BCMBAL_STATUS_UP:
                break;
            case BCMBAL_STATUS_DOWN:
                break;
            case BCMBAL_STATUS_TESTING:
                break;
            case BCMBAL_STATUS_NOT_PRESENT:
                break;
            case BCMBAL_STATUS_LOWER_LAYER_DOWN:
                break;
            case BCMBAL_STATUS_UNKNOWN:
                break;
            default:
                *failed_prop = BCMBAL_ACCESS_TERMINAL_IND_ID_OPER_STATUS;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_ACCESS_TERMINAL_IND_ID_IWF_MODE)) != 0)
    {
        switch (this->iwf_mode)
        {
            case BCMBAL_IWF_MODE_DIRECT_MAPPING:
                break;
            case BCMBAL_IWF_MODE_PER_FLOW:
                break;
            default:
                *failed_prop = BCMBAL_ACCESS_TERMINAL_IND_ID_IWF_MODE;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_flow_key_set_default(bcmbal_flow_key *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_ID)) != 0)
    {
        this->flow_id = (bcmbal_flow_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_TYPE)) != 0)
    {
        this->flow_type = (bcmbal_flow_type) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_flow_key_pack(const bcmbal_flow_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->flow_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_TYPE)) != 0)
    {
        if (!bcmbal_flow_type_pack(this->flow_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_flow_key_get_packed_length(const bcmbal_flow_key *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_TYPE)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_key_unpack(bcmbal_flow_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->flow_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_TYPE)) != 0)
    {
        if (!bcmbal_flow_type_unpack(&this->flow_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_key_bounds_check(const bcmbal_flow_key *this, bcmbal_presence_mask fields_present, bcmbal_flow_key_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_KEY_ID_FLOW_TYPE)) != 0)
    {
        switch (this->flow_type)
        {
            case BCMBAL_FLOW_TYPE_UPSTREAM:
                break;
            case BCMBAL_FLOW_TYPE_DOWNSTREAM:
                break;
            case BCMBAL_FLOW_TYPE_BROADCAST:
                break;
            case BCMBAL_FLOW_TYPE_MULTICAST:
                break;
            default:
                *failed_prop = BCMBAL_FLOW_KEY_ID_FLOW_TYPE;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_flow_cfg_data_set_default(bcmbal_flow_cfg_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ADMIN_STATE)) != 0)
    {
        this->admin_state = (bcmbal_state) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_OPER_STATUS)) != 0)
    {
        this->oper_status = (bcmbal_status) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACCESS_INT_ID)) != 0)
    {
        this->access_int_id = (bcmbal_intf_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_NETWORK_INT_ID)) != 0)
    {
        this->network_int_id = (bcmbal_intf_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_ID)) != 0)
    {
        this->sub_term_id = (bcmbal_sub_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_UNI_IDX)) != 0)
    {
        this->sub_term_uni_idx = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SVC_PORT_ID)) != 0)
    {
        this->svc_port_id = (bcmbal_service_port_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_AGG_PORT_ID)) != 0)
    {
        this->agg_port_id = (bcmbal_aggregation_port_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_RESOLVE_MAC)) != 0)
    {
        this->resolve_mac = BCMOS_FALSE;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_CLASSIFIER)) != 0)
    {
        this->classifier.presence_mask = (bcmbal_classifier_id) 0;
        this->classifier.o_tpid = 0;
        this->classifier.o_vid = 0;
        this->classifier.i_tpid = 0;
        this->classifier.i_vid = 0;
        this->classifier.o_pbits = 0;
        this->classifier.i_pbits = 0;
        this->classifier.ether_type = 0;
        bcmos_mac_address_init(&this->classifier.dst_mac);
        bcmos_mac_address_init(&this->classifier.src_mac);
        this->classifier.ip_proto = 0;
        bcmos_ipv4_address_init(&this->classifier.dst_ip);
        bcmos_ipv4_address_init(&this->classifier.src_ip);
        this->classifier.src_port = 0;
        this->classifier.dst_port = 0;
        this->classifier.pkt_tag_type = (bcmbal_pkt_tag_type) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACTION)) != 0)
    {
        this->action.presence_mask = (bcmbal_action_id) 0;
        this->action.cmds_bitmask = (bcmbal_action_cmd_id) 0;
        this->action.o_vid = 0;
        this->action.o_pbits = 0;
        this->action.o_tpid = 0;
        this->action.i_vid = 0;
        this->action.i_pbits = 0;
        this->action.i_tpid = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SLA)) != 0)
    {
        this->sla.presence_mask = (bcmbal_sla_id) 0;
        this->sla.min_rate = 0;
        this->sla.max_rate = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_COOKIE)) != 0)
    {
        this->cookie = (bcmbal_cookie) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_PRIORITY)) != 0)
    {
        this->priority = 1;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_GROUP_ID)) != 0)
    {
        this->group_id = (bcmbal_group_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_QUEUE)) != 0)
    {
        this->queue.sched_id = (bcmbal_tm_sched_id) 0;
        this->queue.queue_id = (bcmbal_tm_queue_id) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_flow_cfg_data_pack(const bcmbal_flow_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_pack(this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_pack(this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACCESS_INT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->access_int_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_NETWORK_INT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->network_int_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->sub_term_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_UNI_IDX)) != 0)
    {
        if (!bcmbal_buf_write_u8(buf, this->sub_term_uni_idx))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, (uint16_t) this->svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, (uint16_t) this->agg_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_RESOLVE_MAC)) != 0)
    {
        if (!bcmbal_buf_write_bool(buf, this->resolve_mac))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_CLASSIFIER)) != 0)
    {
        if (!bcmbal_classifier_pack(&this->classifier, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACTION)) != 0)
    {
        if (!bcmbal_action_pack(&this->action, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SLA)) != 0)
    {
        if (!bcmbal_sla_pack(&this->sla, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_COOKIE)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, (uint64_t) this->cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_PRIORITY)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->priority))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_GROUP_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->group_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_QUEUE)) != 0)
    {
        if (!bcmbal_tm_queue_ref_pack(&this->queue, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_flow_cfg_data_get_packed_length(const bcmbal_flow_cfg_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ADMIN_STATE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_OPER_STATUS)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACCESS_INT_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_NETWORK_INT_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_UNI_IDX)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SVC_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_AGG_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_RESOLVE_MAC)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_CLASSIFIER)) != 0)
    {
        count += bcmbal_classifier_get_packed_length(&this->classifier);
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACTION)) != 0)
    {
        count += bcmbal_action_get_packed_length(&this->action);
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SLA)) != 0)
    {
        count += bcmbal_sla_get_packed_length(&this->sla);
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_COOKIE)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_PRIORITY)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_GROUP_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_QUEUE)) != 0)
    {
        count += 5;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_cfg_data_unpack(bcmbal_flow_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_unpack(&this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_unpack(&this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACCESS_INT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->access_int_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_NETWORK_INT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->network_int_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->sub_term_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_UNI_IDX)) != 0)
    {
        if (!bcmbal_buf_read_u8(buf, &this->sub_term_uni_idx))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->agg_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_RESOLVE_MAC)) != 0)
    {
        if (!bcmbal_buf_read_bool(buf, &this->resolve_mac))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_CLASSIFIER)) != 0)
    {
        if (!bcmbal_classifier_unpack(&this->classifier, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACTION)) != 0)
    {
        if (!bcmbal_action_unpack(&this->action, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SLA)) != 0)
    {
        if (!bcmbal_sla_unpack(&this->sla, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_COOKIE)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, (uint64_t *) &this->cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_PRIORITY)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->priority))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_GROUP_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->group_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_QUEUE)) != 0)
    {
        if (!bcmbal_tm_queue_ref_unpack(&this->queue, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACCESS_INT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_NETWORK_INT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SUB_TERM_UNI_IDX)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_RESOLVE_MAC)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_CLASSIFIER)) != 0)
    {
        if (!bcmbal_classifier_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACTION)) != 0)
    {
        if (!bcmbal_action_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SLA)) != 0)
    {
        if (!bcmbal_sla_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_COOKIE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_PRIORITY)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_GROUP_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_QUEUE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 5))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_cfg_data_bounds_check(const bcmbal_flow_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_flow_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ADMIN_STATE)) != 0)
    {
        switch (this->admin_state)
        {
            case BCMBAL_STATE_UP:
                break;
            case BCMBAL_STATE_DOWN:
                break;
            case BCMBAL_STATE_TESTING:
                break;
            default:
                *failed_prop = BCMBAL_FLOW_CFG_ID_ADMIN_STATE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_OPER_STATUS)) != 0)
    {
        switch (this->oper_status)
        {
            case BCMBAL_STATUS_UP:
                break;
            case BCMBAL_STATUS_DOWN:
                break;
            case BCMBAL_STATUS_TESTING:
                break;
            case BCMBAL_STATUS_NOT_PRESENT:
                break;
            case BCMBAL_STATUS_LOWER_LAYER_DOWN:
                break;
            case BCMBAL_STATUS_UNKNOWN:
                break;
            default:
                *failed_prop = BCMBAL_FLOW_CFG_ID_OPER_STATUS;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_CLASSIFIER)) != 0)
    {
        if (!bcmbal_classifier_bounds_check(&this->classifier))
        {
            *failed_prop = BCMBAL_FLOW_CFG_ID_CLASSIFIER;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_ACTION)) != 0)
    {
        if (!bcmbal_action_bounds_check(&this->action))
        {
            *failed_prop = BCMBAL_FLOW_CFG_ID_ACTION;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_SLA)) != 0)
    {
        if (!bcmbal_sla_bounds_check(&this->sla))
        {
            *failed_prop = BCMBAL_FLOW_CFG_ID_SLA;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_PRIORITY)) != 0)
    {
        if (this->priority < 1)
        {
            *failed_prop = BCMBAL_FLOW_CFG_ID_PRIORITY;
            return BCMOS_FALSE;
        }

        if (this->priority > 255)
        {
            *failed_prop = BCMBAL_FLOW_CFG_ID_PRIORITY;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_CFG_ID_QUEUE)) != 0)
    {
        if (!bcmbal_tm_queue_ref_bounds_check(&this->queue))
        {
            *failed_prop = BCMBAL_FLOW_CFG_ID_QUEUE;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_flow_stat_data_set_default(bcmbal_flow_stat_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_PACKETS)) != 0)
    {
        this->rx_packets = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_BYTES)) != 0)
    {
        this->rx_bytes = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_PACKETS)) != 0)
    {
        this->tx_packets = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_BYTES)) != 0)
    {
        this->tx_bytes = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_flow_stat_data_pack(const bcmbal_flow_stat_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->rx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_BYTES)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->rx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->tx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_BYTES)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->tx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_flow_stat_data_get_packed_length(const bcmbal_flow_stat_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_PACKETS)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_BYTES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_PACKETS)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_BYTES)) != 0)
    {
        count += 8;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_stat_data_unpack(bcmbal_flow_stat_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->rx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_BYTES)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->rx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->tx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_BYTES)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->tx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_stat_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_RX_BYTES)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_STAT_ID_TX_BYTES)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_stat_data_bounds_check(const bcmbal_flow_stat_data *this, bcmbal_presence_mask fields_present, bcmbal_flow_stat_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_flow_ind_data_set_default(bcmbal_flow_ind_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ADMIN_STATE)) != 0)
    {
        this->admin_state = (bcmbal_state) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_OPER_STATUS)) != 0)
    {
        this->oper_status = (bcmbal_status) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACCESS_INT_ID)) != 0)
    {
        this->access_int_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_NETWORK_INT_ID)) != 0)
    {
        this->network_int_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SUB_TERM_ID)) != 0)
    {
        this->sub_term_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SVC_PORT_ID)) != 0)
    {
        this->svc_port_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_AGG_PORT_ID)) != 0)
    {
        this->agg_port_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_RESOLVE_MAC)) != 0)
    {
        this->resolve_mac = BCMOS_FALSE;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_BASE_TC_ID)) != 0)
    {
        this->base_tc_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_CLASSIFIER)) != 0)
    {
        this->classifier.presence_mask = (bcmbal_classifier_id) 0;
        this->classifier.o_tpid = 0;
        this->classifier.o_vid = 0;
        this->classifier.i_tpid = 0;
        this->classifier.i_vid = 0;
        this->classifier.o_pbits = 0;
        this->classifier.i_pbits = 0;
        this->classifier.ether_type = 0;
        bcmos_mac_address_init(&this->classifier.dst_mac);
        bcmos_mac_address_init(&this->classifier.src_mac);
        this->classifier.ip_proto = 0;
        bcmos_ipv4_address_init(&this->classifier.dst_ip);
        bcmos_ipv4_address_init(&this->classifier.src_ip);
        this->classifier.src_port = 0;
        this->classifier.dst_port = 0;
        this->classifier.pkt_tag_type = (bcmbal_pkt_tag_type) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACTION)) != 0)
    {
        this->action.presence_mask = (bcmbal_action_id) 0;
        this->action.cmds_bitmask = (bcmbal_action_cmd_id) 0;
        this->action.o_vid = 0;
        this->action.o_pbits = 0;
        this->action.o_tpid = 0;
        this->action.i_vid = 0;
        this->action.i_pbits = 0;
        this->action.i_tpid = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SLA)) != 0)
    {
        this->sla.presence_mask = (bcmbal_sla_id) 0;
        this->sla.min_rate = 0;
        this->sla.max_rate = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_COOKIE)) != 0)
    {
        this->cookie = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_PRIORITY)) != 0)
    {
        this->priority = 1;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_flow_ind_data_pack(const bcmbal_flow_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_pack(this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_pack(this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACCESS_INT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->access_int_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_NETWORK_INT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->network_int_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SUB_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, this->sub_term_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->agg_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_RESOLVE_MAC)) != 0)
    {
        if (!bcmbal_buf_write_bool(buf, this->resolve_mac))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_BASE_TC_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->base_tc_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_CLASSIFIER)) != 0)
    {
        if (!bcmbal_classifier_pack(&this->classifier, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACTION)) != 0)
    {
        if (!bcmbal_action_pack(&this->action, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SLA)) != 0)
    {
        if (!bcmbal_sla_pack(&this->sla, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_COOKIE)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, this->cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_PRIORITY)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->priority))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_flow_ind_data_get_packed_length(const bcmbal_flow_ind_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ADMIN_STATE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_OPER_STATUS)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACCESS_INT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_NETWORK_INT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SUB_TERM_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SVC_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_AGG_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_RESOLVE_MAC)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_BASE_TC_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_CLASSIFIER)) != 0)
    {
        count += bcmbal_classifier_get_packed_length(&this->classifier);
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACTION)) != 0)
    {
        count += bcmbal_action_get_packed_length(&this->action);
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SLA)) != 0)
    {
        count += bcmbal_sla_get_packed_length(&this->sla);
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_COOKIE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_PRIORITY)) != 0)
    {
        count += 2;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_ind_data_unpack(bcmbal_flow_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_unpack(&this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_unpack(&this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACCESS_INT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->access_int_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_NETWORK_INT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->network_int_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SUB_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, &this->sub_term_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->agg_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_RESOLVE_MAC)) != 0)
    {
        if (!bcmbal_buf_read_bool(buf, &this->resolve_mac))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_BASE_TC_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->base_tc_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_CLASSIFIER)) != 0)
    {
        if (!bcmbal_classifier_unpack(&this->classifier, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACTION)) != 0)
    {
        if (!bcmbal_action_unpack(&this->action, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SLA)) != 0)
    {
        if (!bcmbal_sla_unpack(&this->sla, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_COOKIE)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, &this->cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_PRIORITY)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->priority))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACCESS_INT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_NETWORK_INT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SUB_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_RESOLVE_MAC)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_BASE_TC_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_CLASSIFIER)) != 0)
    {
        if (!bcmbal_classifier_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACTION)) != 0)
    {
        if (!bcmbal_action_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SLA)) != 0)
    {
        if (!bcmbal_sla_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_COOKIE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_PRIORITY)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_flow_ind_data_bounds_check(const bcmbal_flow_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_flow_ind_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ADMIN_STATE)) != 0)
    {
        switch (this->admin_state)
        {
            case BCMBAL_STATE_UP:
                break;
            case BCMBAL_STATE_DOWN:
                break;
            case BCMBAL_STATE_TESTING:
                break;
            default:
                *failed_prop = BCMBAL_FLOW_IND_ID_ADMIN_STATE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_OPER_STATUS)) != 0)
    {
        switch (this->oper_status)
        {
            case BCMBAL_STATUS_UP:
                break;
            case BCMBAL_STATUS_DOWN:
                break;
            case BCMBAL_STATUS_TESTING:
                break;
            case BCMBAL_STATUS_NOT_PRESENT:
                break;
            case BCMBAL_STATUS_LOWER_LAYER_DOWN:
                break;
            case BCMBAL_STATUS_UNKNOWN:
                break;
            default:
                *failed_prop = BCMBAL_FLOW_IND_ID_OPER_STATUS;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_CLASSIFIER)) != 0)
    {
        if (!bcmbal_classifier_bounds_check(&this->classifier))
        {
            *failed_prop = BCMBAL_FLOW_IND_ID_CLASSIFIER;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_ACTION)) != 0)
    {
        if (!bcmbal_action_bounds_check(&this->action))
        {
            *failed_prop = BCMBAL_FLOW_IND_ID_ACTION;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_SLA)) != 0)
    {
        if (!bcmbal_sla_bounds_check(&this->sla))
        {
            *failed_prop = BCMBAL_FLOW_IND_ID_SLA;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_FLOW_IND_ID_PRIORITY)) != 0)
    {
        if (this->priority < 1)
        {
            *failed_prop = BCMBAL_FLOW_IND_ID_PRIORITY;
            return BCMOS_FALSE;
        }

        if (this->priority > 255)
        {
            *failed_prop = BCMBAL_FLOW_IND_ID_PRIORITY;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_group_key_set_default(bcmbal_group_key *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_GROUP_KEY_ID_GROUP_ID)) != 0)
    {
        this->group_id = (bcmbal_group_id) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_group_key_pack(const bcmbal_group_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_GROUP_KEY_ID_GROUP_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->group_id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_group_key_get_packed_length(const bcmbal_group_key *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_GROUP_KEY_ID_GROUP_ID)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_group_key_unpack(bcmbal_group_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_GROUP_KEY_ID_GROUP_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->group_id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_GROUP_KEY_ID_GROUP_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_key_bounds_check(const bcmbal_group_key *this, bcmbal_presence_mask fields_present, bcmbal_group_key_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_group_cfg_data_set_default(bcmbal_group_cfg_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS_CMD)) != 0)
    {
        this->members_cmd = (bcmbal_group_member_cmd) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS)) != 0)
    {
        this->members.len = 0;
        this->members.val = NULL;
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_COOKIE)) != 0)
    {
        this->cookie = (bcmbal_cookie) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_FLOWS)) != 0)
    {
        this->flows.len = 0;
        this->flows.val = NULL;
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_OWNER)) != 0)
    {
        this->owner = BCMBAL_GROUP_OWNER_NONE;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_group_cfg_data_pack(const bcmbal_group_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS_CMD)) != 0)
    {
        if (!bcmbal_group_member_cmd_pack(this->members_cmd, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS)) != 0)
    {
        if (!bcmbal_group_member_info_list_u16_pack(&this->members, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_COOKIE)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, (uint64_t) this->cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_FLOWS)) != 0)
    {
        if (!bcmbal_flow_id_list_u32_pack(&this->flows, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_OWNER)) != 0)
    {
        if (!bcmbal_group_owner_pack(this->owner, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_group_cfg_data_get_packed_length(const bcmbal_group_cfg_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS_CMD)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS)) != 0)
    {
        count += bcmbal_group_member_info_list_u16_get_packed_length(&this->members);
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_COOKIE)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_FLOWS)) != 0)
    {
        count += bcmbal_flow_id_list_u32_get_packed_length(&this->flows);
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_OWNER)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_group_cfg_data_unpack(bcmbal_group_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS_CMD)) != 0)
    {
        if (!bcmbal_group_member_cmd_unpack(&this->members_cmd, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS)) != 0)
    {
        if (!bcmbal_group_member_info_list_u16_unpack(&this->members, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_COOKIE)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, (uint64_t *) &this->cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_FLOWS)) != 0)
    {
        if (!bcmbal_flow_id_list_u32_unpack(&this->flows, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_OWNER)) != 0)
    {
        if (!bcmbal_group_owner_unpack(&this->owner, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS_CMD)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS)) != 0)
    {
        if (!bcmbal_group_member_info_list_u16_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_COOKIE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_FLOWS)) != 0)
    {
        if (!bcmbal_flow_id_list_u32_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_OWNER)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_group_cfg_data_bounds_check(const bcmbal_group_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_group_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS_CMD)) != 0)
    {
        switch (this->members_cmd)
        {
            case BCMBAL_GROUP_MEMBER_CMD_ADD_MEMBERS:
                break;
            case BCMBAL_GROUP_MEMBER_CMD_REM_MEMBERS:
                break;
            case BCMBAL_GROUP_MEMBER_CMD_SET_MEMBERS:
                break;
            default:
                *failed_prop = BCMBAL_GROUP_CFG_ID_MEMBERS_CMD;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_MEMBERS)) != 0)
    {
        if (!bcmbal_group_member_info_list_u16_bounds_check(&this->members))
        {
            *failed_prop = BCMBAL_GROUP_CFG_ID_MEMBERS;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_FLOWS)) != 0)
    {
        if (!bcmbal_flow_id_list_u32_bounds_check(&this->flows))
        {
            *failed_prop = BCMBAL_GROUP_CFG_ID_FLOWS;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_GROUP_CFG_ID_OWNER)) != 0)
    {
        switch (this->owner)
        {
            case BCMBAL_GROUP_OWNER_NONE:
                break;
            case BCMBAL_GROUP_OWNER_MULTICAST:
                break;
            case BCMBAL_GROUP_OWNER_UNICAST:
                break;
            default:
                *failed_prop = BCMBAL_GROUP_CFG_ID_OWNER;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_interface_key_set_default(bcmbal_interface_key *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_ID)) != 0)
    {
        this->intf_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_TYPE)) != 0)
    {
        this->intf_type = BCMBAL_INTF_TYPE_NNI;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_interface_key_pack(const bcmbal_interface_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, this->intf_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_TYPE)) != 0)
    {
        if (!bcmbal_intf_type_pack(this->intf_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_interface_key_get_packed_length(const bcmbal_interface_key *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_TYPE)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_key_unpack(bcmbal_interface_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, &this->intf_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_TYPE)) != 0)
    {
        if (!bcmbal_intf_type_unpack(&this->intf_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_key_bounds_check(const bcmbal_interface_key *this, bcmbal_presence_mask fields_present, bcmbal_interface_key_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_KEY_ID_INTF_TYPE)) != 0)
    {
        switch (this->intf_type)
        {
            case BCMBAL_INTF_TYPE_NNI:
                break;
            case BCMBAL_INTF_TYPE_PON:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_KEY_ID_INTF_TYPE;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_interface_cfg_data_set_default(bcmbal_interface_cfg_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_ADMIN_STATE)) != 0)
    {
        this->admin_state = (bcmbal_state) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_OPER_STATUS)) != 0)
    {
        this->oper_status = (bcmbal_status) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        this->min_data_agg_port_id = (bcmbal_aggregation_port_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        this->min_data_svc_port_id = (bcmbal_service_port_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_TRANSCEIVER_TYPE)) != 0)
    {
        this->transceiver_type = BCMBAL_TRX_TYPE_GPON_SPS_43_48;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_MISS_MODE)) != 0)
    {
        this->ds_miss_mode = BCMBAL_DS_MISS_MODE_DISCARD;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MTU)) != 0)
    {
        this->mtu = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_FLOW_CONTROL)) != 0)
    {
        this->flow_control = BCMBAL_CONTROL_DISABLE;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_TM)) != 0)
    {
        this->ds_tm = (bcmbal_tm_sched_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_US_TM)) != 0)
    {
        this->us_tm = (bcmbal_tm_sched_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_SUB_TERM_ID_LIST)) != 0)
    {
        this->sub_term_id_list.len = 0;
        this->sub_term_id_list.val = NULL;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_interface_cfg_data_pack(const bcmbal_interface_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_pack(this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_pack(this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, (uint16_t) this->min_data_agg_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, (uint16_t) this->min_data_svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_TRANSCEIVER_TYPE)) != 0)
    {
        if (!bcmbal_trx_type_pack(this->transceiver_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_MISS_MODE)) != 0)
    {
        if (!bcmbal_ds_miss_mode_pack(this->ds_miss_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MTU)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->mtu))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_FLOW_CONTROL)) != 0)
    {
        if (!bcmbal_control_pack(this->flow_control, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->ds_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->us_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_SUB_TERM_ID_LIST)) != 0)
    {
        if (!bcmbal_sub_id_list_u16_pack(&this->sub_term_id_list, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_interface_cfg_data_get_packed_length(const bcmbal_interface_cfg_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_ADMIN_STATE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_OPER_STATUS)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_TRANSCEIVER_TYPE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_MISS_MODE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MTU)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_FLOW_CONTROL)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_TM)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_US_TM)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_SUB_TERM_ID_LIST)) != 0)
    {
        count += bcmbal_sub_id_list_u16_get_packed_length(&this->sub_term_id_list);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_cfg_data_unpack(bcmbal_interface_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_unpack(&this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_unpack(&this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->min_data_agg_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->min_data_svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_TRANSCEIVER_TYPE)) != 0)
    {
        if (!bcmbal_trx_type_unpack(&this->transceiver_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_MISS_MODE)) != 0)
    {
        if (!bcmbal_ds_miss_mode_unpack(&this->ds_miss_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MTU)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->mtu))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_FLOW_CONTROL)) != 0)
    {
        if (!bcmbal_control_unpack(&this->flow_control, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->ds_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->us_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_SUB_TERM_ID_LIST)) != 0)
    {
        if (!bcmbal_sub_id_list_u16_unpack(&this->sub_term_id_list, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_TRANSCEIVER_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_MISS_MODE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_MTU)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_FLOW_CONTROL)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_SUB_TERM_ID_LIST)) != 0)
    {
        if (!bcmbal_sub_id_list_u16_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_cfg_data_bounds_check(const bcmbal_interface_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_interface_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_ADMIN_STATE)) != 0)
    {
        switch (this->admin_state)
        {
            case BCMBAL_STATE_UP:
                break;
            case BCMBAL_STATE_DOWN:
                break;
            case BCMBAL_STATE_TESTING:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_CFG_ID_ADMIN_STATE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_OPER_STATUS)) != 0)
    {
        switch (this->oper_status)
        {
            case BCMBAL_STATUS_UP:
                break;
            case BCMBAL_STATUS_DOWN:
                break;
            case BCMBAL_STATUS_TESTING:
                break;
            case BCMBAL_STATUS_NOT_PRESENT:
                break;
            case BCMBAL_STATUS_LOWER_LAYER_DOWN:
                break;
            case BCMBAL_STATUS_UNKNOWN:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_CFG_ID_OPER_STATUS;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_TRANSCEIVER_TYPE)) != 0)
    {
        switch (this->transceiver_type)
        {
            case BCMBAL_TRX_TYPE_GPON_SPS_43_48:
                break;
            case BCMBAL_TRX_TYPE_GPON_SPS_SOG_4321:
                break;
            case BCMBAL_TRX_TYPE_GPON_LTE_3680_M:
                break;
            case BCMBAL_TRX_TYPE_GPON_SOURCE_PHOTONICS:
                break;
            case BCMBAL_TRX_TYPE_GPON_LTE_3680_P:
                break;
            case BCMBAL_TRX_TYPE_XGPON_LTH_7222_PC:
                break;
            case BCMBAL_TRX_TYPE_XGPON_LTH_7226_PC:
                break;
            case BCMBAL_TRX_TYPE_XGPON_LTH_5302_PC:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_CFG_ID_TRANSCEIVER_TYPE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_DS_MISS_MODE)) != 0)
    {
        switch (this->ds_miss_mode)
        {
            case BCMBAL_DS_MISS_MODE_DISCARD:
                break;
            case BCMBAL_DS_MISS_MODE_BROADCAST:
                break;
            case BCMBAL_DS_MISS_MODE_VID:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_CFG_ID_DS_MISS_MODE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_FLOW_CONTROL)) != 0)
    {
        switch (this->flow_control)
        {
            case BCMBAL_CONTROL_DISABLE:
                break;
            case BCMBAL_CONTROL_ENABLE:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_CFG_ID_FLOW_CONTROL;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_CFG_ID_SUB_TERM_ID_LIST)) != 0)
    {
        if (!bcmbal_sub_id_list_u16_bounds_check(&this->sub_term_id_list))
        {
            *failed_prop = BCMBAL_INTERFACE_CFG_ID_SUB_TERM_ID_LIST;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_interface_stat_data_set_default(bcmbal_interface_stat_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_PACKETS)) != 0)
    {
        this->rx_packets = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_BYTES)) != 0)
    {
        this->rx_bytes = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_PACKETS)) != 0)
    {
        this->tx_packets = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_BYTES)) != 0)
    {
        this->tx_bytes = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_interface_stat_data_pack(const bcmbal_interface_stat_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->rx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_BYTES)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->rx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->tx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_BYTES)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->tx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_interface_stat_data_get_packed_length(const bcmbal_interface_stat_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_PACKETS)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_BYTES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_PACKETS)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_BYTES)) != 0)
    {
        count += 8;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_stat_data_unpack(bcmbal_interface_stat_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->rx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_BYTES)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->rx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->tx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_BYTES)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->tx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_stat_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_RX_BYTES)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_STAT_ID_TX_BYTES)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_stat_data_bounds_check(const bcmbal_interface_stat_data *this, bcmbal_presence_mask fields_present, bcmbal_interface_stat_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_interface_ind_data_set_default(bcmbal_interface_ind_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_ADMIN_STATE)) != 0)
    {
        this->admin_state = (bcmbal_state) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_OPER_STATUS)) != 0)
    {
        this->oper_status = (bcmbal_status) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        this->min_data_agg_port_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        this->min_data_svc_port_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_TRANSCEIVER_TYPE)) != 0)
    {
        this->transceiver_type = BCMBAL_TRX_TYPE_GPON_SPS_43_48;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_MISS_MODE)) != 0)
    {
        this->ds_miss_mode = BCMBAL_DS_MISS_MODE_DISCARD;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MTU)) != 0)
    {
        this->mtu = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_FLOW_CONTROL)) != 0)
    {
        this->flow_control = BCMBAL_CONTROL_DISABLE;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_TM)) != 0)
    {
        this->ds_tm = (bcmbal_tm_sched_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_US_TM)) != 0)
    {
        this->us_tm = (bcmbal_tm_sched_id) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_interface_ind_data_pack(const bcmbal_interface_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_pack(this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_pack(this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->min_data_agg_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->min_data_svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_TRANSCEIVER_TYPE)) != 0)
    {
        if (!bcmbal_trx_type_pack(this->transceiver_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_MISS_MODE)) != 0)
    {
        if (!bcmbal_ds_miss_mode_pack(this->ds_miss_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MTU)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->mtu))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_FLOW_CONTROL)) != 0)
    {
        if (!bcmbal_control_pack(this->flow_control, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->ds_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->us_tm))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_interface_ind_data_get_packed_length(const bcmbal_interface_ind_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_ADMIN_STATE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_OPER_STATUS)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_TRANSCEIVER_TYPE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_MISS_MODE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MTU)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_FLOW_CONTROL)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_TM)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_US_TM)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_ind_data_unpack(bcmbal_interface_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_unpack(&this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_unpack(&this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->min_data_agg_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->min_data_svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_TRANSCEIVER_TYPE)) != 0)
    {
        if (!bcmbal_trx_type_unpack(&this->transceiver_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_MISS_MODE)) != 0)
    {
        if (!bcmbal_ds_miss_mode_unpack(&this->ds_miss_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MTU)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->mtu))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_FLOW_CONTROL)) != 0)
    {
        if (!bcmbal_control_unpack(&this->flow_control, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->ds_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->us_tm))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_AGG_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MIN_DATA_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_TRANSCEIVER_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_MISS_MODE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_MTU)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_FLOW_CONTROL)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_interface_ind_data_bounds_check(const bcmbal_interface_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_interface_ind_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_ADMIN_STATE)) != 0)
    {
        switch (this->admin_state)
        {
            case BCMBAL_STATE_UP:
                break;
            case BCMBAL_STATE_DOWN:
                break;
            case BCMBAL_STATE_TESTING:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_IND_ID_ADMIN_STATE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_OPER_STATUS)) != 0)
    {
        switch (this->oper_status)
        {
            case BCMBAL_STATUS_UP:
                break;
            case BCMBAL_STATUS_DOWN:
                break;
            case BCMBAL_STATUS_TESTING:
                break;
            case BCMBAL_STATUS_NOT_PRESENT:
                break;
            case BCMBAL_STATUS_LOWER_LAYER_DOWN:
                break;
            case BCMBAL_STATUS_UNKNOWN:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_IND_ID_OPER_STATUS;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_TRANSCEIVER_TYPE)) != 0)
    {
        switch (this->transceiver_type)
        {
            case BCMBAL_TRX_TYPE_GPON_SPS_43_48:
                break;
            case BCMBAL_TRX_TYPE_GPON_SPS_SOG_4321:
                break;
            case BCMBAL_TRX_TYPE_GPON_LTE_3680_M:
                break;
            case BCMBAL_TRX_TYPE_GPON_SOURCE_PHOTONICS:
                break;
            case BCMBAL_TRX_TYPE_GPON_LTE_3680_P:
                break;
            case BCMBAL_TRX_TYPE_XGPON_LTH_7222_PC:
                break;
            case BCMBAL_TRX_TYPE_XGPON_LTH_7226_PC:
                break;
            case BCMBAL_TRX_TYPE_XGPON_LTH_5302_PC:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_IND_ID_TRANSCEIVER_TYPE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_DS_MISS_MODE)) != 0)
    {
        switch (this->ds_miss_mode)
        {
            case BCMBAL_DS_MISS_MODE_DISCARD:
                break;
            case BCMBAL_DS_MISS_MODE_BROADCAST:
                break;
            case BCMBAL_DS_MISS_MODE_VID:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_IND_ID_DS_MISS_MODE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_INTERFACE_IND_ID_FLOW_CONTROL)) != 0)
    {
        switch (this->flow_control)
        {
            case BCMBAL_CONTROL_DISABLE:
                break;
            case BCMBAL_CONTROL_ENABLE:
                break;
            default:
                *failed_prop = BCMBAL_INTERFACE_IND_ID_FLOW_CONTROL;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_packet_key_set_default(bcmbal_packet_key *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_RESERVED)) != 0)
    {
        this->reserved = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_PACKET_SEND_DEST)) != 0)
    {
        this->packet_send_dest.type = (bcmbal_dest_type) 0;
        this->packet_send_dest.u.nni.int_id = (bcmbal_intf_id) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_packet_key_pack(const bcmbal_packet_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_RESERVED)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, this->reserved))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_PACKET_SEND_DEST)) != 0)
    {
        if (!bcmbal_dest_pack(&this->packet_send_dest, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_packet_key_get_packed_length(const bcmbal_packet_key *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_RESERVED)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_PACKET_SEND_DEST)) != 0)
    {
        count += bcmbal_dest_get_packed_length(&this->packet_send_dest);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_key_unpack(bcmbal_packet_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_RESERVED)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, &this->reserved))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_PACKET_SEND_DEST)) != 0)
    {
        if (!bcmbal_dest_unpack(&this->packet_send_dest, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_RESERVED)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_PACKET_SEND_DEST)) != 0)
    {
        if (!bcmbal_dest_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_key_bounds_check(const bcmbal_packet_key *this, bcmbal_presence_mask fields_present, bcmbal_packet_key_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_KEY_ID_PACKET_SEND_DEST)) != 0)
    {
        if (!bcmbal_dest_bounds_check(&this->packet_send_dest))
        {
            *failed_prop = BCMBAL_PACKET_KEY_ID_PACKET_SEND_DEST;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_packet_cfg_data_set_default(bcmbal_packet_cfg_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_ID)) != 0)
    {
        this->flow_id = (bcmbal_flow_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_TYPE)) != 0)
    {
        this->flow_type = (bcmbal_flow_type) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_ID)) != 0)
    {
        this->intf_id = (bcmbal_intf_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_TYPE)) != 0)
    {
        this->intf_type = BCMBAL_INTF_TYPE_NNI;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_SVC_PORT)) != 0)
    {
        this->svc_port = (bcmbal_service_port_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_COOKIE)) != 0)
    {
        this->flow_cookie = (bcmbal_cookie) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_PKT)) != 0)
    {
        this->pkt.len = 0;
        this->pkt.val = NULL;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_packet_cfg_data_pack(const bcmbal_packet_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->flow_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_TYPE)) != 0)
    {
        if (!bcmbal_flow_type_pack(this->flow_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->intf_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_TYPE)) != 0)
    {
        if (!bcmbal_intf_type_pack(this->intf_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_SVC_PORT)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, (uint16_t) this->svc_port))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_COOKIE)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, (uint64_t) this->flow_cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_PKT)) != 0)
    {
        if (!bcmbal_u8_list_u32_pack(&this->pkt, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_packet_cfg_data_get_packed_length(const bcmbal_packet_cfg_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_TYPE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_TYPE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_SVC_PORT)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_COOKIE)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_PKT)) != 0)
    {
        count += bcmbal_u8_list_u32_get_packed_length(&this->pkt);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_cfg_data_unpack(bcmbal_packet_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->flow_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_TYPE)) != 0)
    {
        if (!bcmbal_flow_type_unpack(&this->flow_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->intf_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_TYPE)) != 0)
    {
        if (!bcmbal_intf_type_unpack(&this->intf_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_SVC_PORT)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->svc_port))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_COOKIE)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, (uint64_t *) &this->flow_cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_PKT)) != 0)
    {
        if (!bcmbal_u8_list_u32_unpack(&this->pkt, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_SVC_PORT)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_COOKIE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_PKT)) != 0)
    {
        if (!bcmbal_u8_list_u32_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_cfg_data_bounds_check(const bcmbal_packet_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_packet_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_FLOW_TYPE)) != 0)
    {
        switch (this->flow_type)
        {
            case BCMBAL_FLOW_TYPE_UPSTREAM:
                break;
            case BCMBAL_FLOW_TYPE_DOWNSTREAM:
                break;
            case BCMBAL_FLOW_TYPE_BROADCAST:
                break;
            case BCMBAL_FLOW_TYPE_MULTICAST:
                break;
            default:
                *failed_prop = BCMBAL_PACKET_CFG_ID_FLOW_TYPE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_INTF_TYPE)) != 0)
    {
        switch (this->intf_type)
        {
            case BCMBAL_INTF_TYPE_NNI:
                break;
            case BCMBAL_INTF_TYPE_PON:
                break;
            default:
                *failed_prop = BCMBAL_PACKET_CFG_ID_INTF_TYPE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_CFG_ID_PKT)) != 0)
    {
        if (!bcmbal_u8_list_u32_bounds_check(&this->pkt))
        {
            *failed_prop = BCMBAL_PACKET_CFG_ID_PKT;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_packet_ind_data_set_default(bcmbal_packet_ind_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_ID)) != 0)
    {
        this->flow_id = (bcmbal_flow_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_TYPE)) != 0)
    {
        this->flow_type = (bcmbal_flow_type) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_ID)) != 0)
    {
        this->intf_id = (bcmbal_intf_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_TYPE)) != 0)
    {
        this->intf_type = BCMBAL_INTF_TYPE_NNI;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_SVC_PORT)) != 0)
    {
        this->svc_port = (bcmbal_service_port_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_COOKIE)) != 0)
    {
        this->flow_cookie = (bcmbal_cookie) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_PKT)) != 0)
    {
        this->pkt.len = 0;
        this->pkt.val = NULL;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_packet_ind_data_pack(const bcmbal_packet_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->flow_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_TYPE)) != 0)
    {
        if (!bcmbal_flow_type_pack(this->flow_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->intf_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_TYPE)) != 0)
    {
        if (!bcmbal_intf_type_pack(this->intf_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_SVC_PORT)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, (uint16_t) this->svc_port))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_COOKIE)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, (uint64_t) this->flow_cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_PKT)) != 0)
    {
        if (!bcmbal_u8_list_u32_pack(&this->pkt, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_packet_ind_data_get_packed_length(const bcmbal_packet_ind_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_TYPE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_TYPE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_SVC_PORT)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_COOKIE)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_PKT)) != 0)
    {
        count += bcmbal_u8_list_u32_get_packed_length(&this->pkt);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_ind_data_unpack(bcmbal_packet_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->flow_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_TYPE)) != 0)
    {
        if (!bcmbal_flow_type_unpack(&this->flow_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->intf_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_TYPE)) != 0)
    {
        if (!bcmbal_intf_type_unpack(&this->intf_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_SVC_PORT)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->svc_port))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_COOKIE)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, (uint64_t *) &this->flow_cookie))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_PKT)) != 0)
    {
        if (!bcmbal_u8_list_u32_unpack(&this->pkt, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_SVC_PORT)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_COOKIE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_PKT)) != 0)
    {
        if (!bcmbal_u8_list_u32_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_packet_ind_data_bounds_check(const bcmbal_packet_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_packet_ind_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_FLOW_TYPE)) != 0)
    {
        switch (this->flow_type)
        {
            case BCMBAL_FLOW_TYPE_UPSTREAM:
                break;
            case BCMBAL_FLOW_TYPE_DOWNSTREAM:
                break;
            case BCMBAL_FLOW_TYPE_BROADCAST:
                break;
            case BCMBAL_FLOW_TYPE_MULTICAST:
                break;
            default:
                *failed_prop = BCMBAL_PACKET_IND_ID_FLOW_TYPE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_INTF_TYPE)) != 0)
    {
        switch (this->intf_type)
        {
            case BCMBAL_INTF_TYPE_NNI:
                break;
            case BCMBAL_INTF_TYPE_PON:
                break;
            default:
                *failed_prop = BCMBAL_PACKET_IND_ID_INTF_TYPE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_PACKET_IND_ID_PKT)) != 0)
    {
        if (!bcmbal_u8_list_u32_bounds_check(&this->pkt))
        {
            *failed_prop = BCMBAL_PACKET_IND_ID_PKT;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_subscriber_terminal_key_set_default(bcmbal_subscriber_terminal_key *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_SUB_TERM_ID)) != 0)
    {
        this->sub_term_id = (bcmbal_sub_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_INTF_ID)) != 0)
    {
        this->intf_id = (bcmbal_intf_id) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_key_pack(const bcmbal_subscriber_terminal_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_SUB_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->sub_term_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->intf_id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_subscriber_terminal_key_get_packed_length(const bcmbal_subscriber_terminal_key *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_SUB_TERM_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_INTF_ID)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_key_unpack(bcmbal_subscriber_terminal_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_SUB_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->sub_term_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->intf_id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_SUB_TERM_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_INTF_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_key_bounds_check(const bcmbal_subscriber_terminal_key *this, bcmbal_presence_mask fields_present, bcmbal_subscriber_terminal_key_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_subscriber_terminal_cfg_data_set_default(bcmbal_subscriber_terminal_cfg_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        this->admin_state = (bcmbal_state) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        this->oper_status = (bcmbal_status) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SERIAL_NUMBER)) != 0)
    {
        memset(this->serial_number.vendor_id, 0, sizeof(this->serial_number.vendor_id));
        memset(this->serial_number.vendor_specific, 0, sizeof(this->serial_number.vendor_specific));
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_PASSWORD)) != 0)
    {
        memset(this->password.arr, 0, sizeof(this->password.arr));
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_REGISTRATION_ID)) != 0)
    {
        memset(this->registration_id.arr, 0, sizeof(this->registration_id.arr));
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID)) != 0)
    {
        this->svc_port_id = (bcmbal_service_port_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_MAC_ADDRESS)) != 0)
    {
        bcmos_mac_address_init(&this->mac_address);
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_DS_TM)) != 0)
    {
        this->ds_tm = (bcmbal_tm_sched_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_US_TM)) != 0)
    {
        this->us_tm = (bcmbal_tm_sched_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID_LIST)) != 0)
    {
        this->svc_port_id_list.len = 0;
        this->svc_port_id_list.val = NULL;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_AGG_PORT_ID_LIST)) != 0)
    {
        this->agg_port_id_list.len = 0;
        this->agg_port_id_list.val = NULL;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_cfg_data_pack(const bcmbal_subscriber_terminal_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_pack(this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_pack(this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SERIAL_NUMBER)) != 0)
    {
        if (!bcmbal_serial_number_pack(&this->serial_number, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_PASSWORD)) != 0)
    {
        if (!bcmbal_password_pack(&this->password, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_REGISTRATION_ID)) != 0)
    {
        if (!bcmbal_registration_id_pack(&this->registration_id, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, (uint16_t) this->svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_MAC_ADDRESS)) != 0)
    {
        if (!bcmbal_buf_write_mac_address(buf, this->mac_address))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->ds_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->us_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID_LIST)) != 0)
    {
        if (!bcmbal_service_port_id_list_u8_pack(&this->svc_port_id_list, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_AGG_PORT_ID_LIST)) != 0)
    {
        if (!bcmbal_aggregation_port_id_list_u8_pack(&this->agg_port_id_list, buf))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_subscriber_terminal_cfg_data_get_packed_length(const bcmbal_subscriber_terminal_cfg_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SERIAL_NUMBER)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_PASSWORD)) != 0)
    {
        count += 10;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_REGISTRATION_ID)) != 0)
    {
        count += 36;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_MAC_ADDRESS)) != 0)
    {
        count += 6;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_DS_TM)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_US_TM)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID_LIST)) != 0)
    {
        count += bcmbal_service_port_id_list_u8_get_packed_length(&this->svc_port_id_list);
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_AGG_PORT_ID_LIST)) != 0)
    {
        count += bcmbal_aggregation_port_id_list_u8_get_packed_length(&this->agg_port_id_list);
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_cfg_data_unpack(bcmbal_subscriber_terminal_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_unpack(&this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_unpack(&this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SERIAL_NUMBER)) != 0)
    {
        if (!bcmbal_serial_number_unpack(&this->serial_number, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_PASSWORD)) != 0)
    {
        if (!bcmbal_password_unpack(&this->password, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_REGISTRATION_ID)) != 0)
    {
        if (!bcmbal_registration_id_unpack(&this->registration_id, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, (uint16_t *) &this->svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_MAC_ADDRESS)) != 0)
    {
        if (!bcmbal_buf_read_mac_address(buf, &this->mac_address))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->ds_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->us_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID_LIST)) != 0)
    {
        if (!bcmbal_service_port_id_list_u8_unpack(&this->svc_port_id_list, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_AGG_PORT_ID_LIST)) != 0)
    {
        if (!bcmbal_aggregation_port_id_list_u8_unpack(&this->agg_port_id_list, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SERIAL_NUMBER)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_PASSWORD)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 10))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_REGISTRATION_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 36))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_MAC_ADDRESS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 6))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID_LIST)) != 0)
    {
        if (!bcmbal_service_port_id_list_u8_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_AGG_PORT_ID_LIST)) != 0)
    {
        if (!bcmbal_aggregation_port_id_list_u8_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_cfg_data_bounds_check(const bcmbal_subscriber_terminal_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_subscriber_terminal_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_ADMIN_STATE)) != 0)
    {
        switch (this->admin_state)
        {
            case BCMBAL_STATE_UP:
                break;
            case BCMBAL_STATE_DOWN:
                break;
            case BCMBAL_STATE_TESTING:
                break;
            default:
                *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_ADMIN_STATE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_OPER_STATUS)) != 0)
    {
        switch (this->oper_status)
        {
            case BCMBAL_STATUS_UP:
                break;
            case BCMBAL_STATUS_DOWN:
                break;
            case BCMBAL_STATUS_TESTING:
                break;
            case BCMBAL_STATUS_NOT_PRESENT:
                break;
            case BCMBAL_STATUS_LOWER_LAYER_DOWN:
                break;
            case BCMBAL_STATUS_UNKNOWN:
                break;
            default:
                *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_OPER_STATUS;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SERIAL_NUMBER)) != 0)
    {
        if (!bcmbal_serial_number_bounds_check(&this->serial_number))
        {
            *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SERIAL_NUMBER;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_PASSWORD)) != 0)
    {
        if (!bcmbal_password_bounds_check(&this->password))
        {
            *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_PASSWORD;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_REGISTRATION_ID)) != 0)
    {
        if (!bcmbal_registration_id_bounds_check(&this->registration_id))
        {
            *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_REGISTRATION_ID;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID_LIST)) != 0)
    {
        if (!bcmbal_service_port_id_list_u8_bounds_check(&this->svc_port_id_list))
        {
            *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID_LIST;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_AGG_PORT_ID_LIST)) != 0)
    {
        if (!bcmbal_aggregation_port_id_list_u8_bounds_check(&this->agg_port_id_list))
        {
            *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_AGG_PORT_ID_LIST;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_subscriber_terminal_stat_data_set_default(bcmbal_subscriber_terminal_stat_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_PACKETS)) != 0)
    {
        this->rx_packets = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_BYTES)) != 0)
    {
        this->rx_bytes = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_PACKETS)) != 0)
    {
        this->tx_packets = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_BYTES)) != 0)
    {
        this->tx_bytes = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_stat_data_pack(const bcmbal_subscriber_terminal_stat_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->rx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_BYTES)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->rx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->tx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_BYTES)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->tx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_subscriber_terminal_stat_data_get_packed_length(const bcmbal_subscriber_terminal_stat_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_PACKETS)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_BYTES)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_PACKETS)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_BYTES)) != 0)
    {
        count += 8;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_stat_data_unpack(bcmbal_subscriber_terminal_stat_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->rx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_BYTES)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->rx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->tx_packets))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_BYTES)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->tx_bytes))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_stat_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_BYTES)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_PACKETS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_BYTES)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_stat_data_bounds_check(const bcmbal_subscriber_terminal_stat_data *this, bcmbal_presence_mask fields_present, bcmbal_subscriber_terminal_stat_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_subscriber_terminal_ind_data_set_default(bcmbal_subscriber_terminal_ind_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        this->admin_state = (bcmbal_state) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        this->oper_status = (bcmbal_status) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SERIAL_NUMBER)) != 0)
    {
        memset(this->serial_number.vendor_id, 0, sizeof(this->serial_number.vendor_id));
        memset(this->serial_number.vendor_specific, 0, sizeof(this->serial_number.vendor_specific));
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_PASSWORD)) != 0)
    {
        memset(this->password.arr, 0, sizeof(this->password.arr));
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_REGISTRATION_ID)) != 0)
    {
        memset(this->registration_id.arr, 0, sizeof(this->registration_id.arr));
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SVC_PORT_ID)) != 0)
    {
        this->svc_port_id = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_MAC_ADDRESS)) != 0)
    {
        bcmos_mac_address_init(&this->mac_address);
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_DS_TM)) != 0)
    {
        this->ds_tm = (bcmbal_tm_sched_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_US_TM)) != 0)
    {
        this->us_tm = (bcmbal_tm_sched_id) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_ind_data_pack(const bcmbal_subscriber_terminal_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_pack(this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_pack(this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SERIAL_NUMBER)) != 0)
    {
        if (!bcmbal_serial_number_pack(&this->serial_number, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_PASSWORD)) != 0)
    {
        if (!bcmbal_password_pack(&this->password, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_REGISTRATION_ID)) != 0)
    {
        if (!bcmbal_registration_id_pack(&this->registration_id, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_write_u16(buf, this->svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_MAC_ADDRESS)) != 0)
    {
        if (!bcmbal_buf_write_mac_address(buf, this->mac_address))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->ds_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->us_tm))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_subscriber_terminal_ind_data_get_packed_length(const bcmbal_subscriber_terminal_ind_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SERIAL_NUMBER)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_PASSWORD)) != 0)
    {
        count += 10;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_REGISTRATION_ID)) != 0)
    {
        count += 36;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SVC_PORT_ID)) != 0)
    {
        count += 2;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_MAC_ADDRESS)) != 0)
    {
        count += 6;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_DS_TM)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_US_TM)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_ind_data_unpack(bcmbal_subscriber_terminal_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_state_unpack(&this->admin_state, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_status_unpack(&this->oper_status, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SERIAL_NUMBER)) != 0)
    {
        if (!bcmbal_serial_number_unpack(&this->serial_number, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_PASSWORD)) != 0)
    {
        if (!bcmbal_password_unpack(&this->password, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_REGISTRATION_ID)) != 0)
    {
        if (!bcmbal_registration_id_unpack(&this->registration_id, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_read_u16(buf, &this->svc_port_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_MAC_ADDRESS)) != 0)
    {
        if (!bcmbal_buf_read_mac_address(buf, &this->mac_address))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->ds_tm))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->us_tm))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SERIAL_NUMBER)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_PASSWORD)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 10))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_REGISTRATION_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 36))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SVC_PORT_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 2))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_MAC_ADDRESS)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 6))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_DS_TM)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_US_TM)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_subscriber_terminal_ind_data_bounds_check(const bcmbal_subscriber_terminal_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_subscriber_terminal_ind_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_ADMIN_STATE)) != 0)
    {
        switch (this->admin_state)
        {
            case BCMBAL_STATE_UP:
                break;
            case BCMBAL_STATE_DOWN:
                break;
            case BCMBAL_STATE_TESTING:
                break;
            default:
                *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_ADMIN_STATE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_OPER_STATUS)) != 0)
    {
        switch (this->oper_status)
        {
            case BCMBAL_STATUS_UP:
                break;
            case BCMBAL_STATUS_DOWN:
                break;
            case BCMBAL_STATUS_TESTING:
                break;
            case BCMBAL_STATUS_NOT_PRESENT:
                break;
            case BCMBAL_STATUS_LOWER_LAYER_DOWN:
                break;
            case BCMBAL_STATUS_UNKNOWN:
                break;
            default:
                *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_OPER_STATUS;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SERIAL_NUMBER)) != 0)
    {
        if (!bcmbal_serial_number_bounds_check(&this->serial_number))
        {
            *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SERIAL_NUMBER;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_PASSWORD)) != 0)
    {
        if (!bcmbal_password_bounds_check(&this->password))
        {
            *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_PASSWORD;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_REGISTRATION_ID)) != 0)
    {
        if (!bcmbal_registration_id_bounds_check(&this->registration_id))
        {
            *failed_prop = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_REGISTRATION_ID;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_queue_key_set_default(bcmbal_tm_queue_key *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_ID)) != 0)
    {
        this->sched_id = (bcmbal_tm_sched_id) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_DIR)) != 0)
    {
        this->sched_dir = (bcmbal_tm_sched_dir) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_ID)) != 0)
    {
        this->id = (bcmbal_tm_queue_id) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_key_pack(const bcmbal_tm_queue_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->sched_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_DIR)) != 0)
    {
        if (!bcmbal_tm_sched_dir_pack(this->sched_dir, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_ID)) != 0)
    {
        if (!bcmbal_buf_write_u8(buf, (uint8_t) this->id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_queue_key_get_packed_length(const bcmbal_tm_queue_key *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_ID)) != 0)
    {
        count += 4;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_DIR)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_ID)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_key_unpack(bcmbal_tm_queue_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->sched_id))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_DIR)) != 0)
    {
        if (!bcmbal_tm_sched_dir_unpack(&this->sched_dir, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_ID)) != 0)
    {
        if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_DIR)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_key_bounds_check(const bcmbal_tm_queue_key *this, bcmbal_presence_mask fields_present, bcmbal_tm_queue_key_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_KEY_ID_SCHED_DIR)) != 0)
    {
        switch (this->sched_dir)
        {
            case BCMBAL_TM_SCHED_DIR_US:
                break;
            case BCMBAL_TM_SCHED_DIR_DS:
                break;
            default:
                *failed_prop = BCMBAL_TM_QUEUE_KEY_ID_SCHED_DIR;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_queue_cfg_data_set_default(bcmbal_tm_queue_cfg_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_PRIORITY)) != 0)
    {
        this->priority = (bcmbal_tm_priority) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_WEIGHT)) != 0)
    {
        this->weight = (bcmbal_tm_weight) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_RATE)) != 0)
    {
        this->rate.presence_mask = (bcmbal_tm_shaping_id) 0;
        this->rate.sbr = 0;
        this->rate.pbr = 0;
        this->rate.burst = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_BAC)) != 0)
    {
        this->bac.type = BCMBAL_TM_BAC_TYPE_TAILDROP;
        this->bac.u.taildrop.max_size = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_CREATION_MODE)) != 0)
    {
        this->creation_mode = BCMBAL_TM_CREATION_MODE_MANUAL;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_REF_COUNT)) != 0)
    {
        this->ref_count = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_cfg_data_pack(const bcmbal_tm_queue_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_PRIORITY)) != 0)
    {
        if (!bcmbal_buf_write_u8(buf, (uint8_t) this->priority))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_WEIGHT)) != 0)
    {
        if (!bcmbal_buf_write_u8(buf, (uint8_t) this->weight))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_RATE)) != 0)
    {
        if (!bcmbal_tm_shaping_pack(&this->rate, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_BAC)) != 0)
    {
        if (!bcmbal_tm_bac_pack(&this->bac, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_CREATION_MODE)) != 0)
    {
        if (!bcmbal_tm_creation_mode_pack(this->creation_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_REF_COUNT)) != 0)
    {
        if (!bcmbal_buf_write_u8(buf, this->ref_count))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_queue_cfg_data_get_packed_length(const bcmbal_tm_queue_cfg_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_PRIORITY)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_WEIGHT)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_RATE)) != 0)
    {
        count += bcmbal_tm_shaping_get_packed_length(&this->rate);
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_BAC)) != 0)
    {
        count += bcmbal_tm_bac_get_packed_length(&this->bac);
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_CREATION_MODE)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_REF_COUNT)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_cfg_data_unpack(bcmbal_tm_queue_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_PRIORITY)) != 0)
    {
        if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->priority))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_WEIGHT)) != 0)
    {
        if (!bcmbal_buf_read_u8(buf, (uint8_t *) &this->weight))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_RATE)) != 0)
    {
        if (!bcmbal_tm_shaping_unpack(&this->rate, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_BAC)) != 0)
    {
        if (!bcmbal_tm_bac_unpack(&this->bac, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_CREATION_MODE)) != 0)
    {
        if (!bcmbal_tm_creation_mode_unpack(&this->creation_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_REF_COUNT)) != 0)
    {
        if (!bcmbal_buf_read_u8(buf, &this->ref_count))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_PRIORITY)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_WEIGHT)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_RATE)) != 0)
    {
        if (!bcmbal_tm_shaping_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_BAC)) != 0)
    {
        if (!bcmbal_tm_bac_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_CREATION_MODE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_REF_COUNT)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_cfg_data_bounds_check(const bcmbal_tm_queue_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_queue_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_RATE)) != 0)
    {
        if (!bcmbal_tm_shaping_bounds_check(&this->rate))
        {
            *failed_prop = BCMBAL_TM_QUEUE_CFG_ID_RATE;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_BAC)) != 0)
    {
        if (!bcmbal_tm_bac_bounds_check(&this->bac))
        {
            *failed_prop = BCMBAL_TM_QUEUE_CFG_ID_BAC;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_CFG_ID_CREATION_MODE)) != 0)
    {
        switch (this->creation_mode)
        {
            case BCMBAL_TM_CREATION_MODE_MANUAL:
                break;
            case BCMBAL_TM_CREATION_MODE_AUTO:
                break;
            default:
                *failed_prop = BCMBAL_TM_QUEUE_CFG_ID_CREATION_MODE;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_queue_stat_data_set_default(bcmbal_tm_queue_stat_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_OK)) != 0)
    {
        this->packets_ok = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_OK)) != 0)
    {
        this->bytes_ok = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_DISCARDED)) != 0)
    {
        this->packets_discarded = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_DISCARDED)) != 0)
    {
        this->bytes_discarded = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_stat_data_pack(const bcmbal_tm_queue_stat_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_OK)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->packets_ok))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_OK)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->bytes_ok))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_DISCARDED)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->packets_discarded))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_DISCARDED)) != 0)
    {
        if (!bcmbal_buf_write_u64(buf, this->bytes_discarded))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_queue_stat_data_get_packed_length(const bcmbal_tm_queue_stat_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_OK)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_OK)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_DISCARDED)) != 0)
    {
        count += 8;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_DISCARDED)) != 0)
    {
        count += 8;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_stat_data_unpack(bcmbal_tm_queue_stat_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_OK)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->packets_ok))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_OK)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->bytes_ok))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_DISCARDED)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->packets_discarded))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_DISCARDED)) != 0)
    {
        if (!bcmbal_buf_read_u64(buf, &this->bytes_discarded))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_stat_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_OK)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_OK)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_PACKETS_DISCARDED)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_STAT_ID_BYTES_DISCARDED)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 8))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_stat_data_bounds_check(const bcmbal_tm_queue_stat_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_queue_stat_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_queue_ind_data_set_default(bcmbal_tm_queue_ind_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_IND_ID_RET)) != 0)
    {
        this->ret = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ind_data_pack(const bcmbal_tm_queue_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_IND_ID_RET)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, this->ret))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_queue_ind_data_get_packed_length(const bcmbal_tm_queue_ind_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_IND_ID_RET)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ind_data_unpack(bcmbal_tm_queue_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_IND_ID_RET)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, &this->ret))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_QUEUE_IND_ID_RET)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_queue_ind_data_bounds_check(const bcmbal_tm_queue_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_queue_ind_id *failed_prop)
{
    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_sched_key_set_default(bcmbal_tm_sched_key *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_DIR)) != 0)
    {
        this->dir = (bcmbal_tm_sched_dir) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_ID)) != 0)
    {
        this->id = (bcmbal_tm_sched_id) 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_key_pack(const bcmbal_tm_sched_key *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_DIR)) != 0)
    {
        if (!bcmbal_tm_sched_dir_pack(this->dir, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_ID)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, (uint32_t) this->id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_sched_key_get_packed_length(const bcmbal_tm_sched_key *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_DIR)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_ID)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_key_unpack(bcmbal_tm_sched_key *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_DIR)) != 0)
    {
        if (!bcmbal_tm_sched_dir_unpack(&this->dir, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_ID)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, (uint32_t *) &this->id))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_key_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_DIR)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_ID)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_key_bounds_check(const bcmbal_tm_sched_key *this, bcmbal_presence_mask fields_present, bcmbal_tm_sched_key_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_KEY_ID_DIR)) != 0)
    {
        switch (this->dir)
        {
            case BCMBAL_TM_SCHED_DIR_US:
                break;
            case BCMBAL_TM_SCHED_DIR_DS:
                break;
            default:
                *failed_prop = BCMBAL_TM_SCHED_KEY_ID_DIR;
                return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_sched_cfg_data_set_default(bcmbal_tm_sched_cfg_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_OWNER)) != 0)
    {
        this->owner.type = BCMBAL_TM_SCHED_OWNER_TYPE_UNDEFINED;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_TYPE)) != 0)
    {
        this->sched_type = BCMBAL_TM_SCHED_TYPE_NONE;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_PARENT)) != 0)
    {
        this->sched_parent.presence_mask = (bcmbal_tm_sched_parent_id) 0;
        this->sched_parent.sched_id = (bcmbal_tm_sched_id) 0;
        this->sched_parent.priority = (bcmbal_tm_priority) 0;
        this->sched_parent.weight = (bcmbal_tm_weight) 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_CHILD_TYPE)) != 0)
    {
        this->sched_child_type = BCMBAL_TM_SCHED_CHILD_TYPE_QUEUE;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_RATE)) != 0)
    {
        this->rate.presence_mask = (bcmbal_tm_shaping_id) 0;
        this->rate.sbr = 0;
        this->rate.pbr = 0;
        this->rate.burst = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_TCONT_SLA)) != 0)
    {
        this->tcont_sla.presence_mask = (bcmbal_tm_tcont_sla_id) 0;
        this->tcont_sla.extra_bw_elig = BCMBAL_EXTRA_BW_ELIGIBILITY_TYPE_NONE;
        this->tcont_sla.nrt_cbr = 0;
        this->tcont_sla.rt_cbr = 0;
        this->tcont_sla.rt_profile = 0;
        this->tcont_sla.nrt_profile = 0;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_CREATION_MODE)) != 0)
    {
        this->creation_mode = BCMBAL_TM_CREATION_MODE_MANUAL;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_QUEUES)) != 0)
    {
        this->queues.len = 0;
        this->queues.val = NULL;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SUB_SCHEDS)) != 0)
    {
        this->sub_scheds.len = 0;
        this->sub_scheds.val = NULL;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_NUM_PRIORITIES)) != 0)
    {
        this->num_priorities = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_cfg_data_pack(const bcmbal_tm_sched_cfg_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_OWNER)) != 0)
    {
        if (!bcmbal_tm_sched_owner_pack(&this->owner, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_TYPE)) != 0)
    {
        if (!bcmbal_tm_sched_type_pack(this->sched_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_PARENT)) != 0)
    {
        if (!bcmbal_tm_sched_parent_pack(&this->sched_parent, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_CHILD_TYPE)) != 0)
    {
        if (!bcmbal_tm_sched_child_type_pack(this->sched_child_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_RATE)) != 0)
    {
        if (!bcmbal_tm_shaping_pack(&this->rate, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_TCONT_SLA)) != 0)
    {
        if (!bcmbal_tm_tcont_sla_pack(&this->tcont_sla, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_CREATION_MODE)) != 0)
    {
        if (!bcmbal_tm_creation_mode_pack(this->creation_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_QUEUES)) != 0)
    {
        if (!bcmbal_tm_queue_id_list_u8_pack(&this->queues, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SUB_SCHEDS)) != 0)
    {
        if (!bcmbal_tm_sched_id_list_u8_pack(&this->sub_scheds, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_NUM_PRIORITIES)) != 0)
    {
        if (!bcmbal_buf_write_u8(buf, this->num_priorities))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_sched_cfg_data_get_packed_length(const bcmbal_tm_sched_cfg_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_OWNER)) != 0)
    {
        count += bcmbal_tm_sched_owner_get_packed_length(&this->owner);
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_TYPE)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_PARENT)) != 0)
    {
        count += bcmbal_tm_sched_parent_get_packed_length(&this->sched_parent);
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_CHILD_TYPE)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_RATE)) != 0)
    {
        count += bcmbal_tm_shaping_get_packed_length(&this->rate);
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_TCONT_SLA)) != 0)
    {
        count += bcmbal_tm_tcont_sla_get_packed_length(&this->tcont_sla);
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_CREATION_MODE)) != 0)
    {
        count += 1;
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_QUEUES)) != 0)
    {
        count += bcmbal_tm_queue_id_list_u8_get_packed_length(&this->queues);
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SUB_SCHEDS)) != 0)
    {
        count += bcmbal_tm_sched_id_list_u8_get_packed_length(&this->sub_scheds);
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_NUM_PRIORITIES)) != 0)
    {
        count += 1;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_cfg_data_unpack(bcmbal_tm_sched_cfg_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_OWNER)) != 0)
    {
        if (!bcmbal_tm_sched_owner_unpack(&this->owner, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_TYPE)) != 0)
    {
        if (!bcmbal_tm_sched_type_unpack(&this->sched_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_PARENT)) != 0)
    {
        if (!bcmbal_tm_sched_parent_unpack(&this->sched_parent, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_CHILD_TYPE)) != 0)
    {
        if (!bcmbal_tm_sched_child_type_unpack(&this->sched_child_type, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_RATE)) != 0)
    {
        if (!bcmbal_tm_shaping_unpack(&this->rate, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_TCONT_SLA)) != 0)
    {
        if (!bcmbal_tm_tcont_sla_unpack(&this->tcont_sla, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_CREATION_MODE)) != 0)
    {
        if (!bcmbal_tm_creation_mode_unpack(&this->creation_mode, buf))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_QUEUES)) != 0)
    {
        if (!bcmbal_tm_queue_id_list_u8_unpack(&this->queues, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SUB_SCHEDS)) != 0)
    {
        if (!bcmbal_tm_sched_id_list_u8_unpack(&this->sub_scheds, buf, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_NUM_PRIORITIES)) != 0)
    {
        if (!bcmbal_buf_read_u8(buf, &this->num_priorities))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_cfg_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_OWNER)) != 0)
    {
        if (!bcmbal_tm_sched_owner_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_PARENT)) != 0)
    {
        if (!bcmbal_tm_sched_parent_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_CHILD_TYPE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_RATE)) != 0)
    {
        if (!bcmbal_tm_shaping_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_TCONT_SLA)) != 0)
    {
        if (!bcmbal_tm_tcont_sla_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_CREATION_MODE)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_QUEUES)) != 0)
    {
        if (!bcmbal_tm_queue_id_list_u8_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SUB_SCHEDS)) != 0)
    {
        if (!bcmbal_tm_sched_id_list_u8_scan(packed, extra_mem))
        {
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_NUM_PRIORITIES)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 1))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_cfg_data_bounds_check(const bcmbal_tm_sched_cfg_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_sched_cfg_id *failed_prop)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_OWNER)) != 0)
    {
        if (!bcmbal_tm_sched_owner_bounds_check(&this->owner))
        {
            *failed_prop = BCMBAL_TM_SCHED_CFG_ID_OWNER;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_TYPE)) != 0)
    {
        switch (this->sched_type)
        {
            case BCMBAL_TM_SCHED_TYPE_NONE:
                break;
            case BCMBAL_TM_SCHED_TYPE_WFQ:
                break;
            case BCMBAL_TM_SCHED_TYPE_SP:
                break;
            case BCMBAL_TM_SCHED_TYPE_SP_WFQ:
                break;
            default:
                *failed_prop = BCMBAL_TM_SCHED_CFG_ID_SCHED_TYPE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_PARENT)) != 0)
    {
        if (!bcmbal_tm_sched_parent_bounds_check(&this->sched_parent))
        {
            *failed_prop = BCMBAL_TM_SCHED_CFG_ID_SCHED_PARENT;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SCHED_CHILD_TYPE)) != 0)
    {
        switch (this->sched_child_type)
        {
            case BCMBAL_TM_SCHED_CHILD_TYPE_QUEUE:
                break;
            case BCMBAL_TM_SCHED_CHILD_TYPE_SCHED:
                break;
            default:
                *failed_prop = BCMBAL_TM_SCHED_CFG_ID_SCHED_CHILD_TYPE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_RATE)) != 0)
    {
        if (!bcmbal_tm_shaping_bounds_check(&this->rate))
        {
            *failed_prop = BCMBAL_TM_SCHED_CFG_ID_RATE;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_TCONT_SLA)) != 0)
    {
        if (!bcmbal_tm_tcont_sla_bounds_check(&this->tcont_sla))
        {
            *failed_prop = BCMBAL_TM_SCHED_CFG_ID_TCONT_SLA;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_CREATION_MODE)) != 0)
    {
        switch (this->creation_mode)
        {
            case BCMBAL_TM_CREATION_MODE_MANUAL:
                break;
            case BCMBAL_TM_CREATION_MODE_AUTO:
                break;
            default:
                *failed_prop = BCMBAL_TM_SCHED_CFG_ID_CREATION_MODE;
                return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_QUEUES)) != 0)
    {
        if (!bcmbal_tm_queue_id_list_u8_bounds_check(&this->queues))
        {
            *failed_prop = BCMBAL_TM_SCHED_CFG_ID_QUEUES;
            return BCMOS_FALSE;
        }
    }

    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_CFG_ID_SUB_SCHEDS)) != 0)
    {
        if (!bcmbal_tm_sched_id_list_u8_bounds_check(&this->sub_scheds))
        {
            *failed_prop = BCMBAL_TM_SCHED_CFG_ID_SUB_SCHEDS;
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
void bcmbal_tm_sched_ind_data_set_default(bcmbal_tm_sched_ind_data *this, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_IND_ID_RET)) != 0)
    {
        this->ret = 0;
    }
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_ind_data_pack(const bcmbal_tm_sched_ind_data *this, bcmbal_buf *buf, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_IND_ID_RET)) != 0)
    {
        if (!bcmbal_buf_write_u32(buf, this->ret))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
uint32_t bcmbal_tm_sched_ind_data_get_packed_length(const bcmbal_tm_sched_ind_data *this, bcmbal_presence_mask fields_present)
{
    uint32_t count = 0;
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_IND_ID_RET)) != 0)
    {
        count += 4;
    }

    return count;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_ind_data_unpack(bcmbal_tm_sched_ind_data *this, bcmbal_buf *buf, void **extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_IND_ID_RET)) != 0)
    {
        if (!bcmbal_buf_read_u32(buf, &this->ret))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_ind_data_scan(bcmbal_buf *packed, uint32_t *extra_mem, bcmbal_presence_mask fields_present)
{
    if ((fields_present & (1ULL << BCMBAL_TM_SCHED_IND_ID_RET)) != 0)
    {
        if (!bcmbal_buf_skip(packed, 4))
        {
            return BCMOS_FALSE;
        }
    }

    return BCMOS_TRUE;
}

/******************************************************************************/
bcmos_bool bcmbal_tm_sched_ind_data_bounds_check(const bcmbal_tm_sched_ind_data *this, bcmbal_presence_mask fields_present, bcmbal_tm_sched_ind_id *failed_prop)
{
    return BCMOS_TRUE;
}

bcmos_bool bcmbal_obj_has_tag(bcmbal_obj_id obj, bcmbal_obj_tag tag)
{
    switch (obj)
    {
        default:
            return BCMOS_FALSE;
    }
}
