/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *
 *  :>
 *
 *****************************************************************************/
/*
 * cmdline.h - Command line argument helper
 */

#ifndef _CMDLINE_H_
#define _CMDLINE_H_

#include <bcmos_system.h>

/** Argument flags */
typedef enum
{
    CL_ARGUMENT_FLAG_NONE = 0,
    CL_ARGUMENT_FLAG_MANDATORY = 0x1,
} cl_argument_flags;

/** Command line argument */
typedef struct cl_argument
{
    const char *long_name;      /**< Command line option: long form */
    const char *short_name;     /**< Command line option: short form */
    const char *extra_arg;      /**< Extra arguments */
    const char *description;    /**< Description */
    const char *owner;          /**< Owner module */
    cl_argument_flags flags;    /**< Command line argument flags */
} cl_argument;

/** Print usage flags */
typedef enum
{
    CL_ARGUMENT_USAGE_FLAG_NONE = 0,
    CL_ARGUMENT_USAGE_FLAG_OWNER = 0x1, /**< Print argument owners */
} cl_argument_usage_flags;

/** Print usage
 * \param[in]   app                     Application name. Can be NULL
 * \param[in]   arg                     Argument that triggered command line parsing error. Can be NULL
 * \param[in]   supported_args          Array of supported arguments
 * \param[in]   num_supported_args      Number of elements in supported_args[] array
 * \param[in]   flags                   Usage flags
 * \returns     BCM_ERR_PARM
 */
bcmos_errno cl_print_usage(const char *app, const char *arg,
    const cl_argument supported_args[], int num_supported_args,
    cl_argument_usage_flags flags);

/** Validate parameters
 *
 * - make sure that there are no unknown parameters
 * - make sure that all mandatory parameters are present
 *
 * \param[in]   argc                    Number of command line arguments
 * \param[in]   argv                    Command line arguments
 * \param[in]   supported_args          Array of supported arguments
 * \param[in]   num_supported_args      Number of elements in supported_args[] array
 * \returns     BCM_ERR_OK or BCM_ERR_PARM
 */
bcmos_errno cl_validate(int argc, char *argv[],
    const cl_argument supported_args[], int num_supported_args);

/** Get CL parameter by name
 *
 * \param[in]   name                    Parameter name
 * \param[in]   supported_args          Supported arguments array
 * \param[in]   num_supported_args      Supported arguments array size
 * \returns argument descriptor pointer or NULL if not found
 */
const cl_argument *cl_parm_get(const char *name, const cl_argument supported_args[],
    int num_supported_args);

#endif /* _CMDLINE_H_ */
