/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */
#ifndef BCMBAL_APICLI_HELPERS_H_
#define BCMBAL_APICLI_HELPERS_H_

#include <bcmcli.h>
#include <bal_api.h>
#include "bal_api_cli_types.h"

/* Mac name length */
#define BCMBAL_APICLI_MAX_PARM_NAME_LENGTH  BCMCLI_MAX_SEARCH_SUBSTR_LENGTH

/* Max help string length */
#define BCMBAL_APICLI_MAX_PARM_HELP_LENGTH  128

typedef enum bcmbal_apicli_field_descr_flags
{
    BCMBAL_APICLI_FIELD_DESCR_FLAGS_NONE            = 0,
    BCMBAL_APICLI_FIELD_DESCR_FLAGS_PRESENCE_MASK   = (1 << 0)  /* field is a 'presence mask' for a structure */
} bcmbal_apicli_field_descr_flags;

typedef struct bcmbal_apicli_type_descr bcmbal_apicli_type_descr;

/* Structure field descriptor */
typedef struct bcmbal_apicli_field_descr
{
    const char *name;               /* Field name */
    const char *descr;              /* Field description */
    const char *cli_name;           /* Short CLI name. can be missing */
    bcmbal_apicli_type_descr *type; /* Field type */
    uint16_t offset;                /* Offset from the beginning of the type structure */
    bcmbal_apicli_field_descr_flags flags;
} bcmbal_apicli_field_descr;

/* Data type descriptor */
struct bcmbal_apicli_type_descr
{
    const char *name;                       /* Type name */
    const char *descr;                      /* Type description. can be missing */
    const char *cli_name;                   /* Short CLI name. can be missing */
    bcmbal_apicli_base_type_id base_type;   /* Base type: snum, unum, string, ip, enum, etc. */
    uint32_t min_val;                       /* Min value for range check */
    uint32_t max_val;                       /* Max value for range check */
    uint16_t size;                  /* Size */

    /* The following union is qualified by the base_type and contains additional
     * info for array, enum, struct, union */
    union
    {
        bcmcli_enum_val *e;         /* enum value array Contains num_elements+1 values. The last value has name=NULL */
        struct
        {
            uint16_t num_fields;    /* number of elements in the following structure */
            bcmbal_apicli_field_descr *fields;          /* Structure field array. Contains num_elements values */
        } s;
        struct
        {
            uint16_t num_common_fields;                 /* number of non-union fields at the start of the struct */
            bcmbal_apicli_field_descr *common_fields;   /* common field array. Contains num_elements values */
            uint16_t classifier_idx;                    /* index of the classifier field within common_fields */
            bcmbal_apicli_field_descr *union_fields;    /* sub-struct fields under the union (name == NULL if no fields present)
                                                         (one per enum entry in the classifier type, plus one for default) */
        } u;
        struct
        {
            bcmbal_apicli_type_descr *elem_type;        /* Array element type */
            uint8_t len_size;                       /* Byte width of array length field (at start of struct) */
            uint16_t max_size;                      /* Max array size */
        } arr_dyn;
        struct
        {
            bcmbal_apicli_type_descr *elem_type;    /* Array element type */
            uint16_t size;  /* Fixed array size */
        } arr_fixed;
    } x;
};

/* Property descriptor.
 * The 1st 5 fields are exactly the same as in bcmbal_apicli_field_descr
 * ToDo: replace with bcmbal_apicli_field_descr substructure.
 * Requires changes in code generator
 */
typedef struct
{
    const char *name;                       /* C name */
    const char *descr;                      /* Property description */
    const char *cli_name;                   /* CLI name */
    bcmbal_apicli_type_descr *type;         /* Type reference */
    uint16_t offset;                        /* Offset in generated per-group structure */
    uint16_t property;                      /* Property id in per-object management group */
    bcmbal_apicli_prop_access_id access;    /* Access */
} bcmbal_apicli_prop_descr;

/* All APIs return
 * BCM_ERR_OK - ok
 * BCM_ERR_NOENT - if id is in range, but doesn't correspond to any value (a hole)
 * BCM_ERR_RANGE - id is out of range
 */

/* Get object name by id */
bcmos_errno bcmbal_apicli_object_name(bcmbal_obj_id obj, const char **name, const char **descr);

/* Get object structure size */
bcmos_errno bcmbal_apicli_object_struct_size(bcmbal_obj_id obj, bcmbal_mgt_group group, uint16_t subgroup, uint32_t *key_size, uint32_t *key_offset, uint32_t *data_size, uint32_t *data_offset);

/* Get object subgroup (e.g. specific indication) name and description */
bcmos_errno bcmbal_apicli_object_subgroup_name(bcmbal_obj_id obj, bcmbal_mgt_group group, uint16_t subgroup, const char **name, const char **descr);

/* Get property by object, mgt_group, subgroup (e.g. specific indication), property_id */
bcmos_errno bcmbal_apicli_object_property(bcmbal_obj_id obj, bcmbal_mgt_group group, uint16_t subgroup, uint16_t prop, const bcmbal_apicli_prop_descr **descr);

/* Get the number of subgroups present for a given group */
static inline uint16_t bcmbal_apicli_get_subgroup_count(bcmbal_obj_id obj, bcmbal_mgt_group group)
{
    uint16_t count = 0;
    uint32_t dummy;
    while (bcmbal_apicli_object_struct_size(obj, group, count, &dummy, &dummy, &dummy, &dummy) != BCM_ERR_RANGE)
    {
        ++count;
    }

    return count;
}

/* Dump a single property */
bcmos_errno bcmbal_apicli_dump_prop(bcmcli_session *session, const bcmbal_apicli_prop_descr *pd, void *prop_data);

/* Dump a single property value in C initializer format */
bcmos_errno bcmbal_apicli_dump_prop_initializer(bcmcli_session *session, const bcmbal_apicli_prop_descr *pd, void *prop_data);

/* Dump message */
bcmos_errno bcmbal_apicli_msg_dump(bcmcli_session *session, bcmbal_obj *msg);

/* Message group name */
const char *bcmbal_apicli_mgt_group_to_str(bcmbal_mgt_group group);

/* Convert an enum value to the corresponding string */
#define BCMOLT_ENUM_STRING_VAL(enum_name, value)    bcmcli_enum_stringval(enum_name ## _string_table, (value))

/* Enum string tables */
extern bcmcli_enum_val bcmbal_access_terminal_cfg_id_string_table[];
extern bcmcli_enum_val bcmbal_access_terminal_ind_id_string_table[];
extern bcmcli_enum_val bcmbal_access_terminal_key_id_string_table[];
extern bcmcli_enum_val bcmbal_action_id_string_table[];
extern bcmcli_enum_val bcmbal_action_cmd_id_string_table[];
extern bcmcli_enum_val bcmbal_classifier_id_string_table[];
extern bcmcli_enum_val bcmbal_pkt_tag_type_string_table[];
extern bcmcli_enum_val bcmbal_control_string_table[];
extern bcmcli_enum_val bcmbal_dest_type_string_table[];
extern bcmcli_enum_val bcmbal_ds_miss_mode_string_table[];
extern bcmcli_enum_val bcmbal_extra_bw_eligibility_type_string_table[];
extern bcmcli_enum_val bcmbal_flow_cfg_id_string_table[];
extern bcmcli_enum_val bcmbal_flow_ind_id_string_table[];
extern bcmcli_enum_val bcmbal_flow_key_id_string_table[];
extern bcmcli_enum_val bcmbal_flow_stat_id_string_table[];
extern bcmcli_enum_val bcmbal_flow_type_string_table[];
extern bcmcli_enum_val bcmbal_group_cfg_id_string_table[];
extern bcmcli_enum_val bcmbal_group_key_id_string_table[];
extern bcmcli_enum_val bcmbal_group_member_cmd_string_table[];
extern bcmcli_enum_val bcmbal_group_owner_string_table[];
extern bcmcli_enum_val bcmbal_interface_cfg_id_string_table[];
extern bcmcli_enum_val bcmbal_interface_ind_id_string_table[];
extern bcmcli_enum_val bcmbal_interface_key_id_string_table[];
extern bcmcli_enum_val bcmbal_interface_stat_id_string_table[];
extern bcmcli_enum_val bcmbal_intf_type_string_table[];
extern bcmcli_enum_val bcmbal_iwf_mode_string_table[];
extern bcmcli_enum_val bcmbal_packet_cfg_id_string_table[];
extern bcmcli_enum_val bcmbal_packet_ind_id_string_table[];
extern bcmcli_enum_val bcmbal_packet_key_id_string_table[];
extern bcmcli_enum_val bcmbal_sla_id_string_table[];
extern bcmcli_enum_val bcmbal_state_string_table[];
extern bcmcli_enum_val bcmbal_status_string_table[];
extern bcmcli_enum_val bcmbal_subscriber_terminal_cfg_id_string_table[];
extern bcmcli_enum_val bcmbal_subscriber_terminal_ind_id_string_table[];
extern bcmcli_enum_val bcmbal_subscriber_terminal_key_id_string_table[];
extern bcmcli_enum_val bcmbal_subscriber_terminal_stat_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_bac_type_string_table[];
extern bcmcli_enum_val bcmbal_tm_creation_mode_string_table[];
extern bcmcli_enum_val bcmbal_tm_queue_cfg_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_queue_ind_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_queue_key_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_queue_stat_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_sched_cfg_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_sched_child_type_string_table[];
extern bcmcli_enum_val bcmbal_tm_sched_dir_string_table[];
extern bcmcli_enum_val bcmbal_tm_sched_ind_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_sched_key_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_sched_owner_type_string_table[];
extern bcmcli_enum_val bcmbal_tm_sched_owner_agg_port_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_sched_parent_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_sched_type_string_table[];
extern bcmcli_enum_val bcmbal_tm_shaping_id_string_table[];
extern bcmcli_enum_val bcmbal_tm_tcont_sla_id_string_table[];
extern bcmcli_enum_val bcmbal_trx_type_string_table[];
#endif /* BCMBAL_APICLI_HELPERS_H_ */
