#include <bcmos_system.h>
#include <bcmcli.h>
#include <bal_api.h>
#include "bal_api_cli_helpers.h"

/* allow possibly unused descriptors to make the code easier to generate */
#ifdef __GNUC__
#define BCM_DESCR   __attribute__((unused))
#else
#define BCM_DESCR
#endif

/* Unless specified in the XML model, dynamic arrays will have this max size (in bytes, will divide by element size) */
#define DEFAULT_DYN_ARR_MAX_SIZE    2048

/* ==== Base Type Descriptors ==== */
static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint8_t = { .name = "uint8", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNUM, .size = sizeof(uint8_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint16_t = { .name = "uint16", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNUM, .size = sizeof(uint16_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint32_t = { .name = "uint32", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNUM, .size = sizeof(uint32_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint64_t = { .name = "uint64", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNUM, .size = sizeof(uint64_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint8_t_hex = { .name = "uint8_hex", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNUM_HEX, .size = sizeof(uint8_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint16_t_hex = { .name = "uint16_hex", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNUM_HEX, .size = sizeof(uint16_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint32_t_hex = { .name = "uint32_hex", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNUM_HEX, .size = sizeof(uint32_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint64_t_hex = { .name = "uint64_hex", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNUM_HEX, .size = sizeof(uint64_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_int8_t = { .name = "int8", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_SNUM, .size = sizeof(int8_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_int16_t = { .name = "int16", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_SNUM, .size = sizeof(int16_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_int32_t = { .name = "int32", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_SNUM, .size = sizeof(int32_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_int64_t = { .name = "int64", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_SNUM, .size = sizeof(int64_t) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_float = { .name = "float", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_FLOAT, .size = sizeof(float) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_double = { .name = "double", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_FLOAT, .size = sizeof(double) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmos_mac_address = { .name = "mac", .descr = "MAC address", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_MAC, .size = sizeof(bcmos_mac_address) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmos_ipv4_address = { .name = "ipv4", .descr = "IPv4 address", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_IPV4, .size = sizeof(bcmos_ipv4_address) };

static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmos_bool = { .name = "bool", .descr = "Boolean", .base_type = BCMBAL_APICLI_BASE_TYPE_ID_BOOL, .size = sizeof(bcmos_bool) };

/* ==== Object Type Information ==== */
static char *object_name[] = { "access_terminal", "flow", "group", "interface", "packet", "subscriber_terminal", "tm_queue", "tm_sched" };
static char *object_descr[] = { "BAL Access Terminal Object", "BAL Flow", "BAL Group", "BAL interface object", "Packet that can be transmitted or received", "BAL Subscriber Terminal", "Transmit queue", "Scheduling node" };

/* ==== Supporting Types ==== */
bcmcli_enum_val bcmbal_access_terminal_cfg_id_string_table[] = { { .name = "admin_state", .val = BCMBAL_ACCESS_TERMINAL_CFG_ID_ADMIN_STATE }, { .name = "oper_status", .val = BCMBAL_ACCESS_TERMINAL_CFG_ID_OPER_STATUS }, { .name = "iwf_mode", .val = BCMBAL_ACCESS_TERMINAL_CFG_ID_IWF_MODE }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_access_terminal_cfg_id = { .name = "bcmbal_access_terminal_cfg_id", .descr = "Identifiers for all properties contained in the access_terminal_cfg group.", .size = sizeof(bcmbal_access_terminal_cfg_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_access_terminal_cfg_id_string_table } };
bcmcli_enum_val bcmbal_access_terminal_ind_id_string_table[] = { { .name = "admin_state", .val = BCMBAL_ACCESS_TERMINAL_IND_ID_ADMIN_STATE }, { .name = "oper_status", .val = BCMBAL_ACCESS_TERMINAL_IND_ID_OPER_STATUS }, { .name = "iwf_mode", .val = BCMBAL_ACCESS_TERMINAL_IND_ID_IWF_MODE }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_access_terminal_ind_id = { .name = "bcmbal_access_terminal_ind_id", .descr = "Identifiers for all properties contained in the access_terminal_ind group.", .size = sizeof(bcmbal_access_terminal_ind_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_access_terminal_ind_id_string_table } };
bcmcli_enum_val bcmbal_access_terminal_key_id_string_table[] = { { .name = "access_term_id", .val = BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_access_terminal_key_id = { .name = "bcmbal_access_terminal_key_id", .descr = "Identifiers for all properties contained in the access_terminal_key group.", .size = sizeof(bcmbal_access_terminal_key_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_access_terminal_key_id_string_table } };
bcmcli_enum_val bcmbal_action_id_string_table[] = { { .name = "none", .val = BCMBAL_ACTION_ID_NONE }, { .name = "cmds_bitmask", .val = BCMBAL_ACTION_ID_CMDS_BITMASK }, { .name = "o_vid", .val = BCMBAL_ACTION_ID_O_VID }, { .name = "o_pbits", .val = BCMBAL_ACTION_ID_O_PBITS }, { .name = "o_tpid", .val = BCMBAL_ACTION_ID_O_TPID }, { .name = "i_vid", .val = BCMBAL_ACTION_ID_I_VID }, { .name = "i_pbits", .val = BCMBAL_ACTION_ID_I_PBITS }, { .name = "i_tpid", .val = BCMBAL_ACTION_ID_I_TPID }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_action_id = { .name = "bcmbal_action_id", .descr = "action ID", .size = sizeof(bcmbal_action_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM_MASK, .x = { .e = bcmbal_action_id_string_table } };
bcmcli_enum_val bcmbal_action_cmd_id_string_table[] = { { .name = "none", .val = BCMBAL_ACTION_CMD_ID_NONE }, { .name = "add_outer_tag", .val = BCMBAL_ACTION_CMD_ID_ADD_OUTER_TAG }, { .name = "remove_outer_tag", .val = BCMBAL_ACTION_CMD_ID_REMOVE_OUTER_TAG }, { .name = "xlate_outer_tag", .val = BCMBAL_ACTION_CMD_ID_XLATE_OUTER_TAG }, { .name = "xlate_two_tags", .val = BCMBAL_ACTION_CMD_ID_XLATE_TWO_TAGS }, { .name = "discard_ds_bcast", .val = BCMBAL_ACTION_CMD_ID_DISCARD_DS_BCAST }, { .name = "discard_ds_unknown", .val = BCMBAL_ACTION_CMD_ID_DISCARD_DS_UNKNOWN }, { .name = "add_two_tags", .val = BCMBAL_ACTION_CMD_ID_ADD_TWO_TAGS }, { .name = "remove_two_tags", .val = BCMBAL_ACTION_CMD_ID_REMOVE_TWO_TAGS }, { .name = "remark_pbits", .val = BCMBAL_ACTION_CMD_ID_REMARK_PBITS }, { .name = "copy_pbits", .val = BCMBAL_ACTION_CMD_ID_COPY_PBITS }, { .name = "reverse_copy_pbits", .val = BCMBAL_ACTION_CMD_ID_REVERSE_COPY_PBITS }, { .name = "dscp_to_pbits", .val = BCMBAL_ACTION_CMD_ID_DSCP_TO_PBITS }, { .name = "trap_to_host", .val = BCMBAL_ACTION_CMD_ID_TRAP_TO_HOST }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_action_cmd_id = { .name = "bcmbal_action_cmd_id", .descr = "action_cmd_id", .size = sizeof(bcmbal_action_cmd_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM_MASK, .x = { .e = bcmbal_action_cmd_id_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_action_fields[] = { { .name = "presence_mask", .descr = "Presence Mask", .offset = offsetof(bcmbal_action, presence_mask), .type = &type_descr_bcmbal_action_id, .flags = BCMBAL_APICLI_FIELD_DESCR_FLAGS_PRESENCE_MASK }, { .name = "cmds_bitmask", .descr = "Commands bitmask", .offset = offsetof(bcmbal_action, cmds_bitmask), .type = &type_descr_bcmbal_action_cmd_id }, { .name = "o_vid", .descr = "Outer vid", .offset = offsetof(bcmbal_action, o_vid), .type = &type_descr_uint16_t }, { .name = "o_pbits", .descr = "Outer pbits", .offset = offsetof(bcmbal_action, o_pbits), .type = &type_descr_uint8_t }, { .name = "o_tpid", .descr = "Outer tpid", .offset = offsetof(bcmbal_action, o_tpid), .type = &type_descr_uint16_t }, { .name = "i_vid", .descr = "Inner vid", .offset = offsetof(bcmbal_action, i_vid), .type = &type_descr_uint16_t }, { .name = "i_pbits", .descr = "Inner pbits", .offset = offsetof(bcmbal_action, i_pbits), .type = &type_descr_uint8_t }, { .name = "i_tpid", .descr = "Inner tpid", .offset = offsetof(bcmbal_action, i_tpid), .type = &type_descr_uint16_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_action = { .name = "bcmbal_action", .descr = "action", .size = sizeof(bcmbal_action), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_action_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_action_fields } } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_aggregation_port_id_list_u8 = { .name = "bcmbal_aggregation_port_id_list_u8", .descr = "Variable-length list of aggregation_port_id", .size = sizeof(bcmbal_aggregation_port_id_list_u8), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_DYN, .x = { .arr_dyn = { .elem_type = &type_descr_uint16_t, .len_size = 1, .max_size = DEFAULT_DYN_ARR_MAX_SIZE / sizeof(bcmbal_aggregation_port_id) } } };
bcmcli_enum_val bcmbal_classifier_id_string_table[] = { { .name = "none", .val = BCMBAL_CLASSIFIER_ID_NONE }, { .name = "o_tpid", .val = BCMBAL_CLASSIFIER_ID_O_TPID }, { .name = "o_vid", .val = BCMBAL_CLASSIFIER_ID_O_VID }, { .name = "i_tpid", .val = BCMBAL_CLASSIFIER_ID_I_TPID }, { .name = "i_vid", .val = BCMBAL_CLASSIFIER_ID_I_VID }, { .name = "o_pbits", .val = BCMBAL_CLASSIFIER_ID_O_PBITS }, { .name = "i_pbits", .val = BCMBAL_CLASSIFIER_ID_I_PBITS }, { .name = "ether_type", .val = BCMBAL_CLASSIFIER_ID_ETHER_TYPE }, { .name = "dst_mac", .val = BCMBAL_CLASSIFIER_ID_DST_MAC }, { .name = "src_mac", .val = BCMBAL_CLASSIFIER_ID_SRC_MAC }, { .name = "ip_proto", .val = BCMBAL_CLASSIFIER_ID_IP_PROTO }, { .name = "dst_ip", .val = BCMBAL_CLASSIFIER_ID_DST_IP }, { .name = "src_ip", .val = BCMBAL_CLASSIFIER_ID_SRC_IP }, { .name = "src_port", .val = BCMBAL_CLASSIFIER_ID_SRC_PORT }, { .name = "dst_port", .val = BCMBAL_CLASSIFIER_ID_DST_PORT }, { .name = "pkt_tag_type", .val = BCMBAL_CLASSIFIER_ID_PKT_TAG_TYPE }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_classifier_id = { .name = "bcmbal_classifier_id", .descr = "classifier ID", .size = sizeof(bcmbal_classifier_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM_MASK, .x = { .e = bcmbal_classifier_id_string_table } };
bcmcli_enum_val bcmbal_pkt_tag_type_string_table[] = { { .name = "none", .val = BCMBAL_PKT_TAG_TYPE_NONE }, { .name = "untagged", .val = BCMBAL_PKT_TAG_TYPE_UNTAGGED }, { .name = "single_tag", .val = BCMBAL_PKT_TAG_TYPE_SINGLE_TAG }, { .name = "double_tag", .val = BCMBAL_PKT_TAG_TYPE_DOUBLE_TAG }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_pkt_tag_type = { .name = "bcmbal_pkt_tag_type", .descr = "Packet tag type", .size = sizeof(bcmbal_pkt_tag_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM_MASK, .x = { .e = bcmbal_pkt_tag_type_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_classifier_fields[] = { { .name = "presence_mask", .descr = "Presence Mask", .offset = offsetof(bcmbal_classifier, presence_mask), .type = &type_descr_bcmbal_classifier_id, .flags = BCMBAL_APICLI_FIELD_DESCR_FLAGS_PRESENCE_MASK }, { .name = "o_tpid", .descr = "Outer TPID of the packet to be classified", .offset = offsetof(bcmbal_classifier, o_tpid), .type = &type_descr_uint16_t }, { .name = "o_vid", .descr = "Outer VID of the packet to be classified", .offset = offsetof(bcmbal_classifier, o_vid), .type = &type_descr_uint16_t }, { .name = "i_tpid", .descr = "Inner TPID of the packet to be classified", .offset = offsetof(bcmbal_classifier, i_tpid), .type = &type_descr_uint16_t }, { .name = "i_vid", .descr = "Inner VID of the packet to be classified", .offset = offsetof(bcmbal_classifier, i_vid), .type = &type_descr_uint16_t }, { .name = "o_pbits", .descr = "Outer PBITS of the packet to be classified", .offset = offsetof(bcmbal_classifier, o_pbits), .type = &type_descr_uint8_t }, { .name = "i_pbits", .descr = "Inner PBITS of the packet to be classified", .offset = offsetof(bcmbal_classifier, i_pbits), .type = &type_descr_uint8_t }, { .name = "ether_type", .descr = "Ethertype of the packet to be classified", .offset = offsetof(bcmbal_classifier, ether_type), .type = &type_descr_uint16_t }, { .name = "dst_mac", .descr = "Destination MAC address of the packet to be classified", .offset = offsetof(bcmbal_classifier, dst_mac), .type = &type_descr_bcmos_mac_address }, { .name = "src_mac", .descr = "Source MAC address of the packet to be classified", .offset = offsetof(bcmbal_classifier, src_mac), .type = &type_descr_bcmos_mac_address }, { .name = "ip_proto", .descr = "IP protocol of the packet to be classified", .offset = offsetof(bcmbal_classifier, ip_proto), .type = &type_descr_uint8_t }, { .name = "dst_ip", .descr = "Destination IP address of the packet to be classified", .offset = offsetof(bcmbal_classifier, dst_ip), .type = &type_descr_bcmos_ipv4_address }, { .name = "src_ip", .descr = "Source IP address of the packet to be classified", .offset = offsetof(bcmbal_classifier, src_ip), .type = &type_descr_bcmos_ipv4_address }, { .name = "src_port", .descr = "Source port of the packet to be classified", .offset = offsetof(bcmbal_classifier, src_port), .type = &type_descr_uint16_t }, { .name = "dst_port", .descr = "Destination port of the packet to be classified", .offset = offsetof(bcmbal_classifier, dst_port), .type = &type_descr_uint16_t }, { .name = "pkt_tag_type", .descr = "The tag type of the ingress packets", .offset = offsetof(bcmbal_classifier, pkt_tag_type), .type = &type_descr_bcmbal_pkt_tag_type } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_classifier = { .name = "bcmbal_classifier", .descr = "classifier", .size = sizeof(bcmbal_classifier), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_classifier_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_classifier_fields } } };
bcmcli_enum_val bcmbal_control_string_table[] = { { .name = "disable", .val = BCMBAL_CONTROL_DISABLE }, { .name = "enable", .val = BCMBAL_CONTROL_ENABLE }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_control = { .name = "bcmbal_control", .descr = "Generic enable/disable enumeration", .size = sizeof(bcmbal_control), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_control_string_table } };
bcmcli_enum_val bcmbal_dest_type_string_table[] = { { .name = "nni", .val = BCMBAL_DEST_TYPE_NNI }, { .name = "sub_term", .val = BCMBAL_DEST_TYPE_SUB_TERM }, { .name = "host", .val = BCMBAL_DEST_TYPE_HOST }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_dest_type = { .name = "bcmbal_dest_type", .descr = "Destination type", .size = sizeof(bcmbal_dest_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_dest_type_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_dest_fields[] = { { .name = "type", .descr = "packet destination", .offset = offsetof(bcmbal_dest, type), .type = &type_descr_bcmbal_dest_type } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_dest_nni_fields[] = { { .name = "int_id", .descr = "Interface ID", .offset = offsetof(bcmbal_dest, u.nni.int_id) - offsetof(bcmbal_dest, u.nni.int_id), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_dest_nni = { .name = "bcmbal_dest_nni", .descr = "Packet destination nni", .size = sizeof(((bcmbal_dest *)0)->u.nni), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_dest_nni_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_dest_nni_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_dest_sub_term_fields[] = { { .name = "sub_term_id", .descr = "Subscriber terminal ID", .offset = offsetof(bcmbal_dest, u.sub_term.sub_term_id) - offsetof(bcmbal_dest, u.sub_term.sub_term_id), .type = &type_descr_uint32_t }, { .name = "sub_term_uni", .descr = "Subscriber terminal UNI", .offset = offsetof(bcmbal_dest, u.sub_term.sub_term_uni) - offsetof(bcmbal_dest, u.sub_term.sub_term_id), .type = &type_descr_uint16_t }, { .name = "int_id", .descr = "Interface ID", .offset = offsetof(bcmbal_dest, u.sub_term.int_id) - offsetof(bcmbal_dest, u.sub_term.sub_term_id), .type = &type_descr_uint16_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_dest_sub_term = { .name = "bcmbal_dest_sub_term", .descr = "Packet destination subscriber terminal", .size = sizeof(((bcmbal_dest *)0)->u.sub_term), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_dest_sub_term_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_dest_sub_term_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_dest_union_fields[] = { { .name = "u.nni", .descr = "", .offset = offsetof(bcmbal_dest, u.nni), .type = &type_descr_bcmbal_dest_nni }, { .name = "u.sub_term", .descr = "", .offset = offsetof(bcmbal_dest, u.sub_term), .type = &type_descr_bcmbal_dest_sub_term }, { }, { } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_dest = { .name = "bcmbal_dest", .descr = "Packet destination", .size = sizeof(bcmbal_dest), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNION, .x = { .u = { .num_common_fields = sizeof(type_descr_bcmbal_dest_fields) / sizeof(bcmbal_apicli_field_descr), .common_fields = type_descr_bcmbal_dest_fields, .classifier_idx = 0, .union_fields = type_descr_bcmbal_dest_union_fields } } };
bcmcli_enum_val bcmbal_ds_miss_mode_string_table[] = { { .name = "discard", .val = BCMBAL_DS_MISS_MODE_DISCARD }, { .name = "broadcast", .val = BCMBAL_DS_MISS_MODE_BROADCAST }, { .name = "vid", .val = BCMBAL_DS_MISS_MODE_VID }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_ds_miss_mode = { .name = "bcmbal_ds_miss_mode", .descr = "Downstrean action for unknown packets", .size = sizeof(bcmbal_ds_miss_mode), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_ds_miss_mode_string_table } };
bcmcli_enum_val bcmbal_extra_bw_eligibility_type_string_table[] = { { .name = "none", .val = BCMBAL_EXTRA_BW_ELIGIBILITY_TYPE_NONE }, { .name = "not_assured", .val = BCMBAL_EXTRA_BW_ELIGIBILITY_TYPE_NOT_ASSURED }, { .name = "best_effort", .val = BCMBAL_EXTRA_BW_ELIGIBILITY_TYPE_BEST_EFFORT }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_extra_bw_eligibility_type = { .name = "bcmbal_extra_bw_eligibility_type", .descr = "Extra BW Eligibility Type", .size = sizeof(bcmbal_extra_bw_eligibility_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_extra_bw_eligibility_type_string_table } };
bcmcli_enum_val bcmbal_flow_cfg_id_string_table[] = { { .name = "admin_state", .val = BCMBAL_FLOW_CFG_ID_ADMIN_STATE }, { .name = "oper_status", .val = BCMBAL_FLOW_CFG_ID_OPER_STATUS }, { .name = "access_int_id", .val = BCMBAL_FLOW_CFG_ID_ACCESS_INT_ID }, { .name = "network_int_id", .val = BCMBAL_FLOW_CFG_ID_NETWORK_INT_ID }, { .name = "sub_term_id", .val = BCMBAL_FLOW_CFG_ID_SUB_TERM_ID }, { .name = "sub_term_uni_idx", .val = BCMBAL_FLOW_CFG_ID_SUB_TERM_UNI_IDX }, { .name = "svc_port_id", .val = BCMBAL_FLOW_CFG_ID_SVC_PORT_ID }, { .name = "agg_port_id", .val = BCMBAL_FLOW_CFG_ID_AGG_PORT_ID }, { .name = "resolve_mac", .val = BCMBAL_FLOW_CFG_ID_RESOLVE_MAC }, { .name = "classifier", .val = BCMBAL_FLOW_CFG_ID_CLASSIFIER }, { .name = "action", .val = BCMBAL_FLOW_CFG_ID_ACTION }, { .name = "sla", .val = BCMBAL_FLOW_CFG_ID_SLA }, { .name = "cookie", .val = BCMBAL_FLOW_CFG_ID_COOKIE }, { .name = "priority", .val = BCMBAL_FLOW_CFG_ID_PRIORITY }, { .name = "group_id", .val = BCMBAL_FLOW_CFG_ID_GROUP_ID }, { .name = "queue", .val = BCMBAL_FLOW_CFG_ID_QUEUE }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_cfg_id = { .name = "bcmbal_flow_cfg_id", .descr = "Identifiers for all properties contained in the flow_cfg group.", .size = sizeof(bcmbal_flow_cfg_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_flow_cfg_id_string_table } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_id_list_u32 = { .name = "bcmbal_flow_id_list_u32", .descr = "Variable-length list of flow_id", .size = sizeof(bcmbal_flow_id_list_u32), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_DYN, .x = { .arr_dyn = { .elem_type = &type_descr_uint32_t, .len_size = 4, .max_size = DEFAULT_DYN_ARR_MAX_SIZE / sizeof(bcmbal_flow_id) } } };
bcmcli_enum_val bcmbal_flow_ind_id_string_table[] = { { .name = "admin_state", .val = BCMBAL_FLOW_IND_ID_ADMIN_STATE }, { .name = "oper_status", .val = BCMBAL_FLOW_IND_ID_OPER_STATUS }, { .name = "access_int_id", .val = BCMBAL_FLOW_IND_ID_ACCESS_INT_ID }, { .name = "network_int_id", .val = BCMBAL_FLOW_IND_ID_NETWORK_INT_ID }, { .name = "sub_term_id", .val = BCMBAL_FLOW_IND_ID_SUB_TERM_ID }, { .name = "svc_port_id", .val = BCMBAL_FLOW_IND_ID_SVC_PORT_ID }, { .name = "agg_port_id", .val = BCMBAL_FLOW_IND_ID_AGG_PORT_ID }, { .name = "resolve_mac", .val = BCMBAL_FLOW_IND_ID_RESOLVE_MAC }, { .name = "base_tc_id", .val = BCMBAL_FLOW_IND_ID_BASE_TC_ID }, { .name = "classifier", .val = BCMBAL_FLOW_IND_ID_CLASSIFIER }, { .name = "action", .val = BCMBAL_FLOW_IND_ID_ACTION }, { .name = "sla", .val = BCMBAL_FLOW_IND_ID_SLA }, { .name = "cookie", .val = BCMBAL_FLOW_IND_ID_COOKIE }, { .name = "priority", .val = BCMBAL_FLOW_IND_ID_PRIORITY }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_ind_id = { .name = "bcmbal_flow_ind_id", .descr = "Identifiers for all properties contained in the flow_ind group.", .size = sizeof(bcmbal_flow_ind_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_flow_ind_id_string_table } };
bcmcli_enum_val bcmbal_flow_key_id_string_table[] = { { .name = "flow_id", .val = BCMBAL_FLOW_KEY_ID_FLOW_ID }, { .name = "flow_type", .val = BCMBAL_FLOW_KEY_ID_FLOW_TYPE }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_key_id = { .name = "bcmbal_flow_key_id", .descr = "Identifiers for all properties contained in the flow_key group.", .size = sizeof(bcmbal_flow_key_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_flow_key_id_string_table } };
bcmcli_enum_val bcmbal_flow_stat_id_string_table[] = { { .name = "rx_packets", .val = BCMBAL_FLOW_STAT_ID_RX_PACKETS }, { .name = "rx_bytes", .val = BCMBAL_FLOW_STAT_ID_RX_BYTES }, { .name = "tx_packets", .val = BCMBAL_FLOW_STAT_ID_TX_PACKETS }, { .name = "tx_bytes", .val = BCMBAL_FLOW_STAT_ID_TX_BYTES }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_stat_id = { .name = "bcmbal_flow_stat_id", .descr = "Identifiers for all properties contained in the flow_stat group.", .size = sizeof(bcmbal_flow_stat_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_flow_stat_id_string_table } };
bcmcli_enum_val bcmbal_flow_type_string_table[] = { { .name = "upstream", .val = BCMBAL_FLOW_TYPE_UPSTREAM }, { .name = "downstream", .val = BCMBAL_FLOW_TYPE_DOWNSTREAM }, { .name = "broadcast", .val = BCMBAL_FLOW_TYPE_BROADCAST }, { .name = "multicast", .val = BCMBAL_FLOW_TYPE_MULTICAST }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_type = { .name = "bcmbal_flow_type", .descr = "Flow Type", .size = sizeof(bcmbal_flow_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_flow_type_string_table } };
bcmcli_enum_val bcmbal_group_cfg_id_string_table[] = { { .name = "members_cmd", .val = BCMBAL_GROUP_CFG_ID_MEMBERS_CMD }, { .name = "members", .val = BCMBAL_GROUP_CFG_ID_MEMBERS }, { .name = "cookie", .val = BCMBAL_GROUP_CFG_ID_COOKIE }, { .name = "flows", .val = BCMBAL_GROUP_CFG_ID_FLOWS }, { .name = "owner", .val = BCMBAL_GROUP_CFG_ID_OWNER }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_group_cfg_id = { .name = "bcmbal_group_cfg_id", .descr = "Identifiers for all properties contained in the group_cfg group.", .size = sizeof(bcmbal_group_cfg_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_group_cfg_id_string_table } };
bcmcli_enum_val bcmbal_group_key_id_string_table[] = { { .name = "group_id", .val = BCMBAL_GROUP_KEY_ID_GROUP_ID }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_group_key_id = { .name = "bcmbal_group_key_id", .descr = "Identifiers for all properties contained in the group_key group.", .size = sizeof(bcmbal_group_key_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_group_key_id_string_table } };
bcmcli_enum_val bcmbal_group_member_cmd_string_table[] = { { .name = "add_members", .val = BCMBAL_GROUP_MEMBER_CMD_ADD_MEMBERS }, { .name = "rem_members", .val = BCMBAL_GROUP_MEMBER_CMD_REM_MEMBERS }, { .name = "set_members", .val = BCMBAL_GROUP_MEMBER_CMD_SET_MEMBERS }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_group_member_cmd = { .name = "bcmbal_group_member_cmd", .descr = "Member operation type", .size = sizeof(bcmbal_group_member_cmd), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_group_member_cmd_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_queue_ref_fields[] = { { .name = "sched_id", .descr = "Scheduler (tm_sched) ID", .offset = offsetof(bcmbal_tm_queue_ref, sched_id), .type = &type_descr_uint32_t }, { .name = "queue_id", .descr = "Queue ID", .offset = offsetof(bcmbal_tm_queue_ref, queue_id), .type = &type_descr_uint8_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_ref = { .name = "bcmbal_tm_queue_ref", .descr = "Queue Reference", .size = sizeof(bcmbal_tm_queue_ref), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_queue_ref_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_queue_ref_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_group_member_info_fields[] = { { .name = "intf_id", .descr = "Access interface id for this member", .offset = offsetof(bcmbal_group_member_info, intf_id), .type = &type_descr_uint32_t }, { .name = "svc_port_id", .descr = "The multicast \"GEM\" for this member", .offset = offsetof(bcmbal_group_member_info, svc_port_id), .type = &type_descr_uint16_t }, { .name = "action", .descr = "VLAN actions", .offset = offsetof(bcmbal_group_member_info, action), .type = &type_descr_bcmbal_action }, { .name = "queue", .descr = "Egress queue", .offset = offsetof(bcmbal_group_member_info, queue), .type = &type_descr_bcmbal_tm_queue_ref } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_group_member_info = { .name = "bcmbal_group_member_info", .descr = "Group Member Info", .size = sizeof(bcmbal_group_member_info), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_group_member_info_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_group_member_info_fields } } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_group_member_info_list_u16 = { .name = "bcmbal_group_member_info_list_u16", .descr = "Variable-length list of group_member_info", .size = sizeof(bcmbal_group_member_info_list_u16), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_DYN, .x = { .arr_dyn = { .elem_type = &type_descr_bcmbal_group_member_info, .len_size = 2, .max_size = DEFAULT_DYN_ARR_MAX_SIZE / sizeof(bcmbal_group_member_info) } } };
bcmcli_enum_val bcmbal_group_owner_string_table[] = { { .name = "none", .val = BCMBAL_GROUP_OWNER_NONE }, { .name = "multicast", .val = BCMBAL_GROUP_OWNER_MULTICAST }, { .name = "unicast", .val = BCMBAL_GROUP_OWNER_UNICAST }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_group_owner = { .name = "bcmbal_group_owner", .descr = "owner of the group", .size = sizeof(bcmbal_group_owner), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_group_owner_string_table } };
bcmcli_enum_val bcmbal_interface_cfg_id_string_table[] = { { .name = "admin_state", .val = BCMBAL_INTERFACE_CFG_ID_ADMIN_STATE }, { .name = "oper_status", .val = BCMBAL_INTERFACE_CFG_ID_OPER_STATUS }, { .name = "min_data_agg_port_id", .val = BCMBAL_INTERFACE_CFG_ID_MIN_DATA_AGG_PORT_ID }, { .name = "min_data_svc_port_id", .val = BCMBAL_INTERFACE_CFG_ID_MIN_DATA_SVC_PORT_ID }, { .name = "transceiver_type", .val = BCMBAL_INTERFACE_CFG_ID_TRANSCEIVER_TYPE }, { .name = "ds_miss_mode", .val = BCMBAL_INTERFACE_CFG_ID_DS_MISS_MODE }, { .name = "mtu", .val = BCMBAL_INTERFACE_CFG_ID_MTU }, { .name = "flow_control", .val = BCMBAL_INTERFACE_CFG_ID_FLOW_CONTROL }, { .name = "ds_tm", .val = BCMBAL_INTERFACE_CFG_ID_DS_TM }, { .name = "us_tm", .val = BCMBAL_INTERFACE_CFG_ID_US_TM }, { .name = "sub_term_id_list", .val = BCMBAL_INTERFACE_CFG_ID_SUB_TERM_ID_LIST }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_interface_cfg_id = { .name = "bcmbal_interface_cfg_id", .descr = "Identifiers for all properties contained in the interface_cfg group.", .size = sizeof(bcmbal_interface_cfg_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_interface_cfg_id_string_table } };
bcmcli_enum_val bcmbal_interface_ind_id_string_table[] = { { .name = "admin_state", .val = BCMBAL_INTERFACE_IND_ID_ADMIN_STATE }, { .name = "oper_status", .val = BCMBAL_INTERFACE_IND_ID_OPER_STATUS }, { .name = "min_data_agg_port_id", .val = BCMBAL_INTERFACE_IND_ID_MIN_DATA_AGG_PORT_ID }, { .name = "min_data_svc_port_id", .val = BCMBAL_INTERFACE_IND_ID_MIN_DATA_SVC_PORT_ID }, { .name = "transceiver_type", .val = BCMBAL_INTERFACE_IND_ID_TRANSCEIVER_TYPE }, { .name = "ds_miss_mode", .val = BCMBAL_INTERFACE_IND_ID_DS_MISS_MODE }, { .name = "mtu", .val = BCMBAL_INTERFACE_IND_ID_MTU }, { .name = "flow_control", .val = BCMBAL_INTERFACE_IND_ID_FLOW_CONTROL }, { .name = "ds_tm", .val = BCMBAL_INTERFACE_IND_ID_DS_TM }, { .name = "us_tm", .val = BCMBAL_INTERFACE_IND_ID_US_TM }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_interface_ind_id = { .name = "bcmbal_interface_ind_id", .descr = "Identifiers for all properties contained in the interface_ind group.", .size = sizeof(bcmbal_interface_ind_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_interface_ind_id_string_table } };
bcmcli_enum_val bcmbal_interface_key_id_string_table[] = { { .name = "intf_id", .val = BCMBAL_INTERFACE_KEY_ID_INTF_ID }, { .name = "intf_type", .val = BCMBAL_INTERFACE_KEY_ID_INTF_TYPE }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_interface_key_id = { .name = "bcmbal_interface_key_id", .descr = "Identifiers for all properties contained in the interface_key group.", .size = sizeof(bcmbal_interface_key_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_interface_key_id_string_table } };
bcmcli_enum_val bcmbal_interface_stat_id_string_table[] = { { .name = "rx_packets", .val = BCMBAL_INTERFACE_STAT_ID_RX_PACKETS }, { .name = "rx_bytes", .val = BCMBAL_INTERFACE_STAT_ID_RX_BYTES }, { .name = "tx_packets", .val = BCMBAL_INTERFACE_STAT_ID_TX_PACKETS }, { .name = "tx_bytes", .val = BCMBAL_INTERFACE_STAT_ID_TX_BYTES }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_interface_stat_id = { .name = "bcmbal_interface_stat_id", .descr = "Identifiers for all properties contained in the interface_stat group.", .size = sizeof(bcmbal_interface_stat_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_interface_stat_id_string_table } };
bcmcli_enum_val bcmbal_intf_type_string_table[] = { { .name = "nni", .val = BCMBAL_INTF_TYPE_NNI }, { .name = "pon", .val = BCMBAL_INTF_TYPE_PON }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_intf_type = { .name = "bcmbal_intf_type", .descr = "Interface type", .size = sizeof(bcmbal_intf_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_intf_type_string_table } };
bcmcli_enum_val bcmbal_iwf_mode_string_table[] = { { .name = "direct_mapping", .val = BCMBAL_IWF_MODE_DIRECT_MAPPING }, { .name = "per_flow", .val = BCMBAL_IWF_MODE_PER_FLOW }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_iwf_mode = { .name = "bcmbal_iwf_mode", .descr = "Interworking Function Mode", .size = sizeof(bcmbal_iwf_mode), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_iwf_mode_string_table } };
bcmcli_enum_val bcmbal_packet_cfg_id_string_table[] = { { .name = "flow_id", .val = BCMBAL_PACKET_CFG_ID_FLOW_ID }, { .name = "flow_type", .val = BCMBAL_PACKET_CFG_ID_FLOW_TYPE }, { .name = "intf_id", .val = BCMBAL_PACKET_CFG_ID_INTF_ID }, { .name = "intf_type", .val = BCMBAL_PACKET_CFG_ID_INTF_TYPE }, { .name = "svc_port", .val = BCMBAL_PACKET_CFG_ID_SVC_PORT }, { .name = "flow_cookie", .val = BCMBAL_PACKET_CFG_ID_FLOW_COOKIE }, { .name = "pkt", .val = BCMBAL_PACKET_CFG_ID_PKT }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_packet_cfg_id = { .name = "bcmbal_packet_cfg_id", .descr = "Identifiers for all properties contained in the packet_cfg group.", .size = sizeof(bcmbal_packet_cfg_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_packet_cfg_id_string_table } };
bcmcli_enum_val bcmbal_packet_ind_id_string_table[] = { { .name = "flow_id", .val = BCMBAL_PACKET_IND_ID_FLOW_ID }, { .name = "flow_type", .val = BCMBAL_PACKET_IND_ID_FLOW_TYPE }, { .name = "intf_id", .val = BCMBAL_PACKET_IND_ID_INTF_ID }, { .name = "intf_type", .val = BCMBAL_PACKET_IND_ID_INTF_TYPE }, { .name = "svc_port", .val = BCMBAL_PACKET_IND_ID_SVC_PORT }, { .name = "flow_cookie", .val = BCMBAL_PACKET_IND_ID_FLOW_COOKIE }, { .name = "pkt", .val = BCMBAL_PACKET_IND_ID_PKT }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_packet_ind_id = { .name = "bcmbal_packet_ind_id", .descr = "Identifiers for all properties contained in the packet_ind group.", .size = sizeof(bcmbal_packet_ind_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_packet_ind_id_string_table } };
bcmcli_enum_val bcmbal_packet_key_id_string_table[] = { { .name = "reserved", .val = BCMBAL_PACKET_KEY_ID_RESERVED }, { .name = "packet_send_dest", .val = BCMBAL_PACKET_KEY_ID_PACKET_SEND_DEST }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_packet_key_id = { .name = "bcmbal_packet_key_id", .descr = "Identifiers for all properties contained in the packet_key group.", .size = sizeof(bcmbal_packet_key_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_packet_key_id_string_table } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint8_t_arr_10 = { .name = "uint8_t[10]", .descr = "Array of 10 elements of type uint8_t", .size = sizeof(uint8_t[10]), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_FIXED, .x = { .arr_fixed = { .elem_type = &type_descr_uint8_t, .size = 10 } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_password_fields[] = { { .name = "arr", .descr = "Array", .offset = offsetof(bcmbal_password, arr), .type = &type_descr_uint8_t_arr_10 } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_password = { .name = "bcmbal_password", .descr = "Password", .size = sizeof(bcmbal_password), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_password_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_password_fields } } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint8_t_arr_36 = { .name = "uint8_t[36]", .descr = "Array of 36 elements of type uint8_t", .size = sizeof(uint8_t[36]), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_FIXED, .x = { .arr_fixed = { .elem_type = &type_descr_uint8_t, .size = 36 } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_registration_id_fields[] = { { .name = "arr", .descr = "ONU registration ID", .offset = offsetof(bcmbal_registration_id, arr), .type = &type_descr_uint8_t_arr_36 } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_registration_id = { .name = "bcmbal_registration_id", .descr = "Registration id", .size = sizeof(bcmbal_registration_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_registration_id_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_registration_id_fields } } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_uint8_t_arr_4 = { .name = "uint8_t[4]", .descr = "Array of 4 elements of type uint8_t", .size = sizeof(uint8_t[4]), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_FIXED, .x = { .arr_fixed = { .elem_type = &type_descr_uint8_t, .size = 4 } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_serial_number_fields[] = { { .name = "vendor_id", .descr = "vendor id", .offset = offsetof(bcmbal_serial_number, vendor_id), .type = &type_descr_uint8_t_arr_4 }, { .name = "vendor_specific", .descr = "vendor specific", .offset = offsetof(bcmbal_serial_number, vendor_specific), .type = &type_descr_uint8_t_arr_4 } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_serial_number = { .name = "bcmbal_serial_number", .descr = "Serial number", .size = sizeof(bcmbal_serial_number), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_serial_number_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_serial_number_fields } } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_service_port_id_list_u8 = { .name = "bcmbal_service_port_id_list_u8", .descr = "Variable-length list of service_port_id", .size = sizeof(bcmbal_service_port_id_list_u8), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_DYN, .x = { .arr_dyn = { .elem_type = &type_descr_uint16_t, .len_size = 1, .max_size = DEFAULT_DYN_ARR_MAX_SIZE / sizeof(bcmbal_service_port_id) } } };
bcmcli_enum_val bcmbal_sla_id_string_table[] = { { .name = "none", .val = BCMBAL_SLA_ID_NONE }, { .name = "min_rate", .val = BCMBAL_SLA_ID_MIN_RATE }, { .name = "max_rate", .val = BCMBAL_SLA_ID_MAX_RATE }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_sla_id = { .name = "bcmbal_sla_id", .descr = "SLA ID", .size = sizeof(bcmbal_sla_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM_MASK, .x = { .e = bcmbal_sla_id_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_sla_fields[] = { { .name = "presence_mask", .descr = "Presence Mask", .offset = offsetof(bcmbal_sla, presence_mask), .type = &type_descr_bcmbal_sla_id, .flags = BCMBAL_APICLI_FIELD_DESCR_FLAGS_PRESENCE_MASK }, { .name = "min_rate", .descr = "The minimal rate for this flow, in kilobits per second (optional)", .offset = offsetof(bcmbal_sla, min_rate), .type = &type_descr_uint32_t }, { .name = "max_rate", .descr = "The maximum rate for this flow, in kilobits per second (optional)", .offset = offsetof(bcmbal_sla, max_rate), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_sla = { .name = "bcmbal_sla", .descr = "SLA", .size = sizeof(bcmbal_sla), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_sla_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_sla_fields } } };
bcmcli_enum_val bcmbal_state_string_table[] = { { .name = "up", .val = BCMBAL_STATE_UP }, { .name = "down", .val = BCMBAL_STATE_DOWN }, { .name = "testing", .val = BCMBAL_STATE_TESTING }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_state = { .name = "bcmbal_state", .descr = "Admin state values for access terminal object", .size = sizeof(bcmbal_state), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_state_string_table } };
bcmcli_enum_val bcmbal_status_string_table[] = { { .name = "up", .val = BCMBAL_STATUS_UP }, { .name = "down", .val = BCMBAL_STATUS_DOWN }, { .name = "testing", .val = BCMBAL_STATUS_TESTING }, { .name = "not_present", .val = BCMBAL_STATUS_NOT_PRESENT }, { .name = "lower_layer_down", .val = BCMBAL_STATUS_LOWER_LAYER_DOWN }, { .name = "unknown", .val = BCMBAL_STATUS_UNKNOWN }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_status = { .name = "bcmbal_status", .descr = "Oper status values", .size = sizeof(bcmbal_status), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_status_string_table } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_sub_id_list_u16 = { .name = "bcmbal_sub_id_list_u16", .descr = "Variable-length list of sub_id", .size = sizeof(bcmbal_sub_id_list_u16), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_DYN, .x = { .arr_dyn = { .elem_type = &type_descr_uint32_t, .len_size = 2, .max_size = DEFAULT_DYN_ARR_MAX_SIZE / sizeof(bcmbal_sub_id) } } };
bcmcli_enum_val bcmbal_subscriber_terminal_cfg_id_string_table[] = { { .name = "admin_state", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_ADMIN_STATE }, { .name = "oper_status", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_OPER_STATUS }, { .name = "serial_number", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SERIAL_NUMBER }, { .name = "password", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_PASSWORD }, { .name = "registration_id", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_REGISTRATION_ID }, { .name = "svc_port_id", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID }, { .name = "mac_address", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_MAC_ADDRESS }, { .name = "ds_tm", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_DS_TM }, { .name = "us_tm", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_US_TM }, { .name = "svc_port_id_list", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID_LIST }, { .name = "agg_port_id_list", .val = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_AGG_PORT_ID_LIST }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_cfg_id = { .name = "bcmbal_subscriber_terminal_cfg_id", .descr = "Identifiers for all properties contained in the subscriber_terminal_cfg group.", .size = sizeof(bcmbal_subscriber_terminal_cfg_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_subscriber_terminal_cfg_id_string_table } };
bcmcli_enum_val bcmbal_subscriber_terminal_ind_id_string_table[] = { { .name = "admin_state", .val = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_ADMIN_STATE }, { .name = "oper_status", .val = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_OPER_STATUS }, { .name = "serial_number", .val = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SERIAL_NUMBER }, { .name = "password", .val = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_PASSWORD }, { .name = "registration_id", .val = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_REGISTRATION_ID }, { .name = "svc_port_id", .val = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SVC_PORT_ID }, { .name = "mac_address", .val = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_MAC_ADDRESS }, { .name = "ds_tm", .val = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_DS_TM }, { .name = "us_tm", .val = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_US_TM }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_ind_id = { .name = "bcmbal_subscriber_terminal_ind_id", .descr = "Identifiers for all properties contained in the subscriber_terminal_ind group.", .size = sizeof(bcmbal_subscriber_terminal_ind_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_subscriber_terminal_ind_id_string_table } };
bcmcli_enum_val bcmbal_subscriber_terminal_key_id_string_table[] = { { .name = "sub_term_id", .val = BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_SUB_TERM_ID }, { .name = "intf_id", .val = BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_INTF_ID }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_key_id = { .name = "bcmbal_subscriber_terminal_key_id", .descr = "Identifiers for all properties contained in the subscriber_terminal_key group.", .size = sizeof(bcmbal_subscriber_terminal_key_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_subscriber_terminal_key_id_string_table } };
bcmcli_enum_val bcmbal_subscriber_terminal_stat_id_string_table[] = { { .name = "rx_packets", .val = BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_PACKETS }, { .name = "rx_bytes", .val = BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_BYTES }, { .name = "tx_packets", .val = BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_PACKETS }, { .name = "tx_bytes", .val = BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_BYTES }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_stat_id = { .name = "bcmbal_subscriber_terminal_stat_id", .descr = "Identifiers for all properties contained in the subscriber_terminal_stat group.", .size = sizeof(bcmbal_subscriber_terminal_stat_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_subscriber_terminal_stat_id_string_table } };
bcmcli_enum_val bcmbal_tm_bac_type_string_table[] = { { .name = "taildrop", .val = BCMBAL_TM_BAC_TYPE_TAILDROP }, { .name = "wtaildrop", .val = BCMBAL_TM_BAC_TYPE_WTAILDROP }, { .name = "red", .val = BCMBAL_TM_BAC_TYPE_RED }, { .name = "wred", .val = BCMBAL_TM_BAC_TYPE_WRED }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_bac_type = { .name = "bcmbal_tm_bac_type", .descr = "Buffer Admission Control Type", .size = sizeof(bcmbal_tm_bac_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_bac_type_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_red_fields[] = { { .name = "min_threshold", .descr = "Min threshold in percent of max queue size", .offset = offsetof(bcmbal_tm_red, min_threshold), .type = &type_descr_uint8_t }, { .name = "max_threshold", .descr = "Max threshold in percent of max queue size", .offset = offsetof(bcmbal_tm_red, max_threshold), .type = &type_descr_uint8_t }, { .name = "max_probability", .descr = "Discard probability for occupancy between min_threshold and max_threshold", .offset = offsetof(bcmbal_tm_red, max_probability), .type = &type_descr_uint8_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_red = { .name = "bcmbal_tm_red", .descr = "Random Early Discard Configuration", .size = sizeof(bcmbal_tm_red), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_red_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_red_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_bac_fields[] = { { .name = "type", .descr = "Buffer Admission Control Type", .offset = offsetof(bcmbal_tm_bac, type), .type = &type_descr_bcmbal_tm_bac_type } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_bac_taildrop_fields[] = { { .name = "max_size", .descr = "max number of packets in the queue", .offset = offsetof(bcmbal_tm_bac, u.taildrop.max_size) - offsetof(bcmbal_tm_bac, u.taildrop.max_size), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_bac_taildrop = { .name = "bcmbal_tm_bac_taildrop", .descr = "tm_bac taildrop", .size = sizeof(((bcmbal_tm_bac *)0)->u.taildrop), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_bac_taildrop_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_bac_taildrop_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_bac_red_fields[] = { { .name = "red", .descr = "Random Early Discard configuration", .offset = offsetof(bcmbal_tm_bac, u.red.red) - offsetof(bcmbal_tm_bac, u.red.red), .type = &type_descr_bcmbal_tm_red } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_bac_red = { .name = "bcmbal_tm_bac_red", .descr = "tm_bac red", .size = sizeof(((bcmbal_tm_bac *)0)->u.red), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_bac_red_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_bac_red_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_bac_wred_fields[] = { { .name = "green", .descr = "Green Random Early Discard Configuration", .offset = offsetof(bcmbal_tm_bac, u.wred.green) - offsetof(bcmbal_tm_bac, u.wred.green), .type = &type_descr_bcmbal_tm_red }, { .name = "yellow", .descr = "Yellow Random Early Discard Configuration", .offset = offsetof(bcmbal_tm_bac, u.wred.yellow) - offsetof(bcmbal_tm_bac, u.wred.green), .type = &type_descr_bcmbal_tm_red }, { .name = "red", .descr = "Red Random Early Discard Configuration", .offset = offsetof(bcmbal_tm_bac, u.wred.red) - offsetof(bcmbal_tm_bac, u.wred.green), .type = &type_descr_bcmbal_tm_red } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_bac_wred = { .name = "bcmbal_tm_bac_wred", .descr = "tm_bac wred", .size = sizeof(((bcmbal_tm_bac *)0)->u.wred), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_bac_wred_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_bac_wred_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_bac_union_fields[] = { { .name = "u.taildrop", .descr = "", .offset = offsetof(bcmbal_tm_bac, u.taildrop), .type = &type_descr_bcmbal_tm_bac_taildrop }, { }, { .name = "u.red", .descr = "", .offset = offsetof(bcmbal_tm_bac, u.red), .type = &type_descr_bcmbal_tm_bac_red }, { .name = "u.wred", .descr = "", .offset = offsetof(bcmbal_tm_bac, u.wred), .type = &type_descr_bcmbal_tm_bac_wred }, { } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_bac = { .name = "bcmbal_tm_bac", .descr = "Queue Buffer Admission Control", .size = sizeof(bcmbal_tm_bac), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNION, .x = { .u = { .num_common_fields = sizeof(type_descr_bcmbal_tm_bac_fields) / sizeof(bcmbal_apicli_field_descr), .common_fields = type_descr_bcmbal_tm_bac_fields, .classifier_idx = 0, .union_fields = type_descr_bcmbal_tm_bac_union_fields } } };
bcmcli_enum_val bcmbal_tm_creation_mode_string_table[] = { { .name = "manual", .val = BCMBAL_TM_CREATION_MODE_MANUAL }, { .name = "auto", .val = BCMBAL_TM_CREATION_MODE_AUTO }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_creation_mode = { .name = "bcmbal_tm_creation_mode", .descr = "TM Creation Mode", .size = sizeof(bcmbal_tm_creation_mode), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_creation_mode_string_table } };
bcmcli_enum_val bcmbal_tm_queue_cfg_id_string_table[] = { { .name = "priority", .val = BCMBAL_TM_QUEUE_CFG_ID_PRIORITY }, { .name = "weight", .val = BCMBAL_TM_QUEUE_CFG_ID_WEIGHT }, { .name = "rate", .val = BCMBAL_TM_QUEUE_CFG_ID_RATE }, { .name = "bac", .val = BCMBAL_TM_QUEUE_CFG_ID_BAC }, { .name = "creation_mode", .val = BCMBAL_TM_QUEUE_CFG_ID_CREATION_MODE }, { .name = "ref_count", .val = BCMBAL_TM_QUEUE_CFG_ID_REF_COUNT }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_cfg_id = { .name = "bcmbal_tm_queue_cfg_id", .descr = "Identifiers for all properties contained in the tm_queue_cfg group.", .size = sizeof(bcmbal_tm_queue_cfg_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_queue_cfg_id_string_table } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_id_list_u8 = { .name = "bcmbal_tm_queue_id_list_u8", .descr = "Variable-length list of tm_queue_id", .size = sizeof(bcmbal_tm_queue_id_list_u8), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_DYN, .x = { .arr_dyn = { .elem_type = &type_descr_uint8_t, .len_size = 1, .max_size = DEFAULT_DYN_ARR_MAX_SIZE / sizeof(bcmbal_tm_queue_id) } } };
bcmcli_enum_val bcmbal_tm_queue_ind_id_string_table[] = { { .name = "ret", .val = BCMBAL_TM_QUEUE_IND_ID_RET }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_ind_id = { .name = "bcmbal_tm_queue_ind_id", .descr = "Identifiers for all properties contained in the tm_queue_ind group.", .size = sizeof(bcmbal_tm_queue_ind_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_queue_ind_id_string_table } };
bcmcli_enum_val bcmbal_tm_queue_key_id_string_table[] = { { .name = "sched_id", .val = BCMBAL_TM_QUEUE_KEY_ID_SCHED_ID }, { .name = "sched_dir", .val = BCMBAL_TM_QUEUE_KEY_ID_SCHED_DIR }, { .name = "id", .val = BCMBAL_TM_QUEUE_KEY_ID_ID }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_key_id = { .name = "bcmbal_tm_queue_key_id", .descr = "Identifiers for all properties contained in the tm_queue_key group.", .size = sizeof(bcmbal_tm_queue_key_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_queue_key_id_string_table } };
bcmcli_enum_val bcmbal_tm_queue_stat_id_string_table[] = { { .name = "packets_ok", .val = BCMBAL_TM_QUEUE_STAT_ID_PACKETS_OK }, { .name = "bytes_ok", .val = BCMBAL_TM_QUEUE_STAT_ID_BYTES_OK }, { .name = "packets_discarded", .val = BCMBAL_TM_QUEUE_STAT_ID_PACKETS_DISCARDED }, { .name = "bytes_discarded", .val = BCMBAL_TM_QUEUE_STAT_ID_BYTES_DISCARDED }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_stat_id = { .name = "bcmbal_tm_queue_stat_id", .descr = "Identifiers for all properties contained in the tm_queue_stat group.", .size = sizeof(bcmbal_tm_queue_stat_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_queue_stat_id_string_table } };
bcmcli_enum_val bcmbal_tm_sched_cfg_id_string_table[] = { { .name = "owner", .val = BCMBAL_TM_SCHED_CFG_ID_OWNER }, { .name = "sched_type", .val = BCMBAL_TM_SCHED_CFG_ID_SCHED_TYPE }, { .name = "sched_parent", .val = BCMBAL_TM_SCHED_CFG_ID_SCHED_PARENT }, { .name = "sched_child_type", .val = BCMBAL_TM_SCHED_CFG_ID_SCHED_CHILD_TYPE }, { .name = "rate", .val = BCMBAL_TM_SCHED_CFG_ID_RATE }, { .name = "tcont_sla", .val = BCMBAL_TM_SCHED_CFG_ID_TCONT_SLA }, { .name = "creation_mode", .val = BCMBAL_TM_SCHED_CFG_ID_CREATION_MODE }, { .name = "queues", .val = BCMBAL_TM_SCHED_CFG_ID_QUEUES }, { .name = "sub_scheds", .val = BCMBAL_TM_SCHED_CFG_ID_SUB_SCHEDS }, { .name = "num_priorities", .val = BCMBAL_TM_SCHED_CFG_ID_NUM_PRIORITIES }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_cfg_id = { .name = "bcmbal_tm_sched_cfg_id", .descr = "Identifiers for all properties contained in the tm_sched_cfg group.", .size = sizeof(bcmbal_tm_sched_cfg_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_sched_cfg_id_string_table } };
bcmcli_enum_val bcmbal_tm_sched_child_type_string_table[] = { { .name = "queue", .val = BCMBAL_TM_SCHED_CHILD_TYPE_QUEUE }, { .name = "sched", .val = BCMBAL_TM_SCHED_CHILD_TYPE_SCHED }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_child_type = { .name = "bcmbal_tm_sched_child_type", .descr = "Scheduling Level for the Children TM ", .size = sizeof(bcmbal_tm_sched_child_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_sched_child_type_string_table } };
bcmcli_enum_val bcmbal_tm_sched_dir_string_table[] = { { .name = "us", .val = BCMBAL_TM_SCHED_DIR_US }, { .name = "ds", .val = BCMBAL_TM_SCHED_DIR_DS }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_dir = { .name = "bcmbal_tm_sched_dir", .descr = "Traffic Direction", .size = sizeof(bcmbal_tm_sched_dir), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_sched_dir_string_table } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_id_list_u8 = { .name = "bcmbal_tm_sched_id_list_u8", .descr = "Variable-length list of tm_sched_id", .size = sizeof(bcmbal_tm_sched_id_list_u8), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_DYN, .x = { .arr_dyn = { .elem_type = &type_descr_uint32_t, .len_size = 1, .max_size = DEFAULT_DYN_ARR_MAX_SIZE / sizeof(bcmbal_tm_sched_id) } } };
bcmcli_enum_val bcmbal_tm_sched_ind_id_string_table[] = { { .name = "ret", .val = BCMBAL_TM_SCHED_IND_ID_RET }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_ind_id = { .name = "bcmbal_tm_sched_ind_id", .descr = "Identifiers for all properties contained in the tm_sched_ind group.", .size = sizeof(bcmbal_tm_sched_ind_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_sched_ind_id_string_table } };
bcmcli_enum_val bcmbal_tm_sched_key_id_string_table[] = { { .name = "dir", .val = BCMBAL_TM_SCHED_KEY_ID_DIR }, { .name = "id", .val = BCMBAL_TM_SCHED_KEY_ID_ID }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_key_id = { .name = "bcmbal_tm_sched_key_id", .descr = "Identifiers for all properties contained in the tm_sched_key group.", .size = sizeof(bcmbal_tm_sched_key_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_sched_key_id_string_table } };
bcmcli_enum_val bcmbal_tm_sched_owner_type_string_table[] = { { .name = "undefined", .val = BCMBAL_TM_SCHED_OWNER_TYPE_UNDEFINED }, { .name = "interface", .val = BCMBAL_TM_SCHED_OWNER_TYPE_INTERFACE }, { .name = "sub_term", .val = BCMBAL_TM_SCHED_OWNER_TYPE_SUB_TERM }, { .name = "agg_port", .val = BCMBAL_TM_SCHED_OWNER_TYPE_AGG_PORT }, { .name = "uni", .val = BCMBAL_TM_SCHED_OWNER_TYPE_UNI }, { .name = "virtual", .val = BCMBAL_TM_SCHED_OWNER_TYPE_VIRTUAL }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_type = { .name = "bcmbal_tm_sched_owner_type", .descr = "TM Scheduler Owner Type", .size = sizeof(bcmbal_tm_sched_owner_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_sched_owner_type_string_table } };
bcmcli_enum_val bcmbal_tm_sched_owner_agg_port_id_string_table[] = { { .name = "none", .val = BCMBAL_TM_SCHED_OWNER_AGG_PORT_ID_NONE }, { .name = "intf_id", .val = BCMBAL_TM_SCHED_OWNER_AGG_PORT_ID_INTF_ID }, { .name = "sub_term_id", .val = BCMBAL_TM_SCHED_OWNER_AGG_PORT_ID_SUB_TERM_ID }, { .name = "agg_port_id", .val = BCMBAL_TM_SCHED_OWNER_AGG_PORT_ID_AGG_PORT_ID }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_agg_port_id = { .name = "bcmbal_tm_sched_owner_agg_port_id", .descr = "tm_sched_owner agg_port ID", .size = sizeof(bcmbal_tm_sched_owner_agg_port_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM_MASK, .x = { .e = bcmbal_tm_sched_owner_agg_port_id_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_fields[] = { { .name = "type", .descr = "Owner type", .offset = offsetof(bcmbal_tm_sched_owner, type), .type = &type_descr_bcmbal_tm_sched_owner_type } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_interface_fields[] = { { .name = "intf_type", .descr = "Interface Type", .offset = offsetof(bcmbal_tm_sched_owner, u.interface.intf_type) - offsetof(bcmbal_tm_sched_owner, u.interface.intf_type), .type = &type_descr_bcmbal_intf_type }, { .name = "intf_id", .descr = "Interface ID", .offset = offsetof(bcmbal_tm_sched_owner, u.interface.intf_id) - offsetof(bcmbal_tm_sched_owner, u.interface.intf_type), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_interface = { .name = "bcmbal_tm_sched_owner_interface", .descr = "tm_sched_owner interface", .size = sizeof(((bcmbal_tm_sched_owner *)0)->u.interface), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_sched_owner_interface_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_sched_owner_interface_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_sub_term_fields[] = { { .name = "intf_id", .descr = "PON interface id", .offset = offsetof(bcmbal_tm_sched_owner, u.sub_term.intf_id) - offsetof(bcmbal_tm_sched_owner, u.sub_term.intf_id), .type = &type_descr_uint32_t }, { .name = "sub_term_id", .descr = "Subscriber terminal ID", .offset = offsetof(bcmbal_tm_sched_owner, u.sub_term.sub_term_id) - offsetof(bcmbal_tm_sched_owner, u.sub_term.intf_id), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_sub_term = { .name = "bcmbal_tm_sched_owner_sub_term", .descr = "tm_sched_owner subs_term", .size = sizeof(((bcmbal_tm_sched_owner *)0)->u.sub_term), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_sched_owner_sub_term_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_sched_owner_sub_term_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_agg_port_fields[] = { { .name = "presence_mask", .descr = "Presence Mask", .offset = offsetof(bcmbal_tm_sched_owner, u.agg_port.presence_mask) - offsetof(bcmbal_tm_sched_owner, u.agg_port.presence_mask), .type = &type_descr_bcmbal_tm_sched_owner_agg_port_id, .flags = BCMBAL_APICLI_FIELD_DESCR_FLAGS_PRESENCE_MASK }, { .name = "intf_id", .descr = "PON interface id", .offset = offsetof(bcmbal_tm_sched_owner, u.agg_port.intf_id) - offsetof(bcmbal_tm_sched_owner, u.agg_port.presence_mask), .type = &type_descr_uint8_t }, { .name = "sub_term_id", .descr = "Subscriber terminal id", .offset = offsetof(bcmbal_tm_sched_owner, u.agg_port.sub_term_id) - offsetof(bcmbal_tm_sched_owner, u.agg_port.presence_mask), .type = &type_descr_uint32_t }, { .name = "agg_port_id", .descr = "Aggregation port id", .offset = offsetof(bcmbal_tm_sched_owner, u.agg_port.agg_port_id) - offsetof(bcmbal_tm_sched_owner, u.agg_port.presence_mask), .type = &type_descr_uint16_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_agg_port = { .name = "bcmbal_tm_sched_owner_agg_port", .descr = "tm_sched_owner agg_port", .size = sizeof(((bcmbal_tm_sched_owner *)0)->u.agg_port), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_sched_owner_agg_port_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_sched_owner_agg_port_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_uni_fields[] = { { .name = "intf_id", .descr = "PON interface id", .offset = offsetof(bcmbal_tm_sched_owner, u.uni.intf_id) - offsetof(bcmbal_tm_sched_owner, u.uni.intf_id), .type = &type_descr_uint8_t }, { .name = "sub_term_id", .descr = "Subscriber terminal id", .offset = offsetof(bcmbal_tm_sched_owner, u.uni.sub_term_id) - offsetof(bcmbal_tm_sched_owner, u.uni.intf_id), .type = &type_descr_uint32_t }, { .name = "idx", .descr = "Index at subscriber terminal", .offset = offsetof(bcmbal_tm_sched_owner, u.uni.idx) - offsetof(bcmbal_tm_sched_owner, u.uni.intf_id), .type = &type_descr_uint8_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_uni = { .name = "bcmbal_tm_sched_owner_uni", .descr = "tm_sched_owner uni", .size = sizeof(((bcmbal_tm_sched_owner *)0)->u.uni), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_sched_owner_uni_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_sched_owner_uni_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_virtual_fields[] = { { .name = "idx", .descr = "Owner index", .offset = offsetof(bcmbal_tm_sched_owner, u.virtual.idx) - offsetof(bcmbal_tm_sched_owner, u.virtual.idx), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_virtual = { .name = "bcmbal_tm_sched_owner_virtual", .descr = "tm_sched_owner virtual", .size = sizeof(((bcmbal_tm_sched_owner *)0)->u.virtual), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_sched_owner_virtual_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_sched_owner_virtual_fields } } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner_union_fields[] = { { }, { .name = "u.interface", .descr = "", .offset = offsetof(bcmbal_tm_sched_owner, u.interface), .type = &type_descr_bcmbal_tm_sched_owner_interface }, { .name = "u.sub_term", .descr = "", .offset = offsetof(bcmbal_tm_sched_owner, u.sub_term), .type = &type_descr_bcmbal_tm_sched_owner_sub_term }, { .name = "u.agg_port", .descr = "", .offset = offsetof(bcmbal_tm_sched_owner, u.agg_port), .type = &type_descr_bcmbal_tm_sched_owner_agg_port }, { .name = "u.uni", .descr = "", .offset = offsetof(bcmbal_tm_sched_owner, u.uni), .type = &type_descr_bcmbal_tm_sched_owner_uni }, { .name = "u.virtual", .descr = "", .offset = offsetof(bcmbal_tm_sched_owner, u.virtual), .type = &type_descr_bcmbal_tm_sched_owner_virtual }, { } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_owner = { .name = "bcmbal_tm_sched_owner", .descr = "TM Scheduler Owner", .size = sizeof(bcmbal_tm_sched_owner), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_UNION, .x = { .u = { .num_common_fields = sizeof(type_descr_bcmbal_tm_sched_owner_fields) / sizeof(bcmbal_apicli_field_descr), .common_fields = type_descr_bcmbal_tm_sched_owner_fields, .classifier_idx = 0, .union_fields = type_descr_bcmbal_tm_sched_owner_union_fields } } };
bcmcli_enum_val bcmbal_tm_sched_parent_id_string_table[] = { { .name = "none", .val = BCMBAL_TM_SCHED_PARENT_ID_NONE }, { .name = "sched_id", .val = BCMBAL_TM_SCHED_PARENT_ID_SCHED_ID }, { .name = "priority", .val = BCMBAL_TM_SCHED_PARENT_ID_PRIORITY }, { .name = "weight", .val = BCMBAL_TM_SCHED_PARENT_ID_WEIGHT }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_parent_id = { .name = "bcmbal_tm_sched_parent_id", .descr = "tm_sched_parent ID", .size = sizeof(bcmbal_tm_sched_parent_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM_MASK, .x = { .e = bcmbal_tm_sched_parent_id_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_parent_fields[] = { { .name = "presence_mask", .descr = "Presence Mask", .offset = offsetof(bcmbal_tm_sched_parent, presence_mask), .type = &type_descr_bcmbal_tm_sched_parent_id, .flags = BCMBAL_APICLI_FIELD_DESCR_FLAGS_PRESENCE_MASK }, { .name = "sched_id", .descr = "Parent scheduler id", .offset = offsetof(bcmbal_tm_sched_parent, sched_id), .type = &type_descr_uint32_t }, { .name = "priority", .descr = "Priority", .offset = offsetof(bcmbal_tm_sched_parent, priority), .type = &type_descr_uint8_t }, { .name = "weight", .descr = "Weight", .offset = offsetof(bcmbal_tm_sched_parent, weight), .type = &type_descr_uint8_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_parent = { .name = "bcmbal_tm_sched_parent", .descr = "Scheduling Parent Connect Point", .size = sizeof(bcmbal_tm_sched_parent), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_sched_parent_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_sched_parent_fields } } };
bcmcli_enum_val bcmbal_tm_sched_type_string_table[] = { { .name = "none", .val = BCMBAL_TM_SCHED_TYPE_NONE }, { .name = "wfq", .val = BCMBAL_TM_SCHED_TYPE_WFQ }, { .name = "sp", .val = BCMBAL_TM_SCHED_TYPE_SP }, { .name = "sp_wfq", .val = BCMBAL_TM_SCHED_TYPE_SP_WFQ }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_type = { .name = "bcmbal_tm_sched_type", .descr = "Scheduler Type", .size = sizeof(bcmbal_tm_sched_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_tm_sched_type_string_table } };
bcmcli_enum_val bcmbal_tm_shaping_id_string_table[] = { { .name = "none", .val = BCMBAL_TM_SHAPING_ID_NONE }, { .name = "sbr", .val = BCMBAL_TM_SHAPING_ID_SBR }, { .name = "pbr", .val = BCMBAL_TM_SHAPING_ID_PBR }, { .name = "burst", .val = BCMBAL_TM_SHAPING_ID_BURST }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_shaping_id = { .name = "bcmbal_tm_shaping_id", .descr = "tm_shaping ID", .size = sizeof(bcmbal_tm_shaping_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM_MASK, .x = { .e = bcmbal_tm_shaping_id_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_shaping_fields[] = { { .name = "presence_mask", .descr = "Presence Mask", .offset = offsetof(bcmbal_tm_shaping, presence_mask), .type = &type_descr_bcmbal_tm_shaping_id, .flags = BCMBAL_APICLI_FIELD_DESCR_FLAGS_PRESENCE_MASK }, { .name = "sbr", .descr = "Sustained Bit Rate (kbps)", .offset = offsetof(bcmbal_tm_shaping, sbr), .type = &type_descr_uint32_t }, { .name = "pbr", .descr = "Peak Bit Rate (kbps)", .offset = offsetof(bcmbal_tm_shaping, pbr), .type = &type_descr_uint32_t }, { .name = "burst", .descr = "Max Burst Bytes at Peak Bit Rate", .offset = offsetof(bcmbal_tm_shaping, burst), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_shaping = { .name = "bcmbal_tm_shaping", .descr = "Shaping Parameters", .size = sizeof(bcmbal_tm_shaping), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_shaping_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_shaping_fields } } };
bcmcli_enum_val bcmbal_tm_tcont_sla_id_string_table[] = { { .name = "none", .val = BCMBAL_TM_TCONT_SLA_ID_NONE }, { .name = "extra_bw_elig", .val = BCMBAL_TM_TCONT_SLA_ID_EXTRA_BW_ELIG }, { .name = "nrt_cbr", .val = BCMBAL_TM_TCONT_SLA_ID_NRT_CBR }, { .name = "rt_cbr", .val = BCMBAL_TM_TCONT_SLA_ID_RT_CBR }, { .name = "rt_profile", .val = BCMBAL_TM_TCONT_SLA_ID_RT_PROFILE }, { .name = "nrt_profile", .val = BCMBAL_TM_TCONT_SLA_ID_NRT_PROFILE }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_tcont_sla_id = { .name = "bcmbal_tm_tcont_sla_id", .descr = "tm_tcont_sla ID", .size = sizeof(bcmbal_tm_tcont_sla_id), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM_MASK, .x = { .e = bcmbal_tm_tcont_sla_id_string_table } };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_tcont_sla_fields[] = { { .name = "presence_mask", .descr = "Presence Mask", .offset = offsetof(bcmbal_tm_tcont_sla, presence_mask), .type = &type_descr_bcmbal_tm_tcont_sla_id, .flags = BCMBAL_APICLI_FIELD_DESCR_FLAGS_PRESENCE_MASK }, { .name = "extra_bw_elig", .descr = "Extra BW eligibility type", .offset = offsetof(bcmbal_tm_tcont_sla, extra_bw_elig), .type = &type_descr_bcmbal_extra_bw_eligibility_type }, { .name = "nrt_cbr", .descr = "NRT CBR", .offset = offsetof(bcmbal_tm_tcont_sla, nrt_cbr), .type = &type_descr_uint8_t }, { .name = "rt_cbr", .descr = "RT_CBR", .offset = offsetof(bcmbal_tm_tcont_sla, rt_cbr), .type = &type_descr_uint8_t }, { .name = "rt_profile", .descr = "RT Profile", .offset = offsetof(bcmbal_tm_tcont_sla, rt_profile), .type = &type_descr_uint8_t }, { .name = "nrt_profile", .descr = "NRT Profile", .offset = offsetof(bcmbal_tm_tcont_sla, nrt_profile), .type = &type_descr_uint8_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_tcont_sla = { .name = "bcmbal_tm_tcont_sla", .descr = "ITU-PON Extended SLA Parameters", .size = sizeof(bcmbal_tm_tcont_sla), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_tcont_sla_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_tcont_sla_fields } } };
bcmcli_enum_val bcmbal_trx_type_string_table[] = { { .name = "gpon_sps_43_48", .val = BCMBAL_TRX_TYPE_GPON_SPS_43_48 }, { .name = "gpon_sps_sog_4321", .val = BCMBAL_TRX_TYPE_GPON_SPS_SOG_4321 }, { .name = "gpon_lte_3680_m", .val = BCMBAL_TRX_TYPE_GPON_LTE_3680_M }, { .name = "gpon_source_photonics", .val = BCMBAL_TRX_TYPE_GPON_SOURCE_PHOTONICS }, { .name = "gpon_lte_3680_p", .val = BCMBAL_TRX_TYPE_GPON_LTE_3680_P }, { .name = "xgpon_lth_7222_pc", .val = BCMBAL_TRX_TYPE_XGPON_LTH_7222_PC }, { .name = "xgpon_lth_7226_pc", .val = BCMBAL_TRX_TYPE_XGPON_LTH_7226_PC }, { .name = "xgpon_lth_5302_pc", .val = BCMBAL_TRX_TYPE_XGPON_LTH_5302_PC }, BCMCLI_ENUM_LAST };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_trx_type = { .name = "bcmbal_trx_type", .descr = "Transceiver types", .size = sizeof(bcmbal_trx_type), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ENUM, .x = { .e = bcmbal_trx_type_string_table } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_u8_list_u32 = { .name = "bcmbal_u8_list_u32", .descr = "Variable-length list of U8", .size = sizeof(bcmbal_u8_list_u32), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_ARR_DYN, .x = { .arr_dyn = { .elem_type = &type_descr_uint8_t, .len_size = 4, .max_size = DEFAULT_DYN_ARR_MAX_SIZE / sizeof(uint8_t) } } };

/* ==== Object: access_terminal ==== */

/* Group: access_terminal - key */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_access_terminal_key_access_term_id = { .name = "access_term_id", .descr = "Reserved (set to 0)", .access = 0, .property = BCMBAL_ACCESS_TERMINAL_KEY_ID_ACCESS_TERM_ID, .offset = offsetof(bcmbal_access_terminal_key, access_term_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr * BCM_DESCR access_terminal_key_prop_array[] = { &prop_descr_access_terminal_key_access_term_id };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_access_terminal_key_fields[] = { { .name = "access_term_id", .descr = "Reserved (set to 0)", .offset = offsetof(bcmbal_access_terminal_key, access_term_id), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_access_terminal_key = { .name = "bcmbal_access_terminal_key", .descr = "key", .size = sizeof(bcmbal_access_terminal_key), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_access_terminal_key_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_access_terminal_key_fields } } };

/* Group: access_terminal - cfg */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_access_terminal_cfg_admin_state = { .name = "admin_state", .descr = "Administrative state", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_ACCESS_TERMINAL_CFG_ID_ADMIN_STATE, .offset = offsetof(bcmbal_access_terminal_cfg_data, admin_state), .type = &type_descr_bcmbal_state };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_access_terminal_cfg_oper_status = { .name = "oper_status", .descr = "Operational status", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_ACCESS_TERMINAL_CFG_ID_OPER_STATUS, .offset = offsetof(bcmbal_access_terminal_cfg_data, oper_status), .type = &type_descr_bcmbal_status };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_access_terminal_cfg_iwf_mode = { .name = "iwf_mode", .descr = "The interworking mode", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_ACCESS_TERMINAL_CFG_ID_IWF_MODE, .offset = offsetof(bcmbal_access_terminal_cfg_data, iwf_mode), .type = &type_descr_bcmbal_iwf_mode };
static bcmbal_apicli_prop_descr * BCM_DESCR access_terminal_cfg_prop_array[] = { &prop_descr_access_terminal_cfg_admin_state, &prop_descr_access_terminal_cfg_oper_status, &prop_descr_access_terminal_cfg_iwf_mode };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_access_terminal_cfg_data_fields[] = { { .name = "admin_state", .descr = "Administrative state", .offset = offsetof(bcmbal_access_terminal_cfg_data, admin_state), .type = &type_descr_bcmbal_state }, { .name = "oper_status", .descr = "Operational status", .offset = offsetof(bcmbal_access_terminal_cfg_data, oper_status), .type = &type_descr_bcmbal_status }, { .name = "iwf_mode", .descr = "The interworking mode", .offset = offsetof(bcmbal_access_terminal_cfg_data, iwf_mode), .type = &type_descr_bcmbal_iwf_mode } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_access_terminal_cfg_data = { .name = "bcmbal_access_terminal_cfg_data", .descr = "cfg", .size = sizeof(bcmbal_access_terminal_cfg_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_access_terminal_cfg_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_access_terminal_cfg_data_fields } } };

/* Group: access_terminal - ind */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_access_terminal_ind_admin_state = { .name = "admin_state", .descr = "Current administrative state", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_ACCESS_TERMINAL_IND_ID_ADMIN_STATE, .offset = offsetof(bcmbal_access_terminal_ind_data, admin_state), .type = &type_descr_bcmbal_state };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_access_terminal_ind_oper_status = { .name = "oper_status", .descr = "Current operational status", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_ACCESS_TERMINAL_IND_ID_OPER_STATUS, .offset = offsetof(bcmbal_access_terminal_ind_data, oper_status), .type = &type_descr_bcmbal_status };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_access_terminal_ind_iwf_mode = { .name = "iwf_mode", .descr = "The interworking mode", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_ACCESS_TERMINAL_IND_ID_IWF_MODE, .offset = offsetof(bcmbal_access_terminal_ind_data, iwf_mode), .type = &type_descr_bcmbal_iwf_mode };
static bcmbal_apicli_prop_descr * BCM_DESCR access_terminal_ind_prop_array[] = { &prop_descr_access_terminal_ind_admin_state, &prop_descr_access_terminal_ind_oper_status, &prop_descr_access_terminal_ind_iwf_mode };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_access_terminal_ind_data_fields[] = { { .name = "admin_state", .descr = "Current administrative state", .offset = offsetof(bcmbal_access_terminal_ind_data, admin_state), .type = &type_descr_bcmbal_state }, { .name = "oper_status", .descr = "Current operational status", .offset = offsetof(bcmbal_access_terminal_ind_data, oper_status), .type = &type_descr_bcmbal_status }, { .name = "iwf_mode", .descr = "The interworking mode", .offset = offsetof(bcmbal_access_terminal_ind_data, iwf_mode), .type = &type_descr_bcmbal_iwf_mode } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_access_terminal_ind_data = { .name = "bcmbal_access_terminal_ind_data", .descr = "Access Terminal Indication", .size = sizeof(bcmbal_access_terminal_ind_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_access_terminal_ind_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_access_terminal_ind_data_fields } } };

/* ==== Object: flow ==== */

/* Group: flow - cfg */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_admin_state = { .name = "admin_state", .descr = "Administrative state", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_ADMIN_STATE, .offset = offsetof(bcmbal_flow_cfg_data, admin_state), .type = &type_descr_bcmbal_state };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_oper_status = { .name = "oper_status", .descr = "Operational status", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_FLOW_CFG_ID_OPER_STATUS, .offset = offsetof(bcmbal_flow_cfg_data, oper_status), .type = &type_descr_bcmbal_status };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_access_int_id = { .name = "access_int_id", .descr = "The ID of the subscriber side interface; i.e. PON", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_ACCESS_INT_ID, .offset = offsetof(bcmbal_flow_cfg_data, access_int_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_network_int_id = { .name = "network_int_id", .descr = "The ID of the network side interface; i.e. NNI", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_NETWORK_INT_ID, .offset = offsetof(bcmbal_flow_cfg_data, network_int_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_sub_term_id = { .name = "sub_term_id", .descr = "The ID of the subsccriber terminal device", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_SUB_TERM_ID, .offset = offsetof(bcmbal_flow_cfg_data, sub_term_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_sub_term_uni_idx = { .name = "sub_term_uni_idx", .descr = "The index of the subsccriber terminal uni port the flow is related to", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_SUB_TERM_UNI_IDX, .offset = offsetof(bcmbal_flow_cfg_data, sub_term_uni_idx), .type = &type_descr_uint8_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_svc_port_id = { .name = "svc_port_id", .descr = "The ID of the service port (for GPON/XGPON - GEM ID)", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_SVC_PORT_ID, .offset = offsetof(bcmbal_flow_cfg_data, svc_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_agg_port_id = { .name = "agg_port_id", .descr = "The ID of the aggregate port (for GPON/XGPON - ALLOC ID)", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_AGG_PORT_ID, .offset = offsetof(bcmbal_flow_cfg_data, agg_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_resolve_mac = { .name = "resolve_mac", .descr = "A flag indicating if the MAC address table should be used in DS GEM resolution", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_RESOLVE_MAC, .offset = offsetof(bcmbal_flow_cfg_data, resolve_mac), .type = &type_descr_bcmos_bool };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_classifier = { .name = "classifier", .descr = "The classifier for this flow", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_CLASSIFIER, .offset = offsetof(bcmbal_flow_cfg_data, classifier), .type = &type_descr_bcmbal_classifier };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_action = { .name = "action", .descr = "The action associated with the flow", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_ACTION, .offset = offsetof(bcmbal_flow_cfg_data, action), .type = &type_descr_bcmbal_action };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_sla = { .name = "sla", .descr = "SLA parameters for this flow", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_SLA, .offset = offsetof(bcmbal_flow_cfg_data, sla), .type = &type_descr_bcmbal_sla };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_cookie = { .name = "cookie", .descr = "Application cookie", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_COOKIE, .offset = offsetof(bcmbal_flow_cfg_data, cookie), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_priority = { .name = "priority", .descr = "Priority", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_PRIORITY, .offset = offsetof(bcmbal_flow_cfg_data, priority), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_group_id = { .name = "group_id", .descr = "RW - The multicast group associated with this flow, valid for type MULTICAST only", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_GROUP_ID, .offset = offsetof(bcmbal_flow_cfg_data, group_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_cfg_queue = { .name = "queue", .descr = "Egress queue", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_CFG_ID_QUEUE, .offset = offsetof(bcmbal_flow_cfg_data, queue), .type = &type_descr_bcmbal_tm_queue_ref };
static bcmbal_apicli_prop_descr * BCM_DESCR flow_cfg_prop_array[] = { &prop_descr_flow_cfg_admin_state, &prop_descr_flow_cfg_oper_status, &prop_descr_flow_cfg_access_int_id, &prop_descr_flow_cfg_network_int_id, &prop_descr_flow_cfg_sub_term_id, &prop_descr_flow_cfg_sub_term_uni_idx, &prop_descr_flow_cfg_svc_port_id, &prop_descr_flow_cfg_agg_port_id, &prop_descr_flow_cfg_resolve_mac, &prop_descr_flow_cfg_classifier, &prop_descr_flow_cfg_action, &prop_descr_flow_cfg_sla, &prop_descr_flow_cfg_cookie, &prop_descr_flow_cfg_priority, &prop_descr_flow_cfg_group_id, &prop_descr_flow_cfg_queue };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_flow_cfg_data_fields[] = { { .name = "admin_state", .descr = "Administrative state", .offset = offsetof(bcmbal_flow_cfg_data, admin_state), .type = &type_descr_bcmbal_state }, { .name = "oper_status", .descr = "Operational status", .offset = offsetof(bcmbal_flow_cfg_data, oper_status), .type = &type_descr_bcmbal_status }, { .name = "access_int_id", .descr = "The ID of the subscriber side interface; i.e. PON", .offset = offsetof(bcmbal_flow_cfg_data, access_int_id), .type = &type_descr_uint32_t }, { .name = "network_int_id", .descr = "The ID of the network side interface; i.e. NNI", .offset = offsetof(bcmbal_flow_cfg_data, network_int_id), .type = &type_descr_uint32_t }, { .name = "sub_term_id", .descr = "The ID of the subsccriber terminal device", .offset = offsetof(bcmbal_flow_cfg_data, sub_term_id), .type = &type_descr_uint32_t }, { .name = "sub_term_uni_idx", .descr = "The index of the subsccriber terminal uni port the flow is related to", .offset = offsetof(bcmbal_flow_cfg_data, sub_term_uni_idx), .type = &type_descr_uint8_t }, { .name = "svc_port_id", .descr = "The ID of the service port (for GPON/XGPON - GEM ID)", .offset = offsetof(bcmbal_flow_cfg_data, svc_port_id), .type = &type_descr_uint16_t }, { .name = "agg_port_id", .descr = "The ID of the aggregate port (for GPON/XGPON - ALLOC ID)", .offset = offsetof(bcmbal_flow_cfg_data, agg_port_id), .type = &type_descr_uint16_t }, { .name = "resolve_mac", .descr = "A flag indicating if the MAC address table should be used in DS GEM resolution", .offset = offsetof(bcmbal_flow_cfg_data, resolve_mac), .type = &type_descr_bcmos_bool }, { .name = "classifier", .descr = "The classifier for this flow", .offset = offsetof(bcmbal_flow_cfg_data, classifier), .type = &type_descr_bcmbal_classifier }, { .name = "action", .descr = "The action associated with the flow", .offset = offsetof(bcmbal_flow_cfg_data, action), .type = &type_descr_bcmbal_action }, { .name = "sla", .descr = "SLA parameters for this flow", .offset = offsetof(bcmbal_flow_cfg_data, sla), .type = &type_descr_bcmbal_sla }, { .name = "cookie", .descr = "Application cookie", .offset = offsetof(bcmbal_flow_cfg_data, cookie), .type = &type_descr_uint64_t }, { .name = "priority", .descr = "Priority", .offset = offsetof(bcmbal_flow_cfg_data, priority), .type = &type_descr_uint16_t }, { .name = "group_id", .descr = "RW - The multicast group associated with this flow, valid for type MULTICAST only", .offset = offsetof(bcmbal_flow_cfg_data, group_id), .type = &type_descr_uint32_t }, { .name = "queue", .descr = "Egress queue", .offset = offsetof(bcmbal_flow_cfg_data, queue), .type = &type_descr_bcmbal_tm_queue_ref } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_cfg_data = { .name = "bcmbal_flow_cfg_data", .descr = "cfg", .size = sizeof(bcmbal_flow_cfg_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_flow_cfg_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_flow_cfg_data_fields } } };

/* Group: flow - key */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_key_flow_id = { .name = "flow_id", .descr = "The ID of the flow object instance being referenced", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_KEY_ID_FLOW_ID, .offset = offsetof(bcmbal_flow_key, flow_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_key_flow_type = { .name = "flow_type", .descr = "The type of the flow, Upstream, Downstream, Broadcast or Multicast", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_KEY_ID_FLOW_TYPE, .offset = offsetof(bcmbal_flow_key, flow_type), .type = &type_descr_bcmbal_flow_type };
static bcmbal_apicli_prop_descr * BCM_DESCR flow_key_prop_array[] = { &prop_descr_flow_key_flow_id, &prop_descr_flow_key_flow_type };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_flow_key_fields[] = { { .name = "flow_id", .descr = "The ID of the flow object instance being referenced", .offset = offsetof(bcmbal_flow_key, flow_id), .type = &type_descr_uint32_t }, { .name = "flow_type", .descr = "The type of the flow, Upstream, Downstream, Broadcast or Multicast", .offset = offsetof(bcmbal_flow_key, flow_type), .type = &type_descr_bcmbal_flow_type } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_key = { .name = "bcmbal_flow_key", .descr = "key", .size = sizeof(bcmbal_flow_key), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_flow_key_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_flow_key_fields } } };

/* Group: flow - stat */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_stat_rx_packets = { .name = "rx_packets", .descr = "Received packets", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_STAT_ID_RX_PACKETS, .offset = offsetof(bcmbal_flow_stat_data, rx_packets), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_stat_rx_bytes = { .name = "rx_bytes", .descr = "Received bytes", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_STAT_ID_RX_BYTES, .offset = offsetof(bcmbal_flow_stat_data, rx_bytes), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_stat_tx_packets = { .name = "tx_packets", .descr = "Transmitted packets", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_STAT_ID_TX_PACKETS, .offset = offsetof(bcmbal_flow_stat_data, tx_packets), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_stat_tx_bytes = { .name = "tx_bytes", .descr = "Transmitted bytes", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_STAT_ID_TX_BYTES, .offset = offsetof(bcmbal_flow_stat_data, tx_bytes), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr * BCM_DESCR flow_stat_prop_array[] = { &prop_descr_flow_stat_rx_packets, &prop_descr_flow_stat_rx_bytes, &prop_descr_flow_stat_tx_packets, &prop_descr_flow_stat_tx_bytes };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_flow_stat_data_fields[] = { { .name = "rx_packets", .descr = "Received packets", .offset = offsetof(bcmbal_flow_stat_data, rx_packets), .type = &type_descr_uint64_t }, { .name = "rx_bytes", .descr = "Received bytes", .offset = offsetof(bcmbal_flow_stat_data, rx_bytes), .type = &type_descr_uint64_t }, { .name = "tx_packets", .descr = "Transmitted packets", .offset = offsetof(bcmbal_flow_stat_data, tx_packets), .type = &type_descr_uint64_t }, { .name = "tx_bytes", .descr = "Transmitted bytes", .offset = offsetof(bcmbal_flow_stat_data, tx_bytes), .type = &type_descr_uint64_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_stat_data = { .name = "bcmbal_flow_stat_data", .descr = "stat", .size = sizeof(bcmbal_flow_stat_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_flow_stat_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_flow_stat_data_fields } } };

/* Group: flow - ind */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_admin_state = { .name = "admin_state", .descr = "Administrative state", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_ADMIN_STATE, .offset = offsetof(bcmbal_flow_ind_data, admin_state), .type = &type_descr_bcmbal_state };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_oper_status = { .name = "oper_status", .descr = "Operational Status", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_OPER_STATUS, .offset = offsetof(bcmbal_flow_ind_data, oper_status), .type = &type_descr_bcmbal_status };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_access_int_id = { .name = "access_int_id", .descr = "The ID of the subscriber side interface; i.e. PON", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_ACCESS_INT_ID, .offset = offsetof(bcmbal_flow_ind_data, access_int_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_network_int_id = { .name = "network_int_id", .descr = "The ID of the network side interface; i.e. NNI", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_NETWORK_INT_ID, .offset = offsetof(bcmbal_flow_ind_data, network_int_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_sub_term_id = { .name = "sub_term_id", .descr = "The ID of the subsccriber terminal device", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_SUB_TERM_ID, .offset = offsetof(bcmbal_flow_ind_data, sub_term_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_svc_port_id = { .name = "svc_port_id", .descr = "The ID of the service port (for GPON/XGPON - GEM ID)", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_SVC_PORT_ID, .offset = offsetof(bcmbal_flow_ind_data, svc_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_agg_port_id = { .name = "agg_port_id", .descr = "The ID of the aggregate port (for GPON/XGPON - ALLOC ID)", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_AGG_PORT_ID, .offset = offsetof(bcmbal_flow_ind_data, agg_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_resolve_mac = { .name = "resolve_mac", .descr = "A flag indicating if the MAC address table should be used in DS GEM resolution", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_RESOLVE_MAC, .offset = offsetof(bcmbal_flow_ind_data, resolve_mac), .type = &type_descr_bcmos_bool };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_base_tc_id = { .name = "base_tc_id", .descr = "The base index of the TC object(s) to be used for this flow", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_BASE_TC_ID, .offset = offsetof(bcmbal_flow_ind_data, base_tc_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_classifier = { .name = "classifier", .descr = "The classifier for this flow", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_CLASSIFIER, .offset = offsetof(bcmbal_flow_ind_data, classifier), .type = &type_descr_bcmbal_classifier };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_action = { .name = "action", .descr = "The action associated with the flow", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_ACTION, .offset = offsetof(bcmbal_flow_ind_data, action), .type = &type_descr_bcmbal_action };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_sla = { .name = "sla", .descr = "SLA parameters for this flow", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_SLA, .offset = offsetof(bcmbal_flow_ind_data, sla), .type = &type_descr_bcmbal_sla };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_cookie = { .name = "cookie", .descr = "Application cookie", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_COOKIE, .offset = offsetof(bcmbal_flow_ind_data, cookie), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_flow_ind_priority = { .name = "priority", .descr = "Priority", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_FLOW_IND_ID_PRIORITY, .offset = offsetof(bcmbal_flow_ind_data, priority), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr * BCM_DESCR flow_ind_prop_array[] = { &prop_descr_flow_ind_admin_state, &prop_descr_flow_ind_oper_status, &prop_descr_flow_ind_access_int_id, &prop_descr_flow_ind_network_int_id, &prop_descr_flow_ind_sub_term_id, &prop_descr_flow_ind_svc_port_id, &prop_descr_flow_ind_agg_port_id, &prop_descr_flow_ind_resolve_mac, &prop_descr_flow_ind_base_tc_id, &prop_descr_flow_ind_classifier, &prop_descr_flow_ind_action, &prop_descr_flow_ind_sla, &prop_descr_flow_ind_cookie, &prop_descr_flow_ind_priority };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_flow_ind_data_fields[] = { { .name = "admin_state", .descr = "Administrative state", .offset = offsetof(bcmbal_flow_ind_data, admin_state), .type = &type_descr_bcmbal_state }, { .name = "oper_status", .descr = "Operational Status", .offset = offsetof(bcmbal_flow_ind_data, oper_status), .type = &type_descr_bcmbal_status }, { .name = "access_int_id", .descr = "The ID of the subscriber side interface; i.e. PON", .offset = offsetof(bcmbal_flow_ind_data, access_int_id), .type = &type_descr_uint16_t }, { .name = "network_int_id", .descr = "The ID of the network side interface; i.e. NNI", .offset = offsetof(bcmbal_flow_ind_data, network_int_id), .type = &type_descr_uint16_t }, { .name = "sub_term_id", .descr = "The ID of the subsccriber terminal device", .offset = offsetof(bcmbal_flow_ind_data, sub_term_id), .type = &type_descr_uint32_t }, { .name = "svc_port_id", .descr = "The ID of the service port (for GPON/XGPON - GEM ID)", .offset = offsetof(bcmbal_flow_ind_data, svc_port_id), .type = &type_descr_uint16_t }, { .name = "agg_port_id", .descr = "The ID of the aggregate port (for GPON/XGPON - ALLOC ID)", .offset = offsetof(bcmbal_flow_ind_data, agg_port_id), .type = &type_descr_uint16_t }, { .name = "resolve_mac", .descr = "A flag indicating if the MAC address table should be used in DS GEM resolution", .offset = offsetof(bcmbal_flow_ind_data, resolve_mac), .type = &type_descr_bcmos_bool }, { .name = "base_tc_id", .descr = "The base index of the TC object(s) to be used for this flow", .offset = offsetof(bcmbal_flow_ind_data, base_tc_id), .type = &type_descr_uint16_t }, { .name = "classifier", .descr = "The classifier for this flow", .offset = offsetof(bcmbal_flow_ind_data, classifier), .type = &type_descr_bcmbal_classifier }, { .name = "action", .descr = "The action associated with the flow", .offset = offsetof(bcmbal_flow_ind_data, action), .type = &type_descr_bcmbal_action }, { .name = "sla", .descr = "SLA parameters for this flow", .offset = offsetof(bcmbal_flow_ind_data, sla), .type = &type_descr_bcmbal_sla }, { .name = "cookie", .descr = "Application cookie", .offset = offsetof(bcmbal_flow_ind_data, cookie), .type = &type_descr_uint32_t }, { .name = "priority", .descr = "Priority", .offset = offsetof(bcmbal_flow_ind_data, priority), .type = &type_descr_uint16_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_flow_ind_data = { .name = "bcmbal_flow_ind_data", .descr = "Flow Indication", .size = sizeof(bcmbal_flow_ind_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_flow_ind_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_flow_ind_data_fields } } };

/* ==== Object: group ==== */

/* Group: group - cfg */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_group_cfg_members_cmd = { .name = "members_cmd", .descr = "Membership operation commands", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_GROUP_CFG_ID_MEMBERS_CMD, .offset = offsetof(bcmbal_group_cfg_data, members_cmd), .type = &type_descr_bcmbal_group_member_cmd };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_group_cfg_members = { .name = "members", .descr = "The list of members associated with this group", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_GROUP_CFG_ID_MEMBERS, .offset = offsetof(bcmbal_group_cfg_data, members), .type = &type_descr_bcmbal_group_member_info_list_u16 };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_group_cfg_cookie = { .name = "cookie", .descr = "Application cookie", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_GROUP_CFG_ID_COOKIE, .offset = offsetof(bcmbal_group_cfg_data, cookie), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_group_cfg_flows = { .name = "flows", .descr = "List of flows associated with this group", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_GROUP_CFG_ID_FLOWS, .offset = offsetof(bcmbal_group_cfg_data, flows), .type = &type_descr_bcmbal_flow_id_list_u32 };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_group_cfg_owner = { .name = "owner", .descr = "Owner of the group", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_GROUP_CFG_ID_OWNER, .offset = offsetof(bcmbal_group_cfg_data, owner), .type = &type_descr_bcmbal_group_owner };
static bcmbal_apicli_prop_descr * BCM_DESCR group_cfg_prop_array[] = { &prop_descr_group_cfg_members_cmd, &prop_descr_group_cfg_members, &prop_descr_group_cfg_cookie, &prop_descr_group_cfg_flows, &prop_descr_group_cfg_owner };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_group_cfg_data_fields[] = { { .name = "members_cmd", .descr = "Membership operation commands", .offset = offsetof(bcmbal_group_cfg_data, members_cmd), .type = &type_descr_bcmbal_group_member_cmd }, { .name = "members", .descr = "The list of members associated with this group", .offset = offsetof(bcmbal_group_cfg_data, members), .type = &type_descr_bcmbal_group_member_info_list_u16 }, { .name = "cookie", .descr = "Application cookie", .offset = offsetof(bcmbal_group_cfg_data, cookie), .type = &type_descr_uint64_t }, { .name = "flows", .descr = "List of flows associated with this group", .offset = offsetof(bcmbal_group_cfg_data, flows), .type = &type_descr_bcmbal_flow_id_list_u32 }, { .name = "owner", .descr = "Owner of the group", .offset = offsetof(bcmbal_group_cfg_data, owner), .type = &type_descr_bcmbal_group_owner } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_group_cfg_data = { .name = "bcmbal_group_cfg_data", .descr = "cfg", .size = sizeof(bcmbal_group_cfg_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_group_cfg_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_group_cfg_data_fields } } };

/* Group: group - key */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_group_key_group_id = { .name = "group_id", .descr = "The ID of the group object instance being referenced", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_GROUP_KEY_ID_GROUP_ID, .offset = offsetof(bcmbal_group_key, group_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr * BCM_DESCR group_key_prop_array[] = { &prop_descr_group_key_group_id };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_group_key_fields[] = { { .name = "group_id", .descr = "The ID of the group object instance being referenced", .offset = offsetof(bcmbal_group_key, group_id), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_group_key = { .name = "bcmbal_group_key", .descr = "key", .size = sizeof(bcmbal_group_key), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_group_key_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_group_key_fields } } };

/* ==== Object: interface ==== */

/* Group: interface - key */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_key_intf_id = { .name = "intf_id", .descr = "intf_id", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_KEY_ID_INTF_ID, .offset = offsetof(bcmbal_interface_key, intf_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_key_intf_type = { .name = "intf_type", .descr = "intf_type", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_KEY_ID_INTF_TYPE, .offset = offsetof(bcmbal_interface_key, intf_type), .type = &type_descr_bcmbal_intf_type };
static bcmbal_apicli_prop_descr * BCM_DESCR interface_key_prop_array[] = { &prop_descr_interface_key_intf_id, &prop_descr_interface_key_intf_type };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_interface_key_fields[] = { { .name = "intf_id", .descr = "intf_id", .offset = offsetof(bcmbal_interface_key, intf_id), .type = &type_descr_uint32_t }, { .name = "intf_type", .descr = "intf_type", .offset = offsetof(bcmbal_interface_key, intf_type), .type = &type_descr_bcmbal_intf_type } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_interface_key = { .name = "bcmbal_interface_key", .descr = "key", .size = sizeof(bcmbal_interface_key), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_interface_key_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_interface_key_fields } } };

/* Group: interface - cfg */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_admin_state = { .name = "admin_state", .descr = "Administrative state", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_CFG_ID_ADMIN_STATE, .offset = offsetof(bcmbal_interface_cfg_data, admin_state), .type = &type_descr_bcmbal_state };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_oper_status = { .name = "oper_status", .descr = "Operational status", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_INTERFACE_CFG_ID_OPER_STATUS, .offset = offsetof(bcmbal_interface_cfg_data, oper_status), .type = &type_descr_bcmbal_status };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_min_data_agg_port_id = { .name = "min_data_agg_port_id", .descr = "The minimum agg_port_id that is allowed in the system", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_CFG_ID_MIN_DATA_AGG_PORT_ID, .offset = offsetof(bcmbal_interface_cfg_data, min_data_agg_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_min_data_svc_port_id = { .name = "min_data_svc_port_id", .descr = "The minimum svc_port_id that is allowed in the system", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_CFG_ID_MIN_DATA_SVC_PORT_ID, .offset = offsetof(bcmbal_interface_cfg_data, min_data_svc_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_transceiver_type = { .name = "transceiver_type", .descr = "The transceiver type used on an interface", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_CFG_ID_TRANSCEIVER_TYPE, .offset = offsetof(bcmbal_interface_cfg_data, transceiver_type), .type = &type_descr_bcmbal_trx_type };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_ds_miss_mode = { .name = "ds_miss_mode", .descr = "Defines the action to take for unknown downstream packets", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_CFG_ID_DS_MISS_MODE, .offset = offsetof(bcmbal_interface_cfg_data, ds_miss_mode), .type = &type_descr_bcmbal_ds_miss_mode };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_mtu = { .name = "mtu", .descr = "The MTU for an interface", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_CFG_ID_MTU, .offset = offsetof(bcmbal_interface_cfg_data, mtu), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_flow_control = { .name = "flow_control", .descr = "Flow control enable or disable", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_CFG_ID_FLOW_CONTROL, .offset = offsetof(bcmbal_interface_cfg_data, flow_control), .type = &type_descr_bcmbal_control };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_ds_tm = { .name = "ds_tm", .descr = "Downstream scheduler and shaper", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_CFG_ID_DS_TM, .offset = offsetof(bcmbal_interface_cfg_data, ds_tm), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_us_tm = { .name = "us_tm", .descr = "Upstream scheduler and shaper", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_CFG_ID_US_TM, .offset = offsetof(bcmbal_interface_cfg_data, us_tm), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_cfg_sub_term_id_list = { .name = "sub_term_id_list", .descr = "A list of subscriber terminal ids configured on this interface", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_INTERFACE_CFG_ID_SUB_TERM_ID_LIST, .offset = offsetof(bcmbal_interface_cfg_data, sub_term_id_list), .type = &type_descr_bcmbal_sub_id_list_u16 };
static bcmbal_apicli_prop_descr * BCM_DESCR interface_cfg_prop_array[] = { &prop_descr_interface_cfg_admin_state, &prop_descr_interface_cfg_oper_status, &prop_descr_interface_cfg_min_data_agg_port_id, &prop_descr_interface_cfg_min_data_svc_port_id, &prop_descr_interface_cfg_transceiver_type, &prop_descr_interface_cfg_ds_miss_mode, &prop_descr_interface_cfg_mtu, &prop_descr_interface_cfg_flow_control, &prop_descr_interface_cfg_ds_tm, &prop_descr_interface_cfg_us_tm, &prop_descr_interface_cfg_sub_term_id_list };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_interface_cfg_data_fields[] = { { .name = "admin_state", .descr = "Administrative state", .offset = offsetof(bcmbal_interface_cfg_data, admin_state), .type = &type_descr_bcmbal_state }, { .name = "oper_status", .descr = "Operational status", .offset = offsetof(bcmbal_interface_cfg_data, oper_status), .type = &type_descr_bcmbal_status }, { .name = "min_data_agg_port_id", .descr = "The minimum agg_port_id that is allowed in the system", .offset = offsetof(bcmbal_interface_cfg_data, min_data_agg_port_id), .type = &type_descr_uint16_t }, { .name = "min_data_svc_port_id", .descr = "The minimum svc_port_id that is allowed in the system", .offset = offsetof(bcmbal_interface_cfg_data, min_data_svc_port_id), .type = &type_descr_uint16_t }, { .name = "transceiver_type", .descr = "The transceiver type used on an interface", .offset = offsetof(bcmbal_interface_cfg_data, transceiver_type), .type = &type_descr_bcmbal_trx_type }, { .name = "ds_miss_mode", .descr = "Defines the action to take for unknown downstream packets", .offset = offsetof(bcmbal_interface_cfg_data, ds_miss_mode), .type = &type_descr_bcmbal_ds_miss_mode }, { .name = "mtu", .descr = "The MTU for an interface", .offset = offsetof(bcmbal_interface_cfg_data, mtu), .type = &type_descr_uint16_t }, { .name = "flow_control", .descr = "Flow control enable or disable", .offset = offsetof(bcmbal_interface_cfg_data, flow_control), .type = &type_descr_bcmbal_control }, { .name = "ds_tm", .descr = "Downstream scheduler and shaper", .offset = offsetof(bcmbal_interface_cfg_data, ds_tm), .type = &type_descr_uint32_t }, { .name = "us_tm", .descr = "Upstream scheduler and shaper", .offset = offsetof(bcmbal_interface_cfg_data, us_tm), .type = &type_descr_uint32_t }, { .name = "sub_term_id_list", .descr = "A list of subscriber terminal ids configured on this interface", .offset = offsetof(bcmbal_interface_cfg_data, sub_term_id_list), .type = &type_descr_bcmbal_sub_id_list_u16 } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_interface_cfg_data = { .name = "bcmbal_interface_cfg_data", .descr = "cfg", .size = sizeof(bcmbal_interface_cfg_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_interface_cfg_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_interface_cfg_data_fields } } };

/* Group: interface - stat */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_stat_rx_packets = { .name = "rx_packets", .descr = "Recieved packets", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_STAT_ID_RX_PACKETS, .offset = offsetof(bcmbal_interface_stat_data, rx_packets), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_stat_rx_bytes = { .name = "rx_bytes", .descr = "Received bytes", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_STAT_ID_RX_BYTES, .offset = offsetof(bcmbal_interface_stat_data, rx_bytes), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_stat_tx_packets = { .name = "tx_packets", .descr = "Transmitted packets", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_STAT_ID_TX_PACKETS, .offset = offsetof(bcmbal_interface_stat_data, tx_packets), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_stat_tx_bytes = { .name = "tx_bytes", .descr = "Transmitted bytes", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_STAT_ID_TX_BYTES, .offset = offsetof(bcmbal_interface_stat_data, tx_bytes), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr * BCM_DESCR interface_stat_prop_array[] = { &prop_descr_interface_stat_rx_packets, &prop_descr_interface_stat_rx_bytes, &prop_descr_interface_stat_tx_packets, &prop_descr_interface_stat_tx_bytes };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_interface_stat_data_fields[] = { { .name = "rx_packets", .descr = "Recieved packets", .offset = offsetof(bcmbal_interface_stat_data, rx_packets), .type = &type_descr_uint64_t }, { .name = "rx_bytes", .descr = "Received bytes", .offset = offsetof(bcmbal_interface_stat_data, rx_bytes), .type = &type_descr_uint64_t }, { .name = "tx_packets", .descr = "Transmitted packets", .offset = offsetof(bcmbal_interface_stat_data, tx_packets), .type = &type_descr_uint64_t }, { .name = "tx_bytes", .descr = "Transmitted bytes", .offset = offsetof(bcmbal_interface_stat_data, tx_bytes), .type = &type_descr_uint64_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_interface_stat_data = { .name = "bcmbal_interface_stat_data", .descr = "stat", .size = sizeof(bcmbal_interface_stat_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_interface_stat_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_interface_stat_data_fields } } };

/* Group: interface - ind */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_admin_state = { .name = "admin_state", .descr = "Current administrative state", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_ADMIN_STATE, .offset = offsetof(bcmbal_interface_ind_data, admin_state), .type = &type_descr_bcmbal_state };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_oper_status = { .name = "oper_status", .descr = "Current operational state", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_OPER_STATUS, .offset = offsetof(bcmbal_interface_ind_data, oper_status), .type = &type_descr_bcmbal_status };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_min_data_agg_port_id = { .name = "min_data_agg_port_id", .descr = "The minimum agg_port_id that is allowed in the system", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_MIN_DATA_AGG_PORT_ID, .offset = offsetof(bcmbal_interface_ind_data, min_data_agg_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_min_data_svc_port_id = { .name = "min_data_svc_port_id", .descr = "The minimum svc_port_id that is allowed in the system", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_MIN_DATA_SVC_PORT_ID, .offset = offsetof(bcmbal_interface_ind_data, min_data_svc_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_transceiver_type = { .name = "transceiver_type", .descr = "The transceiver type used on an interface", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_TRANSCEIVER_TYPE, .offset = offsetof(bcmbal_interface_ind_data, transceiver_type), .type = &type_descr_bcmbal_trx_type };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_ds_miss_mode = { .name = "ds_miss_mode", .descr = "Defines the action to take for DS unknown packets", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_DS_MISS_MODE, .offset = offsetof(bcmbal_interface_ind_data, ds_miss_mode), .type = &type_descr_bcmbal_ds_miss_mode };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_mtu = { .name = "mtu", .descr = "The MTU for an interface", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_MTU, .offset = offsetof(bcmbal_interface_ind_data, mtu), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_flow_control = { .name = "flow_control", .descr = "Flow control enable or disable", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_FLOW_CONTROL, .offset = offsetof(bcmbal_interface_ind_data, flow_control), .type = &type_descr_bcmbal_control };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_ds_tm = { .name = "ds_tm", .descr = "Downstream scheduler and shaper", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_DS_TM, .offset = offsetof(bcmbal_interface_ind_data, ds_tm), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_interface_ind_us_tm = { .name = "us_tm", .descr = "Upstream scheduler and shaper", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_INTERFACE_IND_ID_US_TM, .offset = offsetof(bcmbal_interface_ind_data, us_tm), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr * BCM_DESCR interface_ind_prop_array[] = { &prop_descr_interface_ind_admin_state, &prop_descr_interface_ind_oper_status, &prop_descr_interface_ind_min_data_agg_port_id, &prop_descr_interface_ind_min_data_svc_port_id, &prop_descr_interface_ind_transceiver_type, &prop_descr_interface_ind_ds_miss_mode, &prop_descr_interface_ind_mtu, &prop_descr_interface_ind_flow_control, &prop_descr_interface_ind_ds_tm, &prop_descr_interface_ind_us_tm };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_interface_ind_data_fields[] = { { .name = "admin_state", .descr = "Current administrative state", .offset = offsetof(bcmbal_interface_ind_data, admin_state), .type = &type_descr_bcmbal_state }, { .name = "oper_status", .descr = "Current operational state", .offset = offsetof(bcmbal_interface_ind_data, oper_status), .type = &type_descr_bcmbal_status }, { .name = "min_data_agg_port_id", .descr = "The minimum agg_port_id that is allowed in the system", .offset = offsetof(bcmbal_interface_ind_data, min_data_agg_port_id), .type = &type_descr_uint16_t }, { .name = "min_data_svc_port_id", .descr = "The minimum svc_port_id that is allowed in the system", .offset = offsetof(bcmbal_interface_ind_data, min_data_svc_port_id), .type = &type_descr_uint16_t }, { .name = "transceiver_type", .descr = "The transceiver type used on an interface", .offset = offsetof(bcmbal_interface_ind_data, transceiver_type), .type = &type_descr_bcmbal_trx_type }, { .name = "ds_miss_mode", .descr = "Defines the action to take for DS unknown packets", .offset = offsetof(bcmbal_interface_ind_data, ds_miss_mode), .type = &type_descr_bcmbal_ds_miss_mode }, { .name = "mtu", .descr = "The MTU for an interface", .offset = offsetof(bcmbal_interface_ind_data, mtu), .type = &type_descr_uint16_t }, { .name = "flow_control", .descr = "Flow control enable or disable", .offset = offsetof(bcmbal_interface_ind_data, flow_control), .type = &type_descr_bcmbal_control }, { .name = "ds_tm", .descr = "Downstream scheduler and shaper", .offset = offsetof(bcmbal_interface_ind_data, ds_tm), .type = &type_descr_uint32_t }, { .name = "us_tm", .descr = "Upstream scheduler and shaper", .offset = offsetof(bcmbal_interface_ind_data, us_tm), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_interface_ind_data = { .name = "bcmbal_interface_ind_data", .descr = "Interface Indication", .size = sizeof(bcmbal_interface_ind_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_interface_ind_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_interface_ind_data_fields } } };

/* ==== Object: packet ==== */

/* Group: packet - cfg */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_cfg_flow_id = { .name = "flow_id", .descr = "N/A for sending a packet", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_CFG_ID_FLOW_ID, .offset = offsetof(bcmbal_packet_cfg_data, flow_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_cfg_flow_type = { .name = "flow_type", .descr = "Flow Type", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_CFG_ID_FLOW_TYPE, .offset = offsetof(bcmbal_packet_cfg_data, flow_type), .type = &type_descr_bcmbal_flow_type };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_cfg_intf_id = { .name = "intf_id", .descr = "Interface ID", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_CFG_ID_INTF_ID, .offset = offsetof(bcmbal_packet_cfg_data, intf_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_cfg_intf_type = { .name = "intf_type", .descr = "Interface Type", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_CFG_ID_INTF_TYPE, .offset = offsetof(bcmbal_packet_cfg_data, intf_type), .type = &type_descr_bcmbal_intf_type };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_cfg_svc_port = { .name = "svc_port", .descr = "N/A for sending a packet", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_CFG_ID_SVC_PORT, .offset = offsetof(bcmbal_packet_cfg_data, svc_port), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_cfg_flow_cookie = { .name = "flow_cookie", .descr = "N/A for sending a packet", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_CFG_ID_FLOW_COOKIE, .offset = offsetof(bcmbal_packet_cfg_data, flow_cookie), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_cfg_pkt = { .name = "pkt", .descr = "Packet Data", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_CFG_ID_PKT, .offset = offsetof(bcmbal_packet_cfg_data, pkt), .type = &type_descr_bcmbal_u8_list_u32 };
static bcmbal_apicli_prop_descr * BCM_DESCR packet_cfg_prop_array[] = { &prop_descr_packet_cfg_flow_id, &prop_descr_packet_cfg_flow_type, &prop_descr_packet_cfg_intf_id, &prop_descr_packet_cfg_intf_type, &prop_descr_packet_cfg_svc_port, &prop_descr_packet_cfg_flow_cookie, &prop_descr_packet_cfg_pkt };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_packet_cfg_data_fields[] = { { .name = "flow_id", .descr = "N/A for sending a packet", .offset = offsetof(bcmbal_packet_cfg_data, flow_id), .type = &type_descr_uint32_t }, { .name = "flow_type", .descr = "Flow Type", .offset = offsetof(bcmbal_packet_cfg_data, flow_type), .type = &type_descr_bcmbal_flow_type }, { .name = "intf_id", .descr = "Interface ID", .offset = offsetof(bcmbal_packet_cfg_data, intf_id), .type = &type_descr_uint32_t }, { .name = "intf_type", .descr = "Interface Type", .offset = offsetof(bcmbal_packet_cfg_data, intf_type), .type = &type_descr_bcmbal_intf_type }, { .name = "svc_port", .descr = "N/A for sending a packet", .offset = offsetof(bcmbal_packet_cfg_data, svc_port), .type = &type_descr_uint16_t }, { .name = "flow_cookie", .descr = "N/A for sending a packet", .offset = offsetof(bcmbal_packet_cfg_data, flow_cookie), .type = &type_descr_uint64_t }, { .name = "pkt", .descr = "Packet Data", .offset = offsetof(bcmbal_packet_cfg_data, pkt), .type = &type_descr_bcmbal_u8_list_u32 } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_packet_cfg_data = { .name = "bcmbal_packet_cfg_data", .descr = "cfg", .size = sizeof(bcmbal_packet_cfg_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_packet_cfg_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_packet_cfg_data_fields } } };

/* Group: packet - key */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_key_reserved = { .name = "reserved", .descr = "Reserved key field", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_KEY_ID_RESERVED, .offset = offsetof(bcmbal_packet_key, reserved), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_key_packet_send_dest = { .name = "packet_send_dest", .descr = "Packet destination", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_KEY_ID_PACKET_SEND_DEST, .offset = offsetof(bcmbal_packet_key, packet_send_dest), .type = &type_descr_bcmbal_dest };
static bcmbal_apicli_prop_descr * BCM_DESCR packet_key_prop_array[] = { &prop_descr_packet_key_reserved, &prop_descr_packet_key_packet_send_dest };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_packet_key_fields[] = { { .name = "reserved", .descr = "Reserved key field", .offset = offsetof(bcmbal_packet_key, reserved), .type = &type_descr_uint32_t }, { .name = "packet_send_dest", .descr = "Packet destination", .offset = offsetof(bcmbal_packet_key, packet_send_dest), .type = &type_descr_bcmbal_dest } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_packet_key = { .name = "bcmbal_packet_key", .descr = "key", .size = sizeof(bcmbal_packet_key), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_packet_key_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_packet_key_fields } } };

/* Group: packet - ind */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_ind_flow_id = { .name = "flow_id", .descr = "N/A for sending a packet", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_IND_ID_FLOW_ID, .offset = offsetof(bcmbal_packet_ind_data, flow_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_ind_flow_type = { .name = "flow_type", .descr = "Flow Type", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_IND_ID_FLOW_TYPE, .offset = offsetof(bcmbal_packet_ind_data, flow_type), .type = &type_descr_bcmbal_flow_type };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_ind_intf_id = { .name = "intf_id", .descr = "Interface ID", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_IND_ID_INTF_ID, .offset = offsetof(bcmbal_packet_ind_data, intf_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_ind_intf_type = { .name = "intf_type", .descr = "Interface Type", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_IND_ID_INTF_TYPE, .offset = offsetof(bcmbal_packet_ind_data, intf_type), .type = &type_descr_bcmbal_intf_type };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_ind_svc_port = { .name = "svc_port", .descr = "N/A for sending a packet", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_IND_ID_SVC_PORT, .offset = offsetof(bcmbal_packet_ind_data, svc_port), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_ind_flow_cookie = { .name = "flow_cookie", .descr = "N/A for sending a packet", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_IND_ID_FLOW_COOKIE, .offset = offsetof(bcmbal_packet_ind_data, flow_cookie), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_packet_ind_pkt = { .name = "pkt", .descr = "Packet Data", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_PACKET_IND_ID_PKT, .offset = offsetof(bcmbal_packet_ind_data, pkt), .type = &type_descr_bcmbal_u8_list_u32 };
static bcmbal_apicli_prop_descr * BCM_DESCR packet_ind_prop_array[] = { &prop_descr_packet_ind_flow_id, &prop_descr_packet_ind_flow_type, &prop_descr_packet_ind_intf_id, &prop_descr_packet_ind_intf_type, &prop_descr_packet_ind_svc_port, &prop_descr_packet_ind_flow_cookie, &prop_descr_packet_ind_pkt };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_packet_ind_data_fields[] = { { .name = "flow_id", .descr = "N/A for sending a packet", .offset = offsetof(bcmbal_packet_ind_data, flow_id), .type = &type_descr_uint32_t }, { .name = "flow_type", .descr = "Flow Type", .offset = offsetof(bcmbal_packet_ind_data, flow_type), .type = &type_descr_bcmbal_flow_type }, { .name = "intf_id", .descr = "Interface ID", .offset = offsetof(bcmbal_packet_ind_data, intf_id), .type = &type_descr_uint32_t }, { .name = "intf_type", .descr = "Interface Type", .offset = offsetof(bcmbal_packet_ind_data, intf_type), .type = &type_descr_bcmbal_intf_type }, { .name = "svc_port", .descr = "N/A for sending a packet", .offset = offsetof(bcmbal_packet_ind_data, svc_port), .type = &type_descr_uint16_t }, { .name = "flow_cookie", .descr = "N/A for sending a packet", .offset = offsetof(bcmbal_packet_ind_data, flow_cookie), .type = &type_descr_uint64_t }, { .name = "pkt", .descr = "Packet Data", .offset = offsetof(bcmbal_packet_ind_data, pkt), .type = &type_descr_bcmbal_u8_list_u32 } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_packet_ind_data = { .name = "bcmbal_packet_ind_data", .descr = "Packet indication", .size = sizeof(bcmbal_packet_ind_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_packet_ind_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_packet_ind_data_fields } } };

/* ==== Object: subscriber_terminal ==== */

/* Group: subscriber_terminal - key */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_key_sub_term_id = { .name = "sub_term_id", .descr = "sub_term_id", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_SUB_TERM_ID, .offset = offsetof(bcmbal_subscriber_terminal_key, sub_term_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_key_intf_id = { .name = "intf_id", .descr = "intf_id", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_KEY_ID_INTF_ID, .offset = offsetof(bcmbal_subscriber_terminal_key, intf_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr * BCM_DESCR subscriber_terminal_key_prop_array[] = { &prop_descr_subscriber_terminal_key_sub_term_id, &prop_descr_subscriber_terminal_key_intf_id };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_key_fields[] = { { .name = "sub_term_id", .descr = "sub_term_id", .offset = offsetof(bcmbal_subscriber_terminal_key, sub_term_id), .type = &type_descr_uint32_t }, { .name = "intf_id", .descr = "intf_id", .offset = offsetof(bcmbal_subscriber_terminal_key, intf_id), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_key = { .name = "bcmbal_subscriber_terminal_key", .descr = "key", .size = sizeof(bcmbal_subscriber_terminal_key), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_subscriber_terminal_key_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_subscriber_terminal_key_fields } } };

/* Group: subscriber_terminal - cfg */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_admin_state = { .name = "admin_state", .descr = "Administrative state", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_ADMIN_STATE, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, admin_state), .type = &type_descr_bcmbal_state };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_oper_status = { .name = "oper_status", .descr = "Operational status", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_OPER_STATUS, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, oper_status), .type = &type_descr_bcmbal_status };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_serial_number = { .name = "serial_number", .descr = "The serial number of an  ITU PON (GPON/XG-PON1/XGS-PON/NG-PON2) subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SERIAL_NUMBER, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, serial_number), .type = &type_descr_bcmbal_serial_number };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_password = { .name = "password", .descr = "The password of a GPON subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_PASSWORD, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, password), .type = &type_descr_bcmbal_password };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_registration_id = { .name = "registration_id", .descr = "ONU registration ID of an  ITU PON (XG-PON1/XGS-PON/NG-PON2) subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_REGISTRATION_ID, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, registration_id), .type = &type_descr_bcmbal_registration_id };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_svc_port_id = { .name = "svc_port_id", .descr = "The management service port ID (for PON, the ONU ID)", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, svc_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_mac_address = { .name = "mac_address", .descr = "The Ethernet MAC address of an EPON subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_MAC_ADDRESS, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, mac_address), .type = &type_descr_bcmos_mac_address };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_ds_tm = { .name = "ds_tm", .descr = "Downstream scheduler and shaper", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_DS_TM, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, ds_tm), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_us_tm = { .name = "us_tm", .descr = "Upstream scheduler and shaper", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_US_TM, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, us_tm), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_svc_port_id_list = { .name = "svc_port_id_list", .descr = "A list of bearer traffic svc_port_ids associated with this subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_SVC_PORT_ID_LIST, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, svc_port_id_list), .type = &type_descr_bcmbal_service_port_id_list_u8 };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_cfg_agg_port_id_list = { .name = "agg_port_id_list", .descr = "A list of aggr_port_ids associated with this subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_SUBSCRIBER_TERMINAL_CFG_ID_AGG_PORT_ID_LIST, .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, agg_port_id_list), .type = &type_descr_bcmbal_aggregation_port_id_list_u8 };
static bcmbal_apicli_prop_descr * BCM_DESCR subscriber_terminal_cfg_prop_array[] = { &prop_descr_subscriber_terminal_cfg_admin_state, &prop_descr_subscriber_terminal_cfg_oper_status, &prop_descr_subscriber_terminal_cfg_serial_number, &prop_descr_subscriber_terminal_cfg_password, &prop_descr_subscriber_terminal_cfg_registration_id, &prop_descr_subscriber_terminal_cfg_svc_port_id, &prop_descr_subscriber_terminal_cfg_mac_address, &prop_descr_subscriber_terminal_cfg_ds_tm, &prop_descr_subscriber_terminal_cfg_us_tm, &prop_descr_subscriber_terminal_cfg_svc_port_id_list, &prop_descr_subscriber_terminal_cfg_agg_port_id_list };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_cfg_data_fields[] = { { .name = "admin_state", .descr = "Administrative state", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, admin_state), .type = &type_descr_bcmbal_state }, { .name = "oper_status", .descr = "Operational status", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, oper_status), .type = &type_descr_bcmbal_status }, { .name = "serial_number", .descr = "The serial number of an  ITU PON (GPON/XG-PON1/XGS-PON/NG-PON2) subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, serial_number), .type = &type_descr_bcmbal_serial_number }, { .name = "password", .descr = "The password of a GPON subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, password), .type = &type_descr_bcmbal_password }, { .name = "registration_id", .descr = "ONU registration ID of an  ITU PON (XG-PON1/XGS-PON/NG-PON2) subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, registration_id), .type = &type_descr_bcmbal_registration_id }, { .name = "svc_port_id", .descr = "The management service port ID (for PON, the ONU ID)", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, svc_port_id), .type = &type_descr_uint16_t }, { .name = "mac_address", .descr = "The Ethernet MAC address of an EPON subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, mac_address), .type = &type_descr_bcmos_mac_address }, { .name = "ds_tm", .descr = "Downstream scheduler and shaper", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, ds_tm), .type = &type_descr_uint32_t }, { .name = "us_tm", .descr = "Upstream scheduler and shaper", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, us_tm), .type = &type_descr_uint32_t }, { .name = "svc_port_id_list", .descr = "A list of bearer traffic svc_port_ids associated with this subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, svc_port_id_list), .type = &type_descr_bcmbal_service_port_id_list_u8 }, { .name = "agg_port_id_list", .descr = "A list of aggr_port_ids associated with this subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_cfg_data, agg_port_id_list), .type = &type_descr_bcmbal_aggregation_port_id_list_u8 } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_cfg_data = { .name = "bcmbal_subscriber_terminal_cfg_data", .descr = "cfg", .size = sizeof(bcmbal_subscriber_terminal_cfg_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_subscriber_terminal_cfg_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_subscriber_terminal_cfg_data_fields } } };

/* Group: subscriber_terminal - stat */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_stat_rx_packets = { .name = "rx_packets", .descr = "Received packets on specified object", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_PACKETS, .offset = offsetof(bcmbal_subscriber_terminal_stat_data, rx_packets), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_stat_rx_bytes = { .name = "rx_bytes", .descr = "Received bytes on specified object", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_RX_BYTES, .offset = offsetof(bcmbal_subscriber_terminal_stat_data, rx_bytes), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_stat_tx_packets = { .name = "tx_packets", .descr = "Transmitted packets on specified object", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_PACKETS, .offset = offsetof(bcmbal_subscriber_terminal_stat_data, tx_packets), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_stat_tx_bytes = { .name = "tx_bytes", .descr = "Transmittted bytes on specified object", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_STAT_ID_TX_BYTES, .offset = offsetof(bcmbal_subscriber_terminal_stat_data, tx_bytes), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr * BCM_DESCR subscriber_terminal_stat_prop_array[] = { &prop_descr_subscriber_terminal_stat_rx_packets, &prop_descr_subscriber_terminal_stat_rx_bytes, &prop_descr_subscriber_terminal_stat_tx_packets, &prop_descr_subscriber_terminal_stat_tx_bytes };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_stat_data_fields[] = { { .name = "rx_packets", .descr = "Received packets on specified object", .offset = offsetof(bcmbal_subscriber_terminal_stat_data, rx_packets), .type = &type_descr_uint64_t }, { .name = "rx_bytes", .descr = "Received bytes on specified object", .offset = offsetof(bcmbal_subscriber_terminal_stat_data, rx_bytes), .type = &type_descr_uint64_t }, { .name = "tx_packets", .descr = "Transmitted packets on specified object", .offset = offsetof(bcmbal_subscriber_terminal_stat_data, tx_packets), .type = &type_descr_uint64_t }, { .name = "tx_bytes", .descr = "Transmittted bytes on specified object", .offset = offsetof(bcmbal_subscriber_terminal_stat_data, tx_bytes), .type = &type_descr_uint64_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_stat_data = { .name = "bcmbal_subscriber_terminal_stat_data", .descr = "stat", .size = sizeof(bcmbal_subscriber_terminal_stat_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_subscriber_terminal_stat_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_subscriber_terminal_stat_data_fields } } };

/* Group: subscriber_terminal - ind */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_ind_admin_state = { .name = "admin_state", .descr = "Current administrative state", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_ADMIN_STATE, .offset = offsetof(bcmbal_subscriber_terminal_ind_data, admin_state), .type = &type_descr_bcmbal_state };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_ind_oper_status = { .name = "oper_status", .descr = "Current operational status", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_OPER_STATUS, .offset = offsetof(bcmbal_subscriber_terminal_ind_data, oper_status), .type = &type_descr_bcmbal_status };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_ind_serial_number = { .name = "serial_number", .descr = "The serial number of an  ITU PON (GPON/XG-PON1/XGS-PON/NG-PON2) subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SERIAL_NUMBER, .offset = offsetof(bcmbal_subscriber_terminal_ind_data, serial_number), .type = &type_descr_bcmbal_serial_number };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_ind_password = { .name = "password", .descr = "The password of a GPON subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_PASSWORD, .offset = offsetof(bcmbal_subscriber_terminal_ind_data, password), .type = &type_descr_bcmbal_password };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_ind_registration_id = { .name = "registration_id", .descr = "ONU registration ID of an  ITU PON (XG-PON1/XGS-PON/NG-PON2) subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_REGISTRATION_ID, .offset = offsetof(bcmbal_subscriber_terminal_ind_data, registration_id), .type = &type_descr_bcmbal_registration_id };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_ind_svc_port_id = { .name = "svc_port_id", .descr = "The service port ID (for PON, the ONU ID)", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_SVC_PORT_ID, .offset = offsetof(bcmbal_subscriber_terminal_ind_data, svc_port_id), .type = &type_descr_uint16_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_ind_mac_address = { .name = "mac_address", .descr = "The Ethernet MAC address of an epon subscriber terminal", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_MAC_ADDRESS, .offset = offsetof(bcmbal_subscriber_terminal_ind_data, mac_address), .type = &type_descr_bcmos_mac_address };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_ind_ds_tm = { .name = "ds_tm", .descr = "Downstream scheduler and shaper", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_DS_TM, .offset = offsetof(bcmbal_subscriber_terminal_ind_data, ds_tm), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_subscriber_terminal_ind_us_tm = { .name = "us_tm", .descr = "Upstream scheduler and shaper", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_SUBSCRIBER_TERMINAL_IND_ID_US_TM, .offset = offsetof(bcmbal_subscriber_terminal_ind_data, us_tm), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr * BCM_DESCR subscriber_terminal_ind_prop_array[] = { &prop_descr_subscriber_terminal_ind_admin_state, &prop_descr_subscriber_terminal_ind_oper_status, &prop_descr_subscriber_terminal_ind_serial_number, &prop_descr_subscriber_terminal_ind_password, &prop_descr_subscriber_terminal_ind_registration_id, &prop_descr_subscriber_terminal_ind_svc_port_id, &prop_descr_subscriber_terminal_ind_mac_address, &prop_descr_subscriber_terminal_ind_ds_tm, &prop_descr_subscriber_terminal_ind_us_tm };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_ind_data_fields[] = { { .name = "admin_state", .descr = "Current administrative state", .offset = offsetof(bcmbal_subscriber_terminal_ind_data, admin_state), .type = &type_descr_bcmbal_state }, { .name = "oper_status", .descr = "Current operational status", .offset = offsetof(bcmbal_subscriber_terminal_ind_data, oper_status), .type = &type_descr_bcmbal_status }, { .name = "serial_number", .descr = "The serial number of an  ITU PON (GPON/XG-PON1/XGS-PON/NG-PON2) subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_ind_data, serial_number), .type = &type_descr_bcmbal_serial_number }, { .name = "password", .descr = "The password of a GPON subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_ind_data, password), .type = &type_descr_bcmbal_password }, { .name = "registration_id", .descr = "ONU registration ID of an  ITU PON (XG-PON1/XGS-PON/NG-PON2) subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_ind_data, registration_id), .type = &type_descr_bcmbal_registration_id }, { .name = "svc_port_id", .descr = "The service port ID (for PON, the ONU ID)", .offset = offsetof(bcmbal_subscriber_terminal_ind_data, svc_port_id), .type = &type_descr_uint16_t }, { .name = "mac_address", .descr = "The Ethernet MAC address of an epon subscriber terminal", .offset = offsetof(bcmbal_subscriber_terminal_ind_data, mac_address), .type = &type_descr_bcmos_mac_address }, { .name = "ds_tm", .descr = "Downstream scheduler and shaper", .offset = offsetof(bcmbal_subscriber_terminal_ind_data, ds_tm), .type = &type_descr_uint32_t }, { .name = "us_tm", .descr = "Upstream scheduler and shaper", .offset = offsetof(bcmbal_subscriber_terminal_ind_data, us_tm), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_subscriber_terminal_ind_data = { .name = "bcmbal_subscriber_terminal_ind_data", .descr = "Subscriber Terminal Indication", .size = sizeof(bcmbal_subscriber_terminal_ind_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_subscriber_terminal_ind_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_subscriber_terminal_ind_data_fields } } };

/* ==== Object: tm_queue ==== */

/* Group: tm_queue - key */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_key_sched_id = { .name = "sched_id", .descr = "Scheduler that owns the queue", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_KEY_ID_SCHED_ID, .offset = offsetof(bcmbal_tm_queue_key, sched_id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_key_sched_dir = { .name = "sched_dir", .descr = "sched dir", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_KEY_ID_SCHED_DIR, .offset = offsetof(bcmbal_tm_queue_key, sched_dir), .type = &type_descr_bcmbal_tm_sched_dir };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_key_id = { .name = "id", .descr = "Queue id", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_KEY_ID_ID, .offset = offsetof(bcmbal_tm_queue_key, id), .type = &type_descr_uint8_t };
static bcmbal_apicli_prop_descr * BCM_DESCR tm_queue_key_prop_array[] = { &prop_descr_tm_queue_key_sched_id, &prop_descr_tm_queue_key_sched_dir, &prop_descr_tm_queue_key_id };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_queue_key_fields[] = { { .name = "sched_id", .descr = "Scheduler that owns the queue", .offset = offsetof(bcmbal_tm_queue_key, sched_id), .type = &type_descr_uint32_t }, { .name = "sched_dir", .descr = "sched dir", .offset = offsetof(bcmbal_tm_queue_key, sched_dir), .type = &type_descr_bcmbal_tm_sched_dir }, { .name = "id", .descr = "Queue id", .offset = offsetof(bcmbal_tm_queue_key, id), .type = &type_descr_uint8_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_key = { .name = "bcmbal_tm_queue_key", .descr = "key", .size = sizeof(bcmbal_tm_queue_key), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_queue_key_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_queue_key_fields } } };

/* Group: tm_queue - cfg */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_cfg_priority = { .name = "priority", .descr = "Scheduling priority", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_CFG_ID_PRIORITY, .offset = offsetof(bcmbal_tm_queue_cfg_data, priority), .type = &type_descr_uint8_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_cfg_weight = { .name = "weight", .descr = "Scheduling weight", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_CFG_ID_WEIGHT, .offset = offsetof(bcmbal_tm_queue_cfg_data, weight), .type = &type_descr_uint8_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_cfg_rate = { .name = "rate", .descr = "Rate shaping parameters", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_CFG_ID_RATE, .offset = offsetof(bcmbal_tm_queue_cfg_data, rate), .type = &type_descr_bcmbal_tm_shaping };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_cfg_bac = { .name = "bac", .descr = "Buffer admission control", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_CFG_ID_BAC, .offset = offsetof(bcmbal_tm_queue_cfg_data, bac), .type = &type_descr_bcmbal_tm_bac };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_cfg_creation_mode = { .name = "creation_mode", .descr = "Creation mode", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_TM_QUEUE_CFG_ID_CREATION_MODE, .offset = offsetof(bcmbal_tm_queue_cfg_data, creation_mode), .type = &type_descr_bcmbal_tm_creation_mode };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_cfg_ref_count = { .name = "ref_count", .descr = "reference count (flows)", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_TM_QUEUE_CFG_ID_REF_COUNT, .offset = offsetof(bcmbal_tm_queue_cfg_data, ref_count), .type = &type_descr_uint8_t };
static bcmbal_apicli_prop_descr * BCM_DESCR tm_queue_cfg_prop_array[] = { &prop_descr_tm_queue_cfg_priority, &prop_descr_tm_queue_cfg_weight, &prop_descr_tm_queue_cfg_rate, &prop_descr_tm_queue_cfg_bac, &prop_descr_tm_queue_cfg_creation_mode, &prop_descr_tm_queue_cfg_ref_count };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_queue_cfg_data_fields[] = { { .name = "priority", .descr = "Scheduling priority", .offset = offsetof(bcmbal_tm_queue_cfg_data, priority), .type = &type_descr_uint8_t }, { .name = "weight", .descr = "Scheduling weight", .offset = offsetof(bcmbal_tm_queue_cfg_data, weight), .type = &type_descr_uint8_t }, { .name = "rate", .descr = "Rate shaping parameters", .offset = offsetof(bcmbal_tm_queue_cfg_data, rate), .type = &type_descr_bcmbal_tm_shaping }, { .name = "bac", .descr = "Buffer admission control", .offset = offsetof(bcmbal_tm_queue_cfg_data, bac), .type = &type_descr_bcmbal_tm_bac }, { .name = "creation_mode", .descr = "Creation mode", .offset = offsetof(bcmbal_tm_queue_cfg_data, creation_mode), .type = &type_descr_bcmbal_tm_creation_mode }, { .name = "ref_count", .descr = "reference count (flows)", .offset = offsetof(bcmbal_tm_queue_cfg_data, ref_count), .type = &type_descr_uint8_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_cfg_data = { .name = "bcmbal_tm_queue_cfg_data", .descr = "cfg", .size = sizeof(bcmbal_tm_queue_cfg_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_queue_cfg_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_queue_cfg_data_fields } } };

/* Group: tm_queue - stat */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_stat_packets_ok = { .name = "packets_ok", .descr = "Packets transmitted succewssfully", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_STAT_ID_PACKETS_OK, .offset = offsetof(bcmbal_tm_queue_stat_data, packets_ok), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_stat_bytes_ok = { .name = "bytes_ok", .descr = "Bytes transmitted successfully", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_STAT_ID_BYTES_OK, .offset = offsetof(bcmbal_tm_queue_stat_data, bytes_ok), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_stat_packets_discarded = { .name = "packets_discarded", .descr = "Packets discarded", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_STAT_ID_PACKETS_DISCARDED, .offset = offsetof(bcmbal_tm_queue_stat_data, packets_discarded), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_stat_bytes_discarded = { .name = "bytes_discarded", .descr = "Bytes discarded", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_STAT_ID_BYTES_DISCARDED, .offset = offsetof(bcmbal_tm_queue_stat_data, bytes_discarded), .type = &type_descr_uint64_t };
static bcmbal_apicli_prop_descr * BCM_DESCR tm_queue_stat_prop_array[] = { &prop_descr_tm_queue_stat_packets_ok, &prop_descr_tm_queue_stat_bytes_ok, &prop_descr_tm_queue_stat_packets_discarded, &prop_descr_tm_queue_stat_bytes_discarded };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_queue_stat_data_fields[] = { { .name = "packets_ok", .descr = "Packets transmitted succewssfully", .offset = offsetof(bcmbal_tm_queue_stat_data, packets_ok), .type = &type_descr_uint64_t }, { .name = "bytes_ok", .descr = "Bytes transmitted successfully", .offset = offsetof(bcmbal_tm_queue_stat_data, bytes_ok), .type = &type_descr_uint64_t }, { .name = "packets_discarded", .descr = "Packets discarded", .offset = offsetof(bcmbal_tm_queue_stat_data, packets_discarded), .type = &type_descr_uint64_t }, { .name = "bytes_discarded", .descr = "Bytes discarded", .offset = offsetof(bcmbal_tm_queue_stat_data, bytes_discarded), .type = &type_descr_uint64_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_stat_data = { .name = "bcmbal_tm_queue_stat_data", .descr = "stat", .size = sizeof(bcmbal_tm_queue_stat_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_queue_stat_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_queue_stat_data_fields } } };

/* Group: tm_queue - ind */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_queue_ind_ret = { .name = "ret", .descr = "ret", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_QUEUE_IND_ID_RET, .offset = offsetof(bcmbal_tm_queue_ind_data, ret), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr * BCM_DESCR tm_queue_ind_prop_array[] = { &prop_descr_tm_queue_ind_ret };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_queue_ind_data_fields[] = { { .name = "ret", .descr = "ret", .offset = offsetof(bcmbal_tm_queue_ind_data, ret), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_queue_ind_data = { .name = "bcmbal_tm_queue_ind_data", .descr = "Tm Queue Indication", .size = sizeof(bcmbal_tm_queue_ind_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_queue_ind_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_queue_ind_data_fields } } };

/* ==== Object: tm_sched ==== */

/* Group: tm_sched - key */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_key_dir = { .name = "dir", .descr = "Traffic direction", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_KEY_ID_DIR, .offset = offsetof(bcmbal_tm_sched_key, dir), .type = &type_descr_bcmbal_tm_sched_dir };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_key_id = { .name = "id", .descr = "ID", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_KEY_ID_ID, .offset = offsetof(bcmbal_tm_sched_key, id), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr * BCM_DESCR tm_sched_key_prop_array[] = { &prop_descr_tm_sched_key_dir, &prop_descr_tm_sched_key_id };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_key_fields[] = { { .name = "dir", .descr = "Traffic direction", .offset = offsetof(bcmbal_tm_sched_key, dir), .type = &type_descr_bcmbal_tm_sched_dir }, { .name = "id", .descr = "ID", .offset = offsetof(bcmbal_tm_sched_key, id), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_key = { .name = "bcmbal_tm_sched_key", .descr = "key", .size = sizeof(bcmbal_tm_sched_key), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_sched_key_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_sched_key_fields } } };

/* Group: tm_sched - cfg */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_owner = { .name = "owner", .descr = "owner", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_CFG_ID_OWNER, .offset = offsetof(bcmbal_tm_sched_cfg_data, owner), .type = &type_descr_bcmbal_tm_sched_owner };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_sched_type = { .name = "sched_type", .descr = "Scheduler type", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_CFG_ID_SCHED_TYPE, .offset = offsetof(bcmbal_tm_sched_cfg_data, sched_type), .type = &type_descr_bcmbal_tm_sched_type };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_sched_parent = { .name = "sched_parent", .descr = "Scheduling parameters for parent scheduler", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_CFG_ID_SCHED_PARENT, .offset = offsetof(bcmbal_tm_sched_cfg_data, sched_parent), .type = &type_descr_bcmbal_tm_sched_parent };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_sched_child_type = { .name = "sched_child_type", .descr = "Scheduling level for children tm ", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_CFG_ID_SCHED_CHILD_TYPE, .offset = offsetof(bcmbal_tm_sched_cfg_data, sched_child_type), .type = &type_descr_bcmbal_tm_sched_child_type };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_rate = { .name = "rate", .descr = "Rate shaping parameters", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_CFG_ID_RATE, .offset = offsetof(bcmbal_tm_sched_cfg_data, rate), .type = &type_descr_bcmbal_tm_shaping };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_tcont_sla = { .name = "tcont_sla", .descr = "Additional SLA parameters for agg_port owner", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_CFG_ID_TCONT_SLA, .offset = offsetof(bcmbal_tm_sched_cfg_data, tcont_sla), .type = &type_descr_bcmbal_tm_tcont_sla };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_creation_mode = { .name = "creation_mode", .descr = "Creation mode", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_TM_SCHED_CFG_ID_CREATION_MODE, .offset = offsetof(bcmbal_tm_sched_cfg_data, creation_mode), .type = &type_descr_bcmbal_tm_creation_mode };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_queues = { .name = "queues", .descr = "Subsidiary queues", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_TM_SCHED_CFG_ID_QUEUES, .offset = offsetof(bcmbal_tm_sched_cfg_data, queues), .type = &type_descr_bcmbal_tm_queue_id_list_u8 };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_sub_scheds = { .name = "sub_scheds", .descr = "Subsidiary schedulers", .access = BCMBAL_APICLI_PROP_ACCESS_ID_R, .property = BCMBAL_TM_SCHED_CFG_ID_SUB_SCHEDS, .offset = offsetof(bcmbal_tm_sched_cfg_data, sub_scheds), .type = &type_descr_bcmbal_tm_sched_id_list_u8 };
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_cfg_num_priorities = { .name = "num_priorities", .descr = "Max number of strict priority scheduling elements", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_CFG_ID_NUM_PRIORITIES, .offset = offsetof(bcmbal_tm_sched_cfg_data, num_priorities), .type = &type_descr_uint8_t };
static bcmbal_apicli_prop_descr * BCM_DESCR tm_sched_cfg_prop_array[] = { &prop_descr_tm_sched_cfg_owner, &prop_descr_tm_sched_cfg_sched_type, &prop_descr_tm_sched_cfg_sched_parent, &prop_descr_tm_sched_cfg_sched_child_type, &prop_descr_tm_sched_cfg_rate, &prop_descr_tm_sched_cfg_tcont_sla, &prop_descr_tm_sched_cfg_creation_mode, &prop_descr_tm_sched_cfg_queues, &prop_descr_tm_sched_cfg_sub_scheds, &prop_descr_tm_sched_cfg_num_priorities };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_cfg_data_fields[] = { { .name = "owner", .descr = "owner", .offset = offsetof(bcmbal_tm_sched_cfg_data, owner), .type = &type_descr_bcmbal_tm_sched_owner }, { .name = "sched_type", .descr = "Scheduler type", .offset = offsetof(bcmbal_tm_sched_cfg_data, sched_type), .type = &type_descr_bcmbal_tm_sched_type }, { .name = "sched_parent", .descr = "Scheduling parameters for parent scheduler", .offset = offsetof(bcmbal_tm_sched_cfg_data, sched_parent), .type = &type_descr_bcmbal_tm_sched_parent }, { .name = "sched_child_type", .descr = "Scheduling level for children tm ", .offset = offsetof(bcmbal_tm_sched_cfg_data, sched_child_type), .type = &type_descr_bcmbal_tm_sched_child_type }, { .name = "rate", .descr = "Rate shaping parameters", .offset = offsetof(bcmbal_tm_sched_cfg_data, rate), .type = &type_descr_bcmbal_tm_shaping }, { .name = "tcont_sla", .descr = "Additional SLA parameters for agg_port owner", .offset = offsetof(bcmbal_tm_sched_cfg_data, tcont_sla), .type = &type_descr_bcmbal_tm_tcont_sla }, { .name = "creation_mode", .descr = "Creation mode", .offset = offsetof(bcmbal_tm_sched_cfg_data, creation_mode), .type = &type_descr_bcmbal_tm_creation_mode }, { .name = "queues", .descr = "Subsidiary queues", .offset = offsetof(bcmbal_tm_sched_cfg_data, queues), .type = &type_descr_bcmbal_tm_queue_id_list_u8 }, { .name = "sub_scheds", .descr = "Subsidiary schedulers", .offset = offsetof(bcmbal_tm_sched_cfg_data, sub_scheds), .type = &type_descr_bcmbal_tm_sched_id_list_u8 }, { .name = "num_priorities", .descr = "Max number of strict priority scheduling elements", .offset = offsetof(bcmbal_tm_sched_cfg_data, num_priorities), .type = &type_descr_uint8_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_cfg_data = { .name = "bcmbal_tm_sched_cfg_data", .descr = "cfg", .size = sizeof(bcmbal_tm_sched_cfg_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_sched_cfg_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_sched_cfg_data_fields } } };

/* Group: tm_sched - ind */
static bcmbal_apicli_prop_descr BCM_DESCR prop_descr_tm_sched_ind_ret = { .name = "ret", .descr = "ret", .access = BCMBAL_APICLI_PROP_ACCESS_ID_RW, .property = BCMBAL_TM_SCHED_IND_ID_RET, .offset = offsetof(bcmbal_tm_sched_ind_data, ret), .type = &type_descr_uint32_t };
static bcmbal_apicli_prop_descr * BCM_DESCR tm_sched_ind_prop_array[] = { &prop_descr_tm_sched_ind_ret };
static bcmbal_apicli_field_descr BCM_DESCR type_descr_bcmbal_tm_sched_ind_data_fields[] = { { .name = "ret", .descr = "ret", .offset = offsetof(bcmbal_tm_sched_ind_data, ret), .type = &type_descr_uint32_t } };
static bcmbal_apicli_type_descr BCM_DESCR type_descr_bcmbal_tm_sched_ind_data = { .name = "bcmbal_tm_sched_ind_data", .descr = "Tm Sched Indication", .size = sizeof(bcmbal_tm_sched_ind_data), .base_type = BCMBAL_APICLI_BASE_TYPE_ID_STRUCT, .x = { .s = { .num_fields = sizeof(type_descr_bcmbal_tm_sched_ind_data_fields) / sizeof(bcmbal_apicli_field_descr), .fields = type_descr_bcmbal_tm_sched_ind_data_fields } } };

/* ==== API Helper Function Implementations ==== */
bcmos_errno bcmbal_apicli_object_struct_size(bcmbal_obj_id obj, bcmbal_mgt_group group, uint16_t subgroup, uint32_t *key_size, uint32_t *key_offset, uint32_t *data_size, uint32_t *data_offset)
{
    if (((key_size == NULL) || (key_offset == NULL)) || ((data_size == NULL) || (data_offset == NULL)))
    {
        return BCM_ERR_RANGE;
    }

    switch (obj)
    {
        case BCMBAL_OBJ_ID_ACCESS_TERMINAL:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_access_terminal_key);
                            *key_offset = 0;
                            *data_size = sizeof(bcmbal_access_terminal_key);
                            *data_offset = 0;
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_access_terminal_key);
                            *key_offset = offsetof(bcmbal_access_terminal_cfg, key);
                            *data_size = sizeof(bcmbal_access_terminal_cfg_data);
                            *data_offset = offsetof(bcmbal_access_terminal_cfg, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_ACCESS_TERMINAL_AUTO_ID_IND:
                            *key_size = sizeof(bcmbal_access_terminal_key);
                            *key_offset = offsetof(bcmbal_access_terminal_ind, key);
                            *data_size = sizeof(bcmbal_access_terminal_ind_data);
                            *data_offset = offsetof(bcmbal_access_terminal_ind, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_FLOW:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_flow_key);
                            *key_offset = 0;
                            *data_size = sizeof(bcmbal_flow_key);
                            *data_offset = 0;
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_flow_key);
                            *key_offset = offsetof(bcmbal_flow_cfg, key);
                            *data_size = sizeof(bcmbal_flow_cfg_data);
                            *data_offset = offsetof(bcmbal_flow_cfg, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_flow_key);
                            *key_offset = offsetof(bcmbal_flow_stat, key);
                            *data_size = sizeof(bcmbal_flow_stat_data);
                            *data_offset = offsetof(bcmbal_flow_stat, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_FLOW_AUTO_ID_IND:
                            *key_size = sizeof(bcmbal_flow_key);
                            *key_offset = offsetof(bcmbal_flow_ind, key);
                            *data_size = sizeof(bcmbal_flow_ind_data);
                            *data_offset = offsetof(bcmbal_flow_ind, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_GROUP:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_group_key);
                            *key_offset = 0;
                            *data_size = sizeof(bcmbal_group_key);
                            *data_offset = 0;
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_group_key);
                            *key_offset = offsetof(bcmbal_group_cfg, key);
                            *data_size = sizeof(bcmbal_group_cfg_data);
                            *data_offset = offsetof(bcmbal_group_cfg, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_INTERFACE:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_interface_key);
                            *key_offset = 0;
                            *data_size = sizeof(bcmbal_interface_key);
                            *data_offset = 0;
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_interface_key);
                            *key_offset = offsetof(bcmbal_interface_cfg, key);
                            *data_size = sizeof(bcmbal_interface_cfg_data);
                            *data_offset = offsetof(bcmbal_interface_cfg, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_interface_key);
                            *key_offset = offsetof(bcmbal_interface_stat, key);
                            *data_size = sizeof(bcmbal_interface_stat_data);
                            *data_offset = offsetof(bcmbal_interface_stat, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_INTERFACE_AUTO_ID_IND:
                            *key_size = sizeof(bcmbal_interface_key);
                            *key_offset = offsetof(bcmbal_interface_ind, key);
                            *data_size = sizeof(bcmbal_interface_ind_data);
                            *data_offset = offsetof(bcmbal_interface_ind, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_PACKET:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_packet_key);
                            *key_offset = 0;
                            *data_size = sizeof(bcmbal_packet_key);
                            *data_offset = 0;
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_packet_key);
                            *key_offset = offsetof(bcmbal_packet_cfg, key);
                            *data_size = sizeof(bcmbal_packet_cfg_data);
                            *data_offset = offsetof(bcmbal_packet_cfg, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_PACKET_AUTO_ID_IND:
                            *key_size = sizeof(bcmbal_packet_key);
                            *key_offset = offsetof(bcmbal_packet_ind, key);
                            *data_size = sizeof(bcmbal_packet_ind_data);
                            *data_offset = offsetof(bcmbal_packet_ind, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_SUBSCRIBER_TERMINAL:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_subscriber_terminal_key);
                            *key_offset = 0;
                            *data_size = sizeof(bcmbal_subscriber_terminal_key);
                            *data_offset = 0;
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_subscriber_terminal_key);
                            *key_offset = offsetof(bcmbal_subscriber_terminal_cfg, key);
                            *data_size = sizeof(bcmbal_subscriber_terminal_cfg_data);
                            *data_offset = offsetof(bcmbal_subscriber_terminal_cfg, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_subscriber_terminal_key);
                            *key_offset = offsetof(bcmbal_subscriber_terminal_stat, key);
                            *data_size = sizeof(bcmbal_subscriber_terminal_stat_data);
                            *data_offset = offsetof(bcmbal_subscriber_terminal_stat, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_SUBSCRIBER_TERMINAL_AUTO_ID_IND:
                            *key_size = sizeof(bcmbal_subscriber_terminal_key);
                            *key_offset = offsetof(bcmbal_subscriber_terminal_ind, key);
                            *data_size = sizeof(bcmbal_subscriber_terminal_ind_data);
                            *data_offset = offsetof(bcmbal_subscriber_terminal_ind, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_TM_QUEUE:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_tm_queue_key);
                            *key_offset = 0;
                            *data_size = sizeof(bcmbal_tm_queue_key);
                            *data_offset = 0;
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_tm_queue_key);
                            *key_offset = offsetof(bcmbal_tm_queue_cfg, key);
                            *data_size = sizeof(bcmbal_tm_queue_cfg_data);
                            *data_offset = offsetof(bcmbal_tm_queue_cfg, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_tm_queue_key);
                            *key_offset = offsetof(bcmbal_tm_queue_stat, key);
                            *data_size = sizeof(bcmbal_tm_queue_stat_data);
                            *data_offset = offsetof(bcmbal_tm_queue_stat, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_TM_QUEUE_AUTO_ID_IND:
                            *key_size = sizeof(bcmbal_tm_queue_key);
                            *key_offset = offsetof(bcmbal_tm_queue_ind, key);
                            *data_size = sizeof(bcmbal_tm_queue_ind_data);
                            *data_offset = offsetof(bcmbal_tm_queue_ind, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_TM_SCHED:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_tm_sched_key);
                            *key_offset = 0;
                            *data_size = sizeof(bcmbal_tm_sched_key);
                            *data_offset = 0;
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *key_size = sizeof(bcmbal_tm_sched_key);
                            *key_offset = offsetof(bcmbal_tm_sched_cfg, key);
                            *data_size = sizeof(bcmbal_tm_sched_cfg_data);
                            *data_offset = offsetof(bcmbal_tm_sched_cfg, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_TM_SCHED_AUTO_ID_IND:
                            *key_size = sizeof(bcmbal_tm_sched_key);
                            *key_offset = offsetof(bcmbal_tm_sched_ind, key);
                            *data_size = sizeof(bcmbal_tm_sched_ind_data);
                            *data_offset = offsetof(bcmbal_tm_sched_ind, data);
                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        default:
            return BCM_ERR_RANGE;
    }

    return BCM_ERR_INTERNAL;    /**<  should never happen. */
}

bcmos_errno bcmbal_apicli_object_subgroup_name(bcmbal_obj_id obj, bcmbal_mgt_group group, uint16_t subgroup, const char **name, const char **descr)
{
    switch (obj)
    {
        case BCMBAL_OBJ_ID_ACCESS_TERMINAL:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "key";
                            }

                            if (descr != NULL)
                            {
                                *descr = "key";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "cfg";
                            }

                            if (descr != NULL)
                            {
                                *descr = "cfg";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_ACCESS_TERMINAL_AUTO_ID_IND:
                            if (name != NULL)
                            {
                                *name = "ind";
                            }

                            if (descr != NULL)
                            {
                                *descr = "Access Terminal Indication";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_FLOW:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "key";
                            }

                            if (descr != NULL)
                            {
                                *descr = "key";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "cfg";
                            }

                            if (descr != NULL)
                            {
                                *descr = "cfg";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "stat";
                            }

                            if (descr != NULL)
                            {
                                *descr = "stat";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_FLOW_AUTO_ID_IND:
                            if (name != NULL)
                            {
                                *name = "ind";
                            }

                            if (descr != NULL)
                            {
                                *descr = "Flow Indication";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_GROUP:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "key";
                            }

                            if (descr != NULL)
                            {
                                *descr = "key";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "cfg";
                            }

                            if (descr != NULL)
                            {
                                *descr = "cfg";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_INTERFACE:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "key";
                            }

                            if (descr != NULL)
                            {
                                *descr = "key";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "cfg";
                            }

                            if (descr != NULL)
                            {
                                *descr = "cfg";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "stat";
                            }

                            if (descr != NULL)
                            {
                                *descr = "stat";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_INTERFACE_AUTO_ID_IND:
                            if (name != NULL)
                            {
                                *name = "ind";
                            }

                            if (descr != NULL)
                            {
                                *descr = "Interface Indication";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_PACKET:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "key";
                            }

                            if (descr != NULL)
                            {
                                *descr = "key";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "cfg";
                            }

                            if (descr != NULL)
                            {
                                *descr = "cfg";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_PACKET_AUTO_ID_IND:
                            if (name != NULL)
                            {
                                *name = "ind";
                            }

                            if (descr != NULL)
                            {
                                *descr = "Packet indication";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_SUBSCRIBER_TERMINAL:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "key";
                            }

                            if (descr != NULL)
                            {
                                *descr = "key";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "cfg";
                            }

                            if (descr != NULL)
                            {
                                *descr = "cfg";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "stat";
                            }

                            if (descr != NULL)
                            {
                                *descr = "stat";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_SUBSCRIBER_TERMINAL_AUTO_ID_IND:
                            if (name != NULL)
                            {
                                *name = "ind";
                            }

                            if (descr != NULL)
                            {
                                *descr = "Subscriber Terminal Indication";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_TM_QUEUE:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "key";
                            }

                            if (descr != NULL)
                            {
                                *descr = "key";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "cfg";
                            }

                            if (descr != NULL)
                            {
                                *descr = "cfg";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "stat";
                            }

                            if (descr != NULL)
                            {
                                *descr = "stat";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_TM_QUEUE_AUTO_ID_IND:
                            if (name != NULL)
                            {
                                *name = "ind";
                            }

                            if (descr != NULL)
                            {
                                *descr = "Tm Queue Indication";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        case BCMBAL_OBJ_ID_TM_SCHED:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "key";
                            }

                            if (descr != NULL)
                            {
                                *descr = "key";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            if (name != NULL)
                            {
                                *name = "cfg";
                            }

                            if (descr != NULL)
                            {
                                *descr = "cfg";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_TM_SCHED_AUTO_ID_IND:
                            if (name != NULL)
                            {
                                *name = "ind";
                            }

                            if (descr != NULL)
                            {
                                *descr = "Tm Sched Indication";
                            }

                            return BCM_ERR_OK;
                        default:
                            return BCM_ERR_RANGE;
                    }

                default:
                    return BCM_ERR_RANGE;
            }

        default:
            return BCM_ERR_RANGE;
    }

    return BCM_ERR_INTERNAL;    /**<  should never happen. */
}

static bcmbal_apicli_prop_descr **obj_get_prop_array(bcmbal_obj_id obj, bcmbal_mgt_group group, uint16_t subgroup, uint32_t *size)
{
    switch (obj)
    {
        case BCMBAL_OBJ_ID_ACCESS_TERMINAL:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(access_terminal_key_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return access_terminal_key_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(access_terminal_cfg_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return access_terminal_cfg_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_ACCESS_TERMINAL_AUTO_ID_IND:
                            *size = sizeof(access_terminal_ind_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return access_terminal_ind_prop_array;
                        default:
                            break;
                    }

                default:
                    break;
            }

        case BCMBAL_OBJ_ID_FLOW:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(flow_key_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return flow_key_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(flow_cfg_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return flow_cfg_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(flow_stat_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return flow_stat_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_FLOW_AUTO_ID_IND:
                            *size = sizeof(flow_ind_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return flow_ind_prop_array;
                        default:
                            break;
                    }

                default:
                    break;
            }

        case BCMBAL_OBJ_ID_GROUP:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(group_key_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return group_key_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(group_cfg_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return group_cfg_prop_array;
                        default:
                            break;
                    }

                default:
                    break;
            }

        case BCMBAL_OBJ_ID_INTERFACE:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(interface_key_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return interface_key_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(interface_cfg_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return interface_cfg_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(interface_stat_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return interface_stat_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_INTERFACE_AUTO_ID_IND:
                            *size = sizeof(interface_ind_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return interface_ind_prop_array;
                        default:
                            break;
                    }

                default:
                    break;
            }

        case BCMBAL_OBJ_ID_PACKET:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(packet_key_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return packet_key_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(packet_cfg_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return packet_cfg_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_PACKET_AUTO_ID_IND:
                            *size = sizeof(packet_ind_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return packet_ind_prop_array;
                        default:
                            break;
                    }

                default:
                    break;
            }

        case BCMBAL_OBJ_ID_SUBSCRIBER_TERMINAL:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(subscriber_terminal_key_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return subscriber_terminal_key_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(subscriber_terminal_cfg_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return subscriber_terminal_cfg_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(subscriber_terminal_stat_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return subscriber_terminal_stat_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_SUBSCRIBER_TERMINAL_AUTO_ID_IND:
                            *size = sizeof(subscriber_terminal_ind_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return subscriber_terminal_ind_prop_array;
                        default:
                            break;
                    }

                default:
                    break;
            }

        case BCMBAL_OBJ_ID_TM_QUEUE:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(tm_queue_key_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return tm_queue_key_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(tm_queue_cfg_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return tm_queue_cfg_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_STAT:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(tm_queue_stat_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return tm_queue_stat_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_TM_QUEUE_AUTO_ID_IND:
                            *size = sizeof(tm_queue_ind_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return tm_queue_ind_prop_array;
                        default:
                            break;
                    }

                default:
                    break;
            }

        case BCMBAL_OBJ_ID_TM_SCHED:
            switch (group)
            {
                case BCMBAL_MGT_GROUP_KEY:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(tm_sched_key_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return tm_sched_key_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_CFG:
                    switch (subgroup)
                    {
                        case 0:
                            *size = sizeof(tm_sched_cfg_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return tm_sched_cfg_prop_array;
                        default:
                            break;
                    }

                case BCMBAL_MGT_GROUP_AUTO:
                    switch (subgroup)
                    {
                        case BCMBAL_TM_SCHED_AUTO_ID_IND:
                            *size = sizeof(tm_sched_ind_prop_array) / sizeof(bcmbal_apicli_prop_descr *);
                            return tm_sched_ind_prop_array;
                        default:
                            break;
                    }

                default:
                    break;
            }

        default:
            break;
    }

    return NULL;
}

bcmos_errno bcmbal_apicli_object_name(bcmbal_obj_id obj, const char **name, const char **descr)
{
    if (obj >= BCMBAL_OBJ_ID__NUM_OF)
    {
        return BCM_ERR_RANGE;
    }

    if (object_name[obj] == NULL)
    {
        return BCM_ERR_NOENT;
    }

    if (name != NULL)
    {
        *name = object_name[obj];
    }

    if (descr != NULL)
    {
        *descr = object_descr[obj];
    }

    return BCM_ERR_OK;
}

bcmos_errno bcmbal_apicli_object_property(bcmbal_obj_id obj, bcmbal_mgt_group group, uint16_t subgroup, uint16_t prop, const bcmbal_apicli_prop_descr **descr)
{
    bcmbal_apicli_prop_descr **prop_array = NULL;
    uint32_t prop_array_size = 0;
    if (descr == NULL)
    {
        return BCM_ERR_PARM;
    }

    prop_array = obj_get_prop_array(obj, group, subgroup, &prop_array_size);
    if ((prop_array == NULL) || (prop >= prop_array_size))
    {
        return BCM_ERR_RANGE;
    }

    if (prop_array[prop] == NULL)
    {
        return BCM_ERR_NOENT;
    }

    *descr = prop_array[prop];
    return BCM_ERR_OK;
}
