/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_worker.h
 * 
 * @brief Bal worker thread included
 * 
 * Module contains the data structures and functions used to support the 
 * BAL core worker thread.
 */

#ifndef	BAL_API_WORKER_H
#define	BAL_API_WORKER_H

#include <bcmos_errno.h>

extern bcmos_msg_queue *p_balapi_to_core_queue;

typedef enum {
    IND_CB_SUBSCRIBE,
    IND_CB_UNSUBSCRIBE
}bcmbal_ind_cb_management_type;

/*
 * Function declarations
 */
extern bcmos_errno bal_api_ind_msg_queue_create(mgmt_queue_addr_ports *mgmt_queue_info);
extern void enable_bal_api_indications(const char *balapi_mgmt_ip_port);
extern bcmos_errno _manage_api_ind_listener(bcmbal_ind_cb_management_type type, bcmbal_cb_cfg *cb_cfg);
extern void bal_api_indications_finish(void);


#endif /* BAL_API_WORKER_H */
