#!/bin/bash
###############################################################################
#
#  <:copyright-BRCM:2016:proprietary:standard
#
#     Broadcom Ltd. Proprietary and Confidential.(c) 2016 Broadcom Ltd.
#     All Rights Reserved
#
#  This program is the proprietary software of Broadcom Ltd. and/or its
#  licensors, and may only be used, duplicated, modified or distributed pursuant
#  to the terms and conditions of a separate, written license agreement executed
#  between you and Broadcom Ltd. (an "Authorized License").  Except as set forth in
#  an Authorized License, Broadcom Ltd. grants no license (express or implied), right
#  to use, or waiver of any kind with respect to the Software, and Broadcom Ltd.
#  expressly reserves all rights in and to the Software and all intellectual
#  property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
#  NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
#  BROADCOM LTD AND DISCONTINUE ALL USE OF THE SOFTWARE.
#
#  Except as expressly set forth in the Authorized License,
#
#  1. This program, including its structure, sequence and organization,
#      constitutes the valuable trade secrets of Broadcom Ltd., and you shall use
#      all reasonable efforts to protect the confidentiality thereof, and to
#      use this information only in connection with your use of Broadcom Ltd.
#      integrated circuit products.
#
#  2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
#      AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
#      WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
#      RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
#      ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
#      FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
#      COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
#      TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
#      PERFORMANCE OF THE SOFTWARE.
#
#  3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
#      ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
#      INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
#      WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
#      IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
#      OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
#      SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
#      SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
#      LIMITED REMEDY.
#  :>
#
###############################################################################

# This script is called from the main Makefile.
# Prerequisites:
# 1. BAL standalone or ofpal_of_agent binaries are built.
# 2. Environment variables defined:
#    - SRC_RELEASE_FILE_PREFIX : source release file prefix (string)
#    - INCLUDE_MAPLE_SDK_RELEASE : include maple SDK release (if set, then Maple SDK release is included, and its zip actually contains BAL's code, without OMCI and SDN-PAL).

if [[ "$SRC_RELEASE_FILE_PREFIX" == "" ]]; then
   echo SRC_RELEASE_FILE_PREFIX variable must be set
   exit -1
fi

TMP_DIR=/tmp/bal_src_release/`date +%d_%m_%Y_%H_%M_%S`

BAL_RELEASE_PREFIX=bal.$SRC_RELEASE_FILE_PREFIX
SDN_PAL_RELEASE_PREFIX=sdn_pal.$SRC_RELEASE_FILE_PREFIX
OMCI_RELEASE_PREFIX=omci.$SRC_RELEASE_FILE_PREFIX

BAL_RELEASE_DIR=$TMP_DIR/bal/$SRC_RELEASE_FILE_PREFIX
SDN_PAL_RELEASE_DIR=$TMP_DIR/sdn_pal/$SRC_RELEASE_FILE_PREFIX
OMCI_RELEASE_DIR=$TMP_DIR/omci/$SRC_RELEASE_FILE_PREFIX

BAL_SRC_RELEASE_FILE=$BAL_RELEASE_PREFIX.tar.gz
SDN_PAL_SRC_RELEASE_FILE=$SDN_PAL_RELEASE_PREFIX.tar.gz
OMCI_SRC_RELEASE_FILE=$OMCI_RELEASE_PREFIX.tar.gz

CP="cp -R --parents"

if [ -d build/core ]; then
    SUBSYSTEM=core
elif [ -d build/agent ]; then
    SUBSYSTEM=agent
else
   echo Neither build/core nor build/agent subdirectories exist
   exit -1
fi

if [ ! -f build/$SUBSYSTEM/src/common/include/bal_model_ids.h ]; then
    echo Generated BAL header files are missing. Build BAL first
    exit -1
fi

if [ ! -f build/$SUBSYSTEM/src/lib/libomcisvc/omci_model_ids.h ]; then
    echo Generated OMCI SVC header files are missing. Build OMCI SVC first
    exit -1
fi

mkdir -p $BAL_RELEASE_DIR
mkdir -p $SDN_PAL_RELEASE_DIR
mkdir -p $OMCI_RELEASE_DIR

# Copy auto-generated files first, as we will need to do "make clean" afterwards (because some 3rdparty libraries have binaries in the source directories and we need to clean those).
# 1. BAL
mkdir -p $BAL_RELEASE_DIR/src/common/include
cp \
    build/$SUBSYSTEM/src/common/include/bal_model_ids.h \
    build/$SUBSYSTEM/src/common/include/bal_model_types.h \
    $BAL_RELEASE_DIR/src/common/include

mkdir -p $BAL_RELEASE_DIR/src/lib/libobjmsg
cp  \
    build/$SUBSYSTEM/src/lib/libobjmsg/bal_model_funcs.c \
    build/$SUBSYSTEM/src/lib/libobjmsg/bal_obj_msg_pack_unpack.c \
    build/$SUBSYSTEM/src/lib/libobjmsg/bal_model_funcs.h \
    build/$SUBSYSTEM/src/lib/libobjmsg/bal_obj_msg_pack_unpack.h \
    $BAL_RELEASE_DIR/src/lib/libobjmsg

mkdir -p $BAL_RELEASE_DIR/src/lib/libbalapicli
cp \
    build/$SUBSYSTEM/src/lib/libbalapicli/bal_api_cli_helpers.h \
    build/$SUBSYSTEM/src/lib/libbalapicli/bal_api_cli_helpers.c \
    build/$SUBSYSTEM/src/lib/libbalapicli/bal_api_cli_handlers.c \
    $BAL_RELEASE_DIR/src/lib/libbalapicli

# 2. OMCI
# Copy auto-generated files to the sources directory
mkdir -p $OMCI_RELEASE_DIR/src/lib/libomcisvc
cp \
    build/$SUBSYSTEM/src/lib/libomcisvc/omci_model_ids.h \
    build/$SUBSYSTEM/src/lib/libomcisvc/omci_model_types.h \
    build/$SUBSYSTEM/src/lib/libomcisvc/omci_model_funcs.h \
    build/$SUBSYSTEM/src/lib/libomcisvc/omci_model_funcs.c \
    build/$SUBSYSTEM/src/lib/libomcisvc/omci_cli_handlers.c \
    build/$SUBSYSTEM/src/lib/libomcisvc/omci_cli_helpers.h \
    build/$SUBSYSTEM/src/lib/libomcisvc/omci_cli_helpers.c \
    $OMCI_RELEASE_DIR/src/lib/libomcisvc

# Clean
make clean
make clean BUILD_NC_AGENT=y

# Now recreate the subsystem directory (wiped out by the make clean), because the archive artifacts from the build will go there
mkdir -p build/$SUBSYSTEM

# Now main copy

# 1. BAL

# Copy only relevant sources.
for file in `find mk -maxdepth 1 -type f`; do cp -L --parents $file $BAL_RELEASE_DIR; done
$CP 3rdparty/bcm-sdk/make $BAL_RELEASE_DIR/
$CP 3rdparty/bcm-sdk/Makefile $BAL_RELEASE_DIR/
$CP 3rdparty/bcm-sdk/Makefile.sdk $BAL_RELEASE_DIR/
$CP 3rdparty/bcm-sdk/make_ing_dir.sh $BAL_RELEASE_DIR/
$CP 3rdparty/bcm-sdk/rc $BAL_RELEASE_DIR/
$CP 3rdparty/bcm-sdk/*.patch $BAL_RELEASE_DIR/
$CP 3rdparty/bcm-sdk/sh $BAL_RELEASE_DIR/
$CP 3rdparty/linenoise $BAL_RELEASE_DIR/
$CP 3rdparty/maple/Makefile $BAL_RELEASE_DIR/
$CP branch.info $BAL_RELEASE_DIR/
chmod +w $BAL_RELEASE_DIR/branch.info
echo PERFORCE_REVISION=$BUILD_PERFORCE_REVISION >> $BAL_RELEASE_DIR/branch.info
$CP COPYRIGHT $BAL_RELEASE_DIR/
$CP doxygen $BAL_RELEASE_DIR/
$CP Makefile $BAL_RELEASE_DIR/
$CP README* $BAL_RELEASE_DIR/
$CP mk/boards $BAL_RELEASE_DIR/
$CP mk/core/Makefile* $BAL_RELEASE_DIR/
$CP mk/core/modules.core.bal $BAL_RELEASE_DIR/
$CP mk/agent/modules.agent.bal $BAL_RELEASE_DIR/
$CP scripts $BAL_RELEASE_DIR/
$CP src/common $BAL_RELEASE_DIR/
$CP src/core $BAL_RELEASE_DIR/
$CP src/apps/bal_cli $BAL_RELEASE_DIR/
$CP src/datamodel/bal.objset $BAL_RELEASE_DIR/
$CP src/lib/common $BAL_RELEASE_DIR/
$CP src/lib/libbalapi $BAL_RELEASE_DIR/
$CP src/lib/libbalapicli $BAL_RELEASE_DIR/
$CP src/lib/libobjmsg $BAL_RELEASE_DIR/
$CP src/lib/librscmgr $BAL_RELEASE_DIR/
$CP src/lib/libtopology $BAL_RELEASE_DIR/
$CP src/lib/libutils $BAL_RELEASE_DIR/
$CP src/lib/libcmdline $BAL_RELEASE_DIR/
$CP tools $BAL_RELEASE_DIR/

# The following file will indicate a release build
touch $BAL_RELEASE_DIR/.release_build

# Add write permission to all the copied files
find $BAL_RELEASE_DIR -type f | xargs -d '\n' chmod +w

# Remove codegen_templates and .ccache
find $BAL_RELEASE_DIR -name codegen_templates | xargs rm -rf
find $BAL_RELEASE_DIR -name .ccache | xargs rm -rf

cd $BAL_RELEASE_DIR/..
tar -czf $BAL_SRC_RELEASE_FILE $SRC_RELEASE_FILE_PREFIX
cd - > /dev/null
mv $TMP_DIR/bal/$BAL_SRC_RELEASE_FILE .
echo ./$BAL_SRC_RELEASE_FILE created

# 2. SDN-PAL

# Copy only relevant sources.
for file in `find mk -maxdepth 1 -type f`; do cp --parents $file $SDN_PAL_RELEASE_DIR; done
$CP 3rdparty/loci $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/libxml2 $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/libxslt $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/libgpg-error $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/libgcrypt $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/libssh $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/libcurl $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/libnetconf $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/indigo $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/openyuma $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/yang/BBF $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/yang/IANA $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/yang/IETF $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/pyang $SDN_PAL_RELEASE_DIR/
$CP 3rdparty/netopeer $SDN_PAL_RELEASE_DIR/
$CP mk/agent/Makefile* $SDN_PAL_RELEASE_DIR/
$CP mk/agent/modules.agent.sdn_pal $SDN_PAL_RELEASE_DIR/
$CP src/agent $SDN_PAL_RELEASE_DIR/
$CP src/netconf $SDN_PAL_RELEASE_DIR/
$CP src/ofpal $SDN_PAL_RELEASE_DIR/

# Add write permission to all the copied files
find $SDN_PAL_RELEASE_DIR -type f | xargs -d '\n' chmod +w

# Remove .ccache
find $SDN_PAL_RELEASE_DIR -name .ccache | xargs rm -rf

cd $SDN_PAL_RELEASE_DIR/..
tar -czf $SDN_PAL_SRC_RELEASE_FILE $SRC_RELEASE_FILE_PREFIX
cd - > /dev/null
mv $TMP_DIR/sdn_pal/$SDN_PAL_SRC_RELEASE_FILE .
echo ./$SDN_PAL_SRC_RELEASE_FILE created

# 3. OMCI

# Copy only relevant sources.
$CP mk/core/modules.core.omci $OMCI_RELEASE_DIR/
$CP mk/agent/modules.agent.omci $OMCI_RELEASE_DIR/
$CP src/datamodel/omci* $OMCI_RELEASE_DIR/
$CP src/lib/libomcistack $OMCI_RELEASE_DIR/
$CP src/lib/libomcisvc $OMCI_RELEASE_DIR/

# Remove OCS OMCI stack from modules.*.omci
sed -i '/3rdparty\/ocs_omci/d' $OMCI_RELEASE_DIR/mk/core/modules.core.omci
sed -i '/3rdparty\/ocs_omci/d' $OMCI_RELEASE_DIR/mk/agent/modules.agent.omci

# Add write permission to all the copied files
find $OMCI_RELEASE_DIR -type f | xargs -d '\n' chmod +w

# Remove codegen_templates and .ccache
find $OMCI_RELEASE_DIR -name codegen_templates | xargs rm -rf
find $OMCI_RELEASE_DIR -name .ccache | xargs rm -rf

# Add a flag to OMCI SVC's Makefile, so that when OMCI package is extracted, builds will include real OMCI SVC, not stubs.
echo "USE_BCM_OMCI_SVC_IN_RELEASE=y" >> $OMCI_RELEASE_DIR/src/lib/libomcisvc/Makefile.config.omci

cd $OMCI_RELEASE_DIR/..
tar -czf $OMCI_SRC_RELEASE_FILE $SRC_RELEASE_FILE_PREFIX
cd - > /dev/null
mv $TMP_DIR/omci/$OMCI_SRC_RELEASE_FILE .
echo ./$OMCI_SRC_RELEASE_FILE created

# If INCLUDE_MAPLE_SDK_RELEASE is defined, then we create a maple release that will wrap the BAL release.
if [[ "$INCLUDE_MAPLE_SDK_RELEASE" != "" ]]; then
    OLD_DIR=`pwd`
    BAL_MAPLE_RELEASE_DIR=$TMP_DIR/bal_maple_release
    ./3rdparty/maple/cur/scripts/rel_delivery.sh $MAPLE_REL_DELIVERY_PREFIX
    BCM68620_ZIP_FILE=`ls ./3rdparty/maple/cur/SW-BCM68620*.zip`
    mkdir -p $BAL_MAPLE_RELEASE_DIR/bcm68620_release
    unzip $BCM68620_ZIP_FILE -d $BAL_MAPLE_RELEASE_DIR/bcm68620_release
    
    cd $BAL_MAPLE_RELEASE_DIR
    ln -s bcm68620_release/release/docs docs

    mkdir -p bal_release
    cd $BAL_RELEASE_DIR
    $CP . $BAL_MAPLE_RELEASE_DIR/bal_release/
    cd $BAL_MAPLE_RELEASE_DIR/bal_release/3rdparty/maple
    ln -s ../../../bcm68620_release cur

    cd $BAL_MAPLE_RELEASE_DIR
    zip -y -r `basename $BCM68620_ZIP_FILE` ./*
    cd $OLD_DIR
    mv $BAL_MAPLE_RELEASE_DIR/`basename $BCM68620_ZIP_FILE` .
    echo `basename ./$BCM68620_ZIP_FILE` created
fi

echo Instructions of how to extract and compile source release packages exist in `ls README*` files

rm -rf $TMP_DIR

