#!/bin/bash
#set -x

# Copy config script. Look in the BAL directory first. If not found, take from the scripts
function copy_config_script {
	if test -n "$2"; then
		template_dir=$2
	else
		template_dir=$bal_dir/scripts
	fi
	if [ -f $bal_dir/$1 ]; then
	   cp -a $bal_dir/$1 $target_dir/
	else
	   cp -a $template_dir/$1 $target_dir/
	fi
}

bal_dir=`pwd`

# Copy and strip bcm_sdn_agent
if [ "$BUILD_OF_AGENT" = "y" ]; then
	target_dir=bcm_sdn_agent_artifacts
	target_exec=bcm_sdn_agent
	target_name=bcm_sdn_agent
	build_dir=build/agent
else
	target_dir=bcm_bal_artifacts
	target_name=bal_cli
	target_exec=src/apps/bal_cli/bal_cli
	build_dir=build/core
fi

cd $build_dir
echo "Creating $target_name build artifacts in `pwd`/$target_dir"
rm -fr $target_dir
mkdir -p $target_dir

echo "Stripping $target_name and extracting debug symbols"
${CROSS_COMPILE}objcopy --strip-debug --strip-unneeded $target_exec $target_dir/$target_name
${CROSS_COMPILE}objcopy --only-keep-debug $target_exec $target_name.debug
${CROSS_COMPILE}objcopy --add-gnu-debuglink=$target_name.debug $target_dir/$target_name
echo "Stripping complete"

if [ "$JENKINS_BUILD" == "y" ]; then
	cp $bal_dir/../../../build_info.log build_info.log
	tar -czf $target_name.debug.tar.gz $target_name.debug build_info.log
	rm build_info.log
else
	tar -czf $target_name.debug.tar.gz $target_name.debug
fi

# Copy init scripts. Look in the BAL directory first. If not found, take from the scripts
copy_config_script bal_config.ini
copy_config_script bal_autostart.ini
copy_config_script bal_topology.ini
# Rename the bal_topology.ini file to avoid bringup issues
mv $target_dir/bal_topology.ini $target_dir/bal_topology.ini.sample
copy_config_script rpc.soc.template $bal_dir/3rdparty/bcm-sdk/rc/bal
cp -ar ../../3rdparty/bcm-sdk/rc $target_dir/switch_rc
rm -fr $target_dir/switch_rc/arad $target_dir/switch_rc/kt2

if [ "$BUILD_NC_AGENT" = "y" ]; then
    cp -ar lib $target_dir/
    # for SDN-PAL running on x86, copy the libssl and libcrypto
    if [ "$BOARD" = "" ]; then
        echo "Copying libcrypto and libssl for x86 target"
        cp /usr/lib/libssl.so.10 /usr/lib/libcrypto.so.10 $target_dir/lib/
    fi
    cp -ar modules $target_dir/
    cp -a start_sdn_agent.sh $target_dir/
    cp -a start_netopeer_cli.sh $target_dir/
    cp -a bin/netopeer-cli $target_dir/
fi

if [ "$BOARD" = "wrx" ]; then
    echo "Copying SVK4 specific scripts and files"
    copy_config_script bal_setup_svk4.sh
    echo 'if [ "${PWD}" != "/broadcom" ]; then echo "ERROR: Your archive file must be expanded into /broadcom before running this script"; else if [ -d /etc/rcS.d ]; then echo "Installing bal startup script in /etc/rcS.d" && pushd /etc/rcS.d >/dev/null && rm -f S99balsetup && ln -s /broadcom/bal_setup_svk4.sh S99balsetup && popd >/dev/null && echo "Installing svk4 scripts" && cp -f switch_rc/svk4/* . && touch /etc/svk4 && cat bal_config.ini | sed s/"of_devs=1"/"of_devs=2"/g > bal_config.ini.svk4_devs && cat bal_config.ini.svk4_devs | sed s/"num_nni_ports=1"/"num_nni_ports=6"/g > bal_config.ini.svk4_devs_nni && cat bal_config.ini.svk4_devs_nni | sed s/"maptable=3"/"maptable=4"/g > bal_config.ini && rm -f bal_config.ini.svk4_devs && rm -f bal_config.ini.svk4_devs_nni; fi; fi' > svk4_install.sh
    chmod 755 svk4_install.sh
    cp svk4_install.sh $target_dir
    echo "Please run svk4_install.sh (only on SVK4 hardware!)" > README.svk4
    cp ../../3rdparty/maple/sdk/build/fs/svk_init_startup.sh $target_dir/
    if [ "$JENKINS_BUILD" == "y" ]; then
        cp ../../3rdparty/bcm-sdk/build-wrx/sdk-all-*/build/projects/xPON_OLT/jenkins/jobs/Bal.Synced.bcm-sdk-*.Wrx/workspace/bal/cur/3rdparty/bcm-sdk/linux-*-bde.ko $target_dir/
    fi
    cp README.svk4 $target_dir/ && rm README.svk4
fi

if [ "$JENKINS_BUILD" == "y" ]; then
    echo "Including build_info.log in the archive"
    cp $bal_dir/../../../build_info.log $target_dir/
fi

archive=$target_dir.tar.gz
echo "Archiving artifacts in `pwd`/$archive"
tar -czf $archive $target_dir
echo "Archive contains:"
tar tzvf $archive


