#!/bin/bash
###############################################################################
#
#  <:copyright-BRCM:2016:proprietary:standard
#   
#     Broadcom Ltd. Proprietary and Confidential.(c) 2016 Broadcom Ltd.
#     All Rights Reserved
#   
#  This program is the proprietary software of Broadcom Ltd. and/or its
#  licensors, and may only be used, duplicated, modified or distributed pursuant
#  to the terms and conditions of a separate, written license agreement executed
#  between you and Broadcom Ltd. (an "Authorized License").  Except as set forth in
#  an Authorized License, Broadcom Ltd. grants no license (express or implied), right
#  to use, or waiver of any kind with respect to the Software, and Broadcom Ltd.
#  expressly reserves all rights in and to the Software and all intellectual
#  property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
#  NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
#  BROADCOM LTD AND DISCONTINUE ALL USE OF THE SOFTWARE.
#   
#  Except as expressly set forth in the Authorized License,
#   
#  1. This program, including its structure, sequence and organization,
#      constitutes the valuable trade secrets of Broadcom Ltd., and you shall use
#      all reasonable efforts to protect the confidentiality thereof, and to
#      use this information only in connection with your use of Broadcom Ltd.
#      integrated circuit products.
#   
#  2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
#      AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
#      WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
#      RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
#      ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
#      FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
#      COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
#      TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
#      PERFORMANCE OF THE SOFTWARE.
#   
#  3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
#      ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
#      INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
#      WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
#      IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
#      OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
#      SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
#      SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
#      LIMITED REMEDY.
#  :>
#
###############################################################################

# This script is called from the main Makefile.
# Prerequisites:
# 1. BAL standalone or ofpal_of_agent binaries are built.
# 2. Environment variables defined:
#    - BUILD_TARGET : bal_of_agent / bal_core
#    - BIN_RELEASE_FILE_PREFIX  : binary release file prefix

if [[ "$BIN_RELEASE_FILE_PREFIX" == "" ]]; then
   echo BIN_RELEASE_FILE_PREFIX variable must be set
   exit -1
fi

TMP_DIR=/tmp/bal_bin_release/`date +%d_%m_%Y_%H_%M_%S`
BIN_RELEASE_FILE=$BIN_RELEASE_FILE_PREFIX.tar.gz
BIN_RELEASE_DIR=$TMP_DIR/$BIN_RELEASE_FILE_PREFIX

mkdir -p $BIN_RELEASE_DIR

if [[ "$BUILD_TARGET" == "core" ]]; then
    echo Generating BAL Release Archive $BIN_RELEASE_FILE
    cp build/core/src/core/main/bal_core $BIN_RELEASE_DIR/
elif [[ "$BUILD_TARGET" == "agent" ]]; then
    echo Generating OF Agent Release Archive $BIN_RELEASE_FILE
    cp build/agent/3rdparty/indigo/ofpal_of_agent $BIN_RELEASE_DIR/bcm_sdn_agent
# The following are relevant only when BUILD_NC_AGENT=y, so they might not exist
    if test -e build/agent/start_sdn_agent.sh; then cp build/agent/start_sdn_agent.sh $BIN_RELEASE_DIR; fi
    if test -e build/agent/lib; then cp -ar build/agent/lib $BIN_RELEASE_DIR; fi
    if test -e build/agent/bin; then cp -ar build/agent/bin $BIN_RELEASE_DIR; fi
    if test -e build/agent/modules; then cp -ar build/agent/modules $BIN_RELEASE_DIR; fi
    if test -e /usr/lib/libssl.so.10; then cp -ar /usr/lib/libssl.so.10 $BIN_RELEASE_DIR; fi
    if test -e /usr/lib/libcrypto.so.10; then cp -ar /usr/lib/libcrypto.so.10 $BIN_RELEASE_DIR; fi
else
    echo BUILD_TARGET has unexpected value \"$BUILD_TARGET\". Must be \"core\" or \"agent\"
    exit -1
fi

cp scripts/bal_autostart.ini $BIN_RELEASE_DIR/
cp scripts/bal_config.ini $BIN_RELEASE_DIR/
cp 3rdparty/bcm-sdk/rc/bal/rpc.soc.template $BIN_RELEASE_DIR

cd $TMP_DIR
tar -czf $BIN_RELEASE_FILE $BIN_RELEASE_FILE_PREFIX
echo ./$BIN_RELEASE_FILE created

