#!/bin/sh

while [[ $# > 1 ]]
do
key="$1"

case $key in
    -Ca)
    CORE_IPUDP="$2"
    shift # past argument
    ;;
    -S)
    SWITCH_IPUDP="$2"
    shift # past argument
    ;;
    *)
            # unknown option
    echo "Unknown Options - ${key}"
    ;;
esac
shift # past argument or value
done


CORE_IP=${CORE_IPUDP%%:*}
CORE_UDP=${CORE_IPUDP##*:}
SWITCH_IP=${SWITCH_IPUDP%%:*}
SWITCH_UDP=${SWITCH_IPUDP##*:}

cd /opt/bcm56450

if [ ! -z "${SWITCH_IP}" ]; then
sed -i "s/.*app.ip.*/bal set app.ip ${SWITCH_IP}/" ./bal.soc
fi

if [ ! -z "${SWITCH_UDP}" ]; then
sed -i "s/.*app.udp_port.*/bal set app.udp_port ${SWITCH_UDP}/" ./bal.soc
fi

if [ ! -z "${CORE_IP}" ]; then
sed -i "s/.*app.peer_ip.*/bal set app.peer_ip ${CORE_IP}/" ./bal.soc
fi

if [ ! -z "${CORE_UDP}" ]; then
sed -i "s/.*app.peer_port.*/bal set app.peer_port ${CORE_UDP}/" ./bal.soc
fi

./kt2_init.sh

