#!/bin/sh
# this shell script build the ING SDK with BAL switch app as a thread
# Eventually this script will be replaced by a make file
#set -x
echo "Preparing ING SDK ${ING_SDK} source tree in ${ING_SDK_DIR}"

# making build directory
rm -fr ${ING_SDK_DIR}
mkdir -p ${ING_SDK_DIR}
cd ${ING_SDK_DIR}/..

#untar the sdk tgz file
echo "Untaring ${ING_SDK}.tar.gz"
tar zxf ${ING_SDK_TOP_DIR}/${ING_SDK}.tar.gz

#patch sdk with bal modifications - DO NOT change the patch order
echo "Patching SDK ${ING_SDK}.tar.gz with patch file ${ING_SDK_PATCH}"
patch -p0 < ${ING_SDK_TOP_DIR}/${ING_SDK_PATCH}

#link switch app .h and .c files
echo "Link Switch App Source files"
cd ${ING_SDK_DIR}
mkdir -p make/

if [ "${SWITCH}" = "qax" ];
then
    ln -s ${ING_SDK_TOP_DIR}/make/Make.local.qax    make/Make.local
else
    echo " SWITCH = ${SWITCH} is not specified or supported"
    exit
fi

echo "Done"
