/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
*/

#ifndef _OMON_H_
#define _OMON_H_

#include <bcmos_system.h>
#include <bcmolt_api.h>
#include <bcmolt_model_types.h>
#include <bcmolt_utils.h>
#include <bcm_dev_log.h>



/**
 * \brief Start the optical monitoring task
 *
 * This function starts the user level optical monitoring task and creates the
 * optical monitoring module.  It should only be called once at start up.
 *
 * \return
 * None
 */
extern
void bcmolt_epon_omon_appl_init (void);


/**
 * \brief Install CLI commands
 *
 * This function creates and optical monitoring command directoy "omon" and
 * installs optical monitoring CLI commands to this directory.
 *
 * \param top_dir Parent of "omon" directory
 */

void bcmolt_user_appl_epon_omon_cli_init(bcmcli_entry *top_dir);


bcmos_errno bcmolt_user_appl_omon_handle_ind(bcmolt_devid device_id, uint8_t instance, bcmolt_auto *ind);


#endif /* End of file omon.h */
