/*
<:copyright-BRCM:2016:DUAL/GPL:standard

   Broadcom Proprietary and Confidential.(c) 2016 Broadcom
   All Rights Reserved

Unless you and Broadcom execute a separate written software license
agreement governing use of this software, this software is licensed
to you under the terms of the GNU General Public License version 2
(the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
with the following added to such license:

   As a special exception, the copyright holders of this software give
   you permission to link this software with independent modules, and
   to copy and distribute the resulting executable under terms of your
   choice, provided that you also meet, for each linked independent
   module, the terms and conditions of the license of that module.
   An independent module is a module which is not derived from this
   software.  The special exception does not apply to any modifications
   of the software.

Not withstanding the above, under no circumstances may you combine
this software in any way with any other Broadcom software provided
under a license other than the GPL, without Broadcom's express prior
written consent.

:>
 */

#include <bcmos_system.h>
#include <bcmolt_embedded_cli.h>

static int _cli_help(void)
{
    fprintf(stderr, "embedded_console [-d device_index]");
    return -1;
}

int main(int argc, char *argv[])
{
    bcmcli_session_parm mon_session_parm;
    bcmcli_session *session;
    int device = 0;
    int i;

    /* argc must be odd because all options except for argv[0] go in pairs */
    if (!(argc % 2))
    {
        return _cli_help();
    }

    memset(&mon_session_parm, 0, sizeof(mon_session_parm));
    mon_session_parm.access_right = BCMCLI_ACCESS_ADMIN;
    for(i=1; i<argc; i++)
    {
        if (!strcmp(argv[i], "-d"))
        {
            char *pend;
            ++i;
            device = strtoul(argv[i], &pend, 0);
            if (pend && *pend)
                return _cli_help();
        }
    }

    if (bcmcli_session_open(&mon_session_parm, &session))
    {
        printf("Can't open CLI session\n");
        return -EINVAL;
    }

    /* Process user input until EOF or ! command */
    bcm_embedded_cli_enter(session, device);

    bcmcli_session_close(session);

    return 0;
}

