/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
#ifndef TEST_SW_UTIL_LOOPBACK

#include <bal_common.h>
#include <bcm_dev_log.h>
#include <bal_msg.h>
#include "bal_switch_util.h"
#include "bal_switch_acc_term.h"
#include "bal_esw_acc_term.h"

#include <bcm/types.h>
#include <bcm/port.h>

/**
 * @file bal_esw_acc_term.c
 * @brief BAL Switch util functions that handle access terminal requests on Enterprise SWitch 
 * @addtogroup sw_util
 *
 */

/*@{*/


/**
 * @brief Connect access terminal with ESW as part of the components
 *
 * This routine is called by sw_util_access_terminal_connect in the BAL core
 * to execute ESW specific API for access_terminal_connect request
 * 
 * @param p_net_map    Pointer to the net ports mapping from logical numbrer to physical number
 * @param p_pon_map    Pointer to the pon ports mapping from logical numbrer to physical number
 * @return bcmos_errno
 */
bcmos_errno sw_util_esw_acc_term_connect(bal_swapp_port *p_net_map, bal_swapp_port *p_pon_map )
{
     bcmos_errno ret = BCM_ERR_OK;
     int      rc = 0;
     bal_swapp_port *port;
     bcm_pbmp_t pon_pbmp, net_pbmp;   
     
     BCM_LOG(INFO, log_id_sw_util, " KT2 - Got a access terminal CONNECT\n");

     BCM_PBMP_CLEAR(pon_pbmp);
     BCM_PBMP_CLEAR(net_pbmp);
 
     /* setup the device ID  - This is very hardware specific */
     port = p_net_map;
     /* -1 indicate the end of table */
     while(port->pbm_id != -1)
     {        
         /* add port to the net list */
         BCM_PBMP_PORT_ADD(net_pbmp, port->pbm_id);
         port++;         
     }    
 
     port = p_pon_map;
     while(port->pbm_id != -1)
     {        
         /* add port to the pon list */
         BCM_PBMP_PORT_ADD(pon_pbmp, port->pbm_id);
         port++;         
     } 
     
    /* set up the valid egress ports for pon facing ports */
     port = p_pon_map;
     while(port->pbm_id != -1)
     {     
         rc = bcm_port_egress_set(port->device_id, port->pbm_id, 0, /* modid */ net_pbmp);
         if (rc)
         {
             BCM_LOG(ERROR, log_id_sw_util, " ESW - Add port %d to pon interface failed\n", port->pbm_id );
         }
         port++;
     }   
    
     /* set up the valid egress ports for net facing ports */
     port = p_net_map;
     while(port->pbm_id != -1)
     {     
         rc = bcm_port_egress_set(port->device_id, port->pbm_id, 0, /* modid */ pon_pbmp);
         if (rc)
         {
             BCM_LOG(ERROR, log_id_sw_util,
                 " ESW - Add port %d to net interface failed\n", port->pbm_id );
         }
         port++;
     }
             
     /* translate ING error code to BAL error code */ 
     if (rc)
     {
         ret = BCM_ERR_INTERNAL;
     }
     else
     {
         ret = BCM_ERR_OK;
     }
     return ret;
}

/*@}*/
#endif /* #ifndef TEST_SW_UTIL_LOOPBACK */
