/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
 /**
 * @file bal_dpp_vswitch.h
 * @brief BAL Switch util helper functions prototype
 * @addtogroup sw_util
 */
#ifndef _BAL_DPP_VSWITCH_H_
#define _BAL_DPP_VSWITCH_H_

#include "bal_switch_flow.h"

/* DPP multicast group offsets - use vsi as base */
/* The mc group should not overlap, so the following setting limit system to 0x1000 vsi */ 
#define  BAL_DPP_US_FLOOD_OFFSET  0x0
#define  BAL_DPP_DS_FLOOD_OFFSET  0x1000
#define  BAL_DPP_MC_OFFSET        0x2000

#define  MAX_SVC_PER_VSI          8

/*@{*/
#ifndef TEST_SW_UTIL_LOOPBACK

typedef struct bal_sw_lif_port bal_sw_lif_port;
struct bal_sw_lif_port
{
    uint32_t port;
    uint32_t gport;
    int32_t  use_count;
};

typedef struct bal_sw_lif_pkt_tag bal_sw_lif_pkt_tag;
struct bal_sw_lif_pkt_tag
{
    uint32_t type;
    uint32_t o_vid;
    uint32_t i_vid;
    uint32_t num_port;
    bal_sw_lif_port port[MAX_NET_PORT];
};

typedef struct bal_sw_vsi_service bal_sw_vsi_service;
struct bal_sw_vsi_service
{
    uint32_t num_tag;
    bal_sw_lif_pkt_tag pkt_tag[MAX_SVC_PER_VSI];  
    uint32_t vswitch;
    uint32_t us_flood_grp_id;
    uint32_t ds_flood_grp_id;
    int32_t  use_count;    
    TAILQ_ENTRY(bal_sw_vsi_service) next_service;
};

extern bcmos_errno bal_sw_util_dpp_vsi_service_port_add(int unit, bal_sw_vsi_service *p_vsi_svc, uint32_t svc_tag_indx, uint32_t port, int32_t *p_gport);
extern bcmos_errno bal_sw_util_dpp_vsi_service_port_rem(int unit, bal_sw_vsi_service *p_vsi_svc, uint32_t svc_tag_indx, uint32_t port);
extern bcmos_errno bal_sw_util_dpp_vsi_service_tag_add(int unit, bal_sw_vsi_service *p_vsi_svc, bcmbal_flow_cfg *p_flow, uint32_t *p_svc_tag_indx);
extern bcmos_errno bal_sw_util_dpp_vsi_service_tag_rem(int unit, bal_sw_vsi_service *p_vsi_svc, uint32_t svc_tag_indx);
extern bal_sw_vsi_service *bal_sw_util_dpp_vsi_service_create(int unit, bcmbal_flow_cfg *p_flow, uint32_t *p_svc_tag_indx);
extern bcmos_errno bal_sw_util_dpp_vsi_service_destroy(int unit, bal_sw_vsi_service *p_vsi_svc);
extern bcmos_errno bal_sw_util_vsi_list_init(void);

#endif /* TEST_SW_UTIL_LOOPBACK */
/*@}*/
#endif
