/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *
 *  :>
 *
 *****************************************************************************/

#ifndef TEST_SW_UTIL_LOOPBACK

#include <bal_common.h>
#include <bal_core.h>
#include <bcm_dev_log.h>
#include <bal_msg.h>
#include "bal_switch_acc_term.h"
#include "bal_switch_util.h"
#include "bal_dpp_interface.h"

#include <bcm/types.h>
#include <bcm/port.h>

/**
 * @file bal_dpp_interface.c
 * @brief BAL Switch util functions that handle interface requests on DUNE PACKET PROCESSOR
 * @addtogroup sw_util
 *
 */

/*@{*/


/**
 * @brief Set up pon interface with DPP
 *
 * This routine is called by sw_util_interface_set in the BAL core
 * to execute DPP specific API for pon interface request
 *
 * @param p_interface_inst   Pointer to interface instance
 * @param opt_type           UP/DOWN/RESTART the interface
 * @return bcmos_errno
 */
bcmos_errno bal_sw_util_dpp_interface_set(acc_term_interface *p_interface_inst, bal_util_oper_if opt_type )
{
     bcmos_errno ret = BCM_ERR_OK;
     int      rc = 0;
     bcmbal_interface_key intf_key = p_interface_inst->api_req_int_obj_info.key;
     int unit, port;

     BCM_LOG(INFO, log_id_sw_util, " DPP - Got a interface SET: intf_type: %s, intf_id: %d, opt_type: %s\n",
             (intf_key.intf_type == BCMBAL_INTF_TYPE_PON ? "PON":"NNI"),
             intf_key.intf_id,
             (opt_type == BAL_UTIL_OPER_IF_DOWN ? "DOWN":"UP"));

     /* based on interface type get the device number and physical port number from associated table */
     switch(intf_key.intf_type)
     {
         case BCMBAL_INTF_TYPE_PON:
             unit = bal_bcm_pon_inf_dev_get(intf_key.intf_id);
             port = bal_bcm_pon_inf_pbm_get(intf_key.intf_id);
         break;
         case BCMBAL_INTF_TYPE_NNI:
             unit = bal_bcm_net_inf_dev_get(intf_key.intf_id);
             port = bal_bcm_net_inf_pbm_get(intf_key.intf_id);
         break;
         default:
             BCM_LOG(ERROR, log_id_sw_util, "Error, Unrecognized interface type %d\n", intf_key.intf_type);
             return BCM_ERR_INTERNAL;
         break;
     }

     switch (opt_type)
     {
         case BAL_UTIL_OPER_IF_DOWN:
             rc = bcm_port_enable_set(unit, port, 0);
         break;
         case BAL_UTIL_OPER_IF_UP:
         default:
             /* disable */
             rc = bcm_port_enable_set(unit, port, 0);
             /* sleep 300 ms */
             usleep(300000);
             /* enable */
             rc = bcm_port_enable_set(unit, port, 1);
             /* Enable auto-negotiation if necessary */
             if (intf_key.intf_type == BCMBAL_INTF_TYPE_NNI &&
                 bcmbal_is_nni_autoneg_on(intf_key.intf_id))
             {
                 /* sleep 400 ms */
                 usleep(400000);
                 rc = rc ? rc : bcm_port_autoneg_set(unit, port, 1);
                 BCM_LOG(INFO, log_id_sw_util, "Enabled autoneg on NNI unit:port %d:%d. rc=%d\n", unit, port, rc);
             }
         break;
     }
     if (rc)
     {
         BCM_LOG(ERROR, log_id_sw_util, "Error, bcm_port_enable_set for pon failed %d\n", rc);
         ret = BCM_ERR_INTERNAL;
     }
     return ret;
}

/*@}*/
#endif /* #ifndef TEST_SW_UTIL_LOOPBACK */
