/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
 /**
 * @file bal_dpp_group.h
 * @brief BAL Switch util helper functions prototype
 * @addtogroup sw_util
 */
#ifndef _BAL_DPP_GROUP_H_
#define _BAL_DPP_GROUP_H_

#include "bal_dpp_vswitch.h"
#include "bal_switch_util.h"

/*@{*/
#ifndef TEST_SW_UTIL_LOOPBACK

typedef struct bal_sw_group_port bal_sw_group_port;
struct bal_sw_group_port
{
    uint32_t port;        /* group member physical port number */
    uint32_t gport;       /* group member gport id, i.e resource reference in the switch */
    uint32_t svc_port;    /* group member GEM id, in the PON world */
};


typedef struct bal_sw_group_list bal_sw_group_list;
struct bal_sw_group_list
{
    uint32_t device;                /* switch device id where the group applied */
    uint32_t bal_grp_id;            /* id reference in BAL */
    uint32_t num_port;              /* number of the member */
    bal_sw_group_port port[MAX_PON_PORT];  /* member info structure */
    uint32_t l2_grp_id;             /* multicast id in L2 table */
    uint32_t use_count;             /* number of flows that reference this group */
    bal_sw_vsi_service *p_vsi;      /* vswitch service used by this GROUP */
    TAILQ_ENTRY(bal_sw_group_list) next_grp;
};


extern bcmos_errno bal_sw_util_dpp_group_list_init(void);
extern bcmos_errno bal_sw_util_dpp_group_list_finish(void);
extern bal_sw_group_list *bal_sw_util_dpp_group_list_get_by_id(uint32_t grp_id);
extern bal_sw_group_list *bal_sw_util_dpp_group_create(int unit, bcmbal_group_cfg *p_grp);
extern bcmos_errno bal_sw_util_dpp_group_destroy(int unit, bcmbal_group_cfg *p_grp);
extern bcmos_errno bal_sw_util_dpp_group_set(int unit, bcmbal_group_cfg *p_grp);
extern bcmos_errno bal_sw_util_dpp_group_rem(int unit, bcmbal_group_cfg *p_grp);
extern bcmos_errno bal_sw_util_dpp_group_add(int unit, bcmbal_group_cfg *p_grp);

#endif /* TEST_SW_UTIL_LOOPBACK */
/*@}*/
#endif
