/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_dpp_acc_term.h
 *
 * @brief bal switch util access terminal service function header file for DUNE PACKET PROCESSOR
 *
 * @addtogroup sw_util
 */
 
#ifndef  _BAL_DPP_ACC_TERM_H_
#define  _BAL_DPP_ACC_TERM_H_

/*@{*/
#include "bcmos_errno.h"
#include "bal_switch_util.h"
#include "bal_switch_acc_term.h"

extern bcmos_errno sw_util_dpp_acc_term_connect(bal_swapp_port *p_net_map, bal_swapp_port *p_pon_map);

#ifndef TEST_SW_UTIL_LOOPBACK
#include <bcm/rx.h>   /* for dpp rpc rx register callback */
extern bcmos_errno sw_util_dpp_rx_cb_register(uint32_t unit, dpp_rx_cb_f cb_f);

bcmos_errno sw_util_dpp_pkt_send(int dst_port_id,
                                 int reason,
                                 unsigned char *payload,
                                 int payload_len,
                                 trap_target target_device,
                                 int target_tunnel_id);
#endif /* TEST_SW_UTIL_LOOPBACK */
/*@}*/
 
#endif
