/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_switch_util.h
 *
 * @brief Switch App interfaces header file
 *
 * This file expose the APIs to the core to configure the switchs
 * with regarding to the operation of access terminal and flow.
 *
 * @defgroup sw_util Switch Util
 * @ingroup core
 */

#ifndef  _BAL_SWITCH_UTIL_H_
#define  _BAL_SWITCH_UTIL_H_

/*@{*/ 

#include <acc_term_fsm.h>
#include <flow_fsm.h>
#include <group_fsm.h>
#include <tm_sched_fsm.h>
#include <tm_queue_fsm.h>


#include <bcmcli.h>
#include <bal_utils_msg.h>

#define BCM_DEVICE_KT2       0xb450
#define BCM_DEVICE_ARAD_PLUS 0x8660
#define BCM_DEVICE_ARAD      0x8650
#define BCM_DEVICE_QAX       0x8470

/* Function Prototypes for external */
bcmos_errno sw_util_access_terminal_set(acc_term_inst *p_acc_term, bal_util_oper_acc_term opt_type);
bcmos_errno sw_util_flow_info_validate(void *p_msg);
bcmos_errno sw_util_flow_set(flow_inst *p_flow, bal_util_oper_flow opt_type);
bcmos_errno sw_util_flow_finish(void);
bcmos_errno sw_util_interface_set(acc_term_interface *p_interface_inst, bal_util_oper_if opt_type);
bcmos_errno sw_util_group_info_validate(void *p_msg);
bcmos_errno sw_util_group_set(group_inst *p_group_inst, bal_util_oper_group opt_type);
bcmos_errno sw_util_group_finish(void);
bcmos_errno sw_util_init(void);
bcmos_errno sw_util_cli_init(bcmcli_entry *top_dir);
bcmos_errno sw_util_finish(void);


bcmos_errno sw_util_tm_sched_validate(void *p_msg);
bcmos_errno sw_util_tm_sched_set(tm_sched_inst *p_tm_sched_inst);
bcmos_errno sw_util_tm_sched_clear(tm_sched_inst *p_tm_sched_inst);   

bcmos_errno sw_util_tm_queue_validate(void *p_msg);
bcmos_errno sw_util_tm_queue_set(tm_queue_inst *p_tm_queue_inst);
bcmos_errno sw_util_tm_queue_clear(tm_queue_inst *p_tm_queue_inst);


/* switch util log id */
extern dev_log_id log_id_sw_util;

/*@}*/

#endif /* _BAL_SWITCH_UTIL_H_ */

