/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_switch_util.c
 *
 * @brief Switch App interfaces definition used by Bal Core
 *
 * This file provides CmdSet message handler functions with relevant  
 * bal object operations of access terminal and flow.
 * 
 * @addtogroup sw_util
 *
 */

/*@{*/

#include <bcm_dev_log.h>
#include <bal_common.h>
#include <bal_msg.h>
#include "bal_switch_util.h"

/*
 * Logging device id
 */
dev_log_id log_id_sw_util;

/**
* @brief sw_util_init  routine to initialize the switch util before any use 
* @return bcmos_errno 
*/
bcmos_errno sw_util_init(void)
{
    bcmos_errno rc = BCM_ERR_OK;

    log_id_sw_util = bcm_dev_log_id_register("SW_UTIL", DEV_LOG_LEVEL_INFO, DEV_LOG_ID_TYPE_BOTH);
    BUG_ON(log_id_sw_util== DEV_LOG_INVALID_ID);

    return rc; 
}

/**
* @brief sw_util_finish  routine to release any resource used by the switch util before exit 
* @return bcmos_errno 
*/
bcmos_errno sw_util_finish(void)
{
    bcmos_errno rc = BCM_ERR_OK;

    /* release any internal allocated DB - best effort as we are exiting anyway */
	/* flow */
	sw_util_flow_finish();
	 
	/* group */
	sw_util_group_finish(); 

    return rc; 
}

/*@}*/

