/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_switch_tm_queue.c
 * @brief BAL Switch util functions that handle tm requests
 * @addtogroup sw_util
 */
 
 /*@{*/
#include <bal_common.h>
#include <bcm_dev_log.h>
#include <bal_msg.h>
#include "bcmos_errno.h"
#include "bal_switch_util.h"  
#include "tm_sched_fsm.h" 


/*  sw_util_tm_queue_validate() is called by the Core to validate the attributes of the tm_queue object
*  p_msg  a pointer to the object bcmbal_tm_queue_cfg
*/
bcmos_errno sw_util_tm_queue_validate(void *p_msg)
{
    return BCM_ERR_OK;
}

/*  sw_util_tm_queue_set() is called by the Core to create an instance of TM Queue in the switch
*  p_tm_queue_inst  a pointer to the data structure tm_queue_inst that used in the Core to manage
*                   the received tm_queue configuration request from the BAL client
*
*  Required attributes
*  Key              - key to unique identify the TM queue and the parent scheduler
*  Max size         - queue size
*  Priority         - SP priority, if parent scheduler is of type SP
*  Weight           - WFQ weight, if parent scheduler is of type WFQ
*
*  Optional
*  Rate             - for rate limit, if not specified default to FULL rate
*/
bcmos_errno sw_util_tm_queue_set(tm_queue_inst *p_tm_queue_inst)
{
    return BCM_ERR_OK;
}

/*  sw_util_tm_queue_clear() is called by the Core to remove an instance of TM queue in the switch
*  p_tm_queue_inst  a pointer to the data structure tm_queue_inst that used in the Core to manage
*                   the received tm_queue configuration request from the BAL client
*
*  Required attributes
*  Key             - key to unique identify the TM queue
*
*  Note:  CLEAR request should be rejected if any flow is still referencing it
*/
bcmos_errno sw_util_tm_queue_clear(tm_queue_inst *p_tm_queue_inst)
{
    return BCM_ERR_OK;
}

/*@}*/

 
