/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
#include <bal_common.h>
#include <bcm_dev_log.h>
#include <bal_msg.h>
#include "bal_switch_util.h"
#include "bal_switch_acc_term.h"
#include "bal_switch_interface.h"
#include "dpp/bal_dpp_interface.h"

#ifndef TEST_SW_UTIL_LOOPBACK
#include <bcm/types.h>
#include <bcm/port.h>

/**
 * @file bal_dpp_interface.c
 * @brief BAL Switch util functions that handle interface requests on DUNE PACKET PROCESSOR 
 * @addtogroup sw_util
 *
 */

/*@{*/


/**
 * @brief Set up pon interface with DPP 
 *
 * This routine is called by sw_util_interface_set in the BAL core
 * to execute DPP specific API for pon interface request
 * 
 * @param p_interface_inst   Pointer to interface instance
 * @param opt_type           UP/DOWN/RESTART the interface 
 * @return bcmos_errno
 */
bcmos_errno bal_sw_util_interface_set(acc_term_interface *p_interface_inst, bal_util_oper_if opt_type )
{
     bcmos_errno ret = BCM_ERR_OK;    
     bcmbal_interface_key intf_key = p_interface_inst->api_req_int_obj_info.key;
     int unit, intf_id;   
     uint32_t dev_type;
     
     BCM_LOG(INFO, log_id_sw_util,
            " Got a interface request - interface_id=%d \n", intf_key.intf_id);            
   
     unit = bal_bcm_pon_inf_dev_get(intf_key.intf_id);
     intf_id = bal_bcm_pon_inf_pbm_get(intf_key.intf_id);
     dev_type = bal_bcm_dev_type_get(unit);    

     /* call the interface set function based on device type */
     if (dev_type == BCM_DEVICE_KT2)
     {
         ret = BCM_ERR_OK;
     }
     else if (dev_type == BCM_DEVICE_ARAD || dev_type == BCM_DEVICE_ARAD_PLUS || dev_type == BCM_DEVICE_QAX)
     {
         ret = bal_sw_util_dpp_interface_set(p_interface_inst, opt_type);
     }
     else
     {
         BCM_LOG(ERROR, log_id_sw_util, " Unknown device type (0x%x)found on interface set\n", dev_type );
         ret = BCM_ERR_INTERNAL;
     }

     BCM_LOG(DEBUG, log_id_sw_util, " Return interface set request with %d on %s 0x%x\n", ret, 
             (intf_key.intf_type == BCMBAL_INTF_TYPE_PON ? "pon" : "nni"), intf_id);

     return ret;
}

/*@}*/
#endif /* #ifndef TEST_SW_UTIL_LOOPBACK */

/**
 * @brief SWITCH module: interface SET handler
 *
 * This routine is called by interface_fsm in the BAL core upon
 * SET request for interface object.
 *
 * @param p_interface_inst   Pointer to interface instance
 * @param opt_type           UP/DOWN/RESTART the interface 
 * @return bcmos_errno
 */
bcmos_errno sw_util_interface_set(acc_term_interface *p_interface_inst, bal_util_oper_if opt_type)
{
    bcmos_errno ret = BCM_ERR_OK;  

#ifndef TEST_SW_UTIL_LOOPBACK
     ret = bal_sw_util_interface_set(p_interface_inst, opt_type);
#else
     BCM_LOG(INFO, log_id_sw_util, "dummy SUCCESS\n");
#endif

     return ret;
}
