/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_switch_flow.h
 *
 * @brief Switch flow interfaces header file
 *
 * This file expose the APIs to the core to configure the switches
 * with regarding to the operation of a flow.
 *
 * @defgroup sw_util Switch Util
 * @ingroup core
 */

#ifndef  _BAL_SWITCH_FLOW_H_
#define  _BAL_SWITCH_FLOW_H_

#include <bal_utils_msg.h>
#include "bcmos_errno.h"
#include "flow_fsm.h"

/*@{*/ 

/* Data structure to keep a link list of flow that has been programmed in the switch */
/* reserve 16 pairs of uni-direction ports */
#define MAX_PON_PORT  32  
#define MAX_NET_PORT  32 
#define MAX_FIELD_EID 64 

#define BAL_SW_FLOW_TYPE_NONE            0
#define BAL_SW_FLOW_TYPE_DOWNSTREAM     (1 << BCMBAL_FLOW_TYPE_DOWNSTREAM)
#define BAL_SW_FLOW_TYPE_UPSTREAM       (1 << BCMBAL_FLOW_TYPE_UPSTREAM)
#define BAL_SW_FLOW_TYPE_MULTICAST      (1 << BCMBAL_FLOW_TYPE_MULTICAST)
 
typedef struct bal_sw_flow bal_sw_flow;
struct bal_sw_flow
{
    uint32_t id;          /* flow id */
    uint32_t type;        /* downstream or upstream */
    uint32_t device;      /* device id, aka unit of the device */
    uint32_t trap_code;   /* id for trap reason */
    uint32_t trap_port;   /* trap gport */
    uint32_t num_eid;     
    uint32_t field_entry_id[MAX_FIELD_EID];  /* field entry for ACL rules */
    void     *p_vsi_svc;  /* vswitch entry in the vsi list */
    uint32_t vsi_svc_indx; /* index to the service within the vswitch this flow is using */
    uint32_t svc_port;    /* LLId or GEMID */
    uint32_t num_pon;
    uint32_t pon_port[MAX_PON_PORT]; /* pon gport attached to vswitch */
    uint32_t num_net;
    uint32_t net_port[MAX_NET_PORT]; /* nni gport attached to vswitch */
    bcmbal_cookie flow_cookie;
    void     *p_service_cfg;
    uint32_t group_id;
    uint32_t valid;    
    TAILQ_ENTRY(bal_sw_flow) flow_next;
};

extern bcmos_errno bal_sw_util_flow_list_insert(bal_sw_flow entry);
extern bcmos_errno bal_sw_util_flow_list_remove(bal_sw_flow *p_entry);
extern bal_sw_flow *bal_sw_util_flow_list_get_by_id(uint32_t id);
extern bal_sw_flow *bal_sw_util_flow_list_get_by_trap_code(uint32_t trap_code);
extern bcmos_bool  bal_sw_util_flow_ds_acl_cls_chk(bcmbal_flow_cfg *p_flow);
extern bcmos_bool  bal_sw_util_flow_us_acl_cls_chk(bcmbal_flow_cfg *p_flow);

/*@}*/

#endif /* _BAL_SWITCH_FLOW_H_ */
