/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_switch_cli.c
 * @brief Sample CLI for switch integration module
 *
 */

/*@{*/

#include <bal_common.h>
#include <bcm_dev_log.h>
#include <bal_msg.h>
#include "bal_switch_util.h"
#include <bcmcli.h>

/* Below local functions are used for real logic only */
#ifndef TEST_SW_UTIL_LOOPBACK

#include "bal_switch_acc_term.h"
#include <bcm/types.h>
#include <bcm/port.h>
#include <appl/diag/shell.h>

static bcmcli_entry *switch_cli_dir;

/* Function declarations */

/*
 * CLI backend helper functions
 */

static bcmos_errno bal_switch_device(bcmcli_session *sess, const bcmcli_cmd_parm parm[], uint16_t nParms)
{
    bal_bcm_dft_dev_set(parm[0].value.number);
    return BCM_ERR_OK;
}

static bcmos_errno bal_switch_l2_age_time(bcmcli_session *sess, const bcmcli_cmd_parm parm[], uint16_t nParms)
{
    bal_bcm_l2_age_time_set(parm[0].value.number);
    return BCM_ERR_OK;
}

static bcmos_errno bal_switch_rpc_mode(bcmcli_session *sess, const bcmcli_cmd_parm parm[], uint16_t nParms)
{
    bal_bcm_use_rpc_set(parm[0].value.number);
    return BCM_ERR_OK;
}

static bcmos_errno bal_switch_intf_map(bcmcli_session *sess, const bcmcli_cmd_parm parm[], uint16_t nParms)
{
    bal_bcm_intf_maptable_set(parm[0].value.number);
    return BCM_ERR_OK;
}

static bcmos_errno bal_switch_trap_udp_port(bcmcli_session *sess, const bcmcli_cmd_parm parm[], uint16_t nParms)
{
    bal_bcm_trap_rcv_port_set(parm[0].value.number);
    return BCM_ERR_OK;
}

static bcmos_errno bal_switch_shell(bcmcli_session *sess, const bcmcli_cmd_parm parm[], uint16_t nParms)
{
    sh_process(-1, "BCM", TRUE);
    return BCM_ERR_OK;
}
/* allow CLI to send a testing packet out of NNI interface, input is interface_number */
static bcmos_errno bal_switch_pkt_out(bcmcli_session *sess, const bcmcli_cmd_parm parm[], uint16_t nParms)
{
    int out_port = parm[0].value.number;
    unsigned char pkt_tagged_data[64] = {
                     0x00, 0x01, 0x02, 0x03, 0x04, 0x05, /* DA */
                     0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, /* SA */
                     0x81, 0x00, 0x00, 0x01, /* TPID + VID */
                     0x08, 0x00, 0x45, 0x10, 0x00, 0x46, 0x00, 0x00, 0x00, 0x00, 0x32, 0x06,
                     0x82, 0xab, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
                     0x03, 0x04, 0x00, 0x04, 0x01, 0x00, 0x56, 0xf1, 0x39, 0x00, 0x00,
                     0x11, 0x22, 0x33, 0x44, 0x55, 0x66};

    sw_util_pkt_send(out_port, REASON_SEND_TO_NNI, pkt_tagged_data, 64, 0);
    return BCM_ERR_OK;
}

/* allow CLI to send a testing packet out of PON interface, inputs are interface_number and tunnel_id */
static bcmos_errno bal_switch_pon_out(bcmcli_session *sess, const bcmcli_cmd_parm parm[], uint16_t nParms)
{
    int out_port = parm[0].value.number;
    int tunnel_id = parm[1].value.number;
    unsigned char pkt_tagged_data[64] = {
                     0x00, 0x01, 0x02, 0x03, 0x04, 0x05, /* DA */
                     0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, /* SA */
                     0x81, 0x00, 0x00, 0x01, /* TPID + VID */
                     0x08, 0x00, 0x45, 0x10, 0x00, 0x46, 0x00, 0x00, 0x00, 0x00, 0x32, 0x06,
                     0x82, 0xab, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
                     0x03, 0x04, 0x00, 0x04, 0x01, 0x00, 0x56, 0xf1, 0x39, 0x00, 0x00,
                     0x11, 0x22, 0x33, 0x44, 0x55, 0x66};

    sw_util_pkt_send(out_port, REASON_SEND_TO_PON, pkt_tagged_data, 64, tunnel_id);
    return BCM_ERR_OK;
}

#endif

/* Create CLI directory */
bcmos_errno sw_util_cli_init(bcmcli_entry *top_dir)
{
#ifndef TEST_SW_UTIL_LOOPBACK
    if (switch_cli_dir)
    {
        return BCM_ERR_ALREADY;
    }
    switch_cli_dir = bcmcli_dir_add(top_dir, "switch", "Switch CLI commands", BCMCLI_ACCESS_GUEST, NULL);
    BCMOS_CHECK_RETURN_ERROR(!switch_cli_dir, BCM_ERR_INTERNAL);

    BCMCLI_MAKE_CMD(switch_cli_dir, "device", "Set default device", bal_switch_device,
        BCMCLI_MAKE_PARM("index", "Device index", BCMCLI_PARM_NUMBER, BCMCLI_PARM_FLAG_NONE));
        
    BCMCLI_MAKE_CMD(switch_cli_dir, "l2_agetime", "Set L2 table aging time", bal_switch_l2_age_time,
        BCMCLI_MAKE_PARM("time", "L2 Aging Time", BCMCLI_PARM_NUMBER, BCMCLI_PARM_FLAG_NONE));

    BCMCLI_MAKE_CMD(switch_cli_dir, "rpc_mode", "Set RPC mode", bal_switch_rpc_mode,
        BCMCLI_MAKE_PARM_ENUM("enable", "Enable RPC mode", bcmcli_enum_bool_table, BCMCLI_PARM_FLAG_NONE));

    BCMCLI_MAKE_CMD(switch_cli_dir, "intf_map_table", "Select interface mapping table", bal_switch_intf_map,
        BCMCLI_MAKE_PARM("table", "Interface Mapping Table Number", BCMCLI_PARM_NUMBER, BCMCLI_PARM_FLAG_NONE));
    
    BCMCLI_MAKE_CMD(switch_cli_dir, "trap_udp_port", "Set trap packet receiving udp port", bal_switch_trap_udp_port,
        BCMCLI_MAKE_PARM("port", "Receiving Port number", BCMCLI_PARM_NUMBER, BCMCLI_PARM_FLAG_NONE));

    BCMCLI_MAKE_CMD(switch_cli_dir, "nni_packet_out", "Send example packet vid=1 to switch nni port", bal_switch_pkt_out,
        BCMCLI_MAKE_PARM("port", "Sending Port number", BCMCLI_PARM_NUMBER, BCMCLI_PARM_FLAG_NONE));

    BCMCLI_MAKE_CMD(switch_cli_dir, "pon_packet_out", "Send example packet vid=1 to switch pon port", bal_switch_pon_out,
        BCMCLI_MAKE_PARM("port", "Sending Port number", BCMCLI_PARM_NUMBER, BCMCLI_PARM_FLAG_NONE),
        BCMCLI_MAKE_PARM("tunnel", "Sending Tunnel Id", BCMCLI_PARM_NUMBER, BCMCLI_PARM_FLAG_NONE));

    BCMCLI_MAKE_CMD_NOPARM(switch_cli_dir, "shell", "Switch SDK shell", bal_switch_shell);
#endif
    return BCM_ERR_OK;
}

/*@}*/
