/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *
 *  :>
 *
 *****************************************************************************/

/**
 * @file bal_switch_acc_term.h
 *
 * @brief bal switch util access terminal service function header file
 *
 * @addtogroup sw_util
 */

#ifndef  _BAL_BCM_ACC_TERM_H_
#define  _BAL_BCM_ACC_TERM_H_

/*@{*/
#include "bcmos_errno.h"

#define BAL_BCM_MAX_INTF    32

/* structure of each entry in the port mapping table */
typedef struct bal_swapp_port_t
{
    uint32_t  pbm_id;
    int       device_id;
} bal_swapp_port;

/* Index of different tables that map core interface number to physical ports on the device
 * for example, GPON mapping table will be table[0], EPON mapping table will be table[2]
 */
typedef enum
{
    BAL_SWAPP_PORT_MAP_GPON,
    BAL_SWAPP_PORT_MAP_GPON_V3,
    BAL_SWAPP_PORT_MAP_EXP,
    BAL_SWAPP_PORT_MAP_EXP2,
    BAL_SWAPP_PORT_MAP_SVK4,
    BAL_SWAPP_PORT_MAP_EPON_TDMA,
    BAL_SWAPP_PORT_MAP_EPON_1G,
    BAL_SWAPP_PORT_MAP_EPON_10G,
    BAL_SWAPP_PORT_MAP__NUM_OF,
} bal_swapp_port_map_indx;

/*
 * @brief Packet send structures and defines
 */
enum
{
    REASON_SEND_TO_NNI = 1,
    REASON_SEND_TO_PON
};

typedef struct
{
    int socket;
    struct sockaddr_in addr;
} trap_target;

extern bcmos_errno bal_bcm_acc_term_connect(void);
extern void bal_bcm_dft_dev_set(uint32_t id);
extern uint32_t bal_bcm_dft_dev_get(void);
extern void bal_bcm_l2_age_time_set(uint32_t time);
extern uint32_t bal_bcm_l2_age_time_get(void);
extern uint32_t bal_bcm_dev_type_get(uint32_t id);
extern void bal_bcm_use_rpc_set(uint32_t use_rpc);
extern int bal_bcm_intf_maptable_set(uint32_t intf_maptable);
extern uint32_t bal_bcm_net_inf_pbm_get(uint32_t net_inf_id);
extern uint32_t bal_bcm_pon_inf_pbm_get(uint32_t pon_inf_id);
extern int bal_bcm_net_inf_dev_get(uint32_t net_inf_id);
extern int bal_bcm_pon_inf_dev_get(uint32_t pon_inf_id);
extern uint32_t bal_bcm_iwf_mode_get(void);
extern bcmos_bool bal_bcm_use_rpc_get(void);
extern uint32_t bal_bcm_trap_rcv_port_get(void);
extern uint32_t bal_bcm_trap_rcv_port_set(uint32_t udp_port);
extern int bal_bcm_pon_inf_idx_get(uint32_t pon_id);
extern int bal_bcm_net_inf_idx_get(uint32_t nni_id);
extern bal_swapp_port_map_indx bal_bcm_intf_maptable_get(void);
extern uint32_t bal_bcm_ds_sched_mode_get(void);
extern uint32_t bal_bcm_ds_sched_mode_set(uint32_t sched_mode);
extern bcmos_errno sw_util_pkt_send(int dst_port_id, int reason, unsigned char *payload, int payload_len, int tunnel_id);
extern bcmos_errno sw_util_pkt_send_init(const char *pkt_send_server_ip, uint16_t pkt_send_server_listen_port);
extern int bal_bcm_net_inf_map_size_get(void);
extern int bal_bcm_pon_inf_map_size_get(void);
/*@}*/

#endif
