/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_oam_util.h
 *
 * @brief OAM util interfaces header file
 *
 * This file expose the APIs to the core to configure ONU via EPON OAM
 *
 * @defgroup oam_util OAM Util
 * @ingroup core
 */
 
#ifndef BAL_OAM_UTIL_H
#define BAL_OAM_UTIL_H

#include <bcmolt_host_api.h>
#include <bcmolt_user_appl_epon_oam.h>

typedef void (*bal_oam_cb)(void *context, bcmolt_devid device_id, bcmolt_epon_ni epon_ni, const bcmos_mac_address *mac_address, bcmos_errno result);

/*****************************************************************************/
/**
 * @brief Start OAM negotiation for a given MAC address.
 *
 * @param device_id   Device ID for which we start OAM negotiation
 * @param epon_ni     EPON NI for which we start OAM negotiation
 * @param mac         MAC address for which we start OAM negotiation
 * @param cb          Callback called upon completion, with success or failure
 *                    code. If omitted, a default callback will be called and
 *                    it will just log the return code
 * @param context     context for the above callback                    
 *
 * @returns BCM_ERR_OK on success, other bcmos_errno codes otherwise
 *
 *****************************************************************************/
bcmos_errno bal_oam_start_oam_negotiation(bcmolt_devid device_id, bcmolt_epon_ni epon_ni, bcmos_mac_address *mac, bal_oam_cb cb, void *context);

/*****************************************************************************/
/**
 * @brief Enable traffic for a given MAC address.
 *
 * @param device_id   Device ID for which we enable/disable traffic
 * @param epon_ni     EPON NI for which we enable/disable traffic 
 * @param mac         MAC address for which we enable/disable traffic 
 * @param is_enabled  Whether we should enable or disable traffic 
 * @param cb          Callback called upon completion, with success or failure
 *                    code. If omitted, a default callback will be called and
 *                    it will just log the return code
 * @param context     context for the above callback                    
 *
 * @returns BCM_ERR_OK on success, other bcmos_errno codes otherwise
 *
 *****************************************************************************/
bcmos_errno bal_oam_configure_traffic(bcmolt_devid device_id, bcmolt_epon_ni epon_ni, bcmos_mac_address *mac, bcmos_bool is_enabled, bal_oam_cb cb, void *context);

/*****************************************************************************/
/**
 * @brief Callback being called whenever an OAM message (proxy rx) arrives and
 *        processed by bcmolt_user_appl_epon_oam_handle_proxy_rx().
 *
 * @param device_id   Device ID for which we got the message
 * @param epon_ni     EPON NI for which we got the message
 * @param mac         MAC address for which we got the message
 * @param id          The type of message                    
 * @param rc          OAM response success/fail code
 *
 *****************************************************************************/
void bal_oam_proxy_rx_cb(bcmolt_devid device_id, bcmolt_epon_ni epon_ni, const bcmos_mac_address *mac, bcmolt_user_appl_epon_oam_rx_id id, bcmos_errno rc);

#endif

