/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file bal_mac_util_loopback.c
 *
 * @brief mac util handling for MAC in loopback mode
 *
 * The loopback mode is handled like a mac protocol, with loopback specific handling 
 *  done as sub-routine calls from the top level handler functions. 
 *
 * @addtogroup mac_util
 */

/*@{*/

#include <bal_mac_util.h>
#include <bal_mac_util_common_itu_pon.h>
#include <bal_worker.h>


/**
 * @brief access terminal set for loopback
 */
bcmos_errno mac_util_access_terminal_set_for_loopback (acc_term_inst *p_acc_term, bal_util_oper_acc_term op_type, bcmolt_devid device_id)
{
    bcmos_errno rc = BCM_ERR_OK;

    bcmos_usleep(1000000);
    mac_util_report_acc_term_event(BCMOLT_DEVICE_AUTO_ID_CONNECTION_COMPLETE);

    return rc;
}


/**
 * @brief set interface for loopback mode
 * 
 * @param p_interface_inst  Pointer to interface instance
 * @param op_type           Operation type on access terminal/interface instance
 * 
 * @return bcmos_errno 
 *
 */
bcmos_errno mac_util_interface_set_for_loopback(acc_term_interface *p_interface_inst, bal_util_oper_if op_type)
{
    bcmos_errno rc = BCM_ERR_OK;
    bcmbal_interface_key intf_key = p_interface_inst->api_req_int_obj_info.key;
    bcmbal_interface_cfg *p_interface_req = &(p_interface_inst->api_req_int_obj_info);

    p_interface_req = &(p_interface_inst->api_req_int_obj_info);

    /* If the user didn't specify a transceiver, then use the default */
    if (BCMOS_FALSE == BCMBAL_CFG_PROP_IS_SET(p_interface_req, interface, transceiver_type))
    {
        BCMBAL_CFG_PROP_SET(p_interface_req, interface, transceiver_type, BCMBAL_MAC_UTIL_TRX_TYPE_DEFAULT_GPON);
    }

    mac_util_report_if_event(intf_key.intf_id, 
            intf_key.intf_type,
            BCM_ERR_OK, BCMOLT_RESULT_SUCCESS, 
            ((BAL_UTIL_OPER_IF_UP == op_type) ? BCMOLT_PON_STATE_ACTIVE_WORKING : BCMOLT_PON_STATE_INACTIVE));


    return rc;
}


/**
 * @brief Set subscriber terminal for loopback mode
 * 
 * @param p_sub_term_inst   A pointer to a subscriber terminal instance
 * @param op_type          Type of operation being performed on the subscriber terminal instance
 * @param is_post_discovery Used for ADD, indicates if this request is after a ONU Discovery
 *
 * @return bcmos_errno 
 */
bcmos_errno mac_util_subscriber_terminal_set_for_loopback(sub_term_inst *p_sub_term_inst, bal_util_oper_sub_term op_type, bcmos_bool is_post_discovery)
{
    bcmos_errno rc = BCM_ERR_OK;
    bcmbal_subscriber_terminal_cfg *p_sub_term_req = &p_sub_term_inst->api_req_sub_term_info;


    mac_util_report_sub_term_event(p_sub_term_req->key.intf_id,
        p_sub_term_req->key.sub_term_id, 
        (bcmolt_serial_number *)NULL,
        (BAL_UTIL_OPER_SUB_TERM_ADD == op_type ? BAL_UTIL_OPER_SUB_TERM_ADD : BAL_UTIL_OPER_SUB_TERM_REMOVE),
        BCM_ERR_OK, BCMOLT_RESULT_SUCCESS,
        (BAL_UTIL_OPER_SUB_TERM_ADD == op_type ? BCMOLT_ACTIVATION_FAIL_REASON_NONE : BCMOLT_RESULT_SUCCESS), BCMBAL_INVALID_TUNNEL_ID);

    return rc;
}


/**
 * @brief set flow for loopback mode
 */
bcmos_errno mac_util_flow_set_for_loopback(bcmbal_flow_cfg *p_flow_req, bal_util_oper_flow op_type, flow_inst *p_flow_core)
{
    bcmos_errno rc = BCM_ERR_OK;

    if (BAL_UTIL_OPER_FLOW_ADD == op_type)
    {
        mac_util_report_flow_add_success(p_flow_req->key, p_flow_req->data.access_int_id);
    }
    else if ((BAL_UTIL_OPER_FLOW_REMOVE == op_type) || (BAL_UTIL_OPER_FLOW_CLEAR == op_type))
    {
        mac_util_report_flow_remove_success(p_flow_req->key, p_flow_req->data.access_int_id, op_type);
    }
    else
    {
        rc = BCM_ERR_INVALID_OP;
    }


    return rc;
}



/*@}*/
